//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (7)
//--------------------------------------------------------------------------------
pub const DSSI_READ_ONLY = @as(u32, 1);
pub const DSSI_NO_ACCESS_CHECK = @as(u32, 2);
pub const DSSI_NO_EDIT_SACL = @as(u32, 4);
pub const DSSI_NO_EDIT_OWNER = @as(u32, 8);
pub const DSSI_IS_ROOT = @as(u32, 16);
pub const DSSI_NO_FILTER = @as(u32, 32);
pub const DSSI_NO_READONLY_MESSAGE = @as(u32, 64);

//--------------------------------------------------------------------------------
// Section: Types (6)
//--------------------------------------------------------------------------------
pub const PFNREADOBJECTSECURITY = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        param0: ?[*:0]const u16,
        param1: u32,
        param2: ?*?*SECURITY_DESCRIPTOR,
        param3: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        param0: ?[*:0]const u16,
        param1: u32,
        param2: ?*?*SECURITY_DESCRIPTOR,
        param3: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const PFNWRITEOBJECTSECURITY = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        param0: ?[*:0]const u16,
        param1: u32,
        param2: ?*SECURITY_DESCRIPTOR,
        param3: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        param0: ?[*:0]const u16,
        param1: u32,
        param2: ?*SECURITY_DESCRIPTOR,
        param3: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const PFNDSCREATEISECINFO = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        param0: ?[*:0]const u16,
        param1: ?[*:0]const u16,
        param2: u32,
        param3: ?*?*ISecurityInformation,
        param4: ?PFNREADOBJECTSECURITY,
        param5: ?PFNWRITEOBJECTSECURITY,
        param6: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        param0: ?[*:0]const u16,
        param1: ?[*:0]const u16,
        param2: u32,
        param3: ?*?*ISecurityInformation,
        param4: ?PFNREADOBJECTSECURITY,
        param5: ?PFNWRITEOBJECTSECURITY,
        param6: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const PFNDSCREATEISECINFOEX = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        param0: ?[*:0]const u16,
        param1: ?[*:0]const u16,
        param2: ?[*:0]const u16,
        param3: ?[*:0]const u16,
        param4: ?[*:0]const u16,
        param5: u32,
        param6: ?*?*ISecurityInformation,
        param7: ?PFNREADOBJECTSECURITY,
        param8: ?PFNWRITEOBJECTSECURITY,
        param9: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        param0: ?[*:0]const u16,
        param1: ?[*:0]const u16,
        param2: ?[*:0]const u16,
        param3: ?[*:0]const u16,
        param4: ?[*:0]const u16,
        param5: u32,
        param6: ?*?*ISecurityInformation,
        param7: ?PFNREADOBJECTSECURITY,
        param8: ?PFNWRITEOBJECTSECURITY,
        param9: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const PFNDSCREATESECPAGE = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        param0: ?[*:0]const u16,
        param1: ?[*:0]const u16,
        param2: u32,
        param3: ?*?HPROPSHEETPAGE,
        param4: ?PFNREADOBJECTSECURITY,
        param5: ?PFNWRITEOBJECTSECURITY,
        param6: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        param0: ?[*:0]const u16,
        param1: ?[*:0]const u16,
        param2: u32,
        param3: ?*?HPROPSHEETPAGE,
        param4: ?PFNREADOBJECTSECURITY,
        param5: ?PFNWRITEOBJECTSECURITY,
        param6: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const PFNDSEDITSECURITY = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        param0: ?HWND,
        param1: ?[*:0]const u16,
        param2: ?[*:0]const u16,
        param3: u32,
        param4: ?[*:0]const u16,
        param5: ?PFNREADOBJECTSECURITY,
        param6: ?PFNWRITEOBJECTSECURITY,
        param7: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        param0: ?HWND,
        param1: ?[*:0]const u16,
        param2: ?[*:0]const u16,
        param3: u32,
        param4: ?[*:0]const u16,
        param5: ?PFNREADOBJECTSECURITY,
        param6: ?PFNWRITEOBJECTSECURITY,
        param7: LPARAM,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

//--------------------------------------------------------------------------------
// Section: Functions (4)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windowsServer2008'
pub extern "dssec" fn DSCreateISecurityInfoObject(
    pwszObjectPath: ?[*:0]const u16,
    pwszObjectClass: ?[*:0]const u16,
    dwFlags: u32,
    ppSI: ?*?*ISecurityInformation,
    pfnReadSD: ?PFNREADOBJECTSECURITY,
    pfnWriteSD: ?PFNWRITEOBJECTSECURITY,
    lpContext: LPARAM,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "dssec" fn DSCreateISecurityInfoObjectEx(
    pwszObjectPath: ?[*:0]const u16,
    pwszObjectClass: ?[*:0]const u16,
    pwszServer: ?[*:0]const u16,
    pwszUserName: ?[*:0]const u16,
    pwszPassword: ?[*:0]const u16,
    dwFlags: u32,
    ppSI: ?*?*ISecurityInformation,
    pfnReadSD: ?PFNREADOBJECTSECURITY,
    pfnWriteSD: ?PFNWRITEOBJECTSECURITY,
    lpContext: LPARAM,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windowsServer2003'
pub extern "dssec" fn DSCreateSecurityPage(
    pwszObjectPath: ?[*:0]const u16,
    pwszObjectClass: ?[*:0]const u16,
    dwFlags: u32,
    phPage: ?*?HPROPSHEETPAGE,
    pfnReadSD: ?PFNREADOBJECTSECURITY,
    pfnWriteSD: ?PFNWRITEOBJECTSECURITY,
    lpContext: LPARAM,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windowsServer2008'
pub extern "dssec" fn DSEditSecurity(
    hwndOwner: ?HWND,
    pwszObjectPath: ?[*:0]const u16,
    pwszObjectClass: ?[*:0]const u16,
    dwFlags: u32,
    pwszCaption: ?[*:0]const u16,
    pfnReadSD: ?PFNREADOBJECTSECURITY,
    pfnWriteSD: ?PFNWRITEOBJECTSECURITY,
    lpContext: LPARAM,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (7)
//--------------------------------------------------------------------------------
const HPROPSHEETPAGE = @import("../ui/controls.zig").HPROPSHEETPAGE;
const HRESULT = @import("../foundation.zig").HRESULT;
const HWND = @import("../foundation.zig").HWND;
const ISecurityInformation = @import("../security/authorization/ui.zig").ISecurityInformation;
const LPARAM = @import("../foundation.zig").LPARAM;
const PWSTR = @import("../foundation.zig").PWSTR;
const SECURITY_DESCRIPTOR = @import("../security.zig").SECURITY_DESCRIPTOR;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "PFNREADOBJECTSECURITY")) {
        _ = PFNREADOBJECTSECURITY;
    }
    if (@hasDecl(@This(), "PFNWRITEOBJECTSECURITY")) {
        _ = PFNWRITEOBJECTSECURITY;
    }
    if (@hasDecl(@This(), "PFNDSCREATEISECINFO")) {
        _ = PFNDSCREATEISECINFO;
    }
    if (@hasDecl(@This(), "PFNDSCREATEISECINFOEX")) {
        _ = PFNDSCREATEISECINFOEX;
    }
    if (@hasDecl(@This(), "PFNDSCREATESECPAGE")) {
        _ = PFNDSCREATESECPAGE;
    }
    if (@hasDecl(@This(), "PFNDSEDITSECURITY")) {
        _ = PFNDSEDITSECURITY;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
