//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (123)
//--------------------------------------------------------------------------------
pub const FILE_DEVICE_SMARTCARD = @as(u32, 49);
pub const GUID_DEVINTERFACE_SMARTCARD_READER = Guid.initString("50dd5230-ba8a-11d1-bf5d-0000f805f530");
pub const SCARD_ATR_LENGTH = @as(u32, 33);
pub const SCARD_PROTOCOL_UNDEFINED = @as(u32, 0);
pub const SCARD_PROTOCOL_T0 = @as(u32, 1);
pub const SCARD_PROTOCOL_T1 = @as(u32, 2);
pub const SCARD_PROTOCOL_RAW = @as(u32, 65536);
pub const SCARD_PROTOCOL_DEFAULT = @as(u32, 2147483648);
pub const SCARD_PROTOCOL_OPTIMAL = @as(u32, 0);
pub const SCARD_POWER_DOWN = @as(u32, 0);
pub const SCARD_COLD_RESET = @as(u32, 1);
pub const SCARD_WARM_RESET = @as(u32, 2);
pub const MAXIMUM_ATTR_STRING_LENGTH = @as(u32, 32);
pub const MAXIMUM_SMARTCARD_READERS = @as(u32, 10);
pub const SCARD_CLASS_VENDOR_INFO = @as(u32, 1);
pub const SCARD_CLASS_COMMUNICATIONS = @as(u32, 2);
pub const SCARD_CLASS_PROTOCOL = @as(u32, 3);
pub const SCARD_CLASS_POWER_MGMT = @as(u32, 4);
pub const SCARD_CLASS_SECURITY = @as(u32, 5);
pub const SCARD_CLASS_MECHANICAL = @as(u32, 6);
pub const SCARD_CLASS_VENDOR_DEFINED = @as(u32, 7);
pub const SCARD_CLASS_IFD_PROTOCOL = @as(u32, 8);
pub const SCARD_CLASS_ICC_STATE = @as(u32, 9);
pub const SCARD_CLASS_PERF = @as(u32, 32766);
pub const SCARD_CLASS_SYSTEM = @as(u32, 32767);
pub const SCARD_T0_HEADER_LENGTH = @as(u32, 7);
pub const SCARD_T0_CMD_LENGTH = @as(u32, 5);
pub const SCARD_T1_PROLOGUE_LENGTH = @as(u32, 3);
pub const SCARD_T1_EPILOGUE_LENGTH = @as(u32, 2);
pub const SCARD_T1_EPILOGUE_LENGTH_LRC = @as(u32, 1);
pub const SCARD_T1_MAX_IFS = @as(u32, 254);
pub const SCARD_UNKNOWN = @as(u32, 0);
pub const SCARD_ABSENT = @as(u32, 1);
pub const SCARD_PRESENT = @as(u32, 2);
pub const SCARD_SWALLOWED = @as(u32, 3);
pub const SCARD_POWERED = @as(u32, 4);
pub const SCARD_NEGOTIABLE = @as(u32, 5);
pub const SCARD_SPECIFIC = @as(u32, 6);
pub const SCARD_READER_SWALLOWS = @as(u32, 1);
pub const SCARD_READER_EJECTS = @as(u32, 2);
pub const SCARD_READER_CONFISCATES = @as(u32, 4);
pub const SCARD_READER_CONTACTLESS = @as(u32, 8);
pub const SCARD_READER_TYPE_SERIAL = @as(u32, 1);
pub const SCARD_READER_TYPE_PARALELL = @as(u32, 2);
pub const SCARD_READER_TYPE_KEYBOARD = @as(u32, 4);
pub const SCARD_READER_TYPE_SCSI = @as(u32, 8);
pub const SCARD_READER_TYPE_IDE = @as(u32, 16);
pub const SCARD_READER_TYPE_USB = @as(u32, 32);
pub const SCARD_READER_TYPE_PCMCIA = @as(u32, 64);
pub const SCARD_READER_TYPE_TPM = @as(u32, 128);
pub const SCARD_READER_TYPE_NFC = @as(u32, 256);
pub const SCARD_READER_TYPE_UICC = @as(u32, 512);
pub const SCARD_READER_TYPE_NGC = @as(u32, 1024);
pub const SCARD_READER_TYPE_EMBEDDEDSE = @as(u32, 2048);
pub const SCARD_READER_TYPE_VENDOR = @as(u32, 240);
pub const STATUS_LOGON_FAILURE = @import("../zig.zig").typedConst(NTSTATUS, @as(i32, -1073741715));
pub const STATUS_WRONG_PASSWORD = @import("../zig.zig").typedConst(NTSTATUS, @as(i32, -1073741718));
pub const STATUS_PASSWORD_EXPIRED = @import("../zig.zig").typedConst(NTSTATUS, @as(i32, -1073741711));
pub const STATUS_PASSWORD_MUST_CHANGE = @import("../zig.zig").typedConst(NTSTATUS, @as(i32, -1073741276));
pub const STATUS_ACCESS_DENIED = @import("../zig.zig").typedConst(NTSTATUS, @as(i32, -1073741790));
pub const STATUS_DOWNGRADE_DETECTED = @import("../zig.zig").typedConst(NTSTATUS, @as(i32, -1073740920));
pub const STATUS_AUTHENTICATION_FIREWALL_FAILED = @import("../zig.zig").typedConst(NTSTATUS, @as(i32, -1073740781));
pub const STATUS_ACCOUNT_DISABLED = @import("../zig.zig").typedConst(NTSTATUS, @as(i32, -1073741710));
pub const STATUS_ACCOUNT_RESTRICTION = @import("../zig.zig").typedConst(NTSTATUS, @as(i32, -1073741714));
pub const STATUS_ACCOUNT_LOCKED_OUT = @import("../zig.zig").typedConst(NTSTATUS, @as(i32, -1073741260));
pub const STATUS_ACCOUNT_EXPIRED = @import("../zig.zig").typedConst(NTSTATUS, @as(i32, -1073741421));
pub const STATUS_LOGON_TYPE_NOT_GRANTED = @import("../zig.zig").typedConst(NTSTATUS, @as(i32, -1073741477));
pub const STATUS_NO_SUCH_LOGON_SESSION = @import("../zig.zig").typedConst(NTSTATUS, @as(i32, -1073741729));
pub const STATUS_NO_SUCH_USER = @import("../zig.zig").typedConst(NTSTATUS, @as(i32, -1073741724));
pub const CRED_MAX_STRING_LENGTH = @as(u32, 256);
pub const CRED_MAX_GENERIC_TARGET_NAME_LENGTH = @as(u32, 32767);
pub const CRED_MAX_TARGETNAME_NAMESPACE_LENGTH = @as(u32, 256);
pub const CRED_MAX_TARGETNAME_ATTRIBUTE_LENGTH = @as(u32, 256);
pub const CRED_MAX_VALUE_SIZE = @as(u32, 256);
pub const CRED_MAX_ATTRIBUTES = @as(u32, 64);
pub const CRED_LOGON_TYPES_MASK = @as(u32, 61440);
pub const CRED_TI_SERVER_FORMAT_UNKNOWN = @as(u32, 1);
pub const CRED_TI_DOMAIN_FORMAT_UNKNOWN = @as(u32, 2);
pub const CRED_TI_ONLY_PASSWORD_REQUIRED = @as(u32, 4);
pub const CRED_TI_USERNAME_TARGET = @as(u32, 8);
pub const CRED_TI_CREATE_EXPLICIT_CRED = @as(u32, 16);
pub const CRED_TI_WORKGROUP_MEMBER = @as(u32, 32);
pub const CRED_TI_DNSTREE_IS_DFS_SERVER = @as(u32, 64);
pub const CRED_TI_VALID_FLAGS = @as(u32, 61567);
pub const CERT_HASH_LENGTH = @as(u32, 20);
pub const CREDUI_MAX_MESSAGE_LENGTH = @as(u32, 1024);
pub const CREDUI_MAX_CAPTION_LENGTH = @as(u32, 128);
pub const CREDUI_MAX_GENERIC_TARGET_LENGTH = @as(u32, 32767);
pub const CREDUIWIN_IGNORE_CLOUDAUTHORITY_NAME = @as(u32, 262144);
pub const CREDUIWIN_DOWNLEVEL_HELLO_AS_SMART_CARD = @as(u32, 2147483648);
pub const CRED_PRESERVE_CREDENTIAL_BLOB = @as(u32, 1);
pub const CRED_CACHE_TARGET_INFORMATION = @as(u32, 1);
pub const CRED_ALLOW_NAME_RESOLUTION = @as(u32, 1);
pub const CRED_PROTECT_AS_SELF = @as(u32, 1);
pub const CRED_PROTECT_TO_SYSTEM = @as(u32, 2);
pub const CRED_UNPROTECT_AS_SELF = @as(u32, 1);
pub const CRED_UNPROTECT_ALLOW_TO_SYSTEM = @as(u32, 2);
pub const SCARD_SCOPE_TERMINAL = @as(u32, 1);
pub const SCARD_PROVIDER_PRIMARY = @as(u32, 1);
pub const SCARD_PROVIDER_CSP = @as(u32, 2);
pub const SCARD_PROVIDER_KSP = @as(u32, 3);
pub const SCARD_STATE_UNPOWERED = @as(u32, 1024);
pub const SCARD_SHARE_EXCLUSIVE = @as(u32, 1);
pub const SCARD_SHARE_SHARED = @as(u32, 2);
pub const SCARD_SHARE_DIRECT = @as(u32, 3);
pub const SCARD_LEAVE_CARD = @as(u32, 0);
pub const SCARD_RESET_CARD = @as(u32, 1);
pub const SCARD_UNPOWER_CARD = @as(u32, 2);
pub const SCARD_EJECT_CARD = @as(u32, 3);
pub const SC_DLG_MINIMAL_UI = @as(u32, 1);
pub const SC_DLG_NO_UI = @as(u32, 2);
pub const SC_DLG_FORCE_UI = @as(u32, 4);
pub const SCERR_NOCARDNAME = @as(u32, 16384);
pub const SCERR_NOGUIDS = @as(u32, 32768);
pub const SCARD_AUDIT_CHV_FAILURE = @as(u32, 0);
pub const SCARD_AUDIT_CHV_SUCCESS = @as(u32, 1);
pub const CREDSSP_SERVER_AUTH_NEGOTIATE = @as(u32, 1);
pub const CREDSSP_SERVER_AUTH_CERTIFICATE = @as(u32, 2);
pub const CREDSSP_SERVER_AUTH_LOOPBACK = @as(u32, 4);
pub const SECPKG_ALT_ATTR = @as(u32, 2147483648);
pub const SECPKG_ATTR_C_FULL_IDENT_TOKEN = @as(u32, 2147483781);
pub const CREDSSP_CRED_EX_VERSION = @as(u32, 0);
pub const CREDSSP_FLAG_REDIRECT = @as(u32, 1);

//--------------------------------------------------------------------------------
// Section: Types (50)
//--------------------------------------------------------------------------------
pub const CRED_FLAGS = enum(u32) {
    PASSWORD_FOR_CERT = 1,
    PROMPT_NOW = 2,
    USERNAME_TARGET = 4,
    OWF_CRED_BLOB = 8,
    REQUIRE_CONFIRMATION = 16,
    WILDCARD_MATCH = 32,
    VSM_PROTECTED = 64,
    NGC_CERT = 128,
    VALID_FLAGS = 61695,
    VALID_INPUT_FLAGS = 61599,
    _,
    pub fn initFlags(o: struct {
        PASSWORD_FOR_CERT: u1 = 0,
        PROMPT_NOW: u1 = 0,
        USERNAME_TARGET: u1 = 0,
        OWF_CRED_BLOB: u1 = 0,
        REQUIRE_CONFIRMATION: u1 = 0,
        WILDCARD_MATCH: u1 = 0,
        VSM_PROTECTED: u1 = 0,
        NGC_CERT: u1 = 0,
        VALID_FLAGS: u1 = 0,
        VALID_INPUT_FLAGS: u1 = 0,
    }) CRED_FLAGS {
        return @as(CRED_FLAGS, @enumFromInt((if (o.PASSWORD_FOR_CERT == 1) @intFromEnum(CRED_FLAGS.PASSWORD_FOR_CERT) else 0) | (if (o.PROMPT_NOW == 1) @intFromEnum(CRED_FLAGS.PROMPT_NOW) else 0) | (if (o.USERNAME_TARGET == 1) @intFromEnum(CRED_FLAGS.USERNAME_TARGET) else 0) | (if (o.OWF_CRED_BLOB == 1) @intFromEnum(CRED_FLAGS.OWF_CRED_BLOB) else 0) | (if (o.REQUIRE_CONFIRMATION == 1) @intFromEnum(CRED_FLAGS.REQUIRE_CONFIRMATION) else 0) | (if (o.WILDCARD_MATCH == 1) @intFromEnum(CRED_FLAGS.WILDCARD_MATCH) else 0) | (if (o.VSM_PROTECTED == 1) @intFromEnum(CRED_FLAGS.VSM_PROTECTED) else 0) | (if (o.NGC_CERT == 1) @intFromEnum(CRED_FLAGS.NGC_CERT) else 0) | (if (o.VALID_FLAGS == 1) @intFromEnum(CRED_FLAGS.VALID_FLAGS) else 0) | (if (o.VALID_INPUT_FLAGS == 1) @intFromEnum(CRED_FLAGS.VALID_INPUT_FLAGS) else 0)));
    }
};
pub const CRED_FLAGS_PASSWORD_FOR_CERT = CRED_FLAGS.PASSWORD_FOR_CERT;
pub const CRED_FLAGS_PROMPT_NOW = CRED_FLAGS.PROMPT_NOW;
pub const CRED_FLAGS_USERNAME_TARGET = CRED_FLAGS.USERNAME_TARGET;
pub const CRED_FLAGS_OWF_CRED_BLOB = CRED_FLAGS.OWF_CRED_BLOB;
pub const CRED_FLAGS_REQUIRE_CONFIRMATION = CRED_FLAGS.REQUIRE_CONFIRMATION;
pub const CRED_FLAGS_WILDCARD_MATCH = CRED_FLAGS.WILDCARD_MATCH;
pub const CRED_FLAGS_VSM_PROTECTED = CRED_FLAGS.VSM_PROTECTED;
pub const CRED_FLAGS_NGC_CERT = CRED_FLAGS.NGC_CERT;
pub const CRED_FLAGS_VALID_FLAGS = CRED_FLAGS.VALID_FLAGS;
pub const CRED_FLAGS_VALID_INPUT_FLAGS = CRED_FLAGS.VALID_INPUT_FLAGS;

pub const CRED_TYPE = enum(u32) {
    GENERIC = 1,
    DOMAIN_PASSWORD = 2,
    DOMAIN_CERTIFICATE = 3,
    DOMAIN_VISIBLE_PASSWORD = 4,
    GENERIC_CERTIFICATE = 5,
    DOMAIN_EXTENDED = 6,
    MAXIMUM = 7,
    MAXIMUM_EX = 1007,
};
pub const CRED_TYPE_GENERIC = CRED_TYPE.GENERIC;
pub const CRED_TYPE_DOMAIN_PASSWORD = CRED_TYPE.DOMAIN_PASSWORD;
pub const CRED_TYPE_DOMAIN_CERTIFICATE = CRED_TYPE.DOMAIN_CERTIFICATE;
pub const CRED_TYPE_DOMAIN_VISIBLE_PASSWORD = CRED_TYPE.DOMAIN_VISIBLE_PASSWORD;
pub const CRED_TYPE_GENERIC_CERTIFICATE = CRED_TYPE.GENERIC_CERTIFICATE;
pub const CRED_TYPE_DOMAIN_EXTENDED = CRED_TYPE.DOMAIN_EXTENDED;
pub const CRED_TYPE_MAXIMUM = CRED_TYPE.MAXIMUM;
pub const CRED_TYPE_MAXIMUM_EX = CRED_TYPE.MAXIMUM_EX;

pub const CRED_PERSIST = enum(u32) {
    NONE = 0,
    SESSION = 1,
    LOCAL_MACHINE = 2,
    ENTERPRISE = 3,
};
pub const CRED_PERSIST_NONE = CRED_PERSIST.NONE;
pub const CRED_PERSIST_SESSION = CRED_PERSIST.SESSION;
pub const CRED_PERSIST_LOCAL_MACHINE = CRED_PERSIST.LOCAL_MACHINE;
pub const CRED_PERSIST_ENTERPRISE = CRED_PERSIST.ENTERPRISE;

pub const CREDUI_FLAGS = enum(u32) {
    ALWAYS_SHOW_UI = 128,
    COMPLETE_USERNAME = 2048,
    DO_NOT_PERSIST = 2,
    EXCLUDE_CERTIFICATES = 8,
    EXPECT_CONFIRMATION = 131072,
    GENERIC_CREDENTIALS = 262144,
    INCORRECT_PASSWORD = 1,
    KEEP_USERNAME = 1048576,
    PASSWORD_ONLY_OK = 512,
    PERSIST = 4096,
    REQUEST_ADMINISTRATOR = 4,
    REQUIRE_CERTIFICATE = 16,
    REQUIRE_SMARTCARD = 256,
    SERVER_CREDENTIAL = 16384,
    SHOW_SAVE_CHECK_BOX = 64,
    USERNAME_TARGET_CREDENTIALS = 524288,
    VALIDATE_USERNAME = 1024,
    _,
    pub fn initFlags(o: struct {
        ALWAYS_SHOW_UI: u1 = 0,
        COMPLETE_USERNAME: u1 = 0,
        DO_NOT_PERSIST: u1 = 0,
        EXCLUDE_CERTIFICATES: u1 = 0,
        EXPECT_CONFIRMATION: u1 = 0,
        GENERIC_CREDENTIALS: u1 = 0,
        INCORRECT_PASSWORD: u1 = 0,
        KEEP_USERNAME: u1 = 0,
        PASSWORD_ONLY_OK: u1 = 0,
        PERSIST: u1 = 0,
        REQUEST_ADMINISTRATOR: u1 = 0,
        REQUIRE_CERTIFICATE: u1 = 0,
        REQUIRE_SMARTCARD: u1 = 0,
        SERVER_CREDENTIAL: u1 = 0,
        SHOW_SAVE_CHECK_BOX: u1 = 0,
        USERNAME_TARGET_CREDENTIALS: u1 = 0,
        VALIDATE_USERNAME: u1 = 0,
    }) CREDUI_FLAGS {
        return @as(CREDUI_FLAGS, @enumFromInt((if (o.ALWAYS_SHOW_UI == 1) @intFromEnum(CREDUI_FLAGS.ALWAYS_SHOW_UI) else 0) | (if (o.COMPLETE_USERNAME == 1) @intFromEnum(CREDUI_FLAGS.COMPLETE_USERNAME) else 0) | (if (o.DO_NOT_PERSIST == 1) @intFromEnum(CREDUI_FLAGS.DO_NOT_PERSIST) else 0) | (if (o.EXCLUDE_CERTIFICATES == 1) @intFromEnum(CREDUI_FLAGS.EXCLUDE_CERTIFICATES) else 0) | (if (o.EXPECT_CONFIRMATION == 1) @intFromEnum(CREDUI_FLAGS.EXPECT_CONFIRMATION) else 0) | (if (o.GENERIC_CREDENTIALS == 1) @intFromEnum(CREDUI_FLAGS.GENERIC_CREDENTIALS) else 0) | (if (o.INCORRECT_PASSWORD == 1) @intFromEnum(CREDUI_FLAGS.INCORRECT_PASSWORD) else 0) | (if (o.KEEP_USERNAME == 1) @intFromEnum(CREDUI_FLAGS.KEEP_USERNAME) else 0) | (if (o.PASSWORD_ONLY_OK == 1) @intFromEnum(CREDUI_FLAGS.PASSWORD_ONLY_OK) else 0) | (if (o.PERSIST == 1) @intFromEnum(CREDUI_FLAGS.PERSIST) else 0) | (if (o.REQUEST_ADMINISTRATOR == 1) @intFromEnum(CREDUI_FLAGS.REQUEST_ADMINISTRATOR) else 0) | (if (o.REQUIRE_CERTIFICATE == 1) @intFromEnum(CREDUI_FLAGS.REQUIRE_CERTIFICATE) else 0) | (if (o.REQUIRE_SMARTCARD == 1) @intFromEnum(CREDUI_FLAGS.REQUIRE_SMARTCARD) else 0) | (if (o.SERVER_CREDENTIAL == 1) @intFromEnum(CREDUI_FLAGS.SERVER_CREDENTIAL) else 0) | (if (o.SHOW_SAVE_CHECK_BOX == 1) @intFromEnum(CREDUI_FLAGS.SHOW_SAVE_CHECK_BOX) else 0) | (if (o.USERNAME_TARGET_CREDENTIALS == 1) @intFromEnum(CREDUI_FLAGS.USERNAME_TARGET_CREDENTIALS) else 0) | (if (o.VALIDATE_USERNAME == 1) @intFromEnum(CREDUI_FLAGS.VALIDATE_USERNAME) else 0)));
    }
};
pub const CREDUI_FLAGS_ALWAYS_SHOW_UI = CREDUI_FLAGS.ALWAYS_SHOW_UI;
pub const CREDUI_FLAGS_COMPLETE_USERNAME = CREDUI_FLAGS.COMPLETE_USERNAME;
pub const CREDUI_FLAGS_DO_NOT_PERSIST = CREDUI_FLAGS.DO_NOT_PERSIST;
pub const CREDUI_FLAGS_EXCLUDE_CERTIFICATES = CREDUI_FLAGS.EXCLUDE_CERTIFICATES;
pub const CREDUI_FLAGS_EXPECT_CONFIRMATION = CREDUI_FLAGS.EXPECT_CONFIRMATION;
pub const CREDUI_FLAGS_GENERIC_CREDENTIALS = CREDUI_FLAGS.GENERIC_CREDENTIALS;
pub const CREDUI_FLAGS_INCORRECT_PASSWORD = CREDUI_FLAGS.INCORRECT_PASSWORD;
pub const CREDUI_FLAGS_KEEP_USERNAME = CREDUI_FLAGS.KEEP_USERNAME;
pub const CREDUI_FLAGS_PASSWORD_ONLY_OK = CREDUI_FLAGS.PASSWORD_ONLY_OK;
pub const CREDUI_FLAGS_PERSIST = CREDUI_FLAGS.PERSIST;
pub const CREDUI_FLAGS_REQUEST_ADMINISTRATOR = CREDUI_FLAGS.REQUEST_ADMINISTRATOR;
pub const CREDUI_FLAGS_REQUIRE_CERTIFICATE = CREDUI_FLAGS.REQUIRE_CERTIFICATE;
pub const CREDUI_FLAGS_REQUIRE_SMARTCARD = CREDUI_FLAGS.REQUIRE_SMARTCARD;
pub const CREDUI_FLAGS_SERVER_CREDENTIAL = CREDUI_FLAGS.SERVER_CREDENTIAL;
pub const CREDUI_FLAGS_SHOW_SAVE_CHECK_BOX = CREDUI_FLAGS.SHOW_SAVE_CHECK_BOX;
pub const CREDUI_FLAGS_USERNAME_TARGET_CREDENTIALS = CREDUI_FLAGS.USERNAME_TARGET_CREDENTIALS;
pub const CREDUI_FLAGS_VALIDATE_USERNAME = CREDUI_FLAGS.VALIDATE_USERNAME;

pub const SCARD_SCOPE = enum(u32) {
    USER = 0,
    SYSTEM = 2,
};
pub const SCARD_SCOPE_USER = SCARD_SCOPE.USER;
pub const SCARD_SCOPE_SYSTEM = SCARD_SCOPE.SYSTEM;

pub const CRED_ENUMERATE_FLAGS = enum(u32) {
    S = 1,
    _,
    pub fn initFlags(o: struct {
        S: u1 = 0,
    }) CRED_ENUMERATE_FLAGS {
        return @as(CRED_ENUMERATE_FLAGS, @enumFromInt((if (o.S == 1) @intFromEnum(CRED_ENUMERATE_FLAGS.S) else 0)));
    }
};
pub const CRED_ENUMERATE_ALL_CREDENTIALS = CRED_ENUMERATE_FLAGS.S;

pub const CREDUIWIN_FLAGS = enum(u32) {
    GENERIC = 1,
    CHECKBOX = 2,
    AUTHPACKAGE_ONLY = 16,
    IN_CRED_ONLY = 32,
    ENUMERATE_ADMINS = 256,
    ENUMERATE_CURRENT_USER = 512,
    SECURE_PROMPT = 4096,
    PREPROMPTING = 8192,
    PACK_32_WOW = 268435456,
    _,
    pub fn initFlags(o: struct {
        GENERIC: u1 = 0,
        CHECKBOX: u1 = 0,
        AUTHPACKAGE_ONLY: u1 = 0,
        IN_CRED_ONLY: u1 = 0,
        ENUMERATE_ADMINS: u1 = 0,
        ENUMERATE_CURRENT_USER: u1 = 0,
        SECURE_PROMPT: u1 = 0,
        PREPROMPTING: u1 = 0,
        PACK_32_WOW: u1 = 0,
    }) CREDUIWIN_FLAGS {
        return @as(CREDUIWIN_FLAGS, @enumFromInt((if (o.GENERIC == 1) @intFromEnum(CREDUIWIN_FLAGS.GENERIC) else 0) | (if (o.CHECKBOX == 1) @intFromEnum(CREDUIWIN_FLAGS.CHECKBOX) else 0) | (if (o.AUTHPACKAGE_ONLY == 1) @intFromEnum(CREDUIWIN_FLAGS.AUTHPACKAGE_ONLY) else 0) | (if (o.IN_CRED_ONLY == 1) @intFromEnum(CREDUIWIN_FLAGS.IN_CRED_ONLY) else 0) | (if (o.ENUMERATE_ADMINS == 1) @intFromEnum(CREDUIWIN_FLAGS.ENUMERATE_ADMINS) else 0) | (if (o.ENUMERATE_CURRENT_USER == 1) @intFromEnum(CREDUIWIN_FLAGS.ENUMERATE_CURRENT_USER) else 0) | (if (o.SECURE_PROMPT == 1) @intFromEnum(CREDUIWIN_FLAGS.SECURE_PROMPT) else 0) | (if (o.PREPROMPTING == 1) @intFromEnum(CREDUIWIN_FLAGS.PREPROMPTING) else 0) | (if (o.PACK_32_WOW == 1) @intFromEnum(CREDUIWIN_FLAGS.PACK_32_WOW) else 0)));
    }
};
pub const CREDUIWIN_GENERIC = CREDUIWIN_FLAGS.GENERIC;
pub const CREDUIWIN_CHECKBOX = CREDUIWIN_FLAGS.CHECKBOX;
pub const CREDUIWIN_AUTHPACKAGE_ONLY = CREDUIWIN_FLAGS.AUTHPACKAGE_ONLY;
pub const CREDUIWIN_IN_CRED_ONLY = CREDUIWIN_FLAGS.IN_CRED_ONLY;
pub const CREDUIWIN_ENUMERATE_ADMINS = CREDUIWIN_FLAGS.ENUMERATE_ADMINS;
pub const CREDUIWIN_ENUMERATE_CURRENT_USER = CREDUIWIN_FLAGS.ENUMERATE_CURRENT_USER;
pub const CREDUIWIN_SECURE_PROMPT = CREDUIWIN_FLAGS.SECURE_PROMPT;
pub const CREDUIWIN_PREPROMPTING = CREDUIWIN_FLAGS.PREPROMPTING;
pub const CREDUIWIN_PACK_32_WOW = CREDUIWIN_FLAGS.PACK_32_WOW;

pub const SCARD_STATE = enum(u32) {
    UNAWARE = 0,
    IGNORE = 1,
    UNAVAILABLE = 8,
    EMPTY = 16,
    PRESENT = 32,
    ATRMATCH = 64,
    EXCLUSIVE = 128,
    INUSE = 256,
    MUTE = 512,
    CHANGED = 2,
    UNKNOWN = 4,
};
pub const SCARD_STATE_UNAWARE = SCARD_STATE.UNAWARE;
pub const SCARD_STATE_IGNORE = SCARD_STATE.IGNORE;
pub const SCARD_STATE_UNAVAILABLE = SCARD_STATE.UNAVAILABLE;
pub const SCARD_STATE_EMPTY = SCARD_STATE.EMPTY;
pub const SCARD_STATE_PRESENT = SCARD_STATE.PRESENT;
pub const SCARD_STATE_ATRMATCH = SCARD_STATE.ATRMATCH;
pub const SCARD_STATE_EXCLUSIVE = SCARD_STATE.EXCLUSIVE;
pub const SCARD_STATE_INUSE = SCARD_STATE.INUSE;
pub const SCARD_STATE_MUTE = SCARD_STATE.MUTE;
pub const SCARD_STATE_CHANGED = SCARD_STATE.CHANGED;
pub const SCARD_STATE_UNKNOWN = SCARD_STATE.UNKNOWN;

pub const CRED_PACK_FLAGS = enum(u32) {
    PROTECTED_CREDENTIALS = 1,
    WOW_BUFFER = 2,
    GENERIC_CREDENTIALS = 4,
    ID_PROVIDER_CREDENTIALS = 8,
    _,
    pub fn initFlags(o: struct {
        PROTECTED_CREDENTIALS: u1 = 0,
        WOW_BUFFER: u1 = 0,
        GENERIC_CREDENTIALS: u1 = 0,
        ID_PROVIDER_CREDENTIALS: u1 = 0,
    }) CRED_PACK_FLAGS {
        return @as(CRED_PACK_FLAGS, @enumFromInt((if (o.PROTECTED_CREDENTIALS == 1) @intFromEnum(CRED_PACK_FLAGS.PROTECTED_CREDENTIALS) else 0) | (if (o.WOW_BUFFER == 1) @intFromEnum(CRED_PACK_FLAGS.WOW_BUFFER) else 0) | (if (o.GENERIC_CREDENTIALS == 1) @intFromEnum(CRED_PACK_FLAGS.GENERIC_CREDENTIALS) else 0) | (if (o.ID_PROVIDER_CREDENTIALS == 1) @intFromEnum(CRED_PACK_FLAGS.ID_PROVIDER_CREDENTIALS) else 0)));
    }
};
pub const CRED_PACK_PROTECTED_CREDENTIALS = CRED_PACK_FLAGS.PROTECTED_CREDENTIALS;
pub const CRED_PACK_WOW_BUFFER = CRED_PACK_FLAGS.WOW_BUFFER;
pub const CRED_PACK_GENERIC_CREDENTIALS = CRED_PACK_FLAGS.GENERIC_CREDENTIALS;
pub const CRED_PACK_ID_PROVIDER_CREDENTIALS = CRED_PACK_FLAGS.ID_PROVIDER_CREDENTIALS;

pub const KeyCredentialManagerOperationErrorStates = enum(u32) {
    None = 0,
    DeviceJoinFailure = 1,
    TokenFailure = 2,
    CertificateFailure = 4,
    RemoteSessionFailure = 8,
    PolicyFailure = 16,
    HardwareFailure = 32,
    PinExistsFailure = 64,
    _,
    pub fn initFlags(o: struct {
        None: u1 = 0,
        DeviceJoinFailure: u1 = 0,
        TokenFailure: u1 = 0,
        CertificateFailure: u1 = 0,
        RemoteSessionFailure: u1 = 0,
        PolicyFailure: u1 = 0,
        HardwareFailure: u1 = 0,
        PinExistsFailure: u1 = 0,
    }) KeyCredentialManagerOperationErrorStates {
        return @as(KeyCredentialManagerOperationErrorStates, @enumFromInt((if (o.None == 1) @intFromEnum(KeyCredentialManagerOperationErrorStates.None) else 0) | (if (o.DeviceJoinFailure == 1) @intFromEnum(KeyCredentialManagerOperationErrorStates.DeviceJoinFailure) else 0) | (if (o.TokenFailure == 1) @intFromEnum(KeyCredentialManagerOperationErrorStates.TokenFailure) else 0) | (if (o.CertificateFailure == 1) @intFromEnum(KeyCredentialManagerOperationErrorStates.CertificateFailure) else 0) | (if (o.RemoteSessionFailure == 1) @intFromEnum(KeyCredentialManagerOperationErrorStates.RemoteSessionFailure) else 0) | (if (o.PolicyFailure == 1) @intFromEnum(KeyCredentialManagerOperationErrorStates.PolicyFailure) else 0) | (if (o.HardwareFailure == 1) @intFromEnum(KeyCredentialManagerOperationErrorStates.HardwareFailure) else 0) | (if (o.PinExistsFailure == 1) @intFromEnum(KeyCredentialManagerOperationErrorStates.PinExistsFailure) else 0)));
    }
};
pub const KeyCredentialManagerOperationErrorStateNone = KeyCredentialManagerOperationErrorStates.None;
pub const KeyCredentialManagerOperationErrorStateDeviceJoinFailure = KeyCredentialManagerOperationErrorStates.DeviceJoinFailure;
pub const KeyCredentialManagerOperationErrorStateTokenFailure = KeyCredentialManagerOperationErrorStates.TokenFailure;
pub const KeyCredentialManagerOperationErrorStateCertificateFailure = KeyCredentialManagerOperationErrorStates.CertificateFailure;
pub const KeyCredentialManagerOperationErrorStateRemoteSessionFailure = KeyCredentialManagerOperationErrorStates.RemoteSessionFailure;
pub const KeyCredentialManagerOperationErrorStatePolicyFailure = KeyCredentialManagerOperationErrorStates.PolicyFailure;
pub const KeyCredentialManagerOperationErrorStateHardwareFailure = KeyCredentialManagerOperationErrorStates.HardwareFailure;
pub const KeyCredentialManagerOperationErrorStatePinExistsFailure = KeyCredentialManagerOperationErrorStates.PinExistsFailure;

pub const KeyCredentialManagerOperationType = enum(i32) {
    rovisioning = 0,
    inChange = 1,
    inReset = 2,
};
pub const KeyCredentialManagerProvisioning = KeyCredentialManagerOperationType.rovisioning;
pub const KeyCredentialManagerPinChange = KeyCredentialManagerOperationType.inChange;
pub const KeyCredentialManagerPinReset = KeyCredentialManagerOperationType.inReset;

pub const KeyCredentialManagerInfo = extern struct {
    containerId: Guid,
};

pub const SecHandle = extern struct {
    dwLower: usize,
    dwUpper: usize,
};

pub const CREDENTIAL_ATTRIBUTEA = extern struct {
    Keyword: ?PSTR,
    Flags: u32,
    ValueSize: u32,
    Value: ?*u8,
};

pub const CREDENTIAL_ATTRIBUTEW = extern struct {
    Keyword: ?PWSTR,
    Flags: u32,
    ValueSize: u32,
    Value: ?*u8,
};

pub const CREDENTIALA = extern struct {
    Flags: CRED_FLAGS,
    Type: CRED_TYPE,
    TargetName: ?PSTR,
    Comment: ?PSTR,
    LastWritten: FILETIME,
    CredentialBlobSize: u32,
    CredentialBlob: ?*u8,
    Persist: CRED_PERSIST,
    AttributeCount: u32,
    Attributes: ?*CREDENTIAL_ATTRIBUTEA,
    TargetAlias: ?PSTR,
    UserName: ?PSTR,
};

pub const CREDENTIALW = extern struct {
    Flags: CRED_FLAGS,
    Type: CRED_TYPE,
    TargetName: ?PWSTR,
    Comment: ?PWSTR,
    LastWritten: FILETIME,
    CredentialBlobSize: u32,
    CredentialBlob: ?*u8,
    Persist: CRED_PERSIST,
    AttributeCount: u32,
    Attributes: ?*CREDENTIAL_ATTRIBUTEW,
    TargetAlias: ?PWSTR,
    UserName: ?PWSTR,
};

pub const CREDENTIAL_TARGET_INFORMATIONA = extern struct {
    TargetName: ?PSTR,
    NetbiosServerName: ?PSTR,
    DnsServerName: ?PSTR,
    NetbiosDomainName: ?PSTR,
    DnsDomainName: ?PSTR,
    DnsTreeName: ?PSTR,
    PackageName: ?PSTR,
    Flags: u32,
    CredTypeCount: u32,
    CredTypes: ?*u32,
};

pub const CREDENTIAL_TARGET_INFORMATIONW = extern struct {
    TargetName: ?PWSTR,
    NetbiosServerName: ?PWSTR,
    DnsServerName: ?PWSTR,
    NetbiosDomainName: ?PWSTR,
    DnsDomainName: ?PWSTR,
    DnsTreeName: ?PWSTR,
    PackageName: ?PWSTR,
    Flags: u32,
    CredTypeCount: u32,
    CredTypes: ?*u32,
};

pub const CERT_CREDENTIAL_INFO = extern struct {
    cbSize: u32,
    rgbHashOfCert: [20]u8,
};

pub const USERNAME_TARGET_CREDENTIAL_INFO = extern struct {
    UserName: ?PWSTR,
};

pub const BINARY_BLOB_CREDENTIAL_INFO = extern struct {
    cbBlob: u32,
    pbBlob: ?*u8,
};

pub const CRED_MARSHAL_TYPE = enum(i32) {
    CertCredential = 1,
    UsernameTargetCredential = 2,
    BinaryBlobCredential = 3,
    UsernameForPackedCredentials = 4,
    BinaryBlobForSystem = 5,
};
pub const CertCredential = CRED_MARSHAL_TYPE.CertCredential;
pub const UsernameTargetCredential = CRED_MARSHAL_TYPE.UsernameTargetCredential;
pub const BinaryBlobCredential = CRED_MARSHAL_TYPE.BinaryBlobCredential;
pub const UsernameForPackedCredentials = CRED_MARSHAL_TYPE.UsernameForPackedCredentials;
pub const BinaryBlobForSystem = CRED_MARSHAL_TYPE.BinaryBlobForSystem;

pub const CRED_PROTECTION_TYPE = enum(i32) {
    Unprotected = 0,
    UserProtection = 1,
    TrustedProtection = 2,
    ForSystemProtection = 3,
};
pub const CredUnprotected = CRED_PROTECTION_TYPE.Unprotected;
pub const CredUserProtection = CRED_PROTECTION_TYPE.UserProtection;
pub const CredTrustedProtection = CRED_PROTECTION_TYPE.TrustedProtection;
pub const CredForSystemProtection = CRED_PROTECTION_TYPE.ForSystemProtection;

pub const CREDUI_INFOA = extern struct {
    cbSize: u32,
    hwndParent: ?HWND,
    pszMessageText: ?[*:0]const u8,
    pszCaptionText: ?[*:0]const u8,
    hbmBanner: ?HBITMAP,
};

pub const CREDUI_INFOW = extern struct {
    cbSize: u32,
    hwndParent: ?HWND,
    pszMessageText: ?[*:0]const u16,
    pszCaptionText: ?[*:0]const u16,
    hbmBanner: ?HBITMAP,
};

pub const SCARD_IO_REQUEST = extern struct {
    dwProtocol: u32,
    cbPciLength: u32,
};

pub const SCARD_T0_COMMAND = extern struct {
    bCla: u8,
    bIns: u8,
    bP1: u8,
    bP2: u8,
    bP3: u8,
};

pub const SCARD_T0_REQUEST = extern struct {
    ioRequest: SCARD_IO_REQUEST,
    bSw1: u8,
    bSw2: u8,
    Anonymous: extern union {
        CmdBytes: SCARD_T0_COMMAND,
        rgbHeader: [5]u8,
    },
};

pub const SCARD_T1_REQUEST = extern struct {
    ioRequest: SCARD_IO_REQUEST,
};

pub const SCARD_READERSTATEA = extern struct {
    szReader: ?[*:0]const u8,
    pvUserData: ?*anyopaque,
    dwCurrentState: SCARD_STATE,
    dwEventState: SCARD_STATE,
    cbAtr: u32,
    rgbAtr: [36]u8,
};

pub const SCARD_READERSTATEW = extern struct {
    szReader: ?[*:0]const u16,
    pvUserData: ?*anyopaque,
    dwCurrentState: SCARD_STATE,
    dwEventState: SCARD_STATE,
    cbAtr: u32,
    rgbAtr: [36]u8,
};

pub const SCARD_ATRMASK = extern struct {
    cbAtr: u32,
    rgbAtr: [36]u8,
    rgbMask: [36]u8,
};

pub const LPOCNCONNPROCA = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        param0: usize,
        param1: ?PSTR,
        param2: ?PSTR,
        param3: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) usize,
    else => *const fn (
        param0: usize,
        param1: ?PSTR,
        param2: ?PSTR,
        param3: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) usize,
};

pub const LPOCNCONNPROCW = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        param0: usize,
        param1: ?PWSTR,
        param2: ?PWSTR,
        param3: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) usize,
    else => *const fn (
        param0: usize,
        param1: ?PWSTR,
        param2: ?PWSTR,
        param3: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) usize,
};

pub const LPOCNCHKPROC = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        param0: usize,
        param1: usize,
        param2: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) BOOL,
    else => *const fn (
        param0: usize,
        param1: usize,
        param2: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) BOOL,
};

pub const LPOCNDSCPROC = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        param0: usize,
        param1: usize,
        param2: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        param0: usize,
        param1: usize,
        param2: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const OPENCARD_SEARCH_CRITERIAA = extern struct {
    dwStructSize: u32,
    lpstrGroupNames: ?PSTR,
    nMaxGroupNames: u32,
    rgguidInterfaces: ?*const Guid,
    cguidInterfaces: u32,
    lpstrCardNames: ?PSTR,
    nMaxCardNames: u32,
    lpfnCheck: ?LPOCNCHKPROC,
    lpfnConnect: ?LPOCNCONNPROCA,
    lpfnDisconnect: ?LPOCNDSCPROC,
    pvUserData: ?*anyopaque,
    dwShareMode: u32,
    dwPreferredProtocols: u32,
};

pub const OPENCARD_SEARCH_CRITERIAW = extern struct {
    dwStructSize: u32,
    lpstrGroupNames: ?PWSTR,
    nMaxGroupNames: u32,
    rgguidInterfaces: ?*const Guid,
    cguidInterfaces: u32,
    lpstrCardNames: ?PWSTR,
    nMaxCardNames: u32,
    lpfnCheck: ?LPOCNCHKPROC,
    lpfnConnect: ?LPOCNCONNPROCW,
    lpfnDisconnect: ?LPOCNDSCPROC,
    pvUserData: ?*anyopaque,
    dwShareMode: u32,
    dwPreferredProtocols: u32,
};

pub const OPENCARDNAME_EXA = extern struct {
    dwStructSize: u32,
    hSCardContext: usize,
    hwndOwner: ?HWND,
    dwFlags: u32,
    lpstrTitle: ?[*:0]const u8,
    lpstrSearchDesc: ?[*:0]const u8,
    hIcon: ?HICON,
    pOpenCardSearchCriteria: ?*OPENCARD_SEARCH_CRITERIAA,
    lpfnConnect: ?LPOCNCONNPROCA,
    pvUserData: ?*anyopaque,
    dwShareMode: u32,
    dwPreferredProtocols: u32,
    lpstrRdr: ?PSTR,
    nMaxRdr: u32,
    lpstrCard: ?PSTR,
    nMaxCard: u32,
    dwActiveProtocol: u32,
    hCardHandle: usize,
};

pub const OPENCARDNAME_EXW = extern struct {
    dwStructSize: u32,
    hSCardContext: usize,
    hwndOwner: ?HWND,
    dwFlags: u32,
    lpstrTitle: ?[*:0]const u16,
    lpstrSearchDesc: ?[*:0]const u16,
    hIcon: ?HICON,
    pOpenCardSearchCriteria: ?*OPENCARD_SEARCH_CRITERIAW,
    lpfnConnect: ?LPOCNCONNPROCW,
    pvUserData: ?*anyopaque,
    dwShareMode: u32,
    dwPreferredProtocols: u32,
    lpstrRdr: ?PWSTR,
    nMaxRdr: u32,
    lpstrCard: ?PWSTR,
    nMaxCard: u32,
    dwActiveProtocol: u32,
    hCardHandle: usize,
};

pub const READER_SEL_REQUEST_MATCH_TYPE = enum(i32) {
    READER_AND_CONTAINER = 1,
    SERIAL_NUMBER = 2,
    ALL_CARDS = 3,
};
pub const RSR_MATCH_TYPE_READER_AND_CONTAINER = READER_SEL_REQUEST_MATCH_TYPE.READER_AND_CONTAINER;
pub const RSR_MATCH_TYPE_SERIAL_NUMBER = READER_SEL_REQUEST_MATCH_TYPE.SERIAL_NUMBER;
pub const RSR_MATCH_TYPE_ALL_CARDS = READER_SEL_REQUEST_MATCH_TYPE.ALL_CARDS;

pub const READER_SEL_REQUEST = extern struct {
    dwShareMode: u32,
    dwPreferredProtocols: u32,
    MatchType: READER_SEL_REQUEST_MATCH_TYPE,
    Anonymous: extern union {
        ReaderAndContainerParameter: extern struct {
            cbReaderNameOffset: u32,
            cchReaderNameLength: u32,
            cbContainerNameOffset: u32,
            cchContainerNameLength: u32,
            dwDesiredCardModuleVersion: u32,
            dwCspFlags: u32,
        },
        SerialNumberParameter: extern struct {
            cbSerialNumberOffset: u32,
            cbSerialNumberLength: u32,
            dwDesiredCardModuleVersion: u32,
        },
    },
};

pub const READER_SEL_RESPONSE = extern struct {
    cbReaderNameOffset: u32,
    cchReaderNameLength: u32,
    cbCardNameOffset: u32,
    cchCardNameLength: u32,
};

pub const OPENCARDNAMEA = extern struct {
    dwStructSize: u32,
    hwndOwner: ?HWND,
    hSCardContext: usize,
    lpstrGroupNames: ?PSTR,
    nMaxGroupNames: u32,
    lpstrCardNames: ?PSTR,
    nMaxCardNames: u32,
    rgguidInterfaces: ?*const Guid,
    cguidInterfaces: u32,
    lpstrRdr: ?PSTR,
    nMaxRdr: u32,
    lpstrCard: ?PSTR,
    nMaxCard: u32,
    lpstrTitle: ?[*:0]const u8,
    dwFlags: u32,
    pvUserData: ?*anyopaque,
    dwShareMode: u32,
    dwPreferredProtocols: u32,
    dwActiveProtocol: u32,
    lpfnConnect: ?LPOCNCONNPROCA,
    lpfnCheck: ?LPOCNCHKPROC,
    lpfnDisconnect: ?LPOCNDSCPROC,
    hCardHandle: usize,
};

pub const OPENCARDNAMEW = extern struct {
    dwStructSize: u32,
    hwndOwner: ?HWND,
    hSCardContext: usize,
    lpstrGroupNames: ?PWSTR,
    nMaxGroupNames: u32,
    lpstrCardNames: ?PWSTR,
    nMaxCardNames: u32,
    rgguidInterfaces: ?*const Guid,
    cguidInterfaces: u32,
    lpstrRdr: ?PWSTR,
    nMaxRdr: u32,
    lpstrCard: ?PWSTR,
    nMaxCard: u32,
    lpstrTitle: ?[*:0]const u16,
    dwFlags: u32,
    pvUserData: ?*anyopaque,
    dwShareMode: u32,
    dwPreferredProtocols: u32,
    dwActiveProtocol: u32,
    lpfnConnect: ?LPOCNCONNPROCW,
    lpfnCheck: ?LPOCNCHKPROC,
    lpfnDisconnect: ?LPOCNDSCPROC,
    hCardHandle: usize,
};

pub const SecPkgContext_ClientCreds = extern struct {
    AuthBufferLen: u32,
    AuthBuffer: ?*u8,
};

pub const CREDSPP_SUBMIT_TYPE = enum(i32) {
    PasswordCreds = 2,
    SchannelCreds = 4,
    CertificateCreds = 13,
    SubmitBufferBoth = 50,
    SubmitBufferBothOld = 51,
    CredEx = 100,
};
pub const CredsspPasswordCreds = CREDSPP_SUBMIT_TYPE.PasswordCreds;
pub const CredsspSchannelCreds = CREDSPP_SUBMIT_TYPE.SchannelCreds;
pub const CredsspCertificateCreds = CREDSPP_SUBMIT_TYPE.CertificateCreds;
pub const CredsspSubmitBufferBoth = CREDSPP_SUBMIT_TYPE.SubmitBufferBoth;
pub const CredsspSubmitBufferBothOld = CREDSPP_SUBMIT_TYPE.SubmitBufferBothOld;
pub const CredsspCredEx = CREDSPP_SUBMIT_TYPE.CredEx;

pub const CREDSSP_CRED = extern struct {
    Type: CREDSPP_SUBMIT_TYPE,
    pSchannelCred: ?*anyopaque,
    pSpnegoCred: ?*anyopaque,
};

pub const CREDSSP_CRED_EX = extern struct {
    Type: CREDSPP_SUBMIT_TYPE,
    Version: u32,
    Flags: u32,
    Reserved: u32,
    Cred: CREDSSP_CRED,
};

//--------------------------------------------------------------------------------
// Section: Functions (127)
//--------------------------------------------------------------------------------
pub extern "keycredmgr" fn KeyCredentialManagerGetOperationErrorStates(
    keyCredentialManagerOperationType: KeyCredentialManagerOperationType,
    isReady: ?*BOOL,
    keyCredentialManagerOperationErrorStates: ?*KeyCredentialManagerOperationErrorStates,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "keycredmgr" fn KeyCredentialManagerShowUIOperation(
    hWndOwner: ?HWND,
    keyCredentialManagerOperationType: KeyCredentialManagerOperationType,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "keycredmgr" fn KeyCredentialManagerGetInformation(
    keyCredentialManagerInfo: ?*?*KeyCredentialManagerInfo,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "keycredmgr" fn KeyCredentialManagerFreeInformation(
    keyCredentialManagerInfo: ?*KeyCredentialManagerInfo,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredWriteW(
    Credential: ?*CREDENTIALW,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredWriteA(
    Credential: ?*CREDENTIALA,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredReadW(
    TargetName: ?[*:0]const u16,
    Type: u32,
    Flags: u32,
    Credential: ?*?*CREDENTIALW,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredReadA(
    TargetName: ?[*:0]const u8,
    Type: u32,
    Flags: u32,
    Credential: ?*?*CREDENTIALA,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredEnumerateW(
    Filter: ?[*:0]const u16,
    Flags: CRED_ENUMERATE_FLAGS,
    Count: ?*u32,
    Credential: ?*?*?*CREDENTIALW,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredEnumerateA(
    Filter: ?[*:0]const u8,
    Flags: CRED_ENUMERATE_FLAGS,
    Count: ?*u32,
    Credential: ?*?*?*CREDENTIALA,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredWriteDomainCredentialsW(
    TargetInfo: ?*CREDENTIAL_TARGET_INFORMATIONW,
    Credential: ?*CREDENTIALW,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredWriteDomainCredentialsA(
    TargetInfo: ?*CREDENTIAL_TARGET_INFORMATIONA,
    Credential: ?*CREDENTIALA,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredReadDomainCredentialsW(
    TargetInfo: ?*CREDENTIAL_TARGET_INFORMATIONW,
    Flags: u32,
    Count: ?*u32,
    Credential: ?*?*?*CREDENTIALW,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredReadDomainCredentialsA(
    TargetInfo: ?*CREDENTIAL_TARGET_INFORMATIONA,
    Flags: u32,
    Count: ?*u32,
    Credential: ?*?*?*CREDENTIALA,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredDeleteW(
    TargetName: ?[*:0]const u16,
    Type: u32,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredDeleteA(
    TargetName: ?[*:0]const u8,
    Type: u32,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredRenameW(
    OldTargetName: ?[*:0]const u16,
    NewTargetName: ?[*:0]const u16,
    Type: u32,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredRenameA(
    OldTargetName: ?[*:0]const u8,
    NewTargetName: ?[*:0]const u8,
    Type: u32,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredGetTargetInfoW(
    TargetName: ?[*:0]const u16,
    Flags: u32,
    TargetInfo: ?*?*CREDENTIAL_TARGET_INFORMATIONW,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredGetTargetInfoA(
    TargetName: ?[*:0]const u8,
    Flags: u32,
    TargetInfo: ?*?*CREDENTIAL_TARGET_INFORMATIONA,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredMarshalCredentialW(
    CredType: CRED_MARSHAL_TYPE,
    Credential: ?*anyopaque,
    MarshaledCredential: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredMarshalCredentialA(
    CredType: CRED_MARSHAL_TYPE,
    Credential: ?*anyopaque,
    MarshaledCredential: ?*?PSTR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredUnmarshalCredentialW(
    MarshaledCredential: ?[*:0]const u16,
    CredType: ?*CRED_MARSHAL_TYPE,
    Credential: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredUnmarshalCredentialA(
    MarshaledCredential: ?[*:0]const u8,
    CredType: ?*CRED_MARSHAL_TYPE,
    Credential: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredIsMarshaledCredentialW(
    MarshaledCredential: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredIsMarshaledCredentialA(
    MarshaledCredential: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "credui" fn CredUnPackAuthenticationBufferW(
    dwFlags: CRED_PACK_FLAGS,
    // TODO: what to do with BytesParamIndex 2?
    pAuthBuffer: ?*anyopaque,
    cbAuthBuffer: u32,
    pszUserName: ?[*:0]u16,
    pcchMaxUserName: ?*u32,
    pszDomainName: ?[*:0]u16,
    pcchMaxDomainName: ?*u32,
    pszPassword: ?[*:0]u16,
    pcchMaxPassword: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "credui" fn CredUnPackAuthenticationBufferA(
    dwFlags: CRED_PACK_FLAGS,
    // TODO: what to do with BytesParamIndex 2?
    pAuthBuffer: ?*anyopaque,
    cbAuthBuffer: u32,
    pszUserName: ?[*:0]u8,
    pcchlMaxUserName: ?*u32,
    pszDomainName: ?[*:0]u8,
    pcchMaxDomainName: ?*u32,
    pszPassword: ?[*:0]u8,
    pcchMaxPassword: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "credui" fn CredPackAuthenticationBufferW(
    dwFlags: CRED_PACK_FLAGS,
    pszUserName: ?PWSTR,
    pszPassword: ?PWSTR,
    // TODO: what to do with BytesParamIndex 4?
    pPackedCredentials: ?*u8,
    pcbPackedCredentials: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "credui" fn CredPackAuthenticationBufferA(
    dwFlags: CRED_PACK_FLAGS,
    pszUserName: ?PSTR,
    pszPassword: ?PSTR,
    // TODO: what to do with BytesParamIndex 4?
    pPackedCredentials: ?*u8,
    pcbPackedCredentials: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn CredProtectW(
    fAsSelf: BOOL,
    pszCredentials: [*:0]u16,
    cchCredentials: u32,
    pszProtectedCredentials: [*:0]u16,
    pcchMaxChars: ?*u32,
    ProtectionType: ?*CRED_PROTECTION_TYPE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn CredProtectA(
    fAsSelf: BOOL,
    pszCredentials: [*:0]u8,
    cchCredentials: u32,
    pszProtectedCredentials: [*:0]u8,
    pcchMaxChars: ?*u32,
    ProtectionType: ?*CRED_PROTECTION_TYPE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn CredUnprotectW(
    fAsSelf: BOOL,
    pszProtectedCredentials: [*:0]u16,
    cchProtectedCredentials: u32,
    pszCredentials: ?[*:0]u16,
    pcchMaxChars: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn CredUnprotectA(
    fAsSelf: BOOL,
    pszProtectedCredentials: [*:0]u8,
    cchProtectedCredentials: u32,
    pszCredentials: ?[*:0]u8,
    pcchMaxChars: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn CredIsProtectedW(
    pszProtectedCredentials: ?PWSTR,
    pProtectionType: ?*CRED_PROTECTION_TYPE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn CredIsProtectedA(
    pszProtectedCredentials: ?PSTR,
    pProtectionType: ?*CRED_PROTECTION_TYPE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn CredFindBestCredentialW(
    TargetName: ?[*:0]const u16,
    Type: u32,
    Flags: u32,
    Credential: ?*?*CREDENTIALW,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn CredFindBestCredentialA(
    TargetName: ?[*:0]const u8,
    Type: u32,
    Flags: u32,
    Credential: ?*?*CREDENTIALA,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredGetSessionTypes(
    MaximumPersistCount: u32,
    MaximumPersist: [*]u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CredFree(
    Buffer: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "credui" fn CredUIPromptForCredentialsW(
    pUiInfo: ?*CREDUI_INFOW,
    pszTargetName: ?[*:0]const u16,
    pContext: ?*SecHandle,
    dwAuthError: u32,
    pszUserName: [*:0]u16,
    ulUserNameBufferSize: u32,
    pszPassword: [*:0]u16,
    ulPasswordBufferSize: u32,
    save: ?*BOOL,
    dwFlags: CREDUI_FLAGS,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "credui" fn CredUIPromptForCredentialsA(
    pUiInfo: ?*CREDUI_INFOA,
    pszTargetName: ?[*:0]const u8,
    pContext: ?*SecHandle,
    dwAuthError: u32,
    pszUserName: [*:0]u8,
    ulUserNameBufferSize: u32,
    pszPassword: [*:0]u8,
    ulPasswordBufferSize: u32,
    save: ?*BOOL,
    dwFlags: CREDUI_FLAGS,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "credui" fn CredUIPromptForWindowsCredentialsW(
    pUiInfo: ?*CREDUI_INFOW,
    dwAuthError: u32,
    pulAuthPackage: ?*u32,
    // TODO: what to do with BytesParamIndex 4?
    pvInAuthBuffer: ?*const anyopaque,
    ulInAuthBufferSize: u32,
    // TODO: what to do with BytesParamIndex 6?
    ppvOutAuthBuffer: ?*?*anyopaque,
    pulOutAuthBufferSize: ?*u32,
    pfSave: ?*BOOL,
    dwFlags: CREDUIWIN_FLAGS,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "credui" fn CredUIPromptForWindowsCredentialsA(
    pUiInfo: ?*CREDUI_INFOA,
    dwAuthError: u32,
    pulAuthPackage: ?*u32,
    // TODO: what to do with BytesParamIndex 4?
    pvInAuthBuffer: ?*const anyopaque,
    ulInAuthBufferSize: u32,
    // TODO: what to do with BytesParamIndex 6?
    ppvOutAuthBuffer: ?*?*anyopaque,
    pulOutAuthBufferSize: ?*u32,
    pfSave: ?*BOOL,
    dwFlags: CREDUIWIN_FLAGS,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "credui" fn CredUIParseUserNameW(
    UserName: ?[*:0]const u16,
    user: [*:0]u16,
    userBufferSize: u32,
    domain: [*:0]u16,
    domainBufferSize: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "credui" fn CredUIParseUserNameA(
    userName: ?[*:0]const u8,
    user: [*:0]u8,
    userBufferSize: u32,
    domain: [*:0]u8,
    domainBufferSize: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "credui" fn CredUICmdLinePromptForCredentialsW(
    pszTargetName: ?[*:0]const u16,
    pContext: ?*SecHandle,
    dwAuthError: u32,
    UserName: [*:0]u16,
    ulUserBufferSize: u32,
    pszPassword: [*:0]u16,
    ulPasswordBufferSize: u32,
    pfSave: ?*BOOL,
    dwFlags: CREDUI_FLAGS,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "credui" fn CredUICmdLinePromptForCredentialsA(
    pszTargetName: ?[*:0]const u8,
    pContext: ?*SecHandle,
    dwAuthError: u32,
    UserName: [*:0]u8,
    ulUserBufferSize: u32,
    pszPassword: [*:0]u8,
    ulPasswordBufferSize: u32,
    pfSave: ?*BOOL,
    dwFlags: CREDUI_FLAGS,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "credui" fn CredUIConfirmCredentialsW(
    pszTargetName: ?[*:0]const u16,
    bConfirm: BOOL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "credui" fn CredUIConfirmCredentialsA(
    pszTargetName: ?[*:0]const u8,
    bConfirm: BOOL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "credui" fn CredUIStoreSSOCredW(
    pszRealm: ?[*:0]const u16,
    pszUsername: ?[*:0]const u16,
    pszPassword: ?[*:0]const u16,
    bPersist: BOOL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "credui" fn CredUIReadSSOCredW(
    pszRealm: ?[*:0]const u16,
    ppszUsername: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardEstablishContext(
    dwScope: SCARD_SCOPE,
    pvReserved1: ?*const anyopaque,
    pvReserved2: ?*const anyopaque,
    phContext: ?*usize,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardReleaseContext(
    hContext: usize,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardIsValidContext(
    hContext: usize,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardListReaderGroupsA(
    hContext: usize,
    mszGroups: ?[*:0]u8,
    pcchGroups: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardListReaderGroupsW(
    hContext: usize,
    mszGroups: ?[*:0]u16,
    pcchGroups: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardListReadersA(
    hContext: usize,
    mszGroups: ?[*:0]const u8,
    mszReaders: ?PSTR,
    pcchReaders: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardListReadersW(
    hContext: usize,
    mszGroups: ?[*:0]const u16,
    mszReaders: ?PWSTR,
    pcchReaders: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardListCardsA(
    hContext: usize,
    pbAtr: ?*u8,
    rgquidInterfaces: ?[*]const Guid,
    cguidInterfaceCount: u32,
    mszCards: ?PSTR,
    pcchCards: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardListCardsW(
    hContext: usize,
    pbAtr: ?*u8,
    rgquidInterfaces: ?[*]const Guid,
    cguidInterfaceCount: u32,
    mszCards: ?PWSTR,
    pcchCards: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardListInterfacesA(
    hContext: usize,
    szCard: ?[*:0]const u8,
    pguidInterfaces: ?*Guid,
    pcguidInterfaces: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardListInterfacesW(
    hContext: usize,
    szCard: ?[*:0]const u16,
    pguidInterfaces: ?*Guid,
    pcguidInterfaces: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardGetProviderIdA(
    hContext: usize,
    szCard: ?[*:0]const u8,
    pguidProviderId: ?*Guid,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardGetProviderIdW(
    hContext: usize,
    szCard: ?[*:0]const u16,
    pguidProviderId: ?*Guid,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardGetCardTypeProviderNameA(
    hContext: usize,
    szCardName: ?[*:0]const u8,
    dwProviderId: u32,
    szProvider: [*:0]u8,
    pcchProvider: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardGetCardTypeProviderNameW(
    hContext: usize,
    szCardName: ?[*:0]const u16,
    dwProviderId: u32,
    szProvider: [*:0]u16,
    pcchProvider: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardIntroduceReaderGroupA(
    hContext: usize,
    szGroupName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardIntroduceReaderGroupW(
    hContext: usize,
    szGroupName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardForgetReaderGroupA(
    hContext: usize,
    szGroupName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardForgetReaderGroupW(
    hContext: usize,
    szGroupName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardIntroduceReaderA(
    hContext: usize,
    szReaderName: ?[*:0]const u8,
    szDeviceName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardIntroduceReaderW(
    hContext: usize,
    szReaderName: ?[*:0]const u16,
    szDeviceName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardForgetReaderA(
    hContext: usize,
    szReaderName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardForgetReaderW(
    hContext: usize,
    szReaderName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardAddReaderToGroupA(
    hContext: usize,
    szReaderName: ?[*:0]const u8,
    szGroupName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardAddReaderToGroupW(
    hContext: usize,
    szReaderName: ?[*:0]const u16,
    szGroupName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardRemoveReaderFromGroupA(
    hContext: usize,
    szReaderName: ?[*:0]const u8,
    szGroupName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardRemoveReaderFromGroupW(
    hContext: usize,
    szReaderName: ?[*:0]const u16,
    szGroupName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardIntroduceCardTypeA(
    hContext: usize,
    szCardName: ?[*:0]const u8,
    pguidPrimaryProvider: ?*const Guid,
    rgguidInterfaces: ?*const Guid,
    dwInterfaceCount: u32,
    pbAtr: ?*u8,
    pbAtrMask: ?*u8,
    cbAtrLen: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardIntroduceCardTypeW(
    hContext: usize,
    szCardName: ?[*:0]const u16,
    pguidPrimaryProvider: ?*const Guid,
    rgguidInterfaces: ?*const Guid,
    dwInterfaceCount: u32,
    pbAtr: ?*u8,
    pbAtrMask: ?*u8,
    cbAtrLen: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardSetCardTypeProviderNameA(
    hContext: usize,
    szCardName: ?[*:0]const u8,
    dwProviderId: u32,
    szProvider: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardSetCardTypeProviderNameW(
    hContext: usize,
    szCardName: ?[*:0]const u16,
    dwProviderId: u32,
    szProvider: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardForgetCardTypeA(
    hContext: usize,
    szCardName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardForgetCardTypeW(
    hContext: usize,
    szCardName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardFreeMemory(
    hContext: usize,
    pvMem: ?*const anyopaque,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardAccessStartedEvent() callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardReleaseStartedEvent() callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardLocateCardsA(
    hContext: usize,
    mszCards: ?[*:0]const u8,
    rgReaderStates: ?*SCARD_READERSTATEA,
    cReaders: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardLocateCardsW(
    hContext: usize,
    mszCards: ?[*:0]const u16,
    rgReaderStates: ?*SCARD_READERSTATEW,
    cReaders: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardLocateCardsByATRA(
    hContext: usize,
    rgAtrMasks: ?*SCARD_ATRMASK,
    cAtrs: u32,
    rgReaderStates: ?*SCARD_READERSTATEA,
    cReaders: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardLocateCardsByATRW(
    hContext: usize,
    rgAtrMasks: ?*SCARD_ATRMASK,
    cAtrs: u32,
    rgReaderStates: ?*SCARD_READERSTATEW,
    cReaders: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardGetStatusChangeA(
    hContext: usize,
    dwTimeout: u32,
    rgReaderStates: ?*SCARD_READERSTATEA,
    cReaders: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardGetStatusChangeW(
    hContext: usize,
    dwTimeout: u32,
    rgReaderStates: ?*SCARD_READERSTATEW,
    cReaders: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardCancel(
    hContext: usize,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardConnectA(
    hContext: usize,
    szReader: ?[*:0]const u8,
    dwShareMode: u32,
    dwPreferredProtocols: u32,
    phCard: ?*usize,
    pdwActiveProtocol: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardConnectW(
    hContext: usize,
    szReader: ?[*:0]const u16,
    dwShareMode: u32,
    dwPreferredProtocols: u32,
    phCard: ?*usize,
    pdwActiveProtocol: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardReconnect(
    hCard: usize,
    dwShareMode: u32,
    dwPreferredProtocols: u32,
    dwInitialization: u32,
    pdwActiveProtocol: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardDisconnect(
    hCard: usize,
    dwDisposition: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardBeginTransaction(
    hCard: usize,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardEndTransaction(
    hCard: usize,
    dwDisposition: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

pub extern "winscard" fn SCardState(
    hCard: usize,
    pdwState: ?*u32,
    pdwProtocol: ?*u32,
    // TODO: what to do with BytesParamIndex 4?
    pbAtr: ?*u8,
    pcbAtrLen: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardStatusA(
    hCard: usize,
    mszReaderNames: ?PSTR,
    pcchReaderLen: ?*u32,
    pdwState: ?*u32,
    pdwProtocol: ?*u32,
    pbAtr: ?*u8,
    pcbAtrLen: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardStatusW(
    hCard: usize,
    mszReaderNames: ?PWSTR,
    pcchReaderLen: ?*u32,
    pdwState: ?*u32,
    pdwProtocol: ?*u32,
    pbAtr: ?*u8,
    pcbAtrLen: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardTransmit(
    hCard: usize,
    pioSendPci: ?*SCARD_IO_REQUEST,
    // TODO: what to do with BytesParamIndex 3?
    pbSendBuffer: ?*u8,
    cbSendLength: u32,
    pioRecvPci: ?*SCARD_IO_REQUEST,
    // TODO: what to do with BytesParamIndex 6?
    pbRecvBuffer: ?*u8,
    pcbRecvLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "winscard" fn SCardGetTransmitCount(
    hCard: usize,
    pcTransmitCount: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardControl(
    hCard: usize,
    dwControlCode: u32,
    // TODO: what to do with BytesParamIndex 3?
    lpInBuffer: ?*const anyopaque,
    cbInBufferSize: u32,
    // TODO: what to do with BytesParamIndex 5?
    lpOutBuffer: ?*anyopaque,
    cbOutBufferSize: u32,
    lpBytesReturned: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardGetAttrib(
    hCard: usize,
    dwAttrId: u32,
    // TODO: what to do with BytesParamIndex 3?
    pbAttr: ?*u8,
    pcbAttrLen: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "winscard" fn SCardSetAttrib(
    hCard: usize,
    dwAttrId: u32,
    // TODO: what to do with BytesParamIndex 3?
    pbAttr: ?*u8,
    cbAttrLen: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "scarddlg" fn SCardUIDlgSelectCardA(
    param0: ?*OPENCARDNAME_EXA,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "scarddlg" fn SCardUIDlgSelectCardW(
    param0: ?*OPENCARDNAME_EXW,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "scarddlg" fn GetOpenCardNameA(
    param0: ?*OPENCARDNAMEA,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "scarddlg" fn GetOpenCardNameW(
    param0: ?*OPENCARDNAMEW,
) callconv(@import("std").os.windows.WINAPI) i32;

pub extern "scarddlg" fn SCardDlgExtendedError() callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "winscard" fn SCardReadCacheA(
    hContext: usize,
    CardIdentifier: ?*Guid,
    FreshnessCounter: u32,
    LookupName: ?PSTR,
    // TODO: what to do with BytesParamIndex 5?
    Data: ?*u8,
    DataLen: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "winscard" fn SCardReadCacheW(
    hContext: usize,
    CardIdentifier: ?*Guid,
    FreshnessCounter: u32,
    LookupName: ?PWSTR,
    // TODO: what to do with BytesParamIndex 5?
    Data: ?*u8,
    DataLen: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "winscard" fn SCardWriteCacheA(
    hContext: usize,
    CardIdentifier: ?*Guid,
    FreshnessCounter: u32,
    LookupName: ?PSTR,
    // TODO: what to do with BytesParamIndex 5?
    Data: ?*u8,
    DataLen: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "winscard" fn SCardWriteCacheW(
    hContext: usize,
    CardIdentifier: ?*Guid,
    FreshnessCounter: u32,
    LookupName: ?PWSTR,
    // TODO: what to do with BytesParamIndex 5?
    Data: ?*u8,
    DataLen: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "winscard" fn SCardGetReaderIconA(
    hContext: usize,
    szReaderName: ?[*:0]const u8,
    // TODO: what to do with BytesParamIndex 3?
    pbIcon: ?*u8,
    pcbIcon: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "winscard" fn SCardGetReaderIconW(
    hContext: usize,
    szReaderName: ?[*:0]const u16,
    // TODO: what to do with BytesParamIndex 3?
    pbIcon: ?*u8,
    pcbIcon: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "winscard" fn SCardGetDeviceTypeIdA(
    hContext: usize,
    szReaderName: ?[*:0]const u8,
    pdwDeviceTypeId: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "winscard" fn SCardGetDeviceTypeIdW(
    hContext: usize,
    szReaderName: ?[*:0]const u16,
    pdwDeviceTypeId: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "winscard" fn SCardGetReaderDeviceInstanceIdA(
    hContext: usize,
    szReaderName: ?[*:0]const u8,
    szDeviceInstanceId: ?PSTR,
    pcchDeviceInstanceId: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "winscard" fn SCardGetReaderDeviceInstanceIdW(
    hContext: usize,
    szReaderName: ?[*:0]const u16,
    szDeviceInstanceId: ?PWSTR,
    pcchDeviceInstanceId: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "winscard" fn SCardListReadersWithDeviceInstanceIdA(
    hContext: usize,
    szDeviceInstanceId: ?[*:0]const u8,
    mszReaders: ?PSTR,
    pcchReaders: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "winscard" fn SCardListReadersWithDeviceInstanceIdW(
    hContext: usize,
    szDeviceInstanceId: ?[*:0]const u16,
    mszReaders: ?PWSTR,
    pcchReaders: ?*u32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "winscard" fn SCardAudit(
    hContext: usize,
    dwEvent: u32,
) callconv(@import("std").os.windows.WINAPI) i32;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (59)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {
        pub const CREDENTIAL_ATTRIBUTE = thismodule.CREDENTIAL_ATTRIBUTEA;
        pub const CREDENTIAL = thismodule.CREDENTIALA;
        pub const CREDENTIAL_TARGET_INFORMATION = thismodule.CREDENTIAL_TARGET_INFORMATIONA;
        pub const CREDUI_INFO = thismodule.CREDUI_INFOA;
        pub const SCARD_READERSTATE = thismodule.SCARD_READERSTATEA;
        pub const LPOCNCONNPROC = thismodule.LPOCNCONNPROCA;
        pub const OPENCARD_SEARCH_CRITERIA = thismodule.OPENCARD_SEARCH_CRITERIAA;
        pub const OPENCARDNAME_EX = thismodule.OPENCARDNAME_EXA;
        pub const OPENCARDNAME = thismodule.OPENCARDNAMEA;
        pub const CredWrite = thismodule.CredWriteA;
        pub const CredRead = thismodule.CredReadA;
        pub const CredEnumerate = thismodule.CredEnumerateA;
        pub const CredWriteDomainCredentials = thismodule.CredWriteDomainCredentialsA;
        pub const CredReadDomainCredentials = thismodule.CredReadDomainCredentialsA;
        pub const CredDelete = thismodule.CredDeleteA;
        pub const CredRename = thismodule.CredRenameA;
        pub const CredGetTargetInfo = thismodule.CredGetTargetInfoA;
        pub const CredMarshalCredential = thismodule.CredMarshalCredentialA;
        pub const CredUnmarshalCredential = thismodule.CredUnmarshalCredentialA;
        pub const CredIsMarshaledCredential = thismodule.CredIsMarshaledCredentialA;
        pub const CredUnPackAuthenticationBuffer = thismodule.CredUnPackAuthenticationBufferA;
        pub const CredPackAuthenticationBuffer = thismodule.CredPackAuthenticationBufferA;
        pub const CredProtect = thismodule.CredProtectA;
        pub const CredUnprotect = thismodule.CredUnprotectA;
        pub const CredIsProtected = thismodule.CredIsProtectedA;
        pub const CredFindBestCredential = thismodule.CredFindBestCredentialA;
        pub const CredUIPromptForCredentials = thismodule.CredUIPromptForCredentialsA;
        pub const CredUIPromptForWindowsCredentials = thismodule.CredUIPromptForWindowsCredentialsA;
        pub const CredUIParseUserName = thismodule.CredUIParseUserNameA;
        pub const CredUICmdLinePromptForCredentials = thismodule.CredUICmdLinePromptForCredentialsA;
        pub const CredUIConfirmCredentials = thismodule.CredUIConfirmCredentialsA;
        pub const SCardListReaderGroups = thismodule.SCardListReaderGroupsA;
        pub const SCardListReaders = thismodule.SCardListReadersA;
        pub const SCardListCards = thismodule.SCardListCardsA;
        pub const SCardListInterfaces = thismodule.SCardListInterfacesA;
        pub const SCardGetProviderId = thismodule.SCardGetProviderIdA;
        pub const SCardGetCardTypeProviderName = thismodule.SCardGetCardTypeProviderNameA;
        pub const SCardIntroduceReaderGroup = thismodule.SCardIntroduceReaderGroupA;
        pub const SCardForgetReaderGroup = thismodule.SCardForgetReaderGroupA;
        pub const SCardIntroduceReader = thismodule.SCardIntroduceReaderA;
        pub const SCardForgetReader = thismodule.SCardForgetReaderA;
        pub const SCardAddReaderToGroup = thismodule.SCardAddReaderToGroupA;
        pub const SCardRemoveReaderFromGroup = thismodule.SCardRemoveReaderFromGroupA;
        pub const SCardIntroduceCardType = thismodule.SCardIntroduceCardTypeA;
        pub const SCardSetCardTypeProviderName = thismodule.SCardSetCardTypeProviderNameA;
        pub const SCardForgetCardType = thismodule.SCardForgetCardTypeA;
        pub const SCardLocateCards = thismodule.SCardLocateCardsA;
        pub const SCardLocateCardsByATR = thismodule.SCardLocateCardsByATRA;
        pub const SCardGetStatusChange = thismodule.SCardGetStatusChangeA;
        pub const SCardConnect = thismodule.SCardConnectA;
        pub const SCardStatus = thismodule.SCardStatusA;
        pub const SCardUIDlgSelectCard = thismodule.SCardUIDlgSelectCardA;
        pub const GetOpenCardName = thismodule.GetOpenCardNameA;
        pub const SCardReadCache = thismodule.SCardReadCacheA;
        pub const SCardWriteCache = thismodule.SCardWriteCacheA;
        pub const SCardGetReaderIcon = thismodule.SCardGetReaderIconA;
        pub const SCardGetDeviceTypeId = thismodule.SCardGetDeviceTypeIdA;
        pub const SCardGetReaderDeviceInstanceId = thismodule.SCardGetReaderDeviceInstanceIdA;
        pub const SCardListReadersWithDeviceInstanceId = thismodule.SCardListReadersWithDeviceInstanceIdA;
    },
    .wide => struct {
        pub const CREDENTIAL_ATTRIBUTE = thismodule.CREDENTIAL_ATTRIBUTEW;
        pub const CREDENTIAL = thismodule.CREDENTIALW;
        pub const CREDENTIAL_TARGET_INFORMATION = thismodule.CREDENTIAL_TARGET_INFORMATIONW;
        pub const CREDUI_INFO = thismodule.CREDUI_INFOW;
        pub const SCARD_READERSTATE = thismodule.SCARD_READERSTATEW;
        pub const LPOCNCONNPROC = thismodule.LPOCNCONNPROCW;
        pub const OPENCARD_SEARCH_CRITERIA = thismodule.OPENCARD_SEARCH_CRITERIAW;
        pub const OPENCARDNAME_EX = thismodule.OPENCARDNAME_EXW;
        pub const OPENCARDNAME = thismodule.OPENCARDNAMEW;
        pub const CredWrite = thismodule.CredWriteW;
        pub const CredRead = thismodule.CredReadW;
        pub const CredEnumerate = thismodule.CredEnumerateW;
        pub const CredWriteDomainCredentials = thismodule.CredWriteDomainCredentialsW;
        pub const CredReadDomainCredentials = thismodule.CredReadDomainCredentialsW;
        pub const CredDelete = thismodule.CredDeleteW;
        pub const CredRename = thismodule.CredRenameW;
        pub const CredGetTargetInfo = thismodule.CredGetTargetInfoW;
        pub const CredMarshalCredential = thismodule.CredMarshalCredentialW;
        pub const CredUnmarshalCredential = thismodule.CredUnmarshalCredentialW;
        pub const CredIsMarshaledCredential = thismodule.CredIsMarshaledCredentialW;
        pub const CredUnPackAuthenticationBuffer = thismodule.CredUnPackAuthenticationBufferW;
        pub const CredPackAuthenticationBuffer = thismodule.CredPackAuthenticationBufferW;
        pub const CredProtect = thismodule.CredProtectW;
        pub const CredUnprotect = thismodule.CredUnprotectW;
        pub const CredIsProtected = thismodule.CredIsProtectedW;
        pub const CredFindBestCredential = thismodule.CredFindBestCredentialW;
        pub const CredUIPromptForCredentials = thismodule.CredUIPromptForCredentialsW;
        pub const CredUIPromptForWindowsCredentials = thismodule.CredUIPromptForWindowsCredentialsW;
        pub const CredUIParseUserName = thismodule.CredUIParseUserNameW;
        pub const CredUICmdLinePromptForCredentials = thismodule.CredUICmdLinePromptForCredentialsW;
        pub const CredUIConfirmCredentials = thismodule.CredUIConfirmCredentialsW;
        pub const SCardListReaderGroups = thismodule.SCardListReaderGroupsW;
        pub const SCardListReaders = thismodule.SCardListReadersW;
        pub const SCardListCards = thismodule.SCardListCardsW;
        pub const SCardListInterfaces = thismodule.SCardListInterfacesW;
        pub const SCardGetProviderId = thismodule.SCardGetProviderIdW;
        pub const SCardGetCardTypeProviderName = thismodule.SCardGetCardTypeProviderNameW;
        pub const SCardIntroduceReaderGroup = thismodule.SCardIntroduceReaderGroupW;
        pub const SCardForgetReaderGroup = thismodule.SCardForgetReaderGroupW;
        pub const SCardIntroduceReader = thismodule.SCardIntroduceReaderW;
        pub const SCardForgetReader = thismodule.SCardForgetReaderW;
        pub const SCardAddReaderToGroup = thismodule.SCardAddReaderToGroupW;
        pub const SCardRemoveReaderFromGroup = thismodule.SCardRemoveReaderFromGroupW;
        pub const SCardIntroduceCardType = thismodule.SCardIntroduceCardTypeW;
        pub const SCardSetCardTypeProviderName = thismodule.SCardSetCardTypeProviderNameW;
        pub const SCardForgetCardType = thismodule.SCardForgetCardTypeW;
        pub const SCardLocateCards = thismodule.SCardLocateCardsW;
        pub const SCardLocateCardsByATR = thismodule.SCardLocateCardsByATRW;
        pub const SCardGetStatusChange = thismodule.SCardGetStatusChangeW;
        pub const SCardConnect = thismodule.SCardConnectW;
        pub const SCardStatus = thismodule.SCardStatusW;
        pub const SCardUIDlgSelectCard = thismodule.SCardUIDlgSelectCardW;
        pub const GetOpenCardName = thismodule.GetOpenCardNameW;
        pub const SCardReadCache = thismodule.SCardReadCacheW;
        pub const SCardWriteCache = thismodule.SCardWriteCacheW;
        pub const SCardGetReaderIcon = thismodule.SCardGetReaderIconW;
        pub const SCardGetDeviceTypeId = thismodule.SCardGetDeviceTypeIdW;
        pub const SCardGetReaderDeviceInstanceId = thismodule.SCardGetReaderDeviceInstanceIdW;
        pub const SCardListReadersWithDeviceInstanceId = thismodule.SCardListReadersWithDeviceInstanceIdW;
    },
    .unspecified => if (@import("builtin").is_test) struct {
        pub const CREDENTIAL_ATTRIBUTE = *opaque {};
        pub const CREDENTIAL = *opaque {};
        pub const CREDENTIAL_TARGET_INFORMATION = *opaque {};
        pub const CREDUI_INFO = *opaque {};
        pub const SCARD_READERSTATE = *opaque {};
        pub const LPOCNCONNPROC = *opaque {};
        pub const OPENCARD_SEARCH_CRITERIA = *opaque {};
        pub const OPENCARDNAME_EX = *opaque {};
        pub const OPENCARDNAME = *opaque {};
        pub const CredWrite = *opaque {};
        pub const CredRead = *opaque {};
        pub const CredEnumerate = *opaque {};
        pub const CredWriteDomainCredentials = *opaque {};
        pub const CredReadDomainCredentials = *opaque {};
        pub const CredDelete = *opaque {};
        pub const CredRename = *opaque {};
        pub const CredGetTargetInfo = *opaque {};
        pub const CredMarshalCredential = *opaque {};
        pub const CredUnmarshalCredential = *opaque {};
        pub const CredIsMarshaledCredential = *opaque {};
        pub const CredUnPackAuthenticationBuffer = *opaque {};
        pub const CredPackAuthenticationBuffer = *opaque {};
        pub const CredProtect = *opaque {};
        pub const CredUnprotect = *opaque {};
        pub const CredIsProtected = *opaque {};
        pub const CredFindBestCredential = *opaque {};
        pub const CredUIPromptForCredentials = *opaque {};
        pub const CredUIPromptForWindowsCredentials = *opaque {};
        pub const CredUIParseUserName = *opaque {};
        pub const CredUICmdLinePromptForCredentials = *opaque {};
        pub const CredUIConfirmCredentials = *opaque {};
        pub const SCardListReaderGroups = *opaque {};
        pub const SCardListReaders = *opaque {};
        pub const SCardListCards = *opaque {};
        pub const SCardListInterfaces = *opaque {};
        pub const SCardGetProviderId = *opaque {};
        pub const SCardGetCardTypeProviderName = *opaque {};
        pub const SCardIntroduceReaderGroup = *opaque {};
        pub const SCardForgetReaderGroup = *opaque {};
        pub const SCardIntroduceReader = *opaque {};
        pub const SCardForgetReader = *opaque {};
        pub const SCardAddReaderToGroup = *opaque {};
        pub const SCardRemoveReaderFromGroup = *opaque {};
        pub const SCardIntroduceCardType = *opaque {};
        pub const SCardSetCardTypeProviderName = *opaque {};
        pub const SCardForgetCardType = *opaque {};
        pub const SCardLocateCards = *opaque {};
        pub const SCardLocateCardsByATR = *opaque {};
        pub const SCardGetStatusChange = *opaque {};
        pub const SCardConnect = *opaque {};
        pub const SCardStatus = *opaque {};
        pub const SCardUIDlgSelectCard = *opaque {};
        pub const GetOpenCardName = *opaque {};
        pub const SCardReadCache = *opaque {};
        pub const SCardWriteCache = *opaque {};
        pub const SCardGetReaderIcon = *opaque {};
        pub const SCardGetDeviceTypeId = *opaque {};
        pub const SCardGetReaderDeviceInstanceId = *opaque {};
        pub const SCardListReadersWithDeviceInstanceId = *opaque {};
    } else struct {
        pub const CREDENTIAL_ATTRIBUTE = @compileError("'CREDENTIAL_ATTRIBUTE' requires that UNICODE be set to true or false in the root module");
        pub const CREDENTIAL = @compileError("'CREDENTIAL' requires that UNICODE be set to true or false in the root module");
        pub const CREDENTIAL_TARGET_INFORMATION = @compileError("'CREDENTIAL_TARGET_INFORMATION' requires that UNICODE be set to true or false in the root module");
        pub const CREDUI_INFO = @compileError("'CREDUI_INFO' requires that UNICODE be set to true or false in the root module");
        pub const SCARD_READERSTATE = @compileError("'SCARD_READERSTATE' requires that UNICODE be set to true or false in the root module");
        pub const LPOCNCONNPROC = @compileError("'LPOCNCONNPROC' requires that UNICODE be set to true or false in the root module");
        pub const OPENCARD_SEARCH_CRITERIA = @compileError("'OPENCARD_SEARCH_CRITERIA' requires that UNICODE be set to true or false in the root module");
        pub const OPENCARDNAME_EX = @compileError("'OPENCARDNAME_EX' requires that UNICODE be set to true or false in the root module");
        pub const OPENCARDNAME = @compileError("'OPENCARDNAME' requires that UNICODE be set to true or false in the root module");
        pub const CredWrite = @compileError("'CredWrite' requires that UNICODE be set to true or false in the root module");
        pub const CredRead = @compileError("'CredRead' requires that UNICODE be set to true or false in the root module");
        pub const CredEnumerate = @compileError("'CredEnumerate' requires that UNICODE be set to true or false in the root module");
        pub const CredWriteDomainCredentials = @compileError("'CredWriteDomainCredentials' requires that UNICODE be set to true or false in the root module");
        pub const CredReadDomainCredentials = @compileError("'CredReadDomainCredentials' requires that UNICODE be set to true or false in the root module");
        pub const CredDelete = @compileError("'CredDelete' requires that UNICODE be set to true or false in the root module");
        pub const CredRename = @compileError("'CredRename' requires that UNICODE be set to true or false in the root module");
        pub const CredGetTargetInfo = @compileError("'CredGetTargetInfo' requires that UNICODE be set to true or false in the root module");
        pub const CredMarshalCredential = @compileError("'CredMarshalCredential' requires that UNICODE be set to true or false in the root module");
        pub const CredUnmarshalCredential = @compileError("'CredUnmarshalCredential' requires that UNICODE be set to true or false in the root module");
        pub const CredIsMarshaledCredential = @compileError("'CredIsMarshaledCredential' requires that UNICODE be set to true or false in the root module");
        pub const CredUnPackAuthenticationBuffer = @compileError("'CredUnPackAuthenticationBuffer' requires that UNICODE be set to true or false in the root module");
        pub const CredPackAuthenticationBuffer = @compileError("'CredPackAuthenticationBuffer' requires that UNICODE be set to true or false in the root module");
        pub const CredProtect = @compileError("'CredProtect' requires that UNICODE be set to true or false in the root module");
        pub const CredUnprotect = @compileError("'CredUnprotect' requires that UNICODE be set to true or false in the root module");
        pub const CredIsProtected = @compileError("'CredIsProtected' requires that UNICODE be set to true or false in the root module");
        pub const CredFindBestCredential = @compileError("'CredFindBestCredential' requires that UNICODE be set to true or false in the root module");
        pub const CredUIPromptForCredentials = @compileError("'CredUIPromptForCredentials' requires that UNICODE be set to true or false in the root module");
        pub const CredUIPromptForWindowsCredentials = @compileError("'CredUIPromptForWindowsCredentials' requires that UNICODE be set to true or false in the root module");
        pub const CredUIParseUserName = @compileError("'CredUIParseUserName' requires that UNICODE be set to true or false in the root module");
        pub const CredUICmdLinePromptForCredentials = @compileError("'CredUICmdLinePromptForCredentials' requires that UNICODE be set to true or false in the root module");
        pub const CredUIConfirmCredentials = @compileError("'CredUIConfirmCredentials' requires that UNICODE be set to true or false in the root module");
        pub const SCardListReaderGroups = @compileError("'SCardListReaderGroups' requires that UNICODE be set to true or false in the root module");
        pub const SCardListReaders = @compileError("'SCardListReaders' requires that UNICODE be set to true or false in the root module");
        pub const SCardListCards = @compileError("'SCardListCards' requires that UNICODE be set to true or false in the root module");
        pub const SCardListInterfaces = @compileError("'SCardListInterfaces' requires that UNICODE be set to true or false in the root module");
        pub const SCardGetProviderId = @compileError("'SCardGetProviderId' requires that UNICODE be set to true or false in the root module");
        pub const SCardGetCardTypeProviderName = @compileError("'SCardGetCardTypeProviderName' requires that UNICODE be set to true or false in the root module");
        pub const SCardIntroduceReaderGroup = @compileError("'SCardIntroduceReaderGroup' requires that UNICODE be set to true or false in the root module");
        pub const SCardForgetReaderGroup = @compileError("'SCardForgetReaderGroup' requires that UNICODE be set to true or false in the root module");
        pub const SCardIntroduceReader = @compileError("'SCardIntroduceReader' requires that UNICODE be set to true or false in the root module");
        pub const SCardForgetReader = @compileError("'SCardForgetReader' requires that UNICODE be set to true or false in the root module");
        pub const SCardAddReaderToGroup = @compileError("'SCardAddReaderToGroup' requires that UNICODE be set to true or false in the root module");
        pub const SCardRemoveReaderFromGroup = @compileError("'SCardRemoveReaderFromGroup' requires that UNICODE be set to true or false in the root module");
        pub const SCardIntroduceCardType = @compileError("'SCardIntroduceCardType' requires that UNICODE be set to true or false in the root module");
        pub const SCardSetCardTypeProviderName = @compileError("'SCardSetCardTypeProviderName' requires that UNICODE be set to true or false in the root module");
        pub const SCardForgetCardType = @compileError("'SCardForgetCardType' requires that UNICODE be set to true or false in the root module");
        pub const SCardLocateCards = @compileError("'SCardLocateCards' requires that UNICODE be set to true or false in the root module");
        pub const SCardLocateCardsByATR = @compileError("'SCardLocateCardsByATR' requires that UNICODE be set to true or false in the root module");
        pub const SCardGetStatusChange = @compileError("'SCardGetStatusChange' requires that UNICODE be set to true or false in the root module");
        pub const SCardConnect = @compileError("'SCardConnect' requires that UNICODE be set to true or false in the root module");
        pub const SCardStatus = @compileError("'SCardStatus' requires that UNICODE be set to true or false in the root module");
        pub const SCardUIDlgSelectCard = @compileError("'SCardUIDlgSelectCard' requires that UNICODE be set to true or false in the root module");
        pub const GetOpenCardName = @compileError("'GetOpenCardName' requires that UNICODE be set to true or false in the root module");
        pub const SCardReadCache = @compileError("'SCardReadCache' requires that UNICODE be set to true or false in the root module");
        pub const SCardWriteCache = @compileError("'SCardWriteCache' requires that UNICODE be set to true or false in the root module");
        pub const SCardGetReaderIcon = @compileError("'SCardGetReaderIcon' requires that UNICODE be set to true or false in the root module");
        pub const SCardGetDeviceTypeId = @compileError("'SCardGetDeviceTypeId' requires that UNICODE be set to true or false in the root module");
        pub const SCardGetReaderDeviceInstanceId = @compileError("'SCardGetReaderDeviceInstanceId' requires that UNICODE be set to true or false in the root module");
        pub const SCardListReadersWithDeviceInstanceId = @compileError("'SCardListReadersWithDeviceInstanceId' requires that UNICODE be set to true or false in the root module");
    },
};
//--------------------------------------------------------------------------------
// Section: Imports (11)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const FILETIME = @import("../foundation.zig").FILETIME;
const HANDLE = @import("../foundation.zig").HANDLE;
const HBITMAP = @import("../graphics/gdi.zig").HBITMAP;
const HICON = @import("../ui/windows_and_messaging.zig").HICON;
const HRESULT = @import("../foundation.zig").HRESULT;
const HWND = @import("../foundation.zig").HWND;
const NTSTATUS = @import("../foundation.zig").NTSTATUS;
const PSTR = @import("../foundation.zig").PSTR;
const PWSTR = @import("../foundation.zig").PWSTR;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "LPOCNCONNPROCA")) {
        _ = LPOCNCONNPROCA;
    }
    if (@hasDecl(@This(), "LPOCNCONNPROCW")) {
        _ = LPOCNCONNPROCW;
    }
    if (@hasDecl(@This(), "LPOCNCHKPROC")) {
        _ = LPOCNCHKPROC;
    }
    if (@hasDecl(@This(), "LPOCNDSCPROC")) {
        _ = LPOCNDSCPROC;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
