//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (131)
//--------------------------------------------------------------------------------
pub const SDDL_REVISION_1 = @as(u32, 1);
pub const SDDL_REVISION = @as(u32, 1);
pub const SDDL_ALIAS_SIZE = @as(u32, 2);
pub const INHERITED_ACCESS_ENTRY = @as(u32, 16);
pub const INHERITED_PARENT = @as(u32, 268435456);
pub const INHERITED_GRANDPARENT = @as(u32, 536870912);
pub const TRUSTEE_ACCESS_ALLOWED = @as(i32, 1);
pub const TRUSTEE_ACCESS_READ = @as(i32, 2);
pub const TRUSTEE_ACCESS_WRITE = @as(i32, 4);
pub const TRUSTEE_ACCESS_EXPLICIT = @as(i32, 1);
pub const TRUSTEE_ACCESS_ALL = @as(i32, -1);
pub const ACTRL_RESERVED = @as(u32, 0);
pub const ACTRL_PERM_1 = @as(u32, 1);
pub const ACTRL_PERM_2 = @as(u32, 2);
pub const ACTRL_PERM_3 = @as(u32, 4);
pub const ACTRL_PERM_4 = @as(u32, 8);
pub const ACTRL_PERM_5 = @as(u32, 16);
pub const ACTRL_PERM_6 = @as(u32, 32);
pub const ACTRL_PERM_7 = @as(u32, 64);
pub const ACTRL_PERM_8 = @as(u32, 128);
pub const ACTRL_PERM_9 = @as(u32, 256);
pub const ACTRL_PERM_10 = @as(u32, 512);
pub const ACTRL_PERM_11 = @as(u32, 1024);
pub const ACTRL_PERM_12 = @as(u32, 2048);
pub const ACTRL_PERM_13 = @as(u32, 4096);
pub const ACTRL_PERM_14 = @as(u32, 8192);
pub const ACTRL_PERM_15 = @as(u32, 16384);
pub const ACTRL_PERM_16 = @as(u32, 32768);
pub const ACTRL_PERM_17 = @as(u32, 65536);
pub const ACTRL_PERM_18 = @as(u32, 131072);
pub const ACTRL_PERM_19 = @as(u32, 262144);
pub const ACTRL_PERM_20 = @as(u32, 524288);
pub const ACTRL_ACCESS_PROTECTED = @as(u32, 1);
pub const ACTRL_SYSTEM_ACCESS = @as(u32, 67108864);
pub const ACTRL_DELETE = @as(u32, 134217728);
pub const ACTRL_READ_CONTROL = @as(u32, 268435456);
pub const ACTRL_CHANGE_ACCESS = @as(u32, 536870912);
pub const ACTRL_CHANGE_OWNER = @as(u32, 1073741824);
pub const ACTRL_SYNCHRONIZE = @as(u32, 2147483648);
pub const ACTRL_STD_RIGHTS_ALL = @as(u32, 4160749568);
pub const ACTRL_FILE_READ = @as(u32, 1);
pub const ACTRL_FILE_WRITE = @as(u32, 2);
pub const ACTRL_FILE_APPEND = @as(u32, 4);
pub const ACTRL_FILE_READ_PROP = @as(u32, 8);
pub const ACTRL_FILE_WRITE_PROP = @as(u32, 16);
pub const ACTRL_FILE_EXECUTE = @as(u32, 32);
pub const ACTRL_FILE_READ_ATTRIB = @as(u32, 128);
pub const ACTRL_FILE_WRITE_ATTRIB = @as(u32, 256);
pub const ACTRL_FILE_CREATE_PIPE = @as(u32, 512);
pub const ACTRL_DIR_LIST = @as(u32, 1);
pub const ACTRL_DIR_CREATE_OBJECT = @as(u32, 2);
pub const ACTRL_DIR_CREATE_CHILD = @as(u32, 4);
pub const ACTRL_DIR_DELETE_CHILD = @as(u32, 64);
pub const ACTRL_DIR_TRAVERSE = @as(u32, 32);
pub const ACTRL_KERNEL_TERMINATE = @as(u32, 1);
pub const ACTRL_KERNEL_THREAD = @as(u32, 2);
pub const ACTRL_KERNEL_VM = @as(u32, 4);
pub const ACTRL_KERNEL_VM_READ = @as(u32, 8);
pub const ACTRL_KERNEL_VM_WRITE = @as(u32, 16);
pub const ACTRL_KERNEL_DUP_HANDLE = @as(u32, 32);
pub const ACTRL_KERNEL_PROCESS = @as(u32, 64);
pub const ACTRL_KERNEL_SET_INFO = @as(u32, 128);
pub const ACTRL_KERNEL_GET_INFO = @as(u32, 256);
pub const ACTRL_KERNEL_CONTROL = @as(u32, 512);
pub const ACTRL_KERNEL_ALERT = @as(u32, 1024);
pub const ACTRL_KERNEL_GET_CONTEXT = @as(u32, 2048);
pub const ACTRL_KERNEL_SET_CONTEXT = @as(u32, 4096);
pub const ACTRL_KERNEL_TOKEN = @as(u32, 8192);
pub const ACTRL_KERNEL_IMPERSONATE = @as(u32, 16384);
pub const ACTRL_KERNEL_DIMPERSONATE = @as(u32, 32768);
pub const ACTRL_PRINT_SADMIN = @as(u32, 1);
pub const ACTRL_PRINT_SLIST = @as(u32, 2);
pub const ACTRL_PRINT_PADMIN = @as(u32, 4);
pub const ACTRL_PRINT_PUSE = @as(u32, 8);
pub const ACTRL_PRINT_JADMIN = @as(u32, 16);
pub const ACTRL_SVC_GET_INFO = @as(u32, 1);
pub const ACTRL_SVC_SET_INFO = @as(u32, 2);
pub const ACTRL_SVC_STATUS = @as(u32, 4);
pub const ACTRL_SVC_LIST = @as(u32, 8);
pub const ACTRL_SVC_START = @as(u32, 16);
pub const ACTRL_SVC_STOP = @as(u32, 32);
pub const ACTRL_SVC_PAUSE = @as(u32, 64);
pub const ACTRL_SVC_INTERROGATE = @as(u32, 128);
pub const ACTRL_SVC_UCONTROL = @as(u32, 256);
pub const ACTRL_REG_QUERY = @as(u32, 1);
pub const ACTRL_REG_SET = @as(u32, 2);
pub const ACTRL_REG_CREATE_CHILD = @as(u32, 4);
pub const ACTRL_REG_LIST = @as(u32, 8);
pub const ACTRL_REG_NOTIFY = @as(u32, 16);
pub const ACTRL_REG_LINK = @as(u32, 32);
pub const ACTRL_WIN_CLIPBRD = @as(u32, 1);
pub const ACTRL_WIN_GLOBAL_ATOMS = @as(u32, 2);
pub const ACTRL_WIN_CREATE = @as(u32, 4);
pub const ACTRL_WIN_LIST_DESK = @as(u32, 8);
pub const ACTRL_WIN_LIST = @as(u32, 16);
pub const ACTRL_WIN_READ_ATTRIBS = @as(u32, 32);
pub const ACTRL_WIN_WRITE_ATTRIBS = @as(u32, 64);
pub const ACTRL_WIN_SCREEN = @as(u32, 128);
pub const ACTRL_WIN_EXIT = @as(u32, 256);
pub const ACTRL_ACCESS_NO_OPTIONS = @as(u32, 0);
pub const ACTRL_ACCESS_SUPPORTS_OBJECT_ENTRIES = @as(u32, 1);
pub const AUDIT_TYPE_LEGACY = @as(u32, 1);
pub const AUDIT_TYPE_WMI = @as(u32, 2);
pub const AP_ParamTypeBits = @as(u32, 8);
pub const AP_ParamTypeMask = @as(i32, 255);
pub const _AUTHZ_SS_MAXSIZE = @as(u32, 128);
pub const APF_AuditFailure = @as(u32, 0);
pub const APF_AuditSuccess = @as(u32, 1);
pub const APF_ValidFlags = @as(u32, 1);
pub const AUTHZP_WPD_EVENT = @as(u32, 16);
pub const AUTHZ_ALLOW_MULTIPLE_SOURCE_INSTANCES = @as(u32, 1);
pub const AUTHZ_MIGRATED_LEGACY_PUBLISHER = @as(u32, 2);
pub const AUTHZ_AUDIT_INSTANCE_INFORMATION = @as(u32, 2);
pub const AUTHZ_SKIP_TOKEN_GROUPS = @as(u32, 2);
pub const AUTHZ_REQUIRE_S4U_LOGON = @as(u32, 4);
pub const AUTHZ_COMPUTE_PRIVILEGES = @as(u32, 8);
pub const AUTHZ_SECURITY_ATTRIBUTE_TYPE_INVALID = @as(u32, 0);
pub const AUTHZ_SECURITY_ATTRIBUTE_TYPE_INT64 = @as(u32, 1);
pub const AUTHZ_SECURITY_ATTRIBUTE_TYPE_UINT64 = @as(u32, 2);
pub const AUTHZ_SECURITY_ATTRIBUTE_TYPE_STRING = @as(u32, 3);
pub const AUTHZ_SECURITY_ATTRIBUTE_TYPE_FQBN = @as(u32, 4);
pub const AUTHZ_SECURITY_ATTRIBUTE_TYPE_SID = @as(u32, 5);
pub const AUTHZ_SECURITY_ATTRIBUTE_TYPE_BOOLEAN = @as(u32, 6);
pub const AUTHZ_SECURITY_ATTRIBUTE_TYPE_OCTET_STRING = @as(u32, 16);
pub const AUTHZ_SECURITY_ATTRIBUTES_INFORMATION_VERSION_V1 = @as(u32, 1);
pub const AUTHZ_SECURITY_ATTRIBUTES_INFORMATION_VERSION = @as(u32, 1);
pub const AUTHZ_RPC_INIT_INFO_CLIENT_VERSION_V1 = @as(u32, 1);
pub const AUTHZ_INIT_INFO_VERSION_V1 = @as(u32, 1);
pub const AUTHZ_WPD_CATEGORY_FLAG = @as(u32, 16);
pub const AUTHZ_FLAG_ALLOW_MULTIPLE_SOURCE_INSTANCES = @as(u32, 1);
pub const OLESCRIPT_E_SYNTAX = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147352319));

//--------------------------------------------------------------------------------
// Section: Types (112)
//--------------------------------------------------------------------------------
pub const AUTHZ_RESOURCE_MANAGER_FLAGS = enum(u32) {
    NO_AUDIT = 1,
    INITIALIZE_UNDER_IMPERSONATION = 2,
    NO_CENTRAL_ACCESS_POLICIES = 4,
    _,
    pub fn initFlags(o: struct {
        NO_AUDIT: u1 = 0,
        INITIALIZE_UNDER_IMPERSONATION: u1 = 0,
        NO_CENTRAL_ACCESS_POLICIES: u1 = 0,
    }) AUTHZ_RESOURCE_MANAGER_FLAGS {
        return @as(AUTHZ_RESOURCE_MANAGER_FLAGS, @enumFromInt((if (o.NO_AUDIT == 1) @intFromEnum(AUTHZ_RESOURCE_MANAGER_FLAGS.NO_AUDIT) else 0) | (if (o.INITIALIZE_UNDER_IMPERSONATION == 1) @intFromEnum(AUTHZ_RESOURCE_MANAGER_FLAGS.INITIALIZE_UNDER_IMPERSONATION) else 0) | (if (o.NO_CENTRAL_ACCESS_POLICIES == 1) @intFromEnum(AUTHZ_RESOURCE_MANAGER_FLAGS.NO_CENTRAL_ACCESS_POLICIES) else 0)));
    }
};
pub const AUTHZ_RM_FLAG_NO_AUDIT = AUTHZ_RESOURCE_MANAGER_FLAGS.NO_AUDIT;
pub const AUTHZ_RM_FLAG_INITIALIZE_UNDER_IMPERSONATION = AUTHZ_RESOURCE_MANAGER_FLAGS.INITIALIZE_UNDER_IMPERSONATION;
pub const AUTHZ_RM_FLAG_NO_CENTRAL_ACCESS_POLICIES = AUTHZ_RESOURCE_MANAGER_FLAGS.NO_CENTRAL_ACCESS_POLICIES;

pub const AUTHZ_ACCESS_CHECK_FLAGS = enum(u32) {
    D = 1,
};
pub const AUTHZ_ACCESS_CHECK_NO_DEEP_COPY_SD = AUTHZ_ACCESS_CHECK_FLAGS.D;

pub const AUTHZ_INITIALIZE_OBJECT_ACCESS_AUDIT_EVENT_FLAGS = enum(u32) {
    SUCCESS_AUDIT = 1,
    FAILURE_AUDIT = 2,
    ALLOC_STRINGS = 4,
};
pub const AUTHZ_NO_SUCCESS_AUDIT = AUTHZ_INITIALIZE_OBJECT_ACCESS_AUDIT_EVENT_FLAGS.SUCCESS_AUDIT;
pub const AUTHZ_NO_FAILURE_AUDIT = AUTHZ_INITIALIZE_OBJECT_ACCESS_AUDIT_EVENT_FLAGS.FAILURE_AUDIT;
pub const AUTHZ_NO_ALLOC_STRINGS = AUTHZ_INITIALIZE_OBJECT_ACCESS_AUDIT_EVENT_FLAGS.ALLOC_STRINGS;

pub const TREE_SEC_INFO = enum(u32) {
    SET = 1,
    RESET = 2,
    RESET_KEEP_EXPLICIT = 3,
};
pub const TREE_SEC_INFO_SET = TREE_SEC_INFO.SET;
pub const TREE_SEC_INFO_RESET = TREE_SEC_INFO.RESET;
pub const TREE_SEC_INFO_RESET_KEEP_EXPLICIT = TREE_SEC_INFO.RESET_KEEP_EXPLICIT;

pub const AUTHZ_GENERATE_RESULTS = enum(u32) {
    SUCCESS_AUDIT = 1,
    FAILURE_AUDIT = 2,
};
pub const AUTHZ_GENERATE_SUCCESS_AUDIT = AUTHZ_GENERATE_RESULTS.SUCCESS_AUDIT;
pub const AUTHZ_GENERATE_FAILURE_AUDIT = AUTHZ_GENERATE_RESULTS.FAILURE_AUDIT;

pub const ACTRL_ACCESS_ENTRY_ACCESS_FLAGS = enum(u32) {
    CCESS_ALLOWED = 1,
    CCESS_DENIED = 2,
    UDIT_SUCCESS = 4,
    UDIT_FAILURE = 8,
};
pub const ACTRL_ACCESS_ALLOWED = ACTRL_ACCESS_ENTRY_ACCESS_FLAGS.CCESS_ALLOWED;
pub const ACTRL_ACCESS_DENIED = ACTRL_ACCESS_ENTRY_ACCESS_FLAGS.CCESS_DENIED;
pub const ACTRL_AUDIT_SUCCESS = ACTRL_ACCESS_ENTRY_ACCESS_FLAGS.UDIT_SUCCESS;
pub const ACTRL_AUDIT_FAILURE = ACTRL_ACCESS_ENTRY_ACCESS_FLAGS.UDIT_FAILURE;

pub const AUTHZ_SECURITY_ATTRIBUTE_FLAGS = enum(u32) {
    NON_INHERITABLE = 1,
    VALUE_CASE_SENSITIVE = 2,
    _,
    pub fn initFlags(o: struct {
        NON_INHERITABLE: u1 = 0,
        VALUE_CASE_SENSITIVE: u1 = 0,
    }) AUTHZ_SECURITY_ATTRIBUTE_FLAGS {
        return @as(AUTHZ_SECURITY_ATTRIBUTE_FLAGS, @enumFromInt((if (o.NON_INHERITABLE == 1) @intFromEnum(AUTHZ_SECURITY_ATTRIBUTE_FLAGS.NON_INHERITABLE) else 0) | (if (o.VALUE_CASE_SENSITIVE == 1) @intFromEnum(AUTHZ_SECURITY_ATTRIBUTE_FLAGS.VALUE_CASE_SENSITIVE) else 0)));
    }
};
pub const AUTHZ_SECURITY_ATTRIBUTE_NON_INHERITABLE = AUTHZ_SECURITY_ATTRIBUTE_FLAGS.NON_INHERITABLE;
pub const AUTHZ_SECURITY_ATTRIBUTE_VALUE_CASE_SENSITIVE = AUTHZ_SECURITY_ATTRIBUTE_FLAGS.VALUE_CASE_SENSITIVE;

pub const SE_OBJECT_TYPE = enum(i32) {
    UNKNOWN_OBJECT_TYPE = 0,
    FILE_OBJECT = 1,
    SERVICE = 2,
    PRINTER = 3,
    REGISTRY_KEY = 4,
    LMSHARE = 5,
    KERNEL_OBJECT = 6,
    WINDOW_OBJECT = 7,
    DS_OBJECT = 8,
    DS_OBJECT_ALL = 9,
    PROVIDER_DEFINED_OBJECT = 10,
    WMIGUID_OBJECT = 11,
    REGISTRY_WOW64_32KEY = 12,
    REGISTRY_WOW64_64KEY = 13,
};
pub const SE_UNKNOWN_OBJECT_TYPE = SE_OBJECT_TYPE.UNKNOWN_OBJECT_TYPE;
pub const SE_FILE_OBJECT = SE_OBJECT_TYPE.FILE_OBJECT;
pub const SE_SERVICE = SE_OBJECT_TYPE.SERVICE;
pub const SE_PRINTER = SE_OBJECT_TYPE.PRINTER;
pub const SE_REGISTRY_KEY = SE_OBJECT_TYPE.REGISTRY_KEY;
pub const SE_LMSHARE = SE_OBJECT_TYPE.LMSHARE;
pub const SE_KERNEL_OBJECT = SE_OBJECT_TYPE.KERNEL_OBJECT;
pub const SE_WINDOW_OBJECT = SE_OBJECT_TYPE.WINDOW_OBJECT;
pub const SE_DS_OBJECT = SE_OBJECT_TYPE.DS_OBJECT;
pub const SE_DS_OBJECT_ALL = SE_OBJECT_TYPE.DS_OBJECT_ALL;
pub const SE_PROVIDER_DEFINED_OBJECT = SE_OBJECT_TYPE.PROVIDER_DEFINED_OBJECT;
pub const SE_WMIGUID_OBJECT = SE_OBJECT_TYPE.WMIGUID_OBJECT;
pub const SE_REGISTRY_WOW64_32KEY = SE_OBJECT_TYPE.REGISTRY_WOW64_32KEY;
pub const SE_REGISTRY_WOW64_64KEY = SE_OBJECT_TYPE.REGISTRY_WOW64_64KEY;

pub const TRUSTEE_TYPE = enum(i32) {
    UNKNOWN = 0,
    USER = 1,
    GROUP = 2,
    DOMAIN = 3,
    ALIAS = 4,
    WELL_KNOWN_GROUP = 5,
    DELETED = 6,
    INVALID = 7,
    COMPUTER = 8,
};
pub const TRUSTEE_IS_UNKNOWN = TRUSTEE_TYPE.UNKNOWN;
pub const TRUSTEE_IS_USER = TRUSTEE_TYPE.USER;
pub const TRUSTEE_IS_GROUP = TRUSTEE_TYPE.GROUP;
pub const TRUSTEE_IS_DOMAIN = TRUSTEE_TYPE.DOMAIN;
pub const TRUSTEE_IS_ALIAS = TRUSTEE_TYPE.ALIAS;
pub const TRUSTEE_IS_WELL_KNOWN_GROUP = TRUSTEE_TYPE.WELL_KNOWN_GROUP;
pub const TRUSTEE_IS_DELETED = TRUSTEE_TYPE.DELETED;
pub const TRUSTEE_IS_INVALID = TRUSTEE_TYPE.INVALID;
pub const TRUSTEE_IS_COMPUTER = TRUSTEE_TYPE.COMPUTER;

pub const TRUSTEE_FORM = enum(i32) {
    IS_SID = 0,
    IS_NAME = 1,
    BAD_FORM = 2,
    IS_OBJECTS_AND_SID = 3,
    IS_OBJECTS_AND_NAME = 4,
};
pub const TRUSTEE_IS_SID = TRUSTEE_FORM.IS_SID;
pub const TRUSTEE_IS_NAME = TRUSTEE_FORM.IS_NAME;
pub const TRUSTEE_BAD_FORM = TRUSTEE_FORM.BAD_FORM;
pub const TRUSTEE_IS_OBJECTS_AND_SID = TRUSTEE_FORM.IS_OBJECTS_AND_SID;
pub const TRUSTEE_IS_OBJECTS_AND_NAME = TRUSTEE_FORM.IS_OBJECTS_AND_NAME;

pub const MULTIPLE_TRUSTEE_OPERATION = enum(i32) {
    NO_MULTIPLE_TRUSTEE = 0,
    TRUSTEE_IS_IMPERSONATE = 1,
};
pub const NO_MULTIPLE_TRUSTEE = MULTIPLE_TRUSTEE_OPERATION.NO_MULTIPLE_TRUSTEE;
pub const TRUSTEE_IS_IMPERSONATE = MULTIPLE_TRUSTEE_OPERATION.TRUSTEE_IS_IMPERSONATE;

pub const OBJECTS_AND_SID = extern struct {
    ObjectsPresent: SYSTEM_AUDIT_OBJECT_ACE_FLAGS,
    ObjectTypeGuid: Guid,
    InheritedObjectTypeGuid: Guid,
    pSid: ?*SID,
};

pub const OBJECTS_AND_NAME_A = extern struct {
    ObjectsPresent: SYSTEM_AUDIT_OBJECT_ACE_FLAGS,
    ObjectType: SE_OBJECT_TYPE,
    ObjectTypeName: ?PSTR,
    InheritedObjectTypeName: ?PSTR,
    ptstrName: ?PSTR,
};

pub const OBJECTS_AND_NAME_W = extern struct {
    ObjectsPresent: SYSTEM_AUDIT_OBJECT_ACE_FLAGS,
    ObjectType: SE_OBJECT_TYPE,
    ObjectTypeName: ?PWSTR,
    InheritedObjectTypeName: ?PWSTR,
    ptstrName: ?PWSTR,
};

pub const TRUSTEE_A = extern struct {
    pMultipleTrustee: ?*TRUSTEE_A,
    MultipleTrusteeOperation: MULTIPLE_TRUSTEE_OPERATION,
    TrusteeForm: TRUSTEE_FORM,
    TrusteeType: TRUSTEE_TYPE,
    ptstrName: ?[*]u8,
};

pub const TRUSTEE_W = extern struct {
    pMultipleTrustee: ?*TRUSTEE_W,
    MultipleTrusteeOperation: MULTIPLE_TRUSTEE_OPERATION,
    TrusteeForm: TRUSTEE_FORM,
    TrusteeType: TRUSTEE_TYPE,
    ptstrName: ?[*]u16,
};

pub const ACCESS_MODE = enum(i32) {
    NOT_USED_ACCESS = 0,
    GRANT_ACCESS = 1,
    SET_ACCESS = 2,
    DENY_ACCESS = 3,
    REVOKE_ACCESS = 4,
    SET_AUDIT_SUCCESS = 5,
    SET_AUDIT_FAILURE = 6,
};
pub const NOT_USED_ACCESS = ACCESS_MODE.NOT_USED_ACCESS;
pub const GRANT_ACCESS = ACCESS_MODE.GRANT_ACCESS;
pub const SET_ACCESS = ACCESS_MODE.SET_ACCESS;
pub const DENY_ACCESS = ACCESS_MODE.DENY_ACCESS;
pub const REVOKE_ACCESS = ACCESS_MODE.REVOKE_ACCESS;
pub const SET_AUDIT_SUCCESS = ACCESS_MODE.SET_AUDIT_SUCCESS;
pub const SET_AUDIT_FAILURE = ACCESS_MODE.SET_AUDIT_FAILURE;

pub const EXPLICIT_ACCESS_A = extern struct {
    grfAccessPermissions: u32,
    grfAccessMode: ACCESS_MODE,
    grfInheritance: ACE_FLAGS,
    Trustee: TRUSTEE_A,
};

pub const EXPLICIT_ACCESS_W = extern struct {
    grfAccessPermissions: u32,
    grfAccessMode: ACCESS_MODE,
    grfInheritance: ACE_FLAGS,
    Trustee: TRUSTEE_W,
};

pub const ACTRL_ACCESS_ENTRYA = extern struct {
    Trustee: TRUSTEE_A,
    fAccessFlags: ACTRL_ACCESS_ENTRY_ACCESS_FLAGS,
    Access: u32,
    ProvSpecificAccess: u32,
    Inheritance: ACE_FLAGS,
    lpInheritProperty: ?PSTR,
};

pub const ACTRL_ACCESS_ENTRYW = extern struct {
    Trustee: TRUSTEE_W,
    fAccessFlags: ACTRL_ACCESS_ENTRY_ACCESS_FLAGS,
    Access: u32,
    ProvSpecificAccess: u32,
    Inheritance: ACE_FLAGS,
    lpInheritProperty: ?PWSTR,
};

pub const ACTRL_ACCESS_ENTRY_LISTA = extern struct {
    cEntries: u32,
    pAccessList: ?*ACTRL_ACCESS_ENTRYA,
};

pub const ACTRL_ACCESS_ENTRY_LISTW = extern struct {
    cEntries: u32,
    pAccessList: ?*ACTRL_ACCESS_ENTRYW,
};

pub const ACTRL_PROPERTY_ENTRYA = extern struct {
    lpProperty: ?PSTR,
    pAccessEntryList: ?*ACTRL_ACCESS_ENTRY_LISTA,
    fListFlags: u32,
};

pub const ACTRL_PROPERTY_ENTRYW = extern struct {
    lpProperty: ?PWSTR,
    pAccessEntryList: ?*ACTRL_ACCESS_ENTRY_LISTW,
    fListFlags: u32,
};

pub const ACTRL_ACCESSA = extern struct {
    cEntries: u32,
    pPropertyAccessList: ?*ACTRL_PROPERTY_ENTRYA,
};

pub const ACTRL_ACCESSW = extern struct {
    cEntries: u32,
    pPropertyAccessList: ?*ACTRL_PROPERTY_ENTRYW,
};

pub const TRUSTEE_ACCESSA = extern struct {
    lpProperty: ?PSTR,
    Access: u32,
    fAccessFlags: u32,
    fReturnedAccess: u32,
};

pub const TRUSTEE_ACCESSW = extern struct {
    lpProperty: ?PWSTR,
    Access: u32,
    fAccessFlags: u32,
    fReturnedAccess: u32,
};

pub const ACTRL_OVERLAPPED = extern struct {
    Anonymous: extern union {
        Provider: ?*anyopaque,
        Reserved1: u32,
    },
    Reserved2: u32,
    hEvent: ?HANDLE,
};

pub const ACTRL_ACCESS_INFOA = extern struct {
    fAccessPermission: u32,
    lpAccessPermissionName: ?PSTR,
};

pub const ACTRL_ACCESS_INFOW = extern struct {
    fAccessPermission: u32,
    lpAccessPermissionName: ?PWSTR,
};

pub const ACTRL_CONTROL_INFOA = extern struct {
    lpControlId: ?PSTR,
    lpControlName: ?PSTR,
};

pub const ACTRL_CONTROL_INFOW = extern struct {
    lpControlId: ?PWSTR,
    lpControlName: ?PWSTR,
};

pub const PROG_INVOKE_SETTING = enum(i32) {
    InvokeNever = 1,
    InvokeEveryObject = 2,
    InvokeOnError = 3,
    CancelOperation = 4,
    RetryOperation = 5,
    InvokePrePostError = 6,
};
pub const ProgressInvokeNever = PROG_INVOKE_SETTING.InvokeNever;
pub const ProgressInvokeEveryObject = PROG_INVOKE_SETTING.InvokeEveryObject;
pub const ProgressInvokeOnError = PROG_INVOKE_SETTING.InvokeOnError;
pub const ProgressCancelOperation = PROG_INVOKE_SETTING.CancelOperation;
pub const ProgressRetryOperation = PROG_INVOKE_SETTING.RetryOperation;
pub const ProgressInvokePrePostError = PROG_INVOKE_SETTING.InvokePrePostError;

pub const FN_OBJECT_MGR_FUNCTIONS = extern struct {
    Placeholder: u32,
};

pub const INHERITED_FROMA = extern struct {
    GenerationGap: i32,
    AncestorName: ?PSTR,
};

pub const INHERITED_FROMW = extern struct {
    GenerationGap: i32,
    AncestorName: ?PWSTR,
};

pub const AUDIT_PARAM_TYPE = enum(i32) {
    None = 1,
    String = 2,
    Ulong = 3,
    Pointer = 4,
    Sid = 5,
    LogonId = 6,
    ObjectTypeList = 7,
    Luid = 8,
    Guid = 9,
    Time = 10,
    Int64 = 11,
    IpAddress = 12,
    LogonIdWithSid = 13,
};
pub const APT_None = AUDIT_PARAM_TYPE.None;
pub const APT_String = AUDIT_PARAM_TYPE.String;
pub const APT_Ulong = AUDIT_PARAM_TYPE.Ulong;
pub const APT_Pointer = AUDIT_PARAM_TYPE.Pointer;
pub const APT_Sid = AUDIT_PARAM_TYPE.Sid;
pub const APT_LogonId = AUDIT_PARAM_TYPE.LogonId;
pub const APT_ObjectTypeList = AUDIT_PARAM_TYPE.ObjectTypeList;
pub const APT_Luid = AUDIT_PARAM_TYPE.Luid;
pub const APT_Guid = AUDIT_PARAM_TYPE.Guid;
pub const APT_Time = AUDIT_PARAM_TYPE.Time;
pub const APT_Int64 = AUDIT_PARAM_TYPE.Int64;
pub const APT_IpAddress = AUDIT_PARAM_TYPE.IpAddress;
pub const APT_LogonIdWithSid = AUDIT_PARAM_TYPE.LogonIdWithSid;

pub const AUDIT_OBJECT_TYPE = extern struct {
    ObjectType: Guid,
    Flags: u16,
    Level: u16,
    AccessMask: u32,
};

pub const AUDIT_OBJECT_TYPES = extern struct {
    Count: u16,
    Flags: u16,
    pObjectTypes: ?*AUDIT_OBJECT_TYPE,
};

pub const AUDIT_IP_ADDRESS = extern struct {
    pIpAddress: [128]u8,
};

pub const AUDIT_PARAM = extern struct {
    Type: AUDIT_PARAM_TYPE,
    Length: u32,
    Flags: u32,
    Anonymous1: extern union {
        Data0: usize,
        String: ?PWSTR,
        u: usize,
        psid: ?*SID,
        pguid: ?*Guid,
        LogonId_LowPart: u32,
        pObjectTypes: ?*AUDIT_OBJECT_TYPES,
        pIpAddress: ?*AUDIT_IP_ADDRESS,
    },
    Anonymous2: extern union {
        Data1: usize,
        LogonId_HighPart: i32,
    },
};

pub const AUDIT_PARAMS = extern struct {
    Length: u32,
    Flags: u32,
    Count: u16,
    Parameters: ?*AUDIT_PARAM,
};

pub const AUTHZ_AUDIT_EVENT_TYPE_LEGACY = extern struct {
    CategoryId: u16,
    AuditId: u16,
    ParameterCount: u16,
};

pub const AUTHZ_AUDIT_EVENT_TYPE_UNION = extern union {
    Legacy: AUTHZ_AUDIT_EVENT_TYPE_LEGACY,
};

pub const AUTHZ_AUDIT_EVENT_TYPE_OLD = extern struct {
    Version: u32,
    dwFlags: u32,
    RefCount: i32,
    hAudit: usize,
    LinkId: LUID,
    u: AUTHZ_AUDIT_EVENT_TYPE_UNION,
};

pub const AUTHZ_CAP_CHANGE_SUBSCRIPTION_HANDLE__ = extern struct {
    unused: i32,
};

pub const AUTHZ_ACCESS_REQUEST = extern struct {
    DesiredAccess: u32,
    PrincipalSelfSid: ?PSID,
    ObjectTypeList: ?*OBJECT_TYPE_LIST,
    ObjectTypeListLength: u32,
    OptionalArguments: ?*anyopaque,
};

pub const AUTHZ_ACCESS_REPLY = extern struct {
    ResultListLength: u32,
    GrantedAccessMask: ?*u32,
    SaclEvaluationResults: ?*AUTHZ_GENERATE_RESULTS,
    Error: ?*u32,
};

pub const PFN_AUTHZ_DYNAMIC_ACCESS_CHECK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        hAuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
        pAce: ?*ACE_HEADER,
        pArgs: ?*anyopaque,
        pbAceApplicable: ?*BOOL,
    ) callconv(@import("std").os.windows.WINAPI) BOOL,
    else => *const fn (
        hAuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
        pAce: ?*ACE_HEADER,
        pArgs: ?*anyopaque,
        pbAceApplicable: ?*BOOL,
    ) callconv(@import("std").os.windows.WINAPI) BOOL,
};

pub const PFN_AUTHZ_COMPUTE_DYNAMIC_GROUPS = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        hAuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
        Args: ?*anyopaque,
        pSidAttrArray: ?*?*SID_AND_ATTRIBUTES,
        pSidCount: ?*u32,
        pRestrictedSidAttrArray: ?*?*SID_AND_ATTRIBUTES,
        pRestrictedSidCount: ?*u32,
    ) callconv(@import("std").os.windows.WINAPI) BOOL,
    else => *const fn (
        hAuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
        Args: ?*anyopaque,
        pSidAttrArray: ?*?*SID_AND_ATTRIBUTES,
        pSidCount: ?*u32,
        pRestrictedSidAttrArray: ?*?*SID_AND_ATTRIBUTES,
        pRestrictedSidCount: ?*u32,
    ) callconv(@import("std").os.windows.WINAPI) BOOL,
};

pub const PFN_AUTHZ_FREE_DYNAMIC_GROUPS = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        pSidAttrArray: ?*SID_AND_ATTRIBUTES,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        pSidAttrArray: ?*SID_AND_ATTRIBUTES,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PFN_AUTHZ_GET_CENTRAL_ACCESS_POLICY = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        hAuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
        capid: ?PSID,
        pArgs: ?*anyopaque,
        pCentralAccessPolicyApplicable: ?*BOOL,
        ppCentralAccessPolicy: ?*?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) BOOL,
    else => *const fn (
        hAuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
        capid: ?PSID,
        pArgs: ?*anyopaque,
        pCentralAccessPolicyApplicable: ?*BOOL,
        ppCentralAccessPolicy: ?*?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) BOOL,
};

pub const PFN_AUTHZ_FREE_CENTRAL_ACCESS_POLICY = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        pCentralAccessPolicy: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        pCentralAccessPolicy: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const AUTHZ_SECURITY_ATTRIBUTE_FQBN_VALUE = extern struct {
    Version: u64,
    pName: ?PWSTR,
};

pub const AUTHZ_SECURITY_ATTRIBUTE_OCTET_STRING_VALUE = extern struct {
    pValue: ?*anyopaque,
    ValueLength: u32,
};

pub const AUTHZ_SECURITY_ATTRIBUTE_OPERATION = enum(i32) {
    NONE = 0,
    REPLACE_ALL = 1,
    ADD = 2,
    DELETE = 3,
    REPLACE = 4,
};
pub const AUTHZ_SECURITY_ATTRIBUTE_OPERATION_NONE = AUTHZ_SECURITY_ATTRIBUTE_OPERATION.NONE;
pub const AUTHZ_SECURITY_ATTRIBUTE_OPERATION_REPLACE_ALL = AUTHZ_SECURITY_ATTRIBUTE_OPERATION.REPLACE_ALL;
pub const AUTHZ_SECURITY_ATTRIBUTE_OPERATION_ADD = AUTHZ_SECURITY_ATTRIBUTE_OPERATION.ADD;
pub const AUTHZ_SECURITY_ATTRIBUTE_OPERATION_DELETE = AUTHZ_SECURITY_ATTRIBUTE_OPERATION.DELETE;
pub const AUTHZ_SECURITY_ATTRIBUTE_OPERATION_REPLACE = AUTHZ_SECURITY_ATTRIBUTE_OPERATION.REPLACE;

pub const AUTHZ_SID_OPERATION = enum(i32) {
    NONE = 0,
    REPLACE_ALL = 1,
    ADD = 2,
    DELETE = 3,
    REPLACE = 4,
};
pub const AUTHZ_SID_OPERATION_NONE = AUTHZ_SID_OPERATION.NONE;
pub const AUTHZ_SID_OPERATION_REPLACE_ALL = AUTHZ_SID_OPERATION.REPLACE_ALL;
pub const AUTHZ_SID_OPERATION_ADD = AUTHZ_SID_OPERATION.ADD;
pub const AUTHZ_SID_OPERATION_DELETE = AUTHZ_SID_OPERATION.DELETE;
pub const AUTHZ_SID_OPERATION_REPLACE = AUTHZ_SID_OPERATION.REPLACE;

pub const AUTHZ_SECURITY_ATTRIBUTE_V1 = extern struct {
    pName: ?PWSTR,
    ValueType: u16,
    Reserved: u16,
    Flags: AUTHZ_SECURITY_ATTRIBUTE_FLAGS,
    ValueCount: u32,
    Values: extern union {
        pInt64: ?*i64,
        pUint64: ?*u64,
        ppString: ?*?PWSTR,
        pFqbn: ?*AUTHZ_SECURITY_ATTRIBUTE_FQBN_VALUE,
        pOctetString: ?*AUTHZ_SECURITY_ATTRIBUTE_OCTET_STRING_VALUE,
    },
};

pub const AUTHZ_SECURITY_ATTRIBUTES_INFORMATION = extern struct {
    Version: u16,
    Reserved: u16,
    AttributeCount: u32,
    Attribute: extern union {
        pAttributeV1: ?*AUTHZ_SECURITY_ATTRIBUTE_V1,
    },
};

pub const AUTHZ_RPC_INIT_INFO_CLIENT = extern struct {
    version: u16,
    ObjectUuid: ?PWSTR,
    ProtSeq: ?PWSTR,
    NetworkAddr: ?PWSTR,
    Endpoint: ?PWSTR,
    Options: ?PWSTR,
    ServerSpn: ?PWSTR,
};

pub const AUTHZ_INIT_INFO = extern struct {
    version: u16,
    szResourceManagerName: ?[*:0]const u16,
    pfnDynamicAccessCheck: ?PFN_AUTHZ_DYNAMIC_ACCESS_CHECK,
    pfnComputeDynamicGroups: ?PFN_AUTHZ_COMPUTE_DYNAMIC_GROUPS,
    pfnFreeDynamicGroups: ?PFN_AUTHZ_FREE_DYNAMIC_GROUPS,
    pfnGetCentralAccessPolicy: ?PFN_AUTHZ_GET_CENTRAL_ACCESS_POLICY,
    pfnFreeCentralAccessPolicy: ?PFN_AUTHZ_FREE_CENTRAL_ACCESS_POLICY,
};

pub const AUTHZ_CONTEXT_INFORMATION_CLASS = enum(i32) {
    UserSid = 1,
    GroupsSids = 2,
    RestrictedSids = 3,
    Privileges = 4,
    ExpirationTime = 5,
    ServerContext = 6,
    Identifier = 7,
    Source = 8,
    All = 9,
    AuthenticationId = 10,
    SecurityAttributes = 11,
    DeviceSids = 12,
    UserClaims = 13,
    DeviceClaims = 14,
    AppContainerSid = 15,
    CapabilitySids = 16,
};
pub const AuthzContextInfoUserSid = AUTHZ_CONTEXT_INFORMATION_CLASS.UserSid;
pub const AuthzContextInfoGroupsSids = AUTHZ_CONTEXT_INFORMATION_CLASS.GroupsSids;
pub const AuthzContextInfoRestrictedSids = AUTHZ_CONTEXT_INFORMATION_CLASS.RestrictedSids;
pub const AuthzContextInfoPrivileges = AUTHZ_CONTEXT_INFORMATION_CLASS.Privileges;
pub const AuthzContextInfoExpirationTime = AUTHZ_CONTEXT_INFORMATION_CLASS.ExpirationTime;
pub const AuthzContextInfoServerContext = AUTHZ_CONTEXT_INFORMATION_CLASS.ServerContext;
pub const AuthzContextInfoIdentifier = AUTHZ_CONTEXT_INFORMATION_CLASS.Identifier;
pub const AuthzContextInfoSource = AUTHZ_CONTEXT_INFORMATION_CLASS.Source;
pub const AuthzContextInfoAll = AUTHZ_CONTEXT_INFORMATION_CLASS.All;
pub const AuthzContextInfoAuthenticationId = AUTHZ_CONTEXT_INFORMATION_CLASS.AuthenticationId;
pub const AuthzContextInfoSecurityAttributes = AUTHZ_CONTEXT_INFORMATION_CLASS.SecurityAttributes;
pub const AuthzContextInfoDeviceSids = AUTHZ_CONTEXT_INFORMATION_CLASS.DeviceSids;
pub const AuthzContextInfoUserClaims = AUTHZ_CONTEXT_INFORMATION_CLASS.UserClaims;
pub const AuthzContextInfoDeviceClaims = AUTHZ_CONTEXT_INFORMATION_CLASS.DeviceClaims;
pub const AuthzContextInfoAppContainerSid = AUTHZ_CONTEXT_INFORMATION_CLASS.AppContainerSid;
pub const AuthzContextInfoCapabilitySids = AUTHZ_CONTEXT_INFORMATION_CLASS.CapabilitySids;

pub const AUTHZ_AUDIT_EVENT_INFORMATION_CLASS = enum(i32) {
    Flags = 1,
    OperationType = 2,
    ObjectType = 3,
    ObjectName = 4,
    AdditionalInfo = 5,
};
pub const AuthzAuditEventInfoFlags = AUTHZ_AUDIT_EVENT_INFORMATION_CLASS.Flags;
pub const AuthzAuditEventInfoOperationType = AUTHZ_AUDIT_EVENT_INFORMATION_CLASS.OperationType;
pub const AuthzAuditEventInfoObjectType = AUTHZ_AUDIT_EVENT_INFORMATION_CLASS.ObjectType;
pub const AuthzAuditEventInfoObjectName = AUTHZ_AUDIT_EVENT_INFORMATION_CLASS.ObjectName;
pub const AuthzAuditEventInfoAdditionalInfo = AUTHZ_AUDIT_EVENT_INFORMATION_CLASS.AdditionalInfo;

pub const AUTHZ_REGISTRATION_OBJECT_TYPE_NAME_OFFSET = extern struct {
    szObjectTypeName: ?PWSTR,
    dwOffset: u32,
};

pub const AUTHZ_SOURCE_SCHEMA_REGISTRATION = extern struct {
    dwFlags: u32,
    szEventSourceName: ?PWSTR,
    szEventMessageFile: ?PWSTR,
    szEventSourceXmlSchemaFile: ?PWSTR,
    szEventAccessStringsFile: ?PWSTR,
    szExecutableImagePath: ?PWSTR,
    Anonymous: extern union {
        pReserved: ?*anyopaque,
        pProviderGuid: ?*Guid,
    },
    dwObjectTypeNameCount: u32,
    ObjectTypeNames: [1]AUTHZ_REGISTRATION_OBJECT_TYPE_NAME_OFFSET,
};

const CLSID_AzAuthorizationStore_Value = Guid.initString("b2bcff59-a757-4b0b-a1bc-ea69981da69e");
pub const CLSID_AzAuthorizationStore = &CLSID_AzAuthorizationStore_Value;

const CLSID_AzBizRuleContext_Value = Guid.initString("5c2dc96f-8d51-434b-b33c-379bccae77c3");
pub const CLSID_AzBizRuleContext = &CLSID_AzBizRuleContext_Value;

const CLSID_AzPrincipalLocator_Value = Guid.initString("483afb5d-70df-4e16-abdc-a1de4d015a3e");
pub const CLSID_AzPrincipalLocator = &CLSID_AzPrincipalLocator_Value;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzAuthorizationStore_Value = Guid.initString("edbd9ca9-9b82-4f6a-9e8b-98301e450f14");
pub const IID_IAzAuthorizationStore = &IID_IAzAuthorizationStore_Value;
pub const IAzAuthorizationStore = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                pbstrDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                pbstrDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ApplicationData: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                pbstrApplicationData: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                pbstrApplicationData: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_ApplicationData: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrApplicationData: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrApplicationData: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_DomainTimeout: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                plProp: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                plProp: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_DomainTimeout: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                lProp: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                lProp: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ScriptEngineTimeout: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                plProp: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                plProp: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_ScriptEngineTimeout: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                lProp: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                lProp: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_MaxScriptEngines: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                plProp: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                plProp: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_MaxScriptEngines: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                lProp: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                lProp: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_GenerateAudits: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                pbProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                pbProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_GenerateAudits: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bProp: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bProp: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Writable: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                lPropId: i32,
                varReserved: VARIANT,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                lPropId: i32,
                varReserved: VARIANT,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPropertyItem: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                lPropId: AZ_PROP_CONSTANTS,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                lPropId: AZ_PROP_CONSTANTS,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePropertyItem: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PolicyAdministrators: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                pvarAdmins: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                pvarAdmins: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PolicyReaders: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                pvarReaders: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                pvarReaders: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPolicyAdministrator: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePolicyAdministrator: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPolicyReader: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePolicyReader: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Initialize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                lFlags: AZ_PROP_CONSTANTS,
                bstrPolicyURL: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                lFlags: AZ_PROP_CONSTANTS,
                bstrPolicyURL: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        UpdateCache: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Delete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Applications: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                ppAppCollection: ?*?*IAzApplications,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                ppAppCollection: ?*?*IAzApplications,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenApplication: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrApplicationName: ?BSTR,
                varReserved: VARIANT,
                ppApplication: ?*?*IAzApplication,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrApplicationName: ?BSTR,
                varReserved: VARIANT,
                ppApplication: ?*?*IAzApplication,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateApplication: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrApplicationName: ?BSTR,
                varReserved: VARIANT,
                ppApplication: ?*?*IAzApplication,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrApplicationName: ?BSTR,
                varReserved: VARIANT,
                ppApplication: ?*?*IAzApplication,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteApplication: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrApplicationName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrApplicationName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ApplicationGroups: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                ppGroupCollection: ?*?*IAzApplicationGroups,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                ppGroupCollection: ?*?*IAzApplicationGroups,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateApplicationGroup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
                ppGroup: ?*?*IAzApplicationGroup,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
                ppGroup: ?*?*IAzApplicationGroup,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenApplicationGroup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
                ppGroup: ?*?*IAzApplicationGroup,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
                ppGroup: ?*?*IAzApplicationGroup,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteApplicationGroup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Submit: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                lFlags: i32,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                lFlags: i32,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_DelegatedPolicyUsers: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                pvarDelegatedPolicyUsers: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                pvarDelegatedPolicyUsers: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddDelegatedPolicyUser: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrDelegatedPolicyUser: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrDelegatedPolicyUser: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteDelegatedPolicyUser: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrDelegatedPolicyUser: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrDelegatedPolicyUser: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_TargetMachine: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                pbstrTargetMachine: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                pbstrTargetMachine: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ApplyStoreSacl: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                pbApplyStoreSacl: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                pbApplyStoreSacl: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_ApplyStoreSacl: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bApplyStoreSacl: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bApplyStoreSacl: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PolicyAdministratorsName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                pvarAdmins: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                pvarAdmins: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PolicyReadersName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                pvarReaders: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                pvarReaders: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPolicyAdministratorName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePolicyAdministratorName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPolicyReaderName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePolicyReaderName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_DelegatedPolicyUsersName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                pvarDelegatedPolicyUsers: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzAuthorizationStore,
                pvarDelegatedPolicyUsers: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddDelegatedPolicyUserName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrDelegatedPolicyUser: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrDelegatedPolicyUser: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteDelegatedPolicyUserName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrDelegatedPolicyUser: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrDelegatedPolicyUser: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CloseApplication: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore,
                bstrApplicationName: ?BSTR,
                lFlag: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore,
                bstrApplicationName: ?BSTR,
                lFlag: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_Description(self: *const T, pbstrDescription: ?*?BSTR) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_Description(@as(*const IAzAuthorizationStore, @ptrCast(self)), pbstrDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_put_Description(self: *const T, bstrDescription: ?BSTR) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).put_Description(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_ApplicationData(self: *const T, pbstrApplicationData: ?*?BSTR) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_ApplicationData(@as(*const IAzAuthorizationStore, @ptrCast(self)), pbstrApplicationData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_put_ApplicationData(self: *const T, bstrApplicationData: ?BSTR) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).put_ApplicationData(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrApplicationData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_DomainTimeout(self: *const T, plProp: ?*i32) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_DomainTimeout(@as(*const IAzAuthorizationStore, @ptrCast(self)), plProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_put_DomainTimeout(self: *const T, lProp: i32) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).put_DomainTimeout(@as(*const IAzAuthorizationStore, @ptrCast(self)), lProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_ScriptEngineTimeout(self: *const T, plProp: ?*i32) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_ScriptEngineTimeout(@as(*const IAzAuthorizationStore, @ptrCast(self)), plProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_put_ScriptEngineTimeout(self: *const T, lProp: i32) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).put_ScriptEngineTimeout(@as(*const IAzAuthorizationStore, @ptrCast(self)), lProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_MaxScriptEngines(self: *const T, plProp: ?*i32) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_MaxScriptEngines(@as(*const IAzAuthorizationStore, @ptrCast(self)), plProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_put_MaxScriptEngines(self: *const T, lProp: i32) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).put_MaxScriptEngines(@as(*const IAzAuthorizationStore, @ptrCast(self)), lProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_GenerateAudits(self: *const T, pbProp: ?*BOOL) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_GenerateAudits(@as(*const IAzAuthorizationStore, @ptrCast(self)), pbProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_put_GenerateAudits(self: *const T, bProp: BOOL) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).put_GenerateAudits(@as(*const IAzAuthorizationStore, @ptrCast(self)), bProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_Writable(self: *const T, pfProp: ?*BOOL) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_Writable(@as(*const IAzAuthorizationStore, @ptrCast(self)), pfProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_GetProperty(self: *const T, lPropId: i32, varReserved: VARIANT, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).GetProperty(@as(*const IAzAuthorizationStore, @ptrCast(self)), lPropId, varReserved, pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_SetProperty(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).SetProperty(@as(*const IAzAuthorizationStore, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_AddPropertyItem(self: *const T, lPropId: AZ_PROP_CONSTANTS, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).AddPropertyItem(@as(*const IAzAuthorizationStore, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_DeletePropertyItem(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).DeletePropertyItem(@as(*const IAzAuthorizationStore, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_PolicyAdministrators(self: *const T, pvarAdmins: ?*VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_PolicyAdministrators(@as(*const IAzAuthorizationStore, @ptrCast(self)), pvarAdmins);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_PolicyReaders(self: *const T, pvarReaders: ?*VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_PolicyReaders(@as(*const IAzAuthorizationStore, @ptrCast(self)), pvarReaders);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_AddPolicyAdministrator(self: *const T, bstrAdmin: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).AddPolicyAdministrator(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrAdmin, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_DeletePolicyAdministrator(self: *const T, bstrAdmin: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).DeletePolicyAdministrator(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrAdmin, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_AddPolicyReader(self: *const T, bstrReader: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).AddPolicyReader(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrReader, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_DeletePolicyReader(self: *const T, bstrReader: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).DeletePolicyReader(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrReader, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_Initialize(self: *const T, lFlags: AZ_PROP_CONSTANTS, bstrPolicyURL: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).Initialize(@as(*const IAzAuthorizationStore, @ptrCast(self)), lFlags, bstrPolicyURL, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_UpdateCache(self: *const T, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).UpdateCache(@as(*const IAzAuthorizationStore, @ptrCast(self)), varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_Delete(self: *const T, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).Delete(@as(*const IAzAuthorizationStore, @ptrCast(self)), varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_Applications(self: *const T, ppAppCollection: ?*?*IAzApplications) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_Applications(@as(*const IAzAuthorizationStore, @ptrCast(self)), ppAppCollection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_OpenApplication(self: *const T, bstrApplicationName: ?BSTR, varReserved: VARIANT, ppApplication: ?*?*IAzApplication) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).OpenApplication(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrApplicationName, varReserved, ppApplication);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_CreateApplication(self: *const T, bstrApplicationName: ?BSTR, varReserved: VARIANT, ppApplication: ?*?*IAzApplication) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).CreateApplication(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrApplicationName, varReserved, ppApplication);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_DeleteApplication(self: *const T, bstrApplicationName: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).DeleteApplication(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrApplicationName, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_ApplicationGroups(self: *const T, ppGroupCollection: ?*?*IAzApplicationGroups) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_ApplicationGroups(@as(*const IAzAuthorizationStore, @ptrCast(self)), ppGroupCollection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_CreateApplicationGroup(self: *const T, bstrGroupName: ?BSTR, varReserved: VARIANT, ppGroup: ?*?*IAzApplicationGroup) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).CreateApplicationGroup(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrGroupName, varReserved, ppGroup);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_OpenApplicationGroup(self: *const T, bstrGroupName: ?BSTR, varReserved: VARIANT, ppGroup: ?*?*IAzApplicationGroup) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).OpenApplicationGroup(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrGroupName, varReserved, ppGroup);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_DeleteApplicationGroup(self: *const T, bstrGroupName: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).DeleteApplicationGroup(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrGroupName, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_Submit(self: *const T, lFlags: i32, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).Submit(@as(*const IAzAuthorizationStore, @ptrCast(self)), lFlags, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_DelegatedPolicyUsers(self: *const T, pvarDelegatedPolicyUsers: ?*VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_DelegatedPolicyUsers(@as(*const IAzAuthorizationStore, @ptrCast(self)), pvarDelegatedPolicyUsers);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_AddDelegatedPolicyUser(self: *const T, bstrDelegatedPolicyUser: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).AddDelegatedPolicyUser(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrDelegatedPolicyUser, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_DeleteDelegatedPolicyUser(self: *const T, bstrDelegatedPolicyUser: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).DeleteDelegatedPolicyUser(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrDelegatedPolicyUser, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_TargetMachine(self: *const T, pbstrTargetMachine: ?*?BSTR) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_TargetMachine(@as(*const IAzAuthorizationStore, @ptrCast(self)), pbstrTargetMachine);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_ApplyStoreSacl(self: *const T, pbApplyStoreSacl: ?*BOOL) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_ApplyStoreSacl(@as(*const IAzAuthorizationStore, @ptrCast(self)), pbApplyStoreSacl);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_put_ApplyStoreSacl(self: *const T, bApplyStoreSacl: BOOL) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).put_ApplyStoreSacl(@as(*const IAzAuthorizationStore, @ptrCast(self)), bApplyStoreSacl);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_PolicyAdministratorsName(self: *const T, pvarAdmins: ?*VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_PolicyAdministratorsName(@as(*const IAzAuthorizationStore, @ptrCast(self)), pvarAdmins);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_PolicyReadersName(self: *const T, pvarReaders: ?*VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_PolicyReadersName(@as(*const IAzAuthorizationStore, @ptrCast(self)), pvarReaders);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_AddPolicyAdministratorName(self: *const T, bstrAdmin: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).AddPolicyAdministratorName(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrAdmin, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_DeletePolicyAdministratorName(self: *const T, bstrAdmin: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).DeletePolicyAdministratorName(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrAdmin, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_AddPolicyReaderName(self: *const T, bstrReader: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).AddPolicyReaderName(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrReader, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_DeletePolicyReaderName(self: *const T, bstrReader: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).DeletePolicyReaderName(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrReader, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_get_DelegatedPolicyUsersName(self: *const T, pvarDelegatedPolicyUsers: ?*VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).get_DelegatedPolicyUsersName(@as(*const IAzAuthorizationStore, @ptrCast(self)), pvarDelegatedPolicyUsers);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_AddDelegatedPolicyUserName(self: *const T, bstrDelegatedPolicyUser: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).AddDelegatedPolicyUserName(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrDelegatedPolicyUser, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_DeleteDelegatedPolicyUserName(self: *const T, bstrDelegatedPolicyUser: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).DeleteDelegatedPolicyUserName(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrDelegatedPolicyUser, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore_CloseApplication(self: *const T, bstrApplicationName: ?BSTR, lFlag: i32) HRESULT {
                return @as(*const IAzAuthorizationStore.VTable, @ptrCast(self.vtable)).CloseApplication(@as(*const IAzAuthorizationStore, @ptrCast(self)), bstrApplicationName, lFlag);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IAzAuthorizationStore2_Value = Guid.initString("b11e5584-d577-4273-b6c5-0973e0f8e80d");
pub const IID_IAzAuthorizationStore2 = &IID_IAzAuthorizationStore2_Value;
pub const IAzAuthorizationStore2 = extern struct {
    pub const VTable = extern struct {
        base: IAzAuthorizationStore.VTable,
        OpenApplication2: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore2,
                bstrApplicationName: ?BSTR,
                varReserved: VARIANT,
                ppApplication: ?*?*IAzApplication2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore2,
                bstrApplicationName: ?BSTR,
                varReserved: VARIANT,
                ppApplication: ?*?*IAzApplication2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateApplication2: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore2,
                bstrApplicationName: ?BSTR,
                varReserved: VARIANT,
                ppApplication: ?*?*IAzApplication2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore2,
                bstrApplicationName: ?BSTR,
                varReserved: VARIANT,
                ppApplication: ?*?*IAzApplication2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IAzAuthorizationStore.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore2_OpenApplication2(self: *const T, bstrApplicationName: ?BSTR, varReserved: VARIANT, ppApplication: ?*?*IAzApplication2) HRESULT {
                return @as(*const IAzAuthorizationStore2.VTable, @ptrCast(self.vtable)).OpenApplication2(@as(*const IAzAuthorizationStore2, @ptrCast(self)), bstrApplicationName, varReserved, ppApplication);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore2_CreateApplication2(self: *const T, bstrApplicationName: ?BSTR, varReserved: VARIANT, ppApplication: ?*?*IAzApplication2) HRESULT {
                return @as(*const IAzAuthorizationStore2.VTable, @ptrCast(self.vtable)).CreateApplication2(@as(*const IAzAuthorizationStore2, @ptrCast(self)), bstrApplicationName, varReserved, ppApplication);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzAuthorizationStore3_Value = Guid.initString("abc08425-0c86-4fa0-9be3-7189956c926e");
pub const IID_IAzAuthorizationStore3 = &IID_IAzAuthorizationStore3_Value;
pub const IAzAuthorizationStore3 = extern struct {
    pub const VTable = extern struct {
        base: IAzAuthorizationStore2.VTable,
        IsUpdateNeeded: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore3,
                pbIsUpdateNeeded: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore3,
                pbIsUpdateNeeded: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        BizruleGroupSupported: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore3,
                pbSupported: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore3,
                pbSupported: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        UpgradeStoresFunctionalLevel: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore3,
                lFunctionalLevel: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore3,
                lFunctionalLevel: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        IsFunctionalLevelUpgradeSupported: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore3,
                lFunctionalLevel: i32,
                pbSupported: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore3,
                lFunctionalLevel: i32,
                pbSupported: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetSchemaVersion: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzAuthorizationStore3,
                plMajorVersion: ?*i32,
                plMinorVersion: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzAuthorizationStore3,
                plMajorVersion: ?*i32,
                plMinorVersion: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IAzAuthorizationStore2.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore3_IsUpdateNeeded(self: *const T, pbIsUpdateNeeded: ?*i16) HRESULT {
                return @as(*const IAzAuthorizationStore3.VTable, @ptrCast(self.vtable)).IsUpdateNeeded(@as(*const IAzAuthorizationStore3, @ptrCast(self)), pbIsUpdateNeeded);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore3_BizruleGroupSupported(self: *const T, pbSupported: ?*i16) HRESULT {
                return @as(*const IAzAuthorizationStore3.VTable, @ptrCast(self.vtable)).BizruleGroupSupported(@as(*const IAzAuthorizationStore3, @ptrCast(self)), pbSupported);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore3_UpgradeStoresFunctionalLevel(self: *const T, lFunctionalLevel: i32) HRESULT {
                return @as(*const IAzAuthorizationStore3.VTable, @ptrCast(self.vtable)).UpgradeStoresFunctionalLevel(@as(*const IAzAuthorizationStore3, @ptrCast(self)), lFunctionalLevel);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore3_IsFunctionalLevelUpgradeSupported(self: *const T, lFunctionalLevel: i32, pbSupported: ?*i16) HRESULT {
                return @as(*const IAzAuthorizationStore3.VTable, @ptrCast(self.vtable)).IsFunctionalLevelUpgradeSupported(@as(*const IAzAuthorizationStore3, @ptrCast(self)), lFunctionalLevel, pbSupported);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzAuthorizationStore3_GetSchemaVersion(self: *const T, plMajorVersion: ?*i32, plMinorVersion: ?*i32) HRESULT {
                return @as(*const IAzAuthorizationStore3.VTable, @ptrCast(self.vtable)).GetSchemaVersion(@as(*const IAzAuthorizationStore3, @ptrCast(self)), plMajorVersion, plMinorVersion);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzApplication_Value = Guid.initString("987bc7c7-b813-4d27-bede-6ba5ae867e95");
pub const IID_IAzApplication = &IID_IAzApplication_Value;
pub const IAzApplication = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                bstrName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                bstrName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                pbstrDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                pbstrDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                bstrDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                bstrDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ApplicationData: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                pbstrApplicationData: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                pbstrApplicationData: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_ApplicationData: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                bstrApplicationData: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                bstrApplicationData: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_AuthzInterfaceClsid: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_AuthzInterfaceClsid: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Version: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Version: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_GenerateAudits: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                pbProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                pbProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_GenerateAudits: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                bProp: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                bProp: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ApplyStoreSacl: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                pbProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                pbProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_ApplyStoreSacl: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                bProp: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                bProp: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Writable: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                lPropId: i32,
                varReserved: VARIANT,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                lPropId: i32,
                varReserved: VARIANT,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PolicyAdministrators: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                pvarAdmins: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                pvarAdmins: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PolicyReaders: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                pvarReaders: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                pvarReaders: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPolicyAdministrator: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePolicyAdministrator: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPolicyReader: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePolicyReader: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Scopes: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                ppScopeCollection: ?*?*IAzScopes,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                ppScopeCollection: ?*?*IAzScopes,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenScope: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrScopeName: ?BSTR,
                varReserved: VARIANT,
                ppScope: ?*?*IAzScope,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrScopeName: ?BSTR,
                varReserved: VARIANT,
                ppScope: ?*?*IAzScope,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateScope: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrScopeName: ?BSTR,
                varReserved: VARIANT,
                ppScope: ?*?*IAzScope,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrScopeName: ?BSTR,
                varReserved: VARIANT,
                ppScope: ?*?*IAzScope,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteScope: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrScopeName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrScopeName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Operations: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                ppOperationCollection: ?*?*IAzOperations,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                ppOperationCollection: ?*?*IAzOperations,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenOperation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrOperationName: ?BSTR,
                varReserved: VARIANT,
                ppOperation: ?*?*IAzOperation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrOperationName: ?BSTR,
                varReserved: VARIANT,
                ppOperation: ?*?*IAzOperation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateOperation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrOperationName: ?BSTR,
                varReserved: VARIANT,
                ppOperation: ?*?*IAzOperation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrOperationName: ?BSTR,
                varReserved: VARIANT,
                ppOperation: ?*?*IAzOperation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteOperation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrOperationName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrOperationName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Tasks: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                ppTaskCollection: ?*?*IAzTasks,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                ppTaskCollection: ?*?*IAzTasks,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenTask: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrTaskName: ?BSTR,
                varReserved: VARIANT,
                ppTask: ?*?*IAzTask,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrTaskName: ?BSTR,
                varReserved: VARIANT,
                ppTask: ?*?*IAzTask,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateTask: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrTaskName: ?BSTR,
                varReserved: VARIANT,
                ppTask: ?*?*IAzTask,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrTaskName: ?BSTR,
                varReserved: VARIANT,
                ppTask: ?*?*IAzTask,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteTask: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrTaskName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrTaskName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ApplicationGroups: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                ppGroupCollection: ?*?*IAzApplicationGroups,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                ppGroupCollection: ?*?*IAzApplicationGroups,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenApplicationGroup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
                ppGroup: ?*?*IAzApplicationGroup,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
                ppGroup: ?*?*IAzApplicationGroup,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateApplicationGroup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
                ppGroup: ?*?*IAzApplicationGroup,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
                ppGroup: ?*?*IAzApplicationGroup,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteApplicationGroup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Roles: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                ppRoleCollection: ?*?*IAzRoles,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                ppRoleCollection: ?*?*IAzRoles,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenRole: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrRoleName: ?BSTR,
                varReserved: VARIANT,
                ppRole: ?*?*IAzRole,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrRoleName: ?BSTR,
                varReserved: VARIANT,
                ppRole: ?*?*IAzRole,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateRole: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrRoleName: ?BSTR,
                varReserved: VARIANT,
                ppRole: ?*?*IAzRole,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrRoleName: ?BSTR,
                varReserved: VARIANT,
                ppRole: ?*?*IAzRole,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteRole: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrRoleName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrRoleName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        InitializeClientContextFromToken: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                ullTokenHandle: u64,
                varReserved: VARIANT,
                ppClientContext: ?*?*IAzClientContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                ullTokenHandle: u64,
                varReserved: VARIANT,
                ppClientContext: ?*?*IAzClientContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPropertyItem: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePropertyItem: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Submit: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                lFlags: i32,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                lFlags: i32,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        InitializeClientContextFromName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                ClientName: ?BSTR,
                DomainName: ?BSTR,
                varReserved: VARIANT,
                ppClientContext: ?*?*IAzClientContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                ClientName: ?BSTR,
                DomainName: ?BSTR,
                varReserved: VARIANT,
                ppClientContext: ?*?*IAzClientContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_DelegatedPolicyUsers: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                pvarDelegatedPolicyUsers: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                pvarDelegatedPolicyUsers: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddDelegatedPolicyUser: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrDelegatedPolicyUser: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrDelegatedPolicyUser: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteDelegatedPolicyUser: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrDelegatedPolicyUser: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrDelegatedPolicyUser: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        InitializeClientContextFromStringSid: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                SidString: ?BSTR,
                lOptions: i32,
                varReserved: VARIANT,
                ppClientContext: ?*?*IAzClientContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                SidString: ?BSTR,
                lOptions: i32,
                varReserved: VARIANT,
                ppClientContext: ?*?*IAzClientContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PolicyAdministratorsName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                pvarAdmins: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                pvarAdmins: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PolicyReadersName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                pvarReaders: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                pvarReaders: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPolicyAdministratorName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePolicyAdministratorName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPolicyReaderName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePolicyReaderName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_DelegatedPolicyUsersName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication,
                pvarDelegatedPolicyUsers: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication,
                pvarDelegatedPolicyUsers: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddDelegatedPolicyUserName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrDelegatedPolicyUser: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrDelegatedPolicyUser: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteDelegatedPolicyUserName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication,
                bstrDelegatedPolicyUser: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication,
                bstrDelegatedPolicyUser: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_Name(self: *const T, pbstrName: ?*?BSTR) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_Name(@as(*const IAzApplication, @ptrCast(self)), pbstrName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_put_Name(self: *const T, bstrName: ?BSTR) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).put_Name(@as(*const IAzApplication, @ptrCast(self)), bstrName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_Description(self: *const T, pbstrDescription: ?*?BSTR) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_Description(@as(*const IAzApplication, @ptrCast(self)), pbstrDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_put_Description(self: *const T, bstrDescription: ?BSTR) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).put_Description(@as(*const IAzApplication, @ptrCast(self)), bstrDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_ApplicationData(self: *const T, pbstrApplicationData: ?*?BSTR) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_ApplicationData(@as(*const IAzApplication, @ptrCast(self)), pbstrApplicationData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_put_ApplicationData(self: *const T, bstrApplicationData: ?BSTR) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).put_ApplicationData(@as(*const IAzApplication, @ptrCast(self)), bstrApplicationData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_AuthzInterfaceClsid(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_AuthzInterfaceClsid(@as(*const IAzApplication, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_put_AuthzInterfaceClsid(self: *const T, bstrProp: ?BSTR) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).put_AuthzInterfaceClsid(@as(*const IAzApplication, @ptrCast(self)), bstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_Version(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_Version(@as(*const IAzApplication, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_put_Version(self: *const T, bstrProp: ?BSTR) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).put_Version(@as(*const IAzApplication, @ptrCast(self)), bstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_GenerateAudits(self: *const T, pbProp: ?*BOOL) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_GenerateAudits(@as(*const IAzApplication, @ptrCast(self)), pbProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_put_GenerateAudits(self: *const T, bProp: BOOL) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).put_GenerateAudits(@as(*const IAzApplication, @ptrCast(self)), bProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_ApplyStoreSacl(self: *const T, pbProp: ?*BOOL) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_ApplyStoreSacl(@as(*const IAzApplication, @ptrCast(self)), pbProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_put_ApplyStoreSacl(self: *const T, bProp: BOOL) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).put_ApplyStoreSacl(@as(*const IAzApplication, @ptrCast(self)), bProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_Writable(self: *const T, pfProp: ?*BOOL) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_Writable(@as(*const IAzApplication, @ptrCast(self)), pfProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_GetProperty(self: *const T, lPropId: i32, varReserved: VARIANT, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).GetProperty(@as(*const IAzApplication, @ptrCast(self)), lPropId, varReserved, pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_SetProperty(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).SetProperty(@as(*const IAzApplication, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_PolicyAdministrators(self: *const T, pvarAdmins: ?*VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_PolicyAdministrators(@as(*const IAzApplication, @ptrCast(self)), pvarAdmins);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_PolicyReaders(self: *const T, pvarReaders: ?*VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_PolicyReaders(@as(*const IAzApplication, @ptrCast(self)), pvarReaders);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_AddPolicyAdministrator(self: *const T, bstrAdmin: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).AddPolicyAdministrator(@as(*const IAzApplication, @ptrCast(self)), bstrAdmin, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_DeletePolicyAdministrator(self: *const T, bstrAdmin: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).DeletePolicyAdministrator(@as(*const IAzApplication, @ptrCast(self)), bstrAdmin, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_AddPolicyReader(self: *const T, bstrReader: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).AddPolicyReader(@as(*const IAzApplication, @ptrCast(self)), bstrReader, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_DeletePolicyReader(self: *const T, bstrReader: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).DeletePolicyReader(@as(*const IAzApplication, @ptrCast(self)), bstrReader, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_Scopes(self: *const T, ppScopeCollection: ?*?*IAzScopes) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_Scopes(@as(*const IAzApplication, @ptrCast(self)), ppScopeCollection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_OpenScope(self: *const T, bstrScopeName: ?BSTR, varReserved: VARIANT, ppScope: ?*?*IAzScope) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).OpenScope(@as(*const IAzApplication, @ptrCast(self)), bstrScopeName, varReserved, ppScope);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_CreateScope(self: *const T, bstrScopeName: ?BSTR, varReserved: VARIANT, ppScope: ?*?*IAzScope) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).CreateScope(@as(*const IAzApplication, @ptrCast(self)), bstrScopeName, varReserved, ppScope);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_DeleteScope(self: *const T, bstrScopeName: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).DeleteScope(@as(*const IAzApplication, @ptrCast(self)), bstrScopeName, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_Operations(self: *const T, ppOperationCollection: ?*?*IAzOperations) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_Operations(@as(*const IAzApplication, @ptrCast(self)), ppOperationCollection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_OpenOperation(self: *const T, bstrOperationName: ?BSTR, varReserved: VARIANT, ppOperation: ?*?*IAzOperation) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).OpenOperation(@as(*const IAzApplication, @ptrCast(self)), bstrOperationName, varReserved, ppOperation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_CreateOperation(self: *const T, bstrOperationName: ?BSTR, varReserved: VARIANT, ppOperation: ?*?*IAzOperation) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).CreateOperation(@as(*const IAzApplication, @ptrCast(self)), bstrOperationName, varReserved, ppOperation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_DeleteOperation(self: *const T, bstrOperationName: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).DeleteOperation(@as(*const IAzApplication, @ptrCast(self)), bstrOperationName, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_Tasks(self: *const T, ppTaskCollection: ?*?*IAzTasks) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_Tasks(@as(*const IAzApplication, @ptrCast(self)), ppTaskCollection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_OpenTask(self: *const T, bstrTaskName: ?BSTR, varReserved: VARIANT, ppTask: ?*?*IAzTask) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).OpenTask(@as(*const IAzApplication, @ptrCast(self)), bstrTaskName, varReserved, ppTask);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_CreateTask(self: *const T, bstrTaskName: ?BSTR, varReserved: VARIANT, ppTask: ?*?*IAzTask) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).CreateTask(@as(*const IAzApplication, @ptrCast(self)), bstrTaskName, varReserved, ppTask);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_DeleteTask(self: *const T, bstrTaskName: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).DeleteTask(@as(*const IAzApplication, @ptrCast(self)), bstrTaskName, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_ApplicationGroups(self: *const T, ppGroupCollection: ?*?*IAzApplicationGroups) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_ApplicationGroups(@as(*const IAzApplication, @ptrCast(self)), ppGroupCollection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_OpenApplicationGroup(self: *const T, bstrGroupName: ?BSTR, varReserved: VARIANT, ppGroup: ?*?*IAzApplicationGroup) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).OpenApplicationGroup(@as(*const IAzApplication, @ptrCast(self)), bstrGroupName, varReserved, ppGroup);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_CreateApplicationGroup(self: *const T, bstrGroupName: ?BSTR, varReserved: VARIANT, ppGroup: ?*?*IAzApplicationGroup) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).CreateApplicationGroup(@as(*const IAzApplication, @ptrCast(self)), bstrGroupName, varReserved, ppGroup);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_DeleteApplicationGroup(self: *const T, bstrGroupName: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).DeleteApplicationGroup(@as(*const IAzApplication, @ptrCast(self)), bstrGroupName, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_Roles(self: *const T, ppRoleCollection: ?*?*IAzRoles) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_Roles(@as(*const IAzApplication, @ptrCast(self)), ppRoleCollection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_OpenRole(self: *const T, bstrRoleName: ?BSTR, varReserved: VARIANT, ppRole: ?*?*IAzRole) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).OpenRole(@as(*const IAzApplication, @ptrCast(self)), bstrRoleName, varReserved, ppRole);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_CreateRole(self: *const T, bstrRoleName: ?BSTR, varReserved: VARIANT, ppRole: ?*?*IAzRole) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).CreateRole(@as(*const IAzApplication, @ptrCast(self)), bstrRoleName, varReserved, ppRole);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_DeleteRole(self: *const T, bstrRoleName: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).DeleteRole(@as(*const IAzApplication, @ptrCast(self)), bstrRoleName, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_InitializeClientContextFromToken(self: *const T, ullTokenHandle: u64, varReserved: VARIANT, ppClientContext: ?*?*IAzClientContext) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).InitializeClientContextFromToken(@as(*const IAzApplication, @ptrCast(self)), ullTokenHandle, varReserved, ppClientContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_AddPropertyItem(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).AddPropertyItem(@as(*const IAzApplication, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_DeletePropertyItem(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).DeletePropertyItem(@as(*const IAzApplication, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_Submit(self: *const T, lFlags: i32, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).Submit(@as(*const IAzApplication, @ptrCast(self)), lFlags, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_InitializeClientContextFromName(self: *const T, ClientName: ?BSTR, DomainName: ?BSTR, varReserved: VARIANT, ppClientContext: ?*?*IAzClientContext) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).InitializeClientContextFromName(@as(*const IAzApplication, @ptrCast(self)), ClientName, DomainName, varReserved, ppClientContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_DelegatedPolicyUsers(self: *const T, pvarDelegatedPolicyUsers: ?*VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_DelegatedPolicyUsers(@as(*const IAzApplication, @ptrCast(self)), pvarDelegatedPolicyUsers);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_AddDelegatedPolicyUser(self: *const T, bstrDelegatedPolicyUser: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).AddDelegatedPolicyUser(@as(*const IAzApplication, @ptrCast(self)), bstrDelegatedPolicyUser, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_DeleteDelegatedPolicyUser(self: *const T, bstrDelegatedPolicyUser: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).DeleteDelegatedPolicyUser(@as(*const IAzApplication, @ptrCast(self)), bstrDelegatedPolicyUser, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_InitializeClientContextFromStringSid(self: *const T, SidString: ?BSTR, lOptions: i32, varReserved: VARIANT, ppClientContext: ?*?*IAzClientContext) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).InitializeClientContextFromStringSid(@as(*const IAzApplication, @ptrCast(self)), SidString, lOptions, varReserved, ppClientContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_PolicyAdministratorsName(self: *const T, pvarAdmins: ?*VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_PolicyAdministratorsName(@as(*const IAzApplication, @ptrCast(self)), pvarAdmins);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_PolicyReadersName(self: *const T, pvarReaders: ?*VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_PolicyReadersName(@as(*const IAzApplication, @ptrCast(self)), pvarReaders);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_AddPolicyAdministratorName(self: *const T, bstrAdmin: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).AddPolicyAdministratorName(@as(*const IAzApplication, @ptrCast(self)), bstrAdmin, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_DeletePolicyAdministratorName(self: *const T, bstrAdmin: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).DeletePolicyAdministratorName(@as(*const IAzApplication, @ptrCast(self)), bstrAdmin, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_AddPolicyReaderName(self: *const T, bstrReader: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).AddPolicyReaderName(@as(*const IAzApplication, @ptrCast(self)), bstrReader, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_DeletePolicyReaderName(self: *const T, bstrReader: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).DeletePolicyReaderName(@as(*const IAzApplication, @ptrCast(self)), bstrReader, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_get_DelegatedPolicyUsersName(self: *const T, pvarDelegatedPolicyUsers: ?*VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).get_DelegatedPolicyUsersName(@as(*const IAzApplication, @ptrCast(self)), pvarDelegatedPolicyUsers);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_AddDelegatedPolicyUserName(self: *const T, bstrDelegatedPolicyUser: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).AddDelegatedPolicyUserName(@as(*const IAzApplication, @ptrCast(self)), bstrDelegatedPolicyUser, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication_DeleteDelegatedPolicyUserName(self: *const T, bstrDelegatedPolicyUser: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplication.VTable, @ptrCast(self.vtable)).DeleteDelegatedPolicyUserName(@as(*const IAzApplication, @ptrCast(self)), bstrDelegatedPolicyUser, varReserved);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzApplication2_Value = Guid.initString("086a68af-a249-437c-b18d-d4d86d6a9660");
pub const IID_IAzApplication2 = &IID_IAzApplication2_Value;
pub const IAzApplication2 = extern struct {
    pub const VTable = extern struct {
        base: IAzApplication.VTable,
        InitializeClientContextFromToken2: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication2,
                ulTokenHandleLowPart: u32,
                ulTokenHandleHighPart: u32,
                varReserved: VARIANT,
                ppClientContext: ?*?*IAzClientContext2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication2,
                ulTokenHandleLowPart: u32,
                ulTokenHandleHighPart: u32,
                varReserved: VARIANT,
                ppClientContext: ?*?*IAzClientContext2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        InitializeClientContext2: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication2,
                IdentifyingString: ?BSTR,
                varReserved: VARIANT,
                ppClientContext: ?*?*IAzClientContext2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication2,
                IdentifyingString: ?BSTR,
                varReserved: VARIANT,
                ppClientContext: ?*?*IAzClientContext2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IAzApplication.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication2_InitializeClientContextFromToken2(self: *const T, ulTokenHandleLowPart: u32, ulTokenHandleHighPart: u32, varReserved: VARIANT, ppClientContext: ?*?*IAzClientContext2) HRESULT {
                return @as(*const IAzApplication2.VTable, @ptrCast(self.vtable)).InitializeClientContextFromToken2(@as(*const IAzApplication2, @ptrCast(self)), ulTokenHandleLowPart, ulTokenHandleHighPart, varReserved, ppClientContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication2_InitializeClientContext2(self: *const T, IdentifyingString: ?BSTR, varReserved: VARIANT, ppClientContext: ?*?*IAzClientContext2) HRESULT {
                return @as(*const IAzApplication2.VTable, @ptrCast(self.vtable)).InitializeClientContext2(@as(*const IAzApplication2, @ptrCast(self)), IdentifyingString, varReserved, ppClientContext);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzApplications_Value = Guid.initString("929b11a9-95c5-4a84-a29a-20ad42c2f16c");
pub const IID_IAzApplications = &IID_IAzApplications_Value;
pub const IAzApplications = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Item: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplications,
                Index: i32,
                pvarObtPtr: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplications,
                Index: i32,
                pvarObtPtr: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplications,
                plCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplications,
                plCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplications,
                ppEnumPtr: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplications,
                ppEnumPtr: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplications_get_Item(self: *const T, Index: i32, pvarObtPtr: ?*VARIANT) HRESULT {
                return @as(*const IAzApplications.VTable, @ptrCast(self.vtable)).get_Item(@as(*const IAzApplications, @ptrCast(self)), Index, pvarObtPtr);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplications_get_Count(self: *const T, plCount: ?*i32) HRESULT {
                return @as(*const IAzApplications.VTable, @ptrCast(self.vtable)).get_Count(@as(*const IAzApplications, @ptrCast(self)), plCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplications_get__NewEnum(self: *const T, ppEnumPtr: ?*?*IUnknown) HRESULT {
                return @as(*const IAzApplications.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const IAzApplications, @ptrCast(self)), ppEnumPtr);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzOperation_Value = Guid.initString("5e56b24f-ea01-4d61-be44-c49b5e4eaf74");
pub const IID_IAzOperation = &IID_IAzOperation_Value;
pub const IAzOperation = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzOperation,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzOperation,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzOperation,
                bstrName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzOperation,
                bstrName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzOperation,
                pbstrDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzOperation,
                pbstrDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzOperation,
                bstrDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzOperation,
                bstrDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ApplicationData: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzOperation,
                pbstrApplicationData: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzOperation,
                pbstrApplicationData: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_ApplicationData: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzOperation,
                bstrApplicationData: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzOperation,
                bstrApplicationData: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_OperationID: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzOperation,
                plProp: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzOperation,
                plProp: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_OperationID: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzOperation,
                lProp: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzOperation,
                lProp: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Writable: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzOperation,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzOperation,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzOperation,
                lPropId: i32,
                varReserved: VARIANT,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzOperation,
                lPropId: i32,
                varReserved: VARIANT,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzOperation,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzOperation,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Submit: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzOperation,
                lFlags: i32,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzOperation,
                lFlags: i32,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzOperation_get_Name(self: *const T, pbstrName: ?*?BSTR) HRESULT {
                return @as(*const IAzOperation.VTable, @ptrCast(self.vtable)).get_Name(@as(*const IAzOperation, @ptrCast(self)), pbstrName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzOperation_put_Name(self: *const T, bstrName: ?BSTR) HRESULT {
                return @as(*const IAzOperation.VTable, @ptrCast(self.vtable)).put_Name(@as(*const IAzOperation, @ptrCast(self)), bstrName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzOperation_get_Description(self: *const T, pbstrDescription: ?*?BSTR) HRESULT {
                return @as(*const IAzOperation.VTable, @ptrCast(self.vtable)).get_Description(@as(*const IAzOperation, @ptrCast(self)), pbstrDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzOperation_put_Description(self: *const T, bstrDescription: ?BSTR) HRESULT {
                return @as(*const IAzOperation.VTable, @ptrCast(self.vtable)).put_Description(@as(*const IAzOperation, @ptrCast(self)), bstrDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzOperation_get_ApplicationData(self: *const T, pbstrApplicationData: ?*?BSTR) HRESULT {
                return @as(*const IAzOperation.VTable, @ptrCast(self.vtable)).get_ApplicationData(@as(*const IAzOperation, @ptrCast(self)), pbstrApplicationData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzOperation_put_ApplicationData(self: *const T, bstrApplicationData: ?BSTR) HRESULT {
                return @as(*const IAzOperation.VTable, @ptrCast(self.vtable)).put_ApplicationData(@as(*const IAzOperation, @ptrCast(self)), bstrApplicationData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzOperation_get_OperationID(self: *const T, plProp: ?*i32) HRESULT {
                return @as(*const IAzOperation.VTable, @ptrCast(self.vtable)).get_OperationID(@as(*const IAzOperation, @ptrCast(self)), plProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzOperation_put_OperationID(self: *const T, lProp: i32) HRESULT {
                return @as(*const IAzOperation.VTable, @ptrCast(self.vtable)).put_OperationID(@as(*const IAzOperation, @ptrCast(self)), lProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzOperation_get_Writable(self: *const T, pfProp: ?*BOOL) HRESULT {
                return @as(*const IAzOperation.VTable, @ptrCast(self.vtable)).get_Writable(@as(*const IAzOperation, @ptrCast(self)), pfProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzOperation_GetProperty(self: *const T, lPropId: i32, varReserved: VARIANT, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzOperation.VTable, @ptrCast(self.vtable)).GetProperty(@as(*const IAzOperation, @ptrCast(self)), lPropId, varReserved, pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzOperation_SetProperty(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzOperation.VTable, @ptrCast(self.vtable)).SetProperty(@as(*const IAzOperation, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzOperation_Submit(self: *const T, lFlags: i32, varReserved: VARIANT) HRESULT {
                return @as(*const IAzOperation.VTable, @ptrCast(self.vtable)).Submit(@as(*const IAzOperation, @ptrCast(self)), lFlags, varReserved);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzOperations_Value = Guid.initString("90ef9c07-9706-49d9-af80-0438a5f3ec35");
pub const IID_IAzOperations = &IID_IAzOperations_Value;
pub const IAzOperations = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Item: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzOperations,
                Index: i32,
                pvarObtPtr: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzOperations,
                Index: i32,
                pvarObtPtr: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzOperations,
                plCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzOperations,
                plCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzOperations,
                ppEnumPtr: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzOperations,
                ppEnumPtr: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzOperations_get_Item(self: *const T, Index: i32, pvarObtPtr: ?*VARIANT) HRESULT {
                return @as(*const IAzOperations.VTable, @ptrCast(self.vtable)).get_Item(@as(*const IAzOperations, @ptrCast(self)), Index, pvarObtPtr);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzOperations_get_Count(self: *const T, plCount: ?*i32) HRESULT {
                return @as(*const IAzOperations.VTable, @ptrCast(self.vtable)).get_Count(@as(*const IAzOperations, @ptrCast(self)), plCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzOperations_get__NewEnum(self: *const T, ppEnumPtr: ?*?*IUnknown) HRESULT {
                return @as(*const IAzOperations.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const IAzOperations, @ptrCast(self)), ppEnumPtr);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzTask_Value = Guid.initString("cb94e592-2e0e-4a6c-a336-b89a6dc1e388");
pub const IID_IAzTask = &IID_IAzTask_Value;
pub const IAzTask = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                bstrName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                bstrName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                pbstrDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                pbstrDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                bstrDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                bstrDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ApplicationData: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                pbstrApplicationData: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                pbstrApplicationData: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_ApplicationData: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                bstrApplicationData: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                bstrApplicationData: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_BizRule: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_BizRule: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_BizRuleLanguage: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_BizRuleLanguage: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_BizRuleImportedPath: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_BizRuleImportedPath: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsRoleDefinition: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_IsRoleDefinition: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                fProp: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                fProp: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Operations: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Tasks: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddOperation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzTask,
                bstrOp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzTask,
                bstrOp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteOperation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzTask,
                bstrOp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzTask,
                bstrOp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddTask: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzTask,
                bstrTask: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzTask,
                bstrTask: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteTask: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzTask,
                bstrTask: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzTask,
                bstrTask: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Writable: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTask,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTask,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzTask,
                lPropId: i32,
                varReserved: VARIANT,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzTask,
                lPropId: i32,
                varReserved: VARIANT,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzTask,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzTask,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPropertyItem: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzTask,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzTask,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePropertyItem: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzTask,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzTask,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Submit: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzTask,
                lFlags: i32,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzTask,
                lFlags: i32,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_get_Name(self: *const T, pbstrName: ?*?BSTR) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).get_Name(@as(*const IAzTask, @ptrCast(self)), pbstrName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_put_Name(self: *const T, bstrName: ?BSTR) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).put_Name(@as(*const IAzTask, @ptrCast(self)), bstrName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_get_Description(self: *const T, pbstrDescription: ?*?BSTR) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).get_Description(@as(*const IAzTask, @ptrCast(self)), pbstrDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_put_Description(self: *const T, bstrDescription: ?BSTR) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).put_Description(@as(*const IAzTask, @ptrCast(self)), bstrDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_get_ApplicationData(self: *const T, pbstrApplicationData: ?*?BSTR) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).get_ApplicationData(@as(*const IAzTask, @ptrCast(self)), pbstrApplicationData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_put_ApplicationData(self: *const T, bstrApplicationData: ?BSTR) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).put_ApplicationData(@as(*const IAzTask, @ptrCast(self)), bstrApplicationData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_get_BizRule(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).get_BizRule(@as(*const IAzTask, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_put_BizRule(self: *const T, bstrProp: ?BSTR) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).put_BizRule(@as(*const IAzTask, @ptrCast(self)), bstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_get_BizRuleLanguage(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).get_BizRuleLanguage(@as(*const IAzTask, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_put_BizRuleLanguage(self: *const T, bstrProp: ?BSTR) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).put_BizRuleLanguage(@as(*const IAzTask, @ptrCast(self)), bstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_get_BizRuleImportedPath(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).get_BizRuleImportedPath(@as(*const IAzTask, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_put_BizRuleImportedPath(self: *const T, bstrProp: ?BSTR) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).put_BizRuleImportedPath(@as(*const IAzTask, @ptrCast(self)), bstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_get_IsRoleDefinition(self: *const T, pfProp: ?*BOOL) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).get_IsRoleDefinition(@as(*const IAzTask, @ptrCast(self)), pfProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_put_IsRoleDefinition(self: *const T, fProp: BOOL) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).put_IsRoleDefinition(@as(*const IAzTask, @ptrCast(self)), fProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_get_Operations(self: *const T, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).get_Operations(@as(*const IAzTask, @ptrCast(self)), pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_get_Tasks(self: *const T, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).get_Tasks(@as(*const IAzTask, @ptrCast(self)), pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_AddOperation(self: *const T, bstrOp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).AddOperation(@as(*const IAzTask, @ptrCast(self)), bstrOp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_DeleteOperation(self: *const T, bstrOp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).DeleteOperation(@as(*const IAzTask, @ptrCast(self)), bstrOp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_AddTask(self: *const T, bstrTask: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).AddTask(@as(*const IAzTask, @ptrCast(self)), bstrTask, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_DeleteTask(self: *const T, bstrTask: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).DeleteTask(@as(*const IAzTask, @ptrCast(self)), bstrTask, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_get_Writable(self: *const T, pfProp: ?*BOOL) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).get_Writable(@as(*const IAzTask, @ptrCast(self)), pfProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_GetProperty(self: *const T, lPropId: i32, varReserved: VARIANT, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).GetProperty(@as(*const IAzTask, @ptrCast(self)), lPropId, varReserved, pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_SetProperty(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).SetProperty(@as(*const IAzTask, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_AddPropertyItem(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).AddPropertyItem(@as(*const IAzTask, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_DeletePropertyItem(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).DeletePropertyItem(@as(*const IAzTask, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask_Submit(self: *const T, lFlags: i32, varReserved: VARIANT) HRESULT {
                return @as(*const IAzTask.VTable, @ptrCast(self.vtable)).Submit(@as(*const IAzTask, @ptrCast(self)), lFlags, varReserved);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzTasks_Value = Guid.initString("b338ccab-4c85-4388-8c0a-c58592bad398");
pub const IID_IAzTasks = &IID_IAzTasks_Value;
pub const IAzTasks = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Item: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTasks,
                Index: i32,
                pvarObtPtr: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTasks,
                Index: i32,
                pvarObtPtr: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTasks,
                plCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTasks,
                plCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzTasks,
                ppEnumPtr: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzTasks,
                ppEnumPtr: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTasks_get_Item(self: *const T, Index: i32, pvarObtPtr: ?*VARIANT) HRESULT {
                return @as(*const IAzTasks.VTable, @ptrCast(self.vtable)).get_Item(@as(*const IAzTasks, @ptrCast(self)), Index, pvarObtPtr);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTasks_get_Count(self: *const T, plCount: ?*i32) HRESULT {
                return @as(*const IAzTasks.VTable, @ptrCast(self.vtable)).get_Count(@as(*const IAzTasks, @ptrCast(self)), plCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTasks_get__NewEnum(self: *const T, ppEnumPtr: ?*?*IUnknown) HRESULT {
                return @as(*const IAzTasks.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const IAzTasks, @ptrCast(self)), ppEnumPtr);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzScope_Value = Guid.initString("00e52487-e08d-4514-b62e-877d5645f5ab");
pub const IID_IAzScope = &IID_IAzScope_Value;
pub const IAzScope = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope,
                bstrName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope,
                bstrName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope,
                pbstrDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope,
                pbstrDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope,
                bstrDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope,
                bstrDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ApplicationData: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope,
                pbstrApplicationData: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope,
                pbstrApplicationData: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_ApplicationData: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope,
                bstrApplicationData: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope,
                bstrApplicationData: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Writable: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                lPropId: i32,
                varReserved: VARIANT,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                lPropId: i32,
                varReserved: VARIANT,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPropertyItem: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePropertyItem: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PolicyAdministrators: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope,
                pvarAdmins: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope,
                pvarAdmins: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PolicyReaders: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope,
                pvarReaders: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope,
                pvarReaders: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPolicyAdministrator: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePolicyAdministrator: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPolicyReader: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePolicyReader: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ApplicationGroups: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope,
                ppGroupCollection: ?*?*IAzApplicationGroups,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope,
                ppGroupCollection: ?*?*IAzApplicationGroups,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenApplicationGroup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
                ppGroup: ?*?*IAzApplicationGroup,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
                ppGroup: ?*?*IAzApplicationGroup,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateApplicationGroup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
                ppGroup: ?*?*IAzApplicationGroup,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
                ppGroup: ?*?*IAzApplicationGroup,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteApplicationGroup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrGroupName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Roles: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope,
                ppRoleCollection: ?*?*IAzRoles,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope,
                ppRoleCollection: ?*?*IAzRoles,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenRole: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrRoleName: ?BSTR,
                varReserved: VARIANT,
                ppRole: ?*?*IAzRole,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrRoleName: ?BSTR,
                varReserved: VARIANT,
                ppRole: ?*?*IAzRole,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateRole: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrRoleName: ?BSTR,
                varReserved: VARIANT,
                ppRole: ?*?*IAzRole,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrRoleName: ?BSTR,
                varReserved: VARIANT,
                ppRole: ?*?*IAzRole,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteRole: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrRoleName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrRoleName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Tasks: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope,
                ppTaskCollection: ?*?*IAzTasks,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope,
                ppTaskCollection: ?*?*IAzTasks,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenTask: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrTaskName: ?BSTR,
                varReserved: VARIANT,
                ppTask: ?*?*IAzTask,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrTaskName: ?BSTR,
                varReserved: VARIANT,
                ppTask: ?*?*IAzTask,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateTask: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrTaskName: ?BSTR,
                varReserved: VARIANT,
                ppTask: ?*?*IAzTask,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrTaskName: ?BSTR,
                varReserved: VARIANT,
                ppTask: ?*?*IAzTask,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteTask: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrTaskName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrTaskName: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Submit: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                lFlags: i32,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                lFlags: i32,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_CanBeDelegated: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_BizrulesWritable: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PolicyAdministratorsName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope,
                pvarAdmins: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope,
                pvarAdmins: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PolicyReadersName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope,
                pvarReaders: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope,
                pvarReaders: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPolicyAdministratorName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePolicyAdministratorName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrAdmin: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPolicyReaderName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePolicyReaderName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope,
                bstrReader: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_get_Name(self: *const T, pbstrName: ?*?BSTR) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).get_Name(@as(*const IAzScope, @ptrCast(self)), pbstrName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_put_Name(self: *const T, bstrName: ?BSTR) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).put_Name(@as(*const IAzScope, @ptrCast(self)), bstrName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_get_Description(self: *const T, pbstrDescription: ?*?BSTR) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).get_Description(@as(*const IAzScope, @ptrCast(self)), pbstrDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_put_Description(self: *const T, bstrDescription: ?BSTR) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).put_Description(@as(*const IAzScope, @ptrCast(self)), bstrDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_get_ApplicationData(self: *const T, pbstrApplicationData: ?*?BSTR) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).get_ApplicationData(@as(*const IAzScope, @ptrCast(self)), pbstrApplicationData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_put_ApplicationData(self: *const T, bstrApplicationData: ?BSTR) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).put_ApplicationData(@as(*const IAzScope, @ptrCast(self)), bstrApplicationData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_get_Writable(self: *const T, pfProp: ?*BOOL) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).get_Writable(@as(*const IAzScope, @ptrCast(self)), pfProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_GetProperty(self: *const T, lPropId: i32, varReserved: VARIANT, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).GetProperty(@as(*const IAzScope, @ptrCast(self)), lPropId, varReserved, pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_SetProperty(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).SetProperty(@as(*const IAzScope, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_AddPropertyItem(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).AddPropertyItem(@as(*const IAzScope, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_DeletePropertyItem(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).DeletePropertyItem(@as(*const IAzScope, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_get_PolicyAdministrators(self: *const T, pvarAdmins: ?*VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).get_PolicyAdministrators(@as(*const IAzScope, @ptrCast(self)), pvarAdmins);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_get_PolicyReaders(self: *const T, pvarReaders: ?*VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).get_PolicyReaders(@as(*const IAzScope, @ptrCast(self)), pvarReaders);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_AddPolicyAdministrator(self: *const T, bstrAdmin: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).AddPolicyAdministrator(@as(*const IAzScope, @ptrCast(self)), bstrAdmin, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_DeletePolicyAdministrator(self: *const T, bstrAdmin: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).DeletePolicyAdministrator(@as(*const IAzScope, @ptrCast(self)), bstrAdmin, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_AddPolicyReader(self: *const T, bstrReader: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).AddPolicyReader(@as(*const IAzScope, @ptrCast(self)), bstrReader, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_DeletePolicyReader(self: *const T, bstrReader: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).DeletePolicyReader(@as(*const IAzScope, @ptrCast(self)), bstrReader, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_get_ApplicationGroups(self: *const T, ppGroupCollection: ?*?*IAzApplicationGroups) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).get_ApplicationGroups(@as(*const IAzScope, @ptrCast(self)), ppGroupCollection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_OpenApplicationGroup(self: *const T, bstrGroupName: ?BSTR, varReserved: VARIANT, ppGroup: ?*?*IAzApplicationGroup) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).OpenApplicationGroup(@as(*const IAzScope, @ptrCast(self)), bstrGroupName, varReserved, ppGroup);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_CreateApplicationGroup(self: *const T, bstrGroupName: ?BSTR, varReserved: VARIANT, ppGroup: ?*?*IAzApplicationGroup) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).CreateApplicationGroup(@as(*const IAzScope, @ptrCast(self)), bstrGroupName, varReserved, ppGroup);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_DeleteApplicationGroup(self: *const T, bstrGroupName: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).DeleteApplicationGroup(@as(*const IAzScope, @ptrCast(self)), bstrGroupName, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_get_Roles(self: *const T, ppRoleCollection: ?*?*IAzRoles) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).get_Roles(@as(*const IAzScope, @ptrCast(self)), ppRoleCollection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_OpenRole(self: *const T, bstrRoleName: ?BSTR, varReserved: VARIANT, ppRole: ?*?*IAzRole) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).OpenRole(@as(*const IAzScope, @ptrCast(self)), bstrRoleName, varReserved, ppRole);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_CreateRole(self: *const T, bstrRoleName: ?BSTR, varReserved: VARIANT, ppRole: ?*?*IAzRole) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).CreateRole(@as(*const IAzScope, @ptrCast(self)), bstrRoleName, varReserved, ppRole);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_DeleteRole(self: *const T, bstrRoleName: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).DeleteRole(@as(*const IAzScope, @ptrCast(self)), bstrRoleName, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_get_Tasks(self: *const T, ppTaskCollection: ?*?*IAzTasks) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).get_Tasks(@as(*const IAzScope, @ptrCast(self)), ppTaskCollection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_OpenTask(self: *const T, bstrTaskName: ?BSTR, varReserved: VARIANT, ppTask: ?*?*IAzTask) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).OpenTask(@as(*const IAzScope, @ptrCast(self)), bstrTaskName, varReserved, ppTask);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_CreateTask(self: *const T, bstrTaskName: ?BSTR, varReserved: VARIANT, ppTask: ?*?*IAzTask) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).CreateTask(@as(*const IAzScope, @ptrCast(self)), bstrTaskName, varReserved, ppTask);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_DeleteTask(self: *const T, bstrTaskName: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).DeleteTask(@as(*const IAzScope, @ptrCast(self)), bstrTaskName, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_Submit(self: *const T, lFlags: i32, varReserved: VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).Submit(@as(*const IAzScope, @ptrCast(self)), lFlags, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_get_CanBeDelegated(self: *const T, pfProp: ?*BOOL) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).get_CanBeDelegated(@as(*const IAzScope, @ptrCast(self)), pfProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_get_BizrulesWritable(self: *const T, pfProp: ?*BOOL) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).get_BizrulesWritable(@as(*const IAzScope, @ptrCast(self)), pfProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_get_PolicyAdministratorsName(self: *const T, pvarAdmins: ?*VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).get_PolicyAdministratorsName(@as(*const IAzScope, @ptrCast(self)), pvarAdmins);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_get_PolicyReadersName(self: *const T, pvarReaders: ?*VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).get_PolicyReadersName(@as(*const IAzScope, @ptrCast(self)), pvarReaders);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_AddPolicyAdministratorName(self: *const T, bstrAdmin: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).AddPolicyAdministratorName(@as(*const IAzScope, @ptrCast(self)), bstrAdmin, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_DeletePolicyAdministratorName(self: *const T, bstrAdmin: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).DeletePolicyAdministratorName(@as(*const IAzScope, @ptrCast(self)), bstrAdmin, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_AddPolicyReaderName(self: *const T, bstrReader: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).AddPolicyReaderName(@as(*const IAzScope, @ptrCast(self)), bstrReader, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope_DeletePolicyReaderName(self: *const T, bstrReader: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzScope.VTable, @ptrCast(self.vtable)).DeletePolicyReaderName(@as(*const IAzScope, @ptrCast(self)), bstrReader, varReserved);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzScopes_Value = Guid.initString("78e14853-9f5e-406d-9b91-6bdba6973510");
pub const IID_IAzScopes = &IID_IAzScopes_Value;
pub const IAzScopes = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Item: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScopes,
                Index: i32,
                pvarObtPtr: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScopes,
                Index: i32,
                pvarObtPtr: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScopes,
                plCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScopes,
                plCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScopes,
                ppEnumPtr: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScopes,
                ppEnumPtr: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScopes_get_Item(self: *const T, Index: i32, pvarObtPtr: ?*VARIANT) HRESULT {
                return @as(*const IAzScopes.VTable, @ptrCast(self.vtable)).get_Item(@as(*const IAzScopes, @ptrCast(self)), Index, pvarObtPtr);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScopes_get_Count(self: *const T, plCount: ?*i32) HRESULT {
                return @as(*const IAzScopes.VTable, @ptrCast(self.vtable)).get_Count(@as(*const IAzScopes, @ptrCast(self)), plCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScopes_get__NewEnum(self: *const T, ppEnumPtr: ?*?*IUnknown) HRESULT {
                return @as(*const IAzScopes.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const IAzScopes, @ptrCast(self)), ppEnumPtr);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzApplicationGroup_Value = Guid.initString("f1b744cd-58a6-4e06-9fbf-36f6d779e21e");
pub const IID_IAzApplicationGroup = &IID_IAzApplicationGroup_Value;
pub const IAzApplicationGroup = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                bstrName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup,
                bstrName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Type: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                plProp: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup,
                plProp: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Type: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                lProp: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup,
                lProp: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_LdapQuery: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_LdapQuery: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_AppMembers: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_AppNonMembers: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Members: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_NonMembers: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                pbstrDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup,
                pbstrDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                bstrDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup,
                bstrDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddAppMember: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteAppMember: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddAppNonMember: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteAppNonMember: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddMember: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteMember: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddNonMember: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteNonMember: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Writable: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                lPropId: i32,
                varReserved: VARIANT,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                lPropId: i32,
                varReserved: VARIANT,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPropertyItem: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePropertyItem: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Submit: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                lFlags: i32,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                lFlags: i32,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddMemberName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteMemberName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddNonMemberName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteNonMemberName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_MembersName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_NonMembersName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_get_Name(self: *const T, pbstrName: ?*?BSTR) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).get_Name(@as(*const IAzApplicationGroup, @ptrCast(self)), pbstrName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_put_Name(self: *const T, bstrName: ?BSTR) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).put_Name(@as(*const IAzApplicationGroup, @ptrCast(self)), bstrName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_get_Type(self: *const T, plProp: ?*i32) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).get_Type(@as(*const IAzApplicationGroup, @ptrCast(self)), plProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_put_Type(self: *const T, lProp: i32) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).put_Type(@as(*const IAzApplicationGroup, @ptrCast(self)), lProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_get_LdapQuery(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).get_LdapQuery(@as(*const IAzApplicationGroup, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_put_LdapQuery(self: *const T, bstrProp: ?BSTR) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).put_LdapQuery(@as(*const IAzApplicationGroup, @ptrCast(self)), bstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_get_AppMembers(self: *const T, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).get_AppMembers(@as(*const IAzApplicationGroup, @ptrCast(self)), pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_get_AppNonMembers(self: *const T, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).get_AppNonMembers(@as(*const IAzApplicationGroup, @ptrCast(self)), pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_get_Members(self: *const T, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).get_Members(@as(*const IAzApplicationGroup, @ptrCast(self)), pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_get_NonMembers(self: *const T, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).get_NonMembers(@as(*const IAzApplicationGroup, @ptrCast(self)), pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_get_Description(self: *const T, pbstrDescription: ?*?BSTR) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).get_Description(@as(*const IAzApplicationGroup, @ptrCast(self)), pbstrDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_put_Description(self: *const T, bstrDescription: ?BSTR) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).put_Description(@as(*const IAzApplicationGroup, @ptrCast(self)), bstrDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_AddAppMember(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).AddAppMember(@as(*const IAzApplicationGroup, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_DeleteAppMember(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).DeleteAppMember(@as(*const IAzApplicationGroup, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_AddAppNonMember(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).AddAppNonMember(@as(*const IAzApplicationGroup, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_DeleteAppNonMember(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).DeleteAppNonMember(@as(*const IAzApplicationGroup, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_AddMember(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).AddMember(@as(*const IAzApplicationGroup, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_DeleteMember(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).DeleteMember(@as(*const IAzApplicationGroup, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_AddNonMember(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).AddNonMember(@as(*const IAzApplicationGroup, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_DeleteNonMember(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).DeleteNonMember(@as(*const IAzApplicationGroup, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_get_Writable(self: *const T, pfProp: ?*BOOL) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).get_Writable(@as(*const IAzApplicationGroup, @ptrCast(self)), pfProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_GetProperty(self: *const T, lPropId: i32, varReserved: VARIANT, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).GetProperty(@as(*const IAzApplicationGroup, @ptrCast(self)), lPropId, varReserved, pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_SetProperty(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).SetProperty(@as(*const IAzApplicationGroup, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_AddPropertyItem(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).AddPropertyItem(@as(*const IAzApplicationGroup, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_DeletePropertyItem(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).DeletePropertyItem(@as(*const IAzApplicationGroup, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_Submit(self: *const T, lFlags: i32, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).Submit(@as(*const IAzApplicationGroup, @ptrCast(self)), lFlags, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_AddMemberName(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).AddMemberName(@as(*const IAzApplicationGroup, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_DeleteMemberName(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).DeleteMemberName(@as(*const IAzApplicationGroup, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_AddNonMemberName(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).AddNonMemberName(@as(*const IAzApplicationGroup, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_DeleteNonMemberName(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).DeleteNonMemberName(@as(*const IAzApplicationGroup, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_get_MembersName(self: *const T, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).get_MembersName(@as(*const IAzApplicationGroup, @ptrCast(self)), pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup_get_NonMembersName(self: *const T, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzApplicationGroup.VTable, @ptrCast(self.vtable)).get_NonMembersName(@as(*const IAzApplicationGroup, @ptrCast(self)), pvarProp);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzApplicationGroups_Value = Guid.initString("4ce66ad5-9f3c-469d-a911-b99887a7e685");
pub const IID_IAzApplicationGroups = &IID_IAzApplicationGroups_Value;
pub const IAzApplicationGroups = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Item: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroups,
                Index: i32,
                pvarObtPtr: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroups,
                Index: i32,
                pvarObtPtr: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroups,
                plCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroups,
                plCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroups,
                ppEnumPtr: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroups,
                ppEnumPtr: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroups_get_Item(self: *const T, Index: i32, pvarObtPtr: ?*VARIANT) HRESULT {
                return @as(*const IAzApplicationGroups.VTable, @ptrCast(self.vtable)).get_Item(@as(*const IAzApplicationGroups, @ptrCast(self)), Index, pvarObtPtr);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroups_get_Count(self: *const T, plCount: ?*i32) HRESULT {
                return @as(*const IAzApplicationGroups.VTable, @ptrCast(self.vtable)).get_Count(@as(*const IAzApplicationGroups, @ptrCast(self)), plCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroups_get__NewEnum(self: *const T, ppEnumPtr: ?*?*IUnknown) HRESULT {
                return @as(*const IAzApplicationGroups.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const IAzApplicationGroups, @ptrCast(self)), ppEnumPtr);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzRole_Value = Guid.initString("859e0d8d-62d7-41d8-a034-c0cd5d43fdfa");
pub const IID_IAzRole = &IID_IAzRole_Value;
pub const IAzRole = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRole,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRole,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRole,
                bstrName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRole,
                bstrName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRole,
                pbstrDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRole,
                pbstrDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_Description: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRole,
                bstrDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRole,
                bstrDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ApplicationData: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRole,
                pbstrApplicationData: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRole,
                pbstrApplicationData: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_ApplicationData: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRole,
                bstrApplicationData: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRole,
                bstrApplicationData: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddAppMember: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteAppMember: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddTask: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteTask: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddOperation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteOperation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddMember: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteMember: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Writable: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRole,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRole,
                pfProp: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRole,
                lPropId: i32,
                varReserved: VARIANT,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRole,
                lPropId: i32,
                varReserved: VARIANT,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRole,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRole,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_AppMembers: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRole,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRole,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Members: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRole,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRole,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Operations: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRole,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRole,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Tasks: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRole,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRole,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPropertyItem: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRole,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRole,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeletePropertyItem: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRole,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRole,
                lPropId: i32,
                varProp: VARIANT,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Submit: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRole,
                lFlags: i32,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRole,
                lFlags: i32,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddMemberName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteMemberName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRole,
                bstrProp: ?BSTR,
                varReserved: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_MembersName: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRole,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRole,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_get_Name(self: *const T, pbstrName: ?*?BSTR) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).get_Name(@as(*const IAzRole, @ptrCast(self)), pbstrName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_put_Name(self: *const T, bstrName: ?BSTR) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).put_Name(@as(*const IAzRole, @ptrCast(self)), bstrName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_get_Description(self: *const T, pbstrDescription: ?*?BSTR) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).get_Description(@as(*const IAzRole, @ptrCast(self)), pbstrDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_put_Description(self: *const T, bstrDescription: ?BSTR) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).put_Description(@as(*const IAzRole, @ptrCast(self)), bstrDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_get_ApplicationData(self: *const T, pbstrApplicationData: ?*?BSTR) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).get_ApplicationData(@as(*const IAzRole, @ptrCast(self)), pbstrApplicationData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_put_ApplicationData(self: *const T, bstrApplicationData: ?BSTR) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).put_ApplicationData(@as(*const IAzRole, @ptrCast(self)), bstrApplicationData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_AddAppMember(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).AddAppMember(@as(*const IAzRole, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_DeleteAppMember(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).DeleteAppMember(@as(*const IAzRole, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_AddTask(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).AddTask(@as(*const IAzRole, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_DeleteTask(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).DeleteTask(@as(*const IAzRole, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_AddOperation(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).AddOperation(@as(*const IAzRole, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_DeleteOperation(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).DeleteOperation(@as(*const IAzRole, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_AddMember(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).AddMember(@as(*const IAzRole, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_DeleteMember(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).DeleteMember(@as(*const IAzRole, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_get_Writable(self: *const T, pfProp: ?*BOOL) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).get_Writable(@as(*const IAzRole, @ptrCast(self)), pfProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_GetProperty(self: *const T, lPropId: i32, varReserved: VARIANT, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).GetProperty(@as(*const IAzRole, @ptrCast(self)), lPropId, varReserved, pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_SetProperty(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).SetProperty(@as(*const IAzRole, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_get_AppMembers(self: *const T, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).get_AppMembers(@as(*const IAzRole, @ptrCast(self)), pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_get_Members(self: *const T, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).get_Members(@as(*const IAzRole, @ptrCast(self)), pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_get_Operations(self: *const T, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).get_Operations(@as(*const IAzRole, @ptrCast(self)), pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_get_Tasks(self: *const T, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).get_Tasks(@as(*const IAzRole, @ptrCast(self)), pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_AddPropertyItem(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).AddPropertyItem(@as(*const IAzRole, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_DeletePropertyItem(self: *const T, lPropId: i32, varProp: VARIANT, varReserved: VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).DeletePropertyItem(@as(*const IAzRole, @ptrCast(self)), lPropId, varProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_Submit(self: *const T, lFlags: i32, varReserved: VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).Submit(@as(*const IAzRole, @ptrCast(self)), lFlags, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_AddMemberName(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).AddMemberName(@as(*const IAzRole, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_DeleteMemberName(self: *const T, bstrProp: ?BSTR, varReserved: VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).DeleteMemberName(@as(*const IAzRole, @ptrCast(self)), bstrProp, varReserved);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRole_get_MembersName(self: *const T, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzRole.VTable, @ptrCast(self.vtable)).get_MembersName(@as(*const IAzRole, @ptrCast(self)), pvarProp);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzRoles_Value = Guid.initString("95e0f119-13b4-4dae-b65f-2f7d60d822e4");
pub const IID_IAzRoles = &IID_IAzRoles_Value;
pub const IAzRoles = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Item: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRoles,
                Index: i32,
                pvarObtPtr: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRoles,
                Index: i32,
                pvarObtPtr: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRoles,
                plCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRoles,
                plCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRoles,
                ppEnumPtr: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRoles,
                ppEnumPtr: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoles_get_Item(self: *const T, Index: i32, pvarObtPtr: ?*VARIANT) HRESULT {
                return @as(*const IAzRoles.VTable, @ptrCast(self.vtable)).get_Item(@as(*const IAzRoles, @ptrCast(self)), Index, pvarObtPtr);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoles_get_Count(self: *const T, plCount: ?*i32) HRESULT {
                return @as(*const IAzRoles.VTable, @ptrCast(self.vtable)).get_Count(@as(*const IAzRoles, @ptrCast(self)), plCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoles_get__NewEnum(self: *const T, ppEnumPtr: ?*?*IUnknown) HRESULT {
                return @as(*const IAzRoles.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const IAzRoles, @ptrCast(self)), ppEnumPtr);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzClientContext_Value = Guid.initString("eff1f00b-488a-466d-afd9-a401c5f9eef5");
pub const IID_IAzClientContext = &IID_IAzClientContext_Value;
pub const IAzClientContext = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        AccessCheck: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzClientContext,
                bstrObjectName: ?BSTR,
                varScopeNames: VARIANT,
                varOperations: VARIANT,
                varParameterNames: VARIANT,
                varParameterValues: VARIANT,
                varInterfaceNames: VARIANT,
                varInterfaceFlags: VARIANT,
                varInterfaces: VARIANT,
                pvarResults: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzClientContext,
                bstrObjectName: ?BSTR,
                varScopeNames: VARIANT,
                varOperations: VARIANT,
                varParameterNames: VARIANT,
                varParameterValues: VARIANT,
                varInterfaceNames: VARIANT,
                varInterfaceFlags: VARIANT,
                varInterfaces: VARIANT,
                pvarResults: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetBusinessRuleString: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzClientContext,
                pbstrBusinessRuleString: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzClientContext,
                pbstrBusinessRuleString: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_UserDn: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzClientContext,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzClientContext,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_UserSamCompat: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzClientContext,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzClientContext,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_UserDisplay: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzClientContext,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzClientContext,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_UserGuid: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzClientContext,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzClientContext,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_UserCanonical: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzClientContext,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzClientContext,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_UserUpn: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzClientContext,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzClientContext,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_UserDnsSamCompat: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzClientContext,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzClientContext,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzClientContext,
                lPropId: i32,
                varReserved: VARIANT,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzClientContext,
                lPropId: i32,
                varReserved: VARIANT,
                pvarProp: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetRoles: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzClientContext,
                bstrScopeName: ?BSTR,
                pvarRoleNames: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzClientContext,
                bstrScopeName: ?BSTR,
                pvarRoleNames: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_RoleForAccessCheck: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzClientContext,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzClientContext,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_RoleForAccessCheck: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzClientContext,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzClientContext,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext_AccessCheck(self: *const T, bstrObjectName: ?BSTR, varScopeNames: VARIANT, varOperations: VARIANT, varParameterNames: VARIANT, varParameterValues: VARIANT, varInterfaceNames: VARIANT, varInterfaceFlags: VARIANT, varInterfaces: VARIANT, pvarResults: ?*VARIANT) HRESULT {
                return @as(*const IAzClientContext.VTable, @ptrCast(self.vtable)).AccessCheck(@as(*const IAzClientContext, @ptrCast(self)), bstrObjectName, varScopeNames, varOperations, varParameterNames, varParameterValues, varInterfaceNames, varInterfaceFlags, varInterfaces, pvarResults);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext_GetBusinessRuleString(self: *const T, pbstrBusinessRuleString: ?*?BSTR) HRESULT {
                return @as(*const IAzClientContext.VTable, @ptrCast(self.vtable)).GetBusinessRuleString(@as(*const IAzClientContext, @ptrCast(self)), pbstrBusinessRuleString);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext_get_UserDn(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzClientContext.VTable, @ptrCast(self.vtable)).get_UserDn(@as(*const IAzClientContext, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext_get_UserSamCompat(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzClientContext.VTable, @ptrCast(self.vtable)).get_UserSamCompat(@as(*const IAzClientContext, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext_get_UserDisplay(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzClientContext.VTable, @ptrCast(self.vtable)).get_UserDisplay(@as(*const IAzClientContext, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext_get_UserGuid(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzClientContext.VTable, @ptrCast(self.vtable)).get_UserGuid(@as(*const IAzClientContext, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext_get_UserCanonical(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzClientContext.VTable, @ptrCast(self.vtable)).get_UserCanonical(@as(*const IAzClientContext, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext_get_UserUpn(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzClientContext.VTable, @ptrCast(self.vtable)).get_UserUpn(@as(*const IAzClientContext, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext_get_UserDnsSamCompat(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzClientContext.VTable, @ptrCast(self.vtable)).get_UserDnsSamCompat(@as(*const IAzClientContext, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext_GetProperty(self: *const T, lPropId: i32, varReserved: VARIANT, pvarProp: ?*VARIANT) HRESULT {
                return @as(*const IAzClientContext.VTable, @ptrCast(self.vtable)).GetProperty(@as(*const IAzClientContext, @ptrCast(self)), lPropId, varReserved, pvarProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext_GetRoles(self: *const T, bstrScopeName: ?BSTR, pvarRoleNames: ?*VARIANT) HRESULT {
                return @as(*const IAzClientContext.VTable, @ptrCast(self.vtable)).GetRoles(@as(*const IAzClientContext, @ptrCast(self)), bstrScopeName, pvarRoleNames);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext_get_RoleForAccessCheck(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzClientContext.VTable, @ptrCast(self.vtable)).get_RoleForAccessCheck(@as(*const IAzClientContext, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext_put_RoleForAccessCheck(self: *const T, bstrProp: ?BSTR) HRESULT {
                return @as(*const IAzClientContext.VTable, @ptrCast(self.vtable)).put_RoleForAccessCheck(@as(*const IAzClientContext, @ptrCast(self)), bstrProp);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windowsServer2008'
const IID_IAzClientContext2_Value = Guid.initString("2b0c92b8-208a-488a-8f81-e4edb22111cd");
pub const IID_IAzClientContext2 = &IID_IAzClientContext2_Value;
pub const IAzClientContext2 = extern struct {
    pub const VTable = extern struct {
        base: IAzClientContext.VTable,
        GetAssignedScopesPage: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzClientContext2,
                lOptions: i32,
                PageSize: i32,
                pvarCursor: ?*VARIANT,
                pvarScopeNames: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzClientContext2,
                lOptions: i32,
                PageSize: i32,
                pvarCursor: ?*VARIANT,
                pvarScopeNames: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddRoles: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzClientContext2,
                varRoles: VARIANT,
                bstrScopeName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzClientContext2,
                varRoles: VARIANT,
                bstrScopeName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddApplicationGroups: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzClientContext2,
                varApplicationGroups: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzClientContext2,
                varApplicationGroups: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddStringSids: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzClientContext2,
                varStringSids: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzClientContext2,
                varStringSids: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_LDAPQueryDN: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzClientContext2,
                bstrLDAPQueryDN: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzClientContext2,
                bstrLDAPQueryDN: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_LDAPQueryDN: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzClientContext2,
                pbstrLDAPQueryDN: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzClientContext2,
                pbstrLDAPQueryDN: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IAzClientContext.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext2_GetAssignedScopesPage(self: *const T, lOptions: i32, PageSize: i32, pvarCursor: ?*VARIANT, pvarScopeNames: ?*VARIANT) HRESULT {
                return @as(*const IAzClientContext2.VTable, @ptrCast(self.vtable)).GetAssignedScopesPage(@as(*const IAzClientContext2, @ptrCast(self)), lOptions, PageSize, pvarCursor, pvarScopeNames);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext2_AddRoles(self: *const T, varRoles: VARIANT, bstrScopeName: ?BSTR) HRESULT {
                return @as(*const IAzClientContext2.VTable, @ptrCast(self.vtable)).AddRoles(@as(*const IAzClientContext2, @ptrCast(self)), varRoles, bstrScopeName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext2_AddApplicationGroups(self: *const T, varApplicationGroups: VARIANT) HRESULT {
                return @as(*const IAzClientContext2.VTable, @ptrCast(self.vtable)).AddApplicationGroups(@as(*const IAzClientContext2, @ptrCast(self)), varApplicationGroups);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext2_AddStringSids(self: *const T, varStringSids: VARIANT) HRESULT {
                return @as(*const IAzClientContext2.VTable, @ptrCast(self.vtable)).AddStringSids(@as(*const IAzClientContext2, @ptrCast(self)), varStringSids);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext2_put_LDAPQueryDN(self: *const T, bstrLDAPQueryDN: ?BSTR) HRESULT {
                return @as(*const IAzClientContext2.VTable, @ptrCast(self.vtable)).put_LDAPQueryDN(@as(*const IAzClientContext2, @ptrCast(self)), bstrLDAPQueryDN);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext2_get_LDAPQueryDN(self: *const T, pbstrLDAPQueryDN: ?*?BSTR) HRESULT {
                return @as(*const IAzClientContext2.VTable, @ptrCast(self.vtable)).get_LDAPQueryDN(@as(*const IAzClientContext2, @ptrCast(self)), pbstrLDAPQueryDN);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzBizRuleContext_Value = Guid.initString("e192f17d-d59f-455e-a152-940316cd77b2");
pub const IID_IAzBizRuleContext = &IID_IAzBizRuleContext_Value;
pub const IAzBizRuleContext = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_BusinessRuleResult: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzBizRuleContext,
                bResult: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzBizRuleContext,
                bResult: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_BusinessRuleString: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzBizRuleContext,
                bstrBusinessRuleString: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzBizRuleContext,
                bstrBusinessRuleString: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_BusinessRuleString: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzBizRuleContext,
                pbstrBusinessRuleString: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzBizRuleContext,
                pbstrBusinessRuleString: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetParameter: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzBizRuleContext,
                bstrParameterName: ?BSTR,
                pvarParameterValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzBizRuleContext,
                bstrParameterName: ?BSTR,
                pvarParameterValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzBizRuleContext_put_BusinessRuleResult(self: *const T, bResult: BOOL) HRESULT {
                return @as(*const IAzBizRuleContext.VTable, @ptrCast(self.vtable)).put_BusinessRuleResult(@as(*const IAzBizRuleContext, @ptrCast(self)), bResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzBizRuleContext_put_BusinessRuleString(self: *const T, bstrBusinessRuleString: ?BSTR) HRESULT {
                return @as(*const IAzBizRuleContext.VTable, @ptrCast(self.vtable)).put_BusinessRuleString(@as(*const IAzBizRuleContext, @ptrCast(self)), bstrBusinessRuleString);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzBizRuleContext_get_BusinessRuleString(self: *const T, pbstrBusinessRuleString: ?*?BSTR) HRESULT {
                return @as(*const IAzBizRuleContext.VTable, @ptrCast(self.vtable)).get_BusinessRuleString(@as(*const IAzBizRuleContext, @ptrCast(self)), pbstrBusinessRuleString);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzBizRuleContext_GetParameter(self: *const T, bstrParameterName: ?BSTR, pvarParameterValue: ?*VARIANT) HRESULT {
                return @as(*const IAzBizRuleContext.VTable, @ptrCast(self.vtable)).GetParameter(@as(*const IAzBizRuleContext, @ptrCast(self)), bstrParameterName, pvarParameterValue);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzBizRuleParameters_Value = Guid.initString("fc17685f-e25d-4dcd-bae1-276ec9533cb5");
pub const IID_IAzBizRuleParameters = &IID_IAzBizRuleParameters_Value;
pub const IAzBizRuleParameters = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        AddParameter: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzBizRuleParameters,
                bstrParameterName: ?BSTR,
                varParameterValue: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzBizRuleParameters,
                bstrParameterName: ?BSTR,
                varParameterValue: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddParameters: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzBizRuleParameters,
                varParameterNames: VARIANT,
                varParameterValues: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzBizRuleParameters,
                varParameterNames: VARIANT,
                varParameterValues: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetParameterValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzBizRuleParameters,
                bstrParameterName: ?BSTR,
                pvarParameterValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzBizRuleParameters,
                bstrParameterName: ?BSTR,
                pvarParameterValue: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Remove: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzBizRuleParameters,
                varParameterName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzBizRuleParameters,
                varParameterName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveAll: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzBizRuleParameters,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzBizRuleParameters,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzBizRuleParameters,
                plCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzBizRuleParameters,
                plCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzBizRuleParameters_AddParameter(self: *const T, bstrParameterName: ?BSTR, varParameterValue: VARIANT) HRESULT {
                return @as(*const IAzBizRuleParameters.VTable, @ptrCast(self.vtable)).AddParameter(@as(*const IAzBizRuleParameters, @ptrCast(self)), bstrParameterName, varParameterValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzBizRuleParameters_AddParameters(self: *const T, varParameterNames: VARIANT, varParameterValues: VARIANT) HRESULT {
                return @as(*const IAzBizRuleParameters.VTable, @ptrCast(self.vtable)).AddParameters(@as(*const IAzBizRuleParameters, @ptrCast(self)), varParameterNames, varParameterValues);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzBizRuleParameters_GetParameterValue(self: *const T, bstrParameterName: ?BSTR, pvarParameterValue: ?*VARIANT) HRESULT {
                return @as(*const IAzBizRuleParameters.VTable, @ptrCast(self.vtable)).GetParameterValue(@as(*const IAzBizRuleParameters, @ptrCast(self)), bstrParameterName, pvarParameterValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzBizRuleParameters_Remove(self: *const T, varParameterName: ?BSTR) HRESULT {
                return @as(*const IAzBizRuleParameters.VTable, @ptrCast(self.vtable)).Remove(@as(*const IAzBizRuleParameters, @ptrCast(self)), varParameterName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzBizRuleParameters_RemoveAll(self: *const T) HRESULT {
                return @as(*const IAzBizRuleParameters.VTable, @ptrCast(self.vtable)).RemoveAll(@as(*const IAzBizRuleParameters, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzBizRuleParameters_get_Count(self: *const T, plCount: ?*u32) HRESULT {
                return @as(*const IAzBizRuleParameters.VTable, @ptrCast(self.vtable)).get_Count(@as(*const IAzBizRuleParameters, @ptrCast(self)), plCount);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzBizRuleInterfaces_Value = Guid.initString("e94128c7-e9da-44cc-b0bd-53036f3aab3d");
pub const IID_IAzBizRuleInterfaces = &IID_IAzBizRuleInterfaces_Value;
pub const IAzBizRuleInterfaces = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        AddInterface: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzBizRuleInterfaces,
                bstrInterfaceName: ?BSTR,
                lInterfaceFlag: i32,
                varInterface: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzBizRuleInterfaces,
                bstrInterfaceName: ?BSTR,
                lInterfaceFlag: i32,
                varInterface: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddInterfaces: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzBizRuleInterfaces,
                varInterfaceNames: VARIANT,
                varInterfaceFlags: VARIANT,
                varInterfaces: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzBizRuleInterfaces,
                varInterfaceNames: VARIANT,
                varInterfaceFlags: VARIANT,
                varInterfaces: VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInterfaceValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzBizRuleInterfaces,
                bstrInterfaceName: ?BSTR,
                lInterfaceFlag: ?*i32,
                varInterface: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzBizRuleInterfaces,
                bstrInterfaceName: ?BSTR,
                lInterfaceFlag: ?*i32,
                varInterface: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Remove: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzBizRuleInterfaces,
                bstrInterfaceName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzBizRuleInterfaces,
                bstrInterfaceName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveAll: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzBizRuleInterfaces,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzBizRuleInterfaces,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzBizRuleInterfaces,
                plCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzBizRuleInterfaces,
                plCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzBizRuleInterfaces_AddInterface(self: *const T, bstrInterfaceName: ?BSTR, lInterfaceFlag: i32, varInterface: VARIANT) HRESULT {
                return @as(*const IAzBizRuleInterfaces.VTable, @ptrCast(self.vtable)).AddInterface(@as(*const IAzBizRuleInterfaces, @ptrCast(self)), bstrInterfaceName, lInterfaceFlag, varInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzBizRuleInterfaces_AddInterfaces(self: *const T, varInterfaceNames: VARIANT, varInterfaceFlags: VARIANT, varInterfaces: VARIANT) HRESULT {
                return @as(*const IAzBizRuleInterfaces.VTable, @ptrCast(self.vtable)).AddInterfaces(@as(*const IAzBizRuleInterfaces, @ptrCast(self)), varInterfaceNames, varInterfaceFlags, varInterfaces);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzBizRuleInterfaces_GetInterfaceValue(self: *const T, bstrInterfaceName: ?BSTR, lInterfaceFlag: ?*i32, varInterface: ?*VARIANT) HRESULT {
                return @as(*const IAzBizRuleInterfaces.VTable, @ptrCast(self.vtable)).GetInterfaceValue(@as(*const IAzBizRuleInterfaces, @ptrCast(self)), bstrInterfaceName, lInterfaceFlag, varInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzBizRuleInterfaces_Remove(self: *const T, bstrInterfaceName: ?BSTR) HRESULT {
                return @as(*const IAzBizRuleInterfaces.VTable, @ptrCast(self.vtable)).Remove(@as(*const IAzBizRuleInterfaces, @ptrCast(self)), bstrInterfaceName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzBizRuleInterfaces_RemoveAll(self: *const T) HRESULT {
                return @as(*const IAzBizRuleInterfaces.VTable, @ptrCast(self.vtable)).RemoveAll(@as(*const IAzBizRuleInterfaces, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzBizRuleInterfaces_get_Count(self: *const T, plCount: ?*u32) HRESULT {
                return @as(*const IAzBizRuleInterfaces.VTable, @ptrCast(self.vtable)).get_Count(@as(*const IAzBizRuleInterfaces, @ptrCast(self)), plCount);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzClientContext3_Value = Guid.initString("11894fde-1deb-4b4b-8907-6d1cda1f5d4f");
pub const IID_IAzClientContext3 = &IID_IAzClientContext3_Value;
pub const IAzClientContext3 = extern struct {
    pub const VTable = extern struct {
        base: IAzClientContext2.VTable,
        AccessCheck2: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzClientContext3,
                bstrObjectName: ?BSTR,
                bstrScopeName: ?BSTR,
                lOperation: i32,
                plResult: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzClientContext3,
                bstrObjectName: ?BSTR,
                bstrScopeName: ?BSTR,
                lOperation: i32,
                plResult: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        IsInRoleAssignment: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzClientContext3,
                bstrScopeName: ?BSTR,
                bstrRoleName: ?BSTR,
                pbIsInRole: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzClientContext3,
                bstrScopeName: ?BSTR,
                bstrRoleName: ?BSTR,
                pbIsInRole: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetOperations: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzClientContext3,
                bstrScopeName: ?BSTR,
                ppOperationCollection: ?*?*IAzOperations,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzClientContext3,
                bstrScopeName: ?BSTR,
                ppOperationCollection: ?*?*IAzOperations,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetTasks: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzClientContext3,
                bstrScopeName: ?BSTR,
                ppTaskCollection: ?*?*IAzTasks,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzClientContext3,
                bstrScopeName: ?BSTR,
                ppTaskCollection: ?*?*IAzTasks,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_BizRuleParameters: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzClientContext3,
                ppBizRuleParam: ?*?*IAzBizRuleParameters,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzClientContext3,
                ppBizRuleParam: ?*?*IAzBizRuleParameters,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_BizRuleInterfaces: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzClientContext3,
                ppBizRuleInterfaces: ?*?*IAzBizRuleInterfaces,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzClientContext3,
                ppBizRuleInterfaces: ?*?*IAzBizRuleInterfaces,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetGroups: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzClientContext3,
                bstrScopeName: ?BSTR,
                ulOptions: AZ_PROP_CONSTANTS,
                pGroupArray: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzClientContext3,
                bstrScopeName: ?BSTR,
                ulOptions: AZ_PROP_CONSTANTS,
                pGroupArray: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Sids: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzClientContext3,
                pStringSidArray: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzClientContext3,
                pStringSidArray: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IAzClientContext2.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext3_AccessCheck2(self: *const T, bstrObjectName: ?BSTR, bstrScopeName: ?BSTR, lOperation: i32, plResult: ?*u32) HRESULT {
                return @as(*const IAzClientContext3.VTable, @ptrCast(self.vtable)).AccessCheck2(@as(*const IAzClientContext3, @ptrCast(self)), bstrObjectName, bstrScopeName, lOperation, plResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext3_IsInRoleAssignment(self: *const T, bstrScopeName: ?BSTR, bstrRoleName: ?BSTR, pbIsInRole: ?*i16) HRESULT {
                return @as(*const IAzClientContext3.VTable, @ptrCast(self.vtable)).IsInRoleAssignment(@as(*const IAzClientContext3, @ptrCast(self)), bstrScopeName, bstrRoleName, pbIsInRole);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext3_GetOperations(self: *const T, bstrScopeName: ?BSTR, ppOperationCollection: ?*?*IAzOperations) HRESULT {
                return @as(*const IAzClientContext3.VTable, @ptrCast(self.vtable)).GetOperations(@as(*const IAzClientContext3, @ptrCast(self)), bstrScopeName, ppOperationCollection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext3_GetTasks(self: *const T, bstrScopeName: ?BSTR, ppTaskCollection: ?*?*IAzTasks) HRESULT {
                return @as(*const IAzClientContext3.VTable, @ptrCast(self.vtable)).GetTasks(@as(*const IAzClientContext3, @ptrCast(self)), bstrScopeName, ppTaskCollection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext3_get_BizRuleParameters(self: *const T, ppBizRuleParam: ?*?*IAzBizRuleParameters) HRESULT {
                return @as(*const IAzClientContext3.VTable, @ptrCast(self.vtable)).get_BizRuleParameters(@as(*const IAzClientContext3, @ptrCast(self)), ppBizRuleParam);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext3_get_BizRuleInterfaces(self: *const T, ppBizRuleInterfaces: ?*?*IAzBizRuleInterfaces) HRESULT {
                return @as(*const IAzClientContext3.VTable, @ptrCast(self.vtable)).get_BizRuleInterfaces(@as(*const IAzClientContext3, @ptrCast(self)), ppBizRuleInterfaces);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext3_GetGroups(self: *const T, bstrScopeName: ?BSTR, ulOptions: AZ_PROP_CONSTANTS, pGroupArray: ?*VARIANT) HRESULT {
                return @as(*const IAzClientContext3.VTable, @ptrCast(self.vtable)).GetGroups(@as(*const IAzClientContext3, @ptrCast(self)), bstrScopeName, ulOptions, pGroupArray);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzClientContext3_get_Sids(self: *const T, pStringSidArray: ?*VARIANT) HRESULT {
                return @as(*const IAzClientContext3.VTable, @ptrCast(self.vtable)).get_Sids(@as(*const IAzClientContext3, @ptrCast(self)), pStringSidArray);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzScope2_Value = Guid.initString("ee9fe8c9-c9f3-40e2-aa12-d1d8599727fd");
pub const IID_IAzScope2 = &IID_IAzScope2_Value;
pub const IAzScope2 = extern struct {
    pub const VTable = extern struct {
        base: IAzScope.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_RoleDefinitions: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope2,
                ppRoleDefinitions: ?*?*IAzRoleDefinitions,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope2,
                ppRoleDefinitions: ?*?*IAzRoleDefinitions,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateRoleDefinition: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope2,
                bstrRoleDefinitionName: ?BSTR,
                ppRoleDefinitions: ?*?*IAzRoleDefinition,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope2,
                bstrRoleDefinitionName: ?BSTR,
                ppRoleDefinitions: ?*?*IAzRoleDefinition,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenRoleDefinition: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope2,
                bstrRoleDefinitionName: ?BSTR,
                ppRoleDefinitions: ?*?*IAzRoleDefinition,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope2,
                bstrRoleDefinitionName: ?BSTR,
                ppRoleDefinitions: ?*?*IAzRoleDefinition,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteRoleDefinition: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope2,
                bstrRoleDefinitionName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope2,
                bstrRoleDefinitionName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_RoleAssignments: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzScope2,
                ppRoleAssignments: ?*?*IAzRoleAssignments,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzScope2,
                ppRoleAssignments: ?*?*IAzRoleAssignments,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateRoleAssignment: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope2,
                bstrRoleAssignmentName: ?BSTR,
                ppRoleAssignment: ?*?*IAzRoleAssignment,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope2,
                bstrRoleAssignmentName: ?BSTR,
                ppRoleAssignment: ?*?*IAzRoleAssignment,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenRoleAssignment: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope2,
                bstrRoleAssignmentName: ?BSTR,
                ppRoleAssignment: ?*?*IAzRoleAssignment,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope2,
                bstrRoleAssignmentName: ?BSTR,
                ppRoleAssignment: ?*?*IAzRoleAssignment,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteRoleAssignment: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzScope2,
                bstrRoleAssignmentName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzScope2,
                bstrRoleAssignmentName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IAzScope.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope2_get_RoleDefinitions(self: *const T, ppRoleDefinitions: ?*?*IAzRoleDefinitions) HRESULT {
                return @as(*const IAzScope2.VTable, @ptrCast(self.vtable)).get_RoleDefinitions(@as(*const IAzScope2, @ptrCast(self)), ppRoleDefinitions);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope2_CreateRoleDefinition(self: *const T, bstrRoleDefinitionName: ?BSTR, ppRoleDefinitions: ?*?*IAzRoleDefinition) HRESULT {
                return @as(*const IAzScope2.VTable, @ptrCast(self.vtable)).CreateRoleDefinition(@as(*const IAzScope2, @ptrCast(self)), bstrRoleDefinitionName, ppRoleDefinitions);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope2_OpenRoleDefinition(self: *const T, bstrRoleDefinitionName: ?BSTR, ppRoleDefinitions: ?*?*IAzRoleDefinition) HRESULT {
                return @as(*const IAzScope2.VTable, @ptrCast(self.vtable)).OpenRoleDefinition(@as(*const IAzScope2, @ptrCast(self)), bstrRoleDefinitionName, ppRoleDefinitions);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope2_DeleteRoleDefinition(self: *const T, bstrRoleDefinitionName: ?BSTR) HRESULT {
                return @as(*const IAzScope2.VTable, @ptrCast(self.vtable)).DeleteRoleDefinition(@as(*const IAzScope2, @ptrCast(self)), bstrRoleDefinitionName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope2_get_RoleAssignments(self: *const T, ppRoleAssignments: ?*?*IAzRoleAssignments) HRESULT {
                return @as(*const IAzScope2.VTable, @ptrCast(self.vtable)).get_RoleAssignments(@as(*const IAzScope2, @ptrCast(self)), ppRoleAssignments);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope2_CreateRoleAssignment(self: *const T, bstrRoleAssignmentName: ?BSTR, ppRoleAssignment: ?*?*IAzRoleAssignment) HRESULT {
                return @as(*const IAzScope2.VTable, @ptrCast(self.vtable)).CreateRoleAssignment(@as(*const IAzScope2, @ptrCast(self)), bstrRoleAssignmentName, ppRoleAssignment);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope2_OpenRoleAssignment(self: *const T, bstrRoleAssignmentName: ?BSTR, ppRoleAssignment: ?*?*IAzRoleAssignment) HRESULT {
                return @as(*const IAzScope2.VTable, @ptrCast(self.vtable)).OpenRoleAssignment(@as(*const IAzScope2, @ptrCast(self)), bstrRoleAssignmentName, ppRoleAssignment);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzScope2_DeleteRoleAssignment(self: *const T, bstrRoleAssignmentName: ?BSTR) HRESULT {
                return @as(*const IAzScope2.VTable, @ptrCast(self.vtable)).DeleteRoleAssignment(@as(*const IAzScope2, @ptrCast(self)), bstrRoleAssignmentName);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzApplication3_Value = Guid.initString("181c845e-7196-4a7d-ac2e-020c0bb7a303");
pub const IID_IAzApplication3 = &IID_IAzApplication3_Value;
pub const IAzApplication3 = extern struct {
    pub const VTable = extern struct {
        base: IAzApplication2.VTable,
        ScopeExists: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication3,
                bstrScopeName: ?BSTR,
                pbExist: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication3,
                bstrScopeName: ?BSTR,
                pbExist: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenScope2: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication3,
                bstrScopeName: ?BSTR,
                ppScope2: ?*?*IAzScope2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication3,
                bstrScopeName: ?BSTR,
                ppScope2: ?*?*IAzScope2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateScope2: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication3,
                bstrScopeName: ?BSTR,
                ppScope2: ?*?*IAzScope2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication3,
                bstrScopeName: ?BSTR,
                ppScope2: ?*?*IAzScope2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteScope2: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication3,
                bstrScopeName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication3,
                bstrScopeName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_RoleDefinitions: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication3,
                ppRoleDefinitions: ?*?*IAzRoleDefinitions,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication3,
                ppRoleDefinitions: ?*?*IAzRoleDefinitions,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateRoleDefinition: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication3,
                bstrRoleDefinitionName: ?BSTR,
                ppRoleDefinitions: ?*?*IAzRoleDefinition,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication3,
                bstrRoleDefinitionName: ?BSTR,
                ppRoleDefinitions: ?*?*IAzRoleDefinition,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenRoleDefinition: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication3,
                bstrRoleDefinitionName: ?BSTR,
                ppRoleDefinitions: ?*?*IAzRoleDefinition,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication3,
                bstrRoleDefinitionName: ?BSTR,
                ppRoleDefinitions: ?*?*IAzRoleDefinition,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteRoleDefinition: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication3,
                bstrRoleDefinitionName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication3,
                bstrRoleDefinitionName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_RoleAssignments: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication3,
                ppRoleAssignments: ?*?*IAzRoleAssignments,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication3,
                ppRoleAssignments: ?*?*IAzRoleAssignments,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateRoleAssignment: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication3,
                bstrRoleAssignmentName: ?BSTR,
                ppRoleAssignment: ?*?*IAzRoleAssignment,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication3,
                bstrRoleAssignmentName: ?BSTR,
                ppRoleAssignment: ?*?*IAzRoleAssignment,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenRoleAssignment: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication3,
                bstrRoleAssignmentName: ?BSTR,
                ppRoleAssignment: ?*?*IAzRoleAssignment,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication3,
                bstrRoleAssignmentName: ?BSTR,
                ppRoleAssignment: ?*?*IAzRoleAssignment,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteRoleAssignment: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplication3,
                bstrRoleAssignmentName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplication3,
                bstrRoleAssignmentName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_BizRulesEnabled: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication3,
                pbEnabled: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication3,
                pbEnabled: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_BizRulesEnabled: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplication3,
                bEnabled: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplication3,
                bEnabled: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IAzApplication2.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication3_ScopeExists(self: *const T, bstrScopeName: ?BSTR, pbExist: ?*i16) HRESULT {
                return @as(*const IAzApplication3.VTable, @ptrCast(self.vtable)).ScopeExists(@as(*const IAzApplication3, @ptrCast(self)), bstrScopeName, pbExist);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication3_OpenScope2(self: *const T, bstrScopeName: ?BSTR, ppScope2: ?*?*IAzScope2) HRESULT {
                return @as(*const IAzApplication3.VTable, @ptrCast(self.vtable)).OpenScope2(@as(*const IAzApplication3, @ptrCast(self)), bstrScopeName, ppScope2);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication3_CreateScope2(self: *const T, bstrScopeName: ?BSTR, ppScope2: ?*?*IAzScope2) HRESULT {
                return @as(*const IAzApplication3.VTable, @ptrCast(self.vtable)).CreateScope2(@as(*const IAzApplication3, @ptrCast(self)), bstrScopeName, ppScope2);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication3_DeleteScope2(self: *const T, bstrScopeName: ?BSTR) HRESULT {
                return @as(*const IAzApplication3.VTable, @ptrCast(self.vtable)).DeleteScope2(@as(*const IAzApplication3, @ptrCast(self)), bstrScopeName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication3_get_RoleDefinitions(self: *const T, ppRoleDefinitions: ?*?*IAzRoleDefinitions) HRESULT {
                return @as(*const IAzApplication3.VTable, @ptrCast(self.vtable)).get_RoleDefinitions(@as(*const IAzApplication3, @ptrCast(self)), ppRoleDefinitions);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication3_CreateRoleDefinition(self: *const T, bstrRoleDefinitionName: ?BSTR, ppRoleDefinitions: ?*?*IAzRoleDefinition) HRESULT {
                return @as(*const IAzApplication3.VTable, @ptrCast(self.vtable)).CreateRoleDefinition(@as(*const IAzApplication3, @ptrCast(self)), bstrRoleDefinitionName, ppRoleDefinitions);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication3_OpenRoleDefinition(self: *const T, bstrRoleDefinitionName: ?BSTR, ppRoleDefinitions: ?*?*IAzRoleDefinition) HRESULT {
                return @as(*const IAzApplication3.VTable, @ptrCast(self.vtable)).OpenRoleDefinition(@as(*const IAzApplication3, @ptrCast(self)), bstrRoleDefinitionName, ppRoleDefinitions);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication3_DeleteRoleDefinition(self: *const T, bstrRoleDefinitionName: ?BSTR) HRESULT {
                return @as(*const IAzApplication3.VTable, @ptrCast(self.vtable)).DeleteRoleDefinition(@as(*const IAzApplication3, @ptrCast(self)), bstrRoleDefinitionName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication3_get_RoleAssignments(self: *const T, ppRoleAssignments: ?*?*IAzRoleAssignments) HRESULT {
                return @as(*const IAzApplication3.VTable, @ptrCast(self.vtable)).get_RoleAssignments(@as(*const IAzApplication3, @ptrCast(self)), ppRoleAssignments);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication3_CreateRoleAssignment(self: *const T, bstrRoleAssignmentName: ?BSTR, ppRoleAssignment: ?*?*IAzRoleAssignment) HRESULT {
                return @as(*const IAzApplication3.VTable, @ptrCast(self.vtable)).CreateRoleAssignment(@as(*const IAzApplication3, @ptrCast(self)), bstrRoleAssignmentName, ppRoleAssignment);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication3_OpenRoleAssignment(self: *const T, bstrRoleAssignmentName: ?BSTR, ppRoleAssignment: ?*?*IAzRoleAssignment) HRESULT {
                return @as(*const IAzApplication3.VTable, @ptrCast(self.vtable)).OpenRoleAssignment(@as(*const IAzApplication3, @ptrCast(self)), bstrRoleAssignmentName, ppRoleAssignment);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication3_DeleteRoleAssignment(self: *const T, bstrRoleAssignmentName: ?BSTR) HRESULT {
                return @as(*const IAzApplication3.VTable, @ptrCast(self.vtable)).DeleteRoleAssignment(@as(*const IAzApplication3, @ptrCast(self)), bstrRoleAssignmentName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication3_get_BizRulesEnabled(self: *const T, pbEnabled: ?*i16) HRESULT {
                return @as(*const IAzApplication3.VTable, @ptrCast(self.vtable)).get_BizRulesEnabled(@as(*const IAzApplication3, @ptrCast(self)), pbEnabled);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplication3_put_BizRulesEnabled(self: *const T, bEnabled: i16) HRESULT {
                return @as(*const IAzApplication3.VTable, @ptrCast(self.vtable)).put_BizRulesEnabled(@as(*const IAzApplication3, @ptrCast(self)), bEnabled);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzOperation2_Value = Guid.initString("1f5ea01f-44a2-4184-9c48-a75b4dcc8ccc");
pub const IID_IAzOperation2 = &IID_IAzOperation2_Value;
pub const IAzOperation2 = extern struct {
    pub const VTable = extern struct {
        base: IAzOperation.VTable,
        RoleAssignments: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzOperation2,
                bstrScopeName: ?BSTR,
                bRecursive: i16,
                ppRoleAssignments: ?*?*IAzRoleAssignments,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzOperation2,
                bstrScopeName: ?BSTR,
                bRecursive: i16,
                ppRoleAssignments: ?*?*IAzRoleAssignments,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IAzOperation.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzOperation2_RoleAssignments(self: *const T, bstrScopeName: ?BSTR, bRecursive: i16, ppRoleAssignments: ?*?*IAzRoleAssignments) HRESULT {
                return @as(*const IAzOperation2.VTable, @ptrCast(self.vtable)).RoleAssignments(@as(*const IAzOperation2, @ptrCast(self)), bstrScopeName, bRecursive, ppRoleAssignments);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzRoleDefinitions_Value = Guid.initString("881f25a5-d755-4550-957a-d503a3b34001");
pub const IID_IAzRoleDefinitions = &IID_IAzRoleDefinitions_Value;
pub const IAzRoleDefinitions = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Item: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRoleDefinitions,
                Index: i32,
                pvarObtPtr: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRoleDefinitions,
                Index: i32,
                pvarObtPtr: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRoleDefinitions,
                plCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRoleDefinitions,
                plCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRoleDefinitions,
                ppEnumPtr: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRoleDefinitions,
                ppEnumPtr: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoleDefinitions_get_Item(self: *const T, Index: i32, pvarObtPtr: ?*VARIANT) HRESULT {
                return @as(*const IAzRoleDefinitions.VTable, @ptrCast(self.vtable)).get_Item(@as(*const IAzRoleDefinitions, @ptrCast(self)), Index, pvarObtPtr);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoleDefinitions_get_Count(self: *const T, plCount: ?*i32) HRESULT {
                return @as(*const IAzRoleDefinitions.VTable, @ptrCast(self.vtable)).get_Count(@as(*const IAzRoleDefinitions, @ptrCast(self)), plCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoleDefinitions_get__NewEnum(self: *const T, ppEnumPtr: ?*?*IUnknown) HRESULT {
                return @as(*const IAzRoleDefinitions.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const IAzRoleDefinitions, @ptrCast(self)), ppEnumPtr);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzRoleDefinition_Value = Guid.initString("d97fcea1-2599-44f1-9fc3-58e9fbe09466");
pub const IID_IAzRoleDefinition = &IID_IAzRoleDefinition_Value;
pub const IAzRoleDefinition = extern struct {
    pub const VTable = extern struct {
        base: IAzTask.VTable,
        RoleAssignments: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRoleDefinition,
                bstrScopeName: ?BSTR,
                bRecursive: i16,
                ppRoleAssignments: ?*?*IAzRoleAssignments,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRoleDefinition,
                bstrScopeName: ?BSTR,
                bRecursive: i16,
                ppRoleAssignments: ?*?*IAzRoleAssignments,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddRoleDefinition: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRoleDefinition,
                bstrRoleDefinition: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRoleDefinition,
                bstrRoleDefinition: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteRoleDefinition: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRoleDefinition,
                bstrRoleDefinition: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRoleDefinition,
                bstrRoleDefinition: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_RoleDefinitions: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRoleDefinition,
                ppRoleDefinitions: ?*?*IAzRoleDefinitions,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRoleDefinition,
                ppRoleDefinitions: ?*?*IAzRoleDefinitions,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IAzTask.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoleDefinition_RoleAssignments(self: *const T, bstrScopeName: ?BSTR, bRecursive: i16, ppRoleAssignments: ?*?*IAzRoleAssignments) HRESULT {
                return @as(*const IAzRoleDefinition.VTable, @ptrCast(self.vtable)).RoleAssignments(@as(*const IAzRoleDefinition, @ptrCast(self)), bstrScopeName, bRecursive, ppRoleAssignments);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoleDefinition_AddRoleDefinition(self: *const T, bstrRoleDefinition: ?BSTR) HRESULT {
                return @as(*const IAzRoleDefinition.VTable, @ptrCast(self.vtable)).AddRoleDefinition(@as(*const IAzRoleDefinition, @ptrCast(self)), bstrRoleDefinition);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoleDefinition_DeleteRoleDefinition(self: *const T, bstrRoleDefinition: ?BSTR) HRESULT {
                return @as(*const IAzRoleDefinition.VTable, @ptrCast(self.vtable)).DeleteRoleDefinition(@as(*const IAzRoleDefinition, @ptrCast(self)), bstrRoleDefinition);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoleDefinition_get_RoleDefinitions(self: *const T, ppRoleDefinitions: ?*?*IAzRoleDefinitions) HRESULT {
                return @as(*const IAzRoleDefinition.VTable, @ptrCast(self.vtable)).get_RoleDefinitions(@as(*const IAzRoleDefinition, @ptrCast(self)), ppRoleDefinitions);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzRoleAssignment_Value = Guid.initString("55647d31-0d5a-4fa3-b4ac-2b5f9ad5ab76");
pub const IID_IAzRoleAssignment = &IID_IAzRoleAssignment_Value;
pub const IAzRoleAssignment = extern struct {
    pub const VTable = extern struct {
        base: IAzRole.VTable,
        AddRoleDefinition: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRoleAssignment,
                bstrRoleDefinition: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRoleAssignment,
                bstrRoleDefinition: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DeleteRoleDefinition: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzRoleAssignment,
                bstrRoleDefinition: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzRoleAssignment,
                bstrRoleDefinition: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_RoleDefinitions: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRoleAssignment,
                ppRoleDefinitions: ?*?*IAzRoleDefinitions,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRoleAssignment,
                ppRoleDefinitions: ?*?*IAzRoleDefinitions,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Scope: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRoleAssignment,
                ppScope: ?*?*IAzScope,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRoleAssignment,
                ppScope: ?*?*IAzScope,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IAzRole.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoleAssignment_AddRoleDefinition(self: *const T, bstrRoleDefinition: ?BSTR) HRESULT {
                return @as(*const IAzRoleAssignment.VTable, @ptrCast(self.vtable)).AddRoleDefinition(@as(*const IAzRoleAssignment, @ptrCast(self)), bstrRoleDefinition);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoleAssignment_DeleteRoleDefinition(self: *const T, bstrRoleDefinition: ?BSTR) HRESULT {
                return @as(*const IAzRoleAssignment.VTable, @ptrCast(self.vtable)).DeleteRoleDefinition(@as(*const IAzRoleAssignment, @ptrCast(self)), bstrRoleDefinition);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoleAssignment_get_RoleDefinitions(self: *const T, ppRoleDefinitions: ?*?*IAzRoleDefinitions) HRESULT {
                return @as(*const IAzRoleAssignment.VTable, @ptrCast(self.vtable)).get_RoleDefinitions(@as(*const IAzRoleAssignment, @ptrCast(self)), ppRoleDefinitions);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoleAssignment_get_Scope(self: *const T, ppScope: ?*?*IAzScope) HRESULT {
                return @as(*const IAzRoleAssignment.VTable, @ptrCast(self.vtable)).get_Scope(@as(*const IAzRoleAssignment, @ptrCast(self)), ppScope);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzRoleAssignments_Value = Guid.initString("9c80b900-fceb-4d73-a0f4-c83b0bbf2481");
pub const IID_IAzRoleAssignments = &IID_IAzRoleAssignments_Value;
pub const IAzRoleAssignments = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Item: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRoleAssignments,
                Index: i32,
                pvarObtPtr: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRoleAssignments,
                Index: i32,
                pvarObtPtr: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Count: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRoleAssignments,
                plCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRoleAssignments,
                plCount: ?*i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzRoleAssignments,
                ppEnumPtr: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzRoleAssignments,
                ppEnumPtr: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoleAssignments_get_Item(self: *const T, Index: i32, pvarObtPtr: ?*VARIANT) HRESULT {
                return @as(*const IAzRoleAssignments.VTable, @ptrCast(self.vtable)).get_Item(@as(*const IAzRoleAssignments, @ptrCast(self)), Index, pvarObtPtr);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoleAssignments_get_Count(self: *const T, plCount: ?*i32) HRESULT {
                return @as(*const IAzRoleAssignments.VTable, @ptrCast(self.vtable)).get_Count(@as(*const IAzRoleAssignments, @ptrCast(self)), plCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzRoleAssignments_get__NewEnum(self: *const T, ppEnumPtr: ?*?*IUnknown) HRESULT {
                return @as(*const IAzRoleAssignments.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const IAzRoleAssignments, @ptrCast(self)), ppEnumPtr);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzPrincipalLocator_Value = Guid.initString("e5c3507d-ad6a-4992-9c7f-74ab480b44cc");
pub const IID_IAzPrincipalLocator = &IID_IAzPrincipalLocator_Value;
pub const IAzPrincipalLocator = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_NameResolver: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzPrincipalLocator,
                ppNameResolver: ?*?*IAzNameResolver,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzPrincipalLocator,
                ppNameResolver: ?*?*IAzNameResolver,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ObjectPicker: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzPrincipalLocator,
                ppObjectPicker: ?*?*IAzObjectPicker,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzPrincipalLocator,
                ppObjectPicker: ?*?*IAzObjectPicker,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzPrincipalLocator_get_NameResolver(self: *const T, ppNameResolver: ?*?*IAzNameResolver) HRESULT {
                return @as(*const IAzPrincipalLocator.VTable, @ptrCast(self.vtable)).get_NameResolver(@as(*const IAzPrincipalLocator, @ptrCast(self)), ppNameResolver);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzPrincipalLocator_get_ObjectPicker(self: *const T, ppObjectPicker: ?*?*IAzObjectPicker) HRESULT {
                return @as(*const IAzPrincipalLocator.VTable, @ptrCast(self.vtable)).get_ObjectPicker(@as(*const IAzPrincipalLocator, @ptrCast(self)), ppObjectPicker);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzNameResolver_Value = Guid.initString("504d0f15-73e2-43df-a870-a64f40714f53");
pub const IID_IAzNameResolver = &IID_IAzNameResolver_Value;
pub const IAzNameResolver = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        NameFromSid: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzNameResolver,
                bstrSid: ?BSTR,
                pSidType: ?*i32,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzNameResolver,
                bstrSid: ?BSTR,
                pSidType: ?*i32,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        NamesFromSids: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzNameResolver,
                vSids: VARIANT,
                pvSidTypes: ?*VARIANT,
                pvNames: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzNameResolver,
                vSids: VARIANT,
                pvSidTypes: ?*VARIANT,
                pvNames: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzNameResolver_NameFromSid(self: *const T, bstrSid: ?BSTR, pSidType: ?*i32, pbstrName: ?*?BSTR) HRESULT {
                return @as(*const IAzNameResolver.VTable, @ptrCast(self.vtable)).NameFromSid(@as(*const IAzNameResolver, @ptrCast(self)), bstrSid, pSidType, pbstrName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzNameResolver_NamesFromSids(self: *const T, vSids: VARIANT, pvSidTypes: ?*VARIANT, pvNames: ?*VARIANT) HRESULT {
                return @as(*const IAzNameResolver.VTable, @ptrCast(self.vtable)).NamesFromSids(@as(*const IAzNameResolver, @ptrCast(self)), vSids, pvSidTypes, pvNames);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzObjectPicker_Value = Guid.initString("63130a48-699a-42d8-bf01-c62ac3fb79f9");
pub const IID_IAzObjectPicker = &IID_IAzObjectPicker_Value;
pub const IAzObjectPicker = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        GetPrincipals: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzObjectPicker,
                hParentWnd: ?HWND,
                bstrTitle: ?BSTR,
                pvSidTypes: ?*VARIANT,
                pvNames: ?*VARIANT,
                pvSids: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzObjectPicker,
                hParentWnd: ?HWND,
                bstrTitle: ?BSTR,
                pvSidTypes: ?*VARIANT,
                pvNames: ?*VARIANT,
                pvSids: ?*VARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Name: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzObjectPicker,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzObjectPicker,
                pbstrName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzObjectPicker_GetPrincipals(self: *const T, hParentWnd: ?HWND, bstrTitle: ?BSTR, pvSidTypes: ?*VARIANT, pvNames: ?*VARIANT, pvSids: ?*VARIANT) HRESULT {
                return @as(*const IAzObjectPicker.VTable, @ptrCast(self.vtable)).GetPrincipals(@as(*const IAzObjectPicker, @ptrCast(self)), hParentWnd, bstrTitle, pvSidTypes, pvNames, pvSids);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzObjectPicker_get_Name(self: *const T, pbstrName: ?*?BSTR) HRESULT {
                return @as(*const IAzObjectPicker.VTable, @ptrCast(self.vtable)).get_Name(@as(*const IAzObjectPicker, @ptrCast(self)), pbstrName);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzApplicationGroup2_Value = Guid.initString("3f0613fc-b71a-464e-a11d-5b881a56cefa");
pub const IID_IAzApplicationGroup2 = &IID_IAzApplicationGroup2_Value;
pub const IAzApplicationGroup2 = extern struct {
    pub const VTable = extern struct {
        base: IAzApplicationGroup.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_BizRule: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup2,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup2,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_BizRule: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup2,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup2,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_BizRuleLanguage: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup2,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup2,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_BizRuleLanguage: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup2,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup2,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_BizRuleImportedPath: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup2,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup2,
                pbstrProp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_BizRuleImportedPath: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IAzApplicationGroup2,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IAzApplicationGroup2,
                bstrProp: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RoleAssignments: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzApplicationGroup2,
                bstrScopeName: ?BSTR,
                bRecursive: i16,
                ppRoleAssignments: ?*?*IAzRoleAssignments,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzApplicationGroup2,
                bstrScopeName: ?BSTR,
                bRecursive: i16,
                ppRoleAssignments: ?*?*IAzRoleAssignments,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IAzApplicationGroup.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup2_get_BizRule(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzApplicationGroup2.VTable, @ptrCast(self.vtable)).get_BizRule(@as(*const IAzApplicationGroup2, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup2_put_BizRule(self: *const T, bstrProp: ?BSTR) HRESULT {
                return @as(*const IAzApplicationGroup2.VTable, @ptrCast(self.vtable)).put_BizRule(@as(*const IAzApplicationGroup2, @ptrCast(self)), bstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup2_get_BizRuleLanguage(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzApplicationGroup2.VTable, @ptrCast(self.vtable)).get_BizRuleLanguage(@as(*const IAzApplicationGroup2, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup2_put_BizRuleLanguage(self: *const T, bstrProp: ?BSTR) HRESULT {
                return @as(*const IAzApplicationGroup2.VTable, @ptrCast(self.vtable)).put_BizRuleLanguage(@as(*const IAzApplicationGroup2, @ptrCast(self)), bstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup2_get_BizRuleImportedPath(self: *const T, pbstrProp: ?*?BSTR) HRESULT {
                return @as(*const IAzApplicationGroup2.VTable, @ptrCast(self.vtable)).get_BizRuleImportedPath(@as(*const IAzApplicationGroup2, @ptrCast(self)), pbstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup2_put_BizRuleImportedPath(self: *const T, bstrProp: ?BSTR) HRESULT {
                return @as(*const IAzApplicationGroup2.VTable, @ptrCast(self.vtable)).put_BizRuleImportedPath(@as(*const IAzApplicationGroup2, @ptrCast(self)), bstrProp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzApplicationGroup2_RoleAssignments(self: *const T, bstrScopeName: ?BSTR, bRecursive: i16, ppRoleAssignments: ?*?*IAzRoleAssignments) HRESULT {
                return @as(*const IAzApplicationGroup2.VTable, @ptrCast(self.vtable)).RoleAssignments(@as(*const IAzApplicationGroup2, @ptrCast(self)), bstrScopeName, bRecursive, ppRoleAssignments);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IAzTask2_Value = Guid.initString("03a9a5ee-48c8-4832-9025-aad503c46526");
pub const IID_IAzTask2 = &IID_IAzTask2_Value;
pub const IAzTask2 = extern struct {
    pub const VTable = extern struct {
        base: IAzTask.VTable,
        RoleAssignments: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IAzTask2,
                bstrScopeName: ?BSTR,
                bRecursive: i16,
                ppRoleAssignments: ?*?*IAzRoleAssignments,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IAzTask2,
                bstrScopeName: ?BSTR,
                bRecursive: i16,
                ppRoleAssignments: ?*?*IAzRoleAssignments,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IAzTask.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IAzTask2_RoleAssignments(self: *const T, bstrScopeName: ?BSTR, bRecursive: i16, ppRoleAssignments: ?*?*IAzRoleAssignments) HRESULT {
                return @as(*const IAzTask2.VTable, @ptrCast(self.vtable)).RoleAssignments(@as(*const IAzTask2, @ptrCast(self)), bstrScopeName, bRecursive, ppRoleAssignments);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const AZ_PROP_CONSTANTS = enum(i32) {
    PROP_NAME = 1,
    PROP_DESCRIPTION = 2,
    PROP_WRITABLE = 3,
    PROP_APPLICATION_DATA = 4,
    PROP_CHILD_CREATE = 5,
    MAX_APPLICATION_NAME_LENGTH = 512,
    MAX_OPERATION_NAME_LENGTH = 64,
    // MAX_TASK_NAME_LENGTH = 64, this enum value conflicts with MAX_OPERATION_NAME_LENGTH
    MAX_SCOPE_NAME_LENGTH = 65536,
    // MAX_GROUP_NAME_LENGTH = 64, this enum value conflicts with MAX_OPERATION_NAME_LENGTH
    // MAX_ROLE_NAME_LENGTH = 64, this enum value conflicts with MAX_OPERATION_NAME_LENGTH
    // MAX_NAME_LENGTH = 65536, this enum value conflicts with MAX_SCOPE_NAME_LENGTH
    MAX_DESCRIPTION_LENGTH = 1024,
    MAX_APPLICATION_DATA_LENGTH = 4096,
    // SUBMIT_FLAG_ABORT = 1, this enum value conflicts with PROP_NAME
    // SUBMIT_FLAG_FLUSH = 2, this enum value conflicts with PROP_DESCRIPTION
    // MAX_POLICY_URL_LENGTH = 65536, this enum value conflicts with MAX_SCOPE_NAME_LENGTH
    // AZSTORE_FLAG_CREATE = 1, this enum value conflicts with PROP_NAME
    // AZSTORE_FLAG_MANAGE_STORE_ONLY = 2, this enum value conflicts with PROP_DESCRIPTION
    // AZSTORE_FLAG_BATCH_UPDATE = 4, this enum value conflicts with PROP_APPLICATION_DATA
    AZSTORE_FLAG_AUDIT_IS_CRITICAL = 8,
    AZSTORE_FORCE_APPLICATION_CLOSE = 16,
    AZSTORE_NT6_FUNCTION_LEVEL = 32,
    AZSTORE_FLAG_MANAGE_ONLY_PASSIVE_SUBMIT = 32768,
    PROP_AZSTORE_DOMAIN_TIMEOUT = 100,
    AZSTORE_DEFAULT_DOMAIN_TIMEOUT = 15000,
    PROP_AZSTORE_SCRIPT_ENGINE_TIMEOUT = 101,
    AZSTORE_MIN_DOMAIN_TIMEOUT = 500,
    AZSTORE_MIN_SCRIPT_ENGINE_TIMEOUT = 5000,
    AZSTORE_DEFAULT_SCRIPT_ENGINE_TIMEOUT = 45000,
    PROP_AZSTORE_MAX_SCRIPT_ENGINES = 102,
    AZSTORE_DEFAULT_MAX_SCRIPT_ENGINES = 120,
    PROP_AZSTORE_MAJOR_VERSION = 103,
    PROP_AZSTORE_MINOR_VERSION = 104,
    PROP_AZSTORE_TARGET_MACHINE = 105,
    PROP_AZTORE_IS_ADAM_INSTANCE = 106,
    PROP_OPERATION_ID = 200,
    PROP_TASK_OPERATIONS = 300,
    PROP_TASK_BIZRULE = 301,
    PROP_TASK_BIZRULE_LANGUAGE = 302,
    PROP_TASK_TASKS = 303,
    PROP_TASK_BIZRULE_IMPORTED_PATH = 304,
    PROP_TASK_IS_ROLE_DEFINITION = 305,
    // MAX_TASK_BIZRULE_LENGTH = 65536, this enum value conflicts with MAX_SCOPE_NAME_LENGTH
    // MAX_TASK_BIZRULE_LANGUAGE_LENGTH = 64, this enum value conflicts with MAX_OPERATION_NAME_LENGTH
    // MAX_TASK_BIZRULE_IMPORTED_PATH_LENGTH = 512, this enum value conflicts with MAX_APPLICATION_NAME_LENGTH
    // MAX_BIZRULE_STRING = 65536, this enum value conflicts with MAX_SCOPE_NAME_LENGTH
    PROP_GROUP_TYPE = 400,
    // GROUPTYPE_LDAP_QUERY = 1, this enum value conflicts with PROP_NAME
    // GROUPTYPE_BASIC = 2, this enum value conflicts with PROP_DESCRIPTION
    // GROUPTYPE_BIZRULE = 3, this enum value conflicts with PROP_WRITABLE
    PROP_GROUP_APP_MEMBERS = 401,
    PROP_GROUP_APP_NON_MEMBERS = 402,
    PROP_GROUP_LDAP_QUERY = 403,
    // MAX_GROUP_LDAP_QUERY_LENGTH = 4096, this enum value conflicts with MAX_APPLICATION_DATA_LENGTH
    PROP_GROUP_MEMBERS = 404,
    PROP_GROUP_NON_MEMBERS = 405,
    PROP_GROUP_MEMBERS_NAME = 406,
    PROP_GROUP_NON_MEMBERS_NAME = 407,
    PROP_GROUP_BIZRULE = 408,
    PROP_GROUP_BIZRULE_LANGUAGE = 409,
    PROP_GROUP_BIZRULE_IMPORTED_PATH = 410,
    // MAX_GROUP_BIZRULE_LENGTH = 65536, this enum value conflicts with MAX_SCOPE_NAME_LENGTH
    // MAX_GROUP_BIZRULE_LANGUAGE_LENGTH = 64, this enum value conflicts with MAX_OPERATION_NAME_LENGTH
    // MAX_GROUP_BIZRULE_IMPORTED_PATH_LENGTH = 512, this enum value conflicts with MAX_APPLICATION_NAME_LENGTH
    // PROP_ROLE_APP_MEMBERS = 500, this enum value conflicts with AZSTORE_MIN_DOMAIN_TIMEOUT
    PROP_ROLE_MEMBERS = 501,
    PROP_ROLE_OPERATIONS = 502,
    PROP_ROLE_TASKS = 504,
    PROP_ROLE_MEMBERS_NAME = 505,
    PROP_SCOPE_BIZRULES_WRITABLE = 600,
    PROP_SCOPE_CAN_BE_DELEGATED = 601,
    PROP_CLIENT_CONTEXT_USER_DN = 700,
    PROP_CLIENT_CONTEXT_USER_SAM_COMPAT = 701,
    PROP_CLIENT_CONTEXT_USER_DISPLAY = 702,
    PROP_CLIENT_CONTEXT_USER_GUID = 703,
    PROP_CLIENT_CONTEXT_USER_CANONICAL = 704,
    PROP_CLIENT_CONTEXT_USER_UPN = 705,
    PROP_CLIENT_CONTEXT_USER_DNS_SAM_COMPAT = 707,
    PROP_CLIENT_CONTEXT_ROLE_FOR_ACCESS_CHECK = 708,
    PROP_CLIENT_CONTEXT_LDAP_QUERY_DN = 709,
    PROP_APPLICATION_AUTHZ_INTERFACE_CLSID = 800,
    PROP_APPLICATION_VERSION = 801,
    // MAX_APPLICATION_VERSION_LENGTH = 512, this enum value conflicts with MAX_APPLICATION_NAME_LENGTH
    PROP_APPLICATION_NAME = 802,
    PROP_APPLICATION_BIZRULE_ENABLED = 803,
    PROP_APPLY_STORE_SACL = 900,
    PROP_GENERATE_AUDITS = 901,
    PROP_POLICY_ADMINS = 902,
    PROP_POLICY_READERS = 903,
    PROP_DELEGATED_POLICY_USERS = 904,
    PROP_POLICY_ADMINS_NAME = 905,
    PROP_POLICY_READERS_NAME = 906,
    PROP_DELEGATED_POLICY_USERS_NAME = 907,
    // CLIENT_CONTEXT_SKIP_GROUP = 1, this enum value conflicts with PROP_NAME
    // CLIENT_CONTEXT_SKIP_LDAP_QUERY = 1, this enum value conflicts with PROP_NAME
    // CLIENT_CONTEXT_GET_GROUP_RECURSIVE = 2, this enum value conflicts with PROP_DESCRIPTION
    // CLIENT_CONTEXT_GET_GROUPS_STORE_LEVEL_ONLY = 2, this enum value conflicts with PROP_DESCRIPTION
};
pub const AZ_PROP_NAME = AZ_PROP_CONSTANTS.PROP_NAME;
pub const AZ_PROP_DESCRIPTION = AZ_PROP_CONSTANTS.PROP_DESCRIPTION;
pub const AZ_PROP_WRITABLE = AZ_PROP_CONSTANTS.PROP_WRITABLE;
pub const AZ_PROP_APPLICATION_DATA = AZ_PROP_CONSTANTS.PROP_APPLICATION_DATA;
pub const AZ_PROP_CHILD_CREATE = AZ_PROP_CONSTANTS.PROP_CHILD_CREATE;
pub const AZ_MAX_APPLICATION_NAME_LENGTH = AZ_PROP_CONSTANTS.MAX_APPLICATION_NAME_LENGTH;
pub const AZ_MAX_OPERATION_NAME_LENGTH = AZ_PROP_CONSTANTS.MAX_OPERATION_NAME_LENGTH;
pub const AZ_MAX_TASK_NAME_LENGTH = AZ_PROP_CONSTANTS.MAX_OPERATION_NAME_LENGTH;
pub const AZ_MAX_SCOPE_NAME_LENGTH = AZ_PROP_CONSTANTS.MAX_SCOPE_NAME_LENGTH;
pub const AZ_MAX_GROUP_NAME_LENGTH = AZ_PROP_CONSTANTS.MAX_OPERATION_NAME_LENGTH;
pub const AZ_MAX_ROLE_NAME_LENGTH = AZ_PROP_CONSTANTS.MAX_OPERATION_NAME_LENGTH;
pub const AZ_MAX_NAME_LENGTH = AZ_PROP_CONSTANTS.MAX_SCOPE_NAME_LENGTH;
pub const AZ_MAX_DESCRIPTION_LENGTH = AZ_PROP_CONSTANTS.MAX_DESCRIPTION_LENGTH;
pub const AZ_MAX_APPLICATION_DATA_LENGTH = AZ_PROP_CONSTANTS.MAX_APPLICATION_DATA_LENGTH;
pub const AZ_SUBMIT_FLAG_ABORT = AZ_PROP_CONSTANTS.PROP_NAME;
pub const AZ_SUBMIT_FLAG_FLUSH = AZ_PROP_CONSTANTS.PROP_DESCRIPTION;
pub const AZ_MAX_POLICY_URL_LENGTH = AZ_PROP_CONSTANTS.MAX_SCOPE_NAME_LENGTH;
pub const AZ_AZSTORE_FLAG_CREATE = AZ_PROP_CONSTANTS.PROP_NAME;
pub const AZ_AZSTORE_FLAG_MANAGE_STORE_ONLY = AZ_PROP_CONSTANTS.PROP_DESCRIPTION;
pub const AZ_AZSTORE_FLAG_BATCH_UPDATE = AZ_PROP_CONSTANTS.PROP_APPLICATION_DATA;
pub const AZ_AZSTORE_FLAG_AUDIT_IS_CRITICAL = AZ_PROP_CONSTANTS.AZSTORE_FLAG_AUDIT_IS_CRITICAL;
pub const AZ_AZSTORE_FORCE_APPLICATION_CLOSE = AZ_PROP_CONSTANTS.AZSTORE_FORCE_APPLICATION_CLOSE;
pub const AZ_AZSTORE_NT6_FUNCTION_LEVEL = AZ_PROP_CONSTANTS.AZSTORE_NT6_FUNCTION_LEVEL;
pub const AZ_AZSTORE_FLAG_MANAGE_ONLY_PASSIVE_SUBMIT = AZ_PROP_CONSTANTS.AZSTORE_FLAG_MANAGE_ONLY_PASSIVE_SUBMIT;
pub const AZ_PROP_AZSTORE_DOMAIN_TIMEOUT = AZ_PROP_CONSTANTS.PROP_AZSTORE_DOMAIN_TIMEOUT;
pub const AZ_AZSTORE_DEFAULT_DOMAIN_TIMEOUT = AZ_PROP_CONSTANTS.AZSTORE_DEFAULT_DOMAIN_TIMEOUT;
pub const AZ_PROP_AZSTORE_SCRIPT_ENGINE_TIMEOUT = AZ_PROP_CONSTANTS.PROP_AZSTORE_SCRIPT_ENGINE_TIMEOUT;
pub const AZ_AZSTORE_MIN_DOMAIN_TIMEOUT = AZ_PROP_CONSTANTS.AZSTORE_MIN_DOMAIN_TIMEOUT;
pub const AZ_AZSTORE_MIN_SCRIPT_ENGINE_TIMEOUT = AZ_PROP_CONSTANTS.AZSTORE_MIN_SCRIPT_ENGINE_TIMEOUT;
pub const AZ_AZSTORE_DEFAULT_SCRIPT_ENGINE_TIMEOUT = AZ_PROP_CONSTANTS.AZSTORE_DEFAULT_SCRIPT_ENGINE_TIMEOUT;
pub const AZ_PROP_AZSTORE_MAX_SCRIPT_ENGINES = AZ_PROP_CONSTANTS.PROP_AZSTORE_MAX_SCRIPT_ENGINES;
pub const AZ_AZSTORE_DEFAULT_MAX_SCRIPT_ENGINES = AZ_PROP_CONSTANTS.AZSTORE_DEFAULT_MAX_SCRIPT_ENGINES;
pub const AZ_PROP_AZSTORE_MAJOR_VERSION = AZ_PROP_CONSTANTS.PROP_AZSTORE_MAJOR_VERSION;
pub const AZ_PROP_AZSTORE_MINOR_VERSION = AZ_PROP_CONSTANTS.PROP_AZSTORE_MINOR_VERSION;
pub const AZ_PROP_AZSTORE_TARGET_MACHINE = AZ_PROP_CONSTANTS.PROP_AZSTORE_TARGET_MACHINE;
pub const AZ_PROP_AZTORE_IS_ADAM_INSTANCE = AZ_PROP_CONSTANTS.PROP_AZTORE_IS_ADAM_INSTANCE;
pub const AZ_PROP_OPERATION_ID = AZ_PROP_CONSTANTS.PROP_OPERATION_ID;
pub const AZ_PROP_TASK_OPERATIONS = AZ_PROP_CONSTANTS.PROP_TASK_OPERATIONS;
pub const AZ_PROP_TASK_BIZRULE = AZ_PROP_CONSTANTS.PROP_TASK_BIZRULE;
pub const AZ_PROP_TASK_BIZRULE_LANGUAGE = AZ_PROP_CONSTANTS.PROP_TASK_BIZRULE_LANGUAGE;
pub const AZ_PROP_TASK_TASKS = AZ_PROP_CONSTANTS.PROP_TASK_TASKS;
pub const AZ_PROP_TASK_BIZRULE_IMPORTED_PATH = AZ_PROP_CONSTANTS.PROP_TASK_BIZRULE_IMPORTED_PATH;
pub const AZ_PROP_TASK_IS_ROLE_DEFINITION = AZ_PROP_CONSTANTS.PROP_TASK_IS_ROLE_DEFINITION;
pub const AZ_MAX_TASK_BIZRULE_LENGTH = AZ_PROP_CONSTANTS.MAX_SCOPE_NAME_LENGTH;
pub const AZ_MAX_TASK_BIZRULE_LANGUAGE_LENGTH = AZ_PROP_CONSTANTS.MAX_OPERATION_NAME_LENGTH;
pub const AZ_MAX_TASK_BIZRULE_IMPORTED_PATH_LENGTH = AZ_PROP_CONSTANTS.MAX_APPLICATION_NAME_LENGTH;
pub const AZ_MAX_BIZRULE_STRING = AZ_PROP_CONSTANTS.MAX_SCOPE_NAME_LENGTH;
pub const AZ_PROP_GROUP_TYPE = AZ_PROP_CONSTANTS.PROP_GROUP_TYPE;
pub const AZ_GROUPTYPE_LDAP_QUERY = AZ_PROP_CONSTANTS.PROP_NAME;
pub const AZ_GROUPTYPE_BASIC = AZ_PROP_CONSTANTS.PROP_DESCRIPTION;
pub const AZ_GROUPTYPE_BIZRULE = AZ_PROP_CONSTANTS.PROP_WRITABLE;
pub const AZ_PROP_GROUP_APP_MEMBERS = AZ_PROP_CONSTANTS.PROP_GROUP_APP_MEMBERS;
pub const AZ_PROP_GROUP_APP_NON_MEMBERS = AZ_PROP_CONSTANTS.PROP_GROUP_APP_NON_MEMBERS;
pub const AZ_PROP_GROUP_LDAP_QUERY = AZ_PROP_CONSTANTS.PROP_GROUP_LDAP_QUERY;
pub const AZ_MAX_GROUP_LDAP_QUERY_LENGTH = AZ_PROP_CONSTANTS.MAX_APPLICATION_DATA_LENGTH;
pub const AZ_PROP_GROUP_MEMBERS = AZ_PROP_CONSTANTS.PROP_GROUP_MEMBERS;
pub const AZ_PROP_GROUP_NON_MEMBERS = AZ_PROP_CONSTANTS.PROP_GROUP_NON_MEMBERS;
pub const AZ_PROP_GROUP_MEMBERS_NAME = AZ_PROP_CONSTANTS.PROP_GROUP_MEMBERS_NAME;
pub const AZ_PROP_GROUP_NON_MEMBERS_NAME = AZ_PROP_CONSTANTS.PROP_GROUP_NON_MEMBERS_NAME;
pub const AZ_PROP_GROUP_BIZRULE = AZ_PROP_CONSTANTS.PROP_GROUP_BIZRULE;
pub const AZ_PROP_GROUP_BIZRULE_LANGUAGE = AZ_PROP_CONSTANTS.PROP_GROUP_BIZRULE_LANGUAGE;
pub const AZ_PROP_GROUP_BIZRULE_IMPORTED_PATH = AZ_PROP_CONSTANTS.PROP_GROUP_BIZRULE_IMPORTED_PATH;
pub const AZ_MAX_GROUP_BIZRULE_LENGTH = AZ_PROP_CONSTANTS.MAX_SCOPE_NAME_LENGTH;
pub const AZ_MAX_GROUP_BIZRULE_LANGUAGE_LENGTH = AZ_PROP_CONSTANTS.MAX_OPERATION_NAME_LENGTH;
pub const AZ_MAX_GROUP_BIZRULE_IMPORTED_PATH_LENGTH = AZ_PROP_CONSTANTS.MAX_APPLICATION_NAME_LENGTH;
pub const AZ_PROP_ROLE_APP_MEMBERS = AZ_PROP_CONSTANTS.AZSTORE_MIN_DOMAIN_TIMEOUT;
pub const AZ_PROP_ROLE_MEMBERS = AZ_PROP_CONSTANTS.PROP_ROLE_MEMBERS;
pub const AZ_PROP_ROLE_OPERATIONS = AZ_PROP_CONSTANTS.PROP_ROLE_OPERATIONS;
pub const AZ_PROP_ROLE_TASKS = AZ_PROP_CONSTANTS.PROP_ROLE_TASKS;
pub const AZ_PROP_ROLE_MEMBERS_NAME = AZ_PROP_CONSTANTS.PROP_ROLE_MEMBERS_NAME;
pub const AZ_PROP_SCOPE_BIZRULES_WRITABLE = AZ_PROP_CONSTANTS.PROP_SCOPE_BIZRULES_WRITABLE;
pub const AZ_PROP_SCOPE_CAN_BE_DELEGATED = AZ_PROP_CONSTANTS.PROP_SCOPE_CAN_BE_DELEGATED;
pub const AZ_PROP_CLIENT_CONTEXT_USER_DN = AZ_PROP_CONSTANTS.PROP_CLIENT_CONTEXT_USER_DN;
pub const AZ_PROP_CLIENT_CONTEXT_USER_SAM_COMPAT = AZ_PROP_CONSTANTS.PROP_CLIENT_CONTEXT_USER_SAM_COMPAT;
pub const AZ_PROP_CLIENT_CONTEXT_USER_DISPLAY = AZ_PROP_CONSTANTS.PROP_CLIENT_CONTEXT_USER_DISPLAY;
pub const AZ_PROP_CLIENT_CONTEXT_USER_GUID = AZ_PROP_CONSTANTS.PROP_CLIENT_CONTEXT_USER_GUID;
pub const AZ_PROP_CLIENT_CONTEXT_USER_CANONICAL = AZ_PROP_CONSTANTS.PROP_CLIENT_CONTEXT_USER_CANONICAL;
pub const AZ_PROP_CLIENT_CONTEXT_USER_UPN = AZ_PROP_CONSTANTS.PROP_CLIENT_CONTEXT_USER_UPN;
pub const AZ_PROP_CLIENT_CONTEXT_USER_DNS_SAM_COMPAT = AZ_PROP_CONSTANTS.PROP_CLIENT_CONTEXT_USER_DNS_SAM_COMPAT;
pub const AZ_PROP_CLIENT_CONTEXT_ROLE_FOR_ACCESS_CHECK = AZ_PROP_CONSTANTS.PROP_CLIENT_CONTEXT_ROLE_FOR_ACCESS_CHECK;
pub const AZ_PROP_CLIENT_CONTEXT_LDAP_QUERY_DN = AZ_PROP_CONSTANTS.PROP_CLIENT_CONTEXT_LDAP_QUERY_DN;
pub const AZ_PROP_APPLICATION_AUTHZ_INTERFACE_CLSID = AZ_PROP_CONSTANTS.PROP_APPLICATION_AUTHZ_INTERFACE_CLSID;
pub const AZ_PROP_APPLICATION_VERSION = AZ_PROP_CONSTANTS.PROP_APPLICATION_VERSION;
pub const AZ_MAX_APPLICATION_VERSION_LENGTH = AZ_PROP_CONSTANTS.MAX_APPLICATION_NAME_LENGTH;
pub const AZ_PROP_APPLICATION_NAME = AZ_PROP_CONSTANTS.PROP_APPLICATION_NAME;
pub const AZ_PROP_APPLICATION_BIZRULE_ENABLED = AZ_PROP_CONSTANTS.PROP_APPLICATION_BIZRULE_ENABLED;
pub const AZ_PROP_APPLY_STORE_SACL = AZ_PROP_CONSTANTS.PROP_APPLY_STORE_SACL;
pub const AZ_PROP_GENERATE_AUDITS = AZ_PROP_CONSTANTS.PROP_GENERATE_AUDITS;
pub const AZ_PROP_POLICY_ADMINS = AZ_PROP_CONSTANTS.PROP_POLICY_ADMINS;
pub const AZ_PROP_POLICY_READERS = AZ_PROP_CONSTANTS.PROP_POLICY_READERS;
pub const AZ_PROP_DELEGATED_POLICY_USERS = AZ_PROP_CONSTANTS.PROP_DELEGATED_POLICY_USERS;
pub const AZ_PROP_POLICY_ADMINS_NAME = AZ_PROP_CONSTANTS.PROP_POLICY_ADMINS_NAME;
pub const AZ_PROP_POLICY_READERS_NAME = AZ_PROP_CONSTANTS.PROP_POLICY_READERS_NAME;
pub const AZ_PROP_DELEGATED_POLICY_USERS_NAME = AZ_PROP_CONSTANTS.PROP_DELEGATED_POLICY_USERS_NAME;
pub const AZ_CLIENT_CONTEXT_SKIP_GROUP = AZ_PROP_CONSTANTS.PROP_NAME;
pub const AZ_CLIENT_CONTEXT_SKIP_LDAP_QUERY = AZ_PROP_CONSTANTS.PROP_NAME;
pub const AZ_CLIENT_CONTEXT_GET_GROUP_RECURSIVE = AZ_PROP_CONSTANTS.PROP_DESCRIPTION;
pub const AZ_CLIENT_CONTEXT_GET_GROUPS_STORE_LEVEL_ONLY = AZ_PROP_CONSTANTS.PROP_DESCRIPTION;

pub const FN_PROGRESS = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        pObjectName: ?PWSTR,
        Status: u32,
        pInvokeSetting: ?*PROG_INVOKE_SETTING,
        Args: ?*anyopaque,
        SecuritySet: BOOL,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        pObjectName: ?PWSTR,
        Status: u32,
        pInvokeSetting: ?*PROG_INVOKE_SETTING,
        Args: ?*anyopaque,
        SecuritySet: BOOL,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const AUTHZ_ACCESS_CHECK_RESULTS_HANDLE = isize;

pub const AUTHZ_CLIENT_CONTEXT_HANDLE = isize;

pub const AUTHZ_RESOURCE_MANAGER_HANDLE = isize;

pub const AUTHZ_AUDIT_EVENT_HANDLE = *opaque {};

pub const AUTHZ_AUDIT_EVENT_TYPE_HANDLE = isize;

pub const AUTHZ_SECURITY_EVENT_PROVIDER_HANDLE = isize;

//--------------------------------------------------------------------------------
// Section: Functions (90)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "authz" fn AuthzAccessCheck(
    Flags: AUTHZ_ACCESS_CHECK_FLAGS,
    hAuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
    pRequest: ?*AUTHZ_ACCESS_REQUEST,
    hAuditEvent: ?AUTHZ_AUDIT_EVENT_HANDLE,
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    OptionalSecurityDescriptorArray: ?[*]?*SECURITY_DESCRIPTOR,
    OptionalSecurityDescriptorCount: u32,
    pReply: ?*AUTHZ_ACCESS_REPLY,
    phAccessCheckResults: ?*isize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "authz" fn AuthzCachedAccessCheck(
    Flags: u32,
    hAccessCheckResults: AUTHZ_ACCESS_CHECK_RESULTS_HANDLE,
    pRequest: ?*AUTHZ_ACCESS_REQUEST,
    hAuditEvent: ?AUTHZ_AUDIT_EVENT_HANDLE,
    pReply: ?*AUTHZ_ACCESS_REPLY,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "authz" fn AuthzOpenObjectAudit(
    Flags: u32,
    hAuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
    pRequest: ?*AUTHZ_ACCESS_REQUEST,
    hAuditEvent: ?AUTHZ_AUDIT_EVENT_HANDLE,
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    OptionalSecurityDescriptorArray: ?[*]?*SECURITY_DESCRIPTOR,
    OptionalSecurityDescriptorCount: u32,
    pReply: ?*AUTHZ_ACCESS_REPLY,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "authz" fn AuthzFreeHandle(
    hAccessCheckResults: AUTHZ_ACCESS_CHECK_RESULTS_HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "authz" fn AuthzInitializeResourceManager(
    Flags: u32,
    pfnDynamicAccessCheck: ?PFN_AUTHZ_DYNAMIC_ACCESS_CHECK,
    pfnComputeDynamicGroups: ?PFN_AUTHZ_COMPUTE_DYNAMIC_GROUPS,
    pfnFreeDynamicGroups: ?PFN_AUTHZ_FREE_DYNAMIC_GROUPS,
    szResourceManagerName: ?[*:0]const u16,
    phAuthzResourceManager: ?*AUTHZ_RESOURCE_MANAGER_HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
// This function from dll 'AUTHZ' is being skipped because it has some sort of issue
pub fn AuthzInitializeResourceManagerEx() void {
    @panic("this function is not working");
}

// TODO: this type is limited to platform 'windows8.0'
pub extern "authz" fn AuthzInitializeRemoteResourceManager(
    pRpcInitInfo: ?*AUTHZ_RPC_INIT_INFO_CLIENT,
    phAuthzResourceManager: ?*AUTHZ_RESOURCE_MANAGER_HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "authz" fn AuthzFreeResourceManager(
    hAuthzResourceManager: AUTHZ_RESOURCE_MANAGER_HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "authz" fn AuthzInitializeContextFromToken(
    Flags: u32,
    TokenHandle: ?HANDLE,
    hAuthzResourceManager: AUTHZ_RESOURCE_MANAGER_HANDLE,
    pExpirationTime: ?*LARGE_INTEGER,
    Identifier: LUID,
    DynamicGroupArgs: ?*anyopaque,
    phAuthzClientContext: ?*isize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "authz" fn AuthzInitializeContextFromSid(
    Flags: u32,
    UserSid: ?PSID,
    hAuthzResourceManager: AUTHZ_RESOURCE_MANAGER_HANDLE,
    pExpirationTime: ?*LARGE_INTEGER,
    Identifier: LUID,
    DynamicGroupArgs: ?*anyopaque,
    phAuthzClientContext: ?*isize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "authz" fn AuthzInitializeContextFromAuthzContext(
    Flags: u32,
    hAuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
    pExpirationTime: ?*LARGE_INTEGER,
    Identifier: LUID,
    DynamicGroupArgs: ?*anyopaque,
    phNewAuthzClientContext: ?*isize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "authz" fn AuthzInitializeCompoundContext(
    UserContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
    DeviceContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
    phCompoundContext: ?*isize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "authz" fn AuthzAddSidsToContext(
    hAuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
    Sids: ?*SID_AND_ATTRIBUTES,
    SidCount: u32,
    RestrictedSids: ?*SID_AND_ATTRIBUTES,
    RestrictedSidCount: u32,
    phNewAuthzClientContext: ?*isize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "authz" fn AuthzModifySecurityAttributes(
    hAuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
    pOperations: ?*AUTHZ_SECURITY_ATTRIBUTE_OPERATION,
    pAttributes: ?*AUTHZ_SECURITY_ATTRIBUTES_INFORMATION,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "authz" fn AuthzModifyClaims(
    hAuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
    ClaimClass: AUTHZ_CONTEXT_INFORMATION_CLASS,
    pClaimOperations: ?*AUTHZ_SECURITY_ATTRIBUTE_OPERATION,
    pClaims: ?*AUTHZ_SECURITY_ATTRIBUTES_INFORMATION,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "authz" fn AuthzModifySids(
    hAuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
    SidClass: AUTHZ_CONTEXT_INFORMATION_CLASS,
    pSidOperations: ?*AUTHZ_SID_OPERATION,
    pSids: ?*TOKEN_GROUPS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "authz" fn AuthzSetAppContainerInformation(
    hAuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
    pAppContainerSid: ?PSID,
    CapabilityCount: u32,
    pCapabilitySids: ?[*]SID_AND_ATTRIBUTES,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "authz" fn AuthzGetInformationFromContext(
    hAuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
    InfoClass: AUTHZ_CONTEXT_INFORMATION_CLASS,
    BufferSize: u32,
    pSizeRequired: ?*u32,
    Buffer: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "authz" fn AuthzFreeContext(
    hAuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "authz" fn AuthzInitializeObjectAccessAuditEvent(
    Flags: AUTHZ_INITIALIZE_OBJECT_ACCESS_AUDIT_EVENT_FLAGS,
    hAuditEventType: AUTHZ_AUDIT_EVENT_TYPE_HANDLE,
    szOperationType: ?PWSTR,
    szObjectType: ?PWSTR,
    szObjectName: ?PWSTR,
    szAdditionalInfo: ?PWSTR,
    phAuditEvent: ?*isize,
    dwAdditionalParameterCount: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windowsServer2003'
pub extern "authz" fn AuthzInitializeObjectAccessAuditEvent2(
    Flags: u32,
    hAuditEventType: AUTHZ_AUDIT_EVENT_TYPE_HANDLE,
    szOperationType: ?PWSTR,
    szObjectType: ?PWSTR,
    szObjectName: ?PWSTR,
    szAdditionalInfo: ?PWSTR,
    szAdditionalInfo2: ?PWSTR,
    phAuditEvent: ?*isize,
    dwAdditionalParameterCount: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "authz" fn AuthzFreeAuditEvent(
    hAuditEvent: ?AUTHZ_AUDIT_EVENT_HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "authz" fn AuthzEvaluateSacl(
    AuthzClientContext: AUTHZ_CLIENT_CONTEXT_HANDLE,
    pRequest: ?*AUTHZ_ACCESS_REQUEST,
    Sacl: ?*ACL,
    GrantedAccess: u32,
    AccessGranted: BOOL,
    pbGenerateAudit: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windowsServer2003'
pub extern "authz" fn AuthzInstallSecurityEventSource(
    dwFlags: u32,
    pRegistration: ?*AUTHZ_SOURCE_SCHEMA_REGISTRATION,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windowsServer2003'
pub extern "authz" fn AuthzUninstallSecurityEventSource(
    dwFlags: u32,
    szEventSourceName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windowsServer2003'
pub extern "authz" fn AuthzEnumerateSecurityEventSources(
    dwFlags: u32,
    Buffer: ?*AUTHZ_SOURCE_SCHEMA_REGISTRATION,
    pdwCount: ?*u32,
    pdwLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windowsServer2003'
pub extern "authz" fn AuthzRegisterSecurityEventSource(
    dwFlags: u32,
    szEventSourceName: ?[*:0]const u16,
    phEventProvider: ?*isize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windowsServer2003'
pub extern "authz" fn AuthzUnregisterSecurityEventSource(
    dwFlags: u32,
    phEventProvider: ?*isize,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windowsServer2003'
pub extern "authz" fn AuthzReportSecurityEvent(
    dwFlags: u32,
    hEventProvider: AUTHZ_SECURITY_EVENT_PROVIDER_HANDLE,
    dwAuditId: u32,
    pUserSid: ?PSID,
    dwCount: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windowsServer2003'
pub extern "authz" fn AuthzReportSecurityEventFromParams(
    dwFlags: u32,
    hEventProvider: AUTHZ_SECURITY_EVENT_PROVIDER_HANDLE,
    dwAuditId: u32,
    pUserSid: ?PSID,
    pParams: ?*AUDIT_PARAMS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "authz" fn AuthzRegisterCapChangeNotification(
    phCapChangeSubscription: ?*?*AUTHZ_CAP_CHANGE_SUBSCRIPTION_HANDLE__,
    pfnCapChangeCallback: ?LPTHREAD_START_ROUTINE,
    pCallbackContext: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "authz" fn AuthzUnregisterCapChangeNotification(
    hCapChangeSubscription: ?*AUTHZ_CAP_CHANGE_SUBSCRIPTION_HANDLE__,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "authz" fn AuthzFreeCentralAccessPolicyCache() callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetEntriesInAclA(
    cCountOfExplicitEntries: u32,
    pListOfExplicitEntries: ?[*]EXPLICIT_ACCESS_A,
    OldAcl: ?*ACL,
    NewAcl: ?*?*ACL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetEntriesInAclW(
    cCountOfExplicitEntries: u32,
    pListOfExplicitEntries: ?[*]EXPLICIT_ACCESS_W,
    OldAcl: ?*ACL,
    NewAcl: ?*?*ACL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetExplicitEntriesFromAclA(
    pacl: ?*ACL,
    pcCountOfExplicitEntries: ?*u32,
    pListOfExplicitEntries: ?*?*EXPLICIT_ACCESS_A,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetExplicitEntriesFromAclW(
    pacl: ?*ACL,
    pcCountOfExplicitEntries: ?*u32,
    pListOfExplicitEntries: ?*?*EXPLICIT_ACCESS_W,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetEffectiveRightsFromAclA(
    pacl: ?*ACL,
    pTrustee: ?*TRUSTEE_A,
    pAccessRights: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetEffectiveRightsFromAclW(
    pacl: ?*ACL,
    pTrustee: ?*TRUSTEE_W,
    pAccessRights: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetAuditedPermissionsFromAclA(
    pacl: ?*ACL,
    pTrustee: ?*TRUSTEE_A,
    pSuccessfulAuditedRights: ?*u32,
    pFailedAuditRights: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetAuditedPermissionsFromAclW(
    pacl: ?*ACL,
    pTrustee: ?*TRUSTEE_W,
    pSuccessfulAuditedRights: ?*u32,
    pFailedAuditRights: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetNamedSecurityInfoA(
    pObjectName: ?[*:0]const u8,
    ObjectType: SE_OBJECT_TYPE,
    SecurityInfo: OBJECT_SECURITY_INFORMATION,
    ppsidOwner: ?*?PSID,
    ppsidGroup: ?*?PSID,
    ppDacl: ?*?*ACL,
    ppSacl: ?*?*ACL,
    ppSecurityDescriptor: ?*?*SECURITY_DESCRIPTOR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetNamedSecurityInfoW(
    pObjectName: ?[*:0]const u16,
    ObjectType: SE_OBJECT_TYPE,
    SecurityInfo: OBJECT_SECURITY_INFORMATION,
    ppsidOwner: ?*?PSID,
    ppsidGroup: ?*?PSID,
    ppDacl: ?*?*ACL,
    ppSacl: ?*?*ACL,
    ppSecurityDescriptor: ?*?*SECURITY_DESCRIPTOR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetSecurityInfo(
    handle: ?HANDLE,
    ObjectType: SE_OBJECT_TYPE,
    SecurityInfo: u32,
    ppsidOwner: ?*?PSID,
    ppsidGroup: ?*?PSID,
    ppDacl: ?*?*ACL,
    ppSacl: ?*?*ACL,
    ppSecurityDescriptor: ?*?*SECURITY_DESCRIPTOR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetNamedSecurityInfoA(
    pObjectName: ?PSTR,
    ObjectType: SE_OBJECT_TYPE,
    SecurityInfo: OBJECT_SECURITY_INFORMATION,
    psidOwner: ?PSID,
    psidGroup: ?PSID,
    pDacl: ?*ACL,
    pSacl: ?*ACL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetNamedSecurityInfoW(
    pObjectName: ?PWSTR,
    ObjectType: SE_OBJECT_TYPE,
    SecurityInfo: OBJECT_SECURITY_INFORMATION,
    psidOwner: ?PSID,
    psidGroup: ?PSID,
    pDacl: ?*ACL,
    pSacl: ?*ACL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetSecurityInfo(
    handle: ?HANDLE,
    ObjectType: SE_OBJECT_TYPE,
    SecurityInfo: u32,
    psidOwner: ?PSID,
    psidGroup: ?PSID,
    pDacl: ?*ACL,
    pSacl: ?*ACL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetInheritanceSourceA(
    pObjectName: ?PSTR,
    ObjectType: SE_OBJECT_TYPE,
    SecurityInfo: u32,
    Container: BOOL,
    pObjectClassGuids: ?[*]?*Guid,
    GuidCount: u32,
    pAcl: ?*ACL,
    pfnArray: ?*FN_OBJECT_MGR_FUNCTIONS,
    pGenericMapping: ?*GENERIC_MAPPING,
    pInheritArray: ?*INHERITED_FROMA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetInheritanceSourceW(
    pObjectName: ?PWSTR,
    ObjectType: SE_OBJECT_TYPE,
    SecurityInfo: u32,
    Container: BOOL,
    pObjectClassGuids: ?[*]?*Guid,
    GuidCount: u32,
    pAcl: ?*ACL,
    pfnArray: ?*FN_OBJECT_MGR_FUNCTIONS,
    pGenericMapping: ?*GENERIC_MAPPING,
    pInheritArray: ?*INHERITED_FROMW,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn FreeInheritedFromArray(
    pInheritArray: [*]INHERITED_FROMW,
    AceCnt: u16,
    pfnArray: ?*FN_OBJECT_MGR_FUNCTIONS,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn TreeResetNamedSecurityInfoA(
    pObjectName: ?PSTR,
    ObjectType: SE_OBJECT_TYPE,
    SecurityInfo: u32,
    pOwner: ?PSID,
    pGroup: ?PSID,
    pDacl: ?*ACL,
    pSacl: ?*ACL,
    KeepExplicit: BOOL,
    fnProgress: ?FN_PROGRESS,
    ProgressInvokeSetting: PROG_INVOKE_SETTING,
    Args: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn TreeResetNamedSecurityInfoW(
    pObjectName: ?PWSTR,
    ObjectType: SE_OBJECT_TYPE,
    SecurityInfo: u32,
    pOwner: ?PSID,
    pGroup: ?PSID,
    pDacl: ?*ACL,
    pSacl: ?*ACL,
    KeepExplicit: BOOL,
    fnProgress: ?FN_PROGRESS,
    ProgressInvokeSetting: PROG_INVOKE_SETTING,
    Args: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn TreeSetNamedSecurityInfoA(
    pObjectName: ?PSTR,
    ObjectType: SE_OBJECT_TYPE,
    SecurityInfo: u32,
    pOwner: ?PSID,
    pGroup: ?PSID,
    pDacl: ?*ACL,
    pSacl: ?*ACL,
    dwAction: TREE_SEC_INFO,
    fnProgress: ?FN_PROGRESS,
    ProgressInvokeSetting: PROG_INVOKE_SETTING,
    Args: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn TreeSetNamedSecurityInfoW(
    pObjectName: ?PWSTR,
    ObjectType: SE_OBJECT_TYPE,
    SecurityInfo: u32,
    pOwner: ?PSID,
    pGroup: ?PSID,
    pDacl: ?*ACL,
    pSacl: ?*ACL,
    dwAction: TREE_SEC_INFO,
    fnProgress: ?FN_PROGRESS,
    ProgressInvokeSetting: PROG_INVOKE_SETTING,
    Args: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn BuildSecurityDescriptorA(
    pOwner: ?*TRUSTEE_A,
    pGroup: ?*TRUSTEE_A,
    cCountOfAccessEntries: u32,
    pListOfAccessEntries: ?[*]EXPLICIT_ACCESS_A,
    cCountOfAuditEntries: u32,
    pListOfAuditEntries: ?[*]EXPLICIT_ACCESS_A,
    pOldSD: ?*SECURITY_DESCRIPTOR,
    pSizeNewSD: ?*u32,
    pNewSD: ?*?*SECURITY_DESCRIPTOR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn BuildSecurityDescriptorW(
    pOwner: ?*TRUSTEE_W,
    pGroup: ?*TRUSTEE_W,
    cCountOfAccessEntries: u32,
    pListOfAccessEntries: ?[*]EXPLICIT_ACCESS_W,
    cCountOfAuditEntries: u32,
    pListOfAuditEntries: ?[*]EXPLICIT_ACCESS_W,
    pOldSD: ?*SECURITY_DESCRIPTOR,
    pSizeNewSD: ?*u32,
    pNewSD: ?*?*SECURITY_DESCRIPTOR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LookupSecurityDescriptorPartsA(
    ppOwner: ?*?*TRUSTEE_A,
    ppGroup: ?*?*TRUSTEE_A,
    pcCountOfAccessEntries: ?*u32,
    ppListOfAccessEntries: ?*?*EXPLICIT_ACCESS_A,
    pcCountOfAuditEntries: ?*u32,
    ppListOfAuditEntries: ?*?*EXPLICIT_ACCESS_A,
    pSD: ?*SECURITY_DESCRIPTOR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LookupSecurityDescriptorPartsW(
    ppOwner: ?*?*TRUSTEE_W,
    ppGroup: ?*?*TRUSTEE_W,
    pcCountOfAccessEntries: ?*u32,
    ppListOfAccessEntries: ?*?*EXPLICIT_ACCESS_W,
    pcCountOfAuditEntries: ?*u32,
    ppListOfAuditEntries: ?*?*EXPLICIT_ACCESS_W,
    pSD: ?*SECURITY_DESCRIPTOR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn BuildExplicitAccessWithNameA(
    pExplicitAccess: ?*EXPLICIT_ACCESS_A,
    pTrusteeName: ?PSTR,
    AccessPermissions: u32,
    AccessMode: ACCESS_MODE,
    Inheritance: ACE_FLAGS,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn BuildExplicitAccessWithNameW(
    pExplicitAccess: ?*EXPLICIT_ACCESS_W,
    pTrusteeName: ?PWSTR,
    AccessPermissions: u32,
    AccessMode: ACCESS_MODE,
    Inheritance: ACE_FLAGS,
) callconv(@import("std").os.windows.WINAPI) void;

pub extern "advapi32" fn BuildImpersonateExplicitAccessWithNameA(
    pExplicitAccess: ?*EXPLICIT_ACCESS_A,
    pTrusteeName: ?PSTR,
    pTrustee: ?*TRUSTEE_A,
    AccessPermissions: u32,
    AccessMode: ACCESS_MODE,
    Inheritance: u32,
) callconv(@import("std").os.windows.WINAPI) void;

pub extern "advapi32" fn BuildImpersonateExplicitAccessWithNameW(
    pExplicitAccess: ?*EXPLICIT_ACCESS_W,
    pTrusteeName: ?PWSTR,
    pTrustee: ?*TRUSTEE_W,
    AccessPermissions: u32,
    AccessMode: ACCESS_MODE,
    Inheritance: u32,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn BuildTrusteeWithNameA(
    pTrustee: ?*TRUSTEE_A,
    pName: ?PSTR,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn BuildTrusteeWithNameW(
    pTrustee: ?*TRUSTEE_W,
    pName: ?PWSTR,
) callconv(@import("std").os.windows.WINAPI) void;

pub extern "advapi32" fn BuildImpersonateTrusteeA(
    pTrustee: ?*TRUSTEE_A,
    pImpersonateTrustee: ?*TRUSTEE_A,
) callconv(@import("std").os.windows.WINAPI) void;

pub extern "advapi32" fn BuildImpersonateTrusteeW(
    pTrustee: ?*TRUSTEE_W,
    pImpersonateTrustee: ?*TRUSTEE_W,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn BuildTrusteeWithSidA(
    pTrustee: ?*TRUSTEE_A,
    pSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn BuildTrusteeWithSidW(
    pTrustee: ?*TRUSTEE_W,
    pSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn BuildTrusteeWithObjectsAndSidA(
    pTrustee: ?*TRUSTEE_A,
    pObjSid: ?*OBJECTS_AND_SID,
    pObjectGuid: ?*Guid,
    pInheritedObjectGuid: ?*Guid,
    pSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn BuildTrusteeWithObjectsAndSidW(
    pTrustee: ?*TRUSTEE_W,
    pObjSid: ?*OBJECTS_AND_SID,
    pObjectGuid: ?*Guid,
    pInheritedObjectGuid: ?*Guid,
    pSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
// This function from dll 'ADVAPI32' is being skipped because it has some sort of issue
pub fn BuildTrusteeWithObjectsAndNameA() void {
    @panic("this function is not working");
}

// TODO: this type is limited to platform 'windows5.1.2600'
// This function from dll 'ADVAPI32' is being skipped because it has some sort of issue
pub fn BuildTrusteeWithObjectsAndNameW() void {
    @panic("this function is not working");
}

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetTrusteeNameA(
    pTrustee: ?*TRUSTEE_A,
) callconv(@import("std").os.windows.WINAPI) ?PSTR;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetTrusteeNameW(
    pTrustee: ?*TRUSTEE_W,
) callconv(@import("std").os.windows.WINAPI) ?PWSTR;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetTrusteeTypeA(
    pTrustee: ?*TRUSTEE_A,
) callconv(@import("std").os.windows.WINAPI) TRUSTEE_TYPE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetTrusteeTypeW(
    pTrustee: ?*TRUSTEE_W,
) callconv(@import("std").os.windows.WINAPI) TRUSTEE_TYPE;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetTrusteeFormA(
    pTrustee: ?*TRUSTEE_A,
) callconv(@import("std").os.windows.WINAPI) TRUSTEE_FORM;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetTrusteeFormW(
    pTrustee: ?*TRUSTEE_W,
) callconv(@import("std").os.windows.WINAPI) TRUSTEE_FORM;

pub extern "advapi32" fn GetMultipleTrusteeOperationA(
    pTrustee: ?*TRUSTEE_A,
) callconv(@import("std").os.windows.WINAPI) MULTIPLE_TRUSTEE_OPERATION;

pub extern "advapi32" fn GetMultipleTrusteeOperationW(
    pTrustee: ?*TRUSTEE_W,
) callconv(@import("std").os.windows.WINAPI) MULTIPLE_TRUSTEE_OPERATION;

pub extern "advapi32" fn GetMultipleTrusteeA(
    pTrustee: ?*TRUSTEE_A,
) callconv(@import("std").os.windows.WINAPI) ?*TRUSTEE_A;

pub extern "advapi32" fn GetMultipleTrusteeW(
    pTrustee: ?*TRUSTEE_W,
) callconv(@import("std").os.windows.WINAPI) ?*TRUSTEE_W;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ConvertSidToStringSidA(
    Sid: ?PSID,
    StringSid: ?*?PSTR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ConvertSidToStringSidW(
    Sid: ?PSID,
    StringSid: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ConvertStringSidToSidA(
    StringSid: ?[*:0]const u8,
    Sid: ?*?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ConvertStringSidToSidW(
    StringSid: ?[*:0]const u16,
    Sid: ?*?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ConvertStringSecurityDescriptorToSecurityDescriptorA(
    StringSecurityDescriptor: ?[*:0]const u8,
    StringSDRevision: u32,
    SecurityDescriptor: ?*?*SECURITY_DESCRIPTOR,
    SecurityDescriptorSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ConvertStringSecurityDescriptorToSecurityDescriptorW(
    StringSecurityDescriptor: ?[*:0]const u16,
    StringSDRevision: u32,
    SecurityDescriptor: ?*?*SECURITY_DESCRIPTOR,
    SecurityDescriptorSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ConvertSecurityDescriptorToStringSecurityDescriptorA(
    SecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    RequestedStringSDRevision: u32,
    SecurityInformation: u32,
    StringSecurityDescriptor: ?*?PSTR,
    StringSecurityDescriptorLen: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ConvertSecurityDescriptorToStringSecurityDescriptorW(
    SecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    RequestedStringSDRevision: u32,
    SecurityInformation: u32,
    StringSecurityDescriptor: ?*?PWSTR,
    StringSecurityDescriptorLen: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (38)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {
        pub const OBJECTS_AND_NAME_ = thismodule.OBJECTS_AND_NAME_A;
        pub const TRUSTEE_ = thismodule.TRUSTEE_A;
        pub const EXPLICIT_ACCESS_ = thismodule.EXPLICIT_ACCESS_A;
        pub const ACTRL_ACCESS_ENTRY = thismodule.ACTRL_ACCESS_ENTRYA;
        pub const ACTRL_ACCESS_ENTRY_LIST = thismodule.ACTRL_ACCESS_ENTRY_LISTA;
        pub const ACTRL_PROPERTY_ENTRY = thismodule.ACTRL_PROPERTY_ENTRYA;
        pub const ACTRL_ACCESS = thismodule.ACTRL_ACCESSA;
        pub const TRUSTEE_ACCESS = thismodule.TRUSTEE_ACCESSA;
        pub const ACTRL_ACCESS_INFO = thismodule.ACTRL_ACCESS_INFOA;
        pub const ACTRL_CONTROL_INFO = thismodule.ACTRL_CONTROL_INFOA;
        pub const INHERITED_FROM = thismodule.INHERITED_FROMA;
        pub const SetEntriesInAcl = thismodule.SetEntriesInAclA;
        pub const GetExplicitEntriesFromAcl = thismodule.GetExplicitEntriesFromAclA;
        pub const GetEffectiveRightsFromAcl = thismodule.GetEffectiveRightsFromAclA;
        pub const GetAuditedPermissionsFromAcl = thismodule.GetAuditedPermissionsFromAclA;
        pub const GetNamedSecurityInfo = thismodule.GetNamedSecurityInfoA;
        pub const SetNamedSecurityInfo = thismodule.SetNamedSecurityInfoA;
        pub const GetInheritanceSource = thismodule.GetInheritanceSourceA;
        pub const TreeResetNamedSecurityInfo = thismodule.TreeResetNamedSecurityInfoA;
        pub const TreeSetNamedSecurityInfo = thismodule.TreeSetNamedSecurityInfoA;
        pub const BuildSecurityDescriptor = thismodule.BuildSecurityDescriptorA;
        pub const LookupSecurityDescriptorParts = thismodule.LookupSecurityDescriptorPartsA;
        pub const BuildExplicitAccessWithName = thismodule.BuildExplicitAccessWithNameA;
        pub const BuildImpersonateExplicitAccessWithName = thismodule.BuildImpersonateExplicitAccessWithNameA;
        pub const BuildTrusteeWithName = thismodule.BuildTrusteeWithNameA;
        pub const BuildImpersonateTrustee = thismodule.BuildImpersonateTrusteeA;
        pub const BuildTrusteeWithSid = thismodule.BuildTrusteeWithSidA;
        pub const BuildTrusteeWithObjectsAndSid = thismodule.BuildTrusteeWithObjectsAndSidA;
        pub const BuildTrusteeWithObjectsAndName = thismodule.BuildTrusteeWithObjectsAndNameA;
        pub const GetTrusteeName = thismodule.GetTrusteeNameA;
        pub const GetTrusteeType = thismodule.GetTrusteeTypeA;
        pub const GetTrusteeForm = thismodule.GetTrusteeFormA;
        pub const GetMultipleTrusteeOperation = thismodule.GetMultipleTrusteeOperationA;
        pub const GetMultipleTrustee = thismodule.GetMultipleTrusteeA;
        pub const ConvertSidToStringSid = thismodule.ConvertSidToStringSidA;
        pub const ConvertStringSidToSid = thismodule.ConvertStringSidToSidA;
        pub const ConvertStringSecurityDescriptorToSecurityDescriptor = thismodule.ConvertStringSecurityDescriptorToSecurityDescriptorA;
        pub const ConvertSecurityDescriptorToStringSecurityDescriptor = thismodule.ConvertSecurityDescriptorToStringSecurityDescriptorA;
    },
    .wide => struct {
        pub const OBJECTS_AND_NAME_ = thismodule.OBJECTS_AND_NAME_W;
        pub const TRUSTEE_ = thismodule.TRUSTEE_W;
        pub const EXPLICIT_ACCESS_ = thismodule.EXPLICIT_ACCESS_W;
        pub const ACTRL_ACCESS_ENTRY = thismodule.ACTRL_ACCESS_ENTRYW;
        pub const ACTRL_ACCESS_ENTRY_LIST = thismodule.ACTRL_ACCESS_ENTRY_LISTW;
        pub const ACTRL_PROPERTY_ENTRY = thismodule.ACTRL_PROPERTY_ENTRYW;
        pub const ACTRL_ACCESS = thismodule.ACTRL_ACCESSW;
        pub const TRUSTEE_ACCESS = thismodule.TRUSTEE_ACCESSW;
        pub const ACTRL_ACCESS_INFO = thismodule.ACTRL_ACCESS_INFOW;
        pub const ACTRL_CONTROL_INFO = thismodule.ACTRL_CONTROL_INFOW;
        pub const INHERITED_FROM = thismodule.INHERITED_FROMW;
        pub const SetEntriesInAcl = thismodule.SetEntriesInAclW;
        pub const GetExplicitEntriesFromAcl = thismodule.GetExplicitEntriesFromAclW;
        pub const GetEffectiveRightsFromAcl = thismodule.GetEffectiveRightsFromAclW;
        pub const GetAuditedPermissionsFromAcl = thismodule.GetAuditedPermissionsFromAclW;
        pub const GetNamedSecurityInfo = thismodule.GetNamedSecurityInfoW;
        pub const SetNamedSecurityInfo = thismodule.SetNamedSecurityInfoW;
        pub const GetInheritanceSource = thismodule.GetInheritanceSourceW;
        pub const TreeResetNamedSecurityInfo = thismodule.TreeResetNamedSecurityInfoW;
        pub const TreeSetNamedSecurityInfo = thismodule.TreeSetNamedSecurityInfoW;
        pub const BuildSecurityDescriptor = thismodule.BuildSecurityDescriptorW;
        pub const LookupSecurityDescriptorParts = thismodule.LookupSecurityDescriptorPartsW;
        pub const BuildExplicitAccessWithName = thismodule.BuildExplicitAccessWithNameW;
        pub const BuildImpersonateExplicitAccessWithName = thismodule.BuildImpersonateExplicitAccessWithNameW;
        pub const BuildTrusteeWithName = thismodule.BuildTrusteeWithNameW;
        pub const BuildImpersonateTrustee = thismodule.BuildImpersonateTrusteeW;
        pub const BuildTrusteeWithSid = thismodule.BuildTrusteeWithSidW;
        pub const BuildTrusteeWithObjectsAndSid = thismodule.BuildTrusteeWithObjectsAndSidW;
        pub const BuildTrusteeWithObjectsAndName = thismodule.BuildTrusteeWithObjectsAndNameW;
        pub const GetTrusteeName = thismodule.GetTrusteeNameW;
        pub const GetTrusteeType = thismodule.GetTrusteeTypeW;
        pub const GetTrusteeForm = thismodule.GetTrusteeFormW;
        pub const GetMultipleTrusteeOperation = thismodule.GetMultipleTrusteeOperationW;
        pub const GetMultipleTrustee = thismodule.GetMultipleTrusteeW;
        pub const ConvertSidToStringSid = thismodule.ConvertSidToStringSidW;
        pub const ConvertStringSidToSid = thismodule.ConvertStringSidToSidW;
        pub const ConvertStringSecurityDescriptorToSecurityDescriptor = thismodule.ConvertStringSecurityDescriptorToSecurityDescriptorW;
        pub const ConvertSecurityDescriptorToStringSecurityDescriptor = thismodule.ConvertSecurityDescriptorToStringSecurityDescriptorW;
    },
    .unspecified => if (@import("builtin").is_test) struct {
        pub const OBJECTS_AND_NAME_ = *opaque {};
        pub const TRUSTEE_ = *opaque {};
        pub const EXPLICIT_ACCESS_ = *opaque {};
        pub const ACTRL_ACCESS_ENTRY = *opaque {};
        pub const ACTRL_ACCESS_ENTRY_LIST = *opaque {};
        pub const ACTRL_PROPERTY_ENTRY = *opaque {};
        pub const ACTRL_ACCESS = *opaque {};
        pub const TRUSTEE_ACCESS = *opaque {};
        pub const ACTRL_ACCESS_INFO = *opaque {};
        pub const ACTRL_CONTROL_INFO = *opaque {};
        pub const INHERITED_FROM = *opaque {};
        pub const SetEntriesInAcl = *opaque {};
        pub const GetExplicitEntriesFromAcl = *opaque {};
        pub const GetEffectiveRightsFromAcl = *opaque {};
        pub const GetAuditedPermissionsFromAcl = *opaque {};
        pub const GetNamedSecurityInfo = *opaque {};
        pub const SetNamedSecurityInfo = *opaque {};
        pub const GetInheritanceSource = *opaque {};
        pub const TreeResetNamedSecurityInfo = *opaque {};
        pub const TreeSetNamedSecurityInfo = *opaque {};
        pub const BuildSecurityDescriptor = *opaque {};
        pub const LookupSecurityDescriptorParts = *opaque {};
        pub const BuildExplicitAccessWithName = *opaque {};
        pub const BuildImpersonateExplicitAccessWithName = *opaque {};
        pub const BuildTrusteeWithName = *opaque {};
        pub const BuildImpersonateTrustee = *opaque {};
        pub const BuildTrusteeWithSid = *opaque {};
        pub const BuildTrusteeWithObjectsAndSid = *opaque {};
        pub const BuildTrusteeWithObjectsAndName = *opaque {};
        pub const GetTrusteeName = *opaque {};
        pub const GetTrusteeType = *opaque {};
        pub const GetTrusteeForm = *opaque {};
        pub const GetMultipleTrusteeOperation = *opaque {};
        pub const GetMultipleTrustee = *opaque {};
        pub const ConvertSidToStringSid = *opaque {};
        pub const ConvertStringSidToSid = *opaque {};
        pub const ConvertStringSecurityDescriptorToSecurityDescriptor = *opaque {};
        pub const ConvertSecurityDescriptorToStringSecurityDescriptor = *opaque {};
    } else struct {
        pub const OBJECTS_AND_NAME_ = @compileError("'OBJECTS_AND_NAME_' requires that UNICODE be set to true or false in the root module");
        pub const TRUSTEE_ = @compileError("'TRUSTEE_' requires that UNICODE be set to true or false in the root module");
        pub const EXPLICIT_ACCESS_ = @compileError("'EXPLICIT_ACCESS_' requires that UNICODE be set to true or false in the root module");
        pub const ACTRL_ACCESS_ENTRY = @compileError("'ACTRL_ACCESS_ENTRY' requires that UNICODE be set to true or false in the root module");
        pub const ACTRL_ACCESS_ENTRY_LIST = @compileError("'ACTRL_ACCESS_ENTRY_LIST' requires that UNICODE be set to true or false in the root module");
        pub const ACTRL_PROPERTY_ENTRY = @compileError("'ACTRL_PROPERTY_ENTRY' requires that UNICODE be set to true or false in the root module");
        pub const ACTRL_ACCESS = @compileError("'ACTRL_ACCESS' requires that UNICODE be set to true or false in the root module");
        pub const TRUSTEE_ACCESS = @compileError("'TRUSTEE_ACCESS' requires that UNICODE be set to true or false in the root module");
        pub const ACTRL_ACCESS_INFO = @compileError("'ACTRL_ACCESS_INFO' requires that UNICODE be set to true or false in the root module");
        pub const ACTRL_CONTROL_INFO = @compileError("'ACTRL_CONTROL_INFO' requires that UNICODE be set to true or false in the root module");
        pub const INHERITED_FROM = @compileError("'INHERITED_FROM' requires that UNICODE be set to true or false in the root module");
        pub const SetEntriesInAcl = @compileError("'SetEntriesInAcl' requires that UNICODE be set to true or false in the root module");
        pub const GetExplicitEntriesFromAcl = @compileError("'GetExplicitEntriesFromAcl' requires that UNICODE be set to true or false in the root module");
        pub const GetEffectiveRightsFromAcl = @compileError("'GetEffectiveRightsFromAcl' requires that UNICODE be set to true or false in the root module");
        pub const GetAuditedPermissionsFromAcl = @compileError("'GetAuditedPermissionsFromAcl' requires that UNICODE be set to true or false in the root module");
        pub const GetNamedSecurityInfo = @compileError("'GetNamedSecurityInfo' requires that UNICODE be set to true or false in the root module");
        pub const SetNamedSecurityInfo = @compileError("'SetNamedSecurityInfo' requires that UNICODE be set to true or false in the root module");
        pub const GetInheritanceSource = @compileError("'GetInheritanceSource' requires that UNICODE be set to true or false in the root module");
        pub const TreeResetNamedSecurityInfo = @compileError("'TreeResetNamedSecurityInfo' requires that UNICODE be set to true or false in the root module");
        pub const TreeSetNamedSecurityInfo = @compileError("'TreeSetNamedSecurityInfo' requires that UNICODE be set to true or false in the root module");
        pub const BuildSecurityDescriptor = @compileError("'BuildSecurityDescriptor' requires that UNICODE be set to true or false in the root module");
        pub const LookupSecurityDescriptorParts = @compileError("'LookupSecurityDescriptorParts' requires that UNICODE be set to true or false in the root module");
        pub const BuildExplicitAccessWithName = @compileError("'BuildExplicitAccessWithName' requires that UNICODE be set to true or false in the root module");
        pub const BuildImpersonateExplicitAccessWithName = @compileError("'BuildImpersonateExplicitAccessWithName' requires that UNICODE be set to true or false in the root module");
        pub const BuildTrusteeWithName = @compileError("'BuildTrusteeWithName' requires that UNICODE be set to true or false in the root module");
        pub const BuildImpersonateTrustee = @compileError("'BuildImpersonateTrustee' requires that UNICODE be set to true or false in the root module");
        pub const BuildTrusteeWithSid = @compileError("'BuildTrusteeWithSid' requires that UNICODE be set to true or false in the root module");
        pub const BuildTrusteeWithObjectsAndSid = @compileError("'BuildTrusteeWithObjectsAndSid' requires that UNICODE be set to true or false in the root module");
        pub const BuildTrusteeWithObjectsAndName = @compileError("'BuildTrusteeWithObjectsAndName' requires that UNICODE be set to true or false in the root module");
        pub const GetTrusteeName = @compileError("'GetTrusteeName' requires that UNICODE be set to true or false in the root module");
        pub const GetTrusteeType = @compileError("'GetTrusteeType' requires that UNICODE be set to true or false in the root module");
        pub const GetTrusteeForm = @compileError("'GetTrusteeForm' requires that UNICODE be set to true or false in the root module");
        pub const GetMultipleTrusteeOperation = @compileError("'GetMultipleTrusteeOperation' requires that UNICODE be set to true or false in the root module");
        pub const GetMultipleTrustee = @compileError("'GetMultipleTrustee' requires that UNICODE be set to true or false in the root module");
        pub const ConvertSidToStringSid = @compileError("'ConvertSidToStringSid' requires that UNICODE be set to true or false in the root module");
        pub const ConvertStringSidToSid = @compileError("'ConvertStringSidToSid' requires that UNICODE be set to true or false in the root module");
        pub const ConvertStringSecurityDescriptorToSecurityDescriptor = @compileError("'ConvertStringSecurityDescriptorToSecurityDescriptor' requires that UNICODE be set to true or false in the root module");
        pub const ConvertSecurityDescriptorToStringSecurityDescriptor = @compileError("'ConvertSecurityDescriptorToStringSecurityDescriptor' requires that UNICODE be set to true or false in the root module");
    },
};
//--------------------------------------------------------------------------------
// Section: Imports (26)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const ACE_FLAGS = @import("../security.zig").ACE_FLAGS;
const ACE_HEADER = @import("../security.zig").ACE_HEADER;
const ACL = @import("../security.zig").ACL;
const BOOL = @import("../foundation.zig").BOOL;
const BSTR = @import("../foundation.zig").BSTR;
const GENERIC_MAPPING = @import("../security.zig").GENERIC_MAPPING;
const HANDLE = @import("../foundation.zig").HANDLE;
const HRESULT = @import("../foundation.zig").HRESULT;
const HWND = @import("../foundation.zig").HWND;
const IDispatch = @import("../system/com.zig").IDispatch;
const IUnknown = @import("../system/com.zig").IUnknown;
const LARGE_INTEGER = @import("../foundation.zig").LARGE_INTEGER;
const LPTHREAD_START_ROUTINE = @import("../system/threading.zig").LPTHREAD_START_ROUTINE;
const LUID = @import("../foundation.zig").LUID;
const OBJECT_SECURITY_INFORMATION = @import("../security.zig").OBJECT_SECURITY_INFORMATION;
const OBJECT_TYPE_LIST = @import("../security.zig").OBJECT_TYPE_LIST;
const PSID = @import("../foundation.zig").PSID;
const PSTR = @import("../foundation.zig").PSTR;
const PWSTR = @import("../foundation.zig").PWSTR;
const SECURITY_DESCRIPTOR = @import("../security.zig").SECURITY_DESCRIPTOR;
const SID = @import("../security.zig").SID;
const SID_AND_ATTRIBUTES = @import("../security.zig").SID_AND_ATTRIBUTES;
const SYSTEM_AUDIT_OBJECT_ACE_FLAGS = @import("../security.zig").SYSTEM_AUDIT_OBJECT_ACE_FLAGS;
const TOKEN_GROUPS = @import("../security.zig").TOKEN_GROUPS;
const VARIANT = @import("../system/com.zig").VARIANT;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "PFN_AUTHZ_DYNAMIC_ACCESS_CHECK")) {
        _ = PFN_AUTHZ_DYNAMIC_ACCESS_CHECK;
    }
    if (@hasDecl(@This(), "PFN_AUTHZ_COMPUTE_DYNAMIC_GROUPS")) {
        _ = PFN_AUTHZ_COMPUTE_DYNAMIC_GROUPS;
    }
    if (@hasDecl(@This(), "PFN_AUTHZ_FREE_DYNAMIC_GROUPS")) {
        _ = PFN_AUTHZ_FREE_DYNAMIC_GROUPS;
    }
    if (@hasDecl(@This(), "PFN_AUTHZ_GET_CENTRAL_ACCESS_POLICY")) {
        _ = PFN_AUTHZ_GET_CENTRAL_ACCESS_POLICY;
    }
    if (@hasDecl(@This(), "PFN_AUTHZ_FREE_CENTRAL_ACCESS_POLICY")) {
        _ = PFN_AUTHZ_FREE_CENTRAL_ACCESS_POLICY;
    }
    if (@hasDecl(@This(), "FN_PROGRESS")) {
        _ = FN_PROGRESS;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
//--------------------------------------------------------------------------------
// Section: SubModules (1)
//--------------------------------------------------------------------------------
pub const ui = @import("authorization/ui.zig");
