//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (1)
//--------------------------------------------------------------------------------
pub const CVT_SECONDS = @as(u32, 1);

//--------------------------------------------------------------------------------
// Section: Types (105)
//--------------------------------------------------------------------------------
pub const TOKEN_PRIVILEGES_ATTRIBUTES = enum(u32) {
    ENABLED = 2,
    ENABLED_BY_DEFAULT = 1,
    REMOVED = 4,
    USED_FOR_ACCESS = 2147483648,
    _,
    pub fn initFlags(o: struct {
        ENABLED: u1 = 0,
        ENABLED_BY_DEFAULT: u1 = 0,
        REMOVED: u1 = 0,
        USED_FOR_ACCESS: u1 = 0,
    }) TOKEN_PRIVILEGES_ATTRIBUTES {
        return @as(TOKEN_PRIVILEGES_ATTRIBUTES, @enumFromInt((if (o.ENABLED == 1) @intFromEnum(TOKEN_PRIVILEGES_ATTRIBUTES.ENABLED) else 0) | (if (o.ENABLED_BY_DEFAULT == 1) @intFromEnum(TOKEN_PRIVILEGES_ATTRIBUTES.ENABLED_BY_DEFAULT) else 0) | (if (o.REMOVED == 1) @intFromEnum(TOKEN_PRIVILEGES_ATTRIBUTES.REMOVED) else 0) | (if (o.USED_FOR_ACCESS == 1) @intFromEnum(TOKEN_PRIVILEGES_ATTRIBUTES.USED_FOR_ACCESS) else 0)));
    }
};
pub const SE_PRIVILEGE_ENABLED = TOKEN_PRIVILEGES_ATTRIBUTES.ENABLED;
pub const SE_PRIVILEGE_ENABLED_BY_DEFAULT = TOKEN_PRIVILEGES_ATTRIBUTES.ENABLED_BY_DEFAULT;
pub const SE_PRIVILEGE_REMOVED = TOKEN_PRIVILEGES_ATTRIBUTES.REMOVED;
pub const SE_PRIVILEGE_USED_FOR_ACCESS = TOKEN_PRIVILEGES_ATTRIBUTES.USED_FOR_ACCESS;

pub const LOGON32_PROVIDER = enum(u32) {
    DEFAULT = 0,
    WINNT50 = 3,
    WINNT40 = 2,
};
pub const LOGON32_PROVIDER_DEFAULT = LOGON32_PROVIDER.DEFAULT;
pub const LOGON32_PROVIDER_WINNT50 = LOGON32_PROVIDER.WINNT50;
pub const LOGON32_PROVIDER_WINNT40 = LOGON32_PROVIDER.WINNT40;

pub const CREATE_RESTRICTED_TOKEN_FLAGS = enum(u32) {
    DISABLE_MAX_PRIVILEGE = 1,
    SANDBOX_INERT = 2,
    LUA_TOKEN = 4,
    WRITE_RESTRICTED = 8,
    _,
    pub fn initFlags(o: struct {
        DISABLE_MAX_PRIVILEGE: u1 = 0,
        SANDBOX_INERT: u1 = 0,
        LUA_TOKEN: u1 = 0,
        WRITE_RESTRICTED: u1 = 0,
    }) CREATE_RESTRICTED_TOKEN_FLAGS {
        return @as(CREATE_RESTRICTED_TOKEN_FLAGS, @enumFromInt((if (o.DISABLE_MAX_PRIVILEGE == 1) @intFromEnum(CREATE_RESTRICTED_TOKEN_FLAGS.DISABLE_MAX_PRIVILEGE) else 0) | (if (o.SANDBOX_INERT == 1) @intFromEnum(CREATE_RESTRICTED_TOKEN_FLAGS.SANDBOX_INERT) else 0) | (if (o.LUA_TOKEN == 1) @intFromEnum(CREATE_RESTRICTED_TOKEN_FLAGS.LUA_TOKEN) else 0) | (if (o.WRITE_RESTRICTED == 1) @intFromEnum(CREATE_RESTRICTED_TOKEN_FLAGS.WRITE_RESTRICTED) else 0)));
    }
};
pub const DISABLE_MAX_PRIVILEGE = CREATE_RESTRICTED_TOKEN_FLAGS.DISABLE_MAX_PRIVILEGE;
pub const SANDBOX_INERT = CREATE_RESTRICTED_TOKEN_FLAGS.SANDBOX_INERT;
pub const LUA_TOKEN = CREATE_RESTRICTED_TOKEN_FLAGS.LUA_TOKEN;
pub const WRITE_RESTRICTED = CREATE_RESTRICTED_TOKEN_FLAGS.WRITE_RESTRICTED;

pub const LOGON32_LOGON = enum(u32) {
    BATCH = 4,
    INTERACTIVE = 2,
    NETWORK = 3,
    NETWORK_CLEARTEXT = 8,
    NEW_CREDENTIALS = 9,
    SERVICE = 5,
    UNLOCK = 7,
};
pub const LOGON32_LOGON_BATCH = LOGON32_LOGON.BATCH;
pub const LOGON32_LOGON_INTERACTIVE = LOGON32_LOGON.INTERACTIVE;
pub const LOGON32_LOGON_NETWORK = LOGON32_LOGON.NETWORK;
pub const LOGON32_LOGON_NETWORK_CLEARTEXT = LOGON32_LOGON.NETWORK_CLEARTEXT;
pub const LOGON32_LOGON_NEW_CREDENTIALS = LOGON32_LOGON.NEW_CREDENTIALS;
pub const LOGON32_LOGON_SERVICE = LOGON32_LOGON.SERVICE;
pub const LOGON32_LOGON_UNLOCK = LOGON32_LOGON.UNLOCK;

pub const ACE_FLAGS = enum(u32) {
    CONTAINER_INHERIT_ACE = 2,
    FAILED_ACCESS_ACE_FLAG = 128,
    INHERIT_ONLY_ACE = 8,
    INHERITED_ACE = 16,
    NO_PROPAGATE_INHERIT_ACE = 4,
    OBJECT_INHERIT_ACE = 1,
    SUCCESSFUL_ACCESS_ACE_FLAG = 64,
    SUB_CONTAINERS_AND_OBJECTS_INHERIT = 3,
    // SUB_CONTAINERS_ONLY_INHERIT = 2, this enum value conflicts with CONTAINER_INHERIT_ACE
    // SUB_OBJECTS_ONLY_INHERIT = 1, this enum value conflicts with OBJECT_INHERIT_ACE
    // INHERIT_NO_PROPAGATE = 4, this enum value conflicts with NO_PROPAGATE_INHERIT_ACE
    // INHERIT_ONLY = 8, this enum value conflicts with INHERIT_ONLY_ACE
    NO_INHERITANCE = 0,
    // INHERIT_ONLY_ACE_ = 8, this enum value conflicts with INHERIT_ONLY_ACE
    _,
    pub fn initFlags(o: struct {
        CONTAINER_INHERIT_ACE: u1 = 0,
        FAILED_ACCESS_ACE_FLAG: u1 = 0,
        INHERIT_ONLY_ACE: u1 = 0,
        INHERITED_ACE: u1 = 0,
        NO_PROPAGATE_INHERIT_ACE: u1 = 0,
        OBJECT_INHERIT_ACE: u1 = 0,
        SUCCESSFUL_ACCESS_ACE_FLAG: u1 = 0,
        SUB_CONTAINERS_AND_OBJECTS_INHERIT: u1 = 0,
        NO_INHERITANCE: u1 = 0,
    }) ACE_FLAGS {
        return @as(ACE_FLAGS, @enumFromInt((if (o.CONTAINER_INHERIT_ACE == 1) @intFromEnum(ACE_FLAGS.CONTAINER_INHERIT_ACE) else 0) | (if (o.FAILED_ACCESS_ACE_FLAG == 1) @intFromEnum(ACE_FLAGS.FAILED_ACCESS_ACE_FLAG) else 0) | (if (o.INHERIT_ONLY_ACE == 1) @intFromEnum(ACE_FLAGS.INHERIT_ONLY_ACE) else 0) | (if (o.INHERITED_ACE == 1) @intFromEnum(ACE_FLAGS.INHERITED_ACE) else 0) | (if (o.NO_PROPAGATE_INHERIT_ACE == 1) @intFromEnum(ACE_FLAGS.NO_PROPAGATE_INHERIT_ACE) else 0) | (if (o.OBJECT_INHERIT_ACE == 1) @intFromEnum(ACE_FLAGS.OBJECT_INHERIT_ACE) else 0) | (if (o.SUCCESSFUL_ACCESS_ACE_FLAG == 1) @intFromEnum(ACE_FLAGS.SUCCESSFUL_ACCESS_ACE_FLAG) else 0) | (if (o.SUB_CONTAINERS_AND_OBJECTS_INHERIT == 1) @intFromEnum(ACE_FLAGS.SUB_CONTAINERS_AND_OBJECTS_INHERIT) else 0) | (if (o.NO_INHERITANCE == 1) @intFromEnum(ACE_FLAGS.NO_INHERITANCE) else 0)));
    }
};
pub const CONTAINER_INHERIT_ACE = ACE_FLAGS.CONTAINER_INHERIT_ACE;
pub const FAILED_ACCESS_ACE_FLAG = ACE_FLAGS.FAILED_ACCESS_ACE_FLAG;
pub const INHERIT_ONLY_ACE = ACE_FLAGS.INHERIT_ONLY_ACE;
pub const INHERITED_ACE = ACE_FLAGS.INHERITED_ACE;
pub const NO_PROPAGATE_INHERIT_ACE = ACE_FLAGS.NO_PROPAGATE_INHERIT_ACE;
pub const OBJECT_INHERIT_ACE = ACE_FLAGS.OBJECT_INHERIT_ACE;
pub const SUCCESSFUL_ACCESS_ACE_FLAG = ACE_FLAGS.SUCCESSFUL_ACCESS_ACE_FLAG;
pub const SUB_CONTAINERS_AND_OBJECTS_INHERIT = ACE_FLAGS.SUB_CONTAINERS_AND_OBJECTS_INHERIT;
pub const SUB_CONTAINERS_ONLY_INHERIT = ACE_FLAGS.CONTAINER_INHERIT_ACE;
pub const SUB_OBJECTS_ONLY_INHERIT = ACE_FLAGS.OBJECT_INHERIT_ACE;
pub const INHERIT_NO_PROPAGATE = ACE_FLAGS.NO_PROPAGATE_INHERIT_ACE;
pub const INHERIT_ONLY = ACE_FLAGS.INHERIT_ONLY_ACE;
pub const NO_INHERITANCE = ACE_FLAGS.NO_INHERITANCE;
pub const INHERIT_ONLY_ACE_ = ACE_FLAGS.INHERIT_ONLY_ACE;

pub const OBJECT_SECURITY_INFORMATION = enum(u32) {
    ATTRIBUTE_SECURITY_INFORMATION = 32,
    BACKUP_SECURITY_INFORMATION = 65536,
    DACL_SECURITY_INFORMATION = 4,
    GROUP_SECURITY_INFORMATION = 2,
    LABEL_SECURITY_INFORMATION = 16,
    OWNER_SECURITY_INFORMATION = 1,
    PROTECTED_DACL_SECURITY_INFORMATION = 2147483648,
    PROTECTED_SACL_SECURITY_INFORMATION = 1073741824,
    SACL_SECURITY_INFORMATION = 8,
    SCOPE_SECURITY_INFORMATION = 64,
    UNPROTECTED_DACL_SECURITY_INFORMATION = 536870912,
    UNPROTECTED_SACL_SECURITY_INFORMATION = 268435456,
    _,
    pub fn initFlags(o: struct {
        ATTRIBUTE_SECURITY_INFORMATION: u1 = 0,
        BACKUP_SECURITY_INFORMATION: u1 = 0,
        DACL_SECURITY_INFORMATION: u1 = 0,
        GROUP_SECURITY_INFORMATION: u1 = 0,
        LABEL_SECURITY_INFORMATION: u1 = 0,
        OWNER_SECURITY_INFORMATION: u1 = 0,
        PROTECTED_DACL_SECURITY_INFORMATION: u1 = 0,
        PROTECTED_SACL_SECURITY_INFORMATION: u1 = 0,
        SACL_SECURITY_INFORMATION: u1 = 0,
        SCOPE_SECURITY_INFORMATION: u1 = 0,
        UNPROTECTED_DACL_SECURITY_INFORMATION: u1 = 0,
        UNPROTECTED_SACL_SECURITY_INFORMATION: u1 = 0,
    }) OBJECT_SECURITY_INFORMATION {
        return @as(OBJECT_SECURITY_INFORMATION, @enumFromInt((if (o.ATTRIBUTE_SECURITY_INFORMATION == 1) @intFromEnum(OBJECT_SECURITY_INFORMATION.ATTRIBUTE_SECURITY_INFORMATION) else 0) | (if (o.BACKUP_SECURITY_INFORMATION == 1) @intFromEnum(OBJECT_SECURITY_INFORMATION.BACKUP_SECURITY_INFORMATION) else 0) | (if (o.DACL_SECURITY_INFORMATION == 1) @intFromEnum(OBJECT_SECURITY_INFORMATION.DACL_SECURITY_INFORMATION) else 0) | (if (o.GROUP_SECURITY_INFORMATION == 1) @intFromEnum(OBJECT_SECURITY_INFORMATION.GROUP_SECURITY_INFORMATION) else 0) | (if (o.LABEL_SECURITY_INFORMATION == 1) @intFromEnum(OBJECT_SECURITY_INFORMATION.LABEL_SECURITY_INFORMATION) else 0) | (if (o.OWNER_SECURITY_INFORMATION == 1) @intFromEnum(OBJECT_SECURITY_INFORMATION.OWNER_SECURITY_INFORMATION) else 0) | (if (o.PROTECTED_DACL_SECURITY_INFORMATION == 1) @intFromEnum(OBJECT_SECURITY_INFORMATION.PROTECTED_DACL_SECURITY_INFORMATION) else 0) | (if (o.PROTECTED_SACL_SECURITY_INFORMATION == 1) @intFromEnum(OBJECT_SECURITY_INFORMATION.PROTECTED_SACL_SECURITY_INFORMATION) else 0) | (if (o.SACL_SECURITY_INFORMATION == 1) @intFromEnum(OBJECT_SECURITY_INFORMATION.SACL_SECURITY_INFORMATION) else 0) | (if (o.SCOPE_SECURITY_INFORMATION == 1) @intFromEnum(OBJECT_SECURITY_INFORMATION.SCOPE_SECURITY_INFORMATION) else 0) | (if (o.UNPROTECTED_DACL_SECURITY_INFORMATION == 1) @intFromEnum(OBJECT_SECURITY_INFORMATION.UNPROTECTED_DACL_SECURITY_INFORMATION) else 0) | (if (o.UNPROTECTED_SACL_SECURITY_INFORMATION == 1) @intFromEnum(OBJECT_SECURITY_INFORMATION.UNPROTECTED_SACL_SECURITY_INFORMATION) else 0)));
    }
};
pub const ATTRIBUTE_SECURITY_INFORMATION = OBJECT_SECURITY_INFORMATION.ATTRIBUTE_SECURITY_INFORMATION;
pub const BACKUP_SECURITY_INFORMATION = OBJECT_SECURITY_INFORMATION.BACKUP_SECURITY_INFORMATION;
pub const DACL_SECURITY_INFORMATION = OBJECT_SECURITY_INFORMATION.DACL_SECURITY_INFORMATION;
pub const GROUP_SECURITY_INFORMATION = OBJECT_SECURITY_INFORMATION.GROUP_SECURITY_INFORMATION;
pub const LABEL_SECURITY_INFORMATION = OBJECT_SECURITY_INFORMATION.LABEL_SECURITY_INFORMATION;
pub const OWNER_SECURITY_INFORMATION = OBJECT_SECURITY_INFORMATION.OWNER_SECURITY_INFORMATION;
pub const PROTECTED_DACL_SECURITY_INFORMATION = OBJECT_SECURITY_INFORMATION.PROTECTED_DACL_SECURITY_INFORMATION;
pub const PROTECTED_SACL_SECURITY_INFORMATION = OBJECT_SECURITY_INFORMATION.PROTECTED_SACL_SECURITY_INFORMATION;
pub const SACL_SECURITY_INFORMATION = OBJECT_SECURITY_INFORMATION.SACL_SECURITY_INFORMATION;
pub const SCOPE_SECURITY_INFORMATION = OBJECT_SECURITY_INFORMATION.SCOPE_SECURITY_INFORMATION;
pub const UNPROTECTED_DACL_SECURITY_INFORMATION = OBJECT_SECURITY_INFORMATION.UNPROTECTED_DACL_SECURITY_INFORMATION;
pub const UNPROTECTED_SACL_SECURITY_INFORMATION = OBJECT_SECURITY_INFORMATION.UNPROTECTED_SACL_SECURITY_INFORMATION;

pub const SECURITY_AUTO_INHERIT_FLAGS = enum(u32) {
    AVOID_OWNER_CHECK = 16,
    AVOID_OWNER_RESTRICTION = 4096,
    AVOID_PRIVILEGE_CHECK = 8,
    DACL_AUTO_INHERIT = 1,
    DEFAULT_DESCRIPTOR_FOR_OBJECT = 4,
    DEFAULT_GROUP_FROM_PARENT = 64,
    DEFAULT_OWNER_FROM_PARENT = 32,
    MACL_NO_EXECUTE_UP = 1024,
    MACL_NO_READ_UP = 512,
    MACL_NO_WRITE_UP = 256,
    SACL_AUTO_INHERIT = 2,
    _,
    pub fn initFlags(o: struct {
        AVOID_OWNER_CHECK: u1 = 0,
        AVOID_OWNER_RESTRICTION: u1 = 0,
        AVOID_PRIVILEGE_CHECK: u1 = 0,
        DACL_AUTO_INHERIT: u1 = 0,
        DEFAULT_DESCRIPTOR_FOR_OBJECT: u1 = 0,
        DEFAULT_GROUP_FROM_PARENT: u1 = 0,
        DEFAULT_OWNER_FROM_PARENT: u1 = 0,
        MACL_NO_EXECUTE_UP: u1 = 0,
        MACL_NO_READ_UP: u1 = 0,
        MACL_NO_WRITE_UP: u1 = 0,
        SACL_AUTO_INHERIT: u1 = 0,
    }) SECURITY_AUTO_INHERIT_FLAGS {
        return @as(SECURITY_AUTO_INHERIT_FLAGS, @enumFromInt((if (o.AVOID_OWNER_CHECK == 1) @intFromEnum(SECURITY_AUTO_INHERIT_FLAGS.AVOID_OWNER_CHECK) else 0) | (if (o.AVOID_OWNER_RESTRICTION == 1) @intFromEnum(SECURITY_AUTO_INHERIT_FLAGS.AVOID_OWNER_RESTRICTION) else 0) | (if (o.AVOID_PRIVILEGE_CHECK == 1) @intFromEnum(SECURITY_AUTO_INHERIT_FLAGS.AVOID_PRIVILEGE_CHECK) else 0) | (if (o.DACL_AUTO_INHERIT == 1) @intFromEnum(SECURITY_AUTO_INHERIT_FLAGS.DACL_AUTO_INHERIT) else 0) | (if (o.DEFAULT_DESCRIPTOR_FOR_OBJECT == 1) @intFromEnum(SECURITY_AUTO_INHERIT_FLAGS.DEFAULT_DESCRIPTOR_FOR_OBJECT) else 0) | (if (o.DEFAULT_GROUP_FROM_PARENT == 1) @intFromEnum(SECURITY_AUTO_INHERIT_FLAGS.DEFAULT_GROUP_FROM_PARENT) else 0) | (if (o.DEFAULT_OWNER_FROM_PARENT == 1) @intFromEnum(SECURITY_AUTO_INHERIT_FLAGS.DEFAULT_OWNER_FROM_PARENT) else 0) | (if (o.MACL_NO_EXECUTE_UP == 1) @intFromEnum(SECURITY_AUTO_INHERIT_FLAGS.MACL_NO_EXECUTE_UP) else 0) | (if (o.MACL_NO_READ_UP == 1) @intFromEnum(SECURITY_AUTO_INHERIT_FLAGS.MACL_NO_READ_UP) else 0) | (if (o.MACL_NO_WRITE_UP == 1) @intFromEnum(SECURITY_AUTO_INHERIT_FLAGS.MACL_NO_WRITE_UP) else 0) | (if (o.SACL_AUTO_INHERIT == 1) @intFromEnum(SECURITY_AUTO_INHERIT_FLAGS.SACL_AUTO_INHERIT) else 0)));
    }
};
pub const SEF_AVOID_OWNER_CHECK = SECURITY_AUTO_INHERIT_FLAGS.AVOID_OWNER_CHECK;
pub const SEF_AVOID_OWNER_RESTRICTION = SECURITY_AUTO_INHERIT_FLAGS.AVOID_OWNER_RESTRICTION;
pub const SEF_AVOID_PRIVILEGE_CHECK = SECURITY_AUTO_INHERIT_FLAGS.AVOID_PRIVILEGE_CHECK;
pub const SEF_DACL_AUTO_INHERIT = SECURITY_AUTO_INHERIT_FLAGS.DACL_AUTO_INHERIT;
pub const SEF_DEFAULT_DESCRIPTOR_FOR_OBJECT = SECURITY_AUTO_INHERIT_FLAGS.DEFAULT_DESCRIPTOR_FOR_OBJECT;
pub const SEF_DEFAULT_GROUP_FROM_PARENT = SECURITY_AUTO_INHERIT_FLAGS.DEFAULT_GROUP_FROM_PARENT;
pub const SEF_DEFAULT_OWNER_FROM_PARENT = SECURITY_AUTO_INHERIT_FLAGS.DEFAULT_OWNER_FROM_PARENT;
pub const SEF_MACL_NO_EXECUTE_UP = SECURITY_AUTO_INHERIT_FLAGS.MACL_NO_EXECUTE_UP;
pub const SEF_MACL_NO_READ_UP = SECURITY_AUTO_INHERIT_FLAGS.MACL_NO_READ_UP;
pub const SEF_MACL_NO_WRITE_UP = SECURITY_AUTO_INHERIT_FLAGS.MACL_NO_WRITE_UP;
pub const SEF_SACL_AUTO_INHERIT = SECURITY_AUTO_INHERIT_FLAGS.SACL_AUTO_INHERIT;

pub const ACE_REVISION = enum(u32) {
    N = 2,
    _DS = 4,
};
pub const ACL_REVISION = ACE_REVISION.N;
pub const ACL_REVISION_DS = ACE_REVISION._DS;

pub const TOKEN_MANDATORY_POLICY_ID = enum(u32) {
    OFF = 0,
    NO_WRITE_UP = 1,
    NEW_PROCESS_MIN = 2,
    VALID_MASK = 3,
};
pub const TOKEN_MANDATORY_POLICY_OFF = TOKEN_MANDATORY_POLICY_ID.OFF;
pub const TOKEN_MANDATORY_POLICY_NO_WRITE_UP = TOKEN_MANDATORY_POLICY_ID.NO_WRITE_UP;
pub const TOKEN_MANDATORY_POLICY_NEW_PROCESS_MIN = TOKEN_MANDATORY_POLICY_ID.NEW_PROCESS_MIN;
pub const TOKEN_MANDATORY_POLICY_VALID_MASK = TOKEN_MANDATORY_POLICY_ID.VALID_MASK;

pub const SYSTEM_AUDIT_OBJECT_ACE_FLAGS = enum(u32) {
    OBJECT_TYPE_PRESENT = 1,
    INHERITED_OBJECT_TYPE_PRESENT = 2,
    _,
    pub fn initFlags(o: struct {
        OBJECT_TYPE_PRESENT: u1 = 0,
        INHERITED_OBJECT_TYPE_PRESENT: u1 = 0,
    }) SYSTEM_AUDIT_OBJECT_ACE_FLAGS {
        return @as(SYSTEM_AUDIT_OBJECT_ACE_FLAGS, @enumFromInt((if (o.OBJECT_TYPE_PRESENT == 1) @intFromEnum(SYSTEM_AUDIT_OBJECT_ACE_FLAGS.OBJECT_TYPE_PRESENT) else 0) | (if (o.INHERITED_OBJECT_TYPE_PRESENT == 1) @intFromEnum(SYSTEM_AUDIT_OBJECT_ACE_FLAGS.INHERITED_OBJECT_TYPE_PRESENT) else 0)));
    }
};
pub const ACE_OBJECT_TYPE_PRESENT = SYSTEM_AUDIT_OBJECT_ACE_FLAGS.OBJECT_TYPE_PRESENT;
pub const ACE_INHERITED_OBJECT_TYPE_PRESENT = SYSTEM_AUDIT_OBJECT_ACE_FLAGS.INHERITED_OBJECT_TYPE_PRESENT;

pub const CLAIM_SECURITY_ATTRIBUTE_FLAGS = enum(u32) {
    NON_INHERITABLE = 1,
    VALUE_CASE_SENSITIVE = 2,
    USE_FOR_DENY_ONLY = 4,
    DISABLED_BY_DEFAULT = 8,
    DISABLED = 16,
    MANDATORY = 32,
    _,
    pub fn initFlags(o: struct {
        NON_INHERITABLE: u1 = 0,
        VALUE_CASE_SENSITIVE: u1 = 0,
        USE_FOR_DENY_ONLY: u1 = 0,
        DISABLED_BY_DEFAULT: u1 = 0,
        DISABLED: u1 = 0,
        MANDATORY: u1 = 0,
    }) CLAIM_SECURITY_ATTRIBUTE_FLAGS {
        return @as(CLAIM_SECURITY_ATTRIBUTE_FLAGS, @enumFromInt((if (o.NON_INHERITABLE == 1) @intFromEnum(CLAIM_SECURITY_ATTRIBUTE_FLAGS.NON_INHERITABLE) else 0) | (if (o.VALUE_CASE_SENSITIVE == 1) @intFromEnum(CLAIM_SECURITY_ATTRIBUTE_FLAGS.VALUE_CASE_SENSITIVE) else 0) | (if (o.USE_FOR_DENY_ONLY == 1) @intFromEnum(CLAIM_SECURITY_ATTRIBUTE_FLAGS.USE_FOR_DENY_ONLY) else 0) | (if (o.DISABLED_BY_DEFAULT == 1) @intFromEnum(CLAIM_SECURITY_ATTRIBUTE_FLAGS.DISABLED_BY_DEFAULT) else 0) | (if (o.DISABLED == 1) @intFromEnum(CLAIM_SECURITY_ATTRIBUTE_FLAGS.DISABLED) else 0) | (if (o.MANDATORY == 1) @intFromEnum(CLAIM_SECURITY_ATTRIBUTE_FLAGS.MANDATORY) else 0)));
    }
};
pub const CLAIM_SECURITY_ATTRIBUTE_NON_INHERITABLE = CLAIM_SECURITY_ATTRIBUTE_FLAGS.NON_INHERITABLE;
pub const CLAIM_SECURITY_ATTRIBUTE_VALUE_CASE_SENSITIVE = CLAIM_SECURITY_ATTRIBUTE_FLAGS.VALUE_CASE_SENSITIVE;
pub const CLAIM_SECURITY_ATTRIBUTE_USE_FOR_DENY_ONLY = CLAIM_SECURITY_ATTRIBUTE_FLAGS.USE_FOR_DENY_ONLY;
pub const CLAIM_SECURITY_ATTRIBUTE_DISABLED_BY_DEFAULT = CLAIM_SECURITY_ATTRIBUTE_FLAGS.DISABLED_BY_DEFAULT;
pub const CLAIM_SECURITY_ATTRIBUTE_DISABLED = CLAIM_SECURITY_ATTRIBUTE_FLAGS.DISABLED;
pub const CLAIM_SECURITY_ATTRIBUTE_MANDATORY = CLAIM_SECURITY_ATTRIBUTE_FLAGS.MANDATORY;

pub const CLAIM_SECURITY_ATTRIBUTE_VALUE_TYPE = enum(u16) {
    INT64 = 1,
    UINT64 = 2,
    STRING = 3,
    OCTET_STRING = 16,
    FQBN = 4,
    SID = 5,
    BOOLEAN = 6,
};
pub const CLAIM_SECURITY_ATTRIBUTE_TYPE_INT64 = CLAIM_SECURITY_ATTRIBUTE_VALUE_TYPE.INT64;
pub const CLAIM_SECURITY_ATTRIBUTE_TYPE_UINT64 = CLAIM_SECURITY_ATTRIBUTE_VALUE_TYPE.UINT64;
pub const CLAIM_SECURITY_ATTRIBUTE_TYPE_STRING = CLAIM_SECURITY_ATTRIBUTE_VALUE_TYPE.STRING;
pub const CLAIM_SECURITY_ATTRIBUTE_TYPE_OCTET_STRING = CLAIM_SECURITY_ATTRIBUTE_VALUE_TYPE.OCTET_STRING;
pub const CLAIM_SECURITY_ATTRIBUTE_TYPE_FQBN = CLAIM_SECURITY_ATTRIBUTE_VALUE_TYPE.FQBN;
pub const CLAIM_SECURITY_ATTRIBUTE_TYPE_SID = CLAIM_SECURITY_ATTRIBUTE_VALUE_TYPE.SID;
pub const CLAIM_SECURITY_ATTRIBUTE_TYPE_BOOLEAN = CLAIM_SECURITY_ATTRIBUTE_VALUE_TYPE.BOOLEAN;

pub const PLSA_AP_CALL_PACKAGE_UNTRUSTED = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        ClientRequest: ?*?*anyopaque,
        // TODO: what to do with BytesParamIndex 3?
        ProtocolSubmitBuffer: ?*anyopaque,
        ClientBufferBase: ?*anyopaque,
        SubmitBufferLength: u32,
        ProtocolReturnBuffer: ?*?*anyopaque,
        ReturnBufferLength: ?*u32,
        ProtocolStatus: ?*i32,
    ) callconv(@import("std").os.windows.WINAPI) NTSTATUS,
    else => *const fn (
        ClientRequest: ?*?*anyopaque,
        // TODO: what to do with BytesParamIndex 3?
        ProtocolSubmitBuffer: ?*anyopaque,
        ClientBufferBase: ?*anyopaque,
        SubmitBufferLength: u32,
        ProtocolReturnBuffer: ?*?*anyopaque,
        ReturnBufferLength: ?*u32,
        ProtocolStatus: ?*i32,
    ) callconv(@import("std").os.windows.WINAPI) NTSTATUS,
};

pub const SEC_THREAD_START = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        lpThreadParameter: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) u32,
    else => *const fn (
        lpThreadParameter: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) u32,
};

pub const TOKEN_ACCESS_MASK = enum(u32) {
    DELETE = 65536,
    READ_CONTROL = 131072,
    WRITE_DAC = 262144,
    WRITE_OWNER = 524288,
    ACCESS_SYSTEM_SECURITY = 16777216,
    ASSIGN_PRIMARY = 1,
    DUPLICATE = 2,
    IMPERSONATE = 4,
    QUERY = 8,
    QUERY_SOURCE = 16,
    ADJUST_PRIVILEGES = 32,
    ADJUST_GROUPS = 64,
    ADJUST_DEFAULT = 128,
    ADJUST_SESSIONID = 256,
    ALL_ACCESS = 983295,
    _,
    pub fn initFlags(o: struct {
        DELETE: u1 = 0,
        READ_CONTROL: u1 = 0,
        WRITE_DAC: u1 = 0,
        WRITE_OWNER: u1 = 0,
        ACCESS_SYSTEM_SECURITY: u1 = 0,
        ASSIGN_PRIMARY: u1 = 0,
        DUPLICATE: u1 = 0,
        IMPERSONATE: u1 = 0,
        QUERY: u1 = 0,
        QUERY_SOURCE: u1 = 0,
        ADJUST_PRIVILEGES: u1 = 0,
        ADJUST_GROUPS: u1 = 0,
        ADJUST_DEFAULT: u1 = 0,
        ADJUST_SESSIONID: u1 = 0,
        ALL_ACCESS: u1 = 0,
    }) TOKEN_ACCESS_MASK {
        return @as(TOKEN_ACCESS_MASK, @enumFromInt((if (o.DELETE == 1) @intFromEnum(TOKEN_ACCESS_MASK.DELETE) else 0) | (if (o.READ_CONTROL == 1) @intFromEnum(TOKEN_ACCESS_MASK.READ_CONTROL) else 0) | (if (o.WRITE_DAC == 1) @intFromEnum(TOKEN_ACCESS_MASK.WRITE_DAC) else 0) | (if (o.WRITE_OWNER == 1) @intFromEnum(TOKEN_ACCESS_MASK.WRITE_OWNER) else 0) | (if (o.ACCESS_SYSTEM_SECURITY == 1) @intFromEnum(TOKEN_ACCESS_MASK.ACCESS_SYSTEM_SECURITY) else 0) | (if (o.ASSIGN_PRIMARY == 1) @intFromEnum(TOKEN_ACCESS_MASK.ASSIGN_PRIMARY) else 0) | (if (o.DUPLICATE == 1) @intFromEnum(TOKEN_ACCESS_MASK.DUPLICATE) else 0) | (if (o.IMPERSONATE == 1) @intFromEnum(TOKEN_ACCESS_MASK.IMPERSONATE) else 0) | (if (o.QUERY == 1) @intFromEnum(TOKEN_ACCESS_MASK.QUERY) else 0) | (if (o.QUERY_SOURCE == 1) @intFromEnum(TOKEN_ACCESS_MASK.QUERY_SOURCE) else 0) | (if (o.ADJUST_PRIVILEGES == 1) @intFromEnum(TOKEN_ACCESS_MASK.ADJUST_PRIVILEGES) else 0) | (if (o.ADJUST_GROUPS == 1) @intFromEnum(TOKEN_ACCESS_MASK.ADJUST_GROUPS) else 0) | (if (o.ADJUST_DEFAULT == 1) @intFromEnum(TOKEN_ACCESS_MASK.ADJUST_DEFAULT) else 0) | (if (o.ADJUST_SESSIONID == 1) @intFromEnum(TOKEN_ACCESS_MASK.ADJUST_SESSIONID) else 0) | (if (o.ALL_ACCESS == 1) @intFromEnum(TOKEN_ACCESS_MASK.ALL_ACCESS) else 0)));
    }
};
pub const TOKEN_DELETE = TOKEN_ACCESS_MASK.DELETE;
pub const TOKEN_READ_CONTROL = TOKEN_ACCESS_MASK.READ_CONTROL;
pub const TOKEN_WRITE_DAC = TOKEN_ACCESS_MASK.WRITE_DAC;
pub const TOKEN_WRITE_OWNER = TOKEN_ACCESS_MASK.WRITE_OWNER;
pub const TOKEN_ACCESS_SYSTEM_SECURITY = TOKEN_ACCESS_MASK.ACCESS_SYSTEM_SECURITY;
pub const TOKEN_ASSIGN_PRIMARY = TOKEN_ACCESS_MASK.ASSIGN_PRIMARY;
pub const TOKEN_DUPLICATE = TOKEN_ACCESS_MASK.DUPLICATE;
pub const TOKEN_IMPERSONATE = TOKEN_ACCESS_MASK.IMPERSONATE;
pub const TOKEN_QUERY = TOKEN_ACCESS_MASK.QUERY;
pub const TOKEN_QUERY_SOURCE = TOKEN_ACCESS_MASK.QUERY_SOURCE;
pub const TOKEN_ADJUST_PRIVILEGES = TOKEN_ACCESS_MASK.ADJUST_PRIVILEGES;
pub const TOKEN_ADJUST_GROUPS = TOKEN_ACCESS_MASK.ADJUST_GROUPS;
pub const TOKEN_ADJUST_DEFAULT = TOKEN_ACCESS_MASK.ADJUST_DEFAULT;
pub const TOKEN_ADJUST_SESSIONID = TOKEN_ACCESS_MASK.ADJUST_SESSIONID;
pub const TOKEN_ALL_ACCESS = TOKEN_ACCESS_MASK.ALL_ACCESS;

pub const HDIAGNOSTIC_DATA_QUERY_SESSION = isize;

pub const HDIAGNOSTIC_REPORT = isize;

pub const HDIAGNOSTIC_EVENT_TAG_DESCRIPTION = isize;

pub const HDIAGNOSTIC_EVENT_PRODUCER_DESCRIPTION = isize;

pub const HDIAGNOSTIC_EVENT_CATEGORY_DESCRIPTION = isize;

pub const HDIAGNOSTIC_RECORD = isize;

pub const NCRYPT_DESCRIPTOR_HANDLE = isize;

pub const NCRYPT_STREAM_HANDLE = isize;

pub const SAFER_LEVEL_HANDLE = isize;

pub const SC_HANDLE = isize;

pub const SECURITY_ATTRIBUTES = extern struct {
    nLength: u32,
    lpSecurityDescriptor: ?*anyopaque,
    bInheritHandle: BOOL,
};

pub const ENUM_PERIOD = enum(i32) {
    INVALID = -1,
    SECONDS = 0,
    MINUTES = 1,
    HOURS = 2,
    DAYS = 3,
    WEEKS = 4,
    MONTHS = 5,
    YEARS = 6,
};
pub const ENUM_PERIOD_INVALID = ENUM_PERIOD.INVALID;
pub const ENUM_PERIOD_SECONDS = ENUM_PERIOD.SECONDS;
pub const ENUM_PERIOD_MINUTES = ENUM_PERIOD.MINUTES;
pub const ENUM_PERIOD_HOURS = ENUM_PERIOD.HOURS;
pub const ENUM_PERIOD_DAYS = ENUM_PERIOD.DAYS;
pub const ENUM_PERIOD_WEEKS = ENUM_PERIOD.WEEKS;
pub const ENUM_PERIOD_MONTHS = ENUM_PERIOD.MONTHS;
pub const ENUM_PERIOD_YEARS = ENUM_PERIOD.YEARS;

pub const LLFILETIME = extern struct {
    Anonymous: extern union {
        ll: i64,
        ft: FILETIME,
    },
};

pub const GENERIC_MAPPING = extern struct {
    GenericRead: u32,
    GenericWrite: u32,
    GenericExecute: u32,
    GenericAll: u32,
};

pub const LUID_AND_ATTRIBUTES = extern struct {
    Luid: LUID,
    Attributes: TOKEN_PRIVILEGES_ATTRIBUTES,
};

pub const SID_IDENTIFIER_AUTHORITY = extern struct {
    Value: [6]u8,
};

pub const SID = extern struct {
    Revision: u8,
    SubAuthorityCount: u8,
    IdentifierAuthority: SID_IDENTIFIER_AUTHORITY,
    SubAuthority: [1]u32,
};

pub const SE_SID = extern union {
    Sid: SID,
    Buffer: [68]u8,
};

pub const SID_NAME_USE = enum(i32) {
    User = 1,
    Group = 2,
    Domain = 3,
    Alias = 4,
    WellKnownGroup = 5,
    DeletedAccount = 6,
    Invalid = 7,
    Unknown = 8,
    Computer = 9,
    Label = 10,
    LogonSession = 11,
};
pub const SidTypeUser = SID_NAME_USE.User;
pub const SidTypeGroup = SID_NAME_USE.Group;
pub const SidTypeDomain = SID_NAME_USE.Domain;
pub const SidTypeAlias = SID_NAME_USE.Alias;
pub const SidTypeWellKnownGroup = SID_NAME_USE.WellKnownGroup;
pub const SidTypeDeletedAccount = SID_NAME_USE.DeletedAccount;
pub const SidTypeInvalid = SID_NAME_USE.Invalid;
pub const SidTypeUnknown = SID_NAME_USE.Unknown;
pub const SidTypeComputer = SID_NAME_USE.Computer;
pub const SidTypeLabel = SID_NAME_USE.Label;
pub const SidTypeLogonSession = SID_NAME_USE.LogonSession;

pub const SID_AND_ATTRIBUTES = extern struct {
    Sid: ?PSID,
    Attributes: u32,
};

pub const SID_AND_ATTRIBUTES_HASH = extern struct {
    SidCount: u32,
    SidAttr: ?*SID_AND_ATTRIBUTES,
    Hash: [32]usize,
};

pub const WELL_KNOWN_SID_TYPE = enum(i32) {
    NullSid = 0,
    WorldSid = 1,
    LocalSid = 2,
    CreatorOwnerSid = 3,
    CreatorGroupSid = 4,
    CreatorOwnerServerSid = 5,
    CreatorGroupServerSid = 6,
    NtAuthoritySid = 7,
    DialupSid = 8,
    NetworkSid = 9,
    BatchSid = 10,
    InteractiveSid = 11,
    ServiceSid = 12,
    AnonymousSid = 13,
    ProxySid = 14,
    EnterpriseControllersSid = 15,
    SelfSid = 16,
    AuthenticatedUserSid = 17,
    RestrictedCodeSid = 18,
    TerminalServerSid = 19,
    RemoteLogonIdSid = 20,
    LogonIdsSid = 21,
    LocalSystemSid = 22,
    LocalServiceSid = 23,
    NetworkServiceSid = 24,
    BuiltinDomainSid = 25,
    BuiltinAdministratorsSid = 26,
    BuiltinUsersSid = 27,
    BuiltinGuestsSid = 28,
    BuiltinPowerUsersSid = 29,
    BuiltinAccountOperatorsSid = 30,
    BuiltinSystemOperatorsSid = 31,
    BuiltinPrintOperatorsSid = 32,
    BuiltinBackupOperatorsSid = 33,
    BuiltinReplicatorSid = 34,
    BuiltinPreWindows2000CompatibleAccessSid = 35,
    BuiltinRemoteDesktopUsersSid = 36,
    BuiltinNetworkConfigurationOperatorsSid = 37,
    AccountAdministratorSid = 38,
    AccountGuestSid = 39,
    AccountKrbtgtSid = 40,
    AccountDomainAdminsSid = 41,
    AccountDomainUsersSid = 42,
    AccountDomainGuestsSid = 43,
    AccountComputersSid = 44,
    AccountControllersSid = 45,
    AccountCertAdminsSid = 46,
    AccountSchemaAdminsSid = 47,
    AccountEnterpriseAdminsSid = 48,
    AccountPolicyAdminsSid = 49,
    AccountRasAndIasServersSid = 50,
    NTLMAuthenticationSid = 51,
    DigestAuthenticationSid = 52,
    SChannelAuthenticationSid = 53,
    ThisOrganizationSid = 54,
    OtherOrganizationSid = 55,
    BuiltinIncomingForestTrustBuildersSid = 56,
    BuiltinPerfMonitoringUsersSid = 57,
    BuiltinPerfLoggingUsersSid = 58,
    BuiltinAuthorizationAccessSid = 59,
    BuiltinTerminalServerLicenseServersSid = 60,
    BuiltinDCOMUsersSid = 61,
    BuiltinIUsersSid = 62,
    IUserSid = 63,
    BuiltinCryptoOperatorsSid = 64,
    UntrustedLabelSid = 65,
    LowLabelSid = 66,
    MediumLabelSid = 67,
    HighLabelSid = 68,
    SystemLabelSid = 69,
    WriteRestrictedCodeSid = 70,
    CreatorOwnerRightsSid = 71,
    CacheablePrincipalsGroupSid = 72,
    NonCacheablePrincipalsGroupSid = 73,
    EnterpriseReadonlyControllersSid = 74,
    AccountReadonlyControllersSid = 75,
    BuiltinEventLogReadersGroup = 76,
    NewEnterpriseReadonlyControllersSid = 77,
    BuiltinCertSvcDComAccessGroup = 78,
    MediumPlusLabelSid = 79,
    LocalLogonSid = 80,
    ConsoleLogonSid = 81,
    ThisOrganizationCertificateSid = 82,
    ApplicationPackageAuthoritySid = 83,
    BuiltinAnyPackageSid = 84,
    CapabilityInternetClientSid = 85,
    CapabilityInternetClientServerSid = 86,
    CapabilityPrivateNetworkClientServerSid = 87,
    CapabilityPicturesLibrarySid = 88,
    CapabilityVideosLibrarySid = 89,
    CapabilityMusicLibrarySid = 90,
    CapabilityDocumentsLibrarySid = 91,
    CapabilitySharedUserCertificatesSid = 92,
    CapabilityEnterpriseAuthenticationSid = 93,
    CapabilityRemovableStorageSid = 94,
    BuiltinRDSRemoteAccessServersSid = 95,
    BuiltinRDSEndpointServersSid = 96,
    BuiltinRDSManagementServersSid = 97,
    UserModeDriversSid = 98,
    BuiltinHyperVAdminsSid = 99,
    AccountCloneableControllersSid = 100,
    BuiltinAccessControlAssistanceOperatorsSid = 101,
    BuiltinRemoteManagementUsersSid = 102,
    AuthenticationAuthorityAssertedSid = 103,
    AuthenticationServiceAssertedSid = 104,
    LocalAccountSid = 105,
    LocalAccountAndAdministratorSid = 106,
    AccountProtectedUsersSid = 107,
    CapabilityAppointmentsSid = 108,
    CapabilityContactsSid = 109,
    AccountDefaultSystemManagedSid = 110,
    BuiltinDefaultSystemManagedGroupSid = 111,
    BuiltinStorageReplicaAdminsSid = 112,
    AccountKeyAdminsSid = 113,
    AccountEnterpriseKeyAdminsSid = 114,
    AuthenticationKeyTrustSid = 115,
    AuthenticationKeyPropertyMFASid = 116,
    AuthenticationKeyPropertyAttestationSid = 117,
    AuthenticationFreshKeyAuthSid = 118,
    BuiltinDeviceOwnersSid = 119,
};
pub const WinNullSid = WELL_KNOWN_SID_TYPE.NullSid;
pub const WinWorldSid = WELL_KNOWN_SID_TYPE.WorldSid;
pub const WinLocalSid = WELL_KNOWN_SID_TYPE.LocalSid;
pub const WinCreatorOwnerSid = WELL_KNOWN_SID_TYPE.CreatorOwnerSid;
pub const WinCreatorGroupSid = WELL_KNOWN_SID_TYPE.CreatorGroupSid;
pub const WinCreatorOwnerServerSid = WELL_KNOWN_SID_TYPE.CreatorOwnerServerSid;
pub const WinCreatorGroupServerSid = WELL_KNOWN_SID_TYPE.CreatorGroupServerSid;
pub const WinNtAuthoritySid = WELL_KNOWN_SID_TYPE.NtAuthoritySid;
pub const WinDialupSid = WELL_KNOWN_SID_TYPE.DialupSid;
pub const WinNetworkSid = WELL_KNOWN_SID_TYPE.NetworkSid;
pub const WinBatchSid = WELL_KNOWN_SID_TYPE.BatchSid;
pub const WinInteractiveSid = WELL_KNOWN_SID_TYPE.InteractiveSid;
pub const WinServiceSid = WELL_KNOWN_SID_TYPE.ServiceSid;
pub const WinAnonymousSid = WELL_KNOWN_SID_TYPE.AnonymousSid;
pub const WinProxySid = WELL_KNOWN_SID_TYPE.ProxySid;
pub const WinEnterpriseControllersSid = WELL_KNOWN_SID_TYPE.EnterpriseControllersSid;
pub const WinSelfSid = WELL_KNOWN_SID_TYPE.SelfSid;
pub const WinAuthenticatedUserSid = WELL_KNOWN_SID_TYPE.AuthenticatedUserSid;
pub const WinRestrictedCodeSid = WELL_KNOWN_SID_TYPE.RestrictedCodeSid;
pub const WinTerminalServerSid = WELL_KNOWN_SID_TYPE.TerminalServerSid;
pub const WinRemoteLogonIdSid = WELL_KNOWN_SID_TYPE.RemoteLogonIdSid;
pub const WinLogonIdsSid = WELL_KNOWN_SID_TYPE.LogonIdsSid;
pub const WinLocalSystemSid = WELL_KNOWN_SID_TYPE.LocalSystemSid;
pub const WinLocalServiceSid = WELL_KNOWN_SID_TYPE.LocalServiceSid;
pub const WinNetworkServiceSid = WELL_KNOWN_SID_TYPE.NetworkServiceSid;
pub const WinBuiltinDomainSid = WELL_KNOWN_SID_TYPE.BuiltinDomainSid;
pub const WinBuiltinAdministratorsSid = WELL_KNOWN_SID_TYPE.BuiltinAdministratorsSid;
pub const WinBuiltinUsersSid = WELL_KNOWN_SID_TYPE.BuiltinUsersSid;
pub const WinBuiltinGuestsSid = WELL_KNOWN_SID_TYPE.BuiltinGuestsSid;
pub const WinBuiltinPowerUsersSid = WELL_KNOWN_SID_TYPE.BuiltinPowerUsersSid;
pub const WinBuiltinAccountOperatorsSid = WELL_KNOWN_SID_TYPE.BuiltinAccountOperatorsSid;
pub const WinBuiltinSystemOperatorsSid = WELL_KNOWN_SID_TYPE.BuiltinSystemOperatorsSid;
pub const WinBuiltinPrintOperatorsSid = WELL_KNOWN_SID_TYPE.BuiltinPrintOperatorsSid;
pub const WinBuiltinBackupOperatorsSid = WELL_KNOWN_SID_TYPE.BuiltinBackupOperatorsSid;
pub const WinBuiltinReplicatorSid = WELL_KNOWN_SID_TYPE.BuiltinReplicatorSid;
pub const WinBuiltinPreWindows2000CompatibleAccessSid = WELL_KNOWN_SID_TYPE.BuiltinPreWindows2000CompatibleAccessSid;
pub const WinBuiltinRemoteDesktopUsersSid = WELL_KNOWN_SID_TYPE.BuiltinRemoteDesktopUsersSid;
pub const WinBuiltinNetworkConfigurationOperatorsSid = WELL_KNOWN_SID_TYPE.BuiltinNetworkConfigurationOperatorsSid;
pub const WinAccountAdministratorSid = WELL_KNOWN_SID_TYPE.AccountAdministratorSid;
pub const WinAccountGuestSid = WELL_KNOWN_SID_TYPE.AccountGuestSid;
pub const WinAccountKrbtgtSid = WELL_KNOWN_SID_TYPE.AccountKrbtgtSid;
pub const WinAccountDomainAdminsSid = WELL_KNOWN_SID_TYPE.AccountDomainAdminsSid;
pub const WinAccountDomainUsersSid = WELL_KNOWN_SID_TYPE.AccountDomainUsersSid;
pub const WinAccountDomainGuestsSid = WELL_KNOWN_SID_TYPE.AccountDomainGuestsSid;
pub const WinAccountComputersSid = WELL_KNOWN_SID_TYPE.AccountComputersSid;
pub const WinAccountControllersSid = WELL_KNOWN_SID_TYPE.AccountControllersSid;
pub const WinAccountCertAdminsSid = WELL_KNOWN_SID_TYPE.AccountCertAdminsSid;
pub const WinAccountSchemaAdminsSid = WELL_KNOWN_SID_TYPE.AccountSchemaAdminsSid;
pub const WinAccountEnterpriseAdminsSid = WELL_KNOWN_SID_TYPE.AccountEnterpriseAdminsSid;
pub const WinAccountPolicyAdminsSid = WELL_KNOWN_SID_TYPE.AccountPolicyAdminsSid;
pub const WinAccountRasAndIasServersSid = WELL_KNOWN_SID_TYPE.AccountRasAndIasServersSid;
pub const WinNTLMAuthenticationSid = WELL_KNOWN_SID_TYPE.NTLMAuthenticationSid;
pub const WinDigestAuthenticationSid = WELL_KNOWN_SID_TYPE.DigestAuthenticationSid;
pub const WinSChannelAuthenticationSid = WELL_KNOWN_SID_TYPE.SChannelAuthenticationSid;
pub const WinThisOrganizationSid = WELL_KNOWN_SID_TYPE.ThisOrganizationSid;
pub const WinOtherOrganizationSid = WELL_KNOWN_SID_TYPE.OtherOrganizationSid;
pub const WinBuiltinIncomingForestTrustBuildersSid = WELL_KNOWN_SID_TYPE.BuiltinIncomingForestTrustBuildersSid;
pub const WinBuiltinPerfMonitoringUsersSid = WELL_KNOWN_SID_TYPE.BuiltinPerfMonitoringUsersSid;
pub const WinBuiltinPerfLoggingUsersSid = WELL_KNOWN_SID_TYPE.BuiltinPerfLoggingUsersSid;
pub const WinBuiltinAuthorizationAccessSid = WELL_KNOWN_SID_TYPE.BuiltinAuthorizationAccessSid;
pub const WinBuiltinTerminalServerLicenseServersSid = WELL_KNOWN_SID_TYPE.BuiltinTerminalServerLicenseServersSid;
pub const WinBuiltinDCOMUsersSid = WELL_KNOWN_SID_TYPE.BuiltinDCOMUsersSid;
pub const WinBuiltinIUsersSid = WELL_KNOWN_SID_TYPE.BuiltinIUsersSid;
pub const WinIUserSid = WELL_KNOWN_SID_TYPE.IUserSid;
pub const WinBuiltinCryptoOperatorsSid = WELL_KNOWN_SID_TYPE.BuiltinCryptoOperatorsSid;
pub const WinUntrustedLabelSid = WELL_KNOWN_SID_TYPE.UntrustedLabelSid;
pub const WinLowLabelSid = WELL_KNOWN_SID_TYPE.LowLabelSid;
pub const WinMediumLabelSid = WELL_KNOWN_SID_TYPE.MediumLabelSid;
pub const WinHighLabelSid = WELL_KNOWN_SID_TYPE.HighLabelSid;
pub const WinSystemLabelSid = WELL_KNOWN_SID_TYPE.SystemLabelSid;
pub const WinWriteRestrictedCodeSid = WELL_KNOWN_SID_TYPE.WriteRestrictedCodeSid;
pub const WinCreatorOwnerRightsSid = WELL_KNOWN_SID_TYPE.CreatorOwnerRightsSid;
pub const WinCacheablePrincipalsGroupSid = WELL_KNOWN_SID_TYPE.CacheablePrincipalsGroupSid;
pub const WinNonCacheablePrincipalsGroupSid = WELL_KNOWN_SID_TYPE.NonCacheablePrincipalsGroupSid;
pub const WinEnterpriseReadonlyControllersSid = WELL_KNOWN_SID_TYPE.EnterpriseReadonlyControllersSid;
pub const WinAccountReadonlyControllersSid = WELL_KNOWN_SID_TYPE.AccountReadonlyControllersSid;
pub const WinBuiltinEventLogReadersGroup = WELL_KNOWN_SID_TYPE.BuiltinEventLogReadersGroup;
pub const WinNewEnterpriseReadonlyControllersSid = WELL_KNOWN_SID_TYPE.NewEnterpriseReadonlyControllersSid;
pub const WinBuiltinCertSvcDComAccessGroup = WELL_KNOWN_SID_TYPE.BuiltinCertSvcDComAccessGroup;
pub const WinMediumPlusLabelSid = WELL_KNOWN_SID_TYPE.MediumPlusLabelSid;
pub const WinLocalLogonSid = WELL_KNOWN_SID_TYPE.LocalLogonSid;
pub const WinConsoleLogonSid = WELL_KNOWN_SID_TYPE.ConsoleLogonSid;
pub const WinThisOrganizationCertificateSid = WELL_KNOWN_SID_TYPE.ThisOrganizationCertificateSid;
pub const WinApplicationPackageAuthoritySid = WELL_KNOWN_SID_TYPE.ApplicationPackageAuthoritySid;
pub const WinBuiltinAnyPackageSid = WELL_KNOWN_SID_TYPE.BuiltinAnyPackageSid;
pub const WinCapabilityInternetClientSid = WELL_KNOWN_SID_TYPE.CapabilityInternetClientSid;
pub const WinCapabilityInternetClientServerSid = WELL_KNOWN_SID_TYPE.CapabilityInternetClientServerSid;
pub const WinCapabilityPrivateNetworkClientServerSid = WELL_KNOWN_SID_TYPE.CapabilityPrivateNetworkClientServerSid;
pub const WinCapabilityPicturesLibrarySid = WELL_KNOWN_SID_TYPE.CapabilityPicturesLibrarySid;
pub const WinCapabilityVideosLibrarySid = WELL_KNOWN_SID_TYPE.CapabilityVideosLibrarySid;
pub const WinCapabilityMusicLibrarySid = WELL_KNOWN_SID_TYPE.CapabilityMusicLibrarySid;
pub const WinCapabilityDocumentsLibrarySid = WELL_KNOWN_SID_TYPE.CapabilityDocumentsLibrarySid;
pub const WinCapabilitySharedUserCertificatesSid = WELL_KNOWN_SID_TYPE.CapabilitySharedUserCertificatesSid;
pub const WinCapabilityEnterpriseAuthenticationSid = WELL_KNOWN_SID_TYPE.CapabilityEnterpriseAuthenticationSid;
pub const WinCapabilityRemovableStorageSid = WELL_KNOWN_SID_TYPE.CapabilityRemovableStorageSid;
pub const WinBuiltinRDSRemoteAccessServersSid = WELL_KNOWN_SID_TYPE.BuiltinRDSRemoteAccessServersSid;
pub const WinBuiltinRDSEndpointServersSid = WELL_KNOWN_SID_TYPE.BuiltinRDSEndpointServersSid;
pub const WinBuiltinRDSManagementServersSid = WELL_KNOWN_SID_TYPE.BuiltinRDSManagementServersSid;
pub const WinUserModeDriversSid = WELL_KNOWN_SID_TYPE.UserModeDriversSid;
pub const WinBuiltinHyperVAdminsSid = WELL_KNOWN_SID_TYPE.BuiltinHyperVAdminsSid;
pub const WinAccountCloneableControllersSid = WELL_KNOWN_SID_TYPE.AccountCloneableControllersSid;
pub const WinBuiltinAccessControlAssistanceOperatorsSid = WELL_KNOWN_SID_TYPE.BuiltinAccessControlAssistanceOperatorsSid;
pub const WinBuiltinRemoteManagementUsersSid = WELL_KNOWN_SID_TYPE.BuiltinRemoteManagementUsersSid;
pub const WinAuthenticationAuthorityAssertedSid = WELL_KNOWN_SID_TYPE.AuthenticationAuthorityAssertedSid;
pub const WinAuthenticationServiceAssertedSid = WELL_KNOWN_SID_TYPE.AuthenticationServiceAssertedSid;
pub const WinLocalAccountSid = WELL_KNOWN_SID_TYPE.LocalAccountSid;
pub const WinLocalAccountAndAdministratorSid = WELL_KNOWN_SID_TYPE.LocalAccountAndAdministratorSid;
pub const WinAccountProtectedUsersSid = WELL_KNOWN_SID_TYPE.AccountProtectedUsersSid;
pub const WinCapabilityAppointmentsSid = WELL_KNOWN_SID_TYPE.CapabilityAppointmentsSid;
pub const WinCapabilityContactsSid = WELL_KNOWN_SID_TYPE.CapabilityContactsSid;
pub const WinAccountDefaultSystemManagedSid = WELL_KNOWN_SID_TYPE.AccountDefaultSystemManagedSid;
pub const WinBuiltinDefaultSystemManagedGroupSid = WELL_KNOWN_SID_TYPE.BuiltinDefaultSystemManagedGroupSid;
pub const WinBuiltinStorageReplicaAdminsSid = WELL_KNOWN_SID_TYPE.BuiltinStorageReplicaAdminsSid;
pub const WinAccountKeyAdminsSid = WELL_KNOWN_SID_TYPE.AccountKeyAdminsSid;
pub const WinAccountEnterpriseKeyAdminsSid = WELL_KNOWN_SID_TYPE.AccountEnterpriseKeyAdminsSid;
pub const WinAuthenticationKeyTrustSid = WELL_KNOWN_SID_TYPE.AuthenticationKeyTrustSid;
pub const WinAuthenticationKeyPropertyMFASid = WELL_KNOWN_SID_TYPE.AuthenticationKeyPropertyMFASid;
pub const WinAuthenticationKeyPropertyAttestationSid = WELL_KNOWN_SID_TYPE.AuthenticationKeyPropertyAttestationSid;
pub const WinAuthenticationFreshKeyAuthSid = WELL_KNOWN_SID_TYPE.AuthenticationFreshKeyAuthSid;
pub const WinBuiltinDeviceOwnersSid = WELL_KNOWN_SID_TYPE.BuiltinDeviceOwnersSid;

pub const ACL = extern struct {
    AclRevision: u8,
    Sbz1: u8,
    AclSize: u16,
    AceCount: u16,
    Sbz2: u16,
};

pub const ACE_HEADER = extern struct {
    AceType: u8,
    AceFlags: u8,
    AceSize: u16,
};

pub const ACCESS_ALLOWED_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    SidStart: u32,
};

pub const ACCESS_DENIED_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    SidStart: u32,
};

pub const SYSTEM_AUDIT_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    SidStart: u32,
};

pub const SYSTEM_ALARM_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    SidStart: u32,
};

pub const SYSTEM_RESOURCE_ATTRIBUTE_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    SidStart: u32,
};

pub const SYSTEM_SCOPED_POLICY_ID_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    SidStart: u32,
};

pub const SYSTEM_MANDATORY_LABEL_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    SidStart: u32,
};

pub const SYSTEM_PROCESS_TRUST_LABEL_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    SidStart: u32,
};

pub const SYSTEM_ACCESS_FILTER_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    SidStart: u32,
};

pub const ACCESS_ALLOWED_OBJECT_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    Flags: SYSTEM_AUDIT_OBJECT_ACE_FLAGS,
    ObjectType: Guid,
    InheritedObjectType: Guid,
    SidStart: u32,
};

pub const ACCESS_DENIED_OBJECT_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    Flags: SYSTEM_AUDIT_OBJECT_ACE_FLAGS,
    ObjectType: Guid,
    InheritedObjectType: Guid,
    SidStart: u32,
};

pub const SYSTEM_AUDIT_OBJECT_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    Flags: SYSTEM_AUDIT_OBJECT_ACE_FLAGS,
    ObjectType: Guid,
    InheritedObjectType: Guid,
    SidStart: u32,
};

pub const SYSTEM_ALARM_OBJECT_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    Flags: u32,
    ObjectType: Guid,
    InheritedObjectType: Guid,
    SidStart: u32,
};

pub const ACCESS_ALLOWED_CALLBACK_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    SidStart: u32,
};

pub const ACCESS_DENIED_CALLBACK_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    SidStart: u32,
};

pub const SYSTEM_AUDIT_CALLBACK_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    SidStart: u32,
};

pub const SYSTEM_ALARM_CALLBACK_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    SidStart: u32,
};

pub const ACCESS_ALLOWED_CALLBACK_OBJECT_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    Flags: SYSTEM_AUDIT_OBJECT_ACE_FLAGS,
    ObjectType: Guid,
    InheritedObjectType: Guid,
    SidStart: u32,
};

pub const ACCESS_DENIED_CALLBACK_OBJECT_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    Flags: SYSTEM_AUDIT_OBJECT_ACE_FLAGS,
    ObjectType: Guid,
    InheritedObjectType: Guid,
    SidStart: u32,
};

pub const SYSTEM_AUDIT_CALLBACK_OBJECT_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    Flags: SYSTEM_AUDIT_OBJECT_ACE_FLAGS,
    ObjectType: Guid,
    InheritedObjectType: Guid,
    SidStart: u32,
};

pub const SYSTEM_ALARM_CALLBACK_OBJECT_ACE = extern struct {
    Header: ACE_HEADER,
    Mask: u32,
    Flags: SYSTEM_AUDIT_OBJECT_ACE_FLAGS,
    ObjectType: Guid,
    InheritedObjectType: Guid,
    SidStart: u32,
};

pub const ACL_INFORMATION_CLASS = enum(i32) {
    RevisionInformation = 1,
    SizeInformation = 2,
};
pub const AclRevisionInformation = ACL_INFORMATION_CLASS.RevisionInformation;
pub const AclSizeInformation = ACL_INFORMATION_CLASS.SizeInformation;

pub const ACL_REVISION_INFORMATION = extern struct {
    AclRevision: u32,
};

pub const ACL_SIZE_INFORMATION = extern struct {
    AceCount: u32,
    AclBytesInUse: u32,
    AclBytesFree: u32,
};

pub const SECURITY_DESCRIPTOR = extern struct {
    Revision: u8,
    Sbz1: u8,
    Control: u16,
    Owner: ?PSID,
    Group: ?PSID,
    Sacl: ?*ACL,
    Dacl: ?*ACL,
};

pub const OBJECT_TYPE_LIST = extern struct {
    Level: u16,
    Sbz: u16,
    ObjectType: ?*Guid,
};

pub const AUDIT_EVENT_TYPE = enum(i32) {
    ObjectAccess = 0,
    DirectoryServiceAccess = 1,
};
pub const AuditEventObjectAccess = AUDIT_EVENT_TYPE.ObjectAccess;
pub const AuditEventDirectoryServiceAccess = AUDIT_EVENT_TYPE.DirectoryServiceAccess;

pub const PRIVILEGE_SET = extern struct {
    PrivilegeCount: u32,
    Control: u32,
    Privilege: [1]LUID_AND_ATTRIBUTES,
};

pub const ACCESS_REASONS = extern struct {
    Data: [32]u32,
};

pub const SE_SECURITY_DESCRIPTOR = extern struct {
    Size: u32,
    Flags: u32,
    SecurityDescriptor: ?*SECURITY_DESCRIPTOR,
};

pub const SE_ACCESS_REQUEST = extern struct {
    Size: u32,
    SeSecurityDescriptor: ?*SE_SECURITY_DESCRIPTOR,
    DesiredAccess: u32,
    PreviouslyGrantedAccess: u32,
    PrincipalSelfSid: ?PSID,
    GenericMapping: ?*GENERIC_MAPPING,
    ObjectTypeListCount: u32,
    ObjectTypeList: ?*OBJECT_TYPE_LIST,
};

pub const SE_ACCESS_REPLY = extern struct {
    Size: u32,
    ResultListCount: u32,
    GrantedAccess: ?*u32,
    AccessStatus: ?*u32,
    AccessReason: ?*ACCESS_REASONS,
    Privileges: ?*?*PRIVILEGE_SET,
};

pub const SECURITY_IMPERSONATION_LEVEL = enum(i32) {
    Anonymous = 0,
    Identification = 1,
    Impersonation = 2,
    Delegation = 3,
};
pub const SecurityAnonymous = SECURITY_IMPERSONATION_LEVEL.Anonymous;
pub const SecurityIdentification = SECURITY_IMPERSONATION_LEVEL.Identification;
pub const SecurityImpersonation = SECURITY_IMPERSONATION_LEVEL.Impersonation;
pub const SecurityDelegation = SECURITY_IMPERSONATION_LEVEL.Delegation;

pub const TOKEN_TYPE = enum(i32) {
    Primary = 1,
    Impersonation = 2,
};
pub const TokenPrimary = TOKEN_TYPE.Primary;
pub const TokenImpersonation = TOKEN_TYPE.Impersonation;

pub const TOKEN_ELEVATION_TYPE = enum(i32) {
    Default = 1,
    Full = 2,
    Limited = 3,
};
pub const TokenElevationTypeDefault = TOKEN_ELEVATION_TYPE.Default;
pub const TokenElevationTypeFull = TOKEN_ELEVATION_TYPE.Full;
pub const TokenElevationTypeLimited = TOKEN_ELEVATION_TYPE.Limited;

pub const TOKEN_INFORMATION_CLASS = enum(i32) {
    TokenUser = 1,
    TokenGroups = 2,
    TokenPrivileges = 3,
    TokenOwner = 4,
    TokenPrimaryGroup = 5,
    TokenDefaultDacl = 6,
    TokenSource = 7,
    TokenType = 8,
    TokenImpersonationLevel = 9,
    TokenStatistics = 10,
    TokenRestrictedSids = 11,
    TokenSessionId = 12,
    TokenGroupsAndPrivileges = 13,
    TokenSessionReference = 14,
    TokenSandBoxInert = 15,
    TokenAuditPolicy = 16,
    TokenOrigin = 17,
    TokenElevationType = 18,
    TokenLinkedToken = 19,
    TokenElevation = 20,
    TokenHasRestrictions = 21,
    TokenAccessInformation = 22,
    TokenVirtualizationAllowed = 23,
    TokenVirtualizationEnabled = 24,
    TokenIntegrityLevel = 25,
    TokenUIAccess = 26,
    TokenMandatoryPolicy = 27,
    TokenLogonSid = 28,
    TokenIsAppContainer = 29,
    TokenCapabilities = 30,
    TokenAppContainerSid = 31,
    TokenAppContainerNumber = 32,
    TokenUserClaimAttributes = 33,
    TokenDeviceClaimAttributes = 34,
    TokenRestrictedUserClaimAttributes = 35,
    TokenRestrictedDeviceClaimAttributes = 36,
    TokenDeviceGroups = 37,
    TokenRestrictedDeviceGroups = 38,
    TokenSecurityAttributes = 39,
    TokenIsRestricted = 40,
    TokenProcessTrustLevel = 41,
    TokenPrivateNameSpace = 42,
    TokenSingletonAttributes = 43,
    TokenBnoIsolation = 44,
    TokenChildProcessFlags = 45,
    TokenIsLessPrivilegedAppContainer = 46,
    TokenIsSandboxed = 47,
    MaxTokenInfoClass = 48,
};
pub const TokenUser = TOKEN_INFORMATION_CLASS.TokenUser;
pub const TokenGroups = TOKEN_INFORMATION_CLASS.TokenGroups;
pub const TokenPrivileges = TOKEN_INFORMATION_CLASS.TokenPrivileges;
pub const TokenOwner = TOKEN_INFORMATION_CLASS.TokenOwner;
pub const TokenPrimaryGroup = TOKEN_INFORMATION_CLASS.TokenPrimaryGroup;
pub const TokenDefaultDacl = TOKEN_INFORMATION_CLASS.TokenDefaultDacl;
pub const TokenSource = TOKEN_INFORMATION_CLASS.TokenSource;
pub const TokenType = TOKEN_INFORMATION_CLASS.TokenType;
pub const TokenImpersonationLevel = TOKEN_INFORMATION_CLASS.TokenImpersonationLevel;
pub const TokenStatistics = TOKEN_INFORMATION_CLASS.TokenStatistics;
pub const TokenRestrictedSids = TOKEN_INFORMATION_CLASS.TokenRestrictedSids;
pub const TokenSessionId = TOKEN_INFORMATION_CLASS.TokenSessionId;
pub const TokenGroupsAndPrivileges = TOKEN_INFORMATION_CLASS.TokenGroupsAndPrivileges;
pub const TokenSessionReference = TOKEN_INFORMATION_CLASS.TokenSessionReference;
pub const TokenSandBoxInert = TOKEN_INFORMATION_CLASS.TokenSandBoxInert;
pub const TokenAuditPolicy = TOKEN_INFORMATION_CLASS.TokenAuditPolicy;
pub const TokenOrigin = TOKEN_INFORMATION_CLASS.TokenOrigin;
pub const TokenElevationType = TOKEN_INFORMATION_CLASS.TokenElevationType;
pub const TokenLinkedToken = TOKEN_INFORMATION_CLASS.TokenLinkedToken;
pub const TokenElevation = TOKEN_INFORMATION_CLASS.TokenElevation;
pub const TokenHasRestrictions = TOKEN_INFORMATION_CLASS.TokenHasRestrictions;
pub const TokenAccessInformation = TOKEN_INFORMATION_CLASS.TokenAccessInformation;
pub const TokenVirtualizationAllowed = TOKEN_INFORMATION_CLASS.TokenVirtualizationAllowed;
pub const TokenVirtualizationEnabled = TOKEN_INFORMATION_CLASS.TokenVirtualizationEnabled;
pub const TokenIntegrityLevel = TOKEN_INFORMATION_CLASS.TokenIntegrityLevel;
pub const TokenUIAccess = TOKEN_INFORMATION_CLASS.TokenUIAccess;
pub const TokenMandatoryPolicy = TOKEN_INFORMATION_CLASS.TokenMandatoryPolicy;
pub const TokenLogonSid = TOKEN_INFORMATION_CLASS.TokenLogonSid;
pub const TokenIsAppContainer = TOKEN_INFORMATION_CLASS.TokenIsAppContainer;
pub const TokenCapabilities = TOKEN_INFORMATION_CLASS.TokenCapabilities;
pub const TokenAppContainerSid = TOKEN_INFORMATION_CLASS.TokenAppContainerSid;
pub const TokenAppContainerNumber = TOKEN_INFORMATION_CLASS.TokenAppContainerNumber;
pub const TokenUserClaimAttributes = TOKEN_INFORMATION_CLASS.TokenUserClaimAttributes;
pub const TokenDeviceClaimAttributes = TOKEN_INFORMATION_CLASS.TokenDeviceClaimAttributes;
pub const TokenRestrictedUserClaimAttributes = TOKEN_INFORMATION_CLASS.TokenRestrictedUserClaimAttributes;
pub const TokenRestrictedDeviceClaimAttributes = TOKEN_INFORMATION_CLASS.TokenRestrictedDeviceClaimAttributes;
pub const TokenDeviceGroups = TOKEN_INFORMATION_CLASS.TokenDeviceGroups;
pub const TokenRestrictedDeviceGroups = TOKEN_INFORMATION_CLASS.TokenRestrictedDeviceGroups;
pub const TokenSecurityAttributes = TOKEN_INFORMATION_CLASS.TokenSecurityAttributes;
pub const TokenIsRestricted = TOKEN_INFORMATION_CLASS.TokenIsRestricted;
pub const TokenProcessTrustLevel = TOKEN_INFORMATION_CLASS.TokenProcessTrustLevel;
pub const TokenPrivateNameSpace = TOKEN_INFORMATION_CLASS.TokenPrivateNameSpace;
pub const TokenSingletonAttributes = TOKEN_INFORMATION_CLASS.TokenSingletonAttributes;
pub const TokenBnoIsolation = TOKEN_INFORMATION_CLASS.TokenBnoIsolation;
pub const TokenChildProcessFlags = TOKEN_INFORMATION_CLASS.TokenChildProcessFlags;
pub const TokenIsLessPrivilegedAppContainer = TOKEN_INFORMATION_CLASS.TokenIsLessPrivilegedAppContainer;
pub const TokenIsSandboxed = TOKEN_INFORMATION_CLASS.TokenIsSandboxed;
pub const MaxTokenInfoClass = TOKEN_INFORMATION_CLASS.MaxTokenInfoClass;

pub const TOKEN_USER = extern struct {
    User: SID_AND_ATTRIBUTES,
};

pub const TOKEN_GROUPS = extern struct {
    GroupCount: u32,
    Groups: [1]SID_AND_ATTRIBUTES,
};

pub const TOKEN_PRIVILEGES = extern struct {
    PrivilegeCount: u32,
    Privileges: [1]LUID_AND_ATTRIBUTES,
};

pub const TOKEN_OWNER = extern struct {
    Owner: ?PSID,
};

pub const TOKEN_PRIMARY_GROUP = extern struct {
    PrimaryGroup: ?PSID,
};

pub const TOKEN_DEFAULT_DACL = extern struct {
    DefaultDacl: ?*ACL,
};

pub const TOKEN_USER_CLAIMS = extern struct {
    UserClaims: ?*anyopaque,
};

pub const TOKEN_DEVICE_CLAIMS = extern struct {
    DeviceClaims: ?*anyopaque,
};

pub const TOKEN_GROUPS_AND_PRIVILEGES = extern struct {
    SidCount: u32,
    SidLength: u32,
    Sids: ?*SID_AND_ATTRIBUTES,
    RestrictedSidCount: u32,
    RestrictedSidLength: u32,
    RestrictedSids: ?*SID_AND_ATTRIBUTES,
    PrivilegeCount: u32,
    PrivilegeLength: u32,
    Privileges: ?*LUID_AND_ATTRIBUTES,
    AuthenticationId: LUID,
};

pub const TOKEN_LINKED_TOKEN = extern struct {
    LinkedToken: ?HANDLE,
};

pub const TOKEN_ELEVATION = extern struct {
    TokenIsElevated: u32,
};

pub const TOKEN_MANDATORY_LABEL = extern struct {
    Label: SID_AND_ATTRIBUTES,
};

pub const TOKEN_MANDATORY_POLICY = extern struct {
    Policy: TOKEN_MANDATORY_POLICY_ID,
};

pub const TOKEN_ACCESS_INFORMATION = extern struct {
    SidHash: ?*SID_AND_ATTRIBUTES_HASH,
    RestrictedSidHash: ?*SID_AND_ATTRIBUTES_HASH,
    Privileges: ?*TOKEN_PRIVILEGES,
    AuthenticationId: LUID,
    TokenType: TOKEN_TYPE,
    ImpersonationLevel: SECURITY_IMPERSONATION_LEVEL,
    MandatoryPolicy: TOKEN_MANDATORY_POLICY,
    Flags: u32,
    AppContainerNumber: u32,
    PackageSid: ?PSID,
    CapabilitiesHash: ?*SID_AND_ATTRIBUTES_HASH,
    TrustLevelSid: ?PSID,
    SecurityAttributes: ?*anyopaque,
};

pub const TOKEN_AUDIT_POLICY = extern struct {
    PerUserPolicy: [30]u8,
};

pub const TOKEN_SOURCE = extern struct {
    SourceName: [8]CHAR,
    SourceIdentifier: LUID,
};

pub const TOKEN_STATISTICS = extern struct {
    TokenId: LUID,
    AuthenticationId: LUID,
    ExpirationTime: LARGE_INTEGER,
    TokenType: TOKEN_TYPE,
    ImpersonationLevel: SECURITY_IMPERSONATION_LEVEL,
    DynamicCharged: u32,
    DynamicAvailable: u32,
    GroupCount: u32,
    PrivilegeCount: u32,
    ModifiedId: LUID,
};

pub const TOKEN_CONTROL = extern struct {
    TokenId: LUID,
    AuthenticationId: LUID,
    ModifiedId: LUID,
    TokenSource: TOKEN_SOURCE,
};

pub const TOKEN_ORIGIN = extern struct {
    OriginatingLogonSession: LUID,
};

pub const MANDATORY_LEVEL = enum(i32) {
    Untrusted = 0,
    Low = 1,
    Medium = 2,
    High = 3,
    System = 4,
    SecureProcess = 5,
    Count = 6,
};
pub const MandatoryLevelUntrusted = MANDATORY_LEVEL.Untrusted;
pub const MandatoryLevelLow = MANDATORY_LEVEL.Low;
pub const MandatoryLevelMedium = MANDATORY_LEVEL.Medium;
pub const MandatoryLevelHigh = MANDATORY_LEVEL.High;
pub const MandatoryLevelSystem = MANDATORY_LEVEL.System;
pub const MandatoryLevelSecureProcess = MANDATORY_LEVEL.SecureProcess;
pub const MandatoryLevelCount = MANDATORY_LEVEL.Count;

pub const TOKEN_APPCONTAINER_INFORMATION = extern struct {
    TokenAppContainer: ?PSID,
};

pub const CLAIM_SECURITY_ATTRIBUTE_FQBN_VALUE = extern struct {
    Version: u64,
    Name: ?PWSTR,
};

pub const CLAIM_SECURITY_ATTRIBUTE_OCTET_STRING_VALUE = extern struct {
    pValue: ?*anyopaque,
    ValueLength: u32,
};

pub const CLAIM_SECURITY_ATTRIBUTE_V1 = extern struct {
    Name: ?PWSTR,
    ValueType: CLAIM_SECURITY_ATTRIBUTE_VALUE_TYPE,
    Reserved: u16,
    Flags: u32,
    ValueCount: u32,
    Values: extern union {
        pInt64: ?*i64,
        pUint64: ?*u64,
        ppString: ?*?PWSTR,
        pFqbn: ?*CLAIM_SECURITY_ATTRIBUTE_FQBN_VALUE,
        pOctetString: ?*CLAIM_SECURITY_ATTRIBUTE_OCTET_STRING_VALUE,
    },
};

pub const CLAIM_SECURITY_ATTRIBUTE_RELATIVE_V1 = extern struct {
    Name: u32,
    ValueType: CLAIM_SECURITY_ATTRIBUTE_VALUE_TYPE,
    Reserved: u16,
    Flags: CLAIM_SECURITY_ATTRIBUTE_FLAGS,
    ValueCount: u32,
    Values: extern union {
        pInt64: [1]u32,
        pUint64: [1]u32,
        ppString: [1]u32,
        pFqbn: [1]u32,
        pOctetString: [1]u32,
    },
};

pub const CLAIM_SECURITY_ATTRIBUTES_INFORMATION = extern struct {
    Version: u16,
    Reserved: u16,
    AttributeCount: u32,
    Attribute: extern union {
        pAttributeV1: ?*CLAIM_SECURITY_ATTRIBUTE_V1,
    },
};

pub const SECURITY_QUALITY_OF_SERVICE = extern struct {
    Length: u32,
    ImpersonationLevel: SECURITY_IMPERSONATION_LEVEL,
    ContextTrackingMode: u8,
    EffectiveOnly: BOOLEAN,
};

pub const SE_IMPERSONATION_STATE = extern struct {
    Token: ?*anyopaque,
    CopyOnOpen: BOOLEAN,
    EffectiveOnly: BOOLEAN,
    Level: SECURITY_IMPERSONATION_LEVEL,
};

pub const SECURITY_CAPABILITIES = extern struct {
    AppContainerSid: ?PSID,
    Capabilities: ?*SID_AND_ATTRIBUTES,
    CapabilityCount: u32,
    Reserved: u32,
};

pub const QUOTA_LIMITS = extern struct {
    PagedPoolLimit: usize,
    NonPagedPoolLimit: usize,
    MinimumWorkingSetSize: usize,
    MaximumWorkingSetSize: usize,
    PagefileLimit: usize,
    TimeLimit: LARGE_INTEGER,
};

//--------------------------------------------------------------------------------
// Section: Functions (133)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AccessCheck(
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    ClientToken: ?HANDLE,
    DesiredAccess: u32,
    GenericMapping: ?*GENERIC_MAPPING,
    // TODO: what to do with BytesParamIndex 5?
    PrivilegeSet: ?*PRIVILEGE_SET,
    PrivilegeSetLength: ?*u32,
    GrantedAccess: ?*u32,
    AccessStatus: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "advapi32" fn AccessCheckAndAuditAlarmW(
    SubsystemName: ?[*:0]const u16,
    HandleId: ?*anyopaque,
    ObjectTypeName: ?PWSTR,
    ObjectName: ?PWSTR,
    SecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    DesiredAccess: u32,
    GenericMapping: ?*GENERIC_MAPPING,
    ObjectCreation: BOOL,
    GrantedAccess: ?*u32,
    AccessStatus: ?*i32,
    pfGenerateOnClose: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AccessCheckByType(
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    PrincipalSelfSid: ?PSID,
    ClientToken: ?HANDLE,
    DesiredAccess: u32,
    ObjectTypeList: ?[*]OBJECT_TYPE_LIST,
    ObjectTypeListLength: u32,
    GenericMapping: ?*GENERIC_MAPPING,
    // TODO: what to do with BytesParamIndex 8?
    PrivilegeSet: ?*PRIVILEGE_SET,
    PrivilegeSetLength: ?*u32,
    GrantedAccess: ?*u32,
    AccessStatus: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AccessCheckByTypeResultList(
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    PrincipalSelfSid: ?PSID,
    ClientToken: ?HANDLE,
    DesiredAccess: u32,
    ObjectTypeList: ?[*]OBJECT_TYPE_LIST,
    ObjectTypeListLength: u32,
    GenericMapping: ?*GENERIC_MAPPING,
    // TODO: what to do with BytesParamIndex 8?
    PrivilegeSet: ?*PRIVILEGE_SET,
    PrivilegeSetLength: ?*u32,
    GrantedAccessList: [*]u32,
    AccessStatusList: [*]u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "advapi32" fn AccessCheckByTypeAndAuditAlarmW(
    SubsystemName: ?[*:0]const u16,
    HandleId: ?*anyopaque,
    ObjectTypeName: ?[*:0]const u16,
    ObjectName: ?[*:0]const u16,
    SecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    PrincipalSelfSid: ?PSID,
    DesiredAccess: u32,
    AuditType: AUDIT_EVENT_TYPE,
    Flags: u32,
    ObjectTypeList: ?[*]OBJECT_TYPE_LIST,
    ObjectTypeListLength: u32,
    GenericMapping: ?*GENERIC_MAPPING,
    ObjectCreation: BOOL,
    GrantedAccess: ?*u32,
    AccessStatus: ?*i32,
    pfGenerateOnClose: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "advapi32" fn AccessCheckByTypeResultListAndAuditAlarmW(
    SubsystemName: ?[*:0]const u16,
    HandleId: ?*anyopaque,
    ObjectTypeName: ?[*:0]const u16,
    ObjectName: ?[*:0]const u16,
    SecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    PrincipalSelfSid: ?PSID,
    DesiredAccess: u32,
    AuditType: AUDIT_EVENT_TYPE,
    Flags: u32,
    ObjectTypeList: ?[*]OBJECT_TYPE_LIST,
    ObjectTypeListLength: u32,
    GenericMapping: ?*GENERIC_MAPPING,
    ObjectCreation: BOOL,
    GrantedAccessList: [*]u32,
    AccessStatusList: [*]u32,
    pfGenerateOnClose: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "advapi32" fn AccessCheckByTypeResultListAndAuditAlarmByHandleW(
    SubsystemName: ?[*:0]const u16,
    HandleId: ?*anyopaque,
    ClientToken: ?HANDLE,
    ObjectTypeName: ?[*:0]const u16,
    ObjectName: ?[*:0]const u16,
    SecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    PrincipalSelfSid: ?PSID,
    DesiredAccess: u32,
    AuditType: AUDIT_EVENT_TYPE,
    Flags: u32,
    ObjectTypeList: ?[*]OBJECT_TYPE_LIST,
    ObjectTypeListLength: u32,
    GenericMapping: ?*GENERIC_MAPPING,
    ObjectCreation: BOOL,
    GrantedAccessList: [*]u32,
    AccessStatusList: [*]u32,
    pfGenerateOnClose: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AddAccessAllowedAce(
    pAcl: ?*ACL,
    dwAceRevision: u32,
    AccessMask: u32,
    pSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AddAccessAllowedAceEx(
    pAcl: ?*ACL,
    dwAceRevision: u32,
    AceFlags: ACE_FLAGS,
    AccessMask: u32,
    pSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AddAccessAllowedObjectAce(
    pAcl: ?*ACL,
    dwAceRevision: u32,
    AceFlags: ACE_FLAGS,
    AccessMask: u32,
    ObjectTypeGuid: ?*Guid,
    InheritedObjectTypeGuid: ?*Guid,
    pSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AddAccessDeniedAce(
    pAcl: ?*ACL,
    dwAceRevision: u32,
    AccessMask: u32,
    pSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AddAccessDeniedAceEx(
    pAcl: ?*ACL,
    dwAceRevision: u32,
    AceFlags: ACE_FLAGS,
    AccessMask: u32,
    pSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AddAccessDeniedObjectAce(
    pAcl: ?*ACL,
    dwAceRevision: u32,
    AceFlags: ACE_FLAGS,
    AccessMask: u32,
    ObjectTypeGuid: ?*Guid,
    InheritedObjectTypeGuid: ?*Guid,
    pSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AddAce(
    pAcl: ?*ACL,
    dwAceRevision: u32,
    dwStartingAceIndex: u32,
    // TODO: what to do with BytesParamIndex 4?
    pAceList: ?*anyopaque,
    nAceListLength: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AddAuditAccessAce(
    pAcl: ?*ACL,
    dwAceRevision: u32,
    dwAccessMask: u32,
    pSid: ?PSID,
    bAuditSuccess: BOOL,
    bAuditFailure: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AddAuditAccessAceEx(
    pAcl: ?*ACL,
    dwAceRevision: u32,
    AceFlags: ACE_FLAGS,
    dwAccessMask: u32,
    pSid: ?PSID,
    bAuditSuccess: BOOL,
    bAuditFailure: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AddAuditAccessObjectAce(
    pAcl: ?*ACL,
    dwAceRevision: u32,
    AceFlags: ACE_FLAGS,
    AccessMask: u32,
    ObjectTypeGuid: ?*Guid,
    InheritedObjectTypeGuid: ?*Guid,
    pSid: ?PSID,
    bAuditSuccess: BOOL,
    bAuditFailure: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn AddMandatoryAce(
    pAcl: ?*ACL,
    dwAceRevision: ACE_REVISION,
    AceFlags: ACE_FLAGS,
    MandatoryPolicy: u32,
    pLabelSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn AddResourceAttributeAce(
    pAcl: ?*ACL,
    dwAceRevision: u32,
    AceFlags: ACE_FLAGS,
    AccessMask: u32,
    pSid: ?PSID,
    pAttributeInfo: ?*CLAIM_SECURITY_ATTRIBUTES_INFORMATION,
    pReturnLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn AddScopedPolicyIDAce(
    pAcl: ?*ACL,
    dwAceRevision: u32,
    AceFlags: ACE_FLAGS,
    AccessMask: u32,
    pSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AdjustTokenGroups(
    TokenHandle: ?HANDLE,
    ResetToDefault: BOOL,
    NewState: ?*TOKEN_GROUPS,
    BufferLength: u32,
    // TODO: what to do with BytesParamIndex 3?
    PreviousState: ?*TOKEN_GROUPS,
    ReturnLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AdjustTokenPrivileges(
    TokenHandle: ?HANDLE,
    DisableAllPrivileges: BOOL,
    NewState: ?*TOKEN_PRIVILEGES,
    BufferLength: u32,
    // TODO: what to do with BytesParamIndex 3?
    PreviousState: ?*TOKEN_PRIVILEGES,
    ReturnLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AllocateAndInitializeSid(
    pIdentifierAuthority: ?*SID_IDENTIFIER_AUTHORITY,
    nSubAuthorityCount: u8,
    nSubAuthority0: u32,
    nSubAuthority1: u32,
    nSubAuthority2: u32,
    nSubAuthority3: u32,
    nSubAuthority4: u32,
    nSubAuthority5: u32,
    nSubAuthority6: u32,
    nSubAuthority7: u32,
    pSid: ?*?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AllocateLocallyUniqueId(
    Luid: ?*LUID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AreAllAccessesGranted(
    GrantedAccess: u32,
    DesiredAccess: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AreAnyAccessesGranted(
    GrantedAccess: u32,
    DesiredAccess: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CheckTokenMembership(
    TokenHandle: ?HANDLE,
    SidToCheck: ?PSID,
    IsMember: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn CheckTokenCapability(
    TokenHandle: ?HANDLE,
    CapabilitySidToCheck: ?PSID,
    HasCapability: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn GetAppContainerAce(
    Acl: ?*ACL,
    StartingAceIndex: u32,
    AppContainerAce: ?*?*anyopaque,
    AppContainerAceIndex: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "kernel32" fn CheckTokenMembershipEx(
    TokenHandle: ?HANDLE,
    SidToCheck: ?PSID,
    Flags: u32,
    IsMember: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ConvertToAutoInheritPrivateObjectSecurity(
    ParentDescriptor: ?*SECURITY_DESCRIPTOR,
    CurrentSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    NewSecurityDescriptor: ?*?*SECURITY_DESCRIPTOR,
    ObjectType: ?*Guid,
    IsDirectoryObject: BOOLEAN,
    GenericMapping: ?*GENERIC_MAPPING,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CopySid(
    nDestinationSidLength: u32,
    // TODO: what to do with BytesParamIndex 0?
    pDestinationSid: ?PSID,
    pSourceSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CreatePrivateObjectSecurity(
    ParentDescriptor: ?*SECURITY_DESCRIPTOR,
    CreatorDescriptor: ?*SECURITY_DESCRIPTOR,
    NewDescriptor: ?*?*SECURITY_DESCRIPTOR,
    IsDirectoryObject: BOOL,
    Token: ?HANDLE,
    GenericMapping: ?*GENERIC_MAPPING,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CreatePrivateObjectSecurityEx(
    ParentDescriptor: ?*SECURITY_DESCRIPTOR,
    CreatorDescriptor: ?*SECURITY_DESCRIPTOR,
    NewDescriptor: ?*?*SECURITY_DESCRIPTOR,
    ObjectType: ?*Guid,
    IsContainerObject: BOOL,
    AutoInheritFlags: SECURITY_AUTO_INHERIT_FLAGS,
    Token: ?HANDLE,
    GenericMapping: ?*GENERIC_MAPPING,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CreatePrivateObjectSecurityWithMultipleInheritance(
    ParentDescriptor: ?*SECURITY_DESCRIPTOR,
    CreatorDescriptor: ?*SECURITY_DESCRIPTOR,
    NewDescriptor: ?*?*SECURITY_DESCRIPTOR,
    ObjectTypes: ?[*]?*Guid,
    GuidCount: u32,
    IsContainerObject: BOOL,
    AutoInheritFlags: SECURITY_AUTO_INHERIT_FLAGS,
    Token: ?HANDLE,
    GenericMapping: ?*GENERIC_MAPPING,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CreateRestrictedToken(
    ExistingTokenHandle: ?HANDLE,
    Flags: CREATE_RESTRICTED_TOKEN_FLAGS,
    DisableSidCount: u32,
    SidsToDisable: ?[*]SID_AND_ATTRIBUTES,
    DeletePrivilegeCount: u32,
    PrivilegesToDelete: ?[*]LUID_AND_ATTRIBUTES,
    RestrictedSidCount: u32,
    SidsToRestrict: ?[*]SID_AND_ATTRIBUTES,
    NewTokenHandle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn CreateWellKnownSid(
    WellKnownSidType: WELL_KNOWN_SID_TYPE,
    DomainSid: ?PSID,
    // TODO: what to do with BytesParamIndex 3?
    pSid: ?PSID,
    cbSid: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn EqualDomainSid(
    pSid1: ?PSID,
    pSid2: ?PSID,
    pfEqual: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn DeleteAce(
    pAcl: ?*ACL,
    dwAceIndex: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn DestroyPrivateObjectSecurity(
    ObjectDescriptor: ?*?*SECURITY_DESCRIPTOR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn DuplicateToken(
    ExistingTokenHandle: ?HANDLE,
    ImpersonationLevel: SECURITY_IMPERSONATION_LEVEL,
    DuplicateTokenHandle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn DuplicateTokenEx(
    hExistingToken: ?HANDLE,
    dwDesiredAccess: TOKEN_ACCESS_MASK,
    lpTokenAttributes: ?*SECURITY_ATTRIBUTES,
    ImpersonationLevel: SECURITY_IMPERSONATION_LEVEL,
    TokenType: TOKEN_TYPE,
    phNewToken: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn EqualPrefixSid(
    pSid1: ?PSID,
    pSid2: ?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn EqualSid(
    pSid1: ?PSID,
    pSid2: ?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn FindFirstFreeAce(
    pAcl: ?*ACL,
    pAce: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn FreeSid(
    pSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetAce(
    pAcl: ?*ACL,
    dwAceIndex: u32,
    pAce: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetAclInformation(
    pAcl: ?*ACL,
    // TODO: what to do with BytesParamIndex 2?
    pAclInformation: ?*anyopaque,
    nAclInformationLength: u32,
    dwAclInformationClass: ACL_INFORMATION_CLASS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "advapi32" fn GetFileSecurityW(
    lpFileName: ?[*:0]const u16,
    RequestedInformation: u32,
    // TODO: what to do with BytesParamIndex 3?
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    nLength: u32,
    lpnLengthNeeded: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetKernelObjectSecurity(
    Handle: ?HANDLE,
    RequestedInformation: u32,
    // TODO: what to do with BytesParamIndex 3?
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    nLength: u32,
    lpnLengthNeeded: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetLengthSid(
    pSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetPrivateObjectSecurity(
    ObjectDescriptor: ?*SECURITY_DESCRIPTOR,
    SecurityInformation: u32,
    // TODO: what to do with BytesParamIndex 3?
    ResultantDescriptor: ?*SECURITY_DESCRIPTOR,
    DescriptorLength: u32,
    ReturnLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetSecurityDescriptorControl(
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    pControl: ?*u16,
    lpdwRevision: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetSecurityDescriptorDacl(
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    lpbDaclPresent: ?*i32,
    pDacl: ?*?*ACL,
    lpbDaclDefaulted: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetSecurityDescriptorGroup(
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    pGroup: ?*?PSID,
    lpbGroupDefaulted: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetSecurityDescriptorLength(
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetSecurityDescriptorOwner(
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    pOwner: ?*?PSID,
    lpbOwnerDefaulted: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetSecurityDescriptorRMControl(
    SecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    RMControl: ?*u8,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetSecurityDescriptorSacl(
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    lpbSaclPresent: ?*i32,
    pSacl: ?*?*ACL,
    lpbSaclDefaulted: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetSidIdentifierAuthority(
    pSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) ?*SID_IDENTIFIER_AUTHORITY;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetSidLengthRequired(
    nSubAuthorityCount: u8,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetSidSubAuthority(
    pSid: ?PSID,
    nSubAuthority: u32,
) callconv(@import("std").os.windows.WINAPI) ?*u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetSidSubAuthorityCount(
    pSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) ?*u8;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetTokenInformation(
    TokenHandle: ?HANDLE,
    TokenInformationClass: TOKEN_INFORMATION_CLASS,
    // TODO: what to do with BytesParamIndex 3?
    TokenInformation: ?*anyopaque,
    TokenInformationLength: u32,
    ReturnLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetWindowsAccountDomainSid(
    pSid: ?PSID,
    // TODO: what to do with BytesParamIndex 2?
    pDomainSid: ?PSID,
    cbDomainSid: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ImpersonateAnonymousToken(
    ThreadHandle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ImpersonateLoggedOnUser(
    hToken: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ImpersonateSelf(
    ImpersonationLevel: SECURITY_IMPERSONATION_LEVEL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn InitializeAcl(
    // TODO: what to do with BytesParamIndex 1?
    pAcl: ?*ACL,
    nAclLength: u32,
    dwAclRevision: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn InitializeSecurityDescriptor(
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    dwRevision: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn InitializeSid(
    Sid: ?PSID,
    pIdentifierAuthority: ?*SID_IDENTIFIER_AUTHORITY,
    nSubAuthorityCount: u8,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn IsTokenRestricted(
    TokenHandle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn IsValidAcl(
    pAcl: ?*ACL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn IsValidSecurityDescriptor(
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn IsValidSid(
    pSid: ?PSID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn IsWellKnownSid(
    pSid: ?PSID,
    WellKnownSidType: WELL_KNOWN_SID_TYPE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn MakeAbsoluteSD(
    pSelfRelativeSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    // TODO: what to do with BytesParamIndex 2?
    pAbsoluteSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    lpdwAbsoluteSecurityDescriptorSize: ?*u32,
    // TODO: what to do with BytesParamIndex 4?
    pDacl: ?*ACL,
    lpdwDaclSize: ?*u32,
    // TODO: what to do with BytesParamIndex 6?
    pSacl: ?*ACL,
    lpdwSaclSize: ?*u32,
    // TODO: what to do with BytesParamIndex 8?
    pOwner: ?PSID,
    lpdwOwnerSize: ?*u32,
    // TODO: what to do with BytesParamIndex 10?
    pPrimaryGroup: ?PSID,
    lpdwPrimaryGroupSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn MakeSelfRelativeSD(
    pAbsoluteSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    // TODO: what to do with BytesParamIndex 2?
    pSelfRelativeSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    lpdwBufferLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn MapGenericMask(
    AccessMask: ?*u32,
    GenericMapping: ?*GENERIC_MAPPING,
) callconv(@import("std").os.windows.WINAPI) void;

pub extern "advapi32" fn ObjectCloseAuditAlarmW(
    SubsystemName: ?[*:0]const u16,
    HandleId: ?*anyopaque,
    GenerateOnClose: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "advapi32" fn ObjectDeleteAuditAlarmW(
    SubsystemName: ?[*:0]const u16,
    HandleId: ?*anyopaque,
    GenerateOnClose: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "advapi32" fn ObjectOpenAuditAlarmW(
    SubsystemName: ?[*:0]const u16,
    HandleId: ?*anyopaque,
    ObjectTypeName: ?PWSTR,
    ObjectName: ?PWSTR,
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    ClientToken: ?HANDLE,
    DesiredAccess: u32,
    GrantedAccess: u32,
    Privileges: ?*PRIVILEGE_SET,
    ObjectCreation: BOOL,
    AccessGranted: BOOL,
    GenerateOnClose: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "advapi32" fn ObjectPrivilegeAuditAlarmW(
    SubsystemName: ?[*:0]const u16,
    HandleId: ?*anyopaque,
    ClientToken: ?HANDLE,
    DesiredAccess: u32,
    Privileges: ?*PRIVILEGE_SET,
    AccessGranted: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn PrivilegeCheck(
    ClientToken: ?HANDLE,
    RequiredPrivileges: ?*PRIVILEGE_SET,
    pfResult: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "advapi32" fn PrivilegedServiceAuditAlarmW(
    SubsystemName: ?[*:0]const u16,
    ServiceName: ?[*:0]const u16,
    ClientToken: ?HANDLE,
    Privileges: ?*PRIVILEGE_SET,
    AccessGranted: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn QuerySecurityAccessMask(
    SecurityInformation: u32,
    DesiredAccess: ?*u32,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn RevertToSelf() callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetAclInformation(
    pAcl: ?*ACL,
    // TODO: what to do with BytesParamIndex 2?
    pAclInformation: ?*anyopaque,
    nAclInformationLength: u32,
    dwAclInformationClass: ACL_INFORMATION_CLASS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "advapi32" fn SetFileSecurityW(
    lpFileName: ?[*:0]const u16,
    SecurityInformation: u32,
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetKernelObjectSecurity(
    Handle: ?HANDLE,
    SecurityInformation: u32,
    SecurityDescriptor: ?*SECURITY_DESCRIPTOR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetPrivateObjectSecurity(
    SecurityInformation: u32,
    ModificationDescriptor: ?*SECURITY_DESCRIPTOR,
    ObjectsSecurityDescriptor: ?*?*SECURITY_DESCRIPTOR,
    GenericMapping: ?*GENERIC_MAPPING,
    Token: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetPrivateObjectSecurityEx(
    SecurityInformation: u32,
    ModificationDescriptor: ?*SECURITY_DESCRIPTOR,
    ObjectsSecurityDescriptor: ?*?*SECURITY_DESCRIPTOR,
    AutoInheritFlags: SECURITY_AUTO_INHERIT_FLAGS,
    GenericMapping: ?*GENERIC_MAPPING,
    Token: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "advapi32" fn SetSecurityAccessMask(
    SecurityInformation: u32,
    DesiredAccess: ?*u32,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetSecurityDescriptorControl(
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    ControlBitsOfInterest: u16,
    ControlBitsToSet: u16,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetSecurityDescriptorDacl(
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    bDaclPresent: BOOL,
    pDacl: ?*ACL,
    bDaclDefaulted: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetSecurityDescriptorGroup(
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    pGroup: ?PSID,
    bGroupDefaulted: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetSecurityDescriptorOwner(
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    pOwner: ?PSID,
    bOwnerDefaulted: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetSecurityDescriptorRMControl(
    SecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    RMControl: ?*u8,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetSecurityDescriptorSacl(
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    bSaclPresent: BOOL,
    pSacl: ?*ACL,
    bSaclDefaulted: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetTokenInformation(
    TokenHandle: ?HANDLE,
    TokenInformationClass: TOKEN_INFORMATION_CLASS,
    // TODO: what to do with BytesParamIndex 3?
    TokenInformation: ?*anyopaque,
    TokenInformationLength: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn SetCachedSigningLevel(
    SourceFiles: [*]?HANDLE,
    SourceFileCount: u32,
    Flags: u32,
    TargetFile: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "kernel32" fn GetCachedSigningLevel(
    File: ?HANDLE,
    Flags: ?*u32,
    SigningLevel: ?*u32,
    // TODO: what to do with BytesParamIndex 4?
    Thumbprint: ?*u8,
    ThumbprintSize: ?*u32,
    ThumbprintAlgorithm: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "api-ms-win-security-base-l1-2-2" fn DeriveCapabilitySidsFromName(
    CapName: ?[*:0]const u16,
    CapabilityGroupSids: ?*?*?PSID,
    CapabilityGroupSidCount: ?*u32,
    CapabilitySids: ?*?*?PSID,
    CapabilitySidCount: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "ntdll" fn RtlNormalizeSecurityDescriptor(
    SecurityDescriptor: ?*?*SECURITY_DESCRIPTOR,
    SecurityDescriptorLength: u32,
    NewSecurityDescriptor: ?*?*SECURITY_DESCRIPTOR,
    NewSecurityDescriptorLength: ?*u32,
    CheckOnly: BOOLEAN,
) callconv(@import("std").os.windows.WINAPI) BOOLEAN;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "user32" fn SetUserObjectSecurity(
    hObj: ?HANDLE,
    pSIRequested: ?*OBJECT_SECURITY_INFORMATION,
    pSID: ?*SECURITY_DESCRIPTOR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "user32" fn GetUserObjectSecurity(
    hObj: ?HANDLE,
    pSIRequested: ?*u32,
    // TODO: what to do with BytesParamIndex 3?
    pSID: ?*SECURITY_DESCRIPTOR,
    nLength: u32,
    lpnLengthNeeded: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AccessCheckAndAuditAlarmA(
    SubsystemName: ?[*:0]const u8,
    HandleId: ?*anyopaque,
    ObjectTypeName: ?PSTR,
    ObjectName: ?PSTR,
    SecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    DesiredAccess: u32,
    GenericMapping: ?*GENERIC_MAPPING,
    ObjectCreation: BOOL,
    GrantedAccess: ?*u32,
    AccessStatus: ?*i32,
    pfGenerateOnClose: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AccessCheckByTypeAndAuditAlarmA(
    SubsystemName: ?[*:0]const u8,
    HandleId: ?*anyopaque,
    ObjectTypeName: ?[*:0]const u8,
    ObjectName: ?[*:0]const u8,
    SecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    PrincipalSelfSid: ?PSID,
    DesiredAccess: u32,
    AuditType: AUDIT_EVENT_TYPE,
    Flags: u32,
    ObjectTypeList: ?[*]OBJECT_TYPE_LIST,
    ObjectTypeListLength: u32,
    GenericMapping: ?*GENERIC_MAPPING,
    ObjectCreation: BOOL,
    GrantedAccess: ?*u32,
    AccessStatus: ?*i32,
    pfGenerateOnClose: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AccessCheckByTypeResultListAndAuditAlarmA(
    SubsystemName: ?[*:0]const u8,
    HandleId: ?*anyopaque,
    ObjectTypeName: ?[*:0]const u8,
    ObjectName: ?[*:0]const u8,
    SecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    PrincipalSelfSid: ?PSID,
    DesiredAccess: u32,
    AuditType: AUDIT_EVENT_TYPE,
    Flags: u32,
    ObjectTypeList: ?[*]OBJECT_TYPE_LIST,
    ObjectTypeListLength: u32,
    GenericMapping: ?*GENERIC_MAPPING,
    ObjectCreation: BOOL,
    GrantedAccess: [*]u32,
    AccessStatusList: [*]u32,
    pfGenerateOnClose: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn AccessCheckByTypeResultListAndAuditAlarmByHandleA(
    SubsystemName: ?[*:0]const u8,
    HandleId: ?*anyopaque,
    ClientToken: ?HANDLE,
    ObjectTypeName: ?[*:0]const u8,
    ObjectName: ?[*:0]const u8,
    SecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    PrincipalSelfSid: ?PSID,
    DesiredAccess: u32,
    AuditType: AUDIT_EVENT_TYPE,
    Flags: u32,
    ObjectTypeList: ?[*]OBJECT_TYPE_LIST,
    ObjectTypeListLength: u32,
    GenericMapping: ?*GENERIC_MAPPING,
    ObjectCreation: BOOL,
    GrantedAccess: [*]u32,
    AccessStatusList: [*]u32,
    pfGenerateOnClose: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ObjectOpenAuditAlarmA(
    SubsystemName: ?[*:0]const u8,
    HandleId: ?*anyopaque,
    ObjectTypeName: ?PSTR,
    ObjectName: ?PSTR,
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    ClientToken: ?HANDLE,
    DesiredAccess: u32,
    GrantedAccess: u32,
    Privileges: ?*PRIVILEGE_SET,
    ObjectCreation: BOOL,
    AccessGranted: BOOL,
    GenerateOnClose: ?*i32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ObjectPrivilegeAuditAlarmA(
    SubsystemName: ?[*:0]const u8,
    HandleId: ?*anyopaque,
    ClientToken: ?HANDLE,
    DesiredAccess: u32,
    Privileges: ?*PRIVILEGE_SET,
    AccessGranted: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ObjectCloseAuditAlarmA(
    SubsystemName: ?[*:0]const u8,
    HandleId: ?*anyopaque,
    GenerateOnClose: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn ObjectDeleteAuditAlarmA(
    SubsystemName: ?[*:0]const u8,
    HandleId: ?*anyopaque,
    GenerateOnClose: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn PrivilegedServiceAuditAlarmA(
    SubsystemName: ?[*:0]const u8,
    ServiceName: ?[*:0]const u8,
    ClientToken: ?HANDLE,
    Privileges: ?*PRIVILEGE_SET,
    AccessGranted: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows6.1'
pub extern "advapi32" fn AddConditionalAce(
    pAcl: ?*ACL,
    dwAceRevision: u32,
    AceFlags: ACE_FLAGS,
    AceType: u8,
    AccessMask: u32,
    pSid: ?PSID,
    ConditionStr: ?[*]u16,
    ReturnLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn SetFileSecurityA(
    lpFileName: ?[*:0]const u8,
    SecurityInformation: u32,
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn GetFileSecurityA(
    lpFileName: ?[*:0]const u8,
    RequestedInformation: u32,
    // TODO: what to do with BytesParamIndex 3?
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
    nLength: u32,
    lpnLengthNeeded: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LookupAccountSidA(
    lpSystemName: ?[*:0]const u8,
    Sid: ?PSID,
    Name: ?[*:0]u8,
    cchName: ?*u32,
    ReferencedDomainName: ?[*:0]u8,
    cchReferencedDomainName: ?*u32,
    peUse: ?*SID_NAME_USE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LookupAccountSidW(
    lpSystemName: ?[*:0]const u16,
    Sid: ?PSID,
    Name: ?[*:0]u16,
    cchName: ?*u32,
    ReferencedDomainName: ?[*:0]u16,
    cchReferencedDomainName: ?*u32,
    peUse: ?*SID_NAME_USE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LookupAccountNameA(
    lpSystemName: ?[*:0]const u8,
    lpAccountName: ?[*:0]const u8,
    // TODO: what to do with BytesParamIndex 3?
    Sid: ?PSID,
    cbSid: ?*u32,
    ReferencedDomainName: ?[*:0]u8,
    cchReferencedDomainName: ?*u32,
    peUse: ?*SID_NAME_USE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LookupAccountNameW(
    lpSystemName: ?[*:0]const u16,
    lpAccountName: ?[*:0]const u16,
    // TODO: what to do with BytesParamIndex 3?
    Sid: ?PSID,
    cbSid: ?*u32,
    ReferencedDomainName: ?[*:0]u16,
    cchReferencedDomainName: ?*u32,
    peUse: ?*SID_NAME_USE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LookupPrivilegeValueA(
    lpSystemName: ?[*:0]const u8,
    lpName: ?[*:0]const u8,
    lpLuid: ?*LUID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LookupPrivilegeValueW(
    lpSystemName: ?[*:0]const u16,
    lpName: ?[*:0]const u16,
    lpLuid: ?*LUID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LookupPrivilegeNameA(
    lpSystemName: ?[*:0]const u8,
    lpLuid: ?*LUID,
    lpName: ?[*:0]u8,
    cchName: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LookupPrivilegeNameW(
    lpSystemName: ?[*:0]const u16,
    lpLuid: ?*LUID,
    lpName: ?[*:0]u16,
    cchName: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LookupPrivilegeDisplayNameA(
    lpSystemName: ?[*:0]const u8,
    lpName: ?[*:0]const u8,
    lpDisplayName: ?[*:0]u8,
    cchDisplayName: ?*u32,
    lpLanguageId: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LookupPrivilegeDisplayNameW(
    lpSystemName: ?[*:0]const u16,
    lpName: ?[*:0]const u16,
    lpDisplayName: ?[*:0]u16,
    cchDisplayName: ?*u32,
    lpLanguageId: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LogonUserA(
    lpszUsername: ?[*:0]const u8,
    lpszDomain: ?[*:0]const u8,
    lpszPassword: ?[*:0]const u8,
    dwLogonType: LOGON32_LOGON,
    dwLogonProvider: LOGON32_PROVIDER,
    phToken: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LogonUserW(
    lpszUsername: ?[*:0]const u16,
    lpszDomain: ?[*:0]const u16,
    lpszPassword: ?[*:0]const u16,
    dwLogonType: LOGON32_LOGON,
    dwLogonProvider: LOGON32_PROVIDER,
    phToken: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LogonUserExA(
    lpszUsername: ?[*:0]const u8,
    lpszDomain: ?[*:0]const u8,
    lpszPassword: ?[*:0]const u8,
    dwLogonType: LOGON32_LOGON,
    dwLogonProvider: LOGON32_PROVIDER,
    phToken: ?*?HANDLE,
    ppLogonSid: ?*?PSID,
    // TODO: what to do with BytesParamIndex 8?
    ppProfileBuffer: ?*?*anyopaque,
    pdwProfileLength: ?*u32,
    pQuotaLimits: ?*QUOTA_LIMITS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "advapi32" fn LogonUserExW(
    lpszUsername: ?[*:0]const u16,
    lpszDomain: ?[*:0]const u16,
    lpszPassword: ?[*:0]const u16,
    dwLogonType: LOGON32_LOGON,
    dwLogonProvider: LOGON32_PROVIDER,
    phToken: ?*?HANDLE,
    ppLogonSid: ?*?PSID,
    // TODO: what to do with BytesParamIndex 8?
    ppProfileBuffer: ?*?*anyopaque,
    pdwProfileLength: ?*u32,
    pQuotaLimits: ?*QUOTA_LIMITS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "ntdll" fn RtlConvertSidToUnicodeString(
    UnicodeString: ?*UNICODE_STRING,
    Sid: ?PSID,
    AllocateDestinationString: BOOLEAN,
) callconv(@import("std").os.windows.WINAPI) NTSTATUS;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (18)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("zig.zig").unicode_mode) {
    .ansi => struct {
        pub const AccessCheckAndAuditAlarm = thismodule.AccessCheckAndAuditAlarmA;
        pub const AccessCheckByTypeAndAuditAlarm = thismodule.AccessCheckByTypeAndAuditAlarmA;
        pub const AccessCheckByTypeResultListAndAuditAlarm = thismodule.AccessCheckByTypeResultListAndAuditAlarmA;
        pub const AccessCheckByTypeResultListAndAuditAlarmByHandle = thismodule.AccessCheckByTypeResultListAndAuditAlarmByHandleA;
        pub const GetFileSecurity = thismodule.GetFileSecurityA;
        pub const ObjectCloseAuditAlarm = thismodule.ObjectCloseAuditAlarmA;
        pub const ObjectDeleteAuditAlarm = thismodule.ObjectDeleteAuditAlarmA;
        pub const ObjectOpenAuditAlarm = thismodule.ObjectOpenAuditAlarmA;
        pub const ObjectPrivilegeAuditAlarm = thismodule.ObjectPrivilegeAuditAlarmA;
        pub const PrivilegedServiceAuditAlarm = thismodule.PrivilegedServiceAuditAlarmA;
        pub const SetFileSecurity = thismodule.SetFileSecurityA;
        pub const LookupAccountSid = thismodule.LookupAccountSidA;
        pub const LookupAccountName = thismodule.LookupAccountNameA;
        pub const LookupPrivilegeValue = thismodule.LookupPrivilegeValueA;
        pub const LookupPrivilegeName = thismodule.LookupPrivilegeNameA;
        pub const LookupPrivilegeDisplayName = thismodule.LookupPrivilegeDisplayNameA;
        pub const LogonUser = thismodule.LogonUserA;
        pub const LogonUserEx = thismodule.LogonUserExA;
    },
    .wide => struct {
        pub const AccessCheckAndAuditAlarm = thismodule.AccessCheckAndAuditAlarmW;
        pub const AccessCheckByTypeAndAuditAlarm = thismodule.AccessCheckByTypeAndAuditAlarmW;
        pub const AccessCheckByTypeResultListAndAuditAlarm = thismodule.AccessCheckByTypeResultListAndAuditAlarmW;
        pub const AccessCheckByTypeResultListAndAuditAlarmByHandle = thismodule.AccessCheckByTypeResultListAndAuditAlarmByHandleW;
        pub const GetFileSecurity = thismodule.GetFileSecurityW;
        pub const ObjectCloseAuditAlarm = thismodule.ObjectCloseAuditAlarmW;
        pub const ObjectDeleteAuditAlarm = thismodule.ObjectDeleteAuditAlarmW;
        pub const ObjectOpenAuditAlarm = thismodule.ObjectOpenAuditAlarmW;
        pub const ObjectPrivilegeAuditAlarm = thismodule.ObjectPrivilegeAuditAlarmW;
        pub const PrivilegedServiceAuditAlarm = thismodule.PrivilegedServiceAuditAlarmW;
        pub const SetFileSecurity = thismodule.SetFileSecurityW;
        pub const LookupAccountSid = thismodule.LookupAccountSidW;
        pub const LookupAccountName = thismodule.LookupAccountNameW;
        pub const LookupPrivilegeValue = thismodule.LookupPrivilegeValueW;
        pub const LookupPrivilegeName = thismodule.LookupPrivilegeNameW;
        pub const LookupPrivilegeDisplayName = thismodule.LookupPrivilegeDisplayNameW;
        pub const LogonUser = thismodule.LogonUserW;
        pub const LogonUserEx = thismodule.LogonUserExW;
    },
    .unspecified => if (@import("builtin").is_test) struct {
        pub const AccessCheckAndAuditAlarm = *opaque {};
        pub const AccessCheckByTypeAndAuditAlarm = *opaque {};
        pub const AccessCheckByTypeResultListAndAuditAlarm = *opaque {};
        pub const AccessCheckByTypeResultListAndAuditAlarmByHandle = *opaque {};
        pub const GetFileSecurity = *opaque {};
        pub const ObjectCloseAuditAlarm = *opaque {};
        pub const ObjectDeleteAuditAlarm = *opaque {};
        pub const ObjectOpenAuditAlarm = *opaque {};
        pub const ObjectPrivilegeAuditAlarm = *opaque {};
        pub const PrivilegedServiceAuditAlarm = *opaque {};
        pub const SetFileSecurity = *opaque {};
        pub const LookupAccountSid = *opaque {};
        pub const LookupAccountName = *opaque {};
        pub const LookupPrivilegeValue = *opaque {};
        pub const LookupPrivilegeName = *opaque {};
        pub const LookupPrivilegeDisplayName = *opaque {};
        pub const LogonUser = *opaque {};
        pub const LogonUserEx = *opaque {};
    } else struct {
        pub const AccessCheckAndAuditAlarm = @compileError("'AccessCheckAndAuditAlarm' requires that UNICODE be set to true or false in the root module");
        pub const AccessCheckByTypeAndAuditAlarm = @compileError("'AccessCheckByTypeAndAuditAlarm' requires that UNICODE be set to true or false in the root module");
        pub const AccessCheckByTypeResultListAndAuditAlarm = @compileError("'AccessCheckByTypeResultListAndAuditAlarm' requires that UNICODE be set to true or false in the root module");
        pub const AccessCheckByTypeResultListAndAuditAlarmByHandle = @compileError("'AccessCheckByTypeResultListAndAuditAlarmByHandle' requires that UNICODE be set to true or false in the root module");
        pub const GetFileSecurity = @compileError("'GetFileSecurity' requires that UNICODE be set to true or false in the root module");
        pub const ObjectCloseAuditAlarm = @compileError("'ObjectCloseAuditAlarm' requires that UNICODE be set to true or false in the root module");
        pub const ObjectDeleteAuditAlarm = @compileError("'ObjectDeleteAuditAlarm' requires that UNICODE be set to true or false in the root module");
        pub const ObjectOpenAuditAlarm = @compileError("'ObjectOpenAuditAlarm' requires that UNICODE be set to true or false in the root module");
        pub const ObjectPrivilegeAuditAlarm = @compileError("'ObjectPrivilegeAuditAlarm' requires that UNICODE be set to true or false in the root module");
        pub const PrivilegedServiceAuditAlarm = @compileError("'PrivilegedServiceAuditAlarm' requires that UNICODE be set to true or false in the root module");
        pub const SetFileSecurity = @compileError("'SetFileSecurity' requires that UNICODE be set to true or false in the root module");
        pub const LookupAccountSid = @compileError("'LookupAccountSid' requires that UNICODE be set to true or false in the root module");
        pub const LookupAccountName = @compileError("'LookupAccountName' requires that UNICODE be set to true or false in the root module");
        pub const LookupPrivilegeValue = @compileError("'LookupPrivilegeValue' requires that UNICODE be set to true or false in the root module");
        pub const LookupPrivilegeName = @compileError("'LookupPrivilegeName' requires that UNICODE be set to true or false in the root module");
        pub const LookupPrivilegeDisplayName = @compileError("'LookupPrivilegeDisplayName' requires that UNICODE be set to true or false in the root module");
        pub const LogonUser = @compileError("'LogonUser' requires that UNICODE be set to true or false in the root module");
        pub const LogonUserEx = @compileError("'LogonUserEx' requires that UNICODE be set to true or false in the root module");
    },
};
//--------------------------------------------------------------------------------
// Section: Imports (13)
//--------------------------------------------------------------------------------
const Guid = @import("zig.zig").Guid;
const BOOL = @import("foundation.zig").BOOL;
const BOOLEAN = @import("foundation.zig").BOOLEAN;
const CHAR = @import("foundation.zig").CHAR;
const FILETIME = @import("foundation.zig").FILETIME;
const HANDLE = @import("foundation.zig").HANDLE;
const LARGE_INTEGER = @import("foundation.zig").LARGE_INTEGER;
const LUID = @import("foundation.zig").LUID;
const NTSTATUS = @import("foundation.zig").NTSTATUS;
const PSID = @import("foundation.zig").PSID;
const PSTR = @import("foundation.zig").PSTR;
const PWSTR = @import("foundation.zig").PWSTR;
const UNICODE_STRING = @import("foundation.zig").UNICODE_STRING;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "PLSA_AP_CALL_PACKAGE_UNTRUSTED")) {
        _ = PLSA_AP_CALL_PACKAGE_UNTRUSTED;
    }
    if (@hasDecl(@This(), "SEC_THREAD_START")) {
        _ = SEC_THREAD_START;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
//--------------------------------------------------------------------------------
// Section: SubModules (16)
//--------------------------------------------------------------------------------
pub const app_locker = @import("security/app_locker.zig");
pub const authentication = @import("security/authentication.zig");
pub const authorization = @import("security/authorization.zig");
pub const configuration_snapin = @import("security/configuration_snapin.zig");
pub const credentials = @import("security/credentials.zig");
pub const cryptography = @import("security/cryptography.zig");
pub const diagnostic_data_query = @import("security/diagnostic_data_query.zig");
pub const directory_services = @import("security/directory_services.zig");
pub const enterprise_data = @import("security/enterprise_data.zig");
pub const extensible_authentication_protocol = @import("security/extensible_authentication_protocol.zig");
pub const isolation = @import("security/isolation.zig");
pub const license_protection = @import("security/license_protection.zig");
pub const network_access_protection = @import("security/network_access_protection.zig");
pub const tpm = @import("security/tpm.zig");
pub const win_trust = @import("security/win_trust.zig");
pub const win_wlx = @import("security/win_wlx.zig");
