//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (2)
//--------------------------------------------------------------------------------
pub const NLM_MAX_ADDRESS_LIST_SIZE = @as(u32, 10);
pub const NLM_UNKNOWN_DATAPLAN_STATUS = @as(u32, 4294967295);

//--------------------------------------------------------------------------------
// Section: Types (26)
//--------------------------------------------------------------------------------
const CLSID_NetworkListManager_Value = Guid.initString("dcb00c01-570f-4a9b-8d69-199fdba5723b");
pub const CLSID_NetworkListManager = &CLSID_NetworkListManager_Value;

pub const NLM_CONNECTION_COST = enum(i32) {
    UNKNOWN = 0,
    UNRESTRICTED = 1,
    FIXED = 2,
    VARIABLE = 4,
    OVERDATALIMIT = 65536,
    CONGESTED = 131072,
    ROAMING = 262144,
    APPROACHINGDATALIMIT = 524288,
};
pub const NLM_CONNECTION_COST_UNKNOWN = NLM_CONNECTION_COST.UNKNOWN;
pub const NLM_CONNECTION_COST_UNRESTRICTED = NLM_CONNECTION_COST.UNRESTRICTED;
pub const NLM_CONNECTION_COST_FIXED = NLM_CONNECTION_COST.FIXED;
pub const NLM_CONNECTION_COST_VARIABLE = NLM_CONNECTION_COST.VARIABLE;
pub const NLM_CONNECTION_COST_OVERDATALIMIT = NLM_CONNECTION_COST.OVERDATALIMIT;
pub const NLM_CONNECTION_COST_CONGESTED = NLM_CONNECTION_COST.CONGESTED;
pub const NLM_CONNECTION_COST_ROAMING = NLM_CONNECTION_COST.ROAMING;
pub const NLM_CONNECTION_COST_APPROACHINGDATALIMIT = NLM_CONNECTION_COST.APPROACHINGDATALIMIT;

pub const NLM_USAGE_DATA = extern struct {
    UsageInMegabytes: u32,
    LastSyncTime: FILETIME,
};

pub const NLM_DATAPLAN_STATUS = extern struct {
    InterfaceGuid: Guid,
    UsageData: NLM_USAGE_DATA,
    DataLimitInMegabytes: u32,
    InboundBandwidthInKbps: u32,
    OutboundBandwidthInKbps: u32,
    NextBillingCycle: FILETIME,
    MaxTransferSizeInMegabytes: u32,
    Reserved: u32,
};

pub const NLM_SOCKADDR = extern struct {
    data: [128]u8,
};

pub const NLM_NETWORK_CLASS = enum(i32) {
    IDENTIFYING = 1,
    IDENTIFIED = 2,
    UNIDENTIFIED = 3,
};
pub const NLM_NETWORK_IDENTIFYING = NLM_NETWORK_CLASS.IDENTIFYING;
pub const NLM_NETWORK_IDENTIFIED = NLM_NETWORK_CLASS.IDENTIFIED;
pub const NLM_NETWORK_UNIDENTIFIED = NLM_NETWORK_CLASS.UNIDENTIFIED;

pub const NLM_SIMULATED_PROFILE_INFO = extern struct {
    ProfileName: [256]u16,
    cost: NLM_CONNECTION_COST,
    UsageInMegabytes: u32,
    DataLimitInMegabytes: u32,
};

pub const NLM_INTERNET_CONNECTIVITY = enum(i32) {
    WEBHIJACK = 1,
    PROXIED = 2,
    CORPORATE = 4,
};
pub const NLM_INTERNET_CONNECTIVITY_WEBHIJACK = NLM_INTERNET_CONNECTIVITY.WEBHIJACK;
pub const NLM_INTERNET_CONNECTIVITY_PROXIED = NLM_INTERNET_CONNECTIVITY.PROXIED;
pub const NLM_INTERNET_CONNECTIVITY_CORPORATE = NLM_INTERNET_CONNECTIVITY.CORPORATE;

pub const NLM_CONNECTIVITY = enum(i32) {
    DISCONNECTED = 0,
    IPV4_NOTRAFFIC = 1,
    IPV6_NOTRAFFIC = 2,
    IPV4_SUBNET = 16,
    IPV4_LOCALNETWORK = 32,
    IPV4_INTERNET = 64,
    IPV6_SUBNET = 256,
    IPV6_LOCALNETWORK = 512,
    IPV6_INTERNET = 1024,
};
pub const NLM_CONNECTIVITY_DISCONNECTED = NLM_CONNECTIVITY.DISCONNECTED;
pub const NLM_CONNECTIVITY_IPV4_NOTRAFFIC = NLM_CONNECTIVITY.IPV4_NOTRAFFIC;
pub const NLM_CONNECTIVITY_IPV6_NOTRAFFIC = NLM_CONNECTIVITY.IPV6_NOTRAFFIC;
pub const NLM_CONNECTIVITY_IPV4_SUBNET = NLM_CONNECTIVITY.IPV4_SUBNET;
pub const NLM_CONNECTIVITY_IPV4_LOCALNETWORK = NLM_CONNECTIVITY.IPV4_LOCALNETWORK;
pub const NLM_CONNECTIVITY_IPV4_INTERNET = NLM_CONNECTIVITY.IPV4_INTERNET;
pub const NLM_CONNECTIVITY_IPV6_SUBNET = NLM_CONNECTIVITY.IPV6_SUBNET;
pub const NLM_CONNECTIVITY_IPV6_LOCALNETWORK = NLM_CONNECTIVITY.IPV6_LOCALNETWORK;
pub const NLM_CONNECTIVITY_IPV6_INTERNET = NLM_CONNECTIVITY.IPV6_INTERNET;

pub const NLM_DOMAIN_TYPE = enum(i32) {
    NON_DOMAIN_NETWORK = 0,
    DOMAIN_NETWORK = 1,
    DOMAIN_AUTHENTICATED = 2,
};
pub const NLM_DOMAIN_TYPE_NON_DOMAIN_NETWORK = NLM_DOMAIN_TYPE.NON_DOMAIN_NETWORK;
pub const NLM_DOMAIN_TYPE_DOMAIN_NETWORK = NLM_DOMAIN_TYPE.DOMAIN_NETWORK;
pub const NLM_DOMAIN_TYPE_DOMAIN_AUTHENTICATED = NLM_DOMAIN_TYPE.DOMAIN_AUTHENTICATED;

pub const NLM_ENUM_NETWORK = enum(i32) {
    CONNECTED = 1,
    DISCONNECTED = 2,
    ALL = 3,
};
pub const NLM_ENUM_NETWORK_CONNECTED = NLM_ENUM_NETWORK.CONNECTED;
pub const NLM_ENUM_NETWORK_DISCONNECTED = NLM_ENUM_NETWORK.DISCONNECTED;
pub const NLM_ENUM_NETWORK_ALL = NLM_ENUM_NETWORK.ALL;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_INetworkListManager_Value = Guid.initString("dcb00000-570f-4a9b-8d69-199fdba5723b");
pub const IID_INetworkListManager = &IID_INetworkListManager_Value;
pub const INetworkListManager = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        GetNetworks: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkListManager,
                Flags: NLM_ENUM_NETWORK,
                ppEnumNetwork: ?*?*IEnumNetworks,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkListManager,
                Flags: NLM_ENUM_NETWORK,
                ppEnumNetwork: ?*?*IEnumNetworks,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetNetwork: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkListManager,
                gdNetworkId: Guid,
                ppNetwork: ?*?*INetwork,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkListManager,
                gdNetworkId: Guid,
                ppNetwork: ?*?*INetwork,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetNetworkConnections: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkListManager,
                ppEnum: ?*?*IEnumNetworkConnections,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkListManager,
                ppEnum: ?*?*IEnumNetworkConnections,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetNetworkConnection: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkListManager,
                gdNetworkConnectionId: Guid,
                ppNetworkConnection: ?*?*INetworkConnection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkListManager,
                gdNetworkConnectionId: Guid,
                ppNetworkConnection: ?*?*INetworkConnection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsConnectedToInternet: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const INetworkListManager,
                pbIsConnected: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const INetworkListManager,
                pbIsConnected: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsConnected: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const INetworkListManager,
                pbIsConnected: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const INetworkListManager,
                pbIsConnected: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetConnectivity: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkListManager,
                pConnectivity: ?*NLM_CONNECTIVITY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkListManager,
                pConnectivity: ?*NLM_CONNECTIVITY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetSimulatedProfileInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkListManager,
                pSimulatedInfo: ?*NLM_SIMULATED_PROFILE_INFO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkListManager,
                pSimulatedInfo: ?*NLM_SIMULATED_PROFILE_INFO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ClearSimulatedProfileInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkListManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkListManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkListManager_GetNetworks(self: *const T, Flags: NLM_ENUM_NETWORK, ppEnumNetwork: ?*?*IEnumNetworks) HRESULT {
                return @as(*const INetworkListManager.VTable, @ptrCast(self.vtable)).GetNetworks(@as(*const INetworkListManager, @ptrCast(self)), Flags, ppEnumNetwork);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkListManager_GetNetwork(self: *const T, gdNetworkId: Guid, ppNetwork: ?*?*INetwork) HRESULT {
                return @as(*const INetworkListManager.VTable, @ptrCast(self.vtable)).GetNetwork(@as(*const INetworkListManager, @ptrCast(self)), gdNetworkId, ppNetwork);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkListManager_GetNetworkConnections(self: *const T, ppEnum: ?*?*IEnumNetworkConnections) HRESULT {
                return @as(*const INetworkListManager.VTable, @ptrCast(self.vtable)).GetNetworkConnections(@as(*const INetworkListManager, @ptrCast(self)), ppEnum);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkListManager_GetNetworkConnection(self: *const T, gdNetworkConnectionId: Guid, ppNetworkConnection: ?*?*INetworkConnection) HRESULT {
                return @as(*const INetworkListManager.VTable, @ptrCast(self.vtable)).GetNetworkConnection(@as(*const INetworkListManager, @ptrCast(self)), gdNetworkConnectionId, ppNetworkConnection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkListManager_get_IsConnectedToInternet(self: *const T, pbIsConnected: ?*i16) HRESULT {
                return @as(*const INetworkListManager.VTable, @ptrCast(self.vtable)).get_IsConnectedToInternet(@as(*const INetworkListManager, @ptrCast(self)), pbIsConnected);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkListManager_get_IsConnected(self: *const T, pbIsConnected: ?*i16) HRESULT {
                return @as(*const INetworkListManager.VTable, @ptrCast(self.vtable)).get_IsConnected(@as(*const INetworkListManager, @ptrCast(self)), pbIsConnected);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkListManager_GetConnectivity(self: *const T, pConnectivity: ?*NLM_CONNECTIVITY) HRESULT {
                return @as(*const INetworkListManager.VTable, @ptrCast(self.vtable)).GetConnectivity(@as(*const INetworkListManager, @ptrCast(self)), pConnectivity);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkListManager_SetSimulatedProfileInfo(self: *const T, pSimulatedInfo: ?*NLM_SIMULATED_PROFILE_INFO) HRESULT {
                return @as(*const INetworkListManager.VTable, @ptrCast(self.vtable)).SetSimulatedProfileInfo(@as(*const INetworkListManager, @ptrCast(self)), pSimulatedInfo);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkListManager_ClearSimulatedProfileInfo(self: *const T) HRESULT {
                return @as(*const INetworkListManager.VTable, @ptrCast(self.vtable)).ClearSimulatedProfileInfo(@as(*const INetworkListManager, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_INetworkListManagerEvents_Value = Guid.initString("dcb00001-570f-4a9b-8d69-199fdba5723b");
pub const IID_INetworkListManagerEvents = &IID_INetworkListManagerEvents_Value;
pub const INetworkListManagerEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        ConnectivityChanged: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkListManagerEvents,
                newConnectivity: NLM_CONNECTIVITY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkListManagerEvents,
                newConnectivity: NLM_CONNECTIVITY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkListManagerEvents_ConnectivityChanged(self: *const T, newConnectivity: NLM_CONNECTIVITY) HRESULT {
                return @as(*const INetworkListManagerEvents.VTable, @ptrCast(self.vtable)).ConnectivityChanged(@as(*const INetworkListManagerEvents, @ptrCast(self)), newConnectivity);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const NLM_NETWORK_CATEGORY = enum(i32) {
    PUBLIC = 0,
    PRIVATE = 1,
    DOMAIN_AUTHENTICATED = 2,
};
pub const NLM_NETWORK_CATEGORY_PUBLIC = NLM_NETWORK_CATEGORY.PUBLIC;
pub const NLM_NETWORK_CATEGORY_PRIVATE = NLM_NETWORK_CATEGORY.PRIVATE;
pub const NLM_NETWORK_CATEGORY_DOMAIN_AUTHENTICATED = NLM_NETWORK_CATEGORY.DOMAIN_AUTHENTICATED;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_INetwork_Value = Guid.initString("dcb00002-570f-4a9b-8d69-199fdba5723b");
pub const IID_INetwork = &IID_INetwork_Value;
pub const INetwork = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        GetName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetwork,
                pszNetworkName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetwork,
                pszNetworkName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetwork,
                szNetworkNewName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetwork,
                szNetworkNewName: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetwork,
                pszDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetwork,
                pszDescription: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetwork,
                szDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetwork,
                szDescription: ?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetNetworkId: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetwork,
                pgdGuidNetworkId: ?*Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetwork,
                pgdGuidNetworkId: ?*Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDomainType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetwork,
                pNetworkType: ?*NLM_DOMAIN_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetwork,
                pNetworkType: ?*NLM_DOMAIN_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetNetworkConnections: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetwork,
                ppEnumNetworkConnection: ?*?*IEnumNetworkConnections,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetwork,
                ppEnumNetworkConnection: ?*?*IEnumNetworkConnections,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetTimeCreatedAndConnected: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetwork,
                pdwLowDateTimeCreated: ?*u32,
                pdwHighDateTimeCreated: ?*u32,
                pdwLowDateTimeConnected: ?*u32,
                pdwHighDateTimeConnected: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetwork,
                pdwLowDateTimeCreated: ?*u32,
                pdwHighDateTimeCreated: ?*u32,
                pdwLowDateTimeConnected: ?*u32,
                pdwHighDateTimeConnected: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsConnectedToInternet: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const INetwork,
                pbIsConnected: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const INetwork,
                pbIsConnected: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsConnected: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const INetwork,
                pbIsConnected: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const INetwork,
                pbIsConnected: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetConnectivity: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetwork,
                pConnectivity: ?*NLM_CONNECTIVITY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetwork,
                pConnectivity: ?*NLM_CONNECTIVITY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetCategory: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetwork,
                pCategory: ?*NLM_NETWORK_CATEGORY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetwork,
                pCategory: ?*NLM_NETWORK_CATEGORY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCategory: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetwork,
                NewCategory: NLM_NETWORK_CATEGORY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetwork,
                NewCategory: NLM_NETWORK_CATEGORY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetwork_GetName(self: *const T, pszNetworkName: ?*?BSTR) HRESULT {
                return @as(*const INetwork.VTable, @ptrCast(self.vtable)).GetName(@as(*const INetwork, @ptrCast(self)), pszNetworkName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetwork_SetName(self: *const T, szNetworkNewName: ?BSTR) HRESULT {
                return @as(*const INetwork.VTable, @ptrCast(self.vtable)).SetName(@as(*const INetwork, @ptrCast(self)), szNetworkNewName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetwork_GetDescription(self: *const T, pszDescription: ?*?BSTR) HRESULT {
                return @as(*const INetwork.VTable, @ptrCast(self.vtable)).GetDescription(@as(*const INetwork, @ptrCast(self)), pszDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetwork_SetDescription(self: *const T, szDescription: ?BSTR) HRESULT {
                return @as(*const INetwork.VTable, @ptrCast(self.vtable)).SetDescription(@as(*const INetwork, @ptrCast(self)), szDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetwork_GetNetworkId(self: *const T, pgdGuidNetworkId: ?*Guid) HRESULT {
                return @as(*const INetwork.VTable, @ptrCast(self.vtable)).GetNetworkId(@as(*const INetwork, @ptrCast(self)), pgdGuidNetworkId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetwork_GetDomainType(self: *const T, pNetworkType: ?*NLM_DOMAIN_TYPE) HRESULT {
                return @as(*const INetwork.VTable, @ptrCast(self.vtable)).GetDomainType(@as(*const INetwork, @ptrCast(self)), pNetworkType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetwork_GetNetworkConnections(self: *const T, ppEnumNetworkConnection: ?*?*IEnumNetworkConnections) HRESULT {
                return @as(*const INetwork.VTable, @ptrCast(self.vtable)).GetNetworkConnections(@as(*const INetwork, @ptrCast(self)), ppEnumNetworkConnection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetwork_GetTimeCreatedAndConnected(self: *const T, pdwLowDateTimeCreated: ?*u32, pdwHighDateTimeCreated: ?*u32, pdwLowDateTimeConnected: ?*u32, pdwHighDateTimeConnected: ?*u32) HRESULT {
                return @as(*const INetwork.VTable, @ptrCast(self.vtable)).GetTimeCreatedAndConnected(@as(*const INetwork, @ptrCast(self)), pdwLowDateTimeCreated, pdwHighDateTimeCreated, pdwLowDateTimeConnected, pdwHighDateTimeConnected);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetwork_get_IsConnectedToInternet(self: *const T, pbIsConnected: ?*i16) HRESULT {
                return @as(*const INetwork.VTable, @ptrCast(self.vtable)).get_IsConnectedToInternet(@as(*const INetwork, @ptrCast(self)), pbIsConnected);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetwork_get_IsConnected(self: *const T, pbIsConnected: ?*i16) HRESULT {
                return @as(*const INetwork.VTable, @ptrCast(self.vtable)).get_IsConnected(@as(*const INetwork, @ptrCast(self)), pbIsConnected);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetwork_GetConnectivity(self: *const T, pConnectivity: ?*NLM_CONNECTIVITY) HRESULT {
                return @as(*const INetwork.VTable, @ptrCast(self.vtable)).GetConnectivity(@as(*const INetwork, @ptrCast(self)), pConnectivity);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetwork_GetCategory(self: *const T, pCategory: ?*NLM_NETWORK_CATEGORY) HRESULT {
                return @as(*const INetwork.VTable, @ptrCast(self.vtable)).GetCategory(@as(*const INetwork, @ptrCast(self)), pCategory);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetwork_SetCategory(self: *const T, NewCategory: NLM_NETWORK_CATEGORY) HRESULT {
                return @as(*const INetwork.VTable, @ptrCast(self.vtable)).SetCategory(@as(*const INetwork, @ptrCast(self)), NewCategory);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IEnumNetworks_Value = Guid.initString("dcb00003-570f-4a9b-8d69-199fdba5723b");
pub const IID_IEnumNetworks = &IID_IEnumNetworks_Value;
pub const IEnumNetworks = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IEnumNetworks,
                ppEnumVar: ?*?*IEnumVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IEnumNetworks,
                ppEnumVar: ?*?*IEnumVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Next: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumNetworks,
                celt: u32,
                rgelt: [*]?*INetwork,
                pceltFetched: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumNetworks,
                celt: u32,
                rgelt: [*]?*INetwork,
                pceltFetched: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Skip: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumNetworks,
                celt: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumNetworks,
                celt: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Reset: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumNetworks,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumNetworks,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Clone: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumNetworks,
                ppEnumNetwork: ?*?*IEnumNetworks,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumNetworks,
                ppEnumNetwork: ?*?*IEnumNetworks,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumNetworks_get__NewEnum(self: *const T, ppEnumVar: ?*?*IEnumVARIANT) HRESULT {
                return @as(*const IEnumNetworks.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const IEnumNetworks, @ptrCast(self)), ppEnumVar);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumNetworks_Next(self: *const T, celt: u32, rgelt: [*]?*INetwork, pceltFetched: ?*u32) HRESULT {
                return @as(*const IEnumNetworks.VTable, @ptrCast(self.vtable)).Next(@as(*const IEnumNetworks, @ptrCast(self)), celt, rgelt, pceltFetched);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumNetworks_Skip(self: *const T, celt: u32) HRESULT {
                return @as(*const IEnumNetworks.VTable, @ptrCast(self.vtable)).Skip(@as(*const IEnumNetworks, @ptrCast(self)), celt);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumNetworks_Reset(self: *const T) HRESULT {
                return @as(*const IEnumNetworks.VTable, @ptrCast(self.vtable)).Reset(@as(*const IEnumNetworks, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumNetworks_Clone(self: *const T, ppEnumNetwork: ?*?*IEnumNetworks) HRESULT {
                return @as(*const IEnumNetworks.VTable, @ptrCast(self.vtable)).Clone(@as(*const IEnumNetworks, @ptrCast(self)), ppEnumNetwork);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const NLM_NETWORK_PROPERTY_CHANGE = enum(i32) {
    CONNECTION = 1,
    DESCRIPTION = 2,
    NAME = 4,
    ICON = 8,
    CATEGORY_VALUE = 16,
};
pub const NLM_NETWORK_PROPERTY_CHANGE_CONNECTION = NLM_NETWORK_PROPERTY_CHANGE.CONNECTION;
pub const NLM_NETWORK_PROPERTY_CHANGE_DESCRIPTION = NLM_NETWORK_PROPERTY_CHANGE.DESCRIPTION;
pub const NLM_NETWORK_PROPERTY_CHANGE_NAME = NLM_NETWORK_PROPERTY_CHANGE.NAME;
pub const NLM_NETWORK_PROPERTY_CHANGE_ICON = NLM_NETWORK_PROPERTY_CHANGE.ICON;
pub const NLM_NETWORK_PROPERTY_CHANGE_CATEGORY_VALUE = NLM_NETWORK_PROPERTY_CHANGE.CATEGORY_VALUE;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_INetworkEvents_Value = Guid.initString("dcb00004-570f-4a9b-8d69-199fdba5723b");
pub const IID_INetworkEvents = &IID_INetworkEvents_Value;
pub const INetworkEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        NetworkAdded: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkEvents,
                networkId: Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkEvents,
                networkId: Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        NetworkDeleted: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkEvents,
                networkId: Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkEvents,
                networkId: Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        NetworkConnectivityChanged: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkEvents,
                networkId: Guid,
                newConnectivity: NLM_CONNECTIVITY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkEvents,
                networkId: Guid,
                newConnectivity: NLM_CONNECTIVITY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        NetworkPropertyChanged: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkEvents,
                networkId: Guid,
                flags: NLM_NETWORK_PROPERTY_CHANGE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkEvents,
                networkId: Guid,
                flags: NLM_NETWORK_PROPERTY_CHANGE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkEvents_NetworkAdded(self: *const T, networkId: Guid) HRESULT {
                return @as(*const INetworkEvents.VTable, @ptrCast(self.vtable)).NetworkAdded(@as(*const INetworkEvents, @ptrCast(self)), networkId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkEvents_NetworkDeleted(self: *const T, networkId: Guid) HRESULT {
                return @as(*const INetworkEvents.VTable, @ptrCast(self.vtable)).NetworkDeleted(@as(*const INetworkEvents, @ptrCast(self)), networkId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkEvents_NetworkConnectivityChanged(self: *const T, networkId: Guid, newConnectivity: NLM_CONNECTIVITY) HRESULT {
                return @as(*const INetworkEvents.VTable, @ptrCast(self.vtable)).NetworkConnectivityChanged(@as(*const INetworkEvents, @ptrCast(self)), networkId, newConnectivity);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkEvents_NetworkPropertyChanged(self: *const T, networkId: Guid, flags: NLM_NETWORK_PROPERTY_CHANGE) HRESULT {
                return @as(*const INetworkEvents.VTable, @ptrCast(self.vtable)).NetworkPropertyChanged(@as(*const INetworkEvents, @ptrCast(self)), networkId, flags);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_INetworkConnection_Value = Guid.initString("dcb00005-570f-4a9b-8d69-199fdba5723b");
pub const IID_INetworkConnection = &IID_INetworkConnection_Value;
pub const INetworkConnection = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        GetNetwork: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkConnection,
                ppNetwork: ?*?*INetwork,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkConnection,
                ppNetwork: ?*?*INetwork,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsConnectedToInternet: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const INetworkConnection,
                pbIsConnected: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const INetworkConnection,
                pbIsConnected: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsConnected: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const INetworkConnection,
                pbIsConnected: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const INetworkConnection,
                pbIsConnected: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetConnectivity: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkConnection,
                pConnectivity: ?*NLM_CONNECTIVITY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkConnection,
                pConnectivity: ?*NLM_CONNECTIVITY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetConnectionId: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkConnection,
                pgdConnectionId: ?*Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkConnection,
                pgdConnectionId: ?*Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAdapterId: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkConnection,
                pgdAdapterId: ?*Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkConnection,
                pgdAdapterId: ?*Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDomainType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkConnection,
                pDomainType: ?*NLM_DOMAIN_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkConnection,
                pDomainType: ?*NLM_DOMAIN_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkConnection_GetNetwork(self: *const T, ppNetwork: ?*?*INetwork) HRESULT {
                return @as(*const INetworkConnection.VTable, @ptrCast(self.vtable)).GetNetwork(@as(*const INetworkConnection, @ptrCast(self)), ppNetwork);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkConnection_get_IsConnectedToInternet(self: *const T, pbIsConnected: ?*i16) HRESULT {
                return @as(*const INetworkConnection.VTable, @ptrCast(self.vtable)).get_IsConnectedToInternet(@as(*const INetworkConnection, @ptrCast(self)), pbIsConnected);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkConnection_get_IsConnected(self: *const T, pbIsConnected: ?*i16) HRESULT {
                return @as(*const INetworkConnection.VTable, @ptrCast(self.vtable)).get_IsConnected(@as(*const INetworkConnection, @ptrCast(self)), pbIsConnected);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkConnection_GetConnectivity(self: *const T, pConnectivity: ?*NLM_CONNECTIVITY) HRESULT {
                return @as(*const INetworkConnection.VTable, @ptrCast(self.vtable)).GetConnectivity(@as(*const INetworkConnection, @ptrCast(self)), pConnectivity);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkConnection_GetConnectionId(self: *const T, pgdConnectionId: ?*Guid) HRESULT {
                return @as(*const INetworkConnection.VTable, @ptrCast(self.vtable)).GetConnectionId(@as(*const INetworkConnection, @ptrCast(self)), pgdConnectionId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkConnection_GetAdapterId(self: *const T, pgdAdapterId: ?*Guid) HRESULT {
                return @as(*const INetworkConnection.VTable, @ptrCast(self.vtable)).GetAdapterId(@as(*const INetworkConnection, @ptrCast(self)), pgdAdapterId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkConnection_GetDomainType(self: *const T, pDomainType: ?*NLM_DOMAIN_TYPE) HRESULT {
                return @as(*const INetworkConnection.VTable, @ptrCast(self.vtable)).GetDomainType(@as(*const INetworkConnection, @ptrCast(self)), pDomainType);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IEnumNetworkConnections_Value = Guid.initString("dcb00006-570f-4a9b-8d69-199fdba5723b");
pub const IID_IEnumNetworkConnections = &IID_IEnumNetworkConnections_Value;
pub const IEnumNetworkConnections = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get__NewEnum: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IEnumNetworkConnections,
                ppEnumVar: ?*?*IEnumVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IEnumNetworkConnections,
                ppEnumVar: ?*?*IEnumVARIANT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Next: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumNetworkConnections,
                celt: u32,
                rgelt: [*]?*INetworkConnection,
                pceltFetched: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumNetworkConnections,
                celt: u32,
                rgelt: [*]?*INetworkConnection,
                pceltFetched: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Skip: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumNetworkConnections,
                celt: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumNetworkConnections,
                celt: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Reset: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumNetworkConnections,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumNetworkConnections,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Clone: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumNetworkConnections,
                ppEnumNetwork: ?*?*IEnumNetworkConnections,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumNetworkConnections,
                ppEnumNetwork: ?*?*IEnumNetworkConnections,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumNetworkConnections_get__NewEnum(self: *const T, ppEnumVar: ?*?*IEnumVARIANT) HRESULT {
                return @as(*const IEnumNetworkConnections.VTable, @ptrCast(self.vtable)).get__NewEnum(@as(*const IEnumNetworkConnections, @ptrCast(self)), ppEnumVar);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumNetworkConnections_Next(self: *const T, celt: u32, rgelt: [*]?*INetworkConnection, pceltFetched: ?*u32) HRESULT {
                return @as(*const IEnumNetworkConnections.VTable, @ptrCast(self.vtable)).Next(@as(*const IEnumNetworkConnections, @ptrCast(self)), celt, rgelt, pceltFetched);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumNetworkConnections_Skip(self: *const T, celt: u32) HRESULT {
                return @as(*const IEnumNetworkConnections.VTable, @ptrCast(self.vtable)).Skip(@as(*const IEnumNetworkConnections, @ptrCast(self)), celt);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumNetworkConnections_Reset(self: *const T) HRESULT {
                return @as(*const IEnumNetworkConnections.VTable, @ptrCast(self.vtable)).Reset(@as(*const IEnumNetworkConnections, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumNetworkConnections_Clone(self: *const T, ppEnumNetwork: ?*?*IEnumNetworkConnections) HRESULT {
                return @as(*const IEnumNetworkConnections.VTable, @ptrCast(self.vtable)).Clone(@as(*const IEnumNetworkConnections, @ptrCast(self)), ppEnumNetwork);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const NLM_CONNECTION_PROPERTY_CHANGE = enum(i32) {
    N = 1,
};
pub const NLM_CONNECTION_PROPERTY_CHANGE_AUTHENTICATION = NLM_CONNECTION_PROPERTY_CHANGE.N;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_INetworkConnectionEvents_Value = Guid.initString("dcb00007-570f-4a9b-8d69-199fdba5723b");
pub const IID_INetworkConnectionEvents = &IID_INetworkConnectionEvents_Value;
pub const INetworkConnectionEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        NetworkConnectionConnectivityChanged: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkConnectionEvents,
                connectionId: Guid,
                newConnectivity: NLM_CONNECTIVITY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkConnectionEvents,
                connectionId: Guid,
                newConnectivity: NLM_CONNECTIVITY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        NetworkConnectionPropertyChanged: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkConnectionEvents,
                connectionId: Guid,
                flags: NLM_CONNECTION_PROPERTY_CHANGE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkConnectionEvents,
                connectionId: Guid,
                flags: NLM_CONNECTION_PROPERTY_CHANGE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkConnectionEvents_NetworkConnectionConnectivityChanged(self: *const T, connectionId: Guid, newConnectivity: NLM_CONNECTIVITY) HRESULT {
                return @as(*const INetworkConnectionEvents.VTable, @ptrCast(self.vtable)).NetworkConnectionConnectivityChanged(@as(*const INetworkConnectionEvents, @ptrCast(self)), connectionId, newConnectivity);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkConnectionEvents_NetworkConnectionPropertyChanged(self: *const T, connectionId: Guid, flags: NLM_CONNECTION_PROPERTY_CHANGE) HRESULT {
                return @as(*const INetworkConnectionEvents.VTable, @ptrCast(self.vtable)).NetworkConnectionPropertyChanged(@as(*const INetworkConnectionEvents, @ptrCast(self)), connectionId, flags);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_INetworkCostManager_Value = Guid.initString("dcb00008-570f-4a9b-8d69-199fdba5723b");
pub const IID_INetworkCostManager = &IID_INetworkCostManager_Value;
pub const INetworkCostManager = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetCost: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkCostManager,
                pCost: ?*u32,
                pDestIPAddr: ?*NLM_SOCKADDR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkCostManager,
                pCost: ?*u32,
                pDestIPAddr: ?*NLM_SOCKADDR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDataPlanStatus: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkCostManager,
                pDataPlanStatus: ?*NLM_DATAPLAN_STATUS,
                pDestIPAddr: ?*NLM_SOCKADDR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkCostManager,
                pDataPlanStatus: ?*NLM_DATAPLAN_STATUS,
                pDestIPAddr: ?*NLM_SOCKADDR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetDestinationAddresses: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkCostManager,
                length: u32,
                pDestIPAddrList: [*]NLM_SOCKADDR,
                bAppend: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkCostManager,
                length: u32,
                pDestIPAddrList: [*]NLM_SOCKADDR,
                bAppend: i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkCostManager_GetCost(self: *const T, pCost: ?*u32, pDestIPAddr: ?*NLM_SOCKADDR) HRESULT {
                return @as(*const INetworkCostManager.VTable, @ptrCast(self.vtable)).GetCost(@as(*const INetworkCostManager, @ptrCast(self)), pCost, pDestIPAddr);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkCostManager_GetDataPlanStatus(self: *const T, pDataPlanStatus: ?*NLM_DATAPLAN_STATUS, pDestIPAddr: ?*NLM_SOCKADDR) HRESULT {
                return @as(*const INetworkCostManager.VTable, @ptrCast(self.vtable)).GetDataPlanStatus(@as(*const INetworkCostManager, @ptrCast(self)), pDataPlanStatus, pDestIPAddr);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkCostManager_SetDestinationAddresses(self: *const T, length: u32, pDestIPAddrList: [*]NLM_SOCKADDR, bAppend: i16) HRESULT {
                return @as(*const INetworkCostManager.VTable, @ptrCast(self.vtable)).SetDestinationAddresses(@as(*const INetworkCostManager, @ptrCast(self)), length, pDestIPAddrList, bAppend);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_INetworkCostManagerEvents_Value = Guid.initString("dcb00009-570f-4a9b-8d69-199fdba5723b");
pub const IID_INetworkCostManagerEvents = &IID_INetworkCostManagerEvents_Value;
pub const INetworkCostManagerEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        CostChanged: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkCostManagerEvents,
                newCost: u32,
                pDestAddr: ?*NLM_SOCKADDR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkCostManagerEvents,
                newCost: u32,
                pDestAddr: ?*NLM_SOCKADDR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DataPlanStatusChanged: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkCostManagerEvents,
                pDestAddr: ?*NLM_SOCKADDR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkCostManagerEvents,
                pDestAddr: ?*NLM_SOCKADDR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkCostManagerEvents_CostChanged(self: *const T, newCost: u32, pDestAddr: ?*NLM_SOCKADDR) HRESULT {
                return @as(*const INetworkCostManagerEvents.VTable, @ptrCast(self.vtable)).CostChanged(@as(*const INetworkCostManagerEvents, @ptrCast(self)), newCost, pDestAddr);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkCostManagerEvents_DataPlanStatusChanged(self: *const T, pDestAddr: ?*NLM_SOCKADDR) HRESULT {
                return @as(*const INetworkCostManagerEvents.VTable, @ptrCast(self.vtable)).DataPlanStatusChanged(@as(*const INetworkCostManagerEvents, @ptrCast(self)), pDestAddr);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_INetworkConnectionCost_Value = Guid.initString("dcb0000a-570f-4a9b-8d69-199fdba5723b");
pub const IID_INetworkConnectionCost = &IID_INetworkConnectionCost_Value;
pub const INetworkConnectionCost = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetCost: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkConnectionCost,
                pCost: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkConnectionCost,
                pCost: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDataPlanStatus: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkConnectionCost,
                pDataPlanStatus: ?*NLM_DATAPLAN_STATUS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkConnectionCost,
                pDataPlanStatus: ?*NLM_DATAPLAN_STATUS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkConnectionCost_GetCost(self: *const T, pCost: ?*u32) HRESULT {
                return @as(*const INetworkConnectionCost.VTable, @ptrCast(self.vtable)).GetCost(@as(*const INetworkConnectionCost, @ptrCast(self)), pCost);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkConnectionCost_GetDataPlanStatus(self: *const T, pDataPlanStatus: ?*NLM_DATAPLAN_STATUS) HRESULT {
                return @as(*const INetworkConnectionCost.VTable, @ptrCast(self.vtable)).GetDataPlanStatus(@as(*const INetworkConnectionCost, @ptrCast(self)), pDataPlanStatus);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_INetworkConnectionCostEvents_Value = Guid.initString("dcb0000b-570f-4a9b-8d69-199fdba5723b");
pub const IID_INetworkConnectionCostEvents = &IID_INetworkConnectionCostEvents_Value;
pub const INetworkConnectionCostEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        ConnectionCostChanged: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkConnectionCostEvents,
                connectionId: Guid,
                newCost: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkConnectionCostEvents,
                connectionId: Guid,
                newCost: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ConnectionDataPlanStatusChanged: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const INetworkConnectionCostEvents,
                connectionId: Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const INetworkConnectionCostEvents,
                connectionId: Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkConnectionCostEvents_ConnectionCostChanged(self: *const T, connectionId: Guid, newCost: u32) HRESULT {
                return @as(*const INetworkConnectionCostEvents.VTable, @ptrCast(self.vtable)).ConnectionCostChanged(@as(*const INetworkConnectionCostEvents, @ptrCast(self)), connectionId, newCost);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn INetworkConnectionCostEvents_ConnectionDataPlanStatusChanged(self: *const T, connectionId: Guid) HRESULT {
                return @as(*const INetworkConnectionCostEvents.VTable, @ptrCast(self.vtable)).ConnectionDataPlanStatusChanged(@as(*const INetworkConnectionCostEvents, @ptrCast(self)), connectionId);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

//--------------------------------------------------------------------------------
// Section: Functions (0)
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (7)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BSTR = @import("../foundation.zig").BSTR;
const FILETIME = @import("../foundation.zig").FILETIME;
const HRESULT = @import("../foundation.zig").HRESULT;
const IDispatch = @import("../system/com.zig").IDispatch;
const IEnumVARIANT = @import("../system/ole.zig").IEnumVARIANT;
const IUnknown = @import("../system/com.zig").IUnknown;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
