//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (144)
//--------------------------------------------------------------------------------
pub const LBER_ERROR = @as(i32, -1);
pub const LBER_DEFAULT = @as(i32, -1);
pub const LDAP_UNICODE = @as(u32, 1);
pub const LDAP_PORT = @as(u32, 389);
pub const LDAP_SSL_PORT = @as(u32, 636);
pub const LDAP_GC_PORT = @as(u32, 3268);
pub const LDAP_SSL_GC_PORT = @as(u32, 3269);
pub const LDAP_VERSION1 = @as(u32, 1);
pub const LDAP_VERSION2 = @as(u32, 2);
pub const LDAP_VERSION3 = @as(u32, 3);
pub const LDAP_VERSION = @as(u32, 2);
pub const LDAP_BIND_CMD = @as(i32, 96);
pub const LDAP_UNBIND_CMD = @as(i32, 66);
pub const LDAP_SEARCH_CMD = @as(i32, 99);
pub const LDAP_MODIFY_CMD = @as(i32, 102);
pub const LDAP_ADD_CMD = @as(i32, 104);
pub const LDAP_DELETE_CMD = @as(i32, 74);
pub const LDAP_MODRDN_CMD = @as(i32, 108);
pub const LDAP_COMPARE_CMD = @as(i32, 110);
pub const LDAP_ABANDON_CMD = @as(i32, 80);
pub const LDAP_SESSION_CMD = @as(i32, 113);
pub const LDAP_EXTENDED_CMD = @as(i32, 119);
pub const LDAP_RES_BIND = @as(i32, 97);
pub const LDAP_RES_SEARCH_ENTRY = @as(i32, 100);
pub const LDAP_RES_SEARCH_RESULT = @as(i32, 101);
pub const LDAP_RES_MODIFY = @as(i32, 103);
pub const LDAP_RES_ADD = @as(i32, 105);
pub const LDAP_RES_DELETE = @as(i32, 107);
pub const LDAP_RES_MODRDN = @as(i32, 109);
pub const LDAP_RES_COMPARE = @as(i32, 111);
pub const LDAP_RES_SESSION = @as(i32, 114);
pub const LDAP_RES_REFERRAL = @as(i32, 115);
pub const LDAP_RES_EXTENDED = @as(i32, 120);
pub const LDAP_RES_ANY = @as(i32, -1);
pub const LDAP_INVALID_CMD = @as(u32, 255);
pub const LDAP_INVALID_RES = @as(u32, 255);
pub const LDAP_AUTH_SIMPLE = @as(i32, 128);
pub const LDAP_AUTH_SASL = @as(i32, 131);
pub const LDAP_AUTH_OTHERKIND = @as(i32, 134);
pub const LDAP_FILTER_AND = @as(u32, 160);
pub const LDAP_FILTER_OR = @as(u32, 161);
pub const LDAP_FILTER_NOT = @as(u32, 162);
pub const LDAP_FILTER_EQUALITY = @as(u32, 163);
pub const LDAP_FILTER_SUBSTRINGS = @as(u32, 164);
pub const LDAP_FILTER_GE = @as(u32, 165);
pub const LDAP_FILTER_LE = @as(u32, 166);
pub const LDAP_FILTER_PRESENT = @as(u32, 135);
pub const LDAP_FILTER_APPROX = @as(u32, 168);
pub const LDAP_FILTER_EXTENSIBLE = @as(u32, 169);
pub const LDAP_SUBSTRING_INITIAL = @as(i32, 128);
pub const LDAP_SUBSTRING_ANY = @as(i32, 129);
pub const LDAP_SUBSTRING_FINAL = @as(i32, 130);
pub const LDAP_DEREF_NEVER = @as(u32, 0);
pub const LDAP_DEREF_SEARCHING = @as(u32, 1);
pub const LDAP_DEREF_FINDING = @as(u32, 2);
pub const LDAP_DEREF_ALWAYS = @as(u32, 3);
pub const LDAP_NO_LIMIT = @as(u32, 0);
pub const LDAP_OPT_DNS = @as(u32, 1);
pub const LDAP_OPT_CHASE_REFERRALS = @as(u32, 2);
pub const LDAP_OPT_RETURN_REFS = @as(u32, 4);
pub const LDAP_MOD_ADD = @as(u32, 0);
pub const LDAP_MOD_DELETE = @as(u32, 1);
pub const LDAP_MOD_REPLACE = @as(u32, 2);
pub const LDAP_MOD_BVALUES = @as(u32, 128);
pub const LDAP_OPT_API_INFO = @as(u32, 0);
pub const LDAP_OPT_DESC = @as(u32, 1);
pub const LDAP_OPT_DEREF = @as(u32, 2);
pub const LDAP_OPT_SIZELIMIT = @as(u32, 3);
pub const LDAP_OPT_TIMELIMIT = @as(u32, 4);
pub const LDAP_OPT_THREAD_FN_PTRS = @as(u32, 5);
pub const LDAP_OPT_REBIND_FN = @as(u32, 6);
pub const LDAP_OPT_REBIND_ARG = @as(u32, 7);
pub const LDAP_OPT_REFERRALS = @as(u32, 8);
pub const LDAP_OPT_RESTART = @as(u32, 9);
pub const LDAP_OPT_SSL = @as(u32, 10);
pub const LDAP_OPT_IO_FN_PTRS = @as(u32, 11);
pub const LDAP_OPT_CACHE_FN_PTRS = @as(u32, 13);
pub const LDAP_OPT_CACHE_STRATEGY = @as(u32, 14);
pub const LDAP_OPT_CACHE_ENABLE = @as(u32, 15);
pub const LDAP_OPT_REFERRAL_HOP_LIMIT = @as(u32, 16);
pub const LDAP_OPT_PROTOCOL_VERSION = @as(u32, 17);
pub const LDAP_OPT_VERSION = @as(u32, 17);
pub const LDAP_OPT_API_FEATURE_INFO = @as(u32, 21);
pub const LDAP_OPT_HOST_NAME = @as(u32, 48);
pub const LDAP_OPT_ERROR_NUMBER = @as(u32, 49);
pub const LDAP_OPT_ERROR_STRING = @as(u32, 50);
pub const LDAP_OPT_SERVER_ERROR = @as(u32, 51);
pub const LDAP_OPT_SERVER_EXT_ERROR = @as(u32, 52);
pub const LDAP_OPT_HOST_REACHABLE = @as(u32, 62);
pub const LDAP_OPT_PING_KEEP_ALIVE = @as(u32, 54);
pub const LDAP_OPT_PING_WAIT_TIME = @as(u32, 55);
pub const LDAP_OPT_PING_LIMIT = @as(u32, 56);
pub const LDAP_OPT_DNSDOMAIN_NAME = @as(u32, 59);
pub const LDAP_OPT_GETDSNAME_FLAGS = @as(u32, 61);
pub const LDAP_OPT_PROMPT_CREDENTIALS = @as(u32, 63);
pub const LDAP_OPT_AUTO_RECONNECT = @as(u32, 145);
pub const LDAP_OPT_SSPI_FLAGS = @as(u32, 146);
pub const LDAP_OPT_SSL_INFO = @as(u32, 147);
pub const LDAP_OPT_TLS = @as(u32, 10);
pub const LDAP_OPT_TLS_INFO = @as(u32, 147);
pub const LDAP_OPT_SIGN = @as(u32, 149);
pub const LDAP_OPT_ENCRYPT = @as(u32, 150);
pub const LDAP_OPT_SASL_METHOD = @as(u32, 151);
pub const LDAP_OPT_AREC_EXCLUSIVE = @as(u32, 152);
pub const LDAP_OPT_SECURITY_CONTEXT = @as(u32, 153);
pub const LDAP_OPT_ROOTDSE_CACHE = @as(u32, 154);
pub const LDAP_OPT_TCP_KEEPALIVE = @as(u32, 64);
pub const LDAP_OPT_FAST_CONCURRENT_BIND = @as(u32, 65);
pub const LDAP_OPT_SEND_TIMEOUT = @as(u32, 66);
pub const LDAP_OPT_SCH_FLAGS = @as(u32, 67);
pub const LDAP_OPT_SOCKET_BIND_ADDRESSES = @as(u32, 68);
pub const LDAP_CHASE_SUBORDINATE_REFERRALS = @as(u32, 32);
pub const LDAP_CHASE_EXTERNAL_REFERRALS = @as(u32, 64);
pub const LDAP_SCOPE_BASE = @as(u32, 0);
pub const LDAP_SCOPE_ONELEVEL = @as(u32, 1);
pub const LDAP_SCOPE_SUBTREE = @as(u32, 2);
pub const LDAP_MSG_ONE = @as(u32, 0);
pub const LDAP_MSG_ALL = @as(u32, 1);
pub const LDAP_MSG_RECEIVED = @as(u32, 2);
pub const LBER_USE_DER = @as(u32, 1);
pub const LBER_USE_INDEFINITE_LEN = @as(u32, 2);
pub const LBER_TRANSLATE_STRINGS = @as(u32, 4);
pub const LAPI_MAJOR_VER1 = @as(u32, 1);
pub const LAPI_MINOR_VER1 = @as(u32, 1);
pub const LDAP_API_INFO_VERSION = @as(u32, 1);
pub const LDAP_API_VERSION = @as(u32, 2004);
pub const LDAP_VERSION_MIN = @as(u32, 2);
pub const LDAP_VERSION_MAX = @as(u32, 3);
pub const LDAP_VENDOR_VERSION = @as(u32, 510);
pub const LDAP_FEATURE_INFO_VERSION = @as(u32, 1);
pub const LDAP_API_FEATURE_VIRTUAL_LIST_VIEW = @as(u32, 1001);
pub const LDAP_VLVINFO_VERSION = @as(u32, 1);
pub const LDAP_OPT_REFERRAL_CALLBACK = @as(u32, 112);
pub const LDAP_OPT_CLIENT_CERTIFICATE = @as(u32, 128);
pub const LDAP_OPT_SERVER_CERTIFICATE = @as(u32, 129);
pub const LDAP_OPT_REF_DEREF_CONN_PER_MSG = @as(u32, 148);
pub const SERVER_SEARCH_FLAG_DOMAIN_SCOPE = @as(u32, 1);
pub const SERVER_SEARCH_FLAG_PHANTOM_ROOT = @as(u32, 2);
pub const LDAP_DIRSYNC_OBJECT_SECURITY = @as(u32, 1);
pub const LDAP_DIRSYNC_ANCESTORS_FIRST_ORDER = @as(u32, 2048);
pub const LDAP_DIRSYNC_PUBLIC_DATA_ONLY = @as(u32, 8192);
pub const LDAP_DIRSYNC_INCREMENTAL_VALUES = @as(u32, 2147483648);
pub const LDAP_DIRSYNC_ROPAS_DATA_ONLY = @as(u32, 1073741824);
pub const LDAP_POLICYHINT_APPLY_FULLPWDPOLICY = @as(u32, 1);

//--------------------------------------------------------------------------------
// Section: Types (26)
//--------------------------------------------------------------------------------
pub const LDAP_RETCODE = enum(i32) {
    SUCCESS = 0,
    OPERATIONS_ERROR = 1,
    PROTOCOL_ERROR = 2,
    TIMELIMIT_EXCEEDED = 3,
    SIZELIMIT_EXCEEDED = 4,
    COMPARE_FALSE = 5,
    COMPARE_TRUE = 6,
    AUTH_METHOD_NOT_SUPPORTED = 7,
    STRONG_AUTH_REQUIRED = 8,
    REFERRAL_V2 = 9,
    // PARTIAL_RESULTS = 9, this enum value conflicts with REFERRAL_V2
    REFERRAL = 10,
    ADMIN_LIMIT_EXCEEDED = 11,
    UNAVAILABLE_CRIT_EXTENSION = 12,
    CONFIDENTIALITY_REQUIRED = 13,
    SASL_BIND_IN_PROGRESS = 14,
    NO_SUCH_ATTRIBUTE = 16,
    UNDEFINED_TYPE = 17,
    INAPPROPRIATE_MATCHING = 18,
    CONSTRAINT_VIOLATION = 19,
    ATTRIBUTE_OR_VALUE_EXISTS = 20,
    INVALID_SYNTAX = 21,
    NO_SUCH_OBJECT = 32,
    ALIAS_PROBLEM = 33,
    INVALID_DN_SYNTAX = 34,
    IS_LEAF = 35,
    ALIAS_DEREF_PROBLEM = 36,
    INAPPROPRIATE_AUTH = 48,
    INVALID_CREDENTIALS = 49,
    INSUFFICIENT_RIGHTS = 50,
    BUSY = 51,
    UNAVAILABLE = 52,
    UNWILLING_TO_PERFORM = 53,
    LOOP_DETECT = 54,
    SORT_CONTROL_MISSING = 60,
    OFFSET_RANGE_ERROR = 61,
    NAMING_VIOLATION = 64,
    OBJECT_CLASS_VIOLATION = 65,
    NOT_ALLOWED_ON_NONLEAF = 66,
    NOT_ALLOWED_ON_RDN = 67,
    ALREADY_EXISTS = 68,
    NO_OBJECT_CLASS_MODS = 69,
    RESULTS_TOO_LARGE = 70,
    AFFECTS_MULTIPLE_DSAS = 71,
    VIRTUAL_LIST_VIEW_ERROR = 76,
    OTHER = 80,
    SERVER_DOWN = 81,
    LOCAL_ERROR = 82,
    ENCODING_ERROR = 83,
    DECODING_ERROR = 84,
    TIMEOUT = 85,
    AUTH_UNKNOWN = 86,
    FILTER_ERROR = 87,
    USER_CANCELLED = 88,
    PARAM_ERROR = 89,
    NO_MEMORY = 90,
    CONNECT_ERROR = 91,
    NOT_SUPPORTED = 92,
    NO_RESULTS_RETURNED = 94,
    CONTROL_NOT_FOUND = 93,
    MORE_RESULTS_TO_RETURN = 95,
    CLIENT_LOOP = 96,
    REFERRAL_LIMIT_EXCEEDED = 97,
};
pub const LDAP_SUCCESS = LDAP_RETCODE.SUCCESS;
pub const LDAP_OPERATIONS_ERROR = LDAP_RETCODE.OPERATIONS_ERROR;
pub const LDAP_PROTOCOL_ERROR = LDAP_RETCODE.PROTOCOL_ERROR;
pub const LDAP_TIMELIMIT_EXCEEDED = LDAP_RETCODE.TIMELIMIT_EXCEEDED;
pub const LDAP_SIZELIMIT_EXCEEDED = LDAP_RETCODE.SIZELIMIT_EXCEEDED;
pub const LDAP_COMPARE_FALSE = LDAP_RETCODE.COMPARE_FALSE;
pub const LDAP_COMPARE_TRUE = LDAP_RETCODE.COMPARE_TRUE;
pub const LDAP_AUTH_METHOD_NOT_SUPPORTED = LDAP_RETCODE.AUTH_METHOD_NOT_SUPPORTED;
pub const LDAP_STRONG_AUTH_REQUIRED = LDAP_RETCODE.STRONG_AUTH_REQUIRED;
pub const LDAP_REFERRAL_V2 = LDAP_RETCODE.REFERRAL_V2;
pub const LDAP_PARTIAL_RESULTS = LDAP_RETCODE.REFERRAL_V2;
pub const LDAP_REFERRAL = LDAP_RETCODE.REFERRAL;
pub const LDAP_ADMIN_LIMIT_EXCEEDED = LDAP_RETCODE.ADMIN_LIMIT_EXCEEDED;
pub const LDAP_UNAVAILABLE_CRIT_EXTENSION = LDAP_RETCODE.UNAVAILABLE_CRIT_EXTENSION;
pub const LDAP_CONFIDENTIALITY_REQUIRED = LDAP_RETCODE.CONFIDENTIALITY_REQUIRED;
pub const LDAP_SASL_BIND_IN_PROGRESS = LDAP_RETCODE.SASL_BIND_IN_PROGRESS;
pub const LDAP_NO_SUCH_ATTRIBUTE = LDAP_RETCODE.NO_SUCH_ATTRIBUTE;
pub const LDAP_UNDEFINED_TYPE = LDAP_RETCODE.UNDEFINED_TYPE;
pub const LDAP_INAPPROPRIATE_MATCHING = LDAP_RETCODE.INAPPROPRIATE_MATCHING;
pub const LDAP_CONSTRAINT_VIOLATION = LDAP_RETCODE.CONSTRAINT_VIOLATION;
pub const LDAP_ATTRIBUTE_OR_VALUE_EXISTS = LDAP_RETCODE.ATTRIBUTE_OR_VALUE_EXISTS;
pub const LDAP_INVALID_SYNTAX = LDAP_RETCODE.INVALID_SYNTAX;
pub const LDAP_NO_SUCH_OBJECT = LDAP_RETCODE.NO_SUCH_OBJECT;
pub const LDAP_ALIAS_PROBLEM = LDAP_RETCODE.ALIAS_PROBLEM;
pub const LDAP_INVALID_DN_SYNTAX = LDAP_RETCODE.INVALID_DN_SYNTAX;
pub const LDAP_IS_LEAF = LDAP_RETCODE.IS_LEAF;
pub const LDAP_ALIAS_DEREF_PROBLEM = LDAP_RETCODE.ALIAS_DEREF_PROBLEM;
pub const LDAP_INAPPROPRIATE_AUTH = LDAP_RETCODE.INAPPROPRIATE_AUTH;
pub const LDAP_INVALID_CREDENTIALS = LDAP_RETCODE.INVALID_CREDENTIALS;
pub const LDAP_INSUFFICIENT_RIGHTS = LDAP_RETCODE.INSUFFICIENT_RIGHTS;
pub const LDAP_BUSY = LDAP_RETCODE.BUSY;
pub const LDAP_UNAVAILABLE = LDAP_RETCODE.UNAVAILABLE;
pub const LDAP_UNWILLING_TO_PERFORM = LDAP_RETCODE.UNWILLING_TO_PERFORM;
pub const LDAP_LOOP_DETECT = LDAP_RETCODE.LOOP_DETECT;
pub const LDAP_SORT_CONTROL_MISSING = LDAP_RETCODE.SORT_CONTROL_MISSING;
pub const LDAP_OFFSET_RANGE_ERROR = LDAP_RETCODE.OFFSET_RANGE_ERROR;
pub const LDAP_NAMING_VIOLATION = LDAP_RETCODE.NAMING_VIOLATION;
pub const LDAP_OBJECT_CLASS_VIOLATION = LDAP_RETCODE.OBJECT_CLASS_VIOLATION;
pub const LDAP_NOT_ALLOWED_ON_NONLEAF = LDAP_RETCODE.NOT_ALLOWED_ON_NONLEAF;
pub const LDAP_NOT_ALLOWED_ON_RDN = LDAP_RETCODE.NOT_ALLOWED_ON_RDN;
pub const LDAP_ALREADY_EXISTS = LDAP_RETCODE.ALREADY_EXISTS;
pub const LDAP_NO_OBJECT_CLASS_MODS = LDAP_RETCODE.NO_OBJECT_CLASS_MODS;
pub const LDAP_RESULTS_TOO_LARGE = LDAP_RETCODE.RESULTS_TOO_LARGE;
pub const LDAP_AFFECTS_MULTIPLE_DSAS = LDAP_RETCODE.AFFECTS_MULTIPLE_DSAS;
pub const LDAP_VIRTUAL_LIST_VIEW_ERROR = LDAP_RETCODE.VIRTUAL_LIST_VIEW_ERROR;
pub const LDAP_OTHER = LDAP_RETCODE.OTHER;
pub const LDAP_SERVER_DOWN = LDAP_RETCODE.SERVER_DOWN;
pub const LDAP_LOCAL_ERROR = LDAP_RETCODE.LOCAL_ERROR;
pub const LDAP_ENCODING_ERROR = LDAP_RETCODE.ENCODING_ERROR;
pub const LDAP_DECODING_ERROR = LDAP_RETCODE.DECODING_ERROR;
pub const LDAP_TIMEOUT = LDAP_RETCODE.TIMEOUT;
pub const LDAP_AUTH_UNKNOWN = LDAP_RETCODE.AUTH_UNKNOWN;
pub const LDAP_FILTER_ERROR = LDAP_RETCODE.FILTER_ERROR;
pub const LDAP_USER_CANCELLED = LDAP_RETCODE.USER_CANCELLED;
pub const LDAP_PARAM_ERROR = LDAP_RETCODE.PARAM_ERROR;
pub const LDAP_NO_MEMORY = LDAP_RETCODE.NO_MEMORY;
pub const LDAP_CONNECT_ERROR = LDAP_RETCODE.CONNECT_ERROR;
pub const LDAP_NOT_SUPPORTED = LDAP_RETCODE.NOT_SUPPORTED;
pub const LDAP_NO_RESULTS_RETURNED = LDAP_RETCODE.NO_RESULTS_RETURNED;
pub const LDAP_CONTROL_NOT_FOUND = LDAP_RETCODE.CONTROL_NOT_FOUND;
pub const LDAP_MORE_RESULTS_TO_RETURN = LDAP_RETCODE.MORE_RESULTS_TO_RETURN;
pub const LDAP_CLIENT_LOOP = LDAP_RETCODE.CLIENT_LOOP;
pub const LDAP_REFERRAL_LIMIT_EXCEEDED = LDAP_RETCODE.REFERRAL_LIMIT_EXCEEDED;

pub const ldap = extern struct {
    ld_sb: extern struct {
        sb_sd: usize,
        Reserved1: [41]u8,
        sb_naddr: usize,
        Reserved2: [24]u8,
    },
    ld_host: ?[*]u8,
    ld_version: u32,
    ld_lberoptions: u8,
    ld_deref: u32,
    ld_timelimit: u32,
    ld_sizelimit: u32,
    ld_errno: u32,
    ld_matched: ?[*]u8,
    ld_error: ?[*]u8,
    ld_msgid: u32,
    Reserved3: [25]u8,
    ld_cldaptries: u32,
    ld_cldaptimeout: u32,
    ld_refhoplimit: u32,
    ld_options: u32,
};

pub const LDAP_TIMEVAL = extern struct {
    tv_sec: i32,
    tv_usec: i32,
};

pub const LDAP_BERVAL = extern struct {
    bv_len: u32,
    bv_val: ?[*]u8,
};

pub const LDAPMessage = extern struct {
    lm_msgid: u32,
    lm_msgtype: u32,
    lm_ber: ?*anyopaque,
    lm_chain: ?*LDAPMessage,
    lm_next: ?*LDAPMessage,
    lm_time: u32,
    Connection: ?*ldap,
    Request: ?*anyopaque,
    lm_returncode: u32,
    lm_referral: u16,
    lm_chased: BOOLEAN,
    lm_eom: BOOLEAN,
    ConnectionReferenced: BOOLEAN,
};

pub const ldapcontrolA = extern struct {
    ldctl_oid: ?[*]u8,
    ldctl_value: LDAP_BERVAL,
    ldctl_iscritical: BOOLEAN,
};

pub const ldapcontrolW = extern struct {
    ldctl_oid: ?[*]u16,
    ldctl_value: LDAP_BERVAL,
    ldctl_iscritical: BOOLEAN,
};

pub const ldapmodW = extern struct {
    mod_op: u32,
    mod_type: ?[*]u16,
    mod_vals: extern union {
        modv_strvals: ?*?PWSTR,
        modv_bvals: ?*?*LDAP_BERVAL,
    },
};

pub const ldapmodA = extern struct {
    mod_op: u32,
    mod_type: ?[*]u8,
    mod_vals: extern union {
        modv_strvals: ?*?PSTR,
        modv_bvals: ?*?*LDAP_BERVAL,
    },
};

pub const berelement = extern struct {
    @"opaque": ?[*]u8,
};

pub const ldap_version_info = extern struct {
    lv_size: u32,
    lv_major: u32,
    lv_minor: u32,
};

pub const ldapapiinfoA = extern struct {
    ldapai_info_version: i32,
    ldapai_api_version: i32,
    ldapai_protocol_version: i32,
    ldapai_extensions: ?*?*i8,
    ldapai_vendor_name: ?PSTR,
    ldapai_vendor_version: i32,
};

pub const ldapapiinfoW = extern struct {
    ldapai_info_version: i32,
    ldapai_api_version: i32,
    ldapai_protocol_version: i32,
    ldapai_extensions: ?*?PWSTR,
    ldapai_vendor_name: ?[*]u16,
    ldapai_vendor_version: i32,
};

pub const LDAPAPIFeatureInfoA = extern struct {
    ldapaif_info_version: i32,
    ldapaif_name: ?PSTR,
    ldapaif_version: i32,
};

pub const LDAPAPIFeatureInfoW = extern struct {
    ldapaif_info_version: i32,
    ldapaif_name: ?[*]u16,
    ldapaif_version: i32,
};

pub const DBGPRINT = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        Format: ?[*]const u8,
    ) callconv(@import("std").os.windows.WINAPI) u32,
    else => *const fn (
        Format: ?[*]const u8,
    ) callconv(@import("std").os.windows.WINAPI) u32,
};

pub const ldapsearch = extern struct {
    placeholder: usize, // TODO: why is this type empty?
};

pub const ldapsortkeyW = extern struct {
    sk_attrtype: ?[*]u16,
    sk_matchruleoid: ?[*]u16,
    sk_reverseorder: BOOLEAN,
};

pub const ldapsortkeyA = extern struct {
    sk_attrtype: ?[*]u8,
    sk_matchruleoid: ?[*]u8,
    sk_reverseorder: BOOLEAN,
};

pub const ldapvlvinfo = extern struct {
    ldvlv_version: i32,
    ldvlv_before_count: u32,
    ldvlv_after_count: u32,
    ldvlv_offset: u32,
    ldvlv_count: u32,
    ldvlv_attrvalue: ?*LDAP_BERVAL,
    ldvlv_context: ?*LDAP_BERVAL,
    ldvlv_extradata: ?*anyopaque,
};

pub const QUERYFORCONNECTION = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        PrimaryConnection: ?*ldap,
        ReferralFromConnection: ?*ldap,
        NewDN: ?[*]u16,
        HostName: ?[*]u8,
        PortNumber: u32,
        SecAuthIdentity: ?*anyopaque,
        CurrentUserToken: ?*anyopaque,
        ConnectionToUse: ?*?*ldap,
    ) callconv(@import("std").os.windows.WINAPI) u32,
    else => *const fn (
        PrimaryConnection: ?*ldap,
        ReferralFromConnection: ?*ldap,
        NewDN: ?[*]u16,
        HostName: ?[*]u8,
        PortNumber: u32,
        SecAuthIdentity: ?*anyopaque,
        CurrentUserToken: ?*anyopaque,
        ConnectionToUse: ?*?*ldap,
    ) callconv(@import("std").os.windows.WINAPI) u32,
};

pub const NOTIFYOFNEWCONNECTION = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        PrimaryConnection: ?*ldap,
        ReferralFromConnection: ?*ldap,
        NewDN: ?[*]u16,
        HostName: ?[*]u8,
        NewConnection: ?*ldap,
        PortNumber: u32,
        SecAuthIdentity: ?*anyopaque,
        CurrentUser: ?*anyopaque,
        ErrorCodeFromBind: u32,
    ) callconv(@import("std").os.windows.WINAPI) BOOLEAN,
    else => *const fn (
        PrimaryConnection: ?*ldap,
        ReferralFromConnection: ?*ldap,
        NewDN: ?[*]u16,
        HostName: ?[*]u8,
        NewConnection: ?*ldap,
        PortNumber: u32,
        SecAuthIdentity: ?*anyopaque,
        CurrentUser: ?*anyopaque,
        ErrorCodeFromBind: u32,
    ) callconv(@import("std").os.windows.WINAPI) BOOLEAN,
};

pub const DEREFERENCECONNECTION = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        PrimaryConnection: ?*ldap,
        ConnectionToDereference: ?*ldap,
    ) callconv(@import("std").os.windows.WINAPI) u32,
    else => *const fn (
        PrimaryConnection: ?*ldap,
        ConnectionToDereference: ?*ldap,
    ) callconv(@import("std").os.windows.WINAPI) u32,
};

pub const LDAP_REFERRAL_CALLBACK = extern struct {
    SizeOfCallbacks: u32,
    QueryForConnection: ?QUERYFORCONNECTION,
    NotifyRoutine: ?NOTIFYOFNEWCONNECTION,
    DereferenceRoutine: ?DEREFERENCECONNECTION,
};

pub const QUERYCLIENTCERT = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        Connection: ?*ldap,
        trusted_CAs: ?*SecPkgContext_IssuerListInfoEx,
        ppCertificate: ?*?*CERT_CONTEXT,
    ) callconv(@import("std").os.windows.WINAPI) BOOLEAN,
    else => *const fn (
        Connection: ?*ldap,
        trusted_CAs: ?*SecPkgContext_IssuerListInfoEx,
        ppCertificate: ?*?*CERT_CONTEXT,
    ) callconv(@import("std").os.windows.WINAPI) BOOLEAN,
};

pub const VERIFYSERVERCERT = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        Connection: ?*ldap,
        pServerCert: ?*?*CERT_CONTEXT,
    ) callconv(@import("std").os.windows.WINAPI) BOOLEAN,
    else => *const fn (
        Connection: ?*ldap,
        pServerCert: ?*?*CERT_CONTEXT,
    ) callconv(@import("std").os.windows.WINAPI) BOOLEAN,
};

//--------------------------------------------------------------------------------
// Section: Functions (243)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_openW(
    HostName: ?[*:0]const u16,
    PortNumber: u32,
) callconv(@import("std").os.windows.WINAPI) ?*ldap;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_openA(
    HostName: ?[*:0]const u8,
    PortNumber: u32,
) callconv(@import("std").os.windows.WINAPI) ?*ldap;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_initW(
    HostName: ?[*:0]const u16,
    PortNumber: u32,
) callconv(@import("std").os.windows.WINAPI) ?*ldap;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_initA(
    HostName: ?[*:0]const u8,
    PortNumber: u32,
) callconv(@import("std").os.windows.WINAPI) ?*ldap;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_sslinitW(
    HostName: ?PWSTR,
    PortNumber: u32,
    secure: i32,
) callconv(@import("std").os.windows.WINAPI) ?*ldap;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_sslinitA(
    HostName: ?PSTR,
    PortNumber: u32,
    secure: i32,
) callconv(@import("std").os.windows.WINAPI) ?*ldap;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_connect(
    ld: ?*ldap,
    timeout: ?*LDAP_TIMEVAL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_open(
    HostName: ?PSTR,
    PortNumber: u32,
) callconv(@import("std").os.windows.WINAPI) ?*ldap;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_init(
    HostName: ?PSTR,
    PortNumber: u32,
) callconv(@import("std").os.windows.WINAPI) ?*ldap;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_sslinit(
    HostName: ?PSTR,
    PortNumber: u32,
    secure: i32,
) callconv(@import("std").os.windows.WINAPI) ?*ldap;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn cldap_openW(
    HostName: ?PWSTR,
    PortNumber: u32,
) callconv(@import("std").os.windows.WINAPI) ?*ldap;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn cldap_openA(
    HostName: ?PSTR,
    PortNumber: u32,
) callconv(@import("std").os.windows.WINAPI) ?*ldap;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn cldap_open(
    HostName: ?PSTR,
    PortNumber: u32,
) callconv(@import("std").os.windows.WINAPI) ?*ldap;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_unbind(
    ld: ?*ldap,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_unbind_s(
    ld: ?*ldap,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_get_option(
    ld: ?*ldap,
    option: i32,
    outvalue: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_get_optionW(
    ld: ?*ldap,
    option: i32,
    outvalue: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_set_option(
    ld: ?*ldap,
    option: i32,
    invalue: ?*const anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_set_optionW(
    ld: ?*ldap,
    option: i32,
    invalue: ?*const anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_simple_bindW(
    ld: ?*ldap,
    dn: ?PWSTR,
    passwd: ?PWSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_simple_bindA(
    ld: ?*ldap,
    dn: ?PSTR,
    passwd: ?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_simple_bind_sW(
    ld: ?*ldap,
    dn: ?PWSTR,
    passwd: ?PWSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_simple_bind_sA(
    ld: ?*ldap,
    dn: ?PSTR,
    passwd: ?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_bindW(
    ld: ?*ldap,
    dn: ?PWSTR,
    cred: ?[*]u16,
    method: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_bindA(
    ld: ?*ldap,
    dn: ?PSTR,
    cred: ?[*]u8,
    method: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_bind_sW(
    ld: ?*ldap,
    dn: ?PWSTR,
    cred: ?[*]u16,
    method: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_bind_sA(
    ld: ?*ldap,
    dn: ?PSTR,
    cred: ?[*]u8,
    method: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_sasl_bindA(
    ExternalHandle: ?*ldap,
    DistName: ?[*:0]const u8,
    AuthMechanism: ?[*:0]const u8,
    cred: ?*const LDAP_BERVAL,
    ServerCtrls: ?*?*ldapcontrolA,
    ClientCtrls: ?*?*ldapcontrolA,
    MessageNumber: ?*i32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_sasl_bindW(
    ExternalHandle: ?*ldap,
    DistName: ?[*:0]const u16,
    AuthMechanism: ?[*:0]const u16,
    cred: ?*const LDAP_BERVAL,
    ServerCtrls: ?*?*ldapcontrolW,
    ClientCtrls: ?*?*ldapcontrolW,
    MessageNumber: ?*i32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_sasl_bind_sA(
    ExternalHandle: ?*ldap,
    DistName: ?[*:0]const u8,
    AuthMechanism: ?[*:0]const u8,
    cred: ?*const LDAP_BERVAL,
    ServerCtrls: ?*?*ldapcontrolA,
    ClientCtrls: ?*?*ldapcontrolA,
    ServerData: ?*?*LDAP_BERVAL,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_sasl_bind_sW(
    ExternalHandle: ?*ldap,
    DistName: ?[*:0]const u16,
    AuthMechanism: ?[*:0]const u16,
    cred: ?*const LDAP_BERVAL,
    ServerCtrls: ?*?*ldapcontrolW,
    ClientCtrls: ?*?*ldapcontrolW,
    ServerData: ?*?*LDAP_BERVAL,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_simple_bind(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    passwd: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_simple_bind_s(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    passwd: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_bind(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    cred: ?[*:0]const u8,
    method: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_bind_s(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    cred: ?[*:0]const u8,
    method: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_searchW(
    ld: ?*ldap,
    base: ?[*:0]const u16,
    scope: u32,
    filter: ?[*:0]const u16,
    attrs: ?*?*u16,
    attrsonly: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_searchA(
    ld: ?*ldap,
    base: ?[*:0]const u8,
    scope: u32,
    filter: ?[*:0]const u8,
    attrs: ?*?*i8,
    attrsonly: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search_sW(
    ld: ?*ldap,
    base: ?[*:0]const u16,
    scope: u32,
    filter: ?[*:0]const u16,
    attrs: ?*?*u16,
    attrsonly: u32,
    res: ?*?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search_sA(
    ld: ?*ldap,
    base: ?[*:0]const u8,
    scope: u32,
    filter: ?[*:0]const u8,
    attrs: ?*?*i8,
    attrsonly: u32,
    res: ?*?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search_stW(
    ld: ?*ldap,
    base: ?[*:0]const u16,
    scope: u32,
    filter: ?[*:0]const u16,
    attrs: ?*?*u16,
    attrsonly: u32,
    timeout: ?*LDAP_TIMEVAL,
    res: ?*?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search_stA(
    ld: ?*ldap,
    base: ?[*:0]const u8,
    scope: u32,
    filter: ?[*:0]const u8,
    attrs: ?*?*i8,
    attrsonly: u32,
    timeout: ?*LDAP_TIMEVAL,
    res: ?*?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search_extW(
    ld: ?*ldap,
    base: ?[*:0]const u16,
    scope: u32,
    filter: ?[*:0]const u16,
    attrs: ?*?*u16,
    attrsonly: u32,
    ServerControls: ?*?*ldapcontrolW,
    ClientControls: ?*?*ldapcontrolW,
    TimeLimit: u32,
    SizeLimit: u32,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search_extA(
    ld: ?*ldap,
    base: ?[*:0]const u8,
    scope: u32,
    filter: ?[*:0]const u8,
    attrs: ?*?*i8,
    attrsonly: u32,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    TimeLimit: u32,
    SizeLimit: u32,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search_ext_sW(
    ld: ?*ldap,
    base: ?[*:0]const u16,
    scope: u32,
    filter: ?[*:0]const u16,
    attrs: ?*?*u16,
    attrsonly: u32,
    ServerControls: ?*?*ldapcontrolW,
    ClientControls: ?*?*ldapcontrolW,
    timeout: ?*LDAP_TIMEVAL,
    SizeLimit: u32,
    res: ?*?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search_ext_sA(
    ld: ?*ldap,
    base: ?[*:0]const u8,
    scope: u32,
    filter: ?[*:0]const u8,
    attrs: ?*?*i8,
    attrsonly: u32,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    timeout: ?*LDAP_TIMEVAL,
    SizeLimit: u32,
    res: ?*?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search(
    ld: ?*ldap,
    base: ?PSTR,
    scope: u32,
    filter: ?PSTR,
    attrs: ?*?*i8,
    attrsonly: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search_s(
    ld: ?*ldap,
    base: ?PSTR,
    scope: u32,
    filter: ?PSTR,
    attrs: ?*?*i8,
    attrsonly: u32,
    res: ?*?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search_st(
    ld: ?*ldap,
    base: ?PSTR,
    scope: u32,
    filter: ?PSTR,
    attrs: ?*?*i8,
    attrsonly: u32,
    timeout: ?*LDAP_TIMEVAL,
    res: ?*?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search_ext(
    ld: ?*ldap,
    base: ?PSTR,
    scope: u32,
    filter: ?PSTR,
    attrs: ?*?*i8,
    attrsonly: u32,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    TimeLimit: u32,
    SizeLimit: u32,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search_ext_s(
    ld: ?*ldap,
    base: ?PSTR,
    scope: u32,
    filter: ?PSTR,
    attrs: ?*?*i8,
    attrsonly: u32,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    timeout: ?*LDAP_TIMEVAL,
    SizeLimit: u32,
    res: ?*?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_check_filterW(
    ld: ?*ldap,
    SearchFilter: ?PWSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_check_filterA(
    ld: ?*ldap,
    SearchFilter: ?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modifyW(
    ld: ?*ldap,
    dn: ?PWSTR,
    mods: ?*?*ldapmodW,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modifyA(
    ld: ?*ldap,
    dn: ?PSTR,
    mods: ?*?*ldapmodA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modify_sW(
    ld: ?*ldap,
    dn: ?PWSTR,
    mods: ?*?*ldapmodW,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modify_sA(
    ld: ?*ldap,
    dn: ?PSTR,
    mods: ?*?*ldapmodA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modify_extW(
    ld: ?*ldap,
    dn: ?[*:0]const u16,
    mods: ?*?*ldapmodW,
    ServerControls: ?*?*ldapcontrolW,
    ClientControls: ?*?*ldapcontrolW,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modify_extA(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    mods: ?*?*ldapmodA,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modify_ext_sW(
    ld: ?*ldap,
    dn: ?[*:0]const u16,
    mods: ?*?*ldapmodW,
    ServerControls: ?*?*ldapcontrolW,
    ClientControls: ?*?*ldapcontrolW,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modify_ext_sA(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    mods: ?*?*ldapmodA,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modify(
    ld: ?*ldap,
    dn: ?PSTR,
    mods: ?*?*ldapmodA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modify_s(
    ld: ?*ldap,
    dn: ?PSTR,
    mods: ?*?*ldapmodA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modify_ext(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    mods: ?*?*ldapmodA,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modify_ext_s(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    mods: ?*?*ldapmodA,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modrdn2W(
    ExternalHandle: ?*ldap,
    DistinguishedName: ?[*:0]const u16,
    NewDistinguishedName: ?[*:0]const u16,
    DeleteOldRdn: i32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modrdn2A(
    ExternalHandle: ?*ldap,
    DistinguishedName: ?[*:0]const u8,
    NewDistinguishedName: ?[*:0]const u8,
    DeleteOldRdn: i32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modrdnW(
    ExternalHandle: ?*ldap,
    DistinguishedName: ?[*:0]const u16,
    NewDistinguishedName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modrdnA(
    ExternalHandle: ?*ldap,
    DistinguishedName: ?[*:0]const u8,
    NewDistinguishedName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modrdn2_sW(
    ExternalHandle: ?*ldap,
    DistinguishedName: ?[*:0]const u16,
    NewDistinguishedName: ?[*:0]const u16,
    DeleteOldRdn: i32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modrdn2_sA(
    ExternalHandle: ?*ldap,
    DistinguishedName: ?[*:0]const u8,
    NewDistinguishedName: ?[*:0]const u8,
    DeleteOldRdn: i32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modrdn_sW(
    ExternalHandle: ?*ldap,
    DistinguishedName: ?[*:0]const u16,
    NewDistinguishedName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modrdn_sA(
    ExternalHandle: ?*ldap,
    DistinguishedName: ?[*:0]const u8,
    NewDistinguishedName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modrdn2(
    ExternalHandle: ?*ldap,
    DistinguishedName: ?[*:0]const u8,
    NewDistinguishedName: ?[*:0]const u8,
    DeleteOldRdn: i32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modrdn(
    ExternalHandle: ?*ldap,
    DistinguishedName: ?[*:0]const u8,
    NewDistinguishedName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modrdn2_s(
    ExternalHandle: ?*ldap,
    DistinguishedName: ?[*:0]const u8,
    NewDistinguishedName: ?[*:0]const u8,
    DeleteOldRdn: i32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_modrdn_s(
    ExternalHandle: ?*ldap,
    DistinguishedName: ?[*:0]const u8,
    NewDistinguishedName: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_rename_extW(
    ld: ?*ldap,
    dn: ?[*:0]const u16,
    NewRDN: ?[*:0]const u16,
    NewParent: ?[*:0]const u16,
    DeleteOldRdn: i32,
    ServerControls: ?*?*ldapcontrolW,
    ClientControls: ?*?*ldapcontrolW,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_rename_extA(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    NewRDN: ?[*:0]const u8,
    NewParent: ?[*:0]const u8,
    DeleteOldRdn: i32,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_rename_ext_sW(
    ld: ?*ldap,
    dn: ?[*:0]const u16,
    NewRDN: ?[*:0]const u16,
    NewParent: ?[*:0]const u16,
    DeleteOldRdn: i32,
    ServerControls: ?*?*ldapcontrolW,
    ClientControls: ?*?*ldapcontrolW,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_rename_ext_sA(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    NewRDN: ?[*:0]const u8,
    NewParent: ?[*:0]const u8,
    DeleteOldRdn: i32,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_rename_ext(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    NewRDN: ?[*:0]const u8,
    NewParent: ?[*:0]const u8,
    DeleteOldRdn: i32,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_rename_ext_s(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    NewRDN: ?[*:0]const u8,
    NewParent: ?[*:0]const u8,
    DeleteOldRdn: i32,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_addW(
    ld: ?*ldap,
    dn: ?PWSTR,
    attrs: ?*?*ldapmodW,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_addA(
    ld: ?*ldap,
    dn: ?PSTR,
    attrs: ?*?*ldapmodA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_add_sW(
    ld: ?*ldap,
    dn: ?PWSTR,
    attrs: ?*?*ldapmodW,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_add_sA(
    ld: ?*ldap,
    dn: ?PSTR,
    attrs: ?*?*ldapmodA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_add_extW(
    ld: ?*ldap,
    dn: ?[*:0]const u16,
    attrs: ?*?*ldapmodW,
    ServerControls: ?*?*ldapcontrolW,
    ClientControls: ?*?*ldapcontrolW,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_add_extA(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    attrs: ?*?*ldapmodA,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_add_ext_sW(
    ld: ?*ldap,
    dn: ?[*:0]const u16,
    attrs: ?*?*ldapmodW,
    ServerControls: ?*?*ldapcontrolW,
    ClientControls: ?*?*ldapcontrolW,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_add_ext_sA(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    attrs: ?*?*ldapmodA,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_add(
    ld: ?*ldap,
    dn: ?PSTR,
    attrs: ?*?*ldapmodA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_add_s(
    ld: ?*ldap,
    dn: ?PSTR,
    attrs: ?*?*ldapmodA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_add_ext(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    attrs: ?*?*ldapmodA,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_add_ext_s(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    attrs: ?*?*ldapmodA,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_compareW(
    ld: ?*ldap,
    dn: ?[*:0]const u16,
    attr: ?[*:0]const u16,
    value: ?PWSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_compareA(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    attr: ?[*:0]const u8,
    value: ?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_compare_sW(
    ld: ?*ldap,
    dn: ?[*:0]const u16,
    attr: ?[*:0]const u16,
    value: ?PWSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_compare_sA(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    attr: ?[*:0]const u8,
    value: ?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_compare(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    attr: ?[*:0]const u8,
    value: ?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_compare_s(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    attr: ?[*:0]const u8,
    value: ?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_compare_extW(
    ld: ?*ldap,
    dn: ?[*:0]const u16,
    Attr: ?[*:0]const u16,
    Value: ?[*:0]const u16,
    Data: ?*LDAP_BERVAL,
    ServerControls: ?*?*ldapcontrolW,
    ClientControls: ?*?*ldapcontrolW,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_compare_extA(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    Attr: ?[*:0]const u8,
    Value: ?[*:0]const u8,
    Data: ?*LDAP_BERVAL,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_compare_ext_sW(
    ld: ?*ldap,
    dn: ?[*:0]const u16,
    Attr: ?[*:0]const u16,
    Value: ?[*:0]const u16,
    Data: ?*LDAP_BERVAL,
    ServerControls: ?*?*ldapcontrolW,
    ClientControls: ?*?*ldapcontrolW,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_compare_ext_sA(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    Attr: ?[*:0]const u8,
    Value: ?[*:0]const u8,
    Data: ?*LDAP_BERVAL,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_compare_ext(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    Attr: ?[*:0]const u8,
    Value: ?[*:0]const u8,
    Data: ?*LDAP_BERVAL,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_compare_ext_s(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    Attr: ?[*:0]const u8,
    Value: ?[*:0]const u8,
    Data: ?*LDAP_BERVAL,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_deleteW(
    ld: ?*ldap,
    dn: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_deleteA(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_delete_sW(
    ld: ?*ldap,
    dn: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_delete_sA(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_delete_extW(
    ld: ?*ldap,
    dn: ?[*:0]const u16,
    ServerControls: ?*?*ldapcontrolW,
    ClientControls: ?*?*ldapcontrolW,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_delete_extA(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_delete_ext_sW(
    ld: ?*ldap,
    dn: ?[*:0]const u16,
    ServerControls: ?*?*ldapcontrolW,
    ClientControls: ?*?*ldapcontrolW,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_delete_ext_sA(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_delete(
    ld: ?*ldap,
    dn: ?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_delete_s(
    ld: ?*ldap,
    dn: ?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_delete_ext(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_delete_ext_s(
    ld: ?*ldap,
    dn: ?[*:0]const u8,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_abandon(
    ld: ?*ldap,
    msgid: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_result(
    ld: ?*ldap,
    msgid: u32,
    all: u32,
    timeout: ?*LDAP_TIMEVAL,
    res: ?*?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_msgfree(
    res: ?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_result2error(
    ld: ?*ldap,
    res: ?*LDAPMessage,
    freeit: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_parse_resultW(
    Connection: ?*ldap,
    ResultMessage: ?*LDAPMessage,
    ReturnCode: ?*u32,
    MatchedDNs: ?*?PWSTR,
    ErrorMessage: ?*?PWSTR,
    Referrals: ?*?*?*u16,
    ServerControls: ?*?*?*ldapcontrolW,
    Freeit: BOOLEAN,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_parse_resultA(
    Connection: ?*ldap,
    ResultMessage: ?*LDAPMessage,
    ReturnCode: ?*u32,
    MatchedDNs: ?*?PSTR,
    ErrorMessage: ?*?PSTR,
    Referrals: ?*?*?*i8,
    ServerControls: ?*?*?*ldapcontrolA,
    Freeit: BOOLEAN,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_parse_extended_resultA(
    Connection: ?*ldap,
    ResultMessage: ?*LDAPMessage,
    ResultOID: ?*?PSTR,
    ResultData: ?*?*LDAP_BERVAL,
    Freeit: BOOLEAN,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_parse_extended_resultW(
    Connection: ?*ldap,
    ResultMessage: ?*LDAPMessage,
    ResultOID: ?*?PWSTR,
    ResultData: ?*?*LDAP_BERVAL,
    Freeit: BOOLEAN,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_controls_freeA(
    Controls: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_control_freeA(
    Controls: ?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_controls_freeW(
    Control: ?*?*ldapcontrolW,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_control_freeW(
    Control: ?*ldapcontrolW,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_free_controlsW(
    Controls: ?*?*ldapcontrolW,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_free_controlsA(
    Controls: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_parse_result(
    Connection: ?*ldap,
    ResultMessage: ?*LDAPMessage,
    ReturnCode: ?*u32,
    MatchedDNs: ?*?PSTR,
    ErrorMessage: ?*?PSTR,
    Referrals: ?*?*?PSTR,
    ServerControls: ?*?*?*ldapcontrolA,
    Freeit: BOOLEAN,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_controls_free(
    Controls: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_control_free(
    Control: ?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_free_controls(
    Controls: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_err2stringW(
    err: u32,
) callconv(@import("std").os.windows.WINAPI) ?PWSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_err2stringA(
    err: u32,
) callconv(@import("std").os.windows.WINAPI) ?PSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_err2string(
    err: u32,
) callconv(@import("std").os.windows.WINAPI) ?PSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_perror(
    ld: ?*ldap,
    msg: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_first_entry(
    ld: ?*ldap,
    res: ?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) ?*LDAPMessage;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_next_entry(
    ld: ?*ldap,
    entry: ?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) ?*LDAPMessage;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_count_entries(
    ld: ?*ldap,
    res: ?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_first_attributeW(
    ld: ?*ldap,
    entry: ?*LDAPMessage,
    ptr: ?*?*berelement,
) callconv(@import("std").os.windows.WINAPI) ?PWSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_first_attributeA(
    ld: ?*ldap,
    entry: ?*LDAPMessage,
    ptr: ?*?*berelement,
) callconv(@import("std").os.windows.WINAPI) ?PSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_first_attribute(
    ld: ?*ldap,
    entry: ?*LDAPMessage,
    ptr: ?*?*berelement,
) callconv(@import("std").os.windows.WINAPI) ?PSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_next_attributeW(
    ld: ?*ldap,
    entry: ?*LDAPMessage,
    ptr: ?*berelement,
) callconv(@import("std").os.windows.WINAPI) ?PWSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_next_attributeA(
    ld: ?*ldap,
    entry: ?*LDAPMessage,
    ptr: ?*berelement,
) callconv(@import("std").os.windows.WINAPI) ?PSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_next_attribute(
    ld: ?*ldap,
    entry: ?*LDAPMessage,
    ptr: ?*berelement,
) callconv(@import("std").os.windows.WINAPI) ?PSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_get_valuesW(
    ld: ?*ldap,
    entry: ?*LDAPMessage,
    attr: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?*?PWSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_get_valuesA(
    ld: ?*ldap,
    entry: ?*LDAPMessage,
    attr: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) ?*?PSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_get_values(
    ld: ?*ldap,
    entry: ?*LDAPMessage,
    attr: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) ?*?PSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_get_values_lenW(
    ExternalHandle: ?*ldap,
    Message: ?*LDAPMessage,
    attr: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?*?*LDAP_BERVAL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_get_values_lenA(
    ExternalHandle: ?*ldap,
    Message: ?*LDAPMessage,
    attr: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) ?*?*LDAP_BERVAL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_get_values_len(
    ExternalHandle: ?*ldap,
    Message: ?*LDAPMessage,
    attr: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) ?*?*LDAP_BERVAL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_count_valuesW(
    vals: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_count_valuesA(
    vals: ?*?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_count_values(
    vals: ?*?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_count_values_len(
    vals: ?*?*LDAP_BERVAL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_value_freeW(
    vals: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_value_freeA(
    vals: ?*?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_value_free(
    vals: ?*?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_value_free_len(
    vals: ?*?*LDAP_BERVAL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_get_dnW(
    ld: ?*ldap,
    entry: ?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) ?PWSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_get_dnA(
    ld: ?*ldap,
    entry: ?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) ?PSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_get_dn(
    ld: ?*ldap,
    entry: ?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) ?PSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_explode_dnW(
    dn: ?[*:0]const u16,
    notypes: u32,
) callconv(@import("std").os.windows.WINAPI) ?*?PWSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_explode_dnA(
    dn: ?[*:0]const u8,
    notypes: u32,
) callconv(@import("std").os.windows.WINAPI) ?*?PSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_explode_dn(
    dn: ?[*:0]const u8,
    notypes: u32,
) callconv(@import("std").os.windows.WINAPI) ?*?PSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_dn2ufnW(
    dn: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) ?PWSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_dn2ufnA(
    dn: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) ?PSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_dn2ufn(
    dn: ?[*:0]const u8,
) callconv(@import("std").os.windows.WINAPI) ?PSTR;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_memfreeW(
    Block: ?[*]u16,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_memfreeA(
    Block: ?[*]u8,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ber_bvfree(
    bv: ?*LDAP_BERVAL,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_memfree(
    Block: ?[*]u8,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_ufn2dnW(
    ufn: ?[*:0]const u16,
    pDn: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_ufn2dnA(
    ufn: ?[*:0]const u8,
    pDn: ?*?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_ufn2dn(
    ufn: ?[*:0]const u8,
    pDn: ?*?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "wldap32" fn ldap_startup(
    version: ?*ldap_version_info,
    Instance: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_cleanup(
    hInstance: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_escape_filter_elementW(
    // TODO: what to do with BytesParamIndex 1?
    sourceFilterElement: ?[*]u8,
    sourceLength: u32,
    // TODO: what to do with BytesParamIndex 3?
    destFilterElement: ?[*]u16,
    destLength: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_escape_filter_elementA(
    // TODO: what to do with BytesParamIndex 1?
    sourceFilterElement: ?[*]u8,
    sourceLength: u32,
    // TODO: what to do with BytesParamIndex 3?
    destFilterElement: ?[*]u8,
    destLength: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_escape_filter_element(
    // TODO: what to do with BytesParamIndex 1?
    sourceFilterElement: ?[*]u8,
    sourceLength: u32,
    // TODO: what to do with BytesParamIndex 3?
    destFilterElement: ?[*]u8,
    destLength: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "wldap32" fn ldap_set_dbg_flags(
    NewFlags: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "wldap32" fn ldap_set_dbg_routine(
    DebugPrintRoutine: ?DBGPRINT,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn LdapUTF8ToUnicode(
    lpSrcStr: [*:0]const u8,
    cchSrc: i32,
    lpDestStr: [*:0]u16,
    cchDest: i32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn LdapUnicodeToUTF8(
    lpSrcStr: [*:0]const u16,
    cchSrc: i32,
    lpDestStr: [*:0]u8,
    cchDest: i32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_create_sort_controlA(
    ExternalHandle: ?*ldap,
    SortKeys: ?*?*ldapsortkeyA,
    IsCritical: u8,
    Control: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_create_sort_controlW(
    ExternalHandle: ?*ldap,
    SortKeys: ?*?*ldapsortkeyW,
    IsCritical: u8,
    Control: ?*?*ldapcontrolW,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_parse_sort_controlA(
    ExternalHandle: ?*ldap,
    Control: ?*?*ldapcontrolA,
    Result: ?*u32,
    Attribute: ?*?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_parse_sort_controlW(
    ExternalHandle: ?*ldap,
    Control: ?*?*ldapcontrolW,
    Result: ?*u32,
    Attribute: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_create_sort_control(
    ExternalHandle: ?*ldap,
    SortKeys: ?*?*ldapsortkeyA,
    IsCritical: u8,
    Control: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_parse_sort_control(
    ExternalHandle: ?*ldap,
    Control: ?*?*ldapcontrolA,
    Result: ?*u32,
    Attribute: ?*?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_encode_sort_controlW(
    ExternalHandle: ?*ldap,
    SortKeys: ?*?*ldapsortkeyW,
    Control: ?*ldapcontrolW,
    Criticality: BOOLEAN,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_encode_sort_controlA(
    ExternalHandle: ?*ldap,
    SortKeys: ?*?*ldapsortkeyA,
    Control: ?*ldapcontrolA,
    Criticality: BOOLEAN,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_create_page_controlW(
    ExternalHandle: ?*ldap,
    PageSize: u32,
    Cookie: ?*LDAP_BERVAL,
    IsCritical: u8,
    Control: ?*?*ldapcontrolW,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_create_page_controlA(
    ExternalHandle: ?*ldap,
    PageSize: u32,
    Cookie: ?*LDAP_BERVAL,
    IsCritical: u8,
    Control: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_parse_page_controlW(
    ExternalHandle: ?*ldap,
    ServerControls: ?*?*ldapcontrolW,
    TotalCount: ?*u32,
    Cookie: ?*?*LDAP_BERVAL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_parse_page_controlA(
    ExternalHandle: ?*ldap,
    ServerControls: ?*?*ldapcontrolA,
    TotalCount: ?*u32,
    Cookie: ?*?*LDAP_BERVAL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_create_page_control(
    ExternalHandle: ?*ldap,
    PageSize: u32,
    Cookie: ?*LDAP_BERVAL,
    IsCritical: u8,
    Control: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_parse_page_control(
    ExternalHandle: ?*ldap,
    ServerControls: ?*?*ldapcontrolA,
    TotalCount: ?*u32,
    Cookie: ?*?*LDAP_BERVAL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search_init_pageW(
    ExternalHandle: ?*ldap,
    DistinguishedName: ?[*:0]const u16,
    ScopeOfSearch: u32,
    SearchFilter: ?[*:0]const u16,
    AttributeList: ?*?*u16,
    AttributesOnly: u32,
    ServerControls: ?*?*ldapcontrolW,
    ClientControls: ?*?*ldapcontrolW,
    PageTimeLimit: u32,
    TotalSizeLimit: u32,
    SortKeys: ?*?*ldapsortkeyW,
) callconv(@import("std").os.windows.WINAPI) ?*ldapsearch;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search_init_pageA(
    ExternalHandle: ?*ldap,
    DistinguishedName: ?[*:0]const u8,
    ScopeOfSearch: u32,
    SearchFilter: ?[*:0]const u8,
    AttributeList: ?*?*i8,
    AttributesOnly: u32,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    PageTimeLimit: u32,
    TotalSizeLimit: u32,
    SortKeys: ?*?*ldapsortkeyA,
) callconv(@import("std").os.windows.WINAPI) ?*ldapsearch;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search_init_page(
    ExternalHandle: ?*ldap,
    DistinguishedName: ?[*:0]const u8,
    ScopeOfSearch: u32,
    SearchFilter: ?[*:0]const u8,
    AttributeList: ?*?*i8,
    AttributesOnly: u32,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    PageTimeLimit: u32,
    TotalSizeLimit: u32,
    SortKeys: ?*?*ldapsortkeyA,
) callconv(@import("std").os.windows.WINAPI) ?*ldapsearch;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_get_next_page(
    ExternalHandle: ?*ldap,
    SearchHandle: ?*ldapsearch,
    PageSize: u32,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_get_next_page_s(
    ExternalHandle: ?*ldap,
    SearchHandle: ?*ldapsearch,
    timeout: ?*LDAP_TIMEVAL,
    PageSize: u32,
    TotalCount: ?*u32,
    Results: ?*?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_get_paged_count(
    ExternalHandle: ?*ldap,
    SearchBlock: ?*ldapsearch,
    TotalCount: ?*u32,
    Results: ?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_search_abandon_page(
    ExternalHandle: ?*ldap,
    SearchBlock: ?*ldapsearch,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_create_vlv_controlW(
    ExternalHandle: ?*ldap,
    VlvInfo: ?*ldapvlvinfo,
    IsCritical: u8,
    Control: ?*?*ldapcontrolW,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_create_vlv_controlA(
    ExternalHandle: ?*ldap,
    VlvInfo: ?*ldapvlvinfo,
    IsCritical: u8,
    Control: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_parse_vlv_controlW(
    ExternalHandle: ?*ldap,
    Control: ?*?*ldapcontrolW,
    TargetPos: ?*u32,
    ListCount: ?*u32,
    Context: ?*?*LDAP_BERVAL,
    ErrCode: ?*i32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_parse_vlv_controlA(
    ExternalHandle: ?*ldap,
    Control: ?*?*ldapcontrolA,
    TargetPos: ?*u32,
    ListCount: ?*u32,
    Context: ?*?*LDAP_BERVAL,
    ErrCode: ?*i32,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_start_tls_sW(
    ExternalHandle: ?*ldap,
    ServerReturnValue: ?*u32,
    result: ?*?*LDAPMessage,
    ServerControls: ?*?*ldapcontrolW,
    ClientControls: ?*?*ldapcontrolW,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_start_tls_sA(
    ExternalHandle: ?*ldap,
    ServerReturnValue: ?*u32,
    result: ?*?*LDAPMessage,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_stop_tls_s(
    ExternalHandle: ?*ldap,
) callconv(@import("std").os.windows.WINAPI) BOOLEAN;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_first_reference(
    ld: ?*ldap,
    res: ?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) ?*LDAPMessage;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_next_reference(
    ld: ?*ldap,
    entry: ?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) ?*LDAPMessage;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_count_references(
    ld: ?*ldap,
    res: ?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_parse_referenceW(
    Connection: ?*ldap,
    ResultMessage: ?*LDAPMessage,
    Referrals: ?*?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_parse_referenceA(
    Connection: ?*ldap,
    ResultMessage: ?*LDAPMessage,
    Referrals: ?*?*?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_parse_reference(
    Connection: ?*ldap,
    ResultMessage: ?*LDAPMessage,
    Referrals: ?*?*?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_extended_operationW(
    ld: ?*ldap,
    Oid: ?[*:0]const u16,
    Data: ?*LDAP_BERVAL,
    ServerControls: ?*?*ldapcontrolW,
    ClientControls: ?*?*ldapcontrolW,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_extended_operationA(
    ld: ?*ldap,
    Oid: ?[*:0]const u8,
    Data: ?*LDAP_BERVAL,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_extended_operation_sA(
    ExternalHandle: ?*ldap,
    Oid: ?PSTR,
    Data: ?*LDAP_BERVAL,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    ReturnedOid: ?*?PSTR,
    ReturnedData: ?*?*LDAP_BERVAL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_extended_operation_sW(
    ExternalHandle: ?*ldap,
    Oid: ?PWSTR,
    Data: ?*LDAP_BERVAL,
    ServerControls: ?*?*ldapcontrolW,
    ClientControls: ?*?*ldapcontrolW,
    ReturnedOid: ?*?PWSTR,
    ReturnedData: ?*?*LDAP_BERVAL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_extended_operation(
    ld: ?*ldap,
    Oid: ?[*:0]const u8,
    Data: ?*LDAP_BERVAL,
    ServerControls: ?*?*ldapcontrolA,
    ClientControls: ?*?*ldapcontrolA,
    MessageNumber: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_close_extended_op(
    ld: ?*ldap,
    MessageNumber: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn LdapGetLastError() callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn LdapMapErrorToWin32(
    LdapError: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ldap_conn_from_msg(
    PrimaryConn: ?*ldap,
    res: ?*LDAPMessage,
) callconv(@import("std").os.windows.WINAPI) ?*ldap;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ber_init(
    pBerVal: ?*LDAP_BERVAL,
) callconv(@import("std").os.windows.WINAPI) ?*berelement;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ber_free(
    pBerElement: ?*berelement,
    fbuf: i32,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ber_bvecfree(
    pBerVal: ?*?*LDAP_BERVAL,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ber_bvdup(
    pBerVal: ?*LDAP_BERVAL,
) callconv(@import("std").os.windows.WINAPI) ?*LDAP_BERVAL;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ber_alloc_t(
    options: i32,
) callconv(@import("std").os.windows.WINAPI) ?*berelement;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ber_skip_tag(
    pBerElement: ?*berelement,
    pLen: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ber_peek_tag(
    pBerElement: ?*berelement,
    pLen: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ber_first_element(
    pBerElement: ?*berelement,
    pLen: ?*u32,
    ppOpaque: ?*?*CHAR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ber_next_element(
    pBerElement: ?*berelement,
    pLen: ?*u32,
    @"opaque": ?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ber_flatten(
    pBerElement: ?*berelement,
    pBerVal: ?*?*LDAP_BERVAL,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ber_printf(
    pBerElement: ?*berelement,
    fmt: ?PSTR,
) callconv(@import("std").os.windows.WINAPI) i32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wldap32" fn ber_scanf(
    pBerElement: ?*berelement,
    fmt: ?PSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (14)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {
        pub const ldapcontrol = thismodule.ldapcontrolA;
        pub const ldapmod = thismodule.ldapmodA;
        pub const ldapapiinfo = thismodule.ldapapiinfoA;
        pub const LDAPAPIFeatureInfo = thismodule.LDAPAPIFeatureInfoA;
        pub const ldapsortkey = thismodule.ldapsortkeyA;
        pub const ldap_sasl_bind = thismodule.ldap_sasl_bindA;
        pub const ldap_sasl_bind_s = thismodule.ldap_sasl_bind_sA;
        pub const ldap_check_filter = thismodule.ldap_check_filterA;
        pub const ldap_parse_extended_result = thismodule.ldap_parse_extended_resultA;
        pub const ldap_encode_sort_control = thismodule.ldap_encode_sort_controlA;
        pub const ldap_create_vlv_control = thismodule.ldap_create_vlv_controlA;
        pub const ldap_parse_vlv_control = thismodule.ldap_parse_vlv_controlA;
        pub const ldap_start_tls_s = thismodule.ldap_start_tls_sA;
        pub const ldap_extended_operation_s = thismodule.ldap_extended_operation_sA;
    },
    .wide => struct {
        pub const ldapcontrol = thismodule.ldapcontrolW;
        pub const ldapmod = thismodule.ldapmodW;
        pub const ldapapiinfo = thismodule.ldapapiinfoW;
        pub const LDAPAPIFeatureInfo = thismodule.LDAPAPIFeatureInfoW;
        pub const ldapsortkey = thismodule.ldapsortkeyW;
        pub const ldap_sasl_bind = thismodule.ldap_sasl_bindW;
        pub const ldap_sasl_bind_s = thismodule.ldap_sasl_bind_sW;
        pub const ldap_check_filter = thismodule.ldap_check_filterW;
        pub const ldap_parse_extended_result = thismodule.ldap_parse_extended_resultW;
        pub const ldap_encode_sort_control = thismodule.ldap_encode_sort_controlW;
        pub const ldap_create_vlv_control = thismodule.ldap_create_vlv_controlW;
        pub const ldap_parse_vlv_control = thismodule.ldap_parse_vlv_controlW;
        pub const ldap_start_tls_s = thismodule.ldap_start_tls_sW;
        pub const ldap_extended_operation_s = thismodule.ldap_extended_operation_sW;
    },
    .unspecified => if (@import("builtin").is_test) struct {
        pub const ldapcontrol = *opaque {};
        pub const ldapmod = *opaque {};
        pub const ldapapiinfo = *opaque {};
        pub const LDAPAPIFeatureInfo = *opaque {};
        pub const ldapsortkey = *opaque {};
        pub const ldap_sasl_bind = *opaque {};
        pub const ldap_sasl_bind_s = *opaque {};
        pub const ldap_check_filter = *opaque {};
        pub const ldap_parse_extended_result = *opaque {};
        pub const ldap_encode_sort_control = *opaque {};
        pub const ldap_create_vlv_control = *opaque {};
        pub const ldap_parse_vlv_control = *opaque {};
        pub const ldap_start_tls_s = *opaque {};
        pub const ldap_extended_operation_s = *opaque {};
    } else struct {
        pub const ldapcontrol = @compileError("'ldapcontrol' requires that UNICODE be set to true or false in the root module");
        pub const ldapmod = @compileError("'ldapmod' requires that UNICODE be set to true or false in the root module");
        pub const ldapapiinfo = @compileError("'ldapapiinfo' requires that UNICODE be set to true or false in the root module");
        pub const LDAPAPIFeatureInfo = @compileError("'LDAPAPIFeatureInfo' requires that UNICODE be set to true or false in the root module");
        pub const ldapsortkey = @compileError("'ldapsortkey' requires that UNICODE be set to true or false in the root module");
        pub const ldap_sasl_bind = @compileError("'ldap_sasl_bind' requires that UNICODE be set to true or false in the root module");
        pub const ldap_sasl_bind_s = @compileError("'ldap_sasl_bind_s' requires that UNICODE be set to true or false in the root module");
        pub const ldap_check_filter = @compileError("'ldap_check_filter' requires that UNICODE be set to true or false in the root module");
        pub const ldap_parse_extended_result = @compileError("'ldap_parse_extended_result' requires that UNICODE be set to true or false in the root module");
        pub const ldap_encode_sort_control = @compileError("'ldap_encode_sort_control' requires that UNICODE be set to true or false in the root module");
        pub const ldap_create_vlv_control = @compileError("'ldap_create_vlv_control' requires that UNICODE be set to true or false in the root module");
        pub const ldap_parse_vlv_control = @compileError("'ldap_parse_vlv_control' requires that UNICODE be set to true or false in the root module");
        pub const ldap_start_tls_s = @compileError("'ldap_start_tls_s' requires that UNICODE be set to true or false in the root module");
        pub const ldap_extended_operation_s = @compileError("'ldap_extended_operation_s' requires that UNICODE be set to true or false in the root module");
    },
};
//--------------------------------------------------------------------------------
// Section: Imports (7)
//--------------------------------------------------------------------------------
const BOOLEAN = @import("../foundation.zig").BOOLEAN;
const CERT_CONTEXT = @import("../security/cryptography.zig").CERT_CONTEXT;
const CHAR = @import("../foundation.zig").CHAR;
const HANDLE = @import("../foundation.zig").HANDLE;
const PSTR = @import("../foundation.zig").PSTR;
const PWSTR = @import("../foundation.zig").PWSTR;
const SecPkgContext_IssuerListInfoEx = @import("../security/authentication/identity.zig").SecPkgContext_IssuerListInfoEx;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "DBGPRINT")) {
        _ = DBGPRINT;
    }
    if (@hasDecl(@This(), "QUERYFORCONNECTION")) {
        _ = QUERYFORCONNECTION;
    }
    if (@hasDecl(@This(), "NOTIFYOFNEWCONNECTION")) {
        _ = NOTIFYOFNEWCONNECTION;
    }
    if (@hasDecl(@This(), "DEREFERENCECONNECTION")) {
        _ = DEREFERENCECONNECTION;
    }
    if (@hasDecl(@This(), "QUERYCLIENTCERT")) {
        _ = QUERYCLIENTCERT;
    }
    if (@hasDecl(@This(), "VERIFYSERVERCERT")) {
        _ = VERIFYSERVERCERT;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
