//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (95)
//--------------------------------------------------------------------------------
pub const HTTP_DEMAND_CBT = @as(u32, 4);
pub const HTTP_MAX_SERVER_QUEUE_LENGTH = @as(u32, 2147483647);
pub const HTTP_MIN_SERVER_QUEUE_LENGTH = @as(u32, 1);
pub const HTTP_AUTH_ENABLE_BASIC = @as(u32, 1);
pub const HTTP_AUTH_ENABLE_DIGEST = @as(u32, 2);
pub const HTTP_AUTH_ENABLE_NTLM = @as(u32, 4);
pub const HTTP_AUTH_ENABLE_NEGOTIATE = @as(u32, 8);
pub const HTTP_AUTH_ENABLE_KERBEROS = @as(u32, 16);
pub const HTTP_AUTH_EX_FLAG_ENABLE_KERBEROS_CREDENTIAL_CACHING = @as(u32, 1);
pub const HTTP_AUTH_EX_FLAG_CAPTURE_CREDENTIAL = @as(u32, 2);
pub const HTTP_CHANNEL_BIND_PROXY = @as(u32, 1);
pub const HTTP_CHANNEL_BIND_PROXY_COHOSTING = @as(u32, 32);
pub const HTTP_CHANNEL_BIND_NO_SERVICE_NAME_CHECK = @as(u32, 2);
pub const HTTP_CHANNEL_BIND_DOTLESS_SERVICE = @as(u32, 4);
pub const HTTP_CHANNEL_BIND_SECURE_CHANNEL_TOKEN = @as(u32, 8);
pub const HTTP_CHANNEL_BIND_CLIENT_SERVICE = @as(u32, 16);
pub const HTTP_LOG_FIELD_DATE = @as(u32, 1);
pub const HTTP_LOG_FIELD_TIME = @as(u32, 2);
pub const HTTP_LOG_FIELD_CLIENT_IP = @as(u32, 4);
pub const HTTP_LOG_FIELD_USER_NAME = @as(u32, 8);
pub const HTTP_LOG_FIELD_SITE_NAME = @as(u32, 16);
pub const HTTP_LOG_FIELD_COMPUTER_NAME = @as(u32, 32);
pub const HTTP_LOG_FIELD_SERVER_IP = @as(u32, 64);
pub const HTTP_LOG_FIELD_METHOD = @as(u32, 128);
pub const HTTP_LOG_FIELD_URI_STEM = @as(u32, 256);
pub const HTTP_LOG_FIELD_URI_QUERY = @as(u32, 512);
pub const HTTP_LOG_FIELD_STATUS = @as(u32, 1024);
pub const HTTP_LOG_FIELD_WIN32_STATUS = @as(u32, 2048);
pub const HTTP_LOG_FIELD_BYTES_SENT = @as(u32, 4096);
pub const HTTP_LOG_FIELD_BYTES_RECV = @as(u32, 8192);
pub const HTTP_LOG_FIELD_TIME_TAKEN = @as(u32, 16384);
pub const HTTP_LOG_FIELD_SERVER_PORT = @as(u32, 32768);
pub const HTTP_LOG_FIELD_USER_AGENT = @as(u32, 65536);
pub const HTTP_LOG_FIELD_COOKIE = @as(u32, 131072);
pub const HTTP_LOG_FIELD_REFERER = @as(u32, 262144);
pub const HTTP_LOG_FIELD_VERSION = @as(u32, 524288);
pub const HTTP_LOG_FIELD_HOST = @as(u32, 1048576);
pub const HTTP_LOG_FIELD_SUB_STATUS = @as(u32, 2097152);
pub const HTTP_LOG_FIELD_STREAM_ID = @as(u32, 134217728);
pub const HTTP_LOG_FIELD_STREAM_ID_EX = @as(u32, 268435456);
pub const HTTP_LOG_FIELD_TRANSPORT_TYPE = @as(u32, 536870912);
pub const HTTP_LOG_FIELD_CLIENT_PORT = @as(u32, 4194304);
pub const HTTP_LOG_FIELD_URI = @as(u32, 8388608);
pub const HTTP_LOG_FIELD_SITE_ID = @as(u32, 16777216);
pub const HTTP_LOG_FIELD_REASON = @as(u32, 33554432);
pub const HTTP_LOG_FIELD_QUEUE_NAME = @as(u32, 67108864);
pub const HTTP_LOG_FIELD_CORRELATION_ID = @as(u32, 1073741824);
pub const HTTP_LOGGING_FLAG_LOCAL_TIME_ROLLOVER = @as(u32, 1);
pub const HTTP_LOGGING_FLAG_USE_UTF8_CONVERSION = @as(u32, 2);
pub const HTTP_LOGGING_FLAG_LOG_ERRORS_ONLY = @as(u32, 4);
pub const HTTP_LOGGING_FLAG_LOG_SUCCESS_ONLY = @as(u32, 8);
pub const HTTP_CREATE_REQUEST_QUEUE_FLAG_OPEN_EXISTING = @as(u32, 1);
pub const HTTP_CREATE_REQUEST_QUEUE_FLAG_CONTROLLER = @as(u32, 2);
pub const HTTP_CREATE_REQUEST_QUEUE_FLAG_DELEGATION = @as(u32, 8);
pub const HTTP_RECEIVE_REQUEST_ENTITY_BODY_FLAG_FILL_BUFFER = @as(u32, 1);
pub const HTTP_SEND_RESPONSE_FLAG_DISCONNECT = @as(u32, 1);
pub const HTTP_SEND_RESPONSE_FLAG_MORE_DATA = @as(u32, 2);
pub const HTTP_SEND_RESPONSE_FLAG_BUFFER_DATA = @as(u32, 4);
pub const HTTP_SEND_RESPONSE_FLAG_ENABLE_NAGLING = @as(u32, 8);
pub const HTTP_SEND_RESPONSE_FLAG_PROCESS_RANGES = @as(u32, 32);
pub const HTTP_SEND_RESPONSE_FLAG_OPAQUE = @as(u32, 64);
pub const HTTP_SEND_RESPONSE_FLAG_GOAWAY = @as(u32, 256);
pub const HTTP_FLUSH_RESPONSE_FLAG_RECURSIVE = @as(u32, 1);
pub const HTTP_URL_FLAG_REMOVE_ALL = @as(u32, 1);
pub const HTTP_RECEIVE_SECURE_CHANNEL_TOKEN = @as(u32, 1);
pub const HTTP_RECEIVE_FULL_CHAIN = @as(u32, 2);
pub const HTTP_REQUEST_SIZING_INFO_FLAG_TCP_FAST_OPEN = @as(u32, 1);
pub const HTTP_REQUEST_SIZING_INFO_FLAG_TLS_SESSION_RESUMPTION = @as(u32, 2);
pub const HTTP_REQUEST_SIZING_INFO_FLAG_TLS_FALSE_START = @as(u32, 4);
pub const HTTP_REQUEST_SIZING_INFO_FLAG_FIRST_REQUEST = @as(u32, 8);
pub const HTTP_REQUEST_AUTH_FLAG_TOKEN_FOR_CACHED_CRED = @as(u32, 1);
pub const HTTP_REQUEST_FLAG_MORE_ENTITY_BODY_EXISTS = @as(u32, 1);
pub const HTTP_REQUEST_FLAG_IP_ROUTED = @as(u32, 2);
pub const HTTP_REQUEST_FLAG_HTTP2 = @as(u32, 4);
pub const HTTP_REQUEST_FLAG_HTTP3 = @as(u32, 8);
pub const HTTP_RESPONSE_FLAG_MULTIPLE_ENCODINGS_AVAILABLE = @as(u32, 1);
pub const HTTP_RESPONSE_FLAG_MORE_ENTITY_BODY_EXISTS = @as(u32, 2);
pub const HTTP_RESPONSE_INFO_FLAGS_PRESERVE_ORDER = @as(u32, 1);
pub const HTTP_SERVICE_CONFIG_SSL_FLAG_USE_DS_MAPPER = @as(u32, 1);
pub const HTTP_SERVICE_CONFIG_SSL_FLAG_NEGOTIATE_CLIENT_CERT = @as(u32, 2);
pub const HTTP_SERVICE_CONFIG_SSL_FLAG_NO_RAW_FILTER = @as(u32, 4);
pub const HTTP_SERVICE_CONFIG_SSL_FLAG_REJECT = @as(u32, 8);
pub const HTTP_SERVICE_CONFIG_SSL_FLAG_DISABLE_HTTP2 = @as(u32, 16);
pub const HTTP_SERVICE_CONFIG_SSL_FLAG_DISABLE_QUIC = @as(u32, 32);
pub const HTTP_SERVICE_CONFIG_SSL_FLAG_DISABLE_TLS13 = @as(u32, 64);
pub const HTTP_SERVICE_CONFIG_SSL_FLAG_DISABLE_OCSP_STAPLING = @as(u32, 128);
pub const HTTP_SERVICE_CONFIG_SSL_FLAG_ENABLE_TOKEN_BINDING = @as(u32, 256);
pub const HTTP_SERVICE_CONFIG_SSL_FLAG_LOG_EXTENDED_EVENTS = @as(u32, 512);
pub const HTTP_SERVICE_CONFIG_SSL_FLAG_DISABLE_LEGACY_TLS = @as(u32, 1024);
pub const HTTP_SERVICE_CONFIG_SSL_FLAG_ENABLE_SESSION_TICKET = @as(u32, 2048);
pub const HTTP_SERVICE_CONFIG_SSL_FLAG_DISABLE_TLS12 = @as(u32, 4096);
pub const HTTP_SERVICE_CONFIG_SSL_FLAG_ENABLE_CLIENT_CORRELATION = @as(u32, 8192);
pub const HTTP_REQUEST_PROPERTY_SNI_HOST_MAX_LENGTH = @as(u32, 255);
pub const HTTP_REQUEST_PROPERTY_SNI_FLAG_SNI_USED = @as(u32, 1);
pub const HTTP_REQUEST_PROPERTY_SNI_FLAG_NO_SNI = @as(u32, 2);

//--------------------------------------------------------------------------------
// Section: Types (123)
//--------------------------------------------------------------------------------
pub const HTTP_RECEIVE_HTTP_REQUEST_FLAGS = enum(u32) {
    COPY_BODY = 1,
    FLUSH_BODY = 2,
};
pub const HTTP_RECEIVE_REQUEST_FLAG_COPY_BODY = HTTP_RECEIVE_HTTP_REQUEST_FLAGS.COPY_BODY;
pub const HTTP_RECEIVE_REQUEST_FLAG_FLUSH_BODY = HTTP_RECEIVE_HTTP_REQUEST_FLAGS.FLUSH_BODY;

pub const HTTP_INITIALIZE = enum(u32) {
    CONFIG = 2,
    SERVER = 1,
    _,
    pub fn initFlags(o: struct {
        CONFIG: u1 = 0,
        SERVER: u1 = 0,
    }) HTTP_INITIALIZE {
        return @as(HTTP_INITIALIZE, @enumFromInt((if (o.CONFIG == 1) @intFromEnum(HTTP_INITIALIZE.CONFIG) else 0) | (if (o.SERVER == 1) @intFromEnum(HTTP_INITIALIZE.SERVER) else 0)));
    }
};
pub const HTTP_INITIALIZE_CONFIG = HTTP_INITIALIZE.CONFIG;
pub const HTTP_INITIALIZE_SERVER = HTTP_INITIALIZE.SERVER;

pub const HTTP_SERVER_PROPERTY = enum(i32) {
    AuthenticationProperty = 0,
    LoggingProperty = 1,
    QosProperty = 2,
    TimeoutsProperty = 3,
    QueueLengthProperty = 4,
    StateProperty = 5,
    @"503VerbosityProperty" = 6,
    BindingProperty = 7,
    ExtendedAuthenticationProperty = 8,
    ListenEndpointProperty = 9,
    ChannelBindProperty = 10,
    ProtectionLevelProperty = 11,
    DelegationProperty = 16,
};
pub const HttpServerAuthenticationProperty = HTTP_SERVER_PROPERTY.AuthenticationProperty;
pub const HttpServerLoggingProperty = HTTP_SERVER_PROPERTY.LoggingProperty;
pub const HttpServerQosProperty = HTTP_SERVER_PROPERTY.QosProperty;
pub const HttpServerTimeoutsProperty = HTTP_SERVER_PROPERTY.TimeoutsProperty;
pub const HttpServerQueueLengthProperty = HTTP_SERVER_PROPERTY.QueueLengthProperty;
pub const HttpServerStateProperty = HTTP_SERVER_PROPERTY.StateProperty;
pub const HttpServer503VerbosityProperty = HTTP_SERVER_PROPERTY.@"503VerbosityProperty";
pub const HttpServerBindingProperty = HTTP_SERVER_PROPERTY.BindingProperty;
pub const HttpServerExtendedAuthenticationProperty = HTTP_SERVER_PROPERTY.ExtendedAuthenticationProperty;
pub const HttpServerListenEndpointProperty = HTTP_SERVER_PROPERTY.ListenEndpointProperty;
pub const HttpServerChannelBindProperty = HTTP_SERVER_PROPERTY.ChannelBindProperty;
pub const HttpServerProtectionLevelProperty = HTTP_SERVER_PROPERTY.ProtectionLevelProperty;
pub const HttpServerDelegationProperty = HTTP_SERVER_PROPERTY.DelegationProperty;

pub const HTTP_PROPERTY_FLAGS = extern struct {
    _bitfield: u32,
};

pub const HTTP_ENABLED_STATE = enum(i32) {
    Active = 0,
    Inactive = 1,
};
pub const HttpEnabledStateActive = HTTP_ENABLED_STATE.Active;
pub const HttpEnabledStateInactive = HTTP_ENABLED_STATE.Inactive;

pub const HTTP_STATE_INFO = extern struct {
    Flags: HTTP_PROPERTY_FLAGS,
    State: HTTP_ENABLED_STATE,
};

pub const HTTP_503_RESPONSE_VERBOSITY = enum(i32) {
    Basic = 0,
    Limited = 1,
    Full = 2,
};
pub const Http503ResponseVerbosityBasic = HTTP_503_RESPONSE_VERBOSITY.Basic;
pub const Http503ResponseVerbosityLimited = HTTP_503_RESPONSE_VERBOSITY.Limited;
pub const Http503ResponseVerbosityFull = HTTP_503_RESPONSE_VERBOSITY.Full;

pub const HTTP_QOS_SETTING_TYPE = enum(i32) {
    Bandwidth = 0,
    ConnectionLimit = 1,
    FlowRate = 2,
};
pub const HttpQosSettingTypeBandwidth = HTTP_QOS_SETTING_TYPE.Bandwidth;
pub const HttpQosSettingTypeConnectionLimit = HTTP_QOS_SETTING_TYPE.ConnectionLimit;
pub const HttpQosSettingTypeFlowRate = HTTP_QOS_SETTING_TYPE.FlowRate;

pub const HTTP_QOS_SETTING_INFO = extern struct {
    QosType: HTTP_QOS_SETTING_TYPE,
    QosSetting: ?*anyopaque,
};

pub const HTTP_CONNECTION_LIMIT_INFO = extern struct {
    Flags: HTTP_PROPERTY_FLAGS,
    MaxConnections: u32,
};

pub const HTTP_BANDWIDTH_LIMIT_INFO = extern struct {
    Flags: HTTP_PROPERTY_FLAGS,
    MaxBandwidth: u32,
};

pub const HTTP_FLOWRATE_INFO = extern struct {
    Flags: HTTP_PROPERTY_FLAGS,
    MaxBandwidth: u32,
    MaxPeakBandwidth: u32,
    BurstSize: u32,
};

pub const HTTP_SERVICE_CONFIG_TIMEOUT_KEY = enum(i32) {
    IdleConnectionTimeout = 0,
    HeaderWaitTimeout = 1,
};
pub const IdleConnectionTimeout = HTTP_SERVICE_CONFIG_TIMEOUT_KEY.IdleConnectionTimeout;
pub const HeaderWaitTimeout = HTTP_SERVICE_CONFIG_TIMEOUT_KEY.HeaderWaitTimeout;

pub const HTTP_SERVICE_CONFIG_TIMEOUT_SET = extern struct {
    KeyDesc: HTTP_SERVICE_CONFIG_TIMEOUT_KEY,
    ParamDesc: u16,
};

pub const HTTP_TIMEOUT_LIMIT_INFO = extern struct {
    Flags: HTTP_PROPERTY_FLAGS,
    EntityBody: u16,
    DrainEntityBody: u16,
    RequestQueue: u16,
    IdleConnection: u16,
    HeaderWait: u16,
    MinSendRate: u32,
};

pub const HTTP_SERVICE_CONFIG_SETTING_KEY = enum(i32) {
    None = 0,
    TlsThrottle = 1,
};
pub const HttpNone = HTTP_SERVICE_CONFIG_SETTING_KEY.None;
pub const HttpTlsThrottle = HTTP_SERVICE_CONFIG_SETTING_KEY.TlsThrottle;

pub const HTTP_SERVICE_CONFIG_SETTING_SET = extern struct {
    KeyDesc: HTTP_SERVICE_CONFIG_SETTING_KEY,
    ParamDesc: u32,
};

pub const HTTP_LISTEN_ENDPOINT_INFO = extern struct {
    Flags: HTTP_PROPERTY_FLAGS,
    EnableSharing: BOOLEAN,
};

pub const HTTP_SERVER_AUTHENTICATION_DIGEST_PARAMS = extern struct {
    DomainNameLength: u16,
    DomainName: ?PWSTR,
    RealmLength: u16,
    Realm: ?PWSTR,
};

pub const HTTP_SERVER_AUTHENTICATION_BASIC_PARAMS = extern struct {
    RealmLength: u16,
    Realm: ?PWSTR,
};

pub const HTTP_SERVER_AUTHENTICATION_INFO = extern struct {
    Flags: HTTP_PROPERTY_FLAGS,
    AuthSchemes: u32,
    ReceiveMutualAuth: BOOLEAN,
    ReceiveContextHandle: BOOLEAN,
    DisableNTLMCredentialCaching: BOOLEAN,
    ExFlags: u8,
    DigestParams: HTTP_SERVER_AUTHENTICATION_DIGEST_PARAMS,
    BasicParams: HTTP_SERVER_AUTHENTICATION_BASIC_PARAMS,
};

pub const HTTP_SERVICE_BINDING_TYPE = enum(i32) {
    None = 0,
    W = 1,
    A = 2,
};
pub const HttpServiceBindingTypeNone = HTTP_SERVICE_BINDING_TYPE.None;
pub const HttpServiceBindingTypeW = HTTP_SERVICE_BINDING_TYPE.W;
pub const HttpServiceBindingTypeA = HTTP_SERVICE_BINDING_TYPE.A;

pub const HTTP_SERVICE_BINDING_BASE = extern struct {
    Type: HTTP_SERVICE_BINDING_TYPE,
};

pub const HTTP_SERVICE_BINDING_A = extern struct {
    Base: HTTP_SERVICE_BINDING_BASE,
    Buffer: ?[*]u8,
    BufferSize: u32,
};

pub const HTTP_SERVICE_BINDING_W = extern struct {
    Base: HTTP_SERVICE_BINDING_BASE,
    Buffer: ?[*]u16,
    BufferSize: u32,
};

pub const HTTP_AUTHENTICATION_HARDENING_LEVELS = enum(i32) {
    Legacy = 0,
    Medium = 1,
    Strict = 2,
};
pub const HttpAuthenticationHardeningLegacy = HTTP_AUTHENTICATION_HARDENING_LEVELS.Legacy;
pub const HttpAuthenticationHardeningMedium = HTTP_AUTHENTICATION_HARDENING_LEVELS.Medium;
pub const HttpAuthenticationHardeningStrict = HTTP_AUTHENTICATION_HARDENING_LEVELS.Strict;

pub const HTTP_CHANNEL_BIND_INFO = extern struct {
    Hardening: HTTP_AUTHENTICATION_HARDENING_LEVELS,
    Flags: u32,
    ServiceNames: ?*?*HTTP_SERVICE_BINDING_BASE,
    NumberOfServiceNames: u32,
};

pub const HTTP_REQUEST_CHANNEL_BIND_STATUS = extern struct {
    ServiceName: ?*HTTP_SERVICE_BINDING_BASE,
    ChannelToken: ?*u8,
    ChannelTokenSize: u32,
    Flags: u32,
};

pub const HTTP_REQUEST_TOKEN_BINDING_INFO = extern struct {
    TokenBinding: ?*u8,
    TokenBindingSize: u32,
    EKM: ?*u8,
    EKMSize: u32,
    KeyType: u8,
};

pub const HTTP_LOGGING_TYPE = enum(i32) {
    W3C = 0,
    IIS = 1,
    NCSA = 2,
    Raw = 3,
};
pub const HttpLoggingTypeW3C = HTTP_LOGGING_TYPE.W3C;
pub const HttpLoggingTypeIIS = HTTP_LOGGING_TYPE.IIS;
pub const HttpLoggingTypeNCSA = HTTP_LOGGING_TYPE.NCSA;
pub const HttpLoggingTypeRaw = HTTP_LOGGING_TYPE.Raw;

pub const HTTP_LOGGING_ROLLOVER_TYPE = enum(i32) {
    Size = 0,
    Daily = 1,
    Weekly = 2,
    Monthly = 3,
    Hourly = 4,
};
pub const HttpLoggingRolloverSize = HTTP_LOGGING_ROLLOVER_TYPE.Size;
pub const HttpLoggingRolloverDaily = HTTP_LOGGING_ROLLOVER_TYPE.Daily;
pub const HttpLoggingRolloverWeekly = HTTP_LOGGING_ROLLOVER_TYPE.Weekly;
pub const HttpLoggingRolloverMonthly = HTTP_LOGGING_ROLLOVER_TYPE.Monthly;
pub const HttpLoggingRolloverHourly = HTTP_LOGGING_ROLLOVER_TYPE.Hourly;

pub const HTTP_LOGGING_INFO = extern struct {
    Flags: HTTP_PROPERTY_FLAGS,
    LoggingFlags: u32,
    SoftwareName: ?[*:0]const u16,
    SoftwareNameLength: u16,
    DirectoryNameLength: u16,
    DirectoryName: ?[*:0]const u16,
    Format: HTTP_LOGGING_TYPE,
    Fields: u32,
    pExtFields: ?*anyopaque,
    NumOfExtFields: u16,
    MaxRecordSize: u16,
    RolloverType: HTTP_LOGGING_ROLLOVER_TYPE,
    RolloverSize: u32,
    pSecurityDescriptor: ?*SECURITY_DESCRIPTOR,
};

pub const HTTP_BINDING_INFO = extern struct {
    Flags: HTTP_PROPERTY_FLAGS,
    RequestQueueHandle: ?HANDLE,
};

pub const HTTP_PROTECTION_LEVEL_TYPE = enum(i32) {
    Unrestricted = 0,
    EdgeRestricted = 1,
    Restricted = 2,
};
pub const HttpProtectionLevelUnrestricted = HTTP_PROTECTION_LEVEL_TYPE.Unrestricted;
pub const HttpProtectionLevelEdgeRestricted = HTTP_PROTECTION_LEVEL_TYPE.EdgeRestricted;
pub const HttpProtectionLevelRestricted = HTTP_PROTECTION_LEVEL_TYPE.Restricted;

pub const HTTP_PROTECTION_LEVEL_INFO = extern struct {
    Flags: HTTP_PROPERTY_FLAGS,
    Level: HTTP_PROTECTION_LEVEL_TYPE,
};

pub const HTTP_BYTE_RANGE = extern struct {
    StartingOffset: ULARGE_INTEGER,
    Length: ULARGE_INTEGER,
};

pub const HTTP_VERSION = extern struct {
    MajorVersion: u16,
    MinorVersion: u16,
};

pub const HTTP_SCHEME = enum(i32) {
    Http = 0,
    Https = 1,
    Maximum = 2,
};
pub const HttpSchemeHttp = HTTP_SCHEME.Http;
pub const HttpSchemeHttps = HTTP_SCHEME.Https;
pub const HttpSchemeMaximum = HTTP_SCHEME.Maximum;

pub const HTTP_VERB = enum(i32) {
    Unparsed = 0,
    Unknown = 1,
    Invalid = 2,
    OPTIONS = 3,
    GET = 4,
    HEAD = 5,
    POST = 6,
    PUT = 7,
    DELETE = 8,
    TRACE = 9,
    CONNECT = 10,
    TRACK = 11,
    MOVE = 12,
    COPY = 13,
    PROPFIND = 14,
    PROPPATCH = 15,
    MKCOL = 16,
    LOCK = 17,
    UNLOCK = 18,
    SEARCH = 19,
    Maximum = 20,
};
pub const HttpVerbUnparsed = HTTP_VERB.Unparsed;
pub const HttpVerbUnknown = HTTP_VERB.Unknown;
pub const HttpVerbInvalid = HTTP_VERB.Invalid;
pub const HttpVerbOPTIONS = HTTP_VERB.OPTIONS;
pub const HttpVerbGET = HTTP_VERB.GET;
pub const HttpVerbHEAD = HTTP_VERB.HEAD;
pub const HttpVerbPOST = HTTP_VERB.POST;
pub const HttpVerbPUT = HTTP_VERB.PUT;
pub const HttpVerbDELETE = HTTP_VERB.DELETE;
pub const HttpVerbTRACE = HTTP_VERB.TRACE;
pub const HttpVerbCONNECT = HTTP_VERB.CONNECT;
pub const HttpVerbTRACK = HTTP_VERB.TRACK;
pub const HttpVerbMOVE = HTTP_VERB.MOVE;
pub const HttpVerbCOPY = HTTP_VERB.COPY;
pub const HttpVerbPROPFIND = HTTP_VERB.PROPFIND;
pub const HttpVerbPROPPATCH = HTTP_VERB.PROPPATCH;
pub const HttpVerbMKCOL = HTTP_VERB.MKCOL;
pub const HttpVerbLOCK = HTTP_VERB.LOCK;
pub const HttpVerbUNLOCK = HTTP_VERB.UNLOCK;
pub const HttpVerbSEARCH = HTTP_VERB.SEARCH;
pub const HttpVerbMaximum = HTTP_VERB.Maximum;

pub const HTTP_HEADER_ID = enum(i32) {
    CacheControl = 0,
    Connection = 1,
    Date = 2,
    KeepAlive = 3,
    Pragma = 4,
    Trailer = 5,
    TransferEncoding = 6,
    Upgrade = 7,
    Via = 8,
    Warning = 9,
    Allow = 10,
    ContentLength = 11,
    ContentType = 12,
    ContentEncoding = 13,
    ContentLanguage = 14,
    ContentLocation = 15,
    ContentMd5 = 16,
    ContentRange = 17,
    Expires = 18,
    LastModified = 19,
    Accept = 20,
    AcceptCharset = 21,
    AcceptEncoding = 22,
    AcceptLanguage = 23,
    Authorization = 24,
    Cookie = 25,
    Expect = 26,
    From = 27,
    Host = 28,
    IfMatch = 29,
    IfModifiedSince = 30,
    IfNoneMatch = 31,
    IfRange = 32,
    IfUnmodifiedSince = 33,
    MaxForwards = 34,
    ProxyAuthorization = 35,
    Referer = 36,
    Range = 37,
    Te = 38,
    Translate = 39,
    UserAgent = 40,
    RequestMaximum = 41,
    // AcceptRanges = 20, this enum value conflicts with Accept
    // Age = 21, this enum value conflicts with AcceptCharset
    // Etag = 22, this enum value conflicts with AcceptEncoding
    // Location = 23, this enum value conflicts with AcceptLanguage
    // ProxyAuthenticate = 24, this enum value conflicts with Authorization
    // RetryAfter = 25, this enum value conflicts with Cookie
    // Server = 26, this enum value conflicts with Expect
    // SetCookie = 27, this enum value conflicts with From
    // Vary = 28, this enum value conflicts with Host
    // WwwAuthenticate = 29, this enum value conflicts with IfMatch
    // ResponseMaximum = 30, this enum value conflicts with IfModifiedSince
    // Maximum = 41, this enum value conflicts with RequestMaximum
};
pub const HttpHeaderCacheControl = HTTP_HEADER_ID.CacheControl;
pub const HttpHeaderConnection = HTTP_HEADER_ID.Connection;
pub const HttpHeaderDate = HTTP_HEADER_ID.Date;
pub const HttpHeaderKeepAlive = HTTP_HEADER_ID.KeepAlive;
pub const HttpHeaderPragma = HTTP_HEADER_ID.Pragma;
pub const HttpHeaderTrailer = HTTP_HEADER_ID.Trailer;
pub const HttpHeaderTransferEncoding = HTTP_HEADER_ID.TransferEncoding;
pub const HttpHeaderUpgrade = HTTP_HEADER_ID.Upgrade;
pub const HttpHeaderVia = HTTP_HEADER_ID.Via;
pub const HttpHeaderWarning = HTTP_HEADER_ID.Warning;
pub const HttpHeaderAllow = HTTP_HEADER_ID.Allow;
pub const HttpHeaderContentLength = HTTP_HEADER_ID.ContentLength;
pub const HttpHeaderContentType = HTTP_HEADER_ID.ContentType;
pub const HttpHeaderContentEncoding = HTTP_HEADER_ID.ContentEncoding;
pub const HttpHeaderContentLanguage = HTTP_HEADER_ID.ContentLanguage;
pub const HttpHeaderContentLocation = HTTP_HEADER_ID.ContentLocation;
pub const HttpHeaderContentMd5 = HTTP_HEADER_ID.ContentMd5;
pub const HttpHeaderContentRange = HTTP_HEADER_ID.ContentRange;
pub const HttpHeaderExpires = HTTP_HEADER_ID.Expires;
pub const HttpHeaderLastModified = HTTP_HEADER_ID.LastModified;
pub const HttpHeaderAccept = HTTP_HEADER_ID.Accept;
pub const HttpHeaderAcceptCharset = HTTP_HEADER_ID.AcceptCharset;
pub const HttpHeaderAcceptEncoding = HTTP_HEADER_ID.AcceptEncoding;
pub const HttpHeaderAcceptLanguage = HTTP_HEADER_ID.AcceptLanguage;
pub const HttpHeaderAuthorization = HTTP_HEADER_ID.Authorization;
pub const HttpHeaderCookie = HTTP_HEADER_ID.Cookie;
pub const HttpHeaderExpect = HTTP_HEADER_ID.Expect;
pub const HttpHeaderFrom = HTTP_HEADER_ID.From;
pub const HttpHeaderHost = HTTP_HEADER_ID.Host;
pub const HttpHeaderIfMatch = HTTP_HEADER_ID.IfMatch;
pub const HttpHeaderIfModifiedSince = HTTP_HEADER_ID.IfModifiedSince;
pub const HttpHeaderIfNoneMatch = HTTP_HEADER_ID.IfNoneMatch;
pub const HttpHeaderIfRange = HTTP_HEADER_ID.IfRange;
pub const HttpHeaderIfUnmodifiedSince = HTTP_HEADER_ID.IfUnmodifiedSince;
pub const HttpHeaderMaxForwards = HTTP_HEADER_ID.MaxForwards;
pub const HttpHeaderProxyAuthorization = HTTP_HEADER_ID.ProxyAuthorization;
pub const HttpHeaderReferer = HTTP_HEADER_ID.Referer;
pub const HttpHeaderRange = HTTP_HEADER_ID.Range;
pub const HttpHeaderTe = HTTP_HEADER_ID.Te;
pub const HttpHeaderTranslate = HTTP_HEADER_ID.Translate;
pub const HttpHeaderUserAgent = HTTP_HEADER_ID.UserAgent;
pub const HttpHeaderRequestMaximum = HTTP_HEADER_ID.RequestMaximum;
pub const HttpHeaderAcceptRanges = HTTP_HEADER_ID.Accept;
pub const HttpHeaderAge = HTTP_HEADER_ID.AcceptCharset;
pub const HttpHeaderEtag = HTTP_HEADER_ID.AcceptEncoding;
pub const HttpHeaderLocation = HTTP_HEADER_ID.AcceptLanguage;
pub const HttpHeaderProxyAuthenticate = HTTP_HEADER_ID.Authorization;
pub const HttpHeaderRetryAfter = HTTP_HEADER_ID.Cookie;
pub const HttpHeaderServer = HTTP_HEADER_ID.Expect;
pub const HttpHeaderSetCookie = HTTP_HEADER_ID.From;
pub const HttpHeaderVary = HTTP_HEADER_ID.Host;
pub const HttpHeaderWwwAuthenticate = HTTP_HEADER_ID.IfMatch;
pub const HttpHeaderResponseMaximum = HTTP_HEADER_ID.IfModifiedSince;
pub const HttpHeaderMaximum = HTTP_HEADER_ID.RequestMaximum;

pub const HTTP_KNOWN_HEADER = extern struct {
    RawValueLength: u16,
    pRawValue: ?[*:0]const u8,
};

pub const HTTP_UNKNOWN_HEADER = extern struct {
    NameLength: u16,
    RawValueLength: u16,
    pName: ?[*:0]const u8,
    pRawValue: ?[*:0]const u8,
};

pub const HTTP_LOG_DATA_TYPE = enum(i32) {
    s = 0,
};
pub const HttpLogDataTypeFields = HTTP_LOG_DATA_TYPE.s;

pub const HTTP_LOG_DATA = extern struct {
    Type: HTTP_LOG_DATA_TYPE,
};

pub const HTTP_LOG_FIELDS_DATA = extern struct {
    Base: HTTP_LOG_DATA,
    UserNameLength: u16,
    UriStemLength: u16,
    ClientIpLength: u16,
    ServerNameLength: u16,
    ServiceNameLength: u16,
    ServerIpLength: u16,
    MethodLength: u16,
    UriQueryLength: u16,
    HostLength: u16,
    UserAgentLength: u16,
    CookieLength: u16,
    ReferrerLength: u16,
    UserName: ?[*]u16,
    UriStem: ?[*]u16,
    ClientIp: ?[*]u8,
    ServerName: ?[*]u8,
    ServiceName: ?[*]u8,
    ServerIp: ?[*]u8,
    Method: ?[*]u8,
    UriQuery: ?[*]u8,
    Host: ?[*]u8,
    UserAgent: ?[*]u8,
    Cookie: ?[*]u8,
    Referrer: ?[*]u8,
    ServerPort: u16,
    ProtocolStatus: u16,
    Win32Status: u32,
    MethodNum: HTTP_VERB,
    SubStatus: u16,
};

pub const HTTP_DATA_CHUNK_TYPE = enum(i32) {
    FromMemory = 0,
    FromFileHandle = 1,
    FromFragmentCache = 2,
    FromFragmentCacheEx = 3,
    Trailers = 4,
    Maximum = 5,
};
pub const HttpDataChunkFromMemory = HTTP_DATA_CHUNK_TYPE.FromMemory;
pub const HttpDataChunkFromFileHandle = HTTP_DATA_CHUNK_TYPE.FromFileHandle;
pub const HttpDataChunkFromFragmentCache = HTTP_DATA_CHUNK_TYPE.FromFragmentCache;
pub const HttpDataChunkFromFragmentCacheEx = HTTP_DATA_CHUNK_TYPE.FromFragmentCacheEx;
pub const HttpDataChunkTrailers = HTTP_DATA_CHUNK_TYPE.Trailers;
pub const HttpDataChunkMaximum = HTTP_DATA_CHUNK_TYPE.Maximum;

pub const HTTP_DATA_CHUNK = extern struct {
    DataChunkType: HTTP_DATA_CHUNK_TYPE,
    Anonymous: extern union {
        FromMemory: extern struct {
            pBuffer: ?*anyopaque,
            BufferLength: u32,
        },
        FromFileHandle: extern struct {
            ByteRange: HTTP_BYTE_RANGE,
            FileHandle: ?HANDLE,
        },
        FromFragmentCache: extern struct {
            FragmentNameLength: u16,
            pFragmentName: ?[*:0]const u16,
        },
        FromFragmentCacheEx: extern struct {
            ByteRange: HTTP_BYTE_RANGE,
            pFragmentName: ?[*:0]const u16,
        },
        Trailers: extern struct {
            TrailerCount: u16,
            pTrailers: ?*HTTP_UNKNOWN_HEADER,
        },
    },
};

pub const HTTP_REQUEST_HEADERS = extern struct {
    UnknownHeaderCount: u16,
    pUnknownHeaders: ?*HTTP_UNKNOWN_HEADER,
    TrailerCount: u16,
    pTrailers: ?*HTTP_UNKNOWN_HEADER,
    KnownHeaders: [41]HTTP_KNOWN_HEADER,
};

pub const HTTP_RESPONSE_HEADERS = extern struct {
    UnknownHeaderCount: u16,
    pUnknownHeaders: ?*HTTP_UNKNOWN_HEADER,
    TrailerCount: u16,
    pTrailers: ?*HTTP_UNKNOWN_HEADER,
    KnownHeaders: [30]HTTP_KNOWN_HEADER,
};

pub const HTTP_DELEGATE_REQUEST_PROPERTY_ID = enum(i32) {
    ReservedProperty = 0,
    DelegateUrlProperty = 1,
};
pub const DelegateRequestReservedProperty = HTTP_DELEGATE_REQUEST_PROPERTY_ID.ReservedProperty;
pub const DelegateRequestDelegateUrlProperty = HTTP_DELEGATE_REQUEST_PROPERTY_ID.DelegateUrlProperty;

pub const HTTP_DELEGATE_REQUEST_PROPERTY_INFO = extern struct {
    PropertyId: HTTP_DELEGATE_REQUEST_PROPERTY_ID,
    PropertyInfoLength: u32,
    PropertyInfo: ?*anyopaque,
};

pub const HTTP_CREATE_REQUEST_QUEUE_PROPERTY_ID = enum(i32) {
    ExternalIdProperty = 1,
    Max = 2,
};
pub const CreateRequestQueueExternalIdProperty = HTTP_CREATE_REQUEST_QUEUE_PROPERTY_ID.ExternalIdProperty;
pub const CreateRequestQueueMax = HTTP_CREATE_REQUEST_QUEUE_PROPERTY_ID.Max;

pub const HTTP_CREATE_REQUEST_QUEUE_PROPERTY_INFO = extern struct {
    PropertyId: HTTP_CREATE_REQUEST_QUEUE_PROPERTY_ID,
    PropertyInfoLength: u32,
    PropertyInfo: ?*anyopaque,
};

pub const HTTP_TRANSPORT_ADDRESS = extern struct {
    pRemoteAddress: ?*SOCKADDR,
    pLocalAddress: ?*SOCKADDR,
};

pub const HTTP_COOKED_URL = extern struct {
    FullUrlLength: u16,
    HostLength: u16,
    AbsPathLength: u16,
    QueryStringLength: u16,
    pFullUrl: ?[*:0]const u16,
    pHost: ?[*:0]const u16,
    pAbsPath: ?[*:0]const u16,
    pQueryString: ?[*:0]const u16,
};

pub const HTTP_AUTH_STATUS = enum(i32) {
    Success = 0,
    NotAuthenticated = 1,
    Failure = 2,
};
pub const HttpAuthStatusSuccess = HTTP_AUTH_STATUS.Success;
pub const HttpAuthStatusNotAuthenticated = HTTP_AUTH_STATUS.NotAuthenticated;
pub const HttpAuthStatusFailure = HTTP_AUTH_STATUS.Failure;

pub const HTTP_REQUEST_AUTH_TYPE = enum(i32) {
    None = 0,
    Basic = 1,
    Digest = 2,
    NTLM = 3,
    Negotiate = 4,
    Kerberos = 5,
};
pub const HttpRequestAuthTypeNone = HTTP_REQUEST_AUTH_TYPE.None;
pub const HttpRequestAuthTypeBasic = HTTP_REQUEST_AUTH_TYPE.Basic;
pub const HttpRequestAuthTypeDigest = HTTP_REQUEST_AUTH_TYPE.Digest;
pub const HttpRequestAuthTypeNTLM = HTTP_REQUEST_AUTH_TYPE.NTLM;
pub const HttpRequestAuthTypeNegotiate = HTTP_REQUEST_AUTH_TYPE.Negotiate;
pub const HttpRequestAuthTypeKerberos = HTTP_REQUEST_AUTH_TYPE.Kerberos;

pub const HTTP_SSL_CLIENT_CERT_INFO = extern struct {
    CertFlags: u32,
    CertEncodedSize: u32,
    pCertEncoded: ?*u8,
    Token: ?HANDLE,
    CertDeniedByMapper: BOOLEAN,
};

pub const HTTP_SSL_INFO = extern struct {
    ServerCertKeySize: u16,
    ConnectionKeySize: u16,
    ServerCertIssuerSize: u32,
    ServerCertSubjectSize: u32,
    pServerCertIssuer: ?[*:0]const u8,
    pServerCertSubject: ?[*:0]const u8,
    pClientCertInfo: ?*HTTP_SSL_CLIENT_CERT_INFO,
    SslClientCertNegotiated: u32,
};

pub const HTTP_SSL_PROTOCOL_INFO = extern struct {
    Protocol: u32,
    CipherType: u32,
    CipherStrength: u32,
    HashType: u32,
    HashStrength: u32,
    KeyExchangeType: u32,
    KeyExchangeStrength: u32,
};

pub const HTTP_REQUEST_SIZING_TYPE = enum(i32) {
    TlsHandshakeLeg1ClientData = 0,
    TlsHandshakeLeg1ServerData = 1,
    TlsHandshakeLeg2ClientData = 2,
    TlsHandshakeLeg2ServerData = 3,
    Headers = 4,
    Max = 5,
};
pub const HttpRequestSizingTypeTlsHandshakeLeg1ClientData = HTTP_REQUEST_SIZING_TYPE.TlsHandshakeLeg1ClientData;
pub const HttpRequestSizingTypeTlsHandshakeLeg1ServerData = HTTP_REQUEST_SIZING_TYPE.TlsHandshakeLeg1ServerData;
pub const HttpRequestSizingTypeTlsHandshakeLeg2ClientData = HTTP_REQUEST_SIZING_TYPE.TlsHandshakeLeg2ClientData;
pub const HttpRequestSizingTypeTlsHandshakeLeg2ServerData = HTTP_REQUEST_SIZING_TYPE.TlsHandshakeLeg2ServerData;
pub const HttpRequestSizingTypeHeaders = HTTP_REQUEST_SIZING_TYPE.Headers;
pub const HttpRequestSizingTypeMax = HTTP_REQUEST_SIZING_TYPE.Max;

pub const HTTP_REQUEST_SIZING_INFO = extern struct {
    Flags: u64,
    RequestIndex: u32,
    RequestSizingCount: u32,
    RequestSizing: [5]u64,
};

pub const HTTP_REQUEST_TIMING_TYPE = enum(i32) {
    ConnectionStart = 0,
    DataStart = 1,
    TlsCertificateLoadStart = 2,
    TlsCertificateLoadEnd = 3,
    TlsHandshakeLeg1Start = 4,
    TlsHandshakeLeg1End = 5,
    TlsHandshakeLeg2Start = 6,
    TlsHandshakeLeg2End = 7,
    TlsAttributesQueryStart = 8,
    TlsAttributesQueryEnd = 9,
    TlsClientCertQueryStart = 10,
    TlsClientCertQueryEnd = 11,
    Http2StreamStart = 12,
    Http2HeaderDecodeStart = 13,
    Http2HeaderDecodeEnd = 14,
    RequestHeaderParseStart = 15,
    RequestHeaderParseEnd = 16,
    RequestRoutingStart = 17,
    RequestRoutingEnd = 18,
    RequestQueuedForInspection = 19,
    RequestDeliveredForInspection = 20,
    RequestReturnedAfterInspection = 21,
    RequestQueuedForDelegation = 22,
    RequestDeliveredForDelegation = 23,
    RequestReturnedAfterDelegation = 24,
    RequestQueuedForIO = 25,
    RequestDeliveredForIO = 26,
    Http3StreamStart = 27,
    Http3HeaderDecodeStart = 28,
    Http3HeaderDecodeEnd = 29,
    Max = 30,
};
pub const HttpRequestTimingTypeConnectionStart = HTTP_REQUEST_TIMING_TYPE.ConnectionStart;
pub const HttpRequestTimingTypeDataStart = HTTP_REQUEST_TIMING_TYPE.DataStart;
pub const HttpRequestTimingTypeTlsCertificateLoadStart = HTTP_REQUEST_TIMING_TYPE.TlsCertificateLoadStart;
pub const HttpRequestTimingTypeTlsCertificateLoadEnd = HTTP_REQUEST_TIMING_TYPE.TlsCertificateLoadEnd;
pub const HttpRequestTimingTypeTlsHandshakeLeg1Start = HTTP_REQUEST_TIMING_TYPE.TlsHandshakeLeg1Start;
pub const HttpRequestTimingTypeTlsHandshakeLeg1End = HTTP_REQUEST_TIMING_TYPE.TlsHandshakeLeg1End;
pub const HttpRequestTimingTypeTlsHandshakeLeg2Start = HTTP_REQUEST_TIMING_TYPE.TlsHandshakeLeg2Start;
pub const HttpRequestTimingTypeTlsHandshakeLeg2End = HTTP_REQUEST_TIMING_TYPE.TlsHandshakeLeg2End;
pub const HttpRequestTimingTypeTlsAttributesQueryStart = HTTP_REQUEST_TIMING_TYPE.TlsAttributesQueryStart;
pub const HttpRequestTimingTypeTlsAttributesQueryEnd = HTTP_REQUEST_TIMING_TYPE.TlsAttributesQueryEnd;
pub const HttpRequestTimingTypeTlsClientCertQueryStart = HTTP_REQUEST_TIMING_TYPE.TlsClientCertQueryStart;
pub const HttpRequestTimingTypeTlsClientCertQueryEnd = HTTP_REQUEST_TIMING_TYPE.TlsClientCertQueryEnd;
pub const HttpRequestTimingTypeHttp2StreamStart = HTTP_REQUEST_TIMING_TYPE.Http2StreamStart;
pub const HttpRequestTimingTypeHttp2HeaderDecodeStart = HTTP_REQUEST_TIMING_TYPE.Http2HeaderDecodeStart;
pub const HttpRequestTimingTypeHttp2HeaderDecodeEnd = HTTP_REQUEST_TIMING_TYPE.Http2HeaderDecodeEnd;
pub const HttpRequestTimingTypeRequestHeaderParseStart = HTTP_REQUEST_TIMING_TYPE.RequestHeaderParseStart;
pub const HttpRequestTimingTypeRequestHeaderParseEnd = HTTP_REQUEST_TIMING_TYPE.RequestHeaderParseEnd;
pub const HttpRequestTimingTypeRequestRoutingStart = HTTP_REQUEST_TIMING_TYPE.RequestRoutingStart;
pub const HttpRequestTimingTypeRequestRoutingEnd = HTTP_REQUEST_TIMING_TYPE.RequestRoutingEnd;
pub const HttpRequestTimingTypeRequestQueuedForInspection = HTTP_REQUEST_TIMING_TYPE.RequestQueuedForInspection;
pub const HttpRequestTimingTypeRequestDeliveredForInspection = HTTP_REQUEST_TIMING_TYPE.RequestDeliveredForInspection;
pub const HttpRequestTimingTypeRequestReturnedAfterInspection = HTTP_REQUEST_TIMING_TYPE.RequestReturnedAfterInspection;
pub const HttpRequestTimingTypeRequestQueuedForDelegation = HTTP_REQUEST_TIMING_TYPE.RequestQueuedForDelegation;
pub const HttpRequestTimingTypeRequestDeliveredForDelegation = HTTP_REQUEST_TIMING_TYPE.RequestDeliveredForDelegation;
pub const HttpRequestTimingTypeRequestReturnedAfterDelegation = HTTP_REQUEST_TIMING_TYPE.RequestReturnedAfterDelegation;
pub const HttpRequestTimingTypeRequestQueuedForIO = HTTP_REQUEST_TIMING_TYPE.RequestQueuedForIO;
pub const HttpRequestTimingTypeRequestDeliveredForIO = HTTP_REQUEST_TIMING_TYPE.RequestDeliveredForIO;
pub const HttpRequestTimingTypeHttp3StreamStart = HTTP_REQUEST_TIMING_TYPE.Http3StreamStart;
pub const HttpRequestTimingTypeHttp3HeaderDecodeStart = HTTP_REQUEST_TIMING_TYPE.Http3HeaderDecodeStart;
pub const HttpRequestTimingTypeHttp3HeaderDecodeEnd = HTTP_REQUEST_TIMING_TYPE.Http3HeaderDecodeEnd;
pub const HttpRequestTimingTypeMax = HTTP_REQUEST_TIMING_TYPE.Max;

pub const HTTP_REQUEST_TIMING_INFO = extern struct {
    RequestTimingCount: u32,
    RequestTiming: [30]u64,
};

pub const HTTP_REQUEST_INFO_TYPE = enum(i32) {
    Auth = 0,
    ChannelBind = 1,
    SslProtocol = 2,
    SslTokenBindingDraft = 3,
    SslTokenBinding = 4,
    RequestTiming = 5,
    TcpInfoV0 = 6,
    RequestSizing = 7,
    QuicStats = 8,
    TcpInfoV1 = 9,
};
pub const HttpRequestInfoTypeAuth = HTTP_REQUEST_INFO_TYPE.Auth;
pub const HttpRequestInfoTypeChannelBind = HTTP_REQUEST_INFO_TYPE.ChannelBind;
pub const HttpRequestInfoTypeSslProtocol = HTTP_REQUEST_INFO_TYPE.SslProtocol;
pub const HttpRequestInfoTypeSslTokenBindingDraft = HTTP_REQUEST_INFO_TYPE.SslTokenBindingDraft;
pub const HttpRequestInfoTypeSslTokenBinding = HTTP_REQUEST_INFO_TYPE.SslTokenBinding;
pub const HttpRequestInfoTypeRequestTiming = HTTP_REQUEST_INFO_TYPE.RequestTiming;
pub const HttpRequestInfoTypeTcpInfoV0 = HTTP_REQUEST_INFO_TYPE.TcpInfoV0;
pub const HttpRequestInfoTypeRequestSizing = HTTP_REQUEST_INFO_TYPE.RequestSizing;
pub const HttpRequestInfoTypeQuicStats = HTTP_REQUEST_INFO_TYPE.QuicStats;
pub const HttpRequestInfoTypeTcpInfoV1 = HTTP_REQUEST_INFO_TYPE.TcpInfoV1;

pub const HTTP_REQUEST_INFO = extern struct {
    InfoType: HTTP_REQUEST_INFO_TYPE,
    InfoLength: u32,
    pInfo: ?*anyopaque,
};

pub const HTTP_REQUEST_AUTH_INFO = extern struct {
    AuthStatus: HTTP_AUTH_STATUS,
    SecStatus: i32,
    Flags: u32,
    AuthType: HTTP_REQUEST_AUTH_TYPE,
    AccessToken: ?HANDLE,
    ContextAttributes: u32,
    PackedContextLength: u32,
    PackedContextType: u32,
    PackedContext: ?*anyopaque,
    MutualAuthDataLength: u32,
    pMutualAuthData: ?[*]u8,
    PackageNameLength: u16,
    pPackageName: ?PWSTR,
};

pub const HTTP_REQUEST_V1 = extern struct {
    Flags: u32,
    ConnectionId: u64,
    RequestId: u64,
    UrlContext: u64,
    Version: HTTP_VERSION,
    Verb: HTTP_VERB,
    UnknownVerbLength: u16,
    RawUrlLength: u16,
    pUnknownVerb: ?[*:0]const u8,
    pRawUrl: ?[*:0]const u8,
    CookedUrl: HTTP_COOKED_URL,
    Address: HTTP_TRANSPORT_ADDRESS,
    Headers: HTTP_REQUEST_HEADERS,
    BytesReceived: u64,
    EntityChunkCount: u16,
    pEntityChunks: ?*HTTP_DATA_CHUNK,
    RawConnectionId: u64,
    pSslInfo: ?*HTTP_SSL_INFO,
};

pub const HTTP_REQUEST_V2 = extern struct {
    __AnonymousBase_http_L1861_C35: HTTP_REQUEST_V1,
    RequestInfoCount: u16,
    pRequestInfo: ?*HTTP_REQUEST_INFO,
};

pub const HTTP_RESPONSE_V1 = extern struct {
    Flags: u32,
    Version: HTTP_VERSION,
    StatusCode: u16,
    ReasonLength: u16,
    pReason: ?[*:0]const u8,
    Headers: HTTP_RESPONSE_HEADERS,
    EntityChunkCount: u16,
    pEntityChunks: ?*HTTP_DATA_CHUNK,
};

pub const HTTP_RESPONSE_INFO_TYPE = enum(i32) {
    MultipleKnownHeaders = 0,
    AuthenticationProperty = 1,
    QoSProperty = 2,
    ChannelBind = 3,
};
pub const HttpResponseInfoTypeMultipleKnownHeaders = HTTP_RESPONSE_INFO_TYPE.MultipleKnownHeaders;
pub const HttpResponseInfoTypeAuthenticationProperty = HTTP_RESPONSE_INFO_TYPE.AuthenticationProperty;
pub const HttpResponseInfoTypeQoSProperty = HTTP_RESPONSE_INFO_TYPE.QoSProperty;
pub const HttpResponseInfoTypeChannelBind = HTTP_RESPONSE_INFO_TYPE.ChannelBind;

pub const HTTP_RESPONSE_INFO = extern struct {
    Type: HTTP_RESPONSE_INFO_TYPE,
    Length: u32,
    pInfo: ?*anyopaque,
};

pub const HTTP_MULTIPLE_KNOWN_HEADERS = extern struct {
    HeaderId: HTTP_HEADER_ID,
    Flags: u32,
    KnownHeaderCount: u16,
    KnownHeaders: ?*HTTP_KNOWN_HEADER,
};

pub const HTTP_RESPONSE_V2 = extern struct {
    __AnonymousBase_http_L2050_C36: HTTP_RESPONSE_V1,
    ResponseInfoCount: u16,
    pResponseInfo: ?*HTTP_RESPONSE_INFO,
};

pub const HTTPAPI_VERSION = extern struct {
    HttpApiMajorVersion: u16,
    HttpApiMinorVersion: u16,
};

pub const HTTP_CACHE_POLICY_TYPE = enum(i32) {
    Nocache = 0,
    UserInvalidates = 1,
    TimeToLive = 2,
    Maximum = 3,
};
pub const HttpCachePolicyNocache = HTTP_CACHE_POLICY_TYPE.Nocache;
pub const HttpCachePolicyUserInvalidates = HTTP_CACHE_POLICY_TYPE.UserInvalidates;
pub const HttpCachePolicyTimeToLive = HTTP_CACHE_POLICY_TYPE.TimeToLive;
pub const HttpCachePolicyMaximum = HTTP_CACHE_POLICY_TYPE.Maximum;

pub const HTTP_CACHE_POLICY = extern struct {
    Policy: HTTP_CACHE_POLICY_TYPE,
    SecondsToLive: u32,
};

pub const HTTP_SERVICE_CONFIG_ID = enum(i32) {
    IPListenList = 0,
    SSLCertInfo = 1,
    UrlAclInfo = 2,
    Timeout = 3,
    Cache = 4,
    SslSniCertInfo = 5,
    SslCcsCertInfo = 6,
    Setting = 7,
    SslCertInfoEx = 8,
    SslSniCertInfoEx = 9,
    SslCcsCertInfoEx = 10,
    SslScopedCcsCertInfo = 11,
    SslScopedCcsCertInfoEx = 12,
    Max = 13,
};
pub const HttpServiceConfigIPListenList = HTTP_SERVICE_CONFIG_ID.IPListenList;
pub const HttpServiceConfigSSLCertInfo = HTTP_SERVICE_CONFIG_ID.SSLCertInfo;
pub const HttpServiceConfigUrlAclInfo = HTTP_SERVICE_CONFIG_ID.UrlAclInfo;
pub const HttpServiceConfigTimeout = HTTP_SERVICE_CONFIG_ID.Timeout;
pub const HttpServiceConfigCache = HTTP_SERVICE_CONFIG_ID.Cache;
pub const HttpServiceConfigSslSniCertInfo = HTTP_SERVICE_CONFIG_ID.SslSniCertInfo;
pub const HttpServiceConfigSslCcsCertInfo = HTTP_SERVICE_CONFIG_ID.SslCcsCertInfo;
pub const HttpServiceConfigSetting = HTTP_SERVICE_CONFIG_ID.Setting;
pub const HttpServiceConfigSslCertInfoEx = HTTP_SERVICE_CONFIG_ID.SslCertInfoEx;
pub const HttpServiceConfigSslSniCertInfoEx = HTTP_SERVICE_CONFIG_ID.SslSniCertInfoEx;
pub const HttpServiceConfigSslCcsCertInfoEx = HTTP_SERVICE_CONFIG_ID.SslCcsCertInfoEx;
pub const HttpServiceConfigSslScopedCcsCertInfo = HTTP_SERVICE_CONFIG_ID.SslScopedCcsCertInfo;
pub const HttpServiceConfigSslScopedCcsCertInfoEx = HTTP_SERVICE_CONFIG_ID.SslScopedCcsCertInfoEx;
pub const HttpServiceConfigMax = HTTP_SERVICE_CONFIG_ID.Max;

pub const HTTP_SERVICE_CONFIG_QUERY_TYPE = enum(i32) {
    Exact = 0,
    Next = 1,
    Max = 2,
};
pub const HttpServiceConfigQueryExact = HTTP_SERVICE_CONFIG_QUERY_TYPE.Exact;
pub const HttpServiceConfigQueryNext = HTTP_SERVICE_CONFIG_QUERY_TYPE.Next;
pub const HttpServiceConfigQueryMax = HTTP_SERVICE_CONFIG_QUERY_TYPE.Max;

pub const HTTP_SERVICE_CONFIG_SSL_KEY = extern struct {
    pIpPort: ?*SOCKADDR,
};

pub const HTTP_SERVICE_CONFIG_SSL_KEY_EX = extern struct {
    IpPort: SOCKADDR_STORAGE,
};

pub const HTTP_SERVICE_CONFIG_SSL_SNI_KEY = extern struct {
    IpPort: SOCKADDR_STORAGE,
    Host: ?PWSTR,
};

pub const HTTP_SERVICE_CONFIG_SSL_CCS_KEY = extern struct {
    LocalAddress: SOCKADDR_STORAGE,
};

pub const HTTP_SERVICE_CONFIG_SSL_PARAM = extern struct {
    SslHashLength: u32,
    pSslHash: ?*anyopaque,
    AppId: Guid,
    pSslCertStoreName: ?PWSTR,
    DefaultCertCheckMode: u32,
    DefaultRevocationFreshnessTime: u32,
    DefaultRevocationUrlRetrievalTimeout: u32,
    pDefaultSslCtlIdentifier: ?PWSTR,
    pDefaultSslCtlStoreName: ?PWSTR,
    DefaultFlags: u32,
};

pub const HTTP_SSL_SERVICE_CONFIG_EX_PARAM_TYPE = enum(i32) {
    Http2Window = 0,
    Http2SettingsLimits = 1,
    HttpPerformance = 2,
    TlsRestrictions = 3,
    ErrorHeaders = 4,
    TlsSessionTicketKeys = 5,
    Max = 6,
};
pub const ExParamTypeHttp2Window = HTTP_SSL_SERVICE_CONFIG_EX_PARAM_TYPE.Http2Window;
pub const ExParamTypeHttp2SettingsLimits = HTTP_SSL_SERVICE_CONFIG_EX_PARAM_TYPE.Http2SettingsLimits;
pub const ExParamTypeHttpPerformance = HTTP_SSL_SERVICE_CONFIG_EX_PARAM_TYPE.HttpPerformance;
pub const ExParamTypeTlsRestrictions = HTTP_SSL_SERVICE_CONFIG_EX_PARAM_TYPE.TlsRestrictions;
pub const ExParamTypeErrorHeaders = HTTP_SSL_SERVICE_CONFIG_EX_PARAM_TYPE.ErrorHeaders;
pub const ExParamTypeTlsSessionTicketKeys = HTTP_SSL_SERVICE_CONFIG_EX_PARAM_TYPE.TlsSessionTicketKeys;
pub const ExParamTypeMax = HTTP_SSL_SERVICE_CONFIG_EX_PARAM_TYPE.Max;

pub const HTTP2_WINDOW_SIZE_PARAM = extern struct {
    Http2ReceiveWindowSize: u32,
};

pub const HTTP2_SETTINGS_LIMITS_PARAM = extern struct {
    Http2MaxSettingsPerFrame: u32,
    Http2MaxSettingsPerMinute: u32,
};

pub const HTTP_PERFORMANCE_PARAM_TYPE = enum(i32) {
    SendBufferingFlags = 0,
    AggressiveICW = 1,
    MaxSendBufferSize = 2,
    MaxConcurrentClientStreams = 3,
    MaxReceiveBufferSize = 4,
    DecryptOnSspiThread = 5,
    Max = 6,
};
pub const PerformanceParamSendBufferingFlags = HTTP_PERFORMANCE_PARAM_TYPE.SendBufferingFlags;
pub const PerformanceParamAggressiveICW = HTTP_PERFORMANCE_PARAM_TYPE.AggressiveICW;
pub const PerformanceParamMaxSendBufferSize = HTTP_PERFORMANCE_PARAM_TYPE.MaxSendBufferSize;
pub const PerformanceParamMaxConcurrentClientStreams = HTTP_PERFORMANCE_PARAM_TYPE.MaxConcurrentClientStreams;
pub const PerformanceParamMaxReceiveBufferSize = HTTP_PERFORMANCE_PARAM_TYPE.MaxReceiveBufferSize;
pub const PerformanceParamDecryptOnSspiThread = HTTP_PERFORMANCE_PARAM_TYPE.DecryptOnSspiThread;
pub const PerformanceParamMax = HTTP_PERFORMANCE_PARAM_TYPE.Max;

pub const HTTP_PERFORMANCE_PARAM = extern struct {
    Type: HTTP_PERFORMANCE_PARAM_TYPE,
    BufferSize: u32,
    Buffer: ?*anyopaque,
};

pub const HTTP_TLS_RESTRICTIONS_PARAM = extern struct {
    RestrictionCount: u32,
    TlsRestrictions: ?*anyopaque,
};

pub const HTTP_ERROR_HEADERS_PARAM = extern struct {
    StatusCode: u16,
    HeaderCount: u16,
    Headers: ?*HTTP_UNKNOWN_HEADER,
};

pub const HTTP_TLS_SESSION_TICKET_KEYS_PARAM = extern struct {
    SessionTicketKeyCount: u32,
    SessionTicketKeys: ?*anyopaque,
};

pub const HTTP_SERVICE_CONFIG_SSL_PARAM_EX = extern struct {
    ParamType: HTTP_SSL_SERVICE_CONFIG_EX_PARAM_TYPE,
    Flags: u64,
    Anonymous: extern union {
        Http2WindowSizeParam: HTTP2_WINDOW_SIZE_PARAM,
        Http2SettingsLimitsParam: HTTP2_SETTINGS_LIMITS_PARAM,
        HttpPerformanceParam: HTTP_PERFORMANCE_PARAM,
        HttpTlsRestrictionsParam: HTTP_TLS_RESTRICTIONS_PARAM,
        HttpErrorHeadersParam: HTTP_ERROR_HEADERS_PARAM,
        HttpTlsSessionTicketKeysParam: HTTP_TLS_SESSION_TICKET_KEYS_PARAM,
    },
};

pub const HTTP_SERVICE_CONFIG_SSL_SET = extern struct {
    KeyDesc: HTTP_SERVICE_CONFIG_SSL_KEY,
    ParamDesc: HTTP_SERVICE_CONFIG_SSL_PARAM,
};

pub const HTTP_SERVICE_CONFIG_SSL_SNI_SET = extern struct {
    KeyDesc: HTTP_SERVICE_CONFIG_SSL_SNI_KEY,
    ParamDesc: HTTP_SERVICE_CONFIG_SSL_PARAM,
};

pub const HTTP_SERVICE_CONFIG_SSL_CCS_SET = extern struct {
    KeyDesc: HTTP_SERVICE_CONFIG_SSL_CCS_KEY,
    ParamDesc: HTTP_SERVICE_CONFIG_SSL_PARAM,
};

pub const HTTP_SERVICE_CONFIG_SSL_SET_EX = extern struct {
    KeyDesc: HTTP_SERVICE_CONFIG_SSL_KEY_EX,
    ParamDesc: HTTP_SERVICE_CONFIG_SSL_PARAM_EX,
};

pub const HTTP_SERVICE_CONFIG_SSL_SNI_SET_EX = extern struct {
    KeyDesc: HTTP_SERVICE_CONFIG_SSL_SNI_KEY,
    ParamDesc: HTTP_SERVICE_CONFIG_SSL_PARAM_EX,
};

pub const HTTP_SERVICE_CONFIG_SSL_CCS_SET_EX = extern struct {
    KeyDesc: HTTP_SERVICE_CONFIG_SSL_CCS_KEY,
    ParamDesc: HTTP_SERVICE_CONFIG_SSL_PARAM_EX,
};

pub const HTTP_SERVICE_CONFIG_SSL_QUERY = extern struct {
    QueryDesc: HTTP_SERVICE_CONFIG_QUERY_TYPE,
    KeyDesc: HTTP_SERVICE_CONFIG_SSL_KEY,
    dwToken: u32,
};

pub const HTTP_SERVICE_CONFIG_SSL_SNI_QUERY = extern struct {
    QueryDesc: HTTP_SERVICE_CONFIG_QUERY_TYPE,
    KeyDesc: HTTP_SERVICE_CONFIG_SSL_SNI_KEY,
    dwToken: u32,
};

pub const HTTP_SERVICE_CONFIG_SSL_CCS_QUERY = extern struct {
    QueryDesc: HTTP_SERVICE_CONFIG_QUERY_TYPE,
    KeyDesc: HTTP_SERVICE_CONFIG_SSL_CCS_KEY,
    dwToken: u32,
};

pub const HTTP_SERVICE_CONFIG_SSL_QUERY_EX = extern struct {
    QueryDesc: HTTP_SERVICE_CONFIG_QUERY_TYPE,
    KeyDesc: HTTP_SERVICE_CONFIG_SSL_KEY_EX,
    dwToken: u32,
    ParamType: HTTP_SSL_SERVICE_CONFIG_EX_PARAM_TYPE,
};

pub const HTTP_SERVICE_CONFIG_SSL_SNI_QUERY_EX = extern struct {
    QueryDesc: HTTP_SERVICE_CONFIG_QUERY_TYPE,
    KeyDesc: HTTP_SERVICE_CONFIG_SSL_SNI_KEY,
    dwToken: u32,
    ParamType: HTTP_SSL_SERVICE_CONFIG_EX_PARAM_TYPE,
};

pub const HTTP_SERVICE_CONFIG_SSL_CCS_QUERY_EX = extern struct {
    QueryDesc: HTTP_SERVICE_CONFIG_QUERY_TYPE,
    KeyDesc: HTTP_SERVICE_CONFIG_SSL_CCS_KEY,
    dwToken: u32,
    ParamType: HTTP_SSL_SERVICE_CONFIG_EX_PARAM_TYPE,
};

pub const HTTP_SERVICE_CONFIG_IP_LISTEN_PARAM = extern struct {
    AddrLength: u16,
    pAddress: ?*SOCKADDR,
};

pub const HTTP_SERVICE_CONFIG_IP_LISTEN_QUERY = extern struct {
    AddrCount: u32,
    AddrList: [1]SOCKADDR_STORAGE,
};

pub const HTTP_SERVICE_CONFIG_URLACL_KEY = extern struct {
    pUrlPrefix: ?PWSTR,
};

pub const HTTP_SERVICE_CONFIG_URLACL_PARAM = extern struct {
    pStringSecurityDescriptor: ?PWSTR,
};

pub const HTTP_SERVICE_CONFIG_URLACL_SET = extern struct {
    KeyDesc: HTTP_SERVICE_CONFIG_URLACL_KEY,
    ParamDesc: HTTP_SERVICE_CONFIG_URLACL_PARAM,
};

pub const HTTP_SERVICE_CONFIG_URLACL_QUERY = extern struct {
    QueryDesc: HTTP_SERVICE_CONFIG_QUERY_TYPE,
    KeyDesc: HTTP_SERVICE_CONFIG_URLACL_KEY,
    dwToken: u32,
};

pub const HTTP_SERVICE_CONFIG_CACHE_KEY = enum(i32) {
    MaxCacheResponseSize = 0,
    CacheRangeChunkSize = 1,
};
pub const MaxCacheResponseSize = HTTP_SERVICE_CONFIG_CACHE_KEY.MaxCacheResponseSize;
pub const CacheRangeChunkSize = HTTP_SERVICE_CONFIG_CACHE_KEY.CacheRangeChunkSize;

pub const HTTP_SERVICE_CONFIG_CACHE_SET = extern struct {
    KeyDesc: HTTP_SERVICE_CONFIG_CACHE_KEY,
    ParamDesc: u32,
};

pub const HTTP_REQUEST_PROPERTY = enum(i32) {
    Isb = 0,
    TcpInfoV0 = 1,
    QuicStats = 2,
    TcpInfoV1 = 3,
    Sni = 4,
    StreamError = 5,
    WskApiTimings = 6,
    QuicApiTimings = 7,
};
pub const HttpRequestPropertyIsb = HTTP_REQUEST_PROPERTY.Isb;
pub const HttpRequestPropertyTcpInfoV0 = HTTP_REQUEST_PROPERTY.TcpInfoV0;
pub const HttpRequestPropertyQuicStats = HTTP_REQUEST_PROPERTY.QuicStats;
pub const HttpRequestPropertyTcpInfoV1 = HTTP_REQUEST_PROPERTY.TcpInfoV1;
pub const HttpRequestPropertySni = HTTP_REQUEST_PROPERTY.Sni;
pub const HttpRequestPropertyStreamError = HTTP_REQUEST_PROPERTY.StreamError;
pub const HttpRequestPropertyWskApiTimings = HTTP_REQUEST_PROPERTY.WskApiTimings;
pub const HttpRequestPropertyQuicApiTimings = HTTP_REQUEST_PROPERTY.QuicApiTimings;

pub const HTTP_QUERY_REQUEST_QUALIFIER_TCP = extern struct {
    Freshness: u64,
};

pub const HTTP_QUERY_REQUEST_QUALIFIER_QUIC = extern struct {
    Freshness: u64,
};

pub const HTTP_REQUEST_PROPERTY_SNI = extern struct {
    Hostname: [256]u16,
    Flags: u32,
};

pub const HTTP_REQUEST_PROPERTY_STREAM_ERROR = extern struct {
    ErrorCode: u32,
};

pub const HTTP_WSK_API_TIMINGS = extern struct {
    ConnectCount: u64,
    ConnectSum: u64,
    DisconnectCount: u64,
    DisconnectSum: u64,
    SendCount: u64,
    SendSum: u64,
    ReceiveCount: u64,
    ReceiveSum: u64,
    ReleaseCount: u64,
    ReleaseSum: u64,
    ControlSocketCount: u64,
    ControlSocketSum: u64,
};

pub const HTTP_QUIC_STREAM_API_TIMINGS = extern struct {
    OpenCount: u64,
    OpenSum: u64,
    CloseCount: u64,
    CloseSum: u64,
    StartCount: u64,
    StartSum: u64,
    ShutdownCount: u64,
    ShutdownSum: u64,
    SendCount: u64,
    SendSum: u64,
    ReceiveSetEnabledCount: u64,
    ReceiveSetEnabledSum: u64,
    GetParamCount: u64,
    GetParamSum: u64,
    SetParamCount: u64,
    SetParamSum: u64,
    SetCallbackHandlerCount: u64,
    SetCallbackHandlerSum: u64,
};

pub const HTTP_QUIC_CONNECTION_API_TIMINGS = extern struct {
    OpenTime: u64,
    CloseTime: u64,
    StartTime: u64,
    ShutdownTime: u64,
    SecConfigCreateTime: u64,
    SecConfigDeleteTime: u64,
    GetParamCount: u64,
    GetParamSum: u64,
    SetParamCount: u64,
    SetParamSum: u64,
    SetCallbackHandlerCount: u64,
    SetCallbackHandlerSum: u64,
    ControlStreamTimings: HTTP_QUIC_STREAM_API_TIMINGS,
};

pub const HTTP_QUIC_API_TIMINGS = extern struct {
    ConnectionTimings: HTTP_QUIC_CONNECTION_API_TIMINGS,
    StreamTimings: HTTP_QUIC_STREAM_API_TIMINGS,
};

pub const HTTP_FEATURE_ID = enum(i32) {
    Unknown = 0,
    ResponseTrailers = 1,
    ApiTimings = 2,
    DelegateEx = 3,
    Http3 = 4,
    max = -1,
};
pub const HttpFeatureUnknown = HTTP_FEATURE_ID.Unknown;
pub const HttpFeatureResponseTrailers = HTTP_FEATURE_ID.ResponseTrailers;
pub const HttpFeatureApiTimings = HTTP_FEATURE_ID.ApiTimings;
pub const HttpFeatureDelegateEx = HTTP_FEATURE_ID.DelegateEx;
pub const HttpFeatureHttp3 = HTTP_FEATURE_ID.Http3;
pub const HttpFeaturemax = HTTP_FEATURE_ID.max;

//--------------------------------------------------------------------------------
// Section: Functions (43)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpInitialize(
    Version: HTTPAPI_VERSION,
    Flags: HTTP_INITIALIZE,
    pReserved: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpTerminate(
    Flags: HTTP_INITIALIZE,
    pReserved: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpCreateHttpHandle(
    RequestQueueHandle: ?*?HANDLE,
    Reserved: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpCreateRequestQueue(
    Version: HTTPAPI_VERSION,
    Name: ?[*:0]const u16,
    SecurityAttributes: ?*SECURITY_ATTRIBUTES,
    Flags: u32,
    RequestQueueHandle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpCloseRequestQueue(
    RequestQueueHandle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpSetRequestQueueProperty(
    RequestQueueHandle: ?HANDLE,
    Property: HTTP_SERVER_PROPERTY,
    // TODO: what to do with BytesParamIndex 3?
    PropertyInformation: ?*anyopaque,
    PropertyInformationLength: u32,
    Reserved1: u32,
    Reserved2: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpQueryRequestQueueProperty(
    RequestQueueHandle: ?HANDLE,
    Property: HTTP_SERVER_PROPERTY,
    // TODO: what to do with BytesParamIndex 3?
    PropertyInformation: ?*anyopaque,
    PropertyInformationLength: u32,
    Reserved1: u32,
    ReturnLength: ?*u32,
    Reserved2: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "httpapi" fn HttpSetRequestProperty(
    RequestQueueHandle: ?HANDLE,
    Id: u64,
    PropertyId: HTTP_REQUEST_PROPERTY,
    // TODO: what to do with BytesParamIndex 4?
    Input: ?*anyopaque,
    InputPropertySize: u32,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpShutdownRequestQueue(
    RequestQueueHandle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpReceiveClientCertificate(
    RequestQueueHandle: ?HANDLE,
    ConnectionId: u64,
    Flags: u32,
    // TODO: what to do with BytesParamIndex 4?
    SslClientCertInfo: ?*HTTP_SSL_CLIENT_CERT_INFO,
    SslClientCertInfoSize: u32,
    BytesReceived: ?*u32,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpCreateServerSession(
    Version: HTTPAPI_VERSION,
    ServerSessionId: ?*u64,
    Reserved: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpCloseServerSession(
    ServerSessionId: u64,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpQueryServerSessionProperty(
    ServerSessionId: u64,
    Property: HTTP_SERVER_PROPERTY,
    // TODO: what to do with BytesParamIndex 3?
    PropertyInformation: ?*anyopaque,
    PropertyInformationLength: u32,
    ReturnLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpSetServerSessionProperty(
    ServerSessionId: u64,
    Property: HTTP_SERVER_PROPERTY,
    // TODO: what to do with BytesParamIndex 3?
    PropertyInformation: ?*anyopaque,
    PropertyInformationLength: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpAddUrl(
    RequestQueueHandle: ?HANDLE,
    FullyQualifiedUrl: ?[*:0]const u16,
    Reserved: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpRemoveUrl(
    RequestQueueHandle: ?HANDLE,
    FullyQualifiedUrl: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpCreateUrlGroup(
    ServerSessionId: u64,
    pUrlGroupId: ?*u64,
    Reserved: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpCloseUrlGroup(
    UrlGroupId: u64,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpAddUrlToUrlGroup(
    UrlGroupId: u64,
    pFullyQualifiedUrl: ?[*:0]const u16,
    UrlContext: u64,
    Reserved: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpRemoveUrlFromUrlGroup(
    UrlGroupId: u64,
    pFullyQualifiedUrl: ?[*:0]const u16,
    Flags: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpSetUrlGroupProperty(
    UrlGroupId: u64,
    Property: HTTP_SERVER_PROPERTY,
    // TODO: what to do with BytesParamIndex 3?
    PropertyInformation: ?*anyopaque,
    PropertyInformationLength: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpQueryUrlGroupProperty(
    UrlGroupId: u64,
    Property: HTTP_SERVER_PROPERTY,
    // TODO: what to do with BytesParamIndex 3?
    PropertyInformation: ?*anyopaque,
    PropertyInformationLength: u32,
    ReturnLength: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "httpapi" fn HttpPrepareUrl(
    Reserved: ?*anyopaque,
    Flags: u32,
    Url: ?[*:0]const u16,
    PreparedUrl: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpReceiveHttpRequest(
    RequestQueueHandle: ?HANDLE,
    RequestId: u64,
    Flags: HTTP_RECEIVE_HTTP_REQUEST_FLAGS,
    // TODO: what to do with BytesParamIndex 4?
    RequestBuffer: ?*HTTP_REQUEST_V2,
    RequestBufferLength: u32,
    BytesReturned: ?*u32,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpReceiveRequestEntityBody(
    RequestQueueHandle: ?HANDLE,
    RequestId: u64,
    Flags: u32,
    // TODO: what to do with BytesParamIndex 4?
    EntityBuffer: ?*anyopaque,
    EntityBufferLength: u32,
    BytesReturned: ?*u32,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpSendHttpResponse(
    RequestQueueHandle: ?HANDLE,
    RequestId: u64,
    Flags: u32,
    HttpResponse: ?*HTTP_RESPONSE_V2,
    CachePolicy: ?*HTTP_CACHE_POLICY,
    BytesSent: ?*u32,
    Reserved1: ?*anyopaque,
    Reserved2: u32,
    Overlapped: ?*OVERLAPPED,
    LogData: ?*HTTP_LOG_DATA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpSendResponseEntityBody(
    RequestQueueHandle: ?HANDLE,
    RequestId: u64,
    Flags: u32,
    EntityChunkCount: u16,
    EntityChunks: ?[*]HTTP_DATA_CHUNK,
    BytesSent: ?*u32,
    Reserved1: ?*anyopaque,
    Reserved2: u32,
    Overlapped: ?*OVERLAPPED,
    LogData: ?*HTTP_LOG_DATA,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "httpapi" fn HttpDeclarePush(
    RequestQueueHandle: ?HANDLE,
    RequestId: u64,
    Verb: HTTP_VERB,
    Path: ?[*:0]const u16,
    Query: ?[*:0]const u8,
    Headers: ?*HTTP_REQUEST_HEADERS,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpWaitForDisconnect(
    RequestQueueHandle: ?HANDLE,
    ConnectionId: u64,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "httpapi" fn HttpWaitForDisconnectEx(
    RequestQueueHandle: ?HANDLE,
    ConnectionId: u64,
    Reserved: u32,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpCancelHttpRequest(
    RequestQueueHandle: ?HANDLE,
    RequestId: u64,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpWaitForDemandStart(
    RequestQueueHandle: ?HANDLE,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "httpapi" fn HttpIsFeatureSupported(
    FeatureId: HTTP_FEATURE_ID,
) callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "httpapi" fn HttpDelegateRequestEx(
    RequestQueueHandle: ?HANDLE,
    DelegateQueueHandle: ?HANDLE,
    RequestId: u64,
    DelegateUrlGroupId: u64,
    PropertyInfoSetSize: u32,
    PropertyInfoSet: ?*HTTP_DELEGATE_REQUEST_PROPERTY_INFO,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "httpapi" fn HttpFindUrlGroupId(
    FullyQualifiedUrl: ?[*:0]const u16,
    RequestQueueHandle: ?HANDLE,
    UrlGroupId: ?*u64,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpFlushResponseCache(
    RequestQueueHandle: ?HANDLE,
    UrlPrefix: ?[*:0]const u16,
    Flags: u32,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpAddFragmentToCache(
    RequestQueueHandle: ?HANDLE,
    UrlPrefix: ?[*:0]const u16,
    DataChunk: ?*HTTP_DATA_CHUNK,
    CachePolicy: ?*HTTP_CACHE_POLICY,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpReadFragmentFromCache(
    RequestQueueHandle: ?HANDLE,
    UrlPrefix: ?[*:0]const u16,
    ByteRange: ?*HTTP_BYTE_RANGE,
    // TODO: what to do with BytesParamIndex 4?
    Buffer: ?*anyopaque,
    BufferLength: u32,
    BytesRead: ?*u32,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "httpapi" fn HttpSetServiceConfiguration(
    ServiceHandle: ?HANDLE,
    ConfigId: HTTP_SERVICE_CONFIG_ID,
    // TODO: what to do with BytesParamIndex 3?
    pConfigInformation: ?*anyopaque,
    ConfigInformationLength: u32,
    pOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows10.0.15063'
pub extern "httpapi" fn HttpUpdateServiceConfiguration(
    Handle: ?HANDLE,
    ConfigId: HTTP_SERVICE_CONFIG_ID,
    // TODO: what to do with BytesParamIndex 3?
    ConfigInfo: ?*anyopaque,
    ConfigInfoLength: u32,
    Overlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpDeleteServiceConfiguration(
    ServiceHandle: ?HANDLE,
    ConfigId: HTTP_SERVICE_CONFIG_ID,
    // TODO: what to do with BytesParamIndex 3?
    pConfigInformation: ?*anyopaque,
    ConfigInformationLength: u32,
    pOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "httpapi" fn HttpQueryServiceConfiguration(
    ServiceHandle: ?HANDLE,
    ConfigId: HTTP_SERVICE_CONFIG_ID,
    // TODO: what to do with BytesParamIndex 3?
    pInput: ?*anyopaque,
    InputLength: u32,
    // TODO: what to do with BytesParamIndex 5?
    pOutput: ?*anyopaque,
    OutputLength: u32,
    pReturnLength: ?*u32,
    pOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

pub extern "httpapi" fn HttpGetExtension(
    Version: HTTPAPI_VERSION,
    Extension: u32,
    Buffer: ?*anyopaque,
    BufferSize: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (1)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {
        pub const HTTP_SERVICE_BINDING_ = thismodule.HTTP_SERVICE_BINDING_A;
    },
    .wide => struct {
        pub const HTTP_SERVICE_BINDING_ = thismodule.HTTP_SERVICE_BINDING_W;
    },
    .unspecified => if (@import("builtin").is_test) struct {
        pub const HTTP_SERVICE_BINDING_ = *opaque {};
    } else struct {
        pub const HTTP_SERVICE_BINDING_ = @compileError("'HTTP_SERVICE_BINDING_' requires that UNICODE be set to true or false in the root module");
    },
};
//--------------------------------------------------------------------------------
// Section: Imports (12)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const BOOLEAN = @import("../foundation.zig").BOOLEAN;
const HANDLE = @import("../foundation.zig").HANDLE;
const OVERLAPPED = @import("../system/io.zig").OVERLAPPED;
const PSTR = @import("../foundation.zig").PSTR;
const PWSTR = @import("../foundation.zig").PWSTR;
const SECURITY_ATTRIBUTES = @import("../security.zig").SECURITY_ATTRIBUTES;
const SECURITY_DESCRIPTOR = @import("../security.zig").SECURITY_DESCRIPTOR;
const SOCKADDR = @import("../networking/win_sock.zig").SOCKADDR;
const SOCKADDR_STORAGE = @import("../networking/win_sock.zig").SOCKADDR_STORAGE;
const ULARGE_INTEGER = @import("../foundation.zig").ULARGE_INTEGER;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
