//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (7)
//--------------------------------------------------------------------------------
pub const DAV_AUTHN_SCHEME_BASIC = @as(u32, 1);
pub const DAV_AUTHN_SCHEME_NTLM = @as(u32, 2);
pub const DAV_AUTHN_SCHEME_PASSPORT = @as(u32, 4);
pub const DAV_AUTHN_SCHEME_DIGEST = @as(u32, 8);
pub const DAV_AUTHN_SCHEME_NEGOTIATE = @as(u32, 16);
pub const DAV_AUTHN_SCHEME_CERT = @as(u32, 65536);
pub const DAV_AUTHN_SCHEME_FBA = @as(u32, 1048576);

//--------------------------------------------------------------------------------
// Section: Types (6)
//--------------------------------------------------------------------------------
pub const DAV_CALLBACK_AUTH_BLOB = extern struct {
    pBuffer: ?*anyopaque,
    ulSize: u32,
    ulType: u32,
};

pub const DAV_CALLBACK_AUTH_UNP = extern struct {
    pszUserName: ?PWSTR,
    ulUserNameLength: u32,
    pszPassword: ?PWSTR,
    ulPasswordLength: u32,
};

pub const DAV_CALLBACK_CRED = extern struct {
    AuthBlob: DAV_CALLBACK_AUTH_BLOB,
    UNPBlob: DAV_CALLBACK_AUTH_UNP,
    bAuthBlobValid: BOOL,
    bSave: BOOL,
};

pub const AUTHNEXTSTEP = enum(i32) {
    DefaultBehavior = 0,
    RetryRequest = 1,
    CancelRequest = 2,
};
pub const DefaultBehavior = AUTHNEXTSTEP.DefaultBehavior;
pub const RetryRequest = AUTHNEXTSTEP.RetryRequest;
pub const CancelRequest = AUTHNEXTSTEP.CancelRequest;

pub const PFNDAVAUTHCALLBACK_FREECRED = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        pbuffer: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) u32,
    else => *const fn (
        pbuffer: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) u32,
};

pub const PFNDAVAUTHCALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        lpwzServerName: ?PWSTR,
        lpwzRemoteName: ?PWSTR,
        dwAuthScheme: u32,
        dwFlags: u32,
        pCallbackCred: ?*DAV_CALLBACK_CRED,
        NextStep: ?*AUTHNEXTSTEP,
        pFreeCred: ?*?PFNDAVAUTHCALLBACK_FREECRED,
    ) callconv(@import("std").os.windows.WINAPI) u32,
    else => *const fn (
        lpwzServerName: ?PWSTR,
        lpwzRemoteName: ?PWSTR,
        dwAuthScheme: u32,
        dwFlags: u32,
        pCallbackCred: ?*DAV_CALLBACK_CRED,
        NextStep: ?*AUTHNEXTSTEP,
        pFreeCred: ?*?PFNDAVAUTHCALLBACK_FREECRED,
    ) callconv(@import("std").os.windows.WINAPI) u32,
};

//--------------------------------------------------------------------------------
// Section: Functions (11)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "netapi32" fn DavAddConnection(
    ConnectionHandle: ?*?HANDLE,
    RemoteName: ?[*:0]const u16,
    UserName: ?[*:0]const u16,
    Password: ?[*:0]const u16,
    // TODO: what to do with BytesParamIndex 5?
    ClientCert: ?*u8,
    CertSize: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "netapi32" fn DavDeleteConnection(
    ConnectionHandle: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "netapi32" fn DavGetUNCFromHTTPPath(
    Url: ?[*:0]const u16,
    UncPath: ?[*:0]u16,
    lpSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "netapi32" fn DavGetHTTPFromUNCPath(
    UncPath: ?[*:0]const u16,
    Url: ?[*:0]u16,
    lpSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "davclnt" fn DavGetTheLockOwnerOfTheFile(
    FileName: ?[*:0]const u16,
    // TODO: what to do with BytesParamIndex 2?
    LockOwnerName: ?PWSTR,
    LockOwnerNameLengthInBytes: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "netapi32" fn DavGetExtendedError(
    hFile: ?HANDLE,
    ExtError: ?*u32,
    ExtErrorString: [*:0]u16,
    cChSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "netapi32" fn DavFlushFile(
    hFile: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "davclnt" fn DavInvalidateCache(
    URLName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "davclnt" fn DavCancelConnectionsToServer(
    lpName: ?PWSTR,
    fForce: BOOL,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "davclnt" fn DavRegisterAuthCallback(
    CallBack: ?PFNDAVAUTHCALLBACK,
    Version: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "davclnt" fn DavUnregisterAuthCallback(
    hCallback: u32,
) callconv(@import("std").os.windows.WINAPI) void;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (3)
//--------------------------------------------------------------------------------
const BOOL = @import("../foundation.zig").BOOL;
const HANDLE = @import("../foundation.zig").HANDLE;
const PWSTR = @import("../foundation.zig").PWSTR;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "PFNDAVAUTHCALLBACK_FREECRED")) {
        _ = PFNDAVAUTHCALLBACK_FREECRED;
    }
    if (@hasDecl(@This(), "PFNDAVAUTHCALLBACK")) {
        _ = PFNDAVAUTHCALLBACK;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
