//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (88)
//--------------------------------------------------------------------------------
pub const NS_PNRPNAME = @as(u32, 38);
pub const NS_PNRPCLOUD = @as(u32, 39);
pub const PNRPINFO_HINT = @as(u32, 1);
pub const NS_PROVIDER_PNRPNAME = Guid.initString("03fe89cd-766d-4976-b9c1-bb9bc42c7b4d");
pub const NS_PROVIDER_PNRPCLOUD = Guid.initString("03fe89ce-766d-4976-b9c1-bb9bc42c7b4d");
pub const SVCID_PNRPCLOUD = Guid.initString("c2239ce6-00c0-4fbf-bad6-18139385a49a");
pub const SVCID_PNRPNAME_V1 = Guid.initString("c2239ce5-00c0-4fbf-bad6-18139385a49a");
pub const SVCID_PNRPNAME_V2 = Guid.initString("c2239ce7-00c0-4fbf-bad6-18139385a49a");
pub const PNRP_MAX_ENDPOINT_ADDRESSES = @as(u32, 10);
pub const PNRP_MAX_EXTENDED_PAYLOAD_BYTES = @as(u32, 4096);
pub const WSA_PNRP_ERROR_BASE = @as(u32, 11500);
pub const WSA_PNRP_CLOUD_NOT_FOUND = @as(u32, 11501);
pub const WSA_PNRP_CLOUD_DISABLED = @as(u32, 11502);
pub const WSA_PNRP_INVALID_IDENTITY = @as(u32, 11503);
pub const WSA_PNRP_TOO_MUCH_LOAD = @as(u32, 11504);
pub const WSA_PNRP_CLOUD_IS_SEARCH_ONLY = @as(u32, 11505);
pub const WSA_PNRP_CLIENT_INVALID_COMPARTMENT_ID = @as(u32, 11506);
pub const WSA_PNRP_DUPLICATE_PEER_NAME = @as(u32, 11508);
pub const WSA_PNRP_CLOUD_IS_DEAD = @as(u32, 11509);
pub const PEER_E_CLOUD_NOT_FOUND = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147013395));
pub const PEER_E_CLOUD_DISABLED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147013394));
pub const PEER_E_INVALID_IDENTITY = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147013393));
pub const PEER_E_TOO_MUCH_LOAD = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147013392));
pub const PEER_E_CLOUD_IS_SEARCH_ONLY = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147013391));
pub const PEER_E_CLIENT_INVALID_COMPARTMENT_ID = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147013390));
pub const PEER_E_DUPLICATE_PEER_NAME = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147013388));
pub const PEER_E_CLOUD_IS_DEAD = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147013387));
pub const PEER_E_NOT_FOUND = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147023728));
pub const PEER_E_DISK_FULL = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147024784));
pub const PEER_E_ALREADY_EXISTS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147024713));
pub const PEER_GROUP_ROLE_ADMIN = Guid.initString("04387127-aa56-450a-8ce5-4f565c6790f4");
pub const PEER_GROUP_ROLE_MEMBER = Guid.initString("f12dc4c7-0857-4ca0-93fc-b1bb19a3d8c2");
pub const PEER_GROUP_ROLE_INVITING_MEMBER = Guid.initString("4370fd89-dc18-4cfb-8dbf-9853a8a9f905");
pub const PEER_COLLAB_OBJECTID_USER_PICTURE = Guid.initString("dd15f41f-fc4e-4922-b035-4c06a754d01d");
pub const FACILITY_DRT = @as(u32, 98);
pub const DRT_E_TIMEOUT = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141057023));
pub const DRT_E_INVALID_KEY_SIZE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141057022));
pub const DRT_E_INVALID_CERT_CHAIN = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141057020));
pub const DRT_E_INVALID_MESSAGE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141057019));
pub const DRT_E_NO_MORE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141057018));
pub const DRT_E_INVALID_MAX_ADDRESSES = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141057017));
pub const DRT_E_SEARCH_IN_PROGRESS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141057016));
pub const DRT_E_INVALID_KEY = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141057015));
pub const DRT_S_RETRY = @import("../zig.zig").typedConst(HRESULT, @as(i32, 6426640));
pub const DRT_E_INVALID_MAX_ENDPOINTS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141057007));
pub const DRT_E_INVALID_SEARCH_RANGE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141057006));
pub const DRT_E_INVALID_PORT = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052928));
pub const DRT_E_INVALID_TRANSPORT_PROVIDER = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052927));
pub const DRT_E_INVALID_SECURITY_PROVIDER = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052926));
pub const DRT_E_STILL_IN_USE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052925));
pub const DRT_E_INVALID_BOOTSTRAP_PROVIDER = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052924));
pub const DRT_E_INVALID_ADDRESS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052923));
pub const DRT_E_INVALID_SCOPE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052922));
pub const DRT_E_TRANSPORT_SHUTTING_DOWN = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052921));
pub const DRT_E_NO_ADDRESSES_AVAILABLE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052920));
pub const DRT_E_DUPLICATE_KEY = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052919));
pub const DRT_E_TRANSPORTPROVIDER_IN_USE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052918));
pub const DRT_E_TRANSPORTPROVIDER_NOT_ATTACHED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052917));
pub const DRT_E_SECURITYPROVIDER_IN_USE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052916));
pub const DRT_E_SECURITYPROVIDER_NOT_ATTACHED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052915));
pub const DRT_E_BOOTSTRAPPROVIDER_IN_USE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052914));
pub const DRT_E_BOOTSTRAPPROVIDER_NOT_ATTACHED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052913));
pub const DRT_E_TRANSPORT_ALREADY_BOUND = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052671));
pub const DRT_E_TRANSPORT_NOT_BOUND = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052670));
pub const DRT_E_TRANSPORT_UNEXPECTED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052669));
pub const DRT_E_TRANSPORT_INVALID_ARGUMENT = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052668));
pub const DRT_E_TRANSPORT_NO_DEST_ADDRESSES = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052667));
pub const DRT_E_TRANSPORT_EXECUTING_CALLBACK = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052666));
pub const DRT_E_TRANSPORT_ALREADY_EXISTS_FOR_SCOPE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052665));
pub const DRT_E_INVALID_SETTINGS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052664));
pub const DRT_E_INVALID_SEARCH_INFO = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052663));
pub const DRT_E_FAULTED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052662));
pub const DRT_E_TRANSPORT_STILL_BOUND = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052661));
pub const DRT_E_INSUFFICIENT_BUFFER = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052660));
pub const DRT_E_INVALID_INSTANCE_PREFIX = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052659));
pub const DRT_E_INVALID_SECURITY_MODE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052658));
pub const DRT_E_CAPABILITY_MISMATCH = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2141052657));
pub const DRT_PAYLOAD_REVOKED = @as(u32, 1);
pub const DRT_MIN_ROUTING_ADDRESSES = @as(u32, 1);
pub const DRT_MAX_ROUTING_ADDRESSES = @as(u32, 20);
pub const DRT_MAX_PAYLOAD_SIZE = @as(u32, 5120);
pub const DRT_MAX_INSTANCE_PREFIX_LEN = @as(u32, 128);
pub const DRT_LINK_LOCAL_ISATAP_SCOPEID = @as(u32, 4294967295);
pub const PEERDIST_PUBLICATION_OPTIONS_VERSION_1 = @as(i32, 1);
pub const PEERDIST_PUBLICATION_OPTIONS_VERSION = @as(i32, 2);
pub const PEERDIST_PUBLICATION_OPTIONS_VERSION_2 = @as(i32, 2);
pub const PEERDIST_READ_TIMEOUT_LOCAL_CACHE_ONLY = @as(u32, 0);
pub const PEERDIST_READ_TIMEOUT_DEFAULT = @as(u32, 4294967294);

//--------------------------------------------------------------------------------
// Section: Types (110)
//--------------------------------------------------------------------------------
pub const PEERDIST_RETRIEVAL_OPTIONS_CONTENTINFO_VERSION_VALUE = enum(u32) {
    _1 = 1,
    _2 = 2,
    // N = 2, this enum value conflicts with _2
};
pub const PEERDIST_RETRIEVAL_OPTIONS_CONTENTINFO_VERSION_1 = PEERDIST_RETRIEVAL_OPTIONS_CONTENTINFO_VERSION_VALUE._1;
pub const PEERDIST_RETRIEVAL_OPTIONS_CONTENTINFO_VERSION_2 = PEERDIST_RETRIEVAL_OPTIONS_CONTENTINFO_VERSION_VALUE._2;
pub const PEERDIST_RETRIEVAL_OPTIONS_CONTENTINFO_VERSION = PEERDIST_RETRIEVAL_OPTIONS_CONTENTINFO_VERSION_VALUE._2;

pub const PNRP_SCOPE = enum(i32) {
    SCOPE_ANY = 0,
    GLOBAL_SCOPE = 1,
    SITE_LOCAL_SCOPE = 2,
    LINK_LOCAL_SCOPE = 3,
};
pub const PNRP_SCOPE_ANY = PNRP_SCOPE.SCOPE_ANY;
pub const PNRP_GLOBAL_SCOPE = PNRP_SCOPE.GLOBAL_SCOPE;
pub const PNRP_SITE_LOCAL_SCOPE = PNRP_SCOPE.SITE_LOCAL_SCOPE;
pub const PNRP_LINK_LOCAL_SCOPE = PNRP_SCOPE.LINK_LOCAL_SCOPE;

pub const PNRP_CLOUD_STATE = enum(i32) {
    VIRTUAL = 0,
    SYNCHRONISING = 1,
    ACTIVE = 2,
    DEAD = 3,
    DISABLED = 4,
    NO_NET = 5,
    ALONE = 6,
};
pub const PNRP_CLOUD_STATE_VIRTUAL = PNRP_CLOUD_STATE.VIRTUAL;
pub const PNRP_CLOUD_STATE_SYNCHRONISING = PNRP_CLOUD_STATE.SYNCHRONISING;
pub const PNRP_CLOUD_STATE_ACTIVE = PNRP_CLOUD_STATE.ACTIVE;
pub const PNRP_CLOUD_STATE_DEAD = PNRP_CLOUD_STATE.DEAD;
pub const PNRP_CLOUD_STATE_DISABLED = PNRP_CLOUD_STATE.DISABLED;
pub const PNRP_CLOUD_STATE_NO_NET = PNRP_CLOUD_STATE.NO_NET;
pub const PNRP_CLOUD_STATE_ALONE = PNRP_CLOUD_STATE.ALONE;

pub const PNRP_CLOUD_FLAGS = enum(i32) {
    NO_FLAGS = 0,
    NAME_LOCAL = 1,
    RESOLVE_ONLY = 2,
    FULL_PARTICIPANT = 4,
};
pub const PNRP_CLOUD_NO_FLAGS = PNRP_CLOUD_FLAGS.NO_FLAGS;
pub const PNRP_CLOUD_NAME_LOCAL = PNRP_CLOUD_FLAGS.NAME_LOCAL;
pub const PNRP_CLOUD_RESOLVE_ONLY = PNRP_CLOUD_FLAGS.RESOLVE_ONLY;
pub const PNRP_CLOUD_FULL_PARTICIPANT = PNRP_CLOUD_FLAGS.FULL_PARTICIPANT;

pub const PNRP_REGISTERED_ID_STATE = enum(i32) {
    OK = 1,
    PROBLEM = 2,
};
pub const PNRP_REGISTERED_ID_STATE_OK = PNRP_REGISTERED_ID_STATE.OK;
pub const PNRP_REGISTERED_ID_STATE_PROBLEM = PNRP_REGISTERED_ID_STATE.PROBLEM;

pub const PNRP_RESOLVE_CRITERIA = enum(i32) {
    DEFAULT = 0,
    REMOTE_PEER_NAME = 1,
    NEAREST_REMOTE_PEER_NAME = 2,
    NON_CURRENT_PROCESS_PEER_NAME = 3,
    NEAREST_NON_CURRENT_PROCESS_PEER_NAME = 4,
    ANY_PEER_NAME = 5,
    NEAREST_PEER_NAME = 6,
};
pub const PNRP_RESOLVE_CRITERIA_DEFAULT = PNRP_RESOLVE_CRITERIA.DEFAULT;
pub const PNRP_RESOLVE_CRITERIA_REMOTE_PEER_NAME = PNRP_RESOLVE_CRITERIA.REMOTE_PEER_NAME;
pub const PNRP_RESOLVE_CRITERIA_NEAREST_REMOTE_PEER_NAME = PNRP_RESOLVE_CRITERIA.NEAREST_REMOTE_PEER_NAME;
pub const PNRP_RESOLVE_CRITERIA_NON_CURRENT_PROCESS_PEER_NAME = PNRP_RESOLVE_CRITERIA.NON_CURRENT_PROCESS_PEER_NAME;
pub const PNRP_RESOLVE_CRITERIA_NEAREST_NON_CURRENT_PROCESS_PEER_NAME = PNRP_RESOLVE_CRITERIA.NEAREST_NON_CURRENT_PROCESS_PEER_NAME;
pub const PNRP_RESOLVE_CRITERIA_ANY_PEER_NAME = PNRP_RESOLVE_CRITERIA.ANY_PEER_NAME;
pub const PNRP_RESOLVE_CRITERIA_NEAREST_PEER_NAME = PNRP_RESOLVE_CRITERIA.NEAREST_PEER_NAME;

pub const PNRP_CLOUD_ID = extern struct {
    AddressFamily: i32,
    Scope: PNRP_SCOPE,
    ScopeId: u32,
};

pub const PNRP_EXTENDED_PAYLOAD_TYPE = enum(i32) {
    NONE = 0,
    BINARY = 1,
    STRING = 2,
};
pub const PNRP_EXTENDED_PAYLOAD_TYPE_NONE = PNRP_EXTENDED_PAYLOAD_TYPE.NONE;
pub const PNRP_EXTENDED_PAYLOAD_TYPE_BINARY = PNRP_EXTENDED_PAYLOAD_TYPE.BINARY;
pub const PNRP_EXTENDED_PAYLOAD_TYPE_STRING = PNRP_EXTENDED_PAYLOAD_TYPE.STRING;

pub const PNRPINFO_V1 = extern struct {
    dwSize: u32,
    lpwszIdentity: ?PWSTR,
    nMaxResolve: u32,
    dwTimeout: u32,
    dwLifetime: u32,
    enResolveCriteria: PNRP_RESOLVE_CRITERIA,
    dwFlags: u32,
    saHint: SOCKET_ADDRESS,
    enNameState: PNRP_REGISTERED_ID_STATE,
};

pub const PNRPINFO_V2 = extern struct {
    dwSize: u32,
    lpwszIdentity: ?PWSTR,
    nMaxResolve: u32,
    dwTimeout: u32,
    dwLifetime: u32,
    enResolveCriteria: PNRP_RESOLVE_CRITERIA,
    dwFlags: u32,
    saHint: SOCKET_ADDRESS,
    enNameState: PNRP_REGISTERED_ID_STATE,
    enExtendedPayloadType: PNRP_EXTENDED_PAYLOAD_TYPE,
    Anonymous: extern union {
        blobPayload: BLOB,
        pwszPayload: ?PWSTR,
    },
};

pub const PNRPCLOUDINFO = extern struct {
    dwSize: u32,
    Cloud: PNRP_CLOUD_ID,
    enCloudState: PNRP_CLOUD_STATE,
    enCloudFlags: PNRP_CLOUD_FLAGS,
};

pub const PEER_RECORD_CHANGE_TYPE = enum(i32) {
    ADDED = 1,
    UPDATED = 2,
    DELETED = 3,
    EXPIRED = 4,
};
pub const PEER_RECORD_ADDED = PEER_RECORD_CHANGE_TYPE.ADDED;
pub const PEER_RECORD_UPDATED = PEER_RECORD_CHANGE_TYPE.UPDATED;
pub const PEER_RECORD_DELETED = PEER_RECORD_CHANGE_TYPE.DELETED;
pub const PEER_RECORD_EXPIRED = PEER_RECORD_CHANGE_TYPE.EXPIRED;

pub const PEER_CONNECTION_STATUS = enum(i32) {
    CONNECTED = 1,
    DISCONNECTED = 2,
    CONNECTION_FAILED = 3,
};
pub const PEER_CONNECTED = PEER_CONNECTION_STATUS.CONNECTED;
pub const PEER_DISCONNECTED = PEER_CONNECTION_STATUS.DISCONNECTED;
pub const PEER_CONNECTION_FAILED = PEER_CONNECTION_STATUS.CONNECTION_FAILED;

pub const PEER_CONNECTION_FLAGS = enum(i32) {
    NEIGHBOR = 1,
    DIRECT = 2,
};
pub const PEER_CONNECTION_NEIGHBOR = PEER_CONNECTION_FLAGS.NEIGHBOR;
pub const PEER_CONNECTION_DIRECT = PEER_CONNECTION_FLAGS.DIRECT;

pub const PEER_RECORD_FLAGS = enum(i32) {
    AUTOREFRESH = 1,
    DELETED = 2,
};
pub const PEER_RECORD_FLAG_AUTOREFRESH = PEER_RECORD_FLAGS.AUTOREFRESH;
pub const PEER_RECORD_FLAG_DELETED = PEER_RECORD_FLAGS.DELETED;

pub const PEER_VERSION_DATA = extern struct {
    wVersion: u16,
    wHighestVersion: u16,
};

pub const PEER_DATA = extern struct {
    cbData: u32,
    pbData: ?*u8,
};

pub const PEER_RECORD = extern struct {
    dwSize: u32,
    type: Guid,
    id: Guid,
    dwVersion: u32,
    dwFlags: u32,
    pwzCreatorId: ?PWSTR,
    pwzModifiedById: ?PWSTR,
    pwzAttributes: ?PWSTR,
    ftCreation: FILETIME,
    ftExpiration: FILETIME,
    ftLastModified: FILETIME,
    securityData: PEER_DATA,
    data: PEER_DATA,
};

pub const PEER_ADDRESS = extern struct {
    dwSize: u32,
    sin6: SOCKADDR_IN6,
};

pub const PEER_CONNECTION_INFO = extern struct {
    dwSize: u32,
    dwFlags: u32,
    ullConnectionId: u64,
    ullNodeId: u64,
    pwzPeerId: ?PWSTR,
    address: PEER_ADDRESS,
};

pub const PEER_EVENT_INCOMING_DATA = extern struct {
    dwSize: u32,
    ullConnectionId: u64,
    type: Guid,
    data: PEER_DATA,
};

pub const PEER_EVENT_RECORD_CHANGE_DATA = extern struct {
    dwSize: u32,
    changeType: PEER_RECORD_CHANGE_TYPE,
    recordId: Guid,
    recordType: Guid,
};

pub const PEER_EVENT_CONNECTION_CHANGE_DATA = extern struct {
    dwSize: u32,
    status: PEER_CONNECTION_STATUS,
    ullConnectionId: u64,
    ullNodeId: u64,
    ullNextConnectionId: u64,
    hrConnectionFailedReason: HRESULT,
};

pub const PEER_EVENT_SYNCHRONIZED_DATA = extern struct {
    dwSize: u32,
    recordType: Guid,
};

pub const PEER_GRAPH_EVENT_TYPE = enum(i32) {
    STATUS_CHANGED = 1,
    PROPERTY_CHANGED = 2,
    RECORD_CHANGED = 3,
    DIRECT_CONNECTION = 4,
    NEIGHBOR_CONNECTION = 5,
    INCOMING_DATA = 6,
    CONNECTION_REQUIRED = 7,
    NODE_CHANGED = 8,
    SYNCHRONIZED = 9,
};
pub const PEER_GRAPH_EVENT_STATUS_CHANGED = PEER_GRAPH_EVENT_TYPE.STATUS_CHANGED;
pub const PEER_GRAPH_EVENT_PROPERTY_CHANGED = PEER_GRAPH_EVENT_TYPE.PROPERTY_CHANGED;
pub const PEER_GRAPH_EVENT_RECORD_CHANGED = PEER_GRAPH_EVENT_TYPE.RECORD_CHANGED;
pub const PEER_GRAPH_EVENT_DIRECT_CONNECTION = PEER_GRAPH_EVENT_TYPE.DIRECT_CONNECTION;
pub const PEER_GRAPH_EVENT_NEIGHBOR_CONNECTION = PEER_GRAPH_EVENT_TYPE.NEIGHBOR_CONNECTION;
pub const PEER_GRAPH_EVENT_INCOMING_DATA = PEER_GRAPH_EVENT_TYPE.INCOMING_DATA;
pub const PEER_GRAPH_EVENT_CONNECTION_REQUIRED = PEER_GRAPH_EVENT_TYPE.CONNECTION_REQUIRED;
pub const PEER_GRAPH_EVENT_NODE_CHANGED = PEER_GRAPH_EVENT_TYPE.NODE_CHANGED;
pub const PEER_GRAPH_EVENT_SYNCHRONIZED = PEER_GRAPH_EVENT_TYPE.SYNCHRONIZED;

pub const PEER_NODE_CHANGE_TYPE = enum(i32) {
    CONNECTED = 1,
    DISCONNECTED = 2,
    UPDATED = 3,
};
pub const PEER_NODE_CHANGE_CONNECTED = PEER_NODE_CHANGE_TYPE.CONNECTED;
pub const PEER_NODE_CHANGE_DISCONNECTED = PEER_NODE_CHANGE_TYPE.DISCONNECTED;
pub const PEER_NODE_CHANGE_UPDATED = PEER_NODE_CHANGE_TYPE.UPDATED;

pub const PEER_GRAPH_STATUS_FLAGS = enum(i32) {
    LISTENING = 1,
    HAS_CONNECTIONS = 2,
    SYNCHRONIZED = 4,
};
pub const PEER_GRAPH_STATUS_LISTENING = PEER_GRAPH_STATUS_FLAGS.LISTENING;
pub const PEER_GRAPH_STATUS_HAS_CONNECTIONS = PEER_GRAPH_STATUS_FLAGS.HAS_CONNECTIONS;
pub const PEER_GRAPH_STATUS_SYNCHRONIZED = PEER_GRAPH_STATUS_FLAGS.SYNCHRONIZED;

pub const PEER_GRAPH_PROPERTY_FLAGS = enum(i32) {
    HEARTBEATS = 1,
    DEFER_EXPIRATION = 2,
};
pub const PEER_GRAPH_PROPERTY_HEARTBEATS = PEER_GRAPH_PROPERTY_FLAGS.HEARTBEATS;
pub const PEER_GRAPH_PROPERTY_DEFER_EXPIRATION = PEER_GRAPH_PROPERTY_FLAGS.DEFER_EXPIRATION;

pub const PEER_GRAPH_SCOPE = enum(i32) {
    ANY = 0,
    GLOBAL = 1,
    SITELOCAL = 2,
    LINKLOCAL = 3,
    LOOPBACK = 4,
};
pub const PEER_GRAPH_SCOPE_ANY = PEER_GRAPH_SCOPE.ANY;
pub const PEER_GRAPH_SCOPE_GLOBAL = PEER_GRAPH_SCOPE.GLOBAL;
pub const PEER_GRAPH_SCOPE_SITELOCAL = PEER_GRAPH_SCOPE.SITELOCAL;
pub const PEER_GRAPH_SCOPE_LINKLOCAL = PEER_GRAPH_SCOPE.LINKLOCAL;
pub const PEER_GRAPH_SCOPE_LOOPBACK = PEER_GRAPH_SCOPE.LOOPBACK;

pub const PEER_GRAPH_PROPERTIES = extern struct {
    dwSize: u32,
    dwFlags: u32,
    dwScope: u32,
    dwMaxRecordSize: u32,
    pwzGraphId: ?PWSTR,
    pwzCreatorId: ?PWSTR,
    pwzFriendlyName: ?PWSTR,
    pwzComment: ?PWSTR,
    ulPresenceLifetime: u32,
    cPresenceMax: u32,
};

pub const PEER_NODE_INFO = extern struct {
    dwSize: u32,
    ullNodeId: u64,
    pwzPeerId: ?PWSTR,
    cAddresses: u32,
    pAddresses: ?*PEER_ADDRESS,
    pwzAttributes: ?PWSTR,
};

pub const PEER_EVENT_NODE_CHANGE_DATA = extern struct {
    dwSize: u32,
    changeType: PEER_NODE_CHANGE_TYPE,
    ullNodeId: u64,
    pwzPeerId: ?PWSTR,
};

pub const PEER_GRAPH_EVENT_REGISTRATION = extern struct {
    eventType: PEER_GRAPH_EVENT_TYPE,
    pType: ?*Guid,
};

pub const PEER_GRAPH_EVENT_DATA = extern struct {
    eventType: PEER_GRAPH_EVENT_TYPE,
    Anonymous: extern union {
        dwStatus: PEER_GRAPH_STATUS_FLAGS,
        incomingData: PEER_EVENT_INCOMING_DATA,
        recordChangeData: PEER_EVENT_RECORD_CHANGE_DATA,
        connectionChangeData: PEER_EVENT_CONNECTION_CHANGE_DATA,
        nodeChangeData: PEER_EVENT_NODE_CHANGE_DATA,
        synchronizedData: PEER_EVENT_SYNCHRONIZED_DATA,
    },
};

pub const PFNPEER_VALIDATE_RECORD = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        hGraph: ?*anyopaque,
        pvContext: ?*anyopaque,
        pRecord: ?*PEER_RECORD,
        changeType: PEER_RECORD_CHANGE_TYPE,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        hGraph: ?*anyopaque,
        pvContext: ?*anyopaque,
        pRecord: ?*PEER_RECORD,
        changeType: PEER_RECORD_CHANGE_TYPE,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const PFNPEER_SECURE_RECORD = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        hGraph: ?*anyopaque,
        pvContext: ?*anyopaque,
        pRecord: ?*PEER_RECORD,
        changeType: PEER_RECORD_CHANGE_TYPE,
        ppSecurityData: ?*?*PEER_DATA,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        hGraph: ?*anyopaque,
        pvContext: ?*anyopaque,
        pRecord: ?*PEER_RECORD,
        changeType: PEER_RECORD_CHANGE_TYPE,
        ppSecurityData: ?*?*PEER_DATA,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const PFNPEER_FREE_SECURITY_DATA = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        hGraph: ?*anyopaque,
        pvContext: ?*anyopaque,
        pSecurityData: ?*PEER_DATA,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        hGraph: ?*anyopaque,
        pvContext: ?*anyopaque,
        pSecurityData: ?*PEER_DATA,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const PFNPEER_ON_PASSWORD_AUTH_FAILED = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        hGraph: ?*anyopaque,
        pvContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        hGraph: ?*anyopaque,
        pvContext: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const PEER_SECURITY_INTERFACE = extern struct {
    dwSize: u32,
    pwzSspFilename: ?PWSTR,
    pwzPackageName: ?PWSTR,
    cbSecurityInfo: u32,
    pbSecurityInfo: ?*u8,
    pvContext: ?*anyopaque,
    pfnValidateRecord: ?PFNPEER_VALIDATE_RECORD,
    pfnSecureRecord: ?PFNPEER_SECURE_RECORD,
    pfnFreeSecurityData: ?PFNPEER_FREE_SECURITY_DATA,
    pfnAuthFailed: ?PFNPEER_ON_PASSWORD_AUTH_FAILED,
};

pub const PEER_GROUP_EVENT_TYPE = enum(i32) {
    STATUS_CHANGED = 1,
    PROPERTY_CHANGED = 2,
    RECORD_CHANGED = 3,
    DIRECT_CONNECTION = 4,
    NEIGHBOR_CONNECTION = 5,
    INCOMING_DATA = 6,
    MEMBER_CHANGED = 8,
    CONNECTION_FAILED = 10,
    AUTHENTICATION_FAILED = 11,
};
pub const PEER_GROUP_EVENT_STATUS_CHANGED = PEER_GROUP_EVENT_TYPE.STATUS_CHANGED;
pub const PEER_GROUP_EVENT_PROPERTY_CHANGED = PEER_GROUP_EVENT_TYPE.PROPERTY_CHANGED;
pub const PEER_GROUP_EVENT_RECORD_CHANGED = PEER_GROUP_EVENT_TYPE.RECORD_CHANGED;
pub const PEER_GROUP_EVENT_DIRECT_CONNECTION = PEER_GROUP_EVENT_TYPE.DIRECT_CONNECTION;
pub const PEER_GROUP_EVENT_NEIGHBOR_CONNECTION = PEER_GROUP_EVENT_TYPE.NEIGHBOR_CONNECTION;
pub const PEER_GROUP_EVENT_INCOMING_DATA = PEER_GROUP_EVENT_TYPE.INCOMING_DATA;
pub const PEER_GROUP_EVENT_MEMBER_CHANGED = PEER_GROUP_EVENT_TYPE.MEMBER_CHANGED;
pub const PEER_GROUP_EVENT_CONNECTION_FAILED = PEER_GROUP_EVENT_TYPE.CONNECTION_FAILED;
pub const PEER_GROUP_EVENT_AUTHENTICATION_FAILED = PEER_GROUP_EVENT_TYPE.AUTHENTICATION_FAILED;

pub const PEER_GROUP_STATUS = enum(i32) {
    LISTENING = 1,
    HAS_CONNECTIONS = 2,
};
pub const PEER_GROUP_STATUS_LISTENING = PEER_GROUP_STATUS.LISTENING;
pub const PEER_GROUP_STATUS_HAS_CONNECTIONS = PEER_GROUP_STATUS.HAS_CONNECTIONS;

pub const PEER_GROUP_PROPERTY_FLAGS = enum(i32) {
    MEMBER_DATA_OPTIONAL = 1,
    DISABLE_PRESENCE = 2,
    DEFER_EXPIRATION = 4,
};
pub const PEER_MEMBER_DATA_OPTIONAL = PEER_GROUP_PROPERTY_FLAGS.MEMBER_DATA_OPTIONAL;
pub const PEER_DISABLE_PRESENCE = PEER_GROUP_PROPERTY_FLAGS.DISABLE_PRESENCE;
pub const PEER_DEFER_EXPIRATION = PEER_GROUP_PROPERTY_FLAGS.DEFER_EXPIRATION;

pub const PEER_GROUP_AUTHENTICATION_SCHEME = enum(i32) {
    GMC_AUTHENTICATION = 1,
    PASSWORD_AUTHENTICATION = 2,
};
pub const PEER_GROUP_GMC_AUTHENTICATION = PEER_GROUP_AUTHENTICATION_SCHEME.GMC_AUTHENTICATION;
pub const PEER_GROUP_PASSWORD_AUTHENTICATION = PEER_GROUP_AUTHENTICATION_SCHEME.PASSWORD_AUTHENTICATION;

pub const PEER_MEMBER_FLAGS = enum(i32) {
    T = 1,
};
pub const PEER_MEMBER_PRESENT = PEER_MEMBER_FLAGS.T;

pub const PEER_MEMBER_CHANGE_TYPE = enum(i32) {
    CONNECTED = 1,
    DISCONNECTED = 2,
    UPDATED = 3,
    JOINED = 4,
    LEFT = 5,
};
pub const PEER_MEMBER_CONNECTED = PEER_MEMBER_CHANGE_TYPE.CONNECTED;
pub const PEER_MEMBER_DISCONNECTED = PEER_MEMBER_CHANGE_TYPE.DISCONNECTED;
pub const PEER_MEMBER_UPDATED = PEER_MEMBER_CHANGE_TYPE.UPDATED;
pub const PEER_MEMBER_JOINED = PEER_MEMBER_CHANGE_TYPE.JOINED;
pub const PEER_MEMBER_LEFT = PEER_MEMBER_CHANGE_TYPE.LEFT;

pub const PEER_GROUP_ISSUE_CREDENTIAL_FLAGS = enum(i32) {
    S = 1,
};
pub const PEER_GROUP_STORE_CREDENTIALS = PEER_GROUP_ISSUE_CREDENTIAL_FLAGS.S;

pub const PEER_CREDENTIAL_INFO = extern struct {
    dwSize: u32,
    dwFlags: u32,
    pwzFriendlyName: ?PWSTR,
    pPublicKey: ?*CERT_PUBLIC_KEY_INFO,
    pwzIssuerPeerName: ?PWSTR,
    pwzIssuerFriendlyName: ?PWSTR,
    ftValidityStart: FILETIME,
    ftValidityEnd: FILETIME,
    cRoles: u32,
    pRoles: ?*Guid,
};

pub const PEER_MEMBER = extern struct {
    dwSize: u32,
    dwFlags: u32,
    pwzIdentity: ?PWSTR,
    pwzAttributes: ?PWSTR,
    ullNodeId: u64,
    cAddresses: u32,
    pAddresses: ?*PEER_ADDRESS,
    pCredentialInfo: ?*PEER_CREDENTIAL_INFO,
};

pub const PEER_INVITATION_INFO = extern struct {
    dwSize: u32,
    dwFlags: u32,
    pwzCloudName: ?PWSTR,
    dwScope: u32,
    dwCloudFlags: u32,
    pwzGroupPeerName: ?PWSTR,
    pwzIssuerPeerName: ?PWSTR,
    pwzSubjectPeerName: ?PWSTR,
    pwzGroupFriendlyName: ?PWSTR,
    pwzIssuerFriendlyName: ?PWSTR,
    pwzSubjectFriendlyName: ?PWSTR,
    ftValidityStart: FILETIME,
    ftValidityEnd: FILETIME,
    cRoles: u32,
    pRoles: ?*Guid,
    cClassifiers: u32,
    ppwzClassifiers: ?*?PWSTR,
    pSubjectPublicKey: ?*CERT_PUBLIC_KEY_INFO,
    authScheme: PEER_GROUP_AUTHENTICATION_SCHEME,
};

pub const PEER_GROUP_PROPERTIES = extern struct {
    dwSize: u32,
    dwFlags: u32,
    pwzCloud: ?PWSTR,
    pwzClassifier: ?PWSTR,
    pwzGroupPeerName: ?PWSTR,
    pwzCreatorPeerName: ?PWSTR,
    pwzFriendlyName: ?PWSTR,
    pwzComment: ?PWSTR,
    ulMemberDataLifetime: u32,
    ulPresenceLifetime: u32,
    dwAuthenticationSchemes: u32,
    pwzGroupPassword: ?PWSTR,
    groupPasswordRole: Guid,
};

pub const PEER_EVENT_MEMBER_CHANGE_DATA = extern struct {
    dwSize: u32,
    changeType: PEER_MEMBER_CHANGE_TYPE,
    pwzIdentity: ?PWSTR,
};

pub const PEER_GROUP_EVENT_REGISTRATION = extern struct {
    eventType: PEER_GROUP_EVENT_TYPE,
    pType: ?*Guid,
};

pub const PEER_GROUP_EVENT_DATA = extern struct {
    eventType: PEER_GROUP_EVENT_TYPE,
    Anonymous: extern union {
        dwStatus: PEER_GROUP_STATUS,
        incomingData: PEER_EVENT_INCOMING_DATA,
        recordChangeData: PEER_EVENT_RECORD_CHANGE_DATA,
        connectionChangeData: PEER_EVENT_CONNECTION_CHANGE_DATA,
        memberChangeData: PEER_EVENT_MEMBER_CHANGE_DATA,
        hrConnectionFailedReason: HRESULT,
    },
};

pub const PEER_NAME_PAIR = extern struct {
    dwSize: u32,
    pwzPeerName: ?PWSTR,
    pwzFriendlyName: ?PWSTR,
};

pub const PEER_SIGNIN_FLAGS = enum(i32) {
    NONE = 0,
    NEAR_ME = 1,
    INTERNET = 2,
    ALL = 3,
};
pub const PEER_SIGNIN_NONE = PEER_SIGNIN_FLAGS.NONE;
pub const PEER_SIGNIN_NEAR_ME = PEER_SIGNIN_FLAGS.NEAR_ME;
pub const PEER_SIGNIN_INTERNET = PEER_SIGNIN_FLAGS.INTERNET;
pub const PEER_SIGNIN_ALL = PEER_SIGNIN_FLAGS.ALL;

pub const PEER_WATCH_PERMISSION = enum(i32) {
    BLOCKED = 0,
    ALLOWED = 1,
};
pub const PEER_WATCH_BLOCKED = PEER_WATCH_PERMISSION.BLOCKED;
pub const PEER_WATCH_ALLOWED = PEER_WATCH_PERMISSION.ALLOWED;

pub const PEER_PUBLICATION_SCOPE = enum(i32) {
    NONE = 0,
    NEAR_ME = 1,
    INTERNET = 2,
    ALL = 3,
};
pub const PEER_PUBLICATION_SCOPE_NONE = PEER_PUBLICATION_SCOPE.NONE;
pub const PEER_PUBLICATION_SCOPE_NEAR_ME = PEER_PUBLICATION_SCOPE.NEAR_ME;
pub const PEER_PUBLICATION_SCOPE_INTERNET = PEER_PUBLICATION_SCOPE.INTERNET;
pub const PEER_PUBLICATION_SCOPE_ALL = PEER_PUBLICATION_SCOPE.ALL;

pub const PEER_APPLICATION = extern struct {
    id: Guid,
    data: PEER_DATA,
    pwzDescription: ?PWSTR,
};

pub const PEER_OBJECT = extern struct {
    id: Guid,
    data: PEER_DATA,
    dwPublicationScope: u32,
};

pub const PEER_CONTACT = extern struct {
    pwzPeerName: ?PWSTR,
    pwzNickName: ?PWSTR,
    pwzDisplayName: ?PWSTR,
    pwzEmailAddress: ?PWSTR,
    fWatch: BOOL,
    WatcherPermissions: PEER_WATCH_PERMISSION,
    credentials: PEER_DATA,
};

pub const PEER_ENDPOINT = extern struct {
    address: PEER_ADDRESS,
    pwzEndpointName: ?PWSTR,
};

pub const PEER_PEOPLE_NEAR_ME = extern struct {
    pwzNickName: ?PWSTR,
    endpoint: PEER_ENDPOINT,
    id: Guid,
};

pub const PEER_INVITATION_RESPONSE_TYPE = enum(i32) {
    DECLINED = 0,
    ACCEPTED = 1,
    EXPIRED = 2,
    ERROR = 3,
};
pub const PEER_INVITATION_RESPONSE_DECLINED = PEER_INVITATION_RESPONSE_TYPE.DECLINED;
pub const PEER_INVITATION_RESPONSE_ACCEPTED = PEER_INVITATION_RESPONSE_TYPE.ACCEPTED;
pub const PEER_INVITATION_RESPONSE_EXPIRED = PEER_INVITATION_RESPONSE_TYPE.EXPIRED;
pub const PEER_INVITATION_RESPONSE_ERROR = PEER_INVITATION_RESPONSE_TYPE.ERROR;

pub const PEER_APPLICATION_REGISTRATION_TYPE = enum(i32) {
    CURRENT_USER = 0,
    ALL_USERS = 1,
};
pub const PEER_APPLICATION_CURRENT_USER = PEER_APPLICATION_REGISTRATION_TYPE.CURRENT_USER;
pub const PEER_APPLICATION_ALL_USERS = PEER_APPLICATION_REGISTRATION_TYPE.ALL_USERS;

pub const PEER_INVITATION = extern struct {
    applicationId: Guid,
    applicationData: PEER_DATA,
    pwzMessage: ?PWSTR,
};

pub const PEER_INVITATION_RESPONSE = extern struct {
    action: PEER_INVITATION_RESPONSE_TYPE,
    pwzMessage: ?PWSTR,
    hrExtendedInfo: HRESULT,
};

pub const PEER_APP_LAUNCH_INFO = extern struct {
    pContact: ?*PEER_CONTACT,
    pEndpoint: ?*PEER_ENDPOINT,
    pInvitation: ?*PEER_INVITATION,
};

pub const PEER_APPLICATION_REGISTRATION_INFO = extern struct {
    application: PEER_APPLICATION,
    pwzApplicationToLaunch: ?PWSTR,
    pwzApplicationArguments: ?PWSTR,
    dwPublicationScope: u32,
};

pub const PEER_PRESENCE_STATUS = enum(i32) {
    OFFLINE = 0,
    OUT_TO_LUNCH = 1,
    AWAY = 2,
    BE_RIGHT_BACK = 3,
    IDLE = 4,
    BUSY = 5,
    ON_THE_PHONE = 6,
    ONLINE = 7,
};
pub const PEER_PRESENCE_OFFLINE = PEER_PRESENCE_STATUS.OFFLINE;
pub const PEER_PRESENCE_OUT_TO_LUNCH = PEER_PRESENCE_STATUS.OUT_TO_LUNCH;
pub const PEER_PRESENCE_AWAY = PEER_PRESENCE_STATUS.AWAY;
pub const PEER_PRESENCE_BE_RIGHT_BACK = PEER_PRESENCE_STATUS.BE_RIGHT_BACK;
pub const PEER_PRESENCE_IDLE = PEER_PRESENCE_STATUS.IDLE;
pub const PEER_PRESENCE_BUSY = PEER_PRESENCE_STATUS.BUSY;
pub const PEER_PRESENCE_ON_THE_PHONE = PEER_PRESENCE_STATUS.ON_THE_PHONE;
pub const PEER_PRESENCE_ONLINE = PEER_PRESENCE_STATUS.ONLINE;

pub const PEER_PRESENCE_INFO = extern struct {
    status: PEER_PRESENCE_STATUS,
    pwzDescriptiveText: ?PWSTR,
};

pub const PEER_CHANGE_TYPE = enum(i32) {
    ADDED = 0,
    DELETED = 1,
    UPDATED = 2,
};
pub const PEER_CHANGE_ADDED = PEER_CHANGE_TYPE.ADDED;
pub const PEER_CHANGE_DELETED = PEER_CHANGE_TYPE.DELETED;
pub const PEER_CHANGE_UPDATED = PEER_CHANGE_TYPE.UPDATED;

pub const PEER_COLLAB_EVENT_TYPE = enum(i32) {
    WATCHLIST_CHANGED = 1,
    ENDPOINT_CHANGED = 2,
    ENDPOINT_PRESENCE_CHANGED = 3,
    ENDPOINT_APPLICATION_CHANGED = 4,
    ENDPOINT_OBJECT_CHANGED = 5,
    MY_ENDPOINT_CHANGED = 6,
    MY_PRESENCE_CHANGED = 7,
    MY_APPLICATION_CHANGED = 8,
    MY_OBJECT_CHANGED = 9,
    PEOPLE_NEAR_ME_CHANGED = 10,
    REQUEST_STATUS_CHANGED = 11,
};
pub const PEER_EVENT_WATCHLIST_CHANGED = PEER_COLLAB_EVENT_TYPE.WATCHLIST_CHANGED;
pub const PEER_EVENT_ENDPOINT_CHANGED = PEER_COLLAB_EVENT_TYPE.ENDPOINT_CHANGED;
pub const PEER_EVENT_ENDPOINT_PRESENCE_CHANGED = PEER_COLLAB_EVENT_TYPE.ENDPOINT_PRESENCE_CHANGED;
pub const PEER_EVENT_ENDPOINT_APPLICATION_CHANGED = PEER_COLLAB_EVENT_TYPE.ENDPOINT_APPLICATION_CHANGED;
pub const PEER_EVENT_ENDPOINT_OBJECT_CHANGED = PEER_COLLAB_EVENT_TYPE.ENDPOINT_OBJECT_CHANGED;
pub const PEER_EVENT_MY_ENDPOINT_CHANGED = PEER_COLLAB_EVENT_TYPE.MY_ENDPOINT_CHANGED;
pub const PEER_EVENT_MY_PRESENCE_CHANGED = PEER_COLLAB_EVENT_TYPE.MY_PRESENCE_CHANGED;
pub const PEER_EVENT_MY_APPLICATION_CHANGED = PEER_COLLAB_EVENT_TYPE.MY_APPLICATION_CHANGED;
pub const PEER_EVENT_MY_OBJECT_CHANGED = PEER_COLLAB_EVENT_TYPE.MY_OBJECT_CHANGED;
pub const PEER_EVENT_PEOPLE_NEAR_ME_CHANGED = PEER_COLLAB_EVENT_TYPE.PEOPLE_NEAR_ME_CHANGED;
pub const PEER_EVENT_REQUEST_STATUS_CHANGED = PEER_COLLAB_EVENT_TYPE.REQUEST_STATUS_CHANGED;

pub const PEER_COLLAB_EVENT_REGISTRATION = extern struct {
    eventType: PEER_COLLAB_EVENT_TYPE,
    pInstance: ?*Guid,
};

pub const PEER_EVENT_WATCHLIST_CHANGED_DATA = extern struct {
    pContact: ?*PEER_CONTACT,
    changeType: PEER_CHANGE_TYPE,
};

pub const PEER_EVENT_PRESENCE_CHANGED_DATA = extern struct {
    pContact: ?*PEER_CONTACT,
    pEndpoint: ?*PEER_ENDPOINT,
    changeType: PEER_CHANGE_TYPE,
    pPresenceInfo: ?*PEER_PRESENCE_INFO,
};

pub const PEER_EVENT_APPLICATION_CHANGED_DATA = extern struct {
    pContact: ?*PEER_CONTACT,
    pEndpoint: ?*PEER_ENDPOINT,
    changeType: PEER_CHANGE_TYPE,
    pApplication: ?*PEER_APPLICATION,
};

pub const PEER_EVENT_OBJECT_CHANGED_DATA = extern struct {
    pContact: ?*PEER_CONTACT,
    pEndpoint: ?*PEER_ENDPOINT,
    changeType: PEER_CHANGE_TYPE,
    pObject: ?*PEER_OBJECT,
};

pub const PEER_EVENT_ENDPOINT_CHANGED_DATA = extern struct {
    pContact: ?*PEER_CONTACT,
    pEndpoint: ?*PEER_ENDPOINT,
};

pub const PEER_EVENT_PEOPLE_NEAR_ME_CHANGED_DATA = extern struct {
    changeType: PEER_CHANGE_TYPE,
    pPeopleNearMe: ?*PEER_PEOPLE_NEAR_ME,
};

pub const PEER_EVENT_REQUEST_STATUS_CHANGED_DATA = extern struct {
    pEndpoint: ?*PEER_ENDPOINT,
    hrChange: HRESULT,
};

pub const PEER_COLLAB_EVENT_DATA = extern struct {
    eventType: PEER_COLLAB_EVENT_TYPE,
    Anonymous: extern union {
        watchListChangedData: PEER_EVENT_WATCHLIST_CHANGED_DATA,
        presenceChangedData: PEER_EVENT_PRESENCE_CHANGED_DATA,
        applicationChangedData: PEER_EVENT_APPLICATION_CHANGED_DATA,
        objectChangedData: PEER_EVENT_OBJECT_CHANGED_DATA,
        endpointChangedData: PEER_EVENT_ENDPOINT_CHANGED_DATA,
        peopleNearMeChangedData: PEER_EVENT_PEOPLE_NEAR_ME_CHANGED_DATA,
        requestStatusChangedData: PEER_EVENT_REQUEST_STATUS_CHANGED_DATA,
    },
};

pub const PEER_PNRP_ENDPOINT_INFO = extern struct {
    pwzPeerName: ?PWSTR,
    cAddresses: u32,
    ppAddresses: ?*?*SOCKADDR,
    pwzComment: ?PWSTR,
    payload: PEER_DATA,
};

pub const PEER_PNRP_CLOUD_INFO = extern struct {
    pwzCloudName: ?PWSTR,
    dwScope: PNRP_SCOPE,
    dwScopeId: u32,
};

pub const PEER_PNRP_REGISTRATION_INFO = extern struct {
    pwzCloudName: ?PWSTR,
    pwzPublishingIdentity: ?PWSTR,
    cAddresses: u32,
    ppAddresses: ?*?*SOCKADDR,
    wPort: u16,
    pwzComment: ?PWSTR,
    payload: PEER_DATA,
};

pub const DRT_SCOPE = enum(i32) {
    GLOBAL_SCOPE = 1,
    SITE_LOCAL_SCOPE = 2,
    LINK_LOCAL_SCOPE = 3,
};
pub const DRT_GLOBAL_SCOPE = DRT_SCOPE.GLOBAL_SCOPE;
pub const DRT_SITE_LOCAL_SCOPE = DRT_SCOPE.SITE_LOCAL_SCOPE;
pub const DRT_LINK_LOCAL_SCOPE = DRT_SCOPE.LINK_LOCAL_SCOPE;

pub const DRT_STATUS = enum(i32) {
    ACTIVE = 0,
    ALONE = 1,
    NO_NETWORK = 10,
    FAULTED = 20,
};
pub const DRT_ACTIVE = DRT_STATUS.ACTIVE;
pub const DRT_ALONE = DRT_STATUS.ALONE;
pub const DRT_NO_NETWORK = DRT_STATUS.NO_NETWORK;
pub const DRT_FAULTED = DRT_STATUS.FAULTED;

pub const DRT_MATCH_TYPE = enum(i32) {
    EXACT = 0,
    NEAR = 1,
    INTERMEDIATE = 2,
};
pub const DRT_MATCH_EXACT = DRT_MATCH_TYPE.EXACT;
pub const DRT_MATCH_NEAR = DRT_MATCH_TYPE.NEAR;
pub const DRT_MATCH_INTERMEDIATE = DRT_MATCH_TYPE.INTERMEDIATE;

pub const DRT_LEAFSET_KEY_CHANGE_TYPE = enum(i32) {
    ADDED = 0,
    DELETED = 1,
};
pub const DRT_LEAFSET_KEY_ADDED = DRT_LEAFSET_KEY_CHANGE_TYPE.ADDED;
pub const DRT_LEAFSET_KEY_DELETED = DRT_LEAFSET_KEY_CHANGE_TYPE.DELETED;

pub const DRT_EVENT_TYPE = enum(i32) {
    STATUS_CHANGED = 0,
    LEAFSET_KEY_CHANGED = 1,
    REGISTRATION_STATE_CHANGED = 2,
};
pub const DRT_EVENT_STATUS_CHANGED = DRT_EVENT_TYPE.STATUS_CHANGED;
pub const DRT_EVENT_LEAFSET_KEY_CHANGED = DRT_EVENT_TYPE.LEAFSET_KEY_CHANGED;
pub const DRT_EVENT_REGISTRATION_STATE_CHANGED = DRT_EVENT_TYPE.REGISTRATION_STATE_CHANGED;

pub const DRT_SECURITY_MODE = enum(i32) {
    RESOLVE = 0,
    MEMBERSHIP = 1,
    CONFIDENTIALPAYLOAD = 2,
};
pub const DRT_SECURE_RESOLVE = DRT_SECURITY_MODE.RESOLVE;
pub const DRT_SECURE_MEMBERSHIP = DRT_SECURITY_MODE.MEMBERSHIP;
pub const DRT_SECURE_CONFIDENTIALPAYLOAD = DRT_SECURITY_MODE.CONFIDENTIALPAYLOAD;

pub const DRT_REGISTRATION_STATE = enum(i32) {
    E = 1,
};
pub const DRT_REGISTRATION_STATE_UNRESOLVEABLE = DRT_REGISTRATION_STATE.E;

pub const DRT_ADDRESS_FLAGS = enum(i32) {
    ACCEPTED = 1,
    REJECTED = 2,
    UNREACHABLE = 4,
    LOOP = 8,
    TOO_BUSY = 16,
    BAD_VALIDATE_ID = 32,
    SUSPECT_UNREGISTERED_ID = 64,
    INQUIRE = 128,
};
pub const DRT_ADDRESS_FLAG_ACCEPTED = DRT_ADDRESS_FLAGS.ACCEPTED;
pub const DRT_ADDRESS_FLAG_REJECTED = DRT_ADDRESS_FLAGS.REJECTED;
pub const DRT_ADDRESS_FLAG_UNREACHABLE = DRT_ADDRESS_FLAGS.UNREACHABLE;
pub const DRT_ADDRESS_FLAG_LOOP = DRT_ADDRESS_FLAGS.LOOP;
pub const DRT_ADDRESS_FLAG_TOO_BUSY = DRT_ADDRESS_FLAGS.TOO_BUSY;
pub const DRT_ADDRESS_FLAG_BAD_VALIDATE_ID = DRT_ADDRESS_FLAGS.BAD_VALIDATE_ID;
pub const DRT_ADDRESS_FLAG_SUSPECT_UNREGISTERED_ID = DRT_ADDRESS_FLAGS.SUSPECT_UNREGISTERED_ID;
pub const DRT_ADDRESS_FLAG_INQUIRE = DRT_ADDRESS_FLAGS.INQUIRE;

pub const DRT_DATA = extern struct {
    cb: u32,
    pb: ?*u8,
};

pub const DRT_REGISTRATION = extern struct {
    key: DRT_DATA,
    appData: DRT_DATA,
};

pub const DRT_SECURITY_PROVIDER = extern struct {
    pvContext: ?*anyopaque,
    Attach: isize,
    Detach: isize,
    RegisterKey: isize,
    UnregisterKey: isize,
    ValidateAndUnpackPayload: isize,
    SecureAndPackPayload: isize,
    FreeData: isize,
    EncryptData: isize,
    DecryptData: isize,
    GetSerializedCredential: isize,
    ValidateRemoteCredential: isize,
    SignData: isize,
    VerifyData: isize,
};

pub const DRT_BOOTSTRAP_RESOLVE_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        hr: HRESULT,
        pvContext: ?*anyopaque,
        pAddresses: ?*SOCKET_ADDRESS_LIST,
        fFatalError: BOOL,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        hr: HRESULT,
        pvContext: ?*anyopaque,
        pAddresses: ?*SOCKET_ADDRESS_LIST,
        fFatalError: BOOL,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const DRT_BOOTSTRAP_PROVIDER = extern struct {
    pvContext: ?*anyopaque,
    Attach: isize,
    Detach: isize,
    InitResolve: isize,
    IssueResolve: isize,
    EndResolve: isize,
    Register: isize,
    Unregister: isize,
};

pub const DRT_SETTINGS = extern struct {
    dwSize: u32,
    cbKey: u32,
    bProtocolMajorVersion: u8,
    bProtocolMinorVersion: u8,
    ulMaxRoutingAddresses: u32,
    pwzDrtInstancePrefix: ?PWSTR,
    hTransport: ?*anyopaque,
    pSecurityProvider: ?*DRT_SECURITY_PROVIDER,
    pBootstrapProvider: ?*DRT_BOOTSTRAP_PROVIDER,
    eSecurityMode: DRT_SECURITY_MODE,
};

pub const DRT_SEARCH_INFO = extern struct {
    dwSize: u32,
    fIterative: BOOL,
    fAllowCurrentInstanceMatch: BOOL,
    fAnyMatchInRange: BOOL,
    cMaxEndpoints: u32,
    pMaximumKey: ?*DRT_DATA,
    pMinimumKey: ?*DRT_DATA,
};

pub const DRT_ADDRESS = extern struct {
    socketAddress: SOCKADDR_STORAGE,
    flags: u32,
    nearness: i32,
    latency: u32,
};

pub const DRT_ADDRESS_LIST = extern struct {
    AddressCount: u32,
    AddressList: [1]DRT_ADDRESS,
};

pub const DRT_SEARCH_RESULT = extern struct {
    dwSize: u32,
    type: DRT_MATCH_TYPE,
    pvContext: ?*anyopaque,
    registration: DRT_REGISTRATION,
};

pub const DRT_EVENT_DATA = extern struct {
    type: DRT_EVENT_TYPE,
    hr: HRESULT,
    pvContext: ?*anyopaque,
    Anonymous: extern union {
        leafsetKeyChange: extern struct {
            change: DRT_LEAFSET_KEY_CHANGE_TYPE,
            localKey: DRT_DATA,
            remoteKey: DRT_DATA,
        },
        registrationStateChange: extern struct {
            state: DRT_REGISTRATION_STATE,
            localKey: DRT_DATA,
        },
        statusChange: extern struct {
            status: DRT_STATUS,
            bootstrapAddresses: extern struct {
                cntAddress: u32,
                pAddresses: ?*SOCKADDR_STORAGE,
            },
        },
    },
};

pub const PEERDIST_STATUS = enum(i32) {
    DISABLED = 0,
    UNAVAILABLE = 1,
    AVAILABLE = 2,
};
pub const PEERDIST_STATUS_DISABLED = PEERDIST_STATUS.DISABLED;
pub const PEERDIST_STATUS_UNAVAILABLE = PEERDIST_STATUS.UNAVAILABLE;
pub const PEERDIST_STATUS_AVAILABLE = PEERDIST_STATUS.AVAILABLE;

pub const PEERDIST_PUBLICATION_OPTIONS = extern struct {
    dwVersion: u32,
    dwFlags: u32,
};

pub const PEERDIST_CONTENT_TAG = extern struct {
    Data: [16]u8,
};

pub const PEERDIST_RETRIEVAL_OPTIONS = extern struct {
    cbSize: u32,
    dwContentInfoMinVersion: u32,
    dwContentInfoMaxVersion: u32,
    dwReserved: u32,
};

pub const PEERDIST_STATUS_INFO = extern struct {
    cbSize: u32,
    status: PEERDIST_STATUS,
    dwMinVer: PEERDIST_RETRIEVAL_OPTIONS_CONTENTINFO_VERSION_VALUE,
    dwMaxVer: PEERDIST_RETRIEVAL_OPTIONS_CONTENTINFO_VERSION_VALUE,
};

pub const PEERDIST_CLIENT_INFO_BY_HANDLE_CLASS = enum(i32) {
    PeerDistClientBasicInfo = 0,
    MaximumPeerDistClientInfoByHandlesClass = 1,
};
pub const PeerDistClientBasicInfo = PEERDIST_CLIENT_INFO_BY_HANDLE_CLASS.PeerDistClientBasicInfo;
pub const MaximumPeerDistClientInfoByHandlesClass = PEERDIST_CLIENT_INFO_BY_HANDLE_CLASS.MaximumPeerDistClientInfoByHandlesClass;

pub const PEERDIST_CLIENT_BASIC_INFO = extern struct {
    fFlashCrowd: BOOL,
};

//--------------------------------------------------------------------------------
// Section: Functions (200)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphStartup(
    wVersionRequested: u16,
    pVersionData: ?*PEER_VERSION_DATA,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphShutdown() callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphFreeData(
    pvData: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphGetItemCount(
    hPeerEnum: ?*anyopaque,
    pCount: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphGetNextItem(
    hPeerEnum: ?*anyopaque,
    pCount: ?*u32,
    pppvItems: ?*?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphEndEnumeration(
    hPeerEnum: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphCreate(
    pGraphProperties: ?*PEER_GRAPH_PROPERTIES,
    pwzDatabaseName: ?[*:0]const u16,
    pSecurityInterface: ?*PEER_SECURITY_INTERFACE,
    phGraph: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphOpen(
    pwzGraphId: ?[*:0]const u16,
    pwzPeerId: ?[*:0]const u16,
    pwzDatabaseName: ?[*:0]const u16,
    pSecurityInterface: ?*PEER_SECURITY_INTERFACE,
    cRecordTypeSyncPrecedence: u32,
    pRecordTypeSyncPrecedence: ?[*]const Guid,
    phGraph: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphListen(
    hGraph: ?*anyopaque,
    dwScope: u32,
    dwScopeId: u32,
    wPort: u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphConnect(
    hGraph: ?*anyopaque,
    pwzPeerId: ?[*:0]const u16,
    pAddress: ?*PEER_ADDRESS,
    pullConnectionId: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphClose(
    hGraph: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphDelete(
    pwzGraphId: ?[*:0]const u16,
    pwzPeerId: ?[*:0]const u16,
    pwzDatabaseName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphGetStatus(
    hGraph: ?*anyopaque,
    pdwStatus: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphGetProperties(
    hGraph: ?*anyopaque,
    ppGraphProperties: ?*?*PEER_GRAPH_PROPERTIES,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphSetProperties(
    hGraph: ?*anyopaque,
    pGraphProperties: ?*PEER_GRAPH_PROPERTIES,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphRegisterEvent(
    hGraph: ?*anyopaque,
    hEvent: ?HANDLE,
    cEventRegistrations: u32,
    pEventRegistrations: [*]PEER_GRAPH_EVENT_REGISTRATION,
    phPeerEvent: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphUnregisterEvent(
    hPeerEvent: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphGetEventData(
    hPeerEvent: ?*anyopaque,
    ppEventData: ?*?*PEER_GRAPH_EVENT_DATA,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphGetRecord(
    hGraph: ?*anyopaque,
    pRecordId: ?*const Guid,
    ppRecord: ?*?*PEER_RECORD,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphAddRecord(
    hGraph: ?*anyopaque,
    pRecord: ?*PEER_RECORD,
    pRecordId: ?*Guid,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphUpdateRecord(
    hGraph: ?*anyopaque,
    pRecord: ?*PEER_RECORD,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphDeleteRecord(
    hGraph: ?*anyopaque,
    pRecordId: ?*const Guid,
    fLocal: BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphEnumRecords(
    hGraph: ?*anyopaque,
    pRecordType: ?*const Guid,
    pwzPeerId: ?[*:0]const u16,
    phPeerEnum: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphSearchRecords(
    hGraph: ?*anyopaque,
    pwzCriteria: ?[*:0]const u16,
    phPeerEnum: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphExportDatabase(
    hGraph: ?*anyopaque,
    pwzFilePath: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphImportDatabase(
    hGraph: ?*anyopaque,
    pwzFilePath: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphValidateDeferredRecords(
    hGraph: ?*anyopaque,
    cRecordIds: u32,
    pRecordIds: [*]const Guid,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphOpenDirectConnection(
    hGraph: ?*anyopaque,
    pwzPeerId: ?[*:0]const u16,
    pAddress: ?*PEER_ADDRESS,
    pullConnectionId: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphSendData(
    hGraph: ?*anyopaque,
    ullConnectionId: u64,
    pType: ?*const Guid,
    cbData: u32,
    // TODO: what to do with BytesParamIndex 3?
    pvData: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphCloseDirectConnection(
    hGraph: ?*anyopaque,
    ullConnectionId: u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphEnumConnections(
    hGraph: ?*anyopaque,
    dwFlags: u32,
    phPeerEnum: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphEnumNodes(
    hGraph: ?*anyopaque,
    pwzPeerId: ?[*:0]const u16,
    phPeerEnum: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphSetPresence(
    hGraph: ?*anyopaque,
    fPresent: BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphGetNodeInfo(
    hGraph: ?*anyopaque,
    ullNodeId: u64,
    ppNodeInfo: ?*?*PEER_NODE_INFO,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphSetNodeAttributes(
    hGraph: ?*anyopaque,
    pwzAttributes: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphPeerTimeToUniversalTime(
    hGraph: ?*anyopaque,
    pftPeerTime: ?*FILETIME,
    pftUniversalTime: ?*FILETIME,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2pgraph" fn PeerGraphUniversalTimeToPeerTime(
    hGraph: ?*anyopaque,
    pftUniversalTime: ?*FILETIME,
    pftPeerTime: ?*FILETIME,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerFreeData(
    pvData: ?*const anyopaque,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGetItemCount(
    hPeerEnum: ?*anyopaque,
    pCount: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGetNextItem(
    hPeerEnum: ?*anyopaque,
    pCount: ?*u32,
    pppvItems: ?*?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerEndEnumeration(
    hPeerEnum: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupStartup(
    wVersionRequested: u16,
    pVersionData: ?*PEER_VERSION_DATA,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupShutdown() callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupCreate(
    pProperties: ?*PEER_GROUP_PROPERTIES,
    phGroup: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupOpen(
    pwzIdentity: ?[*:0]const u16,
    pwzGroupPeerName: ?[*:0]const u16,
    pwzCloud: ?[*:0]const u16,
    phGroup: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupJoin(
    pwzIdentity: ?[*:0]const u16,
    pwzInvitation: ?[*:0]const u16,
    pwzCloud: ?[*:0]const u16,
    phGroup: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupPasswordJoin(
    pwzIdentity: ?[*:0]const u16,
    pwzInvitation: ?[*:0]const u16,
    pwzPassword: ?[*:0]const u16,
    pwzCloud: ?[*:0]const u16,
    phGroup: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupConnect(
    hGroup: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupConnectByAddress(
    hGroup: ?*anyopaque,
    cAddresses: u32,
    pAddresses: [*]PEER_ADDRESS,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupClose(
    hGroup: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupDelete(
    pwzIdentity: ?[*:0]const u16,
    pwzGroupPeerName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupCreateInvitation(
    hGroup: ?*anyopaque,
    pwzIdentityInfo: ?[*:0]const u16,
    pftExpiration: ?*FILETIME,
    cRoles: u32,
    pRoles: ?[*]const Guid,
    ppwzInvitation: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupCreatePasswordInvitation(
    hGroup: ?*anyopaque,
    ppwzInvitation: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupParseInvitation(
    pwzInvitation: ?[*:0]const u16,
    ppInvitationInfo: ?*?*PEER_INVITATION_INFO,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupGetStatus(
    hGroup: ?*anyopaque,
    pdwStatus: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupGetProperties(
    hGroup: ?*anyopaque,
    ppProperties: ?*?*PEER_GROUP_PROPERTIES,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupSetProperties(
    hGroup: ?*anyopaque,
    pProperties: ?*PEER_GROUP_PROPERTIES,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupEnumMembers(
    hGroup: ?*anyopaque,
    dwFlags: u32,
    pwzIdentity: ?[*:0]const u16,
    phPeerEnum: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupOpenDirectConnection(
    hGroup: ?*anyopaque,
    pwzIdentity: ?[*:0]const u16,
    pAddress: ?*PEER_ADDRESS,
    pullConnectionId: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupCloseDirectConnection(
    hGroup: ?*anyopaque,
    ullConnectionId: u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupEnumConnections(
    hGroup: ?*anyopaque,
    dwFlags: u32,
    phPeerEnum: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupSendData(
    hGroup: ?*anyopaque,
    ullConnectionId: u64,
    pType: ?*const Guid,
    cbData: u32,
    // TODO: what to do with BytesParamIndex 3?
    pvData: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupRegisterEvent(
    hGroup: ?*anyopaque,
    hEvent: ?HANDLE,
    cEventRegistration: u32,
    pEventRegistrations: [*]PEER_GROUP_EVENT_REGISTRATION,
    phPeerEvent: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupUnregisterEvent(
    hPeerEvent: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupGetEventData(
    hPeerEvent: ?*anyopaque,
    ppEventData: ?*?*PEER_GROUP_EVENT_DATA,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupGetRecord(
    hGroup: ?*anyopaque,
    pRecordId: ?*const Guid,
    ppRecord: ?*?*PEER_RECORD,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupAddRecord(
    hGroup: ?*anyopaque,
    pRecord: ?*PEER_RECORD,
    pRecordId: ?*Guid,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupUpdateRecord(
    hGroup: ?*anyopaque,
    pRecord: ?*PEER_RECORD,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupDeleteRecord(
    hGroup: ?*anyopaque,
    pRecordId: ?*const Guid,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupEnumRecords(
    hGroup: ?*anyopaque,
    pRecordType: ?*const Guid,
    phPeerEnum: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupSearchRecords(
    hGroup: ?*anyopaque,
    pwzCriteria: ?[*:0]const u16,
    phPeerEnum: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupExportDatabase(
    hGroup: ?*anyopaque,
    pwzFilePath: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupImportDatabase(
    hGroup: ?*anyopaque,
    pwzFilePath: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupIssueCredentials(
    hGroup: ?*anyopaque,
    pwzSubjectIdentity: ?[*:0]const u16,
    pCredentialInfo: ?*PEER_CREDENTIAL_INFO,
    dwFlags: u32,
    ppwzInvitation: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupExportConfig(
    hGroup: ?*anyopaque,
    pwzPassword: ?[*:0]const u16,
    ppwzXML: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupImportConfig(
    pwzXML: ?[*:0]const u16,
    pwzPassword: ?[*:0]const u16,
    fOverwrite: BOOL,
    ppwzIdentity: ?*?PWSTR,
    ppwzGroup: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupPeerTimeToUniversalTime(
    hGroup: ?*anyopaque,
    pftPeerTime: ?*FILETIME,
    pftUniversalTime: ?*FILETIME,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerGroupUniversalTimeToPeerTime(
    hGroup: ?*anyopaque,
    pftUniversalTime: ?*FILETIME,
    pftPeerTime: ?*FILETIME,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "p2p" fn PeerGroupResumePasswordAuthentication(
    hGroup: ?*anyopaque,
    hPeerEventHandle: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerIdentityCreate(
    pwzClassifier: ?[*:0]const u16,
    pwzFriendlyName: ?[*:0]const u16,
    hCryptProv: usize,
    ppwzIdentity: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerIdentityGetFriendlyName(
    pwzIdentity: ?[*:0]const u16,
    ppwzFriendlyName: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerIdentitySetFriendlyName(
    pwzIdentity: ?[*:0]const u16,
    pwzFriendlyName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerIdentityGetCryptKey(
    pwzIdentity: ?[*:0]const u16,
    phCryptProv: ?*usize,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerIdentityDelete(
    pwzIdentity: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerEnumIdentities(
    phPeerEnum: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerEnumGroups(
    pwzIdentity: ?[*:0]const u16,
    phPeerEnum: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerCreatePeerName(
    pwzIdentity: ?[*:0]const u16,
    pwzClassifier: ?[*:0]const u16,
    ppwzPeerName: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerIdentityGetXML(
    pwzIdentity: ?[*:0]const u16,
    ppwzIdentityXML: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerIdentityExport(
    pwzIdentity: ?[*:0]const u16,
    pwzPassword: ?[*:0]const u16,
    ppwzExportXML: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerIdentityImport(
    pwzImportXML: ?[*:0]const u16,
    pwzPassword: ?[*:0]const u16,
    ppwzIdentity: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerIdentityGetDefault(
    ppwzPeerName: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabStartup(
    wVersionRequested: u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabShutdown() callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabSignin(
    hwndParent: ?HWND,
    dwSigninOptions: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabSignout(
    dwSigninOptions: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabGetSigninOptions(
    pdwSigninOptions: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabAsyncInviteContact(
    pcContact: ?*PEER_CONTACT,
    pcEndpoint: ?*PEER_ENDPOINT,
    pcInvitation: ?*PEER_INVITATION,
    hEvent: ?HANDLE,
    phInvitation: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabGetInvitationResponse(
    hInvitation: ?HANDLE,
    ppInvitationResponse: ?*?*PEER_INVITATION_RESPONSE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabCancelInvitation(
    hInvitation: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabCloseHandle(
    hInvitation: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabInviteContact(
    pcContact: ?*PEER_CONTACT,
    pcEndpoint: ?*PEER_ENDPOINT,
    pcInvitation: ?*PEER_INVITATION,
    ppResponse: ?*?*PEER_INVITATION_RESPONSE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabAsyncInviteEndpoint(
    pcEndpoint: ?*PEER_ENDPOINT,
    pcInvitation: ?*PEER_INVITATION,
    hEvent: ?HANDLE,
    phInvitation: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabInviteEndpoint(
    pcEndpoint: ?*PEER_ENDPOINT,
    pcInvitation: ?*PEER_INVITATION,
    ppResponse: ?*?*PEER_INVITATION_RESPONSE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabGetAppLaunchInfo(
    ppLaunchInfo: ?*?*PEER_APP_LAUNCH_INFO,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabRegisterApplication(
    pcApplication: ?*PEER_APPLICATION_REGISTRATION_INFO,
    registrationType: PEER_APPLICATION_REGISTRATION_TYPE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabUnregisterApplication(
    pApplicationId: ?*const Guid,
    registrationType: PEER_APPLICATION_REGISTRATION_TYPE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabGetApplicationRegistrationInfo(
    pApplicationId: ?*const Guid,
    registrationType: PEER_APPLICATION_REGISTRATION_TYPE,
    ppApplication: ?*?*PEER_APPLICATION_REGISTRATION_INFO,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabEnumApplicationRegistrationInfo(
    registrationType: PEER_APPLICATION_REGISTRATION_TYPE,
    phPeerEnum: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabGetPresenceInfo(
    pcEndpoint: ?*PEER_ENDPOINT,
    ppPresenceInfo: ?*?*PEER_PRESENCE_INFO,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabEnumApplications(
    pcEndpoint: ?*PEER_ENDPOINT,
    pApplicationId: ?*const Guid,
    phPeerEnum: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabEnumObjects(
    pcEndpoint: ?*PEER_ENDPOINT,
    pObjectId: ?*const Guid,
    phPeerEnum: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabEnumEndpoints(
    pcContact: ?*PEER_CONTACT,
    phPeerEnum: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabRefreshEndpointData(
    pcEndpoint: ?*PEER_ENDPOINT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabDeleteEndpointData(
    pcEndpoint: ?*PEER_ENDPOINT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabQueryContactData(
    pcEndpoint: ?*PEER_ENDPOINT,
    ppwzContactData: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabSubscribeEndpointData(
    pcEndpoint: ?*const PEER_ENDPOINT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabUnsubscribeEndpointData(
    pcEndpoint: ?*const PEER_ENDPOINT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabSetPresenceInfo(
    pcPresenceInfo: ?*PEER_PRESENCE_INFO,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabGetEndpointName(
    ppwzEndpointName: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabSetEndpointName(
    pwzEndpointName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabSetObject(
    pcObject: ?*PEER_OBJECT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabDeleteObject(
    pObjectId: ?*const Guid,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabRegisterEvent(
    hEvent: ?HANDLE,
    cEventRegistration: u32,
    pEventRegistrations: [*]PEER_COLLAB_EVENT_REGISTRATION,
    phPeerEvent: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabGetEventData(
    hPeerEvent: ?*anyopaque,
    ppEventData: ?*?*PEER_COLLAB_EVENT_DATA,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabUnregisterEvent(
    hPeerEvent: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabEnumPeopleNearMe(
    phPeerEnum: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabAddContact(
    pwzContactData: ?[*:0]const u16,
    ppContact: ?*?*PEER_CONTACT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabDeleteContact(
    pwzPeerName: ?[*:0]const u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabGetContact(
    pwzPeerName: ?[*:0]const u16,
    ppContact: ?*?*PEER_CONTACT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabUpdateContact(
    pContact: ?*PEER_CONTACT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabEnumContacts(
    phPeerEnum: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabExportContact(
    pwzPeerName: ?[*:0]const u16,
    ppwzContactData: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "p2p" fn PeerCollabParseContact(
    pwzContactData: ?[*:0]const u16,
    ppContact: ?*?*PEER_CONTACT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerNameToPeerHostName(
    pwzPeerName: ?[*:0]const u16,
    ppwzHostName: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerHostNameToPeerName(
    pwzHostName: ?[*:0]const u16,
    ppwzPeerName: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerPnrpStartup(
    wVersionRequested: u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerPnrpShutdown() callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerPnrpRegister(
    pcwzPeerName: ?[*:0]const u16,
    pRegistrationInfo: ?*PEER_PNRP_REGISTRATION_INFO,
    phRegistration: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerPnrpUpdateRegistration(
    hRegistration: ?*anyopaque,
    pRegistrationInfo: ?*PEER_PNRP_REGISTRATION_INFO,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerPnrpUnregister(
    hRegistration: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerPnrpResolve(
    pcwzPeerName: ?[*:0]const u16,
    pcwzCloudName: ?[*:0]const u16,
    pcEndpoints: ?*u32,
    ppEndpoints: ?*?*PEER_PNRP_ENDPOINT_INFO,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerPnrpStartResolve(
    pcwzPeerName: ?[*:0]const u16,
    pcwzCloudName: ?[*:0]const u16,
    cMaxEndpoints: u32,
    hEvent: ?HANDLE,
    phResolve: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerPnrpGetCloudInfo(
    pcNumClouds: ?*u32,
    ppCloudInfo: ?*?*PEER_PNRP_CLOUD_INFO,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerPnrpGetEndpoint(
    hResolve: ?*anyopaque,
    ppEndpoint: ?*?*PEER_PNRP_ENDPOINT_INFO,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "p2p" fn PeerPnrpEndResolve(
    hResolve: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drtprov" fn DrtCreatePnrpBootstrapResolver(
    fPublish: BOOL,
    pwzPeerName: ?[*:0]const u16,
    pwzCloudName: ?[*:0]const u16,
    pwzPublishingIdentity: ?[*:0]const u16,
    ppResolver: ?*?*DRT_BOOTSTRAP_PROVIDER,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drtprov" fn DrtDeletePnrpBootstrapResolver(
    pResolver: ?*DRT_BOOTSTRAP_PROVIDER,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drtprov" fn DrtCreateDnsBootstrapResolver(
    port: u16,
    pwszAddress: ?[*:0]const u16,
    ppModule: ?*?*DRT_BOOTSTRAP_PROVIDER,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drtprov" fn DrtDeleteDnsBootstrapResolver(
    pResolver: ?*DRT_BOOTSTRAP_PROVIDER,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drttransport" fn DrtCreateIpv6UdpTransport(
    scope: DRT_SCOPE,
    dwScopeId: u32,
    dwLocalityThreshold: u32,
    pwPort: ?*u16,
    phTransport: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drttransport" fn DrtDeleteIpv6UdpTransport(
    hTransport: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drtprov" fn DrtCreateDerivedKeySecurityProvider(
    pRootCert: ?*const CERT_CONTEXT,
    pLocalCert: ?*const CERT_CONTEXT,
    ppSecurityProvider: ?*?*DRT_SECURITY_PROVIDER,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drtprov" fn DrtCreateDerivedKey(
    pLocalCert: ?*const CERT_CONTEXT,
    pKey: ?*DRT_DATA,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drtprov" fn DrtDeleteDerivedKeySecurityProvider(
    pSecurityProvider: ?*DRT_SECURITY_PROVIDER,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drtprov" fn DrtCreateNullSecurityProvider(
    ppSecurityProvider: ?*?*DRT_SECURITY_PROVIDER,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drtprov" fn DrtDeleteNullSecurityProvider(
    pSecurityProvider: ?*DRT_SECURITY_PROVIDER,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drt" fn DrtOpen(
    pSettings: ?*const DRT_SETTINGS,
    hEvent: ?HANDLE,
    pvContext: ?*const anyopaque,
    phDrt: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drt" fn DrtClose(
    hDrt: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drt" fn DrtGetEventDataSize(
    hDrt: ?*anyopaque,
    pulEventDataLen: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drt" fn DrtGetEventData(
    hDrt: ?*anyopaque,
    ulEventDataLen: u32,
    pEventData: ?*DRT_EVENT_DATA,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drt" fn DrtRegisterKey(
    hDrt: ?*anyopaque,
    pRegistration: ?*DRT_REGISTRATION,
    pvKeyContext: ?*anyopaque,
    phKeyRegistration: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drt" fn DrtUpdateKey(
    hKeyRegistration: ?*anyopaque,
    pAppData: ?*DRT_DATA,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drt" fn DrtUnregisterKey(
    hKeyRegistration: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drt" fn DrtStartSearch(
    hDrt: ?*anyopaque,
    pKey: ?*DRT_DATA,
    pInfo: ?*const DRT_SEARCH_INFO,
    timeout: u32,
    hEvent: ?HANDLE,
    pvContext: ?*const anyopaque,
    hSearchContext: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drt" fn DrtContinueSearch(
    hSearchContext: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drt" fn DrtGetSearchResultSize(
    hSearchContext: ?*anyopaque,
    pulSearchResultSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drt" fn DrtGetSearchResult(
    hSearchContext: ?*anyopaque,
    ulSearchResultSize: u32,
    pSearchResult: ?*DRT_SEARCH_RESULT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drt" fn DrtGetSearchPathSize(
    hSearchContext: ?*anyopaque,
    pulSearchPathSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drt" fn DrtGetSearchPath(
    hSearchContext: ?*anyopaque,
    ulSearchPathSize: u32,
    pSearchPath: ?*DRT_ADDRESS_LIST,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drt" fn DrtEndSearch(
    hSearchContext: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drt" fn DrtGetInstanceName(
    hDrt: ?*anyopaque,
    ulcbInstanceNameSize: u32,
    pwzDrtInstanceName: ?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "drt" fn DrtGetInstanceNameSize(
    hDrt: ?*anyopaque,
    pulcbInstanceNameSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistStartup(
    dwVersionRequested: u32,
    phPeerDist: ?*isize,
    pdwSupportedVersion: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistShutdown(
    hPeerDist: isize,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistGetStatus(
    hPeerDist: isize,
    pPeerDistStatus: ?*PEERDIST_STATUS,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistRegisterForStatusChangeNotification(
    hPeerDist: isize,
    hCompletionPort: ?HANDLE,
    ulCompletionKey: usize,
    lpOverlapped: ?*OVERLAPPED,
    pPeerDistStatus: ?*PEERDIST_STATUS,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistUnregisterForStatusChangeNotification(
    hPeerDist: isize,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistServerPublishStream(
    hPeerDist: isize,
    cbContentIdentifier: u32,
    // TODO: what to do with BytesParamIndex 1?
    pContentIdentifier: ?*u8,
    cbContentLength: u64,
    pPublishOptions: ?*PEERDIST_PUBLICATION_OPTIONS,
    hCompletionPort: ?HANDLE,
    ulCompletionKey: usize,
    phStream: ?*isize,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistServerPublishAddToStream(
    hPeerDist: isize,
    hStream: isize,
    cbNumberOfBytes: u32,
    // TODO: what to do with BytesParamIndex 2?
    pBuffer: ?*u8,
    lpOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistServerPublishCompleteStream(
    hPeerDist: isize,
    hStream: isize,
    lpOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistServerCloseStreamHandle(
    hPeerDist: isize,
    hStream: isize,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistServerUnpublish(
    hPeerDist: isize,
    cbContentIdentifier: u32,
    // TODO: what to do with BytesParamIndex 1?
    pContentIdentifier: ?*u8,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistServerOpenContentInformation(
    hPeerDist: isize,
    cbContentIdentifier: u32,
    // TODO: what to do with BytesParamIndex 1?
    pContentIdentifier: ?*u8,
    ullContentOffset: u64,
    cbContentLength: u64,
    hCompletionPort: ?HANDLE,
    ulCompletionKey: usize,
    phContentInfo: ?*isize,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistServerRetrieveContentInformation(
    hPeerDist: isize,
    hContentInfo: isize,
    cbMaxNumberOfBytes: u32,
    // TODO: what to do with BytesParamIndex 2?
    pBuffer: ?*u8,
    lpOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistServerCloseContentInformation(
    hPeerDist: isize,
    hContentInfo: isize,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistServerCancelAsyncOperation(
    hPeerDist: isize,
    cbContentIdentifier: u32,
    // TODO: what to do with BytesParamIndex 1?
    pContentIdentifier: ?*u8,
    pOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistClientOpenContent(
    hPeerDist: isize,
    pContentTag: ?*PEERDIST_CONTENT_TAG,
    hCompletionPort: ?HANDLE,
    ulCompletionKey: usize,
    phContentHandle: ?*isize,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistClientCloseContent(
    hPeerDist: isize,
    hContentHandle: isize,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistClientAddContentInformation(
    hPeerDist: isize,
    hContentHandle: isize,
    cbNumberOfBytes: u32,
    // TODO: what to do with BytesParamIndex 2?
    pBuffer: ?*u8,
    lpOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistClientCompleteContentInformation(
    hPeerDist: isize,
    hContentHandle: isize,
    lpOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistClientAddData(
    hPeerDist: isize,
    hContentHandle: isize,
    cbNumberOfBytes: u32,
    // TODO: what to do with BytesParamIndex 2?
    pBuffer: ?*u8,
    lpOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistClientBlockRead(
    hPeerDist: isize,
    hContentHandle: isize,
    cbMaxNumberOfBytes: u32,
    // TODO: what to do with BytesParamIndex 2?
    pBuffer: ?*u8,
    dwTimeoutInMilliseconds: u32,
    lpOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistClientStreamRead(
    hPeerDist: isize,
    hContentHandle: isize,
    cbMaxNumberOfBytes: u32,
    // TODO: what to do with BytesParamIndex 2?
    pBuffer: ?*u8,
    dwTimeoutInMilliseconds: u32,
    lpOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistClientFlushContent(
    hPeerDist: isize,
    pContentTag: ?*PEERDIST_CONTENT_TAG,
    hCompletionPort: ?HANDLE,
    ulCompletionKey: usize,
    lpOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows6.1'
pub extern "peerdist" fn PeerDistClientCancelAsyncOperation(
    hPeerDist: isize,
    hContentHandle: isize,
    pOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "peerdist" fn PeerDistGetStatusEx(
    hPeerDist: isize,
    pPeerDistStatus: ?*PEERDIST_STATUS_INFO,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "peerdist" fn PeerDistRegisterForStatusChangeNotificationEx(
    hPeerDist: isize,
    hCompletionPort: ?HANDLE,
    ulCompletionKey: usize,
    lpOverlapped: ?*OVERLAPPED,
    pPeerDistStatus: ?*PEERDIST_STATUS_INFO,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "peerdist" fn PeerDistGetOverlappedResult(
    lpOverlapped: ?*OVERLAPPED,
    lpNumberOfBytesTransferred: ?*u32,
    bWait: BOOL,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows8.0'
pub extern "peerdist" fn PeerDistServerOpenContentInformationEx(
    hPeerDist: isize,
    cbContentIdentifier: u32,
    // TODO: what to do with BytesParamIndex 1?
    pContentIdentifier: ?*u8,
    ullContentOffset: u64,
    cbContentLength: u64,
    pRetrievalOptions: ?*PEERDIST_RETRIEVAL_OPTIONS,
    hCompletionPort: ?HANDLE,
    ulCompletionKey: usize,
    phContentInfo: ?*isize,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows8.0'
pub extern "peerdist" fn PeerDistClientGetInformationByHandle(
    hPeerDist: isize,
    hContentHandle: isize,
    PeerDistClientInfoClass: PEERDIST_CLIENT_INFO_BY_HANDLE_CLASS,
    dwBufferSize: u32,
    // TODO: what to do with BytesParamIndex 3?
    lpInformation: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) u32;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (16)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BLOB = @import("../system/com.zig").BLOB;
const BOOL = @import("../foundation.zig").BOOL;
const CERT_CONTEXT = @import("../security/cryptography.zig").CERT_CONTEXT;
const CERT_PUBLIC_KEY_INFO = @import("../security/cryptography.zig").CERT_PUBLIC_KEY_INFO;
const FILETIME = @import("../foundation.zig").FILETIME;
const HANDLE = @import("../foundation.zig").HANDLE;
const HRESULT = @import("../foundation.zig").HRESULT;
const HWND = @import("../foundation.zig").HWND;
const OVERLAPPED = @import("../system/io.zig").OVERLAPPED;
const PWSTR = @import("../foundation.zig").PWSTR;
const SOCKADDR = @import("../networking/win_sock.zig").SOCKADDR;
const SOCKADDR_IN6 = @import("../networking/win_sock.zig").SOCKADDR_IN6;
const SOCKADDR_STORAGE = @import("../networking/win_sock.zig").SOCKADDR_STORAGE;
const SOCKET_ADDRESS = @import("../networking/win_sock.zig").SOCKET_ADDRESS;
const SOCKET_ADDRESS_LIST = @import("../networking/win_sock.zig").SOCKET_ADDRESS_LIST;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "PFNPEER_VALIDATE_RECORD")) {
        _ = PFNPEER_VALIDATE_RECORD;
    }
    if (@hasDecl(@This(), "PFNPEER_SECURE_RECORD")) {
        _ = PFNPEER_SECURE_RECORD;
    }
    if (@hasDecl(@This(), "PFNPEER_FREE_SECURITY_DATA")) {
        _ = PFNPEER_FREE_SECURITY_DATA;
    }
    if (@hasDecl(@This(), "PFNPEER_ON_PASSWORD_AUTH_FAILED")) {
        _ = PFNPEER_ON_PASSWORD_AUTH_FAILED;
    }
    if (@hasDecl(@This(), "DRT_BOOTSTRAP_RESOLVE_CALLBACK")) {
        _ = DRT_BOOTSTRAP_RESOLVE_CALLBACK;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
