//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (0)
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
// Section: Types (92)
//--------------------------------------------------------------------------------
const CLSID_MbnConnectionProfileManager_Value = Guid.initString("bdfee05a-4418-11dd-90ed-001c257ccff1");
pub const CLSID_MbnConnectionProfileManager = &CLSID_MbnConnectionProfileManager_Value;

const CLSID_MbnInterfaceManager_Value = Guid.initString("bdfee05b-4418-11dd-90ed-001c257ccff1");
pub const CLSID_MbnInterfaceManager = &CLSID_MbnInterfaceManager_Value;

const CLSID_MbnConnectionManager_Value = Guid.initString("bdfee05c-4418-11dd-90ed-001c257ccff1");
pub const CLSID_MbnConnectionManager = &CLSID_MbnConnectionManager_Value;

const CLSID_MbnDeviceServicesManager_Value = Guid.initString("2269daa3-2a9f-4165-a501-ce00a6f7a75b");
pub const CLSID_MbnDeviceServicesManager = &CLSID_MbnDeviceServicesManager_Value;

const IID_IDummyMBNUCMExt_Value = Guid.initString("dcbbbab6-ffff-4bbb-aaee-338e368af6fa");
pub const IID_IDummyMBNUCMExt = &IID_IDummyMBNUCMExt_Value;
pub const IDummyMBNUCMExt = extern struct {
    pub const VTable = extern struct {
        base: IDispatch.VTable,
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDispatch.MethodMixin(T);
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const MBN_SIGNAL_CONSTANTS = enum(i32) {
    RSSI_DEFAULT = -1,
    RSSI_DISABLE = 0,
    RSSI_UNKNOWN = 99,
    // ERROR_RATE_UNKNOWN = 99, this enum value conflicts with RSSI_UNKNOWN
};
pub const MBN_RSSI_DEFAULT = MBN_SIGNAL_CONSTANTS.RSSI_DEFAULT;
pub const MBN_RSSI_DISABLE = MBN_SIGNAL_CONSTANTS.RSSI_DISABLE;
pub const MBN_RSSI_UNKNOWN = MBN_SIGNAL_CONSTANTS.RSSI_UNKNOWN;
pub const MBN_ERROR_RATE_UNKNOWN = MBN_SIGNAL_CONSTANTS.RSSI_UNKNOWN;

pub const MBN_CELLULAR_CLASS = enum(i32) {
    NONE = 0,
    GSM = 1,
    CDMA = 2,
};
pub const MBN_CELLULAR_CLASS_NONE = MBN_CELLULAR_CLASS.NONE;
pub const MBN_CELLULAR_CLASS_GSM = MBN_CELLULAR_CLASS.GSM;
pub const MBN_CELLULAR_CLASS_CDMA = MBN_CELLULAR_CLASS.CDMA;

pub const MBN_VOICE_CLASS = enum(i32) {
    NONE = 0,
    NO_VOICE = 1,
    SEPARATE_VOICE_DATA = 2,
    SIMULTANEOUS_VOICE_DATA = 3,
};
pub const MBN_VOICE_CLASS_NONE = MBN_VOICE_CLASS.NONE;
pub const MBN_VOICE_CLASS_NO_VOICE = MBN_VOICE_CLASS.NO_VOICE;
pub const MBN_VOICE_CLASS_SEPARATE_VOICE_DATA = MBN_VOICE_CLASS.SEPARATE_VOICE_DATA;
pub const MBN_VOICE_CLASS_SIMULTANEOUS_VOICE_DATA = MBN_VOICE_CLASS.SIMULTANEOUS_VOICE_DATA;

pub const MBN_PROVIDER_STATE = enum(i32) {
    NONE = 0,
    HOME = 1,
    FORBIDDEN = 2,
    PREFERRED = 4,
    VISIBLE = 8,
    REGISTERED = 16,
    PREFERRED_MULTICARRIER = 32,
};
pub const MBN_PROVIDER_STATE_NONE = MBN_PROVIDER_STATE.NONE;
pub const MBN_PROVIDER_STATE_HOME = MBN_PROVIDER_STATE.HOME;
pub const MBN_PROVIDER_STATE_FORBIDDEN = MBN_PROVIDER_STATE.FORBIDDEN;
pub const MBN_PROVIDER_STATE_PREFERRED = MBN_PROVIDER_STATE.PREFERRED;
pub const MBN_PROVIDER_STATE_VISIBLE = MBN_PROVIDER_STATE.VISIBLE;
pub const MBN_PROVIDER_STATE_REGISTERED = MBN_PROVIDER_STATE.REGISTERED;
pub const MBN_PROVIDER_STATE_PREFERRED_MULTICARRIER = MBN_PROVIDER_STATE.PREFERRED_MULTICARRIER;

pub const MBN_PROVIDER_CONSTANTS = enum(i32) {
    NAME_LEN = 20,
    ID_LEN = 6,
};
pub const MBN_PROVIDERNAME_LEN = MBN_PROVIDER_CONSTANTS.NAME_LEN;
pub const MBN_PROVIDERID_LEN = MBN_PROVIDER_CONSTANTS.ID_LEN;

pub const MBN_INTERFACE_CAPS_CONSTANTS = enum(i32) {
    DEVICEID_LEN = 18,
    MANUFACTURER_LEN = 32,
    // MODEL_LEN = 32, this enum value conflicts with MANUFACTURER_LEN
    // FIRMWARE_LEN = 32, this enum value conflicts with MANUFACTURER_LEN
};
pub const MBN_DEVICEID_LEN = MBN_INTERFACE_CAPS_CONSTANTS.DEVICEID_LEN;
pub const MBN_MANUFACTURER_LEN = MBN_INTERFACE_CAPS_CONSTANTS.MANUFACTURER_LEN;
pub const MBN_MODEL_LEN = MBN_INTERFACE_CAPS_CONSTANTS.MANUFACTURER_LEN;
pub const MBN_FIRMWARE_LEN = MBN_INTERFACE_CAPS_CONSTANTS.MANUFACTURER_LEN;

pub const MBN_DATA_CLASS = enum(i32) {
    NONE = 0,
    GPRS = 1,
    EDGE = 2,
    UMTS = 4,
    HSDPA = 8,
    HSUPA = 16,
    LTE = 32,
    @"5G_NSA" = 64,
    @"5G_SA" = 128,
    @"1XRTT" = 65536,
    @"1XEVDO" = 131072,
    @"1XEVDO_REVA" = 262144,
    @"1XEVDV" = 524288,
    @"3XRTT" = 1048576,
    @"1XEVDO_REVB" = 2097152,
    UMB = 4194304,
    CUSTOM = -2147483648,
};
pub const MBN_DATA_CLASS_NONE = MBN_DATA_CLASS.NONE;
pub const MBN_DATA_CLASS_GPRS = MBN_DATA_CLASS.GPRS;
pub const MBN_DATA_CLASS_EDGE = MBN_DATA_CLASS.EDGE;
pub const MBN_DATA_CLASS_UMTS = MBN_DATA_CLASS.UMTS;
pub const MBN_DATA_CLASS_HSDPA = MBN_DATA_CLASS.HSDPA;
pub const MBN_DATA_CLASS_HSUPA = MBN_DATA_CLASS.HSUPA;
pub const MBN_DATA_CLASS_LTE = MBN_DATA_CLASS.LTE;
pub const MBN_DATA_CLASS_5G_NSA = MBN_DATA_CLASS.@"5G_NSA";
pub const MBN_DATA_CLASS_5G_SA = MBN_DATA_CLASS.@"5G_SA";
pub const MBN_DATA_CLASS_1XRTT = MBN_DATA_CLASS.@"1XRTT";
pub const MBN_DATA_CLASS_1XEVDO = MBN_DATA_CLASS.@"1XEVDO";
pub const MBN_DATA_CLASS_1XEVDO_REVA = MBN_DATA_CLASS.@"1XEVDO_REVA";
pub const MBN_DATA_CLASS_1XEVDV = MBN_DATA_CLASS.@"1XEVDV";
pub const MBN_DATA_CLASS_3XRTT = MBN_DATA_CLASS.@"3XRTT";
pub const MBN_DATA_CLASS_1XEVDO_REVB = MBN_DATA_CLASS.@"1XEVDO_REVB";
pub const MBN_DATA_CLASS_UMB = MBN_DATA_CLASS.UMB;
pub const MBN_DATA_CLASS_CUSTOM = MBN_DATA_CLASS.CUSTOM;

pub const MBN_CTRL_CAPS = enum(i32) {
    NONE = 0,
    REG_MANUAL = 1,
    HW_RADIO_SWITCH = 2,
    CDMA_MOBILE_IP = 4,
    CDMA_SIMPLE_IP = 8,
    PROTECT_UNIQUEID = 16,
    MODEL_MULTI_CARRIER = 32,
    USSD = 64,
    MULTI_MODE = 128,
};
pub const MBN_CTRL_CAPS_NONE = MBN_CTRL_CAPS.NONE;
pub const MBN_CTRL_CAPS_REG_MANUAL = MBN_CTRL_CAPS.REG_MANUAL;
pub const MBN_CTRL_CAPS_HW_RADIO_SWITCH = MBN_CTRL_CAPS.HW_RADIO_SWITCH;
pub const MBN_CTRL_CAPS_CDMA_MOBILE_IP = MBN_CTRL_CAPS.CDMA_MOBILE_IP;
pub const MBN_CTRL_CAPS_CDMA_SIMPLE_IP = MBN_CTRL_CAPS.CDMA_SIMPLE_IP;
pub const MBN_CTRL_CAPS_PROTECT_UNIQUEID = MBN_CTRL_CAPS.PROTECT_UNIQUEID;
pub const MBN_CTRL_CAPS_MODEL_MULTI_CARRIER = MBN_CTRL_CAPS.MODEL_MULTI_CARRIER;
pub const MBN_CTRL_CAPS_USSD = MBN_CTRL_CAPS.USSD;
pub const MBN_CTRL_CAPS_MULTI_MODE = MBN_CTRL_CAPS.MULTI_MODE;

pub const MBN_SMS_CAPS = enum(i32) {
    NONE = 0,
    PDU_RECEIVE = 1,
    PDU_SEND = 2,
    TEXT_RECEIVE = 4,
    TEXT_SEND = 8,
};
pub const MBN_SMS_CAPS_NONE = MBN_SMS_CAPS.NONE;
pub const MBN_SMS_CAPS_PDU_RECEIVE = MBN_SMS_CAPS.PDU_RECEIVE;
pub const MBN_SMS_CAPS_PDU_SEND = MBN_SMS_CAPS.PDU_SEND;
pub const MBN_SMS_CAPS_TEXT_RECEIVE = MBN_SMS_CAPS.TEXT_RECEIVE;
pub const MBN_SMS_CAPS_TEXT_SEND = MBN_SMS_CAPS.TEXT_SEND;

pub const MBN_BAND_CLASS = enum(i32) {
    NONE = 0,
    @"0" = 1,
    I = 2,
    II = 4,
    III = 8,
    IV = 16,
    V = 32,
    VI = 64,
    VII = 128,
    VIII = 256,
    IX = 512,
    X = 1024,
    XI = 2048,
    XII = 4096,
    XIII = 8192,
    XIV = 16384,
    XV = 32768,
    XVI = 65536,
    XVII = 131072,
    CUSTOM = -2147483648,
};
pub const MBN_BAND_CLASS_NONE = MBN_BAND_CLASS.NONE;
pub const MBN_BAND_CLASS_0 = MBN_BAND_CLASS.@"0";
pub const MBN_BAND_CLASS_I = MBN_BAND_CLASS.I;
pub const MBN_BAND_CLASS_II = MBN_BAND_CLASS.II;
pub const MBN_BAND_CLASS_III = MBN_BAND_CLASS.III;
pub const MBN_BAND_CLASS_IV = MBN_BAND_CLASS.IV;
pub const MBN_BAND_CLASS_V = MBN_BAND_CLASS.V;
pub const MBN_BAND_CLASS_VI = MBN_BAND_CLASS.VI;
pub const MBN_BAND_CLASS_VII = MBN_BAND_CLASS.VII;
pub const MBN_BAND_CLASS_VIII = MBN_BAND_CLASS.VIII;
pub const MBN_BAND_CLASS_IX = MBN_BAND_CLASS.IX;
pub const MBN_BAND_CLASS_X = MBN_BAND_CLASS.X;
pub const MBN_BAND_CLASS_XI = MBN_BAND_CLASS.XI;
pub const MBN_BAND_CLASS_XII = MBN_BAND_CLASS.XII;
pub const MBN_BAND_CLASS_XIII = MBN_BAND_CLASS.XIII;
pub const MBN_BAND_CLASS_XIV = MBN_BAND_CLASS.XIV;
pub const MBN_BAND_CLASS_XV = MBN_BAND_CLASS.XV;
pub const MBN_BAND_CLASS_XVI = MBN_BAND_CLASS.XVI;
pub const MBN_BAND_CLASS_XVII = MBN_BAND_CLASS.XVII;
pub const MBN_BAND_CLASS_CUSTOM = MBN_BAND_CLASS.CUSTOM;

pub const MBN_INTERFACE_CAPS = extern struct {
    cellularClass: MBN_CELLULAR_CLASS,
    voiceClass: MBN_VOICE_CLASS,
    dataClass: u32,
    customDataClass: ?BSTR,
    gsmBandClass: u32,
    cdmaBandClass: u32,
    customBandClass: ?BSTR,
    smsCaps: u32,
    controlCaps: u32,
    deviceID: ?BSTR,
    manufacturer: ?BSTR,
    model: ?BSTR,
    firmwareInfo: ?BSTR,
};

pub const MBN_PROVIDER = extern struct {
    providerID: ?BSTR,
    providerState: u32,
    providerName: ?BSTR,
    dataClass: u32,
};

pub const MBN_PROVIDER2 = extern struct {
    provider: MBN_PROVIDER,
    cellularClass: MBN_CELLULAR_CLASS,
    signalStrength: u32,
    signalError: u32,
};

pub const MBN_READY_STATE = enum(i32) {
    OFF = 0,
    INITIALIZED = 1,
    SIM_NOT_INSERTED = 2,
    BAD_SIM = 3,
    FAILURE = 4,
    NOT_ACTIVATED = 5,
    DEVICE_LOCKED = 6,
    DEVICE_BLOCKED = 7,
    NO_ESIM_PROFILE = 8,
};
pub const MBN_READY_STATE_OFF = MBN_READY_STATE.OFF;
pub const MBN_READY_STATE_INITIALIZED = MBN_READY_STATE.INITIALIZED;
pub const MBN_READY_STATE_SIM_NOT_INSERTED = MBN_READY_STATE.SIM_NOT_INSERTED;
pub const MBN_READY_STATE_BAD_SIM = MBN_READY_STATE.BAD_SIM;
pub const MBN_READY_STATE_FAILURE = MBN_READY_STATE.FAILURE;
pub const MBN_READY_STATE_NOT_ACTIVATED = MBN_READY_STATE.NOT_ACTIVATED;
pub const MBN_READY_STATE_DEVICE_LOCKED = MBN_READY_STATE.DEVICE_LOCKED;
pub const MBN_READY_STATE_DEVICE_BLOCKED = MBN_READY_STATE.DEVICE_BLOCKED;
pub const MBN_READY_STATE_NO_ESIM_PROFILE = MBN_READY_STATE.NO_ESIM_PROFILE;

pub const MBN_ACTIVATION_STATE = enum(i32) {
    NONE = 0,
    ACTIVATED = 1,
    ACTIVATING = 2,
    DEACTIVATED = 3,
    DEACTIVATING = 4,
};
pub const MBN_ACTIVATION_STATE_NONE = MBN_ACTIVATION_STATE.NONE;
pub const MBN_ACTIVATION_STATE_ACTIVATED = MBN_ACTIVATION_STATE.ACTIVATED;
pub const MBN_ACTIVATION_STATE_ACTIVATING = MBN_ACTIVATION_STATE.ACTIVATING;
pub const MBN_ACTIVATION_STATE_DEACTIVATED = MBN_ACTIVATION_STATE.DEACTIVATED;
pub const MBN_ACTIVATION_STATE_DEACTIVATING = MBN_ACTIVATION_STATE.DEACTIVATING;

pub const MBN_CONNECTION_MODE = enum(i32) {
    PROFILE = 0,
    TMP_PROFILE = 1,
};
pub const MBN_CONNECTION_MODE_PROFILE = MBN_CONNECTION_MODE.PROFILE;
pub const MBN_CONNECTION_MODE_TMP_PROFILE = MBN_CONNECTION_MODE.TMP_PROFILE;

pub const MBN_VOICE_CALL_STATE = enum(i32) {
    NONE = 0,
    IN_PROGRESS = 1,
    HANGUP = 2,
};
pub const MBN_VOICE_CALL_STATE_NONE = MBN_VOICE_CALL_STATE.NONE;
pub const MBN_VOICE_CALL_STATE_IN_PROGRESS = MBN_VOICE_CALL_STATE.IN_PROGRESS;
pub const MBN_VOICE_CALL_STATE_HANGUP = MBN_VOICE_CALL_STATE.HANGUP;

pub const MBN_REGISTRATION_CONSTANTS = enum(i32) {
    ROAMTEXT_LEN = 64,
    CDMA_DEFAULT_PROVIDER_ID = 0,
};
pub const MBN_ROAMTEXT_LEN = MBN_REGISTRATION_CONSTANTS.ROAMTEXT_LEN;
pub const MBN_CDMA_DEFAULT_PROVIDER_ID = MBN_REGISTRATION_CONSTANTS.CDMA_DEFAULT_PROVIDER_ID;

pub const MBN_REGISTER_STATE = enum(i32) {
    NONE = 0,
    DEREGISTERED = 1,
    SEARCHING = 2,
    HOME = 3,
    ROAMING = 4,
    PARTNER = 5,
    DENIED = 6,
};
pub const MBN_REGISTER_STATE_NONE = MBN_REGISTER_STATE.NONE;
pub const MBN_REGISTER_STATE_DEREGISTERED = MBN_REGISTER_STATE.DEREGISTERED;
pub const MBN_REGISTER_STATE_SEARCHING = MBN_REGISTER_STATE.SEARCHING;
pub const MBN_REGISTER_STATE_HOME = MBN_REGISTER_STATE.HOME;
pub const MBN_REGISTER_STATE_ROAMING = MBN_REGISTER_STATE.ROAMING;
pub const MBN_REGISTER_STATE_PARTNER = MBN_REGISTER_STATE.PARTNER;
pub const MBN_REGISTER_STATE_DENIED = MBN_REGISTER_STATE.DENIED;

pub const MBN_REGISTER_MODE = enum(i32) {
    NONE = 0,
    AUTOMATIC = 1,
    MANUAL = 2,
};
pub const MBN_REGISTER_MODE_NONE = MBN_REGISTER_MODE.NONE;
pub const MBN_REGISTER_MODE_AUTOMATIC = MBN_REGISTER_MODE.AUTOMATIC;
pub const MBN_REGISTER_MODE_MANUAL = MBN_REGISTER_MODE.MANUAL;

pub const MBN_PIN_CONSTANTS = enum(i32) {
    ATTEMPTS_REMAINING_UNKNOWN = -1,
    // PIN_LENGTH_UNKNOWN = -1, this enum value conflicts with ATTEMPTS_REMAINING_UNKNOWN
};
pub const MBN_ATTEMPTS_REMAINING_UNKNOWN = MBN_PIN_CONSTANTS.ATTEMPTS_REMAINING_UNKNOWN;
pub const MBN_PIN_LENGTH_UNKNOWN = MBN_PIN_CONSTANTS.ATTEMPTS_REMAINING_UNKNOWN;

pub const MBN_PIN_STATE = enum(i32) {
    NONE = 0,
    ENTER = 1,
    UNBLOCK = 2,
};
pub const MBN_PIN_STATE_NONE = MBN_PIN_STATE.NONE;
pub const MBN_PIN_STATE_ENTER = MBN_PIN_STATE.ENTER;
pub const MBN_PIN_STATE_UNBLOCK = MBN_PIN_STATE.UNBLOCK;

pub const MBN_PIN_TYPE = enum(i32) {
    NONE = 0,
    CUSTOM = 1,
    PIN1 = 2,
    PIN2 = 3,
    DEVICE_SIM_PIN = 4,
    DEVICE_FIRST_SIM_PIN = 5,
    NETWORK_PIN = 6,
    NETWORK_SUBSET_PIN = 7,
    SVC_PROVIDER_PIN = 8,
    CORPORATE_PIN = 9,
    SUBSIDY_LOCK = 10,
};
pub const MBN_PIN_TYPE_NONE = MBN_PIN_TYPE.NONE;
pub const MBN_PIN_TYPE_CUSTOM = MBN_PIN_TYPE.CUSTOM;
pub const MBN_PIN_TYPE_PIN1 = MBN_PIN_TYPE.PIN1;
pub const MBN_PIN_TYPE_PIN2 = MBN_PIN_TYPE.PIN2;
pub const MBN_PIN_TYPE_DEVICE_SIM_PIN = MBN_PIN_TYPE.DEVICE_SIM_PIN;
pub const MBN_PIN_TYPE_DEVICE_FIRST_SIM_PIN = MBN_PIN_TYPE.DEVICE_FIRST_SIM_PIN;
pub const MBN_PIN_TYPE_NETWORK_PIN = MBN_PIN_TYPE.NETWORK_PIN;
pub const MBN_PIN_TYPE_NETWORK_SUBSET_PIN = MBN_PIN_TYPE.NETWORK_SUBSET_PIN;
pub const MBN_PIN_TYPE_SVC_PROVIDER_PIN = MBN_PIN_TYPE.SVC_PROVIDER_PIN;
pub const MBN_PIN_TYPE_CORPORATE_PIN = MBN_PIN_TYPE.CORPORATE_PIN;
pub const MBN_PIN_TYPE_SUBSIDY_LOCK = MBN_PIN_TYPE.SUBSIDY_LOCK;

pub const MBN_PIN_INFO = extern struct {
    pinState: MBN_PIN_STATE,
    pinType: MBN_PIN_TYPE,
    attemptsRemaining: u32,
};

pub const MBN_PIN_MODE = enum(i32) {
    ENABLED = 1,
    DISABLED = 2,
};
pub const MBN_PIN_MODE_ENABLED = MBN_PIN_MODE.ENABLED;
pub const MBN_PIN_MODE_DISABLED = MBN_PIN_MODE.DISABLED;

pub const MBN_PIN_FORMAT = enum(i32) {
    NONE = 0,
    NUMERIC = 1,
    ALPHANUMERIC = 2,
};
pub const MBN_PIN_FORMAT_NONE = MBN_PIN_FORMAT.NONE;
pub const MBN_PIN_FORMAT_NUMERIC = MBN_PIN_FORMAT.NUMERIC;
pub const MBN_PIN_FORMAT_ALPHANUMERIC = MBN_PIN_FORMAT.ALPHANUMERIC;

pub const MBN_CONTEXT_CONSTANTS = enum(i32) {
    ACCESSSTRING_LEN = 100,
    USERNAME_LEN = 255,
    // PASSWORD_LEN = 255, this enum value conflicts with USERNAME_LEN
    CONTEXT_ID_APPEND = -1,
};
pub const MBN_ACCESSSTRING_LEN = MBN_CONTEXT_CONSTANTS.ACCESSSTRING_LEN;
pub const MBN_USERNAME_LEN = MBN_CONTEXT_CONSTANTS.USERNAME_LEN;
pub const MBN_PASSWORD_LEN = MBN_CONTEXT_CONSTANTS.USERNAME_LEN;
pub const MBN_CONTEXT_ID_APPEND = MBN_CONTEXT_CONSTANTS.CONTEXT_ID_APPEND;

pub const MBN_AUTH_PROTOCOL = enum(i32) {
    NONE = 0,
    PAP = 1,
    CHAP = 2,
    MSCHAPV2 = 3,
};
pub const MBN_AUTH_PROTOCOL_NONE = MBN_AUTH_PROTOCOL.NONE;
pub const MBN_AUTH_PROTOCOL_PAP = MBN_AUTH_PROTOCOL.PAP;
pub const MBN_AUTH_PROTOCOL_CHAP = MBN_AUTH_PROTOCOL.CHAP;
pub const MBN_AUTH_PROTOCOL_MSCHAPV2 = MBN_AUTH_PROTOCOL.MSCHAPV2;

pub const MBN_COMPRESSION = enum(i32) {
    NONE = 0,
    ENABLE = 1,
};
pub const MBN_COMPRESSION_NONE = MBN_COMPRESSION.NONE;
pub const MBN_COMPRESSION_ENABLE = MBN_COMPRESSION.ENABLE;

pub const MBN_CONTEXT_TYPE = enum(i32) {
    NONE = 0,
    INTERNET = 1,
    VPN = 2,
    VOICE = 3,
    VIDEO_SHARE = 4,
    CUSTOM = 5,
    PURCHASE = 6,
};
pub const MBN_CONTEXT_TYPE_NONE = MBN_CONTEXT_TYPE.NONE;
pub const MBN_CONTEXT_TYPE_INTERNET = MBN_CONTEXT_TYPE.INTERNET;
pub const MBN_CONTEXT_TYPE_VPN = MBN_CONTEXT_TYPE.VPN;
pub const MBN_CONTEXT_TYPE_VOICE = MBN_CONTEXT_TYPE.VOICE;
pub const MBN_CONTEXT_TYPE_VIDEO_SHARE = MBN_CONTEXT_TYPE.VIDEO_SHARE;
pub const MBN_CONTEXT_TYPE_CUSTOM = MBN_CONTEXT_TYPE.CUSTOM;
pub const MBN_CONTEXT_TYPE_PURCHASE = MBN_CONTEXT_TYPE.PURCHASE;

pub const MBN_CONTEXT = extern struct {
    contextID: u32,
    contextType: MBN_CONTEXT_TYPE,
    accessString: ?BSTR,
    userName: ?BSTR,
    password: ?BSTR,
    compression: MBN_COMPRESSION,
    authType: MBN_AUTH_PROTOCOL,
};

pub const WWAEXT_SMS_CONSTANTS = enum(i32) {
    MESSAGE_INDEX_NONE = 0,
    // CDMA_SHORT_MSG_SIZE_UNKNOWN = 0, this enum value conflicts with MESSAGE_INDEX_NONE
    CDMA_SHORT_MSG_SIZE_MAX = 160,
};
pub const MBN_MESSAGE_INDEX_NONE = WWAEXT_SMS_CONSTANTS.MESSAGE_INDEX_NONE;
pub const MBN_CDMA_SHORT_MSG_SIZE_UNKNOWN = WWAEXT_SMS_CONSTANTS.MESSAGE_INDEX_NONE;
pub const MBN_CDMA_SHORT_MSG_SIZE_MAX = WWAEXT_SMS_CONSTANTS.CDMA_SHORT_MSG_SIZE_MAX;

pub const MBN_MSG_STATUS = enum(i32) {
    NEW = 0,
    OLD = 1,
    DRAFT = 2,
    SENT = 3,
};
pub const MBN_MSG_STATUS_NEW = MBN_MSG_STATUS.NEW;
pub const MBN_MSG_STATUS_OLD = MBN_MSG_STATUS.OLD;
pub const MBN_MSG_STATUS_DRAFT = MBN_MSG_STATUS.DRAFT;
pub const MBN_MSG_STATUS_SENT = MBN_MSG_STATUS.SENT;

pub const MBN_SMS_CDMA_LANG = enum(i32) {
    NONE = 0,
    ENGLISH = 1,
    FRENCH = 2,
    SPANISH = 3,
    JAPANESE = 4,
    KOREAN = 5,
    CHINESE = 6,
    HEBREW = 7,
};
pub const MBN_SMS_CDMA_LANG_NONE = MBN_SMS_CDMA_LANG.NONE;
pub const MBN_SMS_CDMA_LANG_ENGLISH = MBN_SMS_CDMA_LANG.ENGLISH;
pub const MBN_SMS_CDMA_LANG_FRENCH = MBN_SMS_CDMA_LANG.FRENCH;
pub const MBN_SMS_CDMA_LANG_SPANISH = MBN_SMS_CDMA_LANG.SPANISH;
pub const MBN_SMS_CDMA_LANG_JAPANESE = MBN_SMS_CDMA_LANG.JAPANESE;
pub const MBN_SMS_CDMA_LANG_KOREAN = MBN_SMS_CDMA_LANG.KOREAN;
pub const MBN_SMS_CDMA_LANG_CHINESE = MBN_SMS_CDMA_LANG.CHINESE;
pub const MBN_SMS_CDMA_LANG_HEBREW = MBN_SMS_CDMA_LANG.HEBREW;

pub const MBN_SMS_CDMA_ENCODING = enum(i32) {
    OCTET = 0,
    EPM = 1,
    @"7BIT_ASCII" = 2,
    IA5 = 3,
    UNICODE = 4,
    SHIFT_JIS = 5,
    KOREAN = 6,
    LATIN_HEBREW = 7,
    LATIN = 8,
    GSM_7BIT = 9,
};
pub const MBN_SMS_CDMA_ENCODING_OCTET = MBN_SMS_CDMA_ENCODING.OCTET;
pub const MBN_SMS_CDMA_ENCODING_EPM = MBN_SMS_CDMA_ENCODING.EPM;
pub const MBN_SMS_CDMA_ENCODING_7BIT_ASCII = MBN_SMS_CDMA_ENCODING.@"7BIT_ASCII";
pub const MBN_SMS_CDMA_ENCODING_IA5 = MBN_SMS_CDMA_ENCODING.IA5;
pub const MBN_SMS_CDMA_ENCODING_UNICODE = MBN_SMS_CDMA_ENCODING.UNICODE;
pub const MBN_SMS_CDMA_ENCODING_SHIFT_JIS = MBN_SMS_CDMA_ENCODING.SHIFT_JIS;
pub const MBN_SMS_CDMA_ENCODING_KOREAN = MBN_SMS_CDMA_ENCODING.KOREAN;
pub const MBN_SMS_CDMA_ENCODING_LATIN_HEBREW = MBN_SMS_CDMA_ENCODING.LATIN_HEBREW;
pub const MBN_SMS_CDMA_ENCODING_LATIN = MBN_SMS_CDMA_ENCODING.LATIN;
pub const MBN_SMS_CDMA_ENCODING_GSM_7BIT = MBN_SMS_CDMA_ENCODING.GSM_7BIT;

pub const MBN_SMS_FLAG = enum(i32) {
    ALL = 0,
    INDEX = 1,
    NEW = 2,
    OLD = 3,
    SENT = 4,
    DRAFT = 5,
};
pub const MBN_SMS_FLAG_ALL = MBN_SMS_FLAG.ALL;
pub const MBN_SMS_FLAG_INDEX = MBN_SMS_FLAG.INDEX;
pub const MBN_SMS_FLAG_NEW = MBN_SMS_FLAG.NEW;
pub const MBN_SMS_FLAG_OLD = MBN_SMS_FLAG.OLD;
pub const MBN_SMS_FLAG_SENT = MBN_SMS_FLAG.SENT;
pub const MBN_SMS_FLAG_DRAFT = MBN_SMS_FLAG.DRAFT;

pub const MBN_SMS_FILTER = extern struct {
    flag: MBN_SMS_FLAG,
    messageIndex: u32,
};

pub const MBN_SMS_STATUS_FLAG = enum(i32) {
    NONE = 0,
    MESSAGE_STORE_FULL = 1,
    NEW_MESSAGE = 2,
};
pub const MBN_SMS_FLAG_NONE = MBN_SMS_STATUS_FLAG.NONE;
pub const MBN_SMS_FLAG_MESSAGE_STORE_FULL = MBN_SMS_STATUS_FLAG.MESSAGE_STORE_FULL;
pub const MBN_SMS_FLAG_NEW_MESSAGE = MBN_SMS_STATUS_FLAG.NEW_MESSAGE;

pub const MBN_SMS_STATUS_INFO = extern struct {
    flag: u32,
    messageIndex: u32,
};

pub const MBN_SMS_FORMAT = enum(i32) {
    NONE = 0,
    PDU = 1,
    TEXT = 2,
};
pub const MBN_SMS_FORMAT_NONE = MBN_SMS_FORMAT.NONE;
pub const MBN_SMS_FORMAT_PDU = MBN_SMS_FORMAT.PDU;
pub const MBN_SMS_FORMAT_TEXT = MBN_SMS_FORMAT.TEXT;

pub const MBN_RADIO = enum(i32) {
    FF = 0,
    N = 1,
};
pub const MBN_RADIO_OFF = MBN_RADIO.FF;
pub const MBN_RADIO_ON = MBN_RADIO.N;

pub const MBN_DEVICE_SERVICE_SESSIONS_STATE = enum(i32) {
    D = 0,
};
pub const MBN_DEVICE_SERVICE_SESSIONS_RESTORED = MBN_DEVICE_SERVICE_SESSIONS_STATE.D;

pub const MBN_DEVICE_SERVICE = extern struct {
    deviceServiceID: ?BSTR,
    dataWriteSupported: i16,
    dataReadSupported: i16,
};

pub const MBN_DEVICE_SERVICES_INTERFACE_STATE = enum(i32) {
    ARRIVAL = 0,
    REMOVAL = 1,
};
pub const MBN_DEVICE_SERVICES_CAPABLE_INTERFACE_ARRIVAL = MBN_DEVICE_SERVICES_INTERFACE_STATE.ARRIVAL;
pub const MBN_DEVICE_SERVICES_CAPABLE_INTERFACE_REMOVAL = MBN_DEVICE_SERVICES_INTERFACE_STATE.REMOVAL;

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnConnection_Value = Guid.initString("dcbbbab6-200d-4bbb-aaee-338e368af6fa");
pub const IID_IMbnConnection = &IID_IMbnConnection_Value;
pub const IMbnConnection = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ConnectionID: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnConnection,
                ConnectionID: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnConnection,
                ConnectionID: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_InterfaceID: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnConnection,
                InterfaceID: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnConnection,
                InterfaceID: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Connect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnection,
                connectionMode: MBN_CONNECTION_MODE,
                strProfile: ?[*:0]const u16,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnection,
                connectionMode: MBN_CONNECTION_MODE,
                strProfile: ?[*:0]const u16,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Disconnect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnection,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnection,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetConnectionState: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnection,
                ConnectionState: ?*MBN_ACTIVATION_STATE,
                ProfileName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnection,
                ConnectionState: ?*MBN_ACTIVATION_STATE,
                ProfileName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetVoiceCallState: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnection,
                voiceCallState: ?*MBN_VOICE_CALL_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnection,
                voiceCallState: ?*MBN_VOICE_CALL_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetActivationNetworkError: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnection,
                networkError: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnection,
                networkError: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnection_get_ConnectionID(self: *const T, ConnectionID: ?*?BSTR) HRESULT {
                return @as(*const IMbnConnection.VTable, @ptrCast(self.vtable)).get_ConnectionID(@as(*const IMbnConnection, @ptrCast(self)), ConnectionID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnection_get_InterfaceID(self: *const T, InterfaceID: ?*?BSTR) HRESULT {
                return @as(*const IMbnConnection.VTable, @ptrCast(self.vtable)).get_InterfaceID(@as(*const IMbnConnection, @ptrCast(self)), InterfaceID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnection_Connect(self: *const T, connectionMode: MBN_CONNECTION_MODE, strProfile: ?[*:0]const u16, requestID: ?*u32) HRESULT {
                return @as(*const IMbnConnection.VTable, @ptrCast(self.vtable)).Connect(@as(*const IMbnConnection, @ptrCast(self)), connectionMode, strProfile, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnection_Disconnect(self: *const T, requestID: ?*u32) HRESULT {
                return @as(*const IMbnConnection.VTable, @ptrCast(self.vtable)).Disconnect(@as(*const IMbnConnection, @ptrCast(self)), requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnection_GetConnectionState(self: *const T, ConnectionState: ?*MBN_ACTIVATION_STATE, ProfileName: ?*?BSTR) HRESULT {
                return @as(*const IMbnConnection.VTable, @ptrCast(self.vtable)).GetConnectionState(@as(*const IMbnConnection, @ptrCast(self)), ConnectionState, ProfileName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnection_GetVoiceCallState(self: *const T, voiceCallState: ?*MBN_VOICE_CALL_STATE) HRESULT {
                return @as(*const IMbnConnection.VTable, @ptrCast(self.vtable)).GetVoiceCallState(@as(*const IMbnConnection, @ptrCast(self)), voiceCallState);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnection_GetActivationNetworkError(self: *const T, networkError: ?*u32) HRESULT {
                return @as(*const IMbnConnection.VTable, @ptrCast(self.vtable)).GetActivationNetworkError(@as(*const IMbnConnection, @ptrCast(self)), networkError);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnConnectionEvents_Value = Guid.initString("dcbbbab6-200e-4bbb-aaee-338e368af6fa");
pub const IID_IMbnConnectionEvents = &IID_IMbnConnectionEvents_Value;
pub const IMbnConnectionEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnConnectComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionEvents,
                newConnection: ?*IMbnConnection,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionEvents,
                newConnection: ?*IMbnConnection,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnDisconnectComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionEvents,
                newConnection: ?*IMbnConnection,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionEvents,
                newConnection: ?*IMbnConnection,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnConnectStateChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionEvents,
                newConnection: ?*IMbnConnection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionEvents,
                newConnection: ?*IMbnConnection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnVoiceCallStateChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionEvents,
                newConnection: ?*IMbnConnection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionEvents,
                newConnection: ?*IMbnConnection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionEvents_OnConnectComplete(self: *const T, newConnection: ?*IMbnConnection, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnConnectionEvents.VTable, @ptrCast(self.vtable)).OnConnectComplete(@as(*const IMbnConnectionEvents, @ptrCast(self)), newConnection, requestID, status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionEvents_OnDisconnectComplete(self: *const T, newConnection: ?*IMbnConnection, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnConnectionEvents.VTable, @ptrCast(self.vtable)).OnDisconnectComplete(@as(*const IMbnConnectionEvents, @ptrCast(self)), newConnection, requestID, status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionEvents_OnConnectStateChange(self: *const T, newConnection: ?*IMbnConnection) HRESULT {
                return @as(*const IMbnConnectionEvents.VTable, @ptrCast(self.vtable)).OnConnectStateChange(@as(*const IMbnConnectionEvents, @ptrCast(self)), newConnection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionEvents_OnVoiceCallStateChange(self: *const T, newConnection: ?*IMbnConnection) HRESULT {
                return @as(*const IMbnConnectionEvents.VTable, @ptrCast(self.vtable)).OnVoiceCallStateChange(@as(*const IMbnConnectionEvents, @ptrCast(self)), newConnection);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnInterface_Value = Guid.initString("dcbbbab6-2001-4bbb-aaee-338e368af6fa");
pub const IID_IMbnInterface = &IID_IMbnInterface_Value;
pub const IMbnInterface = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_InterfaceID: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnInterface,
                InterfaceID: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnInterface,
                InterfaceID: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInterfaceCapability: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterface,
                interfaceCaps: ?*MBN_INTERFACE_CAPS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterface,
                interfaceCaps: ?*MBN_INTERFACE_CAPS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetSubscriberInformation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterface,
                subscriberInformation: ?*?*IMbnSubscriberInformation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterface,
                subscriberInformation: ?*?*IMbnSubscriberInformation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetReadyState: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterface,
                readyState: ?*MBN_READY_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterface,
                readyState: ?*MBN_READY_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        InEmergencyMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterface,
                emergencyMode: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterface,
                emergencyMode: ?*i16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetHomeProvider: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterface,
                homeProvider: ?*MBN_PROVIDER,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterface,
                homeProvider: ?*MBN_PROVIDER,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPreferredProviders: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterface,
                preferredProviders: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterface,
                preferredProviders: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetPreferredProviders: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterface,
                preferredProviders: ?*SAFEARRAY,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterface,
                preferredProviders: ?*SAFEARRAY,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetVisibleProviders: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterface,
                age: ?*u32,
                visibleProviders: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterface,
                age: ?*u32,
                visibleProviders: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ScanNetwork: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterface,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterface,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetConnection: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterface,
                mbnConnection: ?*?*IMbnConnection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterface,
                mbnConnection: ?*?*IMbnConnection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterface_get_InterfaceID(self: *const T, InterfaceID: ?*?BSTR) HRESULT {
                return @as(*const IMbnInterface.VTable, @ptrCast(self.vtable)).get_InterfaceID(@as(*const IMbnInterface, @ptrCast(self)), InterfaceID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterface_GetInterfaceCapability(self: *const T, interfaceCaps: ?*MBN_INTERFACE_CAPS) HRESULT {
                return @as(*const IMbnInterface.VTable, @ptrCast(self.vtable)).GetInterfaceCapability(@as(*const IMbnInterface, @ptrCast(self)), interfaceCaps);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterface_GetSubscriberInformation(self: *const T, subscriberInformation: ?*?*IMbnSubscriberInformation) HRESULT {
                return @as(*const IMbnInterface.VTable, @ptrCast(self.vtable)).GetSubscriberInformation(@as(*const IMbnInterface, @ptrCast(self)), subscriberInformation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterface_GetReadyState(self: *const T, readyState: ?*MBN_READY_STATE) HRESULT {
                return @as(*const IMbnInterface.VTable, @ptrCast(self.vtable)).GetReadyState(@as(*const IMbnInterface, @ptrCast(self)), readyState);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterface_InEmergencyMode(self: *const T, emergencyMode: ?*i16) HRESULT {
                return @as(*const IMbnInterface.VTable, @ptrCast(self.vtable)).InEmergencyMode(@as(*const IMbnInterface, @ptrCast(self)), emergencyMode);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterface_GetHomeProvider(self: *const T, homeProvider: ?*MBN_PROVIDER) HRESULT {
                return @as(*const IMbnInterface.VTable, @ptrCast(self.vtable)).GetHomeProvider(@as(*const IMbnInterface, @ptrCast(self)), homeProvider);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterface_GetPreferredProviders(self: *const T, preferredProviders: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IMbnInterface.VTable, @ptrCast(self.vtable)).GetPreferredProviders(@as(*const IMbnInterface, @ptrCast(self)), preferredProviders);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterface_SetPreferredProviders(self: *const T, preferredProviders: ?*SAFEARRAY, requestID: ?*u32) HRESULT {
                return @as(*const IMbnInterface.VTable, @ptrCast(self.vtable)).SetPreferredProviders(@as(*const IMbnInterface, @ptrCast(self)), preferredProviders, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterface_GetVisibleProviders(self: *const T, age: ?*u32, visibleProviders: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IMbnInterface.VTable, @ptrCast(self.vtable)).GetVisibleProviders(@as(*const IMbnInterface, @ptrCast(self)), age, visibleProviders);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterface_ScanNetwork(self: *const T, requestID: ?*u32) HRESULT {
                return @as(*const IMbnInterface.VTable, @ptrCast(self.vtable)).ScanNetwork(@as(*const IMbnInterface, @ptrCast(self)), requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterface_GetConnection(self: *const T, mbnConnection: ?*?*IMbnConnection) HRESULT {
                return @as(*const IMbnInterface.VTable, @ptrCast(self.vtable)).GetConnection(@as(*const IMbnInterface, @ptrCast(self)), mbnConnection);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnInterfaceEvents_Value = Guid.initString("dcbbbab6-2002-4bbb-aaee-338e368af6fa");
pub const IID_IMbnInterfaceEvents = &IID_IMbnInterfaceEvents_Value;
pub const IMbnInterfaceEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnInterfaceCapabilityAvailable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterfaceEvents,
                newInterface: ?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterfaceEvents,
                newInterface: ?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnSubscriberInformationChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterfaceEvents,
                newInterface: ?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterfaceEvents,
                newInterface: ?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnReadyStateChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterfaceEvents,
                newInterface: ?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterfaceEvents,
                newInterface: ?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnEmergencyModeChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterfaceEvents,
                newInterface: ?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterfaceEvents,
                newInterface: ?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnHomeProviderAvailable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterfaceEvents,
                newInterface: ?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterfaceEvents,
                newInterface: ?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnPreferredProvidersChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterfaceEvents,
                newInterface: ?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterfaceEvents,
                newInterface: ?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnSetPreferredProvidersComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterfaceEvents,
                newInterface: ?*IMbnInterface,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterfaceEvents,
                newInterface: ?*IMbnInterface,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnScanNetworkComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterfaceEvents,
                newInterface: ?*IMbnInterface,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterfaceEvents,
                newInterface: ?*IMbnInterface,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterfaceEvents_OnInterfaceCapabilityAvailable(self: *const T, newInterface: ?*IMbnInterface) HRESULT {
                return @as(*const IMbnInterfaceEvents.VTable, @ptrCast(self.vtable)).OnInterfaceCapabilityAvailable(@as(*const IMbnInterfaceEvents, @ptrCast(self)), newInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterfaceEvents_OnSubscriberInformationChange(self: *const T, newInterface: ?*IMbnInterface) HRESULT {
                return @as(*const IMbnInterfaceEvents.VTable, @ptrCast(self.vtable)).OnSubscriberInformationChange(@as(*const IMbnInterfaceEvents, @ptrCast(self)), newInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterfaceEvents_OnReadyStateChange(self: *const T, newInterface: ?*IMbnInterface) HRESULT {
                return @as(*const IMbnInterfaceEvents.VTable, @ptrCast(self.vtable)).OnReadyStateChange(@as(*const IMbnInterfaceEvents, @ptrCast(self)), newInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterfaceEvents_OnEmergencyModeChange(self: *const T, newInterface: ?*IMbnInterface) HRESULT {
                return @as(*const IMbnInterfaceEvents.VTable, @ptrCast(self.vtable)).OnEmergencyModeChange(@as(*const IMbnInterfaceEvents, @ptrCast(self)), newInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterfaceEvents_OnHomeProviderAvailable(self: *const T, newInterface: ?*IMbnInterface) HRESULT {
                return @as(*const IMbnInterfaceEvents.VTable, @ptrCast(self.vtable)).OnHomeProviderAvailable(@as(*const IMbnInterfaceEvents, @ptrCast(self)), newInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterfaceEvents_OnPreferredProvidersChange(self: *const T, newInterface: ?*IMbnInterface) HRESULT {
                return @as(*const IMbnInterfaceEvents.VTable, @ptrCast(self.vtable)).OnPreferredProvidersChange(@as(*const IMbnInterfaceEvents, @ptrCast(self)), newInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterfaceEvents_OnSetPreferredProvidersComplete(self: *const T, newInterface: ?*IMbnInterface, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnInterfaceEvents.VTable, @ptrCast(self.vtable)).OnSetPreferredProvidersComplete(@as(*const IMbnInterfaceEvents, @ptrCast(self)), newInterface, requestID, status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterfaceEvents_OnScanNetworkComplete(self: *const T, newInterface: ?*IMbnInterface, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnInterfaceEvents.VTable, @ptrCast(self.vtable)).OnScanNetworkComplete(@as(*const IMbnInterfaceEvents, @ptrCast(self)), newInterface, requestID, status);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnInterfaceManager_Value = Guid.initString("dcbbbab6-201b-4bbb-aaee-338e368af6fa");
pub const IID_IMbnInterfaceManager = &IID_IMbnInterfaceManager_Value;
pub const IMbnInterfaceManager = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetInterface: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterfaceManager,
                interfaceID: ?[*:0]const u16,
                mbnInterface: ?*?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterfaceManager,
                interfaceID: ?[*:0]const u16,
                mbnInterface: ?*?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInterfaces: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterfaceManager,
                mbnInterfaces: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterfaceManager,
                mbnInterfaces: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterfaceManager_GetInterface(self: *const T, interfaceID: ?[*:0]const u16, mbnInterface: ?*?*IMbnInterface) HRESULT {
                return @as(*const IMbnInterfaceManager.VTable, @ptrCast(self.vtable)).GetInterface(@as(*const IMbnInterfaceManager, @ptrCast(self)), interfaceID, mbnInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterfaceManager_GetInterfaces(self: *const T, mbnInterfaces: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IMbnInterfaceManager.VTable, @ptrCast(self.vtable)).GetInterfaces(@as(*const IMbnInterfaceManager, @ptrCast(self)), mbnInterfaces);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnInterfaceManagerEvents_Value = Guid.initString("dcbbbab6-201c-4bbb-aaee-338e368af6fa");
pub const IID_IMbnInterfaceManagerEvents = &IID_IMbnInterfaceManagerEvents_Value;
pub const IMbnInterfaceManagerEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnInterfaceArrival: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterfaceManagerEvents,
                newInterface: ?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterfaceManagerEvents,
                newInterface: ?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnInterfaceRemoval: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnInterfaceManagerEvents,
                oldInterface: ?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnInterfaceManagerEvents,
                oldInterface: ?*IMbnInterface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterfaceManagerEvents_OnInterfaceArrival(self: *const T, newInterface: ?*IMbnInterface) HRESULT {
                return @as(*const IMbnInterfaceManagerEvents.VTable, @ptrCast(self.vtable)).OnInterfaceArrival(@as(*const IMbnInterfaceManagerEvents, @ptrCast(self)), newInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnInterfaceManagerEvents_OnInterfaceRemoval(self: *const T, oldInterface: ?*IMbnInterface) HRESULT {
                return @as(*const IMbnInterfaceManagerEvents.VTable, @ptrCast(self.vtable)).OnInterfaceRemoval(@as(*const IMbnInterfaceManagerEvents, @ptrCast(self)), oldInterface);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnRegistration_Value = Guid.initString("dcbbbab6-2009-4bbb-aaee-338e368af6fa");
pub const IID_IMbnRegistration = &IID_IMbnRegistration_Value;
pub const IMbnRegistration = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetRegisterState: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRegistration,
                registerState: ?*MBN_REGISTER_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRegistration,
                registerState: ?*MBN_REGISTER_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetRegisterMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRegistration,
                registerMode: ?*MBN_REGISTER_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRegistration,
                registerMode: ?*MBN_REGISTER_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetProviderID: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRegistration,
                providerID: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRegistration,
                providerID: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetProviderName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRegistration,
                providerName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRegistration,
                providerName: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetRoamingText: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRegistration,
                roamingText: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRegistration,
                roamingText: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAvailableDataClasses: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRegistration,
                availableDataClasses: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRegistration,
                availableDataClasses: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetCurrentDataClass: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRegistration,
                currentDataClass: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRegistration,
                currentDataClass: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetRegistrationNetworkError: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRegistration,
                registrationNetworkError: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRegistration,
                registrationNetworkError: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPacketAttachNetworkError: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRegistration,
                packetAttachNetworkError: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRegistration,
                packetAttachNetworkError: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetRegisterMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRegistration,
                registerMode: MBN_REGISTER_MODE,
                providerID: ?[*:0]const u16,
                dataClass: u32,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRegistration,
                registerMode: MBN_REGISTER_MODE,
                providerID: ?[*:0]const u16,
                dataClass: u32,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRegistration_GetRegisterState(self: *const T, registerState: ?*MBN_REGISTER_STATE) HRESULT {
                return @as(*const IMbnRegistration.VTable, @ptrCast(self.vtable)).GetRegisterState(@as(*const IMbnRegistration, @ptrCast(self)), registerState);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRegistration_GetRegisterMode(self: *const T, registerMode: ?*MBN_REGISTER_MODE) HRESULT {
                return @as(*const IMbnRegistration.VTable, @ptrCast(self.vtable)).GetRegisterMode(@as(*const IMbnRegistration, @ptrCast(self)), registerMode);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRegistration_GetProviderID(self: *const T, providerID: ?*?BSTR) HRESULT {
                return @as(*const IMbnRegistration.VTable, @ptrCast(self.vtable)).GetProviderID(@as(*const IMbnRegistration, @ptrCast(self)), providerID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRegistration_GetProviderName(self: *const T, providerName: ?*?BSTR) HRESULT {
                return @as(*const IMbnRegistration.VTable, @ptrCast(self.vtable)).GetProviderName(@as(*const IMbnRegistration, @ptrCast(self)), providerName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRegistration_GetRoamingText(self: *const T, roamingText: ?*?BSTR) HRESULT {
                return @as(*const IMbnRegistration.VTable, @ptrCast(self.vtable)).GetRoamingText(@as(*const IMbnRegistration, @ptrCast(self)), roamingText);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRegistration_GetAvailableDataClasses(self: *const T, availableDataClasses: ?*u32) HRESULT {
                return @as(*const IMbnRegistration.VTable, @ptrCast(self.vtable)).GetAvailableDataClasses(@as(*const IMbnRegistration, @ptrCast(self)), availableDataClasses);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRegistration_GetCurrentDataClass(self: *const T, currentDataClass: ?*u32) HRESULT {
                return @as(*const IMbnRegistration.VTable, @ptrCast(self.vtable)).GetCurrentDataClass(@as(*const IMbnRegistration, @ptrCast(self)), currentDataClass);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRegistration_GetRegistrationNetworkError(self: *const T, registrationNetworkError: ?*u32) HRESULT {
                return @as(*const IMbnRegistration.VTable, @ptrCast(self.vtable)).GetRegistrationNetworkError(@as(*const IMbnRegistration, @ptrCast(self)), registrationNetworkError);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRegistration_GetPacketAttachNetworkError(self: *const T, packetAttachNetworkError: ?*u32) HRESULT {
                return @as(*const IMbnRegistration.VTable, @ptrCast(self.vtable)).GetPacketAttachNetworkError(@as(*const IMbnRegistration, @ptrCast(self)), packetAttachNetworkError);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRegistration_SetRegisterMode(self: *const T, registerMode: MBN_REGISTER_MODE, providerID: ?[*:0]const u16, dataClass: u32, requestID: ?*u32) HRESULT {
                return @as(*const IMbnRegistration.VTable, @ptrCast(self.vtable)).SetRegisterMode(@as(*const IMbnRegistration, @ptrCast(self)), registerMode, providerID, dataClass, requestID);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnRegistrationEvents_Value = Guid.initString("dcbbbab6-200a-4bbb-aaee-338e368af6fa");
pub const IID_IMbnRegistrationEvents = &IID_IMbnRegistrationEvents_Value;
pub const IMbnRegistrationEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnRegisterModeAvailable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRegistrationEvents,
                newInterface: ?*IMbnRegistration,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRegistrationEvents,
                newInterface: ?*IMbnRegistration,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnRegisterStateChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRegistrationEvents,
                newInterface: ?*IMbnRegistration,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRegistrationEvents,
                newInterface: ?*IMbnRegistration,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnPacketServiceStateChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRegistrationEvents,
                newInterface: ?*IMbnRegistration,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRegistrationEvents,
                newInterface: ?*IMbnRegistration,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnSetRegisterModeComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRegistrationEvents,
                newInterface: ?*IMbnRegistration,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRegistrationEvents,
                newInterface: ?*IMbnRegistration,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRegistrationEvents_OnRegisterModeAvailable(self: *const T, newInterface: ?*IMbnRegistration) HRESULT {
                return @as(*const IMbnRegistrationEvents.VTable, @ptrCast(self.vtable)).OnRegisterModeAvailable(@as(*const IMbnRegistrationEvents, @ptrCast(self)), newInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRegistrationEvents_OnRegisterStateChange(self: *const T, newInterface: ?*IMbnRegistration) HRESULT {
                return @as(*const IMbnRegistrationEvents.VTable, @ptrCast(self.vtable)).OnRegisterStateChange(@as(*const IMbnRegistrationEvents, @ptrCast(self)), newInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRegistrationEvents_OnPacketServiceStateChange(self: *const T, newInterface: ?*IMbnRegistration) HRESULT {
                return @as(*const IMbnRegistrationEvents.VTable, @ptrCast(self.vtable)).OnPacketServiceStateChange(@as(*const IMbnRegistrationEvents, @ptrCast(self)), newInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRegistrationEvents_OnSetRegisterModeComplete(self: *const T, newInterface: ?*IMbnRegistration, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnRegistrationEvents.VTable, @ptrCast(self.vtable)).OnSetRegisterModeComplete(@as(*const IMbnRegistrationEvents, @ptrCast(self)), newInterface, requestID, status);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnConnectionManager_Value = Guid.initString("dcbbbab6-201d-4bbb-aaee-338e368af6fa");
pub const IID_IMbnConnectionManager = &IID_IMbnConnectionManager_Value;
pub const IMbnConnectionManager = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetConnection: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionManager,
                connectionID: ?[*:0]const u16,
                mbnConnection: ?*?*IMbnConnection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionManager,
                connectionID: ?[*:0]const u16,
                mbnConnection: ?*?*IMbnConnection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetConnections: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionManager,
                mbnConnections: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionManager,
                mbnConnections: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionManager_GetConnection(self: *const T, connectionID: ?[*:0]const u16, mbnConnection: ?*?*IMbnConnection) HRESULT {
                return @as(*const IMbnConnectionManager.VTable, @ptrCast(self.vtable)).GetConnection(@as(*const IMbnConnectionManager, @ptrCast(self)), connectionID, mbnConnection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionManager_GetConnections(self: *const T, mbnConnections: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IMbnConnectionManager.VTable, @ptrCast(self.vtable)).GetConnections(@as(*const IMbnConnectionManager, @ptrCast(self)), mbnConnections);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnConnectionManagerEvents_Value = Guid.initString("dcbbbab6-201e-4bbb-aaee-338e368af6fa");
pub const IID_IMbnConnectionManagerEvents = &IID_IMbnConnectionManagerEvents_Value;
pub const IMbnConnectionManagerEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnConnectionArrival: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionManagerEvents,
                newConnection: ?*IMbnConnection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionManagerEvents,
                newConnection: ?*IMbnConnection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnConnectionRemoval: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionManagerEvents,
                oldConnection: ?*IMbnConnection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionManagerEvents,
                oldConnection: ?*IMbnConnection,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionManagerEvents_OnConnectionArrival(self: *const T, newConnection: ?*IMbnConnection) HRESULT {
                return @as(*const IMbnConnectionManagerEvents.VTable, @ptrCast(self.vtable)).OnConnectionArrival(@as(*const IMbnConnectionManagerEvents, @ptrCast(self)), newConnection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionManagerEvents_OnConnectionRemoval(self: *const T, oldConnection: ?*IMbnConnection) HRESULT {
                return @as(*const IMbnConnectionManagerEvents.VTable, @ptrCast(self.vtable)).OnConnectionRemoval(@as(*const IMbnConnectionManagerEvents, @ptrCast(self)), oldConnection);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnPinManager_Value = Guid.initString("dcbbbab6-2005-4bbb-aaee-338e368af6fa");
pub const IID_IMbnPinManager = &IID_IMbnPinManager_Value;
pub const IMbnPinManager = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetPinList: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnPinManager,
                pinList: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnPinManager,
                pinList: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPin: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnPinManager,
                pinType: MBN_PIN_TYPE,
                pin: ?*?*IMbnPin,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnPinManager,
                pinType: MBN_PIN_TYPE,
                pin: ?*?*IMbnPin,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPinState: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnPinManager,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnPinManager,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPinManager_GetPinList(self: *const T, pinList: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IMbnPinManager.VTable, @ptrCast(self.vtable)).GetPinList(@as(*const IMbnPinManager, @ptrCast(self)), pinList);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPinManager_GetPin(self: *const T, pinType: MBN_PIN_TYPE, pin: ?*?*IMbnPin) HRESULT {
                return @as(*const IMbnPinManager.VTable, @ptrCast(self.vtable)).GetPin(@as(*const IMbnPinManager, @ptrCast(self)), pinType, pin);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPinManager_GetPinState(self: *const T, requestID: ?*u32) HRESULT {
                return @as(*const IMbnPinManager.VTable, @ptrCast(self.vtable)).GetPinState(@as(*const IMbnPinManager, @ptrCast(self)), requestID);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnPinManagerEvents_Value = Guid.initString("dcbbbab6-2006-4bbb-aaee-338e368af6fa");
pub const IID_IMbnPinManagerEvents = &IID_IMbnPinManagerEvents_Value;
pub const IMbnPinManagerEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnPinListAvailable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnPinManagerEvents,
                pinManager: ?*IMbnPinManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnPinManagerEvents,
                pinManager: ?*IMbnPinManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnGetPinStateComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnPinManagerEvents,
                pinManager: ?*IMbnPinManager,
                pinInfo: MBN_PIN_INFO,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnPinManagerEvents,
                pinManager: ?*IMbnPinManager,
                pinInfo: MBN_PIN_INFO,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPinManagerEvents_OnPinListAvailable(self: *const T, pinManager: ?*IMbnPinManager) HRESULT {
                return @as(*const IMbnPinManagerEvents.VTable, @ptrCast(self.vtable)).OnPinListAvailable(@as(*const IMbnPinManagerEvents, @ptrCast(self)), pinManager);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPinManagerEvents_OnGetPinStateComplete(self: *const T, pinManager: ?*IMbnPinManager, pinInfo: MBN_PIN_INFO, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnPinManagerEvents.VTable, @ptrCast(self.vtable)).OnGetPinStateComplete(@as(*const IMbnPinManagerEvents, @ptrCast(self)), pinManager, pinInfo, requestID, status);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnPinEvents_Value = Guid.initString("dcbbbab6-2008-4bbb-aaee-338e368af6fa");
pub const IID_IMbnPinEvents = &IID_IMbnPinEvents_Value;
pub const IMbnPinEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnEnableComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnPinEvents,
                pin: ?*IMbnPin,
                pinInfo: ?*MBN_PIN_INFO,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnPinEvents,
                pin: ?*IMbnPin,
                pinInfo: ?*MBN_PIN_INFO,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnDisableComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnPinEvents,
                pin: ?*IMbnPin,
                pinInfo: ?*MBN_PIN_INFO,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnPinEvents,
                pin: ?*IMbnPin,
                pinInfo: ?*MBN_PIN_INFO,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnEnterComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnPinEvents,
                Pin: ?*IMbnPin,
                pinInfo: ?*MBN_PIN_INFO,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnPinEvents,
                Pin: ?*IMbnPin,
                pinInfo: ?*MBN_PIN_INFO,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnChangeComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnPinEvents,
                Pin: ?*IMbnPin,
                pinInfo: ?*MBN_PIN_INFO,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnPinEvents,
                Pin: ?*IMbnPin,
                pinInfo: ?*MBN_PIN_INFO,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnUnblockComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnPinEvents,
                Pin: ?*IMbnPin,
                pinInfo: ?*MBN_PIN_INFO,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnPinEvents,
                Pin: ?*IMbnPin,
                pinInfo: ?*MBN_PIN_INFO,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPinEvents_OnEnableComplete(self: *const T, pin: ?*IMbnPin, pinInfo: ?*MBN_PIN_INFO, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnPinEvents.VTable, @ptrCast(self.vtable)).OnEnableComplete(@as(*const IMbnPinEvents, @ptrCast(self)), pin, pinInfo, requestID, status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPinEvents_OnDisableComplete(self: *const T, pin: ?*IMbnPin, pinInfo: ?*MBN_PIN_INFO, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnPinEvents.VTable, @ptrCast(self.vtable)).OnDisableComplete(@as(*const IMbnPinEvents, @ptrCast(self)), pin, pinInfo, requestID, status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPinEvents_OnEnterComplete(self: *const T, Pin: ?*IMbnPin, pinInfo: ?*MBN_PIN_INFO, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnPinEvents.VTable, @ptrCast(self.vtable)).OnEnterComplete(@as(*const IMbnPinEvents, @ptrCast(self)), Pin, pinInfo, requestID, status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPinEvents_OnChangeComplete(self: *const T, Pin: ?*IMbnPin, pinInfo: ?*MBN_PIN_INFO, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnPinEvents.VTable, @ptrCast(self.vtable)).OnChangeComplete(@as(*const IMbnPinEvents, @ptrCast(self)), Pin, pinInfo, requestID, status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPinEvents_OnUnblockComplete(self: *const T, Pin: ?*IMbnPin, pinInfo: ?*MBN_PIN_INFO, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnPinEvents.VTable, @ptrCast(self.vtable)).OnUnblockComplete(@as(*const IMbnPinEvents, @ptrCast(self)), Pin, pinInfo, requestID, status);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnSubscriberInformation_Value = Guid.initString("459ecc43-bcf5-11dc-a8a8-001321f1405f");
pub const IID_IMbnSubscriberInformation = &IID_IMbnSubscriberInformation_Value;
pub const IMbnSubscriberInformation = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_SubscriberID: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSubscriberInformation,
                SubscriberID: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSubscriberInformation,
                SubscriberID: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_SimIccID: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSubscriberInformation,
                SimIccID: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSubscriberInformation,
                SimIccID: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_TelephoneNumbers: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSubscriberInformation,
                TelephoneNumbers: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSubscriberInformation,
                TelephoneNumbers: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSubscriberInformation_get_SubscriberID(self: *const T, SubscriberID: ?*?BSTR) HRESULT {
                return @as(*const IMbnSubscriberInformation.VTable, @ptrCast(self.vtable)).get_SubscriberID(@as(*const IMbnSubscriberInformation, @ptrCast(self)), SubscriberID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSubscriberInformation_get_SimIccID(self: *const T, SimIccID: ?*?BSTR) HRESULT {
                return @as(*const IMbnSubscriberInformation.VTable, @ptrCast(self.vtable)).get_SimIccID(@as(*const IMbnSubscriberInformation, @ptrCast(self)), SimIccID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSubscriberInformation_get_TelephoneNumbers(self: *const T, TelephoneNumbers: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IMbnSubscriberInformation.VTable, @ptrCast(self.vtable)).get_TelephoneNumbers(@as(*const IMbnSubscriberInformation, @ptrCast(self)), TelephoneNumbers);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnSignal_Value = Guid.initString("dcbbbab6-2003-4bbb-aaee-338e368af6fa");
pub const IID_IMbnSignal = &IID_IMbnSignal_Value;
pub const IMbnSignal = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetSignalStrength: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSignal,
                signalStrength: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSignal,
                signalStrength: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetSignalError: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSignal,
                signalError: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSignal,
                signalError: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSignal_GetSignalStrength(self: *const T, signalStrength: ?*u32) HRESULT {
                return @as(*const IMbnSignal.VTable, @ptrCast(self.vtable)).GetSignalStrength(@as(*const IMbnSignal, @ptrCast(self)), signalStrength);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSignal_GetSignalError(self: *const T, signalError: ?*u32) HRESULT {
                return @as(*const IMbnSignal.VTable, @ptrCast(self.vtable)).GetSignalError(@as(*const IMbnSignal, @ptrCast(self)), signalError);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnSignalEvents_Value = Guid.initString("dcbbbab6-2004-4bbb-aaee-338e368af6fa");
pub const IID_IMbnSignalEvents = &IID_IMbnSignalEvents_Value;
pub const IMbnSignalEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnSignalStateChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSignalEvents,
                newInterface: ?*IMbnSignal,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSignalEvents,
                newInterface: ?*IMbnSignal,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSignalEvents_OnSignalStateChange(self: *const T, newInterface: ?*IMbnSignal) HRESULT {
                return @as(*const IMbnSignalEvents.VTable, @ptrCast(self.vtable)).OnSignalStateChange(@as(*const IMbnSignalEvents, @ptrCast(self)), newInterface);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnConnectionContext_Value = Guid.initString("dcbbbab6-200b-4bbb-aaee-338e368af6fa");
pub const IID_IMbnConnectionContext = &IID_IMbnConnectionContext_Value;
pub const IMbnConnectionContext = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetProvisionedContexts: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionContext,
                provisionedContexts: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionContext,
                provisionedContexts: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetProvisionedContext: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionContext,
                provisionedContexts: MBN_CONTEXT,
                providerID: ?[*:0]const u16,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionContext,
                provisionedContexts: MBN_CONTEXT,
                providerID: ?[*:0]const u16,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionContext_GetProvisionedContexts(self: *const T, provisionedContexts: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IMbnConnectionContext.VTable, @ptrCast(self.vtable)).GetProvisionedContexts(@as(*const IMbnConnectionContext, @ptrCast(self)), provisionedContexts);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionContext_SetProvisionedContext(self: *const T, provisionedContexts: MBN_CONTEXT, providerID: ?[*:0]const u16, requestID: ?*u32) HRESULT {
                return @as(*const IMbnConnectionContext.VTable, @ptrCast(self.vtable)).SetProvisionedContext(@as(*const IMbnConnectionContext, @ptrCast(self)), provisionedContexts, providerID, requestID);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnConnectionContextEvents_Value = Guid.initString("dcbbbab6-200c-4bbb-aaee-338e368af6fa");
pub const IID_IMbnConnectionContextEvents = &IID_IMbnConnectionContextEvents_Value;
pub const IMbnConnectionContextEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnProvisionedContextListChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionContextEvents,
                newInterface: ?*IMbnConnectionContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionContextEvents,
                newInterface: ?*IMbnConnectionContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnSetProvisionedContextComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionContextEvents,
                newInterface: ?*IMbnConnectionContext,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionContextEvents,
                newInterface: ?*IMbnConnectionContext,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionContextEvents_OnProvisionedContextListChange(self: *const T, newInterface: ?*IMbnConnectionContext) HRESULT {
                return @as(*const IMbnConnectionContextEvents.VTable, @ptrCast(self.vtable)).OnProvisionedContextListChange(@as(*const IMbnConnectionContextEvents, @ptrCast(self)), newInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionContextEvents_OnSetProvisionedContextComplete(self: *const T, newInterface: ?*IMbnConnectionContext, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnConnectionContextEvents.VTable, @ptrCast(self.vtable)).OnSetProvisionedContextComplete(@as(*const IMbnConnectionContextEvents, @ptrCast(self)), newInterface, requestID, status);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnConnectionProfileManager_Value = Guid.initString("dcbbbab6-200f-4bbb-aaee-338e368af6fa");
pub const IID_IMbnConnectionProfileManager = &IID_IMbnConnectionProfileManager_Value;
pub const IMbnConnectionProfileManager = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetConnectionProfiles: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionProfileManager,
                mbnInterface: ?*IMbnInterface,
                connectionProfiles: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionProfileManager,
                mbnInterface: ?*IMbnInterface,
                connectionProfiles: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetConnectionProfile: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionProfileManager,
                mbnInterface: ?*IMbnInterface,
                profileName: ?[*:0]const u16,
                connectionProfile: ?*?*IMbnConnectionProfile,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionProfileManager,
                mbnInterface: ?*IMbnInterface,
                profileName: ?[*:0]const u16,
                connectionProfile: ?*?*IMbnConnectionProfile,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateConnectionProfile: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionProfileManager,
                xmlProfile: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionProfileManager,
                xmlProfile: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionProfileManager_GetConnectionProfiles(self: *const T, mbnInterface: ?*IMbnInterface, connectionProfiles: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IMbnConnectionProfileManager.VTable, @ptrCast(self.vtable)).GetConnectionProfiles(@as(*const IMbnConnectionProfileManager, @ptrCast(self)), mbnInterface, connectionProfiles);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionProfileManager_GetConnectionProfile(self: *const T, mbnInterface: ?*IMbnInterface, profileName: ?[*:0]const u16, connectionProfile: ?*?*IMbnConnectionProfile) HRESULT {
                return @as(*const IMbnConnectionProfileManager.VTable, @ptrCast(self.vtable)).GetConnectionProfile(@as(*const IMbnConnectionProfileManager, @ptrCast(self)), mbnInterface, profileName, connectionProfile);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionProfileManager_CreateConnectionProfile(self: *const T, xmlProfile: ?[*:0]const u16) HRESULT {
                return @as(*const IMbnConnectionProfileManager.VTable, @ptrCast(self.vtable)).CreateConnectionProfile(@as(*const IMbnConnectionProfileManager, @ptrCast(self)), xmlProfile);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnConnectionProfile_Value = Guid.initString("dcbbbab6-2010-4bbb-aaee-338e368af6fa");
pub const IID_IMbnConnectionProfile = &IID_IMbnConnectionProfile_Value;
pub const IMbnConnectionProfile = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetProfileXmlData: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionProfile,
                profileData: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionProfile,
                profileData: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        UpdateProfile: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionProfile,
                strProfile: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionProfile,
                strProfile: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Delete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionProfile,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionProfile,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionProfile_GetProfileXmlData(self: *const T, profileData: ?*?BSTR) HRESULT {
                return @as(*const IMbnConnectionProfile.VTable, @ptrCast(self.vtable)).GetProfileXmlData(@as(*const IMbnConnectionProfile, @ptrCast(self)), profileData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionProfile_UpdateProfile(self: *const T, strProfile: ?[*:0]const u16) HRESULT {
                return @as(*const IMbnConnectionProfile.VTable, @ptrCast(self.vtable)).UpdateProfile(@as(*const IMbnConnectionProfile, @ptrCast(self)), strProfile);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionProfile_Delete(self: *const T) HRESULT {
                return @as(*const IMbnConnectionProfile.VTable, @ptrCast(self.vtable)).Delete(@as(*const IMbnConnectionProfile, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnConnectionProfileEvents_Value = Guid.initString("dcbbbab6-2011-4bbb-aaee-338e368af6fa");
pub const IID_IMbnConnectionProfileEvents = &IID_IMbnConnectionProfileEvents_Value;
pub const IMbnConnectionProfileEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnProfileUpdate: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionProfileEvents,
                newProfile: ?*IMbnConnectionProfile,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionProfileEvents,
                newProfile: ?*IMbnConnectionProfile,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionProfileEvents_OnProfileUpdate(self: *const T, newProfile: ?*IMbnConnectionProfile) HRESULT {
                return @as(*const IMbnConnectionProfileEvents.VTable, @ptrCast(self.vtable)).OnProfileUpdate(@as(*const IMbnConnectionProfileEvents, @ptrCast(self)), newProfile);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnSmsConfiguration_Value = Guid.initString("dcbbbab6-2012-4bbb-aaee-338e368af6fa");
pub const IID_IMbnSmsConfiguration = &IID_IMbnSmsConfiguration_Value;
pub const IMbnSmsConfiguration = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_ServiceCenterAddress: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsConfiguration,
                scAddress: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsConfiguration,
                scAddress: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_ServiceCenterAddress: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsConfiguration,
                scAddress: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsConfiguration,
                scAddress: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_MaxMessageIndex: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsConfiguration,
                index: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsConfiguration,
                index: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_CdmaShortMsgSize: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsConfiguration,
                shortMsgSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsConfiguration,
                shortMsgSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_SmsFormat: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsConfiguration,
                smsFormat: ?*MBN_SMS_FORMAT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsConfiguration,
                smsFormat: ?*MBN_SMS_FORMAT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        put_SmsFormat: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsConfiguration,
                smsFormat: MBN_SMS_FORMAT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsConfiguration,
                smsFormat: MBN_SMS_FORMAT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsConfiguration_get_ServiceCenterAddress(self: *const T, scAddress: ?*?BSTR) HRESULT {
                return @as(*const IMbnSmsConfiguration.VTable, @ptrCast(self.vtable)).get_ServiceCenterAddress(@as(*const IMbnSmsConfiguration, @ptrCast(self)), scAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsConfiguration_put_ServiceCenterAddress(self: *const T, scAddress: ?[*:0]const u16) HRESULT {
                return @as(*const IMbnSmsConfiguration.VTable, @ptrCast(self.vtable)).put_ServiceCenterAddress(@as(*const IMbnSmsConfiguration, @ptrCast(self)), scAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsConfiguration_get_MaxMessageIndex(self: *const T, index: ?*u32) HRESULT {
                return @as(*const IMbnSmsConfiguration.VTable, @ptrCast(self.vtable)).get_MaxMessageIndex(@as(*const IMbnSmsConfiguration, @ptrCast(self)), index);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsConfiguration_get_CdmaShortMsgSize(self: *const T, shortMsgSize: ?*u32) HRESULT {
                return @as(*const IMbnSmsConfiguration.VTable, @ptrCast(self.vtable)).get_CdmaShortMsgSize(@as(*const IMbnSmsConfiguration, @ptrCast(self)), shortMsgSize);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsConfiguration_get_SmsFormat(self: *const T, smsFormat: ?*MBN_SMS_FORMAT) HRESULT {
                return @as(*const IMbnSmsConfiguration.VTable, @ptrCast(self.vtable)).get_SmsFormat(@as(*const IMbnSmsConfiguration, @ptrCast(self)), smsFormat);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsConfiguration_put_SmsFormat(self: *const T, smsFormat: MBN_SMS_FORMAT) HRESULT {
                return @as(*const IMbnSmsConfiguration.VTable, @ptrCast(self.vtable)).put_SmsFormat(@as(*const IMbnSmsConfiguration, @ptrCast(self)), smsFormat);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnSmsReadMsgPdu_Value = Guid.initString("dcbbbab6-2013-4bbb-aaee-338e368af6fa");
pub const IID_IMbnSmsReadMsgPdu = &IID_IMbnSmsReadMsgPdu_Value;
pub const IMbnSmsReadMsgPdu = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Index: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsReadMsgPdu,
                Index: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsReadMsgPdu,
                Index: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Status: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsReadMsgPdu,
                Status: ?*MBN_MSG_STATUS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsReadMsgPdu,
                Status: ?*MBN_MSG_STATUS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PduData: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsReadMsgPdu,
                PduData: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsReadMsgPdu,
                PduData: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Message: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsReadMsgPdu,
                Message: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsReadMsgPdu,
                Message: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsReadMsgPdu_get_Index(self: *const T, Index: ?*u32) HRESULT {
                return @as(*const IMbnSmsReadMsgPdu.VTable, @ptrCast(self.vtable)).get_Index(@as(*const IMbnSmsReadMsgPdu, @ptrCast(self)), Index);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsReadMsgPdu_get_Status(self: *const T, Status: ?*MBN_MSG_STATUS) HRESULT {
                return @as(*const IMbnSmsReadMsgPdu.VTable, @ptrCast(self.vtable)).get_Status(@as(*const IMbnSmsReadMsgPdu, @ptrCast(self)), Status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsReadMsgPdu_get_PduData(self: *const T, PduData: ?*?BSTR) HRESULT {
                return @as(*const IMbnSmsReadMsgPdu.VTable, @ptrCast(self.vtable)).get_PduData(@as(*const IMbnSmsReadMsgPdu, @ptrCast(self)), PduData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsReadMsgPdu_get_Message(self: *const T, Message: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IMbnSmsReadMsgPdu.VTable, @ptrCast(self.vtable)).get_Message(@as(*const IMbnSmsReadMsgPdu, @ptrCast(self)), Message);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnSmsReadMsgTextCdma_Value = Guid.initString("dcbbbab6-2014-4bbb-aaee-338e368af6fa");
pub const IID_IMbnSmsReadMsgTextCdma = &IID_IMbnSmsReadMsgTextCdma_Value;
pub const IMbnSmsReadMsgTextCdma = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Index: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsReadMsgTextCdma,
                Index: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsReadMsgTextCdma,
                Index: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Status: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsReadMsgTextCdma,
                Status: ?*MBN_MSG_STATUS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsReadMsgTextCdma,
                Status: ?*MBN_MSG_STATUS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Address: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsReadMsgTextCdma,
                Address: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsReadMsgTextCdma,
                Address: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Timestamp: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsReadMsgTextCdma,
                Timestamp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsReadMsgTextCdma,
                Timestamp: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_EncodingID: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsReadMsgTextCdma,
                EncodingID: ?*MBN_SMS_CDMA_ENCODING,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsReadMsgTextCdma,
                EncodingID: ?*MBN_SMS_CDMA_ENCODING,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_LanguageID: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsReadMsgTextCdma,
                LanguageID: ?*MBN_SMS_CDMA_LANG,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsReadMsgTextCdma,
                LanguageID: ?*MBN_SMS_CDMA_LANG,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_SizeInCharacters: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsReadMsgTextCdma,
                SizeInCharacters: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsReadMsgTextCdma,
                SizeInCharacters: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_Message: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnSmsReadMsgTextCdma,
                Message: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnSmsReadMsgTextCdma,
                Message: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsReadMsgTextCdma_get_Index(self: *const T, Index: ?*u32) HRESULT {
                return @as(*const IMbnSmsReadMsgTextCdma.VTable, @ptrCast(self.vtable)).get_Index(@as(*const IMbnSmsReadMsgTextCdma, @ptrCast(self)), Index);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsReadMsgTextCdma_get_Status(self: *const T, Status: ?*MBN_MSG_STATUS) HRESULT {
                return @as(*const IMbnSmsReadMsgTextCdma.VTable, @ptrCast(self.vtable)).get_Status(@as(*const IMbnSmsReadMsgTextCdma, @ptrCast(self)), Status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsReadMsgTextCdma_get_Address(self: *const T, Address: ?*?BSTR) HRESULT {
                return @as(*const IMbnSmsReadMsgTextCdma.VTable, @ptrCast(self.vtable)).get_Address(@as(*const IMbnSmsReadMsgTextCdma, @ptrCast(self)), Address);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsReadMsgTextCdma_get_Timestamp(self: *const T, Timestamp: ?*?BSTR) HRESULT {
                return @as(*const IMbnSmsReadMsgTextCdma.VTable, @ptrCast(self.vtable)).get_Timestamp(@as(*const IMbnSmsReadMsgTextCdma, @ptrCast(self)), Timestamp);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsReadMsgTextCdma_get_EncodingID(self: *const T, EncodingID: ?*MBN_SMS_CDMA_ENCODING) HRESULT {
                return @as(*const IMbnSmsReadMsgTextCdma.VTable, @ptrCast(self.vtable)).get_EncodingID(@as(*const IMbnSmsReadMsgTextCdma, @ptrCast(self)), EncodingID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsReadMsgTextCdma_get_LanguageID(self: *const T, LanguageID: ?*MBN_SMS_CDMA_LANG) HRESULT {
                return @as(*const IMbnSmsReadMsgTextCdma.VTable, @ptrCast(self.vtable)).get_LanguageID(@as(*const IMbnSmsReadMsgTextCdma, @ptrCast(self)), LanguageID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsReadMsgTextCdma_get_SizeInCharacters(self: *const T, SizeInCharacters: ?*u32) HRESULT {
                return @as(*const IMbnSmsReadMsgTextCdma.VTable, @ptrCast(self.vtable)).get_SizeInCharacters(@as(*const IMbnSmsReadMsgTextCdma, @ptrCast(self)), SizeInCharacters);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsReadMsgTextCdma_get_Message(self: *const T, Message: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IMbnSmsReadMsgTextCdma.VTable, @ptrCast(self.vtable)).get_Message(@as(*const IMbnSmsReadMsgTextCdma, @ptrCast(self)), Message);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnSms_Value = Guid.initString("dcbbbab6-2015-4bbb-aaee-338e368af6fa");
pub const IID_IMbnSms = &IID_IMbnSms_Value;
pub const IMbnSms = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetSmsConfiguration: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSms,
                smsConfiguration: ?*?*IMbnSmsConfiguration,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSms,
                smsConfiguration: ?*?*IMbnSmsConfiguration,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetSmsConfiguration: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSms,
                smsConfiguration: ?*IMbnSmsConfiguration,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSms,
                smsConfiguration: ?*IMbnSmsConfiguration,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SmsSendPdu: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSms,
                pduData: ?[*:0]const u16,
                size: u8,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSms,
                pduData: ?[*:0]const u16,
                size: u8,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SmsSendCdma: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSms,
                address: ?[*:0]const u16,
                encoding: MBN_SMS_CDMA_ENCODING,
                language: MBN_SMS_CDMA_LANG,
                sizeInCharacters: u32,
                message: ?*SAFEARRAY,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSms,
                address: ?[*:0]const u16,
                encoding: MBN_SMS_CDMA_ENCODING,
                language: MBN_SMS_CDMA_LANG,
                sizeInCharacters: u32,
                message: ?*SAFEARRAY,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SmsSendCdmaPdu: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSms,
                message: ?*SAFEARRAY,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSms,
                message: ?*SAFEARRAY,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SmsRead: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSms,
                smsFilter: ?*MBN_SMS_FILTER,
                smsFormat: MBN_SMS_FORMAT,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSms,
                smsFilter: ?*MBN_SMS_FILTER,
                smsFormat: MBN_SMS_FORMAT,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SmsDelete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSms,
                smsFilter: ?*MBN_SMS_FILTER,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSms,
                smsFilter: ?*MBN_SMS_FILTER,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetSmsStatus: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSms,
                smsStatusInfo: ?*MBN_SMS_STATUS_INFO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSms,
                smsStatusInfo: ?*MBN_SMS_STATUS_INFO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSms_GetSmsConfiguration(self: *const T, smsConfiguration: ?*?*IMbnSmsConfiguration) HRESULT {
                return @as(*const IMbnSms.VTable, @ptrCast(self.vtable)).GetSmsConfiguration(@as(*const IMbnSms, @ptrCast(self)), smsConfiguration);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSms_SetSmsConfiguration(self: *const T, smsConfiguration: ?*IMbnSmsConfiguration, requestID: ?*u32) HRESULT {
                return @as(*const IMbnSms.VTable, @ptrCast(self.vtable)).SetSmsConfiguration(@as(*const IMbnSms, @ptrCast(self)), smsConfiguration, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSms_SmsSendPdu(self: *const T, pduData: ?[*:0]const u16, size: u8, requestID: ?*u32) HRESULT {
                return @as(*const IMbnSms.VTable, @ptrCast(self.vtable)).SmsSendPdu(@as(*const IMbnSms, @ptrCast(self)), pduData, size, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSms_SmsSendCdma(self: *const T, address: ?[*:0]const u16, encoding: MBN_SMS_CDMA_ENCODING, language: MBN_SMS_CDMA_LANG, sizeInCharacters: u32, message: ?*SAFEARRAY, requestID: ?*u32) HRESULT {
                return @as(*const IMbnSms.VTable, @ptrCast(self.vtable)).SmsSendCdma(@as(*const IMbnSms, @ptrCast(self)), address, encoding, language, sizeInCharacters, message, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSms_SmsSendCdmaPdu(self: *const T, message: ?*SAFEARRAY, requestID: ?*u32) HRESULT {
                return @as(*const IMbnSms.VTable, @ptrCast(self.vtable)).SmsSendCdmaPdu(@as(*const IMbnSms, @ptrCast(self)), message, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSms_SmsRead(self: *const T, smsFilter: ?*MBN_SMS_FILTER, smsFormat: MBN_SMS_FORMAT, requestID: ?*u32) HRESULT {
                return @as(*const IMbnSms.VTable, @ptrCast(self.vtable)).SmsRead(@as(*const IMbnSms, @ptrCast(self)), smsFilter, smsFormat, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSms_SmsDelete(self: *const T, smsFilter: ?*MBN_SMS_FILTER, requestID: ?*u32) HRESULT {
                return @as(*const IMbnSms.VTable, @ptrCast(self.vtable)).SmsDelete(@as(*const IMbnSms, @ptrCast(self)), smsFilter, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSms_GetSmsStatus(self: *const T, smsStatusInfo: ?*MBN_SMS_STATUS_INFO) HRESULT {
                return @as(*const IMbnSms.VTable, @ptrCast(self.vtable)).GetSmsStatus(@as(*const IMbnSms, @ptrCast(self)), smsStatusInfo);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnSmsEvents_Value = Guid.initString("dcbbbab6-2016-4bbb-aaee-338e368af6fa");
pub const IID_IMbnSmsEvents = &IID_IMbnSmsEvents_Value;
pub const IMbnSmsEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnSmsConfigurationChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSmsEvents,
                sms: ?*IMbnSms,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSmsEvents,
                sms: ?*IMbnSms,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnSetSmsConfigurationComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSmsEvents,
                sms: ?*IMbnSms,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSmsEvents,
                sms: ?*IMbnSms,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnSmsSendComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSmsEvents,
                sms: ?*IMbnSms,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSmsEvents,
                sms: ?*IMbnSms,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnSmsReadComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSmsEvents,
                sms: ?*IMbnSms,
                smsFormat: MBN_SMS_FORMAT,
                readMsgs: ?*SAFEARRAY,
                moreMsgs: i16,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSmsEvents,
                sms: ?*IMbnSms,
                smsFormat: MBN_SMS_FORMAT,
                readMsgs: ?*SAFEARRAY,
                moreMsgs: i16,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnSmsNewClass0Message: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSmsEvents,
                sms: ?*IMbnSms,
                smsFormat: MBN_SMS_FORMAT,
                readMsgs: ?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSmsEvents,
                sms: ?*IMbnSms,
                smsFormat: MBN_SMS_FORMAT,
                readMsgs: ?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnSmsDeleteComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSmsEvents,
                sms: ?*IMbnSms,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSmsEvents,
                sms: ?*IMbnSms,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnSmsStatusChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnSmsEvents,
                sms: ?*IMbnSms,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnSmsEvents,
                sms: ?*IMbnSms,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsEvents_OnSmsConfigurationChange(self: *const T, sms: ?*IMbnSms) HRESULT {
                return @as(*const IMbnSmsEvents.VTable, @ptrCast(self.vtable)).OnSmsConfigurationChange(@as(*const IMbnSmsEvents, @ptrCast(self)), sms);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsEvents_OnSetSmsConfigurationComplete(self: *const T, sms: ?*IMbnSms, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnSmsEvents.VTable, @ptrCast(self.vtable)).OnSetSmsConfigurationComplete(@as(*const IMbnSmsEvents, @ptrCast(self)), sms, requestID, status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsEvents_OnSmsSendComplete(self: *const T, sms: ?*IMbnSms, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnSmsEvents.VTable, @ptrCast(self.vtable)).OnSmsSendComplete(@as(*const IMbnSmsEvents, @ptrCast(self)), sms, requestID, status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsEvents_OnSmsReadComplete(self: *const T, sms: ?*IMbnSms, smsFormat: MBN_SMS_FORMAT, readMsgs: ?*SAFEARRAY, moreMsgs: i16, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnSmsEvents.VTable, @ptrCast(self.vtable)).OnSmsReadComplete(@as(*const IMbnSmsEvents, @ptrCast(self)), sms, smsFormat, readMsgs, moreMsgs, requestID, status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsEvents_OnSmsNewClass0Message(self: *const T, sms: ?*IMbnSms, smsFormat: MBN_SMS_FORMAT, readMsgs: ?*SAFEARRAY) HRESULT {
                return @as(*const IMbnSmsEvents.VTable, @ptrCast(self.vtable)).OnSmsNewClass0Message(@as(*const IMbnSmsEvents, @ptrCast(self)), sms, smsFormat, readMsgs);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsEvents_OnSmsDeleteComplete(self: *const T, sms: ?*IMbnSms, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnSmsEvents.VTable, @ptrCast(self.vtable)).OnSmsDeleteComplete(@as(*const IMbnSmsEvents, @ptrCast(self)), sms, requestID, status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnSmsEvents_OnSmsStatusChange(self: *const T, sms: ?*IMbnSms) HRESULT {
                return @as(*const IMbnSmsEvents.VTable, @ptrCast(self.vtable)).OnSmsStatusChange(@as(*const IMbnSmsEvents, @ptrCast(self)), sms);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnServiceActivation_Value = Guid.initString("dcbbbab6-2017-4bbb-aaee-338e368af6fa");
pub const IID_IMbnServiceActivation = &IID_IMbnServiceActivation_Value;
pub const IMbnServiceActivation = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Activate: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnServiceActivation,
                vendorSpecificData: ?*SAFEARRAY,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnServiceActivation,
                vendorSpecificData: ?*SAFEARRAY,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnServiceActivation_Activate(self: *const T, vendorSpecificData: ?*SAFEARRAY, requestID: ?*u32) HRESULT {
                return @as(*const IMbnServiceActivation.VTable, @ptrCast(self.vtable)).Activate(@as(*const IMbnServiceActivation, @ptrCast(self)), vendorSpecificData, requestID);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnServiceActivationEvents_Value = Guid.initString("dcbbbab6-2018-4bbb-aaee-338e368af6fa");
pub const IID_IMbnServiceActivationEvents = &IID_IMbnServiceActivationEvents_Value;
pub const IMbnServiceActivationEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnActivationComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnServiceActivationEvents,
                serviceActivation: ?*IMbnServiceActivation,
                vendorSpecificData: ?*SAFEARRAY,
                requestID: u32,
                status: HRESULT,
                networkError: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnServiceActivationEvents,
                serviceActivation: ?*IMbnServiceActivation,
                vendorSpecificData: ?*SAFEARRAY,
                requestID: u32,
                status: HRESULT,
                networkError: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnServiceActivationEvents_OnActivationComplete(self: *const T, serviceActivation: ?*IMbnServiceActivation, vendorSpecificData: ?*SAFEARRAY, requestID: u32, status: HRESULT, networkError: u32) HRESULT {
                return @as(*const IMbnServiceActivationEvents.VTable, @ptrCast(self.vtable)).OnActivationComplete(@as(*const IMbnServiceActivationEvents, @ptrCast(self)), serviceActivation, vendorSpecificData, requestID, status, networkError);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnVendorSpecificOperation_Value = Guid.initString("dcbbbab6-2019-4bbb-aaee-338e368af6fa");
pub const IID_IMbnVendorSpecificOperation = &IID_IMbnVendorSpecificOperation_Value;
pub const IMbnVendorSpecificOperation = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetVendorSpecific: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnVendorSpecificOperation,
                vendorSpecificData: ?*SAFEARRAY,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnVendorSpecificOperation,
                vendorSpecificData: ?*SAFEARRAY,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnVendorSpecificOperation_SetVendorSpecific(self: *const T, vendorSpecificData: ?*SAFEARRAY, requestID: ?*u32) HRESULT {
                return @as(*const IMbnVendorSpecificOperation.VTable, @ptrCast(self.vtable)).SetVendorSpecific(@as(*const IMbnVendorSpecificOperation, @ptrCast(self)), vendorSpecificData, requestID);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnVendorSpecificEvents_Value = Guid.initString("dcbbbab6-201a-4bbb-aaee-338e368af6fa");
pub const IID_IMbnVendorSpecificEvents = &IID_IMbnVendorSpecificEvents_Value;
pub const IMbnVendorSpecificEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnEventNotification: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnVendorSpecificEvents,
                vendorOperation: ?*IMbnVendorSpecificOperation,
                vendorSpecificData: ?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnVendorSpecificEvents,
                vendorOperation: ?*IMbnVendorSpecificOperation,
                vendorSpecificData: ?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnSetVendorSpecificComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnVendorSpecificEvents,
                vendorOperation: ?*IMbnVendorSpecificOperation,
                vendorSpecificData: ?*SAFEARRAY,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnVendorSpecificEvents,
                vendorOperation: ?*IMbnVendorSpecificOperation,
                vendorSpecificData: ?*SAFEARRAY,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnVendorSpecificEvents_OnEventNotification(self: *const T, vendorOperation: ?*IMbnVendorSpecificOperation, vendorSpecificData: ?*SAFEARRAY) HRESULT {
                return @as(*const IMbnVendorSpecificEvents.VTable, @ptrCast(self.vtable)).OnEventNotification(@as(*const IMbnVendorSpecificEvents, @ptrCast(self)), vendorOperation, vendorSpecificData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnVendorSpecificEvents_OnSetVendorSpecificComplete(self: *const T, vendorOperation: ?*IMbnVendorSpecificOperation, vendorSpecificData: ?*SAFEARRAY, requestID: u32) HRESULT {
                return @as(*const IMbnVendorSpecificEvents.VTable, @ptrCast(self.vtable)).OnSetVendorSpecificComplete(@as(*const IMbnVendorSpecificEvents, @ptrCast(self)), vendorOperation, vendorSpecificData, requestID);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnConnectionProfileManagerEvents_Value = Guid.initString("dcbbbab6-201f-4bbb-aaee-338e368af6fa");
pub const IID_IMbnConnectionProfileManagerEvents = &IID_IMbnConnectionProfileManagerEvents_Value;
pub const IMbnConnectionProfileManagerEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnConnectionProfileArrival: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionProfileManagerEvents,
                newConnectionProfile: ?*IMbnConnectionProfile,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionProfileManagerEvents,
                newConnectionProfile: ?*IMbnConnectionProfile,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnConnectionProfileRemoval: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnConnectionProfileManagerEvents,
                oldConnectionProfile: ?*IMbnConnectionProfile,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnConnectionProfileManagerEvents,
                oldConnectionProfile: ?*IMbnConnectionProfile,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionProfileManagerEvents_OnConnectionProfileArrival(self: *const T, newConnectionProfile: ?*IMbnConnectionProfile) HRESULT {
                return @as(*const IMbnConnectionProfileManagerEvents.VTable, @ptrCast(self.vtable)).OnConnectionProfileArrival(@as(*const IMbnConnectionProfileManagerEvents, @ptrCast(self)), newConnectionProfile);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnConnectionProfileManagerEvents_OnConnectionProfileRemoval(self: *const T, oldConnectionProfile: ?*IMbnConnectionProfile) HRESULT {
                return @as(*const IMbnConnectionProfileManagerEvents.VTable, @ptrCast(self.vtable)).OnConnectionProfileRemoval(@as(*const IMbnConnectionProfileManagerEvents, @ptrCast(self)), oldConnectionProfile);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnRadio_Value = Guid.initString("dccccab6-201f-4bbb-aaee-338e368af6fa");
pub const IID_IMbnRadio = &IID_IMbnRadio_Value;
pub const IMbnRadio = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_SoftwareRadioState: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnRadio,
                SoftwareRadioState: ?*MBN_RADIO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnRadio,
                SoftwareRadioState: ?*MBN_RADIO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_HardwareRadioState: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnRadio,
                HardwareRadioState: ?*MBN_RADIO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnRadio,
                HardwareRadioState: ?*MBN_RADIO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetSoftwareRadioState: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRadio,
                radioState: MBN_RADIO,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRadio,
                radioState: MBN_RADIO,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRadio_get_SoftwareRadioState(self: *const T, SoftwareRadioState: ?*MBN_RADIO) HRESULT {
                return @as(*const IMbnRadio.VTable, @ptrCast(self.vtable)).get_SoftwareRadioState(@as(*const IMbnRadio, @ptrCast(self)), SoftwareRadioState);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRadio_get_HardwareRadioState(self: *const T, HardwareRadioState: ?*MBN_RADIO) HRESULT {
                return @as(*const IMbnRadio.VTable, @ptrCast(self.vtable)).get_HardwareRadioState(@as(*const IMbnRadio, @ptrCast(self)), HardwareRadioState);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRadio_SetSoftwareRadioState(self: *const T, radioState: MBN_RADIO, requestID: ?*u32) HRESULT {
                return @as(*const IMbnRadio.VTable, @ptrCast(self.vtable)).SetSoftwareRadioState(@as(*const IMbnRadio, @ptrCast(self)), radioState, requestID);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnRadioEvents_Value = Guid.initString("dcdddab6-201f-4bbb-aaee-338e368af6fa");
pub const IID_IMbnRadioEvents = &IID_IMbnRadioEvents_Value;
pub const IMbnRadioEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnRadioStateChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRadioEvents,
                newInterface: ?*IMbnRadio,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRadioEvents,
                newInterface: ?*IMbnRadio,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnSetSoftwareRadioStateComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnRadioEvents,
                newInterface: ?*IMbnRadio,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnRadioEvents,
                newInterface: ?*IMbnRadio,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRadioEvents_OnRadioStateChange(self: *const T, newInterface: ?*IMbnRadio) HRESULT {
                return @as(*const IMbnRadioEvents.VTable, @ptrCast(self.vtable)).OnRadioStateChange(@as(*const IMbnRadioEvents, @ptrCast(self)), newInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnRadioEvents_OnSetSoftwareRadioStateComplete(self: *const T, newInterface: ?*IMbnRadio, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnRadioEvents.VTable, @ptrCast(self.vtable)).OnSetSoftwareRadioStateComplete(@as(*const IMbnRadioEvents, @ptrCast(self)), newInterface, requestID, status);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IMbnMultiCarrier_Value = Guid.initString("dcbbbab6-2020-4bbb-aaee-338e368af6fa");
pub const IID_IMbnMultiCarrier = &IID_IMbnMultiCarrier_Value;
pub const IMbnMultiCarrier = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetHomeProvider: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnMultiCarrier,
                homeProvider: ?*MBN_PROVIDER2,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnMultiCarrier,
                homeProvider: ?*MBN_PROVIDER2,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPreferredProviders: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnMultiCarrier,
                preferredMulticarrierProviders: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnMultiCarrier,
                preferredMulticarrierProviders: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetVisibleProviders: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnMultiCarrier,
                age: ?*u32,
                visibleProviders: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnMultiCarrier,
                age: ?*u32,
                visibleProviders: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetSupportedCellularClasses: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnMultiCarrier,
                cellularClasses: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnMultiCarrier,
                cellularClasses: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetCurrentCellularClass: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnMultiCarrier,
                currentCellularClass: ?*MBN_CELLULAR_CLASS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnMultiCarrier,
                currentCellularClass: ?*MBN_CELLULAR_CLASS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ScanNetwork: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnMultiCarrier,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnMultiCarrier,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnMultiCarrier_SetHomeProvider(self: *const T, homeProvider: ?*MBN_PROVIDER2, requestID: ?*u32) HRESULT {
                return @as(*const IMbnMultiCarrier.VTable, @ptrCast(self.vtable)).SetHomeProvider(@as(*const IMbnMultiCarrier, @ptrCast(self)), homeProvider, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnMultiCarrier_GetPreferredProviders(self: *const T, preferredMulticarrierProviders: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IMbnMultiCarrier.VTable, @ptrCast(self.vtable)).GetPreferredProviders(@as(*const IMbnMultiCarrier, @ptrCast(self)), preferredMulticarrierProviders);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnMultiCarrier_GetVisibleProviders(self: *const T, age: ?*u32, visibleProviders: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IMbnMultiCarrier.VTable, @ptrCast(self.vtable)).GetVisibleProviders(@as(*const IMbnMultiCarrier, @ptrCast(self)), age, visibleProviders);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnMultiCarrier_GetSupportedCellularClasses(self: *const T, cellularClasses: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IMbnMultiCarrier.VTable, @ptrCast(self.vtable)).GetSupportedCellularClasses(@as(*const IMbnMultiCarrier, @ptrCast(self)), cellularClasses);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnMultiCarrier_GetCurrentCellularClass(self: *const T, currentCellularClass: ?*MBN_CELLULAR_CLASS) HRESULT {
                return @as(*const IMbnMultiCarrier.VTable, @ptrCast(self.vtable)).GetCurrentCellularClass(@as(*const IMbnMultiCarrier, @ptrCast(self)), currentCellularClass);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnMultiCarrier_ScanNetwork(self: *const T, requestID: ?*u32) HRESULT {
                return @as(*const IMbnMultiCarrier.VTable, @ptrCast(self.vtable)).ScanNetwork(@as(*const IMbnMultiCarrier, @ptrCast(self)), requestID);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IMbnMultiCarrierEvents_Value = Guid.initString("dcdddab6-2021-4bbb-aaee-338e368af6fa");
pub const IID_IMbnMultiCarrierEvents = &IID_IMbnMultiCarrierEvents_Value;
pub const IMbnMultiCarrierEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnSetHomeProviderComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnMultiCarrierEvents,
                mbnInterface: ?*IMbnMultiCarrier,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnMultiCarrierEvents,
                mbnInterface: ?*IMbnMultiCarrier,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnCurrentCellularClassChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnMultiCarrierEvents,
                mbnInterface: ?*IMbnMultiCarrier,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnMultiCarrierEvents,
                mbnInterface: ?*IMbnMultiCarrier,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnPreferredProvidersChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnMultiCarrierEvents,
                mbnInterface: ?*IMbnMultiCarrier,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnMultiCarrierEvents,
                mbnInterface: ?*IMbnMultiCarrier,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnScanNetworkComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnMultiCarrierEvents,
                mbnInterface: ?*IMbnMultiCarrier,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnMultiCarrierEvents,
                mbnInterface: ?*IMbnMultiCarrier,
                requestID: u32,
                status: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnInterfaceCapabilityChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnMultiCarrierEvents,
                mbnInterface: ?*IMbnMultiCarrier,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnMultiCarrierEvents,
                mbnInterface: ?*IMbnMultiCarrier,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnMultiCarrierEvents_OnSetHomeProviderComplete(self: *const T, mbnInterface: ?*IMbnMultiCarrier, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnMultiCarrierEvents.VTable, @ptrCast(self.vtable)).OnSetHomeProviderComplete(@as(*const IMbnMultiCarrierEvents, @ptrCast(self)), mbnInterface, requestID, status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnMultiCarrierEvents_OnCurrentCellularClassChange(self: *const T, mbnInterface: ?*IMbnMultiCarrier) HRESULT {
                return @as(*const IMbnMultiCarrierEvents.VTable, @ptrCast(self.vtable)).OnCurrentCellularClassChange(@as(*const IMbnMultiCarrierEvents, @ptrCast(self)), mbnInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnMultiCarrierEvents_OnPreferredProvidersChange(self: *const T, mbnInterface: ?*IMbnMultiCarrier) HRESULT {
                return @as(*const IMbnMultiCarrierEvents.VTable, @ptrCast(self.vtable)).OnPreferredProvidersChange(@as(*const IMbnMultiCarrierEvents, @ptrCast(self)), mbnInterface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnMultiCarrierEvents_OnScanNetworkComplete(self: *const T, mbnInterface: ?*IMbnMultiCarrier, requestID: u32, status: HRESULT) HRESULT {
                return @as(*const IMbnMultiCarrierEvents.VTable, @ptrCast(self.vtable)).OnScanNetworkComplete(@as(*const IMbnMultiCarrierEvents, @ptrCast(self)), mbnInterface, requestID, status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnMultiCarrierEvents_OnInterfaceCapabilityChange(self: *const T, mbnInterface: ?*IMbnMultiCarrier) HRESULT {
                return @as(*const IMbnMultiCarrierEvents.VTable, @ptrCast(self.vtable)).OnInterfaceCapabilityChange(@as(*const IMbnMultiCarrierEvents, @ptrCast(self)), mbnInterface);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IMbnDeviceServiceStateEvents_Value = Guid.initString("5d3ff196-89ee-49d8-8b60-33ffddffc58d");
pub const IID_IMbnDeviceServiceStateEvents = &IID_IMbnDeviceServiceStateEvents_Value;
pub const IMbnDeviceServiceStateEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnSessionsStateChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceServiceStateEvents,
                interfaceID: ?BSTR,
                stateChange: MBN_DEVICE_SERVICE_SESSIONS_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceServiceStateEvents,
                interfaceID: ?BSTR,
                stateChange: MBN_DEVICE_SERVICE_SESSIONS_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServiceStateEvents_OnSessionsStateChange(self: *const T, interfaceID: ?BSTR, stateChange: MBN_DEVICE_SERVICE_SESSIONS_STATE) HRESULT {
                return @as(*const IMbnDeviceServiceStateEvents.VTable, @ptrCast(self.vtable)).OnSessionsStateChange(@as(*const IMbnDeviceServiceStateEvents, @ptrCast(self)), interfaceID, stateChange);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IMbnDeviceServicesManager_Value = Guid.initString("20a26258-6811-4478-ac1d-13324e45e41c");
pub const IID_IMbnDeviceServicesManager = &IID_IMbnDeviceServicesManager_Value;
pub const IMbnDeviceServicesManager = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetDeviceServicesContext: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceServicesManager,
                networkInterfaceID: ?BSTR,
                mbnDevicesContext: ?*?*IMbnDeviceServicesContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceServicesManager,
                networkInterfaceID: ?BSTR,
                mbnDevicesContext: ?*?*IMbnDeviceServicesContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServicesManager_GetDeviceServicesContext(self: *const T, networkInterfaceID: ?BSTR, mbnDevicesContext: ?*?*IMbnDeviceServicesContext) HRESULT {
                return @as(*const IMbnDeviceServicesManager.VTable, @ptrCast(self.vtable)).GetDeviceServicesContext(@as(*const IMbnDeviceServicesManager, @ptrCast(self)), networkInterfaceID, mbnDevicesContext);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IMbnDeviceServicesContext_Value = Guid.initString("fc5ac347-1592-4068-80bb-6a57580150d8");
pub const IID_IMbnDeviceServicesContext = &IID_IMbnDeviceServicesContext_Value;
pub const IMbnDeviceServicesContext = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        EnumerateDeviceServices: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceServicesContext,
                deviceServices: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceServicesContext,
                deviceServices: ?*?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDeviceService: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceServicesContext,
                deviceServiceID: ?BSTR,
                mbnDeviceService: ?*?*IMbnDeviceService,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceServicesContext,
                deviceServiceID: ?BSTR,
                mbnDeviceService: ?*?*IMbnDeviceService,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_MaxCommandSize: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnDeviceServicesContext,
                maxCommandSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnDeviceServicesContext,
                maxCommandSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_MaxDataSize: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnDeviceServicesContext,
                maxDataSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnDeviceServicesContext,
                maxDataSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServicesContext_EnumerateDeviceServices(self: *const T, deviceServices: ?*?*SAFEARRAY) HRESULT {
                return @as(*const IMbnDeviceServicesContext.VTable, @ptrCast(self.vtable)).EnumerateDeviceServices(@as(*const IMbnDeviceServicesContext, @ptrCast(self)), deviceServices);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServicesContext_GetDeviceService(self: *const T, deviceServiceID: ?BSTR, mbnDeviceService: ?*?*IMbnDeviceService) HRESULT {
                return @as(*const IMbnDeviceServicesContext.VTable, @ptrCast(self.vtable)).GetDeviceService(@as(*const IMbnDeviceServicesContext, @ptrCast(self)), deviceServiceID, mbnDeviceService);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServicesContext_get_MaxCommandSize(self: *const T, maxCommandSize: ?*u32) HRESULT {
                return @as(*const IMbnDeviceServicesContext.VTable, @ptrCast(self.vtable)).get_MaxCommandSize(@as(*const IMbnDeviceServicesContext, @ptrCast(self)), maxCommandSize);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServicesContext_get_MaxDataSize(self: *const T, maxDataSize: ?*u32) HRESULT {
                return @as(*const IMbnDeviceServicesContext.VTable, @ptrCast(self.vtable)).get_MaxDataSize(@as(*const IMbnDeviceServicesContext, @ptrCast(self)), maxDataSize);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IMbnDeviceServicesEvents_Value = Guid.initString("0a900c19-6824-4e97-b76e-cf239d0ca642");
pub const IID_IMbnDeviceServicesEvents = &IID_IMbnDeviceServicesEvents_Value;
pub const IMbnDeviceServicesEvents = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnQuerySupportedCommandsComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                commandIDList: ?*SAFEARRAY,
                status: HRESULT,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                commandIDList: ?*SAFEARRAY,
                status: HRESULT,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnOpenCommandSessionComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                status: HRESULT,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                status: HRESULT,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnCloseCommandSessionComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                status: HRESULT,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                status: HRESULT,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnSetCommandComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                responseID: u32,
                deviceServiceData: ?*SAFEARRAY,
                status: HRESULT,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                responseID: u32,
                deviceServiceData: ?*SAFEARRAY,
                status: HRESULT,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnQueryCommandComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                responseID: u32,
                deviceServiceData: ?*SAFEARRAY,
                status: HRESULT,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                responseID: u32,
                deviceServiceData: ?*SAFEARRAY,
                status: HRESULT,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnEventNotification: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                eventID: u32,
                deviceServiceData: ?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                eventID: u32,
                deviceServiceData: ?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnOpenDataSessionComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                status: HRESULT,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                status: HRESULT,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnCloseDataSessionComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                status: HRESULT,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                status: HRESULT,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnWriteDataComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                status: HRESULT,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                status: HRESULT,
                requestID: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnReadData: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                deviceServiceData: ?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceServicesEvents,
                deviceService: ?*IMbnDeviceService,
                deviceServiceData: ?*SAFEARRAY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnInterfaceStateChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceServicesEvents,
                interfaceID: ?BSTR,
                stateChange: MBN_DEVICE_SERVICES_INTERFACE_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceServicesEvents,
                interfaceID: ?BSTR,
                stateChange: MBN_DEVICE_SERVICES_INTERFACE_STATE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServicesEvents_OnQuerySupportedCommandsComplete(self: *const T, deviceService: ?*IMbnDeviceService, commandIDList: ?*SAFEARRAY, status: HRESULT, requestID: u32) HRESULT {
                return @as(*const IMbnDeviceServicesEvents.VTable, @ptrCast(self.vtable)).OnQuerySupportedCommandsComplete(@as(*const IMbnDeviceServicesEvents, @ptrCast(self)), deviceService, commandIDList, status, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServicesEvents_OnOpenCommandSessionComplete(self: *const T, deviceService: ?*IMbnDeviceService, status: HRESULT, requestID: u32) HRESULT {
                return @as(*const IMbnDeviceServicesEvents.VTable, @ptrCast(self.vtable)).OnOpenCommandSessionComplete(@as(*const IMbnDeviceServicesEvents, @ptrCast(self)), deviceService, status, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServicesEvents_OnCloseCommandSessionComplete(self: *const T, deviceService: ?*IMbnDeviceService, status: HRESULT, requestID: u32) HRESULT {
                return @as(*const IMbnDeviceServicesEvents.VTable, @ptrCast(self.vtable)).OnCloseCommandSessionComplete(@as(*const IMbnDeviceServicesEvents, @ptrCast(self)), deviceService, status, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServicesEvents_OnSetCommandComplete(self: *const T, deviceService: ?*IMbnDeviceService, responseID: u32, deviceServiceData: ?*SAFEARRAY, status: HRESULT, requestID: u32) HRESULT {
                return @as(*const IMbnDeviceServicesEvents.VTable, @ptrCast(self.vtable)).OnSetCommandComplete(@as(*const IMbnDeviceServicesEvents, @ptrCast(self)), deviceService, responseID, deviceServiceData, status, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServicesEvents_OnQueryCommandComplete(self: *const T, deviceService: ?*IMbnDeviceService, responseID: u32, deviceServiceData: ?*SAFEARRAY, status: HRESULT, requestID: u32) HRESULT {
                return @as(*const IMbnDeviceServicesEvents.VTable, @ptrCast(self.vtable)).OnQueryCommandComplete(@as(*const IMbnDeviceServicesEvents, @ptrCast(self)), deviceService, responseID, deviceServiceData, status, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServicesEvents_OnEventNotification(self: *const T, deviceService: ?*IMbnDeviceService, eventID: u32, deviceServiceData: ?*SAFEARRAY) HRESULT {
                return @as(*const IMbnDeviceServicesEvents.VTable, @ptrCast(self.vtable)).OnEventNotification(@as(*const IMbnDeviceServicesEvents, @ptrCast(self)), deviceService, eventID, deviceServiceData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServicesEvents_OnOpenDataSessionComplete(self: *const T, deviceService: ?*IMbnDeviceService, status: HRESULT, requestID: u32) HRESULT {
                return @as(*const IMbnDeviceServicesEvents.VTable, @ptrCast(self.vtable)).OnOpenDataSessionComplete(@as(*const IMbnDeviceServicesEvents, @ptrCast(self)), deviceService, status, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServicesEvents_OnCloseDataSessionComplete(self: *const T, deviceService: ?*IMbnDeviceService, status: HRESULT, requestID: u32) HRESULT {
                return @as(*const IMbnDeviceServicesEvents.VTable, @ptrCast(self.vtable)).OnCloseDataSessionComplete(@as(*const IMbnDeviceServicesEvents, @ptrCast(self)), deviceService, status, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServicesEvents_OnWriteDataComplete(self: *const T, deviceService: ?*IMbnDeviceService, status: HRESULT, requestID: u32) HRESULT {
                return @as(*const IMbnDeviceServicesEvents.VTable, @ptrCast(self.vtable)).OnWriteDataComplete(@as(*const IMbnDeviceServicesEvents, @ptrCast(self)), deviceService, status, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServicesEvents_OnReadData(self: *const T, deviceService: ?*IMbnDeviceService, deviceServiceData: ?*SAFEARRAY) HRESULT {
                return @as(*const IMbnDeviceServicesEvents.VTable, @ptrCast(self.vtable)).OnReadData(@as(*const IMbnDeviceServicesEvents, @ptrCast(self)), deviceService, deviceServiceData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceServicesEvents_OnInterfaceStateChange(self: *const T, interfaceID: ?BSTR, stateChange: MBN_DEVICE_SERVICES_INTERFACE_STATE) HRESULT {
                return @as(*const IMbnDeviceServicesEvents.VTable, @ptrCast(self.vtable)).OnInterfaceStateChange(@as(*const IMbnDeviceServicesEvents, @ptrCast(self)), interfaceID, stateChange);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IMbnDeviceService_Value = Guid.initString("b3bb9a71-dc70-4be9-a4da-7886ae8b191b");
pub const IID_IMbnDeviceService = &IID_IMbnDeviceService_Value;
pub const IMbnDeviceService = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        QuerySupportedCommands: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceService,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceService,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenCommandSession: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceService,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceService,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CloseCommandSession: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceService,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceService,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCommand: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceService,
                commandID: u32,
                deviceServiceData: ?*SAFEARRAY,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceService,
                commandID: u32,
                deviceServiceData: ?*SAFEARRAY,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        QueryCommand: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceService,
                commandID: u32,
                deviceServiceData: ?*SAFEARRAY,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceService,
                commandID: u32,
                deviceServiceData: ?*SAFEARRAY,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OpenDataSession: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceService,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceService,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CloseDataSession: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceService,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceService,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        WriteData: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnDeviceService,
                deviceServiceData: ?*SAFEARRAY,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnDeviceService,
                deviceServiceData: ?*SAFEARRAY,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_InterfaceID: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnDeviceService,
                InterfaceID: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnDeviceService,
                InterfaceID: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_DeviceServiceID: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnDeviceService,
                DeviceServiceID: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnDeviceService,
                DeviceServiceID: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsCommandSessionOpen: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnDeviceService,
                value: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnDeviceService,
                value: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_IsDataSessionOpen: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnDeviceService,
                value: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnDeviceService,
                value: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceService_QuerySupportedCommands(self: *const T, requestID: ?*u32) HRESULT {
                return @as(*const IMbnDeviceService.VTable, @ptrCast(self.vtable)).QuerySupportedCommands(@as(*const IMbnDeviceService, @ptrCast(self)), requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceService_OpenCommandSession(self: *const T, requestID: ?*u32) HRESULT {
                return @as(*const IMbnDeviceService.VTable, @ptrCast(self.vtable)).OpenCommandSession(@as(*const IMbnDeviceService, @ptrCast(self)), requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceService_CloseCommandSession(self: *const T, requestID: ?*u32) HRESULT {
                return @as(*const IMbnDeviceService.VTable, @ptrCast(self.vtable)).CloseCommandSession(@as(*const IMbnDeviceService, @ptrCast(self)), requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceService_SetCommand(self: *const T, commandID: u32, deviceServiceData: ?*SAFEARRAY, requestID: ?*u32) HRESULT {
                return @as(*const IMbnDeviceService.VTable, @ptrCast(self.vtable)).SetCommand(@as(*const IMbnDeviceService, @ptrCast(self)), commandID, deviceServiceData, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceService_QueryCommand(self: *const T, commandID: u32, deviceServiceData: ?*SAFEARRAY, requestID: ?*u32) HRESULT {
                return @as(*const IMbnDeviceService.VTable, @ptrCast(self.vtable)).QueryCommand(@as(*const IMbnDeviceService, @ptrCast(self)), commandID, deviceServiceData, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceService_OpenDataSession(self: *const T, requestID: ?*u32) HRESULT {
                return @as(*const IMbnDeviceService.VTable, @ptrCast(self.vtable)).OpenDataSession(@as(*const IMbnDeviceService, @ptrCast(self)), requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceService_CloseDataSession(self: *const T, requestID: ?*u32) HRESULT {
                return @as(*const IMbnDeviceService.VTable, @ptrCast(self.vtable)).CloseDataSession(@as(*const IMbnDeviceService, @ptrCast(self)), requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceService_WriteData(self: *const T, deviceServiceData: ?*SAFEARRAY, requestID: ?*u32) HRESULT {
                return @as(*const IMbnDeviceService.VTable, @ptrCast(self.vtable)).WriteData(@as(*const IMbnDeviceService, @ptrCast(self)), deviceServiceData, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceService_get_InterfaceID(self: *const T, InterfaceID: ?*?BSTR) HRESULT {
                return @as(*const IMbnDeviceService.VTable, @ptrCast(self.vtable)).get_InterfaceID(@as(*const IMbnDeviceService, @ptrCast(self)), InterfaceID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceService_get_DeviceServiceID(self: *const T, DeviceServiceID: ?*?BSTR) HRESULT {
                return @as(*const IMbnDeviceService.VTable, @ptrCast(self.vtable)).get_DeviceServiceID(@as(*const IMbnDeviceService, @ptrCast(self)), DeviceServiceID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceService_get_IsCommandSessionOpen(self: *const T, value: ?*BOOL) HRESULT {
                return @as(*const IMbnDeviceService.VTable, @ptrCast(self.vtable)).get_IsCommandSessionOpen(@as(*const IMbnDeviceService, @ptrCast(self)), value);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnDeviceService_get_IsDataSessionOpen(self: *const T, value: ?*BOOL) HRESULT {
                return @as(*const IMbnDeviceService.VTable, @ptrCast(self.vtable)).get_IsDataSessionOpen(@as(*const IMbnDeviceService, @ptrCast(self)), value);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const __mbnapi_ReferenceRemainingTypes__ = extern struct {
    bandClass: MBN_BAND_CLASS,
    contextConstants: MBN_CONTEXT_CONSTANTS,
    ctrlCaps: MBN_CTRL_CAPS,
    dataClass: MBN_DATA_CLASS,
    interfaceCapsConstants: MBN_INTERFACE_CAPS_CONSTANTS,
    pinConstants: MBN_PIN_CONSTANTS,
    providerConstants: MBN_PROVIDER_CONSTANTS,
    providerState: MBN_PROVIDER_STATE,
    registrationConstants: MBN_REGISTRATION_CONSTANTS,
    signalConstants: MBN_SIGNAL_CONSTANTS,
    smsCaps: MBN_SMS_CAPS,
    smsConstants: WWAEXT_SMS_CONSTANTS,
    wwaextSmsConstants: WWAEXT_SMS_CONSTANTS,
    smsStatusFlag: MBN_SMS_STATUS_FLAG,
};

pub const __DummyPinType__ = extern struct {
    pinType: u32,
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IMbnPin_Value = Guid.initString("dcbbbab6-2007-4bbb-aaee-338e368af6fa");
pub const IID_IMbnPin = &IID_IMbnPin_Value;
pub const IMbnPin = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PinType: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnPin,
                PinType: ?*MBN_PIN_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnPin,
                PinType: ?*MBN_PIN_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PinFormat: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnPin,
                PinFormat: ?*MBN_PIN_FORMAT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnPin,
                PinFormat: ?*MBN_PIN_FORMAT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PinLengthMin: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnPin,
                PinLengthMin: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnPin,
                PinLengthMin: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PinLengthMax: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnPin,
                PinLengthMax: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnPin,
                PinLengthMax: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        // TODO: this function has a "SpecialName", should Zig do anything with this?
        get_PinMode: switch (@import("builtin").zig_backend) {
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            .stage1 => fn (
                self: *const IMbnPin,
                PinMode: ?*MBN_PIN_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            // TODO: this function has a "SpecialName", should Zig do anything with this?
            else => *const fn (
                self: *const IMbnPin,
                PinMode: ?*MBN_PIN_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Enable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnPin,
                pin: ?[*:0]const u16,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnPin,
                pin: ?[*:0]const u16,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Disable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnPin,
                pin: ?[*:0]const u16,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnPin,
                pin: ?[*:0]const u16,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Enter: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnPin,
                pin: ?[*:0]const u16,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnPin,
                pin: ?[*:0]const u16,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Change: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnPin,
                pin: ?[*:0]const u16,
                newPin: ?[*:0]const u16,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnPin,
                pin: ?[*:0]const u16,
                newPin: ?[*:0]const u16,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Unblock: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnPin,
                puk: ?[*:0]const u16,
                newPin: ?[*:0]const u16,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnPin,
                puk: ?[*:0]const u16,
                newPin: ?[*:0]const u16,
                requestID: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPinManager: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMbnPin,
                pinManager: ?*?*IMbnPinManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMbnPin,
                pinManager: ?*?*IMbnPinManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPin_get_PinType(self: *const T, PinType: ?*MBN_PIN_TYPE) HRESULT {
                return @as(*const IMbnPin.VTable, @ptrCast(self.vtable)).get_PinType(@as(*const IMbnPin, @ptrCast(self)), PinType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPin_get_PinFormat(self: *const T, PinFormat: ?*MBN_PIN_FORMAT) HRESULT {
                return @as(*const IMbnPin.VTable, @ptrCast(self.vtable)).get_PinFormat(@as(*const IMbnPin, @ptrCast(self)), PinFormat);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPin_get_PinLengthMin(self: *const T, PinLengthMin: ?*u32) HRESULT {
                return @as(*const IMbnPin.VTable, @ptrCast(self.vtable)).get_PinLengthMin(@as(*const IMbnPin, @ptrCast(self)), PinLengthMin);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPin_get_PinLengthMax(self: *const T, PinLengthMax: ?*u32) HRESULT {
                return @as(*const IMbnPin.VTable, @ptrCast(self.vtable)).get_PinLengthMax(@as(*const IMbnPin, @ptrCast(self)), PinLengthMax);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPin_get_PinMode(self: *const T, PinMode: ?*MBN_PIN_MODE) HRESULT {
                return @as(*const IMbnPin.VTable, @ptrCast(self.vtable)).get_PinMode(@as(*const IMbnPin, @ptrCast(self)), PinMode);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPin_Enable(self: *const T, pin: ?[*:0]const u16, requestID: ?*u32) HRESULT {
                return @as(*const IMbnPin.VTable, @ptrCast(self.vtable)).Enable(@as(*const IMbnPin, @ptrCast(self)), pin, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPin_Disable(self: *const T, pin: ?[*:0]const u16, requestID: ?*u32) HRESULT {
                return @as(*const IMbnPin.VTable, @ptrCast(self.vtable)).Disable(@as(*const IMbnPin, @ptrCast(self)), pin, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPin_Enter(self: *const T, pin: ?[*:0]const u16, requestID: ?*u32) HRESULT {
                return @as(*const IMbnPin.VTable, @ptrCast(self.vtable)).Enter(@as(*const IMbnPin, @ptrCast(self)), pin, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPin_Change(self: *const T, pin: ?[*:0]const u16, newPin: ?[*:0]const u16, requestID: ?*u32) HRESULT {
                return @as(*const IMbnPin.VTable, @ptrCast(self.vtable)).Change(@as(*const IMbnPin, @ptrCast(self)), pin, newPin, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPin_Unblock(self: *const T, puk: ?[*:0]const u16, newPin: ?[*:0]const u16, requestID: ?*u32) HRESULT {
                return @as(*const IMbnPin.VTable, @ptrCast(self.vtable)).Unblock(@as(*const IMbnPin, @ptrCast(self)), puk, newPin, requestID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMbnPin_GetPinManager(self: *const T, pinManager: ?*?*IMbnPinManager) HRESULT {
                return @as(*const IMbnPin.VTable, @ptrCast(self.vtable)).GetPinManager(@as(*const IMbnPin, @ptrCast(self)), pinManager);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

//--------------------------------------------------------------------------------
// Section: Functions (0)
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (8)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const BSTR = @import("../foundation.zig").BSTR;
const HRESULT = @import("../foundation.zig").HRESULT;
const IDispatch = @import("../system/com.zig").IDispatch;
const IUnknown = @import("../system/com.zig").IUnknown;
const PWSTR = @import("../foundation.zig").PWSTR;
const SAFEARRAY = @import("../system/com.zig").SAFEARRAY;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
