//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (16)
//--------------------------------------------------------------------------------
pub const DMO_E_INVALIDSTREAMINDEX = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147220991));
pub const DMO_E_INVALIDTYPE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147220990));
pub const DMO_E_TYPE_NOT_SET = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147220989));
pub const DMO_E_NOTACCEPTING = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147220988));
pub const DMO_E_TYPE_NOT_ACCEPTED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147220987));
pub const DMO_E_NO_MORE_ITEMS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2147220986));
pub const DMOCATEGORY_AUDIO_DECODER = Guid.initString("57f2db8b-e6bb-4513-9d43-dcd2a6593125");
pub const DMOCATEGORY_AUDIO_ENCODER = Guid.initString("33d9a761-90c8-11d0-bd43-00a0c911ce86");
pub const DMOCATEGORY_VIDEO_DECODER = Guid.initString("4a69b442-28be-4991-969c-b500adf5d8a8");
pub const DMOCATEGORY_VIDEO_ENCODER = Guid.initString("33d9a760-90c8-11d0-bd43-00a0c911ce86");
pub const DMOCATEGORY_AUDIO_EFFECT = Guid.initString("f3602b3f-0592-48df-a4cd-674721e7ebeb");
pub const DMOCATEGORY_VIDEO_EFFECT = Guid.initString("d990ee14-776c-4723-be46-3da2f56f10b9");
pub const DMOCATEGORY_AUDIO_CAPTURE_EFFECT = Guid.initString("f665aaba-3e09-4920-aa5f-219811148f09");
pub const DMOCATEGORY_ACOUSTIC_ECHO_CANCEL = Guid.initString("bf963d80-c559-11d0-8a2b-00a0c9255ac1");
pub const DMOCATEGORY_AUDIO_NOISE_SUPPRESS = Guid.initString("e07f903f-62fd-4e60-8cdd-dea7236665b5");
pub const DMOCATEGORY_AGC = Guid.initString("e88c9ba0-c557-11d0-8a2b-00a0c9255ac1");

//--------------------------------------------------------------------------------
// Section: Types (21)
//--------------------------------------------------------------------------------
pub const DMO_MEDIA_TYPE = extern struct {
    majortype: Guid,
    subtype: Guid,
    bFixedSizeSamples: BOOL,
    bTemporalCompression: BOOL,
    lSampleSize: u32,
    formattype: Guid,
    pUnk: ?*IUnknown,
    cbFormat: u32,
    pbFormat: ?*u8,
};

pub const _DMO_INPUT_DATA_BUFFER_FLAGS = enum(i32) {
    SYNCPOINT = 1,
    TIME = 2,
    TIMELENGTH = 4,
    DISCONTINUITY = 8,
};
pub const DMO_INPUT_DATA_BUFFERF_SYNCPOINT = _DMO_INPUT_DATA_BUFFER_FLAGS.SYNCPOINT;
pub const DMO_INPUT_DATA_BUFFERF_TIME = _DMO_INPUT_DATA_BUFFER_FLAGS.TIME;
pub const DMO_INPUT_DATA_BUFFERF_TIMELENGTH = _DMO_INPUT_DATA_BUFFER_FLAGS.TIMELENGTH;
pub const DMO_INPUT_DATA_BUFFERF_DISCONTINUITY = _DMO_INPUT_DATA_BUFFER_FLAGS.DISCONTINUITY;

pub const _DMO_OUTPUT_DATA_BUFFER_FLAGS = enum(i32) {
    SYNCPOINT = 1,
    TIME = 2,
    TIMELENGTH = 4,
    DISCONTINUITY = 8,
    INCOMPLETE = 16777216,
};
pub const DMO_OUTPUT_DATA_BUFFERF_SYNCPOINT = _DMO_OUTPUT_DATA_BUFFER_FLAGS.SYNCPOINT;
pub const DMO_OUTPUT_DATA_BUFFERF_TIME = _DMO_OUTPUT_DATA_BUFFER_FLAGS.TIME;
pub const DMO_OUTPUT_DATA_BUFFERF_TIMELENGTH = _DMO_OUTPUT_DATA_BUFFER_FLAGS.TIMELENGTH;
pub const DMO_OUTPUT_DATA_BUFFERF_DISCONTINUITY = _DMO_OUTPUT_DATA_BUFFER_FLAGS.DISCONTINUITY;
pub const DMO_OUTPUT_DATA_BUFFERF_INCOMPLETE = _DMO_OUTPUT_DATA_BUFFER_FLAGS.INCOMPLETE;

pub const _DMO_INPUT_STATUS_FLAGS = enum(i32) {
    A = 1,
};
pub const DMO_INPUT_STATUSF_ACCEPT_DATA = _DMO_INPUT_STATUS_FLAGS.A;

pub const _DMO_INPUT_STREAM_INFO_FLAGS = enum(i32) {
    WHOLE_SAMPLES = 1,
    SINGLE_SAMPLE_PER_BUFFER = 2,
    FIXED_SAMPLE_SIZE = 4,
    HOLDS_BUFFERS = 8,
};
pub const DMO_INPUT_STREAMF_WHOLE_SAMPLES = _DMO_INPUT_STREAM_INFO_FLAGS.WHOLE_SAMPLES;
pub const DMO_INPUT_STREAMF_SINGLE_SAMPLE_PER_BUFFER = _DMO_INPUT_STREAM_INFO_FLAGS.SINGLE_SAMPLE_PER_BUFFER;
pub const DMO_INPUT_STREAMF_FIXED_SAMPLE_SIZE = _DMO_INPUT_STREAM_INFO_FLAGS.FIXED_SAMPLE_SIZE;
pub const DMO_INPUT_STREAMF_HOLDS_BUFFERS = _DMO_INPUT_STREAM_INFO_FLAGS.HOLDS_BUFFERS;

pub const _DMO_OUTPUT_STREAM_INFO_FLAGS = enum(i32) {
    WHOLE_SAMPLES = 1,
    SINGLE_SAMPLE_PER_BUFFER = 2,
    FIXED_SAMPLE_SIZE = 4,
    DISCARDABLE = 8,
    OPTIONAL = 16,
};
pub const DMO_OUTPUT_STREAMF_WHOLE_SAMPLES = _DMO_OUTPUT_STREAM_INFO_FLAGS.WHOLE_SAMPLES;
pub const DMO_OUTPUT_STREAMF_SINGLE_SAMPLE_PER_BUFFER = _DMO_OUTPUT_STREAM_INFO_FLAGS.SINGLE_SAMPLE_PER_BUFFER;
pub const DMO_OUTPUT_STREAMF_FIXED_SAMPLE_SIZE = _DMO_OUTPUT_STREAM_INFO_FLAGS.FIXED_SAMPLE_SIZE;
pub const DMO_OUTPUT_STREAMF_DISCARDABLE = _DMO_OUTPUT_STREAM_INFO_FLAGS.DISCARDABLE;
pub const DMO_OUTPUT_STREAMF_OPTIONAL = _DMO_OUTPUT_STREAM_INFO_FLAGS.OPTIONAL;

pub const _DMO_SET_TYPE_FLAGS = enum(i32) {
    TEST_ONLY = 1,
    CLEAR = 2,
};
pub const DMO_SET_TYPEF_TEST_ONLY = _DMO_SET_TYPE_FLAGS.TEST_ONLY;
pub const DMO_SET_TYPEF_CLEAR = _DMO_SET_TYPE_FLAGS.CLEAR;

pub const _DMO_PROCESS_OUTPUT_FLAGS = enum(i32) {
    R = 1,
};
pub const DMO_PROCESS_OUTPUT_DISCARD_WHEN_NO_BUFFER = _DMO_PROCESS_OUTPUT_FLAGS.R;

const IID_IMediaBuffer_Value = Guid.initString("59eff8b9-938c-4a26-82f2-95cb84cdc837");
pub const IID_IMediaBuffer = &IID_IMediaBuffer_Value;
pub const IMediaBuffer = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetLength: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaBuffer,
                cbLength: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaBuffer,
                cbLength: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMaxLength: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaBuffer,
                pcbMaxLength: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaBuffer,
                pcbMaxLength: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetBufferAndLength: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaBuffer,
                ppBuffer: ?*?*u8,
                pcbLength: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaBuffer,
                ppBuffer: ?*?*u8,
                pcbLength: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaBuffer_SetLength(self: *const T, cbLength: u32) HRESULT {
                return @as(*const IMediaBuffer.VTable, @ptrCast(self.vtable)).SetLength(@as(*const IMediaBuffer, @ptrCast(self)), cbLength);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaBuffer_GetMaxLength(self: *const T, pcbMaxLength: ?*u32) HRESULT {
                return @as(*const IMediaBuffer.VTable, @ptrCast(self.vtable)).GetMaxLength(@as(*const IMediaBuffer, @ptrCast(self)), pcbMaxLength);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaBuffer_GetBufferAndLength(self: *const T, ppBuffer: ?*?*u8, pcbLength: ?*u32) HRESULT {
                return @as(*const IMediaBuffer.VTable, @ptrCast(self.vtable)).GetBufferAndLength(@as(*const IMediaBuffer, @ptrCast(self)), ppBuffer, pcbLength);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const DMO_OUTPUT_DATA_BUFFER = extern struct {
    pBuffer: ?*IMediaBuffer,
    dwStatus: u32,
    rtTimestamp: i64,
    rtTimelength: i64,
};

const IID_IMediaObject_Value = Guid.initString("d8ad0f58-5494-4102-97c5-ec798e59bcf4");
pub const IID_IMediaObject = &IID_IMediaObject_Value;
pub const IMediaObject = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetStreamCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                pcInputStreams: ?*u32,
                pcOutputStreams: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                pcInputStreams: ?*u32,
                pcOutputStreams: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInputStreamInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                pdwFlags: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                pdwFlags: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetOutputStreamInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                dwOutputStreamIndex: u32,
                pdwFlags: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                dwOutputStreamIndex: u32,
                pdwFlags: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInputType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                dwTypeIndex: u32,
                pmt: ?*DMO_MEDIA_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                dwTypeIndex: u32,
                pmt: ?*DMO_MEDIA_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetOutputType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                dwOutputStreamIndex: u32,
                dwTypeIndex: u32,
                pmt: ?*DMO_MEDIA_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                dwOutputStreamIndex: u32,
                dwTypeIndex: u32,
                pmt: ?*DMO_MEDIA_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetInputType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                pmt: ?*const DMO_MEDIA_TYPE,
                dwFlags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                pmt: ?*const DMO_MEDIA_TYPE,
                dwFlags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOutputType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                dwOutputStreamIndex: u32,
                pmt: ?*const DMO_MEDIA_TYPE,
                dwFlags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                dwOutputStreamIndex: u32,
                pmt: ?*const DMO_MEDIA_TYPE,
                dwFlags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInputCurrentType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                pmt: ?*DMO_MEDIA_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                pmt: ?*DMO_MEDIA_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetOutputCurrentType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                dwOutputStreamIndex: u32,
                pmt: ?*DMO_MEDIA_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                dwOutputStreamIndex: u32,
                pmt: ?*DMO_MEDIA_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInputSizeInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                pcbSize: ?*u32,
                pcbMaxLookahead: ?*u32,
                pcbAlignment: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                pcbSize: ?*u32,
                pcbMaxLookahead: ?*u32,
                pcbAlignment: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetOutputSizeInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                dwOutputStreamIndex: u32,
                pcbSize: ?*u32,
                pcbAlignment: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                dwOutputStreamIndex: u32,
                pcbSize: ?*u32,
                pcbAlignment: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInputMaxLatency: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                prtMaxLatency: ?*i64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                prtMaxLatency: ?*i64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetInputMaxLatency: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                rtMaxLatency: i64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                rtMaxLatency: i64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Flush: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Discontinuity: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AllocateStreamingResources: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        FreeStreamingResources: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInputStatus: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                dwFlags: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                dwFlags: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ProcessInput: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                pBuffer: ?*IMediaBuffer,
                dwFlags: u32,
                rtTimestamp: i64,
                rtTimelength: i64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                dwInputStreamIndex: u32,
                pBuffer: ?*IMediaBuffer,
                dwFlags: u32,
                rtTimestamp: i64,
                rtTimelength: i64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ProcessOutput: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                dwFlags: u32,
                cOutputBufferCount: u32,
                pOutputBuffers: [*]DMO_OUTPUT_DATA_BUFFER,
                pdwStatus: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                dwFlags: u32,
                cOutputBufferCount: u32,
                pOutputBuffers: [*]DMO_OUTPUT_DATA_BUFFER,
                pdwStatus: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Lock: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObject,
                bLock: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObject,
                bLock: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_GetStreamCount(self: *const T, pcInputStreams: ?*u32, pcOutputStreams: ?*u32) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).GetStreamCount(@as(*const IMediaObject, @ptrCast(self)), pcInputStreams, pcOutputStreams);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_GetInputStreamInfo(self: *const T, dwInputStreamIndex: u32, pdwFlags: ?*u32) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).GetInputStreamInfo(@as(*const IMediaObject, @ptrCast(self)), dwInputStreamIndex, pdwFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_GetOutputStreamInfo(self: *const T, dwOutputStreamIndex: u32, pdwFlags: ?*u32) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).GetOutputStreamInfo(@as(*const IMediaObject, @ptrCast(self)), dwOutputStreamIndex, pdwFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_GetInputType(self: *const T, dwInputStreamIndex: u32, dwTypeIndex: u32, pmt: ?*DMO_MEDIA_TYPE) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).GetInputType(@as(*const IMediaObject, @ptrCast(self)), dwInputStreamIndex, dwTypeIndex, pmt);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_GetOutputType(self: *const T, dwOutputStreamIndex: u32, dwTypeIndex: u32, pmt: ?*DMO_MEDIA_TYPE) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).GetOutputType(@as(*const IMediaObject, @ptrCast(self)), dwOutputStreamIndex, dwTypeIndex, pmt);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_SetInputType(self: *const T, dwInputStreamIndex: u32, pmt: ?*const DMO_MEDIA_TYPE, dwFlags: u32) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).SetInputType(@as(*const IMediaObject, @ptrCast(self)), dwInputStreamIndex, pmt, dwFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_SetOutputType(self: *const T, dwOutputStreamIndex: u32, pmt: ?*const DMO_MEDIA_TYPE, dwFlags: u32) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).SetOutputType(@as(*const IMediaObject, @ptrCast(self)), dwOutputStreamIndex, pmt, dwFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_GetInputCurrentType(self: *const T, dwInputStreamIndex: u32, pmt: ?*DMO_MEDIA_TYPE) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).GetInputCurrentType(@as(*const IMediaObject, @ptrCast(self)), dwInputStreamIndex, pmt);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_GetOutputCurrentType(self: *const T, dwOutputStreamIndex: u32, pmt: ?*DMO_MEDIA_TYPE) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).GetOutputCurrentType(@as(*const IMediaObject, @ptrCast(self)), dwOutputStreamIndex, pmt);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_GetInputSizeInfo(self: *const T, dwInputStreamIndex: u32, pcbSize: ?*u32, pcbMaxLookahead: ?*u32, pcbAlignment: ?*u32) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).GetInputSizeInfo(@as(*const IMediaObject, @ptrCast(self)), dwInputStreamIndex, pcbSize, pcbMaxLookahead, pcbAlignment);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_GetOutputSizeInfo(self: *const T, dwOutputStreamIndex: u32, pcbSize: ?*u32, pcbAlignment: ?*u32) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).GetOutputSizeInfo(@as(*const IMediaObject, @ptrCast(self)), dwOutputStreamIndex, pcbSize, pcbAlignment);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_GetInputMaxLatency(self: *const T, dwInputStreamIndex: u32, prtMaxLatency: ?*i64) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).GetInputMaxLatency(@as(*const IMediaObject, @ptrCast(self)), dwInputStreamIndex, prtMaxLatency);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_SetInputMaxLatency(self: *const T, dwInputStreamIndex: u32, rtMaxLatency: i64) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).SetInputMaxLatency(@as(*const IMediaObject, @ptrCast(self)), dwInputStreamIndex, rtMaxLatency);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_Flush(self: *const T) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).Flush(@as(*const IMediaObject, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_Discontinuity(self: *const T, dwInputStreamIndex: u32) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).Discontinuity(@as(*const IMediaObject, @ptrCast(self)), dwInputStreamIndex);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_AllocateStreamingResources(self: *const T) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).AllocateStreamingResources(@as(*const IMediaObject, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_FreeStreamingResources(self: *const T) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).FreeStreamingResources(@as(*const IMediaObject, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_GetInputStatus(self: *const T, dwInputStreamIndex: u32, dwFlags: ?*u32) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).GetInputStatus(@as(*const IMediaObject, @ptrCast(self)), dwInputStreamIndex, dwFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_ProcessInput(self: *const T, dwInputStreamIndex: u32, pBuffer: ?*IMediaBuffer, dwFlags: u32, rtTimestamp: i64, rtTimelength: i64) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).ProcessInput(@as(*const IMediaObject, @ptrCast(self)), dwInputStreamIndex, pBuffer, dwFlags, rtTimestamp, rtTimelength);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_ProcessOutput(self: *const T, dwFlags: u32, cOutputBufferCount: u32, pOutputBuffers: [*]DMO_OUTPUT_DATA_BUFFER, pdwStatus: ?*u32) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).ProcessOutput(@as(*const IMediaObject, @ptrCast(self)), dwFlags, cOutputBufferCount, pOutputBuffers, pdwStatus);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObject_Lock(self: *const T, bLock: i32) HRESULT {
                return @as(*const IMediaObject.VTable, @ptrCast(self.vtable)).Lock(@as(*const IMediaObject, @ptrCast(self)), bLock);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IEnumDMO_Value = Guid.initString("2c3cd98a-2bfa-4a53-9c27-5249ba64ba0f");
pub const IID_IEnumDMO = &IID_IEnumDMO_Value;
pub const IEnumDMO = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Next: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumDMO,
                cItemsToFetch: u32,
                pCLSID: [*]Guid,
                Names: [*]?PWSTR,
                pcItemsFetched: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumDMO,
                cItemsToFetch: u32,
                pCLSID: [*]Guid,
                Names: [*]?PWSTR,
                pcItemsFetched: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Skip: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumDMO,
                cItemsToSkip: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumDMO,
                cItemsToSkip: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Reset: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumDMO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumDMO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Clone: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IEnumDMO,
                ppEnum: ?*?*IEnumDMO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IEnumDMO,
                ppEnum: ?*?*IEnumDMO,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumDMO_Next(self: *const T, cItemsToFetch: u32, pCLSID: [*]Guid, Names: [*]?PWSTR, pcItemsFetched: ?*u32) HRESULT {
                return @as(*const IEnumDMO.VTable, @ptrCast(self.vtable)).Next(@as(*const IEnumDMO, @ptrCast(self)), cItemsToFetch, pCLSID, Names, pcItemsFetched);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumDMO_Skip(self: *const T, cItemsToSkip: u32) HRESULT {
                return @as(*const IEnumDMO.VTable, @ptrCast(self.vtable)).Skip(@as(*const IEnumDMO, @ptrCast(self)), cItemsToSkip);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumDMO_Reset(self: *const T) HRESULT {
                return @as(*const IEnumDMO.VTable, @ptrCast(self.vtable)).Reset(@as(*const IEnumDMO, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IEnumDMO_Clone(self: *const T, ppEnum: ?*?*IEnumDMO) HRESULT {
                return @as(*const IEnumDMO.VTable, @ptrCast(self.vtable)).Clone(@as(*const IEnumDMO, @ptrCast(self)), ppEnum);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const _DMO_INPLACE_PROCESS_FLAGS = enum(i32) {
    NORMAL = 0,
    ZERO = 1,
};
pub const DMO_INPLACE_NORMAL = _DMO_INPLACE_PROCESS_FLAGS.NORMAL;
pub const DMO_INPLACE_ZERO = _DMO_INPLACE_PROCESS_FLAGS.ZERO;

const IID_IMediaObjectInPlace_Value = Guid.initString("651b9ad0-0fc7-4aa9-9538-d89931010741");
pub const IID_IMediaObjectInPlace = &IID_IMediaObjectInPlace_Value;
pub const IMediaObjectInPlace = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Process: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObjectInPlace,
                ulSize: u32,
                // TODO: what to do with BytesParamIndex 0?
                pData: ?*u8,
                refTimeStart: i64,
                dwFlags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObjectInPlace,
                ulSize: u32,
                // TODO: what to do with BytesParamIndex 0?
                pData: ?*u8,
                refTimeStart: i64,
                dwFlags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Clone: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObjectInPlace,
                ppMediaObject: ?*?*IMediaObjectInPlace,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObjectInPlace,
                ppMediaObject: ?*?*IMediaObjectInPlace,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetLatency: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMediaObjectInPlace,
                pLatencyTime: ?*i64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMediaObjectInPlace,
                pLatencyTime: ?*i64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObjectInPlace_Process(self: *const T, ulSize: u32, pData: ?*u8, refTimeStart: i64, dwFlags: u32) HRESULT {
                return @as(*const IMediaObjectInPlace.VTable, @ptrCast(self.vtable)).Process(@as(*const IMediaObjectInPlace, @ptrCast(self)), ulSize, pData, refTimeStart, dwFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObjectInPlace_Clone(self: *const T, ppMediaObject: ?*?*IMediaObjectInPlace) HRESULT {
                return @as(*const IMediaObjectInPlace.VTable, @ptrCast(self.vtable)).Clone(@as(*const IMediaObjectInPlace, @ptrCast(self)), ppMediaObject);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMediaObjectInPlace_GetLatency(self: *const T, pLatencyTime: ?*i64) HRESULT {
                return @as(*const IMediaObjectInPlace.VTable, @ptrCast(self.vtable)).GetLatency(@as(*const IMediaObjectInPlace, @ptrCast(self)), pLatencyTime);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const _DMO_QUALITY_STATUS_FLAGS = enum(i32) {
    D = 1,
};
pub const DMO_QUALITY_STATUS_ENABLED = _DMO_QUALITY_STATUS_FLAGS.D;

const IID_IDMOQualityControl_Value = Guid.initString("65abea96-cf36-453f-af8a-705e98f16260");
pub const IID_IDMOQualityControl = &IID_IDMOQualityControl_Value;
pub const IDMOQualityControl = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetNow: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMOQualityControl,
                rtNow: i64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMOQualityControl,
                rtNow: i64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetStatus: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMOQualityControl,
                dwFlags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMOQualityControl,
                dwFlags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetStatus: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMOQualityControl,
                pdwFlags: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMOQualityControl,
                pdwFlags: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMOQualityControl_SetNow(self: *const T, rtNow: i64) HRESULT {
                return @as(*const IDMOQualityControl.VTable, @ptrCast(self.vtable)).SetNow(@as(*const IDMOQualityControl, @ptrCast(self)), rtNow);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMOQualityControl_SetStatus(self: *const T, dwFlags: u32) HRESULT {
                return @as(*const IDMOQualityControl.VTable, @ptrCast(self.vtable)).SetStatus(@as(*const IDMOQualityControl, @ptrCast(self)), dwFlags);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMOQualityControl_GetStatus(self: *const T, pdwFlags: ?*u32) HRESULT {
                return @as(*const IDMOQualityControl.VTable, @ptrCast(self.vtable)).GetStatus(@as(*const IDMOQualityControl, @ptrCast(self)), pdwFlags);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const _DMO_VIDEO_OUTPUT_STREAM_FLAGS = enum(i32) {
    E = 1,
};
pub const DMO_VOSF_NEEDS_PREVIOUS_SAMPLE = _DMO_VIDEO_OUTPUT_STREAM_FLAGS.E;

const IID_IDMOVideoOutputOptimizations_Value = Guid.initString("be8f4f4e-5b16-4d29-b350-7f6b5d9298ac");
pub const IID_IDMOVideoOutputOptimizations = &IID_IDMOVideoOutputOptimizations_Value;
pub const IDMOVideoOutputOptimizations = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        QueryOperationModePreferences: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMOVideoOutputOptimizations,
                ulOutputStreamIndex: u32,
                pdwRequestedCapabilities: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMOVideoOutputOptimizations,
                ulOutputStreamIndex: u32,
                pdwRequestedCapabilities: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOperationMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMOVideoOutputOptimizations,
                ulOutputStreamIndex: u32,
                dwEnabledFeatures: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMOVideoOutputOptimizations,
                ulOutputStreamIndex: u32,
                dwEnabledFeatures: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetCurrentOperationMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMOVideoOutputOptimizations,
                ulOutputStreamIndex: u32,
                pdwEnabledFeatures: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMOVideoOutputOptimizations,
                ulOutputStreamIndex: u32,
                pdwEnabledFeatures: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetCurrentSampleRequirements: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMOVideoOutputOptimizations,
                ulOutputStreamIndex: u32,
                pdwRequestedFeatures: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMOVideoOutputOptimizations,
                ulOutputStreamIndex: u32,
                pdwRequestedFeatures: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMOVideoOutputOptimizations_QueryOperationModePreferences(self: *const T, ulOutputStreamIndex: u32, pdwRequestedCapabilities: ?*u32) HRESULT {
                return @as(*const IDMOVideoOutputOptimizations.VTable, @ptrCast(self.vtable)).QueryOperationModePreferences(@as(*const IDMOVideoOutputOptimizations, @ptrCast(self)), ulOutputStreamIndex, pdwRequestedCapabilities);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMOVideoOutputOptimizations_SetOperationMode(self: *const T, ulOutputStreamIndex: u32, dwEnabledFeatures: u32) HRESULT {
                return @as(*const IDMOVideoOutputOptimizations.VTable, @ptrCast(self.vtable)).SetOperationMode(@as(*const IDMOVideoOutputOptimizations, @ptrCast(self)), ulOutputStreamIndex, dwEnabledFeatures);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMOVideoOutputOptimizations_GetCurrentOperationMode(self: *const T, ulOutputStreamIndex: u32, pdwEnabledFeatures: ?*u32) HRESULT {
                return @as(*const IDMOVideoOutputOptimizations.VTable, @ptrCast(self.vtable)).GetCurrentOperationMode(@as(*const IDMOVideoOutputOptimizations, @ptrCast(self)), ulOutputStreamIndex, pdwEnabledFeatures);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMOVideoOutputOptimizations_GetCurrentSampleRequirements(self: *const T, ulOutputStreamIndex: u32, pdwRequestedFeatures: ?*u32) HRESULT {
                return @as(*const IDMOVideoOutputOptimizations.VTable, @ptrCast(self.vtable)).GetCurrentSampleRequirements(@as(*const IDMOVideoOutputOptimizations, @ptrCast(self)), ulOutputStreamIndex, pdwRequestedFeatures);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const DMO_PARTIAL_MEDIATYPE = extern struct {
    type: Guid,
    subtype: Guid,
};

pub const DMO_REGISTER_FLAGS = enum(i32) {
    D = 1,
};
pub const DMO_REGISTERF_IS_KEYED = DMO_REGISTER_FLAGS.D;

pub const DMO_ENUM_FLAGS = enum(i32) {
    D = 1,
};
pub const DMO_ENUMF_INCLUDE_KEYED = DMO_ENUM_FLAGS.D;

//--------------------------------------------------------------------------------
// Section: Functions (11)
//--------------------------------------------------------------------------------
pub extern "msdmo" fn DMORegister(
    szName: ?[*:0]const u16,
    clsidDMO: ?*const Guid,
    guidCategory: ?*const Guid,
    dwFlags: u32,
    cInTypes: u32,
    pInTypes: ?*const DMO_PARTIAL_MEDIATYPE,
    cOutTypes: u32,
    pOutTypes: ?*const DMO_PARTIAL_MEDIATYPE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "msdmo" fn DMOUnregister(
    clsidDMO: ?*const Guid,
    guidCategory: ?*const Guid,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "msdmo" fn DMOEnum(
    guidCategory: ?*const Guid,
    dwFlags: u32,
    cInTypes: u32,
    pInTypes: ?*const DMO_PARTIAL_MEDIATYPE,
    cOutTypes: u32,
    pOutTypes: ?*const DMO_PARTIAL_MEDIATYPE,
    ppEnum: ?*?*IEnumDMO,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "msdmo" fn DMOGetTypes(
    clsidDMO: ?*const Guid,
    ulInputTypesRequested: u32,
    pulInputTypesSupplied: ?*u32,
    pInputTypes: ?*DMO_PARTIAL_MEDIATYPE,
    ulOutputTypesRequested: u32,
    pulOutputTypesSupplied: ?*u32,
    pOutputTypes: ?*DMO_PARTIAL_MEDIATYPE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "msdmo" fn DMOGetName(
    clsidDMO: ?*const Guid,
    szName: *[80]u16,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "msdmo" fn MoInitMediaType(
    pmt: ?*DMO_MEDIA_TYPE,
    cbFormat: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "msdmo" fn MoFreeMediaType(
    pmt: ?*DMO_MEDIA_TYPE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "msdmo" fn MoCopyMediaType(
    pmtDest: ?*DMO_MEDIA_TYPE,
    pmtSrc: ?*const DMO_MEDIA_TYPE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "msdmo" fn MoCreateMediaType(
    ppmt: ?*?*DMO_MEDIA_TYPE,
    cbFormat: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "msdmo" fn MoDeleteMediaType(
    pmt: ?*DMO_MEDIA_TYPE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "msdmo" fn MoDuplicateMediaType(
    ppmtDest: ?*?*DMO_MEDIA_TYPE,
    pmtSrc: ?*const DMO_MEDIA_TYPE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (5)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const HRESULT = @import("../foundation.zig").HRESULT;
const IUnknown = @import("../system/com.zig").IUnknown;
const PWSTR = @import("../foundation.zig").PWSTR;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
