//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (7)
//--------------------------------------------------------------------------------
pub const PRINTTICKET_ISTREAM_APIS = @as(u32, 1);
pub const S_PT_NO_CONFLICT = @as(u32, 262145);
pub const S_PT_CONFLICT_RESOLVED = @as(u32, 262146);
pub const E_PRINTTICKET_FORMAT = @as(u32, 2147745795);
pub const E_PRINTCAPABILITIES_FORMAT = @as(u32, 2147745796);
pub const E_DELTA_PRINTTICKET_FORMAT = @as(u32, 2147745797);
pub const E_PRINTDEVICECAPABILITIES_FORMAT = @as(u32, 2147745798);

//--------------------------------------------------------------------------------
// Section: Types (2)
//--------------------------------------------------------------------------------
pub const EDefaultDevmodeType = enum(i32) {
    UserDefaultDevmode = 0,
    PrinterDefaultDevmode = 1,
};
pub const kUserDefaultDevmode = EDefaultDevmodeType.UserDefaultDevmode;
pub const kPrinterDefaultDevmode = EDefaultDevmodeType.PrinterDefaultDevmode;

pub const EPrintTicketScope = enum(i32) {
    PageScope = 0,
    DocumentScope = 1,
    JobScope = 2,
};
pub const kPTPageScope = EPrintTicketScope.PageScope;
pub const kPTDocumentScope = EPrintTicketScope.DocumentScope;
pub const kPTJobScope = EPrintTicketScope.JobScope;

//--------------------------------------------------------------------------------
// Section: Functions (11)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "prntvpt" fn PTQuerySchemaVersionSupport(
    pszPrinterName: ?[*:0]const u16,
    pMaxVersion: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "prntvpt" fn PTOpenProvider(
    pszPrinterName: ?[*:0]const u16,
    dwVersion: u32,
    phProvider: ?*?HPTPROVIDER,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "prntvpt" fn PTOpenProviderEx(
    pszPrinterName: ?[*:0]const u16,
    dwMaxVersion: u32,
    dwPrefVersion: u32,
    phProvider: ?*?HPTPROVIDER,
    pUsedVersion: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "prntvpt" fn PTCloseProvider(
    hProvider: ?HPTPROVIDER,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "prntvpt" fn PTReleaseMemory(
    pBuffer: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "prntvpt" fn PTGetPrintCapabilities(
    hProvider: ?HPTPROVIDER,
    pPrintTicket: ?*IStream,
    pCapabilities: ?*IStream,
    pbstrErrorMessage: ?*?BSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.15063'
pub extern "prntvpt" fn PTGetPrintDeviceCapabilities(
    hProvider: ?HPTPROVIDER,
    pPrintTicket: ?*IStream,
    pDeviceCapabilities: ?*IStream,
    pbstrErrorMessage: ?*?BSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.15063'
pub extern "prntvpt" fn PTGetPrintDeviceResources(
    hProvider: ?HPTPROVIDER,
    pszLocaleName: ?[*:0]const u16,
    pPrintTicket: ?*IStream,
    pDeviceResources: ?*IStream,
    pbstrErrorMessage: ?*?BSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "prntvpt" fn PTMergeAndValidatePrintTicket(
    hProvider: ?HPTPROVIDER,
    pBaseTicket: ?*IStream,
    pDeltaTicket: ?*IStream,
    scope: EPrintTicketScope,
    pResultTicket: ?*IStream,
    pbstrErrorMessage: ?*?BSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "prntvpt" fn PTConvertPrintTicketToDevMode(
    hProvider: ?HPTPROVIDER,
    pPrintTicket: ?*IStream,
    baseDevmodeType: EDefaultDevmodeType,
    scope: EPrintTicketScope,
    pcbDevmode: ?*u32,
    ppDevmode: ?*?*DEVMODEA,
    pbstrErrorMessage: ?*?BSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "prntvpt" fn PTConvertDevModeToPrintTicket(
    hProvider: ?HPTPROVIDER,
    cbDevmode: u32,
    pDevmode: ?*DEVMODEA,
    scope: EPrintTicketScope,
    pPrintTicket: ?*IStream,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (6)
//--------------------------------------------------------------------------------
const BSTR = @import("../../foundation.zig").BSTR;
const DEVMODEA = @import("../../graphics/gdi.zig").DEVMODEA;
const HPTPROVIDER = @import("../../storage/xps.zig").HPTPROVIDER;
const HRESULT = @import("../../foundation.zig").HRESULT;
const IStream = @import("../../system/com.zig").IStream;
const PWSTR = @import("../../foundation.zig").PWSTR;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
