//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (4)
//--------------------------------------------------------------------------------
pub const _FACDXCORE = @as(u32, 2176);
pub const DXCORE_ADAPTER_ATTRIBUTE_D3D11_GRAPHICS = Guid.initString("8c47866b-7583-450d-f0f0-6bada895af4b");
pub const DXCORE_ADAPTER_ATTRIBUTE_D3D12_GRAPHICS = Guid.initString("0c9ece4d-2f6e-4f01-8c96-e89e331b47b1");
pub const DXCORE_ADAPTER_ATTRIBUTE_D3D12_CORE_COMPUTE = Guid.initString("248e2800-a793-4724-abaa-23a6de1be090");

//--------------------------------------------------------------------------------
// Section: Types (13)
//--------------------------------------------------------------------------------
pub const DXCoreAdapterProperty = enum(u32) {
    InstanceLuid = 0,
    DriverVersion = 1,
    DriverDescription = 2,
    HardwareID = 3,
    KmdModelVersion = 4,
    ComputePreemptionGranularity = 5,
    GraphicsPreemptionGranularity = 6,
    DedicatedAdapterMemory = 7,
    DedicatedSystemMemory = 8,
    SharedSystemMemory = 9,
    AcgCompatible = 10,
    IsHardware = 11,
    IsIntegrated = 12,
    IsDetachable = 13,
    HardwareIDParts = 14,
};
pub const InstanceLuid = DXCoreAdapterProperty.InstanceLuid;
pub const DriverVersion = DXCoreAdapterProperty.DriverVersion;
pub const DriverDescription = DXCoreAdapterProperty.DriverDescription;
pub const HardwareID = DXCoreAdapterProperty.HardwareID;
pub const KmdModelVersion = DXCoreAdapterProperty.KmdModelVersion;
pub const ComputePreemptionGranularity = DXCoreAdapterProperty.ComputePreemptionGranularity;
pub const GraphicsPreemptionGranularity = DXCoreAdapterProperty.GraphicsPreemptionGranularity;
pub const DedicatedAdapterMemory = DXCoreAdapterProperty.DedicatedAdapterMemory;
pub const DedicatedSystemMemory = DXCoreAdapterProperty.DedicatedSystemMemory;
pub const SharedSystemMemory = DXCoreAdapterProperty.SharedSystemMemory;
pub const AcgCompatible = DXCoreAdapterProperty.AcgCompatible;
pub const IsHardware = DXCoreAdapterProperty.IsHardware;
pub const IsIntegrated = DXCoreAdapterProperty.IsIntegrated;
pub const IsDetachable = DXCoreAdapterProperty.IsDetachable;
pub const HardwareIDParts = DXCoreAdapterProperty.HardwareIDParts;

pub const DXCoreAdapterState = enum(u32) {
    IsDriverUpdateInProgress = 0,
    AdapterMemoryBudget = 1,
};
pub const IsDriverUpdateInProgress = DXCoreAdapterState.IsDriverUpdateInProgress;
pub const AdapterMemoryBudget = DXCoreAdapterState.AdapterMemoryBudget;

pub const DXCoreSegmentGroup = enum(u32) {
    Local = 0,
    NonLocal = 1,
};
pub const Local = DXCoreSegmentGroup.Local;
pub const NonLocal = DXCoreSegmentGroup.NonLocal;

pub const DXCoreNotificationType = enum(u32) {
    ListStale = 0,
    NoLongerValid = 1,
    BudgetChange = 2,
    HardwareContentProtectionTeardown = 3,
};
pub const AdapterListStale = DXCoreNotificationType.ListStale;
pub const AdapterNoLongerValid = DXCoreNotificationType.NoLongerValid;
pub const AdapterBudgetChange = DXCoreNotificationType.BudgetChange;
pub const AdapterHardwareContentProtectionTeardown = DXCoreNotificationType.HardwareContentProtectionTeardown;

pub const DXCoreAdapterPreference = enum(u32) {
    Hardware = 0,
    MinimumPower = 1,
    HighPerformance = 2,
};
pub const Hardware = DXCoreAdapterPreference.Hardware;
pub const MinimumPower = DXCoreAdapterPreference.MinimumPower;
pub const HighPerformance = DXCoreAdapterPreference.HighPerformance;

pub const DXCoreHardwareID = extern struct {
    vendorID: u32,
    deviceID: u32,
    subSysID: u32,
    revision: u32,
};

pub const DXCoreHardwareIDParts = extern struct {
    vendorID: u32,
    deviceID: u32,
    subSystemID: u32,
    subVendorID: u32,
    revisionID: u32,
};

pub const DXCoreAdapterMemoryBudgetNodeSegmentGroup = extern struct {
    nodeIndex: u32,
    segmentGroup: DXCoreSegmentGroup,
};

pub const DXCoreAdapterMemoryBudget = extern struct {
    budget: u64,
    currentUsage: u64,
    availableForReservation: u64,
    currentReservation: u64,
};

pub const PFN_DXCORE_NOTIFICATION_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        notificationType: DXCoreNotificationType,
        object: ?*IUnknown,
        context: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        notificationType: DXCoreNotificationType,
        object: ?*IUnknown,
        context: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

const IID_IDXCoreAdapter_Value = Guid.initString("f0db4c7f-fe5a-42a2-bd62-f2a6cf6fc83e");
pub const IID_IDXCoreAdapter = &IID_IDXCoreAdapter_Value;
pub const IDXCoreAdapter = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        IsValid: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapter,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IDXCoreAdapter,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        IsAttributeSupported: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapter,
                attributeGUID: ?*const Guid,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IDXCoreAdapter,
                attributeGUID: ?*const Guid,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        IsPropertySupported: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapter,
                property: DXCoreAdapterProperty,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IDXCoreAdapter,
                property: DXCoreAdapterProperty,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        GetProperty: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapter,
                property: DXCoreAdapterProperty,
                bufferSize: usize,
                // TODO: what to do with BytesParamIndex 1?
                propertyData: ?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDXCoreAdapter,
                property: DXCoreAdapterProperty,
                bufferSize: usize,
                // TODO: what to do with BytesParamIndex 1?
                propertyData: ?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPropertySize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapter,
                property: DXCoreAdapterProperty,
                bufferSize: ?*usize,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDXCoreAdapter,
                property: DXCoreAdapterProperty,
                bufferSize: ?*usize,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        IsQueryStateSupported: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapter,
                property: DXCoreAdapterState,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IDXCoreAdapter,
                property: DXCoreAdapterState,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        QueryState: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapter,
                state: DXCoreAdapterState,
                inputStateDetailsSize: usize,
                // TODO: what to do with BytesParamIndex 1?
                inputStateDetails: ?*const anyopaque,
                outputBufferSize: usize,
                // TODO: what to do with BytesParamIndex 3?
                outputBuffer: ?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDXCoreAdapter,
                state: DXCoreAdapterState,
                inputStateDetailsSize: usize,
                // TODO: what to do with BytesParamIndex 1?
                inputStateDetails: ?*const anyopaque,
                outputBufferSize: usize,
                // TODO: what to do with BytesParamIndex 3?
                outputBuffer: ?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        IsSetStateSupported: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapter,
                property: DXCoreAdapterState,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IDXCoreAdapter,
                property: DXCoreAdapterState,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        SetState: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapter,
                state: DXCoreAdapterState,
                inputStateDetailsSize: usize,
                // TODO: what to do with BytesParamIndex 1?
                inputStateDetails: ?*const anyopaque,
                inputDataSize: usize,
                // TODO: what to do with BytesParamIndex 3?
                inputData: ?*const anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDXCoreAdapter,
                state: DXCoreAdapterState,
                inputStateDetailsSize: usize,
                // TODO: what to do with BytesParamIndex 1?
                inputStateDetails: ?*const anyopaque,
                inputDataSize: usize,
                // TODO: what to do with BytesParamIndex 3?
                inputData: ?*const anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetFactory: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapter,
                riid: ?*const Guid,
                ppvFactory: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDXCoreAdapter,
                riid: ?*const Guid,
                ppvFactory: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapter_IsValid(self: *const T) bool {
                return @as(*const IDXCoreAdapter.VTable, @ptrCast(self.vtable)).IsValid(@as(*const IDXCoreAdapter, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapter_IsAttributeSupported(self: *const T, attributeGUID: ?*const Guid) bool {
                return @as(*const IDXCoreAdapter.VTable, @ptrCast(self.vtable)).IsAttributeSupported(@as(*const IDXCoreAdapter, @ptrCast(self)), attributeGUID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapter_IsPropertySupported(self: *const T, property: DXCoreAdapterProperty) bool {
                return @as(*const IDXCoreAdapter.VTable, @ptrCast(self.vtable)).IsPropertySupported(@as(*const IDXCoreAdapter, @ptrCast(self)), property);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapter_GetProperty(self: *const T, property: DXCoreAdapterProperty, bufferSize: usize, propertyData: ?*anyopaque) HRESULT {
                return @as(*const IDXCoreAdapter.VTable, @ptrCast(self.vtable)).GetProperty(@as(*const IDXCoreAdapter, @ptrCast(self)), property, bufferSize, propertyData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapter_GetPropertySize(self: *const T, property: DXCoreAdapterProperty, bufferSize: ?*usize) HRESULT {
                return @as(*const IDXCoreAdapter.VTable, @ptrCast(self.vtable)).GetPropertySize(@as(*const IDXCoreAdapter, @ptrCast(self)), property, bufferSize);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapter_IsQueryStateSupported(self: *const T, property: DXCoreAdapterState) bool {
                return @as(*const IDXCoreAdapter.VTable, @ptrCast(self.vtable)).IsQueryStateSupported(@as(*const IDXCoreAdapter, @ptrCast(self)), property);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapter_QueryState(self: *const T, state: DXCoreAdapterState, inputStateDetailsSize: usize, inputStateDetails: ?*const anyopaque, outputBufferSize: usize, outputBuffer: ?*anyopaque) HRESULT {
                return @as(*const IDXCoreAdapter.VTable, @ptrCast(self.vtable)).QueryState(@as(*const IDXCoreAdapter, @ptrCast(self)), state, inputStateDetailsSize, inputStateDetails, outputBufferSize, outputBuffer);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapter_IsSetStateSupported(self: *const T, property: DXCoreAdapterState) bool {
                return @as(*const IDXCoreAdapter.VTable, @ptrCast(self.vtable)).IsSetStateSupported(@as(*const IDXCoreAdapter, @ptrCast(self)), property);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapter_SetState(self: *const T, state: DXCoreAdapterState, inputStateDetailsSize: usize, inputStateDetails: ?*const anyopaque, inputDataSize: usize, inputData: ?*const anyopaque) HRESULT {
                return @as(*const IDXCoreAdapter.VTable, @ptrCast(self.vtable)).SetState(@as(*const IDXCoreAdapter, @ptrCast(self)), state, inputStateDetailsSize, inputStateDetails, inputDataSize, inputData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapter_GetFactory(self: *const T, riid: ?*const Guid, ppvFactory: ?*?*anyopaque) HRESULT {
                return @as(*const IDXCoreAdapter.VTable, @ptrCast(self.vtable)).GetFactory(@as(*const IDXCoreAdapter, @ptrCast(self)), riid, ppvFactory);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDXCoreAdapterList_Value = Guid.initString("526c7776-40e9-459b-b711-f32ad76dfc28");
pub const IID_IDXCoreAdapterList = &IID_IDXCoreAdapterList_Value;
pub const IDXCoreAdapterList = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetAdapter: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapterList,
                index: u32,
                riid: ?*const Guid,
                ppvAdapter: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDXCoreAdapterList,
                index: u32,
                riid: ?*const Guid,
                ppvAdapter: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAdapterCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapterList,
            ) callconv(@import("std").os.windows.WINAPI) u32,
            else => *const fn (
                self: *const IDXCoreAdapterList,
            ) callconv(@import("std").os.windows.WINAPI) u32,
        },
        IsStale: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapterList,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IDXCoreAdapterList,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        GetFactory: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapterList,
                riid: ?*const Guid,
                ppvFactory: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDXCoreAdapterList,
                riid: ?*const Guid,
                ppvFactory: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Sort: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapterList,
                numPreferences: u32,
                preferences: [*]const DXCoreAdapterPreference,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDXCoreAdapterList,
                numPreferences: u32,
                preferences: [*]const DXCoreAdapterPreference,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        IsAdapterPreferenceSupported: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapterList,
                preference: DXCoreAdapterPreference,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IDXCoreAdapterList,
                preference: DXCoreAdapterPreference,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapterList_GetAdapter(self: *const T, index: u32, riid: ?*const Guid, ppvAdapter: ?*?*anyopaque) HRESULT {
                return @as(*const IDXCoreAdapterList.VTable, @ptrCast(self.vtable)).GetAdapter(@as(*const IDXCoreAdapterList, @ptrCast(self)), index, riid, ppvAdapter);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapterList_GetAdapterCount(self: *const T) u32 {
                return @as(*const IDXCoreAdapterList.VTable, @ptrCast(self.vtable)).GetAdapterCount(@as(*const IDXCoreAdapterList, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapterList_IsStale(self: *const T) bool {
                return @as(*const IDXCoreAdapterList.VTable, @ptrCast(self.vtable)).IsStale(@as(*const IDXCoreAdapterList, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapterList_GetFactory(self: *const T, riid: ?*const Guid, ppvFactory: ?*?*anyopaque) HRESULT {
                return @as(*const IDXCoreAdapterList.VTable, @ptrCast(self.vtable)).GetFactory(@as(*const IDXCoreAdapterList, @ptrCast(self)), riid, ppvFactory);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapterList_Sort(self: *const T, numPreferences: u32, preferences: [*]const DXCoreAdapterPreference) HRESULT {
                return @as(*const IDXCoreAdapterList.VTable, @ptrCast(self.vtable)).Sort(@as(*const IDXCoreAdapterList, @ptrCast(self)), numPreferences, preferences);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapterList_IsAdapterPreferenceSupported(self: *const T, preference: DXCoreAdapterPreference) bool {
                return @as(*const IDXCoreAdapterList.VTable, @ptrCast(self.vtable)).IsAdapterPreferenceSupported(@as(*const IDXCoreAdapterList, @ptrCast(self)), preference);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDXCoreAdapterFactory_Value = Guid.initString("78ee5945-c36e-4b13-a669-005dd11c0f06");
pub const IID_IDXCoreAdapterFactory = &IID_IDXCoreAdapterFactory_Value;
pub const IDXCoreAdapterFactory = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        CreateAdapterList: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapterFactory,
                numAttributes: u32,
                filterAttributes: [*]const Guid,
                riid: ?*const Guid,
                ppvAdapterList: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDXCoreAdapterFactory,
                numAttributes: u32,
                filterAttributes: [*]const Guid,
                riid: ?*const Guid,
                ppvAdapterList: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAdapterByLuid: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapterFactory,
                adapterLUID: ?*const LUID,
                riid: ?*const Guid,
                ppvAdapter: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDXCoreAdapterFactory,
                adapterLUID: ?*const LUID,
                riid: ?*const Guid,
                ppvAdapter: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        IsNotificationTypeSupported: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapterFactory,
                notificationType: DXCoreNotificationType,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IDXCoreAdapterFactory,
                notificationType: DXCoreNotificationType,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        RegisterEventNotification: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapterFactory,
                dxCoreObject: ?*IUnknown,
                notificationType: DXCoreNotificationType,
                callbackFunction: ?PFN_DXCORE_NOTIFICATION_CALLBACK,
                callbackContext: ?*anyopaque,
                eventCookie: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDXCoreAdapterFactory,
                dxCoreObject: ?*IUnknown,
                notificationType: DXCoreNotificationType,
                callbackFunction: ?PFN_DXCORE_NOTIFICATION_CALLBACK,
                callbackContext: ?*anyopaque,
                eventCookie: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        UnregisterEventNotification: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDXCoreAdapterFactory,
                eventCookie: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDXCoreAdapterFactory,
                eventCookie: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapterFactory_CreateAdapterList(self: *const T, numAttributes: u32, filterAttributes: [*]const Guid, riid: ?*const Guid, ppvAdapterList: ?*?*anyopaque) HRESULT {
                return @as(*const IDXCoreAdapterFactory.VTable, @ptrCast(self.vtable)).CreateAdapterList(@as(*const IDXCoreAdapterFactory, @ptrCast(self)), numAttributes, filterAttributes, riid, ppvAdapterList);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapterFactory_GetAdapterByLuid(self: *const T, adapterLUID: ?*const LUID, riid: ?*const Guid, ppvAdapter: ?*?*anyopaque) HRESULT {
                return @as(*const IDXCoreAdapterFactory.VTable, @ptrCast(self.vtable)).GetAdapterByLuid(@as(*const IDXCoreAdapterFactory, @ptrCast(self)), adapterLUID, riid, ppvAdapter);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapterFactory_IsNotificationTypeSupported(self: *const T, notificationType: DXCoreNotificationType) bool {
                return @as(*const IDXCoreAdapterFactory.VTable, @ptrCast(self.vtable)).IsNotificationTypeSupported(@as(*const IDXCoreAdapterFactory, @ptrCast(self)), notificationType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapterFactory_RegisterEventNotification(self: *const T, dxCoreObject: ?*IUnknown, notificationType: DXCoreNotificationType, callbackFunction: ?PFN_DXCORE_NOTIFICATION_CALLBACK, callbackContext: ?*anyopaque, eventCookie: ?*u32) HRESULT {
                return @as(*const IDXCoreAdapterFactory.VTable, @ptrCast(self.vtable)).RegisterEventNotification(@as(*const IDXCoreAdapterFactory, @ptrCast(self)), dxCoreObject, notificationType, callbackFunction, callbackContext, eventCookie);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDXCoreAdapterFactory_UnregisterEventNotification(self: *const T, eventCookie: u32) HRESULT {
                return @as(*const IDXCoreAdapterFactory.VTable, @ptrCast(self.vtable)).UnregisterEventNotification(@as(*const IDXCoreAdapterFactory, @ptrCast(self)), eventCookie);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

//--------------------------------------------------------------------------------
// Section: Functions (1)
//--------------------------------------------------------------------------------
pub extern "dxcore" fn DXCoreCreateAdapterFactory(
    riid: ?*const Guid,
    ppvFactory: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (4)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const HRESULT = @import("../foundation.zig").HRESULT;
const IUnknown = @import("../system/com.zig").IUnknown;
const LUID = @import("../foundation.zig").LUID;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "PFN_DXCORE_NOTIFICATION_CALLBACK")) {
        _ = PFN_DXCORE_NOTIFICATION_CALLBACK;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
