//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (8)
//--------------------------------------------------------------------------------
pub const DIRECTMANIPULATION_KEYBOARDFOCUS = @as(u32, 4294967294);
pub const DIRECTMANIPULATION_MOUSEFOCUS = @as(u32, 4294967293);
pub const CLSID_VerticalIndicatorContent = Guid.initString("a10b5f17-afe0-4aa2-91e9-3e7001d2e6b4");
pub const CLSID_HorizontalIndicatorContent = Guid.initString("e7d18cf5-3ec7-44d5-a76b-3770f3cf903d");
pub const CLSID_VirtualViewportContent = Guid.initString("3206a19a-86f0-4cb4-a7f3-16e3b7e2d852");
pub const CLSID_DragDropConfigurationBehavior = Guid.initString("09b01b3e-ba6c-454d-82e8-95e352329f23");
pub const CLSID_AutoScrollBehavior = Guid.initString("26126a51-3c70-4c9a-aec2-948849eeb093");
pub const CLSID_DeferContactService = Guid.initString("d7b67cf4-84bb-434e-86ae-6592bbc9abd9");

//--------------------------------------------------------------------------------
// Section: Types (39)
//--------------------------------------------------------------------------------
const CLSID_DirectManipulationViewport_Value = Guid.initString("34e211b6-3650-4f75-8334-fa359598e1c5");
pub const CLSID_DirectManipulationViewport = &CLSID_DirectManipulationViewport_Value;

const CLSID_DirectManipulationUpdateManager_Value = Guid.initString("9fc1bfd5-1835-441a-b3b1-b6cc74b727d0");
pub const CLSID_DirectManipulationUpdateManager = &CLSID_DirectManipulationUpdateManager_Value;

const CLSID_DirectManipulationPrimaryContent_Value = Guid.initString("caa02661-d59e-41c7-8393-3ba3bacb6b57");
pub const CLSID_DirectManipulationPrimaryContent = &CLSID_DirectManipulationPrimaryContent_Value;

const CLSID_DirectManipulationManager_Value = Guid.initString("54e211b6-3650-4f75-8334-fa359598e1c5");
pub const CLSID_DirectManipulationManager = &CLSID_DirectManipulationManager_Value;

const CLSID_DirectManipulationSharedManager_Value = Guid.initString("99793286-77cc-4b57-96db-3b354f6f9fb5");
pub const CLSID_DirectManipulationSharedManager = &CLSID_DirectManipulationSharedManager_Value;

const CLSID_DCompManipulationCompositor_Value = Guid.initString("79dea627-a08a-43ac-8ef5-6900b9299126");
pub const CLSID_DCompManipulationCompositor = &CLSID_DCompManipulationCompositor_Value;

pub const DIRECTMANIPULATION_STATUS = enum(i32) {
    BUILDING = 0,
    ENABLED = 1,
    DISABLED = 2,
    RUNNING = 3,
    INERTIA = 4,
    READY = 5,
    SUSPENDED = 6,
};
pub const DIRECTMANIPULATION_BUILDING = DIRECTMANIPULATION_STATUS.BUILDING;
pub const DIRECTMANIPULATION_ENABLED = DIRECTMANIPULATION_STATUS.ENABLED;
pub const DIRECTMANIPULATION_DISABLED = DIRECTMANIPULATION_STATUS.DISABLED;
pub const DIRECTMANIPULATION_RUNNING = DIRECTMANIPULATION_STATUS.RUNNING;
pub const DIRECTMANIPULATION_INERTIA = DIRECTMANIPULATION_STATUS.INERTIA;
pub const DIRECTMANIPULATION_READY = DIRECTMANIPULATION_STATUS.READY;
pub const DIRECTMANIPULATION_SUSPENDED = DIRECTMANIPULATION_STATUS.SUSPENDED;

pub const DIRECTMANIPULATION_HITTEST_TYPE = enum(i32) {
    ASYNCHRONOUS = 0,
    SYNCHRONOUS = 1,
    AUTO_SYNCHRONOUS = 2,
};
pub const DIRECTMANIPULATION_HITTEST_TYPE_ASYNCHRONOUS = DIRECTMANIPULATION_HITTEST_TYPE.ASYNCHRONOUS;
pub const DIRECTMANIPULATION_HITTEST_TYPE_SYNCHRONOUS = DIRECTMANIPULATION_HITTEST_TYPE.SYNCHRONOUS;
pub const DIRECTMANIPULATION_HITTEST_TYPE_AUTO_SYNCHRONOUS = DIRECTMANIPULATION_HITTEST_TYPE.AUTO_SYNCHRONOUS;

pub const DIRECTMANIPULATION_CONFIGURATION = enum(i32) {
    NONE = 0,
    INTERACTION = 1,
    TRANSLATION_X = 2,
    TRANSLATION_Y = 4,
    SCALING = 16,
    TRANSLATION_INERTIA = 32,
    SCALING_INERTIA = 128,
    RAILS_X = 256,
    RAILS_Y = 512,
};
pub const DIRECTMANIPULATION_CONFIGURATION_NONE = DIRECTMANIPULATION_CONFIGURATION.NONE;
pub const DIRECTMANIPULATION_CONFIGURATION_INTERACTION = DIRECTMANIPULATION_CONFIGURATION.INTERACTION;
pub const DIRECTMANIPULATION_CONFIGURATION_TRANSLATION_X = DIRECTMANIPULATION_CONFIGURATION.TRANSLATION_X;
pub const DIRECTMANIPULATION_CONFIGURATION_TRANSLATION_Y = DIRECTMANIPULATION_CONFIGURATION.TRANSLATION_Y;
pub const DIRECTMANIPULATION_CONFIGURATION_SCALING = DIRECTMANIPULATION_CONFIGURATION.SCALING;
pub const DIRECTMANIPULATION_CONFIGURATION_TRANSLATION_INERTIA = DIRECTMANIPULATION_CONFIGURATION.TRANSLATION_INERTIA;
pub const DIRECTMANIPULATION_CONFIGURATION_SCALING_INERTIA = DIRECTMANIPULATION_CONFIGURATION.SCALING_INERTIA;
pub const DIRECTMANIPULATION_CONFIGURATION_RAILS_X = DIRECTMANIPULATION_CONFIGURATION.RAILS_X;
pub const DIRECTMANIPULATION_CONFIGURATION_RAILS_Y = DIRECTMANIPULATION_CONFIGURATION.RAILS_Y;

pub const DIRECTMANIPULATION_GESTURE_CONFIGURATION = enum(i32) {
    NONE = 0,
    // DEFAULT = 0, this enum value conflicts with NONE
    CROSS_SLIDE_VERTICAL = 8,
    CROSS_SLIDE_HORIZONTAL = 16,
    PINCH_ZOOM = 32,
};
pub const DIRECTMANIPULATION_GESTURE_NONE = DIRECTMANIPULATION_GESTURE_CONFIGURATION.NONE;
pub const DIRECTMANIPULATION_GESTURE_DEFAULT = DIRECTMANIPULATION_GESTURE_CONFIGURATION.NONE;
pub const DIRECTMANIPULATION_GESTURE_CROSS_SLIDE_VERTICAL = DIRECTMANIPULATION_GESTURE_CONFIGURATION.CROSS_SLIDE_VERTICAL;
pub const DIRECTMANIPULATION_GESTURE_CROSS_SLIDE_HORIZONTAL = DIRECTMANIPULATION_GESTURE_CONFIGURATION.CROSS_SLIDE_HORIZONTAL;
pub const DIRECTMANIPULATION_GESTURE_PINCH_ZOOM = DIRECTMANIPULATION_GESTURE_CONFIGURATION.PINCH_ZOOM;

pub const DIRECTMANIPULATION_MOTION_TYPES = enum(i32) {
    NONE = 0,
    TRANSLATEX = 1,
    TRANSLATEY = 2,
    ZOOM = 4,
    CENTERX = 16,
    CENTERY = 32,
    ALL = 55,
};
pub const DIRECTMANIPULATION_MOTION_NONE = DIRECTMANIPULATION_MOTION_TYPES.NONE;
pub const DIRECTMANIPULATION_MOTION_TRANSLATEX = DIRECTMANIPULATION_MOTION_TYPES.TRANSLATEX;
pub const DIRECTMANIPULATION_MOTION_TRANSLATEY = DIRECTMANIPULATION_MOTION_TYPES.TRANSLATEY;
pub const DIRECTMANIPULATION_MOTION_ZOOM = DIRECTMANIPULATION_MOTION_TYPES.ZOOM;
pub const DIRECTMANIPULATION_MOTION_CENTERX = DIRECTMANIPULATION_MOTION_TYPES.CENTERX;
pub const DIRECTMANIPULATION_MOTION_CENTERY = DIRECTMANIPULATION_MOTION_TYPES.CENTERY;
pub const DIRECTMANIPULATION_MOTION_ALL = DIRECTMANIPULATION_MOTION_TYPES.ALL;

pub const DIRECTMANIPULATION_VIEWPORT_OPTIONS = enum(i32) {
    DEFAULT = 0,
    AUTODISABLE = 1,
    MANUALUPDATE = 2,
    INPUT = 4,
    EXPLICITHITTEST = 8,
    DISABLEPIXELSNAPPING = 16,
};
pub const DIRECTMANIPULATION_VIEWPORT_OPTIONS_DEFAULT = DIRECTMANIPULATION_VIEWPORT_OPTIONS.DEFAULT;
pub const DIRECTMANIPULATION_VIEWPORT_OPTIONS_AUTODISABLE = DIRECTMANIPULATION_VIEWPORT_OPTIONS.AUTODISABLE;
pub const DIRECTMANIPULATION_VIEWPORT_OPTIONS_MANUALUPDATE = DIRECTMANIPULATION_VIEWPORT_OPTIONS.MANUALUPDATE;
pub const DIRECTMANIPULATION_VIEWPORT_OPTIONS_INPUT = DIRECTMANIPULATION_VIEWPORT_OPTIONS.INPUT;
pub const DIRECTMANIPULATION_VIEWPORT_OPTIONS_EXPLICITHITTEST = DIRECTMANIPULATION_VIEWPORT_OPTIONS.EXPLICITHITTEST;
pub const DIRECTMANIPULATION_VIEWPORT_OPTIONS_DISABLEPIXELSNAPPING = DIRECTMANIPULATION_VIEWPORT_OPTIONS.DISABLEPIXELSNAPPING;

pub const DIRECTMANIPULATION_SNAPPOINT_TYPE = enum(i32) {
    MANDATORY = 0,
    OPTIONAL = 1,
    MANDATORY_SINGLE = 2,
    OPTIONAL_SINGLE = 3,
};
pub const DIRECTMANIPULATION_SNAPPOINT_MANDATORY = DIRECTMANIPULATION_SNAPPOINT_TYPE.MANDATORY;
pub const DIRECTMANIPULATION_SNAPPOINT_OPTIONAL = DIRECTMANIPULATION_SNAPPOINT_TYPE.OPTIONAL;
pub const DIRECTMANIPULATION_SNAPPOINT_MANDATORY_SINGLE = DIRECTMANIPULATION_SNAPPOINT_TYPE.MANDATORY_SINGLE;
pub const DIRECTMANIPULATION_SNAPPOINT_OPTIONAL_SINGLE = DIRECTMANIPULATION_SNAPPOINT_TYPE.OPTIONAL_SINGLE;

pub const DIRECTMANIPULATION_SNAPPOINT_COORDINATE = enum(i32) {
    BOUNDARY = 0,
    ORIGIN = 1,
    MIRRORED = 16,
};
pub const DIRECTMANIPULATION_COORDINATE_BOUNDARY = DIRECTMANIPULATION_SNAPPOINT_COORDINATE.BOUNDARY;
pub const DIRECTMANIPULATION_COORDINATE_ORIGIN = DIRECTMANIPULATION_SNAPPOINT_COORDINATE.ORIGIN;
pub const DIRECTMANIPULATION_COORDINATE_MIRRORED = DIRECTMANIPULATION_SNAPPOINT_COORDINATE.MIRRORED;

pub const DIRECTMANIPULATION_HORIZONTALALIGNMENT = enum(i32) {
    NONE = 0,
    LEFT = 1,
    CENTER = 2,
    RIGHT = 4,
    UNLOCKCENTER = 8,
};
pub const DIRECTMANIPULATION_HORIZONTALALIGNMENT_NONE = DIRECTMANIPULATION_HORIZONTALALIGNMENT.NONE;
pub const DIRECTMANIPULATION_HORIZONTALALIGNMENT_LEFT = DIRECTMANIPULATION_HORIZONTALALIGNMENT.LEFT;
pub const DIRECTMANIPULATION_HORIZONTALALIGNMENT_CENTER = DIRECTMANIPULATION_HORIZONTALALIGNMENT.CENTER;
pub const DIRECTMANIPULATION_HORIZONTALALIGNMENT_RIGHT = DIRECTMANIPULATION_HORIZONTALALIGNMENT.RIGHT;
pub const DIRECTMANIPULATION_HORIZONTALALIGNMENT_UNLOCKCENTER = DIRECTMANIPULATION_HORIZONTALALIGNMENT.UNLOCKCENTER;

pub const DIRECTMANIPULATION_VERTICALALIGNMENT = enum(i32) {
    NONE = 0,
    TOP = 1,
    CENTER = 2,
    BOTTOM = 4,
    UNLOCKCENTER = 8,
};
pub const DIRECTMANIPULATION_VERTICALALIGNMENT_NONE = DIRECTMANIPULATION_VERTICALALIGNMENT.NONE;
pub const DIRECTMANIPULATION_VERTICALALIGNMENT_TOP = DIRECTMANIPULATION_VERTICALALIGNMENT.TOP;
pub const DIRECTMANIPULATION_VERTICALALIGNMENT_CENTER = DIRECTMANIPULATION_VERTICALALIGNMENT.CENTER;
pub const DIRECTMANIPULATION_VERTICALALIGNMENT_BOTTOM = DIRECTMANIPULATION_VERTICALALIGNMENT.BOTTOM;
pub const DIRECTMANIPULATION_VERTICALALIGNMENT_UNLOCKCENTER = DIRECTMANIPULATION_VERTICALALIGNMENT.UNLOCKCENTER;

pub const DIRECTMANIPULATION_INPUT_MODE = enum(i32) {
    AUTOMATIC = 0,
    MANUAL = 1,
};
pub const DIRECTMANIPULATION_INPUT_MODE_AUTOMATIC = DIRECTMANIPULATION_INPUT_MODE.AUTOMATIC;
pub const DIRECTMANIPULATION_INPUT_MODE_MANUAL = DIRECTMANIPULATION_INPUT_MODE.MANUAL;

// TODO: this type is limited to platform 'windows8.0'
const IID_IDirectManipulationManager_Value = Guid.initString("fbf5d3b4-70c7-4163-9322-5a6f660d6fbc");
pub const IID_IDirectManipulationManager = &IID_IDirectManipulationManager_Value;
pub const IDirectManipulationManager = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Activate: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationManager,
                window: ?HWND,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationManager,
                window: ?HWND,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Deactivate: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationManager,
                window: ?HWND,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationManager,
                window: ?HWND,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RegisterHitTestTarget: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationManager,
                window: ?HWND,
                hitTestWindow: ?HWND,
                type: DIRECTMANIPULATION_HITTEST_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationManager,
                window: ?HWND,
                hitTestWindow: ?HWND,
                type: DIRECTMANIPULATION_HITTEST_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ProcessInput: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationManager,
                message: ?*const MSG,
                handled: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationManager,
                message: ?*const MSG,
                handled: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetUpdateManager: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationManager,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationManager,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateViewport: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationManager,
                frameInfo: ?*IDirectManipulationFrameInfoProvider,
                window: ?HWND,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationManager,
                frameInfo: ?*IDirectManipulationFrameInfoProvider,
                window: ?HWND,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateContent: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationManager,
                frameInfo: ?*IDirectManipulationFrameInfoProvider,
                clsid: ?*const Guid,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationManager,
                frameInfo: ?*IDirectManipulationFrameInfoProvider,
                clsid: ?*const Guid,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationManager_Activate(self: *const T, window: ?HWND) HRESULT {
                return @as(*const IDirectManipulationManager.VTable, @ptrCast(self.vtable)).Activate(@as(*const IDirectManipulationManager, @ptrCast(self)), window);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationManager_Deactivate(self: *const T, window: ?HWND) HRESULT {
                return @as(*const IDirectManipulationManager.VTable, @ptrCast(self.vtable)).Deactivate(@as(*const IDirectManipulationManager, @ptrCast(self)), window);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationManager_RegisterHitTestTarget(self: *const T, window: ?HWND, hitTestWindow: ?HWND, type_: DIRECTMANIPULATION_HITTEST_TYPE) HRESULT {
                return @as(*const IDirectManipulationManager.VTable, @ptrCast(self.vtable)).RegisterHitTestTarget(@as(*const IDirectManipulationManager, @ptrCast(self)), window, hitTestWindow, type_);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationManager_ProcessInput(self: *const T, message: ?*const MSG, handled: ?*BOOL) HRESULT {
                return @as(*const IDirectManipulationManager.VTable, @ptrCast(self.vtable)).ProcessInput(@as(*const IDirectManipulationManager, @ptrCast(self)), message, handled);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationManager_GetUpdateManager(self: *const T, riid: ?*const Guid, object: ?*?*anyopaque) HRESULT {
                return @as(*const IDirectManipulationManager.VTable, @ptrCast(self.vtable)).GetUpdateManager(@as(*const IDirectManipulationManager, @ptrCast(self)), riid, object);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationManager_CreateViewport(self: *const T, frameInfo: ?*IDirectManipulationFrameInfoProvider, window: ?HWND, riid: ?*const Guid, object: ?*?*anyopaque) HRESULT {
                return @as(*const IDirectManipulationManager.VTable, @ptrCast(self.vtable)).CreateViewport(@as(*const IDirectManipulationManager, @ptrCast(self)), frameInfo, window, riid, object);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationManager_CreateContent(self: *const T, frameInfo: ?*IDirectManipulationFrameInfoProvider, clsid: ?*const Guid, riid: ?*const Guid, object: ?*?*anyopaque) HRESULT {
                return @as(*const IDirectManipulationManager.VTable, @ptrCast(self.vtable)).CreateContent(@as(*const IDirectManipulationManager, @ptrCast(self)), frameInfo, clsid, riid, object);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.1'
const IID_IDirectManipulationManager2_Value = Guid.initString("fa1005e9-3d16-484c-bfc9-62b61e56ec4e");
pub const IID_IDirectManipulationManager2 = &IID_IDirectManipulationManager2_Value;
pub const IDirectManipulationManager2 = extern struct {
    pub const VTable = extern struct {
        base: IDirectManipulationManager.VTable,
        CreateBehavior: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationManager2,
                clsid: ?*const Guid,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationManager2,
                clsid: ?*const Guid,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDirectManipulationManager.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationManager2_CreateBehavior(self: *const T, clsid: ?*const Guid, riid: ?*const Guid, object: ?*?*anyopaque) HRESULT {
                return @as(*const IDirectManipulationManager2.VTable, @ptrCast(self.vtable)).CreateBehavior(@as(*const IDirectManipulationManager2, @ptrCast(self)), clsid, riid, object);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows10.0.10240'
const IID_IDirectManipulationManager3_Value = Guid.initString("2cb6b33d-ffe8-488c-b750-fbdfe88dca8c");
pub const IID_IDirectManipulationManager3 = &IID_IDirectManipulationManager3_Value;
pub const IDirectManipulationManager3 = extern struct {
    pub const VTable = extern struct {
        base: IDirectManipulationManager2.VTable,
        GetService: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationManager3,
                clsid: ?*const Guid,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationManager3,
                clsid: ?*const Guid,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDirectManipulationManager2.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationManager3_GetService(self: *const T, clsid: ?*const Guid, riid: ?*const Guid, object: ?*?*anyopaque) HRESULT {
                return @as(*const IDirectManipulationManager3.VTable, @ptrCast(self.vtable)).GetService(@as(*const IDirectManipulationManager3, @ptrCast(self)), clsid, riid, object);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDirectManipulationViewport_Value = Guid.initString("28b85a3d-60a0-48bd-9ba1-5ce8d9ea3a6d");
pub const IID_IDirectManipulationViewport = &IID_IDirectManipulationViewport_Value;
pub const IDirectManipulationViewport = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Enable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Disable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetContact: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                pointerId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                pointerId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ReleaseContact: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                pointerId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                pointerId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ReleaseAllContacts: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetStatus: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                status: ?*DIRECTMANIPULATION_STATUS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                status: ?*DIRECTMANIPULATION_STATUS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetTag: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
                id: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
                id: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTag: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                object: ?*IUnknown,
                id: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                object: ?*IUnknown,
                id: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetViewportRect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                viewport: ?*RECT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                viewport: ?*RECT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetViewportRect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                viewport: ?*const RECT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                viewport: ?*const RECT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ZoomToRect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                left: f32,
                top: f32,
                right: f32,
                bottom: f32,
                animate: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                left: f32,
                top: f32,
                right: f32,
                bottom: f32,
                animate: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetViewportTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                matrix: [*]const f32,
                pointCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                matrix: [*]const f32,
                pointCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SyncDisplayTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                matrix: [*]const f32,
                pointCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                matrix: [*]const f32,
                pointCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPrimaryContent: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddContent: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                content: ?*IDirectManipulationContent,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                content: ?*IDirectManipulationContent,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveContent: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                content: ?*IDirectManipulationContent,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                content: ?*IDirectManipulationContent,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetViewportOptions: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                options: DIRECTMANIPULATION_VIEWPORT_OPTIONS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                options: DIRECTMANIPULATION_VIEWPORT_OPTIONS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddConfiguration: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                configuration: DIRECTMANIPULATION_CONFIGURATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                configuration: DIRECTMANIPULATION_CONFIGURATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveConfiguration: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                configuration: DIRECTMANIPULATION_CONFIGURATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                configuration: DIRECTMANIPULATION_CONFIGURATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ActivateConfiguration: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                configuration: DIRECTMANIPULATION_CONFIGURATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                configuration: DIRECTMANIPULATION_CONFIGURATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetManualGesture: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                configuration: DIRECTMANIPULATION_GESTURE_CONFIGURATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                configuration: DIRECTMANIPULATION_GESTURE_CONFIGURATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetChaining: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                enabledTypes: DIRECTMANIPULATION_MOTION_TYPES,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                enabledTypes: DIRECTMANIPULATION_MOTION_TYPES,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddEventHandler: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                window: ?HWND,
                eventHandler: ?*IDirectManipulationViewportEventHandler,
                cookie: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                window: ?HWND,
                eventHandler: ?*IDirectManipulationViewportEventHandler,
                cookie: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveEventHandler: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                cookie: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                cookie: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetInputMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                mode: DIRECTMANIPULATION_INPUT_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                mode: DIRECTMANIPULATION_INPUT_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetUpdateMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
                mode: DIRECTMANIPULATION_INPUT_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
                mode: DIRECTMANIPULATION_INPUT_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Stop: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Abandon: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_Enable(self: *const T) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).Enable(@as(*const IDirectManipulationViewport, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_Disable(self: *const T) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).Disable(@as(*const IDirectManipulationViewport, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_SetContact(self: *const T, pointerId: u32) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).SetContact(@as(*const IDirectManipulationViewport, @ptrCast(self)), pointerId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_ReleaseContact(self: *const T, pointerId: u32) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).ReleaseContact(@as(*const IDirectManipulationViewport, @ptrCast(self)), pointerId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_ReleaseAllContacts(self: *const T) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).ReleaseAllContacts(@as(*const IDirectManipulationViewport, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_GetStatus(self: *const T, status: ?*DIRECTMANIPULATION_STATUS) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).GetStatus(@as(*const IDirectManipulationViewport, @ptrCast(self)), status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_GetTag(self: *const T, riid: ?*const Guid, object: ?*?*anyopaque, id: ?*u32) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).GetTag(@as(*const IDirectManipulationViewport, @ptrCast(self)), riid, object, id);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_SetTag(self: *const T, object: ?*IUnknown, id: u32) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).SetTag(@as(*const IDirectManipulationViewport, @ptrCast(self)), object, id);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_GetViewportRect(self: *const T, viewport: ?*RECT) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).GetViewportRect(@as(*const IDirectManipulationViewport, @ptrCast(self)), viewport);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_SetViewportRect(self: *const T, viewport: ?*const RECT) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).SetViewportRect(@as(*const IDirectManipulationViewport, @ptrCast(self)), viewport);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_ZoomToRect(self: *const T, left: f32, top: f32, right: f32, bottom: f32, animate: BOOL) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).ZoomToRect(@as(*const IDirectManipulationViewport, @ptrCast(self)), left, top, right, bottom, animate);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_SetViewportTransform(self: *const T, matrix: [*]const f32, pointCount: u32) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).SetViewportTransform(@as(*const IDirectManipulationViewport, @ptrCast(self)), matrix, pointCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_SyncDisplayTransform(self: *const T, matrix: [*]const f32, pointCount: u32) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).SyncDisplayTransform(@as(*const IDirectManipulationViewport, @ptrCast(self)), matrix, pointCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_GetPrimaryContent(self: *const T, riid: ?*const Guid, object: ?*?*anyopaque) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).GetPrimaryContent(@as(*const IDirectManipulationViewport, @ptrCast(self)), riid, object);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_AddContent(self: *const T, content: ?*IDirectManipulationContent) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).AddContent(@as(*const IDirectManipulationViewport, @ptrCast(self)), content);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_RemoveContent(self: *const T, content: ?*IDirectManipulationContent) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).RemoveContent(@as(*const IDirectManipulationViewport, @ptrCast(self)), content);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_SetViewportOptions(self: *const T, options: DIRECTMANIPULATION_VIEWPORT_OPTIONS) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).SetViewportOptions(@as(*const IDirectManipulationViewport, @ptrCast(self)), options);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_AddConfiguration(self: *const T, configuration: DIRECTMANIPULATION_CONFIGURATION) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).AddConfiguration(@as(*const IDirectManipulationViewport, @ptrCast(self)), configuration);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_RemoveConfiguration(self: *const T, configuration: DIRECTMANIPULATION_CONFIGURATION) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).RemoveConfiguration(@as(*const IDirectManipulationViewport, @ptrCast(self)), configuration);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_ActivateConfiguration(self: *const T, configuration: DIRECTMANIPULATION_CONFIGURATION) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).ActivateConfiguration(@as(*const IDirectManipulationViewport, @ptrCast(self)), configuration);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_SetManualGesture(self: *const T, configuration: DIRECTMANIPULATION_GESTURE_CONFIGURATION) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).SetManualGesture(@as(*const IDirectManipulationViewport, @ptrCast(self)), configuration);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_SetChaining(self: *const T, enabledTypes: DIRECTMANIPULATION_MOTION_TYPES) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).SetChaining(@as(*const IDirectManipulationViewport, @ptrCast(self)), enabledTypes);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_AddEventHandler(self: *const T, window: ?HWND, eventHandler: ?*IDirectManipulationViewportEventHandler, cookie: ?*u32) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).AddEventHandler(@as(*const IDirectManipulationViewport, @ptrCast(self)), window, eventHandler, cookie);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_RemoveEventHandler(self: *const T, cookie: u32) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).RemoveEventHandler(@as(*const IDirectManipulationViewport, @ptrCast(self)), cookie);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_SetInputMode(self: *const T, mode: DIRECTMANIPULATION_INPUT_MODE) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).SetInputMode(@as(*const IDirectManipulationViewport, @ptrCast(self)), mode);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_SetUpdateMode(self: *const T, mode: DIRECTMANIPULATION_INPUT_MODE) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).SetUpdateMode(@as(*const IDirectManipulationViewport, @ptrCast(self)), mode);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_Stop(self: *const T) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).Stop(@as(*const IDirectManipulationViewport, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport_Abandon(self: *const T) HRESULT {
                return @as(*const IDirectManipulationViewport.VTable, @ptrCast(self.vtable)).Abandon(@as(*const IDirectManipulationViewport, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.1'
const IID_IDirectManipulationViewport2_Value = Guid.initString("923ccaac-61e1-4385-b726-017af189882a");
pub const IID_IDirectManipulationViewport2 = &IID_IDirectManipulationViewport2_Value;
pub const IDirectManipulationViewport2 = extern struct {
    pub const VTable = extern struct {
        base: IDirectManipulationViewport.VTable,
        AddBehavior: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport2,
                behavior: ?*IUnknown,
                cookie: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport2,
                behavior: ?*IUnknown,
                cookie: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveBehavior: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport2,
                cookie: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport2,
                cookie: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveAllBehaviors: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewport2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewport2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDirectManipulationViewport.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport2_AddBehavior(self: *const T, behavior: ?*IUnknown, cookie: ?*u32) HRESULT {
                return @as(*const IDirectManipulationViewport2.VTable, @ptrCast(self.vtable)).AddBehavior(@as(*const IDirectManipulationViewport2, @ptrCast(self)), behavior, cookie);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport2_RemoveBehavior(self: *const T, cookie: u32) HRESULT {
                return @as(*const IDirectManipulationViewport2.VTable, @ptrCast(self.vtable)).RemoveBehavior(@as(*const IDirectManipulationViewport2, @ptrCast(self)), cookie);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewport2_RemoveAllBehaviors(self: *const T) HRESULT {
                return @as(*const IDirectManipulationViewport2.VTable, @ptrCast(self.vtable)).RemoveAllBehaviors(@as(*const IDirectManipulationViewport2, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDirectManipulationViewportEventHandler_Value = Guid.initString("952121da-d69f-45f9-b0f9-f23944321a6d");
pub const IID_IDirectManipulationViewportEventHandler = &IID_IDirectManipulationViewportEventHandler_Value;
pub const IDirectManipulationViewportEventHandler = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnViewportStatusChanged: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewportEventHandler,
                viewport: ?*IDirectManipulationViewport,
                current: DIRECTMANIPULATION_STATUS,
                previous: DIRECTMANIPULATION_STATUS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewportEventHandler,
                viewport: ?*IDirectManipulationViewport,
                current: DIRECTMANIPULATION_STATUS,
                previous: DIRECTMANIPULATION_STATUS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnViewportUpdated: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewportEventHandler,
                viewport: ?*IDirectManipulationViewport,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewportEventHandler,
                viewport: ?*IDirectManipulationViewport,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OnContentUpdated: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationViewportEventHandler,
                viewport: ?*IDirectManipulationViewport,
                content: ?*IDirectManipulationContent,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationViewportEventHandler,
                viewport: ?*IDirectManipulationViewport,
                content: ?*IDirectManipulationContent,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewportEventHandler_OnViewportStatusChanged(self: *const T, viewport: ?*IDirectManipulationViewport, current: DIRECTMANIPULATION_STATUS, previous: DIRECTMANIPULATION_STATUS) HRESULT {
                return @as(*const IDirectManipulationViewportEventHandler.VTable, @ptrCast(self.vtable)).OnViewportStatusChanged(@as(*const IDirectManipulationViewportEventHandler, @ptrCast(self)), viewport, current, previous);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewportEventHandler_OnViewportUpdated(self: *const T, viewport: ?*IDirectManipulationViewport) HRESULT {
                return @as(*const IDirectManipulationViewportEventHandler.VTable, @ptrCast(self.vtable)).OnViewportUpdated(@as(*const IDirectManipulationViewportEventHandler, @ptrCast(self)), viewport);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationViewportEventHandler_OnContentUpdated(self: *const T, viewport: ?*IDirectManipulationViewport, content: ?*IDirectManipulationContent) HRESULT {
                return @as(*const IDirectManipulationViewportEventHandler.VTable, @ptrCast(self.vtable)).OnContentUpdated(@as(*const IDirectManipulationViewportEventHandler, @ptrCast(self)), viewport, content);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDirectManipulationContent_Value = Guid.initString("b89962cb-3d89-442b-bb58-5098fa0f9f16");
pub const IID_IDirectManipulationContent = &IID_IDirectManipulationContent_Value;
pub const IDirectManipulationContent = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetContentRect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationContent,
                contentSize: ?*RECT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationContent,
                contentSize: ?*RECT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetContentRect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationContent,
                contentSize: ?*const RECT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationContent,
                contentSize: ?*const RECT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetViewport: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationContent,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationContent,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetTag: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationContent,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
                id: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationContent,
                riid: ?*const Guid,
                object: ?*?*anyopaque,
                id: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTag: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationContent,
                object: ?*IUnknown,
                id: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationContent,
                object: ?*IUnknown,
                id: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetOutputTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationContent,
                matrix: [*]f32,
                pointCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationContent,
                matrix: [*]f32,
                pointCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetContentTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationContent,
                matrix: [*]f32,
                pointCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationContent,
                matrix: [*]f32,
                pointCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SyncContentTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationContent,
                matrix: [*]const f32,
                pointCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationContent,
                matrix: [*]const f32,
                pointCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationContent_GetContentRect(self: *const T, contentSize: ?*RECT) HRESULT {
                return @as(*const IDirectManipulationContent.VTable, @ptrCast(self.vtable)).GetContentRect(@as(*const IDirectManipulationContent, @ptrCast(self)), contentSize);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationContent_SetContentRect(self: *const T, contentSize: ?*const RECT) HRESULT {
                return @as(*const IDirectManipulationContent.VTable, @ptrCast(self.vtable)).SetContentRect(@as(*const IDirectManipulationContent, @ptrCast(self)), contentSize);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationContent_GetViewport(self: *const T, riid: ?*const Guid, object: ?*?*anyopaque) HRESULT {
                return @as(*const IDirectManipulationContent.VTable, @ptrCast(self.vtable)).GetViewport(@as(*const IDirectManipulationContent, @ptrCast(self)), riid, object);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationContent_GetTag(self: *const T, riid: ?*const Guid, object: ?*?*anyopaque, id: ?*u32) HRESULT {
                return @as(*const IDirectManipulationContent.VTable, @ptrCast(self.vtable)).GetTag(@as(*const IDirectManipulationContent, @ptrCast(self)), riid, object, id);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationContent_SetTag(self: *const T, object: ?*IUnknown, id: u32) HRESULT {
                return @as(*const IDirectManipulationContent.VTable, @ptrCast(self.vtable)).SetTag(@as(*const IDirectManipulationContent, @ptrCast(self)), object, id);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationContent_GetOutputTransform(self: *const T, matrix: [*]f32, pointCount: u32) HRESULT {
                return @as(*const IDirectManipulationContent.VTable, @ptrCast(self.vtable)).GetOutputTransform(@as(*const IDirectManipulationContent, @ptrCast(self)), matrix, pointCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationContent_GetContentTransform(self: *const T, matrix: [*]f32, pointCount: u32) HRESULT {
                return @as(*const IDirectManipulationContent.VTable, @ptrCast(self.vtable)).GetContentTransform(@as(*const IDirectManipulationContent, @ptrCast(self)), matrix, pointCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationContent_SyncContentTransform(self: *const T, matrix: [*]const f32, pointCount: u32) HRESULT {
                return @as(*const IDirectManipulationContent.VTable, @ptrCast(self.vtable)).SyncContentTransform(@as(*const IDirectManipulationContent, @ptrCast(self)), matrix, pointCount);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDirectManipulationPrimaryContent_Value = Guid.initString("c12851e4-1698-4625-b9b1-7ca3ec18630b");
pub const IID_IDirectManipulationPrimaryContent = &IID_IDirectManipulationPrimaryContent_Value;
pub const IDirectManipulationPrimaryContent = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetSnapInterval: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationPrimaryContent,
                motion: DIRECTMANIPULATION_MOTION_TYPES,
                interval: f32,
                offset: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationPrimaryContent,
                motion: DIRECTMANIPULATION_MOTION_TYPES,
                interval: f32,
                offset: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetSnapPoints: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationPrimaryContent,
                motion: DIRECTMANIPULATION_MOTION_TYPES,
                points: ?[*]const f32,
                pointCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationPrimaryContent,
                motion: DIRECTMANIPULATION_MOTION_TYPES,
                points: ?[*]const f32,
                pointCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetSnapType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationPrimaryContent,
                motion: DIRECTMANIPULATION_MOTION_TYPES,
                type: DIRECTMANIPULATION_SNAPPOINT_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationPrimaryContent,
                motion: DIRECTMANIPULATION_MOTION_TYPES,
                type: DIRECTMANIPULATION_SNAPPOINT_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetSnapCoordinate: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationPrimaryContent,
                motion: DIRECTMANIPULATION_MOTION_TYPES,
                coordinate: DIRECTMANIPULATION_SNAPPOINT_COORDINATE,
                origin: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationPrimaryContent,
                motion: DIRECTMANIPULATION_MOTION_TYPES,
                coordinate: DIRECTMANIPULATION_SNAPPOINT_COORDINATE,
                origin: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetZoomBoundaries: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationPrimaryContent,
                zoomMinimum: f32,
                zoomMaximum: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationPrimaryContent,
                zoomMinimum: f32,
                zoomMaximum: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetHorizontalAlignment: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationPrimaryContent,
                alignment: DIRECTMANIPULATION_HORIZONTALALIGNMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationPrimaryContent,
                alignment: DIRECTMANIPULATION_HORIZONTALALIGNMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetVerticalAlignment: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationPrimaryContent,
                alignment: DIRECTMANIPULATION_VERTICALALIGNMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationPrimaryContent,
                alignment: DIRECTMANIPULATION_VERTICALALIGNMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInertiaEndTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationPrimaryContent,
                matrix: [*]f32,
                pointCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationPrimaryContent,
                matrix: [*]f32,
                pointCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetCenterPoint: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationPrimaryContent,
                centerX: ?*f32,
                centerY: ?*f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationPrimaryContent,
                centerX: ?*f32,
                centerY: ?*f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationPrimaryContent_SetSnapInterval(self: *const T, motion: DIRECTMANIPULATION_MOTION_TYPES, interval: f32, offset: f32) HRESULT {
                return @as(*const IDirectManipulationPrimaryContent.VTable, @ptrCast(self.vtable)).SetSnapInterval(@as(*const IDirectManipulationPrimaryContent, @ptrCast(self)), motion, interval, offset);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationPrimaryContent_SetSnapPoints(self: *const T, motion: DIRECTMANIPULATION_MOTION_TYPES, points: ?[*]const f32, pointCount: u32) HRESULT {
                return @as(*const IDirectManipulationPrimaryContent.VTable, @ptrCast(self.vtable)).SetSnapPoints(@as(*const IDirectManipulationPrimaryContent, @ptrCast(self)), motion, points, pointCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationPrimaryContent_SetSnapType(self: *const T, motion: DIRECTMANIPULATION_MOTION_TYPES, type_: DIRECTMANIPULATION_SNAPPOINT_TYPE) HRESULT {
                return @as(*const IDirectManipulationPrimaryContent.VTable, @ptrCast(self.vtable)).SetSnapType(@as(*const IDirectManipulationPrimaryContent, @ptrCast(self)), motion, type_);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationPrimaryContent_SetSnapCoordinate(self: *const T, motion: DIRECTMANIPULATION_MOTION_TYPES, coordinate: DIRECTMANIPULATION_SNAPPOINT_COORDINATE, origin: f32) HRESULT {
                return @as(*const IDirectManipulationPrimaryContent.VTable, @ptrCast(self.vtable)).SetSnapCoordinate(@as(*const IDirectManipulationPrimaryContent, @ptrCast(self)), motion, coordinate, origin);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationPrimaryContent_SetZoomBoundaries(self: *const T, zoomMinimum: f32, zoomMaximum: f32) HRESULT {
                return @as(*const IDirectManipulationPrimaryContent.VTable, @ptrCast(self.vtable)).SetZoomBoundaries(@as(*const IDirectManipulationPrimaryContent, @ptrCast(self)), zoomMinimum, zoomMaximum);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationPrimaryContent_SetHorizontalAlignment(self: *const T, alignment: DIRECTMANIPULATION_HORIZONTALALIGNMENT) HRESULT {
                return @as(*const IDirectManipulationPrimaryContent.VTable, @ptrCast(self.vtable)).SetHorizontalAlignment(@as(*const IDirectManipulationPrimaryContent, @ptrCast(self)), alignment);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationPrimaryContent_SetVerticalAlignment(self: *const T, alignment: DIRECTMANIPULATION_VERTICALALIGNMENT) HRESULT {
                return @as(*const IDirectManipulationPrimaryContent.VTable, @ptrCast(self.vtable)).SetVerticalAlignment(@as(*const IDirectManipulationPrimaryContent, @ptrCast(self)), alignment);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationPrimaryContent_GetInertiaEndTransform(self: *const T, matrix: [*]f32, pointCount: u32) HRESULT {
                return @as(*const IDirectManipulationPrimaryContent.VTable, @ptrCast(self.vtable)).GetInertiaEndTransform(@as(*const IDirectManipulationPrimaryContent, @ptrCast(self)), matrix, pointCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationPrimaryContent_GetCenterPoint(self: *const T, centerX: ?*f32, centerY: ?*f32) HRESULT {
                return @as(*const IDirectManipulationPrimaryContent.VTable, @ptrCast(self.vtable)).GetCenterPoint(@as(*const IDirectManipulationPrimaryContent, @ptrCast(self)), centerX, centerY);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const DIRECTMANIPULATION_DRAG_DROP_STATUS = enum(i32) {
    READY = 0,
    PRESELECT = 1,
    SELECTING = 2,
    DRAGGING = 3,
    CANCELLED = 4,
    COMMITTED = 5,
};
pub const DIRECTMANIPULATION_DRAG_DROP_READY = DIRECTMANIPULATION_DRAG_DROP_STATUS.READY;
pub const DIRECTMANIPULATION_DRAG_DROP_PRESELECT = DIRECTMANIPULATION_DRAG_DROP_STATUS.PRESELECT;
pub const DIRECTMANIPULATION_DRAG_DROP_SELECTING = DIRECTMANIPULATION_DRAG_DROP_STATUS.SELECTING;
pub const DIRECTMANIPULATION_DRAG_DROP_DRAGGING = DIRECTMANIPULATION_DRAG_DROP_STATUS.DRAGGING;
pub const DIRECTMANIPULATION_DRAG_DROP_CANCELLED = DIRECTMANIPULATION_DRAG_DROP_STATUS.CANCELLED;
pub const DIRECTMANIPULATION_DRAG_DROP_COMMITTED = DIRECTMANIPULATION_DRAG_DROP_STATUS.COMMITTED;

// TODO: this type is limited to platform 'windows8.1'
const IID_IDirectManipulationDragDropEventHandler_Value = Guid.initString("1fa11b10-701b-41ae-b5f2-49e36bd595aa");
pub const IID_IDirectManipulationDragDropEventHandler = &IID_IDirectManipulationDragDropEventHandler_Value;
pub const IDirectManipulationDragDropEventHandler = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnDragDropStatusChange: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationDragDropEventHandler,
                viewport: ?*IDirectManipulationViewport2,
                current: DIRECTMANIPULATION_DRAG_DROP_STATUS,
                previous: DIRECTMANIPULATION_DRAG_DROP_STATUS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationDragDropEventHandler,
                viewport: ?*IDirectManipulationViewport2,
                current: DIRECTMANIPULATION_DRAG_DROP_STATUS,
                previous: DIRECTMANIPULATION_DRAG_DROP_STATUS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationDragDropEventHandler_OnDragDropStatusChange(self: *const T, viewport: ?*IDirectManipulationViewport2, current: DIRECTMANIPULATION_DRAG_DROP_STATUS, previous: DIRECTMANIPULATION_DRAG_DROP_STATUS) HRESULT {
                return @as(*const IDirectManipulationDragDropEventHandler.VTable, @ptrCast(self.vtable)).OnDragDropStatusChange(@as(*const IDirectManipulationDragDropEventHandler, @ptrCast(self)), viewport, current, previous);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const DIRECTMANIPULATION_DRAG_DROP_CONFIGURATION = enum(i32) {
    VERTICAL = 1,
    HORIZONTAL = 2,
    SELECT_ONLY = 16,
    SELECT_DRAG = 32,
    HOLD_DRAG = 64,
};
pub const DIRECTMANIPULATION_DRAG_DROP_CONFIGURATION_VERTICAL = DIRECTMANIPULATION_DRAG_DROP_CONFIGURATION.VERTICAL;
pub const DIRECTMANIPULATION_DRAG_DROP_CONFIGURATION_HORIZONTAL = DIRECTMANIPULATION_DRAG_DROP_CONFIGURATION.HORIZONTAL;
pub const DIRECTMANIPULATION_DRAG_DROP_CONFIGURATION_SELECT_ONLY = DIRECTMANIPULATION_DRAG_DROP_CONFIGURATION.SELECT_ONLY;
pub const DIRECTMANIPULATION_DRAG_DROP_CONFIGURATION_SELECT_DRAG = DIRECTMANIPULATION_DRAG_DROP_CONFIGURATION.SELECT_DRAG;
pub const DIRECTMANIPULATION_DRAG_DROP_CONFIGURATION_HOLD_DRAG = DIRECTMANIPULATION_DRAG_DROP_CONFIGURATION.HOLD_DRAG;

// TODO: this type is limited to platform 'windows8.1'
const IID_IDirectManipulationDragDropBehavior_Value = Guid.initString("814b5af5-c2c8-4270-a9b7-a198ce8d02fa");
pub const IID_IDirectManipulationDragDropBehavior = &IID_IDirectManipulationDragDropBehavior_Value;
pub const IDirectManipulationDragDropBehavior = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetConfiguration: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationDragDropBehavior,
                configuration: DIRECTMANIPULATION_DRAG_DROP_CONFIGURATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationDragDropBehavior,
                configuration: DIRECTMANIPULATION_DRAG_DROP_CONFIGURATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetStatus: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationDragDropBehavior,
                status: ?*DIRECTMANIPULATION_DRAG_DROP_STATUS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationDragDropBehavior,
                status: ?*DIRECTMANIPULATION_DRAG_DROP_STATUS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationDragDropBehavior_SetConfiguration(self: *const T, configuration: DIRECTMANIPULATION_DRAG_DROP_CONFIGURATION) HRESULT {
                return @as(*const IDirectManipulationDragDropBehavior.VTable, @ptrCast(self.vtable)).SetConfiguration(@as(*const IDirectManipulationDragDropBehavior, @ptrCast(self)), configuration);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationDragDropBehavior_GetStatus(self: *const T, status: ?*DIRECTMANIPULATION_DRAG_DROP_STATUS) HRESULT {
                return @as(*const IDirectManipulationDragDropBehavior.VTable, @ptrCast(self.vtable)).GetStatus(@as(*const IDirectManipulationDragDropBehavior, @ptrCast(self)), status);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const DIRECTMANIPULATION_INTERACTION_TYPE = enum(i32) {
    BEGIN = 0,
    TYPE_MANIPULATION = 1,
    TYPE_GESTURE_TAP = 2,
    TYPE_GESTURE_HOLD = 3,
    TYPE_GESTURE_CROSS_SLIDE = 4,
    TYPE_GESTURE_PINCH_ZOOM = 5,
    END = 100,
};
pub const DIRECTMANIPULATION_INTERACTION_BEGIN = DIRECTMANIPULATION_INTERACTION_TYPE.BEGIN;
pub const DIRECTMANIPULATION_INTERACTION_TYPE_MANIPULATION = DIRECTMANIPULATION_INTERACTION_TYPE.TYPE_MANIPULATION;
pub const DIRECTMANIPULATION_INTERACTION_TYPE_GESTURE_TAP = DIRECTMANIPULATION_INTERACTION_TYPE.TYPE_GESTURE_TAP;
pub const DIRECTMANIPULATION_INTERACTION_TYPE_GESTURE_HOLD = DIRECTMANIPULATION_INTERACTION_TYPE.TYPE_GESTURE_HOLD;
pub const DIRECTMANIPULATION_INTERACTION_TYPE_GESTURE_CROSS_SLIDE = DIRECTMANIPULATION_INTERACTION_TYPE.TYPE_GESTURE_CROSS_SLIDE;
pub const DIRECTMANIPULATION_INTERACTION_TYPE_GESTURE_PINCH_ZOOM = DIRECTMANIPULATION_INTERACTION_TYPE.TYPE_GESTURE_PINCH_ZOOM;
pub const DIRECTMANIPULATION_INTERACTION_END = DIRECTMANIPULATION_INTERACTION_TYPE.END;

// TODO: this type is limited to platform 'windows8.1'
const IID_IDirectManipulationInteractionEventHandler_Value = Guid.initString("e43f45b8-42b4-403e-b1f2-273b8f510830");
pub const IID_IDirectManipulationInteractionEventHandler = &IID_IDirectManipulationInteractionEventHandler_Value;
pub const IDirectManipulationInteractionEventHandler = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        OnInteraction: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationInteractionEventHandler,
                viewport: ?*IDirectManipulationViewport2,
                interaction: DIRECTMANIPULATION_INTERACTION_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationInteractionEventHandler,
                viewport: ?*IDirectManipulationViewport2,
                interaction: DIRECTMANIPULATION_INTERACTION_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationInteractionEventHandler_OnInteraction(self: *const T, viewport: ?*IDirectManipulationViewport2, interaction: DIRECTMANIPULATION_INTERACTION_TYPE) HRESULT {
                return @as(*const IDirectManipulationInteractionEventHandler.VTable, @ptrCast(self.vtable)).OnInteraction(@as(*const IDirectManipulationInteractionEventHandler, @ptrCast(self)), viewport, interaction);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDirectManipulationFrameInfoProvider_Value = Guid.initString("fb759dba-6f4c-4c01-874e-19c8a05907f9");
pub const IID_IDirectManipulationFrameInfoProvider = &IID_IDirectManipulationFrameInfoProvider_Value;
pub const IDirectManipulationFrameInfoProvider = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetNextFrameInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationFrameInfoProvider,
                time: ?*u64,
                processTime: ?*u64,
                compositionTime: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationFrameInfoProvider,
                time: ?*u64,
                processTime: ?*u64,
                compositionTime: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationFrameInfoProvider_GetNextFrameInfo(self: *const T, time: ?*u64, processTime: ?*u64, compositionTime: ?*u64) HRESULT {
                return @as(*const IDirectManipulationFrameInfoProvider.VTable, @ptrCast(self.vtable)).GetNextFrameInfo(@as(*const IDirectManipulationFrameInfoProvider, @ptrCast(self)), time, processTime, compositionTime);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDirectManipulationCompositor_Value = Guid.initString("537a0825-0387-4efa-b62f-71eb1f085a7e");
pub const IID_IDirectManipulationCompositor = &IID_IDirectManipulationCompositor_Value;
pub const IDirectManipulationCompositor = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        AddContent: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationCompositor,
                content: ?*IDirectManipulationContent,
                device: ?*IUnknown,
                parentVisual: ?*IUnknown,
                childVisual: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationCompositor,
                content: ?*IDirectManipulationContent,
                device: ?*IUnknown,
                parentVisual: ?*IUnknown,
                childVisual: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveContent: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationCompositor,
                content: ?*IDirectManipulationContent,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationCompositor,
                content: ?*IDirectManipulationContent,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetUpdateManager: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationCompositor,
                updateManager: ?*IDirectManipulationUpdateManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationCompositor,
                updateManager: ?*IDirectManipulationUpdateManager,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Flush: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationCompositor,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationCompositor,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationCompositor_AddContent(self: *const T, content: ?*IDirectManipulationContent, device: ?*IUnknown, parentVisual: ?*IUnknown, childVisual: ?*IUnknown) HRESULT {
                return @as(*const IDirectManipulationCompositor.VTable, @ptrCast(self.vtable)).AddContent(@as(*const IDirectManipulationCompositor, @ptrCast(self)), content, device, parentVisual, childVisual);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationCompositor_RemoveContent(self: *const T, content: ?*IDirectManipulationContent) HRESULT {
                return @as(*const IDirectManipulationCompositor.VTable, @ptrCast(self.vtable)).RemoveContent(@as(*const IDirectManipulationCompositor, @ptrCast(self)), content);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationCompositor_SetUpdateManager(self: *const T, updateManager: ?*IDirectManipulationUpdateManager) HRESULT {
                return @as(*const IDirectManipulationCompositor.VTable, @ptrCast(self.vtable)).SetUpdateManager(@as(*const IDirectManipulationCompositor, @ptrCast(self)), updateManager);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationCompositor_Flush(self: *const T) HRESULT {
                return @as(*const IDirectManipulationCompositor.VTable, @ptrCast(self.vtable)).Flush(@as(*const IDirectManipulationCompositor, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows10.0.10240'
const IID_IDirectManipulationCompositor2_Value = Guid.initString("d38c7822-f1cb-43cb-b4b9-ac0c767a412e");
pub const IID_IDirectManipulationCompositor2 = &IID_IDirectManipulationCompositor2_Value;
pub const IDirectManipulationCompositor2 = extern struct {
    pub const VTable = extern struct {
        base: IDirectManipulationCompositor.VTable,
        AddContentWithCrossProcessChaining: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationCompositor2,
                content: ?*IDirectManipulationPrimaryContent,
                device: ?*IUnknown,
                parentVisual: ?*IUnknown,
                childVisual: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationCompositor2,
                content: ?*IDirectManipulationPrimaryContent,
                device: ?*IUnknown,
                parentVisual: ?*IUnknown,
                childVisual: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDirectManipulationCompositor.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationCompositor2_AddContentWithCrossProcessChaining(self: *const T, content: ?*IDirectManipulationPrimaryContent, device: ?*IUnknown, parentVisual: ?*IUnknown, childVisual: ?*IUnknown) HRESULT {
                return @as(*const IDirectManipulationCompositor2.VTable, @ptrCast(self.vtable)).AddContentWithCrossProcessChaining(@as(*const IDirectManipulationCompositor2, @ptrCast(self)), content, device, parentVisual, childVisual);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDirectManipulationUpdateHandler_Value = Guid.initString("790b6337-64f8-4ff5-a269-b32bc2af27a7");
pub const IID_IDirectManipulationUpdateHandler = &IID_IDirectManipulationUpdateHandler_Value;
pub const IDirectManipulationUpdateHandler = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Update: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationUpdateHandler,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationUpdateHandler,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationUpdateHandler_Update(self: *const T) HRESULT {
                return @as(*const IDirectManipulationUpdateHandler.VTable, @ptrCast(self.vtable)).Update(@as(*const IDirectManipulationUpdateHandler, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDirectManipulationUpdateManager_Value = Guid.initString("b0ae62fd-be34-46e7-9caa-d361facbb9cc");
pub const IID_IDirectManipulationUpdateManager = &IID_IDirectManipulationUpdateManager_Value;
pub const IDirectManipulationUpdateManager = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        RegisterWaitHandleCallback: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationUpdateManager,
                handle: ?HANDLE,
                eventHandler: ?*IDirectManipulationUpdateHandler,
                cookie: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationUpdateManager,
                handle: ?HANDLE,
                eventHandler: ?*IDirectManipulationUpdateHandler,
                cookie: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        UnregisterWaitHandleCallback: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationUpdateManager,
                cookie: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationUpdateManager,
                cookie: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Update: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationUpdateManager,
                frameInfo: ?*IDirectManipulationFrameInfoProvider,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationUpdateManager,
                frameInfo: ?*IDirectManipulationFrameInfoProvider,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationUpdateManager_RegisterWaitHandleCallback(self: *const T, handle: ?HANDLE, eventHandler: ?*IDirectManipulationUpdateHandler, cookie: ?*u32) HRESULT {
                return @as(*const IDirectManipulationUpdateManager.VTable, @ptrCast(self.vtable)).RegisterWaitHandleCallback(@as(*const IDirectManipulationUpdateManager, @ptrCast(self)), handle, eventHandler, cookie);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationUpdateManager_UnregisterWaitHandleCallback(self: *const T, cookie: u32) HRESULT {
                return @as(*const IDirectManipulationUpdateManager.VTable, @ptrCast(self.vtable)).UnregisterWaitHandleCallback(@as(*const IDirectManipulationUpdateManager, @ptrCast(self)), cookie);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationUpdateManager_Update(self: *const T, frameInfo: ?*IDirectManipulationFrameInfoProvider) HRESULT {
                return @as(*const IDirectManipulationUpdateManager.VTable, @ptrCast(self.vtable)).Update(@as(*const IDirectManipulationUpdateManager, @ptrCast(self)), frameInfo);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const DIRECTMANIPULATION_AUTOSCROLL_CONFIGURATION = enum(i32) {
    STOP = 0,
    FORWARD = 1,
    REVERSE = 2,
};
pub const DIRECTMANIPULATION_AUTOSCROLL_CONFIGURATION_STOP = DIRECTMANIPULATION_AUTOSCROLL_CONFIGURATION.STOP;
pub const DIRECTMANIPULATION_AUTOSCROLL_CONFIGURATION_FORWARD = DIRECTMANIPULATION_AUTOSCROLL_CONFIGURATION.FORWARD;
pub const DIRECTMANIPULATION_AUTOSCROLL_CONFIGURATION_REVERSE = DIRECTMANIPULATION_AUTOSCROLL_CONFIGURATION.REVERSE;

// TODO: this type is limited to platform 'windows8.1'
const IID_IDirectManipulationAutoScrollBehavior_Value = Guid.initString("6d5954d4-2003-4356-9b31-d051c9ff0af7");
pub const IID_IDirectManipulationAutoScrollBehavior = &IID_IDirectManipulationAutoScrollBehavior_Value;
pub const IDirectManipulationAutoScrollBehavior = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetConfiguration: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationAutoScrollBehavior,
                motionTypes: DIRECTMANIPULATION_MOTION_TYPES,
                scrollMotion: DIRECTMANIPULATION_AUTOSCROLL_CONFIGURATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationAutoScrollBehavior,
                motionTypes: DIRECTMANIPULATION_MOTION_TYPES,
                scrollMotion: DIRECTMANIPULATION_AUTOSCROLL_CONFIGURATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationAutoScrollBehavior_SetConfiguration(self: *const T, motionTypes: DIRECTMANIPULATION_MOTION_TYPES, scrollMotion: DIRECTMANIPULATION_AUTOSCROLL_CONFIGURATION) HRESULT {
                return @as(*const IDirectManipulationAutoScrollBehavior.VTable, @ptrCast(self.vtable)).SetConfiguration(@as(*const IDirectManipulationAutoScrollBehavior, @ptrCast(self)), motionTypes, scrollMotion);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows10.0.10240'
const IID_IDirectManipulationDeferContactService_Value = Guid.initString("652d5c71-fe60-4a98-be70-e5f21291e7f1");
pub const IID_IDirectManipulationDeferContactService = &IID_IDirectManipulationDeferContactService_Value;
pub const IDirectManipulationDeferContactService = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        DeferContact: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationDeferContactService,
                pointerId: u32,
                timeout: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationDeferContactService,
                pointerId: u32,
                timeout: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CancelContact: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationDeferContactService,
                pointerId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationDeferContactService,
                pointerId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CancelDeferral: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDirectManipulationDeferContactService,
                pointerId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDirectManipulationDeferContactService,
                pointerId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationDeferContactService_DeferContact(self: *const T, pointerId: u32, timeout: u32) HRESULT {
                return @as(*const IDirectManipulationDeferContactService.VTable, @ptrCast(self.vtable)).DeferContact(@as(*const IDirectManipulationDeferContactService, @ptrCast(self)), pointerId, timeout);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationDeferContactService_CancelContact(self: *const T, pointerId: u32) HRESULT {
                return @as(*const IDirectManipulationDeferContactService.VTable, @ptrCast(self.vtable)).CancelContact(@as(*const IDirectManipulationDeferContactService, @ptrCast(self)), pointerId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDirectManipulationDeferContactService_CancelDeferral(self: *const T, pointerId: u32) HRESULT {
                return @as(*const IDirectManipulationDeferContactService.VTable, @ptrCast(self.vtable)).CancelDeferral(@as(*const IDirectManipulationDeferContactService, @ptrCast(self)), pointerId);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

//--------------------------------------------------------------------------------
// Section: Functions (0)
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (8)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const HANDLE = @import("../foundation.zig").HANDLE;
const HRESULT = @import("../foundation.zig").HRESULT;
const HWND = @import("../foundation.zig").HWND;
const IUnknown = @import("../system/com.zig").IUnknown;
const MSG = @import("../ui/windows_and_messaging.zig").MSG;
const RECT = @import("../foundation.zig").RECT;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
