//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (4)
//--------------------------------------------------------------------------------
pub const COMPOSITIONOBJECT_READ = @as(i32, 1);
pub const COMPOSITIONOBJECT_WRITE = @as(i32, 2);
pub const DCOMPOSITION_MAX_WAITFORCOMPOSITORCLOCK_OBJECTS = @as(u32, 32);
pub const COMPOSITION_STATS_MAX_TARGETS = @as(u32, 256);

//--------------------------------------------------------------------------------
// Section: Types (58)
//--------------------------------------------------------------------------------
pub const DCOMPOSITION_BITMAP_INTERPOLATION_MODE = enum(i32) {
    NEAREST_NEIGHBOR = 0,
    LINEAR = 1,
    INHERIT = -1,
};
pub const DCOMPOSITION_BITMAP_INTERPOLATION_MODE_NEAREST_NEIGHBOR = DCOMPOSITION_BITMAP_INTERPOLATION_MODE.NEAREST_NEIGHBOR;
pub const DCOMPOSITION_BITMAP_INTERPOLATION_MODE_LINEAR = DCOMPOSITION_BITMAP_INTERPOLATION_MODE.LINEAR;
pub const DCOMPOSITION_BITMAP_INTERPOLATION_MODE_INHERIT = DCOMPOSITION_BITMAP_INTERPOLATION_MODE.INHERIT;

pub const DCOMPOSITION_BORDER_MODE = enum(i32) {
    SOFT = 0,
    HARD = 1,
    INHERIT = -1,
};
pub const DCOMPOSITION_BORDER_MODE_SOFT = DCOMPOSITION_BORDER_MODE.SOFT;
pub const DCOMPOSITION_BORDER_MODE_HARD = DCOMPOSITION_BORDER_MODE.HARD;
pub const DCOMPOSITION_BORDER_MODE_INHERIT = DCOMPOSITION_BORDER_MODE.INHERIT;

pub const DCOMPOSITION_COMPOSITE_MODE = enum(i32) {
    SOURCE_OVER = 0,
    DESTINATION_INVERT = 1,
    MIN_BLEND = 2,
    INHERIT = -1,
};
pub const DCOMPOSITION_COMPOSITE_MODE_SOURCE_OVER = DCOMPOSITION_COMPOSITE_MODE.SOURCE_OVER;
pub const DCOMPOSITION_COMPOSITE_MODE_DESTINATION_INVERT = DCOMPOSITION_COMPOSITE_MODE.DESTINATION_INVERT;
pub const DCOMPOSITION_COMPOSITE_MODE_MIN_BLEND = DCOMPOSITION_COMPOSITE_MODE.MIN_BLEND;
pub const DCOMPOSITION_COMPOSITE_MODE_INHERIT = DCOMPOSITION_COMPOSITE_MODE.INHERIT;

pub const DCOMPOSITION_BACKFACE_VISIBILITY = enum(i32) {
    VISIBLE = 0,
    HIDDEN = 1,
    INHERIT = -1,
};
pub const DCOMPOSITION_BACKFACE_VISIBILITY_VISIBLE = DCOMPOSITION_BACKFACE_VISIBILITY.VISIBLE;
pub const DCOMPOSITION_BACKFACE_VISIBILITY_HIDDEN = DCOMPOSITION_BACKFACE_VISIBILITY.HIDDEN;
pub const DCOMPOSITION_BACKFACE_VISIBILITY_INHERIT = DCOMPOSITION_BACKFACE_VISIBILITY.INHERIT;

pub const DCOMPOSITION_OPACITY_MODE = enum(i32) {
    LAYER = 0,
    MULTIPLY = 1,
    INHERIT = -1,
};
pub const DCOMPOSITION_OPACITY_MODE_LAYER = DCOMPOSITION_OPACITY_MODE.LAYER;
pub const DCOMPOSITION_OPACITY_MODE_MULTIPLY = DCOMPOSITION_OPACITY_MODE.MULTIPLY;
pub const DCOMPOSITION_OPACITY_MODE_INHERIT = DCOMPOSITION_OPACITY_MODE.INHERIT;

pub const DCOMPOSITION_DEPTH_MODE = enum(i32) {
    TREE = 0,
    SPATIAL = 1,
    SORTED = 3,
    INHERIT = -1,
};
pub const DCOMPOSITION_DEPTH_MODE_TREE = DCOMPOSITION_DEPTH_MODE.TREE;
pub const DCOMPOSITION_DEPTH_MODE_SPATIAL = DCOMPOSITION_DEPTH_MODE.SPATIAL;
pub const DCOMPOSITION_DEPTH_MODE_SORTED = DCOMPOSITION_DEPTH_MODE.SORTED;
pub const DCOMPOSITION_DEPTH_MODE_INHERIT = DCOMPOSITION_DEPTH_MODE.INHERIT;

pub const DCOMPOSITION_FRAME_STATISTICS = extern struct {
    lastFrameTime: LARGE_INTEGER,
    currentCompositionRate: DXGI_RATIONAL,
    currentTime: LARGE_INTEGER,
    timeFrequency: LARGE_INTEGER,
    nextEstimatedFrameTime: LARGE_INTEGER,
};

pub const COMPOSITION_FRAME_ID_TYPE = enum(i32) {
    REATED = 0,
    ONFIRMED = 1,
    OMPLETED = 2,
};
pub const COMPOSITION_FRAME_ID_CREATED = COMPOSITION_FRAME_ID_TYPE.REATED;
pub const COMPOSITION_FRAME_ID_CONFIRMED = COMPOSITION_FRAME_ID_TYPE.ONFIRMED;
pub const COMPOSITION_FRAME_ID_COMPLETED = COMPOSITION_FRAME_ID_TYPE.OMPLETED;

pub const COMPOSITION_FRAME_STATS = extern struct {
    startTime: u64,
    targetTime: u64,
    framePeriod: u64,
};

pub const COMPOSITION_TARGET_ID = extern struct {
    displayAdapterLuid: LUID,
    renderAdapterLuid: LUID,
    vidPnSourceId: u32,
    vidPnTargetId: u32,
    uniqueId: u32,
};

pub const COMPOSITION_STATS = extern struct {
    presentCount: u32,
    refreshCount: u32,
    virtualRefreshCount: u32,
    time: u64,
};

pub const COMPOSITION_TARGET_STATS = extern struct {
    outstandingPresents: u32,
    presentTime: u64,
    vblankDuration: u64,
    presentedStats: COMPOSITION_STATS,
    completedStats: COMPOSITION_STATS,
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionAnimation_Value = Guid.initString("cbfd91d9-51b2-45e4-b3de-d19ccfb863c5");
pub const IID_IDCompositionAnimation = &IID_IDCompositionAnimation_Value;
pub const IDCompositionAnimation = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Reset: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAbsoluteBeginTime: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionAnimation,
                beginTime: LARGE_INTEGER,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionAnimation,
                beginTime: LARGE_INTEGER,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddCubic: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionAnimation,
                beginOffset: f64,
                constantCoefficient: f32,
                linearCoefficient: f32,
                quadraticCoefficient: f32,
                cubicCoefficient: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionAnimation,
                beginOffset: f64,
                constantCoefficient: f32,
                linearCoefficient: f32,
                quadraticCoefficient: f32,
                cubicCoefficient: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddSinusoidal: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionAnimation,
                beginOffset: f64,
                bias: f32,
                amplitude: f32,
                frequency: f32,
                phase: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionAnimation,
                beginOffset: f64,
                bias: f32,
                amplitude: f32,
                frequency: f32,
                phase: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddRepeat: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionAnimation,
                beginOffset: f64,
                durationToRepeat: f64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionAnimation,
                beginOffset: f64,
                durationToRepeat: f64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        End: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionAnimation,
                endOffset: f64,
                endValue: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionAnimation,
                endOffset: f64,
                endValue: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionAnimation_Reset(self: *const T) HRESULT {
                return @as(*const IDCompositionAnimation.VTable, @ptrCast(self.vtable)).Reset(@as(*const IDCompositionAnimation, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionAnimation_SetAbsoluteBeginTime(self: *const T, beginTime: LARGE_INTEGER) HRESULT {
                return @as(*const IDCompositionAnimation.VTable, @ptrCast(self.vtable)).SetAbsoluteBeginTime(@as(*const IDCompositionAnimation, @ptrCast(self)), beginTime);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionAnimation_AddCubic(self: *const T, beginOffset: f64, constantCoefficient: f32, linearCoefficient: f32, quadraticCoefficient: f32, cubicCoefficient: f32) HRESULT {
                return @as(*const IDCompositionAnimation.VTable, @ptrCast(self.vtable)).AddCubic(@as(*const IDCompositionAnimation, @ptrCast(self)), beginOffset, constantCoefficient, linearCoefficient, quadraticCoefficient, cubicCoefficient);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionAnimation_AddSinusoidal(self: *const T, beginOffset: f64, bias: f32, amplitude: f32, frequency: f32, phase: f32) HRESULT {
                return @as(*const IDCompositionAnimation.VTable, @ptrCast(self.vtable)).AddSinusoidal(@as(*const IDCompositionAnimation, @ptrCast(self)), beginOffset, bias, amplitude, frequency, phase);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionAnimation_AddRepeat(self: *const T, beginOffset: f64, durationToRepeat: f64) HRESULT {
                return @as(*const IDCompositionAnimation.VTable, @ptrCast(self.vtable)).AddRepeat(@as(*const IDCompositionAnimation, @ptrCast(self)), beginOffset, durationToRepeat);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionAnimation_End(self: *const T, endOffset: f64, endValue: f32) HRESULT {
                return @as(*const IDCompositionAnimation.VTable, @ptrCast(self.vtable)).End(@as(*const IDCompositionAnimation, @ptrCast(self)), endOffset, endValue);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionDevice_Value = Guid.initString("c37ea93a-e7aa-450d-b16f-9746cb0407f3");
pub const IID_IDCompositionDevice = &IID_IDCompositionDevice_Value;
pub const IDCompositionDevice = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Commit: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        WaitForCommitCompletion: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetFrameStatistics: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                statistics: ?*DCOMPOSITION_FRAME_STATISTICS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                statistics: ?*DCOMPOSITION_FRAME_STATISTICS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateTargetForHwnd: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                hwnd: ?HWND,
                topmost: BOOL,
                target: ?*?*IDCompositionTarget,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                hwnd: ?HWND,
                topmost: BOOL,
                target: ?*?*IDCompositionTarget,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateVisual: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                visual: ?*?*IDCompositionVisual,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                visual: ?*?*IDCompositionVisual,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateSurface: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                width: u32,
                height: u32,
                pixelFormat: DXGI_FORMAT,
                alphaMode: DXGI_ALPHA_MODE,
                surface: ?*?*IDCompositionSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                width: u32,
                height: u32,
                pixelFormat: DXGI_FORMAT,
                alphaMode: DXGI_ALPHA_MODE,
                surface: ?*?*IDCompositionSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateVirtualSurface: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                initialWidth: u32,
                initialHeight: u32,
                pixelFormat: DXGI_FORMAT,
                alphaMode: DXGI_ALPHA_MODE,
                virtualSurface: ?*?*IDCompositionVirtualSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                initialWidth: u32,
                initialHeight: u32,
                pixelFormat: DXGI_FORMAT,
                alphaMode: DXGI_ALPHA_MODE,
                virtualSurface: ?*?*IDCompositionVirtualSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateSurfaceFromHandle: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                handle: ?HANDLE,
                surface: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                handle: ?HANDLE,
                surface: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateSurfaceFromHwnd: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                hwnd: ?HWND,
                surface: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                hwnd: ?HWND,
                surface: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateTranslateTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                translateTransform: ?*?*IDCompositionTranslateTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                translateTransform: ?*?*IDCompositionTranslateTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateScaleTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                scaleTransform: ?*?*IDCompositionScaleTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                scaleTransform: ?*?*IDCompositionScaleTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateRotateTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                rotateTransform: ?*?*IDCompositionRotateTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                rotateTransform: ?*?*IDCompositionRotateTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateSkewTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                skewTransform: ?*?*IDCompositionSkewTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                skewTransform: ?*?*IDCompositionSkewTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateMatrixTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                matrixTransform: ?*?*IDCompositionMatrixTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                matrixTransform: ?*?*IDCompositionMatrixTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateTransformGroup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                transforms: [*]?*IDCompositionTransform,
                elements: u32,
                transformGroup: ?*?*IDCompositionTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                transforms: [*]?*IDCompositionTransform,
                elements: u32,
                transformGroup: ?*?*IDCompositionTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateTranslateTransform3D: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                translateTransform3D: ?*?*IDCompositionTranslateTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                translateTransform3D: ?*?*IDCompositionTranslateTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateScaleTransform3D: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                scaleTransform3D: ?*?*IDCompositionScaleTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                scaleTransform3D: ?*?*IDCompositionScaleTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateRotateTransform3D: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                rotateTransform3D: ?*?*IDCompositionRotateTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                rotateTransform3D: ?*?*IDCompositionRotateTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateMatrixTransform3D: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                matrixTransform3D: ?*?*IDCompositionMatrixTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                matrixTransform3D: ?*?*IDCompositionMatrixTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateTransform3DGroup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                transforms3D: [*]?*IDCompositionTransform3D,
                elements: u32,
                transform3DGroup: ?*?*IDCompositionTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                transforms3D: [*]?*IDCompositionTransform3D,
                elements: u32,
                transform3DGroup: ?*?*IDCompositionTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateEffectGroup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                effectGroup: ?*?*IDCompositionEffectGroup,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                effectGroup: ?*?*IDCompositionEffectGroup,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateRectangleClip: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                clip: ?*?*IDCompositionRectangleClip,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                clip: ?*?*IDCompositionRectangleClip,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateAnimation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                animation: ?*?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                animation: ?*?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CheckDeviceState: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice,
                pfValid: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice,
                pfValid: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_Commit(self: *const T) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).Commit(@as(*const IDCompositionDevice, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_WaitForCommitCompletion(self: *const T) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).WaitForCommitCompletion(@as(*const IDCompositionDevice, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_GetFrameStatistics(self: *const T, statistics: ?*DCOMPOSITION_FRAME_STATISTICS) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).GetFrameStatistics(@as(*const IDCompositionDevice, @ptrCast(self)), statistics);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateTargetForHwnd(self: *const T, hwnd: ?HWND, topmost: BOOL, target: ?*?*IDCompositionTarget) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateTargetForHwnd(@as(*const IDCompositionDevice, @ptrCast(self)), hwnd, topmost, target);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateVisual(self: *const T, visual: ?*?*IDCompositionVisual) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateVisual(@as(*const IDCompositionDevice, @ptrCast(self)), visual);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateSurface(self: *const T, width: u32, height: u32, pixelFormat: DXGI_FORMAT, alphaMode: DXGI_ALPHA_MODE, surface: ?*?*IDCompositionSurface) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateSurface(@as(*const IDCompositionDevice, @ptrCast(self)), width, height, pixelFormat, alphaMode, surface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateVirtualSurface(self: *const T, initialWidth: u32, initialHeight: u32, pixelFormat: DXGI_FORMAT, alphaMode: DXGI_ALPHA_MODE, virtualSurface: ?*?*IDCompositionVirtualSurface) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateVirtualSurface(@as(*const IDCompositionDevice, @ptrCast(self)), initialWidth, initialHeight, pixelFormat, alphaMode, virtualSurface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateSurfaceFromHandle(self: *const T, handle: ?HANDLE, surface: ?*?*IUnknown) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateSurfaceFromHandle(@as(*const IDCompositionDevice, @ptrCast(self)), handle, surface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateSurfaceFromHwnd(self: *const T, hwnd: ?HWND, surface: ?*?*IUnknown) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateSurfaceFromHwnd(@as(*const IDCompositionDevice, @ptrCast(self)), hwnd, surface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateTranslateTransform(self: *const T, translateTransform: ?*?*IDCompositionTranslateTransform) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateTranslateTransform(@as(*const IDCompositionDevice, @ptrCast(self)), translateTransform);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateScaleTransform(self: *const T, scaleTransform: ?*?*IDCompositionScaleTransform) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateScaleTransform(@as(*const IDCompositionDevice, @ptrCast(self)), scaleTransform);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateRotateTransform(self: *const T, rotateTransform: ?*?*IDCompositionRotateTransform) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateRotateTransform(@as(*const IDCompositionDevice, @ptrCast(self)), rotateTransform);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateSkewTransform(self: *const T, skewTransform: ?*?*IDCompositionSkewTransform) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateSkewTransform(@as(*const IDCompositionDevice, @ptrCast(self)), skewTransform);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateMatrixTransform(self: *const T, matrixTransform: ?*?*IDCompositionMatrixTransform) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateMatrixTransform(@as(*const IDCompositionDevice, @ptrCast(self)), matrixTransform);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateTransformGroup(self: *const T, transforms: [*]?*IDCompositionTransform, elements: u32, transformGroup: ?*?*IDCompositionTransform) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateTransformGroup(@as(*const IDCompositionDevice, @ptrCast(self)), transforms, elements, transformGroup);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateTranslateTransform3D(self: *const T, translateTransform3D: ?*?*IDCompositionTranslateTransform3D) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateTranslateTransform3D(@as(*const IDCompositionDevice, @ptrCast(self)), translateTransform3D);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateScaleTransform3D(self: *const T, scaleTransform3D: ?*?*IDCompositionScaleTransform3D) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateScaleTransform3D(@as(*const IDCompositionDevice, @ptrCast(self)), scaleTransform3D);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateRotateTransform3D(self: *const T, rotateTransform3D: ?*?*IDCompositionRotateTransform3D) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateRotateTransform3D(@as(*const IDCompositionDevice, @ptrCast(self)), rotateTransform3D);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateMatrixTransform3D(self: *const T, matrixTransform3D: ?*?*IDCompositionMatrixTransform3D) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateMatrixTransform3D(@as(*const IDCompositionDevice, @ptrCast(self)), matrixTransform3D);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateTransform3DGroup(self: *const T, transforms3D: [*]?*IDCompositionTransform3D, elements: u32, transform3DGroup: ?*?*IDCompositionTransform3D) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateTransform3DGroup(@as(*const IDCompositionDevice, @ptrCast(self)), transforms3D, elements, transform3DGroup);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateEffectGroup(self: *const T, effectGroup: ?*?*IDCompositionEffectGroup) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateEffectGroup(@as(*const IDCompositionDevice, @ptrCast(self)), effectGroup);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateRectangleClip(self: *const T, clip: ?*?*IDCompositionRectangleClip) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateRectangleClip(@as(*const IDCompositionDevice, @ptrCast(self)), clip);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CreateAnimation(self: *const T, animation: ?*?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CreateAnimation(@as(*const IDCompositionDevice, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice_CheckDeviceState(self: *const T, pfValid: ?*BOOL) HRESULT {
                return @as(*const IDCompositionDevice.VTable, @ptrCast(self.vtable)).CheckDeviceState(@as(*const IDCompositionDevice, @ptrCast(self)), pfValid);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionTarget_Value = Guid.initString("eacdd04c-117e-4e17-88f4-d1b12b0e3d89");
pub const IID_IDCompositionTarget = &IID_IDCompositionTarget_Value;
pub const IDCompositionTarget = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetRoot: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTarget,
                visual: ?*IDCompositionVisual,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTarget,
                visual: ?*IDCompositionVisual,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTarget_SetRoot(self: *const T, visual: ?*IDCompositionVisual) HRESULT {
                return @as(*const IDCompositionTarget.VTable, @ptrCast(self.vtable)).SetRoot(@as(*const IDCompositionTarget, @ptrCast(self)), visual);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionVisual_Value = Guid.initString("4d93059d-097b-4651-9a60-f0f25116e2f3");
pub const IID_IDCompositionVisual = &IID_IDCompositionVisual_Value;
pub const IDCompositionVisual = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetOffsetX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOffsetX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
                offsetX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
                offsetX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOffsetY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOffsetY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
                offsetY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
                offsetY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
                transform: ?*IDCompositionTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
                transform: ?*IDCompositionTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTransform1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
                matrix: ?*const D2D_MATRIX_3X2_F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
                matrix: ?*const D2D_MATRIX_3X2_F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTransformParent: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
                visual: ?*IDCompositionVisual,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
                visual: ?*IDCompositionVisual,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetEffect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
                effect: ?*IDCompositionEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
                effect: ?*IDCompositionEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBitmapInterpolationMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
                interpolationMode: DCOMPOSITION_BITMAP_INTERPOLATION_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
                interpolationMode: DCOMPOSITION_BITMAP_INTERPOLATION_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBorderMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
                borderMode: DCOMPOSITION_BORDER_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
                borderMode: DCOMPOSITION_BORDER_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetClip: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
                clip: ?*IDCompositionClip,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
                clip: ?*IDCompositionClip,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetClip1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
                rect: ?*const D2D_RECT_F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
                rect: ?*const D2D_RECT_F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetContent: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
                content: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
                content: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddVisual: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
                visual: ?*IDCompositionVisual,
                insertAbove: BOOL,
                referenceVisual: ?*IDCompositionVisual,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
                visual: ?*IDCompositionVisual,
                insertAbove: BOOL,
                referenceVisual: ?*IDCompositionVisual,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveVisual: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
                visual: ?*IDCompositionVisual,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
                visual: ?*IDCompositionVisual,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveAllVisuals: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCompositeMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual,
                compositeMode: DCOMPOSITION_COMPOSITE_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual,
                compositeMode: DCOMPOSITION_COMPOSITE_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_SetOffsetX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).SetOffsetX(@as(*const IDCompositionVisual, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_SetOffsetX1(self: *const T, offsetX: f32) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).SetOffsetX(@as(*const IDCompositionVisual, @ptrCast(self)), offsetX);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_SetOffsetY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).SetOffsetY(@as(*const IDCompositionVisual, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_SetOffsetY1(self: *const T, offsetY: f32) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).SetOffsetY(@as(*const IDCompositionVisual, @ptrCast(self)), offsetY);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_SetTransform(self: *const T, transform: ?*IDCompositionTransform) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).SetTransform(@as(*const IDCompositionVisual, @ptrCast(self)), transform);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_SetTransform1(self: *const T, matrix: ?*const D2D_MATRIX_3X2_F) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).SetTransform(@as(*const IDCompositionVisual, @ptrCast(self)), matrix);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_SetTransformParent(self: *const T, visual: ?*IDCompositionVisual) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).SetTransformParent(@as(*const IDCompositionVisual, @ptrCast(self)), visual);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_SetEffect(self: *const T, effect: ?*IDCompositionEffect) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).SetEffect(@as(*const IDCompositionVisual, @ptrCast(self)), effect);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_SetBitmapInterpolationMode(self: *const T, interpolationMode: DCOMPOSITION_BITMAP_INTERPOLATION_MODE) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).SetBitmapInterpolationMode(@as(*const IDCompositionVisual, @ptrCast(self)), interpolationMode);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_SetBorderMode(self: *const T, borderMode: DCOMPOSITION_BORDER_MODE) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).SetBorderMode(@as(*const IDCompositionVisual, @ptrCast(self)), borderMode);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_SetClip(self: *const T, clip: ?*IDCompositionClip) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).SetClip(@as(*const IDCompositionVisual, @ptrCast(self)), clip);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_SetClip1(self: *const T, rect: ?*const D2D_RECT_F) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).SetClip(@as(*const IDCompositionVisual, @ptrCast(self)), rect);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_SetContent(self: *const T, content: ?*IUnknown) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).SetContent(@as(*const IDCompositionVisual, @ptrCast(self)), content);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_AddVisual(self: *const T, visual: ?*IDCompositionVisual, insertAbove: BOOL, referenceVisual: ?*IDCompositionVisual) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).AddVisual(@as(*const IDCompositionVisual, @ptrCast(self)), visual, insertAbove, referenceVisual);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_RemoveVisual(self: *const T, visual: ?*IDCompositionVisual) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).RemoveVisual(@as(*const IDCompositionVisual, @ptrCast(self)), visual);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_RemoveAllVisuals(self: *const T) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).RemoveAllVisuals(@as(*const IDCompositionVisual, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual_SetCompositeMode(self: *const T, compositeMode: DCOMPOSITION_COMPOSITE_MODE) HRESULT {
                return @as(*const IDCompositionVisual.VTable, @ptrCast(self.vtable)).SetCompositeMode(@as(*const IDCompositionVisual, @ptrCast(self)), compositeMode);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionEffect_Value = Guid.initString("ec81b08f-bfcb-4e8d-b193-a915587999e8");
pub const IID_IDCompositionEffect = &IID_IDCompositionEffect_Value;
pub const IDCompositionEffect = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionTransform3D_Value = Guid.initString("71185722-246b-41f2-aad1-0443f7f4bfc2");
pub const IID_IDCompositionTransform3D = &IID_IDCompositionTransform3D_Value;
pub const IDCompositionTransform3D = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionEffect.VTable,
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionEffect.MethodMixin(T);
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionTransform_Value = Guid.initString("fd55faa7-37e0-4c20-95d2-9be45bc33f55");
pub const IID_IDCompositionTransform = &IID_IDCompositionTransform_Value;
pub const IDCompositionTransform = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionTransform3D.VTable,
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionTransform3D.MethodMixin(T);
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionTranslateTransform_Value = Guid.initString("06791122-c6f0-417d-8323-269e987f5954");
pub const IID_IDCompositionTranslateTransform = &IID_IDCompositionTranslateTransform_Value;
pub const IDCompositionTranslateTransform = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionTransform.VTable,
        SetOffsetX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTranslateTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTranslateTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOffsetX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTranslateTransform,
                offsetX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTranslateTransform,
                offsetX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOffsetY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTranslateTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTranslateTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOffsetY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTranslateTransform,
                offsetY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTranslateTransform,
                offsetY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionTransform.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTranslateTransform_SetOffsetX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionTranslateTransform.VTable, @ptrCast(self.vtable)).SetOffsetX(@as(*const IDCompositionTranslateTransform, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTranslateTransform_SetOffsetX1(self: *const T, offsetX: f32) HRESULT {
                return @as(*const IDCompositionTranslateTransform.VTable, @ptrCast(self.vtable)).SetOffsetX(@as(*const IDCompositionTranslateTransform, @ptrCast(self)), offsetX);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTranslateTransform_SetOffsetY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionTranslateTransform.VTable, @ptrCast(self.vtable)).SetOffsetY(@as(*const IDCompositionTranslateTransform, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTranslateTransform_SetOffsetY1(self: *const T, offsetY: f32) HRESULT {
                return @as(*const IDCompositionTranslateTransform.VTable, @ptrCast(self.vtable)).SetOffsetY(@as(*const IDCompositionTranslateTransform, @ptrCast(self)), offsetY);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionScaleTransform_Value = Guid.initString("71fde914-40ef-45ef-bd51-68b037c339f9");
pub const IID_IDCompositionScaleTransform = &IID_IDCompositionScaleTransform_Value;
pub const IDCompositionScaleTransform = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionTransform.VTable,
        SetScaleX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetScaleX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform,
                scaleX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform,
                scaleX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetScaleY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetScaleY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform,
                scaleY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform,
                scaleY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform,
                centerX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform,
                centerX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform,
                centerY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform,
                centerY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionTransform.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform_SetScaleX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionScaleTransform.VTable, @ptrCast(self.vtable)).SetScaleX(@as(*const IDCompositionScaleTransform, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform_SetScaleX1(self: *const T, scaleX: f32) HRESULT {
                return @as(*const IDCompositionScaleTransform.VTable, @ptrCast(self.vtable)).SetScaleX(@as(*const IDCompositionScaleTransform, @ptrCast(self)), scaleX);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform_SetScaleY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionScaleTransform.VTable, @ptrCast(self.vtable)).SetScaleY(@as(*const IDCompositionScaleTransform, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform_SetScaleY1(self: *const T, scaleY: f32) HRESULT {
                return @as(*const IDCompositionScaleTransform.VTable, @ptrCast(self.vtable)).SetScaleY(@as(*const IDCompositionScaleTransform, @ptrCast(self)), scaleY);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform_SetCenterX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionScaleTransform.VTable, @ptrCast(self.vtable)).SetCenterX(@as(*const IDCompositionScaleTransform, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform_SetCenterX1(self: *const T, centerX: f32) HRESULT {
                return @as(*const IDCompositionScaleTransform.VTable, @ptrCast(self.vtable)).SetCenterX(@as(*const IDCompositionScaleTransform, @ptrCast(self)), centerX);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform_SetCenterY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionScaleTransform.VTable, @ptrCast(self.vtable)).SetCenterY(@as(*const IDCompositionScaleTransform, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform_SetCenterY1(self: *const T, centerY: f32) HRESULT {
                return @as(*const IDCompositionScaleTransform.VTable, @ptrCast(self.vtable)).SetCenterY(@as(*const IDCompositionScaleTransform, @ptrCast(self)), centerY);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionRotateTransform_Value = Guid.initString("641ed83c-ae96-46c5-90dc-32774cc5c6d5");
pub const IID_IDCompositionRotateTransform = &IID_IDCompositionRotateTransform_Value;
pub const IDCompositionRotateTransform = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionTransform.VTable,
        SetAngle: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAngle1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform,
                angle: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform,
                angle: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform,
                centerX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform,
                centerX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform,
                centerY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform,
                centerY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionTransform.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform_SetAngle(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRotateTransform.VTable, @ptrCast(self.vtable)).SetAngle(@as(*const IDCompositionRotateTransform, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform_SetAngle1(self: *const T, angle: f32) HRESULT {
                return @as(*const IDCompositionRotateTransform.VTable, @ptrCast(self.vtable)).SetAngle(@as(*const IDCompositionRotateTransform, @ptrCast(self)), angle);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform_SetCenterX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRotateTransform.VTable, @ptrCast(self.vtable)).SetCenterX(@as(*const IDCompositionRotateTransform, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform_SetCenterX1(self: *const T, centerX: f32) HRESULT {
                return @as(*const IDCompositionRotateTransform.VTable, @ptrCast(self.vtable)).SetCenterX(@as(*const IDCompositionRotateTransform, @ptrCast(self)), centerX);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform_SetCenterY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRotateTransform.VTable, @ptrCast(self.vtable)).SetCenterY(@as(*const IDCompositionRotateTransform, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform_SetCenterY1(self: *const T, centerY: f32) HRESULT {
                return @as(*const IDCompositionRotateTransform.VTable, @ptrCast(self.vtable)).SetCenterY(@as(*const IDCompositionRotateTransform, @ptrCast(self)), centerY);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionSkewTransform_Value = Guid.initString("e57aa735-dcdb-4c72-9c61-0591f58889ee");
pub const IID_IDCompositionSkewTransform = &IID_IDCompositionSkewTransform_Value;
pub const IDCompositionSkewTransform = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionTransform.VTable,
        SetAngleX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSkewTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSkewTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAngleX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSkewTransform,
                angleX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSkewTransform,
                angleX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAngleY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSkewTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSkewTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAngleY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSkewTransform,
                angleY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSkewTransform,
                angleY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSkewTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSkewTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSkewTransform,
                centerX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSkewTransform,
                centerX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSkewTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSkewTransform,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSkewTransform,
                centerY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSkewTransform,
                centerY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionTransform.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSkewTransform_SetAngleX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionSkewTransform.VTable, @ptrCast(self.vtable)).SetAngleX(@as(*const IDCompositionSkewTransform, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSkewTransform_SetAngleX1(self: *const T, angleX: f32) HRESULT {
                return @as(*const IDCompositionSkewTransform.VTable, @ptrCast(self.vtable)).SetAngleX(@as(*const IDCompositionSkewTransform, @ptrCast(self)), angleX);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSkewTransform_SetAngleY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionSkewTransform.VTable, @ptrCast(self.vtable)).SetAngleY(@as(*const IDCompositionSkewTransform, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSkewTransform_SetAngleY1(self: *const T, angleY: f32) HRESULT {
                return @as(*const IDCompositionSkewTransform.VTable, @ptrCast(self.vtable)).SetAngleY(@as(*const IDCompositionSkewTransform, @ptrCast(self)), angleY);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSkewTransform_SetCenterX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionSkewTransform.VTable, @ptrCast(self.vtable)).SetCenterX(@as(*const IDCompositionSkewTransform, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSkewTransform_SetCenterX1(self: *const T, centerX: f32) HRESULT {
                return @as(*const IDCompositionSkewTransform.VTable, @ptrCast(self.vtable)).SetCenterX(@as(*const IDCompositionSkewTransform, @ptrCast(self)), centerX);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSkewTransform_SetCenterY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionSkewTransform.VTable, @ptrCast(self.vtable)).SetCenterY(@as(*const IDCompositionSkewTransform, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSkewTransform_SetCenterY1(self: *const T, centerY: f32) HRESULT {
                return @as(*const IDCompositionSkewTransform.VTable, @ptrCast(self.vtable)).SetCenterY(@as(*const IDCompositionSkewTransform, @ptrCast(self)), centerY);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionMatrixTransform_Value = Guid.initString("16cdff07-c503-419c-83f2-0965c7af1fa6");
pub const IID_IDCompositionMatrixTransform = &IID_IDCompositionMatrixTransform_Value;
pub const IDCompositionMatrixTransform = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionTransform.VTable,
        SetMatrix: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionMatrixTransform,
                matrix: ?*const D2D_MATRIX_3X2_F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionMatrixTransform,
                matrix: ?*const D2D_MATRIX_3X2_F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetMatrixElement: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionMatrixTransform,
                row: i32,
                column: i32,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionMatrixTransform,
                row: i32,
                column: i32,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetMatrixElement1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionMatrixTransform,
                row: i32,
                column: i32,
                value: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionMatrixTransform,
                row: i32,
                column: i32,
                value: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionTransform.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionMatrixTransform_SetMatrix(self: *const T, matrix: ?*const D2D_MATRIX_3X2_F) HRESULT {
                return @as(*const IDCompositionMatrixTransform.VTable, @ptrCast(self.vtable)).SetMatrix(@as(*const IDCompositionMatrixTransform, @ptrCast(self)), matrix);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionMatrixTransform_SetMatrixElement(self: *const T, row: i32, column: i32, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionMatrixTransform.VTable, @ptrCast(self.vtable)).SetMatrixElement(@as(*const IDCompositionMatrixTransform, @ptrCast(self)), row, column, animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionMatrixTransform_SetMatrixElement1(self: *const T, row: i32, column: i32, value: f32) HRESULT {
                return @as(*const IDCompositionMatrixTransform.VTable, @ptrCast(self.vtable)).SetMatrixElement(@as(*const IDCompositionMatrixTransform, @ptrCast(self)), row, column, value);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionEffectGroup_Value = Guid.initString("a7929a74-e6b2-4bd6-8b95-4040119ca34d");
pub const IID_IDCompositionEffectGroup = &IID_IDCompositionEffectGroup_Value;
pub const IDCompositionEffectGroup = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionEffect.VTable,
        SetOpacity: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionEffectGroup,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionEffectGroup,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOpacity1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionEffectGroup,
                opacity: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionEffectGroup,
                opacity: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTransform3D: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionEffectGroup,
                transform3D: ?*IDCompositionTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionEffectGroup,
                transform3D: ?*IDCompositionTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionEffect.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionEffectGroup_SetOpacity(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionEffectGroup.VTable, @ptrCast(self.vtable)).SetOpacity(@as(*const IDCompositionEffectGroup, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionEffectGroup_SetOpacity1(self: *const T, opacity: f32) HRESULT {
                return @as(*const IDCompositionEffectGroup.VTable, @ptrCast(self.vtable)).SetOpacity(@as(*const IDCompositionEffectGroup, @ptrCast(self)), opacity);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionEffectGroup_SetTransform3D(self: *const T, transform3D: ?*IDCompositionTransform3D) HRESULT {
                return @as(*const IDCompositionEffectGroup.VTable, @ptrCast(self.vtable)).SetTransform3D(@as(*const IDCompositionEffectGroup, @ptrCast(self)), transform3D);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionTranslateTransform3D_Value = Guid.initString("91636d4b-9ba1-4532-aaf7-e3344994d788");
pub const IID_IDCompositionTranslateTransform3D = &IID_IDCompositionTranslateTransform3D_Value;
pub const IDCompositionTranslateTransform3D = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionTransform3D.VTable,
        SetOffsetX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTranslateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTranslateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOffsetX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTranslateTransform3D,
                offsetX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTranslateTransform3D,
                offsetX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOffsetY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTranslateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTranslateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOffsetY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTranslateTransform3D,
                offsetY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTranslateTransform3D,
                offsetY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOffsetZ: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTranslateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTranslateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOffsetZ1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTranslateTransform3D,
                offsetZ: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTranslateTransform3D,
                offsetZ: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionTransform3D.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTranslateTransform3D_SetOffsetX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionTranslateTransform3D.VTable, @ptrCast(self.vtable)).SetOffsetX(@as(*const IDCompositionTranslateTransform3D, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTranslateTransform3D_SetOffsetX1(self: *const T, offsetX: f32) HRESULT {
                return @as(*const IDCompositionTranslateTransform3D.VTable, @ptrCast(self.vtable)).SetOffsetX(@as(*const IDCompositionTranslateTransform3D, @ptrCast(self)), offsetX);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTranslateTransform3D_SetOffsetY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionTranslateTransform3D.VTable, @ptrCast(self.vtable)).SetOffsetY(@as(*const IDCompositionTranslateTransform3D, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTranslateTransform3D_SetOffsetY1(self: *const T, offsetY: f32) HRESULT {
                return @as(*const IDCompositionTranslateTransform3D.VTable, @ptrCast(self.vtable)).SetOffsetY(@as(*const IDCompositionTranslateTransform3D, @ptrCast(self)), offsetY);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTranslateTransform3D_SetOffsetZ(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionTranslateTransform3D.VTable, @ptrCast(self.vtable)).SetOffsetZ(@as(*const IDCompositionTranslateTransform3D, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTranslateTransform3D_SetOffsetZ1(self: *const T, offsetZ: f32) HRESULT {
                return @as(*const IDCompositionTranslateTransform3D.VTable, @ptrCast(self.vtable)).SetOffsetZ(@as(*const IDCompositionTranslateTransform3D, @ptrCast(self)), offsetZ);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionScaleTransform3D_Value = Guid.initString("2a9e9ead-364b-4b15-a7c4-a1997f78b389");
pub const IID_IDCompositionScaleTransform3D = &IID_IDCompositionScaleTransform3D_Value;
pub const IDCompositionScaleTransform3D = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionTransform3D.VTable,
        SetScaleX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetScaleX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform3D,
                scaleX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform3D,
                scaleX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetScaleY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetScaleY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform3D,
                scaleY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform3D,
                scaleY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetScaleZ: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetScaleZ1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform3D,
                scaleZ: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform3D,
                scaleZ: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform3D,
                centerX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform3D,
                centerX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform3D,
                centerY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform3D,
                centerY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterZ: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterZ1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionScaleTransform3D,
                centerZ: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionScaleTransform3D,
                centerZ: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionTransform3D.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform3D_SetScaleX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionScaleTransform3D.VTable, @ptrCast(self.vtable)).SetScaleX(@as(*const IDCompositionScaleTransform3D, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform3D_SetScaleX1(self: *const T, scaleX: f32) HRESULT {
                return @as(*const IDCompositionScaleTransform3D.VTable, @ptrCast(self.vtable)).SetScaleX(@as(*const IDCompositionScaleTransform3D, @ptrCast(self)), scaleX);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform3D_SetScaleY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionScaleTransform3D.VTable, @ptrCast(self.vtable)).SetScaleY(@as(*const IDCompositionScaleTransform3D, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform3D_SetScaleY1(self: *const T, scaleY: f32) HRESULT {
                return @as(*const IDCompositionScaleTransform3D.VTable, @ptrCast(self.vtable)).SetScaleY(@as(*const IDCompositionScaleTransform3D, @ptrCast(self)), scaleY);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform3D_SetScaleZ(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionScaleTransform3D.VTable, @ptrCast(self.vtable)).SetScaleZ(@as(*const IDCompositionScaleTransform3D, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform3D_SetScaleZ1(self: *const T, scaleZ: f32) HRESULT {
                return @as(*const IDCompositionScaleTransform3D.VTable, @ptrCast(self.vtable)).SetScaleZ(@as(*const IDCompositionScaleTransform3D, @ptrCast(self)), scaleZ);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform3D_SetCenterX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionScaleTransform3D.VTable, @ptrCast(self.vtable)).SetCenterX(@as(*const IDCompositionScaleTransform3D, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform3D_SetCenterX1(self: *const T, centerX: f32) HRESULT {
                return @as(*const IDCompositionScaleTransform3D.VTable, @ptrCast(self.vtable)).SetCenterX(@as(*const IDCompositionScaleTransform3D, @ptrCast(self)), centerX);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform3D_SetCenterY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionScaleTransform3D.VTable, @ptrCast(self.vtable)).SetCenterY(@as(*const IDCompositionScaleTransform3D, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform3D_SetCenterY1(self: *const T, centerY: f32) HRESULT {
                return @as(*const IDCompositionScaleTransform3D.VTable, @ptrCast(self.vtable)).SetCenterY(@as(*const IDCompositionScaleTransform3D, @ptrCast(self)), centerY);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform3D_SetCenterZ(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionScaleTransform3D.VTable, @ptrCast(self.vtable)).SetCenterZ(@as(*const IDCompositionScaleTransform3D, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionScaleTransform3D_SetCenterZ1(self: *const T, centerZ: f32) HRESULT {
                return @as(*const IDCompositionScaleTransform3D.VTable, @ptrCast(self.vtable)).SetCenterZ(@as(*const IDCompositionScaleTransform3D, @ptrCast(self)), centerZ);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionRotateTransform3D_Value = Guid.initString("d8f5b23f-d429-4a91-b55a-d2f45fd75b18");
pub const IID_IDCompositionRotateTransform3D = &IID_IDCompositionRotateTransform3D_Value;
pub const IDCompositionRotateTransform3D = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionTransform3D.VTable,
        SetAngle: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAngle1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform3D,
                angle: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform3D,
                angle: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAxisX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAxisX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform3D,
                axisX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform3D,
                axisX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAxisY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAxisY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform3D,
                axisY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform3D,
                axisY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAxisZ: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAxisZ1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform3D,
                axisZ: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform3D,
                axisZ: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform3D,
                centerX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform3D,
                centerX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform3D,
                centerY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform3D,
                centerY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterZ: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform3D,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCenterZ1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRotateTransform3D,
                centerZ: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRotateTransform3D,
                centerZ: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionTransform3D.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform3D_SetAngle(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRotateTransform3D.VTable, @ptrCast(self.vtable)).SetAngle(@as(*const IDCompositionRotateTransform3D, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform3D_SetAngle1(self: *const T, angle: f32) HRESULT {
                return @as(*const IDCompositionRotateTransform3D.VTable, @ptrCast(self.vtable)).SetAngle(@as(*const IDCompositionRotateTransform3D, @ptrCast(self)), angle);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform3D_SetAxisX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRotateTransform3D.VTable, @ptrCast(self.vtable)).SetAxisX(@as(*const IDCompositionRotateTransform3D, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform3D_SetAxisX1(self: *const T, axisX: f32) HRESULT {
                return @as(*const IDCompositionRotateTransform3D.VTable, @ptrCast(self.vtable)).SetAxisX(@as(*const IDCompositionRotateTransform3D, @ptrCast(self)), axisX);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform3D_SetAxisY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRotateTransform3D.VTable, @ptrCast(self.vtable)).SetAxisY(@as(*const IDCompositionRotateTransform3D, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform3D_SetAxisY1(self: *const T, axisY: f32) HRESULT {
                return @as(*const IDCompositionRotateTransform3D.VTable, @ptrCast(self.vtable)).SetAxisY(@as(*const IDCompositionRotateTransform3D, @ptrCast(self)), axisY);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform3D_SetAxisZ(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRotateTransform3D.VTable, @ptrCast(self.vtable)).SetAxisZ(@as(*const IDCompositionRotateTransform3D, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform3D_SetAxisZ1(self: *const T, axisZ: f32) HRESULT {
                return @as(*const IDCompositionRotateTransform3D.VTable, @ptrCast(self.vtable)).SetAxisZ(@as(*const IDCompositionRotateTransform3D, @ptrCast(self)), axisZ);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform3D_SetCenterX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRotateTransform3D.VTable, @ptrCast(self.vtable)).SetCenterX(@as(*const IDCompositionRotateTransform3D, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform3D_SetCenterX1(self: *const T, centerX: f32) HRESULT {
                return @as(*const IDCompositionRotateTransform3D.VTable, @ptrCast(self.vtable)).SetCenterX(@as(*const IDCompositionRotateTransform3D, @ptrCast(self)), centerX);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform3D_SetCenterY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRotateTransform3D.VTable, @ptrCast(self.vtable)).SetCenterY(@as(*const IDCompositionRotateTransform3D, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform3D_SetCenterY1(self: *const T, centerY: f32) HRESULT {
                return @as(*const IDCompositionRotateTransform3D.VTable, @ptrCast(self.vtable)).SetCenterY(@as(*const IDCompositionRotateTransform3D, @ptrCast(self)), centerY);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform3D_SetCenterZ(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRotateTransform3D.VTable, @ptrCast(self.vtable)).SetCenterZ(@as(*const IDCompositionRotateTransform3D, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRotateTransform3D_SetCenterZ1(self: *const T, centerZ: f32) HRESULT {
                return @as(*const IDCompositionRotateTransform3D.VTable, @ptrCast(self.vtable)).SetCenterZ(@as(*const IDCompositionRotateTransform3D, @ptrCast(self)), centerZ);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionMatrixTransform3D_Value = Guid.initString("4b3363f0-643b-41b7-b6e0-ccf22d34467c");
pub const IID_IDCompositionMatrixTransform3D = &IID_IDCompositionMatrixTransform3D_Value;
pub const IDCompositionMatrixTransform3D = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionTransform3D.VTable,
        SetMatrix: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionMatrixTransform3D,
                matrix: ?*const D3DMATRIX,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionMatrixTransform3D,
                matrix: ?*const D3DMATRIX,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetMatrixElement: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionMatrixTransform3D,
                row: i32,
                column: i32,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionMatrixTransform3D,
                row: i32,
                column: i32,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetMatrixElement1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionMatrixTransform3D,
                row: i32,
                column: i32,
                value: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionMatrixTransform3D,
                row: i32,
                column: i32,
                value: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionTransform3D.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionMatrixTransform3D_SetMatrix(self: *const T, matrix: ?*const D3DMATRIX) HRESULT {
                return @as(*const IDCompositionMatrixTransform3D.VTable, @ptrCast(self.vtable)).SetMatrix(@as(*const IDCompositionMatrixTransform3D, @ptrCast(self)), matrix);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionMatrixTransform3D_SetMatrixElement(self: *const T, row: i32, column: i32, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionMatrixTransform3D.VTable, @ptrCast(self.vtable)).SetMatrixElement(@as(*const IDCompositionMatrixTransform3D, @ptrCast(self)), row, column, animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionMatrixTransform3D_SetMatrixElement1(self: *const T, row: i32, column: i32, value: f32) HRESULT {
                return @as(*const IDCompositionMatrixTransform3D.VTable, @ptrCast(self.vtable)).SetMatrixElement(@as(*const IDCompositionMatrixTransform3D, @ptrCast(self)), row, column, value);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionClip_Value = Guid.initString("64ac3703-9d3f-45ec-a109-7cac0e7a13a7");
pub const IID_IDCompositionClip = &IID_IDCompositionClip_Value;
pub const IDCompositionClip = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionRectangleClip_Value = Guid.initString("9842ad7d-d9cf-4908-aed7-48b51da5e7c2");
pub const IID_IDCompositionRectangleClip = &IID_IDCompositionRectangleClip_Value;
pub const IDCompositionRectangleClip = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionClip.VTable,
        SetLeft: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetLeft1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                left: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                left: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTop: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTop1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                top: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                top: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetRight: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetRight1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                right: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                right: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBottom: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBottom1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                bottom: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                bottom: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTopLeftRadiusX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTopLeftRadiusX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                radius: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                radius: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTopLeftRadiusY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTopLeftRadiusY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                radius: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                radius: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTopRightRadiusX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTopRightRadiusX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                radius: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                radius: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTopRightRadiusY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTopRightRadiusY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                radius: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                radius: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBottomLeftRadiusX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBottomLeftRadiusX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                radius: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                radius: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBottomLeftRadiusY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBottomLeftRadiusY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                radius: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                radius: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBottomRightRadiusX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBottomRightRadiusX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                radius: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                radius: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBottomRightRadiusY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBottomRightRadiusY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionRectangleClip,
                radius: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionRectangleClip,
                radius: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionClip.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetLeft(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetLeft(@as(*const IDCompositionRectangleClip, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetLeft1(self: *const T, left: f32) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetLeft(@as(*const IDCompositionRectangleClip, @ptrCast(self)), left);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetTop(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetTop(@as(*const IDCompositionRectangleClip, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetTop1(self: *const T, top: f32) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetTop(@as(*const IDCompositionRectangleClip, @ptrCast(self)), top);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetRight(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetRight(@as(*const IDCompositionRectangleClip, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetRight1(self: *const T, right: f32) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetRight(@as(*const IDCompositionRectangleClip, @ptrCast(self)), right);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetBottom(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetBottom(@as(*const IDCompositionRectangleClip, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetBottom1(self: *const T, bottom: f32) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetBottom(@as(*const IDCompositionRectangleClip, @ptrCast(self)), bottom);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetTopLeftRadiusX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetTopLeftRadiusX(@as(*const IDCompositionRectangleClip, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetTopLeftRadiusX1(self: *const T, radius: f32) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetTopLeftRadiusX(@as(*const IDCompositionRectangleClip, @ptrCast(self)), radius);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetTopLeftRadiusY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetTopLeftRadiusY(@as(*const IDCompositionRectangleClip, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetTopLeftRadiusY1(self: *const T, radius: f32) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetTopLeftRadiusY(@as(*const IDCompositionRectangleClip, @ptrCast(self)), radius);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetTopRightRadiusX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetTopRightRadiusX(@as(*const IDCompositionRectangleClip, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetTopRightRadiusX1(self: *const T, radius: f32) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetTopRightRadiusX(@as(*const IDCompositionRectangleClip, @ptrCast(self)), radius);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetTopRightRadiusY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetTopRightRadiusY(@as(*const IDCompositionRectangleClip, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetTopRightRadiusY1(self: *const T, radius: f32) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetTopRightRadiusY(@as(*const IDCompositionRectangleClip, @ptrCast(self)), radius);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetBottomLeftRadiusX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetBottomLeftRadiusX(@as(*const IDCompositionRectangleClip, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetBottomLeftRadiusX1(self: *const T, radius: f32) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetBottomLeftRadiusX(@as(*const IDCompositionRectangleClip, @ptrCast(self)), radius);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetBottomLeftRadiusY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetBottomLeftRadiusY(@as(*const IDCompositionRectangleClip, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetBottomLeftRadiusY1(self: *const T, radius: f32) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetBottomLeftRadiusY(@as(*const IDCompositionRectangleClip, @ptrCast(self)), radius);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetBottomRightRadiusX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetBottomRightRadiusX(@as(*const IDCompositionRectangleClip, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetBottomRightRadiusX1(self: *const T, radius: f32) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetBottomRightRadiusX(@as(*const IDCompositionRectangleClip, @ptrCast(self)), radius);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetBottomRightRadiusY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetBottomRightRadiusY(@as(*const IDCompositionRectangleClip, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionRectangleClip_SetBottomRightRadiusY1(self: *const T, radius: f32) HRESULT {
                return @as(*const IDCompositionRectangleClip.VTable, @ptrCast(self.vtable)).SetBottomRightRadiusY(@as(*const IDCompositionRectangleClip, @ptrCast(self)), radius);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionSurface_Value = Guid.initString("bb8a4953-2c99-4f5a-96f5-4819027fa3ac");
pub const IID_IDCompositionSurface = &IID_IDCompositionSurface_Value;
pub const IDCompositionSurface = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        BeginDraw: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSurface,
                updateRect: ?*const RECT,
                iid: ?*const Guid,
                updateObject: ?*?*anyopaque,
                updateOffset: ?*POINT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSurface,
                updateRect: ?*const RECT,
                iid: ?*const Guid,
                updateObject: ?*?*anyopaque,
                updateOffset: ?*POINT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EndDraw: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SuspendDraw: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ResumeDraw: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Scroll: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSurface,
                scrollRect: ?*const RECT,
                clipRect: ?*const RECT,
                offsetX: i32,
                offsetY: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSurface,
                scrollRect: ?*const RECT,
                clipRect: ?*const RECT,
                offsetX: i32,
                offsetY: i32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSurface_BeginDraw(self: *const T, updateRect: ?*const RECT, iid: ?*const Guid, updateObject: ?*?*anyopaque, updateOffset: ?*POINT) HRESULT {
                return @as(*const IDCompositionSurface.VTable, @ptrCast(self.vtable)).BeginDraw(@as(*const IDCompositionSurface, @ptrCast(self)), updateRect, iid, updateObject, updateOffset);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSurface_EndDraw(self: *const T) HRESULT {
                return @as(*const IDCompositionSurface.VTable, @ptrCast(self.vtable)).EndDraw(@as(*const IDCompositionSurface, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSurface_SuspendDraw(self: *const T) HRESULT {
                return @as(*const IDCompositionSurface.VTable, @ptrCast(self.vtable)).SuspendDraw(@as(*const IDCompositionSurface, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSurface_ResumeDraw(self: *const T) HRESULT {
                return @as(*const IDCompositionSurface.VTable, @ptrCast(self.vtable)).ResumeDraw(@as(*const IDCompositionSurface, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSurface_Scroll(self: *const T, scrollRect: ?*const RECT, clipRect: ?*const RECT, offsetX: i32, offsetY: i32) HRESULT {
                return @as(*const IDCompositionSurface.VTable, @ptrCast(self.vtable)).Scroll(@as(*const IDCompositionSurface, @ptrCast(self)), scrollRect, clipRect, offsetX, offsetY);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionVirtualSurface_Value = Guid.initString("ae471c51-5f53-4a24-8d3e-d0c39c30b3f0");
pub const IID_IDCompositionVirtualSurface = &IID_IDCompositionVirtualSurface_Value;
pub const IDCompositionVirtualSurface = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionSurface.VTable,
        Resize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVirtualSurface,
                width: u32,
                height: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVirtualSurface,
                width: u32,
                height: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Trim: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVirtualSurface,
                rectangles: ?[*]const RECT,
                count: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVirtualSurface,
                rectangles: ?[*]const RECT,
                count: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionSurface.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVirtualSurface_Resize(self: *const T, width: u32, height: u32) HRESULT {
                return @as(*const IDCompositionVirtualSurface.VTable, @ptrCast(self.vtable)).Resize(@as(*const IDCompositionVirtualSurface, @ptrCast(self)), width, height);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVirtualSurface_Trim(self: *const T, rectangles: ?[*]const RECT, count: u32) HRESULT {
                return @as(*const IDCompositionVirtualSurface.VTable, @ptrCast(self.vtable)).Trim(@as(*const IDCompositionVirtualSurface, @ptrCast(self)), rectangles, count);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.1'
const IID_IDCompositionDevice2_Value = Guid.initString("75f6468d-1b8e-447c-9bc6-75fea80b5b25");
pub const IID_IDCompositionDevice2 = &IID_IDCompositionDevice2_Value;
pub const IDCompositionDevice2 = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Commit: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        WaitForCommitCompletion: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetFrameStatistics: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                statistics: ?*DCOMPOSITION_FRAME_STATISTICS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                statistics: ?*DCOMPOSITION_FRAME_STATISTICS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateVisual: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                visual: ?*?*IDCompositionVisual2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                visual: ?*?*IDCompositionVisual2,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateSurfaceFactory: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                renderingDevice: ?*IUnknown,
                surfaceFactory: ?*?*IDCompositionSurfaceFactory,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                renderingDevice: ?*IUnknown,
                surfaceFactory: ?*?*IDCompositionSurfaceFactory,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateSurface: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                width: u32,
                height: u32,
                pixelFormat: DXGI_FORMAT,
                alphaMode: DXGI_ALPHA_MODE,
                surface: ?*?*IDCompositionSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                width: u32,
                height: u32,
                pixelFormat: DXGI_FORMAT,
                alphaMode: DXGI_ALPHA_MODE,
                surface: ?*?*IDCompositionSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateVirtualSurface: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                initialWidth: u32,
                initialHeight: u32,
                pixelFormat: DXGI_FORMAT,
                alphaMode: DXGI_ALPHA_MODE,
                virtualSurface: ?*?*IDCompositionVirtualSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                initialWidth: u32,
                initialHeight: u32,
                pixelFormat: DXGI_FORMAT,
                alphaMode: DXGI_ALPHA_MODE,
                virtualSurface: ?*?*IDCompositionVirtualSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateTranslateTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                translateTransform: ?*?*IDCompositionTranslateTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                translateTransform: ?*?*IDCompositionTranslateTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateScaleTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                scaleTransform: ?*?*IDCompositionScaleTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                scaleTransform: ?*?*IDCompositionScaleTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateRotateTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                rotateTransform: ?*?*IDCompositionRotateTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                rotateTransform: ?*?*IDCompositionRotateTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateSkewTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                skewTransform: ?*?*IDCompositionSkewTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                skewTransform: ?*?*IDCompositionSkewTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateMatrixTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                matrixTransform: ?*?*IDCompositionMatrixTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                matrixTransform: ?*?*IDCompositionMatrixTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateTransformGroup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                transforms: [*]?*IDCompositionTransform,
                elements: u32,
                transformGroup: ?*?*IDCompositionTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                transforms: [*]?*IDCompositionTransform,
                elements: u32,
                transformGroup: ?*?*IDCompositionTransform,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateTranslateTransform3D: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                translateTransform3D: ?*?*IDCompositionTranslateTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                translateTransform3D: ?*?*IDCompositionTranslateTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateScaleTransform3D: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                scaleTransform3D: ?*?*IDCompositionScaleTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                scaleTransform3D: ?*?*IDCompositionScaleTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateRotateTransform3D: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                rotateTransform3D: ?*?*IDCompositionRotateTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                rotateTransform3D: ?*?*IDCompositionRotateTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateMatrixTransform3D: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                matrixTransform3D: ?*?*IDCompositionMatrixTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                matrixTransform3D: ?*?*IDCompositionMatrixTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateTransform3DGroup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                transforms3D: [*]?*IDCompositionTransform3D,
                elements: u32,
                transform3DGroup: ?*?*IDCompositionTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                transforms3D: [*]?*IDCompositionTransform3D,
                elements: u32,
                transform3DGroup: ?*?*IDCompositionTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateEffectGroup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                effectGroup: ?*?*IDCompositionEffectGroup,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                effectGroup: ?*?*IDCompositionEffectGroup,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateRectangleClip: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                clip: ?*?*IDCompositionRectangleClip,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                clip: ?*?*IDCompositionRectangleClip,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateAnimation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice2,
                animation: ?*?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice2,
                animation: ?*?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_Commit(self: *const T) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).Commit(@as(*const IDCompositionDevice2, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_WaitForCommitCompletion(self: *const T) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).WaitForCommitCompletion(@as(*const IDCompositionDevice2, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_GetFrameStatistics(self: *const T, statistics: ?*DCOMPOSITION_FRAME_STATISTICS) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).GetFrameStatistics(@as(*const IDCompositionDevice2, @ptrCast(self)), statistics);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateVisual(self: *const T, visual: ?*?*IDCompositionVisual2) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateVisual(@as(*const IDCompositionDevice2, @ptrCast(self)), visual);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateSurfaceFactory(self: *const T, renderingDevice: ?*IUnknown, surfaceFactory: ?*?*IDCompositionSurfaceFactory) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateSurfaceFactory(@as(*const IDCompositionDevice2, @ptrCast(self)), renderingDevice, surfaceFactory);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateSurface(self: *const T, width: u32, height: u32, pixelFormat: DXGI_FORMAT, alphaMode: DXGI_ALPHA_MODE, surface: ?*?*IDCompositionSurface) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateSurface(@as(*const IDCompositionDevice2, @ptrCast(self)), width, height, pixelFormat, alphaMode, surface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateVirtualSurface(self: *const T, initialWidth: u32, initialHeight: u32, pixelFormat: DXGI_FORMAT, alphaMode: DXGI_ALPHA_MODE, virtualSurface: ?*?*IDCompositionVirtualSurface) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateVirtualSurface(@as(*const IDCompositionDevice2, @ptrCast(self)), initialWidth, initialHeight, pixelFormat, alphaMode, virtualSurface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateTranslateTransform(self: *const T, translateTransform: ?*?*IDCompositionTranslateTransform) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateTranslateTransform(@as(*const IDCompositionDevice2, @ptrCast(self)), translateTransform);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateScaleTransform(self: *const T, scaleTransform: ?*?*IDCompositionScaleTransform) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateScaleTransform(@as(*const IDCompositionDevice2, @ptrCast(self)), scaleTransform);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateRotateTransform(self: *const T, rotateTransform: ?*?*IDCompositionRotateTransform) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateRotateTransform(@as(*const IDCompositionDevice2, @ptrCast(self)), rotateTransform);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateSkewTransform(self: *const T, skewTransform: ?*?*IDCompositionSkewTransform) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateSkewTransform(@as(*const IDCompositionDevice2, @ptrCast(self)), skewTransform);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateMatrixTransform(self: *const T, matrixTransform: ?*?*IDCompositionMatrixTransform) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateMatrixTransform(@as(*const IDCompositionDevice2, @ptrCast(self)), matrixTransform);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateTransformGroup(self: *const T, transforms: [*]?*IDCompositionTransform, elements: u32, transformGroup: ?*?*IDCompositionTransform) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateTransformGroup(@as(*const IDCompositionDevice2, @ptrCast(self)), transforms, elements, transformGroup);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateTranslateTransform3D(self: *const T, translateTransform3D: ?*?*IDCompositionTranslateTransform3D) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateTranslateTransform3D(@as(*const IDCompositionDevice2, @ptrCast(self)), translateTransform3D);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateScaleTransform3D(self: *const T, scaleTransform3D: ?*?*IDCompositionScaleTransform3D) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateScaleTransform3D(@as(*const IDCompositionDevice2, @ptrCast(self)), scaleTransform3D);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateRotateTransform3D(self: *const T, rotateTransform3D: ?*?*IDCompositionRotateTransform3D) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateRotateTransform3D(@as(*const IDCompositionDevice2, @ptrCast(self)), rotateTransform3D);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateMatrixTransform3D(self: *const T, matrixTransform3D: ?*?*IDCompositionMatrixTransform3D) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateMatrixTransform3D(@as(*const IDCompositionDevice2, @ptrCast(self)), matrixTransform3D);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateTransform3DGroup(self: *const T, transforms3D: [*]?*IDCompositionTransform3D, elements: u32, transform3DGroup: ?*?*IDCompositionTransform3D) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateTransform3DGroup(@as(*const IDCompositionDevice2, @ptrCast(self)), transforms3D, elements, transform3DGroup);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateEffectGroup(self: *const T, effectGroup: ?*?*IDCompositionEffectGroup) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateEffectGroup(@as(*const IDCompositionDevice2, @ptrCast(self)), effectGroup);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateRectangleClip(self: *const T, clip: ?*?*IDCompositionRectangleClip) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateRectangleClip(@as(*const IDCompositionDevice2, @ptrCast(self)), clip);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice2_CreateAnimation(self: *const T, animation: ?*?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionDevice2.VTable, @ptrCast(self.vtable)).CreateAnimation(@as(*const IDCompositionDevice2, @ptrCast(self)), animation);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.1'
const IID_IDCompositionDesktopDevice_Value = Guid.initString("5f4633fe-1e08-4cb8-8c75-ce24333f5602");
pub const IID_IDCompositionDesktopDevice = &IID_IDCompositionDesktopDevice_Value;
pub const IDCompositionDesktopDevice = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionDevice2.VTable,
        CreateTargetForHwnd: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDesktopDevice,
                hwnd: ?HWND,
                topmost: BOOL,
                target: ?*?*IDCompositionTarget,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDesktopDevice,
                hwnd: ?HWND,
                topmost: BOOL,
                target: ?*?*IDCompositionTarget,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateSurfaceFromHandle: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDesktopDevice,
                handle: ?HANDLE,
                surface: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDesktopDevice,
                handle: ?HANDLE,
                surface: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateSurfaceFromHwnd: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDesktopDevice,
                hwnd: ?HWND,
                surface: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDesktopDevice,
                hwnd: ?HWND,
                surface: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionDevice2.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDesktopDevice_CreateTargetForHwnd(self: *const T, hwnd: ?HWND, topmost: BOOL, target: ?*?*IDCompositionTarget) HRESULT {
                return @as(*const IDCompositionDesktopDevice.VTable, @ptrCast(self.vtable)).CreateTargetForHwnd(@as(*const IDCompositionDesktopDevice, @ptrCast(self)), hwnd, topmost, target);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDesktopDevice_CreateSurfaceFromHandle(self: *const T, handle: ?HANDLE, surface: ?*?*IUnknown) HRESULT {
                return @as(*const IDCompositionDesktopDevice.VTable, @ptrCast(self.vtable)).CreateSurfaceFromHandle(@as(*const IDCompositionDesktopDevice, @ptrCast(self)), handle, surface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDesktopDevice_CreateSurfaceFromHwnd(self: *const T, hwnd: ?HWND, surface: ?*?*IUnknown) HRESULT {
                return @as(*const IDCompositionDesktopDevice.VTable, @ptrCast(self.vtable)).CreateSurfaceFromHwnd(@as(*const IDCompositionDesktopDevice, @ptrCast(self)), hwnd, surface);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDCompositionDeviceDebug_Value = Guid.initString("a1a3c64a-224f-4a81-9773-4f03a89d3c6c");
pub const IID_IDCompositionDeviceDebug = &IID_IDCompositionDeviceDebug_Value;
pub const IDCompositionDeviceDebug = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        EnableDebugCounters: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDeviceDebug,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDeviceDebug,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DisableDebugCounters: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDeviceDebug,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDeviceDebug,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDeviceDebug_EnableDebugCounters(self: *const T) HRESULT {
                return @as(*const IDCompositionDeviceDebug.VTable, @ptrCast(self.vtable)).EnableDebugCounters(@as(*const IDCompositionDeviceDebug, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDeviceDebug_DisableDebugCounters(self: *const T) HRESULT {
                return @as(*const IDCompositionDeviceDebug.VTable, @ptrCast(self.vtable)).DisableDebugCounters(@as(*const IDCompositionDeviceDebug, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.1'
const IID_IDCompositionSurfaceFactory_Value = Guid.initString("e334bc12-3937-4e02-85eb-fcf4eb30d2c8");
pub const IID_IDCompositionSurfaceFactory = &IID_IDCompositionSurfaceFactory_Value;
pub const IDCompositionSurfaceFactory = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        CreateSurface: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSurfaceFactory,
                width: u32,
                height: u32,
                pixelFormat: DXGI_FORMAT,
                alphaMode: DXGI_ALPHA_MODE,
                surface: ?*?*IDCompositionSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSurfaceFactory,
                width: u32,
                height: u32,
                pixelFormat: DXGI_FORMAT,
                alphaMode: DXGI_ALPHA_MODE,
                surface: ?*?*IDCompositionSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateVirtualSurface: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSurfaceFactory,
                initialWidth: u32,
                initialHeight: u32,
                pixelFormat: DXGI_FORMAT,
                alphaMode: DXGI_ALPHA_MODE,
                virtualSurface: ?*?*IDCompositionVirtualSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSurfaceFactory,
                initialWidth: u32,
                initialHeight: u32,
                pixelFormat: DXGI_FORMAT,
                alphaMode: DXGI_ALPHA_MODE,
                virtualSurface: ?*?*IDCompositionVirtualSurface,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSurfaceFactory_CreateSurface(self: *const T, width: u32, height: u32, pixelFormat: DXGI_FORMAT, alphaMode: DXGI_ALPHA_MODE, surface: ?*?*IDCompositionSurface) HRESULT {
                return @as(*const IDCompositionSurfaceFactory.VTable, @ptrCast(self.vtable)).CreateSurface(@as(*const IDCompositionSurfaceFactory, @ptrCast(self)), width, height, pixelFormat, alphaMode, surface);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSurfaceFactory_CreateVirtualSurface(self: *const T, initialWidth: u32, initialHeight: u32, pixelFormat: DXGI_FORMAT, alphaMode: DXGI_ALPHA_MODE, virtualSurface: ?*?*IDCompositionVirtualSurface) HRESULT {
                return @as(*const IDCompositionSurfaceFactory.VTable, @ptrCast(self.vtable)).CreateVirtualSurface(@as(*const IDCompositionSurfaceFactory, @ptrCast(self)), initialWidth, initialHeight, pixelFormat, alphaMode, virtualSurface);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.1'
const IID_IDCompositionVisual2_Value = Guid.initString("e8de1639-4331-4b26-bc5f-6a321d347a85");
pub const IID_IDCompositionVisual2 = &IID_IDCompositionVisual2_Value;
pub const IDCompositionVisual2 = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionVisual.VTable,
        SetOpacityMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual2,
                mode: DCOMPOSITION_OPACITY_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual2,
                mode: DCOMPOSITION_OPACITY_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBackFaceVisibility: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual2,
                visibility: DCOMPOSITION_BACKFACE_VISIBILITY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual2,
                visibility: DCOMPOSITION_BACKFACE_VISIBILITY,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionVisual.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual2_SetOpacityMode(self: *const T, mode: DCOMPOSITION_OPACITY_MODE) HRESULT {
                return @as(*const IDCompositionVisual2.VTable, @ptrCast(self.vtable)).SetOpacityMode(@as(*const IDCompositionVisual2, @ptrCast(self)), mode);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual2_SetBackFaceVisibility(self: *const T, visibility: DCOMPOSITION_BACKFACE_VISIBILITY) HRESULT {
                return @as(*const IDCompositionVisual2.VTable, @ptrCast(self.vtable)).SetBackFaceVisibility(@as(*const IDCompositionVisual2, @ptrCast(self)), visibility);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.1'
const IID_IDCompositionVisualDebug_Value = Guid.initString("fed2b808-5eb4-43a0-aea3-35f65280f91b");
pub const IID_IDCompositionVisualDebug = &IID_IDCompositionVisualDebug_Value;
pub const IDCompositionVisualDebug = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionVisual2.VTable,
        EnableHeatMap: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisualDebug,
                color: ?*const D2D1_COLOR_F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisualDebug,
                color: ?*const D2D1_COLOR_F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DisableHeatMap: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisualDebug,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisualDebug,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EnableRedrawRegions: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisualDebug,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisualDebug,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        DisableRedrawRegions: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisualDebug,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisualDebug,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionVisual2.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisualDebug_EnableHeatMap(self: *const T, color: ?*const D2D1_COLOR_F) HRESULT {
                return @as(*const IDCompositionVisualDebug.VTable, @ptrCast(self.vtable)).EnableHeatMap(@as(*const IDCompositionVisualDebug, @ptrCast(self)), color);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisualDebug_DisableHeatMap(self: *const T) HRESULT {
                return @as(*const IDCompositionVisualDebug.VTable, @ptrCast(self.vtable)).DisableHeatMap(@as(*const IDCompositionVisualDebug, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisualDebug_EnableRedrawRegions(self: *const T) HRESULT {
                return @as(*const IDCompositionVisualDebug.VTable, @ptrCast(self.vtable)).EnableRedrawRegions(@as(*const IDCompositionVisualDebug, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisualDebug_DisableRedrawRegions(self: *const T) HRESULT {
                return @as(*const IDCompositionVisualDebug.VTable, @ptrCast(self.vtable)).DisableRedrawRegions(@as(*const IDCompositionVisualDebug, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.1'
const IID_IDCompositionVisual3_Value = Guid.initString("2775f462-b6c1-4015-b0be-b3e7d6a4976d");
pub const IID_IDCompositionVisual3 = &IID_IDCompositionVisual3_Value;
pub const IDCompositionVisual3 = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionVisualDebug.VTable,
        SetDepthMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual3,
                mode: DCOMPOSITION_DEPTH_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual3,
                mode: DCOMPOSITION_DEPTH_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOffsetZ: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual3,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual3,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOffsetZ1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual3,
                offsetZ: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual3,
                offsetZ: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOpacity: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual3,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual3,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOpacity1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual3,
                opacity: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual3,
                opacity: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTransform: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual3,
                transform: ?*IDCompositionTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual3,
                transform: ?*IDCompositionTransform3D,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTransform1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual3,
                matrix: ?*const D2D_MATRIX_4X4_F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual3,
                matrix: ?*const D2D_MATRIX_4X4_F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetVisible: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionVisual3,
                visible: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionVisual3,
                visible: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionVisualDebug.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual3_SetDepthMode(self: *const T, mode: DCOMPOSITION_DEPTH_MODE) HRESULT {
                return @as(*const IDCompositionVisual3.VTable, @ptrCast(self.vtable)).SetDepthMode(@as(*const IDCompositionVisual3, @ptrCast(self)), mode);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual3_SetOffsetZ(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionVisual3.VTable, @ptrCast(self.vtable)).SetOffsetZ(@as(*const IDCompositionVisual3, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual3_SetOffsetZ1(self: *const T, offsetZ: f32) HRESULT {
                return @as(*const IDCompositionVisual3.VTable, @ptrCast(self.vtable)).SetOffsetZ(@as(*const IDCompositionVisual3, @ptrCast(self)), offsetZ);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual3_SetOpacity(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionVisual3.VTable, @ptrCast(self.vtable)).SetOpacity(@as(*const IDCompositionVisual3, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual3_SetOpacity1(self: *const T, opacity: f32) HRESULT {
                return @as(*const IDCompositionVisual3.VTable, @ptrCast(self.vtable)).SetOpacity(@as(*const IDCompositionVisual3, @ptrCast(self)), opacity);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual3_SetTransform(self: *const T, transform: ?*IDCompositionTransform3D) HRESULT {
                return @as(*const IDCompositionVisual3.VTable, @ptrCast(self.vtable)).SetTransform(@as(*const IDCompositionVisual3, @ptrCast(self)), transform);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual3_SetTransform1(self: *const T, matrix: ?*const D2D_MATRIX_4X4_F) HRESULT {
                return @as(*const IDCompositionVisual3.VTable, @ptrCast(self.vtable)).SetTransform(@as(*const IDCompositionVisual3, @ptrCast(self)), matrix);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionVisual3_SetVisible(self: *const T, visible: BOOL) HRESULT {
                return @as(*const IDCompositionVisual3.VTable, @ptrCast(self.vtable)).SetVisible(@as(*const IDCompositionVisual3, @ptrCast(self)), visible);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.1'
const IID_IDCompositionDevice3_Value = Guid.initString("0987cb06-f916-48bf-8d35-ce7641781bd9");
pub const IID_IDCompositionDevice3 = &IID_IDCompositionDevice3_Value;
pub const IDCompositionDevice3 = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionDevice2.VTable,
        CreateGaussianBlurEffect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice3,
                gaussianBlurEffect: ?*?*IDCompositionGaussianBlurEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice3,
                gaussianBlurEffect: ?*?*IDCompositionGaussianBlurEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateBrightnessEffect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice3,
                brightnessEffect: ?*?*IDCompositionBrightnessEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice3,
                brightnessEffect: ?*?*IDCompositionBrightnessEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateColorMatrixEffect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice3,
                colorMatrixEffect: ?*?*IDCompositionColorMatrixEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice3,
                colorMatrixEffect: ?*?*IDCompositionColorMatrixEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateShadowEffect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice3,
                shadowEffect: ?*?*IDCompositionShadowEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice3,
                shadowEffect: ?*?*IDCompositionShadowEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateHueRotationEffect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice3,
                hueRotationEffect: ?*?*IDCompositionHueRotationEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice3,
                hueRotationEffect: ?*?*IDCompositionHueRotationEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateSaturationEffect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice3,
                saturationEffect: ?*?*IDCompositionSaturationEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice3,
                saturationEffect: ?*?*IDCompositionSaturationEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateTurbulenceEffect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice3,
                turbulenceEffect: ?*?*IDCompositionTurbulenceEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice3,
                turbulenceEffect: ?*?*IDCompositionTurbulenceEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateLinearTransferEffect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice3,
                linearTransferEffect: ?*?*IDCompositionLinearTransferEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice3,
                linearTransferEffect: ?*?*IDCompositionLinearTransferEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateTableTransferEffect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice3,
                tableTransferEffect: ?*?*IDCompositionTableTransferEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice3,
                tableTransferEffect: ?*?*IDCompositionTableTransferEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateCompositeEffect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice3,
                compositeEffect: ?*?*IDCompositionCompositeEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice3,
                compositeEffect: ?*?*IDCompositionCompositeEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateBlendEffect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice3,
                blendEffect: ?*?*IDCompositionBlendEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice3,
                blendEffect: ?*?*IDCompositionBlendEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateArithmeticCompositeEffect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice3,
                arithmeticCompositeEffect: ?*?*IDCompositionArithmeticCompositeEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice3,
                arithmeticCompositeEffect: ?*?*IDCompositionArithmeticCompositeEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateAffineTransform2DEffect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDevice3,
                affineTransform2dEffect: ?*?*IDCompositionAffineTransform2DEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDevice3,
                affineTransform2dEffect: ?*?*IDCompositionAffineTransform2DEffect,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionDevice2.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice3_CreateGaussianBlurEffect(self: *const T, gaussianBlurEffect: ?*?*IDCompositionGaussianBlurEffect) HRESULT {
                return @as(*const IDCompositionDevice3.VTable, @ptrCast(self.vtable)).CreateGaussianBlurEffect(@as(*const IDCompositionDevice3, @ptrCast(self)), gaussianBlurEffect);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice3_CreateBrightnessEffect(self: *const T, brightnessEffect: ?*?*IDCompositionBrightnessEffect) HRESULT {
                return @as(*const IDCompositionDevice3.VTable, @ptrCast(self.vtable)).CreateBrightnessEffect(@as(*const IDCompositionDevice3, @ptrCast(self)), brightnessEffect);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice3_CreateColorMatrixEffect(self: *const T, colorMatrixEffect: ?*?*IDCompositionColorMatrixEffect) HRESULT {
                return @as(*const IDCompositionDevice3.VTable, @ptrCast(self.vtable)).CreateColorMatrixEffect(@as(*const IDCompositionDevice3, @ptrCast(self)), colorMatrixEffect);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice3_CreateShadowEffect(self: *const T, shadowEffect: ?*?*IDCompositionShadowEffect) HRESULT {
                return @as(*const IDCompositionDevice3.VTable, @ptrCast(self.vtable)).CreateShadowEffect(@as(*const IDCompositionDevice3, @ptrCast(self)), shadowEffect);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice3_CreateHueRotationEffect(self: *const T, hueRotationEffect: ?*?*IDCompositionHueRotationEffect) HRESULT {
                return @as(*const IDCompositionDevice3.VTable, @ptrCast(self.vtable)).CreateHueRotationEffect(@as(*const IDCompositionDevice3, @ptrCast(self)), hueRotationEffect);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice3_CreateSaturationEffect(self: *const T, saturationEffect: ?*?*IDCompositionSaturationEffect) HRESULT {
                return @as(*const IDCompositionDevice3.VTable, @ptrCast(self.vtable)).CreateSaturationEffect(@as(*const IDCompositionDevice3, @ptrCast(self)), saturationEffect);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice3_CreateTurbulenceEffect(self: *const T, turbulenceEffect: ?*?*IDCompositionTurbulenceEffect) HRESULT {
                return @as(*const IDCompositionDevice3.VTable, @ptrCast(self.vtable)).CreateTurbulenceEffect(@as(*const IDCompositionDevice3, @ptrCast(self)), turbulenceEffect);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice3_CreateLinearTransferEffect(self: *const T, linearTransferEffect: ?*?*IDCompositionLinearTransferEffect) HRESULT {
                return @as(*const IDCompositionDevice3.VTable, @ptrCast(self.vtable)).CreateLinearTransferEffect(@as(*const IDCompositionDevice3, @ptrCast(self)), linearTransferEffect);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice3_CreateTableTransferEffect(self: *const T, tableTransferEffect: ?*?*IDCompositionTableTransferEffect) HRESULT {
                return @as(*const IDCompositionDevice3.VTable, @ptrCast(self.vtable)).CreateTableTransferEffect(@as(*const IDCompositionDevice3, @ptrCast(self)), tableTransferEffect);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice3_CreateCompositeEffect(self: *const T, compositeEffect: ?*?*IDCompositionCompositeEffect) HRESULT {
                return @as(*const IDCompositionDevice3.VTable, @ptrCast(self.vtable)).CreateCompositeEffect(@as(*const IDCompositionDevice3, @ptrCast(self)), compositeEffect);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice3_CreateBlendEffect(self: *const T, blendEffect: ?*?*IDCompositionBlendEffect) HRESULT {
                return @as(*const IDCompositionDevice3.VTable, @ptrCast(self.vtable)).CreateBlendEffect(@as(*const IDCompositionDevice3, @ptrCast(self)), blendEffect);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice3_CreateArithmeticCompositeEffect(self: *const T, arithmeticCompositeEffect: ?*?*IDCompositionArithmeticCompositeEffect) HRESULT {
                return @as(*const IDCompositionDevice3.VTable, @ptrCast(self.vtable)).CreateArithmeticCompositeEffect(@as(*const IDCompositionDevice3, @ptrCast(self)), arithmeticCompositeEffect);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDevice3_CreateAffineTransform2DEffect(self: *const T, affineTransform2dEffect: ?*?*IDCompositionAffineTransform2DEffect) HRESULT {
                return @as(*const IDCompositionDevice3.VTable, @ptrCast(self.vtable)).CreateAffineTransform2DEffect(@as(*const IDCompositionDevice3, @ptrCast(self)), affineTransform2dEffect);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IDCompositionFilterEffect_Value = Guid.initString("30c421d5-8cb2-4e9f-b133-37be270d4ac2");
pub const IID_IDCompositionFilterEffect = &IID_IDCompositionFilterEffect_Value;
pub const IDCompositionFilterEffect = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionEffect.VTable,
        SetInput: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionFilterEffect,
                index: u32,
                input: ?*IUnknown,
                flags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionFilterEffect,
                index: u32,
                input: ?*IUnknown,
                flags: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionEffect.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionFilterEffect_SetInput(self: *const T, index: u32, input: ?*IUnknown, flags: u32) HRESULT {
                return @as(*const IDCompositionFilterEffect.VTable, @ptrCast(self.vtable)).SetInput(@as(*const IDCompositionFilterEffect, @ptrCast(self)), index, input, flags);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDCompositionGaussianBlurEffect_Value = Guid.initString("45d4d0b7-1bd4-454e-8894-2bfa68443033");
pub const IID_IDCompositionGaussianBlurEffect = &IID_IDCompositionGaussianBlurEffect_Value;
pub const IDCompositionGaussianBlurEffect = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionFilterEffect.VTable,
        SetStandardDeviation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionGaussianBlurEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionGaussianBlurEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetStandardDeviation1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionGaussianBlurEffect,
                amount: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionGaussianBlurEffect,
                amount: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBorderMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionGaussianBlurEffect,
                mode: D2D1_BORDER_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionGaussianBlurEffect,
                mode: D2D1_BORDER_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionFilterEffect.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionGaussianBlurEffect_SetStandardDeviation(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionGaussianBlurEffect.VTable, @ptrCast(self.vtable)).SetStandardDeviation(@as(*const IDCompositionGaussianBlurEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionGaussianBlurEffect_SetStandardDeviation1(self: *const T, amount: f32) HRESULT {
                return @as(*const IDCompositionGaussianBlurEffect.VTable, @ptrCast(self.vtable)).SetStandardDeviation(@as(*const IDCompositionGaussianBlurEffect, @ptrCast(self)), amount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionGaussianBlurEffect_SetBorderMode(self: *const T, mode: D2D1_BORDER_MODE) HRESULT {
                return @as(*const IDCompositionGaussianBlurEffect.VTable, @ptrCast(self.vtable)).SetBorderMode(@as(*const IDCompositionGaussianBlurEffect, @ptrCast(self)), mode);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDCompositionBrightnessEffect_Value = Guid.initString("6027496e-cb3a-49ab-934f-d798da4f7da6");
pub const IID_IDCompositionBrightnessEffect = &IID_IDCompositionBrightnessEffect_Value;
pub const IDCompositionBrightnessEffect = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionFilterEffect.VTable,
        SetWhitePoint: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionBrightnessEffect,
                whitePoint: ?*const D2D_VECTOR_2F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionBrightnessEffect,
                whitePoint: ?*const D2D_VECTOR_2F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBlackPoint: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionBrightnessEffect,
                blackPoint: ?*const D2D_VECTOR_2F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionBrightnessEffect,
                blackPoint: ?*const D2D_VECTOR_2F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetWhitePointX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionBrightnessEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionBrightnessEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetWhitePointX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionBrightnessEffect,
                whitePointX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionBrightnessEffect,
                whitePointX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetWhitePointY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionBrightnessEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionBrightnessEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetWhitePointY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionBrightnessEffect,
                whitePointY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionBrightnessEffect,
                whitePointY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBlackPointX: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionBrightnessEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionBrightnessEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBlackPointX1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionBrightnessEffect,
                blackPointX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionBrightnessEffect,
                blackPointX: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBlackPointY: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionBrightnessEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionBrightnessEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBlackPointY1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionBrightnessEffect,
                blackPointY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionBrightnessEffect,
                blackPointY: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionFilterEffect.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionBrightnessEffect_SetWhitePoint(self: *const T, whitePoint: ?*const D2D_VECTOR_2F) HRESULT {
                return @as(*const IDCompositionBrightnessEffect.VTable, @ptrCast(self.vtable)).SetWhitePoint(@as(*const IDCompositionBrightnessEffect, @ptrCast(self)), whitePoint);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionBrightnessEffect_SetBlackPoint(self: *const T, blackPoint: ?*const D2D_VECTOR_2F) HRESULT {
                return @as(*const IDCompositionBrightnessEffect.VTable, @ptrCast(self.vtable)).SetBlackPoint(@as(*const IDCompositionBrightnessEffect, @ptrCast(self)), blackPoint);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionBrightnessEffect_SetWhitePointX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionBrightnessEffect.VTable, @ptrCast(self.vtable)).SetWhitePointX(@as(*const IDCompositionBrightnessEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionBrightnessEffect_SetWhitePointX1(self: *const T, whitePointX: f32) HRESULT {
                return @as(*const IDCompositionBrightnessEffect.VTable, @ptrCast(self.vtable)).SetWhitePointX(@as(*const IDCompositionBrightnessEffect, @ptrCast(self)), whitePointX);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionBrightnessEffect_SetWhitePointY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionBrightnessEffect.VTable, @ptrCast(self.vtable)).SetWhitePointY(@as(*const IDCompositionBrightnessEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionBrightnessEffect_SetWhitePointY1(self: *const T, whitePointY: f32) HRESULT {
                return @as(*const IDCompositionBrightnessEffect.VTable, @ptrCast(self.vtable)).SetWhitePointY(@as(*const IDCompositionBrightnessEffect, @ptrCast(self)), whitePointY);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionBrightnessEffect_SetBlackPointX(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionBrightnessEffect.VTable, @ptrCast(self.vtable)).SetBlackPointX(@as(*const IDCompositionBrightnessEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionBrightnessEffect_SetBlackPointX1(self: *const T, blackPointX: f32) HRESULT {
                return @as(*const IDCompositionBrightnessEffect.VTable, @ptrCast(self.vtable)).SetBlackPointX(@as(*const IDCompositionBrightnessEffect, @ptrCast(self)), blackPointX);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionBrightnessEffect_SetBlackPointY(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionBrightnessEffect.VTable, @ptrCast(self.vtable)).SetBlackPointY(@as(*const IDCompositionBrightnessEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionBrightnessEffect_SetBlackPointY1(self: *const T, blackPointY: f32) HRESULT {
                return @as(*const IDCompositionBrightnessEffect.VTable, @ptrCast(self.vtable)).SetBlackPointY(@as(*const IDCompositionBrightnessEffect, @ptrCast(self)), blackPointY);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDCompositionColorMatrixEffect_Value = Guid.initString("c1170a22-3ce2-4966-90d4-55408bfc84c4");
pub const IID_IDCompositionColorMatrixEffect = &IID_IDCompositionColorMatrixEffect_Value;
pub const IDCompositionColorMatrixEffect = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionFilterEffect.VTable,
        SetMatrix: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionColorMatrixEffect,
                matrix: ?*const D2D_MATRIX_5X4_F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionColorMatrixEffect,
                matrix: ?*const D2D_MATRIX_5X4_F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetMatrixElement: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionColorMatrixEffect,
                row: i32,
                column: i32,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionColorMatrixEffect,
                row: i32,
                column: i32,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetMatrixElement1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionColorMatrixEffect,
                row: i32,
                column: i32,
                value: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionColorMatrixEffect,
                row: i32,
                column: i32,
                value: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAlphaMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionColorMatrixEffect,
                mode: D2D1_COLORMATRIX_ALPHA_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionColorMatrixEffect,
                mode: D2D1_COLORMATRIX_ALPHA_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetClampOutput: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionColorMatrixEffect,
                clamp: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionColorMatrixEffect,
                clamp: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionFilterEffect.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionColorMatrixEffect_SetMatrix(self: *const T, matrix: ?*const D2D_MATRIX_5X4_F) HRESULT {
                return @as(*const IDCompositionColorMatrixEffect.VTable, @ptrCast(self.vtable)).SetMatrix(@as(*const IDCompositionColorMatrixEffect, @ptrCast(self)), matrix);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionColorMatrixEffect_SetMatrixElement(self: *const T, row: i32, column: i32, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionColorMatrixEffect.VTable, @ptrCast(self.vtable)).SetMatrixElement(@as(*const IDCompositionColorMatrixEffect, @ptrCast(self)), row, column, animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionColorMatrixEffect_SetMatrixElement1(self: *const T, row: i32, column: i32, value: f32) HRESULT {
                return @as(*const IDCompositionColorMatrixEffect.VTable, @ptrCast(self.vtable)).SetMatrixElement(@as(*const IDCompositionColorMatrixEffect, @ptrCast(self)), row, column, value);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionColorMatrixEffect_SetAlphaMode(self: *const T, mode: D2D1_COLORMATRIX_ALPHA_MODE) HRESULT {
                return @as(*const IDCompositionColorMatrixEffect.VTable, @ptrCast(self.vtable)).SetAlphaMode(@as(*const IDCompositionColorMatrixEffect, @ptrCast(self)), mode);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionColorMatrixEffect_SetClampOutput(self: *const T, clamp: BOOL) HRESULT {
                return @as(*const IDCompositionColorMatrixEffect.VTable, @ptrCast(self.vtable)).SetClampOutput(@as(*const IDCompositionColorMatrixEffect, @ptrCast(self)), clamp);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDCompositionShadowEffect_Value = Guid.initString("4ad18ac0-cfd2-4c2f-bb62-96e54fdb6879");
pub const IID_IDCompositionShadowEffect = &IID_IDCompositionShadowEffect_Value;
pub const IDCompositionShadowEffect = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionFilterEffect.VTable,
        SetStandardDeviation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionShadowEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionShadowEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetStandardDeviation1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionShadowEffect,
                amount: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionShadowEffect,
                amount: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetColor: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionShadowEffect,
                color: ?*const D2D_VECTOR_4F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionShadowEffect,
                color: ?*const D2D_VECTOR_4F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetRed: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionShadowEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionShadowEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetRed1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionShadowEffect,
                amount: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionShadowEffect,
                amount: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetGreen: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionShadowEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionShadowEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetGreen1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionShadowEffect,
                amount: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionShadowEffect,
                amount: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBlue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionShadowEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionShadowEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBlue1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionShadowEffect,
                amount: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionShadowEffect,
                amount: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAlpha: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionShadowEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionShadowEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAlpha1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionShadowEffect,
                amount: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionShadowEffect,
                amount: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionFilterEffect.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionShadowEffect_SetStandardDeviation(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionShadowEffect.VTable, @ptrCast(self.vtable)).SetStandardDeviation(@as(*const IDCompositionShadowEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionShadowEffect_SetStandardDeviation1(self: *const T, amount: f32) HRESULT {
                return @as(*const IDCompositionShadowEffect.VTable, @ptrCast(self.vtable)).SetStandardDeviation(@as(*const IDCompositionShadowEffect, @ptrCast(self)), amount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionShadowEffect_SetColor(self: *const T, color: ?*const D2D_VECTOR_4F) HRESULT {
                return @as(*const IDCompositionShadowEffect.VTable, @ptrCast(self.vtable)).SetColor(@as(*const IDCompositionShadowEffect, @ptrCast(self)), color);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionShadowEffect_SetRed(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionShadowEffect.VTable, @ptrCast(self.vtable)).SetRed(@as(*const IDCompositionShadowEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionShadowEffect_SetRed1(self: *const T, amount: f32) HRESULT {
                return @as(*const IDCompositionShadowEffect.VTable, @ptrCast(self.vtable)).SetRed(@as(*const IDCompositionShadowEffect, @ptrCast(self)), amount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionShadowEffect_SetGreen(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionShadowEffect.VTable, @ptrCast(self.vtable)).SetGreen(@as(*const IDCompositionShadowEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionShadowEffect_SetGreen1(self: *const T, amount: f32) HRESULT {
                return @as(*const IDCompositionShadowEffect.VTable, @ptrCast(self.vtable)).SetGreen(@as(*const IDCompositionShadowEffect, @ptrCast(self)), amount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionShadowEffect_SetBlue(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionShadowEffect.VTable, @ptrCast(self.vtable)).SetBlue(@as(*const IDCompositionShadowEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionShadowEffect_SetBlue1(self: *const T, amount: f32) HRESULT {
                return @as(*const IDCompositionShadowEffect.VTable, @ptrCast(self.vtable)).SetBlue(@as(*const IDCompositionShadowEffect, @ptrCast(self)), amount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionShadowEffect_SetAlpha(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionShadowEffect.VTable, @ptrCast(self.vtable)).SetAlpha(@as(*const IDCompositionShadowEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionShadowEffect_SetAlpha1(self: *const T, amount: f32) HRESULT {
                return @as(*const IDCompositionShadowEffect.VTable, @ptrCast(self.vtable)).SetAlpha(@as(*const IDCompositionShadowEffect, @ptrCast(self)), amount);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDCompositionHueRotationEffect_Value = Guid.initString("6db9f920-0770-4781-b0c6-381912f9d167");
pub const IID_IDCompositionHueRotationEffect = &IID_IDCompositionHueRotationEffect_Value;
pub const IDCompositionHueRotationEffect = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionFilterEffect.VTable,
        SetAngle: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionHueRotationEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionHueRotationEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAngle1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionHueRotationEffect,
                amountDegrees: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionHueRotationEffect,
                amountDegrees: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionFilterEffect.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionHueRotationEffect_SetAngle(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionHueRotationEffect.VTable, @ptrCast(self.vtable)).SetAngle(@as(*const IDCompositionHueRotationEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionHueRotationEffect_SetAngle1(self: *const T, amountDegrees: f32) HRESULT {
                return @as(*const IDCompositionHueRotationEffect.VTable, @ptrCast(self.vtable)).SetAngle(@as(*const IDCompositionHueRotationEffect, @ptrCast(self)), amountDegrees);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDCompositionSaturationEffect_Value = Guid.initString("a08debda-3258-4fa4-9f16-9174d3fe93b1");
pub const IID_IDCompositionSaturationEffect = &IID_IDCompositionSaturationEffect_Value;
pub const IDCompositionSaturationEffect = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionFilterEffect.VTable,
        SetSaturation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSaturationEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSaturationEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetSaturation1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionSaturationEffect,
                ratio: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionSaturationEffect,
                ratio: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionFilterEffect.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSaturationEffect_SetSaturation(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionSaturationEffect.VTable, @ptrCast(self.vtable)).SetSaturation(@as(*const IDCompositionSaturationEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionSaturationEffect_SetSaturation1(self: *const T, ratio: f32) HRESULT {
                return @as(*const IDCompositionSaturationEffect.VTable, @ptrCast(self.vtable)).SetSaturation(@as(*const IDCompositionSaturationEffect, @ptrCast(self)), ratio);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDCompositionTurbulenceEffect_Value = Guid.initString("a6a55bda-c09c-49f3-9193-a41922c89715");
pub const IID_IDCompositionTurbulenceEffect = &IID_IDCompositionTurbulenceEffect_Value;
pub const IDCompositionTurbulenceEffect = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionFilterEffect.VTable,
        SetOffset: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTurbulenceEffect,
                offset: ?*const D2D_VECTOR_2F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTurbulenceEffect,
                offset: ?*const D2D_VECTOR_2F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBaseFrequency: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTurbulenceEffect,
                frequency: ?*const D2D_VECTOR_2F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTurbulenceEffect,
                frequency: ?*const D2D_VECTOR_2F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetSize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTurbulenceEffect,
                size: ?*const D2D_VECTOR_2F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTurbulenceEffect,
                size: ?*const D2D_VECTOR_2F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetNumOctaves: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTurbulenceEffect,
                numOctaves: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTurbulenceEffect,
                numOctaves: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetSeed: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTurbulenceEffect,
                seed: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTurbulenceEffect,
                seed: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetNoise: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTurbulenceEffect,
                noise: D2D1_TURBULENCE_NOISE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTurbulenceEffect,
                noise: D2D1_TURBULENCE_NOISE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetStitchable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTurbulenceEffect,
                stitchable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTurbulenceEffect,
                stitchable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionFilterEffect.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTurbulenceEffect_SetOffset(self: *const T, offset: ?*const D2D_VECTOR_2F) HRESULT {
                return @as(*const IDCompositionTurbulenceEffect.VTable, @ptrCast(self.vtable)).SetOffset(@as(*const IDCompositionTurbulenceEffect, @ptrCast(self)), offset);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTurbulenceEffect_SetBaseFrequency(self: *const T, frequency: ?*const D2D_VECTOR_2F) HRESULT {
                return @as(*const IDCompositionTurbulenceEffect.VTable, @ptrCast(self.vtable)).SetBaseFrequency(@as(*const IDCompositionTurbulenceEffect, @ptrCast(self)), frequency);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTurbulenceEffect_SetSize(self: *const T, size: ?*const D2D_VECTOR_2F) HRESULT {
                return @as(*const IDCompositionTurbulenceEffect.VTable, @ptrCast(self.vtable)).SetSize(@as(*const IDCompositionTurbulenceEffect, @ptrCast(self)), size);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTurbulenceEffect_SetNumOctaves(self: *const T, numOctaves: u32) HRESULT {
                return @as(*const IDCompositionTurbulenceEffect.VTable, @ptrCast(self.vtable)).SetNumOctaves(@as(*const IDCompositionTurbulenceEffect, @ptrCast(self)), numOctaves);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTurbulenceEffect_SetSeed(self: *const T, seed: u32) HRESULT {
                return @as(*const IDCompositionTurbulenceEffect.VTable, @ptrCast(self.vtable)).SetSeed(@as(*const IDCompositionTurbulenceEffect, @ptrCast(self)), seed);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTurbulenceEffect_SetNoise(self: *const T, noise: D2D1_TURBULENCE_NOISE) HRESULT {
                return @as(*const IDCompositionTurbulenceEffect.VTable, @ptrCast(self.vtable)).SetNoise(@as(*const IDCompositionTurbulenceEffect, @ptrCast(self)), noise);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTurbulenceEffect_SetStitchable(self: *const T, stitchable: BOOL) HRESULT {
                return @as(*const IDCompositionTurbulenceEffect.VTable, @ptrCast(self.vtable)).SetStitchable(@as(*const IDCompositionTurbulenceEffect, @ptrCast(self)), stitchable);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDCompositionLinearTransferEffect_Value = Guid.initString("4305ee5b-c4a0-4c88-9385-67124e017683");
pub const IID_IDCompositionLinearTransferEffect = &IID_IDCompositionLinearTransferEffect_Value;
pub const IDCompositionLinearTransferEffect = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionFilterEffect.VTable,
        SetRedYIntercept: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetRedYIntercept1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                redYIntercept: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                redYIntercept: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetRedSlope: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetRedSlope1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                redSlope: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                redSlope: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetRedDisable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                redDisable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                redDisable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetGreenYIntercept: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetGreenYIntercept1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                greenYIntercept: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                greenYIntercept: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetGreenSlope: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetGreenSlope1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                greenSlope: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                greenSlope: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetGreenDisable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                greenDisable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                greenDisable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBlueYIntercept: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBlueYIntercept1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                blueYIntercept: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                blueYIntercept: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBlueSlope: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBlueSlope1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                blueSlope: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                blueSlope: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBlueDisable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                blueDisable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                blueDisable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAlphaYIntercept: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAlphaYIntercept1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                alphaYIntercept: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                alphaYIntercept: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAlphaSlope: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAlphaSlope1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                alphaSlope: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                alphaSlope: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAlphaDisable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                alphaDisable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                alphaDisable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetClampOutput: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionLinearTransferEffect,
                clampOutput: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionLinearTransferEffect,
                clampOutput: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionFilterEffect.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetRedYIntercept(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetRedYIntercept(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetRedYIntercept1(self: *const T, redYIntercept: f32) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetRedYIntercept(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), redYIntercept);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetRedSlope(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetRedSlope(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetRedSlope1(self: *const T, redSlope: f32) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetRedSlope(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), redSlope);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetRedDisable(self: *const T, redDisable: BOOL) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetRedDisable(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), redDisable);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetGreenYIntercept(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetGreenYIntercept(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetGreenYIntercept1(self: *const T, greenYIntercept: f32) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetGreenYIntercept(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), greenYIntercept);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetGreenSlope(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetGreenSlope(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetGreenSlope1(self: *const T, greenSlope: f32) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetGreenSlope(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), greenSlope);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetGreenDisable(self: *const T, greenDisable: BOOL) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetGreenDisable(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), greenDisable);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetBlueYIntercept(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetBlueYIntercept(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetBlueYIntercept1(self: *const T, blueYIntercept: f32) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetBlueYIntercept(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), blueYIntercept);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetBlueSlope(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetBlueSlope(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetBlueSlope1(self: *const T, blueSlope: f32) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetBlueSlope(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), blueSlope);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetBlueDisable(self: *const T, blueDisable: BOOL) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetBlueDisable(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), blueDisable);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetAlphaYIntercept(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetAlphaYIntercept(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetAlphaYIntercept1(self: *const T, alphaYIntercept: f32) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetAlphaYIntercept(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), alphaYIntercept);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetAlphaSlope(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetAlphaSlope(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetAlphaSlope1(self: *const T, alphaSlope: f32) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetAlphaSlope(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), alphaSlope);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetAlphaDisable(self: *const T, alphaDisable: BOOL) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetAlphaDisable(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), alphaDisable);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionLinearTransferEffect_SetClampOutput(self: *const T, clampOutput: BOOL) HRESULT {
                return @as(*const IDCompositionLinearTransferEffect.VTable, @ptrCast(self.vtable)).SetClampOutput(@as(*const IDCompositionLinearTransferEffect, @ptrCast(self)), clampOutput);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDCompositionTableTransferEffect_Value = Guid.initString("9b7e82e2-69c5-4eb4-a5f5-a7033f5132cd");
pub const IID_IDCompositionTableTransferEffect = &IID_IDCompositionTableTransferEffect_Value;
pub const IDCompositionTableTransferEffect = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionFilterEffect.VTable,
        SetRedTable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                tableValues: [*]const f32,
                count: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                tableValues: [*]const f32,
                count: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetGreenTable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                tableValues: [*]const f32,
                count: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                tableValues: [*]const f32,
                count: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBlueTable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                tableValues: [*]const f32,
                count: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                tableValues: [*]const f32,
                count: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAlphaTable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                tableValues: [*]const f32,
                count: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                tableValues: [*]const f32,
                count: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetRedDisable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                redDisable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                redDisable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetGreenDisable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                greenDisable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                greenDisable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBlueDisable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                blueDisable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                blueDisable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAlphaDisable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                alphaDisable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                alphaDisable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetClampOutput: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                clampOutput: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                clampOutput: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetRedTableValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                index: u32,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                index: u32,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetRedTableValue1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                index: u32,
                value: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                index: u32,
                value: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetGreenTableValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                index: u32,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                index: u32,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetGreenTableValue1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                index: u32,
                value: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                index: u32,
                value: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBlueTableValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                index: u32,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                index: u32,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBlueTableValue1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                index: u32,
                value: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                index: u32,
                value: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAlphaTableValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                index: u32,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                index: u32,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAlphaTableValue1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionTableTransferEffect,
                index: u32,
                value: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionTableTransferEffect,
                index: u32,
                value: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionFilterEffect.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetRedTable(self: *const T, tableValues: [*]const f32, count: u32) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetRedTable(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), tableValues, count);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetGreenTable(self: *const T, tableValues: [*]const f32, count: u32) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetGreenTable(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), tableValues, count);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetBlueTable(self: *const T, tableValues: [*]const f32, count: u32) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetBlueTable(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), tableValues, count);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetAlphaTable(self: *const T, tableValues: [*]const f32, count: u32) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetAlphaTable(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), tableValues, count);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetRedDisable(self: *const T, redDisable: BOOL) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetRedDisable(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), redDisable);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetGreenDisable(self: *const T, greenDisable: BOOL) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetGreenDisable(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), greenDisable);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetBlueDisable(self: *const T, blueDisable: BOOL) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetBlueDisable(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), blueDisable);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetAlphaDisable(self: *const T, alphaDisable: BOOL) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetAlphaDisable(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), alphaDisable);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetClampOutput(self: *const T, clampOutput: BOOL) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetClampOutput(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), clampOutput);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetRedTableValue(self: *const T, index: u32, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetRedTableValue(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), index, animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetRedTableValue1(self: *const T, index: u32, value: f32) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetRedTableValue(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), index, value);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetGreenTableValue(self: *const T, index: u32, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetGreenTableValue(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), index, animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetGreenTableValue1(self: *const T, index: u32, value: f32) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetGreenTableValue(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), index, value);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetBlueTableValue(self: *const T, index: u32, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetBlueTableValue(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), index, animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetBlueTableValue1(self: *const T, index: u32, value: f32) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetBlueTableValue(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), index, value);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetAlphaTableValue(self: *const T, index: u32, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetAlphaTableValue(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), index, animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionTableTransferEffect_SetAlphaTableValue1(self: *const T, index: u32, value: f32) HRESULT {
                return @as(*const IDCompositionTableTransferEffect.VTable, @ptrCast(self.vtable)).SetAlphaTableValue(@as(*const IDCompositionTableTransferEffect, @ptrCast(self)), index, value);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDCompositionCompositeEffect_Value = Guid.initString("576616c0-a231-494d-a38d-00fd5ec4db46");
pub const IID_IDCompositionCompositeEffect = &IID_IDCompositionCompositeEffect_Value;
pub const IDCompositionCompositeEffect = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionFilterEffect.VTable,
        SetMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionCompositeEffect,
                mode: D2D1_COMPOSITE_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionCompositeEffect,
                mode: D2D1_COMPOSITE_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionFilterEffect.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionCompositeEffect_SetMode(self: *const T, mode: D2D1_COMPOSITE_MODE) HRESULT {
                return @as(*const IDCompositionCompositeEffect.VTable, @ptrCast(self.vtable)).SetMode(@as(*const IDCompositionCompositeEffect, @ptrCast(self)), mode);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDCompositionBlendEffect_Value = Guid.initString("33ecdc0a-578a-4a11-9c14-0cb90517f9c5");
pub const IID_IDCompositionBlendEffect = &IID_IDCompositionBlendEffect_Value;
pub const IDCompositionBlendEffect = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionFilterEffect.VTable,
        SetMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionBlendEffect,
                mode: D2D1_BLEND_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionBlendEffect,
                mode: D2D1_BLEND_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionFilterEffect.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionBlendEffect_SetMode(self: *const T, mode: D2D1_BLEND_MODE) HRESULT {
                return @as(*const IDCompositionBlendEffect.VTable, @ptrCast(self.vtable)).SetMode(@as(*const IDCompositionBlendEffect, @ptrCast(self)), mode);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDCompositionArithmeticCompositeEffect_Value = Guid.initString("3b67dfa8-e3dd-4e61-b640-46c2f3d739dc");
pub const IID_IDCompositionArithmeticCompositeEffect = &IID_IDCompositionArithmeticCompositeEffect_Value;
pub const IDCompositionArithmeticCompositeEffect = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionFilterEffect.VTable,
        SetCoefficients: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                coefficients: ?*const D2D_VECTOR_4F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                coefficients: ?*const D2D_VECTOR_4F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetClampOutput: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                clampoutput: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                clampoutput: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCoefficient1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCoefficient11: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                Coeffcient1: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                Coeffcient1: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCoefficient2: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCoefficient21: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                Coefficient2: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                Coefficient2: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCoefficient3: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCoefficient31: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                Coefficient3: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                Coefficient3: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCoefficient4: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCoefficient41: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                Coefficient4: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionArithmeticCompositeEffect,
                Coefficient4: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionFilterEffect.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionArithmeticCompositeEffect_SetCoefficients(self: *const T, coefficients: ?*const D2D_VECTOR_4F) HRESULT {
                return @as(*const IDCompositionArithmeticCompositeEffect.VTable, @ptrCast(self.vtable)).SetCoefficients(@as(*const IDCompositionArithmeticCompositeEffect, @ptrCast(self)), coefficients);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionArithmeticCompositeEffect_SetClampOutput(self: *const T, clampoutput: BOOL) HRESULT {
                return @as(*const IDCompositionArithmeticCompositeEffect.VTable, @ptrCast(self.vtable)).SetClampOutput(@as(*const IDCompositionArithmeticCompositeEffect, @ptrCast(self)), clampoutput);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionArithmeticCompositeEffect_SetCoefficient1(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionArithmeticCompositeEffect.VTable, @ptrCast(self.vtable)).SetCoefficient1(@as(*const IDCompositionArithmeticCompositeEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionArithmeticCompositeEffect_SetCoefficient11(self: *const T, Coeffcient1: f32) HRESULT {
                return @as(*const IDCompositionArithmeticCompositeEffect.VTable, @ptrCast(self.vtable)).SetCoefficient1(@as(*const IDCompositionArithmeticCompositeEffect, @ptrCast(self)), Coeffcient1);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionArithmeticCompositeEffect_SetCoefficient2(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionArithmeticCompositeEffect.VTable, @ptrCast(self.vtable)).SetCoefficient2(@as(*const IDCompositionArithmeticCompositeEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionArithmeticCompositeEffect_SetCoefficient21(self: *const T, Coefficient2: f32) HRESULT {
                return @as(*const IDCompositionArithmeticCompositeEffect.VTable, @ptrCast(self.vtable)).SetCoefficient2(@as(*const IDCompositionArithmeticCompositeEffect, @ptrCast(self)), Coefficient2);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionArithmeticCompositeEffect_SetCoefficient3(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionArithmeticCompositeEffect.VTable, @ptrCast(self.vtable)).SetCoefficient3(@as(*const IDCompositionArithmeticCompositeEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionArithmeticCompositeEffect_SetCoefficient31(self: *const T, Coefficient3: f32) HRESULT {
                return @as(*const IDCompositionArithmeticCompositeEffect.VTable, @ptrCast(self.vtable)).SetCoefficient3(@as(*const IDCompositionArithmeticCompositeEffect, @ptrCast(self)), Coefficient3);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionArithmeticCompositeEffect_SetCoefficient4(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionArithmeticCompositeEffect.VTable, @ptrCast(self.vtable)).SetCoefficient4(@as(*const IDCompositionArithmeticCompositeEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionArithmeticCompositeEffect_SetCoefficient41(self: *const T, Coefficient4: f32) HRESULT {
                return @as(*const IDCompositionArithmeticCompositeEffect.VTable, @ptrCast(self.vtable)).SetCoefficient4(@as(*const IDCompositionArithmeticCompositeEffect, @ptrCast(self)), Coefficient4);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDCompositionAffineTransform2DEffect_Value = Guid.initString("0b74b9e8-cdd6-492f-bbbc-5ed32157026d");
pub const IID_IDCompositionAffineTransform2DEffect = &IID_IDCompositionAffineTransform2DEffect_Value;
pub const IDCompositionAffineTransform2DEffect = extern struct {
    pub const VTable = extern struct {
        base: IDCompositionFilterEffect.VTable,
        SetInterpolationMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionAffineTransform2DEffect,
                interpolationMode: D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionAffineTransform2DEffect,
                interpolationMode: D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetBorderMode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionAffineTransform2DEffect,
                borderMode: D2D1_BORDER_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionAffineTransform2DEffect,
                borderMode: D2D1_BORDER_MODE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTransformMatrix: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionAffineTransform2DEffect,
                transformMatrix: ?*const D2D_MATRIX_3X2_F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionAffineTransform2DEffect,
                transformMatrix: ?*const D2D_MATRIX_3X2_F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTransformMatrixElement: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionAffineTransform2DEffect,
                row: i32,
                column: i32,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionAffineTransform2DEffect,
                row: i32,
                column: i32,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTransformMatrixElement1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionAffineTransform2DEffect,
                row: i32,
                column: i32,
                value: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionAffineTransform2DEffect,
                row: i32,
                column: i32,
                value: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetSharpness: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionAffineTransform2DEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionAffineTransform2DEffect,
                animation: ?*IDCompositionAnimation,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetSharpness1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionAffineTransform2DEffect,
                sharpness: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionAffineTransform2DEffect,
                sharpness: f32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDCompositionFilterEffect.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionAffineTransform2DEffect_SetInterpolationMode(self: *const T, interpolationMode: D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE) HRESULT {
                return @as(*const IDCompositionAffineTransform2DEffect.VTable, @ptrCast(self.vtable)).SetInterpolationMode(@as(*const IDCompositionAffineTransform2DEffect, @ptrCast(self)), interpolationMode);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionAffineTransform2DEffect_SetBorderMode(self: *const T, borderMode: D2D1_BORDER_MODE) HRESULT {
                return @as(*const IDCompositionAffineTransform2DEffect.VTable, @ptrCast(self.vtable)).SetBorderMode(@as(*const IDCompositionAffineTransform2DEffect, @ptrCast(self)), borderMode);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionAffineTransform2DEffect_SetTransformMatrix(self: *const T, transformMatrix: ?*const D2D_MATRIX_3X2_F) HRESULT {
                return @as(*const IDCompositionAffineTransform2DEffect.VTable, @ptrCast(self.vtable)).SetTransformMatrix(@as(*const IDCompositionAffineTransform2DEffect, @ptrCast(self)), transformMatrix);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionAffineTransform2DEffect_SetTransformMatrixElement(self: *const T, row: i32, column: i32, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionAffineTransform2DEffect.VTable, @ptrCast(self.vtable)).SetTransformMatrixElement(@as(*const IDCompositionAffineTransform2DEffect, @ptrCast(self)), row, column, animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionAffineTransform2DEffect_SetTransformMatrixElement1(self: *const T, row: i32, column: i32, value: f32) HRESULT {
                return @as(*const IDCompositionAffineTransform2DEffect.VTable, @ptrCast(self.vtable)).SetTransformMatrixElement(@as(*const IDCompositionAffineTransform2DEffect, @ptrCast(self)), row, column, value);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionAffineTransform2DEffect_SetSharpness(self: *const T, animation: ?*IDCompositionAnimation) HRESULT {
                return @as(*const IDCompositionAffineTransform2DEffect.VTable, @ptrCast(self.vtable)).SetSharpness(@as(*const IDCompositionAffineTransform2DEffect, @ptrCast(self)), animation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionAffineTransform2DEffect_SetSharpness1(self: *const T, sharpness: f32) HRESULT {
                return @as(*const IDCompositionAffineTransform2DEffect.VTable, @ptrCast(self.vtable)).SetSharpness(@as(*const IDCompositionAffineTransform2DEffect, @ptrCast(self)), sharpness);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const DCompositionInkTrailPoint = extern struct {
    x: f32,
    y: f32,
    radius: f32,
};

const IID_IDCompositionDelegatedInkTrail_Value = Guid.initString("c2448e9b-547d-4057-8cf5-8144ede1c2da");
pub const IID_IDCompositionDelegatedInkTrail = &IID_IDCompositionDelegatedInkTrail_Value;
pub const IDCompositionDelegatedInkTrail = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        AddTrailPoints: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDelegatedInkTrail,
                inkPoints: [*]const DCompositionInkTrailPoint,
                inkPointsCount: u32,
                generationId: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDelegatedInkTrail,
                inkPoints: [*]const DCompositionInkTrailPoint,
                inkPointsCount: u32,
                generationId: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddTrailPointsWithPrediction: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDelegatedInkTrail,
                inkPoints: [*]const DCompositionInkTrailPoint,
                inkPointsCount: u32,
                predictedInkPoints: [*]const DCompositionInkTrailPoint,
                predictedInkPointsCount: u32,
                generationId: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDelegatedInkTrail,
                inkPoints: [*]const DCompositionInkTrailPoint,
                inkPointsCount: u32,
                predictedInkPoints: [*]const DCompositionInkTrailPoint,
                predictedInkPointsCount: u32,
                generationId: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveTrailPoints: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDelegatedInkTrail,
                generationId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDelegatedInkTrail,
                generationId: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        StartNewTrail: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionDelegatedInkTrail,
                color: ?*const D2D1_COLOR_F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionDelegatedInkTrail,
                color: ?*const D2D1_COLOR_F,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDelegatedInkTrail_AddTrailPoints(self: *const T, inkPoints: [*]const DCompositionInkTrailPoint, inkPointsCount: u32, generationId: ?*u32) HRESULT {
                return @as(*const IDCompositionDelegatedInkTrail.VTable, @ptrCast(self.vtable)).AddTrailPoints(@as(*const IDCompositionDelegatedInkTrail, @ptrCast(self)), inkPoints, inkPointsCount, generationId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDelegatedInkTrail_AddTrailPointsWithPrediction(self: *const T, inkPoints: [*]const DCompositionInkTrailPoint, inkPointsCount: u32, predictedInkPoints: [*]const DCompositionInkTrailPoint, predictedInkPointsCount: u32, generationId: ?*u32) HRESULT {
                return @as(*const IDCompositionDelegatedInkTrail.VTable, @ptrCast(self.vtable)).AddTrailPointsWithPrediction(@as(*const IDCompositionDelegatedInkTrail, @ptrCast(self)), inkPoints, inkPointsCount, predictedInkPoints, predictedInkPointsCount, generationId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDelegatedInkTrail_RemoveTrailPoints(self: *const T, generationId: u32) HRESULT {
                return @as(*const IDCompositionDelegatedInkTrail.VTable, @ptrCast(self.vtable)).RemoveTrailPoints(@as(*const IDCompositionDelegatedInkTrail, @ptrCast(self)), generationId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionDelegatedInkTrail_StartNewTrail(self: *const T, color: ?*const D2D1_COLOR_F) HRESULT {
                return @as(*const IDCompositionDelegatedInkTrail.VTable, @ptrCast(self.vtable)).StartNewTrail(@as(*const IDCompositionDelegatedInkTrail, @ptrCast(self)), color);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDCompositionInkTrailDevice_Value = Guid.initString("df0c7cec-cdeb-4d4a-b91c-721bf22f4e6c");
pub const IID_IDCompositionInkTrailDevice = &IID_IDCompositionInkTrailDevice_Value;
pub const IDCompositionInkTrailDevice = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        CreateDelegatedInkTrail: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionInkTrailDevice,
                inkTrail: ?*?*IDCompositionDelegatedInkTrail,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionInkTrailDevice,
                inkTrail: ?*?*IDCompositionDelegatedInkTrail,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateDelegatedInkTrailForSwapChain: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDCompositionInkTrailDevice,
                swapChain: ?*IUnknown,
                inkTrail: ?*?*IDCompositionDelegatedInkTrail,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDCompositionInkTrailDevice,
                swapChain: ?*IUnknown,
                inkTrail: ?*?*IDCompositionDelegatedInkTrail,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionInkTrailDevice_CreateDelegatedInkTrail(self: *const T, inkTrail: ?*?*IDCompositionDelegatedInkTrail) HRESULT {
                return @as(*const IDCompositionInkTrailDevice.VTable, @ptrCast(self.vtable)).CreateDelegatedInkTrail(@as(*const IDCompositionInkTrailDevice, @ptrCast(self)), inkTrail);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDCompositionInkTrailDevice_CreateDelegatedInkTrailForSwapChain(self: *const T, swapChain: ?*IUnknown, inkTrail: ?*?*IDCompositionDelegatedInkTrail) HRESULT {
                return @as(*const IDCompositionInkTrailDevice.VTable, @ptrCast(self.vtable)).CreateDelegatedInkTrailForSwapChain(@as(*const IDCompositionInkTrailDevice, @ptrCast(self)), swapChain, inkTrail);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

//--------------------------------------------------------------------------------
// Section: Functions (11)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows8.0'
pub extern "dcomp" fn DCompositionCreateDevice(
    dxgiDevice: ?*IDXGIDevice,
    iid: ?*const Guid,
    dcompositionDevice: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows8.1'
pub extern "dcomp" fn DCompositionCreateDevice2(
    renderingDevice: ?*IUnknown,
    iid: ?*const Guid,
    dcompositionDevice: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "dcomp" fn DCompositionCreateDevice3(
    renderingDevice: ?*IUnknown,
    iid: ?*const Guid,
    dcompositionDevice: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows8.0'
pub extern "dcomp" fn DCompositionCreateSurfaceHandle(
    desiredAccess: u32,
    securityAttributes: ?*SECURITY_ATTRIBUTES,
    surfaceHandle: ?*?HANDLE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "dcomp" fn DCompositionAttachMouseWheelToHwnd(
    visual: ?*IDCompositionVisual,
    hwnd: ?HWND,
    enable: BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "dcomp" fn DCompositionAttachMouseDragToHwnd(
    visual: ?*IDCompositionVisual,
    hwnd: ?HWND,
    enable: BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "dcomp" fn DCompositionGetFrameId(
    frameIdType: COMPOSITION_FRAME_ID_TYPE,
    frameId: ?*u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "dcomp" fn DCompositionGetStatistics(
    frameId: u64,
    frameStats: ?*COMPOSITION_FRAME_STATS,
    targetIdCount: u32,
    targetIds: ?*COMPOSITION_TARGET_ID,
    actualTargetIdCount: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "dcomp" fn DCompositionGetTargetStatistics(
    frameId: u64,
    targetId: ?*const COMPOSITION_TARGET_ID,
    targetStats: ?*COMPOSITION_TARGET_STATS,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "dcomp" fn DCompositionBoostCompositorClock(
    enable: BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "dcomp" fn DCompositionWaitForCompositorClock(
    count: u32,
    handles: ?[*]const ?HANDLE,
    timeoutInMs: u32,
) callconv(@import("std").os.windows.WINAPI) u32;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (29)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE = @import("../graphics.zig").D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE;
const D2D1_BLEND_MODE = @import("../graphics/direct2d/common.zig").D2D1_BLEND_MODE;
const D2D1_BORDER_MODE = @import("../graphics/direct2d/common.zig").D2D1_BORDER_MODE;
const D2D1_COLOR_F = @import("../graphics/direct2d/common.zig").D2D1_COLOR_F;
const D2D1_COLORMATRIX_ALPHA_MODE = @import("../graphics/direct2d/common.zig").D2D1_COLORMATRIX_ALPHA_MODE;
const D2D1_COMPOSITE_MODE = @import("../graphics/direct2d/common.zig").D2D1_COMPOSITE_MODE;
const D2D1_TURBULENCE_NOISE = @import("../graphics/direct2d/common.zig").D2D1_TURBULENCE_NOISE;
const D2D_MATRIX_3X2_F = @import("../graphics/direct2d/common.zig").D2D_MATRIX_3X2_F;
const D2D_MATRIX_4X4_F = @import("../graphics/direct2d/common.zig").D2D_MATRIX_4X4_F;
const D2D_MATRIX_5X4_F = @import("../graphics/direct2d/common.zig").D2D_MATRIX_5X4_F;
const D2D_RECT_F = @import("../graphics/direct2d/common.zig").D2D_RECT_F;
const D2D_VECTOR_2F = @import("../graphics/direct2d/common.zig").D2D_VECTOR_2F;
const D2D_VECTOR_4F = @import("../graphics/direct2d/common.zig").D2D_VECTOR_4F;
const D3DMATRIX = @import("../graphics/direct3d.zig").D3DMATRIX;
const DXGI_ALPHA_MODE = @import("../graphics/dxgi/common.zig").DXGI_ALPHA_MODE;
const DXGI_FORMAT = @import("../graphics/dxgi/common.zig").DXGI_FORMAT;
const DXGI_RATIONAL = @import("../graphics/dxgi/common.zig").DXGI_RATIONAL;
const HANDLE = @import("../foundation.zig").HANDLE;
const HRESULT = @import("../foundation.zig").HRESULT;
const HWND = @import("../foundation.zig").HWND;
const IDXGIDevice = @import("../graphics/dxgi.zig").IDXGIDevice;
const IUnknown = @import("../system/com.zig").IUnknown;
const LARGE_INTEGER = @import("../foundation.zig").LARGE_INTEGER;
const LUID = @import("../foundation.zig").LUID;
const POINT = @import("../foundation.zig").POINT;
const RECT = @import("../foundation.zig").RECT;
const SECURITY_ATTRIBUTES = @import("../security.zig").SECURITY_ATTRIBUTES;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
