//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (44)
//--------------------------------------------------------------------------------
pub const D3D_COMPILER_VERSION = @as(u32, 47);
pub const D3DCOMPILE_DEBUG = @as(u32, 1);
pub const D3DCOMPILE_SKIP_VALIDATION = @as(u32, 2);
pub const D3DCOMPILE_SKIP_OPTIMIZATION = @as(u32, 4);
pub const D3DCOMPILE_PACK_MATRIX_ROW_MAJOR = @as(u32, 8);
pub const D3DCOMPILE_PACK_MATRIX_COLUMN_MAJOR = @as(u32, 16);
pub const D3DCOMPILE_PARTIAL_PRECISION = @as(u32, 32);
pub const D3DCOMPILE_FORCE_VS_SOFTWARE_NO_OPT = @as(u32, 64);
pub const D3DCOMPILE_FORCE_PS_SOFTWARE_NO_OPT = @as(u32, 128);
pub const D3DCOMPILE_NO_PRESHADER = @as(u32, 256);
pub const D3DCOMPILE_AVOID_FLOW_CONTROL = @as(u32, 512);
pub const D3DCOMPILE_PREFER_FLOW_CONTROL = @as(u32, 1024);
pub const D3DCOMPILE_ENABLE_STRICTNESS = @as(u32, 2048);
pub const D3DCOMPILE_ENABLE_BACKWARDS_COMPATIBILITY = @as(u32, 4096);
pub const D3DCOMPILE_IEEE_STRICTNESS = @as(u32, 8192);
pub const D3DCOMPILE_OPTIMIZATION_LEVEL0 = @as(u32, 16384);
pub const D3DCOMPILE_OPTIMIZATION_LEVEL1 = @as(u32, 0);
pub const D3DCOMPILE_OPTIMIZATION_LEVEL3 = @as(u32, 32768);
pub const D3DCOMPILE_RESERVED16 = @as(u32, 65536);
pub const D3DCOMPILE_RESERVED17 = @as(u32, 131072);
pub const D3DCOMPILE_WARNINGS_ARE_ERRORS = @as(u32, 262144);
pub const D3DCOMPILE_RESOURCES_MAY_ALIAS = @as(u32, 524288);
pub const D3DCOMPILE_ENABLE_UNBOUNDED_DESCRIPTOR_TABLES = @as(u32, 1048576);
pub const D3DCOMPILE_ALL_RESOURCES_BOUND = @as(u32, 2097152);
pub const D3DCOMPILE_DEBUG_NAME_FOR_SOURCE = @as(u32, 4194304);
pub const D3DCOMPILE_DEBUG_NAME_FOR_BINARY = @as(u32, 8388608);
pub const D3DCOMPILE_EFFECT_CHILD_EFFECT = @as(u32, 1);
pub const D3DCOMPILE_EFFECT_ALLOW_SLOW_OPS = @as(u32, 2);
pub const D3DCOMPILE_FLAGS2_FORCE_ROOT_SIGNATURE_LATEST = @as(u32, 0);
pub const D3DCOMPILE_FLAGS2_FORCE_ROOT_SIGNATURE_1_0 = @as(u32, 16);
pub const D3DCOMPILE_FLAGS2_FORCE_ROOT_SIGNATURE_1_1 = @as(u32, 32);
pub const D3DCOMPILE_SECDATA_MERGE_UAV_SLOTS = @as(u32, 1);
pub const D3DCOMPILE_SECDATA_PRESERVE_TEMPLATE_SLOTS = @as(u32, 2);
pub const D3DCOMPILE_SECDATA_REQUIRE_TEMPLATE_MATCH = @as(u32, 4);
pub const D3D_DISASM_ENABLE_COLOR_CODE = @as(u32, 1);
pub const D3D_DISASM_ENABLE_DEFAULT_VALUE_PRINTS = @as(u32, 2);
pub const D3D_DISASM_ENABLE_INSTRUCTION_NUMBERING = @as(u32, 4);
pub const D3D_DISASM_ENABLE_INSTRUCTION_CYCLE = @as(u32, 8);
pub const D3D_DISASM_DISABLE_DEBUG_INFO = @as(u32, 16);
pub const D3D_DISASM_ENABLE_INSTRUCTION_OFFSET = @as(u32, 32);
pub const D3D_DISASM_INSTRUCTION_ONLY = @as(u32, 64);
pub const D3D_DISASM_PRINT_HEX_LITERALS = @as(u32, 128);
pub const D3D_GET_INST_OFFSETS_INCLUDE_NON_EXECUTABLE = @as(u32, 1);
pub const D3D_COMPRESS_SHADER_KEEP_ALL_PARTS = @as(u32, 1);

//--------------------------------------------------------------------------------
// Section: Types (6)
//--------------------------------------------------------------------------------
pub const pD3DCompile = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        pSrcData: ?*const anyopaque,
        SrcDataSize: usize,
        pFileName: ?[*:0]const u8,
        pDefines: ?*const D3D_SHADER_MACRO,
        pInclude: ?*ID3DInclude,
        pEntrypoint: ?[*:0]const u8,
        pTarget: ?[*:0]const u8,
        Flags1: u32,
        Flags2: u32,
        ppCode: ?*?*ID3DBlob,
        ppErrorMsgs: ?*?*ID3DBlob,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        pSrcData: ?*const anyopaque,
        SrcDataSize: usize,
        pFileName: ?[*:0]const u8,
        pDefines: ?*const D3D_SHADER_MACRO,
        pInclude: ?*ID3DInclude,
        pEntrypoint: ?[*:0]const u8,
        pTarget: ?[*:0]const u8,
        Flags1: u32,
        Flags2: u32,
        ppCode: ?*?*ID3DBlob,
        ppErrorMsgs: ?*?*ID3DBlob,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const pD3DPreprocess = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        pSrcData: ?*const anyopaque,
        SrcDataSize: usize,
        pFileName: ?[*:0]const u8,
        pDefines: ?*const D3D_SHADER_MACRO,
        pInclude: ?*ID3DInclude,
        ppCodeText: ?*?*ID3DBlob,
        ppErrorMsgs: ?*?*ID3DBlob,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        pSrcData: ?*const anyopaque,
        SrcDataSize: usize,
        pFileName: ?[*:0]const u8,
        pDefines: ?*const D3D_SHADER_MACRO,
        pInclude: ?*ID3DInclude,
        ppCodeText: ?*?*ID3DBlob,
        ppErrorMsgs: ?*?*ID3DBlob,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const pD3DDisassemble = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        // TODO: what to do with BytesParamIndex 1?
        pSrcData: ?*const anyopaque,
        SrcDataSize: usize,
        Flags: u32,
        szComments: ?[*:0]const u8,
        ppDisassembly: ?*?*ID3DBlob,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        // TODO: what to do with BytesParamIndex 1?
        pSrcData: ?*const anyopaque,
        SrcDataSize: usize,
        Flags: u32,
        szComments: ?[*:0]const u8,
        ppDisassembly: ?*?*ID3DBlob,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const D3DCOMPILER_STRIP_FLAGS = enum(i32) {
    REFLECTION_DATA = 1,
    DEBUG_INFO = 2,
    TEST_BLOBS = 4,
    PRIVATE_DATA = 8,
    ROOT_SIGNATURE = 16,
    FORCE_DWORD = 2147483647,
};
pub const D3DCOMPILER_STRIP_REFLECTION_DATA = D3DCOMPILER_STRIP_FLAGS.REFLECTION_DATA;
pub const D3DCOMPILER_STRIP_DEBUG_INFO = D3DCOMPILER_STRIP_FLAGS.DEBUG_INFO;
pub const D3DCOMPILER_STRIP_TEST_BLOBS = D3DCOMPILER_STRIP_FLAGS.TEST_BLOBS;
pub const D3DCOMPILER_STRIP_PRIVATE_DATA = D3DCOMPILER_STRIP_FLAGS.PRIVATE_DATA;
pub const D3DCOMPILER_STRIP_ROOT_SIGNATURE = D3DCOMPILER_STRIP_FLAGS.ROOT_SIGNATURE;
pub const D3DCOMPILER_STRIP_FORCE_DWORD = D3DCOMPILER_STRIP_FLAGS.FORCE_DWORD;

pub const D3D_BLOB_PART = enum(i32) {
    INPUT_SIGNATURE_BLOB = 0,
    OUTPUT_SIGNATURE_BLOB = 1,
    INPUT_AND_OUTPUT_SIGNATURE_BLOB = 2,
    PATCH_CONSTANT_SIGNATURE_BLOB = 3,
    ALL_SIGNATURE_BLOB = 4,
    DEBUG_INFO = 5,
    LEGACY_SHADER = 6,
    XNA_PREPASS_SHADER = 7,
    XNA_SHADER = 8,
    PDB = 9,
    PRIVATE_DATA = 10,
    ROOT_SIGNATURE = 11,
    DEBUG_NAME = 12,
    TEST_ALTERNATE_SHADER = 32768,
    TEST_COMPILE_DETAILS = 32769,
    TEST_COMPILE_PERF = 32770,
    TEST_COMPILE_REPORT = 32771,
};
pub const D3D_BLOB_INPUT_SIGNATURE_BLOB = D3D_BLOB_PART.INPUT_SIGNATURE_BLOB;
pub const D3D_BLOB_OUTPUT_SIGNATURE_BLOB = D3D_BLOB_PART.OUTPUT_SIGNATURE_BLOB;
pub const D3D_BLOB_INPUT_AND_OUTPUT_SIGNATURE_BLOB = D3D_BLOB_PART.INPUT_AND_OUTPUT_SIGNATURE_BLOB;
pub const D3D_BLOB_PATCH_CONSTANT_SIGNATURE_BLOB = D3D_BLOB_PART.PATCH_CONSTANT_SIGNATURE_BLOB;
pub const D3D_BLOB_ALL_SIGNATURE_BLOB = D3D_BLOB_PART.ALL_SIGNATURE_BLOB;
pub const D3D_BLOB_DEBUG_INFO = D3D_BLOB_PART.DEBUG_INFO;
pub const D3D_BLOB_LEGACY_SHADER = D3D_BLOB_PART.LEGACY_SHADER;
pub const D3D_BLOB_XNA_PREPASS_SHADER = D3D_BLOB_PART.XNA_PREPASS_SHADER;
pub const D3D_BLOB_XNA_SHADER = D3D_BLOB_PART.XNA_SHADER;
pub const D3D_BLOB_PDB = D3D_BLOB_PART.PDB;
pub const D3D_BLOB_PRIVATE_DATA = D3D_BLOB_PART.PRIVATE_DATA;
pub const D3D_BLOB_ROOT_SIGNATURE = D3D_BLOB_PART.ROOT_SIGNATURE;
pub const D3D_BLOB_DEBUG_NAME = D3D_BLOB_PART.DEBUG_NAME;
pub const D3D_BLOB_TEST_ALTERNATE_SHADER = D3D_BLOB_PART.TEST_ALTERNATE_SHADER;
pub const D3D_BLOB_TEST_COMPILE_DETAILS = D3D_BLOB_PART.TEST_COMPILE_DETAILS;
pub const D3D_BLOB_TEST_COMPILE_PERF = D3D_BLOB_PART.TEST_COMPILE_PERF;
pub const D3D_BLOB_TEST_COMPILE_REPORT = D3D_BLOB_PART.TEST_COMPILE_REPORT;

pub const D3D_SHADER_DATA = extern struct {
    pBytecode: ?*const anyopaque,
    BytecodeLength: usize,
};

//--------------------------------------------------------------------------------
// Section: Functions (25)
//--------------------------------------------------------------------------------
pub extern "d3dcompiler_47" fn D3DReadFileToBlob(
    pFileName: ?[*:0]const u16,
    ppContents: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DWriteBlobToFile(
    pBlob: ?*ID3DBlob,
    pFileName: ?[*:0]const u16,
    bOverwrite: BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DCompile(
    // TODO: what to do with BytesParamIndex 1?
    pSrcData: ?*const anyopaque,
    SrcDataSize: usize,
    pSourceName: ?[*:0]const u8,
    pDefines: ?*const D3D_SHADER_MACRO,
    pInclude: ?*ID3DInclude,
    pEntrypoint: ?[*:0]const u8,
    pTarget: ?[*:0]const u8,
    Flags1: u32,
    Flags2: u32,
    ppCode: ?*?*ID3DBlob,
    ppErrorMsgs: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DCompile2(
    // TODO: what to do with BytesParamIndex 1?
    pSrcData: ?*const anyopaque,
    SrcDataSize: usize,
    pSourceName: ?[*:0]const u8,
    pDefines: ?*const D3D_SHADER_MACRO,
    pInclude: ?*ID3DInclude,
    pEntrypoint: ?[*:0]const u8,
    pTarget: ?[*:0]const u8,
    Flags1: u32,
    Flags2: u32,
    SecondaryDataFlags: u32,
    // TODO: what to do with BytesParamIndex 11?
    pSecondaryData: ?*const anyopaque,
    SecondaryDataSize: usize,
    ppCode: ?*?*ID3DBlob,
    ppErrorMsgs: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DCompileFromFile(
    pFileName: ?[*:0]const u16,
    pDefines: ?*const D3D_SHADER_MACRO,
    pInclude: ?*ID3DInclude,
    pEntrypoint: ?[*:0]const u8,
    pTarget: ?[*:0]const u8,
    Flags1: u32,
    Flags2: u32,
    ppCode: ?*?*ID3DBlob,
    ppErrorMsgs: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DPreprocess(
    // TODO: what to do with BytesParamIndex 1?
    pSrcData: ?*const anyopaque,
    SrcDataSize: usize,
    pSourceName: ?[*:0]const u8,
    pDefines: ?*const D3D_SHADER_MACRO,
    pInclude: ?*ID3DInclude,
    ppCodeText: ?*?*ID3DBlob,
    ppErrorMsgs: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DGetDebugInfo(
    // TODO: what to do with BytesParamIndex 1?
    pSrcData: ?*const anyopaque,
    SrcDataSize: usize,
    ppDebugInfo: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DReflect(
    // TODO: what to do with BytesParamIndex 1?
    pSrcData: ?*const anyopaque,
    SrcDataSize: usize,
    pInterface: ?*const Guid,
    ppReflector: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DReflectLibrary(
    // TODO: what to do with BytesParamIndex 1?
    pSrcData: ?*const anyopaque,
    SrcDataSize: usize,
    riid: ?*const Guid,
    ppReflector: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DDisassemble(
    // TODO: what to do with BytesParamIndex 1?
    pSrcData: ?*const anyopaque,
    SrcDataSize: usize,
    Flags: u32,
    szComments: ?[*:0]const u8,
    ppDisassembly: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DDisassembleRegion(
    // TODO: what to do with BytesParamIndex 1?
    pSrcData: ?*const anyopaque,
    SrcDataSize: usize,
    Flags: u32,
    szComments: ?[*:0]const u8,
    StartByteOffset: usize,
    NumInsts: usize,
    pFinishByteOffset: ?*usize,
    ppDisassembly: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DCreateLinker(
    ppLinker: ?*?*ID3D11Linker,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DLoadModule(
    pSrcData: ?*const anyopaque,
    cbSrcDataSize: usize,
    ppModule: ?*?*ID3D11Module,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DCreateFunctionLinkingGraph(
    uFlags: u32,
    ppFunctionLinkingGraph: ?*?*ID3D11FunctionLinkingGraph,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DGetTraceInstructionOffsets(
    // TODO: what to do with BytesParamIndex 1?
    pSrcData: ?*const anyopaque,
    SrcDataSize: usize,
    Flags: u32,
    StartInstIndex: usize,
    NumInsts: usize,
    pOffsets: ?[*]usize,
    pTotalInsts: ?*usize,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DGetInputSignatureBlob(
    // TODO: what to do with BytesParamIndex 1?
    pSrcData: ?*const anyopaque,
    SrcDataSize: usize,
    ppSignatureBlob: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DGetOutputSignatureBlob(
    // TODO: what to do with BytesParamIndex 1?
    pSrcData: ?*const anyopaque,
    SrcDataSize: usize,
    ppSignatureBlob: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DGetInputAndOutputSignatureBlob(
    // TODO: what to do with BytesParamIndex 1?
    pSrcData: ?*const anyopaque,
    SrcDataSize: usize,
    ppSignatureBlob: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DStripShader(
    // TODO: what to do with BytesParamIndex 1?
    pShaderBytecode: ?*const anyopaque,
    BytecodeLength: usize,
    uStripFlags: u32,
    ppStrippedBlob: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DGetBlobPart(
    // TODO: what to do with BytesParamIndex 1?
    pSrcData: ?*const anyopaque,
    SrcDataSize: usize,
    Part: D3D_BLOB_PART,
    Flags: u32,
    ppPart: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DSetBlobPart(
    // TODO: what to do with BytesParamIndex 1?
    pSrcData: ?*const anyopaque,
    SrcDataSize: usize,
    Part: D3D_BLOB_PART,
    Flags: u32,
    // TODO: what to do with BytesParamIndex 5?
    pPart: ?*const anyopaque,
    PartSize: usize,
    ppNewShader: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DCreateBlob(
    Size: usize,
    ppBlob: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DCompressShaders(
    uNumShaders: u32,
    pShaderData: [*]D3D_SHADER_DATA,
    uFlags: u32,
    ppCompressedData: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DDecompressShaders(
    // TODO: what to do with BytesParamIndex 1?
    pSrcData: ?*const anyopaque,
    SrcDataSize: usize,
    uNumShaders: u32,
    uStartIndex: u32,
    pIndices: ?[*]u32,
    uFlags: u32,
    ppShaders: [*]?*ID3DBlob,
    pTotalShaders: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "d3dcompiler_47" fn D3DDisassemble10Effect(
    pEffect: ?*ID3D10Effect,
    Flags: u32,
    ppDisassembly: ?*?*ID3DBlob,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (12)
//--------------------------------------------------------------------------------
const Guid = @import("../../zig.zig").Guid;
const BOOL = @import("../../foundation.zig").BOOL;
const D3D_SHADER_MACRO = @import("../../graphics/direct3d.zig").D3D_SHADER_MACRO;
const HRESULT = @import("../../foundation.zig").HRESULT;
const ID3D10Effect = @import("../../graphics/direct3d10.zig").ID3D10Effect;
const ID3D11FunctionLinkingGraph = @import("../../graphics/direct3d11.zig").ID3D11FunctionLinkingGraph;
const ID3D11Linker = @import("../../graphics/direct3d11.zig").ID3D11Linker;
const ID3D11Module = @import("../../graphics/direct3d11.zig").ID3D11Module;
const ID3DBlob = @import("../../graphics/direct3d.zig").ID3DBlob;
const ID3DInclude = @import("../../graphics/direct3d.zig").ID3DInclude;
const PSTR = @import("../../foundation.zig").PSTR;
const PWSTR = @import("../../foundation.zig").PWSTR;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "pD3DCompile")) {
        _ = pD3DCompile;
    }
    if (@hasDecl(@This(), "pD3DPreprocess")) {
        _ = pD3DPreprocess;
    }
    if (@hasDecl(@This(), "pD3DDisassemble")) {
        _ = pD3DDisassemble;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
