//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (20)
//--------------------------------------------------------------------------------
pub const DXC_HASHFLAG_INCLUDES_SOURCE = @as(u32, 1);
pub const DxcValidatorFlags_Default = @as(u32, 0);
pub const DxcValidatorFlags_InPlaceEdit = @as(u32, 1);
pub const DxcValidatorFlags_RootSignatureOnly = @as(u32, 2);
pub const DxcValidatorFlags_ModuleOnly = @as(u32, 4);
pub const DxcValidatorFlags_ValidMask = @as(u32, 7);
pub const DxcVersionInfoFlags_None = @as(u32, 0);
pub const DxcVersionInfoFlags_Debug = @as(u32, 1);
pub const DxcVersionInfoFlags_Internal = @as(u32, 2);
pub const CLSID_DxcCompiler = Guid.initString("73e22d93-e6ce-47f3-b5bf-f0664f39c1b0");
pub const CLSID_DxcLinker = Guid.initString("ef6a8087-b0ea-4d56-9e45-d07e1a8b7806");
pub const CLSID_DxcDiaDataSource = Guid.initString("cd1f6b73-2ab0-484d-8edc-ebe7a43ca09f");
pub const CLSID_DxcCompilerArgs = Guid.initString("3e56ae82-224d-470f-a1a1-fe3016ee9f9d");
pub const CLSID_DxcLibrary = Guid.initString("6245d6af-66e0-48fd-80b4-4d271796748c");
pub const CLSID_DxcValidator = Guid.initString("8ca3e215-f728-4cf3-8cdd-88af917587a1");
pub const CLSID_DxcAssembler = Guid.initString("d728db68-f903-4f80-94cd-dccf76ec7151");
pub const CLSID_DxcContainerReflection = Guid.initString("b9f54489-55b8-400c-ba3a-1675e4728b91");
pub const CLSID_DxcOptimizer = Guid.initString("ae2cd79f-cc22-453f-9b6b-b124e7a5204c");
pub const CLSID_DxcContainerBuilder = Guid.initString("94134294-411f-4574-b4d0-8741e25240d2");
pub const CLSID_DxcPdbUtils = Guid.initString("54621dfb-f2ce-457e-ae8c-ec355faeec7c");

//--------------------------------------------------------------------------------
// Section: Types (34)
//--------------------------------------------------------------------------------
pub const DXC_CP = enum(u32) {
    ACP = 0,
    UTF16 = 1200,
    UTF8 = 65001,
};
pub const DXC_CP_ACP = DXC_CP.ACP;
pub const DXC_CP_UTF16 = DXC_CP.UTF16;
pub const DXC_CP_UTF8 = DXC_CP.UTF8;

pub const DxcCreateInstanceProc = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        rclsid: ?*const Guid,
        riid: ?*const Guid,
        ppv: ?*?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        rclsid: ?*const Guid,
        riid: ?*const Guid,
        ppv: ?*?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const DxcCreateInstance2Proc = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        pMalloc: ?*IMalloc,
        rclsid: ?*const Guid,
        riid: ?*const Guid,
        ppv: ?*?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        pMalloc: ?*IMalloc,
        rclsid: ?*const Guid,
        riid: ?*const Guid,
        ppv: ?*?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

pub const DxcShaderHash = extern struct {
    Flags: u32,
    HashDigest: [16]u8,
};

const IID_IDxcBlob_Value = Guid.initString("8ba5fb08-5195-40e2-ac58-0d989c3a0102");
pub const IID_IDxcBlob = &IID_IDxcBlob_Value;
pub const IDxcBlob = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetBufferPointer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) ?*anyopaque,
            else => *const fn (
                self: *const IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) ?*anyopaque,
        },
        GetBufferSize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) usize,
            else => *const fn (
                self: *const IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) usize,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcBlob_GetBufferPointer(self: *const T) ?*anyopaque {
                return @as(*const IDxcBlob.VTable, @ptrCast(self.vtable)).GetBufferPointer(@as(*const IDxcBlob, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcBlob_GetBufferSize(self: *const T) usize {
                return @as(*const IDxcBlob.VTable, @ptrCast(self.vtable)).GetBufferSize(@as(*const IDxcBlob, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcBlobEncoding_Value = Guid.initString("7241d424-2646-4191-97c0-98e96e42fc68");
pub const IID_IDxcBlobEncoding = &IID_IDxcBlobEncoding_Value;
pub const IDxcBlobEncoding = extern struct {
    pub const VTable = extern struct {
        base: IDxcBlob.VTable,
        GetEncoding: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcBlobEncoding,
                pKnown: ?*BOOL,
                pCodePage: ?*DXC_CP,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcBlobEncoding,
                pKnown: ?*BOOL,
                pCodePage: ?*DXC_CP,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDxcBlob.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcBlobEncoding_GetEncoding(self: *const T, pKnown: ?*BOOL, pCodePage: ?*DXC_CP) HRESULT {
                return @as(*const IDxcBlobEncoding.VTable, @ptrCast(self.vtable)).GetEncoding(@as(*const IDxcBlobEncoding, @ptrCast(self)), pKnown, pCodePage);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcBlobUtf16_Value = Guid.initString("a3f84eab-0faa-497e-a39c-ee6ed60b2d84");
pub const IID_IDxcBlobUtf16 = &IID_IDxcBlobUtf16_Value;
pub const IDxcBlobUtf16 = extern struct {
    pub const VTable = extern struct {
        base: IDxcBlobEncoding.VTable,
        GetStringPointer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcBlobUtf16,
            ) callconv(@import("std").os.windows.WINAPI) ?PWSTR,
            else => *const fn (
                self: *const IDxcBlobUtf16,
            ) callconv(@import("std").os.windows.WINAPI) ?PWSTR,
        },
        GetStringLength: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcBlobUtf16,
            ) callconv(@import("std").os.windows.WINAPI) usize,
            else => *const fn (
                self: *const IDxcBlobUtf16,
            ) callconv(@import("std").os.windows.WINAPI) usize,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDxcBlobEncoding.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcBlobUtf16_GetStringPointer(self: *const T) ?PWSTR {
                return @as(*const IDxcBlobUtf16.VTable, @ptrCast(self.vtable)).GetStringPointer(@as(*const IDxcBlobUtf16, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcBlobUtf16_GetStringLength(self: *const T) usize {
                return @as(*const IDxcBlobUtf16.VTable, @ptrCast(self.vtable)).GetStringLength(@as(*const IDxcBlobUtf16, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcBlobUtf8_Value = Guid.initString("3da636c9-ba71-4024-a301-30cbf125305b");
pub const IID_IDxcBlobUtf8 = &IID_IDxcBlobUtf8_Value;
pub const IDxcBlobUtf8 = extern struct {
    pub const VTable = extern struct {
        base: IDxcBlobEncoding.VTable,
        GetStringPointer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcBlobUtf8,
            ) callconv(@import("std").os.windows.WINAPI) ?PSTR,
            else => *const fn (
                self: *const IDxcBlobUtf8,
            ) callconv(@import("std").os.windows.WINAPI) ?PSTR,
        },
        GetStringLength: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcBlobUtf8,
            ) callconv(@import("std").os.windows.WINAPI) usize,
            else => *const fn (
                self: *const IDxcBlobUtf8,
            ) callconv(@import("std").os.windows.WINAPI) usize,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDxcBlobEncoding.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcBlobUtf8_GetStringPointer(self: *const T) ?PSTR {
                return @as(*const IDxcBlobUtf8.VTable, @ptrCast(self.vtable)).GetStringPointer(@as(*const IDxcBlobUtf8, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcBlobUtf8_GetStringLength(self: *const T) usize {
                return @as(*const IDxcBlobUtf8.VTable, @ptrCast(self.vtable)).GetStringLength(@as(*const IDxcBlobUtf8, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcIncludeHandler_Value = Guid.initString("7f61fc7d-950d-467f-b3e3-3c02fb49187c");
pub const IID_IDxcIncludeHandler = &IID_IDxcIncludeHandler_Value;
pub const IDxcIncludeHandler = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        LoadSource: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcIncludeHandler,
                pFilename: ?[*:0]const u16,
                ppIncludeSource: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcIncludeHandler,
                pFilename: ?[*:0]const u16,
                ppIncludeSource: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcIncludeHandler_LoadSource(self: *const T, pFilename: ?[*:0]const u16, ppIncludeSource: ?*?*IDxcBlob) HRESULT {
                return @as(*const IDxcIncludeHandler.VTable, @ptrCast(self.vtable)).LoadSource(@as(*const IDxcIncludeHandler, @ptrCast(self)), pFilename, ppIncludeSource);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const DxcBuffer = extern struct {
    Ptr: ?*const anyopaque,
    Size: usize,
    Encoding: u32,
};

pub const DxcDefine = extern struct {
    Name: ?[*:0]const u16,
    Value: ?[*:0]const u16,
};

const IID_IDxcCompilerArgs_Value = Guid.initString("73effe2a-70dc-45f8-9690-eff64c02429d");
pub const IID_IDxcCompilerArgs = &IID_IDxcCompilerArgs_Value;
pub const IDxcCompilerArgs = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetArguments: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcCompilerArgs,
            ) callconv(@import("std").os.windows.WINAPI) ?*?PWSTR,
            else => *const fn (
                self: *const IDxcCompilerArgs,
            ) callconv(@import("std").os.windows.WINAPI) ?*?PWSTR,
        },
        GetCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcCompilerArgs,
            ) callconv(@import("std").os.windows.WINAPI) u32,
            else => *const fn (
                self: *const IDxcCompilerArgs,
            ) callconv(@import("std").os.windows.WINAPI) u32,
        },
        AddArguments: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcCompilerArgs,
                pArguments: ?[*]?PWSTR,
                argCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcCompilerArgs,
                pArguments: ?[*]?PWSTR,
                argCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddArgumentsUTF8: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcCompilerArgs,
                pArguments: ?[*]?PSTR,
                argCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcCompilerArgs,
                pArguments: ?[*]?PSTR,
                argCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddDefines: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcCompilerArgs,
                pDefines: [*]const DxcDefine,
                defineCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcCompilerArgs,
                pDefines: [*]const DxcDefine,
                defineCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcCompilerArgs_GetArguments(self: *const T) ?*?PWSTR {
                return @as(*const IDxcCompilerArgs.VTable, @ptrCast(self.vtable)).GetArguments(@as(*const IDxcCompilerArgs, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcCompilerArgs_GetCount(self: *const T) u32 {
                return @as(*const IDxcCompilerArgs.VTable, @ptrCast(self.vtable)).GetCount(@as(*const IDxcCompilerArgs, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcCompilerArgs_AddArguments(self: *const T, pArguments: ?[*]?PWSTR, argCount: u32) HRESULT {
                return @as(*const IDxcCompilerArgs.VTable, @ptrCast(self.vtable)).AddArguments(@as(*const IDxcCompilerArgs, @ptrCast(self)), pArguments, argCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcCompilerArgs_AddArgumentsUTF8(self: *const T, pArguments: ?[*]?PSTR, argCount: u32) HRESULT {
                return @as(*const IDxcCompilerArgs.VTable, @ptrCast(self.vtable)).AddArgumentsUTF8(@as(*const IDxcCompilerArgs, @ptrCast(self)), pArguments, argCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcCompilerArgs_AddDefines(self: *const T, pDefines: [*]const DxcDefine, defineCount: u32) HRESULT {
                return @as(*const IDxcCompilerArgs.VTable, @ptrCast(self.vtable)).AddDefines(@as(*const IDxcCompilerArgs, @ptrCast(self)), pDefines, defineCount);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcLibrary_Value = Guid.initString("e5204dc7-d18c-4c3c-bdfb-851673980fe7");
pub const IID_IDxcLibrary = &IID_IDxcLibrary_Value;
pub const IDxcLibrary = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetMalloc: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcLibrary,
                pMalloc: ?*IMalloc,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcLibrary,
                pMalloc: ?*IMalloc,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateBlobFromBlob: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcLibrary,
                pBlob: ?*IDxcBlob,
                offset: u32,
                length: u32,
                ppResult: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcLibrary,
                pBlob: ?*IDxcBlob,
                offset: u32,
                length: u32,
                ppResult: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateBlobFromFile: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcLibrary,
                pFileName: ?[*:0]const u16,
                codePage: ?*DXC_CP,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcLibrary,
                pFileName: ?[*:0]const u16,
                codePage: ?*DXC_CP,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateBlobWithEncodingFromPinned: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcLibrary,
                // TODO: what to do with BytesParamIndex 1?
                pText: ?*const anyopaque,
                size: u32,
                codePage: DXC_CP,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcLibrary,
                // TODO: what to do with BytesParamIndex 1?
                pText: ?*const anyopaque,
                size: u32,
                codePage: DXC_CP,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateBlobWithEncodingOnHeapCopy: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcLibrary,
                // TODO: what to do with BytesParamIndex 1?
                pText: ?*const anyopaque,
                size: u32,
                codePage: DXC_CP,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcLibrary,
                // TODO: what to do with BytesParamIndex 1?
                pText: ?*const anyopaque,
                size: u32,
                codePage: DXC_CP,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateBlobWithEncodingOnMalloc: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcLibrary,
                // TODO: what to do with BytesParamIndex 2?
                pText: ?*const anyopaque,
                pIMalloc: ?*IMalloc,
                size: u32,
                codePage: DXC_CP,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcLibrary,
                // TODO: what to do with BytesParamIndex 2?
                pText: ?*const anyopaque,
                pIMalloc: ?*IMalloc,
                size: u32,
                codePage: DXC_CP,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateIncludeHandler: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcLibrary,
                ppResult: ?*?*IDxcIncludeHandler,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcLibrary,
                ppResult: ?*?*IDxcIncludeHandler,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateStreamFromBlobReadOnly: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcLibrary,
                pBlob: ?*IDxcBlob,
                ppStream: ?*?*IStream,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcLibrary,
                pBlob: ?*IDxcBlob,
                ppStream: ?*?*IStream,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetBlobAsUtf8: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcLibrary,
                pBlob: ?*IDxcBlob,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcLibrary,
                pBlob: ?*IDxcBlob,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetBlobAsUtf16: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcLibrary,
                pBlob: ?*IDxcBlob,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcLibrary,
                pBlob: ?*IDxcBlob,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcLibrary_SetMalloc(self: *const T, pMalloc: ?*IMalloc) HRESULT {
                return @as(*const IDxcLibrary.VTable, @ptrCast(self.vtable)).SetMalloc(@as(*const IDxcLibrary, @ptrCast(self)), pMalloc);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcLibrary_CreateBlobFromBlob(self: *const T, pBlob: ?*IDxcBlob, offset: u32, length: u32, ppResult: ?*?*IDxcBlob) HRESULT {
                return @as(*const IDxcLibrary.VTable, @ptrCast(self.vtable)).CreateBlobFromBlob(@as(*const IDxcLibrary, @ptrCast(self)), pBlob, offset, length, ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcLibrary_CreateBlobFromFile(self: *const T, pFileName: ?[*:0]const u16, codePage: ?*DXC_CP, pBlobEncoding: ?*?*IDxcBlobEncoding) HRESULT {
                return @as(*const IDxcLibrary.VTable, @ptrCast(self.vtable)).CreateBlobFromFile(@as(*const IDxcLibrary, @ptrCast(self)), pFileName, codePage, pBlobEncoding);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcLibrary_CreateBlobWithEncodingFromPinned(self: *const T, pText: ?*const anyopaque, size: u32, codePage: DXC_CP, pBlobEncoding: ?*?*IDxcBlobEncoding) HRESULT {
                return @as(*const IDxcLibrary.VTable, @ptrCast(self.vtable)).CreateBlobWithEncodingFromPinned(@as(*const IDxcLibrary, @ptrCast(self)), pText, size, codePage, pBlobEncoding);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcLibrary_CreateBlobWithEncodingOnHeapCopy(self: *const T, pText: ?*const anyopaque, size: u32, codePage: DXC_CP, pBlobEncoding: ?*?*IDxcBlobEncoding) HRESULT {
                return @as(*const IDxcLibrary.VTable, @ptrCast(self.vtable)).CreateBlobWithEncodingOnHeapCopy(@as(*const IDxcLibrary, @ptrCast(self)), pText, size, codePage, pBlobEncoding);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcLibrary_CreateBlobWithEncodingOnMalloc(self: *const T, pText: ?*const anyopaque, pIMalloc: ?*IMalloc, size: u32, codePage: DXC_CP, pBlobEncoding: ?*?*IDxcBlobEncoding) HRESULT {
                return @as(*const IDxcLibrary.VTable, @ptrCast(self.vtable)).CreateBlobWithEncodingOnMalloc(@as(*const IDxcLibrary, @ptrCast(self)), pText, pIMalloc, size, codePage, pBlobEncoding);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcLibrary_CreateIncludeHandler(self: *const T, ppResult: ?*?*IDxcIncludeHandler) HRESULT {
                return @as(*const IDxcLibrary.VTable, @ptrCast(self.vtable)).CreateIncludeHandler(@as(*const IDxcLibrary, @ptrCast(self)), ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcLibrary_CreateStreamFromBlobReadOnly(self: *const T, pBlob: ?*IDxcBlob, ppStream: ?*?*IStream) HRESULT {
                return @as(*const IDxcLibrary.VTable, @ptrCast(self.vtable)).CreateStreamFromBlobReadOnly(@as(*const IDxcLibrary, @ptrCast(self)), pBlob, ppStream);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcLibrary_GetBlobAsUtf8(self: *const T, pBlob: ?*IDxcBlob, pBlobEncoding: ?*?*IDxcBlobEncoding) HRESULT {
                return @as(*const IDxcLibrary.VTable, @ptrCast(self.vtable)).GetBlobAsUtf8(@as(*const IDxcLibrary, @ptrCast(self)), pBlob, pBlobEncoding);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcLibrary_GetBlobAsUtf16(self: *const T, pBlob: ?*IDxcBlob, pBlobEncoding: ?*?*IDxcBlobEncoding) HRESULT {
                return @as(*const IDxcLibrary.VTable, @ptrCast(self.vtable)).GetBlobAsUtf16(@as(*const IDxcLibrary, @ptrCast(self)), pBlob, pBlobEncoding);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcOperationResult_Value = Guid.initString("cedb484a-d4e9-445a-b991-ca21ca157dc2");
pub const IID_IDxcOperationResult = &IID_IDxcOperationResult_Value;
pub const IDxcOperationResult = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetStatus: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcOperationResult,
                pStatus: ?*HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcOperationResult,
                pStatus: ?*HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetResult: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcOperationResult,
                ppResult: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcOperationResult,
                ppResult: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetErrorBuffer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcOperationResult,
                ppErrors: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcOperationResult,
                ppErrors: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcOperationResult_GetStatus(self: *const T, pStatus: ?*HRESULT) HRESULT {
                return @as(*const IDxcOperationResult.VTable, @ptrCast(self.vtable)).GetStatus(@as(*const IDxcOperationResult, @ptrCast(self)), pStatus);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcOperationResult_GetResult(self: *const T, ppResult: ?*?*IDxcBlob) HRESULT {
                return @as(*const IDxcOperationResult.VTable, @ptrCast(self.vtable)).GetResult(@as(*const IDxcOperationResult, @ptrCast(self)), ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcOperationResult_GetErrorBuffer(self: *const T, ppErrors: ?*?*IDxcBlobEncoding) HRESULT {
                return @as(*const IDxcOperationResult.VTable, @ptrCast(self.vtable)).GetErrorBuffer(@as(*const IDxcOperationResult, @ptrCast(self)), ppErrors);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcCompiler_Value = Guid.initString("8c210bf3-011f-4422-8d70-6f9acb8db617");
pub const IID_IDxcCompiler = &IID_IDxcCompiler_Value;
pub const IDxcCompiler = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Compile: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcCompiler,
                pSource: ?*IDxcBlob,
                pSourceName: ?[*:0]const u16,
                pEntryPoint: ?[*:0]const u16,
                pTargetProfile: ?[*:0]const u16,
                pArguments: ?[*]?PWSTR,
                argCount: u32,
                pDefines: [*]const DxcDefine,
                defineCount: u32,
                pIncludeHandler: ?*IDxcIncludeHandler,
                ppResult: ?*?*IDxcOperationResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcCompiler,
                pSource: ?*IDxcBlob,
                pSourceName: ?[*:0]const u16,
                pEntryPoint: ?[*:0]const u16,
                pTargetProfile: ?[*:0]const u16,
                pArguments: ?[*]?PWSTR,
                argCount: u32,
                pDefines: [*]const DxcDefine,
                defineCount: u32,
                pIncludeHandler: ?*IDxcIncludeHandler,
                ppResult: ?*?*IDxcOperationResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Preprocess: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcCompiler,
                pSource: ?*IDxcBlob,
                pSourceName: ?[*:0]const u16,
                pArguments: ?[*]?PWSTR,
                argCount: u32,
                pDefines: [*]const DxcDefine,
                defineCount: u32,
                pIncludeHandler: ?*IDxcIncludeHandler,
                ppResult: ?*?*IDxcOperationResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcCompiler,
                pSource: ?*IDxcBlob,
                pSourceName: ?[*:0]const u16,
                pArguments: ?[*]?PWSTR,
                argCount: u32,
                pDefines: [*]const DxcDefine,
                defineCount: u32,
                pIncludeHandler: ?*IDxcIncludeHandler,
                ppResult: ?*?*IDxcOperationResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Disassemble: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcCompiler,
                pSource: ?*IDxcBlob,
                ppDisassembly: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcCompiler,
                pSource: ?*IDxcBlob,
                ppDisassembly: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcCompiler_Compile(self: *const T, pSource: ?*IDxcBlob, pSourceName: ?[*:0]const u16, pEntryPoint: ?[*:0]const u16, pTargetProfile: ?[*:0]const u16, pArguments: ?[*]?PWSTR, argCount: u32, pDefines: [*]const DxcDefine, defineCount: u32, pIncludeHandler: ?*IDxcIncludeHandler, ppResult: ?*?*IDxcOperationResult) HRESULT {
                return @as(*const IDxcCompiler.VTable, @ptrCast(self.vtable)).Compile(@as(*const IDxcCompiler, @ptrCast(self)), pSource, pSourceName, pEntryPoint, pTargetProfile, pArguments, argCount, pDefines, defineCount, pIncludeHandler, ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcCompiler_Preprocess(self: *const T, pSource: ?*IDxcBlob, pSourceName: ?[*:0]const u16, pArguments: ?[*]?PWSTR, argCount: u32, pDefines: [*]const DxcDefine, defineCount: u32, pIncludeHandler: ?*IDxcIncludeHandler, ppResult: ?*?*IDxcOperationResult) HRESULT {
                return @as(*const IDxcCompiler.VTable, @ptrCast(self.vtable)).Preprocess(@as(*const IDxcCompiler, @ptrCast(self)), pSource, pSourceName, pArguments, argCount, pDefines, defineCount, pIncludeHandler, ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcCompiler_Disassemble(self: *const T, pSource: ?*IDxcBlob, ppDisassembly: ?*?*IDxcBlobEncoding) HRESULT {
                return @as(*const IDxcCompiler.VTable, @ptrCast(self.vtable)).Disassemble(@as(*const IDxcCompiler, @ptrCast(self)), pSource, ppDisassembly);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcCompiler2_Value = Guid.initString("a005a9d9-b8bb-4594-b5c9-0e633bec4d37");
pub const IID_IDxcCompiler2 = &IID_IDxcCompiler2_Value;
pub const IDxcCompiler2 = extern struct {
    pub const VTable = extern struct {
        base: IDxcCompiler.VTable,
        CompileWithDebug: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcCompiler2,
                pSource: ?*IDxcBlob,
                pSourceName: ?[*:0]const u16,
                pEntryPoint: ?[*:0]const u16,
                pTargetProfile: ?[*:0]const u16,
                pArguments: ?[*]?PWSTR,
                argCount: u32,
                pDefines: [*]const DxcDefine,
                defineCount: u32,
                pIncludeHandler: ?*IDxcIncludeHandler,
                ppResult: ?*?*IDxcOperationResult,
                ppDebugBlobName: ?*?PWSTR,
                ppDebugBlob: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcCompiler2,
                pSource: ?*IDxcBlob,
                pSourceName: ?[*:0]const u16,
                pEntryPoint: ?[*:0]const u16,
                pTargetProfile: ?[*:0]const u16,
                pArguments: ?[*]?PWSTR,
                argCount: u32,
                pDefines: [*]const DxcDefine,
                defineCount: u32,
                pIncludeHandler: ?*IDxcIncludeHandler,
                ppResult: ?*?*IDxcOperationResult,
                ppDebugBlobName: ?*?PWSTR,
                ppDebugBlob: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDxcCompiler.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcCompiler2_CompileWithDebug(self: *const T, pSource: ?*IDxcBlob, pSourceName: ?[*:0]const u16, pEntryPoint: ?[*:0]const u16, pTargetProfile: ?[*:0]const u16, pArguments: ?[*]?PWSTR, argCount: u32, pDefines: [*]const DxcDefine, defineCount: u32, pIncludeHandler: ?*IDxcIncludeHandler, ppResult: ?*?*IDxcOperationResult, ppDebugBlobName: ?*?PWSTR, ppDebugBlob: ?*?*IDxcBlob) HRESULT {
                return @as(*const IDxcCompiler2.VTable, @ptrCast(self.vtable)).CompileWithDebug(@as(*const IDxcCompiler2, @ptrCast(self)), pSource, pSourceName, pEntryPoint, pTargetProfile, pArguments, argCount, pDefines, defineCount, pIncludeHandler, ppResult, ppDebugBlobName, ppDebugBlob);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcLinker_Value = Guid.initString("f1b5be2a-62dd-4327-a1c2-42ac1e1e78e6");
pub const IID_IDxcLinker = &IID_IDxcLinker_Value;
pub const IDxcLinker = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        RegisterLibrary: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcLinker,
                pLibName: ?[*:0]const u16,
                pLib: ?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcLinker,
                pLibName: ?[*:0]const u16,
                pLib: ?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Link: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcLinker,
                pEntryName: ?[*:0]const u16,
                pTargetProfile: ?[*:0]const u16,
                pLibNames: [*]const ?[*:0]const u16,
                libCount: u32,
                pArguments: ?[*]const ?[*:0]const u16,
                argCount: u32,
                ppResult: ?*?*IDxcOperationResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcLinker,
                pEntryName: ?[*:0]const u16,
                pTargetProfile: ?[*:0]const u16,
                pLibNames: [*]const ?[*:0]const u16,
                libCount: u32,
                pArguments: ?[*]const ?[*:0]const u16,
                argCount: u32,
                ppResult: ?*?*IDxcOperationResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcLinker_RegisterLibrary(self: *const T, pLibName: ?[*:0]const u16, pLib: ?*IDxcBlob) HRESULT {
                return @as(*const IDxcLinker.VTable, @ptrCast(self.vtable)).RegisterLibrary(@as(*const IDxcLinker, @ptrCast(self)), pLibName, pLib);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcLinker_Link(self: *const T, pEntryName: ?[*:0]const u16, pTargetProfile: ?[*:0]const u16, pLibNames: [*]const ?[*:0]const u16, libCount: u32, pArguments: ?[*]const ?[*:0]const u16, argCount: u32, ppResult: ?*?*IDxcOperationResult) HRESULT {
                return @as(*const IDxcLinker.VTable, @ptrCast(self.vtable)).Link(@as(*const IDxcLinker, @ptrCast(self)), pEntryName, pTargetProfile, pLibNames, libCount, pArguments, argCount, ppResult);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcUtils_Value = Guid.initString("4605c4cb-2019-492a-ada4-65f20bb7d67f");
pub const IID_IDxcUtils = &IID_IDxcUtils_Value;
pub const IDxcUtils = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        CreateBlobFromBlob: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcUtils,
                pBlob: ?*IDxcBlob,
                offset: u32,
                length: u32,
                ppResult: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcUtils,
                pBlob: ?*IDxcBlob,
                offset: u32,
                length: u32,
                ppResult: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateBlobFromPinned: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcUtils,
                // TODO: what to do with BytesParamIndex 1?
                pData: ?*const anyopaque,
                size: u32,
                codePage: DXC_CP,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcUtils,
                // TODO: what to do with BytesParamIndex 1?
                pData: ?*const anyopaque,
                size: u32,
                codePage: DXC_CP,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        MoveToBlob: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcUtils,
                // TODO: what to do with BytesParamIndex 2?
                pData: ?*const anyopaque,
                pIMalloc: ?*IMalloc,
                size: u32,
                codePage: DXC_CP,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcUtils,
                // TODO: what to do with BytesParamIndex 2?
                pData: ?*const anyopaque,
                pIMalloc: ?*IMalloc,
                size: u32,
                codePage: DXC_CP,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateBlob: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcUtils,
                // TODO: what to do with BytesParamIndex 1?
                pData: ?*const anyopaque,
                size: u32,
                codePage: DXC_CP,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcUtils,
                // TODO: what to do with BytesParamIndex 1?
                pData: ?*const anyopaque,
                size: u32,
                codePage: DXC_CP,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        LoadFile: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcUtils,
                pFileName: ?[*:0]const u16,
                pCodePage: ?*DXC_CP,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcUtils,
                pFileName: ?[*:0]const u16,
                pCodePage: ?*DXC_CP,
                pBlobEncoding: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateReadOnlyStreamFromBlob: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcUtils,
                pBlob: ?*IDxcBlob,
                ppStream: ?*?*IStream,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcUtils,
                pBlob: ?*IDxcBlob,
                ppStream: ?*?*IStream,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateDefaultIncludeHandler: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcUtils,
                ppResult: ?*?*IDxcIncludeHandler,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcUtils,
                ppResult: ?*?*IDxcIncludeHandler,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetBlobAsUtf8: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcUtils,
                pBlob: ?*IDxcBlob,
                pBlobEncoding: ?*?*IDxcBlobUtf8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcUtils,
                pBlob: ?*IDxcBlob,
                pBlobEncoding: ?*?*IDxcBlobUtf8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetBlobAsUtf16: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcUtils,
                pBlob: ?*IDxcBlob,
                pBlobEncoding: ?*?*IDxcBlobUtf16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcUtils,
                pBlob: ?*IDxcBlob,
                pBlobEncoding: ?*?*IDxcBlobUtf16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDxilContainerPart: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcUtils,
                pShader: ?*const DxcBuffer,
                DxcPart: u32,
                ppPartData: ?*?*anyopaque,
                pPartSizeInBytes: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcUtils,
                pShader: ?*const DxcBuffer,
                DxcPart: u32,
                ppPartData: ?*?*anyopaque,
                pPartSizeInBytes: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateReflection: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcUtils,
                pData: ?*const DxcBuffer,
                iid: ?*const Guid,
                ppvReflection: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcUtils,
                pData: ?*const DxcBuffer,
                iid: ?*const Guid,
                ppvReflection: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        BuildArguments: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcUtils,
                pSourceName: ?[*:0]const u16,
                pEntryPoint: ?[*:0]const u16,
                pTargetProfile: ?[*:0]const u16,
                pArguments: ?[*]?PWSTR,
                argCount: u32,
                pDefines: [*]const DxcDefine,
                defineCount: u32,
                ppArgs: ?*?*IDxcCompilerArgs,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcUtils,
                pSourceName: ?[*:0]const u16,
                pEntryPoint: ?[*:0]const u16,
                pTargetProfile: ?[*:0]const u16,
                pArguments: ?[*]?PWSTR,
                argCount: u32,
                pDefines: [*]const DxcDefine,
                defineCount: u32,
                ppArgs: ?*?*IDxcCompilerArgs,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPDBContents: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcUtils,
                pPDBBlob: ?*IDxcBlob,
                ppHash: ?*?*IDxcBlob,
                ppContainer: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcUtils,
                pPDBBlob: ?*IDxcBlob,
                ppHash: ?*?*IDxcBlob,
                ppContainer: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcUtils_CreateBlobFromBlob(self: *const T, pBlob: ?*IDxcBlob, offset: u32, length: u32, ppResult: ?*?*IDxcBlob) HRESULT {
                return @as(*const IDxcUtils.VTable, @ptrCast(self.vtable)).CreateBlobFromBlob(@as(*const IDxcUtils, @ptrCast(self)), pBlob, offset, length, ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcUtils_CreateBlobFromPinned(self: *const T, pData: ?*const anyopaque, size: u32, codePage: DXC_CP, pBlobEncoding: ?*?*IDxcBlobEncoding) HRESULT {
                return @as(*const IDxcUtils.VTable, @ptrCast(self.vtable)).CreateBlobFromPinned(@as(*const IDxcUtils, @ptrCast(self)), pData, size, codePage, pBlobEncoding);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcUtils_MoveToBlob(self: *const T, pData: ?*const anyopaque, pIMalloc: ?*IMalloc, size: u32, codePage: DXC_CP, pBlobEncoding: ?*?*IDxcBlobEncoding) HRESULT {
                return @as(*const IDxcUtils.VTable, @ptrCast(self.vtable)).MoveToBlob(@as(*const IDxcUtils, @ptrCast(self)), pData, pIMalloc, size, codePage, pBlobEncoding);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcUtils_CreateBlob(self: *const T, pData: ?*const anyopaque, size: u32, codePage: DXC_CP, pBlobEncoding: ?*?*IDxcBlobEncoding) HRESULT {
                return @as(*const IDxcUtils.VTable, @ptrCast(self.vtable)).CreateBlob(@as(*const IDxcUtils, @ptrCast(self)), pData, size, codePage, pBlobEncoding);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcUtils_LoadFile(self: *const T, pFileName: ?[*:0]const u16, pCodePage: ?*DXC_CP, pBlobEncoding: ?*?*IDxcBlobEncoding) HRESULT {
                return @as(*const IDxcUtils.VTable, @ptrCast(self.vtable)).LoadFile(@as(*const IDxcUtils, @ptrCast(self)), pFileName, pCodePage, pBlobEncoding);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcUtils_CreateReadOnlyStreamFromBlob(self: *const T, pBlob: ?*IDxcBlob, ppStream: ?*?*IStream) HRESULT {
                return @as(*const IDxcUtils.VTable, @ptrCast(self.vtable)).CreateReadOnlyStreamFromBlob(@as(*const IDxcUtils, @ptrCast(self)), pBlob, ppStream);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcUtils_CreateDefaultIncludeHandler(self: *const T, ppResult: ?*?*IDxcIncludeHandler) HRESULT {
                return @as(*const IDxcUtils.VTable, @ptrCast(self.vtable)).CreateDefaultIncludeHandler(@as(*const IDxcUtils, @ptrCast(self)), ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcUtils_GetBlobAsUtf8(self: *const T, pBlob: ?*IDxcBlob, pBlobEncoding: ?*?*IDxcBlobUtf8) HRESULT {
                return @as(*const IDxcUtils.VTable, @ptrCast(self.vtable)).GetBlobAsUtf8(@as(*const IDxcUtils, @ptrCast(self)), pBlob, pBlobEncoding);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcUtils_GetBlobAsUtf16(self: *const T, pBlob: ?*IDxcBlob, pBlobEncoding: ?*?*IDxcBlobUtf16) HRESULT {
                return @as(*const IDxcUtils.VTable, @ptrCast(self.vtable)).GetBlobAsUtf16(@as(*const IDxcUtils, @ptrCast(self)), pBlob, pBlobEncoding);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcUtils_GetDxilContainerPart(self: *const T, pShader: ?*const DxcBuffer, DxcPart: u32, ppPartData: ?*?*anyopaque, pPartSizeInBytes: ?*u32) HRESULT {
                return @as(*const IDxcUtils.VTable, @ptrCast(self.vtable)).GetDxilContainerPart(@as(*const IDxcUtils, @ptrCast(self)), pShader, DxcPart, ppPartData, pPartSizeInBytes);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcUtils_CreateReflection(self: *const T, pData: ?*const DxcBuffer, iid: ?*const Guid, ppvReflection: ?*?*anyopaque) HRESULT {
                return @as(*const IDxcUtils.VTable, @ptrCast(self.vtable)).CreateReflection(@as(*const IDxcUtils, @ptrCast(self)), pData, iid, ppvReflection);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcUtils_BuildArguments(self: *const T, pSourceName: ?[*:0]const u16, pEntryPoint: ?[*:0]const u16, pTargetProfile: ?[*:0]const u16, pArguments: ?[*]?PWSTR, argCount: u32, pDefines: [*]const DxcDefine, defineCount: u32, ppArgs: ?*?*IDxcCompilerArgs) HRESULT {
                return @as(*const IDxcUtils.VTable, @ptrCast(self.vtable)).BuildArguments(@as(*const IDxcUtils, @ptrCast(self)), pSourceName, pEntryPoint, pTargetProfile, pArguments, argCount, pDefines, defineCount, ppArgs);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcUtils_GetPDBContents(self: *const T, pPDBBlob: ?*IDxcBlob, ppHash: ?*?*IDxcBlob, ppContainer: ?*?*IDxcBlob) HRESULT {
                return @as(*const IDxcUtils.VTable, @ptrCast(self.vtable)).GetPDBContents(@as(*const IDxcUtils, @ptrCast(self)), pPDBBlob, ppHash, ppContainer);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const DXC_OUT_KIND = enum(i32) {
    NONE = 0,
    OBJECT = 1,
    ERRORS = 2,
    PDB = 3,
    SHADER_HASH = 4,
    DISASSEMBLY = 5,
    HLSL = 6,
    TEXT = 7,
    REFLECTION = 8,
    ROOT_SIGNATURE = 9,
    EXTRA_OUTPUTS = 10,
    FORCE_DWORD = -1,
};
pub const DXC_OUT_NONE = DXC_OUT_KIND.NONE;
pub const DXC_OUT_OBJECT = DXC_OUT_KIND.OBJECT;
pub const DXC_OUT_ERRORS = DXC_OUT_KIND.ERRORS;
pub const DXC_OUT_PDB = DXC_OUT_KIND.PDB;
pub const DXC_OUT_SHADER_HASH = DXC_OUT_KIND.SHADER_HASH;
pub const DXC_OUT_DISASSEMBLY = DXC_OUT_KIND.DISASSEMBLY;
pub const DXC_OUT_HLSL = DXC_OUT_KIND.HLSL;
pub const DXC_OUT_TEXT = DXC_OUT_KIND.TEXT;
pub const DXC_OUT_REFLECTION = DXC_OUT_KIND.REFLECTION;
pub const DXC_OUT_ROOT_SIGNATURE = DXC_OUT_KIND.ROOT_SIGNATURE;
pub const DXC_OUT_EXTRA_OUTPUTS = DXC_OUT_KIND.EXTRA_OUTPUTS;
pub const DXC_OUT_FORCE_DWORD = DXC_OUT_KIND.FORCE_DWORD;

const IID_IDxcResult_Value = Guid.initString("58346cda-dde7-4497-9461-6f87af5e0659");
pub const IID_IDxcResult = &IID_IDxcResult_Value;
pub const IDxcResult = extern struct {
    pub const VTable = extern struct {
        base: IDxcOperationResult.VTable,
        HasOutput: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcResult,
                dxcOutKind: DXC_OUT_KIND,
            ) callconv(@import("std").os.windows.WINAPI) BOOL,
            else => *const fn (
                self: *const IDxcResult,
                dxcOutKind: DXC_OUT_KIND,
            ) callconv(@import("std").os.windows.WINAPI) BOOL,
        },
        GetOutput: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcResult,
                dxcOutKind: DXC_OUT_KIND,
                iid: ?*const Guid,
                ppvObject: ?*?*anyopaque,
                ppOutputName: ?*?*IDxcBlobUtf16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcResult,
                dxcOutKind: DXC_OUT_KIND,
                iid: ?*const Guid,
                ppvObject: ?*?*anyopaque,
                ppOutputName: ?*?*IDxcBlobUtf16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetNumOutputs: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcResult,
            ) callconv(@import("std").os.windows.WINAPI) u32,
            else => *const fn (
                self: *const IDxcResult,
            ) callconv(@import("std").os.windows.WINAPI) u32,
        },
        GetOutputByIndex: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcResult,
                Index: u32,
            ) callconv(@import("std").os.windows.WINAPI) DXC_OUT_KIND,
            else => *const fn (
                self: *const IDxcResult,
                Index: u32,
            ) callconv(@import("std").os.windows.WINAPI) DXC_OUT_KIND,
        },
        PrimaryOutput: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcResult,
            ) callconv(@import("std").os.windows.WINAPI) DXC_OUT_KIND,
            else => *const fn (
                self: *const IDxcResult,
            ) callconv(@import("std").os.windows.WINAPI) DXC_OUT_KIND,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDxcOperationResult.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcResult_HasOutput(self: *const T, dxcOutKind: DXC_OUT_KIND) BOOL {
                return @as(*const IDxcResult.VTable, @ptrCast(self.vtable)).HasOutput(@as(*const IDxcResult, @ptrCast(self)), dxcOutKind);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcResult_GetOutput(self: *const T, dxcOutKind: DXC_OUT_KIND, iid: ?*const Guid, ppvObject: ?*?*anyopaque, ppOutputName: ?*?*IDxcBlobUtf16) HRESULT {
                return @as(*const IDxcResult.VTable, @ptrCast(self.vtable)).GetOutput(@as(*const IDxcResult, @ptrCast(self)), dxcOutKind, iid, ppvObject, ppOutputName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcResult_GetNumOutputs(self: *const T) u32 {
                return @as(*const IDxcResult.VTable, @ptrCast(self.vtable)).GetNumOutputs(@as(*const IDxcResult, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcResult_GetOutputByIndex(self: *const T, Index: u32) DXC_OUT_KIND {
                return @as(*const IDxcResult.VTable, @ptrCast(self.vtable)).GetOutputByIndex(@as(*const IDxcResult, @ptrCast(self)), Index);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcResult_PrimaryOutput(self: *const T) DXC_OUT_KIND {
                return @as(*const IDxcResult.VTable, @ptrCast(self.vtable)).PrimaryOutput(@as(*const IDxcResult, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcExtraOutputs_Value = Guid.initString("319b37a2-a5c2-494a-a5de-4801b2faf989");
pub const IID_IDxcExtraOutputs = &IID_IDxcExtraOutputs_Value;
pub const IDxcExtraOutputs = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetOutputCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcExtraOutputs,
            ) callconv(@import("std").os.windows.WINAPI) u32,
            else => *const fn (
                self: *const IDxcExtraOutputs,
            ) callconv(@import("std").os.windows.WINAPI) u32,
        },
        GetOutput: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcExtraOutputs,
                uIndex: u32,
                iid: ?*const Guid,
                ppvObject: ?*?*anyopaque,
                ppOutputType: ?*?*IDxcBlobUtf16,
                ppOutputName: ?*?*IDxcBlobUtf16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcExtraOutputs,
                uIndex: u32,
                iid: ?*const Guid,
                ppvObject: ?*?*anyopaque,
                ppOutputType: ?*?*IDxcBlobUtf16,
                ppOutputName: ?*?*IDxcBlobUtf16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcExtraOutputs_GetOutputCount(self: *const T) u32 {
                return @as(*const IDxcExtraOutputs.VTable, @ptrCast(self.vtable)).GetOutputCount(@as(*const IDxcExtraOutputs, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcExtraOutputs_GetOutput(self: *const T, uIndex: u32, iid: ?*const Guid, ppvObject: ?*?*anyopaque, ppOutputType: ?*?*IDxcBlobUtf16, ppOutputName: ?*?*IDxcBlobUtf16) HRESULT {
                return @as(*const IDxcExtraOutputs.VTable, @ptrCast(self.vtable)).GetOutput(@as(*const IDxcExtraOutputs, @ptrCast(self)), uIndex, iid, ppvObject, ppOutputType, ppOutputName);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcCompiler3_Value = Guid.initString("228b4687-5a6a-4730-900c-9702b2203f54");
pub const IID_IDxcCompiler3 = &IID_IDxcCompiler3_Value;
pub const IDxcCompiler3 = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Compile: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcCompiler3,
                pSource: ?*const DxcBuffer,
                pArguments: ?[*]?PWSTR,
                argCount: u32,
                pIncludeHandler: ?*IDxcIncludeHandler,
                riid: ?*const Guid,
                ppResult: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcCompiler3,
                pSource: ?*const DxcBuffer,
                pArguments: ?[*]?PWSTR,
                argCount: u32,
                pIncludeHandler: ?*IDxcIncludeHandler,
                riid: ?*const Guid,
                ppResult: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Disassemble: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcCompiler3,
                pObject: ?*const DxcBuffer,
                riid: ?*const Guid,
                ppResult: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcCompiler3,
                pObject: ?*const DxcBuffer,
                riid: ?*const Guid,
                ppResult: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcCompiler3_Compile(self: *const T, pSource: ?*const DxcBuffer, pArguments: ?[*]?PWSTR, argCount: u32, pIncludeHandler: ?*IDxcIncludeHandler, riid: ?*const Guid, ppResult: ?*?*anyopaque) HRESULT {
                return @as(*const IDxcCompiler3.VTable, @ptrCast(self.vtable)).Compile(@as(*const IDxcCompiler3, @ptrCast(self)), pSource, pArguments, argCount, pIncludeHandler, riid, ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcCompiler3_Disassemble(self: *const T, pObject: ?*const DxcBuffer, riid: ?*const Guid, ppResult: ?*?*anyopaque) HRESULT {
                return @as(*const IDxcCompiler3.VTable, @ptrCast(self.vtable)).Disassemble(@as(*const IDxcCompiler3, @ptrCast(self)), pObject, riid, ppResult);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcValidator_Value = Guid.initString("a6e82bd2-1fd7-4826-9811-2857e797f49a");
pub const IID_IDxcValidator = &IID_IDxcValidator_Value;
pub const IDxcValidator = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Validate: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcValidator,
                pShader: ?*IDxcBlob,
                Flags: u32,
                ppResult: ?*?*IDxcOperationResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcValidator,
                pShader: ?*IDxcBlob,
                Flags: u32,
                ppResult: ?*?*IDxcOperationResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcValidator_Validate(self: *const T, pShader: ?*IDxcBlob, Flags: u32, ppResult: ?*?*IDxcOperationResult) HRESULT {
                return @as(*const IDxcValidator.VTable, @ptrCast(self.vtable)).Validate(@as(*const IDxcValidator, @ptrCast(self)), pShader, Flags, ppResult);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcValidator2_Value = Guid.initString("458e1fd1-b1b2-4750-a6e1-9c10f03bed92");
pub const IID_IDxcValidator2 = &IID_IDxcValidator2_Value;
pub const IDxcValidator2 = extern struct {
    pub const VTable = extern struct {
        base: IDxcValidator.VTable,
        ValidateWithDebug: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcValidator2,
                pShader: ?*IDxcBlob,
                Flags: u32,
                pOptDebugBitcode: ?*DxcBuffer,
                ppResult: ?*?*IDxcOperationResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcValidator2,
                pShader: ?*IDxcBlob,
                Flags: u32,
                pOptDebugBitcode: ?*DxcBuffer,
                ppResult: ?*?*IDxcOperationResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDxcValidator.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcValidator2_ValidateWithDebug(self: *const T, pShader: ?*IDxcBlob, Flags: u32, pOptDebugBitcode: ?*DxcBuffer, ppResult: ?*?*IDxcOperationResult) HRESULT {
                return @as(*const IDxcValidator2.VTable, @ptrCast(self.vtable)).ValidateWithDebug(@as(*const IDxcValidator2, @ptrCast(self)), pShader, Flags, pOptDebugBitcode, ppResult);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcContainerBuilder_Value = Guid.initString("334b1f50-2292-4b35-99a1-25588d8c17fe");
pub const IID_IDxcContainerBuilder = &IID_IDxcContainerBuilder_Value;
pub const IDxcContainerBuilder = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Load: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcContainerBuilder,
                pDxilContainerHeader: ?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcContainerBuilder,
                pDxilContainerHeader: ?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddPart: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcContainerBuilder,
                fourCC: u32,
                pSource: ?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcContainerBuilder,
                fourCC: u32,
                pSource: ?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemovePart: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcContainerBuilder,
                fourCC: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcContainerBuilder,
                fourCC: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SerializeContainer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcContainerBuilder,
                ppResult: ?*?*IDxcOperationResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcContainerBuilder,
                ppResult: ?*?*IDxcOperationResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcContainerBuilder_Load(self: *const T, pDxilContainerHeader: ?*IDxcBlob) HRESULT {
                return @as(*const IDxcContainerBuilder.VTable, @ptrCast(self.vtable)).Load(@as(*const IDxcContainerBuilder, @ptrCast(self)), pDxilContainerHeader);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcContainerBuilder_AddPart(self: *const T, fourCC: u32, pSource: ?*IDxcBlob) HRESULT {
                return @as(*const IDxcContainerBuilder.VTable, @ptrCast(self.vtable)).AddPart(@as(*const IDxcContainerBuilder, @ptrCast(self)), fourCC, pSource);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcContainerBuilder_RemovePart(self: *const T, fourCC: u32) HRESULT {
                return @as(*const IDxcContainerBuilder.VTable, @ptrCast(self.vtable)).RemovePart(@as(*const IDxcContainerBuilder, @ptrCast(self)), fourCC);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcContainerBuilder_SerializeContainer(self: *const T, ppResult: ?*?*IDxcOperationResult) HRESULT {
                return @as(*const IDxcContainerBuilder.VTable, @ptrCast(self.vtable)).SerializeContainer(@as(*const IDxcContainerBuilder, @ptrCast(self)), ppResult);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcAssembler_Value = Guid.initString("091f7a26-1c1f-4948-904b-e6e3a8a771d5");
pub const IID_IDxcAssembler = &IID_IDxcAssembler_Value;
pub const IDxcAssembler = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        AssembleToContainer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcAssembler,
                pShader: ?*IDxcBlob,
                ppResult: ?*?*IDxcOperationResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcAssembler,
                pShader: ?*IDxcBlob,
                ppResult: ?*?*IDxcOperationResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcAssembler_AssembleToContainer(self: *const T, pShader: ?*IDxcBlob, ppResult: ?*?*IDxcOperationResult) HRESULT {
                return @as(*const IDxcAssembler.VTable, @ptrCast(self.vtable)).AssembleToContainer(@as(*const IDxcAssembler, @ptrCast(self)), pShader, ppResult);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcContainerReflection_Value = Guid.initString("d2c21b26-8350-4bdc-976a-331ce6f4c54c");
pub const IID_IDxcContainerReflection = &IID_IDxcContainerReflection_Value;
pub const IDxcContainerReflection = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Load: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcContainerReflection,
                pContainer: ?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcContainerReflection,
                pContainer: ?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPartCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcContainerReflection,
                pResult: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcContainerReflection,
                pResult: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPartKind: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcContainerReflection,
                idx: u32,
                pResult: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcContainerReflection,
                idx: u32,
                pResult: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPartContent: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcContainerReflection,
                idx: u32,
                ppResult: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcContainerReflection,
                idx: u32,
                ppResult: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        FindFirstPartKind: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcContainerReflection,
                kind: u32,
                pResult: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcContainerReflection,
                kind: u32,
                pResult: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPartReflection: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcContainerReflection,
                idx: u32,
                iid: ?*const Guid,
                ppvObject: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcContainerReflection,
                idx: u32,
                iid: ?*const Guid,
                ppvObject: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcContainerReflection_Load(self: *const T, pContainer: ?*IDxcBlob) HRESULT {
                return @as(*const IDxcContainerReflection.VTable, @ptrCast(self.vtable)).Load(@as(*const IDxcContainerReflection, @ptrCast(self)), pContainer);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcContainerReflection_GetPartCount(self: *const T, pResult: ?*u32) HRESULT {
                return @as(*const IDxcContainerReflection.VTable, @ptrCast(self.vtable)).GetPartCount(@as(*const IDxcContainerReflection, @ptrCast(self)), pResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcContainerReflection_GetPartKind(self: *const T, idx: u32, pResult: ?*u32) HRESULT {
                return @as(*const IDxcContainerReflection.VTable, @ptrCast(self.vtable)).GetPartKind(@as(*const IDxcContainerReflection, @ptrCast(self)), idx, pResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcContainerReflection_GetPartContent(self: *const T, idx: u32, ppResult: ?*?*IDxcBlob) HRESULT {
                return @as(*const IDxcContainerReflection.VTable, @ptrCast(self.vtable)).GetPartContent(@as(*const IDxcContainerReflection, @ptrCast(self)), idx, ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcContainerReflection_FindFirstPartKind(self: *const T, kind: u32, pResult: ?*u32) HRESULT {
                return @as(*const IDxcContainerReflection.VTable, @ptrCast(self.vtable)).FindFirstPartKind(@as(*const IDxcContainerReflection, @ptrCast(self)), kind, pResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcContainerReflection_GetPartReflection(self: *const T, idx: u32, iid: ?*const Guid, ppvObject: ?*?*anyopaque) HRESULT {
                return @as(*const IDxcContainerReflection.VTable, @ptrCast(self.vtable)).GetPartReflection(@as(*const IDxcContainerReflection, @ptrCast(self)), idx, iid, ppvObject);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcOptimizerPass_Value = Guid.initString("ae2cd79f-cc22-453f-9b6b-b124e7a5204c");
pub const IID_IDxcOptimizerPass = &IID_IDxcOptimizerPass_Value;
pub const IDxcOptimizerPass = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetOptionName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcOptimizerPass,
                ppResult: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcOptimizerPass,
                ppResult: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcOptimizerPass,
                ppResult: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcOptimizerPass,
                ppResult: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetOptionArgCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcOptimizerPass,
                pCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcOptimizerPass,
                pCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetOptionArgName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcOptimizerPass,
                argIndex: u32,
                ppResult: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcOptimizerPass,
                argIndex: u32,
                ppResult: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetOptionArgDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcOptimizerPass,
                argIndex: u32,
                ppResult: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcOptimizerPass,
                argIndex: u32,
                ppResult: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcOptimizerPass_GetOptionName(self: *const T, ppResult: ?*?PWSTR) HRESULT {
                return @as(*const IDxcOptimizerPass.VTable, @ptrCast(self.vtable)).GetOptionName(@as(*const IDxcOptimizerPass, @ptrCast(self)), ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcOptimizerPass_GetDescription(self: *const T, ppResult: ?*?PWSTR) HRESULT {
                return @as(*const IDxcOptimizerPass.VTable, @ptrCast(self.vtable)).GetDescription(@as(*const IDxcOptimizerPass, @ptrCast(self)), ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcOptimizerPass_GetOptionArgCount(self: *const T, pCount: ?*u32) HRESULT {
                return @as(*const IDxcOptimizerPass.VTable, @ptrCast(self.vtable)).GetOptionArgCount(@as(*const IDxcOptimizerPass, @ptrCast(self)), pCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcOptimizerPass_GetOptionArgName(self: *const T, argIndex: u32, ppResult: ?*?PWSTR) HRESULT {
                return @as(*const IDxcOptimizerPass.VTable, @ptrCast(self.vtable)).GetOptionArgName(@as(*const IDxcOptimizerPass, @ptrCast(self)), argIndex, ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcOptimizerPass_GetOptionArgDescription(self: *const T, argIndex: u32, ppResult: ?*?PWSTR) HRESULT {
                return @as(*const IDxcOptimizerPass.VTable, @ptrCast(self.vtable)).GetOptionArgDescription(@as(*const IDxcOptimizerPass, @ptrCast(self)), argIndex, ppResult);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcOptimizer_Value = Guid.initString("25740e2e-9cba-401b-9119-4fb42f39f270");
pub const IID_IDxcOptimizer = &IID_IDxcOptimizer_Value;
pub const IDxcOptimizer = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetAvailablePassCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcOptimizer,
                pCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcOptimizer,
                pCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAvailablePass: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcOptimizer,
                index: u32,
                ppResult: ?*?*IDxcOptimizerPass,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcOptimizer,
                index: u32,
                ppResult: ?*?*IDxcOptimizerPass,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RunOptimizer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcOptimizer,
                pBlob: ?*IDxcBlob,
                ppOptions: [*]?PWSTR,
                optionCount: u32,
                pOutputModule: ?*?*IDxcBlob,
                ppOutputText: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcOptimizer,
                pBlob: ?*IDxcBlob,
                ppOptions: [*]?PWSTR,
                optionCount: u32,
                pOutputModule: ?*?*IDxcBlob,
                ppOutputText: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcOptimizer_GetAvailablePassCount(self: *const T, pCount: ?*u32) HRESULT {
                return @as(*const IDxcOptimizer.VTable, @ptrCast(self.vtable)).GetAvailablePassCount(@as(*const IDxcOptimizer, @ptrCast(self)), pCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcOptimizer_GetAvailablePass(self: *const T, index: u32, ppResult: ?*?*IDxcOptimizerPass) HRESULT {
                return @as(*const IDxcOptimizer.VTable, @ptrCast(self.vtable)).GetAvailablePass(@as(*const IDxcOptimizer, @ptrCast(self)), index, ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcOptimizer_RunOptimizer(self: *const T, pBlob: ?*IDxcBlob, ppOptions: [*]?PWSTR, optionCount: u32, pOutputModule: ?*?*IDxcBlob, ppOutputText: ?*?*IDxcBlobEncoding) HRESULT {
                return @as(*const IDxcOptimizer.VTable, @ptrCast(self.vtable)).RunOptimizer(@as(*const IDxcOptimizer, @ptrCast(self)), pBlob, ppOptions, optionCount, pOutputModule, ppOutputText);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcVersionInfo_Value = Guid.initString("b04f5b50-2059-4f12-a8ff-a1e0cde1cc7e");
pub const IID_IDxcVersionInfo = &IID_IDxcVersionInfo_Value;
pub const IDxcVersionInfo = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetVersion: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcVersionInfo,
                pMajor: ?*u32,
                pMinor: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcVersionInfo,
                pMajor: ?*u32,
                pMinor: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetFlags: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcVersionInfo,
                pFlags: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcVersionInfo,
                pFlags: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcVersionInfo_GetVersion(self: *const T, pMajor: ?*u32, pMinor: ?*u32) HRESULT {
                return @as(*const IDxcVersionInfo.VTable, @ptrCast(self.vtable)).GetVersion(@as(*const IDxcVersionInfo, @ptrCast(self)), pMajor, pMinor);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcVersionInfo_GetFlags(self: *const T, pFlags: ?*u32) HRESULT {
                return @as(*const IDxcVersionInfo.VTable, @ptrCast(self.vtable)).GetFlags(@as(*const IDxcVersionInfo, @ptrCast(self)), pFlags);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcVersionInfo2_Value = Guid.initString("fb6904c4-42f0-4b62-9c46-983af7da7c83");
pub const IID_IDxcVersionInfo2 = &IID_IDxcVersionInfo2_Value;
pub const IDxcVersionInfo2 = extern struct {
    pub const VTable = extern struct {
        base: IDxcVersionInfo.VTable,
        GetCommitInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcVersionInfo2,
                pCommitCount: ?*u32,
                pCommitHash: ?*?*i8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcVersionInfo2,
                pCommitCount: ?*u32,
                pCommitHash: ?*?*i8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDxcVersionInfo.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcVersionInfo2_GetCommitInfo(self: *const T, pCommitCount: ?*u32, pCommitHash: ?*?*i8) HRESULT {
                return @as(*const IDxcVersionInfo2.VTable, @ptrCast(self.vtable)).GetCommitInfo(@as(*const IDxcVersionInfo2, @ptrCast(self)), pCommitCount, pCommitHash);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDxcVersionInfo3_Value = Guid.initString("5e13e843-9d25-473c-9ad2-03b2d0b44b1e");
pub const IID_IDxcVersionInfo3 = &IID_IDxcVersionInfo3_Value;
pub const IDxcVersionInfo3 = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetCustomVersionString: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcVersionInfo3,
                pVersionString: ?*?*i8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcVersionInfo3,
                pVersionString: ?*?*i8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcVersionInfo3_GetCustomVersionString(self: *const T, pVersionString: ?*?*i8) HRESULT {
                return @as(*const IDxcVersionInfo3.VTable, @ptrCast(self.vtable)).GetCustomVersionString(@as(*const IDxcVersionInfo3, @ptrCast(self)), pVersionString);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const DxcArgPair = extern struct {
    pName: ?[*:0]const u16,
    pValue: ?[*:0]const u16,
};

const IID_IDxcPdbUtils_Value = Guid.initString("e6c9647e-9d6a-4c3b-b94c-524b5a6c343d");
pub const IID_IDxcPdbUtils = &IID_IDxcPdbUtils_Value;
pub const IDxcPdbUtils = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Load: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                pPdbOrDxil: ?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                pPdbOrDxil: ?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetSourceCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                pCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                pCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetSource: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                uIndex: u32,
                ppResult: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                uIndex: u32,
                ppResult: ?*?*IDxcBlobEncoding,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetSourceName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                uIndex: u32,
                pResult: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                uIndex: u32,
                pResult: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetFlagCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                pCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                pCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetFlag: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                uIndex: u32,
                pResult: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                uIndex: u32,
                pResult: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetArgCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                pCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                pCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetArg: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                uIndex: u32,
                pResult: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                uIndex: u32,
                pResult: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetArgPairCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                pCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                pCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetArgPair: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                uIndex: u32,
                pName: ?*?BSTR,
                pValue: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                uIndex: u32,
                pName: ?*?BSTR,
                pValue: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDefineCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                pCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                pCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDefine: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                uIndex: u32,
                pResult: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                uIndex: u32,
                pResult: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetTargetProfile: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                pResult: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                pResult: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetEntryPoint: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                pResult: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                pResult: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMainFileName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                pResult: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                pResult: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetHash: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                ppResult: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                ppResult: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                pResult: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                pResult: ?*?BSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        IsFullPDB: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
            ) callconv(@import("std").os.windows.WINAPI) BOOL,
            else => *const fn (
                self: *const IDxcPdbUtils,
            ) callconv(@import("std").os.windows.WINAPI) BOOL,
        },
        GetFullPDB: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                ppFullPDB: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                ppFullPDB: ?*?*IDxcBlob,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetVersionInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                ppVersionInfo: ?*?*IDxcVersionInfo,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                ppVersionInfo: ?*?*IDxcVersionInfo,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCompiler: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                pCompiler: ?*IDxcCompiler3,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                pCompiler: ?*IDxcCompiler3,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CompileForFullPDB: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                ppResult: ?*?*IDxcResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                ppResult: ?*?*IDxcResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OverrideArgs: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                pArgPairs: ?*DxcArgPair,
                uNumArgPairs: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                pArgPairs: ?*DxcArgPair,
                uNumArgPairs: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        OverrideRootSignature: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDxcPdbUtils,
                pRootSignature: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDxcPdbUtils,
                pRootSignature: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_Load(self: *const T, pPdbOrDxil: ?*IDxcBlob) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).Load(@as(*const IDxcPdbUtils, @ptrCast(self)), pPdbOrDxil);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetSourceCount(self: *const T, pCount: ?*u32) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetSourceCount(@as(*const IDxcPdbUtils, @ptrCast(self)), pCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetSource(self: *const T, uIndex: u32, ppResult: ?*?*IDxcBlobEncoding) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetSource(@as(*const IDxcPdbUtils, @ptrCast(self)), uIndex, ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetSourceName(self: *const T, uIndex: u32, pResult: ?*?BSTR) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetSourceName(@as(*const IDxcPdbUtils, @ptrCast(self)), uIndex, pResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetFlagCount(self: *const T, pCount: ?*u32) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetFlagCount(@as(*const IDxcPdbUtils, @ptrCast(self)), pCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetFlag(self: *const T, uIndex: u32, pResult: ?*?BSTR) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetFlag(@as(*const IDxcPdbUtils, @ptrCast(self)), uIndex, pResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetArgCount(self: *const T, pCount: ?*u32) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetArgCount(@as(*const IDxcPdbUtils, @ptrCast(self)), pCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetArg(self: *const T, uIndex: u32, pResult: ?*?BSTR) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetArg(@as(*const IDxcPdbUtils, @ptrCast(self)), uIndex, pResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetArgPairCount(self: *const T, pCount: ?*u32) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetArgPairCount(@as(*const IDxcPdbUtils, @ptrCast(self)), pCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetArgPair(self: *const T, uIndex: u32, pName: ?*?BSTR, pValue: ?*?BSTR) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetArgPair(@as(*const IDxcPdbUtils, @ptrCast(self)), uIndex, pName, pValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetDefineCount(self: *const T, pCount: ?*u32) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetDefineCount(@as(*const IDxcPdbUtils, @ptrCast(self)), pCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetDefine(self: *const T, uIndex: u32, pResult: ?*?BSTR) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetDefine(@as(*const IDxcPdbUtils, @ptrCast(self)), uIndex, pResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetTargetProfile(self: *const T, pResult: ?*?BSTR) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetTargetProfile(@as(*const IDxcPdbUtils, @ptrCast(self)), pResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetEntryPoint(self: *const T, pResult: ?*?BSTR) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetEntryPoint(@as(*const IDxcPdbUtils, @ptrCast(self)), pResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetMainFileName(self: *const T, pResult: ?*?BSTR) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetMainFileName(@as(*const IDxcPdbUtils, @ptrCast(self)), pResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetHash(self: *const T, ppResult: ?*?*IDxcBlob) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetHash(@as(*const IDxcPdbUtils, @ptrCast(self)), ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetName(self: *const T, pResult: ?*?BSTR) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetName(@as(*const IDxcPdbUtils, @ptrCast(self)), pResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_IsFullPDB(self: *const T) BOOL {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).IsFullPDB(@as(*const IDxcPdbUtils, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetFullPDB(self: *const T, ppFullPDB: ?*?*IDxcBlob) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetFullPDB(@as(*const IDxcPdbUtils, @ptrCast(self)), ppFullPDB);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_GetVersionInfo(self: *const T, ppVersionInfo: ?*?*IDxcVersionInfo) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).GetVersionInfo(@as(*const IDxcPdbUtils, @ptrCast(self)), ppVersionInfo);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_SetCompiler(self: *const T, pCompiler: ?*IDxcCompiler3) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).SetCompiler(@as(*const IDxcPdbUtils, @ptrCast(self)), pCompiler);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_CompileForFullPDB(self: *const T, ppResult: ?*?*IDxcResult) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).CompileForFullPDB(@as(*const IDxcPdbUtils, @ptrCast(self)), ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_OverrideArgs(self: *const T, pArgPairs: ?*DxcArgPair, uNumArgPairs: u32) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).OverrideArgs(@as(*const IDxcPdbUtils, @ptrCast(self)), pArgPairs, uNumArgPairs);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDxcPdbUtils_OverrideRootSignature(self: *const T, pRootSignature: ?[*:0]const u16) HRESULT {
                return @as(*const IDxcPdbUtils.VTable, @ptrCast(self.vtable)).OverrideRootSignature(@as(*const IDxcPdbUtils, @ptrCast(self)), pRootSignature);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

//--------------------------------------------------------------------------------
// Section: Functions (2)
//--------------------------------------------------------------------------------
pub extern "dxcompiler" fn DxcCreateInstance(
    rclsid: ?*const Guid,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "dxcompiler" fn DxcCreateInstance2(
    pMalloc: ?*IMalloc,
    rclsid: ?*const Guid,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (9)
//--------------------------------------------------------------------------------
const Guid = @import("../../zig.zig").Guid;
const BOOL = @import("../../foundation.zig").BOOL;
const BSTR = @import("../../foundation.zig").BSTR;
const HRESULT = @import("../../foundation.zig").HRESULT;
const IMalloc = @import("../../system/com.zig").IMalloc;
const IStream = @import("../../system/com.zig").IStream;
const IUnknown = @import("../../system/com.zig").IUnknown;
const PSTR = @import("../../foundation.zig").PSTR;
const PWSTR = @import("../../foundation.zig").PWSTR;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "DxcCreateInstanceProc")) {
        _ = DxcCreateInstanceProc;
    }
    if (@hasDecl(@This(), "DxcCreateInstance2Proc")) {
        _ = DxcCreateInstance2Proc;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
