//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (0)
//--------------------------------------------------------------------------------

//--------------------------------------------------------------------------------
// Section: Types (21)
//--------------------------------------------------------------------------------
const CLSID_GameExplorer_Value = Guid.initString("9a5ea990-3034-4d6f-9128-01f3c61022bc");
pub const CLSID_GameExplorer = &CLSID_GameExplorer_Value;

const CLSID_GameStatistics_Value = Guid.initString("dbc85a2c-c0dc-4961-b6e2-d28b62c11ad4");
pub const CLSID_GameStatistics = &CLSID_GameStatistics_Value;

pub const GAME_INSTALL_SCOPE = enum(i32) {
    NOT_INSTALLED = 1,
    CURRENT_USER = 2,
    ALL_USERS = 3,
};
pub const GIS_NOT_INSTALLED = GAME_INSTALL_SCOPE.NOT_INSTALLED;
pub const GIS_CURRENT_USER = GAME_INSTALL_SCOPE.CURRENT_USER;
pub const GIS_ALL_USERS = GAME_INSTALL_SCOPE.ALL_USERS;

const IID_IGameExplorer_Value = Guid.initString("e7b2fb72-d728-49b3-a5f2-18ebf5f1349e");
pub const IID_IGameExplorer = &IID_IGameExplorer_Value;
pub const IGameExplorer = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        AddGame: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameExplorer,
                bstrGDFBinaryPath: ?BSTR,
                bstrGameInstallDirectory: ?BSTR,
                installScope: GAME_INSTALL_SCOPE,
                pguidInstanceID: ?*Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameExplorer,
                bstrGDFBinaryPath: ?BSTR,
                bstrGameInstallDirectory: ?BSTR,
                installScope: GAME_INSTALL_SCOPE,
                pguidInstanceID: ?*Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveGame: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameExplorer,
                guidInstanceID: Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameExplorer,
                guidInstanceID: Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        UpdateGame: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameExplorer,
                guidInstanceID: Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameExplorer,
                guidInstanceID: Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        VerifyAccess: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameExplorer,
                bstrGDFBinaryPath: ?BSTR,
                pfHasAccess: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameExplorer,
                bstrGDFBinaryPath: ?BSTR,
                pfHasAccess: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameExplorer_AddGame(self: *const T, bstrGDFBinaryPath: ?BSTR, bstrGameInstallDirectory: ?BSTR, installScope: GAME_INSTALL_SCOPE, pguidInstanceID: ?*Guid) HRESULT {
                return @as(*const IGameExplorer.VTable, @ptrCast(self.vtable)).AddGame(@as(*const IGameExplorer, @ptrCast(self)), bstrGDFBinaryPath, bstrGameInstallDirectory, installScope, pguidInstanceID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameExplorer_RemoveGame(self: *const T, guidInstanceID: Guid) HRESULT {
                return @as(*const IGameExplorer.VTable, @ptrCast(self.vtable)).RemoveGame(@as(*const IGameExplorer, @ptrCast(self)), guidInstanceID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameExplorer_UpdateGame(self: *const T, guidInstanceID: Guid) HRESULT {
                return @as(*const IGameExplorer.VTable, @ptrCast(self.vtable)).UpdateGame(@as(*const IGameExplorer, @ptrCast(self)), guidInstanceID);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameExplorer_VerifyAccess(self: *const T, bstrGDFBinaryPath: ?BSTR, pfHasAccess: ?*BOOL) HRESULT {
                return @as(*const IGameExplorer.VTable, @ptrCast(self.vtable)).VerifyAccess(@as(*const IGameExplorer, @ptrCast(self)), bstrGDFBinaryPath, pfHasAccess);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const GAMESTATS_OPEN_TYPE = enum(i32) {
    RCREATE = 0,
    NLY = 1,
};
pub const GAMESTATS_OPEN_OPENORCREATE = GAMESTATS_OPEN_TYPE.RCREATE;
pub const GAMESTATS_OPEN_OPENONLY = GAMESTATS_OPEN_TYPE.NLY;

pub const GAMESTATS_OPEN_RESULT = enum(i32) {
    CREATED = 0,
    OPENED = 1,
};
pub const GAMESTATS_OPEN_CREATED = GAMESTATS_OPEN_RESULT.CREATED;
pub const GAMESTATS_OPEN_OPENED = GAMESTATS_OPEN_RESULT.OPENED;

const IID_IGameStatistics_Value = Guid.initString("3887c9ca-04a0-42ae-bc4c-5fa6c7721145");
pub const IID_IGameStatistics = &IID_IGameStatistics_Value;
pub const IGameStatistics = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetMaxCategoryLength: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameStatistics,
                cch: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameStatistics,
                cch: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMaxNameLength: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameStatistics,
                cch: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameStatistics,
                cch: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMaxValueLength: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameStatistics,
                cch: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameStatistics,
                cch: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMaxCategories: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameStatistics,
                pMax: ?*u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameStatistics,
                pMax: ?*u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMaxStatsPerCategory: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameStatistics,
                pMax: ?*u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameStatistics,
                pMax: ?*u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetCategoryTitle: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameStatistics,
                categoryIndex: u16,
                title: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameStatistics,
                categoryIndex: u16,
                title: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetCategoryTitle: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameStatistics,
                categoryIndex: u16,
                pTitle: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameStatistics,
                categoryIndex: u16,
                pTitle: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetStatistic: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameStatistics,
                categoryIndex: u16,
                statIndex: u16,
                pName: ?*?PWSTR,
                pValue: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameStatistics,
                categoryIndex: u16,
                statIndex: u16,
                pName: ?*?PWSTR,
                pValue: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetStatistic: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameStatistics,
                categoryIndex: u16,
                statIndex: u16,
                name: ?[*:0]const u16,
                value: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameStatistics,
                categoryIndex: u16,
                statIndex: u16,
                name: ?[*:0]const u16,
                value: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Save: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameStatistics,
                trackChanges: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameStatistics,
                trackChanges: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetLastPlayedCategory: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameStatistics,
                categoryIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameStatistics,
                categoryIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetLastPlayedCategory: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameStatistics,
                pCategoryIndex: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameStatistics,
                pCategoryIndex: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameStatistics_GetMaxCategoryLength(self: *const T, cch: ?*u32) HRESULT {
                return @as(*const IGameStatistics.VTable, @ptrCast(self.vtable)).GetMaxCategoryLength(@as(*const IGameStatistics, @ptrCast(self)), cch);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameStatistics_GetMaxNameLength(self: *const T, cch: ?*u32) HRESULT {
                return @as(*const IGameStatistics.VTable, @ptrCast(self.vtable)).GetMaxNameLength(@as(*const IGameStatistics, @ptrCast(self)), cch);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameStatistics_GetMaxValueLength(self: *const T, cch: ?*u32) HRESULT {
                return @as(*const IGameStatistics.VTable, @ptrCast(self.vtable)).GetMaxValueLength(@as(*const IGameStatistics, @ptrCast(self)), cch);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameStatistics_GetMaxCategories(self: *const T, pMax: ?*u16) HRESULT {
                return @as(*const IGameStatistics.VTable, @ptrCast(self.vtable)).GetMaxCategories(@as(*const IGameStatistics, @ptrCast(self)), pMax);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameStatistics_GetMaxStatsPerCategory(self: *const T, pMax: ?*u16) HRESULT {
                return @as(*const IGameStatistics.VTable, @ptrCast(self.vtable)).GetMaxStatsPerCategory(@as(*const IGameStatistics, @ptrCast(self)), pMax);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameStatistics_SetCategoryTitle(self: *const T, categoryIndex: u16, title: ?[*:0]const u16) HRESULT {
                return @as(*const IGameStatistics.VTable, @ptrCast(self.vtable)).SetCategoryTitle(@as(*const IGameStatistics, @ptrCast(self)), categoryIndex, title);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameStatistics_GetCategoryTitle(self: *const T, categoryIndex: u16, pTitle: ?*?PWSTR) HRESULT {
                return @as(*const IGameStatistics.VTable, @ptrCast(self.vtable)).GetCategoryTitle(@as(*const IGameStatistics, @ptrCast(self)), categoryIndex, pTitle);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameStatistics_GetStatistic(self: *const T, categoryIndex: u16, statIndex: u16, pName: ?*?PWSTR, pValue: ?*?PWSTR) HRESULT {
                return @as(*const IGameStatistics.VTable, @ptrCast(self.vtable)).GetStatistic(@as(*const IGameStatistics, @ptrCast(self)), categoryIndex, statIndex, pName, pValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameStatistics_SetStatistic(self: *const T, categoryIndex: u16, statIndex: u16, name: ?[*:0]const u16, value: ?[*:0]const u16) HRESULT {
                return @as(*const IGameStatistics.VTable, @ptrCast(self.vtable)).SetStatistic(@as(*const IGameStatistics, @ptrCast(self)), categoryIndex, statIndex, name, value);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameStatistics_Save(self: *const T, trackChanges: BOOL) HRESULT {
                return @as(*const IGameStatistics.VTable, @ptrCast(self.vtable)).Save(@as(*const IGameStatistics, @ptrCast(self)), trackChanges);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameStatistics_SetLastPlayedCategory(self: *const T, categoryIndex: u32) HRESULT {
                return @as(*const IGameStatistics.VTable, @ptrCast(self.vtable)).SetLastPlayedCategory(@as(*const IGameStatistics, @ptrCast(self)), categoryIndex);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameStatistics_GetLastPlayedCategory(self: *const T, pCategoryIndex: ?*u32) HRESULT {
                return @as(*const IGameStatistics.VTable, @ptrCast(self.vtable)).GetLastPlayedCategory(@as(*const IGameStatistics, @ptrCast(self)), pCategoryIndex);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IGameStatisticsMgr_Value = Guid.initString("aff3ea11-e70e-407d-95dd-35e612c41ce2");
pub const IID_IGameStatisticsMgr = &IID_IGameStatisticsMgr_Value;
pub const IGameStatisticsMgr = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetGameStatistics: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameStatisticsMgr,
                GDFBinaryPath: ?[*:0]const u16,
                openType: GAMESTATS_OPEN_TYPE,
                pOpenResult: ?*GAMESTATS_OPEN_RESULT,
                ppiStats: ?*?*IGameStatistics,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameStatisticsMgr,
                GDFBinaryPath: ?[*:0]const u16,
                openType: GAMESTATS_OPEN_TYPE,
                pOpenResult: ?*GAMESTATS_OPEN_RESULT,
                ppiStats: ?*?*IGameStatistics,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveGameStatistics: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameStatisticsMgr,
                GDFBinaryPath: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameStatisticsMgr,
                GDFBinaryPath: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameStatisticsMgr_GetGameStatistics(self: *const T, GDFBinaryPath: ?[*:0]const u16, openType: GAMESTATS_OPEN_TYPE, pOpenResult: ?*GAMESTATS_OPEN_RESULT, ppiStats: ?*?*IGameStatistics) HRESULT {
                return @as(*const IGameStatisticsMgr.VTable, @ptrCast(self.vtable)).GetGameStatistics(@as(*const IGameStatisticsMgr, @ptrCast(self)), GDFBinaryPath, openType, pOpenResult, ppiStats);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameStatisticsMgr_RemoveGameStatistics(self: *const T, GDFBinaryPath: ?[*:0]const u16) HRESULT {
                return @as(*const IGameStatisticsMgr.VTable, @ptrCast(self.vtable)).RemoveGameStatistics(@as(*const IGameStatisticsMgr, @ptrCast(self)), GDFBinaryPath);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IGameExplorer2_Value = Guid.initString("86874aa7-a1ed-450d-a7eb-b89e20b2fff3");
pub const IID_IGameExplorer2 = &IID_IGameExplorer2_Value;
pub const IGameExplorer2 = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        InstallGame: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameExplorer2,
                binaryGDFPath: ?[*:0]const u16,
                installDirectory: ?[*:0]const u16,
                installScope: GAME_INSTALL_SCOPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameExplorer2,
                binaryGDFPath: ?[*:0]const u16,
                installDirectory: ?[*:0]const u16,
                installScope: GAME_INSTALL_SCOPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        UninstallGame: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameExplorer2,
                binaryGDFPath: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameExplorer2,
                binaryGDFPath: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CheckAccess: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IGameExplorer2,
                binaryGDFPath: ?[*:0]const u16,
                pHasAccess: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IGameExplorer2,
                binaryGDFPath: ?[*:0]const u16,
                pHasAccess: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameExplorer2_InstallGame(self: *const T, binaryGDFPath: ?[*:0]const u16, installDirectory: ?[*:0]const u16, installScope: GAME_INSTALL_SCOPE) HRESULT {
                return @as(*const IGameExplorer2.VTable, @ptrCast(self.vtable)).InstallGame(@as(*const IGameExplorer2, @ptrCast(self)), binaryGDFPath, installDirectory, installScope);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameExplorer2_UninstallGame(self: *const T, binaryGDFPath: ?[*:0]const u16) HRESULT {
                return @as(*const IGameExplorer2.VTable, @ptrCast(self.vtable)).UninstallGame(@as(*const IGameExplorer2, @ptrCast(self)), binaryGDFPath);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IGameExplorer2_CheckAccess(self: *const T, binaryGDFPath: ?[*:0]const u16, pHasAccess: ?*BOOL) HRESULT {
                return @as(*const IGameExplorer2.VTable, @ptrCast(self.vtable)).CheckAccess(@as(*const IGameExplorer2, @ptrCast(self)), binaryGDFPath, pHasAccess);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const GAMING_DEVICE_VENDOR_ID = enum(i32) {
    NONE = 0,
    MICROSOFT = -1024700366,
};
pub const GAMING_DEVICE_VENDOR_ID_NONE = GAMING_DEVICE_VENDOR_ID.NONE;
pub const GAMING_DEVICE_VENDOR_ID_MICROSOFT = GAMING_DEVICE_VENDOR_ID.MICROSOFT;

pub const GAMING_DEVICE_DEVICE_ID = enum(i32) {
    NONE = 0,
    XBOX_ONE = 1988865574,
    XBOX_ONE_S = 712204761,
    XBOX_ONE_X = 1523980231,
    XBOX_ONE_X_DEVKIT = 284675555,
};
pub const GAMING_DEVICE_DEVICE_ID_NONE = GAMING_DEVICE_DEVICE_ID.NONE;
pub const GAMING_DEVICE_DEVICE_ID_XBOX_ONE = GAMING_DEVICE_DEVICE_ID.XBOX_ONE;
pub const GAMING_DEVICE_DEVICE_ID_XBOX_ONE_S = GAMING_DEVICE_DEVICE_ID.XBOX_ONE_S;
pub const GAMING_DEVICE_DEVICE_ID_XBOX_ONE_X = GAMING_DEVICE_DEVICE_ID.XBOX_ONE_X;
pub const GAMING_DEVICE_DEVICE_ID_XBOX_ONE_X_DEVKIT = GAMING_DEVICE_DEVICE_ID.XBOX_ONE_X_DEVKIT;

pub const GAMING_DEVICE_MODEL_INFORMATION = extern struct {
    vendorId: GAMING_DEVICE_VENDOR_ID,
    deviceId: GAMING_DEVICE_DEVICE_ID,
};

pub const GameUICompletionRoutine = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        returnCode: HRESULT,
        context: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        returnCode: HRESULT,
        context: ?*anyopaque,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PlayerPickerUICompletionRoutine = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        returnCode: HRESULT,
        context: ?*anyopaque,
        selectedXuids: [*]const ?HSTRING,
        selectedXuidsCount: usize,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        returnCode: HRESULT,
        context: ?*anyopaque,
        selectedXuids: [*]const ?HSTRING,
        selectedXuidsCount: usize,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const KnownGamingPrivileges = enum(i32) {
    BROADCAST = 190,
    VIEW_FRIENDS_LIST = 197,
    GAME_DVR = 198,
    SHARE_KINECT_CONTENT = 199,
    MULTIPLAYER_PARTIES = 203,
    COMMUNICATION_VOICE_INGAME = 205,
    COMMUNICATION_VOICE_SKYPE = 206,
    CLOUD_GAMING_MANAGE_SESSION = 207,
    CLOUD_GAMING_JOIN_SESSION = 208,
    CLOUD_SAVED_GAMES = 209,
    SHARE_CONTENT = 211,
    PREMIUM_CONTENT = 214,
    SUBSCRIPTION_CONTENT = 219,
    SOCIAL_NETWORK_SHARING = 220,
    PREMIUM_VIDEO = 224,
    VIDEO_COMMUNICATIONS = 235,
    PURCHASE_CONTENT = 245,
    USER_CREATED_CONTENT = 247,
    PROFILE_VIEWING = 249,
    COMMUNICATIONS = 252,
    MULTIPLAYER_SESSIONS = 254,
    ADD_FRIEND = 255,
};
pub const XPRIVILEGE_BROADCAST = KnownGamingPrivileges.BROADCAST;
pub const XPRIVILEGE_VIEW_FRIENDS_LIST = KnownGamingPrivileges.VIEW_FRIENDS_LIST;
pub const XPRIVILEGE_GAME_DVR = KnownGamingPrivileges.GAME_DVR;
pub const XPRIVILEGE_SHARE_KINECT_CONTENT = KnownGamingPrivileges.SHARE_KINECT_CONTENT;
pub const XPRIVILEGE_MULTIPLAYER_PARTIES = KnownGamingPrivileges.MULTIPLAYER_PARTIES;
pub const XPRIVILEGE_COMMUNICATION_VOICE_INGAME = KnownGamingPrivileges.COMMUNICATION_VOICE_INGAME;
pub const XPRIVILEGE_COMMUNICATION_VOICE_SKYPE = KnownGamingPrivileges.COMMUNICATION_VOICE_SKYPE;
pub const XPRIVILEGE_CLOUD_GAMING_MANAGE_SESSION = KnownGamingPrivileges.CLOUD_GAMING_MANAGE_SESSION;
pub const XPRIVILEGE_CLOUD_GAMING_JOIN_SESSION = KnownGamingPrivileges.CLOUD_GAMING_JOIN_SESSION;
pub const XPRIVILEGE_CLOUD_SAVED_GAMES = KnownGamingPrivileges.CLOUD_SAVED_GAMES;
pub const XPRIVILEGE_SHARE_CONTENT = KnownGamingPrivileges.SHARE_CONTENT;
pub const XPRIVILEGE_PREMIUM_CONTENT = KnownGamingPrivileges.PREMIUM_CONTENT;
pub const XPRIVILEGE_SUBSCRIPTION_CONTENT = KnownGamingPrivileges.SUBSCRIPTION_CONTENT;
pub const XPRIVILEGE_SOCIAL_NETWORK_SHARING = KnownGamingPrivileges.SOCIAL_NETWORK_SHARING;
pub const XPRIVILEGE_PREMIUM_VIDEO = KnownGamingPrivileges.PREMIUM_VIDEO;
pub const XPRIVILEGE_VIDEO_COMMUNICATIONS = KnownGamingPrivileges.VIDEO_COMMUNICATIONS;
pub const XPRIVILEGE_PURCHASE_CONTENT = KnownGamingPrivileges.PURCHASE_CONTENT;
pub const XPRIVILEGE_USER_CREATED_CONTENT = KnownGamingPrivileges.USER_CREATED_CONTENT;
pub const XPRIVILEGE_PROFILE_VIEWING = KnownGamingPrivileges.PROFILE_VIEWING;
pub const XPRIVILEGE_COMMUNICATIONS = KnownGamingPrivileges.COMMUNICATIONS;
pub const XPRIVILEGE_MULTIPLAYER_SESSIONS = KnownGamingPrivileges.MULTIPLAYER_SESSIONS;
pub const XPRIVILEGE_ADD_FRIEND = KnownGamingPrivileges.ADD_FRIEND;

const CLSID_XblIdpAuthManager_Value = Guid.initString("ce23534b-56d8-4978-86a2-7ee570640468");
pub const CLSID_XblIdpAuthManager = &CLSID_XblIdpAuthManager_Value;

const CLSID_XblIdpAuthTokenResult_Value = Guid.initString("9f493441-744a-410c-ae2b-9a22f7c7731f");
pub const CLSID_XblIdpAuthTokenResult = &CLSID_XblIdpAuthTokenResult_Value;

pub const XBL_IDP_AUTH_TOKEN_STATUS = enum(i32) {
    SUCCESS = 0,
    OFFLINE_SUCCESS = 1,
    NO_ACCOUNT_SET = 2,
    LOAD_MSA_ACCOUNT_FAILED = 3,
    XBOX_VETO = 4,
    MSA_INTERRUPT = 5,
    OFFLINE_NO_CONSENT = 6,
    VIEW_NOT_SET = 7,
    UNKNOWN = -1,
};
pub const XBL_IDP_AUTH_TOKEN_STATUS_SUCCESS = XBL_IDP_AUTH_TOKEN_STATUS.SUCCESS;
pub const XBL_IDP_AUTH_TOKEN_STATUS_OFFLINE_SUCCESS = XBL_IDP_AUTH_TOKEN_STATUS.OFFLINE_SUCCESS;
pub const XBL_IDP_AUTH_TOKEN_STATUS_NO_ACCOUNT_SET = XBL_IDP_AUTH_TOKEN_STATUS.NO_ACCOUNT_SET;
pub const XBL_IDP_AUTH_TOKEN_STATUS_LOAD_MSA_ACCOUNT_FAILED = XBL_IDP_AUTH_TOKEN_STATUS.LOAD_MSA_ACCOUNT_FAILED;
pub const XBL_IDP_AUTH_TOKEN_STATUS_XBOX_VETO = XBL_IDP_AUTH_TOKEN_STATUS.XBOX_VETO;
pub const XBL_IDP_AUTH_TOKEN_STATUS_MSA_INTERRUPT = XBL_IDP_AUTH_TOKEN_STATUS.MSA_INTERRUPT;
pub const XBL_IDP_AUTH_TOKEN_STATUS_OFFLINE_NO_CONSENT = XBL_IDP_AUTH_TOKEN_STATUS.OFFLINE_NO_CONSENT;
pub const XBL_IDP_AUTH_TOKEN_STATUS_VIEW_NOT_SET = XBL_IDP_AUTH_TOKEN_STATUS.VIEW_NOT_SET;
pub const XBL_IDP_AUTH_TOKEN_STATUS_UNKNOWN = XBL_IDP_AUTH_TOKEN_STATUS.UNKNOWN;

const IID_IXblIdpAuthManager_Value = Guid.initString("eb5ddb08-8bbf-449b-ac21-b02ddeb3b136");
pub const IID_IXblIdpAuthManager = &IID_IXblIdpAuthManager_Value;
pub const IXblIdpAuthManager = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetGamerAccount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthManager,
                msaAccountId: ?[*:0]const u16,
                xuid: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthManager,
                msaAccountId: ?[*:0]const u16,
                xuid: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetGamerAccount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthManager,
                msaAccountId: ?*?PWSTR,
                xuid: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthManager,
                msaAccountId: ?*?PWSTR,
                xuid: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAppViewInitialized: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthManager,
                appSid: ?[*:0]const u16,
                msaAccountId: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthManager,
                appSid: ?[*:0]const u16,
                msaAccountId: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetEnvironment: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthManager,
                environment: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthManager,
                environment: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetSandbox: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthManager,
                sandbox: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthManager,
                sandbox: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetTokenAndSignatureWithTokenResult: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthManager,
                msaAccountId: ?[*:0]const u16,
                appSid: ?[*:0]const u16,
                msaTarget: ?[*:0]const u16,
                msaPolicy: ?[*:0]const u16,
                httpMethod: ?[*:0]const u16,
                uri: ?[*:0]const u16,
                headers: ?[*:0]const u16,
                body: [*:0]u8,
                bodySize: u32,
                forceRefresh: BOOL,
                result: ?*?*IXblIdpAuthTokenResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthManager,
                msaAccountId: ?[*:0]const u16,
                appSid: ?[*:0]const u16,
                msaTarget: ?[*:0]const u16,
                msaPolicy: ?[*:0]const u16,
                httpMethod: ?[*:0]const u16,
                uri: ?[*:0]const u16,
                headers: ?[*:0]const u16,
                body: [*:0]u8,
                bodySize: u32,
                forceRefresh: BOOL,
                result: ?*?*IXblIdpAuthTokenResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthManager_SetGamerAccount(self: *const T, msaAccountId: ?[*:0]const u16, xuid: ?[*:0]const u16) HRESULT {
                return @as(*const IXblIdpAuthManager.VTable, @ptrCast(self.vtable)).SetGamerAccount(@as(*const IXblIdpAuthManager, @ptrCast(self)), msaAccountId, xuid);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthManager_GetGamerAccount(self: *const T, msaAccountId: ?*?PWSTR, xuid: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthManager.VTable, @ptrCast(self.vtable)).GetGamerAccount(@as(*const IXblIdpAuthManager, @ptrCast(self)), msaAccountId, xuid);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthManager_SetAppViewInitialized(self: *const T, appSid: ?[*:0]const u16, msaAccountId: ?[*:0]const u16) HRESULT {
                return @as(*const IXblIdpAuthManager.VTable, @ptrCast(self.vtable)).SetAppViewInitialized(@as(*const IXblIdpAuthManager, @ptrCast(self)), appSid, msaAccountId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthManager_GetEnvironment(self: *const T, environment: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthManager.VTable, @ptrCast(self.vtable)).GetEnvironment(@as(*const IXblIdpAuthManager, @ptrCast(self)), environment);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthManager_GetSandbox(self: *const T, sandbox: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthManager.VTable, @ptrCast(self.vtable)).GetSandbox(@as(*const IXblIdpAuthManager, @ptrCast(self)), sandbox);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthManager_GetTokenAndSignatureWithTokenResult(self: *const T, msaAccountId: ?[*:0]const u16, appSid: ?[*:0]const u16, msaTarget: ?[*:0]const u16, msaPolicy: ?[*:0]const u16, httpMethod: ?[*:0]const u16, uri: ?[*:0]const u16, headers: ?[*:0]const u16, body: [*:0]u8, bodySize: u32, forceRefresh: BOOL, result: ?*?*IXblIdpAuthTokenResult) HRESULT {
                return @as(*const IXblIdpAuthManager.VTable, @ptrCast(self.vtable)).GetTokenAndSignatureWithTokenResult(@as(*const IXblIdpAuthManager, @ptrCast(self)), msaAccountId, appSid, msaTarget, msaPolicy, httpMethod, uri, headers, body, bodySize, forceRefresh, result);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IXblIdpAuthTokenResult_Value = Guid.initString("46ce0225-f267-4d68-b299-b2762552dec1");
pub const IID_IXblIdpAuthTokenResult = &IID_IXblIdpAuthTokenResult_Value;
pub const IXblIdpAuthTokenResult = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetStatus: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                status: ?*XBL_IDP_AUTH_TOKEN_STATUS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                status: ?*XBL_IDP_AUTH_TOKEN_STATUS,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetErrorCode: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                errorCode: ?*HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                errorCode: ?*HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetToken: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                token: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                token: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetSignature: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                signature: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                signature: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetSandbox: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                sandbox: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                sandbox: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetEnvironment: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                environment: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                environment: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMsaAccountId: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                msaAccountId: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                msaAccountId: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetXuid: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                xuid: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                xuid: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetGamertag: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                gamertag: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                gamertag: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAgeGroup: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                ageGroup: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                ageGroup: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPrivileges: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                privileges: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                privileges: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMsaTarget: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                msaTarget: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                msaTarget: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMsaPolicy: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                msaPolicy: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                msaPolicy: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMsaAppId: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                msaAppId: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                msaAppId: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetRedirect: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                redirect: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                redirect: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMessage: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                message: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                message: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetHelpId: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                helpId: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                helpId: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetEnforcementBans: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                enforcementBans: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                enforcementBans: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetRestrictions: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                restrictions: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                restrictions: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetTitleRestrictions: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult,
                titleRestrictions: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult,
                titleRestrictions: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetStatus(self: *const T, status: ?*XBL_IDP_AUTH_TOKEN_STATUS) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetStatus(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), status);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetErrorCode(self: *const T, errorCode: ?*HRESULT) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetErrorCode(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), errorCode);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetToken(self: *const T, token: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetToken(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), token);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetSignature(self: *const T, signature: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetSignature(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), signature);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetSandbox(self: *const T, sandbox: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetSandbox(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), sandbox);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetEnvironment(self: *const T, environment: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetEnvironment(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), environment);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetMsaAccountId(self: *const T, msaAccountId: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetMsaAccountId(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), msaAccountId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetXuid(self: *const T, xuid: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetXuid(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), xuid);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetGamertag(self: *const T, gamertag: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetGamertag(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), gamertag);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetAgeGroup(self: *const T, ageGroup: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetAgeGroup(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), ageGroup);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetPrivileges(self: *const T, privileges: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetPrivileges(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), privileges);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetMsaTarget(self: *const T, msaTarget: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetMsaTarget(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), msaTarget);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetMsaPolicy(self: *const T, msaPolicy: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetMsaPolicy(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), msaPolicy);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetMsaAppId(self: *const T, msaAppId: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetMsaAppId(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), msaAppId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetRedirect(self: *const T, redirect: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetRedirect(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), redirect);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetMessage(self: *const T, message: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetMessage(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), message);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetHelpId(self: *const T, helpId: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetHelpId(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), helpId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetEnforcementBans(self: *const T, enforcementBans: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetEnforcementBans(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), enforcementBans);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetRestrictions(self: *const T, restrictions: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetRestrictions(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), restrictions);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult_GetTitleRestrictions(self: *const T, titleRestrictions: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult.VTable, @ptrCast(self.vtable)).GetTitleRestrictions(@as(*const IXblIdpAuthTokenResult, @ptrCast(self)), titleRestrictions);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IXblIdpAuthTokenResult2_Value = Guid.initString("75d760b0-60b9-412d-994f-26b2cd5f7812");
pub const IID_IXblIdpAuthTokenResult2 = &IID_IXblIdpAuthTokenResult2_Value;
pub const IXblIdpAuthTokenResult2 = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetModernGamertag: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult2,
                value: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult2,
                value: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetModernGamertagSuffix: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult2,
                value: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult2,
                value: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetUniqueModernGamertag: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IXblIdpAuthTokenResult2,
                value: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IXblIdpAuthTokenResult2,
                value: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult2_GetModernGamertag(self: *const T, value: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult2.VTable, @ptrCast(self.vtable)).GetModernGamertag(@as(*const IXblIdpAuthTokenResult2, @ptrCast(self)), value);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult2_GetModernGamertagSuffix(self: *const T, value: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult2.VTable, @ptrCast(self.vtable)).GetModernGamertagSuffix(@as(*const IXblIdpAuthTokenResult2, @ptrCast(self)), value);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IXblIdpAuthTokenResult2_GetUniqueModernGamertag(self: *const T, value: ?*?PWSTR) HRESULT {
                return @as(*const IXblIdpAuthTokenResult2.VTable, @ptrCast(self.vtable)).GetUniqueModernGamertag(@as(*const IXblIdpAuthTokenResult2, @ptrCast(self)), value);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

//--------------------------------------------------------------------------------
// Section: Functions (30)
//--------------------------------------------------------------------------------
pub extern "api-ms-win-gaming-expandedresources-l1-1-0" fn HasExpandedResources(
    hasExpandedResources: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-expandedresources-l1-1-0" fn GetExpandedResourceExclusiveCpuCount(
    exclusiveCpuCount: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-expandedresources-l1-1-0" fn ReleaseExclusiveCpuSets() callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-deviceinformation-l1-1-0" fn GetGamingDeviceModelInformation(
    information: ?*GAMING_DEVICE_MODEL_INFORMATION,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-0" fn ShowGameInviteUI(
    serviceConfigurationId: ?HSTRING,
    sessionTemplateName: ?HSTRING,
    sessionId: ?HSTRING,
    invitationDisplayText: ?HSTRING,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-0" fn ShowPlayerPickerUI(
    promptDisplayText: ?HSTRING,
    xuids: [*]const ?HSTRING,
    xuidsCount: usize,
    preSelectedXuids: ?[*]const ?HSTRING,
    preSelectedXuidsCount: usize,
    minSelectionCount: usize,
    maxSelectionCount: usize,
    completionRoutine: ?PlayerPickerUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-0" fn ShowProfileCardUI(
    targetUserXuid: ?HSTRING,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-0" fn ShowChangeFriendRelationshipUI(
    targetUserXuid: ?HSTRING,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-0" fn ShowTitleAchievementsUI(
    titleId: u32,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-0" fn ProcessPendingGameUI(
    waitForCompletion: BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-0" fn TryCancelPendingGameUI() callconv(@import("std").os.windows.WINAPI) BOOL;

pub extern "api-ms-win-gaming-tcui-l1-1-1" fn CheckGamingPrivilegeWithUI(
    privilegeId: u32,
    scope: ?HSTRING,
    policy: ?HSTRING,
    friendlyMessage: ?HSTRING,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-1" fn CheckGamingPrivilegeSilently(
    privilegeId: u32,
    scope: ?HSTRING,
    policy: ?HSTRING,
    hasPrivilege: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-2" fn ShowGameInviteUIForUser(
    user: ?*IInspectable,
    serviceConfigurationId: ?HSTRING,
    sessionTemplateName: ?HSTRING,
    sessionId: ?HSTRING,
    invitationDisplayText: ?HSTRING,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-2" fn ShowPlayerPickerUIForUser(
    user: ?*IInspectable,
    promptDisplayText: ?HSTRING,
    xuids: [*]const ?HSTRING,
    xuidsCount: usize,
    preSelectedXuids: ?[*]const ?HSTRING,
    preSelectedXuidsCount: usize,
    minSelectionCount: usize,
    maxSelectionCount: usize,
    completionRoutine: ?PlayerPickerUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-2" fn ShowProfileCardUIForUser(
    user: ?*IInspectable,
    targetUserXuid: ?HSTRING,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-2" fn ShowChangeFriendRelationshipUIForUser(
    user: ?*IInspectable,
    targetUserXuid: ?HSTRING,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-2" fn ShowTitleAchievementsUIForUser(
    user: ?*IInspectable,
    titleId: u32,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-2" fn CheckGamingPrivilegeWithUIForUser(
    user: ?*IInspectable,
    privilegeId: u32,
    scope: ?HSTRING,
    policy: ?HSTRING,
    friendlyMessage: ?HSTRING,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-2" fn CheckGamingPrivilegeSilentlyForUser(
    user: ?*IInspectable,
    privilegeId: u32,
    scope: ?HSTRING,
    policy: ?HSTRING,
    hasPrivilege: ?*BOOL,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-3" fn ShowGameInviteUIWithContext(
    serviceConfigurationId: ?HSTRING,
    sessionTemplateName: ?HSTRING,
    sessionId: ?HSTRING,
    invitationDisplayText: ?HSTRING,
    customActivationContext: ?HSTRING,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-3" fn ShowGameInviteUIWithContextForUser(
    user: ?*IInspectable,
    serviceConfigurationId: ?HSTRING,
    sessionTemplateName: ?HSTRING,
    sessionId: ?HSTRING,
    invitationDisplayText: ?HSTRING,
    customActivationContext: ?HSTRING,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-4" fn ShowGameInfoUI(
    titleId: u32,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-4" fn ShowGameInfoUIForUser(
    user: ?*IInspectable,
    titleId: u32,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-4" fn ShowFindFriendsUI(
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-4" fn ShowFindFriendsUIForUser(
    user: ?*IInspectable,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-4" fn ShowCustomizeUserProfileUI(
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-4" fn ShowCustomizeUserProfileUIForUser(
    user: ?*IInspectable,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-4" fn ShowUserSettingsUI(
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "api-ms-win-gaming-tcui-l1-1-4" fn ShowUserSettingsUIForUser(
    user: ?*IInspectable,
    completionRoutine: ?GameUICompletionRoutine,
    context: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (8)
//--------------------------------------------------------------------------------
const Guid = @import("zig.zig").Guid;
const BOOL = @import("foundation.zig").BOOL;
const BSTR = @import("foundation.zig").BSTR;
const HRESULT = @import("foundation.zig").HRESULT;
const HSTRING = @import("system/win_rt.zig").HSTRING;
const IInspectable = @import("system/win_rt.zig").IInspectable;
const IUnknown = @import("system/com.zig").IUnknown;
const PWSTR = @import("foundation.zig").PWSTR;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "GameUICompletionRoutine")) {
        _ = GameUICompletionRoutine;
    }
    if (@hasDecl(@This(), "PlayerPickerUICompletionRoutine")) {
        _ = PlayerPickerUICompletionRoutine;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
