//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (14)
//--------------------------------------------------------------------------------
pub const WSDAPI_OPTION_MAX_INBOUND_MESSAGE_SIZE = @as(u32, 1);
pub const WSDAPI_OPTION_TRACE_XML_TO_DEBUGGER = @as(u32, 2);
pub const WSDAPI_OPTION_TRACE_XML_TO_FILE = @as(u32, 3);
pub const WSDAPI_SSL_CERT_APPLY_DEFAULT_CHECKS = @as(u32, 0);
pub const WSDAPI_SSL_CERT_IGNORE_REVOCATION = @as(u32, 1);
pub const WSDAPI_SSL_CERT_IGNORE_EXPIRY = @as(u32, 2);
pub const WSDAPI_SSL_CERT_IGNORE_WRONG_USAGE = @as(u32, 4);
pub const WSDAPI_SSL_CERT_IGNORE_UNKNOWN_CA = @as(u32, 8);
pub const WSDAPI_SSL_CERT_IGNORE_INVALID_CN = @as(u32, 16);
pub const WSDAPI_COMPACTSIG_ACCEPT_ALL_MESSAGES = @as(u32, 1);
pub const WSD_SECURITY_HTTP_AUTH_SCHEME_NEGOTIATE = @as(u32, 1);
pub const WSD_SECURITY_HTTP_AUTH_SCHEME_NTLM = @as(u32, 2);
pub const WSDAPI_ADDRESSFAMILY_IPV4 = @as(u32, 1);
pub const WSDAPI_ADDRESSFAMILY_IPV6 = @as(u32, 2);

//--------------------------------------------------------------------------------
// Section: Types (110)
//--------------------------------------------------------------------------------
pub const WSD_CONFIG_PARAM_TYPE = enum(i32) {
    CONFIG_MAX_INBOUND_MESSAGE_SIZE = 1,
    CONFIG_MAX_OUTBOUND_MESSAGE_SIZE = 2,
    SECURITY_SSL_CERT_FOR_CLIENT_AUTH = 3,
    SECURITY_SSL_SERVER_CERT_VALIDATION = 4,
    SECURITY_SSL_CLIENT_CERT_VALIDATION = 5,
    SECURITY_SSL_NEGOTIATE_CLIENT_CERT = 6,
    SECURITY_COMPACTSIG_SIGNING_CERT = 7,
    SECURITY_COMPACTSIG_VALIDATION = 8,
    CONFIG_HOSTING_ADDRESSES = 9,
    CONFIG_DEVICE_ADDRESSES = 10,
    SECURITY_REQUIRE_HTTP_CLIENT_AUTH = 11,
    SECURITY_REQUIRE_CLIENT_CERT_OR_HTTP_CLIENT_AUTH = 12,
    SECURITY_USE_HTTP_CLIENT_AUTH = 13,
};
pub const WSD_CONFIG_MAX_INBOUND_MESSAGE_SIZE = WSD_CONFIG_PARAM_TYPE.CONFIG_MAX_INBOUND_MESSAGE_SIZE;
pub const WSD_CONFIG_MAX_OUTBOUND_MESSAGE_SIZE = WSD_CONFIG_PARAM_TYPE.CONFIG_MAX_OUTBOUND_MESSAGE_SIZE;
pub const WSD_SECURITY_SSL_CERT_FOR_CLIENT_AUTH = WSD_CONFIG_PARAM_TYPE.SECURITY_SSL_CERT_FOR_CLIENT_AUTH;
pub const WSD_SECURITY_SSL_SERVER_CERT_VALIDATION = WSD_CONFIG_PARAM_TYPE.SECURITY_SSL_SERVER_CERT_VALIDATION;
pub const WSD_SECURITY_SSL_CLIENT_CERT_VALIDATION = WSD_CONFIG_PARAM_TYPE.SECURITY_SSL_CLIENT_CERT_VALIDATION;
pub const WSD_SECURITY_SSL_NEGOTIATE_CLIENT_CERT = WSD_CONFIG_PARAM_TYPE.SECURITY_SSL_NEGOTIATE_CLIENT_CERT;
pub const WSD_SECURITY_COMPACTSIG_SIGNING_CERT = WSD_CONFIG_PARAM_TYPE.SECURITY_COMPACTSIG_SIGNING_CERT;
pub const WSD_SECURITY_COMPACTSIG_VALIDATION = WSD_CONFIG_PARAM_TYPE.SECURITY_COMPACTSIG_VALIDATION;
pub const WSD_CONFIG_HOSTING_ADDRESSES = WSD_CONFIG_PARAM_TYPE.CONFIG_HOSTING_ADDRESSES;
pub const WSD_CONFIG_DEVICE_ADDRESSES = WSD_CONFIG_PARAM_TYPE.CONFIG_DEVICE_ADDRESSES;
pub const WSD_SECURITY_REQUIRE_HTTP_CLIENT_AUTH = WSD_CONFIG_PARAM_TYPE.SECURITY_REQUIRE_HTTP_CLIENT_AUTH;
pub const WSD_SECURITY_REQUIRE_CLIENT_CERT_OR_HTTP_CLIENT_AUTH = WSD_CONFIG_PARAM_TYPE.SECURITY_REQUIRE_CLIENT_CERT_OR_HTTP_CLIENT_AUTH;
pub const WSD_SECURITY_USE_HTTP_CLIENT_AUTH = WSD_CONFIG_PARAM_TYPE.SECURITY_USE_HTTP_CLIENT_AUTH;

pub const WSD_CONFIG_PARAM = extern struct {
    configParamType: WSD_CONFIG_PARAM_TYPE,
    pConfigData: ?*anyopaque,
    dwConfigDataSize: u32,
};

pub const WSD_SECURITY_CERT_VALIDATION_V1 = extern struct {
    certMatchArray: ?*?*CERT_CONTEXT,
    dwCertMatchArrayCount: u32,
    hCertMatchStore: ?*anyopaque,
    hCertIssuerStore: ?*anyopaque,
    dwCertCheckOptions: u32,
};

pub const WSD_SECURITY_CERT_VALIDATION = extern struct {
    certMatchArray: ?*?*CERT_CONTEXT,
    dwCertMatchArrayCount: u32,
    hCertMatchStore: ?*anyopaque,
    hCertIssuerStore: ?*anyopaque,
    dwCertCheckOptions: u32,
    pszCNGHashAlgId: ?[*:0]const u16,
    pbCertHash: ?*u8,
    dwCertHashSize: u32,
};

pub const WSD_SECURITY_SIGNATURE_VALIDATION = extern struct {
    signingCertArray: ?*?*CERT_CONTEXT,
    dwSigningCertArrayCount: u32,
    hSigningCertStore: ?*anyopaque,
    dwFlags: u32,
};

pub const WSD_CONFIG_ADDRESSES = extern struct {
    addresses: ?*?*IWSDAddress,
    dwAddressCount: u32,
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDAddress_Value = Guid.initString("b9574c6c-12a6-4f74-93a1-3318ff605759");
pub const IID_IWSDAddress = &IID_IWSDAddress_Value;
pub const IWSDAddress = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Serialize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDAddress,
                pszBuffer: [*:0]u16,
                cchLength: u32,
                fSafe: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDAddress,
                pszBuffer: [*:0]u16,
                cchLength: u32,
                fSafe: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Deserialize: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDAddress,
                pszBuffer: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDAddress,
                pszBuffer: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDAddress_Serialize(self: *const T, pszBuffer: [*:0]u16, cchLength: u32, fSafe: BOOL) HRESULT {
                return @as(*const IWSDAddress.VTable, @ptrCast(self.vtable)).Serialize(@as(*const IWSDAddress, @ptrCast(self)), pszBuffer, cchLength, fSafe);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDAddress_Deserialize(self: *const T, pszBuffer: ?[*:0]const u16) HRESULT {
                return @as(*const IWSDAddress.VTable, @ptrCast(self.vtable)).Deserialize(@as(*const IWSDAddress, @ptrCast(self)), pszBuffer);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDTransportAddress_Value = Guid.initString("70d23498-4ee6-4340-a3df-d845d2235467");
pub const IID_IWSDTransportAddress = &IID_IWSDTransportAddress_Value;
pub const IWSDTransportAddress = extern struct {
    pub const VTable = extern struct {
        base: IWSDAddress.VTable,
        GetPort: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDTransportAddress,
                pwPort: ?*u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDTransportAddress,
                pwPort: ?*u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetPort: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDTransportAddress,
                wPort: u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDTransportAddress,
                wPort: u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetTransportAddress: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDTransportAddress,
                ppszAddress: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDTransportAddress,
                ppszAddress: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetTransportAddressEx: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDTransportAddress,
                fSafe: BOOL,
                ppszAddress: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDTransportAddress,
                fSafe: BOOL,
                ppszAddress: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTransportAddress: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDTransportAddress,
                pszAddress: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDTransportAddress,
                pszAddress: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWSDAddress.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDTransportAddress_GetPort(self: *const T, pwPort: ?*u16) HRESULT {
                return @as(*const IWSDTransportAddress.VTable, @ptrCast(self.vtable)).GetPort(@as(*const IWSDTransportAddress, @ptrCast(self)), pwPort);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDTransportAddress_SetPort(self: *const T, wPort: u16) HRESULT {
                return @as(*const IWSDTransportAddress.VTable, @ptrCast(self.vtable)).SetPort(@as(*const IWSDTransportAddress, @ptrCast(self)), wPort);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDTransportAddress_GetTransportAddress(self: *const T, ppszAddress: ?*?PWSTR) HRESULT {
                return @as(*const IWSDTransportAddress.VTable, @ptrCast(self.vtable)).GetTransportAddress(@as(*const IWSDTransportAddress, @ptrCast(self)), ppszAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDTransportAddress_GetTransportAddressEx(self: *const T, fSafe: BOOL, ppszAddress: ?*?PWSTR) HRESULT {
                return @as(*const IWSDTransportAddress.VTable, @ptrCast(self.vtable)).GetTransportAddressEx(@as(*const IWSDTransportAddress, @ptrCast(self)), fSafe, ppszAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDTransportAddress_SetTransportAddress(self: *const T, pszAddress: ?[*:0]const u16) HRESULT {
                return @as(*const IWSDTransportAddress.VTable, @ptrCast(self.vtable)).SetTransportAddress(@as(*const IWSDTransportAddress, @ptrCast(self)), pszAddress);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDMessageParameters_Value = Guid.initString("1fafe8a2-e6fc-4b80-b6cf-b7d45c416d7c");
pub const IID_IWSDMessageParameters = &IID_IWSDMessageParameters_Value;
pub const IWSDMessageParameters = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetLocalAddress: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDMessageParameters,
                ppAddress: ?*?*IWSDAddress,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDMessageParameters,
                ppAddress: ?*?*IWSDAddress,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetLocalAddress: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDMessageParameters,
                pAddress: ?*IWSDAddress,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDMessageParameters,
                pAddress: ?*IWSDAddress,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetRemoteAddress: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDMessageParameters,
                ppAddress: ?*?*IWSDAddress,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDMessageParameters,
                ppAddress: ?*?*IWSDAddress,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetRemoteAddress: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDMessageParameters,
                pAddress: ?*IWSDAddress,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDMessageParameters,
                pAddress: ?*IWSDAddress,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetLowerParameters: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDMessageParameters,
                ppTxParams: ?*?*IWSDMessageParameters,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDMessageParameters,
                ppTxParams: ?*?*IWSDMessageParameters,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDMessageParameters_GetLocalAddress(self: *const T, ppAddress: ?*?*IWSDAddress) HRESULT {
                return @as(*const IWSDMessageParameters.VTable, @ptrCast(self.vtable)).GetLocalAddress(@as(*const IWSDMessageParameters, @ptrCast(self)), ppAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDMessageParameters_SetLocalAddress(self: *const T, pAddress: ?*IWSDAddress) HRESULT {
                return @as(*const IWSDMessageParameters.VTable, @ptrCast(self.vtable)).SetLocalAddress(@as(*const IWSDMessageParameters, @ptrCast(self)), pAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDMessageParameters_GetRemoteAddress(self: *const T, ppAddress: ?*?*IWSDAddress) HRESULT {
                return @as(*const IWSDMessageParameters.VTable, @ptrCast(self.vtable)).GetRemoteAddress(@as(*const IWSDMessageParameters, @ptrCast(self)), ppAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDMessageParameters_SetRemoteAddress(self: *const T, pAddress: ?*IWSDAddress) HRESULT {
                return @as(*const IWSDMessageParameters.VTable, @ptrCast(self.vtable)).SetRemoteAddress(@as(*const IWSDMessageParameters, @ptrCast(self)), pAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDMessageParameters_GetLowerParameters(self: *const T, ppTxParams: ?*?*IWSDMessageParameters) HRESULT {
                return @as(*const IWSDMessageParameters.VTable, @ptrCast(self.vtable)).GetLowerParameters(@as(*const IWSDMessageParameters, @ptrCast(self)), ppTxParams);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const WSDUdpRetransmitParams = extern struct {
    ulSendDelay: u32,
    ulRepeat: u32,
    ulRepeatMinDelay: u32,
    ulRepeatMaxDelay: u32,
    ulRepeatUpperDelay: u32,
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDUdpMessageParameters_Value = Guid.initString("9934149f-8f0c-447b-aa0b-73124b0ca7f0");
pub const IID_IWSDUdpMessageParameters = &IID_IWSDUdpMessageParameters_Value;
pub const IWSDUdpMessageParameters = extern struct {
    pub const VTable = extern struct {
        base: IWSDMessageParameters.VTable,
        SetRetransmitParams: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDUdpMessageParameters,
                pParams: ?*const WSDUdpRetransmitParams,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDUdpMessageParameters,
                pParams: ?*const WSDUdpRetransmitParams,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetRetransmitParams: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDUdpMessageParameters,
                pParams: ?*WSDUdpRetransmitParams,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDUdpMessageParameters,
                pParams: ?*WSDUdpRetransmitParams,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWSDMessageParameters.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDUdpMessageParameters_SetRetransmitParams(self: *const T, pParams: ?*const WSDUdpRetransmitParams) HRESULT {
                return @as(*const IWSDUdpMessageParameters.VTable, @ptrCast(self.vtable)).SetRetransmitParams(@as(*const IWSDUdpMessageParameters, @ptrCast(self)), pParams);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDUdpMessageParameters_GetRetransmitParams(self: *const T, pParams: ?*WSDUdpRetransmitParams) HRESULT {
                return @as(*const IWSDUdpMessageParameters.VTable, @ptrCast(self.vtable)).GetRetransmitParams(@as(*const IWSDUdpMessageParameters, @ptrCast(self)), pParams);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const WSDUdpMessageType = enum(i32) {
    ONE_WAY = 0,
    TWO_WAY = 1,
};
pub const ONE_WAY = WSDUdpMessageType.ONE_WAY;
pub const TWO_WAY = WSDUdpMessageType.TWO_WAY;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDUdpAddress_Value = Guid.initString("74d6124a-a441-4f78-a1eb-97a8d1996893");
pub const IID_IWSDUdpAddress = &IID_IWSDUdpAddress_Value;
pub const IWSDUdpAddress = extern struct {
    pub const VTable = extern struct {
        base: IWSDTransportAddress.VTable,
        SetSockaddr: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDUdpAddress,
                pSockAddr: ?*const SOCKADDR_STORAGE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDUdpAddress,
                pSockAddr: ?*const SOCKADDR_STORAGE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetSockaddr: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDUdpAddress,
                pSockAddr: ?*SOCKADDR_STORAGE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDUdpAddress,
                pSockAddr: ?*SOCKADDR_STORAGE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetExclusive: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDUdpAddress,
                fExclusive: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDUdpAddress,
                fExclusive: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetExclusive: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDUdpAddress,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDUdpAddress,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetMessageType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDUdpAddress,
                messageType: WSDUdpMessageType,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDUdpAddress,
                messageType: WSDUdpMessageType,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMessageType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDUdpAddress,
                pMessageType: ?*WSDUdpMessageType,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDUdpAddress,
                pMessageType: ?*WSDUdpMessageType,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTTL: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDUdpAddress,
                dwTTL: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDUdpAddress,
                dwTTL: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetTTL: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDUdpAddress,
                pdwTTL: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDUdpAddress,
                pdwTTL: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetAlias: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDUdpAddress,
                pAlias: ?*const Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDUdpAddress,
                pAlias: ?*const Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAlias: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDUdpAddress,
                pAlias: ?*Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDUdpAddress,
                pAlias: ?*Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWSDTransportAddress.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDUdpAddress_SetSockaddr(self: *const T, pSockAddr: ?*const SOCKADDR_STORAGE) HRESULT {
                return @as(*const IWSDUdpAddress.VTable, @ptrCast(self.vtable)).SetSockaddr(@as(*const IWSDUdpAddress, @ptrCast(self)), pSockAddr);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDUdpAddress_GetSockaddr(self: *const T, pSockAddr: ?*SOCKADDR_STORAGE) HRESULT {
                return @as(*const IWSDUdpAddress.VTable, @ptrCast(self.vtable)).GetSockaddr(@as(*const IWSDUdpAddress, @ptrCast(self)), pSockAddr);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDUdpAddress_SetExclusive(self: *const T, fExclusive: BOOL) HRESULT {
                return @as(*const IWSDUdpAddress.VTable, @ptrCast(self.vtable)).SetExclusive(@as(*const IWSDUdpAddress, @ptrCast(self)), fExclusive);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDUdpAddress_GetExclusive(self: *const T) HRESULT {
                return @as(*const IWSDUdpAddress.VTable, @ptrCast(self.vtable)).GetExclusive(@as(*const IWSDUdpAddress, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDUdpAddress_SetMessageType(self: *const T, messageType: WSDUdpMessageType) HRESULT {
                return @as(*const IWSDUdpAddress.VTable, @ptrCast(self.vtable)).SetMessageType(@as(*const IWSDUdpAddress, @ptrCast(self)), messageType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDUdpAddress_GetMessageType(self: *const T, pMessageType: ?*WSDUdpMessageType) HRESULT {
                return @as(*const IWSDUdpAddress.VTable, @ptrCast(self.vtable)).GetMessageType(@as(*const IWSDUdpAddress, @ptrCast(self)), pMessageType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDUdpAddress_SetTTL(self: *const T, dwTTL: u32) HRESULT {
                return @as(*const IWSDUdpAddress.VTable, @ptrCast(self.vtable)).SetTTL(@as(*const IWSDUdpAddress, @ptrCast(self)), dwTTL);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDUdpAddress_GetTTL(self: *const T, pdwTTL: ?*u32) HRESULT {
                return @as(*const IWSDUdpAddress.VTable, @ptrCast(self.vtable)).GetTTL(@as(*const IWSDUdpAddress, @ptrCast(self)), pdwTTL);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDUdpAddress_SetAlias(self: *const T, pAlias: ?*const Guid) HRESULT {
                return @as(*const IWSDUdpAddress.VTable, @ptrCast(self.vtable)).SetAlias(@as(*const IWSDUdpAddress, @ptrCast(self)), pAlias);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDUdpAddress_GetAlias(self: *const T, pAlias: ?*Guid) HRESULT {
                return @as(*const IWSDUdpAddress.VTable, @ptrCast(self.vtable)).GetAlias(@as(*const IWSDUdpAddress, @ptrCast(self)), pAlias);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDHttpMessageParameters_Value = Guid.initString("540bd122-5c83-4dec-b396-ea62a2697fdf");
pub const IID_IWSDHttpMessageParameters = &IID_IWSDHttpMessageParameters_Value;
pub const IWSDHttpMessageParameters = extern struct {
    pub const VTable = extern struct {
        base: IWSDMessageParameters.VTable,
        SetInboundHttpHeaders: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDHttpMessageParameters,
                pszHeaders: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDHttpMessageParameters,
                pszHeaders: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInboundHttpHeaders: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDHttpMessageParameters,
                ppszHeaders: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDHttpMessageParameters,
                ppszHeaders: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOutboundHttpHeaders: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDHttpMessageParameters,
                pszHeaders: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDHttpMessageParameters,
                pszHeaders: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetOutboundHttpHeaders: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDHttpMessageParameters,
                ppszHeaders: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDHttpMessageParameters,
                ppszHeaders: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetID: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDHttpMessageParameters,
                pszId: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDHttpMessageParameters,
                pszId: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetID: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDHttpMessageParameters,
                ppszId: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDHttpMessageParameters,
                ppszId: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetContext: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDHttpMessageParameters,
                pContext: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDHttpMessageParameters,
                pContext: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetContext: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDHttpMessageParameters,
                ppContext: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDHttpMessageParameters,
                ppContext: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Clear: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDHttpMessageParameters,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDHttpMessageParameters,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWSDMessageParameters.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDHttpMessageParameters_SetInboundHttpHeaders(self: *const T, pszHeaders: ?[*:0]const u16) HRESULT {
                return @as(*const IWSDHttpMessageParameters.VTable, @ptrCast(self.vtable)).SetInboundHttpHeaders(@as(*const IWSDHttpMessageParameters, @ptrCast(self)), pszHeaders);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDHttpMessageParameters_GetInboundHttpHeaders(self: *const T, ppszHeaders: ?*?PWSTR) HRESULT {
                return @as(*const IWSDHttpMessageParameters.VTable, @ptrCast(self.vtable)).GetInboundHttpHeaders(@as(*const IWSDHttpMessageParameters, @ptrCast(self)), ppszHeaders);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDHttpMessageParameters_SetOutboundHttpHeaders(self: *const T, pszHeaders: ?[*:0]const u16) HRESULT {
                return @as(*const IWSDHttpMessageParameters.VTable, @ptrCast(self.vtable)).SetOutboundHttpHeaders(@as(*const IWSDHttpMessageParameters, @ptrCast(self)), pszHeaders);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDHttpMessageParameters_GetOutboundHttpHeaders(self: *const T, ppszHeaders: ?*?PWSTR) HRESULT {
                return @as(*const IWSDHttpMessageParameters.VTable, @ptrCast(self.vtable)).GetOutboundHttpHeaders(@as(*const IWSDHttpMessageParameters, @ptrCast(self)), ppszHeaders);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDHttpMessageParameters_SetID(self: *const T, pszId: ?[*:0]const u16) HRESULT {
                return @as(*const IWSDHttpMessageParameters.VTable, @ptrCast(self.vtable)).SetID(@as(*const IWSDHttpMessageParameters, @ptrCast(self)), pszId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDHttpMessageParameters_GetID(self: *const T, ppszId: ?*?PWSTR) HRESULT {
                return @as(*const IWSDHttpMessageParameters.VTable, @ptrCast(self.vtable)).GetID(@as(*const IWSDHttpMessageParameters, @ptrCast(self)), ppszId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDHttpMessageParameters_SetContext(self: *const T, pContext: ?*IUnknown) HRESULT {
                return @as(*const IWSDHttpMessageParameters.VTable, @ptrCast(self.vtable)).SetContext(@as(*const IWSDHttpMessageParameters, @ptrCast(self)), pContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDHttpMessageParameters_GetContext(self: *const T, ppContext: ?*?*IUnknown) HRESULT {
                return @as(*const IWSDHttpMessageParameters.VTable, @ptrCast(self.vtable)).GetContext(@as(*const IWSDHttpMessageParameters, @ptrCast(self)), ppContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDHttpMessageParameters_Clear(self: *const T) HRESULT {
                return @as(*const IWSDHttpMessageParameters.VTable, @ptrCast(self.vtable)).Clear(@as(*const IWSDHttpMessageParameters, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDHttpAddress_Value = Guid.initString("d09ac7bd-2a3e-4b85-8605-2737ff3e4ea0");
pub const IID_IWSDHttpAddress = &IID_IWSDHttpAddress_Value;
pub const IWSDHttpAddress = extern struct {
    pub const VTable = extern struct {
        base: IWSDTransportAddress.VTable,
        GetSecure: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDHttpAddress,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDHttpAddress,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetSecure: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDHttpAddress,
                fSecure: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDHttpAddress,
                fSecure: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetPath: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDHttpAddress,
                ppszPath: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDHttpAddress,
                ppszPath: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetPath: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDHttpAddress,
                pszPath: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDHttpAddress,
                pszPath: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWSDTransportAddress.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDHttpAddress_GetSecure(self: *const T) HRESULT {
                return @as(*const IWSDHttpAddress.VTable, @ptrCast(self.vtable)).GetSecure(@as(*const IWSDHttpAddress, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDHttpAddress_SetSecure(self: *const T, fSecure: BOOL) HRESULT {
                return @as(*const IWSDHttpAddress.VTable, @ptrCast(self.vtable)).SetSecure(@as(*const IWSDHttpAddress, @ptrCast(self)), fSecure);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDHttpAddress_GetPath(self: *const T, ppszPath: ?*?PWSTR) HRESULT {
                return @as(*const IWSDHttpAddress.VTable, @ptrCast(self.vtable)).GetPath(@as(*const IWSDHttpAddress, @ptrCast(self)), ppszPath);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDHttpAddress_SetPath(self: *const T, pszPath: ?[*:0]const u16) HRESULT {
                return @as(*const IWSDHttpAddress.VTable, @ptrCast(self.vtable)).SetPath(@as(*const IWSDHttpAddress, @ptrCast(self)), pszPath);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IWSDSSLClientCertificate_Value = Guid.initString("de105e87-a0da-418e-98ad-27b9eed87bdc");
pub const IID_IWSDSSLClientCertificate = &IID_IWSDSSLClientCertificate_Value;
pub const IWSDSSLClientCertificate = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetClientCertificate: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDSSLClientCertificate,
                ppCertContext: ?*?*CERT_CONTEXT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDSSLClientCertificate,
                ppCertContext: ?*?*CERT_CONTEXT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMappedAccessToken: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDSSLClientCertificate,
                phToken: ?*?HANDLE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDSSLClientCertificate,
                phToken: ?*?HANDLE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDSSLClientCertificate_GetClientCertificate(self: *const T, ppCertContext: ?*?*CERT_CONTEXT) HRESULT {
                return @as(*const IWSDSSLClientCertificate.VTable, @ptrCast(self.vtable)).GetClientCertificate(@as(*const IWSDSSLClientCertificate, @ptrCast(self)), ppCertContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDSSLClientCertificate_GetMappedAccessToken(self: *const T, phToken: ?*?HANDLE) HRESULT {
                return @as(*const IWSDSSLClientCertificate.VTable, @ptrCast(self.vtable)).GetMappedAccessToken(@as(*const IWSDSSLClientCertificate, @ptrCast(self)), phToken);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows8.0'
const IID_IWSDHttpAuthParameters_Value = Guid.initString("0b476df0-8dac-480d-b05c-99781a5884aa");
pub const IID_IWSDHttpAuthParameters = &IID_IWSDHttpAuthParameters_Value;
pub const IWSDHttpAuthParameters = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetClientAccessToken: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDHttpAuthParameters,
                phToken: ?*?HANDLE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDHttpAuthParameters,
                phToken: ?*?HANDLE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAuthType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDHttpAuthParameters,
                pAuthType: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDHttpAuthParameters,
                pAuthType: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDHttpAuthParameters_GetClientAccessToken(self: *const T, phToken: ?*?HANDLE) HRESULT {
                return @as(*const IWSDHttpAuthParameters.VTable, @ptrCast(self.vtable)).GetClientAccessToken(@as(*const IWSDHttpAuthParameters, @ptrCast(self)), phToken);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDHttpAuthParameters_GetAuthType(self: *const T, pAuthType: ?*u32) HRESULT {
                return @as(*const IWSDHttpAuthParameters.VTable, @ptrCast(self.vtable)).GetAuthType(@as(*const IWSDHttpAuthParameters, @ptrCast(self)), pAuthType);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IWSDSignatureProperty_Value = Guid.initString("03ce20aa-71c4-45e2-b32e-3766c61c790f");
pub const IID_IWSDSignatureProperty = &IID_IWSDSignatureProperty_Value;
pub const IWSDSignatureProperty = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        IsMessageSigned: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDSignatureProperty,
                pbSigned: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDSignatureProperty,
                pbSigned: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        IsMessageSignatureTrusted: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDSignatureProperty,
                pbSignatureTrusted: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDSignatureProperty,
                pbSignatureTrusted: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetKeyInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDSignatureProperty,
                // TODO: what to do with BytesParamIndex 1?
                pbKeyInfo: ?*u8,
                pdwKeyInfoSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDSignatureProperty,
                // TODO: what to do with BytesParamIndex 1?
                pbKeyInfo: ?*u8,
                pdwKeyInfoSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetSignature: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDSignatureProperty,
                // TODO: what to do with BytesParamIndex 1?
                pbSignature: ?*u8,
                pdwSignatureSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDSignatureProperty,
                // TODO: what to do with BytesParamIndex 1?
                pbSignature: ?*u8,
                pdwSignatureSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetSignedInfoHash: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDSignatureProperty,
                // TODO: what to do with BytesParamIndex 1?
                pbSignedInfoHash: ?*u8,
                pdwHashSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDSignatureProperty,
                // TODO: what to do with BytesParamIndex 1?
                pbSignedInfoHash: ?*u8,
                pdwHashSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDSignatureProperty_IsMessageSigned(self: *const T, pbSigned: ?*BOOL) HRESULT {
                return @as(*const IWSDSignatureProperty.VTable, @ptrCast(self.vtable)).IsMessageSigned(@as(*const IWSDSignatureProperty, @ptrCast(self)), pbSigned);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDSignatureProperty_IsMessageSignatureTrusted(self: *const T, pbSignatureTrusted: ?*BOOL) HRESULT {
                return @as(*const IWSDSignatureProperty.VTable, @ptrCast(self.vtable)).IsMessageSignatureTrusted(@as(*const IWSDSignatureProperty, @ptrCast(self)), pbSignatureTrusted);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDSignatureProperty_GetKeyInfo(self: *const T, pbKeyInfo: ?*u8, pdwKeyInfoSize: ?*u32) HRESULT {
                return @as(*const IWSDSignatureProperty.VTable, @ptrCast(self.vtable)).GetKeyInfo(@as(*const IWSDSignatureProperty, @ptrCast(self)), pbKeyInfo, pdwKeyInfoSize);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDSignatureProperty_GetSignature(self: *const T, pbSignature: ?*u8, pdwSignatureSize: ?*u32) HRESULT {
                return @as(*const IWSDSignatureProperty.VTable, @ptrCast(self.vtable)).GetSignature(@as(*const IWSDSignatureProperty, @ptrCast(self)), pbSignature, pdwSignatureSize);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDSignatureProperty_GetSignedInfoHash(self: *const T, pbSignedInfoHash: ?*u8, pdwHashSize: ?*u32) HRESULT {
                return @as(*const IWSDSignatureProperty.VTable, @ptrCast(self.vtable)).GetSignedInfoHash(@as(*const IWSDSignatureProperty, @ptrCast(self)), pbSignedInfoHash, pdwHashSize);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDAttachment_Value = Guid.initString("5d55a616-9df8-4b09-b156-9ba351a48b76");
pub const IID_IWSDAttachment = &IID_IWSDAttachment_Value;
pub const IWSDAttachment = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDOutboundAttachment_Value = Guid.initString("aa302f8d-5a22-4ba5-b392-aa8486f4c15d");
pub const IID_IWSDOutboundAttachment = &IID_IWSDOutboundAttachment_Value;
pub const IWSDOutboundAttachment = extern struct {
    pub const VTable = extern struct {
        base: IWSDAttachment.VTable,
        Write: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDOutboundAttachment,
                pBuffer: [*:0]const u8,
                dwBytesToWrite: u32,
                pdwNumberOfBytesWritten: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDOutboundAttachment,
                pBuffer: [*:0]const u8,
                dwBytesToWrite: u32,
                pdwNumberOfBytesWritten: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Close: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDOutboundAttachment,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDOutboundAttachment,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Abort: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDOutboundAttachment,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDOutboundAttachment,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWSDAttachment.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDOutboundAttachment_Write(self: *const T, pBuffer: [*:0]const u8, dwBytesToWrite: u32, pdwNumberOfBytesWritten: ?*u32) HRESULT {
                return @as(*const IWSDOutboundAttachment.VTable, @ptrCast(self.vtable)).Write(@as(*const IWSDOutboundAttachment, @ptrCast(self)), pBuffer, dwBytesToWrite, pdwNumberOfBytesWritten);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDOutboundAttachment_Close(self: *const T) HRESULT {
                return @as(*const IWSDOutboundAttachment.VTable, @ptrCast(self.vtable)).Close(@as(*const IWSDOutboundAttachment, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDOutboundAttachment_Abort(self: *const T) HRESULT {
                return @as(*const IWSDOutboundAttachment.VTable, @ptrCast(self.vtable)).Abort(@as(*const IWSDOutboundAttachment, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDInboundAttachment_Value = Guid.initString("5bd6ca65-233c-4fb8-9f7a-2641619655c9");
pub const IID_IWSDInboundAttachment = &IID_IWSDInboundAttachment_Value;
pub const IWSDInboundAttachment = extern struct {
    pub const VTable = extern struct {
        base: IWSDAttachment.VTable,
        Read: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDInboundAttachment,
                pBuffer: [*:0]u8,
                dwBytesToRead: u32,
                pdwNumberOfBytesRead: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDInboundAttachment,
                pBuffer: [*:0]u8,
                dwBytesToRead: u32,
                pdwNumberOfBytesRead: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Close: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDInboundAttachment,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDInboundAttachment,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWSDAttachment.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDInboundAttachment_Read(self: *const T, pBuffer: [*:0]u8, dwBytesToRead: u32, pdwNumberOfBytesRead: ?*u32) HRESULT {
                return @as(*const IWSDInboundAttachment.VTable, @ptrCast(self.vtable)).Read(@as(*const IWSDInboundAttachment, @ptrCast(self)), pBuffer, dwBytesToRead, pdwNumberOfBytesRead);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDInboundAttachment_Close(self: *const T) HRESULT {
                return @as(*const IWSDInboundAttachment.VTable, @ptrCast(self.vtable)).Close(@as(*const IWSDInboundAttachment, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const WSD_DATETIME = extern struct {
    isPositive: BOOL,
    year: u32,
    month: u8,
    day: u8,
    hour: u8,
    minute: u8,
    second: u8,
    millisecond: u32,
    TZIsLocal: BOOL,
    TZIsPositive: BOOL,
    TZHour: u8,
    TZMinute: u8,
};

pub const WSD_DURATION = extern struct {
    isPositive: BOOL,
    year: u32,
    month: u32,
    day: u32,
    hour: u32,
    minute: u32,
    second: u32,
    millisecond: u32,
};

pub const WSDXML_OP = enum(i32) {
    None = 0,
    EndOfTable = 1,
    BeginElement_ = 2,
    BeginAnyElement = 3,
    EndElement = 4,
    Element_ = 5,
    AnyElement = 6,
    AnyElements = 7,
    AnyText = 8,
    Attribute_ = 9,
    BeginChoice = 10,
    EndChoice = 11,
    BeginSequence = 12,
    EndSequence = 13,
    BeginAll = 14,
    EndAll = 15,
    Anything = 16,
    AnyNumber = 17,
    OneOrMore = 18,
    Optional = 19,
    FormatBool_ = 20,
    FormatInt8_ = 21,
    FormatInt16_ = 22,
    FormatInt32_ = 23,
    FormatInt64_ = 24,
    FormatUInt8_ = 25,
    FormatUInt16_ = 26,
    FormatUInt32_ = 27,
    FormatUInt64_ = 28,
    FormatUnicodeString_ = 29,
    FormatDom_ = 30,
    FormatStruct_ = 31,
    FormatUri_ = 32,
    FormatUuidUri_ = 33,
    FormatName_ = 34,
    FormatListInsertTail_ = 35,
    FormatType_ = 36,
    FormatDynamicType_ = 37,
    FormatLookupType_ = 38,
    FormatDuration_ = 39,
    FormatDateTime_ = 40,
    FormatFloat_ = 41,
    FormatDouble_ = 42,
    Process_ = 43,
    QualifiedAttribute_ = 44,
    FormatXMLDeclaration_ = 45,
    FormatMax = 46,
};
pub const OpNone = WSDXML_OP.None;
pub const OpEndOfTable = WSDXML_OP.EndOfTable;
pub const OpBeginElement_ = WSDXML_OP.BeginElement_;
pub const OpBeginAnyElement = WSDXML_OP.BeginAnyElement;
pub const OpEndElement = WSDXML_OP.EndElement;
pub const OpElement_ = WSDXML_OP.Element_;
pub const OpAnyElement = WSDXML_OP.AnyElement;
pub const OpAnyElements = WSDXML_OP.AnyElements;
pub const OpAnyText = WSDXML_OP.AnyText;
pub const OpAttribute_ = WSDXML_OP.Attribute_;
pub const OpBeginChoice = WSDXML_OP.BeginChoice;
pub const OpEndChoice = WSDXML_OP.EndChoice;
pub const OpBeginSequence = WSDXML_OP.BeginSequence;
pub const OpEndSequence = WSDXML_OP.EndSequence;
pub const OpBeginAll = WSDXML_OP.BeginAll;
pub const OpEndAll = WSDXML_OP.EndAll;
pub const OpAnything = WSDXML_OP.Anything;
pub const OpAnyNumber = WSDXML_OP.AnyNumber;
pub const OpOneOrMore = WSDXML_OP.OneOrMore;
pub const OpOptional = WSDXML_OP.Optional;
pub const OpFormatBool_ = WSDXML_OP.FormatBool_;
pub const OpFormatInt8_ = WSDXML_OP.FormatInt8_;
pub const OpFormatInt16_ = WSDXML_OP.FormatInt16_;
pub const OpFormatInt32_ = WSDXML_OP.FormatInt32_;
pub const OpFormatInt64_ = WSDXML_OP.FormatInt64_;
pub const OpFormatUInt8_ = WSDXML_OP.FormatUInt8_;
pub const OpFormatUInt16_ = WSDXML_OP.FormatUInt16_;
pub const OpFormatUInt32_ = WSDXML_OP.FormatUInt32_;
pub const OpFormatUInt64_ = WSDXML_OP.FormatUInt64_;
pub const OpFormatUnicodeString_ = WSDXML_OP.FormatUnicodeString_;
pub const OpFormatDom_ = WSDXML_OP.FormatDom_;
pub const OpFormatStruct_ = WSDXML_OP.FormatStruct_;
pub const OpFormatUri_ = WSDXML_OP.FormatUri_;
pub const OpFormatUuidUri_ = WSDXML_OP.FormatUuidUri_;
pub const OpFormatName_ = WSDXML_OP.FormatName_;
pub const OpFormatListInsertTail_ = WSDXML_OP.FormatListInsertTail_;
pub const OpFormatType_ = WSDXML_OP.FormatType_;
pub const OpFormatDynamicType_ = WSDXML_OP.FormatDynamicType_;
pub const OpFormatLookupType_ = WSDXML_OP.FormatLookupType_;
pub const OpFormatDuration_ = WSDXML_OP.FormatDuration_;
pub const OpFormatDateTime_ = WSDXML_OP.FormatDateTime_;
pub const OpFormatFloat_ = WSDXML_OP.FormatFloat_;
pub const OpFormatDouble_ = WSDXML_OP.FormatDouble_;
pub const OpProcess_ = WSDXML_OP.Process_;
pub const OpQualifiedAttribute_ = WSDXML_OP.QualifiedAttribute_;
pub const OpFormatXMLDeclaration_ = WSDXML_OP.FormatXMLDeclaration_;
pub const OpFormatMax = WSDXML_OP.FormatMax;

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDXMLContext_Value = Guid.initString("75d8f3ee-3e5a-43b4-a15a-bcf6887460c0");
pub const IID_IWSDXMLContext = &IID_IWSDXMLContext_Value;
pub const IWSDXMLContext = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        AddNamespace: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDXMLContext,
                pszUri: ?[*:0]const u16,
                pszSuggestedPrefix: ?[*:0]const u16,
                ppNamespace: ?*?*WSDXML_NAMESPACE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDXMLContext,
                pszUri: ?[*:0]const u16,
                pszSuggestedPrefix: ?[*:0]const u16,
                ppNamespace: ?*?*WSDXML_NAMESPACE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddNameToNamespace: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDXMLContext,
                pszUri: ?[*:0]const u16,
                pszName: ?[*:0]const u16,
                ppName: ?*?*WSDXML_NAME,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDXMLContext,
                pszUri: ?[*:0]const u16,
                pszName: ?[*:0]const u16,
                ppName: ?*?*WSDXML_NAME,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetNamespaces: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDXMLContext,
                pNamespaces: [*]const ?*const WSDXML_NAMESPACE,
                wNamespacesCount: u16,
                bLayerNumber: u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDXMLContext,
                pNamespaces: [*]const ?*const WSDXML_NAMESPACE,
                wNamespacesCount: u16,
                bLayerNumber: u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetTypes: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDXMLContext,
                pTypes: [*]const ?*const WSDXML_TYPE,
                dwTypesCount: u32,
                bLayerNumber: u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDXMLContext,
                pTypes: [*]const ?*const WSDXML_TYPE,
                dwTypesCount: u32,
                bLayerNumber: u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDXMLContext_AddNamespace(self: *const T, pszUri: ?[*:0]const u16, pszSuggestedPrefix: ?[*:0]const u16, ppNamespace: ?*?*WSDXML_NAMESPACE) HRESULT {
                return @as(*const IWSDXMLContext.VTable, @ptrCast(self.vtable)).AddNamespace(@as(*const IWSDXMLContext, @ptrCast(self)), pszUri, pszSuggestedPrefix, ppNamespace);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDXMLContext_AddNameToNamespace(self: *const T, pszUri: ?[*:0]const u16, pszName: ?[*:0]const u16, ppName: ?*?*WSDXML_NAME) HRESULT {
                return @as(*const IWSDXMLContext.VTable, @ptrCast(self.vtable)).AddNameToNamespace(@as(*const IWSDXMLContext, @ptrCast(self)), pszUri, pszName, ppName);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDXMLContext_SetNamespaces(self: *const T, pNamespaces: [*]const ?*const WSDXML_NAMESPACE, wNamespacesCount: u16, bLayerNumber: u8) HRESULT {
                return @as(*const IWSDXMLContext.VTable, @ptrCast(self.vtable)).SetNamespaces(@as(*const IWSDXMLContext, @ptrCast(self)), pNamespaces, wNamespacesCount, bLayerNumber);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDXMLContext_SetTypes(self: *const T, pTypes: [*]const ?*const WSDXML_TYPE, dwTypesCount: u32, bLayerNumber: u8) HRESULT {
                return @as(*const IWSDXMLContext.VTable, @ptrCast(self.vtable)).SetTypes(@as(*const IWSDXMLContext, @ptrCast(self)), pTypes, dwTypesCount, bLayerNumber);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const WSDXML_NAMESPACE = extern struct {
    Uri: ?[*:0]const u16,
    PreferredPrefix: ?[*:0]const u16,
    Names: ?*WSDXML_NAME,
    NamesCount: u16,
    Encoding: u16,
};

pub const WSDXML_NAME = extern struct {
    Space: ?*WSDXML_NAMESPACE,
    LocalName: ?PWSTR,
};

pub const WSDXML_TYPE = extern struct {
    Uri: ?[*:0]const u16,
    Table: ?*const u8,
};

pub const WSDXML_PREFIX_MAPPING = extern struct {
    Refs: u32,
    Next: ?*WSDXML_PREFIX_MAPPING,
    Space: ?*WSDXML_NAMESPACE,
    Prefix: ?PWSTR,
};

pub const WSDXML_ATTRIBUTE = extern struct {
    Element: ?*WSDXML_ELEMENT,
    Next: ?*WSDXML_ATTRIBUTE,
    Name: ?*WSDXML_NAME,
    Value: ?PWSTR,
};

pub const WSDXML_NODE = extern struct {
    Type: i32,
    Parent: ?*WSDXML_ELEMENT,
    Next: ?*WSDXML_NODE,
};

pub const WSDXML_ELEMENT = extern struct {
    Node: WSDXML_NODE,
    Name: ?*WSDXML_NAME,
    FirstAttribute: ?*WSDXML_ATTRIBUTE,
    FirstChild: ?*WSDXML_NODE,
    PrefixMappings: ?*WSDXML_PREFIX_MAPPING,
};

pub const WSDXML_TEXT = extern struct {
    Node: WSDXML_NODE,
    Text: ?PWSTR,
};

pub const WSDXML_ELEMENT_LIST = extern struct {
    Next: ?*WSDXML_ELEMENT_LIST,
    Element: ?*WSDXML_ELEMENT,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const WSD_STUB_FUNCTION = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

pub const DeviceDiscoveryMechanism = enum(i32) {
    MulticastDiscovery = 0,
    DirectedDiscovery = 1,
    SecureDirectedDiscovery = 2,
};
pub const MulticastDiscovery = DeviceDiscoveryMechanism.MulticastDiscovery;
pub const DirectedDiscovery = DeviceDiscoveryMechanism.DirectedDiscovery;
pub const SecureDirectedDiscovery = DeviceDiscoveryMechanism.SecureDirectedDiscovery;

pub const WSD_PROTOCOL_TYPE = enum(i32) {
    NONE = 0,
    UDP = 1,
    HTTP = 2,
    HTTPS = 4,
    ALL = 255,
};
pub const WSD_PT_NONE = WSD_PROTOCOL_TYPE.NONE;
pub const WSD_PT_UDP = WSD_PROTOCOL_TYPE.UDP;
pub const WSD_PT_HTTP = WSD_PROTOCOL_TYPE.HTTP;
pub const WSD_PT_HTTPS = WSD_PROTOCOL_TYPE.HTTPS;
pub const WSD_PT_ALL = WSD_PROTOCOL_TYPE.ALL;

pub const WSD_OPERATION = extern struct {
    RequestType: ?*WSDXML_TYPE,
    ResponseType: ?*WSDXML_TYPE,
    RequestStubFunction: ?WSD_STUB_FUNCTION,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PWSD_SOAP_MESSAGE_HANDLER = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

pub const WSD_HANDLER_CONTEXT = extern struct {
    Handler: ?PWSD_SOAP_MESSAGE_HANDLER,
    PVoid: ?*anyopaque,
    Unknown: ?*IUnknown,
};

pub const WSDEventType = enum(i32) {
    NONE = 0,
    INCOMING_MESSAGE = 1,
    INCOMING_FAULT = 2,
    TRANSMISSION_FAILURE = 3,
    RESPONSE_TIMEOUT = 4,
};
pub const WSDET_NONE = WSDEventType.NONE;
pub const WSDET_INCOMING_MESSAGE = WSDEventType.INCOMING_MESSAGE;
pub const WSDET_INCOMING_FAULT = WSDEventType.INCOMING_FAULT;
pub const WSDET_TRANSMISSION_FAILURE = WSDEventType.TRANSMISSION_FAILURE;
pub const WSDET_RESPONSE_TIMEOUT = WSDEventType.RESPONSE_TIMEOUT;

pub const WSD_SYNCHRONOUS_RESPONSE_CONTEXT = extern struct {
    hr: HRESULT,
    eventHandle: ?HANDLE,
    messageParameters: ?*IWSDMessageParameters,
    results: ?*anyopaque,
};

pub const WSD_PORT_TYPE = extern struct {
    EncodedName: u32,
    OperationCount: u32,
    Operations: ?*WSD_OPERATION,
    ProtocolType: WSD_PROTOCOL_TYPE,
};

pub const WSD_RELATIONSHIP_METADATA = extern struct {
    Type: ?[*:0]const u16,
    Data: ?*WSD_HOST_METADATA,
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_SERVICE_METADATA_LIST = extern struct {
    Next: ?*WSD_SERVICE_METADATA_LIST,
    Element: ?*WSD_SERVICE_METADATA,
};

pub const WSD_HOST_METADATA = extern struct {
    Host: ?*WSD_SERVICE_METADATA,
    Hosted: ?*WSD_SERVICE_METADATA_LIST,
};

pub const WSD_ENDPOINT_REFERENCE_LIST = extern struct {
    Next: ?*WSD_ENDPOINT_REFERENCE_LIST,
    Element: ?*WSD_ENDPOINT_REFERENCE,
};

pub const WSD_SERVICE_METADATA = extern struct {
    EndpointReference: ?*WSD_ENDPOINT_REFERENCE_LIST,
    Types: ?*WSD_NAME_LIST,
    ServiceId: ?[*:0]const u16,
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_THIS_DEVICE_METADATA = extern struct {
    FriendlyName: ?*WSD_LOCALIZED_STRING_LIST,
    FirmwareVersion: ?[*:0]const u16,
    SerialNumber: ?[*:0]const u16,
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_THIS_MODEL_METADATA = extern struct {
    Manufacturer: ?*WSD_LOCALIZED_STRING_LIST,
    ManufacturerUrl: ?[*:0]const u16,
    ModelName: ?*WSD_LOCALIZED_STRING_LIST,
    ModelNumber: ?[*:0]const u16,
    ModelUrl: ?[*:0]const u16,
    PresentationUrl: ?[*:0]const u16,
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_LOCALIZED_STRING_LIST = extern struct {
    Next: ?*WSD_LOCALIZED_STRING_LIST,
    Element: ?*WSD_LOCALIZED_STRING,
};

pub const WSD_SOAP_FAULT_REASON = extern struct {
    Text: ?*WSD_LOCALIZED_STRING_LIST,
};

pub const WSD_SOAP_FAULT_SUBCODE = extern struct {
    Value: ?*WSDXML_NAME,
    Subcode: ?*WSD_SOAP_FAULT_SUBCODE,
};

pub const WSD_SOAP_FAULT_CODE = extern struct {
    Value: ?*WSDXML_NAME,
    Subcode: ?*WSD_SOAP_FAULT_SUBCODE,
};

pub const WSD_SOAP_FAULT = extern struct {
    Code: ?*WSD_SOAP_FAULT_CODE,
    Reason: ?*WSD_SOAP_FAULT_REASON,
    Node: ?[*:0]const u16,
    Role: ?[*:0]const u16,
    Detail: ?*WSDXML_ELEMENT,
};

pub const WSD_APP_SEQUENCE = extern struct {
    InstanceId: u64,
    SequenceId: ?[*:0]const u16,
    MessageNumber: u64,
};

pub const WSD_HEADER_RELATESTO = extern struct {
    RelationshipType: ?*WSDXML_NAME,
    MessageID: ?[*:0]const u16,
};

pub const WSD_SOAP_HEADER = extern struct {
    To: ?[*:0]const u16,
    Action: ?[*:0]const u16,
    MessageID: ?[*:0]const u16,
    RelatesTo: WSD_HEADER_RELATESTO,
    ReplyTo: ?*WSD_ENDPOINT_REFERENCE,
    From: ?*WSD_ENDPOINT_REFERENCE,
    FaultTo: ?*WSD_ENDPOINT_REFERENCE,
    AppSequence: ?*WSD_APP_SEQUENCE,
    AnyHeaders: ?*WSDXML_ELEMENT,
};

pub const WSD_SOAP_MESSAGE = extern struct {
    Header: WSD_SOAP_HEADER,
    Body: ?*anyopaque,
    BodyType: ?*WSDXML_TYPE,
};

pub const WSD_RESOLVE_MATCHES = extern struct {
    ResolveMatch: ?*WSD_RESOLVE_MATCH,
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_RESOLVE_MATCH = extern struct {
    EndpointReference: ?*WSD_ENDPOINT_REFERENCE,
    Types: ?*WSD_NAME_LIST,
    Scopes: ?*WSD_SCOPES,
    XAddrs: ?*WSD_URI_LIST,
    MetadataVersion: u64,
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_RESOLVE = extern struct {
    EndpointReference: ?*WSD_ENDPOINT_REFERENCE,
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_PROBE_MATCH = extern struct {
    EndpointReference: ?*WSD_ENDPOINT_REFERENCE,
    Types: ?*WSD_NAME_LIST,
    Scopes: ?*WSD_SCOPES,
    XAddrs: ?*WSD_URI_LIST,
    MetadataVersion: u64,
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_PROBE_MATCH_LIST = extern struct {
    Next: ?*WSD_PROBE_MATCH_LIST,
    Element: ?*WSD_PROBE_MATCH,
};

pub const WSD_PROBE_MATCHES = extern struct {
    ProbeMatch: ?*WSD_PROBE_MATCH_LIST,
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_PROBE = extern struct {
    Types: ?*WSD_NAME_LIST,
    Scopes: ?*WSD_SCOPES,
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_BYE = extern struct {
    EndpointReference: ?*WSD_ENDPOINT_REFERENCE,
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_SCOPES = extern struct {
    MatchBy: ?[*:0]const u16,
    Scopes: ?*WSD_URI_LIST,
};

pub const WSD_NAME_LIST = extern struct {
    Next: ?*WSD_NAME_LIST,
    Element: ?*WSDXML_NAME,
};

pub const WSD_HELLO = extern struct {
    EndpointReference: ?*WSD_ENDPOINT_REFERENCE,
    Types: ?*WSD_NAME_LIST,
    Scopes: ?*WSD_SCOPES,
    XAddrs: ?*WSD_URI_LIST,
    MetadataVersion: u64,
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_REFERENCE_PARAMETERS = extern struct {
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_REFERENCE_PROPERTIES = extern struct {
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_ENDPOINT_REFERENCE = extern struct {
    Address: ?[*:0]const u16,
    ReferenceProperties: WSD_REFERENCE_PROPERTIES,
    ReferenceParameters: WSD_REFERENCE_PARAMETERS,
    PortType: ?*WSDXML_NAME,
    ServiceName: ?*WSDXML_NAME,
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_METADATA_SECTION = extern struct {
    Dialect: ?[*:0]const u16,
    Identifier: ?[*:0]const u16,
    Data: ?*anyopaque,
    MetadataReference: ?*WSD_ENDPOINT_REFERENCE,
    Location: ?[*:0]const u16,
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_METADATA_SECTION_LIST = extern struct {
    Next: ?*WSD_METADATA_SECTION_LIST,
    Element: ?*WSD_METADATA_SECTION,
};

pub const WSD_URI_LIST = extern struct {
    Next: ?*WSD_URI_LIST,
    Element: ?[*:0]const u16,
};

pub const WSD_EVENTING_FILTER_ACTION = extern struct {
    Actions: ?*WSD_URI_LIST,
};

pub const WSD_EVENTING_FILTER = extern struct {
    Dialect: ?[*:0]const u16,
    FilterAction: ?*WSD_EVENTING_FILTER_ACTION,
    Data: ?*anyopaque,
};

pub const WSD_EVENTING_EXPIRES = extern struct {
    Duration: ?*WSD_DURATION,
    DateTime: ?*WSD_DATETIME,
};

pub const WSD_EVENTING_DELIVERY_MODE_PUSH = extern struct {
    NotifyTo: ?*WSD_ENDPOINT_REFERENCE,
};

pub const WSD_EVENTING_DELIVERY_MODE = extern struct {
    Mode: ?[*:0]const u16,
    Push: ?*WSD_EVENTING_DELIVERY_MODE_PUSH,
    Data: ?*anyopaque,
};

pub const WSD_LOCALIZED_STRING = extern struct {
    lang: ?[*:0]const u16,
    String: ?[*:0]const u16,
};

pub const RESPONSEBODY_GetMetadata = extern struct {
    Metadata: ?*WSD_METADATA_SECTION_LIST,
};

pub const REQUESTBODY_Subscribe = extern struct {
    EndTo: ?*WSD_ENDPOINT_REFERENCE,
    Delivery: ?*WSD_EVENTING_DELIVERY_MODE,
    Expires: ?*WSD_EVENTING_EXPIRES,
    Filter: ?*WSD_EVENTING_FILTER,
    Any: ?*WSDXML_ELEMENT,
};

pub const RESPONSEBODY_Subscribe = extern struct {
    SubscriptionManager: ?*WSD_ENDPOINT_REFERENCE,
    expires: ?*WSD_EVENTING_EXPIRES,
    any: ?*WSDXML_ELEMENT,
};

pub const REQUESTBODY_Renew = extern struct {
    Expires: ?*WSD_EVENTING_EXPIRES,
    Any: ?*WSDXML_ELEMENT,
};

pub const RESPONSEBODY_Renew = extern struct {
    expires: ?*WSD_EVENTING_EXPIRES,
    any: ?*WSDXML_ELEMENT,
};

pub const REQUESTBODY_GetStatus = extern struct {
    Any: ?*WSDXML_ELEMENT,
};

pub const RESPONSEBODY_GetStatus = extern struct {
    expires: ?*WSD_EVENTING_EXPIRES,
    any: ?*WSDXML_ELEMENT,
};

pub const REQUESTBODY_Unsubscribe = extern struct {
    any: ?*WSDXML_ELEMENT,
};

pub const RESPONSEBODY_SubscriptionEnd = extern struct {
    SubscriptionManager: ?*WSD_ENDPOINT_REFERENCE,
    Status: ?[*:0]const u16,
    Reason: ?*WSD_LOCALIZED_STRING,
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_UNKNOWN_LOOKUP = extern struct {
    Any: ?*WSDXML_ELEMENT,
};

pub const WSD_EVENT = extern struct {
    Hr: HRESULT,
    EventType: u32,
    DispatchTag: ?PWSTR,
    HandlerContext: WSD_HANDLER_CONTEXT,
    Soap: ?*WSD_SOAP_MESSAGE,
    Operation: ?*WSD_OPERATION,
    MessageParameters: ?*IWSDMessageParameters,
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDiscoveryProvider_Value = Guid.initString("8ffc8e55-f0eb-480f-88b7-b435dd281d45");
pub const IID_IWSDiscoveryProvider = &IID_IWSDiscoveryProvider_Value;
pub const IWSDiscoveryProvider = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetAddressFamily: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryProvider,
                dwAddressFamily: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryProvider,
                dwAddressFamily: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Attach: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryProvider,
                pSink: ?*IWSDiscoveryProviderNotify,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryProvider,
                pSink: ?*IWSDiscoveryProviderNotify,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Detach: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryProvider,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryProvider,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SearchById: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryProvider,
                pszId: ?[*:0]const u16,
                pszTag: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryProvider,
                pszId: ?[*:0]const u16,
                pszTag: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SearchByAddress: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryProvider,
                pszAddress: ?[*:0]const u16,
                pszTag: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryProvider,
                pszAddress: ?[*:0]const u16,
                pszTag: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SearchByType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryProvider,
                pTypesList: ?*const WSD_NAME_LIST,
                pScopesList: ?*const WSD_URI_LIST,
                pszMatchBy: ?[*:0]const u16,
                pszTag: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryProvider,
                pTypesList: ?*const WSD_NAME_LIST,
                pScopesList: ?*const WSD_URI_LIST,
                pszMatchBy: ?[*:0]const u16,
                pszTag: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetXMLContext: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryProvider,
                ppContext: ?*?*IWSDXMLContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryProvider,
                ppContext: ?*?*IWSDXMLContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryProvider_SetAddressFamily(self: *const T, dwAddressFamily: u32) HRESULT {
                return @as(*const IWSDiscoveryProvider.VTable, @ptrCast(self.vtable)).SetAddressFamily(@as(*const IWSDiscoveryProvider, @ptrCast(self)), dwAddressFamily);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryProvider_Attach(self: *const T, pSink: ?*IWSDiscoveryProviderNotify) HRESULT {
                return @as(*const IWSDiscoveryProvider.VTable, @ptrCast(self.vtable)).Attach(@as(*const IWSDiscoveryProvider, @ptrCast(self)), pSink);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryProvider_Detach(self: *const T) HRESULT {
                return @as(*const IWSDiscoveryProvider.VTable, @ptrCast(self.vtable)).Detach(@as(*const IWSDiscoveryProvider, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryProvider_SearchById(self: *const T, pszId: ?[*:0]const u16, pszTag: ?[*:0]const u16) HRESULT {
                return @as(*const IWSDiscoveryProvider.VTable, @ptrCast(self.vtable)).SearchById(@as(*const IWSDiscoveryProvider, @ptrCast(self)), pszId, pszTag);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryProvider_SearchByAddress(self: *const T, pszAddress: ?[*:0]const u16, pszTag: ?[*:0]const u16) HRESULT {
                return @as(*const IWSDiscoveryProvider.VTable, @ptrCast(self.vtable)).SearchByAddress(@as(*const IWSDiscoveryProvider, @ptrCast(self)), pszAddress, pszTag);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryProvider_SearchByType(self: *const T, pTypesList: ?*const WSD_NAME_LIST, pScopesList: ?*const WSD_URI_LIST, pszMatchBy: ?[*:0]const u16, pszTag: ?[*:0]const u16) HRESULT {
                return @as(*const IWSDiscoveryProvider.VTable, @ptrCast(self.vtable)).SearchByType(@as(*const IWSDiscoveryProvider, @ptrCast(self)), pTypesList, pScopesList, pszMatchBy, pszTag);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryProvider_GetXMLContext(self: *const T, ppContext: ?*?*IWSDXMLContext) HRESULT {
                return @as(*const IWSDiscoveryProvider.VTable, @ptrCast(self.vtable)).GetXMLContext(@as(*const IWSDiscoveryProvider, @ptrCast(self)), ppContext);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDiscoveryProviderNotify_Value = Guid.initString("73ee3ced-b6e6-4329-a546-3e8ad46563d2");
pub const IID_IWSDiscoveryProviderNotify = &IID_IWSDiscoveryProviderNotify_Value;
pub const IWSDiscoveryProviderNotify = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Add: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryProviderNotify,
                pService: ?*IWSDiscoveredService,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryProviderNotify,
                pService: ?*IWSDiscoveredService,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Remove: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryProviderNotify,
                pService: ?*IWSDiscoveredService,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryProviderNotify,
                pService: ?*IWSDiscoveredService,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SearchFailed: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryProviderNotify,
                hr: HRESULT,
                pszTag: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryProviderNotify,
                hr: HRESULT,
                pszTag: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SearchComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryProviderNotify,
                pszTag: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryProviderNotify,
                pszTag: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryProviderNotify_Add(self: *const T, pService: ?*IWSDiscoveredService) HRESULT {
                return @as(*const IWSDiscoveryProviderNotify.VTable, @ptrCast(self.vtable)).Add(@as(*const IWSDiscoveryProviderNotify, @ptrCast(self)), pService);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryProviderNotify_Remove(self: *const T, pService: ?*IWSDiscoveredService) HRESULT {
                return @as(*const IWSDiscoveryProviderNotify.VTable, @ptrCast(self.vtable)).Remove(@as(*const IWSDiscoveryProviderNotify, @ptrCast(self)), pService);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryProviderNotify_SearchFailed(self: *const T, hr: HRESULT, pszTag: ?[*:0]const u16) HRESULT {
                return @as(*const IWSDiscoveryProviderNotify.VTable, @ptrCast(self.vtable)).SearchFailed(@as(*const IWSDiscoveryProviderNotify, @ptrCast(self)), hr, pszTag);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryProviderNotify_SearchComplete(self: *const T, pszTag: ?[*:0]const u16) HRESULT {
                return @as(*const IWSDiscoveryProviderNotify.VTable, @ptrCast(self.vtable)).SearchComplete(@as(*const IWSDiscoveryProviderNotify, @ptrCast(self)), pszTag);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDiscoveredService_Value = Guid.initString("4bad8a3b-b374-4420-9632-aac945b374aa");
pub const IID_IWSDiscoveredService = &IID_IWSDiscoveredService_Value;
pub const IWSDiscoveredService = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetEndpointReference: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveredService,
                ppEndpointReference: ?*?*WSD_ENDPOINT_REFERENCE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveredService,
                ppEndpointReference: ?*?*WSD_ENDPOINT_REFERENCE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetTypes: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveredService,
                ppTypesList: ?*?*WSD_NAME_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveredService,
                ppTypesList: ?*?*WSD_NAME_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetScopes: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveredService,
                ppScopesList: ?*?*WSD_URI_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveredService,
                ppScopesList: ?*?*WSD_URI_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetXAddrs: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveredService,
                ppXAddrsList: ?*?*WSD_URI_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveredService,
                ppXAddrsList: ?*?*WSD_URI_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetMetadataVersion: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveredService,
                pullMetadataVersion: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveredService,
                pullMetadataVersion: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetExtendedDiscoXML: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveredService,
                ppHeaderAny: ?*?*WSDXML_ELEMENT,
                ppBodyAny: ?*?*WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveredService,
                ppHeaderAny: ?*?*WSDXML_ELEMENT,
                ppBodyAny: ?*?*WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetProbeResolveTag: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveredService,
                ppszTag: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveredService,
                ppszTag: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetRemoteTransportAddress: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveredService,
                ppszRemoteTransportAddress: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveredService,
                ppszRemoteTransportAddress: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetLocalTransportAddress: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveredService,
                ppszLocalTransportAddress: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveredService,
                ppszLocalTransportAddress: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetLocalInterfaceGUID: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveredService,
                pGuid: ?*Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveredService,
                pGuid: ?*Guid,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInstanceId: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveredService,
                pullInstanceId: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveredService,
                pullInstanceId: ?*u64,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveredService_GetEndpointReference(self: *const T, ppEndpointReference: ?*?*WSD_ENDPOINT_REFERENCE) HRESULT {
                return @as(*const IWSDiscoveredService.VTable, @ptrCast(self.vtable)).GetEndpointReference(@as(*const IWSDiscoveredService, @ptrCast(self)), ppEndpointReference);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveredService_GetTypes(self: *const T, ppTypesList: ?*?*WSD_NAME_LIST) HRESULT {
                return @as(*const IWSDiscoveredService.VTable, @ptrCast(self.vtable)).GetTypes(@as(*const IWSDiscoveredService, @ptrCast(self)), ppTypesList);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveredService_GetScopes(self: *const T, ppScopesList: ?*?*WSD_URI_LIST) HRESULT {
                return @as(*const IWSDiscoveredService.VTable, @ptrCast(self.vtable)).GetScopes(@as(*const IWSDiscoveredService, @ptrCast(self)), ppScopesList);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveredService_GetXAddrs(self: *const T, ppXAddrsList: ?*?*WSD_URI_LIST) HRESULT {
                return @as(*const IWSDiscoveredService.VTable, @ptrCast(self.vtable)).GetXAddrs(@as(*const IWSDiscoveredService, @ptrCast(self)), ppXAddrsList);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveredService_GetMetadataVersion(self: *const T, pullMetadataVersion: ?*u64) HRESULT {
                return @as(*const IWSDiscoveredService.VTable, @ptrCast(self.vtable)).GetMetadataVersion(@as(*const IWSDiscoveredService, @ptrCast(self)), pullMetadataVersion);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveredService_GetExtendedDiscoXML(self: *const T, ppHeaderAny: ?*?*WSDXML_ELEMENT, ppBodyAny: ?*?*WSDXML_ELEMENT) HRESULT {
                return @as(*const IWSDiscoveredService.VTable, @ptrCast(self.vtable)).GetExtendedDiscoXML(@as(*const IWSDiscoveredService, @ptrCast(self)), ppHeaderAny, ppBodyAny);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveredService_GetProbeResolveTag(self: *const T, ppszTag: ?*?PWSTR) HRESULT {
                return @as(*const IWSDiscoveredService.VTable, @ptrCast(self.vtable)).GetProbeResolveTag(@as(*const IWSDiscoveredService, @ptrCast(self)), ppszTag);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveredService_GetRemoteTransportAddress(self: *const T, ppszRemoteTransportAddress: ?*?PWSTR) HRESULT {
                return @as(*const IWSDiscoveredService.VTable, @ptrCast(self.vtable)).GetRemoteTransportAddress(@as(*const IWSDiscoveredService, @ptrCast(self)), ppszRemoteTransportAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveredService_GetLocalTransportAddress(self: *const T, ppszLocalTransportAddress: ?*?PWSTR) HRESULT {
                return @as(*const IWSDiscoveredService.VTable, @ptrCast(self.vtable)).GetLocalTransportAddress(@as(*const IWSDiscoveredService, @ptrCast(self)), ppszLocalTransportAddress);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveredService_GetLocalInterfaceGUID(self: *const T, pGuid: ?*Guid) HRESULT {
                return @as(*const IWSDiscoveredService.VTable, @ptrCast(self.vtable)).GetLocalInterfaceGUID(@as(*const IWSDiscoveredService, @ptrCast(self)), pGuid);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveredService_GetInstanceId(self: *const T, pullInstanceId: ?*u64) HRESULT {
                return @as(*const IWSDiscoveredService.VTable, @ptrCast(self.vtable)).GetInstanceId(@as(*const IWSDiscoveredService, @ptrCast(self)), pullInstanceId);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDiscoveryPublisher_Value = Guid.initString("ae01e1a8-3ff9-4148-8116-057cc616fe13");
pub const IID_IWSDiscoveryPublisher = &IID_IWSDiscoveryPublisher_Value;
pub const IWSDiscoveryPublisher = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetAddressFamily: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryPublisher,
                dwAddressFamily: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryPublisher,
                dwAddressFamily: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RegisterNotificationSink: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryPublisher,
                pSink: ?*IWSDiscoveryPublisherNotify,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryPublisher,
                pSink: ?*IWSDiscoveryPublisherNotify,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        UnRegisterNotificationSink: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryPublisher,
                pSink: ?*IWSDiscoveryPublisherNotify,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryPublisher,
                pSink: ?*IWSDiscoveryPublisherNotify,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Publish: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryPublisher,
                pszId: ?[*:0]const u16,
                ullMetadataVersion: u64,
                ullInstanceId: u64,
                ullMessageNumber: u64,
                pszSessionId: ?[*:0]const u16,
                pTypesList: ?*const WSD_NAME_LIST,
                pScopesList: ?*const WSD_URI_LIST,
                pXAddrsList: ?*const WSD_URI_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryPublisher,
                pszId: ?[*:0]const u16,
                ullMetadataVersion: u64,
                ullInstanceId: u64,
                ullMessageNumber: u64,
                pszSessionId: ?[*:0]const u16,
                pTypesList: ?*const WSD_NAME_LIST,
                pScopesList: ?*const WSD_URI_LIST,
                pXAddrsList: ?*const WSD_URI_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        UnPublish: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryPublisher,
                pszId: ?[*:0]const u16,
                ullInstanceId: u64,
                ullMessageNumber: u64,
                pszSessionId: ?[*:0]const u16,
                pAny: ?*const WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryPublisher,
                pszId: ?[*:0]const u16,
                ullInstanceId: u64,
                ullMessageNumber: u64,
                pszSessionId: ?[*:0]const u16,
                pAny: ?*const WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        MatchProbe: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryPublisher,
                pProbeMessage: ?*const WSD_SOAP_MESSAGE,
                pMessageParameters: ?*IWSDMessageParameters,
                pszId: ?[*:0]const u16,
                ullMetadataVersion: u64,
                ullInstanceId: u64,
                ullMessageNumber: u64,
                pszSessionId: ?[*:0]const u16,
                pTypesList: ?*const WSD_NAME_LIST,
                pScopesList: ?*const WSD_URI_LIST,
                pXAddrsList: ?*const WSD_URI_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryPublisher,
                pProbeMessage: ?*const WSD_SOAP_MESSAGE,
                pMessageParameters: ?*IWSDMessageParameters,
                pszId: ?[*:0]const u16,
                ullMetadataVersion: u64,
                ullInstanceId: u64,
                ullMessageNumber: u64,
                pszSessionId: ?[*:0]const u16,
                pTypesList: ?*const WSD_NAME_LIST,
                pScopesList: ?*const WSD_URI_LIST,
                pXAddrsList: ?*const WSD_URI_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        MatchResolve: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryPublisher,
                pResolveMessage: ?*const WSD_SOAP_MESSAGE,
                pMessageParameters: ?*IWSDMessageParameters,
                pszId: ?[*:0]const u16,
                ullMetadataVersion: u64,
                ullInstanceId: u64,
                ullMessageNumber: u64,
                pszSessionId: ?[*:0]const u16,
                pTypesList: ?*const WSD_NAME_LIST,
                pScopesList: ?*const WSD_URI_LIST,
                pXAddrsList: ?*const WSD_URI_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryPublisher,
                pResolveMessage: ?*const WSD_SOAP_MESSAGE,
                pMessageParameters: ?*IWSDMessageParameters,
                pszId: ?[*:0]const u16,
                ullMetadataVersion: u64,
                ullInstanceId: u64,
                ullMessageNumber: u64,
                pszSessionId: ?[*:0]const u16,
                pTypesList: ?*const WSD_NAME_LIST,
                pScopesList: ?*const WSD_URI_LIST,
                pXAddrsList: ?*const WSD_URI_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        PublishEx: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryPublisher,
                pszId: ?[*:0]const u16,
                ullMetadataVersion: u64,
                ullInstanceId: u64,
                ullMessageNumber: u64,
                pszSessionId: ?[*:0]const u16,
                pTypesList: ?*const WSD_NAME_LIST,
                pScopesList: ?*const WSD_URI_LIST,
                pXAddrsList: ?*const WSD_URI_LIST,
                pHeaderAny: ?*const WSDXML_ELEMENT,
                pReferenceParameterAny: ?*const WSDXML_ELEMENT,
                pPolicyAny: ?*const WSDXML_ELEMENT,
                pEndpointReferenceAny: ?*const WSDXML_ELEMENT,
                pAny: ?*const WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryPublisher,
                pszId: ?[*:0]const u16,
                ullMetadataVersion: u64,
                ullInstanceId: u64,
                ullMessageNumber: u64,
                pszSessionId: ?[*:0]const u16,
                pTypesList: ?*const WSD_NAME_LIST,
                pScopesList: ?*const WSD_URI_LIST,
                pXAddrsList: ?*const WSD_URI_LIST,
                pHeaderAny: ?*const WSDXML_ELEMENT,
                pReferenceParameterAny: ?*const WSDXML_ELEMENT,
                pPolicyAny: ?*const WSDXML_ELEMENT,
                pEndpointReferenceAny: ?*const WSDXML_ELEMENT,
                pAny: ?*const WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        MatchProbeEx: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryPublisher,
                pProbeMessage: ?*const WSD_SOAP_MESSAGE,
                pMessageParameters: ?*IWSDMessageParameters,
                pszId: ?[*:0]const u16,
                ullMetadataVersion: u64,
                ullInstanceId: u64,
                ullMessageNumber: u64,
                pszSessionId: ?[*:0]const u16,
                pTypesList: ?*const WSD_NAME_LIST,
                pScopesList: ?*const WSD_URI_LIST,
                pXAddrsList: ?*const WSD_URI_LIST,
                pHeaderAny: ?*const WSDXML_ELEMENT,
                pReferenceParameterAny: ?*const WSDXML_ELEMENT,
                pPolicyAny: ?*const WSDXML_ELEMENT,
                pEndpointReferenceAny: ?*const WSDXML_ELEMENT,
                pAny: ?*const WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryPublisher,
                pProbeMessage: ?*const WSD_SOAP_MESSAGE,
                pMessageParameters: ?*IWSDMessageParameters,
                pszId: ?[*:0]const u16,
                ullMetadataVersion: u64,
                ullInstanceId: u64,
                ullMessageNumber: u64,
                pszSessionId: ?[*:0]const u16,
                pTypesList: ?*const WSD_NAME_LIST,
                pScopesList: ?*const WSD_URI_LIST,
                pXAddrsList: ?*const WSD_URI_LIST,
                pHeaderAny: ?*const WSDXML_ELEMENT,
                pReferenceParameterAny: ?*const WSDXML_ELEMENT,
                pPolicyAny: ?*const WSDXML_ELEMENT,
                pEndpointReferenceAny: ?*const WSDXML_ELEMENT,
                pAny: ?*const WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        MatchResolveEx: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryPublisher,
                pResolveMessage: ?*const WSD_SOAP_MESSAGE,
                pMessageParameters: ?*IWSDMessageParameters,
                pszId: ?[*:0]const u16,
                ullMetadataVersion: u64,
                ullInstanceId: u64,
                ullMessageNumber: u64,
                pszSessionId: ?[*:0]const u16,
                pTypesList: ?*const WSD_NAME_LIST,
                pScopesList: ?*const WSD_URI_LIST,
                pXAddrsList: ?*const WSD_URI_LIST,
                pHeaderAny: ?*const WSDXML_ELEMENT,
                pReferenceParameterAny: ?*const WSDXML_ELEMENT,
                pPolicyAny: ?*const WSDXML_ELEMENT,
                pEndpointReferenceAny: ?*const WSDXML_ELEMENT,
                pAny: ?*const WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryPublisher,
                pResolveMessage: ?*const WSD_SOAP_MESSAGE,
                pMessageParameters: ?*IWSDMessageParameters,
                pszId: ?[*:0]const u16,
                ullMetadataVersion: u64,
                ullInstanceId: u64,
                ullMessageNumber: u64,
                pszSessionId: ?[*:0]const u16,
                pTypesList: ?*const WSD_NAME_LIST,
                pScopesList: ?*const WSD_URI_LIST,
                pXAddrsList: ?*const WSD_URI_LIST,
                pHeaderAny: ?*const WSDXML_ELEMENT,
                pReferenceParameterAny: ?*const WSDXML_ELEMENT,
                pPolicyAny: ?*const WSDXML_ELEMENT,
                pEndpointReferenceAny: ?*const WSDXML_ELEMENT,
                pAny: ?*const WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RegisterScopeMatchingRule: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryPublisher,
                pScopeMatchingRule: ?*IWSDScopeMatchingRule,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryPublisher,
                pScopeMatchingRule: ?*IWSDScopeMatchingRule,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        UnRegisterScopeMatchingRule: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryPublisher,
                pScopeMatchingRule: ?*IWSDScopeMatchingRule,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryPublisher,
                pScopeMatchingRule: ?*IWSDScopeMatchingRule,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetXMLContext: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryPublisher,
                ppContext: ?*?*IWSDXMLContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryPublisher,
                ppContext: ?*?*IWSDXMLContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryPublisher_SetAddressFamily(self: *const T, dwAddressFamily: u32) HRESULT {
                return @as(*const IWSDiscoveryPublisher.VTable, @ptrCast(self.vtable)).SetAddressFamily(@as(*const IWSDiscoveryPublisher, @ptrCast(self)), dwAddressFamily);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryPublisher_RegisterNotificationSink(self: *const T, pSink: ?*IWSDiscoveryPublisherNotify) HRESULT {
                return @as(*const IWSDiscoveryPublisher.VTable, @ptrCast(self.vtable)).RegisterNotificationSink(@as(*const IWSDiscoveryPublisher, @ptrCast(self)), pSink);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryPublisher_UnRegisterNotificationSink(self: *const T, pSink: ?*IWSDiscoveryPublisherNotify) HRESULT {
                return @as(*const IWSDiscoveryPublisher.VTable, @ptrCast(self.vtable)).UnRegisterNotificationSink(@as(*const IWSDiscoveryPublisher, @ptrCast(self)), pSink);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryPublisher_Publish(self: *const T, pszId: ?[*:0]const u16, ullMetadataVersion: u64, ullInstanceId: u64, ullMessageNumber: u64, pszSessionId: ?[*:0]const u16, pTypesList: ?*const WSD_NAME_LIST, pScopesList: ?*const WSD_URI_LIST, pXAddrsList: ?*const WSD_URI_LIST) HRESULT {
                return @as(*const IWSDiscoveryPublisher.VTable, @ptrCast(self.vtable)).Publish(@as(*const IWSDiscoveryPublisher, @ptrCast(self)), pszId, ullMetadataVersion, ullInstanceId, ullMessageNumber, pszSessionId, pTypesList, pScopesList, pXAddrsList);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryPublisher_UnPublish(self: *const T, pszId: ?[*:0]const u16, ullInstanceId: u64, ullMessageNumber: u64, pszSessionId: ?[*:0]const u16, pAny: ?*const WSDXML_ELEMENT) HRESULT {
                return @as(*const IWSDiscoveryPublisher.VTable, @ptrCast(self.vtable)).UnPublish(@as(*const IWSDiscoveryPublisher, @ptrCast(self)), pszId, ullInstanceId, ullMessageNumber, pszSessionId, pAny);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryPublisher_MatchProbe(self: *const T, pProbeMessage: ?*const WSD_SOAP_MESSAGE, pMessageParameters: ?*IWSDMessageParameters, pszId: ?[*:0]const u16, ullMetadataVersion: u64, ullInstanceId: u64, ullMessageNumber: u64, pszSessionId: ?[*:0]const u16, pTypesList: ?*const WSD_NAME_LIST, pScopesList: ?*const WSD_URI_LIST, pXAddrsList: ?*const WSD_URI_LIST) HRESULT {
                return @as(*const IWSDiscoveryPublisher.VTable, @ptrCast(self.vtable)).MatchProbe(@as(*const IWSDiscoveryPublisher, @ptrCast(self)), pProbeMessage, pMessageParameters, pszId, ullMetadataVersion, ullInstanceId, ullMessageNumber, pszSessionId, pTypesList, pScopesList, pXAddrsList);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryPublisher_MatchResolve(self: *const T, pResolveMessage: ?*const WSD_SOAP_MESSAGE, pMessageParameters: ?*IWSDMessageParameters, pszId: ?[*:0]const u16, ullMetadataVersion: u64, ullInstanceId: u64, ullMessageNumber: u64, pszSessionId: ?[*:0]const u16, pTypesList: ?*const WSD_NAME_LIST, pScopesList: ?*const WSD_URI_LIST, pXAddrsList: ?*const WSD_URI_LIST) HRESULT {
                return @as(*const IWSDiscoveryPublisher.VTable, @ptrCast(self.vtable)).MatchResolve(@as(*const IWSDiscoveryPublisher, @ptrCast(self)), pResolveMessage, pMessageParameters, pszId, ullMetadataVersion, ullInstanceId, ullMessageNumber, pszSessionId, pTypesList, pScopesList, pXAddrsList);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryPublisher_PublishEx(self: *const T, pszId: ?[*:0]const u16, ullMetadataVersion: u64, ullInstanceId: u64, ullMessageNumber: u64, pszSessionId: ?[*:0]const u16, pTypesList: ?*const WSD_NAME_LIST, pScopesList: ?*const WSD_URI_LIST, pXAddrsList: ?*const WSD_URI_LIST, pHeaderAny: ?*const WSDXML_ELEMENT, pReferenceParameterAny: ?*const WSDXML_ELEMENT, pPolicyAny: ?*const WSDXML_ELEMENT, pEndpointReferenceAny: ?*const WSDXML_ELEMENT, pAny: ?*const WSDXML_ELEMENT) HRESULT {
                return @as(*const IWSDiscoveryPublisher.VTable, @ptrCast(self.vtable)).PublishEx(@as(*const IWSDiscoveryPublisher, @ptrCast(self)), pszId, ullMetadataVersion, ullInstanceId, ullMessageNumber, pszSessionId, pTypesList, pScopesList, pXAddrsList, pHeaderAny, pReferenceParameterAny, pPolicyAny, pEndpointReferenceAny, pAny);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryPublisher_MatchProbeEx(self: *const T, pProbeMessage: ?*const WSD_SOAP_MESSAGE, pMessageParameters: ?*IWSDMessageParameters, pszId: ?[*:0]const u16, ullMetadataVersion: u64, ullInstanceId: u64, ullMessageNumber: u64, pszSessionId: ?[*:0]const u16, pTypesList: ?*const WSD_NAME_LIST, pScopesList: ?*const WSD_URI_LIST, pXAddrsList: ?*const WSD_URI_LIST, pHeaderAny: ?*const WSDXML_ELEMENT, pReferenceParameterAny: ?*const WSDXML_ELEMENT, pPolicyAny: ?*const WSDXML_ELEMENT, pEndpointReferenceAny: ?*const WSDXML_ELEMENT, pAny: ?*const WSDXML_ELEMENT) HRESULT {
                return @as(*const IWSDiscoveryPublisher.VTable, @ptrCast(self.vtable)).MatchProbeEx(@as(*const IWSDiscoveryPublisher, @ptrCast(self)), pProbeMessage, pMessageParameters, pszId, ullMetadataVersion, ullInstanceId, ullMessageNumber, pszSessionId, pTypesList, pScopesList, pXAddrsList, pHeaderAny, pReferenceParameterAny, pPolicyAny, pEndpointReferenceAny, pAny);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryPublisher_MatchResolveEx(self: *const T, pResolveMessage: ?*const WSD_SOAP_MESSAGE, pMessageParameters: ?*IWSDMessageParameters, pszId: ?[*:0]const u16, ullMetadataVersion: u64, ullInstanceId: u64, ullMessageNumber: u64, pszSessionId: ?[*:0]const u16, pTypesList: ?*const WSD_NAME_LIST, pScopesList: ?*const WSD_URI_LIST, pXAddrsList: ?*const WSD_URI_LIST, pHeaderAny: ?*const WSDXML_ELEMENT, pReferenceParameterAny: ?*const WSDXML_ELEMENT, pPolicyAny: ?*const WSDXML_ELEMENT, pEndpointReferenceAny: ?*const WSDXML_ELEMENT, pAny: ?*const WSDXML_ELEMENT) HRESULT {
                return @as(*const IWSDiscoveryPublisher.VTable, @ptrCast(self.vtable)).MatchResolveEx(@as(*const IWSDiscoveryPublisher, @ptrCast(self)), pResolveMessage, pMessageParameters, pszId, ullMetadataVersion, ullInstanceId, ullMessageNumber, pszSessionId, pTypesList, pScopesList, pXAddrsList, pHeaderAny, pReferenceParameterAny, pPolicyAny, pEndpointReferenceAny, pAny);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryPublisher_RegisterScopeMatchingRule(self: *const T, pScopeMatchingRule: ?*IWSDScopeMatchingRule) HRESULT {
                return @as(*const IWSDiscoveryPublisher.VTable, @ptrCast(self.vtable)).RegisterScopeMatchingRule(@as(*const IWSDiscoveryPublisher, @ptrCast(self)), pScopeMatchingRule);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryPublisher_UnRegisterScopeMatchingRule(self: *const T, pScopeMatchingRule: ?*IWSDScopeMatchingRule) HRESULT {
                return @as(*const IWSDiscoveryPublisher.VTable, @ptrCast(self.vtable)).UnRegisterScopeMatchingRule(@as(*const IWSDiscoveryPublisher, @ptrCast(self)), pScopeMatchingRule);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryPublisher_GetXMLContext(self: *const T, ppContext: ?*?*IWSDXMLContext) HRESULT {
                return @as(*const IWSDiscoveryPublisher.VTable, @ptrCast(self.vtable)).GetXMLContext(@as(*const IWSDiscoveryPublisher, @ptrCast(self)), ppContext);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDiscoveryPublisherNotify_Value = Guid.initString("e67651b0-337a-4b3c-9758-733388568251");
pub const IID_IWSDiscoveryPublisherNotify = &IID_IWSDiscoveryPublisherNotify_Value;
pub const IWSDiscoveryPublisherNotify = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        ProbeHandler: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryPublisherNotify,
                pSoap: ?*const WSD_SOAP_MESSAGE,
                pMessageParameters: ?*IWSDMessageParameters,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryPublisherNotify,
                pSoap: ?*const WSD_SOAP_MESSAGE,
                pMessageParameters: ?*IWSDMessageParameters,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ResolveHandler: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDiscoveryPublisherNotify,
                pSoap: ?*const WSD_SOAP_MESSAGE,
                pMessageParameters: ?*IWSDMessageParameters,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDiscoveryPublisherNotify,
                pSoap: ?*const WSD_SOAP_MESSAGE,
                pMessageParameters: ?*IWSDMessageParameters,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryPublisherNotify_ProbeHandler(self: *const T, pSoap: ?*const WSD_SOAP_MESSAGE, pMessageParameters: ?*IWSDMessageParameters) HRESULT {
                return @as(*const IWSDiscoveryPublisherNotify.VTable, @ptrCast(self.vtable)).ProbeHandler(@as(*const IWSDiscoveryPublisherNotify, @ptrCast(self)), pSoap, pMessageParameters);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDiscoveryPublisherNotify_ResolveHandler(self: *const T, pSoap: ?*const WSD_SOAP_MESSAGE, pMessageParameters: ?*IWSDMessageParameters) HRESULT {
                return @as(*const IWSDiscoveryPublisherNotify.VTable, @ptrCast(self.vtable)).ResolveHandler(@as(*const IWSDiscoveryPublisherNotify, @ptrCast(self)), pSoap, pMessageParameters);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDScopeMatchingRule_Value = Guid.initString("fcafe424-fef5-481a-bd9f-33ce0574256f");
pub const IID_IWSDScopeMatchingRule = &IID_IWSDScopeMatchingRule_Value;
pub const IWSDScopeMatchingRule = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetScopeRule: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDScopeMatchingRule,
                ppszScopeMatchingRule: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDScopeMatchingRule,
                ppszScopeMatchingRule: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        MatchScopes: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDScopeMatchingRule,
                pszScope1: ?[*:0]const u16,
                pszScope2: ?[*:0]const u16,
                pfMatch: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDScopeMatchingRule,
                pszScope1: ?[*:0]const u16,
                pszScope2: ?[*:0]const u16,
                pfMatch: ?*BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDScopeMatchingRule_GetScopeRule(self: *const T, ppszScopeMatchingRule: ?*?PWSTR) HRESULT {
                return @as(*const IWSDScopeMatchingRule.VTable, @ptrCast(self.vtable)).GetScopeRule(@as(*const IWSDScopeMatchingRule, @ptrCast(self)), ppszScopeMatchingRule);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDScopeMatchingRule_MatchScopes(self: *const T, pszScope1: ?[*:0]const u16, pszScope2: ?[*:0]const u16, pfMatch: ?*BOOL) HRESULT {
                return @as(*const IWSDScopeMatchingRule.VTable, @ptrCast(self.vtable)).MatchScopes(@as(*const IWSDScopeMatchingRule, @ptrCast(self)), pszScope1, pszScope2, pfMatch);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDEndpointProxy_Value = Guid.initString("1860d430-b24c-4975-9f90-dbb39baa24ec");
pub const IID_IWSDEndpointProxy = &IID_IWSDEndpointProxy_Value;
pub const IWSDEndpointProxy = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SendOneWayRequest: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDEndpointProxy,
                pBody: ?*const anyopaque,
                pOperation: ?*const WSD_OPERATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDEndpointProxy,
                pBody: ?*const anyopaque,
                pOperation: ?*const WSD_OPERATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SendTwoWayRequest: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDEndpointProxy,
                pBody: ?*const anyopaque,
                pOperation: ?*const WSD_OPERATION,
                pResponseContext: ?*const WSD_SYNCHRONOUS_RESPONSE_CONTEXT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDEndpointProxy,
                pBody: ?*const anyopaque,
                pOperation: ?*const WSD_OPERATION,
                pResponseContext: ?*const WSD_SYNCHRONOUS_RESPONSE_CONTEXT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SendTwoWayRequestAsync: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDEndpointProxy,
                pBody: ?*const anyopaque,
                pOperation: ?*const WSD_OPERATION,
                pAsyncState: ?*IUnknown,
                pCallback: ?*IWSDAsyncCallback,
                pResult: ?*?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDEndpointProxy,
                pBody: ?*const anyopaque,
                pOperation: ?*const WSD_OPERATION,
                pAsyncState: ?*IUnknown,
                pCallback: ?*IWSDAsyncCallback,
                pResult: ?*?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AbortAsyncOperation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDEndpointProxy,
                pAsyncResult: ?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDEndpointProxy,
                pAsyncResult: ?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        ProcessFault: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDEndpointProxy,
                pFault: ?*const WSD_SOAP_FAULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDEndpointProxy,
                pFault: ?*const WSD_SOAP_FAULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetErrorInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDEndpointProxy,
                ppszErrorInfo: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDEndpointProxy,
                ppszErrorInfo: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetFaultInfo: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDEndpointProxy,
                ppFault: ?*?*WSD_SOAP_FAULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDEndpointProxy,
                ppFault: ?*?*WSD_SOAP_FAULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDEndpointProxy_SendOneWayRequest(self: *const T, pBody: ?*const anyopaque, pOperation: ?*const WSD_OPERATION) HRESULT {
                return @as(*const IWSDEndpointProxy.VTable, @ptrCast(self.vtable)).SendOneWayRequest(@as(*const IWSDEndpointProxy, @ptrCast(self)), pBody, pOperation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDEndpointProxy_SendTwoWayRequest(self: *const T, pBody: ?*const anyopaque, pOperation: ?*const WSD_OPERATION, pResponseContext: ?*const WSD_SYNCHRONOUS_RESPONSE_CONTEXT) HRESULT {
                return @as(*const IWSDEndpointProxy.VTable, @ptrCast(self.vtable)).SendTwoWayRequest(@as(*const IWSDEndpointProxy, @ptrCast(self)), pBody, pOperation, pResponseContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDEndpointProxy_SendTwoWayRequestAsync(self: *const T, pBody: ?*const anyopaque, pOperation: ?*const WSD_OPERATION, pAsyncState: ?*IUnknown, pCallback: ?*IWSDAsyncCallback, pResult: ?*?*IWSDAsyncResult) HRESULT {
                return @as(*const IWSDEndpointProxy.VTable, @ptrCast(self.vtable)).SendTwoWayRequestAsync(@as(*const IWSDEndpointProxy, @ptrCast(self)), pBody, pOperation, pAsyncState, pCallback, pResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDEndpointProxy_AbortAsyncOperation(self: *const T, pAsyncResult: ?*IWSDAsyncResult) HRESULT {
                return @as(*const IWSDEndpointProxy.VTable, @ptrCast(self.vtable)).AbortAsyncOperation(@as(*const IWSDEndpointProxy, @ptrCast(self)), pAsyncResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDEndpointProxy_ProcessFault(self: *const T, pFault: ?*const WSD_SOAP_FAULT) HRESULT {
                return @as(*const IWSDEndpointProxy.VTable, @ptrCast(self.vtable)).ProcessFault(@as(*const IWSDEndpointProxy, @ptrCast(self)), pFault);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDEndpointProxy_GetErrorInfo(self: *const T, ppszErrorInfo: ?*?PWSTR) HRESULT {
                return @as(*const IWSDEndpointProxy.VTable, @ptrCast(self.vtable)).GetErrorInfo(@as(*const IWSDEndpointProxy, @ptrCast(self)), ppszErrorInfo);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDEndpointProxy_GetFaultInfo(self: *const T, ppFault: ?*?*WSD_SOAP_FAULT) HRESULT {
                return @as(*const IWSDEndpointProxy.VTable, @ptrCast(self.vtable)).GetFaultInfo(@as(*const IWSDEndpointProxy, @ptrCast(self)), ppFault);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDMetadataExchange_Value = Guid.initString("06996d57-1d67-4928-9307-3d7833fdb846");
pub const IID_IWSDMetadataExchange = &IID_IWSDMetadataExchange_Value;
pub const IWSDMetadataExchange = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetMetadata: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDMetadataExchange,
                MetadataOut: ?*?*WSD_METADATA_SECTION_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDMetadataExchange,
                MetadataOut: ?*?*WSD_METADATA_SECTION_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDMetadataExchange_GetMetadata(self: *const T, MetadataOut: ?*?*WSD_METADATA_SECTION_LIST) HRESULT {
                return @as(*const IWSDMetadataExchange.VTable, @ptrCast(self.vtable)).GetMetadata(@as(*const IWSDMetadataExchange, @ptrCast(self)), MetadataOut);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDServiceProxy_Value = Guid.initString("d4c7fb9c-03ab-4175-9d67-094fafebf487");
pub const IID_IWSDServiceProxy = &IID_IWSDServiceProxy_Value;
pub const IWSDServiceProxy = extern struct {
    pub const VTable = extern struct {
        base: IWSDMetadataExchange.VTable,
        BeginGetMetadata: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxy,
                ppResult: ?*?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxy,
                ppResult: ?*?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EndGetMetadata: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxy,
                pResult: ?*IWSDAsyncResult,
                ppMetadata: ?*?*WSD_METADATA_SECTION_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxy,
                pResult: ?*IWSDAsyncResult,
                ppMetadata: ?*?*WSD_METADATA_SECTION_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetServiceMetadata: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxy,
                ppServiceMetadata: ?*?*WSD_SERVICE_METADATA,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxy,
                ppServiceMetadata: ?*?*WSD_SERVICE_METADATA,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SubscribeToOperation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxy,
                pOperation: ?*const WSD_OPERATION,
                pUnknown: ?*IUnknown,
                pAny: ?*const WSDXML_ELEMENT,
                ppAny: ?*?*WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxy,
                pOperation: ?*const WSD_OPERATION,
                pUnknown: ?*IUnknown,
                pAny: ?*const WSDXML_ELEMENT,
                ppAny: ?*?*WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        UnsubscribeToOperation: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxy,
                pOperation: ?*const WSD_OPERATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxy,
                pOperation: ?*const WSD_OPERATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetEventingStatusCallback: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxy,
                pStatus: ?*IWSDEventingStatus,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxy,
                pStatus: ?*IWSDEventingStatus,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetEndpointProxy: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxy,
                ppProxy: ?*?*IWSDEndpointProxy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxy,
                ppProxy: ?*?*IWSDEndpointProxy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWSDMetadataExchange.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxy_BeginGetMetadata(self: *const T, ppResult: ?*?*IWSDAsyncResult) HRESULT {
                return @as(*const IWSDServiceProxy.VTable, @ptrCast(self.vtable)).BeginGetMetadata(@as(*const IWSDServiceProxy, @ptrCast(self)), ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxy_EndGetMetadata(self: *const T, pResult: ?*IWSDAsyncResult, ppMetadata: ?*?*WSD_METADATA_SECTION_LIST) HRESULT {
                return @as(*const IWSDServiceProxy.VTable, @ptrCast(self.vtable)).EndGetMetadata(@as(*const IWSDServiceProxy, @ptrCast(self)), pResult, ppMetadata);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxy_GetServiceMetadata(self: *const T, ppServiceMetadata: ?*?*WSD_SERVICE_METADATA) HRESULT {
                return @as(*const IWSDServiceProxy.VTable, @ptrCast(self.vtable)).GetServiceMetadata(@as(*const IWSDServiceProxy, @ptrCast(self)), ppServiceMetadata);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxy_SubscribeToOperation(self: *const T, pOperation: ?*const WSD_OPERATION, pUnknown: ?*IUnknown, pAny: ?*const WSDXML_ELEMENT, ppAny: ?*?*WSDXML_ELEMENT) HRESULT {
                return @as(*const IWSDServiceProxy.VTable, @ptrCast(self.vtable)).SubscribeToOperation(@as(*const IWSDServiceProxy, @ptrCast(self)), pOperation, pUnknown, pAny, ppAny);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxy_UnsubscribeToOperation(self: *const T, pOperation: ?*const WSD_OPERATION) HRESULT {
                return @as(*const IWSDServiceProxy.VTable, @ptrCast(self.vtable)).UnsubscribeToOperation(@as(*const IWSDServiceProxy, @ptrCast(self)), pOperation);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxy_SetEventingStatusCallback(self: *const T, pStatus: ?*IWSDEventingStatus) HRESULT {
                return @as(*const IWSDServiceProxy.VTable, @ptrCast(self.vtable)).SetEventingStatusCallback(@as(*const IWSDServiceProxy, @ptrCast(self)), pStatus);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxy_GetEndpointProxy(self: *const T, ppProxy: ?*?*IWSDEndpointProxy) HRESULT {
                return @as(*const IWSDServiceProxy.VTable, @ptrCast(self.vtable)).GetEndpointProxy(@as(*const IWSDServiceProxy, @ptrCast(self)), ppProxy);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.1'
const IID_IWSDServiceProxyEventing_Value = Guid.initString("f9279d6d-1012-4a94-b8cc-fd35d2202bfe");
pub const IID_IWSDServiceProxyEventing = &IID_IWSDServiceProxyEventing_Value;
pub const IWSDServiceProxyEventing = extern struct {
    pub const VTable = extern struct {
        base: IWSDServiceProxy.VTable,
        SubscribeToMultipleOperations: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pUnknown: ?*IUnknown,
                pExpires: ?*const WSD_EVENTING_EXPIRES,
                pAny: ?*const WSDXML_ELEMENT,
                ppExpires: ?*?*WSD_EVENTING_EXPIRES,
                ppAny: ?*?*WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pUnknown: ?*IUnknown,
                pExpires: ?*const WSD_EVENTING_EXPIRES,
                pAny: ?*const WSDXML_ELEMENT,
                ppExpires: ?*?*WSD_EVENTING_EXPIRES,
                ppAny: ?*?*WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        BeginSubscribeToMultipleOperations: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pUnknown: ?*IUnknown,
                pExpires: ?*const WSD_EVENTING_EXPIRES,
                pAny: ?*const WSDXML_ELEMENT,
                pAsyncState: ?*IUnknown,
                pAsyncCallback: ?*IWSDAsyncCallback,
                ppResult: ?*?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pUnknown: ?*IUnknown,
                pExpires: ?*const WSD_EVENTING_EXPIRES,
                pAny: ?*const WSDXML_ELEMENT,
                pAsyncState: ?*IUnknown,
                pAsyncCallback: ?*IWSDAsyncCallback,
                ppResult: ?*?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EndSubscribeToMultipleOperations: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pResult: ?*IWSDAsyncResult,
                ppExpires: ?*?*WSD_EVENTING_EXPIRES,
                ppAny: ?*?*WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pResult: ?*IWSDAsyncResult,
                ppExpires: ?*?*WSD_EVENTING_EXPIRES,
                ppAny: ?*?*WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        UnsubscribeToMultipleOperations: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pAny: ?*const WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pAny: ?*const WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        BeginUnsubscribeToMultipleOperations: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pAny: ?*const WSDXML_ELEMENT,
                pAsyncState: ?*IUnknown,
                pAsyncCallback: ?*IWSDAsyncCallback,
                ppResult: ?*?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pAny: ?*const WSDXML_ELEMENT,
                pAsyncState: ?*IUnknown,
                pAsyncCallback: ?*IWSDAsyncCallback,
                ppResult: ?*?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EndUnsubscribeToMultipleOperations: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pResult: ?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pResult: ?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RenewMultipleOperations: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pExpires: ?*const WSD_EVENTING_EXPIRES,
                pAny: ?*const WSDXML_ELEMENT,
                ppExpires: ?*?*WSD_EVENTING_EXPIRES,
                ppAny: ?*?*WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pExpires: ?*const WSD_EVENTING_EXPIRES,
                pAny: ?*const WSDXML_ELEMENT,
                ppExpires: ?*?*WSD_EVENTING_EXPIRES,
                ppAny: ?*?*WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        BeginRenewMultipleOperations: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pExpires: ?*const WSD_EVENTING_EXPIRES,
                pAny: ?*const WSDXML_ELEMENT,
                pAsyncState: ?*IUnknown,
                pAsyncCallback: ?*IWSDAsyncCallback,
                ppResult: ?*?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pExpires: ?*const WSD_EVENTING_EXPIRES,
                pAny: ?*const WSDXML_ELEMENT,
                pAsyncState: ?*IUnknown,
                pAsyncCallback: ?*IWSDAsyncCallback,
                ppResult: ?*?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EndRenewMultipleOperations: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pResult: ?*IWSDAsyncResult,
                ppExpires: ?*?*WSD_EVENTING_EXPIRES,
                ppAny: ?*?*WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pResult: ?*IWSDAsyncResult,
                ppExpires: ?*?*WSD_EVENTING_EXPIRES,
                ppAny: ?*?*WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetStatusForMultipleOperations: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pAny: ?*const WSDXML_ELEMENT,
                ppExpires: ?*?*WSD_EVENTING_EXPIRES,
                ppAny: ?*?*WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pAny: ?*const WSDXML_ELEMENT,
                ppExpires: ?*?*WSD_EVENTING_EXPIRES,
                ppAny: ?*?*WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        BeginGetStatusForMultipleOperations: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pAny: ?*const WSDXML_ELEMENT,
                pAsyncState: ?*IUnknown,
                pAsyncCallback: ?*IWSDAsyncCallback,
                ppResult: ?*?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pAny: ?*const WSDXML_ELEMENT,
                pAsyncState: ?*IUnknown,
                pAsyncCallback: ?*IWSDAsyncCallback,
                ppResult: ?*?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EndGetStatusForMultipleOperations: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pResult: ?*IWSDAsyncResult,
                ppExpires: ?*?*WSD_EVENTING_EXPIRES,
                ppAny: ?*?*WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceProxyEventing,
                pOperations: [*]const WSD_OPERATION,
                dwOperationCount: u32,
                pResult: ?*IWSDAsyncResult,
                ppExpires: ?*?*WSD_EVENTING_EXPIRES,
                ppAny: ?*?*WSDXML_ELEMENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IWSDServiceProxy.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxyEventing_SubscribeToMultipleOperations(self: *const T, pOperations: [*]const WSD_OPERATION, dwOperationCount: u32, pUnknown: ?*IUnknown, pExpires: ?*const WSD_EVENTING_EXPIRES, pAny: ?*const WSDXML_ELEMENT, ppExpires: ?*?*WSD_EVENTING_EXPIRES, ppAny: ?*?*WSDXML_ELEMENT) HRESULT {
                return @as(*const IWSDServiceProxyEventing.VTable, @ptrCast(self.vtable)).SubscribeToMultipleOperations(@as(*const IWSDServiceProxyEventing, @ptrCast(self)), pOperations, dwOperationCount, pUnknown, pExpires, pAny, ppExpires, ppAny);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxyEventing_BeginSubscribeToMultipleOperations(self: *const T, pOperations: [*]const WSD_OPERATION, dwOperationCount: u32, pUnknown: ?*IUnknown, pExpires: ?*const WSD_EVENTING_EXPIRES, pAny: ?*const WSDXML_ELEMENT, pAsyncState: ?*IUnknown, pAsyncCallback: ?*IWSDAsyncCallback, ppResult: ?*?*IWSDAsyncResult) HRESULT {
                return @as(*const IWSDServiceProxyEventing.VTable, @ptrCast(self.vtable)).BeginSubscribeToMultipleOperations(@as(*const IWSDServiceProxyEventing, @ptrCast(self)), pOperations, dwOperationCount, pUnknown, pExpires, pAny, pAsyncState, pAsyncCallback, ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxyEventing_EndSubscribeToMultipleOperations(self: *const T, pOperations: [*]const WSD_OPERATION, dwOperationCount: u32, pResult: ?*IWSDAsyncResult, ppExpires: ?*?*WSD_EVENTING_EXPIRES, ppAny: ?*?*WSDXML_ELEMENT) HRESULT {
                return @as(*const IWSDServiceProxyEventing.VTable, @ptrCast(self.vtable)).EndSubscribeToMultipleOperations(@as(*const IWSDServiceProxyEventing, @ptrCast(self)), pOperations, dwOperationCount, pResult, ppExpires, ppAny);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxyEventing_UnsubscribeToMultipleOperations(self: *const T, pOperations: [*]const WSD_OPERATION, dwOperationCount: u32, pAny: ?*const WSDXML_ELEMENT) HRESULT {
                return @as(*const IWSDServiceProxyEventing.VTable, @ptrCast(self.vtable)).UnsubscribeToMultipleOperations(@as(*const IWSDServiceProxyEventing, @ptrCast(self)), pOperations, dwOperationCount, pAny);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxyEventing_BeginUnsubscribeToMultipleOperations(self: *const T, pOperations: [*]const WSD_OPERATION, dwOperationCount: u32, pAny: ?*const WSDXML_ELEMENT, pAsyncState: ?*IUnknown, pAsyncCallback: ?*IWSDAsyncCallback, ppResult: ?*?*IWSDAsyncResult) HRESULT {
                return @as(*const IWSDServiceProxyEventing.VTable, @ptrCast(self.vtable)).BeginUnsubscribeToMultipleOperations(@as(*const IWSDServiceProxyEventing, @ptrCast(self)), pOperations, dwOperationCount, pAny, pAsyncState, pAsyncCallback, ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxyEventing_EndUnsubscribeToMultipleOperations(self: *const T, pOperations: [*]const WSD_OPERATION, dwOperationCount: u32, pResult: ?*IWSDAsyncResult) HRESULT {
                return @as(*const IWSDServiceProxyEventing.VTable, @ptrCast(self.vtable)).EndUnsubscribeToMultipleOperations(@as(*const IWSDServiceProxyEventing, @ptrCast(self)), pOperations, dwOperationCount, pResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxyEventing_RenewMultipleOperations(self: *const T, pOperations: [*]const WSD_OPERATION, dwOperationCount: u32, pExpires: ?*const WSD_EVENTING_EXPIRES, pAny: ?*const WSDXML_ELEMENT, ppExpires: ?*?*WSD_EVENTING_EXPIRES, ppAny: ?*?*WSDXML_ELEMENT) HRESULT {
                return @as(*const IWSDServiceProxyEventing.VTable, @ptrCast(self.vtable)).RenewMultipleOperations(@as(*const IWSDServiceProxyEventing, @ptrCast(self)), pOperations, dwOperationCount, pExpires, pAny, ppExpires, ppAny);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxyEventing_BeginRenewMultipleOperations(self: *const T, pOperations: [*]const WSD_OPERATION, dwOperationCount: u32, pExpires: ?*const WSD_EVENTING_EXPIRES, pAny: ?*const WSDXML_ELEMENT, pAsyncState: ?*IUnknown, pAsyncCallback: ?*IWSDAsyncCallback, ppResult: ?*?*IWSDAsyncResult) HRESULT {
                return @as(*const IWSDServiceProxyEventing.VTable, @ptrCast(self.vtable)).BeginRenewMultipleOperations(@as(*const IWSDServiceProxyEventing, @ptrCast(self)), pOperations, dwOperationCount, pExpires, pAny, pAsyncState, pAsyncCallback, ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxyEventing_EndRenewMultipleOperations(self: *const T, pOperations: [*]const WSD_OPERATION, dwOperationCount: u32, pResult: ?*IWSDAsyncResult, ppExpires: ?*?*WSD_EVENTING_EXPIRES, ppAny: ?*?*WSDXML_ELEMENT) HRESULT {
                return @as(*const IWSDServiceProxyEventing.VTable, @ptrCast(self.vtable)).EndRenewMultipleOperations(@as(*const IWSDServiceProxyEventing, @ptrCast(self)), pOperations, dwOperationCount, pResult, ppExpires, ppAny);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxyEventing_GetStatusForMultipleOperations(self: *const T, pOperations: [*]const WSD_OPERATION, dwOperationCount: u32, pAny: ?*const WSDXML_ELEMENT, ppExpires: ?*?*WSD_EVENTING_EXPIRES, ppAny: ?*?*WSDXML_ELEMENT) HRESULT {
                return @as(*const IWSDServiceProxyEventing.VTable, @ptrCast(self.vtable)).GetStatusForMultipleOperations(@as(*const IWSDServiceProxyEventing, @ptrCast(self)), pOperations, dwOperationCount, pAny, ppExpires, ppAny);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxyEventing_BeginGetStatusForMultipleOperations(self: *const T, pOperations: [*]const WSD_OPERATION, dwOperationCount: u32, pAny: ?*const WSDXML_ELEMENT, pAsyncState: ?*IUnknown, pAsyncCallback: ?*IWSDAsyncCallback, ppResult: ?*?*IWSDAsyncResult) HRESULT {
                return @as(*const IWSDServiceProxyEventing.VTable, @ptrCast(self.vtable)).BeginGetStatusForMultipleOperations(@as(*const IWSDServiceProxyEventing, @ptrCast(self)), pOperations, dwOperationCount, pAny, pAsyncState, pAsyncCallback, ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceProxyEventing_EndGetStatusForMultipleOperations(self: *const T, pOperations: [*]const WSD_OPERATION, dwOperationCount: u32, pResult: ?*IWSDAsyncResult, ppExpires: ?*?*WSD_EVENTING_EXPIRES, ppAny: ?*?*WSDXML_ELEMENT) HRESULT {
                return @as(*const IWSDServiceProxyEventing.VTable, @ptrCast(self.vtable)).EndGetStatusForMultipleOperations(@as(*const IWSDServiceProxyEventing, @ptrCast(self)), pOperations, dwOperationCount, pResult, ppExpires, ppAny);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDDeviceProxy_Value = Guid.initString("eee0c031-c578-4c0e-9a3b-973c35f409db");
pub const IID_IWSDDeviceProxy = &IID_IWSDDeviceProxy_Value;
pub const IWSDDeviceProxy = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Init: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceProxy,
                pszDeviceId: ?[*:0]const u16,
                pDeviceAddress: ?*IWSDAddress,
                pszLocalId: ?[*:0]const u16,
                pContext: ?*IWSDXMLContext,
                pSponsor: ?*IWSDDeviceProxy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceProxy,
                pszDeviceId: ?[*:0]const u16,
                pDeviceAddress: ?*IWSDAddress,
                pszLocalId: ?[*:0]const u16,
                pContext: ?*IWSDXMLContext,
                pSponsor: ?*IWSDDeviceProxy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        BeginGetMetadata: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceProxy,
                ppResult: ?*?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceProxy,
                ppResult: ?*?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EndGetMetadata: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceProxy,
                pResult: ?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceProxy,
                pResult: ?*IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetHostMetadata: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceProxy,
                ppHostMetadata: ?*?*WSD_HOST_METADATA,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceProxy,
                ppHostMetadata: ?*?*WSD_HOST_METADATA,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetThisModelMetadata: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceProxy,
                ppManufacturerMetadata: ?*?*WSD_THIS_MODEL_METADATA,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceProxy,
                ppManufacturerMetadata: ?*?*WSD_THIS_MODEL_METADATA,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetThisDeviceMetadata: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceProxy,
                ppThisDeviceMetadata: ?*?*WSD_THIS_DEVICE_METADATA,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceProxy,
                ppThisDeviceMetadata: ?*?*WSD_THIS_DEVICE_METADATA,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAllMetadata: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceProxy,
                ppMetadata: ?*?*WSD_METADATA_SECTION_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceProxy,
                ppMetadata: ?*?*WSD_METADATA_SECTION_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetServiceProxyById: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceProxy,
                pszServiceId: ?[*:0]const u16,
                ppServiceProxy: ?*?*IWSDServiceProxy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceProxy,
                pszServiceId: ?[*:0]const u16,
                ppServiceProxy: ?*?*IWSDServiceProxy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetServiceProxyByType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceProxy,
                pType: ?*const WSDXML_NAME,
                ppServiceProxy: ?*?*IWSDServiceProxy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceProxy,
                pType: ?*const WSDXML_NAME,
                ppServiceProxy: ?*?*IWSDServiceProxy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetEndpointProxy: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceProxy,
                ppProxy: ?*?*IWSDEndpointProxy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceProxy,
                ppProxy: ?*?*IWSDEndpointProxy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceProxy_Init(self: *const T, pszDeviceId: ?[*:0]const u16, pDeviceAddress: ?*IWSDAddress, pszLocalId: ?[*:0]const u16, pContext: ?*IWSDXMLContext, pSponsor: ?*IWSDDeviceProxy) HRESULT {
                return @as(*const IWSDDeviceProxy.VTable, @ptrCast(self.vtable)).Init(@as(*const IWSDDeviceProxy, @ptrCast(self)), pszDeviceId, pDeviceAddress, pszLocalId, pContext, pSponsor);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceProxy_BeginGetMetadata(self: *const T, ppResult: ?*?*IWSDAsyncResult) HRESULT {
                return @as(*const IWSDDeviceProxy.VTable, @ptrCast(self.vtable)).BeginGetMetadata(@as(*const IWSDDeviceProxy, @ptrCast(self)), ppResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceProxy_EndGetMetadata(self: *const T, pResult: ?*IWSDAsyncResult) HRESULT {
                return @as(*const IWSDDeviceProxy.VTable, @ptrCast(self.vtable)).EndGetMetadata(@as(*const IWSDDeviceProxy, @ptrCast(self)), pResult);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceProxy_GetHostMetadata(self: *const T, ppHostMetadata: ?*?*WSD_HOST_METADATA) HRESULT {
                return @as(*const IWSDDeviceProxy.VTable, @ptrCast(self.vtable)).GetHostMetadata(@as(*const IWSDDeviceProxy, @ptrCast(self)), ppHostMetadata);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceProxy_GetThisModelMetadata(self: *const T, ppManufacturerMetadata: ?*?*WSD_THIS_MODEL_METADATA) HRESULT {
                return @as(*const IWSDDeviceProxy.VTable, @ptrCast(self.vtable)).GetThisModelMetadata(@as(*const IWSDDeviceProxy, @ptrCast(self)), ppManufacturerMetadata);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceProxy_GetThisDeviceMetadata(self: *const T, ppThisDeviceMetadata: ?*?*WSD_THIS_DEVICE_METADATA) HRESULT {
                return @as(*const IWSDDeviceProxy.VTable, @ptrCast(self.vtable)).GetThisDeviceMetadata(@as(*const IWSDDeviceProxy, @ptrCast(self)), ppThisDeviceMetadata);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceProxy_GetAllMetadata(self: *const T, ppMetadata: ?*?*WSD_METADATA_SECTION_LIST) HRESULT {
                return @as(*const IWSDDeviceProxy.VTable, @ptrCast(self.vtable)).GetAllMetadata(@as(*const IWSDDeviceProxy, @ptrCast(self)), ppMetadata);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceProxy_GetServiceProxyById(self: *const T, pszServiceId: ?[*:0]const u16, ppServiceProxy: ?*?*IWSDServiceProxy) HRESULT {
                return @as(*const IWSDDeviceProxy.VTable, @ptrCast(self.vtable)).GetServiceProxyById(@as(*const IWSDDeviceProxy, @ptrCast(self)), pszServiceId, ppServiceProxy);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceProxy_GetServiceProxyByType(self: *const T, pType: ?*const WSDXML_NAME, ppServiceProxy: ?*?*IWSDServiceProxy) HRESULT {
                return @as(*const IWSDDeviceProxy.VTable, @ptrCast(self.vtable)).GetServiceProxyByType(@as(*const IWSDDeviceProxy, @ptrCast(self)), pType, ppServiceProxy);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceProxy_GetEndpointProxy(self: *const T, ppProxy: ?*?*IWSDEndpointProxy) HRESULT {
                return @as(*const IWSDDeviceProxy.VTable, @ptrCast(self.vtable)).GetEndpointProxy(@as(*const IWSDDeviceProxy, @ptrCast(self)), ppProxy);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDAsyncResult_Value = Guid.initString("11a9852a-8dd8-423e-b537-9356db4fbfb8");
pub const IID_IWSDAsyncResult = &IID_IWSDAsyncResult_Value;
pub const IWSDAsyncResult = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetCallback: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDAsyncResult,
                pCallback: ?*IWSDAsyncCallback,
                pAsyncState: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDAsyncResult,
                pCallback: ?*IWSDAsyncCallback,
                pAsyncState: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetWaitHandle: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDAsyncResult,
                hWaitHandle: ?HANDLE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDAsyncResult,
                hWaitHandle: ?HANDLE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        HasCompleted: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAsyncState: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDAsyncResult,
                ppAsyncState: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDAsyncResult,
                ppAsyncState: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Abort: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDAsyncResult,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetEvent: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDAsyncResult,
                pEvent: ?*WSD_EVENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDAsyncResult,
                pEvent: ?*WSD_EVENT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetEndpointProxy: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDAsyncResult,
                ppEndpoint: ?*?*IWSDEndpointProxy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDAsyncResult,
                ppEndpoint: ?*?*IWSDEndpointProxy,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDAsyncResult_SetCallback(self: *const T, pCallback: ?*IWSDAsyncCallback, pAsyncState: ?*IUnknown) HRESULT {
                return @as(*const IWSDAsyncResult.VTable, @ptrCast(self.vtable)).SetCallback(@as(*const IWSDAsyncResult, @ptrCast(self)), pCallback, pAsyncState);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDAsyncResult_SetWaitHandle(self: *const T, hWaitHandle: ?HANDLE) HRESULT {
                return @as(*const IWSDAsyncResult.VTable, @ptrCast(self.vtable)).SetWaitHandle(@as(*const IWSDAsyncResult, @ptrCast(self)), hWaitHandle);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDAsyncResult_HasCompleted(self: *const T) HRESULT {
                return @as(*const IWSDAsyncResult.VTable, @ptrCast(self.vtable)).HasCompleted(@as(*const IWSDAsyncResult, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDAsyncResult_GetAsyncState(self: *const T, ppAsyncState: ?*?*IUnknown) HRESULT {
                return @as(*const IWSDAsyncResult.VTable, @ptrCast(self.vtable)).GetAsyncState(@as(*const IWSDAsyncResult, @ptrCast(self)), ppAsyncState);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDAsyncResult_Abort(self: *const T) HRESULT {
                return @as(*const IWSDAsyncResult.VTable, @ptrCast(self.vtable)).Abort(@as(*const IWSDAsyncResult, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDAsyncResult_GetEvent(self: *const T, pEvent: ?*WSD_EVENT) HRESULT {
                return @as(*const IWSDAsyncResult.VTable, @ptrCast(self.vtable)).GetEvent(@as(*const IWSDAsyncResult, @ptrCast(self)), pEvent);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDAsyncResult_GetEndpointProxy(self: *const T, ppEndpoint: ?*?*IWSDEndpointProxy) HRESULT {
                return @as(*const IWSDAsyncResult.VTable, @ptrCast(self.vtable)).GetEndpointProxy(@as(*const IWSDAsyncResult, @ptrCast(self)), ppEndpoint);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDAsyncCallback_Value = Guid.initString("a63e109d-ce72-49e2-ba98-e845f5ee1666");
pub const IID_IWSDAsyncCallback = &IID_IWSDAsyncCallback_Value;
pub const IWSDAsyncCallback = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        AsyncOperationComplete: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDAsyncCallback,
                pAsyncResult: ?*IWSDAsyncResult,
                pAsyncState: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDAsyncCallback,
                pAsyncResult: ?*IWSDAsyncResult,
                pAsyncState: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDAsyncCallback_AsyncOperationComplete(self: *const T, pAsyncResult: ?*IWSDAsyncResult, pAsyncState: ?*IUnknown) HRESULT {
                return @as(*const IWSDAsyncCallback.VTable, @ptrCast(self.vtable)).AsyncOperationComplete(@as(*const IWSDAsyncCallback, @ptrCast(self)), pAsyncResult, pAsyncState);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDEventingStatus_Value = Guid.initString("49b17f52-637a-407a-ae99-fbe82a4d38c0");
pub const IID_IWSDEventingStatus = &IID_IWSDEventingStatus_Value;
pub const IWSDEventingStatus = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SubscriptionRenewed: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDEventingStatus,
                pszSubscriptionAction: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) void,
            else => *const fn (
                self: *const IWSDEventingStatus,
                pszSubscriptionAction: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) void,
        },
        SubscriptionRenewalFailed: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDEventingStatus,
                pszSubscriptionAction: ?[*:0]const u16,
                hr: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) void,
            else => *const fn (
                self: *const IWSDEventingStatus,
                pszSubscriptionAction: ?[*:0]const u16,
                hr: HRESULT,
            ) callconv(@import("std").os.windows.WINAPI) void,
        },
        SubscriptionEnded: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDEventingStatus,
                pszSubscriptionAction: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) void,
            else => *const fn (
                self: *const IWSDEventingStatus,
                pszSubscriptionAction: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) void,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDEventingStatus_SubscriptionRenewed(self: *const T, pszSubscriptionAction: ?[*:0]const u16) void {
                return @as(*const IWSDEventingStatus.VTable, @ptrCast(self.vtable)).SubscriptionRenewed(@as(*const IWSDEventingStatus, @ptrCast(self)), pszSubscriptionAction);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDEventingStatus_SubscriptionRenewalFailed(self: *const T, pszSubscriptionAction: ?[*:0]const u16, hr: HRESULT) void {
                return @as(*const IWSDEventingStatus.VTable, @ptrCast(self.vtable)).SubscriptionRenewalFailed(@as(*const IWSDEventingStatus, @ptrCast(self)), pszSubscriptionAction, hr);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDEventingStatus_SubscriptionEnded(self: *const T, pszSubscriptionAction: ?[*:0]const u16) void {
                return @as(*const IWSDEventingStatus.VTable, @ptrCast(self.vtable)).SubscriptionEnded(@as(*const IWSDEventingStatus, @ptrCast(self)), pszSubscriptionAction);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDDeviceHost_Value = Guid.initString("917fe891-3d13-4138-9809-934c8abeb12c");
pub const IID_IWSDDeviceHost = &IID_IWSDDeviceHost_Value;
pub const IWSDDeviceHost = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Init: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceHost,
                pszLocalId: ?[*:0]const u16,
                pContext: ?*IWSDXMLContext,
                ppHostAddresses: ?[*]?*IWSDAddress,
                dwHostAddressCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceHost,
                pszLocalId: ?[*:0]const u16,
                pContext: ?*IWSDXMLContext,
                ppHostAddresses: ?[*]?*IWSDAddress,
                dwHostAddressCount: u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Start: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceHost,
                ullInstanceId: u64,
                pScopeList: ?*const WSD_URI_LIST,
                pNotificationSink: ?*IWSDDeviceHostNotify,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceHost,
                ullInstanceId: u64,
                pScopeList: ?*const WSD_URI_LIST,
                pNotificationSink: ?*IWSDDeviceHostNotify,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Stop: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceHost,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceHost,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Terminate: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceHost,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceHost,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RegisterPortType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceHost,
                pPortType: ?*const WSD_PORT_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceHost,
                pPortType: ?*const WSD_PORT_TYPE,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetMetadata: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceHost,
                pThisModelMetadata: ?*const WSD_THIS_MODEL_METADATA,
                pThisDeviceMetadata: ?*const WSD_THIS_DEVICE_METADATA,
                pHostMetadata: ?*const WSD_HOST_METADATA,
                pCustomMetadata: ?*const WSD_METADATA_SECTION_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceHost,
                pThisModelMetadata: ?*const WSD_THIS_MODEL_METADATA,
                pThisDeviceMetadata: ?*const WSD_THIS_DEVICE_METADATA,
                pHostMetadata: ?*const WSD_HOST_METADATA,
                pCustomMetadata: ?*const WSD_METADATA_SECTION_LIST,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RegisterService: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceHost,
                pszServiceId: ?[*:0]const u16,
                pService: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceHost,
                pszServiceId: ?[*:0]const u16,
                pService: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RetireService: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceHost,
                pszServiceId: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceHost,
                pszServiceId: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AddDynamicService: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceHost,
                pszServiceId: ?[*:0]const u16,
                pszEndpointAddress: ?[*:0]const u16,
                pPortType: ?*const WSD_PORT_TYPE,
                pPortName: ?*const WSDXML_NAME,
                pAny: ?*const WSDXML_ELEMENT,
                pService: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceHost,
                pszServiceId: ?[*:0]const u16,
                pszEndpointAddress: ?[*:0]const u16,
                pPortType: ?*const WSD_PORT_TYPE,
                pPortName: ?*const WSDXML_NAME,
                pAny: ?*const WSDXML_ELEMENT,
                pService: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RemoveDynamicService: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceHost,
                pszServiceId: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceHost,
                pszServiceId: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetServiceDiscoverable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceHost,
                pszServiceId: ?[*:0]const u16,
                fDiscoverable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceHost,
                pszServiceId: ?[*:0]const u16,
                fDiscoverable: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SignalEvent: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceHost,
                pszServiceId: ?[*:0]const u16,
                pBody: ?*const anyopaque,
                pOperation: ?*const WSD_OPERATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceHost,
                pszServiceId: ?[*:0]const u16,
                pBody: ?*const anyopaque,
                pOperation: ?*const WSD_OPERATION,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceHost_Init(self: *const T, pszLocalId: ?[*:0]const u16, pContext: ?*IWSDXMLContext, ppHostAddresses: ?[*]?*IWSDAddress, dwHostAddressCount: u32) HRESULT {
                return @as(*const IWSDDeviceHost.VTable, @ptrCast(self.vtable)).Init(@as(*const IWSDDeviceHost, @ptrCast(self)), pszLocalId, pContext, ppHostAddresses, dwHostAddressCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceHost_Start(self: *const T, ullInstanceId: u64, pScopeList: ?*const WSD_URI_LIST, pNotificationSink: ?*IWSDDeviceHostNotify) HRESULT {
                return @as(*const IWSDDeviceHost.VTable, @ptrCast(self.vtable)).Start(@as(*const IWSDDeviceHost, @ptrCast(self)), ullInstanceId, pScopeList, pNotificationSink);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceHost_Stop(self: *const T) HRESULT {
                return @as(*const IWSDDeviceHost.VTable, @ptrCast(self.vtable)).Stop(@as(*const IWSDDeviceHost, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceHost_Terminate(self: *const T) HRESULT {
                return @as(*const IWSDDeviceHost.VTable, @ptrCast(self.vtable)).Terminate(@as(*const IWSDDeviceHost, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceHost_RegisterPortType(self: *const T, pPortType: ?*const WSD_PORT_TYPE) HRESULT {
                return @as(*const IWSDDeviceHost.VTable, @ptrCast(self.vtable)).RegisterPortType(@as(*const IWSDDeviceHost, @ptrCast(self)), pPortType);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceHost_SetMetadata(self: *const T, pThisModelMetadata: ?*const WSD_THIS_MODEL_METADATA, pThisDeviceMetadata: ?*const WSD_THIS_DEVICE_METADATA, pHostMetadata: ?*const WSD_HOST_METADATA, pCustomMetadata: ?*const WSD_METADATA_SECTION_LIST) HRESULT {
                return @as(*const IWSDDeviceHost.VTable, @ptrCast(self.vtable)).SetMetadata(@as(*const IWSDDeviceHost, @ptrCast(self)), pThisModelMetadata, pThisDeviceMetadata, pHostMetadata, pCustomMetadata);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceHost_RegisterService(self: *const T, pszServiceId: ?[*:0]const u16, pService: ?*IUnknown) HRESULT {
                return @as(*const IWSDDeviceHost.VTable, @ptrCast(self.vtable)).RegisterService(@as(*const IWSDDeviceHost, @ptrCast(self)), pszServiceId, pService);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceHost_RetireService(self: *const T, pszServiceId: ?[*:0]const u16) HRESULT {
                return @as(*const IWSDDeviceHost.VTable, @ptrCast(self.vtable)).RetireService(@as(*const IWSDDeviceHost, @ptrCast(self)), pszServiceId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceHost_AddDynamicService(self: *const T, pszServiceId: ?[*:0]const u16, pszEndpointAddress: ?[*:0]const u16, pPortType: ?*const WSD_PORT_TYPE, pPortName: ?*const WSDXML_NAME, pAny: ?*const WSDXML_ELEMENT, pService: ?*IUnknown) HRESULT {
                return @as(*const IWSDDeviceHost.VTable, @ptrCast(self.vtable)).AddDynamicService(@as(*const IWSDDeviceHost, @ptrCast(self)), pszServiceId, pszEndpointAddress, pPortType, pPortName, pAny, pService);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceHost_RemoveDynamicService(self: *const T, pszServiceId: ?[*:0]const u16) HRESULT {
                return @as(*const IWSDDeviceHost.VTable, @ptrCast(self.vtable)).RemoveDynamicService(@as(*const IWSDDeviceHost, @ptrCast(self)), pszServiceId);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceHost_SetServiceDiscoverable(self: *const T, pszServiceId: ?[*:0]const u16, fDiscoverable: BOOL) HRESULT {
                return @as(*const IWSDDeviceHost.VTable, @ptrCast(self.vtable)).SetServiceDiscoverable(@as(*const IWSDDeviceHost, @ptrCast(self)), pszServiceId, fDiscoverable);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceHost_SignalEvent(self: *const T, pszServiceId: ?[*:0]const u16, pBody: ?*const anyopaque, pOperation: ?*const WSD_OPERATION) HRESULT {
                return @as(*const IWSDDeviceHost.VTable, @ptrCast(self.vtable)).SignalEvent(@as(*const IWSDDeviceHost, @ptrCast(self)), pszServiceId, pBody, pOperation);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDDeviceHostNotify_Value = Guid.initString("b5bee9f9-eeda-41fe-96f7-f45e14990fb0");
pub const IID_IWSDDeviceHostNotify = &IID_IWSDDeviceHostNotify_Value;
pub const IWSDDeviceHostNotify = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetService: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDDeviceHostNotify,
                pszServiceId: ?[*:0]const u16,
                ppService: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDDeviceHostNotify,
                pszServiceId: ?[*:0]const u16,
                ppService: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDDeviceHostNotify_GetService(self: *const T, pszServiceId: ?[*:0]const u16, ppService: ?*?*IUnknown) HRESULT {
                return @as(*const IWSDDeviceHostNotify.VTable, @ptrCast(self.vtable)).GetService(@as(*const IWSDDeviceHostNotify, @ptrCast(self)), pszServiceId, ppService);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows6.0.6000'
const IID_IWSDServiceMessaging_Value = Guid.initString("94974cf4-0cab-460d-a3f6-7a0ad623c0e6");
pub const IID_IWSDServiceMessaging = &IID_IWSDServiceMessaging_Value;
pub const IWSDServiceMessaging = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SendResponse: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceMessaging,
                pBody: ?*anyopaque,
                pOperation: ?*WSD_OPERATION,
                pMessageParameters: ?*IWSDMessageParameters,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceMessaging,
                pBody: ?*anyopaque,
                pOperation: ?*WSD_OPERATION,
                pMessageParameters: ?*IWSDMessageParameters,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        FaultRequest: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWSDServiceMessaging,
                pRequestHeader: ?*WSD_SOAP_HEADER,
                pMessageParameters: ?*IWSDMessageParameters,
                pFault: ?*WSD_SOAP_FAULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWSDServiceMessaging,
                pRequestHeader: ?*WSD_SOAP_HEADER,
                pMessageParameters: ?*IWSDMessageParameters,
                pFault: ?*WSD_SOAP_FAULT,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceMessaging_SendResponse(self: *const T, pBody: ?*anyopaque, pOperation: ?*WSD_OPERATION, pMessageParameters: ?*IWSDMessageParameters) HRESULT {
                return @as(*const IWSDServiceMessaging.VTable, @ptrCast(self.vtable)).SendResponse(@as(*const IWSDServiceMessaging, @ptrCast(self)), pBody, pOperation, pMessageParameters);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWSDServiceMessaging_FaultRequest(self: *const T, pRequestHeader: ?*WSD_SOAP_HEADER, pMessageParameters: ?*IWSDMessageParameters, pFault: ?*WSD_SOAP_FAULT) HRESULT {
                return @as(*const IWSDServiceMessaging.VTable, @ptrCast(self.vtable)).FaultRequest(@as(*const IWSDServiceMessaging, @ptrCast(self)), pRequestHeader, pMessageParameters, pFault);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

//--------------------------------------------------------------------------------
// Section: Functions (32)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDCreateUdpMessageParameters(
    ppTxParams: ?*?*IWSDUdpMessageParameters,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDCreateUdpAddress(
    ppAddress: ?*?*IWSDUdpAddress,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDCreateHttpMessageParameters(
    ppTxParams: ?*?*IWSDHttpMessageParameters,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDCreateHttpAddress(
    ppAddress: ?*?*IWSDHttpAddress,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDCreateOutboundAttachment(
    ppAttachment: ?*?*IWSDOutboundAttachment,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDXMLGetNameFromBuiltinNamespace(
    pszNamespace: ?[*:0]const u16,
    pszName: ?[*:0]const u16,
    ppName: ?*?*WSDXML_NAME,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDXMLCreateContext(
    ppContext: ?*?*IWSDXMLContext,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDCreateDiscoveryProvider(
    pContext: ?*IWSDXMLContext,
    ppProvider: ?*?*IWSDiscoveryProvider,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "wsdapi" fn WSDCreateDiscoveryProvider2(
    pContext: ?*IWSDXMLContext,
    pConfigParams: ?[*]WSD_CONFIG_PARAM,
    dwConfigParamCount: u32,
    ppProvider: ?*?*IWSDiscoveryProvider,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDCreateDiscoveryPublisher(
    pContext: ?*IWSDXMLContext,
    ppPublisher: ?*?*IWSDiscoveryPublisher,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "wsdapi" fn WSDCreateDiscoveryPublisher2(
    pContext: ?*IWSDXMLContext,
    pConfigParams: ?[*]WSD_CONFIG_PARAM,
    dwConfigParamCount: u32,
    ppPublisher: ?*?*IWSDiscoveryPublisher,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDCreateDeviceProxy(
    pszDeviceId: ?[*:0]const u16,
    pszLocalId: ?[*:0]const u16,
    pContext: ?*IWSDXMLContext,
    ppDeviceProxy: ?*?*IWSDDeviceProxy,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDCreateDeviceProxyAdvanced(
    pszDeviceId: ?[*:0]const u16,
    pDeviceAddress: ?*IWSDAddress,
    pszLocalId: ?[*:0]const u16,
    pContext: ?*IWSDXMLContext,
    ppDeviceProxy: ?*?*IWSDDeviceProxy,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "wsdapi" fn WSDCreateDeviceProxy2(
    pszDeviceId: ?[*:0]const u16,
    pszLocalId: ?[*:0]const u16,
    pContext: ?*IWSDXMLContext,
    pConfigParams: ?[*]WSD_CONFIG_PARAM,
    dwConfigParamCount: u32,
    ppDeviceProxy: ?*?*IWSDDeviceProxy,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDCreateDeviceHost(
    pszLocalId: ?[*:0]const u16,
    pContext: ?*IWSDXMLContext,
    ppDeviceHost: ?*?*IWSDDeviceHost,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDCreateDeviceHostAdvanced(
    pszLocalId: ?[*:0]const u16,
    pContext: ?*IWSDXMLContext,
    ppHostAddresses: ?[*]?*IWSDAddress,
    dwHostAddressCount: u32,
    ppDeviceHost: ?*?*IWSDDeviceHost,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "wsdapi" fn WSDCreateDeviceHost2(
    pszLocalId: ?[*:0]const u16,
    pContext: ?*IWSDXMLContext,
    pConfigParams: ?[*]WSD_CONFIG_PARAM,
    dwConfigParamCount: u32,
    ppDeviceHost: ?*?*IWSDDeviceHost,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDSetConfigurationOption(
    dwOption: u32,
    // TODO: what to do with BytesParamIndex 2?
    pVoid: ?*anyopaque,
    cbInBuffer: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDGetConfigurationOption(
    dwOption: u32,
    // TODO: what to do with BytesParamIndex 2?
    pVoid: ?*anyopaque,
    cbOutBuffer: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDAllocateLinkedMemory(
    pParent: ?*anyopaque,
    cbSize: usize,
) callconv(@import("std").os.windows.WINAPI) ?*anyopaque;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDFreeLinkedMemory(
    pVoid: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDAttachLinkedMemory(
    pParent: ?*anyopaque,
    pChild: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDDetachLinkedMemory(
    pVoid: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDXMLBuildAnyForSingleElement(
    pElementName: ?*WSDXML_NAME,
    pszText: ?[*:0]const u16,
    ppAny: ?*?*WSDXML_ELEMENT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDXMLGetValueFromAny(
    pszNamespace: ?[*:0]const u16,
    pszName: ?[*:0]const u16,
    pAny: ?*WSDXML_ELEMENT,
    ppszValue: ?*?PWSTR,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDXMLAddSibling(
    pFirst: ?*WSDXML_ELEMENT,
    pSecond: ?*WSDXML_ELEMENT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDXMLAddChild(
    pParent: ?*WSDXML_ELEMENT,
    pChild: ?*WSDXML_ELEMENT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDXMLCleanupElement(
    pAny: ?*WSDXML_ELEMENT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDGenerateFault(
    pszCode: ?[*:0]const u16,
    pszSubCode: ?[*:0]const u16,
    pszReason: ?[*:0]const u16,
    pszDetail: ?[*:0]const u16,
    pContext: ?*IWSDXMLContext,
    ppFault: ?*?*WSD_SOAP_FAULT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.0.6000'
pub extern "wsdapi" fn WSDGenerateFaultEx(
    pCode: ?*WSDXML_NAME,
    pSubCode: ?*WSDXML_NAME,
    pReasons: ?*WSD_LOCALIZED_STRING_LIST,
    pszDetail: ?[*:0]const u16,
    ppFault: ?*?*WSD_SOAP_FAULT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "wsdapi" fn WSDUriEncode(
    source: [*:0]const u16,
    cchSource: u32,
    destOut: [*]?PWSTR,
    cchDestOut: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "wsdapi" fn WSDUriDecode(
    source: [*:0]const u16,
    cchSource: u32,
    destOut: [*]?PWSTR,
    cchDestOut: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (8)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const CERT_CONTEXT = @import("../security/cryptography.zig").CERT_CONTEXT;
const HANDLE = @import("../foundation.zig").HANDLE;
const HRESULT = @import("../foundation.zig").HRESULT;
const IUnknown = @import("../system/com.zig").IUnknown;
const PWSTR = @import("../foundation.zig").PWSTR;
const SOCKADDR_STORAGE = @import("../networking/win_sock.zig").SOCKADDR_STORAGE;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
