//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (92)
//--------------------------------------------------------------------------------
pub const MDM_COMPRESSION = @as(u32, 1);
pub const MDM_ERROR_CONTROL = @as(u32, 2);
pub const MDM_FORCED_EC = @as(u32, 4);
pub const MDM_CELLULAR = @as(u32, 8);
pub const MDM_FLOWCONTROL_HARD = @as(u32, 16);
pub const MDM_FLOWCONTROL_SOFT = @as(u32, 32);
pub const MDM_CCITT_OVERRIDE = @as(u32, 64);
pub const MDM_SPEED_ADJUST = @as(u32, 128);
pub const MDM_TONE_DIAL = @as(u32, 256);
pub const MDM_BLIND_DIAL = @as(u32, 512);
pub const MDM_V23_OVERRIDE = @as(u32, 1024);
pub const MDM_DIAGNOSTICS = @as(u32, 2048);
pub const MDM_MASK_BEARERMODE = @as(u32, 61440);
pub const MDM_SHIFT_BEARERMODE = @as(u32, 12);
pub const MDM_MASK_PROTOCOLID = @as(u32, 983040);
pub const MDM_SHIFT_PROTOCOLID = @as(u32, 16);
pub const MDM_MASK_PROTOCOLDATA = @as(u32, 267386880);
pub const MDM_SHIFT_PROTOCOLDATA = @as(u32, 20);
pub const MDM_SHIFT_PROTOCOLINFO = @as(u32, 16);
pub const MDM_SHIFT_EXTENDEDINFO = @as(u32, 12);
pub const MDM_BEARERMODE_ANALOG = @as(u32, 0);
pub const MDM_BEARERMODE_ISDN = @as(u32, 1);
pub const MDM_BEARERMODE_GSM = @as(u32, 2);
pub const MDM_PROTOCOLID_DEFAULT = @as(u32, 0);
pub const MDM_PROTOCOLID_HDLCPPP = @as(u32, 1);
pub const MDM_PROTOCOLID_V128 = @as(u32, 2);
pub const MDM_PROTOCOLID_X75 = @as(u32, 3);
pub const MDM_PROTOCOLID_V110 = @as(u32, 4);
pub const MDM_PROTOCOLID_V120 = @as(u32, 5);
pub const MDM_PROTOCOLID_AUTO = @as(u32, 6);
pub const MDM_PROTOCOLID_ANALOG = @as(u32, 7);
pub const MDM_PROTOCOLID_GPRS = @as(u32, 8);
pub const MDM_PROTOCOLID_PIAFS = @as(u32, 9);
pub const MDM_SHIFT_HDLCPPP_SPEED = @as(u32, 0);
pub const MDM_MASK_HDLCPPP_SPEED = @as(u32, 7);
pub const MDM_HDLCPPP_SPEED_DEFAULT = @as(u32, 0);
pub const MDM_HDLCPPP_SPEED_64K = @as(u32, 1);
pub const MDM_HDLCPPP_SPEED_56K = @as(u32, 2);
pub const MDM_SHIFT_HDLCPPP_AUTH = @as(u32, 3);
pub const MDM_HDLCPPP_AUTH_DEFAULT = @as(u32, 0);
pub const MDM_HDLCPPP_AUTH_NONE = @as(u32, 1);
pub const MDM_HDLCPPP_AUTH_PAP = @as(u32, 2);
pub const MDM_HDLCPPP_AUTH_CHAP = @as(u32, 3);
pub const MDM_HDLCPPP_AUTH_MSCHAP = @as(u32, 4);
pub const MDM_SHIFT_HDLCPPP_ML = @as(u32, 6);
pub const MDM_HDLCPPP_ML_DEFAULT = @as(u32, 0);
pub const MDM_HDLCPPP_ML_NONE = @as(u32, 1);
pub const MDM_HDLCPPP_ML_2 = @as(u32, 2);
pub const MDM_SHIFT_V120_SPEED = @as(u32, 0);
pub const MDM_MASK_V120_SPEED = @as(u32, 7);
pub const MDM_V120_SPEED_DEFAULT = @as(u32, 0);
pub const MDM_V120_SPEED_64K = @as(u32, 1);
pub const MDM_V120_SPEED_56K = @as(u32, 2);
pub const MDM_SHIFT_V120_ML = @as(u32, 6);
pub const MDM_V120_ML_DEFAULT = @as(u32, 0);
pub const MDM_V120_ML_NONE = @as(u32, 1);
pub const MDM_V120_ML_2 = @as(u32, 2);
pub const MDM_SHIFT_X75_DATA = @as(u32, 0);
pub const MDM_MASK_X75_DATA = @as(u32, 7);
pub const MDM_X75_DATA_DEFAULT = @as(u32, 0);
pub const MDM_X75_DATA_64K = @as(u32, 1);
pub const MDM_X75_DATA_128K = @as(u32, 2);
pub const MDM_X75_DATA_T_70 = @as(u32, 3);
pub const MDM_X75_DATA_BTX = @as(u32, 4);
pub const MDM_SHIFT_V110_SPEED = @as(u32, 0);
pub const MDM_MASK_V110_SPEED = @as(u32, 15);
pub const MDM_V110_SPEED_DEFAULT = @as(u32, 0);
pub const MDM_V110_SPEED_1DOT2K = @as(u32, 1);
pub const MDM_V110_SPEED_2DOT4K = @as(u32, 2);
pub const MDM_V110_SPEED_4DOT8K = @as(u32, 3);
pub const MDM_V110_SPEED_9DOT6K = @as(u32, 4);
pub const MDM_V110_SPEED_12DOT0K = @as(u32, 5);
pub const MDM_V110_SPEED_14DOT4K = @as(u32, 6);
pub const MDM_V110_SPEED_19DOT2K = @as(u32, 7);
pub const MDM_V110_SPEED_28DOT8K = @as(u32, 8);
pub const MDM_V110_SPEED_38DOT4K = @as(u32, 9);
pub const MDM_V110_SPEED_57DOT6K = @as(u32, 10);
pub const MDM_SHIFT_AUTO_SPEED = @as(u32, 0);
pub const MDM_MASK_AUTO_SPEED = @as(u32, 7);
pub const MDM_AUTO_SPEED_DEFAULT = @as(u32, 0);
pub const MDM_SHIFT_AUTO_ML = @as(u32, 6);
pub const MDM_AUTO_ML_DEFAULT = @as(u32, 0);
pub const MDM_AUTO_ML_NONE = @as(u32, 1);
pub const MDM_AUTO_ML_2 = @as(u32, 2);
pub const MDM_ANALOG_RLP_ON = @as(u32, 0);
pub const MDM_ANALOG_RLP_OFF = @as(u32, 1);
pub const MDM_ANALOG_V34 = @as(u32, 2);
pub const MDM_PIAFS_INCOMING = @as(u32, 0);
pub const MDM_PIAFS_OUTGOING = @as(u32, 1);
pub const SID_3GPP_SUPSVCMODEL = Guid.initString("d7d08e07-d767-4478-b14a-eecc87ea12f7");
pub const MAXLENGTH_NAI = @as(u32, 72);
pub const MAXLENGTH_UICCDATASTORE = @as(u32, 10);

//--------------------------------------------------------------------------------
// Section: Types (18)
//--------------------------------------------------------------------------------
pub const MODEM_STATUS_FLAGS = enum(u32) {
    CTS_ON = 16,
    DSR_ON = 32,
    RING_ON = 64,
    RLSD_ON = 128,
    _,
    pub fn initFlags(o: struct {
        CTS_ON: u1 = 0,
        DSR_ON: u1 = 0,
        RING_ON: u1 = 0,
        RLSD_ON: u1 = 0,
    }) MODEM_STATUS_FLAGS {
        return @as(MODEM_STATUS_FLAGS, @enumFromInt((if (o.CTS_ON == 1) @intFromEnum(MODEM_STATUS_FLAGS.CTS_ON) else 0) | (if (o.DSR_ON == 1) @intFromEnum(MODEM_STATUS_FLAGS.DSR_ON) else 0) | (if (o.RING_ON == 1) @intFromEnum(MODEM_STATUS_FLAGS.RING_ON) else 0) | (if (o.RLSD_ON == 1) @intFromEnum(MODEM_STATUS_FLAGS.RLSD_ON) else 0)));
    }
};
pub const MS_CTS_ON = MODEM_STATUS_FLAGS.CTS_ON;
pub const MS_DSR_ON = MODEM_STATUS_FLAGS.DSR_ON;
pub const MS_RING_ON = MODEM_STATUS_FLAGS.RING_ON;
pub const MS_RLSD_ON = MODEM_STATUS_FLAGS.RLSD_ON;

pub const CLEAR_COMM_ERROR_FLAGS = enum(u32) {
    BREAK = 16,
    FRAME = 8,
    OVERRUN = 2,
    RXOVER = 1,
    RXPARITY = 4,
    _,
    pub fn initFlags(o: struct {
        BREAK: u1 = 0,
        FRAME: u1 = 0,
        OVERRUN: u1 = 0,
        RXOVER: u1 = 0,
        RXPARITY: u1 = 0,
    }) CLEAR_COMM_ERROR_FLAGS {
        return @as(CLEAR_COMM_ERROR_FLAGS, @enumFromInt((if (o.BREAK == 1) @intFromEnum(CLEAR_COMM_ERROR_FLAGS.BREAK) else 0) | (if (o.FRAME == 1) @intFromEnum(CLEAR_COMM_ERROR_FLAGS.FRAME) else 0) | (if (o.OVERRUN == 1) @intFromEnum(CLEAR_COMM_ERROR_FLAGS.OVERRUN) else 0) | (if (o.RXOVER == 1) @intFromEnum(CLEAR_COMM_ERROR_FLAGS.RXOVER) else 0) | (if (o.RXPARITY == 1) @intFromEnum(CLEAR_COMM_ERROR_FLAGS.RXPARITY) else 0)));
    }
};
pub const CE_BREAK = CLEAR_COMM_ERROR_FLAGS.BREAK;
pub const CE_FRAME = CLEAR_COMM_ERROR_FLAGS.FRAME;
pub const CE_OVERRUN = CLEAR_COMM_ERROR_FLAGS.OVERRUN;
pub const CE_RXOVER = CLEAR_COMM_ERROR_FLAGS.RXOVER;
pub const CE_RXPARITY = CLEAR_COMM_ERROR_FLAGS.RXPARITY;

pub const PURGE_COMM_FLAGS = enum(u32) {
    RXABORT = 2,
    RXCLEAR = 8,
    TXABORT = 1,
    TXCLEAR = 4,
    _,
    pub fn initFlags(o: struct {
        RXABORT: u1 = 0,
        RXCLEAR: u1 = 0,
        TXABORT: u1 = 0,
        TXCLEAR: u1 = 0,
    }) PURGE_COMM_FLAGS {
        return @as(PURGE_COMM_FLAGS, @enumFromInt((if (o.RXABORT == 1) @intFromEnum(PURGE_COMM_FLAGS.RXABORT) else 0) | (if (o.RXCLEAR == 1) @intFromEnum(PURGE_COMM_FLAGS.RXCLEAR) else 0) | (if (o.TXABORT == 1) @intFromEnum(PURGE_COMM_FLAGS.TXABORT) else 0) | (if (o.TXCLEAR == 1) @intFromEnum(PURGE_COMM_FLAGS.TXCLEAR) else 0)));
    }
};
pub const PURGE_RXABORT = PURGE_COMM_FLAGS.RXABORT;
pub const PURGE_RXCLEAR = PURGE_COMM_FLAGS.RXCLEAR;
pub const PURGE_TXABORT = PURGE_COMM_FLAGS.TXABORT;
pub const PURGE_TXCLEAR = PURGE_COMM_FLAGS.TXCLEAR;

pub const COMM_EVENT_MASK = enum(u32) {
    BREAK = 64,
    CTS = 8,
    DSR = 16,
    ERR = 128,
    EVENT1 = 2048,
    EVENT2 = 4096,
    PERR = 512,
    RING = 256,
    RLSD = 32,
    RX80FULL = 1024,
    RXCHAR = 1,
    RXFLAG = 2,
    TXEMPTY = 4,
    _,
    pub fn initFlags(o: struct {
        BREAK: u1 = 0,
        CTS: u1 = 0,
        DSR: u1 = 0,
        ERR: u1 = 0,
        EVENT1: u1 = 0,
        EVENT2: u1 = 0,
        PERR: u1 = 0,
        RING: u1 = 0,
        RLSD: u1 = 0,
        RX80FULL: u1 = 0,
        RXCHAR: u1 = 0,
        RXFLAG: u1 = 0,
        TXEMPTY: u1 = 0,
    }) COMM_EVENT_MASK {
        return @as(COMM_EVENT_MASK, @enumFromInt((if (o.BREAK == 1) @intFromEnum(COMM_EVENT_MASK.BREAK) else 0) | (if (o.CTS == 1) @intFromEnum(COMM_EVENT_MASK.CTS) else 0) | (if (o.DSR == 1) @intFromEnum(COMM_EVENT_MASK.DSR) else 0) | (if (o.ERR == 1) @intFromEnum(COMM_EVENT_MASK.ERR) else 0) | (if (o.EVENT1 == 1) @intFromEnum(COMM_EVENT_MASK.EVENT1) else 0) | (if (o.EVENT2 == 1) @intFromEnum(COMM_EVENT_MASK.EVENT2) else 0) | (if (o.PERR == 1) @intFromEnum(COMM_EVENT_MASK.PERR) else 0) | (if (o.RING == 1) @intFromEnum(COMM_EVENT_MASK.RING) else 0) | (if (o.RLSD == 1) @intFromEnum(COMM_EVENT_MASK.RLSD) else 0) | (if (o.RX80FULL == 1) @intFromEnum(COMM_EVENT_MASK.RX80FULL) else 0) | (if (o.RXCHAR == 1) @intFromEnum(COMM_EVENT_MASK.RXCHAR) else 0) | (if (o.RXFLAG == 1) @intFromEnum(COMM_EVENT_MASK.RXFLAG) else 0) | (if (o.TXEMPTY == 1) @intFromEnum(COMM_EVENT_MASK.TXEMPTY) else 0)));
    }
};
pub const EV_BREAK = COMM_EVENT_MASK.BREAK;
pub const EV_CTS = COMM_EVENT_MASK.CTS;
pub const EV_DSR = COMM_EVENT_MASK.DSR;
pub const EV_ERR = COMM_EVENT_MASK.ERR;
pub const EV_EVENT1 = COMM_EVENT_MASK.EVENT1;
pub const EV_EVENT2 = COMM_EVENT_MASK.EVENT2;
pub const EV_PERR = COMM_EVENT_MASK.PERR;
pub const EV_RING = COMM_EVENT_MASK.RING;
pub const EV_RLSD = COMM_EVENT_MASK.RLSD;
pub const EV_RX80FULL = COMM_EVENT_MASK.RX80FULL;
pub const EV_RXCHAR = COMM_EVENT_MASK.RXCHAR;
pub const EV_RXFLAG = COMM_EVENT_MASK.RXFLAG;
pub const EV_TXEMPTY = COMM_EVENT_MASK.TXEMPTY;

pub const ESCAPE_COMM_FUNCTION = enum(u32) {
    CLRBREAK = 9,
    CLRDTR = 6,
    CLRRTS = 4,
    SETBREAK = 8,
    SETDTR = 5,
    SETRTS = 3,
    SETXOFF = 1,
    SETXON = 2,
};
pub const CLRBREAK = ESCAPE_COMM_FUNCTION.CLRBREAK;
pub const CLRDTR = ESCAPE_COMM_FUNCTION.CLRDTR;
pub const CLRRTS = ESCAPE_COMM_FUNCTION.CLRRTS;
pub const SETBREAK = ESCAPE_COMM_FUNCTION.SETBREAK;
pub const SETDTR = ESCAPE_COMM_FUNCTION.SETDTR;
pub const SETRTS = ESCAPE_COMM_FUNCTION.SETRTS;
pub const SETXOFF = ESCAPE_COMM_FUNCTION.SETXOFF;
pub const SETXON = ESCAPE_COMM_FUNCTION.SETXON;

pub const MODEMDEVCAPS_DIAL_OPTIONS = enum(u32) {
    BILLING = 64,
    DIALTONE = 256,
    QUIET = 128,
    _,
    pub fn initFlags(o: struct {
        BILLING: u1 = 0,
        DIALTONE: u1 = 0,
        QUIET: u1 = 0,
    }) MODEMDEVCAPS_DIAL_OPTIONS {
        return @as(MODEMDEVCAPS_DIAL_OPTIONS, @enumFromInt((if (o.BILLING == 1) @intFromEnum(MODEMDEVCAPS_DIAL_OPTIONS.BILLING) else 0) | (if (o.DIALTONE == 1) @intFromEnum(MODEMDEVCAPS_DIAL_OPTIONS.DIALTONE) else 0) | (if (o.QUIET == 1) @intFromEnum(MODEMDEVCAPS_DIAL_OPTIONS.QUIET) else 0)));
    }
};
pub const DIALOPTION_BILLING = MODEMDEVCAPS_DIAL_OPTIONS.BILLING;
pub const DIALOPTION_DIALTONE = MODEMDEVCAPS_DIAL_OPTIONS.DIALTONE;
pub const DIALOPTION_QUIET = MODEMDEVCAPS_DIAL_OPTIONS.QUIET;

pub const MODEMSETTINGS_SPEAKER_MODE = enum(u32) {
    CALLSETUP = 8,
    DIAL = 2,
    OFF = 1,
    ON = 4,
};
pub const MDMSPKR_CALLSETUP = MODEMSETTINGS_SPEAKER_MODE.CALLSETUP;
pub const MDMSPKR_DIAL = MODEMSETTINGS_SPEAKER_MODE.DIAL;
pub const MDMSPKR_OFF = MODEMSETTINGS_SPEAKER_MODE.OFF;
pub const MDMSPKR_ON = MODEMSETTINGS_SPEAKER_MODE.ON;

pub const COMMPROP_STOP_PARITY = enum(u16) {
    STOPBITS_10 = 1,
    STOPBITS_15 = 2,
    STOPBITS_20 = 4,
    PARITY_NONE = 256,
    PARITY_ODD = 512,
    PARITY_EVEN = 1024,
    PARITY_MARK = 2048,
    PARITY_SPACE = 4096,
    _,
    pub fn initFlags(o: struct {
        STOPBITS_10: u1 = 0,
        STOPBITS_15: u1 = 0,
        STOPBITS_20: u1 = 0,
        PARITY_NONE: u1 = 0,
        PARITY_ODD: u1 = 0,
        PARITY_EVEN: u1 = 0,
        PARITY_MARK: u1 = 0,
        PARITY_SPACE: u1 = 0,
    }) COMMPROP_STOP_PARITY {
        return @as(COMMPROP_STOP_PARITY, @enumFromInt((if (o.STOPBITS_10 == 1) @intFromEnum(COMMPROP_STOP_PARITY.STOPBITS_10) else 0) | (if (o.STOPBITS_15 == 1) @intFromEnum(COMMPROP_STOP_PARITY.STOPBITS_15) else 0) | (if (o.STOPBITS_20 == 1) @intFromEnum(COMMPROP_STOP_PARITY.STOPBITS_20) else 0) | (if (o.PARITY_NONE == 1) @intFromEnum(COMMPROP_STOP_PARITY.PARITY_NONE) else 0) | (if (o.PARITY_ODD == 1) @intFromEnum(COMMPROP_STOP_PARITY.PARITY_ODD) else 0) | (if (o.PARITY_EVEN == 1) @intFromEnum(COMMPROP_STOP_PARITY.PARITY_EVEN) else 0) | (if (o.PARITY_MARK == 1) @intFromEnum(COMMPROP_STOP_PARITY.PARITY_MARK) else 0) | (if (o.PARITY_SPACE == 1) @intFromEnum(COMMPROP_STOP_PARITY.PARITY_SPACE) else 0)));
    }
};
pub const STOPBITS_10 = COMMPROP_STOP_PARITY.STOPBITS_10;
pub const STOPBITS_15 = COMMPROP_STOP_PARITY.STOPBITS_15;
pub const STOPBITS_20 = COMMPROP_STOP_PARITY.STOPBITS_20;
pub const PARITY_NONE = COMMPROP_STOP_PARITY.PARITY_NONE;
pub const PARITY_ODD = COMMPROP_STOP_PARITY.PARITY_ODD;
pub const PARITY_EVEN = COMMPROP_STOP_PARITY.PARITY_EVEN;
pub const PARITY_MARK = COMMPROP_STOP_PARITY.PARITY_MARK;
pub const PARITY_SPACE = COMMPROP_STOP_PARITY.PARITY_SPACE;

pub const MODEM_SPEAKER_VOLUME = enum(u32) {
    HIGH = 2,
    LOW = 0,
    MEDIUM = 1,
};
pub const MDMVOL_HIGH = MODEM_SPEAKER_VOLUME.HIGH;
pub const MDMVOL_LOW = MODEM_SPEAKER_VOLUME.LOW;
pub const MDMVOL_MEDIUM = MODEM_SPEAKER_VOLUME.MEDIUM;

pub const MODEMDEVCAPS_SPEAKER_VOLUME = enum(u32) {
    HIGH = 4,
    LOW = 1,
    MEDIUM = 2,
    _,
    pub fn initFlags(o: struct {
        HIGH: u1 = 0,
        LOW: u1 = 0,
        MEDIUM: u1 = 0,
    }) MODEMDEVCAPS_SPEAKER_VOLUME {
        return @as(MODEMDEVCAPS_SPEAKER_VOLUME, @enumFromInt((if (o.HIGH == 1) @intFromEnum(MODEMDEVCAPS_SPEAKER_VOLUME.HIGH) else 0) | (if (o.LOW == 1) @intFromEnum(MODEMDEVCAPS_SPEAKER_VOLUME.LOW) else 0) | (if (o.MEDIUM == 1) @intFromEnum(MODEMDEVCAPS_SPEAKER_VOLUME.MEDIUM) else 0)));
    }
};
pub const MDMVOLFLAG_HIGH = MODEMDEVCAPS_SPEAKER_VOLUME.HIGH;
pub const MDMVOLFLAG_LOW = MODEMDEVCAPS_SPEAKER_VOLUME.LOW;
pub const MDMVOLFLAG_MEDIUM = MODEMDEVCAPS_SPEAKER_VOLUME.MEDIUM;

pub const MODEMDEVCAPS_SPEAKER_MODE = enum(u32) {
    CALLSETUP = 8,
    DIAL = 2,
    OFF = 1,
    ON = 4,
    _,
    pub fn initFlags(o: struct {
        CALLSETUP: u1 = 0,
        DIAL: u1 = 0,
        OFF: u1 = 0,
        ON: u1 = 0,
    }) MODEMDEVCAPS_SPEAKER_MODE {
        return @as(MODEMDEVCAPS_SPEAKER_MODE, @enumFromInt((if (o.CALLSETUP == 1) @intFromEnum(MODEMDEVCAPS_SPEAKER_MODE.CALLSETUP) else 0) | (if (o.DIAL == 1) @intFromEnum(MODEMDEVCAPS_SPEAKER_MODE.DIAL) else 0) | (if (o.OFF == 1) @intFromEnum(MODEMDEVCAPS_SPEAKER_MODE.OFF) else 0) | (if (o.ON == 1) @intFromEnum(MODEMDEVCAPS_SPEAKER_MODE.ON) else 0)));
    }
};
pub const MDMSPKRFLAG_CALLSETUP = MODEMDEVCAPS_SPEAKER_MODE.CALLSETUP;
pub const MDMSPKRFLAG_DIAL = MODEMDEVCAPS_SPEAKER_MODE.DIAL;
pub const MDMSPKRFLAG_OFF = MODEMDEVCAPS_SPEAKER_MODE.OFF;
pub const MDMSPKRFLAG_ON = MODEMDEVCAPS_SPEAKER_MODE.ON;

pub const MODEMDEVCAPS = extern struct {
    dwActualSize: u32,
    dwRequiredSize: u32,
    dwDevSpecificOffset: u32,
    dwDevSpecificSize: u32,
    dwModemProviderVersion: u32,
    dwModemManufacturerOffset: u32,
    dwModemManufacturerSize: u32,
    dwModemModelOffset: u32,
    dwModemModelSize: u32,
    dwModemVersionOffset: u32,
    dwModemVersionSize: u32,
    dwDialOptions: MODEMDEVCAPS_DIAL_OPTIONS,
    dwCallSetupFailTimer: u32,
    dwInactivityTimeout: u32,
    dwSpeakerVolume: MODEMDEVCAPS_SPEAKER_VOLUME,
    dwSpeakerMode: MODEMDEVCAPS_SPEAKER_MODE,
    dwModemOptions: u32,
    dwMaxDTERate: u32,
    dwMaxDCERate: u32,
    abVariablePortion: [1]u8,
};

pub const MODEMSETTINGS = extern struct {
    dwActualSize: u32,
    dwRequiredSize: u32,
    dwDevSpecificOffset: u32,
    dwDevSpecificSize: u32,
    dwCallSetupFailTimer: u32,
    dwInactivityTimeout: u32,
    dwSpeakerVolume: MODEM_SPEAKER_VOLUME,
    dwSpeakerMode: MODEMSETTINGS_SPEAKER_MODE,
    dwPreferredModemOptions: u32,
    dwNegotiatedModemOptions: u32,
    dwNegotiatedDCERate: u32,
    abVariablePortion: [1]u8,
};

pub const COMMPROP = extern struct {
    wPacketLength: u16,
    wPacketVersion: u16,
    dwServiceMask: u32,
    dwReserved1: u32,
    dwMaxTxQueue: u32,
    dwMaxRxQueue: u32,
    dwMaxBaud: u32,
    dwProvSubType: u32,
    dwProvCapabilities: u32,
    dwSettableParams: u32,
    dwSettableBaud: u32,
    wSettableData: u16,
    wSettableStopParity: COMMPROP_STOP_PARITY,
    dwCurrentTxQueue: u32,
    dwCurrentRxQueue: u32,
    dwProvSpec1: u32,
    dwProvSpec2: u32,
    wcProvChar: [1]u16,
};

pub const COMSTAT = extern struct {
    _bitfield: u32,
    cbInQue: u32,
    cbOutQue: u32,
};

pub const DCB = extern struct {
    DCBlength: u32,
    BaudRate: u32,
    _bitfield: u32,
    wReserved: u16,
    XonLim: u16,
    XoffLim: u16,
    ByteSize: u8,
    Parity: u8,
    StopBits: u8,
    XonChar: CHAR,
    XoffChar: CHAR,
    ErrorChar: CHAR,
    EofChar: CHAR,
    EvtChar: CHAR,
    wReserved1: u16,
};

pub const COMMTIMEOUTS = extern struct {
    ReadIntervalTimeout: u32,
    ReadTotalTimeoutMultiplier: u32,
    ReadTotalTimeoutConstant: u32,
    WriteTotalTimeoutMultiplier: u32,
    WriteTotalTimeoutConstant: u32,
};

pub const COMMCONFIG = extern struct {
    dwSize: u32,
    wVersion: u16,
    wReserved: u16,
    dcb: DCB,
    dwProviderSubType: u32,
    dwProviderOffset: u32,
    dwProviderSize: u32,
    wcProviderData: [1]u16,
};

//--------------------------------------------------------------------------------
// Section: Functions (30)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn ClearCommBreak(
    hFile: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn ClearCommError(
    hFile: ?HANDLE,
    lpErrors: ?*CLEAR_COMM_ERROR_FLAGS,
    lpStat: ?*COMSTAT,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetupComm(
    hFile: ?HANDLE,
    dwInQueue: u32,
    dwOutQueue: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn EscapeCommFunction(
    hFile: ?HANDLE,
    dwFunc: ESCAPE_COMM_FUNCTION,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetCommConfig(
    hCommDev: ?HANDLE,
    // TODO: what to do with BytesParamIndex 2?
    lpCC: ?*COMMCONFIG,
    lpdwSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetCommMask(
    hFile: ?HANDLE,
    lpEvtMask: ?*COMM_EVENT_MASK,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetCommProperties(
    hFile: ?HANDLE,
    lpCommProp: ?*COMMPROP,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetCommModemStatus(
    hFile: ?HANDLE,
    lpModemStat: ?*MODEM_STATUS_FLAGS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetCommState(
    hFile: ?HANDLE,
    lpDCB: ?*DCB,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetCommTimeouts(
    hFile: ?HANDLE,
    lpCommTimeouts: ?*COMMTIMEOUTS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn PurgeComm(
    hFile: ?HANDLE,
    dwFlags: PURGE_COMM_FLAGS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetCommBreak(
    hFile: ?HANDLE,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetCommConfig(
    hCommDev: ?HANDLE,
    // TODO: what to do with BytesParamIndex 2?
    lpCC: ?*COMMCONFIG,
    dwSize: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetCommMask(
    hFile: ?HANDLE,
    dwEvtMask: COMM_EVENT_MASK,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetCommState(
    hFile: ?HANDLE,
    lpDCB: ?*DCB,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetCommTimeouts(
    hFile: ?HANDLE,
    lpCommTimeouts: ?*COMMTIMEOUTS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn TransmitCommChar(
    hFile: ?HANDLE,
    cChar: CHAR,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn WaitCommEvent(
    hFile: ?HANDLE,
    lpEvtMask: ?*COMM_EVENT_MASK,
    lpOverlapped: ?*OVERLAPPED,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows10.0.16299'
pub extern "api-ms-win-core-comm-l1-1-1" fn OpenCommPort(
    uPortNumber: u32,
    dwDesiredAccess: u32,
    dwFlagsAndAttributes: u32,
) callconv(@import("std").os.windows.WINAPI) ?HANDLE;

// TODO: this type is limited to platform 'windows10.0.17134'
pub extern "api-ms-win-core-comm-l1-1-2" fn GetCommPorts(
    lpPortNumbers: [*]u32,
    uPortNumbersCount: u32,
    puPortNumbersFound: ?*u32,
) callconv(@import("std").os.windows.WINAPI) u32;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn BuildCommDCBA(
    lpDef: ?[*:0]const u8,
    lpDCB: ?*DCB,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn BuildCommDCBW(
    lpDef: ?[*:0]const u16,
    lpDCB: ?*DCB,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn BuildCommDCBAndTimeoutsA(
    lpDef: ?[*:0]const u8,
    lpDCB: ?*DCB,
    lpCommTimeouts: ?*COMMTIMEOUTS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn BuildCommDCBAndTimeoutsW(
    lpDef: ?[*:0]const u16,
    lpDCB: ?*DCB,
    lpCommTimeouts: ?*COMMTIMEOUTS,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CommConfigDialogA(
    lpszName: ?[*:0]const u8,
    hWnd: ?HWND,
    lpCC: ?*COMMCONFIG,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn CommConfigDialogW(
    lpszName: ?[*:0]const u16,
    hWnd: ?HWND,
    lpCC: ?*COMMCONFIG,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetDefaultCommConfigA(
    lpszName: ?[*:0]const u8,
    // TODO: what to do with BytesParamIndex 2?
    lpCC: ?*COMMCONFIG,
    lpdwSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn GetDefaultCommConfigW(
    lpszName: ?[*:0]const u16,
    // TODO: what to do with BytesParamIndex 2?
    lpCC: ?*COMMCONFIG,
    lpdwSize: ?*u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetDefaultCommConfigA(
    lpszName: ?[*:0]const u8,
    // TODO: what to do with BytesParamIndex 2?
    lpCC: ?*COMMCONFIG,
    dwSize: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

// TODO: this type is limited to platform 'windows5.1.2600'
pub extern "kernel32" fn SetDefaultCommConfigW(
    lpszName: ?[*:0]const u16,
    // TODO: what to do with BytesParamIndex 2?
    lpCC: ?*COMMCONFIG,
    dwSize: u32,
) callconv(@import("std").os.windows.WINAPI) BOOL;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (5)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {
        pub const BuildCommDCB = thismodule.BuildCommDCBA;
        pub const BuildCommDCBAndTimeouts = thismodule.BuildCommDCBAndTimeoutsA;
        pub const CommConfigDialog = thismodule.CommConfigDialogA;
        pub const GetDefaultCommConfig = thismodule.GetDefaultCommConfigA;
        pub const SetDefaultCommConfig = thismodule.SetDefaultCommConfigA;
    },
    .wide => struct {
        pub const BuildCommDCB = thismodule.BuildCommDCBW;
        pub const BuildCommDCBAndTimeouts = thismodule.BuildCommDCBAndTimeoutsW;
        pub const CommConfigDialog = thismodule.CommConfigDialogW;
        pub const GetDefaultCommConfig = thismodule.GetDefaultCommConfigW;
        pub const SetDefaultCommConfig = thismodule.SetDefaultCommConfigW;
    },
    .unspecified => if (@import("builtin").is_test) struct {
        pub const BuildCommDCB = *opaque {};
        pub const BuildCommDCBAndTimeouts = *opaque {};
        pub const CommConfigDialog = *opaque {};
        pub const GetDefaultCommConfig = *opaque {};
        pub const SetDefaultCommConfig = *opaque {};
    } else struct {
        pub const BuildCommDCB = @compileError("'BuildCommDCB' requires that UNICODE be set to true or false in the root module");
        pub const BuildCommDCBAndTimeouts = @compileError("'BuildCommDCBAndTimeouts' requires that UNICODE be set to true or false in the root module");
        pub const CommConfigDialog = @compileError("'CommConfigDialog' requires that UNICODE be set to true or false in the root module");
        pub const GetDefaultCommConfig = @compileError("'GetDefaultCommConfig' requires that UNICODE be set to true or false in the root module");
        pub const SetDefaultCommConfig = @compileError("'SetDefaultCommConfig' requires that UNICODE be set to true or false in the root module");
    },
};
//--------------------------------------------------------------------------------
// Section: Imports (8)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const CHAR = @import("../foundation.zig").CHAR;
const HANDLE = @import("../foundation.zig").HANDLE;
const HWND = @import("../foundation.zig").HWND;
const OVERLAPPED = @import("../system/io.zig").OVERLAPPED;
const PSTR = @import("../foundation.zig").PSTR;
const PWSTR = @import("../foundation.zig").PWSTR;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
