//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (104)
//--------------------------------------------------------------------------------
pub const WINBIO_MAX_STRING_LEN = @as(u32, 256);
pub const WINBIO_SCP_VERSION_1 = @as(u32, 1);
pub const WINBIO_SCP_RANDOM_SIZE_V1 = @as(u32, 32);
pub const WINBIO_SCP_DIGEST_SIZE_V1 = @as(u32, 32);
pub const WINBIO_SCP_CURVE_FIELD_SIZE_V1 = @as(u32, 32);
pub const WINBIO_SCP_PUBLIC_KEY_SIZE_V1 = @as(u32, 65);
pub const WINBIO_SCP_PRIVATE_KEY_SIZE_V1 = @as(u32, 32);
pub const WINBIO_SCP_SIGNATURE_SIZE_V1 = @as(u32, 64);
pub const WINBIO_SCP_ENCRYPTION_BLOCK_SIZE_V1 = @as(u32, 16);
pub const WINBIO_SCP_ENCRYPTION_KEY_SIZE_V1 = @as(u32, 32);
pub const WINBIO_BIR_ALIGN_SIZE = @as(u32, 8);
pub const WINBIO_BIR_ALGIN_SIZE = @as(u32, 8);
pub const FACILITY_WINBIO = @as(u32, 9);
pub const FACILITY_NONE = @as(u32, 0);
pub const WINBIO_E_UNSUPPORTED_FACTOR = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861055));
pub const WINBIO_E_INVALID_UNIT = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861054));
pub const WINBIO_E_UNKNOWN_ID = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861053));
pub const WINBIO_E_CANCELED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861052));
pub const WINBIO_E_NO_MATCH = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861051));
pub const WINBIO_E_CAPTURE_ABORTED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861050));
pub const WINBIO_E_ENROLLMENT_IN_PROGRESS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861049));
pub const WINBIO_E_BAD_CAPTURE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861048));
pub const WINBIO_E_INVALID_CONTROL_CODE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861047));
pub const WINBIO_E_DATA_COLLECTION_IN_PROGRESS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861045));
pub const WINBIO_E_UNSUPPORTED_DATA_FORMAT = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861044));
pub const WINBIO_E_UNSUPPORTED_DATA_TYPE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861043));
pub const WINBIO_E_UNSUPPORTED_PURPOSE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861042));
pub const WINBIO_E_INVALID_DEVICE_STATE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861041));
pub const WINBIO_E_DEVICE_BUSY = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861040));
pub const WINBIO_E_DATABASE_CANT_CREATE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861039));
pub const WINBIO_E_DATABASE_CANT_OPEN = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861038));
pub const WINBIO_E_DATABASE_CANT_CLOSE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861037));
pub const WINBIO_E_DATABASE_CANT_ERASE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861036));
pub const WINBIO_E_DATABASE_CANT_FIND = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861035));
pub const WINBIO_E_DATABASE_ALREADY_EXISTS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861034));
pub const WINBIO_E_DATABASE_FULL = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861032));
pub const WINBIO_E_DATABASE_LOCKED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861031));
pub const WINBIO_E_DATABASE_CORRUPTED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861030));
pub const WINBIO_E_DATABASE_NO_SUCH_RECORD = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861029));
pub const WINBIO_E_DUPLICATE_ENROLLMENT = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861028));
pub const WINBIO_E_DATABASE_READ_ERROR = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861027));
pub const WINBIO_E_DATABASE_WRITE_ERROR = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861026));
pub const WINBIO_E_DATABASE_NO_RESULTS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861025));
pub const WINBIO_E_DATABASE_NO_MORE_RECORDS = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861024));
pub const WINBIO_E_DATABASE_EOF = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861023));
pub const WINBIO_E_DATABASE_BAD_INDEX_VECTOR = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861022));
pub const WINBIO_E_INCORRECT_BSP = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861020));
pub const WINBIO_E_INCORRECT_SENSOR_POOL = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861019));
pub const WINBIO_E_NO_CAPTURE_DATA = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861018));
pub const WINBIO_E_INVALID_SENSOR_MODE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861017));
pub const WINBIO_E_LOCK_VIOLATION = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861014));
pub const WINBIO_E_DUPLICATE_TEMPLATE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861013));
pub const WINBIO_E_INVALID_OPERATION = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861012));
pub const WINBIO_E_SESSION_BUSY = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861011));
pub const WINBIO_E_CRED_PROV_DISABLED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861008));
pub const WINBIO_E_CRED_PROV_NO_CREDENTIAL = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861007));
pub const WINBIO_E_DISABLED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861006));
pub const WINBIO_E_CONFIGURATION_FAILURE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861005));
pub const WINBIO_E_SENSOR_UNAVAILABLE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861004));
pub const WINBIO_E_SAS_ENABLED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861003));
pub const WINBIO_E_DEVICE_FAILURE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861002));
pub const WINBIO_E_FAST_USER_SWITCH_DISABLED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861001));
pub const WINBIO_E_NOT_ACTIVE_CONSOLE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146861000));
pub const WINBIO_E_EVENT_MONITOR_ACTIVE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860999));
pub const WINBIO_E_INVALID_PROPERTY_TYPE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860998));
pub const WINBIO_E_INVALID_PROPERTY_ID = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860997));
pub const WINBIO_E_UNSUPPORTED_PROPERTY = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860996));
pub const WINBIO_E_ADAPTER_INTEGRITY_FAILURE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860995));
pub const WINBIO_E_INCORRECT_SESSION_TYPE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860994));
pub const WINBIO_E_SESSION_HANDLE_CLOSED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860993));
pub const WINBIO_E_DEADLOCK_DETECTED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860992));
pub const WINBIO_E_NO_PREBOOT_IDENTITY = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860991));
pub const WINBIO_E_MAX_ERROR_COUNT_EXCEEDED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860990));
pub const WINBIO_E_AUTO_LOGON_DISABLED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860989));
pub const WINBIO_E_INVALID_TICKET = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860988));
pub const WINBIO_E_TICKET_QUOTA_EXCEEDED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860987));
pub const WINBIO_E_DATA_PROTECTION_FAILURE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860986));
pub const WINBIO_E_CRED_PROV_SECURITY_LOCKOUT = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860985));
pub const WINBIO_E_UNSUPPORTED_POOL_TYPE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860984));
pub const WINBIO_E_SELECTION_REQUIRED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860983));
pub const WINBIO_E_PRESENCE_MONITOR_ACTIVE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860982));
pub const WINBIO_E_INVALID_SUBFACTOR = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860981));
pub const WINBIO_E_INVALID_CALIBRATION_FORMAT_ARRAY = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860980));
pub const WINBIO_E_NO_SUPPORTED_CALIBRATION_FORMAT = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860979));
pub const WINBIO_E_UNSUPPORTED_SENSOR_CALIBRATION_FORMAT = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860978));
pub const WINBIO_E_CALIBRATION_BUFFER_TOO_SMALL = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860977));
pub const WINBIO_E_CALIBRATION_BUFFER_TOO_LARGE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860976));
pub const WINBIO_E_CALIBRATION_BUFFER_INVALID = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860975));
pub const WINBIO_E_INVALID_KEY_IDENTIFIER = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860974));
pub const WINBIO_E_KEY_CREATION_FAILED = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860973));
pub const WINBIO_E_KEY_IDENTIFIER_BUFFER_TOO_SMALL = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860972));
pub const WINBIO_E_PROPERTY_UNAVAILABLE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860971));
pub const WINBIO_E_POLICY_PROTECTION_UNAVAILABLE = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860970));
pub const WINBIO_E_INSECURE_SENSOR = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860969));
pub const WINBIO_E_INVALID_BUFFER_ID = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860968));
pub const WINBIO_E_INVALID_BUFFER = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860967));
pub const WINBIO_E_TRUSTLET_INTEGRITY_FAIL = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860966));
pub const WINBIO_E_ENROLLMENT_CANCELED_BY_SUSPEND = @import("../zig.zig").typedConst(HRESULT, @as(i32, -2146860965));
pub const WINBIO_I_MORE_DATA = @import("../zig.zig").typedConst(HRESULT, @as(i32, 589825));
pub const WINBIO_I_EXTENDED_STATUS_INFORMATION = @import("../zig.zig").typedConst(HRESULT, @as(i32, 589826));
pub const GUID_DEVINTERFACE_BIOMETRIC_READER = Guid.initString("e2b5183a-99ea-4cc3-ad6b-80ca8d715b80");
pub const IOCTL_BIOMETRIC_VENDOR = @as(u32, 4464640);
pub const WINBIO_WBDI_MAJOR_VERSION = @as(u32, 1);
pub const WINBIO_WBDI_MINOR_VERSION = @as(u32, 0);

//--------------------------------------------------------------------------------
// Section: Types (192)
//--------------------------------------------------------------------------------
pub const WINBIO_SETTING_SOURCE = enum(u32) {
    INVALID = 0,
    DEFAULT = 1,
    LOCAL = 3,
    POLICY = 2,
};
pub const WINBIO_SETTING_SOURCE_INVALID = WINBIO_SETTING_SOURCE.INVALID;
pub const WINBIO_SETTING_SOURCE_DEFAULT = WINBIO_SETTING_SOURCE.DEFAULT;
pub const WINBIO_SETTING_SOURCE_LOCAL = WINBIO_SETTING_SOURCE.LOCAL;
pub const WINBIO_SETTING_SOURCE_POLICY = WINBIO_SETTING_SOURCE.POLICY;

pub const WINBIO_COMPONENT = enum(u32) {
    SENSOR = 1,
    ENGINE = 2,
    STORAGE = 3,
};
pub const WINBIO_COMPONENT_SENSOR = WINBIO_COMPONENT.SENSOR;
pub const WINBIO_COMPONENT_ENGINE = WINBIO_COMPONENT.ENGINE;
pub const WINBIO_COMPONENT_STORAGE = WINBIO_COMPONENT.STORAGE;

pub const WINBIO_POOL = enum(u32) {
    SYSTEM = 1,
    PRIVATE = 2,
};
pub const WINBIO_POOL_SYSTEM = WINBIO_POOL.SYSTEM;
pub const WINBIO_POOL_PRIVATE = WINBIO_POOL.PRIVATE;

pub const WINBIO_VERSION = extern struct {
    MajorVersion: u32,
    MinorVersion: u32,
};

pub const WINBIO_IDENTITY = extern struct {
    Type: u32,
    Value: extern union {
        Null: u32,
        Wildcard: u32,
        TemplateGuid: Guid,
        AccountSid: extern struct {
            Size: u32,
            Data: [68]u8,
        },
        SecureId: [32]u8,
    },
};

pub const WINBIO_SECURE_CONNECTION_PARAMS = extern struct {
    PayloadSize: u32,
    Version: u16,
    Flags: u16,
};

pub const WINBIO_SECURE_CONNECTION_DATA = extern struct {
    Size: u32,
    Version: u16,
    Flags: u16,
    ModelCertificateSize: u32,
    IntermediateCA1Size: u32,
    IntermediateCA2Size: u32,
};

pub const WINBIO_BIR_DATA = extern struct {
    Size: u32,
    Offset: u32,
};

pub const WINBIO_BIR = extern struct {
    HeaderBlock: WINBIO_BIR_DATA,
    StandardDataBlock: WINBIO_BIR_DATA,
    VendorDataBlock: WINBIO_BIR_DATA,
    SignatureBlock: WINBIO_BIR_DATA,
};

pub const WINBIO_REGISTERED_FORMAT = extern struct {
    Owner: u16,
    Type: u16,
};

pub const WINBIO_BIR_HEADER = extern struct {
    ValidFields: u16,
    HeaderVersion: u8,
    PatronHeaderVersion: u8,
    DataFlags: u8,
    Type: u32,
    Subtype: u8,
    Purpose: u8,
    DataQuality: i8,
    CreationDate: LARGE_INTEGER,
    ValidityPeriod: extern struct {
        BeginDate: LARGE_INTEGER,
        EndDate: LARGE_INTEGER,
    },
    BiometricDataFormat: WINBIO_REGISTERED_FORMAT,
    ProductId: WINBIO_REGISTERED_FORMAT,
};

pub const WINBIO_BDB_ANSI_381_HEADER = extern struct {
    RecordLength: u64,
    FormatIdentifier: u32,
    VersionNumber: u32,
    ProductId: WINBIO_REGISTERED_FORMAT,
    CaptureDeviceId: u16,
    ImageAcquisitionLevel: u16,
    HorizontalScanResolution: u16,
    VerticalScanResolution: u16,
    HorizontalImageResolution: u16,
    VerticalImageResolution: u16,
    ElementCount: u8,
    ScaleUnits: u8,
    PixelDepth: u8,
    ImageCompressionAlg: u8,
    Reserved: u16,
};

pub const WINBIO_BDB_ANSI_381_RECORD = extern struct {
    BlockLength: u32,
    HorizontalLineLength: u16,
    VerticalLineLength: u16,
    Position: u8,
    CountOfViews: u8,
    ViewNumber: u8,
    ImageQuality: u8,
    ImpressionType: u8,
    Reserved: u8,
};

pub const WINBIO_SECURE_BUFFER_HEADER_V1 = extern struct {
    Type: u32,
    Size: u32,
    Flags: u32,
    ValidationTag: u64,
};

pub const WINBIO_EVENT = extern struct {
    Type: u32,
    Parameters: extern union {
        Unclaimed: extern struct {
            UnitId: u32,
            RejectDetail: u32,
        },
        UnclaimedIdentify: extern struct {
            UnitId: u32,
            Identity: WINBIO_IDENTITY,
            SubFactor: u8,
            RejectDetail: u32,
        },
        Error: extern struct {
            ErrorCode: HRESULT,
        },
    },
};

pub const WINBIO_PRESENCE_PROPERTIES = extern union {
    FacialFeatures: extern struct {
        BoundingBox: RECT,
        Distance: i32,
        OpaqueEngineData: extern struct {
            AdapterId: Guid,
            Data: [78]u32,
        },
    },
    Iris: extern struct {
        EyeBoundingBox_1: RECT,
        EyeBoundingBox_2: RECT,
        PupilCenter_1: POINT,
        PupilCenter_2: POINT,
        Distance: i32,
    },
};

pub const WINBIO_PRESENCE = extern struct {
    Factor: u32,
    SubFactor: u8,
    Status: HRESULT,
    RejectDetail: u32,
    Identity: WINBIO_IDENTITY,
    TrackingId: u64,
    Ticket: u64,
    Properties: WINBIO_PRESENCE_PROPERTIES,
    Authorization: extern struct {
        Size: u32,
        Data: [32]u8,
    },
};

pub const WINBIO_BSP_SCHEMA = extern struct {
    BiometricFactor: u32,
    BspId: Guid,
    Description: [256]u16,
    Vendor: [256]u16,
    Version: WINBIO_VERSION,
};

pub const WINBIO_UNIT_SCHEMA = extern struct {
    UnitId: u32,
    PoolType: u32,
    BiometricFactor: u32,
    SensorSubType: u32,
    Capabilities: u32,
    DeviceInstanceId: [256]u16,
    Description: [256]u16,
    Manufacturer: [256]u16,
    Model: [256]u16,
    SerialNumber: [256]u16,
    FirmwareVersion: WINBIO_VERSION,
};

pub const WINBIO_STORAGE_SCHEMA = extern struct {
    BiometricFactor: u32,
    DatabaseId: Guid,
    DataFormat: Guid,
    Attributes: u32,
    FilePath: [256]u16,
    ConnectionString: [256]u16,
};

pub const WINBIO_EXTENDED_SENSOR_INFO = extern struct {
    GenericSensorCapabilities: u32,
    Factor: u32,
    Specific: extern union {
        Null: u32,
        FacialFeatures: extern struct {
            FrameSize: RECT,
            FrameOffset: POINT,
            MandatoryOrientation: u32,
            HardwareInfo: extern struct {
                ColorSensorId: [260]u16,
                InfraredSensorId: [260]u16,
                InfraredSensorRotationAngle: u32,
            },
        },
        Fingerprint: extern struct {
            Reserved: u32,
        },
        Iris: extern struct {
            FrameSize: RECT,
            FrameOffset: POINT,
            MandatoryOrientation: u32,
        },
        Voice: extern struct {
            Reserved: u32,
        },
    },
};

pub const WINBIO_EXTENDED_ENGINE_INFO = extern struct {
    GenericEngineCapabilities: u32,
    Factor: u32,
    Specific: extern union {
        Null: u32,
        FacialFeatures: extern struct {
            Capabilities: u32,
            EnrollmentRequirements: extern struct {
                Null: u32,
            },
        },
        Fingerprint: extern struct {
            Capabilities: u32,
            EnrollmentRequirements: extern struct {
                GeneralSamples: u32,
                Center: u32,
                TopEdge: u32,
                BottomEdge: u32,
                LeftEdge: u32,
                RightEdge: u32,
            },
        },
        Iris: extern struct {
            Capabilities: u32,
            EnrollmentRequirements: extern struct {
                Null: u32,
            },
        },
        Voice: extern struct {
            Capabilities: u32,
            EnrollmentRequirements: extern struct {
                Null: u32,
            },
        },
    },
};

pub const WINBIO_EXTENDED_STORAGE_INFO = extern struct {
    GenericStorageCapabilities: u32,
    Factor: u32,
    Specific: extern union {
        Null: u32,
        FacialFeatures: extern struct {
            Capabilities: u32,
        },
        Fingerprint: extern struct {
            Capabilities: u32,
        },
        Iris: extern struct {
            Capabilities: u32,
        },
        Voice: extern struct {
            Capabilities: u32,
        },
    },
};

pub const WINBIO_EXTENDED_ENROLLMENT_STATUS = extern struct {
    TemplateStatus: HRESULT,
    RejectDetail: u32,
    PercentComplete: u32,
    Factor: u32,
    SubFactor: u8,
    Specific: extern union {
        Null: u32,
        FacialFeatures: extern struct {
            BoundingBox: RECT,
            Distance: i32,
            OpaqueEngineData: extern struct {
                AdapterId: Guid,
                Data: [78]u32,
            },
        },
        Fingerprint: extern struct {
            GeneralSamples: u32,
            Center: u32,
            TopEdge: u32,
            BottomEdge: u32,
            LeftEdge: u32,
            RightEdge: u32,
        },
        Iris: extern struct {
            EyeBoundingBox_1: RECT,
            EyeBoundingBox_2: RECT,
            PupilCenter_1: POINT,
            PupilCenter_2: POINT,
            Distance: i32,
            GridPointCompletionPercent: u32,
            GridPointIndex: u16,
            Point3D: extern struct {
                X: f64,
                Y: f64,
                Z: f64,
            },
            StopCaptureAndShowCriticalFeedback: BOOL,
        },
        Voice: extern struct {
            Reserved: u32,
        },
    },
};

pub const WINBIO_EXTENDED_UNIT_STATUS = extern struct {
    Availability: u32,
    ReasonCode: u32,
};

pub const WINBIO_FP_BU_STATE = extern struct {
    SensorAttached: BOOL,
    CreationResult: HRESULT,
};

pub const WINBIO_ANTI_SPOOF_POLICY_ACTION = enum(i32) {
    DISABLE = 0,
    ENABLE = 1,
    REMOVE = 2,
};
pub const WINBIO_ANTI_SPOOF_DISABLE = WINBIO_ANTI_SPOOF_POLICY_ACTION.DISABLE;
pub const WINBIO_ANTI_SPOOF_ENABLE = WINBIO_ANTI_SPOOF_POLICY_ACTION.ENABLE;
pub const WINBIO_ANTI_SPOOF_REMOVE = WINBIO_ANTI_SPOOF_POLICY_ACTION.REMOVE;

pub const WINBIO_POLICY_SOURCE = enum(i32) {
    UNKNOWN = 0,
    DEFAULT = 1,
    LOCAL = 2,
    ADMIN = 3,
};
pub const WINBIO_POLICY_UNKNOWN = WINBIO_POLICY_SOURCE.UNKNOWN;
pub const WINBIO_POLICY_DEFAULT = WINBIO_POLICY_SOURCE.DEFAULT;
pub const WINBIO_POLICY_LOCAL = WINBIO_POLICY_SOURCE.LOCAL;
pub const WINBIO_POLICY_ADMIN = WINBIO_POLICY_SOURCE.ADMIN;

pub const WINBIO_ANTI_SPOOF_POLICY = extern struct {
    Action: WINBIO_ANTI_SPOOF_POLICY_ACTION,
    Source: WINBIO_POLICY_SOURCE,
};

pub const WINBIO_CREDENTIAL_TYPE = enum(i32) {
    PASSWORD = 1,
    ALL = -1,
};
pub const WINBIO_CREDENTIAL_PASSWORD = WINBIO_CREDENTIAL_TYPE.PASSWORD;
pub const WINBIO_CREDENTIAL_ALL = WINBIO_CREDENTIAL_TYPE.ALL;

pub const WINBIO_CREDENTIAL_FORMAT = enum(i32) {
    GENERIC = 1,
    PACKED = 2,
    PROTECTED = 3,
};
pub const WINBIO_PASSWORD_GENERIC = WINBIO_CREDENTIAL_FORMAT.GENERIC;
pub const WINBIO_PASSWORD_PACKED = WINBIO_CREDENTIAL_FORMAT.PACKED;
pub const WINBIO_PASSWORD_PROTECTED = WINBIO_CREDENTIAL_FORMAT.PROTECTED;

pub const WINBIO_CREDENTIAL_STATE = enum(i32) {
    NOT_SET = 1,
    SET = 2,
};
pub const WINBIO_CREDENTIAL_NOT_SET = WINBIO_CREDENTIAL_STATE.NOT_SET;
pub const WINBIO_CREDENTIAL_SET = WINBIO_CREDENTIAL_STATE.SET;

pub const WINBIO_EXTENDED_ENROLLMENT_PARAMETERS = extern struct {
    Size: usize,
    SubFactor: u8,
};

pub const WINBIO_ACCOUNT_POLICY = extern struct {
    Identity: WINBIO_IDENTITY,
    AntiSpoofBehavior: WINBIO_ANTI_SPOOF_POLICY_ACTION,
};

pub const WINBIO_PROTECTION_POLICY = extern struct {
    Version: u32,
    Identity: WINBIO_IDENTITY,
    DatabaseId: Guid,
    UserState: u64,
    PolicySize: usize,
    Policy: [128]u8,
};

pub const WINBIO_GESTURE_METADATA = extern struct {
    Size: usize,
    BiometricType: u32,
    MatchType: u32,
    ProtectionType: u32,
};

pub const WINBIO_ASYNC_NOTIFICATION_METHOD = enum(i32) {
    NONE = 0,
    CALLBACK = 1,
    MESSAGE = 2,
    MAXIMUM_VALUE = 3,
};
pub const WINBIO_ASYNC_NOTIFY_NONE = WINBIO_ASYNC_NOTIFICATION_METHOD.NONE;
pub const WINBIO_ASYNC_NOTIFY_CALLBACK = WINBIO_ASYNC_NOTIFICATION_METHOD.CALLBACK;
pub const WINBIO_ASYNC_NOTIFY_MESSAGE = WINBIO_ASYNC_NOTIFICATION_METHOD.MESSAGE;
pub const WINBIO_ASYNC_NOTIFY_MAXIMUM_VALUE = WINBIO_ASYNC_NOTIFICATION_METHOD.MAXIMUM_VALUE;

pub const WINBIO_ASYNC_RESULT = extern struct {
    SessionHandle: u32,
    Operation: u32,
    SequenceNumber: u64,
    TimeStamp: i64,
    ApiStatus: HRESULT,
    UnitId: u32,
    UserData: ?*anyopaque,
    Parameters: extern union {
        Verify: extern struct {
            Match: BOOLEAN,
            RejectDetail: u32,
        },
        Identify: extern struct {
            Identity: WINBIO_IDENTITY,
            SubFactor: u8,
            RejectDetail: u32,
        },
        EnrollBegin: extern struct {
            SubFactor: u8,
        },
        EnrollCapture: extern struct {
            RejectDetail: u32,
        },
        EnrollCommit: extern struct {
            Identity: WINBIO_IDENTITY,
            IsNewTemplate: BOOLEAN,
        },
        EnumEnrollments: extern struct {
            Identity: WINBIO_IDENTITY,
            SubFactorCount: usize,
            SubFactorArray: ?*u8,
        },
        CaptureSample: extern struct {
            Sample: ?*WINBIO_BIR,
            SampleSize: usize,
            RejectDetail: u32,
        },
        DeleteTemplate: extern struct {
            Identity: WINBIO_IDENTITY,
            SubFactor: u8,
        },
        GetProperty: extern struct {
            PropertyType: u32,
            PropertyId: u32,
            Identity: WINBIO_IDENTITY,
            SubFactor: u8,
            PropertyBufferSize: usize,
            PropertyBuffer: ?*anyopaque,
        },
        SetProperty: extern struct {
            PropertyType: u32,
            PropertyId: u32,
            Identity: WINBIO_IDENTITY,
            SubFactor: u8,
            PropertyBufferSize: usize,
            PropertyBuffer: ?*anyopaque,
        },
        GetEvent: extern struct {
            Event: WINBIO_EVENT,
        },
        ControlUnit: extern struct {
            Component: WINBIO_COMPONENT,
            ControlCode: u32,
            OperationStatus: u32,
            SendBuffer: ?*u8,
            SendBufferSize: usize,
            ReceiveBuffer: ?*u8,
            ReceiveBufferSize: usize,
            ReceiveDataSize: usize,
        },
        EnumServiceProviders: extern struct {
            BspCount: usize,
            BspSchemaArray: ?*WINBIO_BSP_SCHEMA,
        },
        EnumBiometricUnits: extern struct {
            UnitCount: usize,
            UnitSchemaArray: ?*WINBIO_UNIT_SCHEMA,
        },
        EnumDatabases: extern struct {
            StorageCount: usize,
            StorageSchemaArray: ?*WINBIO_STORAGE_SCHEMA,
        },
        VerifyAndReleaseTicket: extern struct {
            Match: BOOLEAN,
            RejectDetail: u32,
            Ticket: u64,
        },
        IdentifyAndReleaseTicket: extern struct {
            Identity: WINBIO_IDENTITY,
            SubFactor: u8,
            RejectDetail: u32,
            Ticket: u64,
        },
        EnrollSelect: extern struct {
            SelectorValue: u64,
        },
        MonitorPresence: extern struct {
            ChangeType: u32,
            PresenceCount: usize,
            PresenceArray: ?*WINBIO_PRESENCE,
        },
        GetProtectionPolicy: extern struct {
            Identity: WINBIO_IDENTITY,
            Policy: WINBIO_PROTECTION_POLICY,
        },
        NotifyUnitStatusChange: extern struct {
            ExtendedStatus: WINBIO_EXTENDED_UNIT_STATUS,
        },
    },
};

pub const PWINBIO_ASYNC_COMPLETION_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        AsyncResult: ?*WINBIO_ASYNC_RESULT,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        AsyncResult: ?*WINBIO_ASYNC_RESULT,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PWINBIO_VERIFY_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        VerifyCallbackContext: ?*anyopaque,
        OperationStatus: HRESULT,
        UnitId: u32,
        Match: BOOLEAN,
        RejectDetail: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        VerifyCallbackContext: ?*anyopaque,
        OperationStatus: HRESULT,
        UnitId: u32,
        Match: BOOLEAN,
        RejectDetail: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PWINBIO_IDENTIFY_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        IdentifyCallbackContext: ?*anyopaque,
        OperationStatus: HRESULT,
        UnitId: u32,
        Identity: ?*WINBIO_IDENTITY,
        SubFactor: u8,
        RejectDetail: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        IdentifyCallbackContext: ?*anyopaque,
        OperationStatus: HRESULT,
        UnitId: u32,
        Identity: ?*WINBIO_IDENTITY,
        SubFactor: u8,
        RejectDetail: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PWINBIO_LOCATE_SENSOR_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        LocateCallbackContext: ?*anyopaque,
        OperationStatus: HRESULT,
        UnitId: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        LocateCallbackContext: ?*anyopaque,
        OperationStatus: HRESULT,
        UnitId: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PWINBIO_ENROLL_CAPTURE_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        EnrollCallbackContext: ?*anyopaque,
        OperationStatus: HRESULT,
        RejectDetail: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        EnrollCallbackContext: ?*anyopaque,
        OperationStatus: HRESULT,
        RejectDetail: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PWINBIO_EVENT_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        EventCallbackContext: ?*anyopaque,
        OperationStatus: HRESULT,
        Event: ?*WINBIO_EVENT,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        EventCallbackContext: ?*anyopaque,
        OperationStatus: HRESULT,
        Event: ?*WINBIO_EVENT,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const PWINBIO_CAPTURE_CALLBACK = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        CaptureCallbackContext: ?*anyopaque,
        OperationStatus: HRESULT,
        UnitId: u32,
        // TODO: what to do with BytesParamIndex 4?
        Sample: ?*WINBIO_BIR,
        SampleSize: usize,
        RejectDetail: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn (
        CaptureCallbackContext: ?*anyopaque,
        OperationStatus: HRESULT,
        UnitId: u32,
        // TODO: what to do with BytesParamIndex 4?
        Sample: ?*WINBIO_BIR,
        SampleSize: usize,
        RejectDetail: u32,
    ) callconv(@import("std").os.windows.WINAPI) void,
};

pub const _WINIBIO_SENSOR_CONTEXT = extern struct {
    placeholder: usize, // TODO: why is this type empty?
};

pub const _WINIBIO_ENGINE_CONTEXT = extern struct {
    placeholder: usize, // TODO: why is this type empty?
};

pub const _WINIBIO_STORAGE_CONTEXT = extern struct {
    placeholder: usize, // TODO: why is this type empty?
};

pub const WINBIO_STORAGE_RECORD = extern struct {
    Identity: ?*WINBIO_IDENTITY,
    SubFactor: u8,
    IndexVector: ?*u32,
    IndexElementCount: usize,
    TemplateBlob: ?*u8,
    TemplateBlobSize: usize,
    PayloadBlob: ?*u8,
    PayloadBlobSize: usize,
};

pub const WINBIO_PIPELINE = extern struct {
    SensorHandle: ?HANDLE,
    EngineHandle: ?HANDLE,
    StorageHandle: ?HANDLE,
    SensorInterface: ?*WINBIO_SENSOR_INTERFACE,
    EngineInterface: ?*WINBIO_ENGINE_INTERFACE,
    StorageInterface: ?*WINBIO_STORAGE_INTERFACE,
    SensorContext: ?*_WINIBIO_SENSOR_CONTEXT,
    EngineContext: ?*_WINIBIO_ENGINE_CONTEXT,
    StorageContext: ?*_WINIBIO_STORAGE_CONTEXT,
    FrameworkInterface: ?*WINBIO_FRAMEWORK_INTERFACE,
};

pub const WINBIO_ADAPTER_INTERFACE_VERSION = extern struct {
    MajorVersion: u16,
    MinorVersion: u16,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_ATTACH_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_DETACH_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_CLEAR_CONTEXT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_QUERY_STATUS_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_RESET_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_SET_MODE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_SET_INDICATOR_STATUS_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_GET_INDICATOR_STATUS_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_START_CAPTURE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_FINISH_CAPTURE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_EXPORT_SENSOR_DATA_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_CANCEL_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_PUSH_DATA_TO_ENGINE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_CONTROL_UNIT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_CONTROL_UNIT_PRIVILEGED_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_NOTIFY_POWER_CHANGE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_PIPELINE_INIT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_PIPELINE_CLEANUP_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_ACTIVATE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_DEACTIVATE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_QUERY_EXTENDED_INFO_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_QUERY_CALIBRATION_FORMATS_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_SET_CALIBRATION_FORMAT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_ACCEPT_CALIBRATION_DATA_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_ASYNC_IMPORT_RAW_BUFFER_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_ASYNC_IMPORT_SECURE_BUFFER_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_QUERY_PRIVATE_SENSOR_TYPE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_CONNECT_SECURE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_START_CAPTURE_EX_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_START_NOTIFY_WAKE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_SENSOR_FINISH_NOTIFY_WAKE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

pub const WINBIO_SENSOR_INTERFACE = extern struct {
    Version: WINBIO_ADAPTER_INTERFACE_VERSION,
    Type: u32,
    Size: usize,
    AdapterId: Guid,
    Attach: ?PIBIO_SENSOR_ATTACH_FN,
    Detach: ?PIBIO_SENSOR_DETACH_FN,
    ClearContext: ?PIBIO_SENSOR_CLEAR_CONTEXT_FN,
    QueryStatus: ?PIBIO_SENSOR_QUERY_STATUS_FN,
    Reset: ?PIBIO_SENSOR_RESET_FN,
    SetMode: ?PIBIO_SENSOR_SET_MODE_FN,
    SetIndicatorStatus: ?PIBIO_SENSOR_SET_INDICATOR_STATUS_FN,
    GetIndicatorStatus: ?PIBIO_SENSOR_GET_INDICATOR_STATUS_FN,
    StartCapture: ?PIBIO_SENSOR_START_CAPTURE_FN,
    FinishCapture: ?PIBIO_SENSOR_FINISH_CAPTURE_FN,
    ExportSensorData: ?PIBIO_SENSOR_EXPORT_SENSOR_DATA_FN,
    Cancel: ?PIBIO_SENSOR_CANCEL_FN,
    PushDataToEngine: ?PIBIO_SENSOR_PUSH_DATA_TO_ENGINE_FN,
    ControlUnit: ?PIBIO_SENSOR_CONTROL_UNIT_FN,
    ControlUnitPrivileged: ?PIBIO_SENSOR_CONTROL_UNIT_PRIVILEGED_FN,
    NotifyPowerChange: ?PIBIO_SENSOR_NOTIFY_POWER_CHANGE_FN,
    PipelineInit: ?PIBIO_SENSOR_PIPELINE_INIT_FN,
    PipelineCleanup: ?PIBIO_SENSOR_PIPELINE_CLEANUP_FN,
    Activate: ?PIBIO_SENSOR_ACTIVATE_FN,
    Deactivate: ?PIBIO_SENSOR_DEACTIVATE_FN,
    QueryExtendedInfo: ?PIBIO_SENSOR_QUERY_EXTENDED_INFO_FN,
    QueryCalibrationFormats: ?PIBIO_SENSOR_QUERY_CALIBRATION_FORMATS_FN,
    SetCalibrationFormat: ?PIBIO_SENSOR_SET_CALIBRATION_FORMAT_FN,
    AcceptCalibrationData: ?PIBIO_SENSOR_ACCEPT_CALIBRATION_DATA_FN,
    AsyncImportRawBuffer: ?PIBIO_SENSOR_ASYNC_IMPORT_RAW_BUFFER_FN,
    AsyncImportSecureBuffer: ?PIBIO_SENSOR_ASYNC_IMPORT_SECURE_BUFFER_FN,
    QueryPrivateSensorType: ?PIBIO_SENSOR_QUERY_PRIVATE_SENSOR_TYPE_FN,
    ConnectSecure: ?PIBIO_SENSOR_CONNECT_SECURE_FN,
    StartCaptureEx: ?PIBIO_SENSOR_START_CAPTURE_EX_FN,
    StartNotifyWake: ?PIBIO_SENSOR_START_NOTIFY_WAKE_FN,
    FinishNotifyWake: ?PIBIO_SENSOR_FINISH_NOTIFY_WAKE_FN,
};

pub const PWINBIO_QUERY_SENSOR_INTERFACE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        SensorInterface: ?*?*WINBIO_SENSOR_INTERFACE,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        SensorInterface: ?*?*WINBIO_SENSOR_INTERFACE,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_ATTACH_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_DETACH_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_CLEAR_CONTEXT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_QUERY_PREFERRED_FORMAT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_QUERY_INDEX_VECTOR_SIZE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_QUERY_HASH_ALGORITHMS_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_SET_HASH_ALGORITHM_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_QUERY_SAMPLE_HINT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_ACCEPT_SAMPLE_DATA_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_EXPORT_ENGINE_DATA_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_VERIFY_FEATURE_SET_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_IDENTIFY_FEATURE_SET_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_CREATE_ENROLLMENT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_UPDATE_ENROLLMENT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_GET_ENROLLMENT_STATUS_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_GET_ENROLLMENT_HASH_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_CHECK_FOR_DUPLICATE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_COMMIT_ENROLLMENT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_DISCARD_ENROLLMENT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_CONTROL_UNIT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_CONTROL_UNIT_PRIVILEGED_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_NOTIFY_POWER_CHANGE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_RESERVED_1_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_PIPELINE_INIT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_PIPELINE_CLEANUP_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_ACTIVATE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_DEACTIVATE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_QUERY_EXTENDED_INFO_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_IDENTIFY_ALL_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_SET_ENROLLMENT_SELECTOR_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_SET_ENROLLMENT_PARAMETERS_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_QUERY_EXTENDED_ENROLLMENT_STATUS_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_REFRESH_CACHE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_SELECT_CALIBRATION_FORMAT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_QUERY_CALIBRATION_DATA_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_SET_ACCOUNT_POLICY_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_CREATE_KEY_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_IDENTIFY_FEATURE_SET_SECURE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_ACCEPT_PRIVATE_SENSOR_TYPE_INFO_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_CREATE_ENROLLMENT_AUTHENTICATED_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_ENGINE_IDENTIFY_FEATURE_SET_AUTHENTICATED_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

pub const WINBIO_ENGINE_INTERFACE = extern struct {
    Version: WINBIO_ADAPTER_INTERFACE_VERSION,
    Type: u32,
    Size: usize,
    AdapterId: Guid,
    Attach: ?PIBIO_ENGINE_ATTACH_FN,
    Detach: ?PIBIO_ENGINE_DETACH_FN,
    ClearContext: ?PIBIO_ENGINE_CLEAR_CONTEXT_FN,
    QueryPreferredFormat: ?PIBIO_ENGINE_QUERY_PREFERRED_FORMAT_FN,
    QueryIndexVectorSize: ?PIBIO_ENGINE_QUERY_INDEX_VECTOR_SIZE_FN,
    QueryHashAlgorithms: ?PIBIO_ENGINE_QUERY_HASH_ALGORITHMS_FN,
    SetHashAlgorithm: ?PIBIO_ENGINE_SET_HASH_ALGORITHM_FN,
    QuerySampleHint: ?PIBIO_ENGINE_QUERY_SAMPLE_HINT_FN,
    AcceptSampleData: ?PIBIO_ENGINE_ACCEPT_SAMPLE_DATA_FN,
    ExportEngineData: ?PIBIO_ENGINE_EXPORT_ENGINE_DATA_FN,
    VerifyFeatureSet: ?PIBIO_ENGINE_VERIFY_FEATURE_SET_FN,
    IdentifyFeatureSet: ?PIBIO_ENGINE_IDENTIFY_FEATURE_SET_FN,
    CreateEnrollment: ?PIBIO_ENGINE_CREATE_ENROLLMENT_FN,
    UpdateEnrollment: ?PIBIO_ENGINE_UPDATE_ENROLLMENT_FN,
    GetEnrollmentStatus: ?PIBIO_ENGINE_GET_ENROLLMENT_STATUS_FN,
    GetEnrollmentHash: ?PIBIO_ENGINE_GET_ENROLLMENT_HASH_FN,
    CheckForDuplicate: ?PIBIO_ENGINE_CHECK_FOR_DUPLICATE_FN,
    CommitEnrollment: ?PIBIO_ENGINE_COMMIT_ENROLLMENT_FN,
    DiscardEnrollment: ?PIBIO_ENGINE_DISCARD_ENROLLMENT_FN,
    ControlUnit: ?PIBIO_ENGINE_CONTROL_UNIT_FN,
    ControlUnitPrivileged: ?PIBIO_ENGINE_CONTROL_UNIT_PRIVILEGED_FN,
    NotifyPowerChange: ?PIBIO_ENGINE_NOTIFY_POWER_CHANGE_FN,
    Reserved_1: ?PIBIO_ENGINE_RESERVED_1_FN,
    PipelineInit: ?PIBIO_ENGINE_PIPELINE_INIT_FN,
    PipelineCleanup: ?PIBIO_ENGINE_PIPELINE_CLEANUP_FN,
    Activate: ?PIBIO_ENGINE_ACTIVATE_FN,
    Deactivate: ?PIBIO_ENGINE_DEACTIVATE_FN,
    QueryExtendedInfo: ?PIBIO_ENGINE_QUERY_EXTENDED_INFO_FN,
    IdentifyAll: ?PIBIO_ENGINE_IDENTIFY_ALL_FN,
    SetEnrollmentSelector: ?PIBIO_ENGINE_SET_ENROLLMENT_SELECTOR_FN,
    SetEnrollmentParameters: ?PIBIO_ENGINE_SET_ENROLLMENT_PARAMETERS_FN,
    QueryExtendedEnrollmentStatus: ?PIBIO_ENGINE_QUERY_EXTENDED_ENROLLMENT_STATUS_FN,
    RefreshCache: ?PIBIO_ENGINE_REFRESH_CACHE_FN,
    SelectCalibrationFormat: ?PIBIO_ENGINE_SELECT_CALIBRATION_FORMAT_FN,
    QueryCalibrationData: ?PIBIO_ENGINE_QUERY_CALIBRATION_DATA_FN,
    SetAccountPolicy: ?PIBIO_ENGINE_SET_ACCOUNT_POLICY_FN,
    CreateKey: ?PIBIO_ENGINE_CREATE_KEY_FN,
    IdentifyFeatureSetSecure: ?PIBIO_ENGINE_IDENTIFY_FEATURE_SET_SECURE_FN,
    AcceptPrivateSensorTypeInfo: ?PIBIO_ENGINE_ACCEPT_PRIVATE_SENSOR_TYPE_INFO_FN,
    CreateEnrollmentAuthenticated: ?PIBIO_ENGINE_CREATE_ENROLLMENT_AUTHENTICATED_FN,
    IdentifyFeatureSetAuthenticated: ?PIBIO_ENGINE_IDENTIFY_FEATURE_SET_AUTHENTICATED_FN,
};

pub const PWINBIO_QUERY_ENGINE_INTERFACE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        EngineInterface: ?*?*WINBIO_ENGINE_INTERFACE,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        EngineInterface: ?*?*WINBIO_ENGINE_INTERFACE,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_ATTACH_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_DETACH_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_CLEAR_CONTEXT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_CREATE_DATABASE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_ERASE_DATABASE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_OPEN_DATABASE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_CLOSE_DATABASE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_GET_DATA_FORMAT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_GET_DATABASE_SIZE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_ADD_RECORD_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_DELETE_RECORD_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_QUERY_BY_SUBJECT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_QUERY_BY_CONTENT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_GET_RECORD_COUNT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_FIRST_RECORD_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_NEXT_RECORD_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_GET_CURRENT_RECORD_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_CONTROL_UNIT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_CONTROL_UNIT_PRIVILEGED_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_NOTIFY_POWER_CHANGE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_PIPELINE_INIT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_PIPELINE_CLEANUP_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_ACTIVATE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_DEACTIVATE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_QUERY_EXTENDED_INFO_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_NOTIFY_DATABASE_CHANGE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_RESERVED_1_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_RESERVED_2_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_UPDATE_RECORD_BEGIN_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_STORAGE_UPDATE_RECORD_COMMIT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

pub const WINBIO_STORAGE_INTERFACE = extern struct {
    Version: WINBIO_ADAPTER_INTERFACE_VERSION,
    Type: u32,
    Size: usize,
    AdapterId: Guid,
    Attach: ?PIBIO_STORAGE_ATTACH_FN,
    Detach: ?PIBIO_STORAGE_DETACH_FN,
    ClearContext: ?PIBIO_STORAGE_CLEAR_CONTEXT_FN,
    CreateDatabase: ?PIBIO_STORAGE_CREATE_DATABASE_FN,
    EraseDatabase: ?PIBIO_STORAGE_ERASE_DATABASE_FN,
    OpenDatabase: ?PIBIO_STORAGE_OPEN_DATABASE_FN,
    CloseDatabase: ?PIBIO_STORAGE_CLOSE_DATABASE_FN,
    GetDataFormat: ?PIBIO_STORAGE_GET_DATA_FORMAT_FN,
    GetDatabaseSize: ?PIBIO_STORAGE_GET_DATABASE_SIZE_FN,
    AddRecord: ?PIBIO_STORAGE_ADD_RECORD_FN,
    DeleteRecord: ?PIBIO_STORAGE_DELETE_RECORD_FN,
    QueryBySubject: ?PIBIO_STORAGE_QUERY_BY_SUBJECT_FN,
    QueryByContent: ?PIBIO_STORAGE_QUERY_BY_CONTENT_FN,
    GetRecordCount: ?PIBIO_STORAGE_GET_RECORD_COUNT_FN,
    FirstRecord: ?PIBIO_STORAGE_FIRST_RECORD_FN,
    NextRecord: ?PIBIO_STORAGE_NEXT_RECORD_FN,
    GetCurrentRecord: ?PIBIO_STORAGE_GET_CURRENT_RECORD_FN,
    ControlUnit: ?PIBIO_STORAGE_CONTROL_UNIT_FN,
    ControlUnitPrivileged: ?PIBIO_STORAGE_CONTROL_UNIT_PRIVILEGED_FN,
    NotifyPowerChange: ?PIBIO_STORAGE_NOTIFY_POWER_CHANGE_FN,
    PipelineInit: ?PIBIO_STORAGE_PIPELINE_INIT_FN,
    PipelineCleanup: ?PIBIO_STORAGE_PIPELINE_CLEANUP_FN,
    Activate: ?PIBIO_STORAGE_ACTIVATE_FN,
    Deactivate: ?PIBIO_STORAGE_DEACTIVATE_FN,
    QueryExtendedInfo: ?PIBIO_STORAGE_QUERY_EXTENDED_INFO_FN,
    NotifyDatabaseChange: ?PIBIO_STORAGE_NOTIFY_DATABASE_CHANGE_FN,
    Reserved1: ?PIBIO_STORAGE_RESERVED_1_FN,
    Reserved2: ?PIBIO_STORAGE_RESERVED_2_FN,
    UpdateRecordBegin: ?PIBIO_STORAGE_UPDATE_RECORD_BEGIN_FN,
    UpdateRecordCommit: ?PIBIO_STORAGE_UPDATE_RECORD_COMMIT_FN,
};

pub const PWINBIO_QUERY_STORAGE_INTERFACE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn (
        StorageInterface: ?*?*WINBIO_STORAGE_INTERFACE,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
    else => *const fn (
        StorageInterface: ?*?*WINBIO_STORAGE_INTERFACE,
    ) callconv(@import("std").os.windows.WINAPI) HRESULT,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_SET_UNIT_STATUS_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_VSM_CACHE_CLEAR_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_VSM_CACHE_IMPORT_BEGIN_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_VSM_CACHE_IMPORT_NEXT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_VSM_CACHE_IMPORT_END_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_VSM_CACHE_EXPORT_BEGIN_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_VSM_CACHE_EXPORT_NEXT_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_VSM_CACHE_EXPORT_END_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_VSM_STORAGE_RESERVED_1_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_VSM_STORAGE_RESERVED_2_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_VSM_STORAGE_RESERVED_3_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_ALLOCATE_MEMORY_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_FREE_MEMORY_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_GET_PROPERTY_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_LOCK_AND_VALIDATE_SECURE_BUFFER_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_RELEASE_SECURE_BUFFER_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_VSM_QUERY_AUTHORIZED_ENROLLMENTS_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

// TODO: this function pointer causes dependency loop problems, so it's stubbed out
pub const PIBIO_FRAMEWORK_VSM_DECRYPT_SAMPLE_FN = switch (@import("builtin").zig_backend) {
    .stage1 => fn () callconv(@import("std").os.windows.WINAPI) void,
    else => *const fn () callconv(@import("std").os.windows.WINAPI) void,
};

pub const WINBIO_FRAMEWORK_INTERFACE = extern struct {
    Version: WINBIO_ADAPTER_INTERFACE_VERSION,
    Type: u32,
    Size: usize,
    AdapterId: Guid,
    SetUnitStatus: ?PIBIO_FRAMEWORK_SET_UNIT_STATUS_FN,
    VsmStorageAttach: ?PIBIO_STORAGE_ATTACH_FN,
    VsmStorageDetach: ?PIBIO_STORAGE_DETACH_FN,
    VsmStorageClearContext: ?PIBIO_STORAGE_CLEAR_CONTEXT_FN,
    VsmStorageCreateDatabase: ?PIBIO_STORAGE_CREATE_DATABASE_FN,
    VsmStorageOpenDatabase: ?PIBIO_STORAGE_OPEN_DATABASE_FN,
    VsmStorageCloseDatabase: ?PIBIO_STORAGE_CLOSE_DATABASE_FN,
    VsmStorageDeleteRecord: ?PIBIO_STORAGE_DELETE_RECORD_FN,
    VsmStorageNotifyPowerChange: ?PIBIO_STORAGE_NOTIFY_POWER_CHANGE_FN,
    VsmStoragePipelineInit: ?PIBIO_STORAGE_PIPELINE_INIT_FN,
    VsmStoragePipelineCleanup: ?PIBIO_STORAGE_PIPELINE_CLEANUP_FN,
    VsmStorageActivate: ?PIBIO_STORAGE_ACTIVATE_FN,
    VsmStorageDeactivate: ?PIBIO_STORAGE_DEACTIVATE_FN,
    VsmStorageQueryExtendedInfo: ?PIBIO_STORAGE_QUERY_EXTENDED_INFO_FN,
    VsmStorageCacheClear: ?PIBIO_FRAMEWORK_VSM_CACHE_CLEAR_FN,
    VsmStorageCacheImportBegin: ?PIBIO_FRAMEWORK_VSM_CACHE_IMPORT_BEGIN_FN,
    VsmStorageCacheImportNext: ?PIBIO_FRAMEWORK_VSM_CACHE_IMPORT_NEXT_FN,
    VsmStorageCacheImportEnd: ?PIBIO_FRAMEWORK_VSM_CACHE_IMPORT_END_FN,
    VsmStorageCacheExportBegin: ?PIBIO_FRAMEWORK_VSM_CACHE_EXPORT_BEGIN_FN,
    VsmStorageCacheExportNext: ?PIBIO_FRAMEWORK_VSM_CACHE_EXPORT_NEXT_FN,
    VsmStorageCacheExportEnd: ?PIBIO_FRAMEWORK_VSM_CACHE_EXPORT_END_FN,
    VsmSensorAttach: ?PIBIO_SENSOR_ATTACH_FN,
    VsmSensorDetach: ?PIBIO_SENSOR_DETACH_FN,
    VsmSensorClearContext: ?PIBIO_SENSOR_CLEAR_CONTEXT_FN,
    VsmSensorPushDataToEngine: ?PIBIO_SENSOR_PUSH_DATA_TO_ENGINE_FN,
    VsmSensorNotifyPowerChange: ?PIBIO_SENSOR_NOTIFY_POWER_CHANGE_FN,
    VsmSensorPipelineInit: ?PIBIO_SENSOR_PIPELINE_INIT_FN,
    VsmSensorPipelineCleanup: ?PIBIO_SENSOR_PIPELINE_CLEANUP_FN,
    VsmSensorActivate: ?PIBIO_SENSOR_ACTIVATE_FN,
    VsmSensorDeactivate: ?PIBIO_SENSOR_DEACTIVATE_FN,
    VsmSensorAsyncImportRawBuffer: ?PIBIO_SENSOR_ASYNC_IMPORT_RAW_BUFFER_FN,
    VsmSensorAsyncImportSecureBuffer: ?PIBIO_SENSOR_ASYNC_IMPORT_SECURE_BUFFER_FN,
    Reserved1: ?PIBIO_FRAMEWORK_VSM_STORAGE_RESERVED_1_FN,
    Reserved2: ?PIBIO_FRAMEWORK_VSM_STORAGE_RESERVED_2_FN,
    Reserved3: ?PIBIO_FRAMEWORK_VSM_STORAGE_RESERVED_3_FN,
    Reserved4: ?PIBIO_STORAGE_RESERVED_1_FN,
    Reserved5: ?PIBIO_STORAGE_RESERVED_2_FN,
    AllocateMemory: ?PIBIO_FRAMEWORK_ALLOCATE_MEMORY_FN,
    FreeMemory: ?PIBIO_FRAMEWORK_FREE_MEMORY_FN,
    GetProperty: ?PIBIO_FRAMEWORK_GET_PROPERTY_FN,
    LockAndValidateSecureBuffer: ?PIBIO_FRAMEWORK_LOCK_AND_VALIDATE_SECURE_BUFFER_FN,
    ReleaseSecureBuffer: ?PIBIO_FRAMEWORK_RELEASE_SECURE_BUFFER_FN,
    QueryAuthorizedEnrollments: ?PIBIO_FRAMEWORK_VSM_QUERY_AUTHORIZED_ENROLLMENTS_FN,
    DecryptSample: ?PIBIO_FRAMEWORK_VSM_DECRYPT_SAMPLE_FN,
};

pub const WINBIO_SENSOR_ATTRIBUTES = extern struct {
    PayloadSize: u32,
    WinBioHresult: HRESULT,
    WinBioVersion: WINBIO_VERSION,
    SensorType: u32,
    SensorSubType: u32,
    Capabilities: u32,
    ManufacturerName: [256]u16,
    ModelName: [256]u16,
    SerialNumber: [256]u16,
    FirmwareVersion: WINBIO_VERSION,
    SupportedFormatEntries: u32,
    SupportedFormat: [1]WINBIO_REGISTERED_FORMAT,
};

pub const WINBIO_DATA = extern struct {
    Size: u32,
    Data: [1]u8,
};

pub const WINBIO_UPDATE_FIRMWARE = extern struct {
    PayloadSize: u32,
    FirmwareData: WINBIO_DATA,
};

pub const WINBIO_CALIBRATION_INFO = extern struct {
    PayloadSize: u32,
    WinBioHresult: HRESULT,
    CalibrationData: WINBIO_DATA,
};

pub const WINBIO_DIAGNOSTICS = extern struct {
    PayloadSize: u32,
    WinBioHresult: HRESULT,
    SensorStatus: u32,
    VendorDiagnostics: WINBIO_DATA,
};

pub const WINBIO_BLANK_PAYLOAD = extern struct {
    PayloadSize: u32,
    WinBioHresult: HRESULT,
};

pub const WINBIO_CAPTURE_PARAMETERS = extern struct {
    PayloadSize: u32,
    Purpose: u8,
    Format: WINBIO_REGISTERED_FORMAT,
    VendorFormat: Guid,
    Flags: u8,
};

pub const WINBIO_CAPTURE_DATA = extern struct {
    PayloadSize: u32,
    WinBioHresult: HRESULT,
    SensorStatus: u32,
    RejectDetail: u32,
    CaptureData: WINBIO_DATA,
};

pub const WINBIO_SUPPORTED_ALGORITHMS = extern struct {
    PayloadSize: u32,
    WinBioHresult: HRESULT,
    NumberOfAlgorithms: u32,
    AlgorithmData: WINBIO_DATA,
};

pub const WINBIO_GET_INDICATOR = extern struct {
    PayloadSize: u32,
    WinBioHresult: HRESULT,
    IndicatorStatus: u32,
};

pub const WINBIO_SET_INDICATOR = extern struct {
    PayloadSize: u32,
    IndicatorStatus: u32,
};

pub const WINBIO_PRIVATE_SENSOR_TYPE_INFO = extern struct {
    PayloadSize: u32,
    WinBioHresult: HRESULT,
    PrivateSensorTypeInfo: WINBIO_DATA,
};

pub const WINBIO_ENCRYPTED_CAPTURE_PARAMS = extern struct {
    PayloadSize: u32,
    Purpose: u8,
    Format: WINBIO_REGISTERED_FORMAT,
    VendorFormat: Guid,
    Flags: u8,
    NonceSize: u32,
};

pub const WINBIO_NOTIFY_WAKE = extern struct {
    PayloadSize: u32,
    WinBioHresult: HRESULT,
    Reason: u32,
};

//--------------------------------------------------------------------------------
// Section: Functions (54)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioEnumServiceProviders(
    Factor: u32,
    BspSchemaArray: ?*?*WINBIO_BSP_SCHEMA,
    BspCount: ?*usize,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioEnumBiometricUnits(
    Factor: u32,
    UnitSchemaArray: ?*?*WINBIO_UNIT_SCHEMA,
    UnitCount: ?*usize,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioEnumDatabases(
    Factor: u32,
    StorageSchemaArray: ?*?*WINBIO_STORAGE_SCHEMA,
    StorageCount: ?*usize,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows8.0'
pub extern "winbio" fn WinBioAsyncOpenFramework(
    NotificationMethod: WINBIO_ASYNC_NOTIFICATION_METHOD,
    TargetWindow: ?HWND,
    MessageCode: u32,
    CallbackRoutine: ?PWINBIO_ASYNC_COMPLETION_CALLBACK,
    UserData: ?*anyopaque,
    AsynchronousOpen: BOOL,
    FrameworkHandle: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows8.0'
pub extern "winbio" fn WinBioCloseFramework(
    FrameworkHandle: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows8.0'
pub extern "winbio" fn WinBioAsyncEnumServiceProviders(
    FrameworkHandle: u32,
    Factor: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows8.0'
pub extern "winbio" fn WinBioAsyncEnumBiometricUnits(
    FrameworkHandle: u32,
    Factor: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows8.0'
pub extern "winbio" fn WinBioAsyncEnumDatabases(
    FrameworkHandle: u32,
    Factor: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows8.0'
pub extern "winbio" fn WinBioAsyncMonitorFrameworkChanges(
    FrameworkHandle: u32,
    ChangeTypes: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioOpenSession(
    Factor: u32,
    PoolType: WINBIO_POOL,
    Flags: u32,
    UnitArray: ?[*]u32,
    UnitCount: usize,
    DatabaseId: ?*Guid,
    SessionHandle: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows8.0'
pub extern "winbio" fn WinBioAsyncOpenSession(
    Factor: u32,
    PoolType: WINBIO_POOL,
    Flags: u32,
    UnitArray: ?[*]u32,
    UnitCount: usize,
    DatabaseId: ?*Guid,
    NotificationMethod: WINBIO_ASYNC_NOTIFICATION_METHOD,
    TargetWindow: ?HWND,
    MessageCode: u32,
    CallbackRoutine: ?PWINBIO_ASYNC_COMPLETION_CALLBACK,
    UserData: ?*anyopaque,
    AsynchronousOpen: BOOL,
    SessionHandle: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioCloseSession(
    SessionHandle: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioVerify(
    SessionHandle: u32,
    Identity: ?*WINBIO_IDENTITY,
    SubFactor: u8,
    UnitId: ?*u32,
    Match: ?*u8,
    RejectDetail: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioVerifyWithCallback(
    SessionHandle: u32,
    Identity: ?*WINBIO_IDENTITY,
    SubFactor: u8,
    VerifyCallback: ?PWINBIO_VERIFY_CALLBACK,
    VerifyCallbackContext: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioIdentify(
    SessionHandle: u32,
    UnitId: ?*u32,
    Identity: ?*WINBIO_IDENTITY,
    SubFactor: ?*u8,
    RejectDetail: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioIdentifyWithCallback(
    SessionHandle: u32,
    IdentifyCallback: ?PWINBIO_IDENTIFY_CALLBACK,
    IdentifyCallbackContext: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioWait(
    SessionHandle: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioCancel(
    SessionHandle: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioLocateSensor(
    SessionHandle: u32,
    UnitId: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioLocateSensorWithCallback(
    SessionHandle: u32,
    LocateCallback: ?PWINBIO_LOCATE_SENSOR_CALLBACK,
    LocateCallbackContext: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioEnrollBegin(
    SessionHandle: u32,
    SubFactor: u8,
    UnitId: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "winbio" fn WinBioEnrollSelect(
    SessionHandle: u32,
    SelectorValue: u64,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioEnrollCapture(
    SessionHandle: u32,
    RejectDetail: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioEnrollCaptureWithCallback(
    SessionHandle: u32,
    EnrollCallback: ?PWINBIO_ENROLL_CAPTURE_CALLBACK,
    EnrollCallbackContext: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioEnrollCommit(
    SessionHandle: u32,
    Identity: ?*WINBIO_IDENTITY,
    IsNewTemplate: ?*u8,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioEnrollDiscard(
    SessionHandle: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioEnumEnrollments(
    SessionHandle: u32,
    UnitId: u32,
    Identity: ?*WINBIO_IDENTITY,
    SubFactorArray: ?*?*u8,
    SubFactorCount: ?*usize,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winbio" fn WinBioImproveBegin(
    SessionHandle: u32,
    UnitId: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "winbio" fn WinBioImproveEnd(
    SessionHandle: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioRegisterEventMonitor(
    SessionHandle: u32,
    EventMask: u32,
    EventCallback: ?PWINBIO_EVENT_CALLBACK,
    EventCallbackContext: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioUnregisterEventMonitor(
    SessionHandle: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "winbio" fn WinBioMonitorPresence(
    SessionHandle: u32,
    UnitId: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioCaptureSample(
    SessionHandle: u32,
    Purpose: u8,
    Flags: u8,
    UnitId: ?*u32,
    Sample: ?*?*WINBIO_BIR,
    SampleSize: ?*usize,
    RejectDetail: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioCaptureSampleWithCallback(
    SessionHandle: u32,
    Purpose: u8,
    Flags: u8,
    CaptureCallback: ?PWINBIO_CAPTURE_CALLBACK,
    CaptureCallbackContext: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioDeleteTemplate(
    SessionHandle: u32,
    UnitId: u32,
    Identity: ?*WINBIO_IDENTITY,
    SubFactor: u8,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioLockUnit(
    SessionHandle: u32,
    UnitId: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioUnlockUnit(
    SessionHandle: u32,
    UnitId: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioControlUnit(
    SessionHandle: u32,
    UnitId: u32,
    Component: WINBIO_COMPONENT,
    ControlCode: u32,
    // TODO: what to do with BytesParamIndex 5?
    SendBuffer: ?*u8,
    SendBufferSize: usize,
    // TODO: what to do with BytesParamIndex 7?
    ReceiveBuffer: ?*u8,
    ReceiveBufferSize: usize,
    ReceiveDataSize: ?*usize,
    OperationStatus: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioControlUnitPrivileged(
    SessionHandle: u32,
    UnitId: u32,
    Component: WINBIO_COMPONENT,
    ControlCode: u32,
    // TODO: what to do with BytesParamIndex 5?
    SendBuffer: ?*u8,
    SendBufferSize: usize,
    // TODO: what to do with BytesParamIndex 7?
    ReceiveBuffer: ?*u8,
    ReceiveBufferSize: usize,
    ReceiveDataSize: ?*usize,
    OperationStatus: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioGetProperty(
    SessionHandle: u32,
    PropertyType: u32,
    PropertyId: u32,
    UnitId: u32,
    Identity: ?*WINBIO_IDENTITY,
    SubFactor: u8,
    PropertyBuffer: ?*?*anyopaque,
    PropertyBufferSize: ?*usize,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "winbio" fn WinBioSetProperty(
    SessionHandle: u32,
    PropertyType: u32,
    PropertyId: u32,
    UnitId: u32,
    Identity: ?*WINBIO_IDENTITY,
    SubFactor: u8,
    // TODO: what to do with BytesParamIndex 7?
    PropertyBuffer: ?*anyopaque,
    PropertyBufferSize: usize,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioFree(
    Address: ?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows8.1'
pub extern "winbio" fn WinBioSetCredential(
    Type: WINBIO_CREDENTIAL_TYPE,
    // TODO: what to do with BytesParamIndex 2?
    Credential: ?*u8,
    CredentialSize: usize,
    Format: WINBIO_CREDENTIAL_FORMAT,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioRemoveCredential(
    Identity: WINBIO_IDENTITY,
    Type: WINBIO_CREDENTIAL_TYPE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioRemoveAllCredentials() callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioRemoveAllDomainCredentials() callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioGetCredentialState(
    Identity: WINBIO_IDENTITY,
    Type: WINBIO_CREDENTIAL_TYPE,
    CredentialState: ?*WINBIO_CREDENTIAL_STATE,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioLogonIdentifiedUser(
    SessionHandle: u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "winbio" fn WinBioGetEnrolledFactors(
    AccountOwner: ?*WINBIO_IDENTITY,
    EnrolledFactors: ?*u32,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioGetEnabledSetting(
    Value: ?*u8,
    Source: ?*WINBIO_SETTING_SOURCE,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioGetLogonSetting(
    Value: ?*u8,
    Source: ?*WINBIO_SETTING_SOURCE,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioGetDomainLogonSetting(
    Value: ?*u8,
    Source: ?*WINBIO_SETTING_SOURCE,
) callconv(@import("std").os.windows.WINAPI) void;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioAcquireFocus() callconv(@import("std").os.windows.WINAPI) HRESULT;

// TODO: this type is limited to platform 'windows6.1'
pub extern "winbio" fn WinBioReleaseFocus() callconv(@import("std").os.windows.WINAPI) HRESULT;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (9)
//--------------------------------------------------------------------------------
const Guid = @import("../zig.zig").Guid;
const BOOL = @import("../foundation.zig").BOOL;
const BOOLEAN = @import("../foundation.zig").BOOLEAN;
const HANDLE = @import("../foundation.zig").HANDLE;
const HRESULT = @import("../foundation.zig").HRESULT;
const HWND = @import("../foundation.zig").HWND;
const LARGE_INTEGER = @import("../foundation.zig").LARGE_INTEGER;
const POINT = @import("../foundation.zig").POINT;
const RECT = @import("../foundation.zig").RECT;

test {
    // The following '_ = <FuncPtrType>' lines are a workaround for https://github.com/ziglang/zig/issues/4476
    if (@hasDecl(@This(), "PWINBIO_ASYNC_COMPLETION_CALLBACK")) {
        _ = PWINBIO_ASYNC_COMPLETION_CALLBACK;
    }
    if (@hasDecl(@This(), "PWINBIO_VERIFY_CALLBACK")) {
        _ = PWINBIO_VERIFY_CALLBACK;
    }
    if (@hasDecl(@This(), "PWINBIO_IDENTIFY_CALLBACK")) {
        _ = PWINBIO_IDENTIFY_CALLBACK;
    }
    if (@hasDecl(@This(), "PWINBIO_LOCATE_SENSOR_CALLBACK")) {
        _ = PWINBIO_LOCATE_SENSOR_CALLBACK;
    }
    if (@hasDecl(@This(), "PWINBIO_ENROLL_CAPTURE_CALLBACK")) {
        _ = PWINBIO_ENROLL_CAPTURE_CALLBACK;
    }
    if (@hasDecl(@This(), "PWINBIO_EVENT_CALLBACK")) {
        _ = PWINBIO_EVENT_CALLBACK;
    }
    if (@hasDecl(@This(), "PWINBIO_CAPTURE_CALLBACK")) {
        _ = PWINBIO_CAPTURE_CALLBACK;
    }
    if (@hasDecl(@This(), "PWINBIO_QUERY_SENSOR_INTERFACE_FN")) {
        _ = PWINBIO_QUERY_SENSOR_INTERFACE_FN;
    }
    if (@hasDecl(@This(), "PWINBIO_QUERY_ENGINE_INTERFACE_FN")) {
        _ = PWINBIO_QUERY_ENGINE_INTERFACE_FN;
    }
    if (@hasDecl(@This(), "PWINBIO_QUERY_STORAGE_INTERFACE_FN")) {
        _ = PWINBIO_QUERY_STORAGE_INTERFACE_FN;
    }

    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
