//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (1)
//--------------------------------------------------------------------------------
pub const WINML_TENSOR_DIMENSION_COUNT_MAX = @as(u32, 4);

//--------------------------------------------------------------------------------
// Section: Types (47)
//--------------------------------------------------------------------------------
pub const WINML_TENSOR_DATA_TYPE = enum(i32) {
    UNDEFINED = 0,
    FLOAT = 1,
    UINT8 = 2,
    INT8 = 3,
    UINT16 = 4,
    INT16 = 5,
    INT32 = 6,
    INT64 = 7,
    STRING = 8,
    BOOLEAN = 9,
    FLOAT16 = 10,
    DOUBLE = 11,
    UINT32 = 12,
    UINT64 = 13,
    COMPLEX64 = 14,
    COMPLEX128 = 15,
};
pub const WINML_TENSOR_UNDEFINED = WINML_TENSOR_DATA_TYPE.UNDEFINED;
pub const WINML_TENSOR_FLOAT = WINML_TENSOR_DATA_TYPE.FLOAT;
pub const WINML_TENSOR_UINT8 = WINML_TENSOR_DATA_TYPE.UINT8;
pub const WINML_TENSOR_INT8 = WINML_TENSOR_DATA_TYPE.INT8;
pub const WINML_TENSOR_UINT16 = WINML_TENSOR_DATA_TYPE.UINT16;
pub const WINML_TENSOR_INT16 = WINML_TENSOR_DATA_TYPE.INT16;
pub const WINML_TENSOR_INT32 = WINML_TENSOR_DATA_TYPE.INT32;
pub const WINML_TENSOR_INT64 = WINML_TENSOR_DATA_TYPE.INT64;
pub const WINML_TENSOR_STRING = WINML_TENSOR_DATA_TYPE.STRING;
pub const WINML_TENSOR_BOOLEAN = WINML_TENSOR_DATA_TYPE.BOOLEAN;
pub const WINML_TENSOR_FLOAT16 = WINML_TENSOR_DATA_TYPE.FLOAT16;
pub const WINML_TENSOR_DOUBLE = WINML_TENSOR_DATA_TYPE.DOUBLE;
pub const WINML_TENSOR_UINT32 = WINML_TENSOR_DATA_TYPE.UINT32;
pub const WINML_TENSOR_UINT64 = WINML_TENSOR_DATA_TYPE.UINT64;
pub const WINML_TENSOR_COMPLEX64 = WINML_TENSOR_DATA_TYPE.COMPLEX64;
pub const WINML_TENSOR_COMPLEX128 = WINML_TENSOR_DATA_TYPE.COMPLEX128;

pub const WINML_FEATURE_TYPE = enum(i32) {
    UNDEFINED = 0,
    TENSOR = 1,
    SEQUENCE = 2,
    MAP = 3,
    IMAGE = 4,
};
pub const WINML_FEATURE_UNDEFINED = WINML_FEATURE_TYPE.UNDEFINED;
pub const WINML_FEATURE_TENSOR = WINML_FEATURE_TYPE.TENSOR;
pub const WINML_FEATURE_SEQUENCE = WINML_FEATURE_TYPE.SEQUENCE;
pub const WINML_FEATURE_MAP = WINML_FEATURE_TYPE.MAP;
pub const WINML_FEATURE_IMAGE = WINML_FEATURE_TYPE.IMAGE;

pub const WINML_BINDING_TYPE = enum(i32) {
    UNDEFINED = 0,
    TENSOR = 1,
    SEQUENCE = 2,
    MAP = 3,
    IMAGE = 4,
    RESOURCE = 5,
};
pub const WINML_BINDING_UNDEFINED = WINML_BINDING_TYPE.UNDEFINED;
pub const WINML_BINDING_TENSOR = WINML_BINDING_TYPE.TENSOR;
pub const WINML_BINDING_SEQUENCE = WINML_BINDING_TYPE.SEQUENCE;
pub const WINML_BINDING_MAP = WINML_BINDING_TYPE.MAP;
pub const WINML_BINDING_IMAGE = WINML_BINDING_TYPE.IMAGE;
pub const WINML_BINDING_RESOURCE = WINML_BINDING_TYPE.RESOURCE;

pub const WINML_TENSOR_BINDING_DESC = extern struct {
    DataType: WINML_TENSOR_DATA_TYPE,
    NumDimensions: u32,
    pShape: ?*i64,
    DataSize: u32,
    pData: ?*anyopaque,
};

pub const WINML_SEQUENCE_BINDING_DESC = extern struct {
    ElementCount: u32,
    ElementType: WINML_TENSOR_DATA_TYPE,
    Anonymous: extern union {
        pStrings: ?*?PWSTR,
        pInts: ?*i64,
        pFloats: ?*f32,
        pDoubles: ?*f64,
    },
};

pub const WINML_MAP_BINDING_DESC = extern struct {
    ElementCount: u32,
    KeyType: WINML_TENSOR_DATA_TYPE,
    Anonymous1: extern union {
        pStringKeys: ?*?PWSTR,
        pIntKeys: ?*i64,
    },
    Fields: WINML_TENSOR_DATA_TYPE,
    Anonymous2: extern union {
        pStringFields: ?*?PWSTR,
        pIntFields: ?*i64,
        pFloatFields: ?*f32,
        pDoubleFields: ?*f64,
    },
};

pub const WINML_IMAGE_BINDING_DESC = extern struct {
    ElementType: WINML_TENSOR_DATA_TYPE,
    NumDimensions: u32,
    pShape: ?*i64,
    DataSize: u32,
    pData: ?*anyopaque,
};

pub const WINML_RESOURCE_BINDING_DESC = extern struct {
    ElementType: WINML_TENSOR_DATA_TYPE,
    NumDimensions: u32,
    pShape: ?*i64,
    pResource: ?*ID3D12Resource,
};

pub const WINML_BINDING_DESC = extern struct {
    Name: ?[*:0]const u16,
    BindType: WINML_BINDING_TYPE,
    Anonymous: extern union {
        Tensor: WINML_TENSOR_BINDING_DESC,
        Sequence: WINML_SEQUENCE_BINDING_DESC,
        Map: WINML_MAP_BINDING_DESC,
        Image: WINML_IMAGE_BINDING_DESC,
        Resource: WINML_RESOURCE_BINDING_DESC,
    },
};

pub const WINML_TENSOR_VARIABLE_DESC = extern struct {
    ElementType: WINML_TENSOR_DATA_TYPE,
    NumDimensions: u32,
    pShape: ?*i64,
};

pub const WINML_SEQUENCE_VARIABLE_DESC = extern struct {
    ElementType: WINML_TENSOR_DATA_TYPE,
};

pub const WINML_MAP_VARIABLE_DESC = extern struct {
    KeyType: WINML_TENSOR_DATA_TYPE,
    Fields: WINML_TENSOR_DATA_TYPE,
};

pub const WINML_IMAGE_VARIABLE_DESC = extern struct {
    ElementType: WINML_TENSOR_DATA_TYPE,
    NumDimensions: u32,
    pShape: ?*i64,
};

pub const WINML_VARIABLE_DESC = extern struct {
    Name: ?PWSTR,
    Description: ?PWSTR,
    FeatureType: WINML_FEATURE_TYPE,
    Required: BOOL,
    Anonymous: extern union {
        Tensor: WINML_TENSOR_VARIABLE_DESC,
        Sequence: WINML_SEQUENCE_VARIABLE_DESC,
        Map: WINML_MAP_VARIABLE_DESC,
        Image: WINML_IMAGE_VARIABLE_DESC,
    },
};

pub const WINML_MODEL_DESC = extern struct {
    Author: ?PWSTR,
    Name: ?PWSTR,
    Domain: ?PWSTR,
    Description: ?PWSTR,
    Version: usize,
};

// TODO: this type is limited to platform 'windows10.0.17134'
const IID_IWinMLModel_Value = Guid.initString("e2eeb6a9-f31f-4055-a521-e30b5b33664a");
pub const IID_IWinMLModel = &IID_IWinMLModel_Value;
pub const IWinMLModel = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWinMLModel,
                ppDescription: ?*?*WINML_MODEL_DESC,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWinMLModel,
                ppDescription: ?*?*WINML_MODEL_DESC,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EnumerateMetadata: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWinMLModel,
                Index: u32,
                pKey: ?*?PWSTR,
                pValue: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWinMLModel,
                Index: u32,
                pKey: ?*?PWSTR,
                pValue: ?*?PWSTR,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EnumerateModelInputs: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWinMLModel,
                Index: u32,
                ppInputDescriptor: ?*?*WINML_VARIABLE_DESC,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWinMLModel,
                Index: u32,
                ppInputDescriptor: ?*?*WINML_VARIABLE_DESC,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EnumerateModelOutputs: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWinMLModel,
                Index: u32,
                ppOutputDescriptor: ?*?*WINML_VARIABLE_DESC,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWinMLModel,
                Index: u32,
                ppOutputDescriptor: ?*?*WINML_VARIABLE_DESC,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWinMLModel_GetDescription(self: *const T, ppDescription: ?*?*WINML_MODEL_DESC) HRESULT {
                return @as(*const IWinMLModel.VTable, @ptrCast(self.vtable)).GetDescription(@as(*const IWinMLModel, @ptrCast(self)), ppDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWinMLModel_EnumerateMetadata(self: *const T, Index: u32, pKey: ?*?PWSTR, pValue: ?*?PWSTR) HRESULT {
                return @as(*const IWinMLModel.VTable, @ptrCast(self.vtable)).EnumerateMetadata(@as(*const IWinMLModel, @ptrCast(self)), Index, pKey, pValue);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWinMLModel_EnumerateModelInputs(self: *const T, Index: u32, ppInputDescriptor: ?*?*WINML_VARIABLE_DESC) HRESULT {
                return @as(*const IWinMLModel.VTable, @ptrCast(self.vtable)).EnumerateModelInputs(@as(*const IWinMLModel, @ptrCast(self)), Index, ppInputDescriptor);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWinMLModel_EnumerateModelOutputs(self: *const T, Index: u32, ppOutputDescriptor: ?*?*WINML_VARIABLE_DESC) HRESULT {
                return @as(*const IWinMLModel.VTable, @ptrCast(self.vtable)).EnumerateModelOutputs(@as(*const IWinMLModel, @ptrCast(self)), Index, ppOutputDescriptor);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows10.0.17134'
const IID_IWinMLEvaluationContext_Value = Guid.initString("95848f9e-583d-4054-af12-916387cd8426");
pub const IID_IWinMLEvaluationContext = &IID_IWinMLEvaluationContext_Value;
pub const IWinMLEvaluationContext = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        BindValue: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWinMLEvaluationContext,
                pDescriptor: ?*WINML_BINDING_DESC,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWinMLEvaluationContext,
                pDescriptor: ?*WINML_BINDING_DESC,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetValueByName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWinMLEvaluationContext,
                Name: ?[*:0]const u16,
                pDescriptor: ?*?*WINML_BINDING_DESC,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWinMLEvaluationContext,
                Name: ?[*:0]const u16,
                pDescriptor: ?*?*WINML_BINDING_DESC,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Clear: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWinMLEvaluationContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWinMLEvaluationContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWinMLEvaluationContext_BindValue(self: *const T, pDescriptor: ?*WINML_BINDING_DESC) HRESULT {
                return @as(*const IWinMLEvaluationContext.VTable, @ptrCast(self.vtable)).BindValue(@as(*const IWinMLEvaluationContext, @ptrCast(self)), pDescriptor);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWinMLEvaluationContext_GetValueByName(self: *const T, Name: ?[*:0]const u16, pDescriptor: ?*?*WINML_BINDING_DESC) HRESULT {
                return @as(*const IWinMLEvaluationContext.VTable, @ptrCast(self.vtable)).GetValueByName(@as(*const IWinMLEvaluationContext, @ptrCast(self)), Name, pDescriptor);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWinMLEvaluationContext_Clear(self: *const T) HRESULT {
                return @as(*const IWinMLEvaluationContext.VTable, @ptrCast(self.vtable)).Clear(@as(*const IWinMLEvaluationContext, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

// TODO: this type is limited to platform 'windows10.0.17134'
const IID_IWinMLRuntime_Value = Guid.initString("a0425329-40ae-48d9-bce3-829ef7b8a41a");
pub const IID_IWinMLRuntime = &IID_IWinMLRuntime_Value;
pub const IWinMLRuntime = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        LoadModel: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWinMLRuntime,
                Path: ?[*:0]const u16,
                ppModel: ?*?*IWinMLModel,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWinMLRuntime,
                Path: ?[*:0]const u16,
                ppModel: ?*?*IWinMLModel,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateEvaluationContext: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWinMLRuntime,
                device: ?*ID3D12Device,
                ppContext: ?*?*IWinMLEvaluationContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWinMLRuntime,
                device: ?*ID3D12Device,
                ppContext: ?*?*IWinMLEvaluationContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        EvaluateModel: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWinMLRuntime,
                pContext: ?*IWinMLEvaluationContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWinMLRuntime,
                pContext: ?*IWinMLEvaluationContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWinMLRuntime_LoadModel(self: *const T, Path: ?[*:0]const u16, ppModel: ?*?*IWinMLModel) HRESULT {
                return @as(*const IWinMLRuntime.VTable, @ptrCast(self.vtable)).LoadModel(@as(*const IWinMLRuntime, @ptrCast(self)), Path, ppModel);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWinMLRuntime_CreateEvaluationContext(self: *const T, device: ?*ID3D12Device, ppContext: ?*?*IWinMLEvaluationContext) HRESULT {
                return @as(*const IWinMLRuntime.VTable, @ptrCast(self.vtable)).CreateEvaluationContext(@as(*const IWinMLRuntime, @ptrCast(self)), device, ppContext);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWinMLRuntime_EvaluateModel(self: *const T, pContext: ?*IWinMLEvaluationContext) HRESULT {
                return @as(*const IWinMLRuntime.VTable, @ptrCast(self.vtable)).EvaluateModel(@as(*const IWinMLRuntime, @ptrCast(self)), pContext);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const WINML_RUNTIME_TYPE = enum(i32) {
    K = 0,
};
pub const WINML_RUNTIME_CNTK = WINML_RUNTIME_TYPE.K;

// TODO: this type is limited to platform 'windows10.0.17134'
const IID_IWinMLRuntimeFactory_Value = Guid.initString("a807b84d-4ae5-4bc0-a76a-941aa246bd41");
pub const IID_IWinMLRuntimeFactory = &IID_IWinMLRuntimeFactory_Value;
pub const IWinMLRuntimeFactory = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        CreateRuntime: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IWinMLRuntimeFactory,
                RuntimeType: WINML_RUNTIME_TYPE,
                ppRuntime: ?*?*IWinMLRuntime,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IWinMLRuntimeFactory,
                RuntimeType: WINML_RUNTIME_TYPE,
                ppRuntime: ?*?*IWinMLRuntime,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IWinMLRuntimeFactory_CreateRuntime(self: *const T, RuntimeType: WINML_RUNTIME_TYPE, ppRuntime: ?*?*IWinMLRuntime) HRESULT {
                return @as(*const IWinMLRuntimeFactory.VTable, @ptrCast(self.vtable)).CreateRuntime(@as(*const IWinMLRuntimeFactory, @ptrCast(self)), RuntimeType, ppRuntime);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const MLOperatorAttributeType = enum(u32) {
    Undefined = 0,
    Float = 2,
    Int = 3,
    String = 4,
    FloatArray = 7,
    IntArray = 8,
    StringArray = 9,
};
// NOTE: not creating aliases because this enum is 'Scoped'

pub const MLOperatorTensorDataType = enum(u32) {
    Undefined = 0,
    Float = 1,
    UInt8 = 2,
    Int8 = 3,
    UInt16 = 4,
    Int16 = 5,
    Int32 = 6,
    Int64 = 7,
    String = 8,
    Bool = 9,
    Float16 = 10,
    Double = 11,
    UInt32 = 12,
    UInt64 = 13,
    Complex64 = 14,
    Complex128 = 15,
};
// NOTE: not creating aliases because this enum is 'Scoped'

pub const MLOperatorEdgeType = enum(u32) {
    Undefined = 0,
    Tensor = 1,
};
// NOTE: not creating aliases because this enum is 'Scoped'

pub const MLOperatorEdgeDescription = extern struct {
    edgeType: MLOperatorEdgeType,
    Anonymous: extern union {
        reserved: u64,
        tensorDataType: MLOperatorTensorDataType,
    },
};

const IID_IMLOperatorAttributes_Value = Guid.initString("4b1b1759-ec40-466c-aab4-beb5347fd24c");
pub const IID_IMLOperatorAttributes = &IID_IMLOperatorAttributes_Value;
pub const IMLOperatorAttributes = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetAttributeElementCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorAttributes,
                name: ?[*:0]const u8,
                type: MLOperatorAttributeType,
                elementCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorAttributes,
                name: ?[*:0]const u8,
                type: MLOperatorAttributeType,
                elementCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetAttribute: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorAttributes,
                name: ?[*:0]const u8,
                type: MLOperatorAttributeType,
                elementCount: u32,
                elementByteSize: usize,
                value: ?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorAttributes,
                name: ?[*:0]const u8,
                type: MLOperatorAttributeType,
                elementCount: u32,
                elementByteSize: usize,
                value: ?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetStringAttributeElementLength: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorAttributes,
                name: ?[*:0]const u8,
                elementIndex: u32,
                attributeElementByteSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorAttributes,
                name: ?[*:0]const u8,
                elementIndex: u32,
                attributeElementByteSize: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetStringAttributeElement: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorAttributes,
                name: ?[*:0]const u8,
                elementIndex: u32,
                attributeElementByteSize: u32,
                attributeElement: [*:0]u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorAttributes,
                name: ?[*:0]const u8,
                elementIndex: u32,
                attributeElementByteSize: u32,
                attributeElement: [*:0]u8,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorAttributes_GetAttributeElementCount(self: *const T, name: ?[*:0]const u8, type_: MLOperatorAttributeType, elementCount: ?*u32) HRESULT {
                return @as(*const IMLOperatorAttributes.VTable, @ptrCast(self.vtable)).GetAttributeElementCount(@as(*const IMLOperatorAttributes, @ptrCast(self)), name, type_, elementCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorAttributes_GetAttribute(self: *const T, name: ?[*:0]const u8, type_: MLOperatorAttributeType, elementCount: u32, elementByteSize: usize, value: ?*anyopaque) HRESULT {
                return @as(*const IMLOperatorAttributes.VTable, @ptrCast(self.vtable)).GetAttribute(@as(*const IMLOperatorAttributes, @ptrCast(self)), name, type_, elementCount, elementByteSize, value);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorAttributes_GetStringAttributeElementLength(self: *const T, name: ?[*:0]const u8, elementIndex: u32, attributeElementByteSize: ?*u32) HRESULT {
                return @as(*const IMLOperatorAttributes.VTable, @ptrCast(self.vtable)).GetStringAttributeElementLength(@as(*const IMLOperatorAttributes, @ptrCast(self)), name, elementIndex, attributeElementByteSize);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorAttributes_GetStringAttributeElement(self: *const T, name: ?[*:0]const u8, elementIndex: u32, attributeElementByteSize: u32, attributeElement: [*:0]u8) HRESULT {
                return @as(*const IMLOperatorAttributes.VTable, @ptrCast(self.vtable)).GetStringAttributeElement(@as(*const IMLOperatorAttributes, @ptrCast(self)), name, elementIndex, attributeElementByteSize, attributeElement);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IMLOperatorTensorShapeDescription_Value = Guid.initString("f20e8cbe-3b28-4248-be95-f96fbc6e4643");
pub const IID_IMLOperatorTensorShapeDescription = &IID_IMLOperatorTensorShapeDescription_Value;
pub const IMLOperatorTensorShapeDescription = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetInputTensorDimensionCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTensorShapeDescription,
                inputIndex: u32,
                dimensionCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorTensorShapeDescription,
                inputIndex: u32,
                dimensionCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInputTensorShape: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTensorShapeDescription,
                inputIndex: u32,
                dimensionCount: u32,
                dimensions: [*]u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorTensorShapeDescription,
                inputIndex: u32,
                dimensionCount: u32,
                dimensions: [*]u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        HasOutputShapeDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTensorShapeDescription,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IMLOperatorTensorShapeDescription,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        GetOutputTensorDimensionCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTensorShapeDescription,
                outputIndex: u32,
                dimensionCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorTensorShapeDescription,
                outputIndex: u32,
                dimensionCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetOutputTensorShape: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTensorShapeDescription,
                outputIndex: u32,
                dimensionCount: u32,
                dimensions: [*]u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorTensorShapeDescription,
                outputIndex: u32,
                dimensionCount: u32,
                dimensions: [*]u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTensorShapeDescription_GetInputTensorDimensionCount(self: *const T, inputIndex: u32, dimensionCount: ?*u32) HRESULT {
                return @as(*const IMLOperatorTensorShapeDescription.VTable, @ptrCast(self.vtable)).GetInputTensorDimensionCount(@as(*const IMLOperatorTensorShapeDescription, @ptrCast(self)), inputIndex, dimensionCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTensorShapeDescription_GetInputTensorShape(self: *const T, inputIndex: u32, dimensionCount: u32, dimensions: [*]u32) HRESULT {
                return @as(*const IMLOperatorTensorShapeDescription.VTable, @ptrCast(self.vtable)).GetInputTensorShape(@as(*const IMLOperatorTensorShapeDescription, @ptrCast(self)), inputIndex, dimensionCount, dimensions);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTensorShapeDescription_HasOutputShapeDescription(self: *const T) bool {
                return @as(*const IMLOperatorTensorShapeDescription.VTable, @ptrCast(self.vtable)).HasOutputShapeDescription(@as(*const IMLOperatorTensorShapeDescription, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTensorShapeDescription_GetOutputTensorDimensionCount(self: *const T, outputIndex: u32, dimensionCount: ?*u32) HRESULT {
                return @as(*const IMLOperatorTensorShapeDescription.VTable, @ptrCast(self.vtable)).GetOutputTensorDimensionCount(@as(*const IMLOperatorTensorShapeDescription, @ptrCast(self)), outputIndex, dimensionCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTensorShapeDescription_GetOutputTensorShape(self: *const T, outputIndex: u32, dimensionCount: u32, dimensions: [*]u32) HRESULT {
                return @as(*const IMLOperatorTensorShapeDescription.VTable, @ptrCast(self.vtable)).GetOutputTensorShape(@as(*const IMLOperatorTensorShapeDescription, @ptrCast(self)), outputIndex, dimensionCount, dimensions);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IMLOperatorKernelCreationContext_Value = Guid.initString("5459b53d-a0fc-4665-addd-70171ef7e631");
pub const IID_IMLOperatorKernelCreationContext = &IID_IMLOperatorKernelCreationContext_Value;
pub const IMLOperatorKernelCreationContext = extern struct {
    pub const VTable = extern struct {
        base: IMLOperatorAttributes.VTable,
        GetInputCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorKernelCreationContext,
            ) callconv(@import("std").os.windows.WINAPI) u32,
            else => *const fn (
                self: *const IMLOperatorKernelCreationContext,
            ) callconv(@import("std").os.windows.WINAPI) u32,
        },
        GetOutputCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorKernelCreationContext,
            ) callconv(@import("std").os.windows.WINAPI) u32,
            else => *const fn (
                self: *const IMLOperatorKernelCreationContext,
            ) callconv(@import("std").os.windows.WINAPI) u32,
        },
        IsInputValid: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorKernelCreationContext,
                inputIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IMLOperatorKernelCreationContext,
                inputIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        IsOutputValid: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorKernelCreationContext,
                outputIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IMLOperatorKernelCreationContext,
                outputIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        GetInputEdgeDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorKernelCreationContext,
                inputIndex: u32,
                edgeDescription: ?*MLOperatorEdgeDescription,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorKernelCreationContext,
                inputIndex: u32,
                edgeDescription: ?*MLOperatorEdgeDescription,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetOutputEdgeDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorKernelCreationContext,
                outputIndex: u32,
                edgeDescription: ?*MLOperatorEdgeDescription,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorKernelCreationContext,
                outputIndex: u32,
                edgeDescription: ?*MLOperatorEdgeDescription,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        HasTensorShapeDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorKernelCreationContext,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IMLOperatorKernelCreationContext,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        GetTensorShapeDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorKernelCreationContext,
                shapeDescription: ?*?*IMLOperatorTensorShapeDescription,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorKernelCreationContext,
                shapeDescription: ?*?*IMLOperatorTensorShapeDescription,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetExecutionInterface: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorKernelCreationContext,
                executionObject: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) void,
            else => *const fn (
                self: *const IMLOperatorKernelCreationContext,
                executionObject: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) void,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IMLOperatorAttributes.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorKernelCreationContext_GetInputCount(self: *const T) u32 {
                return @as(*const IMLOperatorKernelCreationContext.VTable, @ptrCast(self.vtable)).GetInputCount(@as(*const IMLOperatorKernelCreationContext, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorKernelCreationContext_GetOutputCount(self: *const T) u32 {
                return @as(*const IMLOperatorKernelCreationContext.VTable, @ptrCast(self.vtable)).GetOutputCount(@as(*const IMLOperatorKernelCreationContext, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorKernelCreationContext_IsInputValid(self: *const T, inputIndex: u32) bool {
                return @as(*const IMLOperatorKernelCreationContext.VTable, @ptrCast(self.vtable)).IsInputValid(@as(*const IMLOperatorKernelCreationContext, @ptrCast(self)), inputIndex);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorKernelCreationContext_IsOutputValid(self: *const T, outputIndex: u32) bool {
                return @as(*const IMLOperatorKernelCreationContext.VTable, @ptrCast(self.vtable)).IsOutputValid(@as(*const IMLOperatorKernelCreationContext, @ptrCast(self)), outputIndex);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorKernelCreationContext_GetInputEdgeDescription(self: *const T, inputIndex: u32, edgeDescription: ?*MLOperatorEdgeDescription) HRESULT {
                return @as(*const IMLOperatorKernelCreationContext.VTable, @ptrCast(self.vtable)).GetInputEdgeDescription(@as(*const IMLOperatorKernelCreationContext, @ptrCast(self)), inputIndex, edgeDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorKernelCreationContext_GetOutputEdgeDescription(self: *const T, outputIndex: u32, edgeDescription: ?*MLOperatorEdgeDescription) HRESULT {
                return @as(*const IMLOperatorKernelCreationContext.VTable, @ptrCast(self.vtable)).GetOutputEdgeDescription(@as(*const IMLOperatorKernelCreationContext, @ptrCast(self)), outputIndex, edgeDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorKernelCreationContext_HasTensorShapeDescription(self: *const T) bool {
                return @as(*const IMLOperatorKernelCreationContext.VTable, @ptrCast(self.vtable)).HasTensorShapeDescription(@as(*const IMLOperatorKernelCreationContext, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorKernelCreationContext_GetTensorShapeDescription(self: *const T, shapeDescription: ?*?*IMLOperatorTensorShapeDescription) HRESULT {
                return @as(*const IMLOperatorKernelCreationContext.VTable, @ptrCast(self.vtable)).GetTensorShapeDescription(@as(*const IMLOperatorKernelCreationContext, @ptrCast(self)), shapeDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorKernelCreationContext_GetExecutionInterface(self: *const T, executionObject: ?*?*IUnknown) void {
                return @as(*const IMLOperatorKernelCreationContext.VTable, @ptrCast(self.vtable)).GetExecutionInterface(@as(*const IMLOperatorKernelCreationContext, @ptrCast(self)), executionObject);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IMLOperatorTensor_Value = Guid.initString("7fe41f41-f430-440e-aece-54416dc8b9db");
pub const IID_IMLOperatorTensor = &IID_IMLOperatorTensor_Value;
pub const IMLOperatorTensor = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetDimensionCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTensor,
            ) callconv(@import("std").os.windows.WINAPI) u32,
            else => *const fn (
                self: *const IMLOperatorTensor,
            ) callconv(@import("std").os.windows.WINAPI) u32,
        },
        GetShape: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTensor,
                dimensionCount: u32,
                dimensions: [*]u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorTensor,
                dimensionCount: u32,
                dimensions: [*]u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetTensorDataType: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTensor,
            ) callconv(@import("std").os.windows.WINAPI) MLOperatorTensorDataType,
            else => *const fn (
                self: *const IMLOperatorTensor,
            ) callconv(@import("std").os.windows.WINAPI) MLOperatorTensorDataType,
        },
        IsCpuData: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTensor,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IMLOperatorTensor,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        IsDataInterface: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTensor,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IMLOperatorTensor,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        GetData: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTensor,
            ) callconv(@import("std").os.windows.WINAPI) ?*anyopaque,
            else => *const fn (
                self: *const IMLOperatorTensor,
            ) callconv(@import("std").os.windows.WINAPI) ?*anyopaque,
        },
        GetDataInterface: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTensor,
                dataInterface: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) void,
            else => *const fn (
                self: *const IMLOperatorTensor,
                dataInterface: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) void,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTensor_GetDimensionCount(self: *const T) u32 {
                return @as(*const IMLOperatorTensor.VTable, @ptrCast(self.vtable)).GetDimensionCount(@as(*const IMLOperatorTensor, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTensor_GetShape(self: *const T, dimensionCount: u32, dimensions: [*]u32) HRESULT {
                return @as(*const IMLOperatorTensor.VTable, @ptrCast(self.vtable)).GetShape(@as(*const IMLOperatorTensor, @ptrCast(self)), dimensionCount, dimensions);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTensor_GetTensorDataType(self: *const T) MLOperatorTensorDataType {
                return @as(*const IMLOperatorTensor.VTable, @ptrCast(self.vtable)).GetTensorDataType(@as(*const IMLOperatorTensor, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTensor_IsCpuData(self: *const T) bool {
                return @as(*const IMLOperatorTensor.VTable, @ptrCast(self.vtable)).IsCpuData(@as(*const IMLOperatorTensor, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTensor_IsDataInterface(self: *const T) bool {
                return @as(*const IMLOperatorTensor.VTable, @ptrCast(self.vtable)).IsDataInterface(@as(*const IMLOperatorTensor, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTensor_GetData(self: *const T) ?*anyopaque {
                return @as(*const IMLOperatorTensor.VTable, @ptrCast(self.vtable)).GetData(@as(*const IMLOperatorTensor, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTensor_GetDataInterface(self: *const T, dataInterface: ?*?*IUnknown) void {
                return @as(*const IMLOperatorTensor.VTable, @ptrCast(self.vtable)).GetDataInterface(@as(*const IMLOperatorTensor, @ptrCast(self)), dataInterface);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IMLOperatorKernelContext_Value = Guid.initString("82536a28-f022-4769-9d3f-8b278f84c0c3");
pub const IID_IMLOperatorKernelContext = &IID_IMLOperatorKernelContext_Value;
pub const IMLOperatorKernelContext = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetInputTensor: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorKernelContext,
                inputIndex: u32,
                tensor: ?*?*IMLOperatorTensor,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorKernelContext,
                inputIndex: u32,
                tensor: ?*?*IMLOperatorTensor,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetOutputTensor: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorKernelContext,
                outputIndex: u32,
                dimensionCount: u32,
                dimensionSizes: [*]const u32,
                tensor: ?*?*IMLOperatorTensor,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorKernelContext,
                outputIndex: u32,
                dimensionCount: u32,
                dimensionSizes: [*]const u32,
                tensor: ?*?*IMLOperatorTensor,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetOutputTensor1: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorKernelContext,
                outputIndex: u32,
                tensor: ?*?*IMLOperatorTensor,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorKernelContext,
                outputIndex: u32,
                tensor: ?*?*IMLOperatorTensor,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        AllocateTemporaryData: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorKernelContext,
                size: usize,
                data: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorKernelContext,
                size: usize,
                data: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetExecutionInterface: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorKernelContext,
                executionObject: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) void,
            else => *const fn (
                self: *const IMLOperatorKernelContext,
                executionObject: ?*?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) void,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorKernelContext_GetInputTensor(self: *const T, inputIndex: u32, tensor: ?*?*IMLOperatorTensor) HRESULT {
                return @as(*const IMLOperatorKernelContext.VTable, @ptrCast(self.vtable)).GetInputTensor(@as(*const IMLOperatorKernelContext, @ptrCast(self)), inputIndex, tensor);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorKernelContext_GetOutputTensor(self: *const T, outputIndex: u32, dimensionCount: u32, dimensionSizes: [*]const u32, tensor: ?*?*IMLOperatorTensor) HRESULT {
                return @as(*const IMLOperatorKernelContext.VTable, @ptrCast(self.vtable)).GetOutputTensor(@as(*const IMLOperatorKernelContext, @ptrCast(self)), outputIndex, dimensionCount, dimensionSizes, tensor);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorKernelContext_GetOutputTensor1(self: *const T, outputIndex: u32, tensor: ?*?*IMLOperatorTensor) HRESULT {
                return @as(*const IMLOperatorKernelContext.VTable, @ptrCast(self.vtable)).GetOutputTensor(@as(*const IMLOperatorKernelContext, @ptrCast(self)), outputIndex, tensor);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorKernelContext_AllocateTemporaryData(self: *const T, size: usize, data: ?*?*IUnknown) HRESULT {
                return @as(*const IMLOperatorKernelContext.VTable, @ptrCast(self.vtable)).AllocateTemporaryData(@as(*const IMLOperatorKernelContext, @ptrCast(self)), size, data);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorKernelContext_GetExecutionInterface(self: *const T, executionObject: ?*?*IUnknown) void {
                return @as(*const IMLOperatorKernelContext.VTable, @ptrCast(self.vtable)).GetExecutionInterface(@as(*const IMLOperatorKernelContext, @ptrCast(self)), executionObject);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IMLOperatorKernel_Value = Guid.initString("11c4b4a0-b467-4eaa-a1a6-b961d8d0ed79");
pub const IID_IMLOperatorKernel = &IID_IMLOperatorKernel_Value;
pub const IMLOperatorKernel = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        Compute: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorKernel,
                context: ?*IMLOperatorKernelContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorKernel,
                context: ?*IMLOperatorKernelContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorKernel_Compute(self: *const T, context: ?*IMLOperatorKernelContext) HRESULT {
                return @as(*const IMLOperatorKernel.VTable, @ptrCast(self.vtable)).Compute(@as(*const IMLOperatorKernel, @ptrCast(self)), context);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const MLOperatorParameterOptions = enum(u32) {
    Single = 0,
    Optional = 1,
    Variadic = 2,
    _,
    pub fn initFlags(o: struct {
        Single: u1 = 0,
        Optional: u1 = 0,
        Variadic: u1 = 0,
    }) MLOperatorParameterOptions {
        return @as(MLOperatorParameterOptions, @enumFromInt((if (o.Single == 1) @intFromEnum(MLOperatorParameterOptions.Single) else 0) | (if (o.Optional == 1) @intFromEnum(MLOperatorParameterOptions.Optional) else 0) | (if (o.Variadic == 1) @intFromEnum(MLOperatorParameterOptions.Variadic) else 0)));
    }
};
// NOTE: not creating aliases because this enum is 'Scoped'

pub const MLOperatorSchemaEdgeTypeFormat = enum(i32) {
    EdgeDescription = 0,
    Label = 1,
};
// NOTE: not creating aliases because this enum is 'Scoped'

pub const MLOperatorSchemaEdgeDescription = extern struct {
    options: MLOperatorParameterOptions,
    typeFormat: MLOperatorSchemaEdgeTypeFormat,
    Anonymous: extern union {
        reserved: ?*const anyopaque,
        typeLabel: ?[*:0]const u8,
        edgeDescription: MLOperatorEdgeDescription,
    },
};

pub const MLOperatorEdgeTypeConstraint = extern struct {
    typeLabel: ?[*:0]const u8,
    allowedTypes: ?*const MLOperatorEdgeDescription,
    allowedTypeCount: u32,
};

const IID_IMLOperatorShapeInferenceContext_Value = Guid.initString("105b6b29-5408-4a68-9959-09b5955a3492");
pub const IID_IMLOperatorShapeInferenceContext = &IID_IMLOperatorShapeInferenceContext_Value;
pub const IMLOperatorShapeInferenceContext = extern struct {
    pub const VTable = extern struct {
        base: IMLOperatorAttributes.VTable,
        GetInputCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorShapeInferenceContext,
            ) callconv(@import("std").os.windows.WINAPI) u32,
            else => *const fn (
                self: *const IMLOperatorShapeInferenceContext,
            ) callconv(@import("std").os.windows.WINAPI) u32,
        },
        GetOutputCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorShapeInferenceContext,
            ) callconv(@import("std").os.windows.WINAPI) u32,
            else => *const fn (
                self: *const IMLOperatorShapeInferenceContext,
            ) callconv(@import("std").os.windows.WINAPI) u32,
        },
        IsInputValid: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorShapeInferenceContext,
                inputIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IMLOperatorShapeInferenceContext,
                inputIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        IsOutputValid: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorShapeInferenceContext,
                outputIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IMLOperatorShapeInferenceContext,
                outputIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        GetInputEdgeDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorShapeInferenceContext,
                inputIndex: u32,
                edgeDescription: ?*MLOperatorEdgeDescription,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorShapeInferenceContext,
                inputIndex: u32,
                edgeDescription: ?*MLOperatorEdgeDescription,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInputTensorDimensionCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorShapeInferenceContext,
                inputIndex: u32,
                dimensionCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorShapeInferenceContext,
                inputIndex: u32,
                dimensionCount: ?*u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetInputTensorShape: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorShapeInferenceContext,
                inputIndex: u32,
                dimensionCount: u32,
                dimensions: [*]u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorShapeInferenceContext,
                inputIndex: u32,
                dimensionCount: u32,
                dimensions: [*]u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOutputTensorShape: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorShapeInferenceContext,
                outputIndex: u32,
                dimensionCount: u32,
                dimensions: ?*const u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorShapeInferenceContext,
                outputIndex: u32,
                dimensionCount: u32,
                dimensions: ?*const u32,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IMLOperatorAttributes.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorShapeInferenceContext_GetInputCount(self: *const T) u32 {
                return @as(*const IMLOperatorShapeInferenceContext.VTable, @ptrCast(self.vtable)).GetInputCount(@as(*const IMLOperatorShapeInferenceContext, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorShapeInferenceContext_GetOutputCount(self: *const T) u32 {
                return @as(*const IMLOperatorShapeInferenceContext.VTable, @ptrCast(self.vtable)).GetOutputCount(@as(*const IMLOperatorShapeInferenceContext, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorShapeInferenceContext_IsInputValid(self: *const T, inputIndex: u32) bool {
                return @as(*const IMLOperatorShapeInferenceContext.VTable, @ptrCast(self.vtable)).IsInputValid(@as(*const IMLOperatorShapeInferenceContext, @ptrCast(self)), inputIndex);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorShapeInferenceContext_IsOutputValid(self: *const T, outputIndex: u32) bool {
                return @as(*const IMLOperatorShapeInferenceContext.VTable, @ptrCast(self.vtable)).IsOutputValid(@as(*const IMLOperatorShapeInferenceContext, @ptrCast(self)), outputIndex);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorShapeInferenceContext_GetInputEdgeDescription(self: *const T, inputIndex: u32, edgeDescription: ?*MLOperatorEdgeDescription) HRESULT {
                return @as(*const IMLOperatorShapeInferenceContext.VTable, @ptrCast(self.vtable)).GetInputEdgeDescription(@as(*const IMLOperatorShapeInferenceContext, @ptrCast(self)), inputIndex, edgeDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorShapeInferenceContext_GetInputTensorDimensionCount(self: *const T, inputIndex: u32, dimensionCount: ?*u32) HRESULT {
                return @as(*const IMLOperatorShapeInferenceContext.VTable, @ptrCast(self.vtable)).GetInputTensorDimensionCount(@as(*const IMLOperatorShapeInferenceContext, @ptrCast(self)), inputIndex, dimensionCount);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorShapeInferenceContext_GetInputTensorShape(self: *const T, inputIndex: u32, dimensionCount: u32, dimensions: [*]u32) HRESULT {
                return @as(*const IMLOperatorShapeInferenceContext.VTable, @ptrCast(self.vtable)).GetInputTensorShape(@as(*const IMLOperatorShapeInferenceContext, @ptrCast(self)), inputIndex, dimensionCount, dimensions);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorShapeInferenceContext_SetOutputTensorShape(self: *const T, outputIndex: u32, dimensionCount: u32, dimensions: ?*const u32) HRESULT {
                return @as(*const IMLOperatorShapeInferenceContext.VTable, @ptrCast(self.vtable)).SetOutputTensorShape(@as(*const IMLOperatorShapeInferenceContext, @ptrCast(self)), outputIndex, dimensionCount, dimensions);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IMLOperatorTypeInferenceContext_Value = Guid.initString("ec893bb1-f938-427b-8488-c8dcf775f138");
pub const IID_IMLOperatorTypeInferenceContext = &IID_IMLOperatorTypeInferenceContext_Value;
pub const IMLOperatorTypeInferenceContext = extern struct {
    pub const VTable = extern struct {
        base: IMLOperatorAttributes.VTable,
        GetInputCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTypeInferenceContext,
            ) callconv(@import("std").os.windows.WINAPI) u32,
            else => *const fn (
                self: *const IMLOperatorTypeInferenceContext,
            ) callconv(@import("std").os.windows.WINAPI) u32,
        },
        GetOutputCount: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTypeInferenceContext,
            ) callconv(@import("std").os.windows.WINAPI) u32,
            else => *const fn (
                self: *const IMLOperatorTypeInferenceContext,
            ) callconv(@import("std").os.windows.WINAPI) u32,
        },
        IsInputValid: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTypeInferenceContext,
                inputIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IMLOperatorTypeInferenceContext,
                inputIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        IsOutputValid: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTypeInferenceContext,
                outputIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) bool,
            else => *const fn (
                self: *const IMLOperatorTypeInferenceContext,
                outputIndex: u32,
            ) callconv(@import("std").os.windows.WINAPI) bool,
        },
        GetInputEdgeDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTypeInferenceContext,
                inputIndex: u32,
                edgeDescription: ?*MLOperatorEdgeDescription,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorTypeInferenceContext,
                inputIndex: u32,
                edgeDescription: ?*MLOperatorEdgeDescription,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetOutputEdgeDescription: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTypeInferenceContext,
                outputIndex: u32,
                edgeDescription: ?*const MLOperatorEdgeDescription,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorTypeInferenceContext,
                outputIndex: u32,
                edgeDescription: ?*const MLOperatorEdgeDescription,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IMLOperatorAttributes.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTypeInferenceContext_GetInputCount(self: *const T) u32 {
                return @as(*const IMLOperatorTypeInferenceContext.VTable, @ptrCast(self.vtable)).GetInputCount(@as(*const IMLOperatorTypeInferenceContext, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTypeInferenceContext_GetOutputCount(self: *const T) u32 {
                return @as(*const IMLOperatorTypeInferenceContext.VTable, @ptrCast(self.vtable)).GetOutputCount(@as(*const IMLOperatorTypeInferenceContext, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTypeInferenceContext_IsInputValid(self: *const T, inputIndex: u32) bool {
                return @as(*const IMLOperatorTypeInferenceContext.VTable, @ptrCast(self.vtable)).IsInputValid(@as(*const IMLOperatorTypeInferenceContext, @ptrCast(self)), inputIndex);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTypeInferenceContext_IsOutputValid(self: *const T, outputIndex: u32) bool {
                return @as(*const IMLOperatorTypeInferenceContext.VTable, @ptrCast(self.vtable)).IsOutputValid(@as(*const IMLOperatorTypeInferenceContext, @ptrCast(self)), outputIndex);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTypeInferenceContext_GetInputEdgeDescription(self: *const T, inputIndex: u32, edgeDescription: ?*MLOperatorEdgeDescription) HRESULT {
                return @as(*const IMLOperatorTypeInferenceContext.VTable, @ptrCast(self.vtable)).GetInputEdgeDescription(@as(*const IMLOperatorTypeInferenceContext, @ptrCast(self)), inputIndex, edgeDescription);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTypeInferenceContext_SetOutputEdgeDescription(self: *const T, outputIndex: u32, edgeDescription: ?*const MLOperatorEdgeDescription) HRESULT {
                return @as(*const IMLOperatorTypeInferenceContext.VTable, @ptrCast(self.vtable)).SetOutputEdgeDescription(@as(*const IMLOperatorTypeInferenceContext, @ptrCast(self)), outputIndex, edgeDescription);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IMLOperatorTypeInferrer_Value = Guid.initString("781aeb48-9bcb-4797-bf77-8bf455217beb");
pub const IID_IMLOperatorTypeInferrer = &IID_IMLOperatorTypeInferrer_Value;
pub const IMLOperatorTypeInferrer = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        InferOutputTypes: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorTypeInferrer,
                context: ?*IMLOperatorTypeInferenceContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorTypeInferrer,
                context: ?*IMLOperatorTypeInferenceContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorTypeInferrer_InferOutputTypes(self: *const T, context: ?*IMLOperatorTypeInferenceContext) HRESULT {
                return @as(*const IMLOperatorTypeInferrer.VTable, @ptrCast(self.vtable)).InferOutputTypes(@as(*const IMLOperatorTypeInferrer, @ptrCast(self)), context);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IMLOperatorShapeInferrer_Value = Guid.initString("540be5be-a6c9-40ee-83f6-d2b8b40a7798");
pub const IID_IMLOperatorShapeInferrer = &IID_IMLOperatorShapeInferrer_Value;
pub const IMLOperatorShapeInferrer = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        InferOutputShapes: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorShapeInferrer,
                context: ?*IMLOperatorShapeInferenceContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorShapeInferrer,
                context: ?*IMLOperatorShapeInferenceContext,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorShapeInferrer_InferOutputShapes(self: *const T, context: ?*IMLOperatorShapeInferenceContext) HRESULT {
                return @as(*const IMLOperatorShapeInferrer.VTable, @ptrCast(self.vtable)).InferOutputShapes(@as(*const IMLOperatorShapeInferrer, @ptrCast(self)), context);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const MLOperatorAttribute = extern struct {
    name: ?[*:0]const u8,
    type: MLOperatorAttributeType,
    required: bool,
};

pub const MLOperatorAttributeNameValue = extern struct {
    name: ?[*:0]const u8,
    type: MLOperatorAttributeType,
    valueCount: u32,
    Anonymous: extern union {
        reserved: ?*const anyopaque,
        ints: ?*const i64,
        strings: ?*const ?*i8,
        floats: ?*const f32,
    },
};

pub const MLOperatorSchemaDescription = extern struct {
    name: ?[*:0]const u8,
    operatorSetVersionAtLastChange: i32,
    inputs: ?*const MLOperatorSchemaEdgeDescription,
    inputCount: u32,
    outputs: ?*const MLOperatorSchemaEdgeDescription,
    outputCount: u32,
    typeConstraints: ?*const MLOperatorEdgeTypeConstraint,
    typeConstraintCount: u32,
    attributes: ?*const MLOperatorAttribute,
    attributeCount: u32,
    defaultAttributes: ?*const MLOperatorAttributeNameValue,
    defaultAttributeCount: u32,
};

pub const MLOperatorSetId = extern struct {
    domain: ?[*:0]const u8,
    version: i32,
};

pub const MLOperatorKernelOptions = enum(u32) {
    None = 0,
    s = 1,
    _,
    pub fn initFlags(o: struct {
        None: u1 = 0,
        s: u1 = 0,
    }) MLOperatorKernelOptions {
        return @as(MLOperatorKernelOptions, @enumFromInt((if (o.None == 1) @intFromEnum(MLOperatorKernelOptions.None) else 0) | (if (o.s == 1) @intFromEnum(MLOperatorKernelOptions.s) else 0)));
    }
};
// NOTE: not creating aliases because this enum is 'Scoped'

pub const MLOperatorExecutionType = enum(u32) {
    Undefined = 0,
    Cpu = 1,
    D3D12 = 2,
};
// NOTE: not creating aliases because this enum is 'Scoped'

pub const MLOperatorKernelDescription = extern struct {
    domain: ?[*:0]const u8,
    name: ?[*:0]const u8,
    minimumOperatorSetVersion: i32,
    executionType: MLOperatorExecutionType,
    typeConstraints: ?*const MLOperatorEdgeTypeConstraint,
    typeConstraintCount: u32,
    defaultAttributes: ?*const MLOperatorAttributeNameValue,
    defaultAttributeCount: u32,
    options: MLOperatorKernelOptions,
    executionOptions: u32,
};

const IID_IMLOperatorKernelFactory_Value = Guid.initString("ef15ad6f-0dc9-4908-ab35-a575a30dfbf8");
pub const IID_IMLOperatorKernelFactory = &IID_IMLOperatorKernelFactory_Value;
pub const IMLOperatorKernelFactory = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        CreateKernel: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorKernelFactory,
                context: ?*IMLOperatorKernelCreationContext,
                kernel: ?*?*IMLOperatorKernel,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorKernelFactory,
                context: ?*IMLOperatorKernelCreationContext,
                kernel: ?*?*IMLOperatorKernel,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorKernelFactory_CreateKernel(self: *const T, context: ?*IMLOperatorKernelCreationContext, kernel: ?*?*IMLOperatorKernel) HRESULT {
                return @as(*const IMLOperatorKernelFactory.VTable, @ptrCast(self.vtable)).CreateKernel(@as(*const IMLOperatorKernelFactory, @ptrCast(self)), context, kernel);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IMLOperatorRegistry_Value = Guid.initString("2af9dd2d-b516-4672-9ab5-530c208493ad");
pub const IID_IMLOperatorRegistry = &IID_IMLOperatorRegistry_Value;
pub const IMLOperatorRegistry = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        RegisterOperatorSetSchema: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorRegistry,
                operatorSetId: ?*const MLOperatorSetId,
                baselineVersion: i32,
                schema: ?[*]const ?*const MLOperatorSchemaDescription,
                schemaCount: u32,
                typeInferrer: ?*IMLOperatorTypeInferrer,
                shapeInferrer: ?*IMLOperatorShapeInferrer,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorRegistry,
                operatorSetId: ?*const MLOperatorSetId,
                baselineVersion: i32,
                schema: ?[*]const ?*const MLOperatorSchemaDescription,
                schemaCount: u32,
                typeInferrer: ?*IMLOperatorTypeInferrer,
                shapeInferrer: ?*IMLOperatorShapeInferrer,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        RegisterOperatorKernel: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IMLOperatorRegistry,
                operatorKernel: ?*const MLOperatorKernelDescription,
                operatorKernelFactory: ?*IMLOperatorKernelFactory,
                shapeInferrer: ?*IMLOperatorShapeInferrer,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IMLOperatorRegistry,
                operatorKernel: ?*const MLOperatorKernelDescription,
                operatorKernelFactory: ?*IMLOperatorKernelFactory,
                shapeInferrer: ?*IMLOperatorShapeInferrer,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorRegistry_RegisterOperatorSetSchema(self: *const T, operatorSetId: ?*const MLOperatorSetId, baselineVersion: i32, schema: ?[*]const ?*const MLOperatorSchemaDescription, schemaCount: u32, typeInferrer: ?*IMLOperatorTypeInferrer, shapeInferrer: ?*IMLOperatorShapeInferrer) HRESULT {
                return @as(*const IMLOperatorRegistry.VTable, @ptrCast(self.vtable)).RegisterOperatorSetSchema(@as(*const IMLOperatorRegistry, @ptrCast(self)), operatorSetId, baselineVersion, schema, schemaCount, typeInferrer, shapeInferrer);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IMLOperatorRegistry_RegisterOperatorKernel(self: *const T, operatorKernel: ?*const MLOperatorKernelDescription, operatorKernelFactory: ?*IMLOperatorKernelFactory, shapeInferrer: ?*IMLOperatorShapeInferrer) HRESULT {
                return @as(*const IMLOperatorRegistry.VTable, @ptrCast(self.vtable)).RegisterOperatorKernel(@as(*const IMLOperatorRegistry, @ptrCast(self)), operatorKernel, operatorKernelFactory, shapeInferrer);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

//--------------------------------------------------------------------------------
// Section: Functions (2)
//--------------------------------------------------------------------------------
pub extern "winml" fn WinMLCreateRuntime(
    runtime: ?*?*IWinMLRuntime,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "windows.ai.machinelearning" fn MLCreateOperatorRegistry(
    registry: ?*?*IMLOperatorRegistry,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (8)
//--------------------------------------------------------------------------------
const Guid = @import("../../zig.zig").Guid;
const BOOL = @import("../../foundation.zig").BOOL;
const HRESULT = @import("../../foundation.zig").HRESULT;
const ID3D12Device = @import("../../graphics/direct3d12.zig").ID3D12Device;
const ID3D12Resource = @import("../../graphics/direct3d12.zig").ID3D12Resource;
const IUnknown = @import("../../system/com.zig").IUnknown;
const PSTR = @import("../../foundation.zig").PSTR;
const PWSTR = @import("../../foundation.zig").PWSTR;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
