//! NOTE: this file is autogenerated, DO NOT MODIFY
//--------------------------------------------------------------------------------
// Section: Constants (6)
//--------------------------------------------------------------------------------
pub const DML_TARGET_VERSION = @as(u32, 16384);
pub const DML_TENSOR_DIMENSION_COUNT_MAX = @as(u32, 5);
pub const DML_TENSOR_DIMENSION_COUNT_MAX1 = @as(u32, 8);
pub const DML_TEMPORARY_BUFFER_ALIGNMENT = @as(u32, 256);
pub const DML_PERSISTENT_BUFFER_ALIGNMENT = @as(u32, 256);
pub const DML_MINIMUM_BUFFER_TENSOR_ALIGNMENT = @as(u32, 16);

//--------------------------------------------------------------------------------
// Section: Types (206)
//--------------------------------------------------------------------------------
pub const DML_TENSOR_DATA_TYPE = enum(i32) {
    UNKNOWN = 0,
    FLOAT32 = 1,
    FLOAT16 = 2,
    UINT32 = 3,
    UINT16 = 4,
    UINT8 = 5,
    INT32 = 6,
    INT16 = 7,
    INT8 = 8,
    FLOAT64 = 9,
    UINT64 = 10,
    INT64 = 11,
};
pub const DML_TENSOR_DATA_TYPE_UNKNOWN = DML_TENSOR_DATA_TYPE.UNKNOWN;
pub const DML_TENSOR_DATA_TYPE_FLOAT32 = DML_TENSOR_DATA_TYPE.FLOAT32;
pub const DML_TENSOR_DATA_TYPE_FLOAT16 = DML_TENSOR_DATA_TYPE.FLOAT16;
pub const DML_TENSOR_DATA_TYPE_UINT32 = DML_TENSOR_DATA_TYPE.UINT32;
pub const DML_TENSOR_DATA_TYPE_UINT16 = DML_TENSOR_DATA_TYPE.UINT16;
pub const DML_TENSOR_DATA_TYPE_UINT8 = DML_TENSOR_DATA_TYPE.UINT8;
pub const DML_TENSOR_DATA_TYPE_INT32 = DML_TENSOR_DATA_TYPE.INT32;
pub const DML_TENSOR_DATA_TYPE_INT16 = DML_TENSOR_DATA_TYPE.INT16;
pub const DML_TENSOR_DATA_TYPE_INT8 = DML_TENSOR_DATA_TYPE.INT8;
pub const DML_TENSOR_DATA_TYPE_FLOAT64 = DML_TENSOR_DATA_TYPE.FLOAT64;
pub const DML_TENSOR_DATA_TYPE_UINT64 = DML_TENSOR_DATA_TYPE.UINT64;
pub const DML_TENSOR_DATA_TYPE_INT64 = DML_TENSOR_DATA_TYPE.INT64;

pub const DML_TENSOR_TYPE = enum(i32) {
    INVALID = 0,
    BUFFER = 1,
};
pub const DML_TENSOR_TYPE_INVALID = DML_TENSOR_TYPE.INVALID;
pub const DML_TENSOR_TYPE_BUFFER = DML_TENSOR_TYPE.BUFFER;

pub const DML_TENSOR_FLAGS = enum(u32) {
    NONE = 0,
    OWNED_BY_DML = 1,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        OWNED_BY_DML: u1 = 0,
    }) DML_TENSOR_FLAGS {
        return @as(DML_TENSOR_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(DML_TENSOR_FLAGS.NONE) else 0) | (if (o.OWNED_BY_DML == 1) @intFromEnum(DML_TENSOR_FLAGS.OWNED_BY_DML) else 0)));
    }
};
pub const DML_TENSOR_FLAG_NONE = DML_TENSOR_FLAGS.NONE;
pub const DML_TENSOR_FLAG_OWNED_BY_DML = DML_TENSOR_FLAGS.OWNED_BY_DML;

pub const DML_BUFFER_TENSOR_DESC = extern struct {
    DataType: DML_TENSOR_DATA_TYPE,
    Flags: DML_TENSOR_FLAGS,
    DimensionCount: u32,
    Sizes: ?*const u32,
    Strides: ?*const u32,
    TotalTensorSizeInBytes: u64,
    GuaranteedBaseOffsetAlignment: u32,
};

pub const DML_TENSOR_DESC = extern struct {
    Type: DML_TENSOR_TYPE,
    Desc: ?*const anyopaque,
};

pub const DML_OPERATOR_TYPE = enum(i32) {
    INVALID = 0,
    ELEMENT_WISE_IDENTITY = 1,
    ELEMENT_WISE_ABS = 2,
    ELEMENT_WISE_ACOS = 3,
    ELEMENT_WISE_ADD = 4,
    ELEMENT_WISE_ASIN = 5,
    ELEMENT_WISE_ATAN = 6,
    ELEMENT_WISE_CEIL = 7,
    ELEMENT_WISE_CLIP = 8,
    ELEMENT_WISE_COS = 9,
    ELEMENT_WISE_DIVIDE = 10,
    ELEMENT_WISE_EXP = 11,
    ELEMENT_WISE_FLOOR = 12,
    ELEMENT_WISE_LOG = 13,
    ELEMENT_WISE_LOGICAL_AND = 14,
    ELEMENT_WISE_LOGICAL_EQUALS = 15,
    ELEMENT_WISE_LOGICAL_GREATER_THAN = 16,
    ELEMENT_WISE_LOGICAL_LESS_THAN = 17,
    ELEMENT_WISE_LOGICAL_NOT = 18,
    ELEMENT_WISE_LOGICAL_OR = 19,
    ELEMENT_WISE_LOGICAL_XOR = 20,
    ELEMENT_WISE_MAX = 21,
    ELEMENT_WISE_MEAN = 22,
    ELEMENT_WISE_MIN = 23,
    ELEMENT_WISE_MULTIPLY = 24,
    ELEMENT_WISE_POW = 25,
    ELEMENT_WISE_CONSTANT_POW = 26,
    ELEMENT_WISE_RECIP = 27,
    ELEMENT_WISE_SIN = 28,
    ELEMENT_WISE_SQRT = 29,
    ELEMENT_WISE_SUBTRACT = 30,
    ELEMENT_WISE_TAN = 31,
    ELEMENT_WISE_THRESHOLD = 32,
    ELEMENT_WISE_QUANTIZE_LINEAR = 33,
    ELEMENT_WISE_DEQUANTIZE_LINEAR = 34,
    ACTIVATION_ELU = 35,
    ACTIVATION_HARDMAX = 36,
    ACTIVATION_HARD_SIGMOID = 37,
    ACTIVATION_IDENTITY = 38,
    ACTIVATION_LEAKY_RELU = 39,
    ACTIVATION_LINEAR = 40,
    ACTIVATION_LOG_SOFTMAX = 41,
    ACTIVATION_PARAMETERIZED_RELU = 42,
    ACTIVATION_PARAMETRIC_SOFTPLUS = 43,
    ACTIVATION_RELU = 44,
    ACTIVATION_SCALED_ELU = 45,
    ACTIVATION_SCALED_TANH = 46,
    ACTIVATION_SIGMOID = 47,
    ACTIVATION_SOFTMAX = 48,
    ACTIVATION_SOFTPLUS = 49,
    ACTIVATION_SOFTSIGN = 50,
    ACTIVATION_TANH = 51,
    ACTIVATION_THRESHOLDED_RELU = 52,
    CONVOLUTION = 53,
    GEMM = 54,
    REDUCE = 55,
    AVERAGE_POOLING = 56,
    LP_POOLING = 57,
    MAX_POOLING = 58,
    ROI_POOLING = 59,
    SLICE = 60,
    CAST = 61,
    SPLIT = 62,
    JOIN = 63,
    PADDING = 64,
    VALUE_SCALE_2D = 65,
    UPSAMPLE_2D = 66,
    GATHER = 67,
    SPACE_TO_DEPTH = 68,
    DEPTH_TO_SPACE = 69,
    TILE = 70,
    TOP_K = 71,
    BATCH_NORMALIZATION = 72,
    MEAN_VARIANCE_NORMALIZATION = 73,
    LOCAL_RESPONSE_NORMALIZATION = 74,
    LP_NORMALIZATION = 75,
    RNN = 76,
    LSTM = 77,
    GRU = 78,
    ELEMENT_WISE_SIGN = 79,
    ELEMENT_WISE_IS_NAN = 80,
    ELEMENT_WISE_ERF = 81,
    ELEMENT_WISE_SINH = 82,
    ELEMENT_WISE_COSH = 83,
    ELEMENT_WISE_TANH = 84,
    ELEMENT_WISE_ASINH = 85,
    ELEMENT_WISE_ACOSH = 86,
    ELEMENT_WISE_ATANH = 87,
    ELEMENT_WISE_IF = 88,
    ELEMENT_WISE_ADD1 = 89,
    ACTIVATION_SHRINK = 90,
    MAX_POOLING1 = 91,
    MAX_UNPOOLING = 92,
    DIAGONAL_MATRIX = 93,
    SCATTER_ELEMENTS = 94,
    // SCATTER = 94, this enum value conflicts with SCATTER_ELEMENTS
    ONE_HOT = 95,
    RESAMPLE = 96,
    ELEMENT_WISE_BIT_SHIFT_LEFT = 97,
    ELEMENT_WISE_BIT_SHIFT_RIGHT = 98,
    ELEMENT_WISE_ROUND = 99,
    ELEMENT_WISE_IS_INFINITY = 100,
    ELEMENT_WISE_MODULUS_TRUNCATE = 101,
    ELEMENT_WISE_MODULUS_FLOOR = 102,
    FILL_VALUE_CONSTANT = 103,
    FILL_VALUE_SEQUENCE = 104,
    CUMULATIVE_SUMMATION = 105,
    REVERSE_SUBSEQUENCES = 106,
    GATHER_ELEMENTS = 107,
    GATHER_ND = 108,
    SCATTER_ND = 109,
    MAX_POOLING2 = 110,
    SLICE1 = 111,
    TOP_K1 = 112,
    DEPTH_TO_SPACE1 = 113,
    SPACE_TO_DEPTH1 = 114,
    MEAN_VARIANCE_NORMALIZATION1 = 115,
    RESAMPLE1 = 116,
    MATRIX_MULTIPLY_INTEGER = 117,
    QUANTIZED_LINEAR_MATRIX_MULTIPLY = 118,
    CONVOLUTION_INTEGER = 119,
    QUANTIZED_LINEAR_CONVOLUTION = 120,
    ELEMENT_WISE_BIT_AND = 121,
    ELEMENT_WISE_BIT_OR = 122,
    ELEMENT_WISE_BIT_XOR = 123,
    ELEMENT_WISE_BIT_NOT = 124,
    ELEMENT_WISE_BIT_COUNT = 125,
    ELEMENT_WISE_LOGICAL_GREATER_THAN_OR_EQUAL = 126,
    ELEMENT_WISE_LOGICAL_LESS_THAN_OR_EQUAL = 127,
    ACTIVATION_CELU = 128,
    ACTIVATION_RELU_GRAD = 129,
    AVERAGE_POOLING_GRAD = 130,
    MAX_POOLING_GRAD = 131,
    RANDOM_GENERATOR = 132,
    NONZERO_COORDINATES = 133,
    RESAMPLE_GRAD = 134,
    SLICE_GRAD = 135,
    ADAM_OPTIMIZER = 136,
    ARGMIN = 137,
    ARGMAX = 138,
    ROI_ALIGN = 139,
    GATHER_ND1 = 140,
    ELEMENT_WISE_ATAN_YX = 141,
    ELEMENT_WISE_CLIP_GRAD = 142,
    ELEMENT_WISE_DIFFERENCE_SQUARE = 143,
    LOCAL_RESPONSE_NORMALIZATION_GRAD = 144,
    CUMULATIVE_PRODUCT = 145,
    BATCH_NORMALIZATION_GRAD = 146,
    ELEMENT_WISE_QUANTIZED_LINEAR_ADD = 147,
    DYNAMIC_QUANTIZE_LINEAR = 148,
    ROI_ALIGN1 = 149,
};
pub const DML_OPERATOR_INVALID = DML_OPERATOR_TYPE.INVALID;
pub const DML_OPERATOR_ELEMENT_WISE_IDENTITY = DML_OPERATOR_TYPE.ELEMENT_WISE_IDENTITY;
pub const DML_OPERATOR_ELEMENT_WISE_ABS = DML_OPERATOR_TYPE.ELEMENT_WISE_ABS;
pub const DML_OPERATOR_ELEMENT_WISE_ACOS = DML_OPERATOR_TYPE.ELEMENT_WISE_ACOS;
pub const DML_OPERATOR_ELEMENT_WISE_ADD = DML_OPERATOR_TYPE.ELEMENT_WISE_ADD;
pub const DML_OPERATOR_ELEMENT_WISE_ASIN = DML_OPERATOR_TYPE.ELEMENT_WISE_ASIN;
pub const DML_OPERATOR_ELEMENT_WISE_ATAN = DML_OPERATOR_TYPE.ELEMENT_WISE_ATAN;
pub const DML_OPERATOR_ELEMENT_WISE_CEIL = DML_OPERATOR_TYPE.ELEMENT_WISE_CEIL;
pub const DML_OPERATOR_ELEMENT_WISE_CLIP = DML_OPERATOR_TYPE.ELEMENT_WISE_CLIP;
pub const DML_OPERATOR_ELEMENT_WISE_COS = DML_OPERATOR_TYPE.ELEMENT_WISE_COS;
pub const DML_OPERATOR_ELEMENT_WISE_DIVIDE = DML_OPERATOR_TYPE.ELEMENT_WISE_DIVIDE;
pub const DML_OPERATOR_ELEMENT_WISE_EXP = DML_OPERATOR_TYPE.ELEMENT_WISE_EXP;
pub const DML_OPERATOR_ELEMENT_WISE_FLOOR = DML_OPERATOR_TYPE.ELEMENT_WISE_FLOOR;
pub const DML_OPERATOR_ELEMENT_WISE_LOG = DML_OPERATOR_TYPE.ELEMENT_WISE_LOG;
pub const DML_OPERATOR_ELEMENT_WISE_LOGICAL_AND = DML_OPERATOR_TYPE.ELEMENT_WISE_LOGICAL_AND;
pub const DML_OPERATOR_ELEMENT_WISE_LOGICAL_EQUALS = DML_OPERATOR_TYPE.ELEMENT_WISE_LOGICAL_EQUALS;
pub const DML_OPERATOR_ELEMENT_WISE_LOGICAL_GREATER_THAN = DML_OPERATOR_TYPE.ELEMENT_WISE_LOGICAL_GREATER_THAN;
pub const DML_OPERATOR_ELEMENT_WISE_LOGICAL_LESS_THAN = DML_OPERATOR_TYPE.ELEMENT_WISE_LOGICAL_LESS_THAN;
pub const DML_OPERATOR_ELEMENT_WISE_LOGICAL_NOT = DML_OPERATOR_TYPE.ELEMENT_WISE_LOGICAL_NOT;
pub const DML_OPERATOR_ELEMENT_WISE_LOGICAL_OR = DML_OPERATOR_TYPE.ELEMENT_WISE_LOGICAL_OR;
pub const DML_OPERATOR_ELEMENT_WISE_LOGICAL_XOR = DML_OPERATOR_TYPE.ELEMENT_WISE_LOGICAL_XOR;
pub const DML_OPERATOR_ELEMENT_WISE_MAX = DML_OPERATOR_TYPE.ELEMENT_WISE_MAX;
pub const DML_OPERATOR_ELEMENT_WISE_MEAN = DML_OPERATOR_TYPE.ELEMENT_WISE_MEAN;
pub const DML_OPERATOR_ELEMENT_WISE_MIN = DML_OPERATOR_TYPE.ELEMENT_WISE_MIN;
pub const DML_OPERATOR_ELEMENT_WISE_MULTIPLY = DML_OPERATOR_TYPE.ELEMENT_WISE_MULTIPLY;
pub const DML_OPERATOR_ELEMENT_WISE_POW = DML_OPERATOR_TYPE.ELEMENT_WISE_POW;
pub const DML_OPERATOR_ELEMENT_WISE_CONSTANT_POW = DML_OPERATOR_TYPE.ELEMENT_WISE_CONSTANT_POW;
pub const DML_OPERATOR_ELEMENT_WISE_RECIP = DML_OPERATOR_TYPE.ELEMENT_WISE_RECIP;
pub const DML_OPERATOR_ELEMENT_WISE_SIN = DML_OPERATOR_TYPE.ELEMENT_WISE_SIN;
pub const DML_OPERATOR_ELEMENT_WISE_SQRT = DML_OPERATOR_TYPE.ELEMENT_WISE_SQRT;
pub const DML_OPERATOR_ELEMENT_WISE_SUBTRACT = DML_OPERATOR_TYPE.ELEMENT_WISE_SUBTRACT;
pub const DML_OPERATOR_ELEMENT_WISE_TAN = DML_OPERATOR_TYPE.ELEMENT_WISE_TAN;
pub const DML_OPERATOR_ELEMENT_WISE_THRESHOLD = DML_OPERATOR_TYPE.ELEMENT_WISE_THRESHOLD;
pub const DML_OPERATOR_ELEMENT_WISE_QUANTIZE_LINEAR = DML_OPERATOR_TYPE.ELEMENT_WISE_QUANTIZE_LINEAR;
pub const DML_OPERATOR_ELEMENT_WISE_DEQUANTIZE_LINEAR = DML_OPERATOR_TYPE.ELEMENT_WISE_DEQUANTIZE_LINEAR;
pub const DML_OPERATOR_ACTIVATION_ELU = DML_OPERATOR_TYPE.ACTIVATION_ELU;
pub const DML_OPERATOR_ACTIVATION_HARDMAX = DML_OPERATOR_TYPE.ACTIVATION_HARDMAX;
pub const DML_OPERATOR_ACTIVATION_HARD_SIGMOID = DML_OPERATOR_TYPE.ACTIVATION_HARD_SIGMOID;
pub const DML_OPERATOR_ACTIVATION_IDENTITY = DML_OPERATOR_TYPE.ACTIVATION_IDENTITY;
pub const DML_OPERATOR_ACTIVATION_LEAKY_RELU = DML_OPERATOR_TYPE.ACTIVATION_LEAKY_RELU;
pub const DML_OPERATOR_ACTIVATION_LINEAR = DML_OPERATOR_TYPE.ACTIVATION_LINEAR;
pub const DML_OPERATOR_ACTIVATION_LOG_SOFTMAX = DML_OPERATOR_TYPE.ACTIVATION_LOG_SOFTMAX;
pub const DML_OPERATOR_ACTIVATION_PARAMETERIZED_RELU = DML_OPERATOR_TYPE.ACTIVATION_PARAMETERIZED_RELU;
pub const DML_OPERATOR_ACTIVATION_PARAMETRIC_SOFTPLUS = DML_OPERATOR_TYPE.ACTIVATION_PARAMETRIC_SOFTPLUS;
pub const DML_OPERATOR_ACTIVATION_RELU = DML_OPERATOR_TYPE.ACTIVATION_RELU;
pub const DML_OPERATOR_ACTIVATION_SCALED_ELU = DML_OPERATOR_TYPE.ACTIVATION_SCALED_ELU;
pub const DML_OPERATOR_ACTIVATION_SCALED_TANH = DML_OPERATOR_TYPE.ACTIVATION_SCALED_TANH;
pub const DML_OPERATOR_ACTIVATION_SIGMOID = DML_OPERATOR_TYPE.ACTIVATION_SIGMOID;
pub const DML_OPERATOR_ACTIVATION_SOFTMAX = DML_OPERATOR_TYPE.ACTIVATION_SOFTMAX;
pub const DML_OPERATOR_ACTIVATION_SOFTPLUS = DML_OPERATOR_TYPE.ACTIVATION_SOFTPLUS;
pub const DML_OPERATOR_ACTIVATION_SOFTSIGN = DML_OPERATOR_TYPE.ACTIVATION_SOFTSIGN;
pub const DML_OPERATOR_ACTIVATION_TANH = DML_OPERATOR_TYPE.ACTIVATION_TANH;
pub const DML_OPERATOR_ACTIVATION_THRESHOLDED_RELU = DML_OPERATOR_TYPE.ACTIVATION_THRESHOLDED_RELU;
pub const DML_OPERATOR_CONVOLUTION = DML_OPERATOR_TYPE.CONVOLUTION;
pub const DML_OPERATOR_GEMM = DML_OPERATOR_TYPE.GEMM;
pub const DML_OPERATOR_REDUCE = DML_OPERATOR_TYPE.REDUCE;
pub const DML_OPERATOR_AVERAGE_POOLING = DML_OPERATOR_TYPE.AVERAGE_POOLING;
pub const DML_OPERATOR_LP_POOLING = DML_OPERATOR_TYPE.LP_POOLING;
pub const DML_OPERATOR_MAX_POOLING = DML_OPERATOR_TYPE.MAX_POOLING;
pub const DML_OPERATOR_ROI_POOLING = DML_OPERATOR_TYPE.ROI_POOLING;
pub const DML_OPERATOR_SLICE = DML_OPERATOR_TYPE.SLICE;
pub const DML_OPERATOR_CAST = DML_OPERATOR_TYPE.CAST;
pub const DML_OPERATOR_SPLIT = DML_OPERATOR_TYPE.SPLIT;
pub const DML_OPERATOR_JOIN = DML_OPERATOR_TYPE.JOIN;
pub const DML_OPERATOR_PADDING = DML_OPERATOR_TYPE.PADDING;
pub const DML_OPERATOR_VALUE_SCALE_2D = DML_OPERATOR_TYPE.VALUE_SCALE_2D;
pub const DML_OPERATOR_UPSAMPLE_2D = DML_OPERATOR_TYPE.UPSAMPLE_2D;
pub const DML_OPERATOR_GATHER = DML_OPERATOR_TYPE.GATHER;
pub const DML_OPERATOR_SPACE_TO_DEPTH = DML_OPERATOR_TYPE.SPACE_TO_DEPTH;
pub const DML_OPERATOR_DEPTH_TO_SPACE = DML_OPERATOR_TYPE.DEPTH_TO_SPACE;
pub const DML_OPERATOR_TILE = DML_OPERATOR_TYPE.TILE;
pub const DML_OPERATOR_TOP_K = DML_OPERATOR_TYPE.TOP_K;
pub const DML_OPERATOR_BATCH_NORMALIZATION = DML_OPERATOR_TYPE.BATCH_NORMALIZATION;
pub const DML_OPERATOR_MEAN_VARIANCE_NORMALIZATION = DML_OPERATOR_TYPE.MEAN_VARIANCE_NORMALIZATION;
pub const DML_OPERATOR_LOCAL_RESPONSE_NORMALIZATION = DML_OPERATOR_TYPE.LOCAL_RESPONSE_NORMALIZATION;
pub const DML_OPERATOR_LP_NORMALIZATION = DML_OPERATOR_TYPE.LP_NORMALIZATION;
pub const DML_OPERATOR_RNN = DML_OPERATOR_TYPE.RNN;
pub const DML_OPERATOR_LSTM = DML_OPERATOR_TYPE.LSTM;
pub const DML_OPERATOR_GRU = DML_OPERATOR_TYPE.GRU;
pub const DML_OPERATOR_ELEMENT_WISE_SIGN = DML_OPERATOR_TYPE.ELEMENT_WISE_SIGN;
pub const DML_OPERATOR_ELEMENT_WISE_IS_NAN = DML_OPERATOR_TYPE.ELEMENT_WISE_IS_NAN;
pub const DML_OPERATOR_ELEMENT_WISE_ERF = DML_OPERATOR_TYPE.ELEMENT_WISE_ERF;
pub const DML_OPERATOR_ELEMENT_WISE_SINH = DML_OPERATOR_TYPE.ELEMENT_WISE_SINH;
pub const DML_OPERATOR_ELEMENT_WISE_COSH = DML_OPERATOR_TYPE.ELEMENT_WISE_COSH;
pub const DML_OPERATOR_ELEMENT_WISE_TANH = DML_OPERATOR_TYPE.ELEMENT_WISE_TANH;
pub const DML_OPERATOR_ELEMENT_WISE_ASINH = DML_OPERATOR_TYPE.ELEMENT_WISE_ASINH;
pub const DML_OPERATOR_ELEMENT_WISE_ACOSH = DML_OPERATOR_TYPE.ELEMENT_WISE_ACOSH;
pub const DML_OPERATOR_ELEMENT_WISE_ATANH = DML_OPERATOR_TYPE.ELEMENT_WISE_ATANH;
pub const DML_OPERATOR_ELEMENT_WISE_IF = DML_OPERATOR_TYPE.ELEMENT_WISE_IF;
pub const DML_OPERATOR_ELEMENT_WISE_ADD1 = DML_OPERATOR_TYPE.ELEMENT_WISE_ADD1;
pub const DML_OPERATOR_ACTIVATION_SHRINK = DML_OPERATOR_TYPE.ACTIVATION_SHRINK;
pub const DML_OPERATOR_MAX_POOLING1 = DML_OPERATOR_TYPE.MAX_POOLING1;
pub const DML_OPERATOR_MAX_UNPOOLING = DML_OPERATOR_TYPE.MAX_UNPOOLING;
pub const DML_OPERATOR_DIAGONAL_MATRIX = DML_OPERATOR_TYPE.DIAGONAL_MATRIX;
pub const DML_OPERATOR_SCATTER_ELEMENTS = DML_OPERATOR_TYPE.SCATTER_ELEMENTS;
pub const DML_OPERATOR_SCATTER = DML_OPERATOR_TYPE.SCATTER_ELEMENTS;
pub const DML_OPERATOR_ONE_HOT = DML_OPERATOR_TYPE.ONE_HOT;
pub const DML_OPERATOR_RESAMPLE = DML_OPERATOR_TYPE.RESAMPLE;
pub const DML_OPERATOR_ELEMENT_WISE_BIT_SHIFT_LEFT = DML_OPERATOR_TYPE.ELEMENT_WISE_BIT_SHIFT_LEFT;
pub const DML_OPERATOR_ELEMENT_WISE_BIT_SHIFT_RIGHT = DML_OPERATOR_TYPE.ELEMENT_WISE_BIT_SHIFT_RIGHT;
pub const DML_OPERATOR_ELEMENT_WISE_ROUND = DML_OPERATOR_TYPE.ELEMENT_WISE_ROUND;
pub const DML_OPERATOR_ELEMENT_WISE_IS_INFINITY = DML_OPERATOR_TYPE.ELEMENT_WISE_IS_INFINITY;
pub const DML_OPERATOR_ELEMENT_WISE_MODULUS_TRUNCATE = DML_OPERATOR_TYPE.ELEMENT_WISE_MODULUS_TRUNCATE;
pub const DML_OPERATOR_ELEMENT_WISE_MODULUS_FLOOR = DML_OPERATOR_TYPE.ELEMENT_WISE_MODULUS_FLOOR;
pub const DML_OPERATOR_FILL_VALUE_CONSTANT = DML_OPERATOR_TYPE.FILL_VALUE_CONSTANT;
pub const DML_OPERATOR_FILL_VALUE_SEQUENCE = DML_OPERATOR_TYPE.FILL_VALUE_SEQUENCE;
pub const DML_OPERATOR_CUMULATIVE_SUMMATION = DML_OPERATOR_TYPE.CUMULATIVE_SUMMATION;
pub const DML_OPERATOR_REVERSE_SUBSEQUENCES = DML_OPERATOR_TYPE.REVERSE_SUBSEQUENCES;
pub const DML_OPERATOR_GATHER_ELEMENTS = DML_OPERATOR_TYPE.GATHER_ELEMENTS;
pub const DML_OPERATOR_GATHER_ND = DML_OPERATOR_TYPE.GATHER_ND;
pub const DML_OPERATOR_SCATTER_ND = DML_OPERATOR_TYPE.SCATTER_ND;
pub const DML_OPERATOR_MAX_POOLING2 = DML_OPERATOR_TYPE.MAX_POOLING2;
pub const DML_OPERATOR_SLICE1 = DML_OPERATOR_TYPE.SLICE1;
pub const DML_OPERATOR_TOP_K1 = DML_OPERATOR_TYPE.TOP_K1;
pub const DML_OPERATOR_DEPTH_TO_SPACE1 = DML_OPERATOR_TYPE.DEPTH_TO_SPACE1;
pub const DML_OPERATOR_SPACE_TO_DEPTH1 = DML_OPERATOR_TYPE.SPACE_TO_DEPTH1;
pub const DML_OPERATOR_MEAN_VARIANCE_NORMALIZATION1 = DML_OPERATOR_TYPE.MEAN_VARIANCE_NORMALIZATION1;
pub const DML_OPERATOR_RESAMPLE1 = DML_OPERATOR_TYPE.RESAMPLE1;
pub const DML_OPERATOR_MATRIX_MULTIPLY_INTEGER = DML_OPERATOR_TYPE.MATRIX_MULTIPLY_INTEGER;
pub const DML_OPERATOR_QUANTIZED_LINEAR_MATRIX_MULTIPLY = DML_OPERATOR_TYPE.QUANTIZED_LINEAR_MATRIX_MULTIPLY;
pub const DML_OPERATOR_CONVOLUTION_INTEGER = DML_OPERATOR_TYPE.CONVOLUTION_INTEGER;
pub const DML_OPERATOR_QUANTIZED_LINEAR_CONVOLUTION = DML_OPERATOR_TYPE.QUANTIZED_LINEAR_CONVOLUTION;
pub const DML_OPERATOR_ELEMENT_WISE_BIT_AND = DML_OPERATOR_TYPE.ELEMENT_WISE_BIT_AND;
pub const DML_OPERATOR_ELEMENT_WISE_BIT_OR = DML_OPERATOR_TYPE.ELEMENT_WISE_BIT_OR;
pub const DML_OPERATOR_ELEMENT_WISE_BIT_XOR = DML_OPERATOR_TYPE.ELEMENT_WISE_BIT_XOR;
pub const DML_OPERATOR_ELEMENT_WISE_BIT_NOT = DML_OPERATOR_TYPE.ELEMENT_WISE_BIT_NOT;
pub const DML_OPERATOR_ELEMENT_WISE_BIT_COUNT = DML_OPERATOR_TYPE.ELEMENT_WISE_BIT_COUNT;
pub const DML_OPERATOR_ELEMENT_WISE_LOGICAL_GREATER_THAN_OR_EQUAL = DML_OPERATOR_TYPE.ELEMENT_WISE_LOGICAL_GREATER_THAN_OR_EQUAL;
pub const DML_OPERATOR_ELEMENT_WISE_LOGICAL_LESS_THAN_OR_EQUAL = DML_OPERATOR_TYPE.ELEMENT_WISE_LOGICAL_LESS_THAN_OR_EQUAL;
pub const DML_OPERATOR_ACTIVATION_CELU = DML_OPERATOR_TYPE.ACTIVATION_CELU;
pub const DML_OPERATOR_ACTIVATION_RELU_GRAD = DML_OPERATOR_TYPE.ACTIVATION_RELU_GRAD;
pub const DML_OPERATOR_AVERAGE_POOLING_GRAD = DML_OPERATOR_TYPE.AVERAGE_POOLING_GRAD;
pub const DML_OPERATOR_MAX_POOLING_GRAD = DML_OPERATOR_TYPE.MAX_POOLING_GRAD;
pub const DML_OPERATOR_RANDOM_GENERATOR = DML_OPERATOR_TYPE.RANDOM_GENERATOR;
pub const DML_OPERATOR_NONZERO_COORDINATES = DML_OPERATOR_TYPE.NONZERO_COORDINATES;
pub const DML_OPERATOR_RESAMPLE_GRAD = DML_OPERATOR_TYPE.RESAMPLE_GRAD;
pub const DML_OPERATOR_SLICE_GRAD = DML_OPERATOR_TYPE.SLICE_GRAD;
pub const DML_OPERATOR_ADAM_OPTIMIZER = DML_OPERATOR_TYPE.ADAM_OPTIMIZER;
pub const DML_OPERATOR_ARGMIN = DML_OPERATOR_TYPE.ARGMIN;
pub const DML_OPERATOR_ARGMAX = DML_OPERATOR_TYPE.ARGMAX;
pub const DML_OPERATOR_ROI_ALIGN = DML_OPERATOR_TYPE.ROI_ALIGN;
pub const DML_OPERATOR_GATHER_ND1 = DML_OPERATOR_TYPE.GATHER_ND1;
pub const DML_OPERATOR_ELEMENT_WISE_ATAN_YX = DML_OPERATOR_TYPE.ELEMENT_WISE_ATAN_YX;
pub const DML_OPERATOR_ELEMENT_WISE_CLIP_GRAD = DML_OPERATOR_TYPE.ELEMENT_WISE_CLIP_GRAD;
pub const DML_OPERATOR_ELEMENT_WISE_DIFFERENCE_SQUARE = DML_OPERATOR_TYPE.ELEMENT_WISE_DIFFERENCE_SQUARE;
pub const DML_OPERATOR_LOCAL_RESPONSE_NORMALIZATION_GRAD = DML_OPERATOR_TYPE.LOCAL_RESPONSE_NORMALIZATION_GRAD;
pub const DML_OPERATOR_CUMULATIVE_PRODUCT = DML_OPERATOR_TYPE.CUMULATIVE_PRODUCT;
pub const DML_OPERATOR_BATCH_NORMALIZATION_GRAD = DML_OPERATOR_TYPE.BATCH_NORMALIZATION_GRAD;
pub const DML_OPERATOR_ELEMENT_WISE_QUANTIZED_LINEAR_ADD = DML_OPERATOR_TYPE.ELEMENT_WISE_QUANTIZED_LINEAR_ADD;
pub const DML_OPERATOR_DYNAMIC_QUANTIZE_LINEAR = DML_OPERATOR_TYPE.DYNAMIC_QUANTIZE_LINEAR;
pub const DML_OPERATOR_ROI_ALIGN1 = DML_OPERATOR_TYPE.ROI_ALIGN1;

pub const DML_REDUCE_FUNCTION = enum(i32) {
    ARGMAX = 0,
    ARGMIN = 1,
    AVERAGE = 2,
    L1 = 3,
    L2 = 4,
    LOG_SUM = 5,
    LOG_SUM_EXP = 6,
    MAX = 7,
    MIN = 8,
    MULTIPLY = 9,
    SUM = 10,
    SUM_SQUARE = 11,
};
pub const DML_REDUCE_FUNCTION_ARGMAX = DML_REDUCE_FUNCTION.ARGMAX;
pub const DML_REDUCE_FUNCTION_ARGMIN = DML_REDUCE_FUNCTION.ARGMIN;
pub const DML_REDUCE_FUNCTION_AVERAGE = DML_REDUCE_FUNCTION.AVERAGE;
pub const DML_REDUCE_FUNCTION_L1 = DML_REDUCE_FUNCTION.L1;
pub const DML_REDUCE_FUNCTION_L2 = DML_REDUCE_FUNCTION.L2;
pub const DML_REDUCE_FUNCTION_LOG_SUM = DML_REDUCE_FUNCTION.LOG_SUM;
pub const DML_REDUCE_FUNCTION_LOG_SUM_EXP = DML_REDUCE_FUNCTION.LOG_SUM_EXP;
pub const DML_REDUCE_FUNCTION_MAX = DML_REDUCE_FUNCTION.MAX;
pub const DML_REDUCE_FUNCTION_MIN = DML_REDUCE_FUNCTION.MIN;
pub const DML_REDUCE_FUNCTION_MULTIPLY = DML_REDUCE_FUNCTION.MULTIPLY;
pub const DML_REDUCE_FUNCTION_SUM = DML_REDUCE_FUNCTION.SUM;
pub const DML_REDUCE_FUNCTION_SUM_SQUARE = DML_REDUCE_FUNCTION.SUM_SQUARE;

pub const DML_MATRIX_TRANSFORM = enum(i32) {
    NONE = 0,
    TRANSPOSE = 1,
};
pub const DML_MATRIX_TRANSFORM_NONE = DML_MATRIX_TRANSFORM.NONE;
pub const DML_MATRIX_TRANSFORM_TRANSPOSE = DML_MATRIX_TRANSFORM.TRANSPOSE;

pub const DML_CONVOLUTION_MODE = enum(i32) {
    ONVOLUTION = 0,
    ROSS_CORRELATION = 1,
};
pub const DML_CONVOLUTION_MODE_CONVOLUTION = DML_CONVOLUTION_MODE.ONVOLUTION;
pub const DML_CONVOLUTION_MODE_CROSS_CORRELATION = DML_CONVOLUTION_MODE.ROSS_CORRELATION;

pub const DML_CONVOLUTION_DIRECTION = enum(i32) {
    FORWARD = 0,
    BACKWARD = 1,
};
pub const DML_CONVOLUTION_DIRECTION_FORWARD = DML_CONVOLUTION_DIRECTION.FORWARD;
pub const DML_CONVOLUTION_DIRECTION_BACKWARD = DML_CONVOLUTION_DIRECTION.BACKWARD;

pub const DML_PADDING_MODE = enum(i32) {
    CONSTANT = 0,
    EDGE = 1,
    REFLECTION = 2,
    SYMMETRIC = 3,
};
pub const DML_PADDING_MODE_CONSTANT = DML_PADDING_MODE.CONSTANT;
pub const DML_PADDING_MODE_EDGE = DML_PADDING_MODE.EDGE;
pub const DML_PADDING_MODE_REFLECTION = DML_PADDING_MODE.REFLECTION;
pub const DML_PADDING_MODE_SYMMETRIC = DML_PADDING_MODE.SYMMETRIC;

pub const DML_INTERPOLATION_MODE = enum(i32) {
    NEAREST_NEIGHBOR = 0,
    LINEAR = 1,
};
pub const DML_INTERPOLATION_MODE_NEAREST_NEIGHBOR = DML_INTERPOLATION_MODE.NEAREST_NEIGHBOR;
pub const DML_INTERPOLATION_MODE_LINEAR = DML_INTERPOLATION_MODE.LINEAR;

pub const DML_SCALE_BIAS = extern struct {
    Scale: f32,
    Bias: f32,
};

pub const DML_SIZE_2D = extern struct {
    Width: u32,
    Height: u32,
};

pub const DML_RECURRENT_NETWORK_DIRECTION = enum(i32) {
    FORWARD = 0,
    BACKWARD = 1,
    BIDIRECTIONAL = 2,
};
pub const DML_RECURRENT_NETWORK_DIRECTION_FORWARD = DML_RECURRENT_NETWORK_DIRECTION.FORWARD;
pub const DML_RECURRENT_NETWORK_DIRECTION_BACKWARD = DML_RECURRENT_NETWORK_DIRECTION.BACKWARD;
pub const DML_RECURRENT_NETWORK_DIRECTION_BIDIRECTIONAL = DML_RECURRENT_NETWORK_DIRECTION.BIDIRECTIONAL;

pub const DML_ROUNDING_MODE = enum(i32) {
    HALVES_TO_NEAREST_EVEN = 0,
    TOWARD_ZERO = 1,
    TOWARD_INFINITY = 2,
};
pub const DML_ROUNDING_MODE_HALVES_TO_NEAREST_EVEN = DML_ROUNDING_MODE.HALVES_TO_NEAREST_EVEN;
pub const DML_ROUNDING_MODE_TOWARD_ZERO = DML_ROUNDING_MODE.TOWARD_ZERO;
pub const DML_ROUNDING_MODE_TOWARD_INFINITY = DML_ROUNDING_MODE.TOWARD_INFINITY;

pub const DML_IS_INFINITY_MODE = enum(i32) {
    EITHER = 0,
    POSITIVE = 1,
    NEGATIVE = 2,
};
pub const DML_IS_INFINITY_MODE_EITHER = DML_IS_INFINITY_MODE.EITHER;
pub const DML_IS_INFINITY_MODE_POSITIVE = DML_IS_INFINITY_MODE.POSITIVE;
pub const DML_IS_INFINITY_MODE_NEGATIVE = DML_IS_INFINITY_MODE.NEGATIVE;

pub const DML_AXIS_DIRECTION = enum(i32) {
    INCREASING = 0,
    DECREASING = 1,
};
pub const DML_AXIS_DIRECTION_INCREASING = DML_AXIS_DIRECTION.INCREASING;
pub const DML_AXIS_DIRECTION_DECREASING = DML_AXIS_DIRECTION.DECREASING;

pub const DML_DEPTH_SPACE_ORDER = enum(i32) {
    DEPTH_COLUMN_ROW = 0,
    COLUMN_ROW_DEPTH = 1,
};
pub const DML_DEPTH_SPACE_ORDER_DEPTH_COLUMN_ROW = DML_DEPTH_SPACE_ORDER.DEPTH_COLUMN_ROW;
pub const DML_DEPTH_SPACE_ORDER_COLUMN_ROW_DEPTH = DML_DEPTH_SPACE_ORDER.COLUMN_ROW_DEPTH;

pub const DML_SCALAR_UNION = extern union {
    Bytes: [8]u8,
    Int8: i8,
    UInt8: u8,
    Int16: i16,
    UInt16: u16,
    Int32: i32,
    UInt32: u32,
    Int64: i64,
    UInt64: u64,
    Float32: f32,
    Float64: f64,
};

pub const DML_RANDOM_GENERATOR_TYPE = enum(i32) {
    @"0" = 0,
};
pub const DML_RANDOM_GENERATOR_TYPE_PHILOX_4X32_10 = DML_RANDOM_GENERATOR_TYPE.@"0";

pub const DML_OPERATOR_DESC = extern struct {
    Type: DML_OPERATOR_TYPE,
    Desc: ?*const anyopaque,
};

pub const DML_ELEMENT_WISE_IDENTITY_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_ABS_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_ACOS_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_ADD_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_ADD1_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    FusedActivation: ?*const DML_OPERATOR_DESC,
};

pub const DML_ELEMENT_WISE_ASIN_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_ATAN_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_CEIL_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_CLIP_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
    Min: f32,
    Max: f32,
};

pub const DML_ELEMENT_WISE_COS_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_DIVIDE_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_EXP_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_FLOOR_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_LOG_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_LOGICAL_AND_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_LOGICAL_EQUALS_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_LOGICAL_GREATER_THAN_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_LOGICAL_LESS_THAN_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_LOGICAL_NOT_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_LOGICAL_OR_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_LOGICAL_XOR_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_MAX_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_MEAN_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_MIN_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_MULTIPLY_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_POW_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    ExponentTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_CONSTANT_POW_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
    Exponent: f32,
};

pub const DML_ELEMENT_WISE_RECIP_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_SIN_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_SQRT_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_SUBTRACT_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_TAN_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_THRESHOLD_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
    Min: f32,
};

pub const DML_ELEMENT_WISE_QUANTIZE_LINEAR_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    ScaleTensor: ?*const DML_TENSOR_DESC,
    ZeroPointTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_DEQUANTIZE_LINEAR_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    ScaleTensor: ?*const DML_TENSOR_DESC,
    ZeroPointTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ACTIVATION_ELU_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Alpha: f32,
};

pub const DML_ACTIVATION_HARDMAX_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ACTIVATION_HARD_SIGMOID_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Alpha: f32,
    Beta: f32,
};

pub const DML_ACTIVATION_IDENTITY_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ACTIVATION_LEAKY_RELU_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Alpha: f32,
};

pub const DML_ACTIVATION_LINEAR_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Alpha: f32,
    Beta: f32,
};

pub const DML_ACTIVATION_LOG_SOFTMAX_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ACTIVATION_PARAMETERIZED_RELU_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    SlopeTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ACTIVATION_PARAMETRIC_SOFTPLUS_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Alpha: f32,
    Beta: f32,
};

pub const DML_ACTIVATION_RELU_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ACTIVATION_SCALED_ELU_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Alpha: f32,
    Gamma: f32,
};

pub const DML_ACTIVATION_SCALED_TANH_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Alpha: f32,
    Beta: f32,
};

pub const DML_ACTIVATION_SIGMOID_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ACTIVATION_SOFTMAX_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ACTIVATION_SOFTPLUS_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Steepness: f32,
};

pub const DML_ACTIVATION_SOFTSIGN_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ACTIVATION_TANH_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ACTIVATION_THRESHOLDED_RELU_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Alpha: f32,
};

pub const DML_CONVOLUTION_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    FilterTensor: ?*const DML_TENSOR_DESC,
    BiasTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Mode: DML_CONVOLUTION_MODE,
    Direction: DML_CONVOLUTION_DIRECTION,
    DimensionCount: u32,
    Strides: ?*const u32,
    Dilations: ?*const u32,
    StartPadding: ?*const u32,
    EndPadding: ?*const u32,
    OutputPadding: ?*const u32,
    GroupCount: u32,
    FusedActivation: ?*const DML_OPERATOR_DESC,
};

pub const DML_GEMM_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    CTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    TransA: DML_MATRIX_TRANSFORM,
    TransB: DML_MATRIX_TRANSFORM,
    Alpha: f32,
    Beta: f32,
    FusedActivation: ?*const DML_OPERATOR_DESC,
};

pub const DML_REDUCE_OPERATOR_DESC = extern struct {
    Function: DML_REDUCE_FUNCTION,
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    AxisCount: u32,
    Axes: ?*const u32,
};

pub const DML_AVERAGE_POOLING_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    DimensionCount: u32,
    Strides: ?*const u32,
    WindowSize: ?*const u32,
    StartPadding: ?*const u32,
    EndPadding: ?*const u32,
    IncludePadding: BOOL,
};

pub const DML_LP_POOLING_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    DimensionCount: u32,
    Strides: ?*const u32,
    WindowSize: ?*const u32,
    StartPadding: ?*const u32,
    EndPadding: ?*const u32,
    P: u32,
};

pub const DML_MAX_POOLING_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    DimensionCount: u32,
    Strides: ?*const u32,
    WindowSize: ?*const u32,
    StartPadding: ?*const u32,
    EndPadding: ?*const u32,
};

pub const DML_ROI_POOLING_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    ROITensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    SpatialScale: f32,
    PooledSize: DML_SIZE_2D,
};

pub const DML_SLICE_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    DimensionCount: u32,
    Offsets: ?*const u32,
    Sizes: ?*const u32,
    Strides: ?*const u32,
};

pub const DML_CAST_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_SPLIT_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputCount: u32,
    OutputTensors: ?*const DML_TENSOR_DESC,
    Axis: u32,
};

pub const DML_JOIN_OPERATOR_DESC = extern struct {
    InputCount: u32,
    InputTensors: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Axis: u32,
};

pub const DML_PADDING_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    PaddingMode: DML_PADDING_MODE,
    PaddingValue: f32,
    DimensionCount: u32,
    StartPadding: ?*const u32,
    EndPadding: ?*const u32,
};

pub const DML_VALUE_SCALE_2D_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Scale: f32,
    ChannelCount: u32,
    Bias: ?*const f32,
};

pub const DML_UPSAMPLE_2D_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleSize: DML_SIZE_2D,
    InterpolationMode: DML_INTERPOLATION_MODE,
};

pub const DML_GATHER_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    IndicesTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Axis: u32,
    IndexDimensions: u32,
};

pub const DML_SPACE_TO_DEPTH_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    BlockSize: u32,
};

pub const DML_DEPTH_TO_SPACE_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    BlockSize: u32,
};

pub const DML_TILE_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    RepeatsCount: u32,
    Repeats: ?*const u32,
};

pub const DML_TOP_K_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputValueTensor: ?*const DML_TENSOR_DESC,
    OutputIndexTensor: ?*const DML_TENSOR_DESC,
    Axis: u32,
    K: u32,
};

pub const DML_BATCH_NORMALIZATION_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    MeanTensor: ?*const DML_TENSOR_DESC,
    VarianceTensor: ?*const DML_TENSOR_DESC,
    ScaleTensor: ?*const DML_TENSOR_DESC,
    BiasTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Spatial: BOOL,
    Epsilon: f32,
    FusedActivation: ?*const DML_OPERATOR_DESC,
};

pub const DML_MEAN_VARIANCE_NORMALIZATION_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    ScaleTensor: ?*const DML_TENSOR_DESC,
    BiasTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    CrossChannel: BOOL,
    NormalizeVariance: BOOL,
    Epsilon: f32,
    FusedActivation: ?*const DML_OPERATOR_DESC,
};

pub const DML_LOCAL_RESPONSE_NORMALIZATION_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    CrossChannel: BOOL,
    LocalSize: u32,
    Alpha: f32,
    Beta: f32,
    Bias: f32,
};

pub const DML_LP_NORMALIZATION_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Axis: u32,
    Epsilon: f32,
    P: u32,
};

pub const DML_RNN_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    WeightTensor: ?*const DML_TENSOR_DESC,
    RecurrenceTensor: ?*const DML_TENSOR_DESC,
    BiasTensor: ?*const DML_TENSOR_DESC,
    HiddenInitTensor: ?*const DML_TENSOR_DESC,
    SequenceLengthsTensor: ?*const DML_TENSOR_DESC,
    OutputSequenceTensor: ?*const DML_TENSOR_DESC,
    OutputSingleTensor: ?*const DML_TENSOR_DESC,
    ActivationDescCount: u32,
    ActivationDescs: ?*const DML_OPERATOR_DESC,
    Direction: DML_RECURRENT_NETWORK_DIRECTION,
};

pub const DML_LSTM_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    WeightTensor: ?*const DML_TENSOR_DESC,
    RecurrenceTensor: ?*const DML_TENSOR_DESC,
    BiasTensor: ?*const DML_TENSOR_DESC,
    HiddenInitTensor: ?*const DML_TENSOR_DESC,
    CellMemInitTensor: ?*const DML_TENSOR_DESC,
    SequenceLengthsTensor: ?*const DML_TENSOR_DESC,
    PeepholeTensor: ?*const DML_TENSOR_DESC,
    OutputSequenceTensor: ?*const DML_TENSOR_DESC,
    OutputSingleTensor: ?*const DML_TENSOR_DESC,
    OutputCellSingleTensor: ?*const DML_TENSOR_DESC,
    ActivationDescCount: u32,
    ActivationDescs: ?*const DML_OPERATOR_DESC,
    Direction: DML_RECURRENT_NETWORK_DIRECTION,
    ClipThreshold: f32,
    UseClipThreshold: BOOL,
    CoupleInputForget: BOOL,
};

pub const DML_GRU_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    WeightTensor: ?*const DML_TENSOR_DESC,
    RecurrenceTensor: ?*const DML_TENSOR_DESC,
    BiasTensor: ?*const DML_TENSOR_DESC,
    HiddenInitTensor: ?*const DML_TENSOR_DESC,
    SequenceLengthsTensor: ?*const DML_TENSOR_DESC,
    OutputSequenceTensor: ?*const DML_TENSOR_DESC,
    OutputSingleTensor: ?*const DML_TENSOR_DESC,
    ActivationDescCount: u32,
    ActivationDescs: ?*const DML_OPERATOR_DESC,
    Direction: DML_RECURRENT_NETWORK_DIRECTION,
    LinearBeforeReset: BOOL,
};

pub const DML_ELEMENT_WISE_SIGN_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_IS_NAN_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_ERF_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_SINH_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_COSH_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_TANH_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_ASINH_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_ACOSH_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_ATANH_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ScaleBias: ?*const DML_SCALE_BIAS,
};

pub const DML_ELEMENT_WISE_IF_OPERATOR_DESC = extern struct {
    ConditionTensor: ?*const DML_TENSOR_DESC,
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ACTIVATION_SHRINK_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Bias: f32,
    Threshold: f32,
};

pub const DML_MAX_POOLING1_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    OutputIndicesTensor: ?*const DML_TENSOR_DESC,
    DimensionCount: u32,
    Strides: ?*const u32,
    WindowSize: ?*const u32,
    StartPadding: ?*const u32,
    EndPadding: ?*const u32,
};

pub const DML_MAX_UNPOOLING_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    IndicesTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_DIAGONAL_MATRIX_OPERATOR_DESC = extern struct {
    OutputTensor: ?*const DML_TENSOR_DESC,
    Offset: i32,
    Value: f32,
};

pub const DML_SCATTER_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    IndicesTensor: ?*const DML_TENSOR_DESC,
    UpdatesTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Axis: u32,
};

pub const DML_ONE_HOT_OPERATOR_DESC = extern struct {
    IndicesTensor: ?*const DML_TENSOR_DESC,
    ValuesTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Axis: u32,
};

pub const DML_RESAMPLE_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    InterpolationMode: DML_INTERPOLATION_MODE,
    ScaleCount: u32,
    Scales: ?*const f32,
};

pub const DML_ELEMENT_WISE_BIT_SHIFT_LEFT_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_BIT_SHIFT_RIGHT_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_ROUND_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    RoundingMode: DML_ROUNDING_MODE,
};

pub const DML_ELEMENT_WISE_IS_INFINITY_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    InfinityMode: DML_IS_INFINITY_MODE,
};

pub const DML_ELEMENT_WISE_MODULUS_TRUNCATE_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_MODULUS_FLOOR_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_FILL_VALUE_CONSTANT_OPERATOR_DESC = extern struct {
    OutputTensor: ?*const DML_TENSOR_DESC,
    ValueDataType: DML_TENSOR_DATA_TYPE,
    Value: DML_SCALAR_UNION,
};

pub const DML_FILL_VALUE_SEQUENCE_OPERATOR_DESC = extern struct {
    OutputTensor: ?*const DML_TENSOR_DESC,
    ValueDataType: DML_TENSOR_DATA_TYPE,
    ValueStart: DML_SCALAR_UNION,
    ValueDelta: DML_SCALAR_UNION,
};

pub const DML_CUMULATIVE_SUMMATION_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Axis: u32,
    AxisDirection: DML_AXIS_DIRECTION,
    HasExclusiveSum: BOOL,
};

pub const DML_REVERSE_SUBSEQUENCES_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    SequenceLengthsTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Axis: u32,
};

pub const DML_GATHER_ELEMENTS_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    IndicesTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Axis: u32,
};

pub const DML_GATHER_ND_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    IndicesTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    InputDimensionCount: u32,
    IndicesDimensionCount: u32,
};

pub const DML_SCATTER_ND_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    IndicesTensor: ?*const DML_TENSOR_DESC,
    UpdatesTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    InputDimensionCount: u32,
    IndicesDimensionCount: u32,
};

pub const DML_MAX_POOLING2_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    OutputIndicesTensor: ?*const DML_TENSOR_DESC,
    DimensionCount: u32,
    Strides: ?*const u32,
    WindowSize: ?*const u32,
    StartPadding: ?*const u32,
    EndPadding: ?*const u32,
    Dilations: ?*const u32,
};

pub const DML_SLICE1_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    DimensionCount: u32,
    InputWindowOffsets: ?*const u32,
    InputWindowSizes: ?*const u32,
    InputWindowStrides: ?*const i32,
};

pub const DML_TOP_K1_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputValueTensor: ?*const DML_TENSOR_DESC,
    OutputIndexTensor: ?*const DML_TENSOR_DESC,
    Axis: u32,
    K: u32,
    AxisDirection: DML_AXIS_DIRECTION,
};

pub const DML_DEPTH_TO_SPACE1_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    BlockSize: u32,
    Order: DML_DEPTH_SPACE_ORDER,
};

pub const DML_SPACE_TO_DEPTH1_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    BlockSize: u32,
    Order: DML_DEPTH_SPACE_ORDER,
};

pub const DML_MEAN_VARIANCE_NORMALIZATION1_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    ScaleTensor: ?*const DML_TENSOR_DESC,
    BiasTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    AxisCount: u32,
    Axes: ?*const u32,
    NormalizeVariance: BOOL,
    Epsilon: f32,
    FusedActivation: ?*const DML_OPERATOR_DESC,
};

pub const DML_RESAMPLE1_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    InterpolationMode: DML_INTERPOLATION_MODE,
    DimensionCount: u32,
    Scales: ?*const f32,
    InputPixelOffsets: ?*const f32,
    OutputPixelOffsets: ?*const f32,
};

pub const DML_MATRIX_MULTIPLY_INTEGER_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    AZeroPointTensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    BZeroPointTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_QUANTIZED_LINEAR_MATRIX_MULTIPLY_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    AScaleTensor: ?*const DML_TENSOR_DESC,
    AZeroPointTensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    BScaleTensor: ?*const DML_TENSOR_DESC,
    BZeroPointTensor: ?*const DML_TENSOR_DESC,
    OutputScaleTensor: ?*const DML_TENSOR_DESC,
    OutputZeroPointTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_CONVOLUTION_INTEGER_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    InputZeroPointTensor: ?*const DML_TENSOR_DESC,
    FilterTensor: ?*const DML_TENSOR_DESC,
    FilterZeroPointTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    DimensionCount: u32,
    Strides: ?*const u32,
    Dilations: ?*const u32,
    StartPadding: ?*const u32,
    EndPadding: ?*const u32,
    GroupCount: u32,
};

pub const DML_QUANTIZED_LINEAR_CONVOLUTION_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    InputScaleTensor: ?*const DML_TENSOR_DESC,
    InputZeroPointTensor: ?*const DML_TENSOR_DESC,
    FilterTensor: ?*const DML_TENSOR_DESC,
    FilterScaleTensor: ?*const DML_TENSOR_DESC,
    FilterZeroPointTensor: ?*const DML_TENSOR_DESC,
    BiasTensor: ?*const DML_TENSOR_DESC,
    OutputScaleTensor: ?*const DML_TENSOR_DESC,
    OutputZeroPointTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    DimensionCount: u32,
    Strides: ?*const u32,
    Dilations: ?*const u32,
    StartPadding: ?*const u32,
    EndPadding: ?*const u32,
    GroupCount: u32,
};

pub const DML_ELEMENT_WISE_BIT_AND_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_BIT_OR_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_BIT_XOR_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_BIT_NOT_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_BIT_COUNT_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_LOGICAL_GREATER_THAN_OR_EQUAL_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_LOGICAL_LESS_THAN_OR_EQUAL_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ACTIVATION_CELU_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Alpha: f32,
};

pub const DML_ACTIVATION_RELU_GRAD_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    InputGradientTensor: ?*const DML_TENSOR_DESC,
    OutputGradientTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_AVERAGE_POOLING_GRAD_OPERATOR_DESC = extern struct {
    InputGradientTensor: ?*const DML_TENSOR_DESC,
    OutputGradientTensor: ?*const DML_TENSOR_DESC,
    DimensionCount: u32,
    Strides: ?*const u32,
    WindowSize: ?*const u32,
    StartPadding: ?*const u32,
    EndPadding: ?*const u32,
    IncludePadding: BOOL,
};

pub const DML_MAX_POOLING_GRAD_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    InputGradientTensor: ?*const DML_TENSOR_DESC,
    OutputGradientTensor: ?*const DML_TENSOR_DESC,
    DimensionCount: u32,
    Strides: ?*const u32,
    WindowSize: ?*const u32,
    StartPadding: ?*const u32,
    EndPadding: ?*const u32,
    Dilations: ?*const u32,
};

pub const DML_RANDOM_GENERATOR_OPERATOR_DESC = extern struct {
    InputStateTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    OutputStateTensor: ?*const DML_TENSOR_DESC,
    Type: DML_RANDOM_GENERATOR_TYPE,
};

pub const DML_NONZERO_COORDINATES_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputCountTensor: ?*const DML_TENSOR_DESC,
    OutputCoordinatesTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_RESAMPLE_GRAD_OPERATOR_DESC = extern struct {
    InputGradientTensor: ?*const DML_TENSOR_DESC,
    OutputGradientTensor: ?*const DML_TENSOR_DESC,
    InterpolationMode: DML_INTERPOLATION_MODE,
    DimensionCount: u32,
    Scales: ?*const f32,
    InputPixelOffsets: ?*const f32,
    OutputPixelOffsets: ?*const f32,
};

pub const DML_SLICE_GRAD_OPERATOR_DESC = extern struct {
    InputGradientTensor: ?*const DML_TENSOR_DESC,
    OutputGradientTensor: ?*const DML_TENSOR_DESC,
    DimensionCount: u32,
    InputWindowOffsets: ?*const u32,
    InputWindowSizes: ?*const u32,
    InputWindowStrides: ?*const i32,
};

pub const DML_ADAM_OPTIMIZER_OPERATOR_DESC = extern struct {
    InputParametersTensor: ?*const DML_TENSOR_DESC,
    InputFirstMomentTensor: ?*const DML_TENSOR_DESC,
    InputSecondMomentTensor: ?*const DML_TENSOR_DESC,
    GradientTensor: ?*const DML_TENSOR_DESC,
    TrainingStepTensor: ?*const DML_TENSOR_DESC,
    OutputParametersTensor: ?*const DML_TENSOR_DESC,
    OutputFirstMomentTensor: ?*const DML_TENSOR_DESC,
    OutputSecondMomentTensor: ?*const DML_TENSOR_DESC,
    LearningRate: f32,
    Beta1: f32,
    Beta2: f32,
    Epsilon: f32,
};

pub const DML_ARGMIN_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    AxisCount: u32,
    Axes: ?*const u32,
    AxisDirection: DML_AXIS_DIRECTION,
};

pub const DML_ARGMAX_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    AxisCount: u32,
    Axes: ?*const u32,
    AxisDirection: DML_AXIS_DIRECTION,
};

pub const DML_ROI_ALIGN_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    ROITensor: ?*const DML_TENSOR_DESC,
    BatchIndicesTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ReductionFunction: DML_REDUCE_FUNCTION,
    InterpolationMode: DML_INTERPOLATION_MODE,
    SpatialScaleX: f32,
    SpatialScaleY: f32,
    OutOfBoundsInputValue: f32,
    MinimumSamplesPerOutput: u32,
    MaximumSamplesPerOutput: u32,
};

pub const DML_GATHER_ND1_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    IndicesTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    InputDimensionCount: u32,
    IndicesDimensionCount: u32,
    BatchDimensionCount: u32,
};

pub const DML_ELEMENT_WISE_ATAN_YX_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ELEMENT_WISE_CLIP_GRAD_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    InputGradientTensor: ?*const DML_TENSOR_DESC,
    OutputGradientTensor: ?*const DML_TENSOR_DESC,
    Min: f32,
    Max: f32,
};

pub const DML_ELEMENT_WISE_DIFFERENCE_SQUARE_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_LOCAL_RESPONSE_NORMALIZATION_GRAD_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    InputGradientTensor: ?*const DML_TENSOR_DESC,
    OutputGradientTensor: ?*const DML_TENSOR_DESC,
    CrossChannel: BOOL,
    LocalSize: u32,
    Alpha: f32,
    Beta: f32,
    Bias: f32,
};

pub const DML_CUMULATIVE_PRODUCT_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    Axis: u32,
    AxisDirection: DML_AXIS_DIRECTION,
    HasExclusiveProduct: BOOL,
};

pub const DML_BATCH_NORMALIZATION_GRAD_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    InputGradientTensor: ?*const DML_TENSOR_DESC,
    MeanTensor: ?*const DML_TENSOR_DESC,
    VarianceTensor: ?*const DML_TENSOR_DESC,
    ScaleTensor: ?*const DML_TENSOR_DESC,
    OutputGradientTensor: ?*const DML_TENSOR_DESC,
    OutputScaleGradientTensor: ?*const DML_TENSOR_DESC,
    OutputBiasGradientTensor: ?*const DML_TENSOR_DESC,
    Epsilon: f32,
};

pub const DML_ELEMENT_WISE_QUANTIZED_LINEAR_ADD_OPERATOR_DESC = extern struct {
    ATensor: ?*const DML_TENSOR_DESC,
    AScaleTensor: ?*const DML_TENSOR_DESC,
    AZeroPointTensor: ?*const DML_TENSOR_DESC,
    BTensor: ?*const DML_TENSOR_DESC,
    BScaleTensor: ?*const DML_TENSOR_DESC,
    BZeroPointTensor: ?*const DML_TENSOR_DESC,
    OutputScaleTensor: ?*const DML_TENSOR_DESC,
    OutputZeroPointTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_DYNAMIC_QUANTIZE_LINEAR_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    OutputScaleTensor: ?*const DML_TENSOR_DESC,
    OutputZeroPointTensor: ?*const DML_TENSOR_DESC,
};

pub const DML_ROI_ALIGN1_OPERATOR_DESC = extern struct {
    InputTensor: ?*const DML_TENSOR_DESC,
    ROITensor: ?*const DML_TENSOR_DESC,
    BatchIndicesTensor: ?*const DML_TENSOR_DESC,
    OutputTensor: ?*const DML_TENSOR_DESC,
    ReductionFunction: DML_REDUCE_FUNCTION,
    InterpolationMode: DML_INTERPOLATION_MODE,
    SpatialScaleX: f32,
    SpatialScaleY: f32,
    InputPixelOffset: f32,
    OutputPixelOffset: f32,
    OutOfBoundsInputValue: f32,
    MinimumSamplesPerOutput: u32,
    MaximumSamplesPerOutput: u32,
    AlignRegionsToCorners: BOOL,
};

pub const DML_FEATURE_LEVEL = enum(i32) {
    @"1_0" = 4096,
    @"2_0" = 8192,
    @"2_1" = 8448,
    @"3_0" = 12288,
    @"3_1" = 12544,
    @"4_0" = 16384,
};
pub const DML_FEATURE_LEVEL_1_0 = DML_FEATURE_LEVEL.@"1_0";
pub const DML_FEATURE_LEVEL_2_0 = DML_FEATURE_LEVEL.@"2_0";
pub const DML_FEATURE_LEVEL_2_1 = DML_FEATURE_LEVEL.@"2_1";
pub const DML_FEATURE_LEVEL_3_0 = DML_FEATURE_LEVEL.@"3_0";
pub const DML_FEATURE_LEVEL_3_1 = DML_FEATURE_LEVEL.@"3_1";
pub const DML_FEATURE_LEVEL_4_0 = DML_FEATURE_LEVEL.@"4_0";

pub const DML_FEATURE = enum(i32) {
    TENSOR_DATA_TYPE_SUPPORT = 0,
    FEATURE_LEVELS = 1,
};
pub const DML_FEATURE_TENSOR_DATA_TYPE_SUPPORT = DML_FEATURE.TENSOR_DATA_TYPE_SUPPORT;
pub const DML_FEATURE_FEATURE_LEVELS = DML_FEATURE.FEATURE_LEVELS;

pub const DML_FEATURE_QUERY_TENSOR_DATA_TYPE_SUPPORT = extern struct {
    DataType: DML_TENSOR_DATA_TYPE,
};

pub const DML_FEATURE_DATA_TENSOR_DATA_TYPE_SUPPORT = extern struct {
    IsSupported: BOOL,
};

pub const DML_FEATURE_QUERY_FEATURE_LEVELS = extern struct {
    RequestedFeatureLevelCount: u32,
    RequestedFeatureLevels: ?*const DML_FEATURE_LEVEL,
};

pub const DML_FEATURE_DATA_FEATURE_LEVELS = extern struct {
    MaxSupportedFeatureLevel: DML_FEATURE_LEVEL,
};

pub const DML_BINDING_TABLE_DESC = extern struct {
    Dispatchable: ?*IDMLDispatchable,
    CPUDescriptorHandle: D3D12_CPU_DESCRIPTOR_HANDLE,
    GPUDescriptorHandle: D3D12_GPU_DESCRIPTOR_HANDLE,
    SizeInDescriptors: u32,
};

pub const DML_EXECUTION_FLAGS = enum(u32) {
    NONE = 0,
    ALLOW_HALF_PRECISION_COMPUTATION = 1,
    DISABLE_META_COMMANDS = 2,
    DESCRIPTORS_VOLATILE = 4,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        ALLOW_HALF_PRECISION_COMPUTATION: u1 = 0,
        DISABLE_META_COMMANDS: u1 = 0,
        DESCRIPTORS_VOLATILE: u1 = 0,
    }) DML_EXECUTION_FLAGS {
        return @as(DML_EXECUTION_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(DML_EXECUTION_FLAGS.NONE) else 0) | (if (o.ALLOW_HALF_PRECISION_COMPUTATION == 1) @intFromEnum(DML_EXECUTION_FLAGS.ALLOW_HALF_PRECISION_COMPUTATION) else 0) | (if (o.DISABLE_META_COMMANDS == 1) @intFromEnum(DML_EXECUTION_FLAGS.DISABLE_META_COMMANDS) else 0) | (if (o.DESCRIPTORS_VOLATILE == 1) @intFromEnum(DML_EXECUTION_FLAGS.DESCRIPTORS_VOLATILE) else 0)));
    }
};
pub const DML_EXECUTION_FLAG_NONE = DML_EXECUTION_FLAGS.NONE;
pub const DML_EXECUTION_FLAG_ALLOW_HALF_PRECISION_COMPUTATION = DML_EXECUTION_FLAGS.ALLOW_HALF_PRECISION_COMPUTATION;
pub const DML_EXECUTION_FLAG_DISABLE_META_COMMANDS = DML_EXECUTION_FLAGS.DISABLE_META_COMMANDS;
pub const DML_EXECUTION_FLAG_DESCRIPTORS_VOLATILE = DML_EXECUTION_FLAGS.DESCRIPTORS_VOLATILE;

pub const DML_CREATE_DEVICE_FLAGS = enum(u32) {
    NONE = 0,
    DEBUG = 1,
    _,
    pub fn initFlags(o: struct {
        NONE: u1 = 0,
        DEBUG: u1 = 0,
    }) DML_CREATE_DEVICE_FLAGS {
        return @as(DML_CREATE_DEVICE_FLAGS, @enumFromInt((if (o.NONE == 1) @intFromEnum(DML_CREATE_DEVICE_FLAGS.NONE) else 0) | (if (o.DEBUG == 1) @intFromEnum(DML_CREATE_DEVICE_FLAGS.DEBUG) else 0)));
    }
};
pub const DML_CREATE_DEVICE_FLAG_NONE = DML_CREATE_DEVICE_FLAGS.NONE;
pub const DML_CREATE_DEVICE_FLAG_DEBUG = DML_CREATE_DEVICE_FLAGS.DEBUG;

const IID_IDMLObject_Value = Guid.initString("c8263aac-9e0c-4a2d-9b8e-007521a3317c");
pub const IID_IDMLObject = &IID_IDMLObject_Value;
pub const IDMLObject = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        GetPrivateData: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLObject,
                guid: ?*const Guid,
                dataSize: ?*u32,
                // TODO: what to do with BytesParamIndex 1?
                data: ?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLObject,
                guid: ?*const Guid,
                dataSize: ?*u32,
                // TODO: what to do with BytesParamIndex 1?
                data: ?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetPrivateData: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLObject,
                guid: ?*const Guid,
                dataSize: u32,
                // TODO: what to do with BytesParamIndex 1?
                data: ?*const anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLObject,
                guid: ?*const Guid,
                dataSize: u32,
                // TODO: what to do with BytesParamIndex 1?
                data: ?*const anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetPrivateDataInterface: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLObject,
                guid: ?*const Guid,
                data: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLObject,
                guid: ?*const Guid,
                data: ?*IUnknown,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        SetName: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLObject,
                name: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLObject,
                name: ?[*:0]const u16,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLObject_GetPrivateData(self: *const T, guid: ?*const Guid, dataSize: ?*u32, data: ?*anyopaque) HRESULT {
                return @as(*const IDMLObject.VTable, @ptrCast(self.vtable)).GetPrivateData(@as(*const IDMLObject, @ptrCast(self)), guid, dataSize, data);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLObject_SetPrivateData(self: *const T, guid: ?*const Guid, dataSize: u32, data: ?*const anyopaque) HRESULT {
                return @as(*const IDMLObject.VTable, @ptrCast(self.vtable)).SetPrivateData(@as(*const IDMLObject, @ptrCast(self)), guid, dataSize, data);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLObject_SetPrivateDataInterface(self: *const T, guid: ?*const Guid, data: ?*IUnknown) HRESULT {
                return @as(*const IDMLObject.VTable, @ptrCast(self.vtable)).SetPrivateDataInterface(@as(*const IDMLObject, @ptrCast(self)), guid, data);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLObject_SetName(self: *const T, name: ?[*:0]const u16) HRESULT {
                return @as(*const IDMLObject.VTable, @ptrCast(self.vtable)).SetName(@as(*const IDMLObject, @ptrCast(self)), name);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDMLDevice_Value = Guid.initString("6dbd6437-96fd-423f-a98c-ae5e7c2a573f");
pub const IID_IDMLDevice = &IID_IDMLDevice_Value;
pub const IDMLDevice = extern struct {
    pub const VTable = extern struct {
        base: IDMLObject.VTable,
        CheckFeatureSupport: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLDevice,
                feature: DML_FEATURE,
                featureQueryDataSize: u32,
                // TODO: what to do with BytesParamIndex 1?
                featureQueryData: ?*const anyopaque,
                featureSupportDataSize: u32,
                // TODO: what to do with BytesParamIndex 3?
                featureSupportData: ?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLDevice,
                feature: DML_FEATURE,
                featureQueryDataSize: u32,
                // TODO: what to do with BytesParamIndex 1?
                featureQueryData: ?*const anyopaque,
                featureSupportDataSize: u32,
                // TODO: what to do with BytesParamIndex 3?
                featureSupportData: ?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateOperator: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLDevice,
                desc: ?*const DML_OPERATOR_DESC,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLDevice,
                desc: ?*const DML_OPERATOR_DESC,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CompileOperator: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLDevice,
                op: ?*IDMLOperator,
                flags: DML_EXECUTION_FLAGS,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLDevice,
                op: ?*IDMLOperator,
                flags: DML_EXECUTION_FLAGS,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateOperatorInitializer: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLDevice,
                operatorCount: u32,
                operators: ?[*]?*IDMLCompiledOperator,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLDevice,
                operatorCount: u32,
                operators: ?[*]?*IDMLCompiledOperator,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateCommandRecorder: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLDevice,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLDevice,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        CreateBindingTable: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLDevice,
                desc: ?*const DML_BINDING_TABLE_DESC,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLDevice,
                desc: ?*const DML_BINDING_TABLE_DESC,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        Evict: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLDevice,
                count: u32,
                ppObjects: [*]?*IDMLPageable,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLDevice,
                count: u32,
                ppObjects: [*]?*IDMLPageable,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        MakeResident: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLDevice,
                count: u32,
                ppObjects: [*]?*IDMLPageable,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLDevice,
                count: u32,
                ppObjects: [*]?*IDMLPageable,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetDeviceRemovedReason: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLDevice,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLDevice,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
        GetParentDevice: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLDevice,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLDevice,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDMLObject.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLDevice_CheckFeatureSupport(self: *const T, feature: DML_FEATURE, featureQueryDataSize: u32, featureQueryData: ?*const anyopaque, featureSupportDataSize: u32, featureSupportData: ?*anyopaque) HRESULT {
                return @as(*const IDMLDevice.VTable, @ptrCast(self.vtable)).CheckFeatureSupport(@as(*const IDMLDevice, @ptrCast(self)), feature, featureQueryDataSize, featureQueryData, featureSupportDataSize, featureSupportData);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLDevice_CreateOperator(self: *const T, desc: ?*const DML_OPERATOR_DESC, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IDMLDevice.VTable, @ptrCast(self.vtable)).CreateOperator(@as(*const IDMLDevice, @ptrCast(self)), desc, riid, ppv);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLDevice_CompileOperator(self: *const T, op: ?*IDMLOperator, flags: DML_EXECUTION_FLAGS, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IDMLDevice.VTable, @ptrCast(self.vtable)).CompileOperator(@as(*const IDMLDevice, @ptrCast(self)), op, flags, riid, ppv);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLDevice_CreateOperatorInitializer(self: *const T, operatorCount: u32, operators: ?[*]?*IDMLCompiledOperator, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IDMLDevice.VTable, @ptrCast(self.vtable)).CreateOperatorInitializer(@as(*const IDMLDevice, @ptrCast(self)), operatorCount, operators, riid, ppv);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLDevice_CreateCommandRecorder(self: *const T, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IDMLDevice.VTable, @ptrCast(self.vtable)).CreateCommandRecorder(@as(*const IDMLDevice, @ptrCast(self)), riid, ppv);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLDevice_CreateBindingTable(self: *const T, desc: ?*const DML_BINDING_TABLE_DESC, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IDMLDevice.VTable, @ptrCast(self.vtable)).CreateBindingTable(@as(*const IDMLDevice, @ptrCast(self)), desc, riid, ppv);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLDevice_Evict(self: *const T, count: u32, ppObjects: [*]?*IDMLPageable) HRESULT {
                return @as(*const IDMLDevice.VTable, @ptrCast(self.vtable)).Evict(@as(*const IDMLDevice, @ptrCast(self)), count, ppObjects);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLDevice_MakeResident(self: *const T, count: u32, ppObjects: [*]?*IDMLPageable) HRESULT {
                return @as(*const IDMLDevice.VTable, @ptrCast(self.vtable)).MakeResident(@as(*const IDMLDevice, @ptrCast(self)), count, ppObjects);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLDevice_GetDeviceRemovedReason(self: *const T) HRESULT {
                return @as(*const IDMLDevice.VTable, @ptrCast(self.vtable)).GetDeviceRemovedReason(@as(*const IDMLDevice, @ptrCast(self)));
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLDevice_GetParentDevice(self: *const T, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IDMLDevice.VTable, @ptrCast(self.vtable)).GetParentDevice(@as(*const IDMLDevice, @ptrCast(self)), riid, ppv);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDMLDeviceChild_Value = Guid.initString("27e83142-8165-49e3-974e-2fd66e4cb69d");
pub const IID_IDMLDeviceChild = &IID_IDMLDeviceChild_Value;
pub const IDMLDeviceChild = extern struct {
    pub const VTable = extern struct {
        base: IDMLObject.VTable,
        GetDevice: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLDeviceChild,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLDeviceChild,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDMLObject.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLDeviceChild_GetDevice(self: *const T, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IDMLDeviceChild.VTable, @ptrCast(self.vtable)).GetDevice(@as(*const IDMLDeviceChild, @ptrCast(self)), riid, ppv);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDMLPageable_Value = Guid.initString("b1ab0825-4542-4a4b-8617-6dde6e8f6201");
pub const IID_IDMLPageable = &IID_IDMLPageable_Value;
pub const IDMLPageable = extern struct {
    pub const VTable = extern struct {
        base: IDMLDeviceChild.VTable,
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDMLDeviceChild.MethodMixin(T);
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDMLOperator_Value = Guid.initString("26caae7a-3081-4633-9581-226fbe57695d");
pub const IID_IDMLOperator = &IID_IDMLOperator_Value;
pub const IDMLOperator = extern struct {
    pub const VTable = extern struct {
        base: IDMLDeviceChild.VTable,
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDMLDeviceChild.MethodMixin(T);
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const DML_BINDING_PROPERTIES = extern struct {
    RequiredDescriptorCount: u32,
    TemporaryResourceSize: u64,
    PersistentResourceSize: u64,
};

const IID_IDMLDispatchable_Value = Guid.initString("dcb821a8-1039-441e-9f1c-b1759c2f3cec");
pub const IID_IDMLDispatchable = &IID_IDMLDispatchable_Value;
pub const IDMLDispatchable = extern struct {
    pub const VTable = extern struct {
        base: IDMLPageable.VTable,
        GetBindingProperties: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLDispatchable,
            ) callconv(@import("std").os.windows.WINAPI) DML_BINDING_PROPERTIES,
            else => *const fn (
                self: *const IDMLDispatchable,
            ) callconv(@import("std").os.windows.WINAPI) DML_BINDING_PROPERTIES,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDMLPageable.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLDispatchable_GetBindingProperties(self: *const T) DML_BINDING_PROPERTIES {
                return @as(*const IDMLDispatchable.VTable, @ptrCast(self.vtable)).GetBindingProperties(@as(*const IDMLDispatchable, @ptrCast(self)));
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDMLCompiledOperator_Value = Guid.initString("6b15e56a-bf5c-4902-92d8-da3a650afea4");
pub const IID_IDMLCompiledOperator = &IID_IDMLCompiledOperator_Value;
pub const IDMLCompiledOperator = extern struct {
    pub const VTable = extern struct {
        base: IDMLDispatchable.VTable,
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDMLDispatchable.MethodMixin(T);
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDMLOperatorInitializer_Value = Guid.initString("427c1113-435c-469c-8676-4d5dd072f813");
pub const IID_IDMLOperatorInitializer = &IID_IDMLOperatorInitializer_Value;
pub const IDMLOperatorInitializer = extern struct {
    pub const VTable = extern struct {
        base: IDMLDispatchable.VTable,
        Reset: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLOperatorInitializer,
                operatorCount: u32,
                operators: ?[*]?*IDMLCompiledOperator,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLOperatorInitializer,
                operatorCount: u32,
                operators: ?[*]?*IDMLCompiledOperator,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDMLDispatchable.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLOperatorInitializer_Reset(self: *const T, operatorCount: u32, operators: ?[*]?*IDMLCompiledOperator) HRESULT {
                return @as(*const IDMLOperatorInitializer.VTable, @ptrCast(self.vtable)).Reset(@as(*const IDMLOperatorInitializer, @ptrCast(self)), operatorCount, operators);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const DML_BINDING_TYPE = enum(i32) {
    NONE = 0,
    BUFFER = 1,
    BUFFER_ARRAY = 2,
};
pub const DML_BINDING_TYPE_NONE = DML_BINDING_TYPE.NONE;
pub const DML_BINDING_TYPE_BUFFER = DML_BINDING_TYPE.BUFFER;
pub const DML_BINDING_TYPE_BUFFER_ARRAY = DML_BINDING_TYPE.BUFFER_ARRAY;

pub const DML_BINDING_DESC = extern struct {
    Type: DML_BINDING_TYPE,
    Desc: ?*const anyopaque,
};

pub const DML_BUFFER_BINDING = extern struct {
    Buffer: ?*ID3D12Resource,
    Offset: u64,
    SizeInBytes: u64,
};

pub const DML_BUFFER_ARRAY_BINDING = extern struct {
    BindingCount: u32,
    Bindings: ?*const DML_BUFFER_BINDING,
};

const IID_IDMLBindingTable_Value = Guid.initString("29c687dc-de74-4e3b-ab00-1168f2fc3cfc");
pub const IID_IDMLBindingTable = &IID_IDMLBindingTable_Value;
pub const IDMLBindingTable = extern struct {
    pub const VTable = extern struct {
        base: IDMLDeviceChild.VTable,
        BindInputs: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLBindingTable,
                bindingCount: u32,
                bindings: ?[*]const DML_BINDING_DESC,
            ) callconv(@import("std").os.windows.WINAPI) void,
            else => *const fn (
                self: *const IDMLBindingTable,
                bindingCount: u32,
                bindings: ?[*]const DML_BINDING_DESC,
            ) callconv(@import("std").os.windows.WINAPI) void,
        },
        BindOutputs: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLBindingTable,
                bindingCount: u32,
                bindings: ?[*]const DML_BINDING_DESC,
            ) callconv(@import("std").os.windows.WINAPI) void,
            else => *const fn (
                self: *const IDMLBindingTable,
                bindingCount: u32,
                bindings: ?[*]const DML_BINDING_DESC,
            ) callconv(@import("std").os.windows.WINAPI) void,
        },
        BindTemporaryResource: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLBindingTable,
                binding: ?*const DML_BINDING_DESC,
            ) callconv(@import("std").os.windows.WINAPI) void,
            else => *const fn (
                self: *const IDMLBindingTable,
                binding: ?*const DML_BINDING_DESC,
            ) callconv(@import("std").os.windows.WINAPI) void,
        },
        BindPersistentResource: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLBindingTable,
                binding: ?*const DML_BINDING_DESC,
            ) callconv(@import("std").os.windows.WINAPI) void,
            else => *const fn (
                self: *const IDMLBindingTable,
                binding: ?*const DML_BINDING_DESC,
            ) callconv(@import("std").os.windows.WINAPI) void,
        },
        Reset: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLBindingTable,
                desc: ?*const DML_BINDING_TABLE_DESC,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLBindingTable,
                desc: ?*const DML_BINDING_TABLE_DESC,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDMLDeviceChild.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLBindingTable_BindInputs(self: *const T, bindingCount: u32, bindings: ?[*]const DML_BINDING_DESC) void {
                return @as(*const IDMLBindingTable.VTable, @ptrCast(self.vtable)).BindInputs(@as(*const IDMLBindingTable, @ptrCast(self)), bindingCount, bindings);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLBindingTable_BindOutputs(self: *const T, bindingCount: u32, bindings: ?[*]const DML_BINDING_DESC) void {
                return @as(*const IDMLBindingTable.VTable, @ptrCast(self.vtable)).BindOutputs(@as(*const IDMLBindingTable, @ptrCast(self)), bindingCount, bindings);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLBindingTable_BindTemporaryResource(self: *const T, binding: ?*const DML_BINDING_DESC) void {
                return @as(*const IDMLBindingTable.VTable, @ptrCast(self.vtable)).BindTemporaryResource(@as(*const IDMLBindingTable, @ptrCast(self)), binding);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLBindingTable_BindPersistentResource(self: *const T, binding: ?*const DML_BINDING_DESC) void {
                return @as(*const IDMLBindingTable.VTable, @ptrCast(self.vtable)).BindPersistentResource(@as(*const IDMLBindingTable, @ptrCast(self)), binding);
            }
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLBindingTable_Reset(self: *const T, desc: ?*const DML_BINDING_TABLE_DESC) HRESULT {
                return @as(*const IDMLBindingTable.VTable, @ptrCast(self.vtable)).Reset(@as(*const IDMLBindingTable, @ptrCast(self)), desc);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDMLCommandRecorder_Value = Guid.initString("e6857a76-2e3e-4fdd-bff4-5d2ba10fb453");
pub const IID_IDMLCommandRecorder = &IID_IDMLCommandRecorder_Value;
pub const IDMLCommandRecorder = extern struct {
    pub const VTable = extern struct {
        base: IDMLDeviceChild.VTable,
        RecordDispatch: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLCommandRecorder,
                commandList: ?*ID3D12CommandList,
                dispatchable: ?*IDMLDispatchable,
                bindings: ?*IDMLBindingTable,
            ) callconv(@import("std").os.windows.WINAPI) void,
            else => *const fn (
                self: *const IDMLCommandRecorder,
                commandList: ?*ID3D12CommandList,
                dispatchable: ?*IDMLDispatchable,
                bindings: ?*IDMLBindingTable,
            ) callconv(@import("std").os.windows.WINAPI) void,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDMLDeviceChild.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLCommandRecorder_RecordDispatch(self: *const T, commandList: ?*ID3D12CommandList, dispatchable: ?*IDMLDispatchable, bindings: ?*IDMLBindingTable) void {
                return @as(*const IDMLCommandRecorder.VTable, @ptrCast(self.vtable)).RecordDispatch(@as(*const IDMLCommandRecorder, @ptrCast(self)), commandList, dispatchable, bindings);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

const IID_IDMLDebugDevice_Value = Guid.initString("7d6f3ac9-394a-4ac3-92a7-390cc57a8217");
pub const IID_IDMLDebugDevice = &IID_IDMLDebugDevice_Value;
pub const IDMLDebugDevice = extern struct {
    pub const VTable = extern struct {
        base: IUnknown.VTable,
        SetMuteDebugOutput: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLDebugDevice,
                mute: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) void,
            else => *const fn (
                self: *const IDMLDebugDevice,
                mute: BOOL,
            ) callconv(@import("std").os.windows.WINAPI) void,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IUnknown.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLDebugDevice_SetMuteDebugOutput(self: *const T, mute: BOOL) void {
                return @as(*const IDMLDebugDevice.VTable, @ptrCast(self.vtable)).SetMuteDebugOutput(@as(*const IDMLDebugDevice, @ptrCast(self)), mute);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

pub const DML_GRAPH_EDGE_TYPE = enum(i32) {
    INVALID = 0,
    INPUT = 1,
    OUTPUT = 2,
    INTERMEDIATE = 3,
};
pub const DML_GRAPH_EDGE_TYPE_INVALID = DML_GRAPH_EDGE_TYPE.INVALID;
pub const DML_GRAPH_EDGE_TYPE_INPUT = DML_GRAPH_EDGE_TYPE.INPUT;
pub const DML_GRAPH_EDGE_TYPE_OUTPUT = DML_GRAPH_EDGE_TYPE.OUTPUT;
pub const DML_GRAPH_EDGE_TYPE_INTERMEDIATE = DML_GRAPH_EDGE_TYPE.INTERMEDIATE;

pub const DML_GRAPH_EDGE_DESC = extern struct {
    Type: DML_GRAPH_EDGE_TYPE,
    Desc: ?*const anyopaque,
};

pub const DML_INPUT_GRAPH_EDGE_DESC = extern struct {
    GraphInputIndex: u32,
    ToNodeIndex: u32,
    ToNodeInputIndex: u32,
    Name: ?[*:0]const u8,
};

pub const DML_OUTPUT_GRAPH_EDGE_DESC = extern struct {
    FromNodeIndex: u32,
    FromNodeOutputIndex: u32,
    GraphOutputIndex: u32,
    Name: ?[*:0]const u8,
};

pub const DML_INTERMEDIATE_GRAPH_EDGE_DESC = extern struct {
    FromNodeIndex: u32,
    FromNodeOutputIndex: u32,
    ToNodeIndex: u32,
    ToNodeInputIndex: u32,
    Name: ?[*:0]const u8,
};

pub const DML_GRAPH_NODE_TYPE = enum(i32) {
    INVALID = 0,
    OPERATOR = 1,
};
pub const DML_GRAPH_NODE_TYPE_INVALID = DML_GRAPH_NODE_TYPE.INVALID;
pub const DML_GRAPH_NODE_TYPE_OPERATOR = DML_GRAPH_NODE_TYPE.OPERATOR;

pub const DML_GRAPH_NODE_DESC = extern struct {
    Type: DML_GRAPH_NODE_TYPE,
    Desc: ?*const anyopaque,
};

pub const DML_OPERATOR_GRAPH_NODE_DESC = extern struct {
    Operator: ?*IDMLOperator,
    Name: ?[*:0]const u8,
};

pub const DML_GRAPH_DESC = extern struct {
    InputCount: u32,
    OutputCount: u32,
    NodeCount: u32,
    Nodes: ?*const DML_GRAPH_NODE_DESC,
    InputEdgeCount: u32,
    InputEdges: ?*const DML_GRAPH_EDGE_DESC,
    OutputEdgeCount: u32,
    OutputEdges: ?*const DML_GRAPH_EDGE_DESC,
    IntermediateEdgeCount: u32,
    IntermediateEdges: ?*const DML_GRAPH_EDGE_DESC,
};

const IID_IDMLDevice1_Value = Guid.initString("a0884f9a-d2be-4355-aa5d-5901281ad1d2");
pub const IID_IDMLDevice1 = &IID_IDMLDevice1_Value;
pub const IDMLDevice1 = extern struct {
    pub const VTable = extern struct {
        base: IDMLDevice.VTable,
        CompileGraph: switch (@import("builtin").zig_backend) {
            .stage1 => fn (
                self: *const IDMLDevice1,
                desc: ?*const DML_GRAPH_DESC,
                flags: DML_EXECUTION_FLAGS,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
            else => *const fn (
                self: *const IDMLDevice1,
                desc: ?*const DML_GRAPH_DESC,
                flags: DML_EXECUTION_FLAGS,
                riid: ?*const Guid,
                ppv: ?*?*anyopaque,
            ) callconv(@import("std").os.windows.WINAPI) HRESULT,
        },
    };
    vtable: *const VTable,
    pub fn MethodMixin(comptime T: type) type {
        return struct {
            pub usingnamespace IDMLDevice.MethodMixin(T);
            // NOTE: method is namespaced with interface name to avoid conflicts for now
            pub inline fn IDMLDevice1_CompileGraph(self: *const T, desc: ?*const DML_GRAPH_DESC, flags: DML_EXECUTION_FLAGS, riid: ?*const Guid, ppv: ?*?*anyopaque) HRESULT {
                return @as(*const IDMLDevice1.VTable, @ptrCast(self.vtable)).CompileGraph(@as(*const IDMLDevice1, @ptrCast(self)), desc, flags, riid, ppv);
            }
        };
    }
    pub usingnamespace MethodMixin(@This());
};

//--------------------------------------------------------------------------------
// Section: Functions (2)
//--------------------------------------------------------------------------------
// TODO: this type is limited to platform 'windows10.0.10240'
pub extern "directml" fn DMLCreateDevice(
    d3d12Device: ?*ID3D12Device,
    flags: DML_CREATE_DEVICE_FLAGS,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

pub extern "directml" fn DMLCreateDevice1(
    d3d12Device: ?*ID3D12Device,
    flags: DML_CREATE_DEVICE_FLAGS,
    minimumFeatureLevel: DML_FEATURE_LEVEL,
    riid: ?*const Guid,
    ppv: ?*?*anyopaque,
) callconv(@import("std").os.windows.WINAPI) HRESULT;

//--------------------------------------------------------------------------------
// Section: Unicode Aliases (0)
//--------------------------------------------------------------------------------
const thismodule = @This();
pub usingnamespace switch (@import("../../zig.zig").unicode_mode) {
    .ansi => struct {},
    .wide => struct {},
    .unspecified => if (@import("builtin").is_test) struct {} else struct {},
};
//--------------------------------------------------------------------------------
// Section: Imports (11)
//--------------------------------------------------------------------------------
const Guid = @import("../../zig.zig").Guid;
const BOOL = @import("../../foundation.zig").BOOL;
const D3D12_CPU_DESCRIPTOR_HANDLE = @import("../../graphics/direct3d12.zig").D3D12_CPU_DESCRIPTOR_HANDLE;
const D3D12_GPU_DESCRIPTOR_HANDLE = @import("../../graphics/direct3d12.zig").D3D12_GPU_DESCRIPTOR_HANDLE;
const HRESULT = @import("../../foundation.zig").HRESULT;
const ID3D12CommandList = @import("../../graphics/direct3d12.zig").ID3D12CommandList;
const ID3D12Device = @import("../../graphics/direct3d12.zig").ID3D12Device;
const ID3D12Resource = @import("../../graphics/direct3d12.zig").ID3D12Resource;
const IUnknown = @import("../../system/com.zig").IUnknown;
const PSTR = @import("../../foundation.zig").PSTR;
const PWSTR = @import("../../foundation.zig").PWSTR;

test {
    @setEvalBranchQuota(comptime @import("std").meta.declarations(@This()).len * 3);

    // reference all the pub declarations
    if (!@import("builtin").is_test) return;
    inline for (comptime @import("std").meta.declarations(@This())) |decl| {
        if (decl.is_pub) {
            _ = @field(@This(), decl.name);
        }
    }
}
