import { cn } from "../../lib/utils";
type IconProps = React.HTMLAttributes<SVGElement>;

export const SpinnerIcon = (props: IconProps) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
      {...props}
    >
      <path d="M21 12a9 9 0 1 1-6.219-8.56" />
    </svg>
  );
};

export const UserAvatarIcon = (props: IconProps) => {
  const { className } = props;

  return (
    <svg
      className={className}
      width="200"
      height="200"
      viewBox="0 0 200 200"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <rect width="200" height="200" fill="#CCFBF1" />
      <path
        d="M100 50C127.6 50 150 72.4 150 100C150 127.6 127.6 150 100 150C72.4 150 50 127.6 50 100C50 72.4 72.4 50 100 50ZM70.1166 117.081C77.4542 128.034 88.4756 135 100.799 135C113.122 135 124.143 128.034 131.481 117.081C123.443 109.586 112.656 105 100.799 105C88.9411 105 78.1548 109.586 70.1166 117.081ZM100 95C108.285 95 115 88.2842 115 80C115 71.7158 108.285 65 100 65C91.7155 65 85 71.7158 85 80C85 88.2842 91.7155 95 100 95Z"
        fill="#14B8A6"
      />
    </svg>
  );
};

export const CompanyLogoIcon = (props: IconProps) => {
  const { className } = props;

  return (
    <svg
      className={className}
      width="200"
      height="200"
      viewBox="0 0 200 200"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <rect width="200" height="200" fill="#FBEECC" />
      <path
        d="M142.545 133.465H152V142.898H48V133.465H57.4545V62.7166C57.4545 60.1117 59.571 58 62.1818 58H109.455C112.065 58 114.182 60.1117 114.182 62.7166V133.465H123.636V86.2993H137.818C140.429 86.2993 142.545 88.411 142.545 91.0159V133.465ZM76.3636 95.7324V105.166H95.2727V95.7324H76.3636ZM76.3636 76.8662V86.2993H95.2727V76.8662H76.3636Z"
        fill="#DF7513"
      />
    </svg>
  );
};

export const LogoIcon = (props: IconProps) => {
  const { className } = props;

  return (
    <svg
      className={cn(className)}
      width="800"
      height="800"
      viewBox="0 0 800 800"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M0 399.561C0 187.376 164.852 13.7373 373.333 0V214.583C282.872 227.536 213.333 305.419 213.333 399.561C213.333 502.767 296.907 586.434 400 586.434C441.93 586.434 480.63 572.589 511.792 549.225L663.36 700.964C593.003 762.626 500.86 800 400 800C179.086 800 0 620.716 0 399.561Z"
        fill="black"
        fillOpacity={"0.75"}
      />
      <path
        d="M701.072 663.211C762.672 592.771 800 500.53 800 399.561C800 344.38 788.848 291.806 768.683 243.973L573.611 330.767C582.037 352.058 586.667 375.268 586.667 399.561C586.667 441.535 572.843 480.277 549.504 511.473L701.072 663.211Z"
        fill="black"
        fillOpacity="0.5"
      />
      <path
        d="M426.667 214.583V0C562.219 8.93175 679.323 85.4603 744.672 196.23L546.885 284.23C517.9 247.286 475.308 221.548 426.667 214.583Z"
        fill="black"
        fillOpacity="0.25"
      />
    </svg>
  );
};

export const SignatureIcon = (props: IconProps) => {
  const { className } = props;
  return (
    <svg
      className={cn(className)}
      fill="currentColor"
      width="80px"
      height="80px"
      viewBox="0 0 56 56"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path d="M 1.1883 43.4869 L 13.6935 43.4869 C 13.4483 44.4300 13.3162 45.3542 13.3162 46.2030 C 13.3162 49.2397 15.0138 51.4088 18.5786 51.4088 C 22.9168 51.4088 26.4250 48.3532 28.6884 43.4869 L 54.8118 43.4869 C 55.4719 43.4869 56 42.9777 56 42.3175 C 56 41.6574 55.4719 41.1670 54.8118 41.1670 L 29.6315 41.1670 C 30.6877 38.0737 31.3290 34.4523 31.4611 30.5290 C 32.6494 30.2650 33.8941 30.1329 35.1769 30.1329 C 35.8371 30.1329 36.2141 30.4159 36.2141 30.9063 C 36.2141 32.5472 35.3276 33.8298 35.3276 35.4708 C 35.3276 36.9043 36.3841 37.7719 37.7608 37.7719 C 41.5896 37.7719 46.2108 31.2269 47.7385 31.2269 C 49.1342 31.2269 47.3990 37.1117 52.1522 37.1117 C 52.9256 37.1117 53.9253 36.9043 54.6986 36.4139 C 55.1513 36.0932 55.4719 35.6405 55.4719 35.0558 C 55.4719 34.3391 55.0192 33.7544 54.2648 33.7544 C 53.6046 33.7544 53.0577 34.3013 52.4164 34.3013 C 50.3792 34.3013 52.3218 28.0393 48.5687 28.0393 C 45.2868 28.0393 40.1561 34.4145 38.8548 34.4145 C 38.6852 34.4145 38.5531 34.3202 38.5531 34.0939 C 38.5531 33.4149 39.4017 31.8871 39.4017 30.3593 C 39.4017 28.4732 37.8361 27.2660 35.3844 27.2660 C 34.0451 27.2660 32.7248 27.3980 31.4611 27.6432 C 31.0461 17.7032 26.3307 9.8756 19.1256 9.8756 C 14.2782 9.8756 10.5436 14.0063 10.5436 19.2687 C 10.5436 25.4176 14.5423 30.6799 19.5217 34.1693 C 17.3149 36.3384 15.5985 38.8093 14.5423 41.1670 L 1.1883 41.1670 C .5281 41.1670 0 41.6574 0 42.3175 C 0 42.9777 .5281 43.4869 1.1883 43.4869 Z M 13.4106 19.2687 C 13.4106 15.5907 15.9003 12.7426 19.1256 12.7426 C 24.7841 12.7426 28.4432 19.7780 28.6130 28.4166 C 26.0101 29.3219 23.6335 30.6988 21.5776 32.3397 C 17.6544 29.6237 13.4106 25.1347 13.4106 19.2687 Z M .6413 37.1495 C 1.1317 37.6399 1.8673 37.6210 2.3765 37.1495 L 4.7342 34.7918 L 7.0919 37.1495 C 7.5823 37.6399 8.3368 37.6399 8.8272 37.1495 C 9.3176 36.6591 9.3176 35.9046 8.8272 35.4142 L 6.4695 33.0754 L 8.8272 30.7177 C 9.3176 30.2273 9.3176 29.4917 8.8272 29.0012 C 8.3368 28.4920 7.5823 28.5109 7.0919 29.0012 L 4.7342 31.3401 L 2.3765 29.0012 C 1.8673 28.4920 1.1317 28.4920 .6413 29.0012 C .1509 29.4917 .1509 30.2461 .6413 30.7177 L 2.9990 33.0754 L .6413 35.4142 C .1509 35.9235 .1509 36.6591 .6413 37.1495 Z M 23.6335 36.5459 C 23.8787 36.6591 24.1051 36.7156 24.3314 36.7156 C 25.1047 36.7156 25.6517 36.1121 25.6517 35.4708 C 25.6517 34.9992 25.4254 34.5466 24.8784 34.2825 C 24.6143 34.1505 24.3503 34.0184 24.0674 33.8675 C 25.4254 32.9056 26.9343 32.0568 28.5564 31.4155 C 28.3300 35.0558 27.6322 38.4132 26.5571 41.1670 L 17.5790 41.1670 C 18.5597 39.3185 20.0309 37.3758 21.8982 35.6594 C 22.4641 35.9800 23.0488 36.2630 23.6335 36.5459 Z M 16.2586 45.6560 C 16.2586 44.9959 16.3718 44.2603 16.6170 43.4869 L 25.4820 43.4869 C 23.7844 46.6180 21.5022 48.5418 18.8993 48.5418 C 17.0886 48.5418 16.2586 47.3536 16.2586 45.6560 Z" />
    </svg>
  );
};

export const ArrowRight = (props: IconProps) => {
  const { className } = props;
  return (
    <svg
      className={cn(className)}
      width="15px"
      height="15px"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 24 24"
      fill="currentColor"
    >
      <path d="M16.1716 10.9999L10.8076 5.63589L12.2218 4.22168L20 11.9999L12.2218 19.778L10.8076 18.3638L16.1716 12.9999H4V10.9999H16.1716Z"></path>
    </svg>
  );
};
