<h2 id="hosting">🚀 Self hosting</h2>

Captable, Inc. is an open-source project that you can host on your own server. This gives you full control over your data.

If you like to self-host Captable, Inc., please schedule a call with us, and we will help you set up your own instance.

<a href="https://captable.inc/schedule/"><img alt="Book us" src="https://cal.com/book-with-cal-dark.svg" /></a>

- **Prerequisites**:
  - Docker
  - Postgres database (RDS, Cloud SQL, Supabase, Neon etc.)
  - SMTP provider (Resend, AWS SES, Mailgun, Sendgrid etc.)
  - S3 Compatible storage (AWS S3, R2, Minio, Backblaze etc.)

- **Official Docker Images**:
  - <a href="https://hub.docker.com/r/captable/captable" target="_blank">Docker hub</a>
  <!-- - <a href="https://github.com/captableinc/captable/pkgs/container/captable" target="_blank">Github registry</a> -->

- **Environment Variables**:\
Following envrionment variables are required

```bash
NODE_ENV="production"
DATABASE_URL="postgres://user:password@host:port/dbname"
NEXTAUTH_SECRET="xxx" # Generated by `openssl rand -base64 32`
NEXTAUTH_URL="https://your-domain.com"
NEXT_PUBLIC_BASE_URL="https://your-domain.com"

# Email server environment variables
EMAIL_FROM="your@email.com"

# Please use encrypted/TLS connection for SMTP server.
EMAIL_SERVER="smtp://username:password@host:port"

# File uplod environment variables
UPLOAD_REGION="us-west-1" # auto when using Cloudflare R2
UPLOAD_ENDPOINT="https://xxx.r2.cloudflarestorage.com"
UPLOAD_ACCESS_KEY_ID="xxx"
UPLOAD_SECRET_ACCESS_KEY="xxx"
UPLOAD_BUCKET_PUBLIC="public-bucket-name"
UPLOAD_BUCKET_PRIVATE="private-bucket-name"
```

Following environment variables are optional

```bash
# If you are using custom domain, especially with Cloudflare R2, AWAS S3 with custom domain.
NEXT_PUBLIC_UPLOAD_DOMAIN="https://custom.your-domain.com" 
```


- **Run the docker container**:

```bash
docker run -d \
  -e NODE_ENV="replace" \
  -e DATABASE_URL="replace" \
  -e NEXTAUTH_SECRET="replace" \
  -e NEXTAUTH_URL="replace" \
  -e NEXT_PUBLIC_BASE_URL="replace" \
  -e EMAIL_FROM="replace" \
  -e EMAIL_SERVER="replace" \
  -e UPLOAD_REGION="replace" \
  -e UPLOAD_ENDPOINT="replace" \
  -e NEXT_PUBLIC_UPLOAD_DOMAIN="replace" \
  -e UPLOAD_ACCESS_KEY_ID="replace" \
  -e UPLOAD_SECRET_ACCESS_KEY="replace" \
  -e UPLOAD_BUCKET_PUBLIC="replace" \
  -e UPLOAD_BUCKET_PRIVATE="replace" \
  -p 3000:3000 \
  captable/captable
```

- **Setup CORS for file uploads**:\
  Some of the services including Cloudflare R2 may require you to setup CORS for file uploads.\
  
  > Here is an sample CORS configuration for Cloudflare R2.

```json
[
  {
    "AllowedOrigins": [
      "https://your-domain.com"
    ],
    "AllowedMethods": [
      "HEAD",
      "GET",
      "POST",
      "PUT",
      "DELETE"
    ],
    "AllowedHeaders": [
      "*"
    ]
  }
]
```

- **Run database migrations**:

```bash
docker exec -it <container_id> npx prisma migrate deploy
```

<!-- Ready -->
- **Access the application**:\
  Open your browser and navigate to `https://your-domain.com`

- **Questions?**\
  If you have any questions, please schedule a call with us, and we will help you set up your own instance.

  <a href="https://captable.inc/schedule/"><img alt="Book us" src="https://cal.com/book-with-cal-dark.svg" /></a>
