# Contributing to IndieWeb Search

IndieWeb Search is actively open to contributions, big or small. You don't need to have any prior experience with search to participate.

## Our Vision

IndieWeb Search aims to be an effective discovery engine for the IndieWeb community. We want to build a search engine that makes it easy to find new websites in the IndieWeb community and to get answers to questions you may have that member websites may have written about.

To accomplish this goal, we want to:

1. Create an easy-to-use search interface.
2. Develop an algorithm that shows relevant results at the top.
3. When possible, provide direct answers to questions.

IndieWeb Search is built on top of many community standards. For instance, our direct answer logic is powered entirely with microformats. We want to encourage use of standards that are already in use and are relevant to the community.

## How to Contribute

We welcome any contributions to improve the IndieWeb Search engine. Here are the best ways in which you can assist us in improving this project:

1. Add a new feature to the library (discussed further below).
2. Fix a bug present with an existing feature.
3. Add new documentation to our wiki which outlines how to use and navigate the project.
4. Tell us what feature you would like to see in the search engine next.
5. Help clean up the code in the project.

### Adding New Features

Once you have an idea for a new feature, please add an Issue to the project that outlines your idea. This will enable the core contributors to weigh in on your idea and potentially guide you in the right direction if you need assistance on how to implement your feature idea.

### Preparing to Submit Pull Requests

IndieWeb Search is a relatively complicated project. Before you add new features, please read through the project GitHub wiki to make sure you understand how everything works at a high level.

There are three main areas in which you can contribute a new feature:

1. The crawler that retrieves and saves content from websites.
2. The web interface that allows users to search for content.
3. The search algorithm that determines which results are relevant.

When you have a clear idea on what feature you want to build and have discussed it via a GitHub issue, you can begin to work on your change or addition.

## How to Push a Change

Please refer to the indieweb-utils "[How to Make a Change](https://github.com/capjamesg/indieweb-utils/blob/main/CONTRIBUTING.md#how-to-make-a-change)" document for instructions on how to add a new feature or modify the contents of this project.

## Feedback

How can we improve this contributing guide? Are we missing some key information that could help you get started? If you have any feedback, feel free to file an issue in the project GitHub repository.