/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.util;

import java.io.PrintStream;
import java.io.PrintWriter;

public abstract class NestableCheckedException
extends Exception {
    private static final String NESTING_MESSAGE = "Nested Exception: ";
    private Throwable cause;

    public NestableCheckedException() {
    }

    public NestableCheckedException(String message) {
        super(message);
    }

    public NestableCheckedException(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    public NestableCheckedException(Throwable cause) {
        this.cause = cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void getMessage(StringBuffer sb) {
        sb.append(super.getMessage());
        sb.append("\n");
        if (this.cause != null) {
            sb.append(NESTING_MESSAGE);
            if (this.cause instanceof NestableCheckedException) {
                NestableCheckedException chainedCause = (NestableCheckedException)this.cause;
                chainedCause.getMessage(sb);
            } else {
                sb.append(this.cause.getMessage());
            }
        }
    }

    public void printStackTrace() {
        super.printStackTrace();
        Throwable t = this.getCause();
        if (t != null) {
            System.err.println(NESTING_MESSAGE);
            t.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        Throwable t = this.getCause();
        if (t != null) {
            out.println(NESTING_MESSAGE);
            t.printStackTrace(out);
        }
    }

    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        Throwable t = this.getCause();
        if (t != null) {
            out.println(NESTING_MESSAGE);
            t.printStackTrace(out);
        }
    }
}

