/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.copiers.dsl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.MorphException;
import net.sf.morph.transform.Copier;
import net.sf.morph.transform.NodeCopier;
import net.sf.morph.transform.copiers.CumulativeCopier;
import net.sf.morph.transform.copiers.PropertyExpressionMappingCopier;
import net.sf.morph.transform.copiers.PropertyNameMatchingCopier;
import net.sf.morph.transform.copiers.dsl.DSLDefinedCopier;
import net.sf.morph.transform.copiers.dsl.Direction;
import net.sf.morph.util.Assert;
import net.sf.morph.util.ContainerUtils;
import net.sf.morph.util.ProxyUtils;

class CopierDef {
    private DSLDefinedCopier parent;
    private Class leftClass;
    private Direction direction;
    private Class rightClass;
    private boolean matchProperties;
    private Set includeProperties;
    private Set ignoreProperties;
    private PropertyMaps propertyMapps;
    static /* synthetic */ Class class$net$sf$morph$transform$NodeCopier;

    public CopierDef(DSLDefinedCopier parent, Class leftClass, Direction direction, Class rightClass) {
        Assert.notNull((Object)((Object)parent), (String)"parent");
        this.parent = parent;
        Assert.notNull((Object)leftClass, (String)"leftClass");
        this.leftClass = leftClass;
        Assert.notNull((Object)direction, (String)"direction");
        this.direction = direction;
        Assert.notNull((Object)rightClass, (String)"rightClass");
        this.rightClass = rightClass;
        this.propertyMapps = new PropertyMaps();
    }

    public synchronized void setMatchProperties(boolean matchProperties) {
        this.matchProperties = matchProperties;
    }

    public synchronized Map getPropertyMap(Direction direction) {
        return this.propertyMapps.getExposedMap(this.resolveDirection(direction));
    }

    public synchronized Set getIgnoreProperties() {
        if (this.ignoreProperties == null) {
            this.ignoreProperties = ContainerUtils.createOrderedSet();
        }
        return this.ignoreProperties;
    }

    public synchronized Set getIncludeProperties() {
        if (this.includeProperties == null) {
            this.includeProperties = ContainerUtils.createOrderedSet();
        }
        return this.includeProperties;
    }

    public synchronized List getCopiers() {
        PropertyNameMatchingCopier matcher = this.createMatcher();
        if (this.propertyMapps.isEmpty()) {
            if (matcher == null) {
                return Collections.EMPTY_LIST;
            }
            matcher.setSourceClasses(this.getSourceClasses(this.direction));
            matcher.setDestinationClasses(this.getDestClasses(this.direction));
            return Collections.singletonList(matcher);
        }
        ArrayList<PropertyNameMatchingCopier> leftCopiers = null;
        ArrayList<PropertyNameMatchingCopier> rightCopiers = null;
        if (this.direction != Direction.RIGHT) {
            leftCopiers = new ArrayList<PropertyNameMatchingCopier>();
            if (matcher != null) {
                matcher.setSourceClasses(this.getSourceClasses(Direction.LEFT));
                matcher.setDestinationClasses(this.getDestClasses(Direction.LEFT));
                leftCopiers.add(matcher);
            }
            this.addNotNull(leftCopiers, this.createMapper(Direction.LEFT));
            matcher = null;
        }
        if (this.direction != Direction.LEFT) {
            rightCopiers = new ArrayList<PropertyNameMatchingCopier>();
            if (matcher == null) {
                matcher = this.createMatcher();
            }
            if (matcher != null) {
                matcher.setSourceClasses(this.getSourceClasses(Direction.RIGHT));
                matcher.setDestinationClasses(this.getDestClasses(Direction.RIGHT));
                rightCopiers.add(matcher);
            }
            this.addNotNull(rightCopiers, this.createMapper(Direction.RIGHT));
        }
        List result = this.addNotNull(new ArrayList(), this.accumulate(rightCopiers));
        result = this.addNotNull(result, this.accumulate(leftCopiers));
        return result;
    }

    private Copier accumulate(List l) {
        if (ObjectUtils.isEmpty((Object)l)) {
            return null;
        }
        if (l.size() == 1) {
            return (Copier)l.get(0);
        }
        CumulativeCopier result = new CumulativeCopier();
        result.setComponents((Object[])l.toArray(new Copier[l.size()]));
        return (NodeCopier)ProxyUtils.getProxy((Object)result, (Class)(class$net$sf$morph$transform$NodeCopier == null ? (class$net$sf$morph$transform$NodeCopier = CopierDef.class$("net.sf.morph.transform.NodeCopier")) : class$net$sf$morph$transform$NodeCopier));
    }

    private PropertyNameMatchingCopier createMatcher() {
        if (!this.matchProperties && ObjectUtils.isEmpty((Object)this.includeProperties)) {
            return null;
        }
        PropertyNameMatchingCopier matcher = new PropertyNameMatchingCopier();
        if (!ObjectUtils.isEmpty((Object)this.includeProperties)) {
            matcher.setPropertiesToCopy(this.toStringArray(this.includeProperties));
        }
        if (!ObjectUtils.isEmpty((Object)this.ignoreProperties)) {
            matcher.setPropertiesToIgnore(this.toStringArray(this.ignoreProperties));
        }
        matcher.setReflector(this.parent.getReflector());
        return matcher;
    }

    private String[] toStringArray(Set s) {
        return s.toArray(new String[s.size()]);
    }

    private Direction resolveDirection(Direction dir) {
        if (this.direction == dir || this.direction == Direction.BIDI) {
            return dir;
        }
        if (dir == Direction.BIDI) {
            return this.direction;
        }
        throw new IllegalArgumentException("property mapping direction: " + dir);
    }

    private PropertyExpressionMappingCopier createMapper(Direction d) {
        Map m = this.propertyMapps.getAdjustedMap(d);
        if (m.isEmpty()) {
            return null;
        }
        PropertyExpressionMappingCopier mapper = new PropertyExpressionMappingCopier();
        mapper.setMapping(m);
        mapper.setReflector(this.parent.getReflector());
        mapper.setSourceClasses(this.getSourceClasses(d));
        mapper.setDestinationClasses(this.getDestClasses(d));
        return mapper;
    }

    private List addNotNull(List l, Object o) {
        if (o != null) {
            l.add(o);
        }
        return l;
    }

    private Class[] getSourceClasses(Direction dir) {
        Class[] classArray;
        Direction d = this.resolveDirection(dir);
        if (d == Direction.BIDI && this.leftClass != this.rightClass) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = this.leftClass;
            classArray = classArray2;
            classArray2[1] = this.rightClass;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = d == Direction.LEFT ? this.rightClass : this.leftClass;
        }
        return classArray;
    }

    private Class[] getDestClasses(Direction dir) {
        Class[] classArray;
        Direction d = this.resolveDirection(dir);
        if (d == Direction.BIDI && this.leftClass != this.rightClass) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = this.leftClass;
            classArray = classArray2;
            classArray2[1] = this.rightClass;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = d == Direction.LEFT ? this.leftClass : this.rightClass;
        }
        return classArray;
    }

    public synchronized Direction getDirection() {
        return this.direction;
    }

    public synchronized Class getLeftClass() {
        return this.leftClass;
    }

    public synchronized boolean isMatchProperties() {
        return this.matchProperties;
    }

    public synchronized Class getRightClass() {
        return this.rightClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PropertyMaps {
        Map rightward;
        Map leftward;
        Map exposeLeftward;
        Map bidi;

        PropertyMaps() {
            try {
                this.rightward = (Map)CopierDef.this.parent.getPropertyMapClass().newInstance();
                this.leftward = (Map)CopierDef.this.parent.getPropertyMapClass().newInstance();
            }
            catch (Exception e) {
                throw new MorphException((Throwable)e);
            }
            this.exposeLeftward = new AbstractMap(){

                public Set entrySet() {
                    return Collections.EMPTY_SET;
                }

                public Object put(Object right, Object left) {
                    return PropertyMaps.this.leftward.put(left, right);
                }
            };
            this.bidi = new AbstractMap(){

                public Set entrySet() {
                    return Collections.EMPTY_SET;
                }

                public Object put(Object left, Object right) {
                    PropertyMaps.this.rightward.put(left, right);
                    PropertyMaps.this.exposeLeftward.put(left, right);
                    return null;
                }
            };
        }

        Map getExposedMap(Direction d) {
            return d == Direction.LEFT ? this.exposeLeftward : (d == Direction.RIGHT ? this.rightward : this.bidi);
        }

        Map getAdjustedMap(Direction d) {
            return d == Direction.LEFT ? this.leftward : (d == Direction.RIGHT ? this.rightward : null);
        }

        boolean isEmpty() {
            return this.rightward.isEmpty() && this.leftward.isEmpty();
        }
    }
}

