/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.reflect.BeanReflector;
import net.sf.morph.reflect.ReflectionException;
import net.sf.morph.transform.TransformationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.TypeMismatchException;

public class MorphBeanWrapper
extends AbstractPropertyAccessor
implements BeanWrapper {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$morph$beans$MorphBeanWrapper == null ? (class$net$sf$morph$beans$MorphBeanWrapper = MorphBeanWrapper.class$("net.sf.morph.beans.MorphBeanWrapper")) : class$net$sf$morph$beans$MorphBeanWrapper));
    private Object bean;
    private BeanReflector beanReflector;
    static /* synthetic */ Class class$net$sf$morph$beans$MorphBeanWrapper;

    public MorphBeanWrapper() {
    }

    public MorphBeanWrapper(Object bean) {
        this();
        this.setWrappedInstance(bean);
    }

    public void setWrappedInstance(Object bean) {
        this.bean = bean;
    }

    public Object getWrappedInstance() {
        return this.bean;
    }

    public Class getWrappedClass() {
        if (this.bean == null) {
            throw new NullPointerException("The wrapped instance has not been set, so the wrapped class cannot be determined");
        }
        return this.bean.getClass();
    }

    protected PropertyChangeEvent getPropertyChangeEvent(String propertyName, Object newValue) {
        Object oldValue;
        try {
            oldValue = this.beanReflector.get(this.bean, propertyName);
        }
        catch (ReflectionException e) {
            oldValue = null;
        }
        return new PropertyChangeEvent(this.bean, propertyName, oldValue, newValue);
    }

    public PropertyEditor findCustomEditor(Class requiredType, String propertyPath) {
        throw new UnsupportedOperationException();
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) throws BeansException {
        throw new UnsupportedOperationException();
    }

    public PropertyDescriptor[] getPropertyDescriptors() throws BeansException {
        throw new UnsupportedOperationException();
    }

    public void setExtractOldValueForEditor(boolean extractOldValueForEditor) {
    }

    public boolean isExtractOldValueForEditor() {
        return false;
    }

    public Class getPropertyType(String propertyName) throws BeansException {
        try {
            return this.beanReflector.getType(this.bean, propertyName);
        }
        catch (ReflectionException e) {
            throw new FatalBeanException("Unable to retrieve type for property '" + propertyName + "' of bean " + ObjectUtils.getObjectDescription((Object)this.bean));
        }
    }

    public boolean isReadableProperty(String propertyName) throws BeansException {
        try {
            return this.beanReflector.isReadable(this.bean, propertyName);
        }
        catch (ReflectionException e) {
            throw new FatalBeanException("Unable to determine if property '" + propertyName + "' is readable in bean " + ObjectUtils.getObjectDescription((Object)this.bean), (Throwable)e);
        }
    }

    public boolean isWritableProperty(String propertyName) throws BeansException {
        try {
            return this.beanReflector.isWriteable(this.bean, propertyName);
        }
        catch (ReflectionException e) {
            throw new NotWritablePropertyException(this.bean.getClass(), propertyName);
        }
    }

    public void registerCustomEditor(Class requiredType, PropertyEditor propertyEditor) {
        throw new UnsupportedOperationException();
    }

    public void registerCustomEditor(Class requiredType, String propertyPath, PropertyEditor propertyEditor) {
        throw new UnsupportedOperationException();
    }

    public Object getPropertyValue(String propertyName) throws BeansException {
        try {
            return this.beanReflector.get(this.bean, propertyName);
        }
        catch (ReflectionException e) {
            throw new FatalBeanException("Unable to retrieve property '" + propertyName + "' from bean " + ObjectUtils.getObjectDescription((Object)this.bean), (Throwable)e);
        }
    }

    public void setPropertyValue(String propertyName, Object value) throws BeansException {
        try {
            this.beanReflector.set(this.bean, propertyName, value);
        }
        catch (ReflectionException e) {
            if (e.getCause() instanceof TransformationException) {
                Class requiredType;
                block5: {
                    requiredType = null;
                    try {
                        requiredType = this.getPropertyType(propertyName);
                    }
                    catch (BeansException logged) {
                        if (!log.isWarnEnabled()) break block5;
                        log.warn((Object)("Type for property '" + propertyName + "' could not be determined"), (Throwable)logged);
                    }
                }
                throw new TypeMismatchException(this.getPropertyChangeEvent(propertyName, value), requiredType, (Throwable)e);
            }
            throw new MethodInvocationException(this.getPropertyChangeEvent(propertyName, value), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

