/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.morph.Morph2;
import net.sf.morph.MorphTestCase;
import net.sf.morph.reflect.ReflectionException;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.util.TestObjects;
import net.sf.morph.util.TestUtils;

public class Morph2TestCase
extends MorphTestCase {
    static /* synthetic */ Class array$Ljava$lang$Integer;
    static /* synthetic */ Class array$Ljava$util$Map;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class array$Lnet$sf$morph$Morph2TestCase$ITestInterface;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$Comparable;

    public void testGetLongObject() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("longObject", "2");
        TestUtils.assertEquals((Object)new Long(2L), (Object)Morph2.getLongObject(map, "longObject"));
    }

    public void testRuntimeArrayTypeOfConversion() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new Integer(1));
        list.add(new Integer(2));
        list.add(new BigDecimal(3));
        Object converted = Morph2.convert(array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = Morph2TestCase.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer, list);
        Morph2TestCase.assertTrue((boolean)(converted instanceof Integer[]));
        list = new ArrayList();
        list.add(new HashMap());
        list.add(new HashMap());
        Map[] result = new Map[]{new HashMap(), new HashMap()};
        converted = Morph2.convert(array$Ljava$util$Map == null ? (array$Ljava$util$Map = Morph2TestCase.class$("[Ljava.util.Map;")) : array$Ljava$util$Map, list);
        Morph2TestCase.assertSame((Object)(array$Ljava$util$Map == null ? (array$Ljava$util$Map = Morph2TestCase.class$("[Ljava.util.Map;")) : array$Ljava$util$Map), converted.getClass());
        TestUtils.assertEquals((Object)result, (Object)converted);
        list = new ArrayList();
        list.add(new Integer(2));
        list.add(new Integer(3));
        converted = Morph2.convert(class$java$util$Set == null ? (class$java$util$Set = Morph2TestCase.class$("java.util.Set")) : class$java$util$Set, list);
        Morph2TestCase.assertSame((Object)(class$java$util$HashSet == null ? (class$java$util$HashSet = Morph2TestCase.class$("java.util.HashSet")) : class$java$util$HashSet), converted.getClass());
        TestUtils.assertEquals((Object)converted, new HashSet(list));
        list = new ArrayList();
        list.add(new TestImplementation());
        list.add(new TestImplementation());
        converted = Morph2.convert(array$Lnet$sf$morph$Morph2TestCase$ITestInterface == null ? (array$Lnet$sf$morph$Morph2TestCase$ITestInterface = Morph2TestCase.class$("[Lnet.sf.morph.Morph2TestCase$ITestInterface;")) : array$Lnet$sf$morph$Morph2TestCase$ITestInterface, list);
        Morph2TestCase.assertEquals((Object)(array$Lnet$sf$morph$Morph2TestCase$ITestInterface == null ? (array$Lnet$sf$morph$Morph2TestCase$ITestInterface = Morph2TestCase.class$("[Lnet.sf.morph.Morph2TestCase$ITestInterface;")) : array$Lnet$sf$morph$Morph2TestCase$ITestInterface), converted.getClass());
        TestUtils.assertEquals((Object)converted, (Object)new ITestInterface[]{new TestImplementation(), new TestImplementation()});
        list = new ArrayList();
        converted = Morph2.convert(array$Lnet$sf$morph$Morph2TestCase$ITestInterface == null ? (array$Lnet$sf$morph$Morph2TestCase$ITestInterface = Morph2TestCase.class$("[Lnet.sf.morph.Morph2TestCase$ITestInterface;")) : array$Lnet$sf$morph$Morph2TestCase$ITestInterface, list);
        Morph2TestCase.assertEquals((Object)(array$Lnet$sf$morph$Morph2TestCase$ITestInterface == null ? (array$Lnet$sf$morph$Morph2TestCase$ITestInterface = Morph2TestCase.class$("[Lnet.sf.morph.Morph2TestCase$ITestInterface;")) : array$Lnet$sf$morph$Morph2TestCase$ITestInterface), converted.getClass());
        TestUtils.assertEquals((Object)converted, (Object)new ITestInterface[0]);
        list = new ArrayList();
        converted = Morph2.convert(array$Ljava$lang$String == null ? (array$Ljava$lang$String = Morph2TestCase.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, list);
        Morph2TestCase.assertEquals((Object)(array$Ljava$lang$String == null ? (array$Ljava$lang$String = Morph2TestCase.class$("[Ljava.lang.String;")) : array$Ljava$lang$String), converted.getClass());
        TestUtils.assertEquals((Object)converted, (Object)new String[0]);
    }

    public void testNumberAndCalendarConversion() {
        Date date = new Date(2005, 0, 1);
        GregorianCalendar newYearsDay2005 = new GregorianCalendar();
        newYearsDay2005.setTime(date);
        TestUtils.assertEquals((Object)newYearsDay2005, (Object)Morph2.convertToCalendar(new Long(date.getTime())));
        TestUtils.assertEquals((Object)new Long(date.getTime()), (Object)Morph2.convertToLongObject(date));
    }

    public void testStringToDoubleConversion() {
        Morph2TestCase.assertEquals((double)2.0, (double)Morph2.convertToDouble("2"), (double)0.001);
        Morph2TestCase.assertEquals((double)2.0, (double)Morph2.convertToDouble("2.0"), (double)0.001);
        Morph2TestCase.assertEquals((double)2.1, (double)Morph2.convertToDouble("2.10000"), (double)0.001);
        Morph2TestCase.assertEquals((double)2.5, (double)Morph2.convertToDouble("2.5"), (double)0.001);
        Morph2TestCase.assertEquals((double)2.9, (double)Morph2.convertToDouble("2.9"), (double)0.001);
    }

    public void testLocaleSpecificConversions() throws Exception {
        double precision = 1.0E-6;
        Morph2TestCase.assertEquals((double)4444.44, (double)Morph2.convertToDouble("$4,444.44", Locale.US), (double)precision);
        Morph2TestCase.assertEquals((double)4444.44, (double)Morph2.convertToDouble("  $ 4,444.44", Locale.US), (double)precision);
        Morph2TestCase.assertEquals((double)0.35, (double)Morph2.convertToFloat("35%", Locale.US), (double)precision);
        Morph2TestCase.assertEquals((double)0.0035, (double)Morph2.convertToFloat(".35%", Locale.US), (double)precision);
        Morph2TestCase.assertEquals((double)3.5, (double)Morph2.convertToFloat("350%", Locale.US), (double)precision);
        Morph2TestCase.assertEquals((double)3500000.1234, (double)Morph2.convertToDouble("3,500,000.1234", Locale.US), (double)precision);
        Morph2TestCase.assertEquals((String)"3500000", (String)Morph2.convertToString(new Double(3500000.0), Locale.US));
        Locale dutch = new Locale("nl", "");
        Morph2TestCase.assertEquals((double)4444.44, (double)Morph2.convertToDouble("\u20ac4.444,44", dutch), (double)precision);
        Morph2TestCase.assertEquals((double)4444.44, (double)Morph2.convertToDouble("\u20ac 4.444,44", dutch), (double)precision);
        Morph2TestCase.assertEquals((double)0.35, (double)Morph2.convertToFloat("35%", dutch), (double)precision);
        Morph2TestCase.assertEquals((double)0.0035, (double)Morph2.convertToFloat(",35%", dutch), (double)precision);
        Morph2TestCase.assertEquals((double)3.5, (double)Morph2.convertToFloat("350%", dutch), (double)precision);
        Morph2TestCase.assertEquals((double)3500000.1234, (double)Morph2.convertToDouble("3.500.000,1234", dutch), (double)precision);
        Morph2TestCase.assertEquals((String)"3500000", (String)Morph2.convertToString(new Double(3500000.0), dutch));
    }

    public void testCopyToDestWithoutGetter() throws Exception {
        HashMap<String, Integer> source = new HashMap<String, Integer>();
        source.put("testProperty", new Integer(123));
        DestinationWithoutGetter dest = new DestinationWithoutGetter();
        Morph2.copy(dest, source);
        Morph2TestCase.assertTrue((boolean)dest.testProperty.equals(new Integer(123)));
    }

    public void testGetBooleanObject() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("true", Boolean.TRUE);
        map.put("false", Boolean.FALSE);
        map.put("trueStr", "true");
        map.put("falseStr", "false");
        map.put("emptyStr", "");
        map.put("null", null);
        Morph2TestCase.assertEquals((Object)Boolean.TRUE, (Object)Morph2.getBooleanObject(map, "true"));
        Morph2TestCase.assertEquals((Object)Boolean.FALSE, (Object)Morph2.getBooleanObject(map, "false"));
        Morph2TestCase.assertEquals((Object)Boolean.TRUE, (Object)Morph2.getBooleanObject(map, "trueStr"));
        Morph2TestCase.assertEquals((Object)Boolean.FALSE, (Object)Morph2.getBooleanObject(map, "falseStr"));
        Morph2TestCase.assertEquals(null, (Object)Morph2.getBooleanObject(map, "emptyStr"));
        Morph2TestCase.assertEquals(null, (Object)Morph2.getBooleanObject(map, "null"));
    }

    public void testConvertToBoolean() throws Exception {
        Morph2TestCase.assertTrue((boolean)Morph2.convertToBoolean(Boolean.TRUE));
        Morph2TestCase.assertFalse((boolean)Morph2.convertToBoolean(Boolean.FALSE));
        try {
            Morph2.convertToBoolean(null);
            Morph2TestCase.fail((String)"Should not have been able to convert null to a boolean");
        }
        catch (TransformationException transformationException) {
            // empty catch block
        }
    }

    public void testConvertToBooleanObject() throws Exception {
        Morph2TestCase.assertEquals((Object)Boolean.TRUE, (Object)Morph2.convertToBooleanObject(Boolean.TRUE));
        Morph2TestCase.assertEquals((Object)Boolean.FALSE, (Object)Morph2.convertToBooleanObject(Boolean.FALSE));
        Morph2TestCase.assertNull((Object)Morph2.convertToBooleanObject(null));
    }

    public void testCopy() {
        CopiableObject source = new CopiableObject();
        source.setBooleanProperty(Boolean.TRUE);
        CopiableObject destination = new CopiableObject();
        Morph2.copy(destination, source);
        Morph2TestCase.assertEquals((Object)destination.getBooleanProperty(), (Object)Boolean.TRUE);
    }

    public void testGetSize() {
        try {
            Morph2.getSize(null);
            Morph2TestCase.fail((String)"Exception should be thrown when retrieving the size of a null object");
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
        Morph2TestCase.assertEquals((int)0, (int)Morph2.getSize(new StringTokenizer("")));
        Morph2TestCase.assertEquals((int)1, (int)Morph2.getSize(new StringTokenizer("1")));
        Morph2TestCase.assertEquals((int)2, (int)Morph2.getSize(new StringTokenizer("two words")));
    }

    public void testWebLikeDataBinding() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("array", "1,2");
        DomainObject object = new DomainObject();
        Morph2.copy(object, map);
        Morph2TestCase.assertEquals((Object)new Integer(1), (Object)object.getArray()[0]);
        Morph2TestCase.assertEquals((Object)new Integer(2), (Object)object.getArray()[1]);
    }

    public void testGetInterfaceType() {
        TestObjects to = new TestObjects();
        Morph2TestCase.assertEquals((Object)new Long(1L), (Object)Morph2.get(to.multiElementEmptyPrimitiveArray, "0", class$java$lang$Comparable == null ? (class$java$lang$Comparable = Morph2TestCase.class$("java.lang.Comparable")) : class$java$lang$Comparable));
        Morph2TestCase.assertEquals((Object)new Long(1L), (Object)Morph2.get(to.oneTwoThreeNumberArray, "0", class$java$lang$Comparable == null ? (class$java$lang$Comparable = Morph2TestCase.class$("java.lang.Comparable")) : class$java$lang$Comparable));
        Morph2TestCase.assertEquals((Object)new Long(1L), (Object)Morph2.get(to.oneTwoThreeObjectArray, "0", class$java$lang$Comparable == null ? (class$java$lang$Comparable = Morph2TestCase.class$("java.lang.Comparable")) : class$java$lang$Comparable));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class DomainObject {
        Integer[] array;

        public Integer[] getArray() {
            return this.array;
        }

        public void setArray(Integer[] array) {
            this.array = array;
        }
    }

    public static class CopiableObject {
        private Boolean booleanProperty;

        public Boolean getBooleanProperty() {
            return this.booleanProperty;
        }

        public void setBooleanProperty(Boolean booleanProperty) {
            this.booleanProperty = booleanProperty;
        }
    }

    public static final class DestinationWithoutGetter {
        Object testProperty;

        public void setTestProperty(Object object) {
            this.testProperty = object;
        }
    }

    protected static class TestImplementation
    implements ITestInterface {
        protected TestImplementation() {
        }
    }

    protected static interface ITestInterface {
    }
}

