/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonplugin;

import com.googlecode.jsonplugin.JSONException;
import com.googlecode.jsonplugin.JSONReader;
import com.googlecode.jsonplugin.JSONWriter;
import com.googlecode.jsonplugin.SerializationParams;
import com.googlecode.jsonplugin.annotations.SMDMethod;
import com.opensymphony.xwork2.util.TextUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONUtil {
    static final String RFC3339_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final Log log = LogFactory.getLog(JSONUtil.class);

    public static String serialize(Object object) throws JSONException {
        JSONWriter writer = new JSONWriter();
        return writer.write(object);
    }

    public static String serialize(Object object, Collection<Pattern> excludeProperties, Collection<Pattern> includeProperties, boolean ignoreHierarchy, boolean excludeNullProperties) throws JSONException {
        JSONWriter writer = new JSONWriter();
        writer.setIgnoreHierarchy(ignoreHierarchy);
        return writer.write(object, excludeProperties, includeProperties, excludeNullProperties);
    }

    public static String serialize(Object object, Collection<Pattern> excludeProperties, Collection<Pattern> includeProperties, boolean ignoreHierarchy, boolean enumAsBean, boolean excludeNullProperties) throws JSONException {
        JSONWriter writer = new JSONWriter();
        writer.setIgnoreHierarchy(ignoreHierarchy);
        writer.setEnumAsBean(enumAsBean);
        return writer.write(object, excludeProperties, includeProperties, excludeNullProperties);
    }

    public static void serialize(Writer writer, Object object) throws IOException, JSONException {
        writer.write(JSONUtil.serialize(object));
    }

    public static void serialize(Writer writer, Object object, Collection<Pattern> excludeProperties, Collection<Pattern> includeProperties, boolean excludeNullProperties) throws IOException, JSONException {
        writer.write(JSONUtil.serialize(object, excludeProperties, includeProperties, true, excludeNullProperties));
    }

    public static Object deserialize(String json) throws JSONException {
        JSONReader reader = new JSONReader();
        return reader.read(json);
    }

    public static Object deserialize(Reader reader) throws JSONException {
        BufferedReader bufferReader = new BufferedReader(reader);
        String line = null;
        StringBuilder buffer = new StringBuilder();
        try {
            while ((line = bufferReader.readLine()) != null) {
                buffer.append(line);
            }
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        return JSONUtil.deserialize(buffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeJSONToResponse(SerializationParams serializationParams) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        if (TextUtils.stringSet((String)serializationParams.getSerializedJSON())) {
            stringBuilder.append(serializationParams.getSerializedJSON());
        }
        if (TextUtils.stringSet((String)serializationParams.getWrapPrefix())) {
            stringBuilder.insert(0, serializationParams.getWrapPrefix());
        } else if (serializationParams.isWrapWithComments()) {
            stringBuilder.insert(0, "/* ");
            stringBuilder.append(" */");
        } else if (serializationParams.isPrefix()) {
            stringBuilder.insert(0, "{}&& ");
        }
        if (TextUtils.stringSet((String)serializationParams.getWrapSuffix())) {
            stringBuilder.append(serializationParams.getWrapSuffix());
        }
        String json = stringBuilder.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[JSON]" + json));
        }
        HttpServletResponse response = serializationParams.getResponse();
        if (serializationParams.getStatusCode() > 0) {
            response.setStatus(serializationParams.getStatusCode());
        } else if (serializationParams.getErrorCode() > 0) {
            response.sendError(serializationParams.getErrorCode());
        }
        if (serializationParams.isSmd()) {
            response.setContentType("application/json-rpc;charset=" + serializationParams.getEncoding());
        } else {
            response.setContentType(serializationParams.getContentType() + ";charset=" + serializationParams.getEncoding());
        }
        if (serializationParams.isNoCache()) {
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Expires", "0");
            response.setHeader("Pragma", "No-cache");
        }
        if (serializationParams.isGzip()) {
            response.addHeader("Content-Encoding", "gzip");
            GZIPOutputStream out = null;
            InputStream in = null;
            try {
                int len;
                out = new GZIPOutputStream((OutputStream)response.getOutputStream());
                in = new ByteArrayInputStream(json.getBytes());
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.finish();
                    out.close();
                }
            }
        } else {
            response.setContentLength(json.getBytes(serializationParams.getEncoding()).length);
            PrintWriter out = response.getWriter();
            out.print(json);
        }
    }

    public static List<String> asList(String commaDelim) {
        if (commaDelim == null || commaDelim.trim().length() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] split = commaDelim.split(",");
        for (int i = 0; i < split.length; ++i) {
            String trimmed = split[i].trim();
            if (trimmed.length() <= 0) continue;
            list.add(trimmed);
        }
        return list;
    }

    public static Method[] listSMDMethods(Class clazz, boolean ignoreInterfaces) {
        final LinkedList<Method> methods = new LinkedList<Method>();
        if (ignoreInterfaces) {
            for (Method method : clazz.getMethods()) {
                SMDMethod smdMethodAnnotation = method.getAnnotation(SMDMethod.class);
                if (smdMethodAnnotation == null) continue;
                methods.add(method);
            }
        } else {
            JSONUtil.visitInterfaces(clazz, new ClassVisitor(){

                public boolean visit(Class aClass) {
                    for (Method method : aClass.getMethods()) {
                        SMDMethod smdMethodAnnotation = method.getAnnotation(SMDMethod.class);
                        if (smdMethodAnnotation == null || methods.contains(method)) continue;
                        methods.add(method);
                    }
                    return true;
                }
            });
        }
        Method[] methodResult = new Method[methods.size()];
        return methods.toArray(methodResult);
    }

    public static boolean visitInterfaces(Class aClass, ClassVisitor visitor) {
        LinkedList<Class> classesVisited = new LinkedList<Class>();
        return JSONUtil.visitUniqueInterfaces(aClass, visitor, classesVisited);
    }

    private static boolean visitUniqueInterfaces(Class thisClass, ClassVisitor visitor, List<Class> classesVisited) {
        boolean okayToContinue = true;
        if (!classesVisited.contains(thisClass)) {
            classesVisited.add(thisClass);
            okayToContinue = visitor.visit(thisClass);
            if (okayToContinue) {
                Class superClass;
                Class<?>[] interfaces = thisClass.getInterfaces();
                int index = 0;
                while (index < interfaces.length && okayToContinue) {
                    okayToContinue = JSONUtil.visitUniqueInterfaces(interfaces[index++], visitor, classesVisited);
                }
                if (okayToContinue && (superClass = thisClass.getSuperclass()) != null && !Object.class.equals(superClass)) {
                    okayToContinue = JSONUtil.visitUniqueInterfaces(superClass, visitor, classesVisited);
                }
            }
        }
        return okayToContinue;
    }

    public static boolean isGzipInRequest(HttpServletRequest request) {
        String header = request.getHeader("Accept-Encoding");
        return header != null && header.indexOf("gzip") >= 0;
    }

    public static interface ClassVisitor {
        public boolean visit(Class var1);
    }
}

