/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonplugin;

import com.googlecode.jsonplugin.JSONUtil;
import com.googlecode.jsonplugin.SerializationParams;
import com.googlecode.jsonplugin.annotations.SMDMethod;
import com.googlecode.jsonplugin.smd.SMD;
import com.googlecode.jsonplugin.smd.SMDMethodParameter;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONResult
implements Result {
    private static final long serialVersionUID = 8624350183189931165L;
    private static final Log log = LogFactory.getLog(JSONResult.class);
    private String defaultEncoding = "ISO-8859-1";
    private List<Pattern> includeProperties;
    private List<Pattern> excludeProperties;
    private String root;
    private boolean wrapWithComments;
    private boolean prefix;
    private boolean enableSMD = false;
    private boolean enableGZIP = false;
    private boolean ignoreHierarchy = true;
    private boolean ignoreInterfaces = true;
    private boolean enumAsBean = false;
    private boolean noCache = false;
    private boolean excludeNullProperties = false;
    private int statusCode;
    private int errorCode;
    private String callbackParameter;
    private String contentType;
    private String wrapPrefix;
    private String wrapSuffix;

    @Inject(value="struts.i18n.encoding")
    public void setDefaultEncoding(String val) {
        this.defaultEncoding = val;
    }

    public List<Pattern> getExcludePropertiesList() {
        return this.excludeProperties;
    }

    public void setExcludeProperties(String commaDelim) {
        List<String> excludePatterns = JSONUtil.asList(commaDelim);
        if (excludePatterns != null) {
            this.excludeProperties = new ArrayList<Pattern>(excludePatterns.size());
            for (String pattern : excludePatterns) {
                this.excludeProperties.add(Pattern.compile(pattern));
            }
        }
    }

    public List<Pattern> getIncludePropertiesList() {
        return this.includeProperties;
    }

    public void setIncludeProperties(String commaDelim) {
        List<String> includePatterns = JSONUtil.asList(commaDelim);
        if (includePatterns != null) {
            this.includeProperties = new ArrayList<Pattern>(includePatterns.size());
            HashMap<String, String> existingPatterns = new HashMap<String, String>();
            for (String pattern : includePatterns) {
                String[] patternPieces = pattern.split("\\\\\\.");
                String patternExpr = "";
                for (String patternPiece : patternPieces) {
                    if (patternExpr.length() > 0) {
                        patternExpr = patternExpr + "\\.";
                    }
                    if (existingPatterns.containsKey(patternExpr = patternExpr + patternPiece)) continue;
                    existingPatterns.put(patternExpr, patternExpr);
                    if (patternPiece.endsWith("\\]")) {
                        this.includeProperties.add(Pattern.compile(patternExpr.substring(0, patternPiece.lastIndexOf("\\["))));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Adding include property expression:  " + patternExpr.substring(0, patternPiece.lastIndexOf("\\["))));
                        }
                    }
                    this.includeProperties.add(Pattern.compile(patternExpr));
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Adding include property expression:  " + patternExpr));
                }
            }
        }
    }

    public void execute(ActionInvocation invocation) throws Exception {
        ActionContext actionContext = invocation.getInvocationContext();
        HttpServletRequest request = (HttpServletRequest)actionContext.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)actionContext.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        try {
            Object rootObject;
            if (this.enableSMD) {
                rootObject = this.writeSMD(invocation);
            } else if (this.root != null) {
                ValueStack stack = invocation.getStack();
                rootObject = stack.findValue(this.root);
            } else {
                rootObject = invocation.getAction();
            }
            String json = JSONUtil.serialize(rootObject, this.excludeProperties, this.includeProperties, this.ignoreHierarchy, this.enumAsBean, this.excludeNullProperties);
            json = this.addCallbackIfApplicable(request, json);
            boolean writeGzip = this.enableGZIP && JSONUtil.isGzipInRequest(request);
            this.writeToResponse(response, json, writeGzip);
        }
        catch (IOException exception) {
            log.error((Object)exception.getMessage(), (Throwable)exception);
            throw exception;
        }
    }

    protected void writeToResponse(HttpServletResponse response, String json, boolean gzip) throws IOException {
        JSONUtil.writeJSONToResponse(new SerializationParams(response, this.getEncoding(), this.isWrapWithComments(), json, false, gzip, this.noCache, this.statusCode, this.errorCode, this.prefix, this.contentType, this.wrapPrefix, this.wrapSuffix));
    }

    protected SMD writeSMD(ActionInvocation invocation) {
        Method[] methods;
        ActionContext actionContext = invocation.getInvocationContext();
        HttpServletRequest request = (HttpServletRequest)actionContext.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        Object rootObject = null;
        if (this.root != null) {
            ValueStack stack = invocation.getStack();
            rootObject = stack.findValue(this.root);
        } else {
            rootObject = invocation.getAction();
        }
        Class<?> clazz = rootObject.getClass();
        SMD smd = new SMD();
        smd.setServiceUrl(request.getRequestURI());
        com.googlecode.jsonplugin.annotations.SMD smdAnnotation = clazz.getAnnotation(com.googlecode.jsonplugin.annotations.SMD.class);
        if (smdAnnotation != null) {
            smd.setObjectName(smdAnnotation.objectName());
            smd.setServiceType(smdAnnotation.serviceType());
            smd.setVersion(smdAnnotation.version());
        }
        for (Method method : methods = JSONUtil.listSMDMethods(clazz, this.ignoreInterfaces)) {
            SMDMethod smdMethodAnnotation = method.getAnnotation(SMDMethod.class);
            if (smdMethodAnnotation != null && !this.shouldExcludeProperty(method.getName())) {
                String methodName = smdMethodAnnotation.name().length() == 0 ? method.getName() : smdMethodAnnotation.name();
                com.googlecode.jsonplugin.smd.SMDMethod smdMethod = new com.googlecode.jsonplugin.smd.SMDMethod(methodName);
                smd.addSMDMethod(smdMethod);
                int parametersCount = method.getParameterTypes().length;
                if (parametersCount <= 0) continue;
                Annotation[][] parameterAnnotations = method.getParameterAnnotations();
                for (int i = 0; i < parametersCount; ++i) {
                    com.googlecode.jsonplugin.annotations.SMDMethodParameter smdMethodParameterAnnotation = this.getSMDMethodParameterAnnotation(parameterAnnotations[i]);
                    String paramName = smdMethodParameterAnnotation != null ? smdMethodParameterAnnotation.name() : "p" + i;
                    smdMethod.addSMDMethodParameter(new SMDMethodParameter(paramName));
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Ignoring property " + method.getName()));
        }
        return smd;
    }

    private com.googlecode.jsonplugin.annotations.SMDMethodParameter getSMDMethodParameterAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof com.googlecode.jsonplugin.annotations.SMDMethodParameter)) continue;
            return (com.googlecode.jsonplugin.annotations.SMDMethodParameter)annotation;
        }
        return null;
    }

    private boolean shouldExcludeProperty(String expr) {
        if (this.excludeProperties != null) {
            for (Pattern pattern : this.excludeProperties) {
                if (!pattern.matcher(expr).matches()) continue;
                return true;
            }
        }
        return false;
    }

    protected String getEncoding() {
        String encoding = this.defaultEncoding;
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    protected String addCallbackIfApplicable(HttpServletRequest request, String json) {
        String callbackName;
        if (this.callbackParameter != null && this.callbackParameter.length() > 0 && (callbackName = request.getParameter(this.callbackParameter)) != null && callbackName.length() > 0) {
            json = callbackName + "(" + json + ")";
        }
        return json;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public boolean isWrapWithComments() {
        return this.wrapWithComments;
    }

    public void setWrapWithComments(boolean wrapWithComments) {
        this.wrapWithComments = wrapWithComments;
    }

    public boolean isEnableSMD() {
        return this.enableSMD;
    }

    public void setEnableSMD(boolean enableSMD) {
        this.enableSMD = enableSMD;
    }

    public void setIgnoreHierarchy(boolean ignoreHierarchy) {
        this.ignoreHierarchy = ignoreHierarchy;
    }

    public void setIgnoreInterfaces(boolean ignoreInterfaces) {
        this.ignoreInterfaces = ignoreInterfaces;
    }

    public void setEnumAsBean(boolean enumAsBean) {
        this.enumAsBean = enumAsBean;
    }

    public boolean isEnumAsBean() {
        return this.enumAsBean;
    }

    public boolean isEnableGZIP() {
        return this.enableGZIP;
    }

    public void setEnableGZIP(boolean enableGZIP) {
        this.enableGZIP = enableGZIP;
    }

    public boolean isNoCache() {
        return this.noCache;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    public boolean isIgnoreHierarchy() {
        return this.ignoreHierarchy;
    }

    public boolean isExcludeNullProperties() {
        return this.excludeNullProperties;
    }

    public void setExcludeNullProperties(boolean excludeNullProperties) {
        this.excludeNullProperties = excludeNullProperties;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setCallbackParameter(String callbackParameter) {
        this.callbackParameter = callbackParameter;
    }

    public String getCallbackParameter() {
        return this.callbackParameter;
    }

    public void setPrefix(boolean prefix) {
        this.prefix = prefix;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getWrapPrefix() {
        return this.wrapPrefix;
    }

    public void setWrapPrefix(String wrapPrefix) {
        this.wrapPrefix = wrapPrefix;
    }

    public String getWrapSuffix() {
        return this.wrapSuffix;
    }

    public void setWrapSuffix(String wrapSuffix) {
        this.wrapSuffix = wrapSuffix;
    }
}

