/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonplugin;

import com.googlecode.jsonplugin.JSONException;
import java.util.List;
import java.util.Map;

public abstract class JSONCleaner {
    public Object clean(String ognlPrefix, Object data) throws JSONException {
        if (data == null) {
            return null;
        }
        if (data instanceof List) {
            return this.cleanList(ognlPrefix, data);
        }
        if (data instanceof Map) {
            return this.cleanMap(ognlPrefix, data);
        }
        return this.cleanValue(ognlPrefix, data);
    }

    protected Object cleanList(String ognlPrefix, Object data) throws JSONException {
        List list = (List)data;
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            list.set(i, this.clean(ognlPrefix + "[" + i + "]", list.get(i)));
        }
        return list;
    }

    protected Object cleanMap(String ognlPrefix, Object data) throws JSONException {
        Map map = (Map)data;
        for (Map.Entry entry : map.entrySet()) {
            entry.setValue(this.clean((ognlPrefix.length() > 0 ? ognlPrefix + "." : "") + entry.getKey(), entry.getValue()));
        }
        return map;
    }

    protected abstract Object cleanValue(String var1, Object var2) throws JSONException;
}

