/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.wrap.support;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import net.sf.composite.util.CompositeUtils;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.Defaults;
import net.sf.morph.reflect.Reflector;
import net.sf.morph.util.BidirectionalMap;
import net.sf.morph.wrap.support.WrapperInvocationHandler;

public class DefaultWrapperInvocationHandler
implements WrapperInvocationHandler {
    private static final Map DEFAULT_REFLECTOR_WRAPPER_MAP = new BidirectionalMap(6);
    private Map reflectorWrapperMap;
    private Reflector reflector;
    private Object wrapped;
    static /* synthetic */ Class class$net$sf$morph$reflect$BeanReflector;
    static /* synthetic */ Class class$net$sf$morph$wrap$Bean;
    static /* synthetic */ Class class$net$sf$morph$reflect$ContainerReflector;
    static /* synthetic */ Class class$net$sf$morph$wrap$Container;
    static /* synthetic */ Class class$net$sf$morph$reflect$GrowableContainerReflector;
    static /* synthetic */ Class class$net$sf$morph$wrap$GrowableContainer;
    static /* synthetic */ Class class$net$sf$morph$reflect$IndexedContainerReflector;
    static /* synthetic */ Class class$net$sf$morph$wrap$IndexedContainer;
    static /* synthetic */ Class class$net$sf$morph$wrap$MutableIndexedContainer;
    static /* synthetic */ Class class$net$sf$morph$reflect$SizableReflector;
    static /* synthetic */ Class class$net$sf$morph$wrap$Sizable;
    static /* synthetic */ Class class$java$lang$Object;

    public DefaultWrapperInvocationHandler(Object wrapped) {
        this.wrapped = wrapped;
    }

    public DefaultWrapperInvocationHandler(Object wrapped, Reflector reflector) {
        this(wrapped);
        this.reflector = reflector;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass.equals(this.getWrapped().getClass())) {
                return method.invoke(this.getWrapped(), args);
            }
            Class<?> wrapperClass = method.getDeclaringClass();
            Class reflectorClass = (Class)this.getBiDirectionalReflectorWrapperMap().getKey(wrapperClass);
            if (reflectorClass == null) {
                throw new IllegalArgumentException("Cannot invoke method " + method + " because it is not declared in one of the recognized wrapper classes, which are: " + ObjectUtils.getObjectDescription(this.getReflectorWrapperMap().values()));
            }
            Reflector reflector = (Reflector)CompositeUtils.specialize((Object)this.getReflector(), (Class)reflectorClass);
            int wrapperNumArgs = method.getParameterTypes().length;
            int reflectorNumArgs = wrapperNumArgs + 1;
            Class[] reflectorParameterTypes = new Class[reflectorNumArgs];
            Class clazz = reflectorParameterTypes[0] = class$java$lang$Object == null ? (class$java$lang$Object = DefaultWrapperInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object;
            if (method.getParameterTypes() != null) {
                System.arraycopy(method.getParameterTypes(), 0, reflectorParameterTypes, 1, wrapperNumArgs);
            }
            Object[] reflectorArgs = new Object[reflectorNumArgs];
            reflectorArgs[0] = this.getWrapped();
            if (args != null) {
                System.arraycopy(args, 0, reflectorArgs, 1, wrapperNumArgs);
            }
            Method reflectorMethod = reflector.getClass().getMethod(method.getName(), reflectorParameterTypes);
            return reflectorMethod.invoke((Object)reflector, reflectorArgs);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public Class[] getInterfaces(Object object) {
        Class<?>[] baseInterfaces = object.getClass().getInterfaces();
        ArrayList<Object> interfaces = baseInterfaces == null ? new ArrayList() : new ArrayList(Arrays.asList(baseInterfaces));
        Map reflectorWrapperMap = this.getReflectorWrapperMap();
        Iterator reflectorClasses = reflectorWrapperMap.keySet().iterator();
        while (reflectorClasses.hasNext()) {
            Class reflectorClass = (Class)reflectorClasses.next();
            Class wrapperClass = (Class)reflectorWrapperMap.get(reflectorClass);
            if (!CompositeUtils.isSpecializable((Object)this.getReflector(), (Class)reflectorClass)) continue;
            interfaces.add(wrapperClass);
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    protected BidirectionalMap getBiDirectionalReflectorWrapperMap() {
        return (BidirectionalMap)this.getReflectorWrapperMap();
    }

    public Map getReflectorWrapperMap() {
        if (this.reflectorWrapperMap == null) {
            this.setReflectorWrapperMap(DEFAULT_REFLECTOR_WRAPPER_MAP);
        }
        return this.reflectorWrapperMap;
    }

    public void setReflectorWrapperMap(Map reflectorWrapperMap) {
        this.reflectorWrapperMap = BidirectionalMap.getInstance(reflectorWrapperMap);
    }

    public synchronized Reflector getReflector() {
        if (this.reflector == null) {
            this.setReflector(Defaults.createReflector());
        }
        return this.reflector;
    }

    public synchronized void setReflector(Reflector reflector) {
        this.reflector = reflector;
    }

    public Object getWrapped() {
        return this.wrapped;
    }

    public void setWrapped(Object wrapped) {
        this.wrapped = wrapped;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_REFLECTOR_WRAPPER_MAP.put(class$net$sf$morph$reflect$BeanReflector == null ? (class$net$sf$morph$reflect$BeanReflector = DefaultWrapperInvocationHandler.class$("net.sf.morph.reflect.BeanReflector")) : class$net$sf$morph$reflect$BeanReflector, class$net$sf$morph$wrap$Bean == null ? (class$net$sf$morph$wrap$Bean = DefaultWrapperInvocationHandler.class$("net.sf.morph.wrap.Bean")) : class$net$sf$morph$wrap$Bean);
        DEFAULT_REFLECTOR_WRAPPER_MAP.put(class$net$sf$morph$reflect$ContainerReflector == null ? (class$net$sf$morph$reflect$ContainerReflector = DefaultWrapperInvocationHandler.class$("net.sf.morph.reflect.ContainerReflector")) : class$net$sf$morph$reflect$ContainerReflector, class$net$sf$morph$wrap$Container == null ? (class$net$sf$morph$wrap$Container = DefaultWrapperInvocationHandler.class$("net.sf.morph.wrap.Container")) : class$net$sf$morph$wrap$Container);
        DEFAULT_REFLECTOR_WRAPPER_MAP.put(class$net$sf$morph$reflect$GrowableContainerReflector == null ? (class$net$sf$morph$reflect$GrowableContainerReflector = DefaultWrapperInvocationHandler.class$("net.sf.morph.reflect.GrowableContainerReflector")) : class$net$sf$morph$reflect$GrowableContainerReflector, class$net$sf$morph$wrap$GrowableContainer == null ? (class$net$sf$morph$wrap$GrowableContainer = DefaultWrapperInvocationHandler.class$("net.sf.morph.wrap.GrowableContainer")) : class$net$sf$morph$wrap$GrowableContainer);
        DEFAULT_REFLECTOR_WRAPPER_MAP.put(class$net$sf$morph$reflect$IndexedContainerReflector == null ? (class$net$sf$morph$reflect$IndexedContainerReflector = DefaultWrapperInvocationHandler.class$("net.sf.morph.reflect.IndexedContainerReflector")) : class$net$sf$morph$reflect$IndexedContainerReflector, class$net$sf$morph$wrap$IndexedContainer == null ? (class$net$sf$morph$wrap$IndexedContainer = DefaultWrapperInvocationHandler.class$("net.sf.morph.wrap.IndexedContainer")) : class$net$sf$morph$wrap$IndexedContainer);
        DEFAULT_REFLECTOR_WRAPPER_MAP.put(class$net$sf$morph$wrap$MutableIndexedContainer == null ? (class$net$sf$morph$wrap$MutableIndexedContainer = DefaultWrapperInvocationHandler.class$("net.sf.morph.wrap.MutableIndexedContainer")) : class$net$sf$morph$wrap$MutableIndexedContainer, class$net$sf$morph$wrap$MutableIndexedContainer == null ? (class$net$sf$morph$wrap$MutableIndexedContainer = DefaultWrapperInvocationHandler.class$("net.sf.morph.wrap.MutableIndexedContainer")) : class$net$sf$morph$wrap$MutableIndexedContainer);
        DEFAULT_REFLECTOR_WRAPPER_MAP.put(class$net$sf$morph$reflect$SizableReflector == null ? (class$net$sf$morph$reflect$SizableReflector = DefaultWrapperInvocationHandler.class$("net.sf.morph.reflect.SizableReflector")) : class$net$sf$morph$reflect$SizableReflector, class$net$sf$morph$wrap$Sizable == null ? (class$net$sf$morph$wrap$Sizable = DefaultWrapperInvocationHandler.class$("net.sf.morph.wrap.Sizable")) : class$net$sf$morph$wrap$Sizable);
    }
}

