/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.transform.Converter;
import net.sf.morph.transform.Copier;
import net.sf.morph.transform.ExplicitTransformer;
import net.sf.morph.transform.ImpreciseTransformer;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.transform.Transformer;
import net.sf.morph.util.ClassUtils;
import net.sf.morph.util.ContainerUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TransformerUtils {
    private static final ClassStrategy SOURCE = new ClassStrategy(){

        Class[] get(Transformer t) {
            return t.getSourceClasses();
        }
    };
    private static final ClassStrategy DEST = new ClassStrategy(){

        Class[] get(Transformer t) {
            return t.getDestinationClasses();
        }
    };
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$morph$util$TransformerUtils == null ? (class$net$sf$morph$util$TransformerUtils = TransformerUtils.class$("net.sf.morph.util.TransformerUtils")) : class$net$sf$morph$util$TransformerUtils));
    private static final Class[] CLASS_NONE = new Class[0];
    static /* synthetic */ Class class$net$sf$morph$util$TransformerUtils;

    public static boolean isImplicitlyTransformable(Transformer transformer, Class destinationClass, Class sourceClass) {
        return ClassUtils.inheritanceContains(transformer.getDestinationClasses(), destinationClass) && ClassUtils.inheritanceContains(transformer.getSourceClasses(), sourceClass);
    }

    public static boolean isTransformable(Transformer transformer, Class destinationClass, Class sourceClass) {
        if (transformer instanceof ExplicitTransformer) {
            return ((ExplicitTransformer)((Object)transformer)).isTransformable(destinationClass, sourceClass);
        }
        return TransformerUtils.isImplicitlyTransformable(transformer, destinationClass, sourceClass);
    }

    public static boolean isImpreciseTransformation(Transformer transformer, Class destinationClass, Class sourceClass) {
        if (transformer instanceof ImpreciseTransformer) {
            return ((ImpreciseTransformer)transformer).isImpreciseTransformation(destinationClass, sourceClass);
        }
        return destinationClass == null && sourceClass != null;
    }

    public static Object transform(Transformer transformer, Class destinationType, Object destination, Object source, Locale locale, Integer preferredTransformationType) throws TransformationException {
        boolean mutableDest;
        Integer xform = preferredTransformationType != null ? preferredTransformationType : (transformer instanceof Copier ? Transformer.TRANSFORMATION_TYPE_COPY : Transformer.TRANSFORMATION_TYPE_CONVERT);
        boolean bl = mutableDest = !ClassUtils.isImmutableObject(destination);
        if (Transformer.TRANSFORMATION_TYPE_COPY.equals(xform)) {
            if (transformer instanceof Converter && !mutableDest) {
                xform = Transformer.TRANSFORMATION_TYPE_CONVERT;
            }
        } else if (Transformer.TRANSFORMATION_TYPE_CONVERT.equals(xform) && !(transformer instanceof Converter) && transformer instanceof Copier && mutableDest) {
            xform = Transformer.TRANSFORMATION_TYPE_COPY;
        }
        if (Transformer.TRANSFORMATION_TYPE_CONVERT.equals(xform)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Performing nested conversion of " + ObjectUtils.getObjectDescription((Object)source) + " to destination type " + ObjectUtils.getObjectDescription((Object)destinationType)));
            }
            try {
                return ((Converter)transformer).convert(destinationType, source, locale);
            }
            catch (TransformationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TransformationException("Unable to perform transformation", e);
            }
        }
        if (Transformer.TRANSFORMATION_TYPE_COPY.equals(xform)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Performing nested copy of " + ObjectUtils.getObjectDescription((Object)source) + " to destination " + ObjectUtils.getObjectDescription((Object)destination)));
            }
            try {
                ((Copier)transformer).copy(destination, source, locale);
            }
            catch (TransformationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TransformationException("Unable to perform graph transformation", e);
            }
            return destination;
        }
        throw new TransformationException("Unable to perform transformation using transformer " + ObjectUtils.getObjectDescription((Object)transformer));
    }

    public static Class getMappedDestinationType(Map typeMapping, Class requestedType) {
        if (typeMapping == null) {
            return null;
        }
        Class mappedDestinationType = (Class)typeMapping.get(requestedType);
        if (mappedDestinationType == null) {
            Set keys = typeMapping.keySet();
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                Class type = (Class)i.next();
                if (!type.isAssignableFrom(requestedType)) continue;
                mappedDestinationType = (Class)typeMapping.get(type);
                break;
            }
        }
        return mappedDestinationType;
    }

    public static Class[] getSourceClasses(Transformer transformer, Class destinationType) {
        if (!ClassUtils.inheritanceContains(transformer.getDestinationClasses(), destinationType)) {
            return CLASS_NONE;
        }
        Class[] sourceTypes = transformer.getSourceClasses();
        if (transformer instanceof ExplicitTransformer) {
            Set result = ContainerUtils.createOrderedSet();
            for (int i = 0; i < sourceTypes.length; ++i) {
                if (!((ExplicitTransformer)((Object)transformer)).isTransformable(destinationType, sourceTypes[i])) continue;
                result.add(sourceTypes[i]);
            }
            return result.isEmpty() ? CLASS_NONE : result.toArray(new Class[result.size()]);
        }
        return sourceTypes;
    }

    public static Class[] getDestinationClasses(Transformer transformer, Class sourceType) {
        if (!ClassUtils.inheritanceContains(transformer.getSourceClasses(), sourceType)) {
            return CLASS_NONE;
        }
        Class[] destinationTypes = transformer.getDestinationClasses();
        if (transformer instanceof ExplicitTransformer) {
            Set result = ContainerUtils.createOrderedSet();
            for (int i = 0; i < destinationTypes.length; ++i) {
                if (!((ExplicitTransformer)((Object)transformer)).isTransformable(destinationTypes[i], sourceType)) continue;
                result.add(destinationTypes[i]);
            }
            return result.isEmpty() ? CLASS_NONE : result.toArray(new Class[result.size()]);
        }
        return destinationTypes;
    }

    public static Class[] getSourceClassIntersection(Transformer[] transformers) {
        return TransformerUtils.getClassIntersection(transformers, SOURCE);
    }

    public static Class[] getDestinationClassIntersection(Transformer[] transformers) {
        return TransformerUtils.getClassIntersection(transformers, DEST);
    }

    private static Class[] getClassIntersection(Transformer[] transformers, ClassStrategy strategy) {
        Set s = ContainerUtils.createOrderedSet();
        s.addAll(Arrays.asList(strategy.get(transformers[0])));
        for (int i = 1; i < transformers.length; ++i) {
            Set survivors = ContainerUtils.createOrderedSet();
            Class[] c = strategy.get(transformers[i]);
            block1: for (int j = 0; j < c.length; ++j) {
                if (s.contains(c[j])) {
                    survivors.add(c[j]);
                    break;
                }
                if (c[j] == null) break;
                Iterator it = s.iterator();
                while (it.hasNext()) {
                    Class next = (Class)it.next();
                    if (next == null || !next.isAssignableFrom(c[j])) continue;
                    survivors.add(c[j]);
                    continue block1;
                }
            }
            if (!survivors.containsAll(s)) {
                Class next;
                Iterator it = s.iterator();
                block3: while (it.hasNext() && !survivors.contains(next = (Class)it.next()) && next != null) {
                    for (int j = 0; j < c.length; ++j) {
                        if (c[j] == null || !c[j].isAssignableFrom(next)) continue;
                        survivors.add(next);
                        continue block3;
                    }
                }
            }
            s = survivors;
        }
        return s.isEmpty() ? CLASS_NONE : s.toArray(new Class[s.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static abstract class ClassStrategy {
        private ClassStrategy() {
        }

        abstract Class[] get(Transformer var1);
    }
}

