/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.Resource;

public class ResourceArrayInputStream
extends InputStream {
    private static final int EOF = -1;
    private boolean eof = false;
    private InputStream currentStream;
    private Resource[] resources;
    private int index = -1;

    public ResourceArrayInputStream(Resource[] resources) {
        this.resources = resources;
    }

    public void close() throws IOException {
        this.closeCurrent();
        this.eof = true;
    }

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        int result = this.readCurrent();
        if (result == -1) {
            this.nextResource();
            result = this.readCurrent();
        }
        return result;
    }

    private int readCurrent() throws IOException {
        return this.eof || this.currentStream == null ? -1 : this.currentStream.read();
    }

    private void nextResource() throws IOException {
        this.closeCurrent();
        if (this.resources == null || ++this.index == this.resources.length) {
            this.eof = true;
        } else {
            this.currentStream = new BufferedInputStream(this.resources[this.index].getInputStream());
        }
    }

    private void closeCurrent() {
        if (this.currentStream != null) {
            try {
                this.currentStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.currentStream = null;
        }
    }
}

