/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.util;

import net.sf.morph.reflect.CompositeReflector;
import net.sf.morph.reflect.Reflector;
import net.sf.morph.util.ClassUtils;

public abstract class ReflectorUtils {
    public static boolean isReflectable(Reflector reflector, Class reflectedType, Class reflectorType) throws IllegalArgumentException {
        if (reflector == null) {
            throw new IllegalArgumentException("The reflector must be specified");
        }
        if (reflectedType == null) {
            throw new IllegalArgumentException("The reflectedType must be specified");
        }
        if (reflectorType == null) {
            throw new IllegalArgumentException("The reflectorType must be specified");
        }
        if (reflector instanceof CompositeReflector) {
            return ((CompositeReflector)reflector).isReflectable(reflectedType, reflectorType);
        }
        return reflectorType.isInstance(reflector) && ClassUtils.inheritanceContains(reflector.getReflectableClasses(), reflectedType);
    }

    public static boolean isReflectable(Reflector reflector, Object reflectedObject, Class reflectorType) {
        return ReflectorUtils.isReflectable(reflector, ClassUtils.getClass(reflectedObject), reflectorType);
    }
}

