/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.reflect.ReflectionException;
import net.sf.morph.util.ClassUtils;
import net.sf.morph.util.ContainerUtils;

public abstract class NumberUtils {
    public static final Map MAXIMUMS_FOR_TYPES;
    public static final Map MINIMUMS_FOR_TYPES;
    public static final Comparator NARROWNESS_COMPARATOR;
    private static final Map WRAPPERS_FOR_PRIMITIVE_TYPES;
    private static final Map NUMBER_FACTORIES;
    protected static final Class[] BASE_NUMBER_TYPES;
    public static final BigDecimal MAX_LONG;
    public static final BigDecimal MAX_INTEGER;
    public static final BigDecimal MAX_SHORT;
    public static final BigDecimal MAX_BYTE;
    public static final BigDecimal MAX_DOUBLE;
    public static final BigDecimal MAX_FLOAT;
    public static final BigDecimal MIN_LONG;
    public static final BigDecimal MIN_INTEGER;
    public static final BigDecimal MIN_SHORT;
    public static final BigDecimal MIN_BYTE;
    public static final BigDecimal MIN_DOUBLE;
    public static final BigDecimal MIN_FLOAT;
    public static final BigDecimal ZERO;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Void;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Number;

    public static BigDecimal getMaximumForType(Class type) {
        return (BigDecimal)MAXIMUMS_FOR_TYPES.get(type);
    }

    public static BigDecimal getMinimumForType(Class type) {
        return (BigDecimal)MINIMUMS_FOR_TYPES.get(type);
    }

    public static BigDecimal numberToBigDecimal(Number number) {
        return number == null ? null : new BigDecimal(number.toString());
    }

    public static boolean isNumber(Class type) {
        return ClassUtils.inheritanceContains(BASE_NUMBER_TYPES, type);
    }

    public static boolean isDecimal(Number number) {
        return number != null && (number instanceof Float || number instanceof Double || number instanceof BigDecimal);
    }

    protected static boolean isOutOfBoundsForType(Map boundMap, Number number, Class type, int badCompareToResult) {
        if (number == null || type == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger) || type == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return false;
        }
        BigDecimal boundForType = (BigDecimal)boundMap.get(type);
        if (boundForType == null) {
            throw new IllegalArgumentException("Unable to determine bounds for type " + ObjectUtils.getObjectDescription((Object)type));
        }
        return NumberUtils.numberToBigDecimal(number).compareTo(boundForType) == badCompareToResult;
    }

    public static boolean isTooBigForType(Number number, Class type) {
        return NumberUtils.isOutOfBoundsForType(MAXIMUMS_FOR_TYPES, number, type, 1);
    }

    public static boolean isTooSmallForType(Number number, Class type) {
        return NumberUtils.isOutOfBoundsForType(MINIMUMS_FOR_TYPES, number, type, -1);
    }

    public static boolean isOutOfBoundsForType(Number number, Class type) {
        return number != null && (NumberUtils.isTooBigForType(number, type) || NumberUtils.isTooSmallForType(number, type));
    }

    public static Class getWrapperForPrimitiveType(Class type) {
        return (Class)WRAPPERS_FOR_PRIMITIVE_TYPES.get(type);
    }

    public static Number getNumber(Class type, String s) throws Exception {
        return ((NumberFactory)NUMBER_FACTORIES.get(type)).get(s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        NARROWNESS_COMPARATOR = new NarrownessComparator();
        MAX_LONG = new BigDecimal("9223372036854775807");
        MAX_INTEGER = new BigDecimal("2147483647");
        MAX_SHORT = new BigDecimal("32767");
        MAX_BYTE = new BigDecimal("127");
        MAX_DOUBLE = new BigDecimal("1.7976931348623157E308");
        MAX_FLOAT = new BigDecimal("3.4028235E38");
        MIN_LONG = new BigDecimal("-9223372036854775808");
        MIN_INTEGER = new BigDecimal("-2147483648");
        MIN_SHORT = new BigDecimal("-32768");
        MIN_BYTE = new BigDecimal("-128");
        MIN_DOUBLE = new BigDecimal("-1.7976931348623157E308");
        MIN_FLOAT = new BigDecimal("-3.4028235E38");
        ZERO = new BigDecimal("0");
        MAXIMUMS_FOR_TYPES = new HashMap();
        MAXIMUMS_FOR_TYPES.put(class$java$lang$Long == null ? (class$java$lang$Long = NumberUtils.class$("java.lang.Long")) : class$java$lang$Long, MAX_LONG);
        MAXIMUMS_FOR_TYPES.put(Long.TYPE, MAX_LONG);
        MAXIMUMS_FOR_TYPES.put(class$java$lang$Integer == null ? (class$java$lang$Integer = NumberUtils.class$("java.lang.Integer")) : class$java$lang$Integer, MAX_INTEGER);
        MAXIMUMS_FOR_TYPES.put(Integer.TYPE, MAX_INTEGER);
        MAXIMUMS_FOR_TYPES.put(class$java$lang$Short == null ? (class$java$lang$Short = NumberUtils.class$("java.lang.Short")) : class$java$lang$Short, MAX_SHORT);
        MAXIMUMS_FOR_TYPES.put(Short.TYPE, MAX_SHORT);
        MAXIMUMS_FOR_TYPES.put(class$java$lang$Byte == null ? (class$java$lang$Byte = NumberUtils.class$("java.lang.Byte")) : class$java$lang$Byte, MAX_BYTE);
        MAXIMUMS_FOR_TYPES.put(Byte.TYPE, MAX_BYTE);
        MAXIMUMS_FOR_TYPES.put(class$java$lang$Double == null ? (class$java$lang$Double = NumberUtils.class$("java.lang.Double")) : class$java$lang$Double, MAX_DOUBLE);
        MAXIMUMS_FOR_TYPES.put(Double.TYPE, MAX_DOUBLE);
        MAXIMUMS_FOR_TYPES.put(class$java$lang$Float == null ? (class$java$lang$Float = NumberUtils.class$("java.lang.Float")) : class$java$lang$Float, MAX_FLOAT);
        MAXIMUMS_FOR_TYPES.put(Float.TYPE, MAX_FLOAT);
        MINIMUMS_FOR_TYPES = new HashMap();
        MINIMUMS_FOR_TYPES.put(class$java$lang$Long == null ? (class$java$lang$Long = NumberUtils.class$("java.lang.Long")) : class$java$lang$Long, MIN_LONG);
        MINIMUMS_FOR_TYPES.put(Long.TYPE, MIN_LONG);
        MINIMUMS_FOR_TYPES.put(class$java$lang$Integer == null ? (class$java$lang$Integer = NumberUtils.class$("java.lang.Integer")) : class$java$lang$Integer, MIN_INTEGER);
        MINIMUMS_FOR_TYPES.put(Integer.TYPE, MIN_INTEGER);
        MINIMUMS_FOR_TYPES.put(class$java$lang$Short == null ? (class$java$lang$Short = NumberUtils.class$("java.lang.Short")) : class$java$lang$Short, MIN_SHORT);
        MINIMUMS_FOR_TYPES.put(Short.TYPE, MIN_SHORT);
        MINIMUMS_FOR_TYPES.put(class$java$lang$Byte == null ? (class$java$lang$Byte = NumberUtils.class$("java.lang.Byte")) : class$java$lang$Byte, MIN_BYTE);
        MINIMUMS_FOR_TYPES.put(Byte.TYPE, MIN_BYTE);
        MINIMUMS_FOR_TYPES.put(class$java$lang$Double == null ? (class$java$lang$Double = NumberUtils.class$("java.lang.Double")) : class$java$lang$Double, MIN_DOUBLE);
        MINIMUMS_FOR_TYPES.put(Double.TYPE, MIN_DOUBLE);
        MINIMUMS_FOR_TYPES.put(class$java$lang$Float == null ? (class$java$lang$Float = NumberUtils.class$("java.lang.Float")) : class$java$lang$Float, MIN_FLOAT);
        MINIMUMS_FOR_TYPES.put(Float.TYPE, MIN_FLOAT);
        WRAPPERS_FOR_PRIMITIVE_TYPES = new HashMap();
        WRAPPERS_FOR_PRIMITIVE_TYPES.put(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = NumberUtils.class$("java.lang.Long")) : class$java$lang$Long);
        WRAPPERS_FOR_PRIMITIVE_TYPES.put(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = NumberUtils.class$("java.lang.Integer")) : class$java$lang$Integer);
        WRAPPERS_FOR_PRIMITIVE_TYPES.put(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = NumberUtils.class$("java.lang.Short")) : class$java$lang$Short);
        WRAPPERS_FOR_PRIMITIVE_TYPES.put(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = NumberUtils.class$("java.lang.Byte")) : class$java$lang$Byte);
        WRAPPERS_FOR_PRIMITIVE_TYPES.put(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = NumberUtils.class$("java.lang.Double")) : class$java$lang$Double);
        WRAPPERS_FOR_PRIMITIVE_TYPES.put(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = NumberUtils.class$("java.lang.Float")) : class$java$lang$Float);
        WRAPPERS_FOR_PRIMITIVE_TYPES.put(Void.TYPE, class$java$lang$Void == null ? (class$java$lang$Void = NumberUtils.class$("java.lang.Void")) : class$java$lang$Void);
        NUMBER_FACTORIES = new HashMap();
        try {
            Iterator it = WRAPPERS_FOR_PRIMITIVE_TYPES.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                Class c = (Class)e.getValue();
                if (c == (class$java$lang$Void == null ? NumberUtils.class$("java.lang.Void") : class$java$lang$Void)) continue;
                MethodNumberFactory nf = new MethodNumberFactory(c);
                NUMBER_FACTORIES.put(c, nf);
                NUMBER_FACTORIES.put(e.getKey(), nf);
            }
            NUMBER_FACTORIES.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger, new ConstructorNumberFactory(class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger));
            NUMBER_FACTORIES.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new ConstructorNumberFactory(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal));
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
        Set baseNumberTypes = ContainerUtils.createOrderedSet();
        baseNumberTypes.addAll(MAXIMUMS_FOR_TYPES.keySet());
        baseNumberTypes.add(class$java$lang$Number == null ? (class$java$lang$Number = NumberUtils.class$("java.lang.Number")) : class$java$lang$Number);
        BASE_NUMBER_TYPES = baseNumberTypes.toArray(new Class[baseNumberTypes.size()]);
    }

    private static class NarrownessComparator
    implements Comparator {
        private NarrownessComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            Class c1;
            if (arg0 == arg1) {
                return 0;
            }
            Class c0 = this.getType(arg0);
            if (c0 == (c1 = this.getType(arg1)) || c0 == null || c1 == null) {
                return 0;
            }
            return NumberUtils.getMaximumForType(c0).compareTo(NumberUtils.getMaximumForType(c1));
        }

        private Class getType(Object o) {
            if (MAXIMUMS_FOR_TYPES.containsKey(o)) {
                return (Class)o;
            }
            Class test = ClassUtils.getClass(o);
            return MAXIMUMS_FOR_TYPES.containsKey(test) ? test : null;
        }
    }

    private static class ConstructorNumberFactory
    extends NumberFactory {
        private Constructor cs;

        ConstructorNumberFactory(Class c) throws Exception {
            this.cs = c.getConstructor(paramTypes);
        }

        protected Object iget(String s) throws Exception {
            return this.cs.newInstance(s);
        }
    }

    private static class MethodNumberFactory
    extends NumberFactory {
        private Method m;

        MethodNumberFactory(Class c) throws Exception {
            this.m = c.getMethod("valueOf", paramTypes);
        }

        protected Object iget(String s) throws Exception {
            return this.m.invoke(null, s);
        }
    }

    private static abstract class NumberFactory {
        static Class[] paramTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = NumberUtils.class$("java.lang.String")) : class$java$lang$String};

        private NumberFactory() {
        }

        Number get(String s) {
            try {
                return (Number)this.iget(s);
            }
            catch (Exception e) {
                throw new ReflectionException(e);
            }
        }

        protected abstract Object iget(String var1) throws Exception;
    }
}

