/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.MorphException;
import net.sf.morph.reflect.ReflectionException;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.util.ContainerUtils;

public abstract class ClassUtils
extends net.sf.composite.util.ClassUtils {
    public static final Class[] ARRAY_TYPES = new Class[]{array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = ClassUtils.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, array$J == null ? (array$J = ClassUtils.class$("[J")) : array$J, array$I == null ? (array$I = ClassUtils.class$("[I")) : array$I, array$S == null ? (array$S = ClassUtils.class$("[S")) : array$S, array$C == null ? (array$C = ClassUtils.class$("[C")) : array$C, array$B == null ? (array$B = ClassUtils.class$("[B")) : array$B, array$D == null ? (array$D = ClassUtils.class$("[D")) : array$D, array$F == null ? (array$F = ClassUtils.class$("[F")) : array$F, array$Z == null ? (array$Z = ClassUtils.class$("[Z")) : array$Z};
    private static final Set ALL_CLASSES;
    private static final Set IMMUTABLE_TYPES;
    private static final Map PRIMITIVE_TYPE_MAP;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Object;

    public static Class getArrayClass(Class componentType) {
        return ClassUtils.createArray((Class)componentType, (int)0).getClass();
    }

    public static Object newInstance(Object type) {
        try {
            return ClassUtils.convertToClass(type).newInstance();
        }
        catch (MorphException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ReflectionException("Could not create a new instance of " + ObjectUtils.getObjectDescription((Object)type), e);
        }
    }

    public static Class convertToClass(Object type) {
        if (type == null) {
            throw new IllegalArgumentException("You must specify the class to instantiate");
        }
        if (!(type instanceof String || type instanceof StringBuffer || type instanceof Class)) {
            throw new IllegalArgumentException("The type to be instantiated must be specified as a Class, String or StringBuffer object");
        }
        try {
            return type instanceof Class ? (Class<?>)type : Class.forName(type.toString());
        }
        catch (Exception e) {
            throw new TransformationException("Could not convert " + ObjectUtils.getObjectDescription((Object)type) + " to a Class object: " + e.getMessage(), e);
        }
    }

    public static boolean isServletApiPresent() {
        return ClassUtils.isClassPresent((String)"javax.servlet.http.HttpServletRequest");
    }

    public static boolean isJspApiPresent() {
        return ClassUtils.isClassPresent((String)"javax.servlet.jsp.PageContext");
    }

    public static boolean isBeanUtilsPresent() {
        return ClassUtils.isClassPresent((String)"org.apache.commons.beanutils.DynaBean");
    }

    public static boolean isVelocityPresent() {
        return ClassUtils.isClassPresent((String)"org.apache.velocity.VelocityContext");
    }

    public static boolean isCommonsCollections3Present() {
        return ClassUtils.isClassPresent((String)"org.apache.commons.collections.set.ListOrderedSet");
    }

    public static boolean inheritanceContains(Class[] typeArray, Class type) {
        if (typeArray == null) {
            return false;
        }
        for (int i = 0; i < typeArray.length; ++i) {
            if (!(type == null ? typeArray[i] == null : typeArray[i] != null && typeArray[i].isAssignableFrom(type))) continue;
            return true;
        }
        return false;
    }

    public static Class getClass(Object object) {
        return object == null ? null : object.getClass();
    }

    public static boolean isImmutable(Class destinationType) {
        return IMMUTABLE_TYPES.contains(destinationType);
    }

    public static boolean isImmutableObject(Object o) {
        return ClassUtils.isImmutable(ClassUtils.getClass(o));
    }

    public static Class[] getImmutableTypes() {
        return IMMUTABLE_TYPES.toArray(new Class[IMMUTABLE_TYPES.size()]);
    }

    public static Class getPrimitiveWrapper(Class c) {
        return (Class)PRIMITIVE_TYPE_MAP.get(c);
    }

    public static Class[] getPrimitiveTypes() {
        return PRIMITIVE_TYPE_MAP.keySet().toArray(new Class[PRIMITIVE_TYPE_MAP.size()]);
    }

    public static Class[] getWrapperTypes() {
        return PRIMITIVE_TYPE_MAP.values().toArray(new Class[PRIMITIVE_TYPE_MAP.size()]);
    }

    public static Class[] getAllClasses() {
        return ALL_CLASSES.toArray(new Class[ALL_CLASSES.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Class[] primitives = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        Class[] wrappers = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Byte == null ? (class$java$lang$Byte = ClassUtils.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Character == null ? (class$java$lang$Character = ClassUtils.class$("java.lang.Character")) : class$java$lang$Character, class$java$lang$Short == null ? (class$java$lang$Short = ClassUtils.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = ClassUtils.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = ClassUtils.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Float == null ? (class$java$lang$Float = ClassUtils.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Double == null ? (class$java$lang$Double = ClassUtils.class$("java.lang.Double")) : class$java$lang$Double};
        HashMap<Class, Class> ptm = new HashMap<Class, Class>(8);
        for (int i = 0; i < primitives.length; ++i) {
            ptm.put(primitives[i], wrappers[i]);
        }
        PRIMITIVE_TYPE_MAP = Collections.unmodifiableMap(ptm);
        Set immutable = ContainerUtils.createOrderedSet();
        immutable.addAll(Arrays.asList(primitives));
        immutable.addAll(Arrays.asList(wrappers));
        immutable.add(class$java$lang$String == null ? (class$java$lang$String = ClassUtils.class$("java.lang.String")) : class$java$lang$String);
        immutable.add(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ClassUtils.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        immutable.add(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ClassUtils.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        immutable.add(null);
        immutable.add(class$java$lang$Class == null ? (class$java$lang$Class = ClassUtils.class$("java.lang.Class")) : class$java$lang$Class);
        IMMUTABLE_TYPES = Collections.unmodifiableSet(immutable);
        Set allClasses = ContainerUtils.createOrderedSet();
        allClasses.add(class$java$lang$Object == null ? (class$java$lang$Object = ClassUtils.class$("java.lang.Object")) : class$java$lang$Object);
        allClasses.addAll(Arrays.asList(primitives));
        allClasses.add(null);
        ALL_CLASSES = Collections.unmodifiableSet(allClasses);
    }
}

