/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.util;

import java.util.HashMap;
import java.util.Map;
import net.sf.composite.util.ObjectUtils;

public class BidirectionalMap
extends HashMap {
    private final Map reverseMap;

    public static BidirectionalMap getInstance(Map m) {
        return m instanceof BidirectionalMap ? (BidirectionalMap)m : new BidirectionalMap(m);
    }

    public BidirectionalMap() {
        this.reverseMap = new HashMap();
    }

    public BidirectionalMap(int initialCapacity) {
        super(initialCapacity);
        this.reverseMap = new HashMap(initialCapacity);
    }

    public BidirectionalMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.reverseMap = new HashMap(initialCapacity, loadFactor);
    }

    public BidirectionalMap(Map m) {
        this(m.size());
        this.putAll(m);
    }

    public Object getKey(Object entry) {
        return this.reverseMap.get(entry);
    }

    public void clear() {
        super.clear();
        this.reverseMap.clear();
    }

    public Object clone() {
        HashMap clone = (HashMap)super.clone();
        return new BidirectionalMap((Map)clone);
    }

    public Object put(Object key, Object value) {
        if (this.reverseMap.containsKey(value)) {
            throw new IllegalArgumentException("The value '" + ObjectUtils.getObjectDescription((Object)value) + "' has already been added to the map");
        }
        this.reverseMap.put(value, key);
        return super.put(key, value);
    }

    public Object remove(Object key) {
        Object value = this.get(key);
        this.reverseMap.remove(value);
        return super.remove(key);
    }

    public Map getReverseMap() {
        return this.reverseMap;
    }
}

