/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.transformers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.composite.CompositeException;
import net.sf.composite.SpecializableComposite;
import net.sf.composite.specialize.Specializer;
import net.sf.composite.specialize.specializers.CachingSpecializerProxy;
import net.sf.composite.specialize.specializers.CloningSpecializer;
import net.sf.composite.util.ObjectPair;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.transform.Converter;
import net.sf.morph.transform.Copier;
import net.sf.morph.transform.DecoratedConverter;
import net.sf.morph.transform.DecoratedCopier;
import net.sf.morph.transform.ExplicitTransformer;
import net.sf.morph.transform.ImpreciseTransformer;
import net.sf.morph.transform.NodeCopier;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.transform.Transformer;
import net.sf.morph.transform.converters.DefaultToBooleanConverter;
import net.sf.morph.transform.converters.DefaultToTextConverter;
import net.sf.morph.transform.converters.IdentityConverter;
import net.sf.morph.transform.converters.NumberConverter;
import net.sf.morph.transform.converters.NumberToTimeConverter;
import net.sf.morph.transform.converters.ObjectToClassConverter;
import net.sf.morph.transform.converters.TextConverter;
import net.sf.morph.transform.converters.TextToNumberConverter;
import net.sf.morph.transform.converters.TextToTimeConverter;
import net.sf.morph.transform.converters.TimeConverter;
import net.sf.morph.transform.converters.TimeToNumberConverter;
import net.sf.morph.transform.copiers.ContainerCopier;
import net.sf.morph.transform.copiers.ImmutableComponentArrayCopier;
import net.sf.morph.transform.copiers.MapCopier;
import net.sf.morph.transform.copiers.PropertyNameMatchingCopier;
import net.sf.morph.transform.copiers.TextToContainerCopier;
import net.sf.morph.transform.transformers.BaseCompositeTransformer;
import net.sf.morph.util.ClassUtils;
import net.sf.morph.util.ContainerUtils;
import net.sf.morph.util.MutableInteger;
import net.sf.morph.util.TransformerUtils;

public class SimpleDelegatingTransformer
extends BaseCompositeTransformer
implements SpecializableComposite,
ExplicitTransformer,
Transformer,
DecoratedCopier,
DecoratedConverter,
Cloneable,
ImpreciseTransformer {
    private Specializer specializer;
    private boolean preferPreciseTransformers;
    private transient ThreadLocal visitedSourceToDestinationMapThreadLocal = new MapThreadLocal();
    private transient ThreadLocal stackDepthThreadLocal = new StackDepthThreadLocal();
    private transient Map copierRegistry = Collections.synchronizedMap(new HashMap());
    private transient Map transformerRegistry = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$net$sf$morph$transform$Copier;
    static /* synthetic */ Class class$net$sf$morph$transform$Transformer;

    protected Transformer[] createDefaultComponents() {
        return new Transformer[]{new DefaultToBooleanConverter(), new IdentityConverter(), new ObjectToClassConverter(), new TextConverter(), new DefaultToTextConverter(), new TextToNumberConverter(), new TextToTimeConverter(), new NumberToTimeConverter(), new TimeToNumberConverter(), new NumberConverter(), new TimeConverter(), new TextToContainerCopier(), new MapCopier(), new PropertyNameMatchingCopier(){
            {
                this.setDestinationClasses(new Class[]{class$java$util$Map == null ? (class$java$util$Map = SimpleDelegatingTransformer.class$("java.util.Map")) : class$java$util$Map});
            }
        }, new ImmutableComponentArrayCopier(), new ContainerCopier(), new PropertyNameMatchingCopier()};
    }

    public SimpleDelegatingTransformer() {
    }

    public SimpleDelegatingTransformer(Transformer[] components) {
        this(components, false);
    }

    public SimpleDelegatingTransformer(Transformer[] components, boolean appendDefaultComponents) {
        if (appendDefaultComponents) {
            Transformer[] defaultComponents = this.createDefaultComponents();
            if (ObjectUtils.isEmpty((Object)components)) {
                components = defaultComponents;
            } else {
                Transformer[] newComponents = (Transformer[])ClassUtils.createArray((Class)this.getComponentType(), (int)(components.length + defaultComponents.length));
                System.arraycopy(components, 0, newComponents, 0, components.length);
                System.arraycopy(defaultComponents, 0, newComponents, components.length, defaultComponents.length);
                components = newComponents;
            }
        }
        this.setComponents(components);
    }

    protected void initializeImpl() throws Exception {
        super.initializeImpl();
        if (this.getNestedTransformer() == null) {
            this.setNestedTransformer(this);
        }
    }

    protected boolean isTransformableImpl(Class destinationType, Class sourceType) throws Exception {
        for (int i = 0; i < this.getTransformers().length; ++i) {
            Transformer transformer = this.getTransformers()[i];
            if (!TransformerUtils.isTransformable(transformer, destinationType, sourceType)) continue;
            return true;
        }
        return false;
    }

    protected boolean isImpreciseTransformationImpl(Class destinationClass, Class sourceClass) {
        return TransformerUtils.isImpreciseTransformation(this.getTransformer(destinationClass, sourceClass), destinationClass, sourceClass);
    }

    protected Class[] getSourceClassesImpl() throws Exception {
        Set sourceClasses = ContainerUtils.createOrderedSet();
        Transformer[] t = this.getTransformers();
        for (int i = 0; i < t.length; ++i) {
            sourceClasses.addAll(Arrays.asList(t[i].getSourceClasses()));
        }
        return sourceClasses.toArray(new Class[sourceClasses.size()]);
    }

    protected Class[] getDestinationClassesImpl() throws Exception {
        Set destinationClasses = ContainerUtils.createOrderedSet();
        Transformer[] t = this.getTransformers();
        for (int i = 0; i < t.length; ++i) {
            destinationClasses.addAll(Arrays.asList(t[i].getDestinationClasses()));
        }
        return destinationClasses.toArray(new Class[destinationClasses.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyImpl(Object destination, Object source, Locale locale, Integer preferredTransformationType) throws Exception {
        this.incrementStackDepth();
        try {
            if (!this.hasVisitedDestination(source, destination)) {
                Class destinationType = ClassUtils.getClass(destination);
                Copier copier = this.getCopier(destinationType, ClassUtils.getClass(source));
                this.recordVisit(source, destinationType, destination);
                copier.copy(destination, source, locale);
            }
        }
        finally {
            this.decrementStackDepth();
            this.clearVisitedSourceToDestinationMapIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object convertImpl(Class destinationType, Object source, Locale locale) throws Exception {
        this.incrementStackDepth();
        try {
            Class sourceClass = ClassUtils.getClass(source);
            Transformer transformer = this.getTransformer(destinationType, sourceClass);
            if (this.hasVisited(source, destinationType)) {
                Object object = this.getCachedResult(source, destinationType);
                return object;
            }
            if (transformer instanceof NodeCopier) {
                NodeCopier nodeCopier = (NodeCopier)transformer;
                Object reuseableSource = nodeCopier.createReusableSource(destinationType, source);
                Object newInstance = nodeCopier.createNewInstance(destinationType, reuseableSource);
                this.recordVisit(source, destinationType, newInstance);
                nodeCopier.copy(newInstance, reuseableSource, locale);
                Object object = newInstance;
                return object;
            }
            Converter converter = (Converter)transformer;
            Object object = converter.convert(destinationType, source, locale);
            return object;
        }
        finally {
            this.decrementStackDepth();
            this.clearVisitedSourceToDestinationMapIfNecessary();
        }
    }

    protected void incrementStackDepth() {
        ++((MutableInteger)this.stackDepthThreadLocal.get()).value;
    }

    protected void decrementStackDepth() {
        --((MutableInteger)this.stackDepthThreadLocal.get()).value;
    }

    protected void clearVisitedSourceToDestinationMapIfNecessary() {
        if (((MutableInteger)this.stackDepthThreadLocal.get()).value == 0) {
            this.getVisitedSourceToDestinationMap().clear();
        }
    }

    protected void recordVisit(Object source, Class destinationType, Object destination) {
        ObjectPair key = new ObjectPair(source, (Object)destinationType);
        this.getVisitedSourceToDestinationMap().put(key, destination);
    }

    protected boolean hasVisited(Object source, Class destinationType) {
        ObjectPair key = new ObjectPair(source, (Object)destinationType);
        return this.getVisitedSourceToDestinationMap().containsKey(key);
    }

    protected boolean hasVisitedDestination(Object source, Object destination) {
        Class destinationType = ClassUtils.getClass(destination);
        return this.hasVisited(source, destinationType) && this.getCachedResult(source, destinationType) == destination;
    }

    protected Object getCachedResult(Object source, Class destinationType) {
        ObjectPair key = new ObjectPair(source, (Object)destinationType);
        if (!this.getVisitedSourceToDestinationMap().containsKey(key)) {
            throw new IllegalArgumentException("Cannot return a cached conversion result for " + ObjectUtils.getObjectDescription((Object)source) + " to destination type '" + destinationType + "' because that conversion hasn't been performed before");
        }
        return this.getVisitedSourceToDestinationMap().get(key);
    }

    public Object specialize(Class compositeType) {
        return this.getSpecializer().specialize((Object)this, compositeType);
    }

    public boolean isSpecializable(Class type) throws CompositeException {
        return this.getSpecializer().isSpecializable((Object)this, type);
    }

    protected Transformer getTransformer(Map registry, Class transformerType, Class destinationClass, Class sourceClass) {
        ObjectPair key = new ObjectPair((Object)destinationClass, (Object)sourceClass);
        Transformer transformer = (Transformer)registry.get(key);
        if (transformer == null) {
            transformer = this.getTransformer(transformerType, destinationClass, sourceClass);
            registry.put(key, transformer);
        }
        return transformer;
    }

    protected Copier getCopier(Class destinationClass, Class sourceClass) {
        return (Copier)this.getTransformer(this.copierRegistry, class$net$sf$morph$transform$Copier == null ? (class$net$sf$morph$transform$Copier = SimpleDelegatingTransformer.class$("net.sf.morph.transform.Copier")) : class$net$sf$morph$transform$Copier, destinationClass, sourceClass);
    }

    protected Transformer getTransformer(Class destinationClass, Class sourceClass) {
        return this.getTransformer(this.transformerRegistry, class$net$sf$morph$transform$Transformer == null ? (class$net$sf$morph$transform$Transformer = SimpleDelegatingTransformer.class$("net.sf.morph.transform.Transformer")) : class$net$sf$morph$transform$Transformer, destinationClass, sourceClass);
    }

    private Transformer getTransformer(Class transformerType, Class destinationClass, Class sourceClass) throws TransformationException {
        Transformer candidate = null;
        for (int i = 0; i < this.components.length; ++i) {
            Transformer transformer = (Transformer)this.components[i];
            if (transformerType.isAssignableFrom(transformer.getClass()) && TransformerUtils.isTransformable(transformer, destinationClass, sourceClass)) {
                if (this.isPreferPreciseTransformers() && candidate == null && TransformerUtils.isImpreciseTransformation(transformer, destinationClass, sourceClass)) {
                    candidate = transformer;
                    continue;
                }
                if (this.getLog().isTraceEnabled()) {
                    this.getLog().trace((Object)("Using " + ClassUtils.getUnqualifiedClassName((Class)transformerType) + " " + transformer.getClass().getName() + " to transform " + ObjectUtils.getObjectDescription((Object)sourceClass) + " to " + ObjectUtils.getObjectDescription((Object)destinationClass)));
                }
                return transformer;
            }
            if (candidate == null) continue;
            return candidate;
        }
        throw new TransformationException("Could not find a transformer that can transform objects of " + ObjectUtils.getObjectDescription((Object)sourceClass) + " to objects of " + ObjectUtils.getObjectDescription((Object)destinationClass));
    }

    public synchronized Transformer[] getTransformers() {
        return (Transformer[])this.getComponents();
    }

    public synchronized Object[] getComponents() {
        if (this.components == null) {
            this.setComponents(this.createDefaultComponents());
        }
        return super.getComponents();
    }

    public synchronized void setComponents(Object[] components) {
        if (this.components == components) {
            return;
        }
        this.components = components;
        this.transformerRegistry.clear();
        this.copierRegistry.clear();
        if (components != null) {
            this.updateNestedTransformerComponents(this.getNestedTransformer(), null);
        }
    }

    protected boolean isPerformingLogging() {
        return false;
    }

    protected boolean isAutomaticallyHandlingNulls() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleDelegatingTransformer result = (SimpleDelegatingTransformer)super.clone();
        result.copierRegistry = Collections.synchronizedMap(new HashMap());
        result.transformerRegistry = Collections.synchronizedMap(new HashMap());
        result.visitedSourceToDestinationMapThreadLocal = new MapThreadLocal();
        result.stackDepthThreadLocal = new StackDepthThreadLocal();
        return result;
    }

    protected Map getVisitedSourceToDestinationMap() {
        return (Map)this.visitedSourceToDestinationMapThreadLocal.get();
    }

    public Specializer getSpecializer() {
        if (this.specializer == null) {
            this.specializer = new CachingSpecializerProxy((Specializer)new CloningSpecializer());
        }
        return this.specializer;
    }

    public void setSpecializer(Specializer specializer) {
        this.specializer = specializer;
    }

    protected Object createReusableSource(Class destinationClass, Object source) {
        Transformer t = this.getTransformer(destinationClass, ClassUtils.getClass(source));
        return t instanceof NodeCopier ? ((NodeCopier)t).createReusableSource(destinationClass, source) : super.createReusableSource(destinationClass, source);
    }

    public boolean isPreferPreciseTransformers() {
        return this.preferPreciseTransformers;
    }

    public void setPreferPreciseTransformers(boolean preferPreciseTransformers) {
        this.preferPreciseTransformers = preferPreciseTransformers;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class StackDepthThreadLocal
    extends ThreadLocal {
        private StackDepthThreadLocal() {
        }

        protected Object initialValue() {
            return new MutableInteger();
        }
    }

    private static class MapThreadLocal
    extends ThreadLocal {
        private MapThreadLocal() {
        }

        protected Object initialValue() {
            return new HashMap();
        }
    }
}

