/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.transformers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.transform.Converter;
import net.sf.morph.transform.Copier;
import net.sf.morph.transform.DecoratedConverter;
import net.sf.morph.transform.DecoratedCopier;
import net.sf.morph.transform.ExplicitTransformer;
import net.sf.morph.transform.ImpreciseTransformer;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.transform.Transformer;
import net.sf.morph.transform.copiers.CopierDecorator;
import net.sf.morph.transform.transformers.BaseCompositeTransformer;
import net.sf.morph.util.Assert;
import net.sf.morph.util.ClassUtils;
import net.sf.morph.util.TransformerUtils;

public class ChainedTransformer
extends BaseCompositeTransformer
implements DecoratedConverter,
DecoratedCopier,
ExplicitTransformer,
ImpreciseTransformer {
    private Converter copyConverter;

    public ChainedTransformer() {
    }

    public ChainedTransformer(Transformer[] chain) {
        this.setComponents(chain);
    }

    protected boolean isTransformableImpl(Class destinationType, Class sourceType) throws Exception {
        return this.getConversionPath(destinationType, sourceType) != null;
    }

    protected boolean isImpreciseTransformationImpl(Class destinationClass, Class sourceClass) {
        List conversionPath = this.getConversionPath(destinationClass, sourceClass);
        return !this.isPrecise(conversionPath, sourceClass, 0);
    }

    protected synchronized Converter getCopyConverter() {
        if (this.copyConverter == null) {
            Transformer[] chain = this.getChain();
            Assert.notNull((Object)chain, (String)"components");
            if (chain.length == 2) {
                this.copyConverter = this.getConverter(chain[0]);
            } else {
                Transformer[] newChain = new Transformer[chain.length - 1];
                System.arraycopy(chain, 0, newChain, 0, newChain.length);
                this.copyConverter = new ChainedTransformer(newChain);
            }
        }
        return this.copyConverter;
    }

    private Converter getConverter(Transformer t) {
        if (t instanceof Converter) {
            return (Converter)t;
        }
        if (t instanceof Copier) {
            return new CopierDecorator((Copier)t);
        }
        throw new IllegalArgumentException("Don't know how to use " + t + " as a Converter");
    }

    protected Object convertImpl(Class destinationClass, Object source, Locale locale) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Using chain to convert " + ObjectUtils.getObjectDescription((Object)source) + " to " + ObjectUtils.getObjectDescription((Object)destinationClass)));
        }
        Transformer[] chain = this.getChain();
        Class sourceType = ClassUtils.getClass(source);
        List conversionPath = this.getConversionPath(destinationClass, sourceType);
        if (conversionPath == null) {
            throw new TransformationException(destinationClass, sourceType, null, "Chained conversion path could not be determined");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using chained conversion path " + conversionPath));
        }
        Object o = source;
        for (int i = 0; i < conversionPath.size(); ++i) {
            o = this.getConverter(chain[i]).convert((Class)conversionPath.get(i), o, locale);
            this.logConversion(i + 1, source, o);
        }
        return o;
    }

    protected void copyImpl(Object destination, Object source, Locale locale, Integer preferredTransformationType) throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Using chain to copy " + ObjectUtils.getObjectDescription((Object)source) + " to " + ObjectUtils.getObjectDescription((Object)destination)));
        }
        Class destinationClass = ClassUtils.getClass(destination);
        Transformer[] chain = this.getChain();
        Transformer copier = chain[chain.length - 1];
        if (!(copier instanceof Copier)) {
            throw new TransformationException(destinationClass, source, null, "Last chain component must be a Copier");
        }
        Class sourceType = ClassUtils.getClass(source);
        List conversionPath = this.getConversionPath(destinationClass, sourceType);
        if (conversionPath == null) {
            throw new TransformationException(destinationClass, source, null, "Chained conversion path could not be determined");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using chained conversion path " + conversionPath));
        }
        Object last = this.getCopyConverter().convert((Class)conversionPath.get(chain.length - 2), source, locale);
        ((Copier)copier).copy(destination, last, locale);
    }

    protected void logConversion(int conversionNumber, Object source, Object destination) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Conversion " + conversionNumber + " of " + this.getComponents().length + " was from " + ObjectUtils.getObjectDescription((Object)source) + " to " + ObjectUtils.getObjectDescription((Object)destination) + " and was performed by " + ObjectUtils.getObjectDescription((Object)this.getComponents()[conversionNumber - 1])));
        }
    }

    protected Class[] getDestinationClassesImpl() throws Exception {
        return this.getChain()[this.getChain().length - 1].getDestinationClasses();
    }

    protected Class[] getSourceClassesImpl() throws Exception {
        return this.getChain()[0].getSourceClasses();
    }

    protected List getConversionPath(Class destinationType, Class sourceType) {
        return this.getConversionPath(destinationType, sourceType, 0);
    }

    private List getConversionPath(Class destinationType, Class sourceType, int index) {
        Transformer[] chain = this.getChain();
        Transformer c = chain[index];
        if (index + 1 == chain.length) {
            if (TransformerUtils.isTransformable(c, destinationType, sourceType)) {
                ArrayList<Class> result = new ArrayList<Class>();
                result.add(destinationType);
                return result;
            }
            return null;
        }
        List possibleResult = null;
        Class[] available = c.getDestinationClasses();
        for (int i = 0; i < available.length; ++i) {
            List tail;
            if (!TransformerUtils.isTransformable(c, available[i], sourceType) || (tail = this.getConversionPath(destinationType, available[i], index + 1)) == null) continue;
            tail.add(0, available[i]);
            if (this.isPrecise(tail, sourceType, index)) {
                return tail;
            }
            possibleResult = tail;
        }
        return possibleResult;
    }

    private boolean isPrecise(List conversionPath, Class sourceType, int index) {
        Transformer[] chain = this.getChain();
        Class currentSource = sourceType;
        int i = 0;
        Iterator iter = conversionPath.iterator();
        while (iter.hasNext()) {
            Class currentDest = (Class)iter.next();
            if (TransformerUtils.isImpreciseTransformation(chain[index + i], currentDest, currentSource)) {
                return false;
            }
            currentSource = currentDest;
            ++i;
        }
        return true;
    }

    protected synchronized Transformer[] getChain() {
        return (Transformer[])this.getComponents();
    }
}

