/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.transformers;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.composite.util.CompositeUtils;
import net.sf.composite.util.ObjectPair;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.Defaults;
import net.sf.morph.reflect.InstantiatingReflector;
import net.sf.morph.reflect.ReflectionException;
import net.sf.morph.reflect.Reflector;
import net.sf.morph.transform.Converter;
import net.sf.morph.transform.Copier;
import net.sf.morph.transform.DecoratedTransformer;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.transform.Transformer;
import net.sf.morph.util.ClassUtils;
import net.sf.morph.util.TransformerUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseTransformer
implements Transformer,
DecoratedTransformer {
    private static final String SPRING_LOCALE_CONTEXT_HOLDER_CLASS = "org.springframework.context.i18n.LocaleContextHolder";
    private boolean initialized = false;
    private boolean cachingIsTransformableCalls = true;
    private Transformer nestedTransformer;
    private Reflector reflector;
    private String transformerName;
    private transient Map transformableCallCache;
    protected transient Log log;
    protected Class[] sourceClasses;
    protected Class[] destinationClasses;
    static /* synthetic */ Class class$net$sf$morph$transform$ExplicitTransformer;
    static /* synthetic */ Class class$net$sf$morph$reflect$InstantiatingReflector;

    protected BaseTransformer() {
        this.setTransformerName(null);
    }

    protected boolean isTransformableImpl(Class destinationType, Class sourceType) throws Exception {
        return TransformerUtils.isImplicitlyTransformable(this, destinationType, sourceType);
    }

    public final boolean isTransformable(Class destinationType, Class sourceType) throws TransformationException {
        this.initialize();
        ObjectPair pair = null;
        if (this.isCachingIsTransformableCalls()) {
            pair = new ObjectPair((Object)destinationType, (Object)sourceType);
            if (this.getTransformableCallCache().containsKey(pair)) {
                Boolean isTransformable = (Boolean)this.getTransformableCallCache().get(pair);
                return isTransformable;
            }
        }
        try {
            boolean isTransformable = this.isTransformableImpl(destinationType, sourceType);
            if (this.isCachingIsTransformableCalls()) {
                this.getTransformableCallCache().put(pair, new Boolean(isTransformable));
            }
            return isTransformable;
        }
        catch (TransformationException e) {
            throw e;
        }
        catch (StackOverflowError e) {
            throw new TransformationException("Stack overflow detected.  This usually occurs when a transformer implements " + ObjectUtils.getObjectDescription((Object)(class$net$sf$morph$transform$ExplicitTransformer == null ? (class$net$sf$morph$transform$ExplicitTransformer = BaseTransformer.class$("net.sf.morph.transform.ExplicitTransformer")) : class$net$sf$morph$transform$ExplicitTransformer)) + " but does not override the isTransformableImpl method", e);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new TransformationException("Could not determine if " + sourceType + " is convertible to " + destinationType, e);
        }
    }

    protected abstract Class[] getSourceClassesImpl() throws Exception;

    protected abstract Class[] getDestinationClassesImpl() throws Exception;

    public final Class[] getSourceClasses() throws TransformationException {
        this.initialize();
        return this.sourceClasses;
    }

    public final Class[] getDestinationClasses() throws TransformationException {
        this.initialize();
        return this.destinationClasses;
    }

    protected synchronized void setSourceClasses(Class[] sourceClasses) {
        this.setInitialized(false);
        this.sourceClasses = sourceClasses;
    }

    protected synchronized void setDestinationClasses(Class[] destinationClasses) {
        this.setInitialized(false);
        this.destinationClasses = destinationClasses;
    }

    protected void initializeImpl() throws Exception {
    }

    protected final synchronized void initialize() throws TransformationException {
        if (!this.initialized) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Initializing transformer " + ObjectUtils.getObjectDescription((Object)this)));
            }
            try {
                this.initializeImpl();
                if (this.sourceClasses == null) {
                    this.sourceClasses = this.getSourceClassesImpl();
                }
                if (this.destinationClasses == null) {
                    this.destinationClasses = this.getDestinationClassesImpl();
                }
                if (ObjectUtils.isEmpty((Object)this.sourceClasses)) {
                    throw new TransformationException("This transformer, " + ObjectUtils.getObjectDescription((Object)this) + ", is invalid because it does specify any sourceClasses");
                }
                if (ObjectUtils.isEmpty((Object)this.destinationClasses)) {
                    throw new TransformationException("This transformer, " + ObjectUtils.getObjectDescription((Object)this) + ", is invalid because it does specify any destinationClasses");
                }
                this.transformableCallCache = Collections.synchronizedMap(new HashMap());
                if (this.nestedTransformer == null) {
                    this.nestedTransformer = Defaults.createTransformer();
                }
                this.initialized = true;
            }
            catch (TransformationException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                    throw (RuntimeException)e;
                }
                throw new TransformationException("Could not initialize transformer " + ObjectUtils.getObjectDescription((Object)this), e);
            }
        }
    }

    protected Locale getLocale() {
        Locale locale = null;
        if (ClassUtils.isClassPresent((String)SPRING_LOCALE_CONTEXT_HOLDER_CLASS)) {
            try {
                Class<?> contextHolderClass = Class.forName(SPRING_LOCALE_CONTEXT_HOLDER_CLASS);
                Method getLocaleMethod = contextHolderClass.getMethod("getLocale", null);
                locale = (Locale)getLocaleMethod.invoke(null, (Object[])null);
            }
            catch (Exception e) {
                this.log.warn((Object)"Unable to retrieve locale from Spring", (Throwable)e);
            }
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public final Object convert(Class destinationClass, Object source) throws TransformationException {
        return this.convert(destinationClass, source, null);
    }

    public final Object convert(Class destinationClass, Object source, Locale locale) {
        this.initialize();
        if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
            this.log.trace((Object)("Converting " + ObjectUtils.getObjectDescription((Object)source) + " to destination type " + ObjectUtils.getObjectDescription((Object)destinationClass) + " in locale " + locale));
        }
        if (locale == null) {
            locale = this.getLocale();
        }
        if (source == null && this.isAutomaticallyHandlingNulls()) {
            if (destinationClass != null && destinationClass.isPrimitive()) {
                throw new TransformationException(destinationClass, source);
            }
            return null;
        }
        try {
            return this.convertImpl(destinationClass, source, locale);
        }
        catch (TransformationException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            if (this.isTransformable(destinationClass, ClassUtils.getClass(source))) {
                throw new TransformationException(destinationClass, source, (Throwable)e);
            }
            throw new TransformationException(this.getClass().getName() + " cannot convert " + ObjectUtils.getObjectDescription((Object)source) + " to an instance of " + ObjectUtils.getObjectDescription((Object)destinationClass), e);
        }
    }

    protected Object convertImpl(Class destinationClass, Object source, Locale locale) throws Exception {
        Object reuseableSource = this.createReusableSource(destinationClass, source);
        Object newInstance = this.createNewInstance(destinationClass, reuseableSource);
        this.copyImpl(newInstance, reuseableSource, locale, Converter.TRANSFORMATION_TYPE_CONVERT);
        return newInstance;
    }

    protected Object createReusableSource(Class destinationClass, Object source) {
        return source;
    }

    public boolean equals(Object object1, Object object2, Locale locale) {
        if (locale == null) {
            locale = this.getLocale();
        }
        return object1 == object2 || object1 != null && this.equalsUnidirectionalTest(object1, object2, locale) || object2 != null && this.equalsUnidirectionalTest(object2, object1, locale);
    }

    public final boolean equals(Object object1, Object object2) throws TransformationException {
        return this.equals(object1, object2, null);
    }

    protected boolean equalsUnidirectionalTest(Object cannotBeNull, Object canBeNull, Locale locale) {
        return cannotBeNull.equals(this.convert(cannotBeNull.getClass(), canBeNull, locale));
    }

    public final void copy(Object destination, Object source) throws TransformationException {
        this.copy(destination, source, null);
    }

    public final void copy(Object destination, Object source, Locale locale) throws TransformationException {
        this.initialize();
        if (this.isPerformingLogging() && this.log.isTraceEnabled()) {
            this.log.trace((Object)("Copying information from " + ObjectUtils.getObjectDescription((Object)source) + " to destination " + ObjectUtils.getObjectDescription((Object)destination) + " in locale " + locale));
        }
        if (destination == null) {
            throw new TransformationException("Destination cannot be null");
        }
        if (source == null && this.isAutomaticallyHandlingNulls()) {
            return;
        }
        if (locale == null) {
            locale = this.getLocale();
        }
        try {
            this.copyImpl(destination, source, locale, Copier.TRANSFORMATION_TYPE_COPY);
        }
        catch (TransformationException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            if (this.isTransformable(destination.getClass(), source.getClass())) {
                throw new TransformationException("Error copying source " + ObjectUtils.getObjectDescription((Object)source) + " to destination " + ObjectUtils.getObjectDescription((Object)destination), e);
            }
            throw new TransformationException("The " + this.getClass().getName() + " cannot copy source '" + source + "' (class " + source.getClass().getName() + ") to destination '" + destination + "' (class " + destination.getClass().getName() + ")");
        }
    }

    protected void copyImpl(Object destination, Object source, Locale locale, Integer preferredTransformationType) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected Object createNewInstanceImpl(Class destinationClass, Object source) throws Exception {
        block3: {
            if (CompositeUtils.isSpecializable((Object)this.getReflector(), (Class)(class$net$sf$morph$reflect$InstantiatingReflector == null ? (class$net$sf$morph$reflect$InstantiatingReflector = BaseTransformer.class$("net.sf.morph.reflect.InstantiatingReflector")) : class$net$sf$morph$reflect$InstantiatingReflector))) {
                try {
                    return this.getInstantiatingReflector().newInstance(destinationClass, source);
                }
                catch (Exception e) {
                    if (!this.getLog().isWarnEnabled()) break block3;
                    this.getLog().warn((Object)(ObjectUtils.getObjectDescription((Object)this.getReflector()) + " is exposable as an InstantiatingReflector, but failed to instantiate " + ObjectUtils.getObjectDescription((Object)destinationClass)), (Throwable)e);
                }
            }
        }
        return destinationClass.newInstance();
    }

    public Object createNewInstance(Class destinationClass, Object source) {
        try {
            return this.createNewInstanceImpl(destinationClass, source);
        }
        catch (ReflectionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new ReflectionException("Unable to instantiate " + ObjectUtils.getObjectDescription((Object)destinationClass), e);
        }
    }

    protected boolean isImpreciseTransformationImpl(Class destinationClass, Class sourceClass) {
        return destinationClass == null && sourceClass != null;
    }

    public final boolean isImpreciseTransformation(Class destinationClass, Class sourceClass) {
        try {
            return this.isImpreciseTransformationImpl(destinationClass, sourceClass);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException && !this.isWrappingRuntimeExceptions()) {
                throw (RuntimeException)e;
            }
            throw new TransformationException("Could not determine if transformation of " + sourceClass + " to " + destinationClass + " results in a loss of precision", e);
        }
    }

    protected boolean isPerformingLogging() {
        return true;
    }

    protected boolean isAutomaticallyHandlingNulls() {
        return true;
    }

    protected boolean isWrappingRuntimeExceptions() {
        return true;
    }

    protected Transformer getNestedTransformer() {
        return this.nestedTransformer;
    }

    protected void setNestedTransformer(Transformer nestedTransformer) {
        this.nestedTransformer = nestedTransformer;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isCachingIsTransformableCalls() {
        return this.cachingIsTransformableCalls;
    }

    public void setCachingIsTransformableCalls(boolean cachingIsTransformableCalls) {
        this.cachingIsTransformableCalls = cachingIsTransformableCalls;
    }

    protected Map getTransformableCallCache() {
        return this.transformableCallCache;
    }

    protected void setTransformableCallCache(Map transformableCallCache) {
        this.transformableCallCache = transformableCallCache;
    }

    protected Log getLog() {
        return this.log;
    }

    protected void setLog(Log log) {
        this.log = log;
    }

    protected InstantiatingReflector getInstantiatingReflector() {
        return (InstantiatingReflector)this.getReflector(class$net$sf$morph$reflect$InstantiatingReflector == null ? (class$net$sf$morph$reflect$InstantiatingReflector = BaseTransformer.class$("net.sf.morph.reflect.InstantiatingReflector")) : class$net$sf$morph$reflect$InstantiatingReflector);
    }

    protected Reflector getReflector(Class reflectorType) {
        return (Reflector)CompositeUtils.specialize((Object)this.getReflector(), (Class)reflectorType);
    }

    public synchronized Reflector getReflector() {
        if (this.reflector == null) {
            this.setReflector(this.createDefaultReflector());
        }
        return this.reflector;
    }

    public synchronized void setReflector(Reflector reflector) {
        this.reflector = reflector;
    }

    protected Reflector createDefaultReflector() {
        return Defaults.createReflector();
    }

    protected Object clone() throws CloneNotSupportedException {
        BaseTransformer result = (BaseTransformer)super.clone();
        result.transformableCallCache = Collections.synchronizedMap(new HashMap());
        return result;
    }

    public String getTransformerName() {
        return this.transformerName;
    }

    public void setTransformerName(String transformerName) {
        if (this.initialized && ObjectUtils.equals((Object)transformerName, (Object)this.transformerName)) {
            return;
        }
        this.transformerName = transformerName;
        this.log = transformerName == null ? LogFactory.getLog(this.getClass()) : LogFactory.getLog((String)transformerName);
    }

    public String toString() {
        String name = this.getTransformerName();
        return name == null ? super.toString() : name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

