/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ResetableIteratorWrapper
implements Iterator {
    private static final String NULL_ITERATOR = "The supplied iterator was null";
    private static final String NEVER_SET = "You must set the iterator to wrap before calling this method";
    private static final String ALREADY_SET = "You can only set the delegate iterator once";
    private static final String NO_MORE = "There are no more elements to iterate over";
    private boolean frozen = false;
    private int index = 0;
    private List list;

    public ResetableIteratorWrapper() {
    }

    public ResetableIteratorWrapper(Iterator iterator) {
        this();
        this.setIterator(iterator);
    }

    public synchronized boolean hasNext() {
        if (!this.frozen) {
            throw new IllegalStateException(NEVER_SET);
        }
        return this.list != null && this.index < this.list.size();
    }

    public synchronized Object next() {
        if (this.hasNext()) {
            return this.list.get(this.index++);
        }
        throw new NoSuchElementException(NO_MORE);
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public synchronized void reset() {
        this.index = 0;
    }

    public synchronized Iterator getIterator() {
        return this.list == null ? null : this.list.iterator();
    }

    public synchronized void setIterator(Iterator iterator) {
        if (this.frozen) {
            throw new IllegalStateException(ALREADY_SET);
        }
        if (iterator == null) {
            throw new IllegalArgumentException(NULL_ITERATOR);
        }
        this.frozen = true;
        this.list = new ArrayList();
        while (iterator.hasNext()) {
            this.list.add(iterator.next());
        }
    }

    public int size() {
        if (!this.frozen) {
            throw new IllegalStateException(NEVER_SET);
        }
        return this.list.size();
    }

    public String toString() {
        return "ResetableIteratorWrapper" + this.list;
    }
}

