/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.support;

import java.math.BigDecimal;
import net.sf.morph.util.NumberUtils;

public abstract class NumberRounder {
    public static final String ROUND_CEILING = "ROUND_CEILING";
    public static final String ROUND_DOWN = "ROUND_DOWN";
    public static final String ROUND_FLOOR = "ROUND_FLOOR";
    public static final String ROUND_HALF_DOWN = "ROUND_HALF_DOWN";
    public static final String ROUND_HALF_EVEN = "ROUND_HALF_EVEN";
    public static final String ROUND_HALF_UP = "ROUND_HALF_UP";
    public static final String ROUND_UP = "ROUND_UP";
    static /* synthetic */ Class class$net$sf$morph$transform$support$NumberRounder;

    public static int getBigDecimalRoundMode(String mode) throws IllegalArgumentException {
        if (ROUND_CEILING.equals(mode)) {
            return 2;
        }
        if (ROUND_DOWN.equals(mode)) {
            return 1;
        }
        if (ROUND_FLOOR.equals(mode)) {
            return 3;
        }
        if (ROUND_HALF_DOWN.equals(mode)) {
            return 5;
        }
        if (ROUND_HALF_EVEN.equals(mode)) {
            return 6;
        }
        if (ROUND_HALF_UP.equals(mode)) {
            return 4;
        }
        if (ROUND_UP.equals(mode)) {
            return 0;
        }
        throw new IllegalArgumentException("'" + mode + "' is not a valid rounding mode.  Please specify one of the constants defined in " + (class$net$sf$morph$transform$support$NumberRounder == null ? (class$net$sf$morph$transform$support$NumberRounder = NumberRounder.class$("net.sf.morph.transform.support.NumberRounder")) : class$net$sf$morph$transform$support$NumberRounder).getName());
    }

    public static Number round(Number number, String mode) throws IllegalArgumentException {
        if (NumberUtils.isDecimal(number)) {
            BigDecimal bigDecimal = NumberUtils.numberToBigDecimal(number);
            BigDecimal rounded = bigDecimal.setScale(0, NumberRounder.getBigDecimalRoundMode(mode));
            if (number instanceof BigDecimal) {
                return rounded;
            }
            if (number instanceof Double) {
                return new Double(rounded.doubleValue());
            }
            if (number instanceof Float) {
                return new Float(rounded.floatValue());
            }
        }
        return number;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

