/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.copiers;

import java.util.Enumeration;
import java.util.Locale;
import net.sf.morph.Defaults;
import net.sf.morph.transform.Converter;
import net.sf.morph.transform.Copier;
import net.sf.morph.transform.DecoratedConverter;
import net.sf.morph.transform.DecoratedCopier;
import net.sf.morph.transform.transformers.BaseTransformer;
import net.sf.morph.util.MorphStringTokenizer;

public class TextToContainerCopier
extends BaseTransformer
implements DecoratedConverter,
DecoratedCopier {
    public static final String DEFAULT_DELIMITERS = " ,|";
    public static final String DEFAULT_IGNORED_CHARACTERS = "()[]{}";
    private String delimiters = " ,|";
    private String ignoredCharacters = "()[]{}";
    private Converter textConverter = Defaults.createTextConverter();
    private Copier containerCopier = Defaults.createContainerCopier();
    static /* synthetic */ Class class$java$lang$String;

    protected Object convertImpl(Class destinationClass, Object source, Locale locale) throws Exception {
        Enumeration tokenizer = this.getTokenizer(source, locale);
        Object destination = this.createNewInstance(destinationClass, tokenizer);
        this.getContainerCopier().copy(destination, tokenizer, locale);
        return destination;
    }

    protected void copyImpl(Object destination, Object source, Locale locale, Integer preferredTransformationType) throws Exception {
        Enumeration tokenizer = this.getTokenizer(source, locale);
        this.getContainerCopier().copy(destination, tokenizer, locale);
    }

    protected Enumeration getTokenizer(Object source, Locale locale) {
        String sourceStr = (String)this.getTextConverter().convert(class$java$lang$String == null ? (class$java$lang$String = TextToContainerCopier.class$("java.lang.String")) : class$java$lang$String, source, locale);
        sourceStr = this.removeIgnoredCharacters(sourceStr, this.getIgnoredCharacters());
        return new MorphStringTokenizer(sourceStr, this.getDelimiters());
    }

    protected String removeIgnoredCharacters(String source, String ignoredCharacters) {
        if (source == null) {
            return null;
        }
        if (ignoredCharacters == null || "".equals(ignoredCharacters)) {
            return source;
        }
        StringBuffer buffer = new StringBuffer(source.length());
        for (int i = 0; i < source.length(); ++i) {
            for (int j = 0; j < ignoredCharacters.length() && source.charAt(i) != ignoredCharacters.charAt(j); ++j) {
                if (j != ignoredCharacters.length() - 1) continue;
                buffer.append(source.charAt(i));
            }
        }
        return buffer.toString();
    }

    protected Class[] getDestinationClassesImpl() throws Exception {
        return this.getContainerCopier().getDestinationClasses();
    }

    protected Class[] getSourceClassesImpl() throws Exception {
        return this.getTextConverter().getSourceClasses();
    }

    protected boolean isWrappingRuntimeExceptions() {
        return false;
    }

    public String getDelimiters() {
        return this.delimiters;
    }

    public void setDelimiters(String delimiters) {
        this.delimiters = delimiters;
    }

    public String getIgnoredCharacters() {
        return this.ignoredCharacters;
    }

    public void setIgnoredCharacters(String ignoredCharacters) {
        this.ignoredCharacters = ignoredCharacters;
    }

    public Converter getTextConverter() {
        return this.textConverter;
    }

    public void setTextConverter(Converter textConverter) {
        this.textConverter = textConverter;
    }

    public Copier getContainerCopier() {
        return this.containerCopier;
    }

    public void setContainerCopier(Copier containerCopier) {
        this.containerCopier = containerCopier;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

