/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.copiers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.reflect.ReflectionException;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.transform.copiers.BasePropertyNameCopier;
import net.sf.morph.util.ContainerUtils;
import net.sf.morph.util.StringUtils;

public class PropertyNameMatchingCopier
extends BasePropertyNameCopier {
    private Set propertiesToCopy = ContainerUtils.createOrderedSet();
    private Set propertiesToIgnore = ContainerUtils.createOrderedSet();

    public PropertyNameMatchingCopier() {
        this.setErrorOnMissingProperty(false);
    }

    public PropertyNameMatchingCopier(boolean errorOnMissingProperty) {
        super(errorOnMissingProperty);
    }

    public void copyImpl(Object destination, Object source, Locale locale, Integer preferredTransformationType) throws Exception {
        String[] properties = this.evaluateIncludedProperties(source);
        if (this.log.isInfoEnabled()) {
            if (ObjectUtils.isEmpty((Object)properties)) {
                this.getLog().info((Object)"No properties available for copying");
            } else {
                this.getLog().info((Object)("Copying properties " + StringUtils.englishJoin(properties)));
            }
        }
        ArrayList<String> unreadableProperties = null;
        ArrayList<String> unwriteableProperties = null;
        if (this.isErrorOnMissingProperty() || this.getLog().isTraceEnabled()) {
            unreadableProperties = new ArrayList<String>();
            unwriteableProperties = new ArrayList<String>();
        }
        for (int i = 0; i < properties.length; ++i) {
            String property = properties[i];
            boolean sourceReadable = this.getBeanReflector().isReadable(source, property);
            boolean destinationWriteable = this.getBeanReflector().isWriteable(destination, property);
            if (sourceReadable && destinationWriteable) {
                this.copyProperty(property, source, property, destination, locale, preferredTransformationType);
                continue;
            }
            if (!this.isErrorOnMissingProperty() && !this.getLog().isTraceEnabled()) continue;
            if (!sourceReadable) {
                unreadableProperties.add(property);
            }
            if (destinationWriteable) continue;
            unwriteableProperties.add(property);
        }
        if (this.isErrorOnMissingProperty() || this.getLog().isTraceEnabled()) {
            int skippedPropertiesSize = unreadableProperties.size() + unwriteableProperties.size();
            ArrayList<String> skippedProperties = new ArrayList<String>(skippedPropertiesSize);
            skippedProperties.addAll(unreadableProperties);
            skippedProperties.addAll(unwriteableProperties);
            String message = "The following properties were not copied because they were not readable on the source object, not writeable on the destination object or both: " + StringUtils.englishJoin(skippedProperties) + ".  The properties that were not readable are: " + StringUtils.englishJoin(unreadableProperties) + ".  The properties that were not writeable are: " + StringUtils.englishJoin(unwriteableProperties);
            if (this.isErrorOnMissingProperty()) {
                throw new TransformationException(message);
            }
            if (!skippedProperties.isEmpty()) {
                this.getLog().trace((Object)message);
            }
        }
    }

    public synchronized String[] getPropertiesToCopy() {
        return this.propertiesToCopy.toArray(new String[this.propertiesToCopy.size()]);
    }

    public synchronized void setPropertiesToCopy(String[] propertiesToCopy) {
        this.propertiesToCopy.clear();
        this.propertiesToCopy.addAll(Arrays.asList(propertiesToCopy));
    }

    public synchronized void addPropertyToCopy(String propertyName) {
        this.propertiesToCopy.add(propertyName);
    }

    public synchronized String[] getPropertiesToIgnore() {
        return this.propertiesToIgnore.toArray(new String[this.propertiesToIgnore.size()]);
    }

    public synchronized void setPropertiesToIgnore(String[] propertiesToIgnore) {
        this.propertiesToIgnore.clear();
        this.propertiesToIgnore.addAll(Arrays.asList(propertiesToIgnore));
    }

    public synchronized void addPropertyToIgnore(String propertyName) {
        this.propertiesToIgnore.add(propertyName);
    }

    protected boolean isImpreciseTransformationImpl(Class destinationClass, Class sourceClass) {
        if (!this.isErrorOnMissingProperty() && ObjectUtils.isEmpty((Object)this.propertiesToCopy) && ObjectUtils.isEmpty((Object)this.propertiesToIgnore)) {
            Object destinationBean;
            Object sourceBean;
            try {
                sourceBean = this.getInstantiatingReflector().newInstance(sourceClass, null);
                destinationBean = this.getInstantiatingReflector().newInstance(destinationClass, null);
            }
            catch (ReflectionException e) {
                return true;
            }
            HashSet<String> sourcePropertyNames = new HashSet<String>(Arrays.asList(this.getBeanReflector().getPropertyNames(sourceBean)));
            HashSet<String> destinationPropertyNames = new HashSet<String>(Arrays.asList(this.getBeanReflector().getPropertyNames(destinationBean)));
            return !sourcePropertyNames.equals(destinationPropertyNames);
        }
        return super.isImpreciseTransformationImpl(destinationClass, sourceClass);
    }

    private String[] evaluateIncludedProperties(Object source) {
        Set result = ContainerUtils.createOrderedSet();
        result.addAll(this.propertiesToCopy);
        result.retainAll(this.propertiesToIgnore);
        if (!result.isEmpty()) {
            throw new IllegalStateException("Overlapping included/ignored properties: " + result);
        }
        if (ObjectUtils.isEmpty((Object)this.propertiesToCopy)) {
            result.addAll(Arrays.asList(this.getBeanReflector().getPropertyNames(source)));
            result.removeAll(this.propertiesToIgnore);
        } else {
            result = this.propertiesToCopy;
        }
        return result.toArray(new String[result.size()]);
    }
}

