/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.copiers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.transform.copiers.BasePropertyNameCopier;
import net.sf.morph.util.ContainerUtils;

public class PropertyNameMappingCopier
extends BasePropertyNameCopier {
    private Map mapping;
    private boolean bidirectional = true;

    public PropertyNameMappingCopier() {
        this.setErrorOnMissingProperty(true);
    }

    public PropertyNameMappingCopier(boolean errorOnMissingProperty) {
        super(errorOnMissingProperty);
    }

    protected void initializeImpl() throws Exception {
        super.initializeImpl();
        if (ObjectUtils.isEmpty((Object)this.mapping)) {
            throw new TransformationException("You must specify which properties you would like the " + this.getClass().getName() + " to copy by setting the mapping property");
        }
        this.ensureOnlyStrings(this.mapping.keySet());
        this.ensureOnlyStrings(this.mapping.values());
        if (this.bidirectional) {
            Set propertiesWithMappings = ContainerUtils.createOrderedSet();
            Iterator iterator = this.mapping.values().iterator();
            while (iterator.hasNext()) {
                String propertyName = (String)iterator.next();
                if (propertiesWithMappings.contains(propertyName)) {
                    throw new TransformationException("A duplicate mapping was detected for property '" + propertyName + "'.  Please remote the duplicate mapping or set bidirectional to false.");
                }
                propertiesWithMappings.add(propertyName);
            }
        }
    }

    private void ensureOnlyStrings(Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            if (value instanceof String) continue;
            throw new TransformationException("An invalid mapping element was specified: " + ObjectUtils.getObjectDescription(value) + ".  Mapping elements must be Strings");
        }
    }

    protected void copyImpl(Object destination, Object source, Locale locale, Integer preferredTransformationType) throws TransformationException {
        Iterator i = this.mapping.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry propertyMapping = i.next();
            String sourceProperty = (String)propertyMapping.getKey();
            String destinationProperty = (String)propertyMapping.getValue();
            boolean missingProperty = false;
            if (this.getBeanReflector().isReadable(source, sourceProperty) && this.getBeanReflector().isWriteable(destination, destinationProperty)) {
                this.copyProperty(sourceProperty, source, destinationProperty, destination, locale, preferredTransformationType);
            } else if (this.isBidirectional() && this.getBeanReflector().isReadable(source, destinationProperty) && this.getBeanReflector().isWriteable(destination, sourceProperty)) {
                this.copyProperty(destinationProperty, source, sourceProperty, destination, locale, preferredTransformationType);
            } else {
                missingProperty = true;
            }
            if (!missingProperty || !this.getLog().isWarnEnabled() && !this.isErrorOnMissingProperty()) continue;
            String message = "Failed to copy property '" + sourceProperty + "' of " + ObjectUtils.getObjectDescription((Object)source) + " to property '" + destinationProperty + "' of  " + ObjectUtils.getObjectDescription((Object)destination);
            if (this.isErrorOnMissingProperty()) {
                throw new TransformationException(message);
            }
            this.getLog().warn((Object)message);
        }
    }

    protected Map getMapping() {
        return this.mapping;
    }

    public void setMapping(Map mapping) {
        this.mapping = mapping;
    }

    public void addMapping(String sourcePropertyName, String destinationPropertyName) {
        if (this.mapping == null) {
            this.mapping = new HashMap();
        }
        this.mapping.put(sourcePropertyName, destinationPropertyName);
    }

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    public void setBidirectional(boolean bidirectional) {
        this.bidirectional = bidirectional;
    }
}

