/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.copiers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import net.sf.composite.util.ObjectUtils;
import net.sf.morph.Defaults;
import net.sf.morph.lang.DecoratedLanguage;
import net.sf.morph.lang.Language;
import net.sf.morph.lang.languages.LanguageDecorator;
import net.sf.morph.lang.languages.SimpleLanguage;
import net.sf.morph.reflect.BeanReflector;
import net.sf.morph.reflect.ContainerReflector;
import net.sf.morph.reflect.Reflector;
import net.sf.morph.reflect.reflectors.ArrayReflector;
import net.sf.morph.reflect.reflectors.CollectionReflector;
import net.sf.morph.reflect.reflectors.EnumerationReflector;
import net.sf.morph.reflect.reflectors.IteratorReflector;
import net.sf.morph.reflect.reflectors.ListReflector;
import net.sf.morph.reflect.reflectors.ObjectReflector;
import net.sf.morph.reflect.reflectors.SetReflector;
import net.sf.morph.reflect.reflectors.SimpleDelegatingReflector;
import net.sf.morph.reflect.reflectors.SortedSetReflector;
import net.sf.morph.transform.Converter;
import net.sf.morph.transform.DecoratedConverter;
import net.sf.morph.transform.DecoratedCopier;
import net.sf.morph.transform.NodeCopier;
import net.sf.morph.transform.TransformationException;
import net.sf.morph.transform.Transformer;
import net.sf.morph.transform.transformers.BaseTransformer;
import net.sf.morph.util.TransformerUtils;

public class PropertyExpressionMappingCopier
extends BaseTransformer
implements DecoratedConverter,
DecoratedCopier,
NodeCopier {
    private static final ContainerReflector DEST_REFLECTOR = new SimpleDelegatingReflector(new Reflector[]{new ListReflector(), new SortedSetReflector(), new SetReflector(), new EnumerationReflector(), new IteratorReflector(), new ArrayReflector(), new CollectionReflector(), new ObjectReflector()});
    private static final Class[] SOURCE_AND_DEST_CLASSES = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = PropertyExpressionMappingCopier.class$("java.lang.Object")) : class$java$lang$Object};
    private Map mapping;
    private Language language;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$morph$reflect$BeanReflector;

    public PropertyExpressionMappingCopier() {
    }

    public PropertyExpressionMappingCopier(Map mapping) {
        this();
        this.setMapping(mapping);
    }

    public synchronized Language getLanguage() {
        if (this.language == null) {
            SimpleLanguage lang = Defaults.createLanguage();
            lang.setConverter((Converter)this.getNestedTransformer());
            lang.setReflector((BeanReflector)this.getReflector(class$net$sf$morph$reflect$BeanReflector == null ? (class$net$sf$morph$reflect$BeanReflector = PropertyExpressionMappingCopier.class$("net.sf.morph.reflect.BeanReflector")) : class$net$sf$morph$reflect$BeanReflector));
            this.setLanguage(lang);
        }
        return this.language;
    }

    public synchronized void setLanguage(Language language) {
        this.language = language instanceof DecoratedLanguage ? language : new LanguageDecorator(language);
    }

    protected void initializeImpl() throws Exception {
        super.initializeImpl();
        if (ObjectUtils.isEmpty((Object)this.mapping)) {
            throw new TransformationException("You must specify which properties you would like the " + this.getClass().getName() + " to copy by setting the mapping property");
        }
        this.ensureOnlyStrings(this.mapping.keySet());
        this.ensureOnlyStrings(this.expand(this.mapping.values()));
    }

    private void ensureOnlyStrings(Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            if (value instanceof String) continue;
            throw new TransformationException("An invalid mapping element was specified: " + ObjectUtils.getObjectDescription(value) + ".  Mapping elements must be Strings");
        }
    }

    private Collection expand(Collection collection) {
        ArrayList result = new ArrayList(collection.size());
        Iterator outerIter = collection.iterator();
        while (outerIter.hasNext()) {
            Iterator innerIter = DEST_REFLECTOR.getIterator(outerIter.next());
            while (innerIter.hasNext()) {
                result.add(innerIter.next());
            }
        }
        return result;
    }

    protected void copyImpl(Object destination, Object source, Locale locale, Integer preferredTransformationType) throws Exception {
        Iterator it = this.getMapping().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String sourceProperty = (String)e.getKey();
            Iterator v = DEST_REFLECTOR.getIterator(e.getValue());
            while (v.hasNext()) {
                this.copyProperty(sourceProperty, source, (String)v.next(), destination, locale, preferredTransformationType);
            }
        }
    }

    protected void copyProperty(String sourceProperty, Object source, String destinationProperty, Object destination, Locale locale, Integer preferredTransformationType) throws Exception {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("Copying property '" + sourceProperty + "' of " + ObjectUtils.getObjectDescription((Object)source) + " to property '" + destinationProperty + "' of " + ObjectUtils.getObjectDescription((Object)destination)));
        }
        Class destinationType = this.getLanguage().getType(destination, destinationProperty);
        Object sourceValue = this.getLanguage().get(source, sourceProperty);
        Object destinationValue = this.getLanguage().get(destination, destinationProperty);
        Transformer transformer = this.getNestedTransformer();
        if (!((BeanReflector)this.getReflector(class$net$sf$morph$reflect$BeanReflector == null ? (class$net$sf$morph$reflect$BeanReflector = PropertyExpressionMappingCopier.class$("net.sf.morph.reflect.BeanReflector")) : class$net$sf$morph$reflect$BeanReflector)).isWriteable(destination, destinationProperty)) {
            preferredTransformationType = TRANSFORMATION_TYPE_COPY;
        }
        Object newDestinationValue = TransformerUtils.transform(transformer, destinationType, destinationValue, sourceValue, locale, preferredTransformationType);
        this.getLanguage().set(destination, destinationProperty, newDestinationValue);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("Done copying property '" + sourceProperty + "' to property '" + destinationProperty + "'.  sourceValue was " + ObjectUtils.getObjectDescription((Object)sourceValue) + " and destinationValue was " + ObjectUtils.getObjectDescription((Object)destinationValue)));
        }
    }

    protected Class[] getDestinationClassesImpl() throws Exception {
        return SOURCE_AND_DEST_CLASSES;
    }

    protected Class[] getSourceClassesImpl() throws Exception {
        return SOURCE_AND_DEST_CLASSES;
    }

    public synchronized Map getMapping() {
        return this.mapping;
    }

    public synchronized void setMapping(Map mapping) {
        this.mapping = mapping;
        this.setInitialized(false);
    }

    public synchronized void setSourceClasses(Class[] sourceClasses) {
        super.setSourceClasses(sourceClasses);
    }

    public synchronized void setDestinationClasses(Class[] destinationClasses) {
        super.setDestinationClasses(destinationClasses);
    }

    public Object createReusableSource(Class destinationClass, Object source) {
        return super.createReusableSource(destinationClass, source);
    }

    public void setNestedTransformer(Transformer nestedTransformer) {
        super.setNestedTransformer(nestedTransformer);
    }

    public Transformer getNestedTransformer() {
        return super.getNestedTransformer();
    }

    protected boolean isWrappingRuntimeExceptions() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

