/*
 * Decompiled with CFR 0.152.
 */
package net.sf.morph.transform.copiers;

import java.lang.reflect.Array;
import java.util.Locale;
import java.util.Set;
import net.sf.morph.transform.DecoratedConverter;
import net.sf.morph.transform.DecoratedCopier;
import net.sf.morph.transform.ExplicitTransformer;
import net.sf.morph.transform.transformers.BaseTransformer;
import net.sf.morph.util.ClassUtils;
import net.sf.morph.util.ContainerUtils;
import net.sf.morph.util.TransformerUtils;

public class ImmutableComponentArrayCopier
extends BaseTransformer
implements DecoratedConverter,
DecoratedCopier,
ExplicitTransformer {
    private static final Class[] SOURCE_AND_DEST_TYPES;

    protected Class[] getDestinationClassesImpl() throws Exception {
        return SOURCE_AND_DEST_TYPES;
    }

    protected Class[] getSourceClassesImpl() throws Exception {
        return SOURCE_AND_DEST_TYPES;
    }

    protected boolean isTransformableImpl(Class destinationType, Class sourceType) throws Exception {
        return TransformerUtils.isImplicitlyTransformable(this, destinationType, sourceType) && sourceType.getComponentType() == destinationType.getComponentType();
    }

    protected Object convertImpl(Class destinationClass, Object source, Locale locale) throws Exception {
        Object array = ClassUtils.createArray(destinationClass.getComponentType(), (int)Array.getLength(source));
        this.copyImpl(array, source, locale, TRANSFORMATION_TYPE_CONVERT);
        return array;
    }

    protected void copyImpl(Object destination, Object source, Locale locale, Integer preferredTransformationType) throws Exception {
        System.arraycopy(source, 0, destination, 0, Array.getLength(source));
    }

    protected boolean isPerformingLogging() {
        return false;
    }

    static {
        Class[] componentTypes = ClassUtils.getImmutableTypes();
        Set arrayTypes = ContainerUtils.createOrderedSet();
        for (int i = 0; i < componentTypes.length; ++i) {
            if (componentTypes[i] == null) continue;
            arrayTypes.add(ClassUtils.getArrayClass(componentTypes[i]));
        }
        SOURCE_AND_DEST_TYPES = arrayTypes.toArray(new Class[arrayTypes.size()]);
    }
}

